# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: bookshelf/v1/bookshelf.proto
# plugin: python-betterproto
import logging
from typing import Dict, List

import allure
from dataclasses import dataclass

import betterproto


@dataclass
class EmptyRequest(betterproto.Message):
    pass


@dataclass
class AddBookmarkReq(betterproto.Message):
    # 漫画 ID
    comic_id: int = betterproto.int32_field(1)
    # 单话 ID
    ep_id: int = betterproto.int32_field(2)
    # 页码
    page: int = betterproto.int32_field(3)
    # 标题
    title: str = betterproto.string_field(4)


@dataclass
class DeleteBookmarksReq(betterproto.Message):
    # 多个书签 ID,  json array 格式 例：[1,2,3...]
    ids: str = betterproto.string_field(1)


@dataclass
class ListBookmarksReq(betterproto.Message):
    # 漫画 ID 必选参数
    comic_id: int = betterproto.int32_field(1)
    # 单话 ID 可选参数(传该参数后返回该单话所有书签)
    ep_id: int = betterproto.int32_field(2)
    # 页码 可选参数(传该参数后返回该页码所有书签，ps: 使用此参数b必需配合 ep_id 一起传)
    page: int = betterproto.int32_field(3)


@dataclass
class CountBookmarksReq(betterproto.Message):
    # 漫画 ID 必选参数
    comic_id: int = betterproto.int32_field(1)


@dataclass
class CountBookmarksResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "CountBookmarksInfo" = betterproto.message_field(3)


@dataclass
class CountBookmarksInfo(betterproto.Message):
    # 单本漫画书签数量上限
    max_limit: int = betterproto.int32_field(1)
    # 单本漫画书签数量总量
    total_count: int = betterproto.int32_field(2)


@dataclass
class ListBookmarksResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ListBookmarksInfo" = betterproto.message_field(3)


@dataclass
class ListBookmarksInfo(betterproto.Message):
    # 当前书签数量(用该字段判断是否超过书签上限) 该数字的意义取决于请求时的参数 当仅传输 comic_id 时为该漫画总书签数量 当还传输 ep_id
    # 时为该单话总书签数量
    total_count: int = betterproto.int32_field(1)
    bookmarks: List["Bookmark"] = betterproto.message_field(2)


@dataclass
class Bookmark(betterproto.Message):
    # id
    id: int = betterproto.int32_field(1)
    # 漫画 id
    comic_id: int = betterproto.int32_field(2)
    # 单话 id
    ep_id: int = betterproto.int32_field(3)
    # 页码
    page: int = betterproto.int32_field(4)
    # 标题
    title: str = betterproto.string_field(6)
    # 短标题
    ep_short_title: str = betterproto.string_field(7)
    # 单话是否正常上架
    is_ep_online: bool = betterproto.bool_field(8)


@dataclass
class DefaultListRequest(betterproto.Message):
    # 单页数量
    page_size: int = betterproto.int32_field(1)
    # 分页页数
    page_num: int = betterproto.int32_field(2)


@dataclass
class ListFavoriteRequest(betterproto.Message):
    # 单页数量
    page_size: int = betterproto.int32_field(1)
    # 分页页数
    page_num: int = betterproto.int32_field(2)
    # 排序方式：1、追漫顺序 2、漫画更新时间 3、最近阅读
    order: int = betterproto.int32_field(3)
    # 分组 ID 表示请求分组中的漫画， 不传代表查询所有
    group_id: int = betterproto.int32_field(4)
    # wait_free = 1 表示只返回有等免机会的漫画 此时不分页
    wait_free: int = betterproto.int32_field(5)


@dataclass
class ListHistoryResponse(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["HistoryComic"] = betterproto.message_field(3)


@dataclass
class HistoryComic(betterproto.Message):
    id: int = betterproto.int64_field(1)
    # 漫画ID
    comic_id: int = betterproto.int32_field(2)
    # 标题
    title: str = betterproto.string_field(3)
    # 连载状态 1 未开刊, 2 连载中, 3 已完结, 4 已下线
    status: int = betterproto.int32_field(4)
    # 看到话数
    last_ord: float = betterproto.float_field(5)
    # 最新话数(总话数)
    ord_count: int = betterproto.int32_field(6)
    # 阅读时间
    read_time: str = betterproto.string_field(7)
    # 横版封面
    hcover: str = betterproto.string_field(8)
    # 方版封面
    scover: str = betterproto.string_field(9)
    # 竖版封面
    vcover: str = betterproto.string_field(10)
    # 最新发布时间
    publish_time: str = betterproto.string_field(11)
    # 上次阅读章节ID
    last_ep_id: int = betterproto.int32_field(12)
    # 上次阅读话标题
    last_ep_short_title: str = betterproto.string_field(13)
    # 当前漫画最新话
    latest_ep_short_title: str = betterproto.string_field(14)


@dataclass
class AddHistoryRequest(betterproto.Message):
    # 漫画ID
    comic_id: int = betterproto.int32_field(1)
    # 当前话ID
    ep_id: int = betterproto.int32_field(2)


@dataclass
class SyncHistoryRequest(betterproto.Message):
    # 本地阅读历史列表 JSON 格式字符串  - comic_id 漫画ID  - ep_id 最新阅读话  - read_time 阅读时间
    # [{"comic_id":1, "ep_id":1, "read_time":"2018-08-01 13:00:00"}]
    list: str = betterproto.string_field(1)


@dataclass
class DefaultResponse(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "EmptyData" = betterproto.message_field(3)


@dataclass
class HasFavoriteResponse(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    # 已经追漫返回 true，否则返回 false
    data: bool = betterproto.bool_field(3)


@dataclass
class CountFavoriteResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "CountFavoriteData" = betterproto.message_field(3)


@dataclass
class CountFavoriteData(betterproto.Message):
    # 追漫总数
    count: int = betterproto.int32_field(1)


@dataclass
class EmptyData(betterproto.Message):
    pass


@dataclass
class DeleteHistoryReq(betterproto.Message):
    # 漫画 ID 列表, 英文逗号分割 如："1,2,3,4"，最多 20 个
    comic_ids: str = betterproto.string_field(1)


@dataclass
class MultiIDRequest(betterproto.Message):
    # 漫画 ID 列表, 英文逗号分割 如："1,2,3,4"，最多 20 个
    comic_ids: str = betterproto.string_field(1)
    # 分组 ID 注意如果不操作分组不要使用该字段 如果传入 代表将上述漫画 ID 加入到分组
    group_id: int = betterproto.int32_field(2)


@dataclass
class DeleteWikiFavoriteReq(betterproto.Message):
    wiki_id: int = betterproto.int32_field(2)


@dataclass
class ListFavoriteResponse(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["FavoriteComic"] = betterproto.message_field(3)


@dataclass
class FavoriteComic(betterproto.Message):
    id: int = betterproto.int64_field(1)
    # 漫画ID
    comic_id: int = betterproto.int32_field(2)
    # 标题
    title: str = betterproto.string_field(3)
    # 连载状态 1 未开刊, 2 连载中, 3 已完结, 4 已下线
    status: int = betterproto.int32_field(4)
    # 看到话数
    last_ord: float = betterproto.float_field(5)
    # 新话数(总话数)
    ord_count: int = betterproto.int32_field(6)
    # 横版封面
    hcover: str = betterproto.string_field(7)
    # 方版封面
    scover: str = betterproto.string_field(8)
    # 竖版封面
    vcover: str = betterproto.string_field(9)
    # 漫画发布时间
    publish_time: str = betterproto.string_field(10)
    # 漫画最新话发布时间 格式: "2006-01-02 15:04:05", PS: 缺少时区信息，约定为+0800，仅为和之前的格式保持统一
    last_ep_publish_time: str = betterproto.string_field(11)
    # 看到话的编号
    last_ep_id: int = betterproto.int32_field(12)
    # 看到话的标题
    last_ep_short_title: str = betterproto.string_field(13)
    # 当前漫画最新话
    latest_ep_short_title: str = betterproto.string_field(14)
    # 是否支持等免
    allow_wait_free: bool = betterproto.bool_field(15)


@dataclass
class AddFavoriteRequest(betterproto.Message):
    # 漫画 ID/百科 ID
    comic_id: int = betterproto.int32_field(1)
    # 漫画 ID 列表, 英文逗号分割 如："1,2,3,4"，最多 20 个
    comic_ids: str = betterproto.string_field(2)
    # 分组 ID 如果收藏到分组需要传入该字段，否则不要使用
    group_id: int = betterproto.int32_field(3)


@dataclass
class AddFavResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "AddFavInfo" = betterproto.message_field(3)


@dataclass
class AddFavInfo(betterproto.Message):
    # "comic_id": bool 查询漫画的首次追漫状态
    first_fav_status: Dict[int, bool] = betterproto.map_field(
        1, betterproto.TYPE_INT32, betterproto.TYPE_BOOL
    )


@dataclass
class AddWikiFavoriteReq(betterproto.Message):
    # 百科 id
    id: int = betterproto.int32_field(1)


@dataclass
class HasFavoriteRequest(betterproto.Message):
    # 漫画ID
    comic_id: int = betterproto.int32_field(1)


@dataclass
class AddGroupReq(betterproto.Message):
    # 分组名字
    name: str = betterproto.string_field(1)


@dataclass
class AddGroupResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GroupBaseInfo" = betterproto.message_field(3)


@dataclass
class GroupBaseInfo(betterproto.Message):
    group_id: int = betterproto.int32_field(1)


@dataclass
class DelGroupReq(betterproto.Message):
    # 分组 ID 列表, 多个用英文逗号分开 如: "1,2,3,4"
    group_ids: List[int] = betterproto.int32_field(1)


@dataclass
class RenameGroupReq(betterproto.Message):
    # 分组 ID
    group_id: int = betterproto.int32_field(1)
    # 分组新名字
    name: str = betterproto.string_field(2)


@dataclass
class GroupInfo(betterproto.Message):
    # 分组 ID
    id: int = betterproto.int32_field(1)
    # 分组名称
    name: str = betterproto.string_field(2)
    # 分组内漫画数量
    comic_count: int = betterproto.int32_field(3)
    # 分组在前端的位置
    position: int = betterproto.int32_field(4)


@dataclass
class ListGroupResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    # 书架分组列表
    data: "GroupDetail" = betterproto.message_field(3)


@dataclass
class GroupDetail(betterproto.Message):
    # 书架分组总数量
    total_count: int = betterproto.int32_field(1)
    # 书架分组列表
    groups: List["GroupInfo"] = betterproto.message_field(2)
    # 追漫总数量
    total_comics_count: int = betterproto.int32_field(3)


@dataclass
class OrderGroupRequest(betterproto.Message):
    # 分组 ID 列表, 多个用英文逗号分开 如: "1,2,3,4"
    group_ids: List[int] = betterproto.int32_field(1)


class BookshelfStub(betterproto.ServiceStub):
    """书架服务"""

    @allure.step("""查询阅读记录""")
    def list_history(self, request: DefaultListRequest) -> ListHistoryResponse:
        """查询阅读记录"""
        logging.getLogger(__name__).info(
            "start call " + "[list_history]" + " api" + "=>" + """查询阅读记录"""
        )
        response = ListHistoryResponse()
        self._do_twirp_rpc("/bookshelf.v1.Bookshelf/ListHistory", request, response)
        logging.getLogger(__name__).info("call " + "[list_history]" + " api success!")
        return response

    @allure.step("""添加阅读记录""")
    def add_history(self, request: AddHistoryRequest) -> DefaultResponse:
        """添加阅读记录"""
        logging.getLogger(__name__).info(
            "start call " + "[add_history]" + " api" + "=>" + """添加阅读记录"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/bookshelf.v1.Bookshelf/AddHistory", request, response)
        logging.getLogger(__name__).info("call " + "[add_history]" + " api success!")
        return response

    @allure.step("""同步阅读记录""")
    def sync_history(self, request: SyncHistoryRequest) -> DefaultResponse:
        """同步阅读记录"""
        logging.getLogger(__name__).info(
            "start call " + "[sync_history]" + " api" + "=>" + """同步阅读记录"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/bookshelf.v1.Bookshelf/SyncHistory", request, response)
        logging.getLogger(__name__).info("call " + "[sync_history]" + " api success!")
        return response

    @allure.step("""删除阅读记录""")
    def delete_history(self, request: DeleteHistoryReq) -> DefaultResponse:
        """删除阅读记录"""
        logging.getLogger(__name__).info(
            "start call " + "[delete_history]" + " api" + "=>" + """删除阅读记录"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/bookshelf.v1.Bookshelf/DeleteHistory", request, response)
        logging.getLogger(__name__).info("call " + "[delete_history]" + " api success!")
        return response

    @allure.step("""获取追漫记录""")
    def list_favorite(self, request: ListFavoriteRequest) -> ListFavoriteResponse:
        """获取追漫记录"""
        logging.getLogger(__name__).info(
            "start call " + "[list_favorite]" + " api" + "=>" + """获取追漫记录"""
        )
        response = ListFavoriteResponse()
        self._do_twirp_rpc("/bookshelf.v1.Bookshelf/ListFavorite", request, response)
        logging.getLogger(__name__).info("call " + "[list_favorite]" + " api success!")
        return response

    @allure.step("""添加追漫记录""")
    def add_favorite(self, request: AddFavoriteRequest) -> AddFavResp:
        """添加追漫记录"""
        logging.getLogger(__name__).info(
            "start call " + "[add_favorite]" + " api" + "=>" + """添加追漫记录"""
        )
        response = AddFavResp()
        self._do_twirp_rpc("/bookshelf.v1.Bookshelf/AddFavorite", request, response)
        logging.getLogger(__name__).info("call " + "[add_favorite]" + " api success!")
        return response

    @allure.step("""添加百科追漫记录 1-未开通预约追漫""")
    def add_wiki_favorite(self, request: AddWikiFavoriteReq) -> DefaultResponse:
        """添加百科追漫记录 1-未开通预约追漫"""
        logging.getLogger(__name__).info(
            "start call "
            + "[add_wiki_favorite]"
            + " api"
            + "=>"
            + """添加百科追漫记录 1-未开通预约追漫"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/bookshelf.v1.Bookshelf/AddWikiFavorite", request, response)
        logging.getLogger(__name__).info(
            "call " + "[add_wiki_favorite]" + " api success!"
        )
        return response

    @allure.step("""是否已经追漫""")
    def has_favorite(self, request: HasFavoriteRequest) -> HasFavoriteResponse:
        """是否已经追漫"""
        logging.getLogger(__name__).info(
            "start call " + "[has_favorite]" + " api" + "=>" + """是否已经追漫"""
        )
        response = HasFavoriteResponse()
        self._do_twirp_rpc("/bookshelf.v1.Bookshelf/HasFavorite", request, response)
        logging.getLogger(__name__).info("call " + "[has_favorite]" + " api success!")
        return response

    @allure.step("""查询用户追漫总数""")
    def count_favorite(self, request: EmptyRequest) -> CountFavoriteResp:
        """查询用户追漫总数"""
        logging.getLogger(__name__).info(
            "start call " + "[count_favorite]" + " api" + "=>" + """查询用户追漫总数"""
        )
        response = CountFavoriteResp()
        self._do_twirp_rpc("/bookshelf.v1.Bookshelf/CountFavorite", request, response)
        logging.getLogger(__name__).info("call " + "[count_favorite]" + " api success!")
        return response

    @allure.step("""删除追漫记录""")
    def delete_favorite(self, request: MultiIDRequest) -> DefaultResponse:
        """删除追漫记录"""
        logging.getLogger(__name__).info(
            "start call " + "[delete_favorite]" + " api" + "=>" + """删除追漫记录"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/bookshelf.v1.Bookshelf/DeleteFavorite", request, response)
        logging.getLogger(__name__).info(
            "call " + "[delete_favorite]" + " api success!"
        )
        return response

    @allure.step("""删除百科追漫记录""")
    def delete_wiki_favorite(self, request: AddWikiFavoriteReq) -> DefaultResponse:
        """删除百科追漫记录"""
        logging.getLogger(__name__).info(
            "start call " + "[delete_wiki_favorite]" + " api" + "=>" + """删除百科追漫记录"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc(
            "/bookshelf.v1.Bookshelf/DeleteWikiFavorite", request, response
        )
        logging.getLogger(__name__).info(
            "call " + "[delete_wiki_favorite]" + " api success!"
        )
        return response

    @allure.step("""添加书签""")
    def add_bookmark(self, request: AddBookmarkReq) -> DefaultResponse:
        """添加书签"""
        logging.getLogger(__name__).info(
            "start call " + "[add_bookmark]" + " api" + "=>" + """添加书签"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/bookshelf.v1.Bookshelf/AddBookmark", request, response)
        logging.getLogger(__name__).info("call " + "[add_bookmark]" + " api success!")
        return response

    @allure.step("""删除书签""")
    def delete_bookmarks(self, request: DeleteBookmarksReq) -> DefaultResponse:
        """删除书签"""
        logging.getLogger(__name__).info(
            "start call " + "[delete_bookmarks]" + " api" + "=>" + """删除书签"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/bookshelf.v1.Bookshelf/DeleteBookmarks", request, response)
        logging.getLogger(__name__).info(
            "call " + "[delete_bookmarks]" + " api success!"
        )
        return response

    @allure.step("""返回书签列表""")
    def list_bookmarks(self, request: ListBookmarksReq) -> ListBookmarksResp:
        """返回书签列表"""
        logging.getLogger(__name__).info(
            "start call " + "[list_bookmarks]" + " api" + "=>" + """返回书签列表"""
        )
        response = ListBookmarksResp()
        self._do_twirp_rpc("/bookshelf.v1.Bookshelf/ListBookmarks", request, response)
        logging.getLogger(__name__).info("call " + "[list_bookmarks]" + " api success!")
        return response

    @allure.step("""返回书签数量""")
    def count_bookmarks(self, request: CountBookmarksReq) -> CountBookmarksResp:
        """返回书签数量"""
        logging.getLogger(__name__).info(
            "start call " + "[count_bookmarks]" + " api" + "=>" + """返回书签数量"""
        )
        response = CountBookmarksResp()
        self._do_twirp_rpc("/bookshelf.v1.Bookshelf/CountBookmarks", request, response)
        logging.getLogger(__name__).info(
            "call " + "[count_bookmarks]" + " api success!"
        )
        return response

    @allure.step("""创建书架分组""")
    def add_group(self, request: AddGroupReq) -> AddGroupResp:
        """创建书架分组"""
        logging.getLogger(__name__).info(
            "start call " + "[add_group]" + " api" + "=>" + """创建书架分组"""
        )
        response = AddGroupResp()
        self._do_twirp_rpc("/bookshelf.v1.Bookshelf/AddGroup", request, response)
        logging.getLogger(__name__).info("call " + "[add_group]" + " api success!")
        return response

    @allure.step("""删除书架分组""")
    def del_group(self, request: DelGroupReq) -> DefaultResponse:
        """删除书架分组"""
        logging.getLogger(__name__).info(
            "start call " + "[del_group]" + " api" + "=>" + """删除书架分组"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/bookshelf.v1.Bookshelf/DelGroup", request, response)
        logging.getLogger(__name__).info("call " + "[del_group]" + " api success!")
        return response

    @allure.step("""重命名书架分组""")
    def rename_group(self, request: RenameGroupReq) -> DefaultResponse:
        """重命名书架分组"""
        logging.getLogger(__name__).info(
            "start call " + "[rename_group]" + " api" + "=>" + """重命名书架分组"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/bookshelf.v1.Bookshelf/RenameGroup", request, response)
        logging.getLogger(__name__).info("call " + "[rename_group]" + " api success!")
        return response

    @allure.step("""获取书架列表""")
    def list_group(self, request: EmptyRequest) -> ListGroupResp:
        """获取书架列表"""
        logging.getLogger(__name__).info(
            "start call " + "[list_group]" + " api" + "=>" + """获取书架列表"""
        )
        response = ListGroupResp()
        self._do_twirp_rpc("/bookshelf.v1.Bookshelf/ListGroup", request, response)
        logging.getLogger(__name__).info("call " + "[list_group]" + " api success!")
        return response

    @allure.step("""排序书架列表""")
    def sort_group(self, request: OrderGroupRequest) -> DefaultResponse:
        """排序书架列表"""
        logging.getLogger(__name__).info(
            "start call " + "[sort_group]" + " api" + "=>" + """排序书架列表"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/bookshelf.v1.Bookshelf/SortGroup", request, response)
        logging.getLogger(__name__).info("call " + "[sort_group]" + " api success!")
        return response
