# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['HistoryExecutionStep']


class HistoryExecutionStep(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 completion_time: Optional[pulumi.Input[pulumi.InputType['TimestampArgs']]] = None,
                 creation_time: Optional[pulumi.Input[pulumi.InputType['TimestampArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_usage_duration: Optional[pulumi.Input[pulumi.InputType['DurationArgs']]] = None,
                 dimension_value: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StepDimensionValueEntryArgs']]]]] = None,
                 execution_id: Optional[pulumi.Input[str]] = None,
                 has_images: Optional[pulumi.Input[bool]] = None,
                 history_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StepLabelsEntryArgs']]]]] = None,
                 multi_step: Optional[pulumi.Input[pulumi.InputType['MultiStepArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outcome: Optional[pulumi.Input[pulumi.InputType['OutcomeArgs']]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 run_duration: Optional[pulumi.Input[pulumi.InputType['DurationArgs']]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 step_id: Optional[pulumi.Input[str]] = None,
                 test_execution_step: Optional[pulumi.Input[pulumi.InputType['TestExecutionStepArgs']]] = None,
                 tool_execution_step: Optional[pulumi.Input[pulumi.InputType['ToolExecutionStepArgs']]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a Step. The returned Step will have the id set. May return any of the following canonical error codes: - PERMISSION_DENIED - if the user is not authorized to write to project - INVALID_ARGUMENT - if the request is malformed - FAILED_PRECONDITION - if the step is too large (more than 10Mib) - NOT_FOUND - if the containing Execution does not exist

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['TimestampArgs']] completion_time: The time when the step status was set to complete. This value will be set automatically when state transitions to COMPLETE. - In response: set if the execution state is COMPLETE. - In create/update request: never set
        :param pulumi.Input[pulumi.InputType['TimestampArgs']] creation_time: The time when the step was created. - In response: always set - In create/update request: never set
        :param pulumi.Input[str] description: A description of this tool For example: mvn clean package -D skipTests=true - In response: present if set by create/update request - In create/update request: optional
        :param pulumi.Input[pulumi.InputType['DurationArgs']] device_usage_duration: How much the device resource is used to perform the test. This is the device usage used for billing purpose, which is different from the run_duration, for example, infrastructure failure won't be charged for device usage. PRECONDITION_FAILED will be returned if one attempts to set a device_usage on a step which already has this field set. - In response: present if previously set. - In create request: optional - In update request: optional
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StepDimensionValueEntryArgs']]]] dimension_value: If the execution containing this step has any dimension_definition set, then this field allows the child to specify the values of the dimensions. The keys must exactly match the dimension_definition of the execution. For example, if the execution has `dimension_definition = ['attempt', 'device']` then a step must define values for those dimensions, eg. `dimension_value = ['attempt': '1', 'device': 'Nexus 6']` If a step does not participate in one dimension of the matrix, the value for that dimension should be empty string. For example, if one of the tests is executed by a runner which does not support retries, the step could have `dimension_value = ['attempt': '', 'device': 'Nexus 6']` If the step does not participate in any dimensions of the matrix, it may leave dimension_value unset. A PRECONDITION_FAILED will be returned if any of the keys do not exist in the dimension_definition of the execution. A PRECONDITION_FAILED will be returned if another step in this execution already has the same name and dimension_value, but differs on other data fields, for example, step field is different. A PRECONDITION_FAILED will be returned if dimension_value is set, and there is a dimension_definition in the execution which is not specified as one of the keys. - In response: present if set by create - In create request: optional - In update request: never set
        :param pulumi.Input[bool] has_images: Whether any of the outputs of this step are images whose thumbnails can be fetched with ListThumbnails. - In response: always set - In create/update request: never set
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StepLabelsEntryArgs']]]] labels: Arbitrary user-supplied key/value pairs that are associated with the step. Users are responsible for managing the key namespace such that keys don't accidentally collide. An INVALID_ARGUMENT will be returned if the number of labels exceeds 100 or if the length of any of the keys or values exceeds 100 characters. - In response: always set - In create request: optional - In update request: optional; any new key/value pair will be added to the map, and any new value for an existing key will update that key's value
        :param pulumi.Input[pulumi.InputType['MultiStepArgs']] multi_step: Details when multiple steps are run with the same configuration as a group. These details can be used identify which group this step is part of. It also identifies the groups 'primary step' which indexes all the group members. - In response: present if previously set. - In create request: optional, set iff this step was performed more than once. - In update request: optional
        :param pulumi.Input[str] name: A short human-readable name to display in the UI. Maximum of 100 characters. For example: Clean build A PRECONDITION_FAILED will be returned upon creating a new step if it shares its name and dimension_value with an existing step. If two steps represent a similar action, but have different dimension values, they should share the same name. For instance, if the same set of tests is run on two different platforms, the two steps should have the same name. - In response: always set - In create request: always set - In update request: never set
        :param pulumi.Input[pulumi.InputType['OutcomeArgs']] outcome: Classification of the result, for example into SUCCESS or FAILURE - In response: present if set by create/update request - In create/update request: optional
        :param pulumi.Input[pulumi.InputType['DurationArgs']] run_duration: How long it took for this step to run. If unset, this is set to the difference between creation_time and completion_time when the step is set to the COMPLETE state. In some cases, it is appropriate to set this value separately: For instance, if a step is created, but the operation it represents is queued for a few minutes before it executes, it would be appropriate not to include the time spent queued in its run_duration. PRECONDITION_FAILED will be returned if one attempts to set a run_duration on a step which already has this field set. - In response: present if previously set; always present on COMPLETE step - In create request: optional - In update request: optional
        :param pulumi.Input[str] state: The initial state is IN_PROGRESS. The only legal state transitions are * IN_PROGRESS -> COMPLETE A PRECONDITION_FAILED will be returned if an invalid transition is requested. It is valid to create Step with a state set to COMPLETE. The state can only be set to COMPLETE once. A PRECONDITION_FAILED will be returned if the state is set to COMPLETE multiple times. - In response: always set - In create/update request: optional
        :param pulumi.Input[str] step_id: A unique identifier within a Execution for this Step. Returns INVALID_ARGUMENT if this field is set or overwritten by the caller. - In response: always set - In create/update request: never set
        :param pulumi.Input[pulumi.InputType['TestExecutionStepArgs']] test_execution_step: An execution of a test runner.
        :param pulumi.Input[pulumi.InputType['ToolExecutionStepArgs']] tool_execution_step: An execution of a tool (used for steps we don't explicitly support).
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['completion_time'] = completion_time
            __props__['creation_time'] = creation_time
            __props__['description'] = description
            __props__['device_usage_duration'] = device_usage_duration
            __props__['dimension_value'] = dimension_value
            if execution_id is None and not opts.urn:
                raise TypeError("Missing required property 'execution_id'")
            __props__['execution_id'] = execution_id
            __props__['has_images'] = has_images
            if history_id is None and not opts.urn:
                raise TypeError("Missing required property 'history_id'")
            __props__['history_id'] = history_id
            __props__['labels'] = labels
            __props__['multi_step'] = multi_step
            __props__['name'] = name
            __props__['outcome'] = outcome
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__['project_id'] = project_id
            __props__['run_duration'] = run_duration
            __props__['state'] = state
            if step_id is None and not opts.urn:
                raise TypeError("Missing required property 'step_id'")
            __props__['step_id'] = step_id
            __props__['test_execution_step'] = test_execution_step
            __props__['tool_execution_step'] = tool_execution_step
        super(HistoryExecutionStep, __self__).__init__(
            'gcp-native:toolresults/v1beta3:HistoryExecutionStep',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'HistoryExecutionStep':
        """
        Get an existing HistoryExecutionStep resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["completion_time"] = None
        __props__["creation_time"] = None
        __props__["description"] = None
        __props__["device_usage_duration"] = None
        __props__["dimension_value"] = None
        __props__["has_images"] = None
        __props__["labels"] = None
        __props__["multi_step"] = None
        __props__["name"] = None
        __props__["outcome"] = None
        __props__["run_duration"] = None
        __props__["state"] = None
        __props__["step_id"] = None
        __props__["test_execution_step"] = None
        __props__["tool_execution_step"] = None
        return HistoryExecutionStep(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="completionTime")
    def completion_time(self) -> pulumi.Output['outputs.TimestampResponse']:
        """
        The time when the step status was set to complete. This value will be set automatically when state transitions to COMPLETE. - In response: set if the execution state is COMPLETE. - In create/update request: never set
        """
        return pulumi.get(self, "completion_time")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output['outputs.TimestampResponse']:
        """
        The time when the step was created. - In response: always set - In create/update request: never set
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        A description of this tool For example: mvn clean package -D skipTests=true - In response: present if set by create/update request - In create/update request: optional
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceUsageDuration")
    def device_usage_duration(self) -> pulumi.Output['outputs.DurationResponse']:
        """
        How much the device resource is used to perform the test. This is the device usage used for billing purpose, which is different from the run_duration, for example, infrastructure failure won't be charged for device usage. PRECONDITION_FAILED will be returned if one attempts to set a device_usage on a step which already has this field set. - In response: present if previously set. - In create request: optional - In update request: optional
        """
        return pulumi.get(self, "device_usage_duration")

    @property
    @pulumi.getter(name="dimensionValue")
    def dimension_value(self) -> pulumi.Output[Sequence['outputs.StepDimensionValueEntryResponse']]:
        """
        If the execution containing this step has any dimension_definition set, then this field allows the child to specify the values of the dimensions. The keys must exactly match the dimension_definition of the execution. For example, if the execution has `dimension_definition = ['attempt', 'device']` then a step must define values for those dimensions, eg. `dimension_value = ['attempt': '1', 'device': 'Nexus 6']` If a step does not participate in one dimension of the matrix, the value for that dimension should be empty string. For example, if one of the tests is executed by a runner which does not support retries, the step could have `dimension_value = ['attempt': '', 'device': 'Nexus 6']` If the step does not participate in any dimensions of the matrix, it may leave dimension_value unset. A PRECONDITION_FAILED will be returned if any of the keys do not exist in the dimension_definition of the execution. A PRECONDITION_FAILED will be returned if another step in this execution already has the same name and dimension_value, but differs on other data fields, for example, step field is different. A PRECONDITION_FAILED will be returned if dimension_value is set, and there is a dimension_definition in the execution which is not specified as one of the keys. - In response: present if set by create - In create request: optional - In update request: never set
        """
        return pulumi.get(self, "dimension_value")

    @property
    @pulumi.getter(name="hasImages")
    def has_images(self) -> pulumi.Output[bool]:
        """
        Whether any of the outputs of this step are images whose thumbnails can be fetched with ListThumbnails. - In response: always set - In create/update request: never set
        """
        return pulumi.get(self, "has_images")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Sequence['outputs.StepLabelsEntryResponse']]:
        """
        Arbitrary user-supplied key/value pairs that are associated with the step. Users are responsible for managing the key namespace such that keys don't accidentally collide. An INVALID_ARGUMENT will be returned if the number of labels exceeds 100 or if the length of any of the keys or values exceeds 100 characters. - In response: always set - In create request: optional - In update request: optional; any new key/value pair will be added to the map, and any new value for an existing key will update that key's value
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="multiStep")
    def multi_step(self) -> pulumi.Output['outputs.MultiStepResponse']:
        """
        Details when multiple steps are run with the same configuration as a group. These details can be used identify which group this step is part of. It also identifies the groups 'primary step' which indexes all the group members. - In response: present if previously set. - In create request: optional, set iff this step was performed more than once. - In update request: optional
        """
        return pulumi.get(self, "multi_step")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A short human-readable name to display in the UI. Maximum of 100 characters. For example: Clean build A PRECONDITION_FAILED will be returned upon creating a new step if it shares its name and dimension_value with an existing step. If two steps represent a similar action, but have different dimension values, they should share the same name. For instance, if the same set of tests is run on two different platforms, the two steps should have the same name. - In response: always set - In create request: always set - In update request: never set
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def outcome(self) -> pulumi.Output['outputs.OutcomeResponse']:
        """
        Classification of the result, for example into SUCCESS or FAILURE - In response: present if set by create/update request - In create/update request: optional
        """
        return pulumi.get(self, "outcome")

    @property
    @pulumi.getter(name="runDuration")
    def run_duration(self) -> pulumi.Output['outputs.DurationResponse']:
        """
        How long it took for this step to run. If unset, this is set to the difference between creation_time and completion_time when the step is set to the COMPLETE state. In some cases, it is appropriate to set this value separately: For instance, if a step is created, but the operation it represents is queued for a few minutes before it executes, it would be appropriate not to include the time spent queued in its run_duration. PRECONDITION_FAILED will be returned if one attempts to set a run_duration on a step which already has this field set. - In response: present if previously set; always present on COMPLETE step - In create request: optional - In update request: optional
        """
        return pulumi.get(self, "run_duration")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The initial state is IN_PROGRESS. The only legal state transitions are * IN_PROGRESS -> COMPLETE A PRECONDITION_FAILED will be returned if an invalid transition is requested. It is valid to create Step with a state set to COMPLETE. The state can only be set to COMPLETE once. A PRECONDITION_FAILED will be returned if the state is set to COMPLETE multiple times. - In response: always set - In create/update request: optional
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stepId")
    def step_id(self) -> pulumi.Output[str]:
        """
        A unique identifier within a Execution for this Step. Returns INVALID_ARGUMENT if this field is set or overwritten by the caller. - In response: always set - In create/update request: never set
        """
        return pulumi.get(self, "step_id")

    @property
    @pulumi.getter(name="testExecutionStep")
    def test_execution_step(self) -> pulumi.Output['outputs.TestExecutionStepResponse']:
        """
        An execution of a test runner.
        """
        return pulumi.get(self, "test_execution_step")

    @property
    @pulumi.getter(name="toolExecutionStep")
    def tool_execution_step(self) -> pulumi.Output['outputs.ToolExecutionStepResponse']:
        """
        An execution of a tool (used for steps we don't explicitly support).
        """
        return pulumi.get(self, "tool_execution_step")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

