# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Bucket']


class Bucket(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketAccessControlArgs']]]]] = None,
                 billing: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 cors: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]] = None,
                 default_event_based_hold: Optional[pulumi.Input[bool]] = None,
                 default_object_acl: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ObjectAccessControlArgs']]]]] = None,
                 encryption: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 iam_configuration: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lifecycle: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 location_type: Optional[pulumi.Input[str]] = None,
                 logging: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 metageneration: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 project_number: Optional[pulumi.Input[str]] = None,
                 retention_policy: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 satisfies_pzs: Optional[pulumi.Input[bool]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 storage_class: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 updated: Optional[pulumi.Input[str]] = None,
                 versioning: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 website: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 zone_affinity: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a new bucket.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketAccessControlArgs']]]] acl: Access controls on the bucket.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] billing: The bucket's billing configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]] cors: The bucket's Cross-Origin Resource Sharing (CORS) configuration.
        :param pulumi.Input[bool] default_event_based_hold: The default value for event-based hold on newly created objects in this bucket. Event-based hold is a way to retain objects indefinitely until an event occurs, signified by the hold's release. After being released, such objects will be subject to bucket-level retention (if any). One sample use case of this flag is for banks to hold loan documents for at least 3 years after loan is paid in full. Here, bucket-level retention is 3 years and the event is loan being paid in full. In this example, these objects will be held intact for any number of years until the event has occurred (event-based hold on the object is released) and then 3 more years after that. That means retention duration of the objects begins from the moment event-based hold transitioned from true to false. Objects under event-based hold cannot be deleted, overwritten or archived until the hold is removed.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ObjectAccessControlArgs']]]] default_object_acl: Default access controls to apply to new objects when no ACL is provided.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] encryption: Encryption configuration for a bucket.
        :param pulumi.Input[str] etag: HTTP 1.1 Entity tag for the bucket.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] iam_configuration: The bucket's IAM configuration.
        :param pulumi.Input[str] id: The ID of the bucket. For buckets, the id and name properties are the same.
        :param pulumi.Input[str] kind: The kind of item this is. For buckets, this is always storage#bucket.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-provided labels, in key/value pairs.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] lifecycle: The bucket's lifecycle configuration. See lifecycle management for more information.
        :param pulumi.Input[str] location: The location of the bucket. Object data for objects in the bucket resides in physical storage within this region. Defaults to US. See the developer's guide for the authoritative list.
        :param pulumi.Input[str] location_type: The type of the bucket location.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] logging: The bucket's logging configuration, which defines the destination bucket and optional name prefix for the current bucket's logs.
        :param pulumi.Input[str] metageneration: The metadata generation of this bucket.
        :param pulumi.Input[str] name: The name of the bucket.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] owner: The owner of the bucket. This is always the project team's owner group.
        :param pulumi.Input[str] project_number: The project number of the project the bucket belongs to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] retention_policy: The bucket's retention policy. The retention policy enforces a minimum retention time for all objects contained in the bucket, based on their creation time. Any attempt to overwrite or delete objects younger than the retention period will result in a PERMISSION_DENIED error. An unlocked retention policy can be modified or removed from the bucket via a storage.buckets.update operation. A locked retention policy cannot be removed or shortened in duration for the lifetime of the bucket. Attempting to remove or decrease period of a locked retention policy will result in a PERMISSION_DENIED error.
        :param pulumi.Input[bool] satisfies_pzs: Reserved for future use.
        :param pulumi.Input[str] self_link: The URI of this bucket.
        :param pulumi.Input[str] storage_class: The bucket's default storage class, used whenever no storageClass is specified for a newly-created object. This defines how objects in the bucket are stored and determines the SLA and the cost of storage. Values include MULTI_REGIONAL, REGIONAL, STANDARD, NEARLINE, COLDLINE, ARCHIVE, and DURABLE_REDUCED_AVAILABILITY. If this value is not specified when the bucket is created, it will default to STANDARD. For more information, see storage classes.
        :param pulumi.Input[str] time_created: The creation time of the bucket in RFC 3339 format.
        :param pulumi.Input[str] updated: The modification time of the bucket in RFC 3339 format.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] versioning: The bucket's versioning configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] website: The bucket's website configuration, controlling how the service behaves when accessing bucket contents as a web site. See the Static Website Examples for more information.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zone_affinity: The zone or zones from which the bucket is intended to use zonal quota. Requests for data from outside the specified affinities are still allowed but won't be able to use zonal quota. The zone or zones need to be within the bucket location otherwise the requests will fail with a 400 Bad Request response.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['acl'] = acl
            __props__['billing'] = billing
            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__['bucket'] = bucket
            __props__['cors'] = cors
            __props__['default_event_based_hold'] = default_event_based_hold
            __props__['default_object_acl'] = default_object_acl
            __props__['encryption'] = encryption
            __props__['etag'] = etag
            __props__['iam_configuration'] = iam_configuration
            __props__['id'] = id
            __props__['kind'] = kind
            __props__['labels'] = labels
            __props__['lifecycle'] = lifecycle
            __props__['location'] = location
            __props__['location_type'] = location_type
            __props__['logging'] = logging
            __props__['metageneration'] = metageneration
            __props__['name'] = name
            __props__['owner'] = owner
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            __props__['project_number'] = project_number
            __props__['retention_policy'] = retention_policy
            __props__['satisfies_pzs'] = satisfies_pzs
            __props__['self_link'] = self_link
            __props__['storage_class'] = storage_class
            __props__['time_created'] = time_created
            __props__['updated'] = updated
            __props__['versioning'] = versioning
            __props__['website'] = website
            __props__['zone_affinity'] = zone_affinity
        super(Bucket, __self__).__init__(
            'gcp-native:storage/v1:Bucket',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Bucket':
        """
        Get an existing Bucket resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["acl"] = None
        __props__["billing"] = None
        __props__["cors"] = None
        __props__["default_event_based_hold"] = None
        __props__["default_object_acl"] = None
        __props__["encryption"] = None
        __props__["etag"] = None
        __props__["iam_configuration"] = None
        __props__["kind"] = None
        __props__["labels"] = None
        __props__["lifecycle"] = None
        __props__["location"] = None
        __props__["location_type"] = None
        __props__["logging"] = None
        __props__["metageneration"] = None
        __props__["name"] = None
        __props__["owner"] = None
        __props__["project_number"] = None
        __props__["retention_policy"] = None
        __props__["satisfies_pzs"] = None
        __props__["self_link"] = None
        __props__["storage_class"] = None
        __props__["time_created"] = None
        __props__["updated"] = None
        __props__["versioning"] = None
        __props__["website"] = None
        __props__["zone_affinity"] = None
        return Bucket(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acl(self) -> pulumi.Output[Sequence['outputs.BucketAccessControlResponse']]:
        """
        Access controls on the bucket.
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter
    def billing(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The bucket's billing configuration.
        """
        return pulumi.get(self, "billing")

    @property
    @pulumi.getter
    def cors(self) -> pulumi.Output[Sequence[Mapping[str, str]]]:
        """
        The bucket's Cross-Origin Resource Sharing (CORS) configuration.
        """
        return pulumi.get(self, "cors")

    @property
    @pulumi.getter(name="defaultEventBasedHold")
    def default_event_based_hold(self) -> pulumi.Output[bool]:
        """
        The default value for event-based hold on newly created objects in this bucket. Event-based hold is a way to retain objects indefinitely until an event occurs, signified by the hold's release. After being released, such objects will be subject to bucket-level retention (if any). One sample use case of this flag is for banks to hold loan documents for at least 3 years after loan is paid in full. Here, bucket-level retention is 3 years and the event is loan being paid in full. In this example, these objects will be held intact for any number of years until the event has occurred (event-based hold on the object is released) and then 3 more years after that. That means retention duration of the objects begins from the moment event-based hold transitioned from true to false. Objects under event-based hold cannot be deleted, overwritten or archived until the hold is removed.
        """
        return pulumi.get(self, "default_event_based_hold")

    @property
    @pulumi.getter(name="defaultObjectAcl")
    def default_object_acl(self) -> pulumi.Output[Sequence['outputs.ObjectAccessControlResponse']]:
        """
        Default access controls to apply to new objects when no ACL is provided.
        """
        return pulumi.get(self, "default_object_acl")

    @property
    @pulumi.getter
    def encryption(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Encryption configuration for a bucket.
        """
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        HTTP 1.1 Entity tag for the bucket.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="iamConfiguration")
    def iam_configuration(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The bucket's IAM configuration.
        """
        return pulumi.get(self, "iam_configuration")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[str]:
        """
        The kind of item this is. For buckets, this is always storage#bucket.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        User-provided labels, in key/value pairs.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def lifecycle(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The bucket's lifecycle configuration. See lifecycle management for more information.
        """
        return pulumi.get(self, "lifecycle")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The location of the bucket. Object data for objects in the bucket resides in physical storage within this region. Defaults to US. See the developer's guide for the authoritative list.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> pulumi.Output[str]:
        """
        The type of the bucket location.
        """
        return pulumi.get(self, "location_type")

    @property
    @pulumi.getter
    def logging(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The bucket's logging configuration, which defines the destination bucket and optional name prefix for the current bucket's logs.
        """
        return pulumi.get(self, "logging")

    @property
    @pulumi.getter
    def metageneration(self) -> pulumi.Output[str]:
        """
        The metadata generation of this bucket.
        """
        return pulumi.get(self, "metageneration")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The owner of the bucket. This is always the project team's owner group.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="projectNumber")
    def project_number(self) -> pulumi.Output[str]:
        """
        The project number of the project the bucket belongs to.
        """
        return pulumi.get(self, "project_number")

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The bucket's retention policy. The retention policy enforces a minimum retention time for all objects contained in the bucket, based on their creation time. Any attempt to overwrite or delete objects younger than the retention period will result in a PERMISSION_DENIED error. An unlocked retention policy can be modified or removed from the bucket via a storage.buckets.update operation. A locked retention policy cannot be removed or shortened in duration for the lifetime of the bucket. Attempting to remove or decrease period of a locked retention policy will result in a PERMISSION_DENIED error.
        """
        return pulumi.get(self, "retention_policy")

    @property
    @pulumi.getter(name="satisfiesPZS")
    def satisfies_pzs(self) -> pulumi.Output[bool]:
        """
        Reserved for future use.
        """
        return pulumi.get(self, "satisfies_pzs")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of this bucket.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> pulumi.Output[str]:
        """
        The bucket's default storage class, used whenever no storageClass is specified for a newly-created object. This defines how objects in the bucket are stored and determines the SLA and the cost of storage. Values include MULTI_REGIONAL, REGIONAL, STANDARD, NEARLINE, COLDLINE, ARCHIVE, and DURABLE_REDUCED_AVAILABILITY. If this value is not specified when the bucket is created, it will default to STANDARD. For more information, see storage classes.
        """
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The creation time of the bucket in RFC 3339 format.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def updated(self) -> pulumi.Output[str]:
        """
        The modification time of the bucket in RFC 3339 format.
        """
        return pulumi.get(self, "updated")

    @property
    @pulumi.getter
    def versioning(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The bucket's versioning configuration.
        """
        return pulumi.get(self, "versioning")

    @property
    @pulumi.getter
    def website(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The bucket's website configuration, controlling how the service behaves when accessing bucket contents as a web site. See the Static Website Examples for more information.
        """
        return pulumi.get(self, "website")

    @property
    @pulumi.getter(name="zoneAffinity")
    def zone_affinity(self) -> pulumi.Output[Sequence[str]]:
        """
        The zone or zones from which the bucket is intended to use zonal quota. Requests for data from outside the specified affinities are still allowed but won't be able to use zonal quota. The zone or zones need to be within the bucket location otherwise the requests will fail with a 400 Bad Request response.
        """
        return pulumi.get(self, "zone_affinity")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

