# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['BackupRun']


class BackupRun(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_kind: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_encryption_configuration: Optional[pulumi.Input[pulumi.InputType['DiskEncryptionConfigurationArgs']]] = None,
                 disk_encryption_status: Optional[pulumi.Input[pulumi.InputType['DiskEncryptionStatusArgs']]] = None,
                 end_time: Optional[pulumi.Input[str]] = None,
                 enqueued_time: Optional[pulumi.Input[str]] = None,
                 error: Optional[pulumi.Input[pulumi.InputType['OperationErrorArgs']]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 instance: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 window_start_time: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a new backup run on demand. This method is applicable only to Second Generation instances.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backup_kind: Specifies the kind of backup, PHYSICAL or DEFAULT_SNAPSHOT.
        :param pulumi.Input[str] description: The description of this run, only applicable to on-demand backups.
        :param pulumi.Input[pulumi.InputType['DiskEncryptionConfigurationArgs']] disk_encryption_configuration: Encryption configuration specific to a backup. Applies only to Second Generation instances.
        :param pulumi.Input[pulumi.InputType['DiskEncryptionStatusArgs']] disk_encryption_status: Encryption status specific to a backup. Applies only to Second Generation instances.
        :param pulumi.Input[str] end_time: The time the backup operation completed in UTC timezone in RFC 3339 format, for example *2012-11-15T16:19:00.094Z*.
        :param pulumi.Input[str] enqueued_time: The time the run was enqueued in UTC timezone in RFC 3339 format, for example *2012-11-15T16:19:00.094Z*.
        :param pulumi.Input[pulumi.InputType['OperationErrorArgs']] error: Information about why the backup operation failed. This is only present if the run has the FAILED status.
        :param pulumi.Input[str] id: The identifier for this backup run. Unique only for a specific Cloud SQL instance.
        :param pulumi.Input[str] instance: Name of the database instance.
        :param pulumi.Input[str] kind: This is always *sql#backupRun*.
        :param pulumi.Input[str] location: Location of the backups.
        :param pulumi.Input[str] self_link: The URI of this resource.
        :param pulumi.Input[str] start_time: The time the backup operation actually started in UTC timezone in RFC 3339 format, for example *2012-11-15T16:19:00.094Z*.
        :param pulumi.Input[str] status: The status of this run.
        :param pulumi.Input[str] type: The type of this run; can be either "AUTOMATED" or "ON_DEMAND". This field defaults to "ON_DEMAND" and is ignored, when specified for insert requests.
        :param pulumi.Input[str] window_start_time: The start time of the backup window during which this the backup was attempted in RFC 3339 format, for example *2012-11-15T16:19:00.094Z*.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['backup_kind'] = backup_kind
            __props__['description'] = description
            __props__['disk_encryption_configuration'] = disk_encryption_configuration
            __props__['disk_encryption_status'] = disk_encryption_status
            __props__['end_time'] = end_time
            __props__['enqueued_time'] = enqueued_time
            __props__['error'] = error
            if id is None and not opts.urn:
                raise TypeError("Missing required property 'id'")
            __props__['id'] = id
            if instance is None and not opts.urn:
                raise TypeError("Missing required property 'instance'")
            __props__['instance'] = instance
            __props__['kind'] = kind
            __props__['location'] = location
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            __props__['self_link'] = self_link
            __props__['start_time'] = start_time
            __props__['status'] = status
            __props__['type'] = type
            __props__['window_start_time'] = window_start_time
        super(BackupRun, __self__).__init__(
            'gcp-native:sqladmin/v1beta4:BackupRun',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'BackupRun':
        """
        Get an existing BackupRun resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["backup_kind"] = None
        __props__["description"] = None
        __props__["disk_encryption_configuration"] = None
        __props__["disk_encryption_status"] = None
        __props__["end_time"] = None
        __props__["enqueued_time"] = None
        __props__["error"] = None
        __props__["instance"] = None
        __props__["kind"] = None
        __props__["location"] = None
        __props__["self_link"] = None
        __props__["start_time"] = None
        __props__["status"] = None
        __props__["type"] = None
        __props__["window_start_time"] = None
        return BackupRun(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backupKind")
    def backup_kind(self) -> pulumi.Output[str]:
        """
        Specifies the kind of backup, PHYSICAL or DEFAULT_SNAPSHOT.
        """
        return pulumi.get(self, "backup_kind")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of this run, only applicable to on-demand backups.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskEncryptionConfiguration")
    def disk_encryption_configuration(self) -> pulumi.Output['outputs.DiskEncryptionConfigurationResponse']:
        """
        Encryption configuration specific to a backup. Applies only to Second Generation instances.
        """
        return pulumi.get(self, "disk_encryption_configuration")

    @property
    @pulumi.getter(name="diskEncryptionStatus")
    def disk_encryption_status(self) -> pulumi.Output['outputs.DiskEncryptionStatusResponse']:
        """
        Encryption status specific to a backup. Applies only to Second Generation instances.
        """
        return pulumi.get(self, "disk_encryption_status")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[str]:
        """
        The time the backup operation completed in UTC timezone in RFC 3339 format, for example *2012-11-15T16:19:00.094Z*.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="enqueuedTime")
    def enqueued_time(self) -> pulumi.Output[str]:
        """
        The time the run was enqueued in UTC timezone in RFC 3339 format, for example *2012-11-15T16:19:00.094Z*.
        """
        return pulumi.get(self, "enqueued_time")

    @property
    @pulumi.getter
    def error(self) -> pulumi.Output['outputs.OperationErrorResponse']:
        """
        Information about why the backup operation failed. This is only present if the run has the FAILED status.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Output[str]:
        """
        Name of the database instance.
        """
        return pulumi.get(self, "instance")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[str]:
        """
        This is always *sql#backupRun*.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        Location of the backups.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of this resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[str]:
        """
        The time the backup operation actually started in UTC timezone in RFC 3339 format, for example *2012-11-15T16:19:00.094Z*.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of this run.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of this run; can be either "AUTOMATED" or "ON_DEMAND". This field defaults to "ON_DEMAND" and is ignored, when specified for insert requests.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="windowStartTime")
    def window_start_time(self) -> pulumi.Output[str]:
        """
        The start time of the backup window during which this the backup was attempted in RFC 3339 format, for example *2012-11-15T16:19:00.094Z*.
        """
        return pulumi.get(self, "window_start_time")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

