# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables

__all__ = [
    'AddressableArgs',
    'AuditConfigArgs',
    'AuditLogConfigArgs',
    'BindingArgs',
    'CapabilitiesArgs',
    'ConfigMapEnvSourceArgs',
    'ConfigMapKeySelectorArgs',
    'ConfigMapVolumeSourceArgs',
    'ConfigurationSpecArgs',
    'ContainerArgs',
    'ContainerPortArgs',
    'DomainMappingConditionArgs',
    'DomainMappingSpecArgs',
    'DomainMappingStatusArgs',
    'EnvFromSourceArgs',
    'EnvVarArgs',
    'EnvVarSourceArgs',
    'ExecActionArgs',
    'ExprArgs',
    'HTTPGetActionArgs',
    'HTTPHeaderArgs',
    'HandlerArgs',
    'InstanceSpecArgs',
    'InstanceStatusArgs',
    'InstanceTemplateSpecArgs',
    'IntOrStringArgs',
    'JobConditionArgs',
    'JobSpecArgs',
    'JobStatusArgs',
    'KeyToPathArgs',
    'LifecycleArgs',
    'LocalObjectReferenceArgs',
    'ObjectMetaArgs',
    'OwnerReferenceArgs',
    'ProbeArgs',
    'ResourceRecordArgs',
    'ResourceRequirementsArgs',
    'RevisionSpecArgs',
    'RevisionTemplateArgs',
    'SELinuxOptionsArgs',
    'SecretEnvSourceArgs',
    'SecretKeySelectorArgs',
    'SecretVolumeSourceArgs',
    'SecurityContextArgs',
    'ServiceConditionArgs',
    'ServiceSpecArgs',
    'ServiceSpecManualTypeArgs',
    'ServiceSpecPinnedTypeArgs',
    'ServiceSpecReleaseTypeArgs',
    'ServiceSpecRunLatestArgs',
    'ServiceStatusArgs',
    'TCPSocketActionArgs',
    'TrafficTargetArgs',
    'VolumeArgs',
    'VolumeDeviceArgs',
    'VolumeMountArgs',
]

@pulumi.input_type
class AddressableArgs:
    def __init__(__self__, *,
                 hostname: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Information for connecting over HTTP(s).
        :param pulumi.Input[str] hostname: Deprecated - use url instead.
        """
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Deprecated - use url instead.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class AuditConfigArgs:
    def __init__(__self__, *,
                 audit_log_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]] = None,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
        :param pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]] audit_log_configs: The configuration for logging of each type of permission.
        :param pulumi.Input[str] service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        if audit_log_configs is not None:
            pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @audit_log_configs.setter
    def audit_log_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]):
        pulumi.set(self, "audit_log_configs", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class AuditLogConfigArgs:
    def __init__(__self__, *,
                 exempted_members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_type: Optional[pulumi.Input[str]] = None):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param pulumi.Input[str] log_type: The log type that this config enables.
        """
        if exempted_members is not None:
            pulumi.set(__self__, "exempted_members", exempted_members)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @exempted_members.setter
    def exempted_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exempted_members", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[pulumi.Input[str]]:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_type", value)


@pulumi.input_type
class BindingArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates `members` with a `role`.
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the identities requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param pulumi.Input[str] role: Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class CapabilitiesArgs:
    def __init__(__self__, *,
                 add: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 drop: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Adds and removes POSIX capabilities from running containers.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] add: Added capabilities +optional
        :param pulumi.Input[Sequence[pulumi.Input[str]]] drop: Removed capabilities +optional
        """
        if add is not None:
            pulumi.set(__self__, "add", add)
        if drop is not None:
            pulumi.set(__self__, "drop", drop)

    @property
    @pulumi.getter
    def add(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Added capabilities +optional
        """
        return pulumi.get(self, "add")

    @add.setter
    def add(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "add", value)

    @property
    @pulumi.getter
    def drop(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Removed capabilities +optional
        """
        return pulumi.get(self, "drop")

    @drop.setter
    def drop(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "drop", value)


@pulumi.input_type
class ConfigMapEnvSourceArgs:
    def __init__(__self__, *,
                 local_object_reference: Optional[pulumi.Input['LocalObjectReferenceArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 optional: Optional[pulumi.Input[bool]] = None):
        """
        ConfigMapEnvSource selects a ConfigMap to populate the environment variables with. The contents of the target ConfigMap's Data field will represent the key-value pairs as environment variables.
        :param pulumi.Input['LocalObjectReferenceArgs'] local_object_reference: This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        :param pulumi.Input[str] name: Cloud Run fully managed: not supported Cloud Run for Anthos: supported The ConfigMap to select from.
        :param pulumi.Input[bool] optional: Cloud Run fully managed: not supported Cloud Run for Anthos: supported Specify whether the ConfigMap must be defined +optional
        """
        if local_object_reference is not None:
            pulumi.set(__self__, "local_object_reference", local_object_reference)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="localObjectReference")
    def local_object_reference(self) -> Optional[pulumi.Input['LocalObjectReferenceArgs']]:
        """
        This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        """
        return pulumi.get(self, "local_object_reference")

    @local_object_reference.setter
    def local_object_reference(self, value: Optional[pulumi.Input['LocalObjectReferenceArgs']]):
        pulumi.set(self, "local_object_reference", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud Run fully managed: not supported Cloud Run for Anthos: supported The ConfigMap to select from.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def optional(self) -> Optional[pulumi.Input[bool]]:
        """
        Cloud Run fully managed: not supported Cloud Run for Anthos: supported Specify whether the ConfigMap must be defined +optional
        """
        return pulumi.get(self, "optional")

    @optional.setter
    def optional(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "optional", value)


@pulumi.input_type
class ConfigMapKeySelectorArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 local_object_reference: Optional[pulumi.Input['LocalObjectReferenceArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 optional: Optional[pulumi.Input[bool]] = None):
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported Selects a key from a ConfigMap.
        :param pulumi.Input[str] key: Cloud Run fully managed: not supported Cloud Run on GKE: supported The key to select.
        :param pulumi.Input['LocalObjectReferenceArgs'] local_object_reference: This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        :param pulumi.Input[str] name: Cloud Run fully managed: not supported Cloud Run on GKE: supported The ConfigMap to select from.
        :param pulumi.Input[bool] optional: Cloud Run fully managed: not supported Cloud Run on GKE: supported Specify whether the ConfigMap or its key must be defined +optional
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if local_object_reference is not None:
            pulumi.set(__self__, "local_object_reference", local_object_reference)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported The key to select.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="localObjectReference")
    def local_object_reference(self) -> Optional[pulumi.Input['LocalObjectReferenceArgs']]:
        """
        This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        """
        return pulumi.get(self, "local_object_reference")

    @local_object_reference.setter
    def local_object_reference(self, value: Optional[pulumi.Input['LocalObjectReferenceArgs']]):
        pulumi.set(self, "local_object_reference", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported The ConfigMap to select from.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def optional(self) -> Optional[pulumi.Input[bool]]:
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported Specify whether the ConfigMap or its key must be defined +optional
        """
        return pulumi.get(self, "optional")

    @optional.setter
    def optional(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "optional", value)


@pulumi.input_type
class ConfigMapVolumeSourceArgs:
    def __init__(__self__, *,
                 default_mode: Optional[pulumi.Input[int]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['KeyToPathArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 optional: Optional[pulumi.Input[bool]] = None):
        """
        Adapts a ConfigMap into a volume. The contents of the target ConfigMap's Data field will be presented in a volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths.
        :param pulumi.Input[int] default_mode: Mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param pulumi.Input[Sequence[pulumi.Input['KeyToPathArgs']]] items: If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional.
        :param pulumi.Input[str] name: Name of the config.
        :param pulumi.Input[bool] optional: Specify whether the Secret or its keys must be defined.
        """
        if default_mode is not None:
            pulumi.set(__self__, "default_mode", default_mode)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> Optional[pulumi.Input[int]]:
        """
        Mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "default_mode")

    @default_mode.setter
    def default_mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_mode", value)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeyToPathArgs']]]]:
        """
        If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeyToPathArgs']]]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the config.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def optional(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether the Secret or its keys must be defined.
        """
        return pulumi.get(self, "optional")

    @optional.setter
    def optional(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "optional", value)


@pulumi.input_type
class ConfigurationSpecArgs:
    def __init__(__self__, *,
                 generation: Optional[pulumi.Input[int]] = None,
                 revision_template: Optional[pulumi.Input['RevisionTemplateArgs']] = None,
                 template: Optional[pulumi.Input['RevisionTemplateArgs']] = None):
        """
        ConfigurationSpec holds the desired state of the Configuration (from the client).
        :param pulumi.Input[int] generation: Deprecated and not currently populated by Cloud Run. See metadata.generation instead, which is the sequence number containing the latest generation of the desired state. Read-only.
        :param pulumi.Input['RevisionTemplateArgs'] revision_template: RevisionTemplate holds the latest specification for the Revision to be stamped out. The template references the container image, and may also include labels and annotations that should be attached to the Revision. To correlate a Revision, and/or to force a Revision to be created when the spec doesn't otherwise change, a nonce label may be provided in the template metadata. For more details, see: https://github.com/knative/serving/blob/master/docs/client-conventions.md#associate-modifications-with-revisions Cloud Run does not currently support referencing a build that is responsible for materializing the container image from source.
        :param pulumi.Input['RevisionTemplateArgs'] template: Template holds the latest specification for the Revision to be stamped out.
        """
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if revision_template is not None:
            pulumi.set(__self__, "revision_template", revision_template)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[int]]:
        """
        Deprecated and not currently populated by Cloud Run. See metadata.generation instead, which is the sequence number containing the latest generation of the desired state. Read-only.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter(name="revisionTemplate")
    def revision_template(self) -> Optional[pulumi.Input['RevisionTemplateArgs']]:
        """
        RevisionTemplate holds the latest specification for the Revision to be stamped out. The template references the container image, and may also include labels and annotations that should be attached to the Revision. To correlate a Revision, and/or to force a Revision to be created when the spec doesn't otherwise change, a nonce label may be provided in the template metadata. For more details, see: https://github.com/knative/serving/blob/master/docs/client-conventions.md#associate-modifications-with-revisions Cloud Run does not currently support referencing a build that is responsible for materializing the container image from source.
        """
        return pulumi.get(self, "revision_template")

    @revision_template.setter
    def revision_template(self, value: Optional[pulumi.Input['RevisionTemplateArgs']]):
        pulumi.set(self, "revision_template", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['RevisionTemplateArgs']]:
        """
        Template holds the latest specification for the Revision to be stamped out.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['RevisionTemplateArgs']]):
        pulumi.set(self, "template", value)


@pulumi.input_type
class ContainerArgs:
    def __init__(__self__, *,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 command: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 env: Optional[pulumi.Input[Sequence[pulumi.Input['EnvVarArgs']]]] = None,
                 env_from: Optional[pulumi.Input[Sequence[pulumi.Input['EnvFromSourceArgs']]]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 image_pull_policy: Optional[pulumi.Input[str]] = None,
                 lifecycle: Optional[pulumi.Input['LifecycleArgs']] = None,
                 liveness_probe: Optional[pulumi.Input['ProbeArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerPortArgs']]]] = None,
                 readiness_probe: Optional[pulumi.Input['ProbeArgs']] = None,
                 resources: Optional[pulumi.Input['ResourceRequirementsArgs']] = None,
                 security_context: Optional[pulumi.Input['SecurityContextArgs']] = None,
                 stdin: Optional[pulumi.Input[bool]] = None,
                 stdin_once: Optional[pulumi.Input[bool]] = None,
                 termination_message_path: Optional[pulumi.Input[str]] = None,
                 termination_message_policy: Optional[pulumi.Input[str]] = None,
                 tty: Optional[pulumi.Input[bool]] = None,
                 volume_devices: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeDeviceArgs']]]] = None,
                 volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeMountArgs']]]] = None,
                 working_dir: Optional[pulumi.Input[str]] = None):
        """
        A single application container. This specifies both the container to run, the command to run in the container and the arguments to supply to it. Note that additional arguments may be supplied by the system to the container at runtime.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell +optional
        :param pulumi.Input[Sequence[pulumi.Input[str]]] command: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell +optional
        :param pulumi.Input[Sequence[pulumi.Input['EnvVarArgs']]] env: List of environment variables to set in the container. Cannot be updated. +optional
        :param pulumi.Input[Sequence[pulumi.Input['EnvFromSourceArgs']]] env_from: List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated. +optional
        :param pulumi.Input[str] image: Docker image name. More info: https://kubernetes.io/docs/concepts/containers/images
        :param pulumi.Input[str] image_pull_policy: Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images +optional
        :param pulumi.Input['LifecycleArgs'] lifecycle: Actions that the management system should take in response to container lifecycle events. Cannot be updated. +optional
        :param pulumi.Input['ProbeArgs'] liveness_probe: Periodic probe of container liveness. Container will be restarted if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional
        :param pulumi.Input[str] name: Name of the container specified as a DNS_LABEL. Each container must have a unique name (DNS_LABEL). Cannot be updated.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerPortArgs']]] ports: List of ports to expose from the container. Exposing a port here gives the system additional information about the network connections a container uses, but is primarily informational. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default "0.0.0.0" address inside a container will be accessible from the network. Cannot be updated. +optional
        :param pulumi.Input['ProbeArgs'] readiness_probe: Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional
        :param pulumi.Input['ResourceRequirementsArgs'] resources: Compute Resources required by this container. Cannot be updated. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources +optional
        :param pulumi.Input['SecurityContextArgs'] security_context: Security options the pod should run with. More info: https://kubernetes.io/docs/concepts/policy/security-context/ More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/ +optional
        :param pulumi.Input[bool] stdin: Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false. +optional
        :param pulumi.Input[bool] stdin_once: Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false +optional
        :param pulumi.Input[str] termination_message_path: Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated. +optional
        :param pulumi.Input[str] termination_message_policy: Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated. +optional
        :param pulumi.Input[bool] tty: Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false. +optional
        :param pulumi.Input[Sequence[pulumi.Input['VolumeDeviceArgs']]] volume_devices: volumeDevices is the list of block devices to be used by the container. This is an alpha feature and may change in the future. +optional
        :param pulumi.Input[Sequence[pulumi.Input['VolumeMountArgs']]] volume_mounts: Pod volumes to mount into the container's filesystem. Cannot be updated. +optional
        :param pulumi.Input[str] working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated. +optional
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if env_from is not None:
            pulumi.set(__self__, "env_from", env_from)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if image_pull_policy is not None:
            pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        if lifecycle is not None:
            pulumi.set(__self__, "lifecycle", lifecycle)
        if liveness_probe is not None:
            pulumi.set(__self__, "liveness_probe", liveness_probe)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if readiness_probe is not None:
            pulumi.set(__self__, "readiness_probe", readiness_probe)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if security_context is not None:
            pulumi.set(__self__, "security_context", security_context)
        if stdin is not None:
            pulumi.set(__self__, "stdin", stdin)
        if stdin_once is not None:
            pulumi.set(__self__, "stdin_once", stdin_once)
        if termination_message_path is not None:
            pulumi.set(__self__, "termination_message_path", termination_message_path)
        if termination_message_policy is not None:
            pulumi.set(__self__, "termination_message_policy", termination_message_policy)
        if tty is not None:
            pulumi.set(__self__, "tty", tty)
        if volume_devices is not None:
            pulumi.set(__self__, "volume_devices", volume_devices)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell +optional
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell +optional
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter
    def env(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvVarArgs']]]]:
        """
        List of environment variables to set in the container. Cannot be updated. +optional
        """
        return pulumi.get(self, "env")

    @env.setter
    def env(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvVarArgs']]]]):
        pulumi.set(self, "env", value)

    @property
    @pulumi.getter(name="envFrom")
    def env_from(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvFromSourceArgs']]]]:
        """
        List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated. +optional
        """
        return pulumi.get(self, "env_from")

    @env_from.setter
    def env_from(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvFromSourceArgs']]]]):
        pulumi.set(self, "env_from", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        Docker image name. More info: https://kubernetes.io/docs/concepts/containers/images
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images +optional
        """
        return pulumi.get(self, "image_pull_policy")

    @image_pull_policy.setter
    def image_pull_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_pull_policy", value)

    @property
    @pulumi.getter
    def lifecycle(self) -> Optional[pulumi.Input['LifecycleArgs']]:
        """
        Actions that the management system should take in response to container lifecycle events. Cannot be updated. +optional
        """
        return pulumi.get(self, "lifecycle")

    @lifecycle.setter
    def lifecycle(self, value: Optional[pulumi.Input['LifecycleArgs']]):
        pulumi.set(self, "lifecycle", value)

    @property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> Optional[pulumi.Input['ProbeArgs']]:
        """
        Periodic probe of container liveness. Container will be restarted if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional
        """
        return pulumi.get(self, "liveness_probe")

    @liveness_probe.setter
    def liveness_probe(self, value: Optional[pulumi.Input['ProbeArgs']]):
        pulumi.set(self, "liveness_probe", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the container specified as a DNS_LABEL. Each container must have a unique name (DNS_LABEL). Cannot be updated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerPortArgs']]]]:
        """
        List of ports to expose from the container. Exposing a port here gives the system additional information about the network connections a container uses, but is primarily informational. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default "0.0.0.0" address inside a container will be accessible from the network. Cannot be updated. +optional
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerPortArgs']]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter(name="readinessProbe")
    def readiness_probe(self) -> Optional[pulumi.Input['ProbeArgs']]:
        """
        Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional
        """
        return pulumi.get(self, "readiness_probe")

    @readiness_probe.setter
    def readiness_probe(self, value: Optional[pulumi.Input['ProbeArgs']]):
        pulumi.set(self, "readiness_probe", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['ResourceRequirementsArgs']]:
        """
        Compute Resources required by this container. Cannot be updated. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources +optional
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['ResourceRequirementsArgs']]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter(name="securityContext")
    def security_context(self) -> Optional[pulumi.Input['SecurityContextArgs']]:
        """
        Security options the pod should run with. More info: https://kubernetes.io/docs/concepts/policy/security-context/ More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/ +optional
        """
        return pulumi.get(self, "security_context")

    @security_context.setter
    def security_context(self, value: Optional[pulumi.Input['SecurityContextArgs']]):
        pulumi.set(self, "security_context", value)

    @property
    @pulumi.getter
    def stdin(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false. +optional
        """
        return pulumi.get(self, "stdin")

    @stdin.setter
    def stdin(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "stdin", value)

    @property
    @pulumi.getter(name="stdinOnce")
    def stdin_once(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false +optional
        """
        return pulumi.get(self, "stdin_once")

    @stdin_once.setter
    def stdin_once(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "stdin_once", value)

    @property
    @pulumi.getter(name="terminationMessagePath")
    def termination_message_path(self) -> Optional[pulumi.Input[str]]:
        """
        Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated. +optional
        """
        return pulumi.get(self, "termination_message_path")

    @termination_message_path.setter
    def termination_message_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "termination_message_path", value)

    @property
    @pulumi.getter(name="terminationMessagePolicy")
    def termination_message_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated. +optional
        """
        return pulumi.get(self, "termination_message_policy")

    @termination_message_policy.setter
    def termination_message_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "termination_message_policy", value)

    @property
    @pulumi.getter
    def tty(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false. +optional
        """
        return pulumi.get(self, "tty")

    @tty.setter
    def tty(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tty", value)

    @property
    @pulumi.getter(name="volumeDevices")
    def volume_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeDeviceArgs']]]]:
        """
        volumeDevices is the list of block devices to be used by the container. This is an alpha feature and may change in the future. +optional
        """
        return pulumi.get(self, "volume_devices")

    @volume_devices.setter
    def volume_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeDeviceArgs']]]]):
        pulumi.set(self, "volume_devices", value)

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeMountArgs']]]]:
        """
        Pod volumes to mount into the container's filesystem. Cannot be updated. +optional
        """
        return pulumi.get(self, "volume_mounts")

    @volume_mounts.setter
    def volume_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeMountArgs']]]]):
        pulumi.set(self, "volume_mounts", value)

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[pulumi.Input[str]]:
        """
        Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated. +optional
        """
        return pulumi.get(self, "working_dir")

    @working_dir.setter
    def working_dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "working_dir", value)


@pulumi.input_type
class ContainerPortArgs:
    def __init__(__self__, *,
                 container_port: Optional[pulumi.Input[int]] = None,
                 host_ip: Optional[pulumi.Input[str]] = None,
                 host_port: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        ContainerPort represents a network port in a single container.
        :param pulumi.Input[int] container_port: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
        :param pulumi.Input[str] host_ip: What host IP to bind the external port to. +optional
        :param pulumi.Input[int] host_port: Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this. +optional
        :param pulumi.Input[str] name: If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services. +optional
        :param pulumi.Input[str] protocol: Protocol for port. Must be UDP or TCP. Defaults to "TCP". +optional
        """
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if host_ip is not None:
            pulumi.set(__self__, "host_ip", host_ip)
        if host_port is not None:
            pulumi.set(__self__, "host_port", host_port)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[pulumi.Input[int]]:
        """
        Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
        """
        return pulumi.get(self, "container_port")

    @container_port.setter
    def container_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "container_port", value)

    @property
    @pulumi.getter(name="hostIP")
    def host_ip(self) -> Optional[pulumi.Input[str]]:
        """
        What host IP to bind the external port to. +optional
        """
        return pulumi.get(self, "host_ip")

    @host_ip.setter
    def host_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_ip", value)

    @property
    @pulumi.getter(name="hostPort")
    def host_port(self) -> Optional[pulumi.Input[int]]:
        """
        Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this. +optional
        """
        return pulumi.get(self, "host_port")

    @host_port.setter
    def host_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "host_port", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services. +optional
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Protocol for port. Must be UDP or TCP. Defaults to "TCP". +optional
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class DomainMappingConditionArgs:
    def __init__(__self__, *,
                 last_transition_time: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None,
                 severity: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        DomainMappingCondition contains state information for a DomainMapping.
        :param pulumi.Input[str] last_transition_time: Last time the condition transitioned from one status to another. +optional
        :param pulumi.Input[str] message: Human readable message indicating details about the current status. +optional
        :param pulumi.Input[str] reason: One-word CamelCase reason for the condition's current status. +optional
        :param pulumi.Input[str] severity: How to interpret failures of this condition, one of Error, Warning, Info +optional
        :param pulumi.Input[str] status: Status of the condition, one of True, False, Unknown.
        :param pulumi.Input[str] type: Type of domain mapping condition.
        """
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[pulumi.Input[str]]:
        """
        Last time the condition transitioned from one status to another. +optional
        """
        return pulumi.get(self, "last_transition_time")

    @last_transition_time.setter
    def last_transition_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_transition_time", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Human readable message indicating details about the current status. +optional
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        One-word CamelCase reason for the condition's current status. +optional
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[str]]:
        """
        How to interpret failures of this condition, one of Error, Warning, Info +optional
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of domain mapping condition.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class DomainMappingSpecArgs:
    def __init__(__self__, *,
                 certificate_mode: Optional[pulumi.Input[str]] = None,
                 force_override: Optional[pulumi.Input[bool]] = None,
                 route_name: Optional[pulumi.Input[str]] = None):
        """
        The desired state of the Domain Mapping.
        :param pulumi.Input[str] certificate_mode: The mode of the certificate.
        :param pulumi.Input[bool] force_override: If set, the mapping will override any mapping set before this spec was set. It is recommended that the user leaves this empty to receive an error warning about a potential conflict and only set it once the respective UI has given such a warning.
        :param pulumi.Input[str] route_name: The name of the Knative Route that this DomainMapping applies to. The route must exist.
        """
        if certificate_mode is not None:
            pulumi.set(__self__, "certificate_mode", certificate_mode)
        if force_override is not None:
            pulumi.set(__self__, "force_override", force_override)
        if route_name is not None:
            pulumi.set(__self__, "route_name", route_name)

    @property
    @pulumi.getter(name="certificateMode")
    def certificate_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The mode of the certificate.
        """
        return pulumi.get(self, "certificate_mode")

    @certificate_mode.setter
    def certificate_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_mode", value)

    @property
    @pulumi.getter(name="forceOverride")
    def force_override(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, the mapping will override any mapping set before this spec was set. It is recommended that the user leaves this empty to receive an error warning about a potential conflict and only set it once the respective UI has given such a warning.
        """
        return pulumi.get(self, "force_override")

    @force_override.setter
    def force_override(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_override", value)

    @property
    @pulumi.getter(name="routeName")
    def route_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Knative Route that this DomainMapping applies to. The route must exist.
        """
        return pulumi.get(self, "route_name")

    @route_name.setter
    def route_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "route_name", value)


@pulumi.input_type
class DomainMappingStatusArgs:
    def __init__(__self__, *,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['DomainMappingConditionArgs']]]] = None,
                 mapped_route_name: Optional[pulumi.Input[str]] = None,
                 observed_generation: Optional[pulumi.Input[int]] = None,
                 resource_records: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceRecordArgs']]]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        The current state of the Domain Mapping.
        :param pulumi.Input[Sequence[pulumi.Input['DomainMappingConditionArgs']]] conditions: Array of observed DomainMappingConditions, indicating the current state of the DomainMapping.
        :param pulumi.Input[str] mapped_route_name: The name of the route that the mapping currently points to.
        :param pulumi.Input[int] observed_generation: ObservedGeneration is the 'Generation' of the DomainMapping that was last processed by the controller. Clients polling for completed reconciliation should poll until observedGeneration = metadata.generation and the Ready condition's status is True or False.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceRecordArgs']]] resource_records: The resource records required to configure this domain mapping. These records must be added to the domain's DNS configuration in order to serve the application via this domain mapping.
        :param pulumi.Input[str] url: Cloud Run fully managed: not supported Cloud Run on GKE: supported Holds the URL that will serve the traffic of the DomainMapping. +optional
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if mapped_route_name is not None:
            pulumi.set(__self__, "mapped_route_name", mapped_route_name)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if resource_records is not None:
            pulumi.set(__self__, "resource_records", resource_records)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainMappingConditionArgs']]]]:
        """
        Array of observed DomainMappingConditions, indicating the current state of the DomainMapping.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainMappingConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="mappedRouteName")
    def mapped_route_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the route that the mapping currently points to.
        """
        return pulumi.get(self, "mapped_route_name")

    @mapped_route_name.setter
    def mapped_route_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mapped_route_name", value)

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[pulumi.Input[int]]:
        """
        ObservedGeneration is the 'Generation' of the DomainMapping that was last processed by the controller. Clients polling for completed reconciliation should poll until observedGeneration = metadata.generation and the Ready condition's status is True or False.
        """
        return pulumi.get(self, "observed_generation")

    @observed_generation.setter
    def observed_generation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "observed_generation", value)

    @property
    @pulumi.getter(name="resourceRecords")
    def resource_records(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceRecordArgs']]]]:
        """
        The resource records required to configure this domain mapping. These records must be added to the domain's DNS configuration in order to serve the application via this domain mapping.
        """
        return pulumi.get(self, "resource_records")

    @resource_records.setter
    def resource_records(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceRecordArgs']]]]):
        pulumi.set(self, "resource_records", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported Holds the URL that will serve the traffic of the DomainMapping. +optional
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class EnvFromSourceArgs:
    def __init__(__self__, *,
                 config_map_ref: Optional[pulumi.Input['ConfigMapEnvSourceArgs']] = None,
                 prefix: Optional[pulumi.Input[str]] = None,
                 secret_ref: Optional[pulumi.Input['SecretEnvSourceArgs']] = None):
        """
        EnvFromSource represents the source of a set of ConfigMaps
        :param pulumi.Input['ConfigMapEnvSourceArgs'] config_map_ref: The ConfigMap to select from +optional
        :param pulumi.Input[str] prefix: An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER. +optional
        :param pulumi.Input['SecretEnvSourceArgs'] secret_ref: The Secret to select from +optional
        """
        if config_map_ref is not None:
            pulumi.set(__self__, "config_map_ref", config_map_ref)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)

    @property
    @pulumi.getter(name="configMapRef")
    def config_map_ref(self) -> Optional[pulumi.Input['ConfigMapEnvSourceArgs']]:
        """
        The ConfigMap to select from +optional
        """
        return pulumi.get(self, "config_map_ref")

    @config_map_ref.setter
    def config_map_ref(self, value: Optional[pulumi.Input['ConfigMapEnvSourceArgs']]):
        pulumi.set(self, "config_map_ref", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER. +optional
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[pulumi.Input['SecretEnvSourceArgs']]:
        """
        The Secret to select from +optional
        """
        return pulumi.get(self, "secret_ref")

    @secret_ref.setter
    def secret_ref(self, value: Optional[pulumi.Input['SecretEnvSourceArgs']]):
        pulumi.set(self, "secret_ref", value)


@pulumi.input_type
class EnvVarArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 value_from: Optional[pulumi.Input['EnvVarSourceArgs']] = None):
        """
        EnvVar represents an environment variable present in a Container.
        :param pulumi.Input[str] name: Name of the environment variable. Must be a C_IDENTIFIER.
        :param pulumi.Input[str] value: Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any route environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "". +optional
        :param pulumi.Input['EnvVarSourceArgs'] value_from: Cloud Run fully managed: not supported Cloud Run on GKE: supported Source for the environment variable's value. Cannot be used if value is not empty. +optional
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_from is not None:
            pulumi.set(__self__, "value_from", value_from)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the environment variable. Must be a C_IDENTIFIER.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any route environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "". +optional
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="valueFrom")
    def value_from(self) -> Optional[pulumi.Input['EnvVarSourceArgs']]:
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported Source for the environment variable's value. Cannot be used if value is not empty. +optional
        """
        return pulumi.get(self, "value_from")

    @value_from.setter
    def value_from(self, value: Optional[pulumi.Input['EnvVarSourceArgs']]):
        pulumi.set(self, "value_from", value)


@pulumi.input_type
class EnvVarSourceArgs:
    def __init__(__self__, *,
                 config_map_key_ref: Optional[pulumi.Input['ConfigMapKeySelectorArgs']] = None,
                 secret_key_ref: Optional[pulumi.Input['SecretKeySelectorArgs']] = None):
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported EnvVarSource represents a source for the value of an EnvVar.
        :param pulumi.Input['ConfigMapKeySelectorArgs'] config_map_key_ref: Cloud Run fully managed: not supported Cloud Run on GKE: supported Selects a key of a ConfigMap. +optional
        :param pulumi.Input['SecretKeySelectorArgs'] secret_key_ref: Cloud Run fully managed: not supported Cloud Run on GKE: supported Selects a key of a secret in the pod's namespace +optional
        """
        if config_map_key_ref is not None:
            pulumi.set(__self__, "config_map_key_ref", config_map_key_ref)
        if secret_key_ref is not None:
            pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="configMapKeyRef")
    def config_map_key_ref(self) -> Optional[pulumi.Input['ConfigMapKeySelectorArgs']]:
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported Selects a key of a ConfigMap. +optional
        """
        return pulumi.get(self, "config_map_key_ref")

    @config_map_key_ref.setter
    def config_map_key_ref(self, value: Optional[pulumi.Input['ConfigMapKeySelectorArgs']]):
        pulumi.set(self, "config_map_key_ref", value)

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> Optional[pulumi.Input['SecretKeySelectorArgs']]:
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported Selects a key of a secret in the pod's namespace +optional
        """
        return pulumi.get(self, "secret_key_ref")

    @secret_key_ref.setter
    def secret_key_ref(self, value: Optional[pulumi.Input['SecretKeySelectorArgs']]):
        pulumi.set(self, "secret_key_ref", value)


@pulumi.input_type
class ExecActionArgs:
    def __init__(__self__, *,
                 command: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        ExecAction describes a "run in container" action.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] command: Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy. +optional
        """
        if command is not None:
            pulumi.set(__self__, "command", command)

    @property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy. +optional
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "command", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class HTTPGetActionArgs:
    def __init__(__self__, *,
                 host: Optional[pulumi.Input[str]] = None,
                 http_headers: Optional[pulumi.Input[Sequence[pulumi.Input['HTTPHeaderArgs']]]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input['IntOrStringArgs']] = None,
                 scheme: Optional[pulumi.Input[str]] = None):
        """
        HTTPGetAction describes an action based on HTTP Get requests.
        :param pulumi.Input[str] host: Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead. +optional
        :param pulumi.Input[Sequence[pulumi.Input['HTTPHeaderArgs']]] http_headers: Custom headers to set in the request. HTTP allows repeated headers. +optional
        :param pulumi.Input[str] path: Path to access on the HTTP server. +optional
        :param pulumi.Input['IntOrStringArgs'] port: Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        :param pulumi.Input[str] scheme: Scheme to use for connecting to the host. Defaults to HTTP. +optional
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead. +optional
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HTTPHeaderArgs']]]]:
        """
        Custom headers to set in the request. HTTP allows repeated headers. +optional
        """
        return pulumi.get(self, "http_headers")

    @http_headers.setter
    def http_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HTTPHeaderArgs']]]]):
        pulumi.set(self, "http_headers", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to access on the HTTP server. +optional
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input['IntOrStringArgs']]:
        """
        Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input['IntOrStringArgs']]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def scheme(self) -> Optional[pulumi.Input[str]]:
        """
        Scheme to use for connecting to the host. Defaults to HTTP. +optional
        """
        return pulumi.get(self, "scheme")

    @scheme.setter
    def scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheme", value)


@pulumi.input_type
class HTTPHeaderArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        HTTPHeader describes a custom header to be used in HTTP probes
        :param pulumi.Input[str] name: The header field name
        :param pulumi.Input[str] value: The header field value
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The header field name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The header field value
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class HandlerArgs:
    def __init__(__self__, *,
                 exec_: Optional[pulumi.Input['ExecActionArgs']] = None,
                 http_get: Optional[pulumi.Input['HTTPGetActionArgs']] = None,
                 tcp_socket: Optional[pulumi.Input['TCPSocketActionArgs']] = None):
        """
        Handler defines a specific action that should be taken
        :param pulumi.Input['ExecActionArgs'] exec_: One and only one of the following should be specified. Exec specifies the action to take. +optional
        :param pulumi.Input['HTTPGetActionArgs'] http_get: HTTPGet specifies the http request to perform. +optional
        :param pulumi.Input['TCPSocketActionArgs'] tcp_socket: TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported
        """
        if exec_ is not None:
            pulumi.set(__self__, "exec_", exec_)
        if http_get is not None:
            pulumi.set(__self__, "http_get", http_get)
        if tcp_socket is not None:
            pulumi.set(__self__, "tcp_socket", tcp_socket)

    @property
    @pulumi.getter(name="exec")
    def exec_(self) -> Optional[pulumi.Input['ExecActionArgs']]:
        """
        One and only one of the following should be specified. Exec specifies the action to take. +optional
        """
        return pulumi.get(self, "exec_")

    @exec_.setter
    def exec_(self, value: Optional[pulumi.Input['ExecActionArgs']]):
        pulumi.set(self, "exec_", value)

    @property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> Optional[pulumi.Input['HTTPGetActionArgs']]:
        """
        HTTPGet specifies the http request to perform. +optional
        """
        return pulumi.get(self, "http_get")

    @http_get.setter
    def http_get(self, value: Optional[pulumi.Input['HTTPGetActionArgs']]):
        pulumi.set(self, "http_get", value)

    @property
    @pulumi.getter(name="tcpSocket")
    def tcp_socket(self) -> Optional[pulumi.Input['TCPSocketActionArgs']]:
        """
        TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported
        """
        return pulumi.get(self, "tcp_socket")

    @tcp_socket.setter
    def tcp_socket(self, value: Optional[pulumi.Input['TCPSocketActionArgs']]):
        pulumi.set(self, "tcp_socket", value)


@pulumi.input_type
class InstanceSpecArgs:
    def __init__(__self__, *,
                 active_deadline_seconds: Optional[pulumi.Input[str]] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerArgs']]]] = None,
                 restart_policy: Optional[pulumi.Input[str]] = None,
                 service_account_name: Optional[pulumi.Input[str]] = None,
                 termination_grace_period_seconds: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]]] = None):
        """
        InstanceSpec is a description of an instance.
        :param pulumi.Input[str] active_deadline_seconds: Optional. Optional duration in seconds the instance may be active relative to StartTime before the system will actively try to mark it failed and kill associated containers. If set to zero, the system will never attempt to kill an instance based on time. Otherwise, value must be a positive integer. +optional
        :param pulumi.Input[Sequence[pulumi.Input['ContainerArgs']]] containers: Optional. List of containers belonging to the instance. We disallow a number of fields on this Container. Only a single container may be provided.
        :param pulumi.Input[str] restart_policy: Optional. Restart policy for all containers within the instance. Allowed values are: - OnFailure: Instances will always be restarted on failure if the backoffLimit has not been reached. - Never: Instances are never restarted and all failures are permanent. Cannot be used if backoffLimit is set. +optional
        :param pulumi.Input[str] service_account_name: Optional. Email address of the IAM service account associated with the instance of a Job. The service account represents the identity of the running instance, and determines what permissions the instance has. If not provided, the instance will use the project's default service account. +optional
        :param pulumi.Input[str] termination_grace_period_seconds: Optional. Optional duration in seconds the instance needs to terminate gracefully. Value must be non-negative integer. The value zero indicates delete immediately. The grace period is the duration in seconds after the processes running in the instance are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. +optional
        :param pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]] volumes: Optional. List of volumes that can be mounted by containers belonging to the instance. More info: https://kubernetes.io/docs/concepts/storage/volumes +optional
        """
        if active_deadline_seconds is not None:
            pulumi.set(__self__, "active_deadline_seconds", active_deadline_seconds)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if restart_policy is not None:
            pulumi.set(__self__, "restart_policy", restart_policy)
        if service_account_name is not None:
            pulumi.set(__self__, "service_account_name", service_account_name)
        if termination_grace_period_seconds is not None:
            pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="activeDeadlineSeconds")
    def active_deadline_seconds(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Optional duration in seconds the instance may be active relative to StartTime before the system will actively try to mark it failed and kill associated containers. If set to zero, the system will never attempt to kill an instance based on time. Otherwise, value must be a positive integer. +optional
        """
        return pulumi.get(self, "active_deadline_seconds")

    @active_deadline_seconds.setter
    def active_deadline_seconds(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "active_deadline_seconds", value)

    @property
    @pulumi.getter
    def containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerArgs']]]]:
        """
        Optional. List of containers belonging to the instance. We disallow a number of fields on this Container. Only a single container may be provided.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerArgs']]]]):
        pulumi.set(self, "containers", value)

    @property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Restart policy for all containers within the instance. Allowed values are: - OnFailure: Instances will always be restarted on failure if the backoffLimit has not been reached. - Never: Instances are never restarted and all failures are permanent. Cannot be used if backoffLimit is set. +optional
        """
        return pulumi.get(self, "restart_policy")

    @restart_policy.setter
    def restart_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restart_policy", value)

    @property
    @pulumi.getter(name="serviceAccountName")
    def service_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Email address of the IAM service account associated with the instance of a Job. The service account represents the identity of the running instance, and determines what permissions the instance has. If not provided, the instance will use the project's default service account. +optional
        """
        return pulumi.get(self, "service_account_name")

    @service_account_name.setter
    def service_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_name", value)

    @property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Optional duration in seconds the instance needs to terminate gracefully. Value must be non-negative integer. The value zero indicates delete immediately. The grace period is the duration in seconds after the processes running in the instance are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. +optional
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @termination_grace_period_seconds.setter
    def termination_grace_period_seconds(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "termination_grace_period_seconds", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]]]:
        """
        Optional. List of volumes that can be mounted by containers belonging to the instance. More info: https://kubernetes.io/docs/concepts/storage/volumes +optional
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


@pulumi.input_type
class InstanceStatusArgs:
    def __init__(__self__, *,
                 completion_time: Optional[pulumi.Input[str]] = None,
                 failed: Optional[pulumi.Input[int]] = None,
                 index: Optional[pulumi.Input[int]] = None,
                 last_exit_code: Optional[pulumi.Input[int]] = None,
                 restarted: Optional[pulumi.Input[int]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 succeeded: Optional[pulumi.Input[int]] = None):
        """
        Instance represents the status of an instance of a Job.
        :param pulumi.Input[str] completion_time: Optional. Represents time when the instance was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        :param pulumi.Input[int] failed: Optional. The number of times this instance exited with code > 0; +optional
        :param pulumi.Input[int] index: Required. Index of the instance, unique per Job, and beginning at 0.
        :param pulumi.Input[int] last_exit_code: Optional. Last exit code seen for this instance. +optional
        :param pulumi.Input[int] restarted: Optional. The number of times this instance was restarted. Instances are restarted according the restartPolicy configured in the Job template. +optional
        :param pulumi.Input[str] start_time: Optional. Represents time when the instance was created by the job controller. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        :param pulumi.Input[int] succeeded: Optional. The number of times this instance exited with code == 0. +optional
        """
        if completion_time is not None:
            pulumi.set(__self__, "completion_time", completion_time)
        if failed is not None:
            pulumi.set(__self__, "failed", failed)
        if index is not None:
            pulumi.set(__self__, "index", index)
        if last_exit_code is not None:
            pulumi.set(__self__, "last_exit_code", last_exit_code)
        if restarted is not None:
            pulumi.set(__self__, "restarted", restarted)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if succeeded is not None:
            pulumi.set(__self__, "succeeded", succeeded)

    @property
    @pulumi.getter(name="completionTime")
    def completion_time(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Represents time when the instance was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        """
        return pulumi.get(self, "completion_time")

    @completion_time.setter
    def completion_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "completion_time", value)

    @property
    @pulumi.getter
    def failed(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The number of times this instance exited with code > 0; +optional
        """
        return pulumi.get(self, "failed")

    @failed.setter
    def failed(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failed", value)

    @property
    @pulumi.getter
    def index(self) -> Optional[pulumi.Input[int]]:
        """
        Required. Index of the instance, unique per Job, and beginning at 0.
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "index", value)

    @property
    @pulumi.getter(name="lastExitCode")
    def last_exit_code(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Last exit code seen for this instance. +optional
        """
        return pulumi.get(self, "last_exit_code")

    @last_exit_code.setter
    def last_exit_code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "last_exit_code", value)

    @property
    @pulumi.getter
    def restarted(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The number of times this instance was restarted. Instances are restarted according the restartPolicy configured in the Job template. +optional
        """
        return pulumi.get(self, "restarted")

    @restarted.setter
    def restarted(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "restarted", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Represents time when the instance was created by the job controller. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def succeeded(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The number of times this instance exited with code == 0. +optional
        """
        return pulumi.get(self, "succeeded")

    @succeeded.setter
    def succeeded(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "succeeded", value)


@pulumi.input_type
class InstanceTemplateSpecArgs:
    def __init__(__self__, *,
                 spec: Optional[pulumi.Input['InstanceSpecArgs']] = None):
        """
        InstanceTemplateSpec describes the data an instance should have when created from a template.
        :param pulumi.Input['InstanceSpecArgs'] spec: Optional. Specification of the desired behavior of the instance. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status +optional
        """
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['InstanceSpecArgs']]:
        """
        Optional. Specification of the desired behavior of the instance. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status +optional
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['InstanceSpecArgs']]):
        pulumi.set(self, "spec", value)


@pulumi.input_type
class IntOrStringArgs:
    def __init__(__self__, *,
                 int_val: Optional[pulumi.Input[int]] = None,
                 str_val: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[int]] = None):
        """
        IntOrString is a type that can hold an int32 or a string. When used in JSON or YAML marshalling and unmarshalling, it produces or consumes the inner type. This allows you to have, for example, a JSON field that can accept a name or number.
        :param pulumi.Input[int] int_val: The int value.
        :param pulumi.Input[str] str_val: The string value.
        :param pulumi.Input[int] type: The type of the value.
        """
        if int_val is not None:
            pulumi.set(__self__, "int_val", int_val)
        if str_val is not None:
            pulumi.set(__self__, "str_val", str_val)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="intVal")
    def int_val(self) -> Optional[pulumi.Input[int]]:
        """
        The int value.
        """
        return pulumi.get(self, "int_val")

    @int_val.setter
    def int_val(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "int_val", value)

    @property
    @pulumi.getter(name="strVal")
    def str_val(self) -> Optional[pulumi.Input[str]]:
        """
        The string value.
        """
        return pulumi.get(self, "str_val")

    @str_val.setter
    def str_val(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "str_val", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[int]]:
        """
        The type of the value.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class JobConditionArgs:
    def __init__(__self__, *,
                 last_transition_time: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None,
                 severity: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        JobCondition defines a readiness condition for a Revision.
        :param pulumi.Input[str] last_transition_time: Optional. Last time the condition transitioned from one status to another.
        :param pulumi.Input[str] message: Optional. Human readable message indicating details about the current status.
        :param pulumi.Input[str] reason: Optional. One-word CamelCase reason for the condition's last transition.
        :param pulumi.Input[str] severity: Optional. How to interpret failures of this condition, one of Error, Warning, Info
        :param pulumi.Input[str] status: Required. Status of the condition, one of True, False, Unknown.
        :param pulumi.Input[str] type: Required. Type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/master/docs/spec/errors.md#error-conditions-and-reporting Types include: * "Completed": True when the Job has successfully completed. * "Started": True when the Job has successfully started running. * "ResourcesAvailable": True when underlying resources have been provisioned.
        """
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @last_transition_time.setter
    def last_transition_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_transition_time", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. One-word CamelCase reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/master/docs/spec/errors.md#error-conditions-and-reporting Types include: * "Completed": True when the Job has successfully completed. * "Started": True when the Job has successfully started running. * "ResourcesAvailable": True when underlying resources have been provisioned.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class JobSpecArgs:
    def __init__(__self__, *,
                 active_deadline_seconds: Optional[pulumi.Input[str]] = None,
                 backoff_limit: Optional[pulumi.Input[int]] = None,
                 completions: Optional[pulumi.Input[int]] = None,
                 parallelism: Optional[pulumi.Input[int]] = None,
                 template: Optional[pulumi.Input['InstanceTemplateSpecArgs']] = None,
                 ttl_seconds_after_finished: Optional[pulumi.Input[int]] = None):
        """
        JobSpec describes how the job execution will look like.
        :param pulumi.Input[str] active_deadline_seconds: Optional. Specifies the duration in seconds relative to the startTime that the job may be active before the system tries to terminate it. If set to zero, the system will never attempt to terminate the job based on time. Otherwise, the value must be positive integer. +optional
        :param pulumi.Input[int] backoff_limit: Optional. Specifies the number of retries per instance, before marking this job failed. If set to zero, instances will never retry on failure. +optional
        :param pulumi.Input[int] completions: Optional. Specifies the desired number of successfully finished instances the job should be run with. Setting to 1 means that parallelism is limited to 1 and the success of that instance signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/ +optional
        :param pulumi.Input[int] parallelism: Optional. Specifies the maximum desired number of instances the job should run at any given time. Must be <= completions. The actual number of instances running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/ +optional
        :param pulumi.Input['InstanceTemplateSpecArgs'] template: Optional. Describes the instance that will be created when executing a job.
        :param pulumi.Input[int] ttl_seconds_after_finished: Optional. ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is set to zero, the Job won't be automatically deleted. +optional
        """
        if active_deadline_seconds is not None:
            pulumi.set(__self__, "active_deadline_seconds", active_deadline_seconds)
        if backoff_limit is not None:
            pulumi.set(__self__, "backoff_limit", backoff_limit)
        if completions is not None:
            pulumi.set(__self__, "completions", completions)
        if parallelism is not None:
            pulumi.set(__self__, "parallelism", parallelism)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if ttl_seconds_after_finished is not None:
            pulumi.set(__self__, "ttl_seconds_after_finished", ttl_seconds_after_finished)

    @property
    @pulumi.getter(name="activeDeadlineSeconds")
    def active_deadline_seconds(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Specifies the duration in seconds relative to the startTime that the job may be active before the system tries to terminate it. If set to zero, the system will never attempt to terminate the job based on time. Otherwise, the value must be positive integer. +optional
        """
        return pulumi.get(self, "active_deadline_seconds")

    @active_deadline_seconds.setter
    def active_deadline_seconds(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "active_deadline_seconds", value)

    @property
    @pulumi.getter(name="backoffLimit")
    def backoff_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Specifies the number of retries per instance, before marking this job failed. If set to zero, instances will never retry on failure. +optional
        """
        return pulumi.get(self, "backoff_limit")

    @backoff_limit.setter
    def backoff_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backoff_limit", value)

    @property
    @pulumi.getter
    def completions(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Specifies the desired number of successfully finished instances the job should be run with. Setting to 1 means that parallelism is limited to 1 and the success of that instance signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/ +optional
        """
        return pulumi.get(self, "completions")

    @completions.setter
    def completions(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "completions", value)

    @property
    @pulumi.getter
    def parallelism(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Specifies the maximum desired number of instances the job should run at any given time. Must be <= completions. The actual number of instances running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/ +optional
        """
        return pulumi.get(self, "parallelism")

    @parallelism.setter
    def parallelism(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "parallelism", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['InstanceTemplateSpecArgs']]:
        """
        Optional. Describes the instance that will be created when executing a job.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['InstanceTemplateSpecArgs']]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter(name="ttlSecondsAfterFinished")
    def ttl_seconds_after_finished(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is set to zero, the Job won't be automatically deleted. +optional
        """
        return pulumi.get(self, "ttl_seconds_after_finished")

    @ttl_seconds_after_finished.setter
    def ttl_seconds_after_finished(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl_seconds_after_finished", value)


@pulumi.input_type
class JobStatusArgs:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[int]] = None,
                 completion_time: Optional[pulumi.Input[str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['JobConditionArgs']]]] = None,
                 failed: Optional[pulumi.Input[int]] = None,
                 image_digest: Optional[pulumi.Input[str]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceStatusArgs']]]] = None,
                 observed_generation: Optional[pulumi.Input[int]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 succeeded: Optional[pulumi.Input[int]] = None):
        """
        JobStatus represents the current state of a Job.
        :param pulumi.Input[int] active: Optional. The number of actively running instances. +optional
        :param pulumi.Input[str] completion_time: Optional. Represents time when the job was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        :param pulumi.Input[Sequence[pulumi.Input['JobConditionArgs']]] conditions: Optional. The latest available observations of a job's current state. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/ +optional
        :param pulumi.Input[int] failed: Optional. The number of instances which reached phase Failed. +optional
        :param pulumi.Input[str] image_digest: Optional. ImageDigest holds the resolved digest for the image specified within .Spec.Template.Spec.Container.Image. The digest is resolved during the creation of the Job. This field holds the digest value regardless of whether a tag or digest was originally specified in the Container object.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceStatusArgs']]] instances: Optional. Status of completed, failed, and running instances. +optional
        :param pulumi.Input[int] observed_generation: Optional. The 'generation' of the job that was last processed by the controller.
        :param pulumi.Input[str] start_time: Optional. Represents time when the job was acknowledged by the job controller. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        :param pulumi.Input[int] succeeded: Optional. The number of instances which reached phase Succeeded. +optional
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if completion_time is not None:
            pulumi.set(__self__, "completion_time", completion_time)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if failed is not None:
            pulumi.set(__self__, "failed", failed)
        if image_digest is not None:
            pulumi.set(__self__, "image_digest", image_digest)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if succeeded is not None:
            pulumi.set(__self__, "succeeded", succeeded)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The number of actively running instances. +optional
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="completionTime")
    def completion_time(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Represents time when the job was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        """
        return pulumi.get(self, "completion_time")

    @completion_time.setter
    def completion_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "completion_time", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobConditionArgs']]]]:
        """
        Optional. The latest available observations of a job's current state. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/ +optional
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def failed(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The number of instances which reached phase Failed. +optional
        """
        return pulumi.get(self, "failed")

    @failed.setter
    def failed(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failed", value)

    @property
    @pulumi.getter(name="imageDigest")
    def image_digest(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. ImageDigest holds the resolved digest for the image specified within .Spec.Template.Spec.Container.Image. The digest is resolved during the creation of the Job. This field holds the digest value regardless of whether a tag or digest was originally specified in the Container object.
        """
        return pulumi.get(self, "image_digest")

    @image_digest.setter
    def image_digest(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_digest", value)

    @property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceStatusArgs']]]]:
        """
        Optional. Status of completed, failed, and running instances. +optional
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceStatusArgs']]]]):
        pulumi.set(self, "instances", value)

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The 'generation' of the job that was last processed by the controller.
        """
        return pulumi.get(self, "observed_generation")

    @observed_generation.setter
    def observed_generation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "observed_generation", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Represents time when the job was acknowledged by the job controller. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def succeeded(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The number of instances which reached phase Succeeded. +optional
        """
        return pulumi.get(self, "succeeded")

    @succeeded.setter
    def succeeded(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "succeeded", value)


@pulumi.input_type
class KeyToPathArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[int]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        Maps a string key to a path within a volume.
        :param pulumi.Input[str] key: The key to project.
        :param pulumi.Input[int] mode: Mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. +optional
        :param pulumi.Input[str] path: The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The key to project.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[int]]:
        """
        Mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. +optional
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class LifecycleArgs:
    def __init__(__self__, *,
                 post_start: Optional[pulumi.Input['HandlerArgs']] = None,
                 pre_stop: Optional[pulumi.Input['HandlerArgs']] = None):
        """
        Lifecycle describes actions that the management system should take in response to container lifecycle events. For the PostStart and PreStop lifecycle handlers, management of the container blocks until the action is complete, unless the container process fails, in which case the handler is aborted.
        :param pulumi.Input['HandlerArgs'] post_start: PostStart is called immediately after a container is created. If the handler fails, the container is terminated and restarted according to its restart policy. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks +optional
        :param pulumi.Input['HandlerArgs'] pre_stop: PreStop is called immediately before a container is terminated. The container is terminated after the handler completes. The reason for termination is passed to the handler. Regardless of the outcome of the handler, the container is eventually terminated. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks +optional
        """
        if post_start is not None:
            pulumi.set(__self__, "post_start", post_start)
        if pre_stop is not None:
            pulumi.set(__self__, "pre_stop", pre_stop)

    @property
    @pulumi.getter(name="postStart")
    def post_start(self) -> Optional[pulumi.Input['HandlerArgs']]:
        """
        PostStart is called immediately after a container is created. If the handler fails, the container is terminated and restarted according to its restart policy. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks +optional
        """
        return pulumi.get(self, "post_start")

    @post_start.setter
    def post_start(self, value: Optional[pulumi.Input['HandlerArgs']]):
        pulumi.set(self, "post_start", value)

    @property
    @pulumi.getter(name="preStop")
    def pre_stop(self) -> Optional[pulumi.Input['HandlerArgs']]:
        """
        PreStop is called immediately before a container is terminated. The container is terminated after the handler completes. The reason for termination is passed to the handler. Regardless of the outcome of the handler, the container is eventually terminated. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks +optional
        """
        return pulumi.get(self, "pre_stop")

    @pre_stop.setter
    def pre_stop(self, value: Optional[pulumi.Input['HandlerArgs']]):
        pulumi.set(self, "pre_stop", value)


@pulumi.input_type
class LocalObjectReferenceArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace.
        :param pulumi.Input[str] name: Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ObjectMetaArgs:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 creation_timestamp: Optional[pulumi.Input[str]] = None,
                 deletion_grace_period_seconds: Optional[pulumi.Input[int]] = None,
                 deletion_timestamp: Optional[pulumi.Input[str]] = None,
                 finalizers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 generate_name: Optional[pulumi.Input[str]] = None,
                 generation: Optional[pulumi.Input[int]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 owner_references: Optional[pulumi.Input[Sequence[pulumi.Input['OwnerReferenceArgs']]]] = None,
                 resource_version: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations +optional
        :param pulumi.Input[str] cluster_name: Not currently supported by Cloud Run. The name of the cluster which the object belongs to. This is used to distinguish resources with same name and namespace in different clusters. This field is not set anywhere right now and apiserver is going to ignore it if set in create or update request. +optional
        :param pulumi.Input[str] creation_timestamp: CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC. Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata +optional
        :param pulumi.Input[int] deletion_grace_period_seconds: Not currently supported by Cloud Run. Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only. +optional
        :param pulumi.Input[str] deletion_timestamp: DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested. Populated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata +optional
        :param pulumi.Input[Sequence[pulumi.Input[str]]] finalizers: Not currently supported by Cloud Run. Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. +optional +patchStrategy=merge
        :param pulumi.Input[str] generate_name: Not currently supported by Cloud Run. GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server. If this field is specified and the generated name exists, the server will NOT return a 409 - instead, it will either return 201 Created or 500 with Reason ServerTimeout indicating a unique name could not be found in the time allotted, and the client should retry (optionally after the time indicated in the Retry-After header). Applied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#idempotency +optional string generateName = 2;
        :param pulumi.Input[int] generation: A sequence number representing a specific generation of the desired state. Populated by the system. Read-only. +optional
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and routes. More info: http://kubernetes.io/docs/user-guide/labels +optional
        :param pulumi.Input[str] name: Name must be unique within a namespace, within a Cloud Run region. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names +optional
        :param pulumi.Input[str] namespace: Namespace defines the space within each name must be unique, within a Cloud Run region. In Cloud Run the namespace must be equal to either the project ID or project number.
        :param pulumi.Input[Sequence[pulumi.Input['OwnerReferenceArgs']]] owner_references: List of objects that own this object. If ALL objects in the list have been deleted, this object will be garbage collected. +optional
        :param pulumi.Input[str] resource_version: An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources. Populated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency +optional
        :param pulumi.Input[str] self_link: SelfLink is a URL representing this object. Populated by the system. Read-only. +optional string selfLink = 4;
        :param pulumi.Input[str] uid: UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations. Populated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids +optional
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if deletion_grace_period_seconds is not None:
            pulumi.set(__self__, "deletion_grace_period_seconds", deletion_grace_period_seconds)
        if deletion_timestamp is not None:
            pulumi.set(__self__, "deletion_timestamp", deletion_timestamp)
        if finalizers is not None:
            pulumi.set(__self__, "finalizers", finalizers)
        if generate_name is not None:
            pulumi.set(__self__, "generate_name", generate_name)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if owner_references is not None:
            pulumi.set(__self__, "owner_references", owner_references)
        if resource_version is not None:
            pulumi.set(__self__, "resource_version", resource_version)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations +optional
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        Not currently supported by Cloud Run. The name of the cluster which the object belongs to. This is used to distinguish resources with same name and namespace in different clusters. This field is not set anywhere right now and apiserver is going to ignore it if set in create or update request. +optional
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC. Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata +optional
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter(name="deletionGracePeriodSeconds")
    def deletion_grace_period_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Not currently supported by Cloud Run. Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only. +optional
        """
        return pulumi.get(self, "deletion_grace_period_seconds")

    @deletion_grace_period_seconds.setter
    def deletion_grace_period_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "deletion_grace_period_seconds", value)

    @property
    @pulumi.getter(name="deletionTimestamp")
    def deletion_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested. Populated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata +optional
        """
        return pulumi.get(self, "deletion_timestamp")

    @deletion_timestamp.setter
    def deletion_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deletion_timestamp", value)

    @property
    @pulumi.getter
    def finalizers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Not currently supported by Cloud Run. Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. +optional +patchStrategy=merge
        """
        return pulumi.get(self, "finalizers")

    @finalizers.setter
    def finalizers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "finalizers", value)

    @property
    @pulumi.getter(name="generateName")
    def generate_name(self) -> Optional[pulumi.Input[str]]:
        """
        Not currently supported by Cloud Run. GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server. If this field is specified and the generated name exists, the server will NOT return a 409 - instead, it will either return 201 Created or 500 with Reason ServerTimeout indicating a unique name could not be found in the time allotted, and the client should retry (optionally after the time indicated in the Retry-After header). Applied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#idempotency +optional string generateName = 2;
        """
        return pulumi.get(self, "generate_name")

    @generate_name.setter
    def generate_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "generate_name", value)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[int]]:
        """
        A sequence number representing a specific generation of the desired state. Populated by the system. Read-only. +optional
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and routes. More info: http://kubernetes.io/docs/user-guide/labels +optional
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name must be unique within a namespace, within a Cloud Run region. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names +optional
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Namespace defines the space within each name must be unique, within a Cloud Run region. In Cloud Run the namespace must be equal to either the project ID or project number.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="ownerReferences")
    def owner_references(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OwnerReferenceArgs']]]]:
        """
        List of objects that own this object. If ALL objects in the list have been deleted, this object will be garbage collected. +optional
        """
        return pulumi.get(self, "owner_references")

    @owner_references.setter
    def owner_references(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OwnerReferenceArgs']]]]):
        pulumi.set(self, "owner_references", value)

    @property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> Optional[pulumi.Input[str]]:
        """
        An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources. Populated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency +optional
        """
        return pulumi.get(self, "resource_version")

    @resource_version.setter
    def resource_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_version", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        SelfLink is a URL representing this object. Populated by the system. Read-only. +optional string selfLink = 4;
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations. Populated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids +optional
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class OwnerReferenceArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[str]] = None,
                 block_owner_deletion: Optional[pulumi.Input[bool]] = None,
                 controller: Optional[pulumi.Input[bool]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        OwnerReference contains enough information to let you identify an owning object. Currently, an owning object must be in the same namespace, so there is no namespace field.
        :param pulumi.Input[str] api_version: API version of the referent.
        :param pulumi.Input[bool] block_owner_deletion: If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned. +optional
        :param pulumi.Input[bool] controller: If true, this reference points to the managing controller. +optional
        :param pulumi.Input[str] kind: Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input[str] name: Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
        :param pulumi.Input[str] uid: UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if block_owner_deletion is not None:
            pulumi.set(__self__, "block_owner_deletion", block_owner_deletion)
        if controller is not None:
            pulumi.set(__self__, "controller", controller)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        API version of the referent.
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter(name="blockOwnerDeletion")
    def block_owner_deletion(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned. +optional
        """
        return pulumi.get(self, "block_owner_deletion")

    @block_owner_deletion.setter
    def block_owner_deletion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_owner_deletion", value)

    @property
    @pulumi.getter
    def controller(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, this reference points to the managing controller. +optional
        """
        return pulumi.get(self, "controller")

    @controller.setter
    def controller(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "controller", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class ProbeArgs:
    def __init__(__self__, *,
                 failure_threshold: Optional[pulumi.Input[int]] = None,
                 handler: Optional[pulumi.Input['HandlerArgs']] = None,
                 initial_delay_seconds: Optional[pulumi.Input[int]] = None,
                 period_seconds: Optional[pulumi.Input[int]] = None,
                 success_threshold: Optional[pulumi.Input[int]] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None):
        """
        Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.
        :param pulumi.Input[int] failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. +optional
        :param pulumi.Input['HandlerArgs'] handler: The action taken to determine the health of a container
        :param pulumi.Input[int] initial_delay_seconds: Number of seconds after the container has started before liveness probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional
        :param pulumi.Input[int] period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. +optional
        :param pulumi.Input[int] success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness. Minimum value is 1. +optional
        :param pulumi.Input[int] timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if handler is not None:
            pulumi.set(__self__, "handler", handler)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. +optional
        """
        return pulumi.get(self, "failure_threshold")

    @failure_threshold.setter
    def failure_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failure_threshold", value)

    @property
    @pulumi.getter
    def handler(self) -> Optional[pulumi.Input['HandlerArgs']]:
        """
        The action taken to determine the health of a container
        """
        return pulumi.get(self, "handler")

    @handler.setter
    def handler(self, value: Optional[pulumi.Input['HandlerArgs']]):
        pulumi.set(self, "handler", value)

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Number of seconds after the container has started before liveness probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional
        """
        return pulumi.get(self, "initial_delay_seconds")

    @initial_delay_seconds.setter
    def initial_delay_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initial_delay_seconds", value)

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. +optional
        """
        return pulumi.get(self, "period_seconds")

    @period_seconds.setter
    def period_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period_seconds", value)

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness. Minimum value is 1. +optional
        """
        return pulumi.get(self, "success_threshold")

    @success_threshold.setter
    def success_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "success_threshold", value)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_seconds", value)


@pulumi.input_type
class ResourceRecordArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 rrdata: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        A DNS resource record.
        :param pulumi.Input[str] name: Relative name of the object affected by this record. Only applicable for `CNAME` records. Example: 'www'.
        :param pulumi.Input[str] rrdata: Data for this record. Values vary by record type, as defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1).
        :param pulumi.Input[str] type: Resource record type. Example: `AAAA`.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rrdata is not None:
            pulumi.set(__self__, "rrdata", rrdata)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Relative name of the object affected by this record. Only applicable for `CNAME` records. Example: 'www'.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def rrdata(self) -> Optional[pulumi.Input[str]]:
        """
        Data for this record. Values vary by record type, as defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1).
        """
        return pulumi.get(self, "rrdata")

    @rrdata.setter
    def rrdata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rrdata", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource record type. Example: `AAAA`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ResourceRequirementsArgs:
    def __init__(__self__, *,
                 limits: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 limits_in_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 requests: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 requests_in_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        ResourceRequirements describes the compute resource requirements.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] limits: Limits describes the maximum amount of compute resources allowed. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] limits_in_map: Limits describes the maximum amount of compute resources allowed. This is a temporary field created to migrate away from the map limits field. This is done to become compliant with k8s style API. This field is deprecated in favor of limits field.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] requests: Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] requests_in_map: Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. This is a temporary field created to migrate away from the map requests field. This is done to become compliant with k8s style API. This field is deprecated in favor of requests field.
        """
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if limits_in_map is not None:
            pulumi.set(__self__, "limits_in_map", limits_in_map)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)
        if requests_in_map is not None:
            pulumi.set(__self__, "requests_in_map", requests_in_map)

    @property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Limits describes the maximum amount of compute resources allowed. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "limits", value)

    @property
    @pulumi.getter(name="limitsInMap")
    def limits_in_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Limits describes the maximum amount of compute resources allowed. This is a temporary field created to migrate away from the map limits field. This is done to become compliant with k8s style API. This field is deprecated in favor of limits field.
        """
        return pulumi.get(self, "limits_in_map")

    @limits_in_map.setter
    def limits_in_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "limits_in_map", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "requests", value)

    @property
    @pulumi.getter(name="requestsInMap")
    def requests_in_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. This is a temporary field created to migrate away from the map requests field. This is done to become compliant with k8s style API. This field is deprecated in favor of requests field.
        """
        return pulumi.get(self, "requests_in_map")

    @requests_in_map.setter
    def requests_in_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "requests_in_map", value)


@pulumi.input_type
class RevisionSpecArgs:
    def __init__(__self__, *,
                 concurrency_model: Optional[pulumi.Input[str]] = None,
                 container: Optional[pulumi.Input['ContainerArgs']] = None,
                 container_concurrency: Optional[pulumi.Input[int]] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerArgs']]]] = None,
                 generation: Optional[pulumi.Input[int]] = None,
                 service_account_name: Optional[pulumi.Input[str]] = None,
                 serving_state: Optional[pulumi.Input[str]] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]]] = None):
        """
        RevisionSpec holds the desired state of the Revision (from the client).
        :param pulumi.Input[str] concurrency_model: ConcurrencyModel specifies the desired concurrency model (Single or Multi) for the Revision. Defaults to Multi. Deprecated in favor of ContainerConcurrency. +optional
        :param pulumi.Input['ContainerArgs'] container: Container defines the unit of execution for this Revision. In the context of a Revision, we disallow a number of the fields of this Container, including: name, ports, and volumeMounts. The runtime contract is documented here: https://github.com/knative/serving/blob/master/docs/runtime-contract.md
        :param pulumi.Input[int] container_concurrency: (Optional) ContainerConcurrency specifies the maximum allowed in-flight (concurrent) requests per container instance of the Revision. Cloud Run fully managed: supported, defaults to 80 Cloud Run on GKE: supported, defaults to 0, which means concurrency to the application is not limited, and the system decides the target concurrency for the autoscaler.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerArgs']]] containers: Containers holds the single container that defines the unit of execution for this Revision. In the context of a Revision, we disallow a number of fields on this Container, including: name and lifecycle. In Cloud Run, only a single container may be provided.
        :param pulumi.Input[int] generation: Deprecated and not currently populated by Cloud Run. See metadata.generation instead, which is the sequence number containing the latest generation of the desired state. Read-only.
        :param pulumi.Input[str] service_account_name: Email address of the IAM service account associated with the revision of the service. The service account represents the identity of the running revision, and determines what permissions the revision has. If not provided, the revision will use the project's default service account.
        :param pulumi.Input[str] serving_state: ServingState holds a value describing the state the resources are in for this Revision. Users must not specify this when creating a revision. It is expected that the system will manipulate this based on routability and load. Populated by the system. Read-only.
        :param pulumi.Input[int] timeout_seconds: TimeoutSeconds holds the max duration the instance is allowed for responding to a request. Not currently used by Cloud Run.
        """
        if concurrency_model is not None:
            pulumi.set(__self__, "concurrency_model", concurrency_model)
        if container is not None:
            pulumi.set(__self__, "container", container)
        if container_concurrency is not None:
            pulumi.set(__self__, "container_concurrency", container_concurrency)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if service_account_name is not None:
            pulumi.set(__self__, "service_account_name", service_account_name)
        if serving_state is not None:
            pulumi.set(__self__, "serving_state", serving_state)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="concurrencyModel")
    def concurrency_model(self) -> Optional[pulumi.Input[str]]:
        """
        ConcurrencyModel specifies the desired concurrency model (Single or Multi) for the Revision. Defaults to Multi. Deprecated in favor of ContainerConcurrency. +optional
        """
        return pulumi.get(self, "concurrency_model")

    @concurrency_model.setter
    def concurrency_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "concurrency_model", value)

    @property
    @pulumi.getter
    def container(self) -> Optional[pulumi.Input['ContainerArgs']]:
        """
        Container defines the unit of execution for this Revision. In the context of a Revision, we disallow a number of the fields of this Container, including: name, ports, and volumeMounts. The runtime contract is documented here: https://github.com/knative/serving/blob/master/docs/runtime-contract.md
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional[pulumi.Input['ContainerArgs']]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter(name="containerConcurrency")
    def container_concurrency(self) -> Optional[pulumi.Input[int]]:
        """
        (Optional) ContainerConcurrency specifies the maximum allowed in-flight (concurrent) requests per container instance of the Revision. Cloud Run fully managed: supported, defaults to 80 Cloud Run on GKE: supported, defaults to 0, which means concurrency to the application is not limited, and the system decides the target concurrency for the autoscaler.
        """
        return pulumi.get(self, "container_concurrency")

    @container_concurrency.setter
    def container_concurrency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "container_concurrency", value)

    @property
    @pulumi.getter
    def containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerArgs']]]]:
        """
        Containers holds the single container that defines the unit of execution for this Revision. In the context of a Revision, we disallow a number of fields on this Container, including: name and lifecycle. In Cloud Run, only a single container may be provided.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerArgs']]]]):
        pulumi.set(self, "containers", value)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[int]]:
        """
        Deprecated and not currently populated by Cloud Run. See metadata.generation instead, which is the sequence number containing the latest generation of the desired state. Read-only.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter(name="serviceAccountName")
    def service_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        Email address of the IAM service account associated with the revision of the service. The service account represents the identity of the running revision, and determines what permissions the revision has. If not provided, the revision will use the project's default service account.
        """
        return pulumi.get(self, "service_account_name")

    @service_account_name.setter
    def service_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_name", value)

    @property
    @pulumi.getter(name="servingState")
    def serving_state(self) -> Optional[pulumi.Input[str]]:
        """
        ServingState holds a value describing the state the resources are in for this Revision. Users must not specify this when creating a revision. It is expected that the system will manipulate this based on routability and load. Populated by the system. Read-only.
        """
        return pulumi.get(self, "serving_state")

    @serving_state.setter
    def serving_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serving_state", value)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        TimeoutSeconds holds the max duration the instance is allowed for responding to a request. Not currently used by Cloud Run.
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_seconds", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]]]:
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


@pulumi.input_type
class RevisionTemplateArgs:
    def __init__(__self__, *,
                 metadata: Optional[pulumi.Input['ObjectMetaArgs']] = None,
                 spec: Optional[pulumi.Input['RevisionSpecArgs']] = None):
        """
        RevisionTemplateSpec describes the data a revision should have when created from a template. Based on: https://github.com/kubernetes/api/blob/e771f807/core/v1/types.go#L3179-L3190
        :param pulumi.Input['ObjectMetaArgs'] metadata: Optional metadata for this Revision, including labels and annotations. Name will be generated by the Configuration. To set minimum instances for this revision, use the "autoscaling.knative.dev/minScale" annotation key. (Cloud Run on GKE only). To set maximum instances for this revision, use the "autoscaling.knative.dev/maxScale" annotation key. To set Cloud SQL connections for the revision, use the "run.googleapis.com/cloudsql-instances" annotation key. Values should be comma separated.
        :param pulumi.Input['RevisionSpecArgs'] spec: RevisionSpec holds the desired state of the Revision (from the client).
        """
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['ObjectMetaArgs']]:
        """
        Optional metadata for this Revision, including labels and annotations. Name will be generated by the Configuration. To set minimum instances for this revision, use the "autoscaling.knative.dev/minScale" annotation key. (Cloud Run on GKE only). To set maximum instances for this revision, use the "autoscaling.knative.dev/maxScale" annotation key. To set Cloud SQL connections for the revision, use the "run.googleapis.com/cloudsql-instances" annotation key. Values should be comma separated.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['RevisionSpecArgs']]:
        """
        RevisionSpec holds the desired state of the Revision (from the client).
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['RevisionSpecArgs']]):
        pulumi.set(self, "spec", value)


@pulumi.input_type
class SELinuxOptionsArgs:
    def __init__(__self__, *,
                 level: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user: Optional[pulumi.Input[str]] = None):
        """
        SELinuxOptions are the labels to be applied to the container
        :param pulumi.Input[str] level: Level is SELinux level label that applies to the container. +optional
        :param pulumi.Input[str] role: Role is a SELinux role label that applies to the container. +optional
        :param pulumi.Input[str] type: Type is a SELinux type label that applies to the container. +optional
        :param pulumi.Input[str] user: User is a SELinux user label that applies to the container. +optional
        """
        if level is not None:
            pulumi.set(__self__, "level", level)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[str]]:
        """
        Level is SELinux level label that applies to the container. +optional
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role is a SELinux role label that applies to the container. +optional
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type is a SELinux type label that applies to the container. +optional
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        """
        User is a SELinux user label that applies to the container. +optional
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class SecretEnvSourceArgs:
    def __init__(__self__, *,
                 local_object_reference: Optional[pulumi.Input['LocalObjectReferenceArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 optional: Optional[pulumi.Input[bool]] = None):
        """
        SecretEnvSource selects a Secret to populate the environment variables with. The contents of the target Secret's Data field will represent the key-value pairs as environment variables.
        :param pulumi.Input['LocalObjectReferenceArgs'] local_object_reference: This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        :param pulumi.Input[str] name: Cloud Run fully managed: not supported Cloud Run for Anthos: supported The Secret to select from.
        :param pulumi.Input[bool] optional: Cloud Run fully managed: not supported Cloud Run for Anthos: supported Specify whether the Secret must be defined +optional
        """
        if local_object_reference is not None:
            pulumi.set(__self__, "local_object_reference", local_object_reference)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="localObjectReference")
    def local_object_reference(self) -> Optional[pulumi.Input['LocalObjectReferenceArgs']]:
        """
        This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        """
        return pulumi.get(self, "local_object_reference")

    @local_object_reference.setter
    def local_object_reference(self, value: Optional[pulumi.Input['LocalObjectReferenceArgs']]):
        pulumi.set(self, "local_object_reference", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud Run fully managed: not supported Cloud Run for Anthos: supported The Secret to select from.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def optional(self) -> Optional[pulumi.Input[bool]]:
        """
        Cloud Run fully managed: not supported Cloud Run for Anthos: supported Specify whether the Secret must be defined +optional
        """
        return pulumi.get(self, "optional")

    @optional.setter
    def optional(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "optional", value)


@pulumi.input_type
class SecretKeySelectorArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 local_object_reference: Optional[pulumi.Input['LocalObjectReferenceArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 optional: Optional[pulumi.Input[bool]] = None):
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported SecretKeySelector selects a key of a Secret.
        :param pulumi.Input[str] key: Cloud Run fully managed: not supported Cloud Run on GKE: supported The key of the secret to select from. Must be a valid secret key.
        :param pulumi.Input['LocalObjectReferenceArgs'] local_object_reference: This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        :param pulumi.Input[str] name: Cloud Run fully managed: not supported Cloud Run on GKE: supported The name of the secret in the pod's namespace to select from.
        :param pulumi.Input[bool] optional: Cloud Run fully managed: not supported Cloud Run on GKE: supported Specify whether the Secret or its key must be defined +optional
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if local_object_reference is not None:
            pulumi.set(__self__, "local_object_reference", local_object_reference)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported The key of the secret to select from. Must be a valid secret key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="localObjectReference")
    def local_object_reference(self) -> Optional[pulumi.Input['LocalObjectReferenceArgs']]:
        """
        This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        """
        return pulumi.get(self, "local_object_reference")

    @local_object_reference.setter
    def local_object_reference(self, value: Optional[pulumi.Input['LocalObjectReferenceArgs']]):
        pulumi.set(self, "local_object_reference", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported The name of the secret in the pod's namespace to select from.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def optional(self) -> Optional[pulumi.Input[bool]]:
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported Specify whether the Secret or its key must be defined +optional
        """
        return pulumi.get(self, "optional")

    @optional.setter
    def optional(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "optional", value)


@pulumi.input_type
class SecretVolumeSourceArgs:
    def __init__(__self__, *,
                 default_mode: Optional[pulumi.Input[int]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['KeyToPathArgs']]]] = None,
                 optional: Optional[pulumi.Input[bool]] = None,
                 secret_name: Optional[pulumi.Input[str]] = None):
        """
        The contents of the target Secret's Data field will be presented in a volume as files using the keys in the Data field as the file names.
        :param pulumi.Input[int] default_mode: Mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param pulumi.Input[Sequence[pulumi.Input['KeyToPathArgs']]] items: If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional.
        :param pulumi.Input[bool] optional: Specify whether the Secret or its keys must be defined.
        :param pulumi.Input[str] secret_name: Name of the secret in the container's namespace to use.
        """
        if default_mode is not None:
            pulumi.set(__self__, "default_mode", default_mode)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)

    @property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> Optional[pulumi.Input[int]]:
        """
        Mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "default_mode")

    @default_mode.setter
    def default_mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_mode", value)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeyToPathArgs']]]]:
        """
        If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeyToPathArgs']]]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter
    def optional(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether the Secret or its keys must be defined.
        """
        return pulumi.get(self, "optional")

    @optional.setter
    def optional(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "optional", value)

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the secret in the container's namespace to use.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_name", value)


@pulumi.input_type
class SecurityContextArgs:
    def __init__(__self__, *,
                 allow_privilege_escalation: Optional[pulumi.Input[bool]] = None,
                 capabilities: Optional[pulumi.Input['CapabilitiesArgs']] = None,
                 privileged: Optional[pulumi.Input[bool]] = None,
                 read_only_root_filesystem: Optional[pulumi.Input[bool]] = None,
                 run_as_group: Optional[pulumi.Input[int]] = None,
                 run_as_non_root: Optional[pulumi.Input[bool]] = None,
                 run_as_user: Optional[pulumi.Input[int]] = None,
                 se_linux_options: Optional[pulumi.Input['SELinuxOptionsArgs']] = None):
        """
        SecurityContext holds security configuration that will be applied to a container. Some fields are present in both SecurityContext and PodSecurityContext. When both are set, the values in SecurityContext take precedence.
        :param pulumi.Input[bool] allow_privilege_escalation: AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN +optional
        :param pulumi.Input['CapabilitiesArgs'] capabilities: The capabilities to add/drop when running containers. Defaults to the default set of capabilities granted by the container runtime. +optional
        :param pulumi.Input[bool] privileged: Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false. +optional
        :param pulumi.Input[bool] read_only_root_filesystem: Whether this container has a read-only root filesystem. Default is false. +optional
        :param pulumi.Input[int] run_as_group: The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. +optional
        :param pulumi.Input[bool] run_as_non_root: Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. +optional
        :param pulumi.Input[int] run_as_user: The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. +optional
        :param pulumi.Input['SELinuxOptionsArgs'] se_linux_options: The SELinux context to be applied to the container. If unspecified, the container runtime will allocate a random SELinux context for each container. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. +optional
        """
        if allow_privilege_escalation is not None:
            pulumi.set(__self__, "allow_privilege_escalation", allow_privilege_escalation)
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)
        if read_only_root_filesystem is not None:
            pulumi.set(__self__, "read_only_root_filesystem", read_only_root_filesystem)
        if run_as_group is not None:
            pulumi.set(__self__, "run_as_group", run_as_group)
        if run_as_non_root is not None:
            pulumi.set(__self__, "run_as_non_root", run_as_non_root)
        if run_as_user is not None:
            pulumi.set(__self__, "run_as_user", run_as_user)
        if se_linux_options is not None:
            pulumi.set(__self__, "se_linux_options", se_linux_options)

    @property
    @pulumi.getter(name="allowPrivilegeEscalation")
    def allow_privilege_escalation(self) -> Optional[pulumi.Input[bool]]:
        """
        AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN +optional
        """
        return pulumi.get(self, "allow_privilege_escalation")

    @allow_privilege_escalation.setter
    def allow_privilege_escalation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_privilege_escalation", value)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input['CapabilitiesArgs']]:
        """
        The capabilities to add/drop when running containers. Defaults to the default set of capabilities granted by the container runtime. +optional
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input['CapabilitiesArgs']]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter
    def privileged(self) -> Optional[pulumi.Input[bool]]:
        """
        Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false. +optional
        """
        return pulumi.get(self, "privileged")

    @privileged.setter
    def privileged(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "privileged", value)

    @property
    @pulumi.getter(name="readOnlyRootFilesystem")
    def read_only_root_filesystem(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this container has a read-only root filesystem. Default is false. +optional
        """
        return pulumi.get(self, "read_only_root_filesystem")

    @read_only_root_filesystem.setter
    def read_only_root_filesystem(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only_root_filesystem", value)

    @property
    @pulumi.getter(name="runAsGroup")
    def run_as_group(self) -> Optional[pulumi.Input[int]]:
        """
        The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. +optional
        """
        return pulumi.get(self, "run_as_group")

    @run_as_group.setter
    def run_as_group(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "run_as_group", value)

    @property
    @pulumi.getter(name="runAsNonRoot")
    def run_as_non_root(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. +optional
        """
        return pulumi.get(self, "run_as_non_root")

    @run_as_non_root.setter
    def run_as_non_root(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "run_as_non_root", value)

    @property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> Optional[pulumi.Input[int]]:
        """
        The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. +optional
        """
        return pulumi.get(self, "run_as_user")

    @run_as_user.setter
    def run_as_user(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "run_as_user", value)

    @property
    @pulumi.getter(name="seLinuxOptions")
    def se_linux_options(self) -> Optional[pulumi.Input['SELinuxOptionsArgs']]:
        """
        The SELinux context to be applied to the container. If unspecified, the container runtime will allocate a random SELinux context for each container. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. +optional
        """
        return pulumi.get(self, "se_linux_options")

    @se_linux_options.setter
    def se_linux_options(self, value: Optional[pulumi.Input['SELinuxOptionsArgs']]):
        pulumi.set(self, "se_linux_options", value)


@pulumi.input_type
class ServiceConditionArgs:
    def __init__(__self__, *,
                 last_transition_time: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None,
                 severity: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        ServiceCondition defines a readiness condition for a Service.
        :param pulumi.Input[str] last_transition_time: Last time the condition transitioned from one status to another. +optional
        :param pulumi.Input[str] message: Human-readable message indicating details about last transition. +optional
        :param pulumi.Input[str] reason: One-word CamelCase reason for the condition's last transition. +optional
        :param pulumi.Input[str] severity: How to interpret failures of this condition, one of Error, Warning, Info +optional
        :param pulumi.Input[str] status: Status of the condition, one of True, False, Unknown.
        :param pulumi.Input[str] type: ServiceConditionType is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/master/docs/spec/errors.md#error-conditions-and-reporting Types include: "Ready", "ConfigurationsReady", and "RoutesReady". "Ready" will be true when the underlying Route and Configuration are ready.
        """
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[pulumi.Input[str]]:
        """
        Last time the condition transitioned from one status to another. +optional
        """
        return pulumi.get(self, "last_transition_time")

    @last_transition_time.setter
    def last_transition_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_transition_time", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable message indicating details about last transition. +optional
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        One-word CamelCase reason for the condition's last transition. +optional
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[str]]:
        """
        How to interpret failures of this condition, one of Error, Warning, Info +optional
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        ServiceConditionType is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/master/docs/spec/errors.md#error-conditions-and-reporting Types include: "Ready", "ConfigurationsReady", and "RoutesReady". "Ready" will be true when the underlying Route and Configuration are ready.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ServiceSpecArgs:
    def __init__(__self__, *,
                 generation: Optional[pulumi.Input[int]] = None,
                 manual: Optional[pulumi.Input['ServiceSpecManualTypeArgs']] = None,
                 pinned: Optional[pulumi.Input['ServiceSpecPinnedTypeArgs']] = None,
                 release: Optional[pulumi.Input['ServiceSpecReleaseTypeArgs']] = None,
                 run_latest: Optional[pulumi.Input['ServiceSpecRunLatestArgs']] = None,
                 template: Optional[pulumi.Input['RevisionTemplateArgs']] = None,
                 traffic: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficTargetArgs']]]] = None):
        """
        ServiceSpec holds the desired state of the Route (from the client), which is used to manipulate the underlying Route and Configuration(s).
        :param pulumi.Input[int] generation: Deprecated and not currently populated by Cloud Run. See metadata.generation instead, which is the sequence number containing the latest generation of the desired state. Read-only.
        :param pulumi.Input['ServiceSpecManualTypeArgs'] manual: Manual contains the options for configuring a manual service. See ServiceSpec for more details. Not currently supported by Cloud Run.
        :param pulumi.Input['ServiceSpecPinnedTypeArgs'] pinned: Pins this service to a specific revision name. The revision must be owned by the configuration provided. Deprecated and not supported by Cloud Run. +optional
        :param pulumi.Input['ServiceSpecReleaseTypeArgs'] release: Release enables gradual promotion of new revisions by allowing traffic to be split between two revisions. This type replaces the deprecated Pinned type. Not currently supported by Cloud Run.
        :param pulumi.Input['ServiceSpecRunLatestArgs'] run_latest: RunLatest defines a simple Service. It will automatically configure a route that keeps the latest ready revision from the supplied configuration running. +optional
        :param pulumi.Input['RevisionTemplateArgs'] template: Template holds the latest specification for the Revision to be stamped out.
        :param pulumi.Input[Sequence[pulumi.Input['TrafficTargetArgs']]] traffic: Traffic specifies how to distribute traffic over a collection of Knative Revisions and Configurations.
        """
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if manual is not None:
            pulumi.set(__self__, "manual", manual)
        if pinned is not None:
            pulumi.set(__self__, "pinned", pinned)
        if release is not None:
            pulumi.set(__self__, "release", release)
        if run_latest is not None:
            pulumi.set(__self__, "run_latest", run_latest)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if traffic is not None:
            pulumi.set(__self__, "traffic", traffic)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[int]]:
        """
        Deprecated and not currently populated by Cloud Run. See metadata.generation instead, which is the sequence number containing the latest generation of the desired state. Read-only.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter
    def manual(self) -> Optional[pulumi.Input['ServiceSpecManualTypeArgs']]:
        """
        Manual contains the options for configuring a manual service. See ServiceSpec for more details. Not currently supported by Cloud Run.
        """
        return pulumi.get(self, "manual")

    @manual.setter
    def manual(self, value: Optional[pulumi.Input['ServiceSpecManualTypeArgs']]):
        pulumi.set(self, "manual", value)

    @property
    @pulumi.getter
    def pinned(self) -> Optional[pulumi.Input['ServiceSpecPinnedTypeArgs']]:
        """
        Pins this service to a specific revision name. The revision must be owned by the configuration provided. Deprecated and not supported by Cloud Run. +optional
        """
        return pulumi.get(self, "pinned")

    @pinned.setter
    def pinned(self, value: Optional[pulumi.Input['ServiceSpecPinnedTypeArgs']]):
        pulumi.set(self, "pinned", value)

    @property
    @pulumi.getter
    def release(self) -> Optional[pulumi.Input['ServiceSpecReleaseTypeArgs']]:
        """
        Release enables gradual promotion of new revisions by allowing traffic to be split between two revisions. This type replaces the deprecated Pinned type. Not currently supported by Cloud Run.
        """
        return pulumi.get(self, "release")

    @release.setter
    def release(self, value: Optional[pulumi.Input['ServiceSpecReleaseTypeArgs']]):
        pulumi.set(self, "release", value)

    @property
    @pulumi.getter(name="runLatest")
    def run_latest(self) -> Optional[pulumi.Input['ServiceSpecRunLatestArgs']]:
        """
        RunLatest defines a simple Service. It will automatically configure a route that keeps the latest ready revision from the supplied configuration running. +optional
        """
        return pulumi.get(self, "run_latest")

    @run_latest.setter
    def run_latest(self, value: Optional[pulumi.Input['ServiceSpecRunLatestArgs']]):
        pulumi.set(self, "run_latest", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['RevisionTemplateArgs']]:
        """
        Template holds the latest specification for the Revision to be stamped out.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['RevisionTemplateArgs']]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter
    def traffic(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrafficTargetArgs']]]]:
        """
        Traffic specifies how to distribute traffic over a collection of Knative Revisions and Configurations.
        """
        return pulumi.get(self, "traffic")

    @traffic.setter
    def traffic(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficTargetArgs']]]]):
        pulumi.set(self, "traffic", value)


@pulumi.input_type
class ServiceSpecManualTypeArgs:
    def __init__(__self__):
        """
        ServiceSpecManualType contains the options for configuring a manual service. See ServiceSpec for more details. Not currently supported by Cloud Run.
        """
        pass


@pulumi.input_type
class ServiceSpecPinnedTypeArgs:
    def __init__(__self__, *,
                 configuration: Optional[pulumi.Input['ConfigurationSpecArgs']] = None,
                 revision_name: Optional[pulumi.Input[str]] = None):
        """
        ServiceSpecPinnedType Pins this service to a specific revision name. The revision must be owned by the configuration provided. Deprecated and not supported by Cloud Run.
        :param pulumi.Input['ConfigurationSpecArgs'] configuration: The configuration for this service.
        :param pulumi.Input[str] revision_name: The revision name to pin this service to until changed to a different service type.
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if revision_name is not None:
            pulumi.set(__self__, "revision_name", revision_name)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['ConfigurationSpecArgs']]:
        """
        The configuration for this service.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['ConfigurationSpecArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="revisionName")
    def revision_name(self) -> Optional[pulumi.Input[str]]:
        """
        The revision name to pin this service to until changed to a different service type.
        """
        return pulumi.get(self, "revision_name")

    @revision_name.setter
    def revision_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision_name", value)


@pulumi.input_type
class ServiceSpecReleaseTypeArgs:
    def __init__(__self__, *,
                 configuration: Optional[pulumi.Input['ConfigurationSpecArgs']] = None,
                 revisions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rollout_percent: Optional[pulumi.Input[int]] = None):
        """
        ServiceSpecReleaseType contains the options for slowly releasing revisions. See ServiceSpec for more details. Not currently supported by Cloud Run.
        :param pulumi.Input['ConfigurationSpecArgs'] configuration: The configuration for this service. All revisions from this service must come from a single configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] revisions: Revisions is an ordered list of 1 or 2 revisions. The first is the current revision, and the second is the candidate revision. If a single revision is provided, traffic will be pinned at that revision. "@latest" is a shortcut for usage that refers to the latest created revision by the configuration.
        :param pulumi.Input[int] rollout_percent: RolloutPercent is the percent of traffic that should be sent to the candidate revision, i.e. the 2nd revision in the revisions list. Valid values are between 0 and 99 inclusive.
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if revisions is not None:
            pulumi.set(__self__, "revisions", revisions)
        if rollout_percent is not None:
            pulumi.set(__self__, "rollout_percent", rollout_percent)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['ConfigurationSpecArgs']]:
        """
        The configuration for this service. All revisions from this service must come from a single configuration.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['ConfigurationSpecArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter
    def revisions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Revisions is an ordered list of 1 or 2 revisions. The first is the current revision, and the second is the candidate revision. If a single revision is provided, traffic will be pinned at that revision. "@latest" is a shortcut for usage that refers to the latest created revision by the configuration.
        """
        return pulumi.get(self, "revisions")

    @revisions.setter
    def revisions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "revisions", value)

    @property
    @pulumi.getter(name="rolloutPercent")
    def rollout_percent(self) -> Optional[pulumi.Input[int]]:
        """
        RolloutPercent is the percent of traffic that should be sent to the candidate revision, i.e. the 2nd revision in the revisions list. Valid values are between 0 and 99 inclusive.
        """
        return pulumi.get(self, "rollout_percent")

    @rollout_percent.setter
    def rollout_percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rollout_percent", value)


@pulumi.input_type
class ServiceSpecRunLatestArgs:
    def __init__(__self__, *,
                 configuration: Optional[pulumi.Input['ConfigurationSpecArgs']] = None):
        """
        ServiceSpecRunLatest contains the options for always having a route to the latest configuration. See ServiceSpec for more details.
        :param pulumi.Input['ConfigurationSpecArgs'] configuration: The configuration for this service.
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['ConfigurationSpecArgs']]:
        """
        The configuration for this service.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['ConfigurationSpecArgs']]):
        pulumi.set(self, "configuration", value)


@pulumi.input_type
class ServiceStatusArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input['AddressableArgs']] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceConditionArgs']]]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 latest_created_revision_name: Optional[pulumi.Input[str]] = None,
                 latest_ready_revision_name: Optional[pulumi.Input[str]] = None,
                 observed_generation: Optional[pulumi.Input[int]] = None,
                 traffic: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficTargetArgs']]]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        The current state of the Service. Output only.
        :param pulumi.Input['AddressableArgs'] address: From RouteStatus. Similar to url, information on where the service is available on HTTP.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceConditionArgs']]] conditions: Conditions communicates information about ongoing/complete reconciliation processes that bring the "spec" inline with the observed state of the world.
        :param pulumi.Input[str] domain: From RouteStatus. Domain holds the top-level domain that will distribute traffic over the provided targets. It generally has the form https://{route-hash}-{project-hash}-{cluster-level-suffix}.a.run.app
        :param pulumi.Input[str] latest_created_revision_name: From ConfigurationStatus. LatestCreatedRevisionName is the last revision that was created from this Service's Configuration. It might not be ready yet, for that use LatestReadyRevisionName.
        :param pulumi.Input[str] latest_ready_revision_name: From ConfigurationStatus. LatestReadyRevisionName holds the name of the latest Revision stamped out from this Service's Configuration that has had its "Ready" condition become "True".
        :param pulumi.Input[int] observed_generation: ObservedGeneration is the 'Generation' of the Route that was last processed by the controller. Clients polling for completed reconciliation should poll until observedGeneration = metadata.generation and the Ready condition's status is True or False.
        :param pulumi.Input[Sequence[pulumi.Input['TrafficTargetArgs']]] traffic: From RouteStatus. Traffic holds the configured traffic distribution. These entries will always contain RevisionName references. When ConfigurationName appears in the spec, this will hold the LatestReadyRevisionName that we last observed.
        :param pulumi.Input[str] url: From RouteStatus. URL holds the url that will distribute traffic over the provided traffic targets. It generally has the form https://{route-hash}-{project-hash}-{cluster-level-suffix}.a.run.app
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if latest_created_revision_name is not None:
            pulumi.set(__self__, "latest_created_revision_name", latest_created_revision_name)
        if latest_ready_revision_name is not None:
            pulumi.set(__self__, "latest_ready_revision_name", latest_ready_revision_name)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if traffic is not None:
            pulumi.set(__self__, "traffic", traffic)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input['AddressableArgs']]:
        """
        From RouteStatus. Similar to url, information on where the service is available on HTTP.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input['AddressableArgs']]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceConditionArgs']]]]:
        """
        Conditions communicates information about ongoing/complete reconciliation processes that bring the "spec" inline with the observed state of the world.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        From RouteStatus. Domain holds the top-level domain that will distribute traffic over the provided targets. It generally has the form https://{route-hash}-{project-hash}-{cluster-level-suffix}.a.run.app
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="latestCreatedRevisionName")
    def latest_created_revision_name(self) -> Optional[pulumi.Input[str]]:
        """
        From ConfigurationStatus. LatestCreatedRevisionName is the last revision that was created from this Service's Configuration. It might not be ready yet, for that use LatestReadyRevisionName.
        """
        return pulumi.get(self, "latest_created_revision_name")

    @latest_created_revision_name.setter
    def latest_created_revision_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "latest_created_revision_name", value)

    @property
    @pulumi.getter(name="latestReadyRevisionName")
    def latest_ready_revision_name(self) -> Optional[pulumi.Input[str]]:
        """
        From ConfigurationStatus. LatestReadyRevisionName holds the name of the latest Revision stamped out from this Service's Configuration that has had its "Ready" condition become "True".
        """
        return pulumi.get(self, "latest_ready_revision_name")

    @latest_ready_revision_name.setter
    def latest_ready_revision_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "latest_ready_revision_name", value)

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[pulumi.Input[int]]:
        """
        ObservedGeneration is the 'Generation' of the Route that was last processed by the controller. Clients polling for completed reconciliation should poll until observedGeneration = metadata.generation and the Ready condition's status is True or False.
        """
        return pulumi.get(self, "observed_generation")

    @observed_generation.setter
    def observed_generation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "observed_generation", value)

    @property
    @pulumi.getter
    def traffic(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrafficTargetArgs']]]]:
        """
        From RouteStatus. Traffic holds the configured traffic distribution. These entries will always contain RevisionName references. When ConfigurationName appears in the spec, this will hold the LatestReadyRevisionName that we last observed.
        """
        return pulumi.get(self, "traffic")

    @traffic.setter
    def traffic(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficTargetArgs']]]]):
        pulumi.set(self, "traffic", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        From RouteStatus. URL holds the url that will distribute traffic over the provided traffic targets. It generally has the form https://{route-hash}-{project-hash}-{cluster-level-suffix}.a.run.app
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class TCPSocketActionArgs:
    def __init__(__self__, *,
                 host: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input['IntOrStringArgs']] = None):
        """
        TCPSocketAction describes an action based on opening a socket
        :param pulumi.Input[str] host: Optional: Host name to connect to, defaults to the pod IP. +optional
        :param pulumi.Input['IntOrStringArgs'] port: Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        Optional: Host name to connect to, defaults to the pod IP. +optional
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input['IntOrStringArgs']]:
        """
        Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input['IntOrStringArgs']]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class TrafficTargetArgs:
    def __init__(__self__, *,
                 configuration_name: Optional[pulumi.Input[str]] = None,
                 latest_revision: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 percent: Optional[pulumi.Input[int]] = None,
                 revision_name: Optional[pulumi.Input[str]] = None,
                 tag: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        TrafficTarget holds a single entry of the routing table for a Route.
        :param pulumi.Input[str] configuration_name: ConfigurationName of a configuration to whose latest revision we will send this portion of traffic. When the "status.latestReadyRevisionName" of the referenced configuration changes, we will automatically migrate traffic from the prior "latest ready" revision to the new one. This field is never set in Route's status, only its spec. This is mutually exclusive with RevisionName. Cloud Run currently supports a single ConfigurationName.
        :param pulumi.Input[bool] latest_revision: LatestRevision may be optionally provided to indicate that the latest ready Revision of the Configuration should be used for this traffic target. When provided LatestRevision must be true if RevisionName is empty; it must be false when RevisionName is non-empty. +optional
        :param pulumi.Input[str] name: Name is optionally used to expose a dedicated hostname for referencing this target exclusively. Not currently supported by Cloud Run. +optional
        :param pulumi.Input[int] percent: Percent specifies percent of the traffic to this Revision or Configuration. This defaults to zero if unspecified. Cloud Run currently requires 100 percent for a single ConfigurationName TrafficTarget entry.
        :param pulumi.Input[str] revision_name: RevisionName of a specific revision to which to send this portion of traffic. This is mutually exclusive with ConfigurationName. Providing RevisionName in spec is not currently supported by Cloud Run.
        :param pulumi.Input[str] tag: Tag is optionally used to expose a dedicated url for referencing this target exclusively. Not currently supported in Cloud Run. +optional
        :param pulumi.Input[str] url: URL displays the URL for accessing named traffic targets. URL is displayed in status, and is disallowed on spec. URL must contain a scheme (e.g. http://) and a hostname, but may not contain anything else (e.g. basic auth, url path, etc. Not currently supported in Cloud Run.
        """
        if configuration_name is not None:
            pulumi.set(__self__, "configuration_name", configuration_name)
        if latest_revision is not None:
            pulumi.set(__self__, "latest_revision", latest_revision)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if percent is not None:
            pulumi.set(__self__, "percent", percent)
        if revision_name is not None:
            pulumi.set(__self__, "revision_name", revision_name)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="configurationName")
    def configuration_name(self) -> Optional[pulumi.Input[str]]:
        """
        ConfigurationName of a configuration to whose latest revision we will send this portion of traffic. When the "status.latestReadyRevisionName" of the referenced configuration changes, we will automatically migrate traffic from the prior "latest ready" revision to the new one. This field is never set in Route's status, only its spec. This is mutually exclusive with RevisionName. Cloud Run currently supports a single ConfigurationName.
        """
        return pulumi.get(self, "configuration_name")

    @configuration_name.setter
    def configuration_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_name", value)

    @property
    @pulumi.getter(name="latestRevision")
    def latest_revision(self) -> Optional[pulumi.Input[bool]]:
        """
        LatestRevision may be optionally provided to indicate that the latest ready Revision of the Configuration should be used for this traffic target. When provided LatestRevision must be true if RevisionName is empty; it must be false when RevisionName is non-empty. +optional
        """
        return pulumi.get(self, "latest_revision")

    @latest_revision.setter
    def latest_revision(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "latest_revision", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name is optionally used to expose a dedicated hostname for referencing this target exclusively. Not currently supported by Cloud Run. +optional
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def percent(self) -> Optional[pulumi.Input[int]]:
        """
        Percent specifies percent of the traffic to this Revision or Configuration. This defaults to zero if unspecified. Cloud Run currently requires 100 percent for a single ConfigurationName TrafficTarget entry.
        """
        return pulumi.get(self, "percent")

    @percent.setter
    def percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "percent", value)

    @property
    @pulumi.getter(name="revisionName")
    def revision_name(self) -> Optional[pulumi.Input[str]]:
        """
        RevisionName of a specific revision to which to send this portion of traffic. This is mutually exclusive with ConfigurationName. Providing RevisionName in spec is not currently supported by Cloud Run.
        """
        return pulumi.get(self, "revision_name")

    @revision_name.setter
    def revision_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision_name", value)

    @property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[str]]:
        """
        Tag is optionally used to expose a dedicated url for referencing this target exclusively. Not currently supported in Cloud Run. +optional
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        URL displays the URL for accessing named traffic targets. URL is displayed in status, and is disallowed on spec. URL must contain a scheme (e.g. http://) and a hostname, but may not contain anything else (e.g. basic auth, url path, etc. Not currently supported in Cloud Run.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class VolumeArgs:
    def __init__(__self__, *,
                 config_map: Optional[pulumi.Input['ConfigMapVolumeSourceArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 secret: Optional[pulumi.Input['SecretVolumeSourceArgs']] = None):
        """
        Volume represents a named volume in a container.
        :param pulumi.Input[str] name: Volume's name.
        """
        if config_map is not None:
            pulumi.set(__self__, "config_map", config_map)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="configMap")
    def config_map(self) -> Optional[pulumi.Input['ConfigMapVolumeSourceArgs']]:
        return pulumi.get(self, "config_map")

    @config_map.setter
    def config_map(self, value: Optional[pulumi.Input['ConfigMapVolumeSourceArgs']]):
        pulumi.set(self, "config_map", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Volume's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input['SecretVolumeSourceArgs']]:
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input['SecretVolumeSourceArgs']]):
        pulumi.set(self, "secret", value)


@pulumi.input_type
class VolumeDeviceArgs:
    def __init__(__self__, *,
                 device_path: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        volumeDevice describes a mapping of a raw block device within a container.
        :param pulumi.Input[str] device_path: devicePath is the path inside of the container that the device will be mapped to.
        :param pulumi.Input[str] name: name must match the name of a persistentVolumeClaim in the pod
        """
        if device_path is not None:
            pulumi.set(__self__, "device_path", device_path)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="devicePath")
    def device_path(self) -> Optional[pulumi.Input[str]]:
        """
        devicePath is the path inside of the container that the device will be mapped to.
        """
        return pulumi.get(self, "device_path")

    @device_path.setter
    def device_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_path", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name must match the name of a persistentVolumeClaim in the pod
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class VolumeMountArgs:
    def __init__(__self__, *,
                 mount_path: Optional[pulumi.Input[str]] = None,
                 mount_propagation: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 sub_path: Optional[pulumi.Input[str]] = None):
        """
        VolumeMount describes a mounting of a Volume within a container.
        :param pulumi.Input[str] mount_path: Path within the container at which the volume should be mounted. Must not contain ':'.
        :param pulumi.Input[str] mount_propagation: mountPropagation determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationHostToContainer is used. This field is beta in 1.10. +optional
        :param pulumi.Input[str] name: This must match the Name of a Volume.
        :param pulumi.Input[bool] read_only: Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false. +optional
        :param pulumi.Input[str] sub_path: Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root). +optional
        """
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if mount_propagation is not None:
            pulumi.set(__self__, "mount_propagation", mount_propagation)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if sub_path is not None:
            pulumi.set(__self__, "sub_path", sub_path)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[pulumi.Input[str]]:
        """
        Path within the container at which the volume should be mounted. Must not contain ':'.
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter(name="mountPropagation")
    def mount_propagation(self) -> Optional[pulumi.Input[str]]:
        """
        mountPropagation determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationHostToContainer is used. This field is beta in 1.10. +optional
        """
        return pulumi.get(self, "mount_propagation")

    @mount_propagation.setter
    def mount_propagation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_propagation", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        This must match the Name of a Volume.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false. +optional
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="subPath")
    def sub_path(self) -> Optional[pulumi.Input[str]]:
        """
        Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root). +optional
        """
        return pulumi.get(self, "sub_path")

    @sub_path.setter
    def sub_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sub_path", value)


