# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables

__all__ = [
    'AptSettingsArgs',
    'ExecStepArgs',
    'ExecStepConfigArgs',
    'FixedOrPercentArgs',
    'GcsObjectArgs',
    'GooSettingsArgs',
    'MonthlyScheduleArgs',
    'OneTimeScheduleArgs',
    'PatchConfigArgs',
    'PatchInstanceFilterArgs',
    'PatchInstanceFilterGroupLabelArgs',
    'PatchRolloutArgs',
    'RecurringScheduleArgs',
    'TimeOfDayArgs',
    'TimeZoneArgs',
    'WeekDayOfMonthArgs',
    'WeeklyScheduleArgs',
    'WindowsUpdateSettingsArgs',
    'YumSettingsArgs',
    'ZypperSettingsArgs',
]

@pulumi.input_type
class AptSettingsArgs:
    def __init__(__self__, *,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 exclusive_packages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Apt patching is completed by executing `apt-get update && apt-get upgrade`. Additional options can be set to control how this is executed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excludes: List of packages to exclude from update. These packages will be excluded
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exclusive_packages: An exclusive list of packages to be updated. These are the only packages that will be updated. If these packages are not installed, they will be ignored. This field cannot be specified with any other patch configuration fields.
        :param pulumi.Input[str] type: By changing the type to DIST, the patching is performed using `apt-get dist-upgrade` instead.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if exclusive_packages is not None:
            pulumi.set(__self__, "exclusive_packages", exclusive_packages)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of packages to exclude from update. These packages will be excluded
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter(name="exclusivePackages")
    def exclusive_packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An exclusive list of packages to be updated. These are the only packages that will be updated. If these packages are not installed, they will be ignored. This field cannot be specified with any other patch configuration fields.
        """
        return pulumi.get(self, "exclusive_packages")

    @exclusive_packages.setter
    def exclusive_packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exclusive_packages", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        By changing the type to DIST, the patching is performed using `apt-get dist-upgrade` instead.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ExecStepArgs:
    def __init__(__self__, *,
                 linux_exec_step_config: Optional[pulumi.Input['ExecStepConfigArgs']] = None,
                 windows_exec_step_config: Optional[pulumi.Input['ExecStepConfigArgs']] = None):
        """
        A step that runs an executable for a PatchJob.
        :param pulumi.Input['ExecStepConfigArgs'] linux_exec_step_config: The ExecStepConfig for all Linux VMs targeted by the PatchJob.
        :param pulumi.Input['ExecStepConfigArgs'] windows_exec_step_config: The ExecStepConfig for all Windows VMs targeted by the PatchJob.
        """
        if linux_exec_step_config is not None:
            pulumi.set(__self__, "linux_exec_step_config", linux_exec_step_config)
        if windows_exec_step_config is not None:
            pulumi.set(__self__, "windows_exec_step_config", windows_exec_step_config)

    @property
    @pulumi.getter(name="linuxExecStepConfig")
    def linux_exec_step_config(self) -> Optional[pulumi.Input['ExecStepConfigArgs']]:
        """
        The ExecStepConfig for all Linux VMs targeted by the PatchJob.
        """
        return pulumi.get(self, "linux_exec_step_config")

    @linux_exec_step_config.setter
    def linux_exec_step_config(self, value: Optional[pulumi.Input['ExecStepConfigArgs']]):
        pulumi.set(self, "linux_exec_step_config", value)

    @property
    @pulumi.getter(name="windowsExecStepConfig")
    def windows_exec_step_config(self) -> Optional[pulumi.Input['ExecStepConfigArgs']]:
        """
        The ExecStepConfig for all Windows VMs targeted by the PatchJob.
        """
        return pulumi.get(self, "windows_exec_step_config")

    @windows_exec_step_config.setter
    def windows_exec_step_config(self, value: Optional[pulumi.Input['ExecStepConfigArgs']]):
        pulumi.set(self, "windows_exec_step_config", value)


@pulumi.input_type
class ExecStepConfigArgs:
    def __init__(__self__, *,
                 allowed_success_codes: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 gcs_object: Optional[pulumi.Input['GcsObjectArgs']] = None,
                 interpreter: Optional[pulumi.Input[str]] = None,
                 local_path: Optional[pulumi.Input[str]] = None):
        """
        Common configurations for an ExecStep.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] allowed_success_codes: Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
        :param pulumi.Input['GcsObjectArgs'] gcs_object: A Cloud Storage object containing the executable.
        :param pulumi.Input[str] interpreter: The script interpreter to use to run the script. If no interpreter is specified the script will be executed directly, which will likely only succeed for scripts with [shebang lines] (https://en.wikipedia.org/wiki/Shebang_\(Unix\)).
        :param pulumi.Input[str] local_path: An absolute path to the executable on the VM.
        """
        if allowed_success_codes is not None:
            pulumi.set(__self__, "allowed_success_codes", allowed_success_codes)
        if gcs_object is not None:
            pulumi.set(__self__, "gcs_object", gcs_object)
        if interpreter is not None:
            pulumi.set(__self__, "interpreter", interpreter)
        if local_path is not None:
            pulumi.set(__self__, "local_path", local_path)

    @property
    @pulumi.getter(name="allowedSuccessCodes")
    def allowed_success_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
        """
        return pulumi.get(self, "allowed_success_codes")

    @allowed_success_codes.setter
    def allowed_success_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "allowed_success_codes", value)

    @property
    @pulumi.getter(name="gcsObject")
    def gcs_object(self) -> Optional[pulumi.Input['GcsObjectArgs']]:
        """
        A Cloud Storage object containing the executable.
        """
        return pulumi.get(self, "gcs_object")

    @gcs_object.setter
    def gcs_object(self, value: Optional[pulumi.Input['GcsObjectArgs']]):
        pulumi.set(self, "gcs_object", value)

    @property
    @pulumi.getter
    def interpreter(self) -> Optional[pulumi.Input[str]]:
        """
        The script interpreter to use to run the script. If no interpreter is specified the script will be executed directly, which will likely only succeed for scripts with [shebang lines] (https://en.wikipedia.org/wiki/Shebang_\(Unix\)).
        """
        return pulumi.get(self, "interpreter")

    @interpreter.setter
    def interpreter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interpreter", value)

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> Optional[pulumi.Input[str]]:
        """
        An absolute path to the executable on the VM.
        """
        return pulumi.get(self, "local_path")

    @local_path.setter
    def local_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_path", value)


@pulumi.input_type
class FixedOrPercentArgs:
    def __init__(__self__, *,
                 fixed: Optional[pulumi.Input[int]] = None,
                 percent: Optional[pulumi.Input[int]] = None):
        """
        Message encapsulating a value that can be either absolute ("fixed") or relative ("percent") to a value.
        :param pulumi.Input[int] fixed: Specifies a fixed value.
        :param pulumi.Input[int] percent: Specifies the relative value defined as a percentage, which will be multiplied by a reference value.
        """
        if fixed is not None:
            pulumi.set(__self__, "fixed", fixed)
        if percent is not None:
            pulumi.set(__self__, "percent", percent)

    @property
    @pulumi.getter
    def fixed(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies a fixed value.
        """
        return pulumi.get(self, "fixed")

    @fixed.setter
    def fixed(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fixed", value)

    @property
    @pulumi.getter
    def percent(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the relative value defined as a percentage, which will be multiplied by a reference value.
        """
        return pulumi.get(self, "percent")

    @percent.setter
    def percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "percent", value)


@pulumi.input_type
class GcsObjectArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 generation_number: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None):
        """
        Cloud Storage object representation.
        :param pulumi.Input[str] bucket: Required. Bucket of the Cloud Storage object.
        :param pulumi.Input[str] generation_number: Required. Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
        :param pulumi.Input[str] object: Required. Name of the Cloud Storage object.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if generation_number is not None:
            pulumi.set(__self__, "generation_number", generation_number)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Bucket of the Cloud Storage object.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="generationNumber")
    def generation_number(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
        """
        return pulumi.get(self, "generation_number")

    @generation_number.setter
    def generation_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "generation_number", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Name of the Cloud Storage object.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)


@pulumi.input_type
class GooSettingsArgs:
    def __init__(__self__):
        """
        Googet patching is performed by running `googet update`.
        """
        pass


@pulumi.input_type
class MonthlyScheduleArgs:
    def __init__(__self__, *,
                 month_day: Optional[pulumi.Input[int]] = None,
                 week_day_of_month: Optional[pulumi.Input['WeekDayOfMonthArgs']] = None):
        """
        Represents a monthly schedule. An example of a valid monthly schedule is "on the third Tuesday of the month" or "on the 15th of the month".
        :param pulumi.Input[int] month_day: Required. One day of the month. 1-31 indicates the 1st to the 31st day. -1 indicates the last day of the month. Months without the target day will be skipped. For example, a schedule to run "every month on the 31st" will not run in February, April, June, etc.
        :param pulumi.Input['WeekDayOfMonthArgs'] week_day_of_month: Required. Week day in a month.
        """
        if month_day is not None:
            pulumi.set(__self__, "month_day", month_day)
        if week_day_of_month is not None:
            pulumi.set(__self__, "week_day_of_month", week_day_of_month)

    @property
    @pulumi.getter(name="monthDay")
    def month_day(self) -> Optional[pulumi.Input[int]]:
        """
        Required. One day of the month. 1-31 indicates the 1st to the 31st day. -1 indicates the last day of the month. Months without the target day will be skipped. For example, a schedule to run "every month on the 31st" will not run in February, April, June, etc.
        """
        return pulumi.get(self, "month_day")

    @month_day.setter
    def month_day(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "month_day", value)

    @property
    @pulumi.getter(name="weekDayOfMonth")
    def week_day_of_month(self) -> Optional[pulumi.Input['WeekDayOfMonthArgs']]:
        """
        Required. Week day in a month.
        """
        return pulumi.get(self, "week_day_of_month")

    @week_day_of_month.setter
    def week_day_of_month(self, value: Optional[pulumi.Input['WeekDayOfMonthArgs']]):
        pulumi.set(self, "week_day_of_month", value)


@pulumi.input_type
class OneTimeScheduleArgs:
    def __init__(__self__, *,
                 execute_time: Optional[pulumi.Input[str]] = None):
        """
        Sets the time for a one time patch deployment. Timestamp is in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
        :param pulumi.Input[str] execute_time: Required. The desired patch job execution time.
        """
        if execute_time is not None:
            pulumi.set(__self__, "execute_time", execute_time)

    @property
    @pulumi.getter(name="executeTime")
    def execute_time(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The desired patch job execution time.
        """
        return pulumi.get(self, "execute_time")

    @execute_time.setter
    def execute_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "execute_time", value)


@pulumi.input_type
class PatchConfigArgs:
    def __init__(__self__, *,
                 apt: Optional[pulumi.Input['AptSettingsArgs']] = None,
                 goo: Optional[pulumi.Input['GooSettingsArgs']] = None,
                 post_step: Optional[pulumi.Input['ExecStepArgs']] = None,
                 pre_step: Optional[pulumi.Input['ExecStepArgs']] = None,
                 reboot_config: Optional[pulumi.Input[str]] = None,
                 windows_update: Optional[pulumi.Input['WindowsUpdateSettingsArgs']] = None,
                 yum: Optional[pulumi.Input['YumSettingsArgs']] = None,
                 zypper: Optional[pulumi.Input['ZypperSettingsArgs']] = None):
        """
        Patch configuration specifications. Contains details on how to apply the patch(es) to a VM instance.
        :param pulumi.Input['AptSettingsArgs'] apt: Apt update settings. Use this setting to override the default `apt` patch rules.
        :param pulumi.Input['GooSettingsArgs'] goo: Goo update settings. Use this setting to override the default `goo` patch rules.
        :param pulumi.Input['ExecStepArgs'] post_step: The `ExecStep` to run after the patch update.
        :param pulumi.Input['ExecStepArgs'] pre_step: The `ExecStep` to run before the patch update.
        :param pulumi.Input[str] reboot_config: Post-patch reboot settings.
        :param pulumi.Input['WindowsUpdateSettingsArgs'] windows_update: Windows update settings. Use this override the default windows patch rules.
        :param pulumi.Input['YumSettingsArgs'] yum: Yum update settings. Use this setting to override the default `yum` patch rules.
        :param pulumi.Input['ZypperSettingsArgs'] zypper: Zypper update settings. Use this setting to override the default `zypper` patch rules.
        """
        if apt is not None:
            pulumi.set(__self__, "apt", apt)
        if goo is not None:
            pulumi.set(__self__, "goo", goo)
        if post_step is not None:
            pulumi.set(__self__, "post_step", post_step)
        if pre_step is not None:
            pulumi.set(__self__, "pre_step", pre_step)
        if reboot_config is not None:
            pulumi.set(__self__, "reboot_config", reboot_config)
        if windows_update is not None:
            pulumi.set(__self__, "windows_update", windows_update)
        if yum is not None:
            pulumi.set(__self__, "yum", yum)
        if zypper is not None:
            pulumi.set(__self__, "zypper", zypper)

    @property
    @pulumi.getter
    def apt(self) -> Optional[pulumi.Input['AptSettingsArgs']]:
        """
        Apt update settings. Use this setting to override the default `apt` patch rules.
        """
        return pulumi.get(self, "apt")

    @apt.setter
    def apt(self, value: Optional[pulumi.Input['AptSettingsArgs']]):
        pulumi.set(self, "apt", value)

    @property
    @pulumi.getter
    def goo(self) -> Optional[pulumi.Input['GooSettingsArgs']]:
        """
        Goo update settings. Use this setting to override the default `goo` patch rules.
        """
        return pulumi.get(self, "goo")

    @goo.setter
    def goo(self, value: Optional[pulumi.Input['GooSettingsArgs']]):
        pulumi.set(self, "goo", value)

    @property
    @pulumi.getter(name="postStep")
    def post_step(self) -> Optional[pulumi.Input['ExecStepArgs']]:
        """
        The `ExecStep` to run after the patch update.
        """
        return pulumi.get(self, "post_step")

    @post_step.setter
    def post_step(self, value: Optional[pulumi.Input['ExecStepArgs']]):
        pulumi.set(self, "post_step", value)

    @property
    @pulumi.getter(name="preStep")
    def pre_step(self) -> Optional[pulumi.Input['ExecStepArgs']]:
        """
        The `ExecStep` to run before the patch update.
        """
        return pulumi.get(self, "pre_step")

    @pre_step.setter
    def pre_step(self, value: Optional[pulumi.Input['ExecStepArgs']]):
        pulumi.set(self, "pre_step", value)

    @property
    @pulumi.getter(name="rebootConfig")
    def reboot_config(self) -> Optional[pulumi.Input[str]]:
        """
        Post-patch reboot settings.
        """
        return pulumi.get(self, "reboot_config")

    @reboot_config.setter
    def reboot_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reboot_config", value)

    @property
    @pulumi.getter(name="windowsUpdate")
    def windows_update(self) -> Optional[pulumi.Input['WindowsUpdateSettingsArgs']]:
        """
        Windows update settings. Use this override the default windows patch rules.
        """
        return pulumi.get(self, "windows_update")

    @windows_update.setter
    def windows_update(self, value: Optional[pulumi.Input['WindowsUpdateSettingsArgs']]):
        pulumi.set(self, "windows_update", value)

    @property
    @pulumi.getter
    def yum(self) -> Optional[pulumi.Input['YumSettingsArgs']]:
        """
        Yum update settings. Use this setting to override the default `yum` patch rules.
        """
        return pulumi.get(self, "yum")

    @yum.setter
    def yum(self, value: Optional[pulumi.Input['YumSettingsArgs']]):
        pulumi.set(self, "yum", value)

    @property
    @pulumi.getter
    def zypper(self) -> Optional[pulumi.Input['ZypperSettingsArgs']]:
        """
        Zypper update settings. Use this setting to override the default `zypper` patch rules.
        """
        return pulumi.get(self, "zypper")

    @zypper.setter
    def zypper(self, value: Optional[pulumi.Input['ZypperSettingsArgs']]):
        pulumi.set(self, "zypper", value)


@pulumi.input_type
class PatchInstanceFilterArgs:
    def __init__(__self__, *,
                 all: Optional[pulumi.Input[bool]] = None,
                 group_labels: Optional[pulumi.Input[Sequence[pulumi.Input['PatchInstanceFilterGroupLabelArgs']]]] = None,
                 instance_name_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        A filter to target VM instances for patching. The targeted VMs must meet all criteria specified. So if both labels and zones are specified, the patch job targets only VMs with those labels and in those zones.
        :param pulumi.Input[bool] all: Target all VM instances in the project. If true, no other criteria is permitted.
        :param pulumi.Input[Sequence[pulumi.Input['PatchInstanceFilterGroupLabelArgs']]] group_labels: Targets VM instances matching ANY of these GroupLabels. This allows targeting of disparate groups of VM instances.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_name_prefixes: Targets VMs whose name starts with one of these prefixes. Similar to labels, this is another way to group VMs when targeting configs, for example prefix="prod-".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instances: Targets any of the VM instances specified. Instances are specified by their URI in the form `zones/[ZONE]/instances/[INSTANCE_NAME]`, `projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`, or `https://www.googleapis.com/compute/v1/projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: Targets VM instances in ANY of these zones. Leave empty to target VM instances in any zone.
        """
        if all is not None:
            pulumi.set(__self__, "all", all)
        if group_labels is not None:
            pulumi.set(__self__, "group_labels", group_labels)
        if instance_name_prefixes is not None:
            pulumi.set(__self__, "instance_name_prefixes", instance_name_prefixes)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def all(self) -> Optional[pulumi.Input[bool]]:
        """
        Target all VM instances in the project. If true, no other criteria is permitted.
        """
        return pulumi.get(self, "all")

    @all.setter
    def all(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "all", value)

    @property
    @pulumi.getter(name="groupLabels")
    def group_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PatchInstanceFilterGroupLabelArgs']]]]:
        """
        Targets VM instances matching ANY of these GroupLabels. This allows targeting of disparate groups of VM instances.
        """
        return pulumi.get(self, "group_labels")

    @group_labels.setter
    def group_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PatchInstanceFilterGroupLabelArgs']]]]):
        pulumi.set(self, "group_labels", value)

    @property
    @pulumi.getter(name="instanceNamePrefixes")
    def instance_name_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Targets VMs whose name starts with one of these prefixes. Similar to labels, this is another way to group VMs when targeting configs, for example prefix="prod-".
        """
        return pulumi.get(self, "instance_name_prefixes")

    @instance_name_prefixes.setter
    def instance_name_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_name_prefixes", value)

    @property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Targets any of the VM instances specified. Instances are specified by their URI in the form `zones/[ZONE]/instances/[INSTANCE_NAME]`, `projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`, or `https://www.googleapis.com/compute/v1/projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instances", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Targets VM instances in ANY of these zones. Leave empty to target VM instances in any zone.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class PatchInstanceFilterGroupLabelArgs:
    def __init__(__self__, *,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Targets a group of VM instances by using their [assigned labels](https://cloud.google.com/compute/docs/labeling-resources). Labels are key-value pairs. A `GroupLabel` is a combination of labels that is used to target VMs for a patch job. For example, a patch job can target VMs that have the following `GroupLabel`: `{"env":"test", "app":"web"}`. This means that the patch job is applied to VMs that have both the labels `env=test` and `app=web`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Compute Engine instance labels that must be present for a VM instance to be targeted by this filter.
        """
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Compute Engine instance labels that must be present for a VM instance to be targeted by this filter.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)


@pulumi.input_type
class PatchRolloutArgs:
    def __init__(__self__, *,
                 disruption_budget: Optional[pulumi.Input['FixedOrPercentArgs']] = None,
                 mode: Optional[pulumi.Input[str]] = None):
        """
        Patch rollout configuration specifications. Contains details on the concurrency control when applying patch(es) to all targeted VMs.
        :param pulumi.Input['FixedOrPercentArgs'] disruption_budget: The maximum number (or percentage) of VMs per zone to disrupt at any given moment. The number of VMs calculated from multiplying the percentage by the total number of VMs in a zone is rounded up. During patching, a VM is considered disrupted from the time the agent is notified to begin until patching has completed. This disruption time includes the time to complete reboot and any post-patch steps. A VM contributes to the disruption budget if its patching operation fails either when applying the patches, running pre or post patch steps, or if it fails to respond with a success notification before timing out. VMs that are not running or do not have an active agent do not count toward this disruption budget. For zone-by-zone rollouts, if the disruption budget in a zone is exceeded, the patch job stops, because continuing to the next zone requires completion of the patch process in the previous zone. For example, if the disruption budget has a fixed value of `10`, and 8 VMs fail to patch in the current zone, the patch job continues to patch 2 VMs at a time until the zone is completed. When that zone is completed successfully, patching begins with 10 VMs at a time in the next zone. If 10 VMs in the next zone fail to patch, the patch job stops.
        :param pulumi.Input[str] mode: Mode of the patch rollout.
        """
        if disruption_budget is not None:
            pulumi.set(__self__, "disruption_budget", disruption_budget)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="disruptionBudget")
    def disruption_budget(self) -> Optional[pulumi.Input['FixedOrPercentArgs']]:
        """
        The maximum number (or percentage) of VMs per zone to disrupt at any given moment. The number of VMs calculated from multiplying the percentage by the total number of VMs in a zone is rounded up. During patching, a VM is considered disrupted from the time the agent is notified to begin until patching has completed. This disruption time includes the time to complete reboot and any post-patch steps. A VM contributes to the disruption budget if its patching operation fails either when applying the patches, running pre or post patch steps, or if it fails to respond with a success notification before timing out. VMs that are not running or do not have an active agent do not count toward this disruption budget. For zone-by-zone rollouts, if the disruption budget in a zone is exceeded, the patch job stops, because continuing to the next zone requires completion of the patch process in the previous zone. For example, if the disruption budget has a fixed value of `10`, and 8 VMs fail to patch in the current zone, the patch job continues to patch 2 VMs at a time until the zone is completed. When that zone is completed successfully, patching begins with 10 VMs at a time in the next zone. If 10 VMs in the next zone fail to patch, the patch job stops.
        """
        return pulumi.get(self, "disruption_budget")

    @disruption_budget.setter
    def disruption_budget(self, value: Optional[pulumi.Input['FixedOrPercentArgs']]):
        pulumi.set(self, "disruption_budget", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        Mode of the patch rollout.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class RecurringScheduleArgs:
    def __init__(__self__, *,
                 end_time: Optional[pulumi.Input[str]] = None,
                 frequency: Optional[pulumi.Input[str]] = None,
                 monthly: Optional[pulumi.Input['MonthlyScheduleArgs']] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 time_of_day: Optional[pulumi.Input['TimeOfDayArgs']] = None,
                 time_zone: Optional[pulumi.Input['TimeZoneArgs']] = None,
                 weekly: Optional[pulumi.Input['WeeklyScheduleArgs']] = None):
        """
        Sets the time for recurring patch deployments.
        :param pulumi.Input[str] end_time: Optional. The end time at which a recurring patch deployment schedule is no longer active.
        :param pulumi.Input[str] frequency: Required. The frequency unit of this recurring schedule.
        :param pulumi.Input['MonthlyScheduleArgs'] monthly: Required. Schedule with monthly executions.
        :param pulumi.Input[str] start_time: Optional. The time that the recurring schedule becomes effective. Defaults to `create_time` of the patch deployment.
        :param pulumi.Input['TimeOfDayArgs'] time_of_day: Required. Time of the day to run a recurring deployment.
        :param pulumi.Input['TimeZoneArgs'] time_zone: Required. Defines the time zone that `time_of_day` is relative to. The rules for daylight saving time are determined by the chosen time zone.
        :param pulumi.Input['WeeklyScheduleArgs'] weekly: Required. Schedule with weekly executions.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if monthly is not None:
            pulumi.set(__self__, "monthly", monthly)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if time_of_day is not None:
            pulumi.set(__self__, "time_of_day", time_of_day)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if weekly is not None:
            pulumi.set(__self__, "weekly", weekly)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The end time at which a recurring patch deployment schedule is no longer active.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The frequency unit of this recurring schedule.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def monthly(self) -> Optional[pulumi.Input['MonthlyScheduleArgs']]:
        """
        Required. Schedule with monthly executions.
        """
        return pulumi.get(self, "monthly")

    @monthly.setter
    def monthly(self, value: Optional[pulumi.Input['MonthlyScheduleArgs']]):
        pulumi.set(self, "monthly", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The time that the recurring schedule becomes effective. Defaults to `create_time` of the patch deployment.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="timeOfDay")
    def time_of_day(self) -> Optional[pulumi.Input['TimeOfDayArgs']]:
        """
        Required. Time of the day to run a recurring deployment.
        """
        return pulumi.get(self, "time_of_day")

    @time_of_day.setter
    def time_of_day(self, value: Optional[pulumi.Input['TimeOfDayArgs']]):
        pulumi.set(self, "time_of_day", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input['TimeZoneArgs']]:
        """
        Required. Defines the time zone that `time_of_day` is relative to. The rules for daylight saving time are determined by the chosen time zone.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input['TimeZoneArgs']]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter
    def weekly(self) -> Optional[pulumi.Input['WeeklyScheduleArgs']]:
        """
        Required. Schedule with weekly executions.
        """
        return pulumi.get(self, "weekly")

    @weekly.setter
    def weekly(self, value: Optional[pulumi.Input['WeeklyScheduleArgs']]):
        pulumi.set(self, "weekly", value)


@pulumi.input_type
class TimeOfDayArgs:
    def __init__(__self__, *,
                 hours: Optional[pulumi.Input[int]] = None,
                 minutes: Optional[pulumi.Input[int]] = None,
                 nanos: Optional[pulumi.Input[int]] = None,
                 seconds: Optional[pulumi.Input[int]] = None):
        """
        Represents a time of day. The date and time zone are either not significant or are specified elsewhere. An API may choose to allow leap seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
        :param pulumi.Input[int] hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param pulumi.Input[int] minutes: Minutes of hour of day. Must be from 0 to 59.
        :param pulumi.Input[int] nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param pulumi.Input[int] seconds: Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> Optional[pulumi.Input[int]]:
        """
        Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @hours.setter
    def hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hours", value)

    @property
    @pulumi.getter
    def minutes(self) -> Optional[pulumi.Input[int]]:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @minutes.setter
    def minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minutes", value)

    @property
    @pulumi.getter
    def nanos(self) -> Optional[pulumi.Input[int]]:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @nanos.setter
    def nanos(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nanos", value)

    @property
    @pulumi.getter
    def seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        return pulumi.get(self, "seconds")

    @seconds.setter
    def seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "seconds", value)


@pulumi.input_type
class TimeZoneArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Represents a time zone from the [IANA Time Zone Database](https://www.iana.org/time-zones).
        :param pulumi.Input[str] id: IANA Time Zone Database time zone, e.g. "America/New_York".
        :param pulumi.Input[str] version: Optional. IANA Time Zone Database version number, e.g. "2019a".
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        IANA Time Zone Database time zone, e.g. "America/New_York".
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. IANA Time Zone Database version number, e.g. "2019a".
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class WeekDayOfMonthArgs:
    def __init__(__self__, *,
                 day_of_week: Optional[pulumi.Input[str]] = None,
                 week_ordinal: Optional[pulumi.Input[int]] = None):
        """
        Represents one week day in a month. An example is "the 4th Sunday".
        :param pulumi.Input[str] day_of_week: Required. A day of the week.
        :param pulumi.Input[int] week_ordinal: Required. Week number in a month. 1-4 indicates the 1st to 4th week of the month. -1 indicates the last week of the month.
        """
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if week_ordinal is not None:
            pulumi.set(__self__, "week_ordinal", week_ordinal)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[pulumi.Input[str]]:
        """
        Required. A day of the week.
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "day_of_week", value)

    @property
    @pulumi.getter(name="weekOrdinal")
    def week_ordinal(self) -> Optional[pulumi.Input[int]]:
        """
        Required. Week number in a month. 1-4 indicates the 1st to 4th week of the month. -1 indicates the last week of the month.
        """
        return pulumi.get(self, "week_ordinal")

    @week_ordinal.setter
    def week_ordinal(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "week_ordinal", value)


@pulumi.input_type
class WeeklyScheduleArgs:
    def __init__(__self__, *,
                 day_of_week: Optional[pulumi.Input[str]] = None):
        """
        Represents a weekly schedule.
        :param pulumi.Input[str] day_of_week: Required. Day of the week.
        """
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Day of the week.
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "day_of_week", value)


@pulumi.input_type
class WindowsUpdateSettingsArgs:
    def __init__(__self__, *,
                 classifications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 exclusive_patches: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Windows patching is performed using the Windows Update Agent.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] classifications: Only apply updates of these windows update classifications. If empty, all updates are applied.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excludes: List of KBs to exclude from update.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exclusive_patches: An exclusive list of kbs to be updated. These are the only patches that will be updated. This field must not be used with other patch configurations.
        """
        if classifications is not None:
            pulumi.set(__self__, "classifications", classifications)
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if exclusive_patches is not None:
            pulumi.set(__self__, "exclusive_patches", exclusive_patches)

    @property
    @pulumi.getter
    def classifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Only apply updates of these windows update classifications. If empty, all updates are applied.
        """
        return pulumi.get(self, "classifications")

    @classifications.setter
    def classifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "classifications", value)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of KBs to exclude from update.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter(name="exclusivePatches")
    def exclusive_patches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An exclusive list of kbs to be updated. These are the only patches that will be updated. This field must not be used with other patch configurations.
        """
        return pulumi.get(self, "exclusive_patches")

    @exclusive_patches.setter
    def exclusive_patches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exclusive_patches", value)


@pulumi.input_type
class YumSettingsArgs:
    def __init__(__self__, *,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 exclusive_packages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 minimal: Optional[pulumi.Input[bool]] = None,
                 security: Optional[pulumi.Input[bool]] = None):
        """
        Yum patching is performed by executing `yum update`. Additional options can be set to control how this is executed. Note that not all settings are supported on all platforms.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excludes: List of packages to exclude from update. These packages are excluded by using the yum `--exclude` flag.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exclusive_packages: An exclusive list of packages to be updated. These are the only packages that will be updated. If these packages are not installed, they will be ignored. This field must not be specified with any other patch configuration fields.
        :param pulumi.Input[bool] minimal: Will cause patch to run `yum update-minimal` instead.
        :param pulumi.Input[bool] security: Adds the `--security` flag to `yum update`. Not supported on all platforms.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if exclusive_packages is not None:
            pulumi.set(__self__, "exclusive_packages", exclusive_packages)
        if minimal is not None:
            pulumi.set(__self__, "minimal", minimal)
        if security is not None:
            pulumi.set(__self__, "security", security)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of packages to exclude from update. These packages are excluded by using the yum `--exclude` flag.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter(name="exclusivePackages")
    def exclusive_packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An exclusive list of packages to be updated. These are the only packages that will be updated. If these packages are not installed, they will be ignored. This field must not be specified with any other patch configuration fields.
        """
        return pulumi.get(self, "exclusive_packages")

    @exclusive_packages.setter
    def exclusive_packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exclusive_packages", value)

    @property
    @pulumi.getter
    def minimal(self) -> Optional[pulumi.Input[bool]]:
        """
        Will cause patch to run `yum update-minimal` instead.
        """
        return pulumi.get(self, "minimal")

    @minimal.setter
    def minimal(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "minimal", value)

    @property
    @pulumi.getter
    def security(self) -> Optional[pulumi.Input[bool]]:
        """
        Adds the `--security` flag to `yum update`. Not supported on all platforms.
        """
        return pulumi.get(self, "security")

    @security.setter
    def security(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "security", value)


@pulumi.input_type
class ZypperSettingsArgs:
    def __init__(__self__, *,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 exclusive_patches: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 severities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 with_optional: Optional[pulumi.Input[bool]] = None,
                 with_update: Optional[pulumi.Input[bool]] = None):
        """
        Zypper patching is performed by running `zypper patch`. See also https://en.opensuse.org/SDB:Zypper_manual.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] categories: Install only patches with these categories. Common categories include security, recommended, and feature.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excludes: List of patches to exclude from update.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exclusive_patches: An exclusive list of patches to be updated. These are the only patches that will be installed using 'zypper patch patch:' command. This field must not be used with any other patch configuration fields.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] severities: Install only patches with these severities. Common severities include critical, important, moderate, and low.
        :param pulumi.Input[bool] with_optional: Adds the `--with-optional` flag to `zypper patch`.
        :param pulumi.Input[bool] with_update: Adds the `--with-update` flag, to `zypper patch`.
        """
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if exclusive_patches is not None:
            pulumi.set(__self__, "exclusive_patches", exclusive_patches)
        if severities is not None:
            pulumi.set(__self__, "severities", severities)
        if with_optional is not None:
            pulumi.set(__self__, "with_optional", with_optional)
        if with_update is not None:
            pulumi.set(__self__, "with_update", with_update)

    @property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Install only patches with these categories. Common categories include security, recommended, and feature.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "categories", value)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of patches to exclude from update.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter(name="exclusivePatches")
    def exclusive_patches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An exclusive list of patches to be updated. These are the only patches that will be installed using 'zypper patch patch:' command. This field must not be used with any other patch configuration fields.
        """
        return pulumi.get(self, "exclusive_patches")

    @exclusive_patches.setter
    def exclusive_patches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exclusive_patches", value)

    @property
    @pulumi.getter
    def severities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Install only patches with these severities. Common severities include critical, important, moderate, and low.
        """
        return pulumi.get(self, "severities")

    @severities.setter
    def severities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "severities", value)

    @property
    @pulumi.getter(name="withOptional")
    def with_optional(self) -> Optional[pulumi.Input[bool]]:
        """
        Adds the `--with-optional` flag to `zypper patch`.
        """
        return pulumi.get(self, "with_optional")

    @with_optional.setter
    def with_optional(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "with_optional", value)

    @property
    @pulumi.getter(name="withUpdate")
    def with_update(self) -> Optional[pulumi.Input[bool]]:
        """
        Adds the `--with-update` flag, to `zypper patch`.
        """
        return pulumi.get(self, "with_update")

    @with_update.setter
    def with_update(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "with_update", value)


