# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables

__all__ = [
    'BindingArgs',
    'ExprArgs',
    'TrustArgs',
]

@pulumi.input_type
class BindingArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates `members` with a `role`.
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the identities requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param pulumi.Input[str] role: Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class TrustArgs:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 last_known_trust_connected_heartbeat_time: Optional[pulumi.Input[str]] = None,
                 selective_authentication: Optional[pulumi.Input[bool]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 state_description: Optional[pulumi.Input[str]] = None,
                 target_dns_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_domain_name: Optional[pulumi.Input[str]] = None,
                 trust_direction: Optional[pulumi.Input[str]] = None,
                 trust_handshake_secret: Optional[pulumi.Input[str]] = None,
                 trust_type: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Represents a relationship between two domains which makes it possible for users in one domain to be authenticated by a dc in another domain. Refer https://docs.microsoft.com/en-us/previous-versions/windows/it-pro/windows-server-2008-R2-and-2008/cc731335(v%3dws.10) If the trust is being changed, it will be placed into the UPDATING state, which indicates that the resource is being reconciled. At this point, Get will reflect an intermediate state.
        :param pulumi.Input[str] create_time: The time the instance was created.
        :param pulumi.Input[str] last_known_trust_connected_heartbeat_time: The last heartbeat time when the trust was known to be connected.
        :param pulumi.Input[bool] selective_authentication: The trust authentication type which decides whether the trusted side has forest/domain wide access or selective access to approved set of resources.
        :param pulumi.Input[str] state: The current state of this trust.
        :param pulumi.Input[str] state_description: Additional information about the current state of this trust, if available.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_dns_ip_addresses: The target dns server ip addresses which can resolve the remote domain involved in trust.
        :param pulumi.Input[str] target_domain_name: The fully qualified target domain name which will be in trust with current domain.
        :param pulumi.Input[str] trust_direction: The trust direction decides the current domain is trusted, trusting or both.
        :param pulumi.Input[str] trust_handshake_secret: Input only, and will not be stored. The trust secret used for handshake with target domain.
        :param pulumi.Input[str] trust_type: The type of trust represented by the trust resource.
        :param pulumi.Input[str] update_time: Last update time.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if last_known_trust_connected_heartbeat_time is not None:
            pulumi.set(__self__, "last_known_trust_connected_heartbeat_time", last_known_trust_connected_heartbeat_time)
        if selective_authentication is not None:
            pulumi.set(__self__, "selective_authentication", selective_authentication)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_description is not None:
            pulumi.set(__self__, "state_description", state_description)
        if target_dns_ip_addresses is not None:
            pulumi.set(__self__, "target_dns_ip_addresses", target_dns_ip_addresses)
        if target_domain_name is not None:
            pulumi.set(__self__, "target_domain_name", target_domain_name)
        if trust_direction is not None:
            pulumi.set(__self__, "trust_direction", trust_direction)
        if trust_handshake_secret is not None:
            pulumi.set(__self__, "trust_handshake_secret", trust_handshake_secret)
        if trust_type is not None:
            pulumi.set(__self__, "trust_type", trust_type)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time the instance was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="lastKnownTrustConnectedHeartbeatTime")
    def last_known_trust_connected_heartbeat_time(self) -> Optional[pulumi.Input[str]]:
        """
        The last heartbeat time when the trust was known to be connected.
        """
        return pulumi.get(self, "last_known_trust_connected_heartbeat_time")

    @last_known_trust_connected_heartbeat_time.setter
    def last_known_trust_connected_heartbeat_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_known_trust_connected_heartbeat_time", value)

    @property
    @pulumi.getter(name="selectiveAuthentication")
    def selective_authentication(self) -> Optional[pulumi.Input[bool]]:
        """
        The trust authentication type which decides whether the trusted side has forest/domain wide access or selective access to approved set of resources.
        """
        return pulumi.get(self, "selective_authentication")

    @selective_authentication.setter
    def selective_authentication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "selective_authentication", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of this trust.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stateDescription")
    def state_description(self) -> Optional[pulumi.Input[str]]:
        """
        Additional information about the current state of this trust, if available.
        """
        return pulumi.get(self, "state_description")

    @state_description.setter
    def state_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state_description", value)

    @property
    @pulumi.getter(name="targetDnsIpAddresses")
    def target_dns_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The target dns server ip addresses which can resolve the remote domain involved in trust.
        """
        return pulumi.get(self, "target_dns_ip_addresses")

    @target_dns_ip_addresses.setter
    def target_dns_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "target_dns_ip_addresses", value)

    @property
    @pulumi.getter(name="targetDomainName")
    def target_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified target domain name which will be in trust with current domain.
        """
        return pulumi.get(self, "target_domain_name")

    @target_domain_name.setter
    def target_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_domain_name", value)

    @property
    @pulumi.getter(name="trustDirection")
    def trust_direction(self) -> Optional[pulumi.Input[str]]:
        """
        The trust direction decides the current domain is trusted, trusting or both.
        """
        return pulumi.get(self, "trust_direction")

    @trust_direction.setter
    def trust_direction(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trust_direction", value)

    @property
    @pulumi.getter(name="trustHandshakeSecret")
    def trust_handshake_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Input only, and will not be stored. The trust secret used for handshake with target domain.
        """
        return pulumi.get(self, "trust_handshake_secret")

    @trust_handshake_secret.setter
    def trust_handshake_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trust_handshake_secret", value)

    @property
    @pulumi.getter(name="trustType")
    def trust_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of trust represented by the trust resource.
        """
        return pulumi.get(self, "trust_type")

    @trust_type.setter
    def trust_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trust_type", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Last update time.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


