# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs

__all__ = [
    'AuditConfigResponse',
    'AuditLogConfigResponse',
    'AuthorizationLoggingOptionsResponse',
    'BindingResponse',
    'CloudAuditOptionsResponse',
    'ConditionResponse',
    'CounterOptionsResponse',
    'CustomFieldResponse',
    'DataAccessOptionsResponse',
    'ExprResponse',
    'FleetConfigResponse',
    'GameServerClusterConnectionInfoResponse',
    'GkeClusterReferenceResponse',
    'LabelSelectorResponse',
    'LogConfigResponse',
    'RuleResponse',
    'ScalingConfigResponse',
    'ScheduleResponse',
]

@pulumi.output_type
class AuditConfigResponse(dict):
    """
    Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
    """
    def __init__(__self__, *,
                 audit_log_configs: Sequence['outputs.AuditLogConfigResponse'],
                 exempted_members: Sequence[str],
                 service: str):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
        :param Sequence['AuditLogConfigResponseArgs'] audit_log_configs: The configuration for logging of each type of permission.
        :param str service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Sequence['outputs.AuditLogConfigResponse']:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AuditLogConfigResponse(dict):
    """
    Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
    """
    def __init__(__self__, *,
                 exempted_members: Sequence[str],
                 ignore_child_exemptions: bool,
                 log_type: str):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param Sequence[str] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param str log_type: The log type that this config enables.
        """
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "ignore_child_exemptions", ignore_child_exemptions)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter(name="ignoreChildExemptions")
    def ignore_child_exemptions(self) -> bool:
        return pulumi.get(self, "ignore_child_exemptions")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AuthorizationLoggingOptionsResponse(dict):
    """
    Authorization-related information used by Cloud Audit Logging.
    """
    def __init__(__self__, *,
                 permission_type: str):
        """
        Authorization-related information used by Cloud Audit Logging.
        :param str permission_type: The type of the permission that was checked.
        """
        pulumi.set(__self__, "permission_type", permission_type)

    @property
    @pulumi.getter(name="permissionType")
    def permission_type(self) -> str:
        """
        The type of the permission that was checked.
        """
        return pulumi.get(self, "permission_type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class BindingResponse(dict):
    """
    Associates `members` with a `role`.
    """
    def __init__(__self__, *,
                 binding_id: str,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members` with a `role`.
        :param 'ExprResponseArgs' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the identities requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "binding_id", binding_id)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter(name="bindingId")
    def binding_id(self) -> str:
        return pulumi.get(self, "binding_id")

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the identities requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class CloudAuditOptionsResponse(dict):
    """
    Write a Cloud Audit log
    """
    def __init__(__self__, *,
                 authorization_logging_options: 'outputs.AuthorizationLoggingOptionsResponse',
                 log_name: str):
        """
        Write a Cloud Audit log
        :param 'AuthorizationLoggingOptionsResponseArgs' authorization_logging_options: Information used by the Cloud Audit Logging pipeline.
        :param str log_name: The log_name to populate in the Cloud Audit Record.
        """
        pulumi.set(__self__, "authorization_logging_options", authorization_logging_options)
        pulumi.set(__self__, "log_name", log_name)

    @property
    @pulumi.getter(name="authorizationLoggingOptions")
    def authorization_logging_options(self) -> 'outputs.AuthorizationLoggingOptionsResponse':
        """
        Information used by the Cloud Audit Logging pipeline.
        """
        return pulumi.get(self, "authorization_logging_options")

    @property
    @pulumi.getter(name="logName")
    def log_name(self) -> str:
        """
        The log_name to populate in the Cloud Audit Record.
        """
        return pulumi.get(self, "log_name")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ConditionResponse(dict):
    """
    A condition to be met.
    """
    def __init__(__self__, *,
                 iam: str,
                 op: str,
                 svc: str,
                 sys: str,
                 values: Sequence[str]):
        """
        A condition to be met.
        :param str iam: Trusted attributes supplied by the IAM system.
        :param str op: An operator to apply the subject with.
        :param str svc: Trusted attributes discharged by the service.
        :param str sys: Trusted attributes supplied by any service that owns resources and uses the IAM system for access control.
        :param Sequence[str] values: The objects of the condition.
        """
        pulumi.set(__self__, "iam", iam)
        pulumi.set(__self__, "op", op)
        pulumi.set(__self__, "svc", svc)
        pulumi.set(__self__, "sys", sys)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def iam(self) -> str:
        """
        Trusted attributes supplied by the IAM system.
        """
        return pulumi.get(self, "iam")

    @property
    @pulumi.getter
    def op(self) -> str:
        """
        An operator to apply the subject with.
        """
        return pulumi.get(self, "op")

    @property
    @pulumi.getter
    def svc(self) -> str:
        """
        Trusted attributes discharged by the service.
        """
        return pulumi.get(self, "svc")

    @property
    @pulumi.getter
    def sys(self) -> str:
        """
        Trusted attributes supplied by any service that owns resources and uses the IAM system for access control.
        """
        return pulumi.get(self, "sys")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The objects of the condition.
        """
        return pulumi.get(self, "values")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class CounterOptionsResponse(dict):
    """
    Increment a streamz counter with the specified metric and field names. Metric names should start with a '/', generally be lowercase-only, and end in "_count". Field names should not contain an initial slash. The actual exported metric names will have "/iam/policy" prepended. Field names correspond to IAM request parameters and field values are their respective values. Supported field names: - "authority", which is "[token]" if IAMContext.token is present, otherwise the value of IAMContext.authority_selector if present, and otherwise a representation of IAMContext.principal; or - "iam_principal", a representation of IAMContext.principal even if a token or authority selector is present; or - "" (empty string), resulting in a counter with no fields. Examples: counter { metric: "/debug_access_count" field: "iam_principal" } ==> increment counter /iam/policy/debug_access_count {iam_principal=[value of IAMContext.principal]}
    """
    def __init__(__self__, *,
                 custom_fields: Sequence['outputs.CustomFieldResponse'],
                 field: str,
                 metric: str):
        """
        Increment a streamz counter with the specified metric and field names. Metric names should start with a '/', generally be lowercase-only, and end in "_count". Field names should not contain an initial slash. The actual exported metric names will have "/iam/policy" prepended. Field names correspond to IAM request parameters and field values are their respective values. Supported field names: - "authority", which is "[token]" if IAMContext.token is present, otherwise the value of IAMContext.authority_selector if present, and otherwise a representation of IAMContext.principal; or - "iam_principal", a representation of IAMContext.principal even if a token or authority selector is present; or - "" (empty string), resulting in a counter with no fields. Examples: counter { metric: "/debug_access_count" field: "iam_principal" } ==> increment counter /iam/policy/debug_access_count {iam_principal=[value of IAMContext.principal]}
        :param Sequence['CustomFieldResponseArgs'] custom_fields: Custom fields.
        :param str field: The field value to attribute.
        :param str metric: The metric to update.
        """
        pulumi.set(__self__, "custom_fields", custom_fields)
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "metric", metric)

    @property
    @pulumi.getter(name="customFields")
    def custom_fields(self) -> Sequence['outputs.CustomFieldResponse']:
        """
        Custom fields.
        """
        return pulumi.get(self, "custom_fields")

    @property
    @pulumi.getter
    def field(self) -> str:
        """
        The field value to attribute.
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter
    def metric(self) -> str:
        """
        The metric to update.
        """
        return pulumi.get(self, "metric")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class CustomFieldResponse(dict):
    """
    Custom fields. These can be used to create a counter with arbitrary field/value pairs. See: go/rpcsp-custom-fields.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        Custom fields. These can be used to create a counter with arbitrary field/value pairs. See: go/rpcsp-custom-fields.
        :param str name: Name is the field name.
        :param str value: Value is the field value. It is important that in contrast to the CounterOptions.field, the value here is a constant that is not derived from the IAMContext.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name is the field name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value is the field value. It is important that in contrast to the CounterOptions.field, the value here is a constant that is not derived from the IAMContext.
        """
        return pulumi.get(self, "value")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DataAccessOptionsResponse(dict):
    """
    Write a Data Access (Gin) log
    """
    def __init__(__self__, *,
                 log_mode: str):
        """
        Write a Data Access (Gin) log
        """
        pulumi.set(__self__, "log_mode", log_mode)

    @property
    @pulumi.getter(name="logMode")
    def log_mode(self) -> str:
        return pulumi.get(self, "log_mode")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class FleetConfigResponse(dict):
    """
    Fleet configs for Agones.
    """
    def __init__(__self__, *,
                 fleet_spec: str,
                 name: str):
        """
        Fleet configs for Agones.
        :param str fleet_spec: Agones fleet spec. Example spec: `https://agones.dev/site/docs/reference/fleet/`.
        :param str name: The name of the FleetConfig.
        """
        pulumi.set(__self__, "fleet_spec", fleet_spec)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="fleetSpec")
    def fleet_spec(self) -> str:
        """
        Agones fleet spec. Example spec: `https://agones.dev/site/docs/reference/fleet/`.
        """
        return pulumi.get(self, "fleet_spec")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the FleetConfig.
        """
        return pulumi.get(self, "name")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GameServerClusterConnectionInfoResponse(dict):
    """
    The game server cluster connection information.
    """
    def __init__(__self__, *,
                 gke_cluster_reference: 'outputs.GkeClusterReferenceResponse',
                 namespace: str):
        """
        The game server cluster connection information.
        :param 'GkeClusterReferenceResponseArgs' gke_cluster_reference: Reference to the GKE cluster where the game servers are installed.
        :param str namespace: Namespace designated on the game server cluster where the Agones game server instances will be created. Existence of the namespace will be validated during creation.
        """
        pulumi.set(__self__, "gke_cluster_reference", gke_cluster_reference)
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="gkeClusterReference")
    def gke_cluster_reference(self) -> 'outputs.GkeClusterReferenceResponse':
        """
        Reference to the GKE cluster where the game servers are installed.
        """
        return pulumi.get(self, "gke_cluster_reference")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Namespace designated on the game server cluster where the Agones game server instances will be created. Existence of the namespace will be validated during creation.
        """
        return pulumi.get(self, "namespace")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GkeClusterReferenceResponse(dict):
    """
    A reference to a GKE cluster.
    """
    def __init__(__self__, *,
                 cluster: str):
        """
        A reference to a GKE cluster.
        :param str cluster: The full or partial name of a GKE cluster, using one of the following forms: * `projects/{project}/locations/{location}/clusters/{cluster}` * `locations/{location}/clusters/{cluster}` * `{cluster}` If project and location are not specified, the project and location of the GameServerCluster resource are used to generate the full name of the GKE cluster.
        """
        pulumi.set(__self__, "cluster", cluster)

    @property
    @pulumi.getter
    def cluster(self) -> str:
        """
        The full or partial name of a GKE cluster, using one of the following forms: * `projects/{project}/locations/{location}/clusters/{cluster}` * `locations/{location}/clusters/{cluster}` * `{cluster}` If project and location are not specified, the project and location of the GameServerCluster resource are used to generate the full name of the GKE cluster.
        """
        return pulumi.get(self, "cluster")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class LabelSelectorResponse(dict):
    """
    The label selector, used to group labels on the resources.
    """
    def __init__(__self__, *,
                 labels: Mapping[str, str]):
        """
        The label selector, used to group labels on the resources.
        :param Mapping[str, str] labels: Resource labels for this selector.
        """
        pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Resource labels for this selector.
        """
        return pulumi.get(self, "labels")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class LogConfigResponse(dict):
    """
    Specifies what kind of log the caller must write
    """
    def __init__(__self__, *,
                 cloud_audit: 'outputs.CloudAuditOptionsResponse',
                 counter: 'outputs.CounterOptionsResponse',
                 data_access: 'outputs.DataAccessOptionsResponse'):
        """
        Specifies what kind of log the caller must write
        :param 'CloudAuditOptionsResponseArgs' cloud_audit: Cloud audit options.
        :param 'CounterOptionsResponseArgs' counter: Counter options.
        :param 'DataAccessOptionsResponseArgs' data_access: Data access options.
        """
        pulumi.set(__self__, "cloud_audit", cloud_audit)
        pulumi.set(__self__, "counter", counter)
        pulumi.set(__self__, "data_access", data_access)

    @property
    @pulumi.getter(name="cloudAudit")
    def cloud_audit(self) -> 'outputs.CloudAuditOptionsResponse':
        """
        Cloud audit options.
        """
        return pulumi.get(self, "cloud_audit")

    @property
    @pulumi.getter
    def counter(self) -> 'outputs.CounterOptionsResponse':
        """
        Counter options.
        """
        return pulumi.get(self, "counter")

    @property
    @pulumi.getter(name="dataAccess")
    def data_access(self) -> 'outputs.DataAccessOptionsResponse':
        """
        Data access options.
        """
        return pulumi.get(self, "data_access")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class RuleResponse(dict):
    """
    A rule to be applied in a Policy.
    """
    def __init__(__self__, *,
                 action: str,
                 conditions: Sequence['outputs.ConditionResponse'],
                 description: str,
                 in_: Sequence[str],
                 log_config: Sequence['outputs.LogConfigResponse'],
                 not_in: Sequence[str],
                 permissions: Sequence[str]):
        """
        A rule to be applied in a Policy.
        :param str action: Required
        :param Sequence['ConditionResponseArgs'] conditions: Additional restrictions that must be met. All conditions must pass for the rule to match.
        :param str description: Human-readable description of the rule.
        :param Sequence[str] in_: If one or more 'in' clauses are specified, the rule matches if the PRINCIPAL/AUTHORITY_SELECTOR is in at least one of these entries.
        :param Sequence['LogConfigResponseArgs'] log_config: The config returned to callers of tech.iam.IAM.CheckPolicy for any entries that match the LOG action.
        :param Sequence[str] not_in: If one or more 'not_in' clauses are specified, the rule matches if the PRINCIPAL/AUTHORITY_SELECTOR is in none of the entries. The format for in and not_in entries can be found at in the Local IAM documentation (see go/local-iam#features).
        :param Sequence[str] permissions: A permission is a string of form '..' (e.g., 'storage.buckets.list'). A value of '*' matches all permissions, and a verb part of '*' (e.g., 'storage.buckets.*') matches all verbs.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "in_", in_)
        pulumi.set(__self__, "log_config", log_config)
        pulumi.set(__self__, "not_in", not_in)
        pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Required
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.ConditionResponse']:
        """
        Additional restrictions that must be met. All conditions must pass for the rule to match.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Human-readable description of the rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="in")
    def in_(self) -> Sequence[str]:
        """
        If one or more 'in' clauses are specified, the rule matches if the PRINCIPAL/AUTHORITY_SELECTOR is in at least one of these entries.
        """
        return pulumi.get(self, "in_")

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Sequence['outputs.LogConfigResponse']:
        """
        The config returned to callers of tech.iam.IAM.CheckPolicy for any entries that match the LOG action.
        """
        return pulumi.get(self, "log_config")

    @property
    @pulumi.getter(name="notIn")
    def not_in(self) -> Sequence[str]:
        """
        If one or more 'not_in' clauses are specified, the rule matches if the PRINCIPAL/AUTHORITY_SELECTOR is in none of the entries. The format for in and not_in entries can be found at in the Local IAM documentation (see go/local-iam#features).
        """
        return pulumi.get(self, "not_in")

    @property
    @pulumi.getter
    def permissions(self) -> Sequence[str]:
        """
        A permission is a string of form '..' (e.g., 'storage.buckets.list'). A value of '*' matches all permissions, and a verb part of '*' (e.g., 'storage.buckets.*') matches all verbs.
        """
        return pulumi.get(self, "permissions")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ScalingConfigResponse(dict):
    """
    Autoscaling config for an Agones fleet.
    """
    def __init__(__self__, *,
                 fleet_autoscaler_spec: str,
                 name: str,
                 schedules: Sequence['outputs.ScheduleResponse'],
                 selectors: Sequence['outputs.LabelSelectorResponse']):
        """
        Autoscaling config for an Agones fleet.
        :param str fleet_autoscaler_spec: Required. Agones fleet autoscaler spec. Example spec: https://agones.dev/site/docs/reference/fleetautoscaler/
        :param str name: Required. The name of the Scaling Config
        :param Sequence['ScheduleResponseArgs'] schedules: The schedules to which this Scaling Config applies.
        :param Sequence['LabelSelectorResponseArgs'] selectors: Labels used to identify the game server clusters to which this Agones scaling config applies. A game server cluster is subject to this Agones scaling config if its labels match any of the selector entries.
        """
        pulumi.set(__self__, "fleet_autoscaler_spec", fleet_autoscaler_spec)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "schedules", schedules)
        pulumi.set(__self__, "selectors", selectors)

    @property
    @pulumi.getter(name="fleetAutoscalerSpec")
    def fleet_autoscaler_spec(self) -> str:
        """
        Required. Agones fleet autoscaler spec. Example spec: https://agones.dev/site/docs/reference/fleetautoscaler/
        """
        return pulumi.get(self, "fleet_autoscaler_spec")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Required. The name of the Scaling Config
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schedules(self) -> Sequence['outputs.ScheduleResponse']:
        """
        The schedules to which this Scaling Config applies.
        """
        return pulumi.get(self, "schedules")

    @property
    @pulumi.getter
    def selectors(self) -> Sequence['outputs.LabelSelectorResponse']:
        """
        Labels used to identify the game server clusters to which this Agones scaling config applies. A game server cluster is subject to this Agones scaling config if its labels match any of the selector entries.
        """
        return pulumi.get(self, "selectors")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ScheduleResponse(dict):
    """
    The schedule of a recurring or one time event. The event's time span is specified by start_time and end_time. If the scheduled event's timespan is larger than the cron_spec + cron_job_duration, the event will be recurring. If only cron_spec + cron_job_duration are specified, the event is effective starting at the local time specified by cron_spec, and is recurring. start_time|-------[cron job]-------[cron job]-------[cron job]---|end_time cron job: cron spec start time + duration
    """
    def __init__(__self__, *,
                 cron_job_duration: str,
                 cron_spec: str,
                 end_time: str,
                 start_time: str):
        """
        The schedule of a recurring or one time event. The event's time span is specified by start_time and end_time. If the scheduled event's timespan is larger than the cron_spec + cron_job_duration, the event will be recurring. If only cron_spec + cron_job_duration are specified, the event is effective starting at the local time specified by cron_spec, and is recurring. start_time|-------[cron job]-------[cron job]-------[cron job]---|end_time cron job: cron spec start time + duration
        :param str cron_job_duration: The duration for the cron job event. The duration of the event is effective after the cron job's start time.
        :param str cron_spec: The cron definition of the scheduled event. See https://en.wikipedia.org/wiki/Cron. Cron spec specifies the local time as defined by the realm.
        :param str end_time: The end time of the event.
        :param str start_time: The start time of the event.
        """
        pulumi.set(__self__, "cron_job_duration", cron_job_duration)
        pulumi.set(__self__, "cron_spec", cron_spec)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="cronJobDuration")
    def cron_job_duration(self) -> str:
        """
        The duration for the cron job event. The duration of the event is effective after the cron job's start time.
        """
        return pulumi.get(self, "cron_job_duration")

    @property
    @pulumi.getter(name="cronSpec")
    def cron_spec(self) -> str:
        """
        The cron definition of the scheduled event. See https://en.wikipedia.org/wiki/Cron. Cron spec specifies the local time as defined by the realm.
        """
        return pulumi.get(self, "cron_spec")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The end time of the event.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The start time of the event.
        """
        return pulumi.get(self, "start_time")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


