# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['RegionJob']


class RegionJob(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 hadoop_job: Optional[pulumi.Input[pulumi.InputType['HadoopJobArgs']]] = None,
                 hive_job: Optional[pulumi.Input[pulumi.InputType['HiveJobArgs']]] = None,
                 job_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 pig_job: Optional[pulumi.Input[pulumi.InputType['PigJobArgs']]] = None,
                 placement: Optional[pulumi.Input[pulumi.InputType['JobPlacementArgs']]] = None,
                 presto_job: Optional[pulumi.Input[pulumi.InputType['PrestoJobArgs']]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 pyspark_job: Optional[pulumi.Input[pulumi.InputType['PySparkJobArgs']]] = None,
                 reference: Optional[pulumi.Input[pulumi.InputType['JobReferenceArgs']]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 scheduling: Optional[pulumi.Input[pulumi.InputType['JobSchedulingArgs']]] = None,
                 spark_job: Optional[pulumi.Input[pulumi.InputType['SparkJobArgs']]] = None,
                 spark_r_job: Optional[pulumi.Input[pulumi.InputType['SparkRJobArgs']]] = None,
                 spark_sql_job: Optional[pulumi.Input[pulumi.InputType['SparkSqlJobArgs']]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Submits a job to a cluster.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['HadoopJobArgs']] hadoop_job: Optional. Job is a Hadoop job.
        :param pulumi.Input[pulumi.InputType['HiveJobArgs']] hive_job: Optional. Job is a Hive job.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional. The labels to associate with this job. Label keys must contain 1 to 63 characters, and must conform to RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt). Label values may be empty, but, if present, must contain 1 to 63 characters, and must conform to RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be associated with a job.
        :param pulumi.Input[pulumi.InputType['PigJobArgs']] pig_job: Optional. Job is a Pig job.
        :param pulumi.Input[pulumi.InputType['JobPlacementArgs']] placement: Required. Job information, including how, when, and where to run the job.
        :param pulumi.Input[pulumi.InputType['PrestoJobArgs']] presto_job: Optional. Job is a Presto job.
        :param pulumi.Input[pulumi.InputType['PySparkJobArgs']] pyspark_job: Optional. Job is a PySpark job.
        :param pulumi.Input[pulumi.InputType['JobReferenceArgs']] reference: Optional. The fully qualified reference to the job, which can be used to obtain the equivalent REST path of the job resource. If this property is not specified when a job is created, the server generates a job_id.
        :param pulumi.Input[str] request_id: Optional. A unique id used to identify the request. If the server receives two SubmitJobRequest (https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1beta2#google.cloud.dataproc.v1.SubmitJobRequest)s with the same id, then the second request will be ignored and the first Job created and stored in the backend is returned.It is recommended to always set this value to a UUID (https://en.wikipedia.org/wiki/Universally_unique_identifier).The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens (-). The maximum length is 40 characters.
        :param pulumi.Input[pulumi.InputType['JobSchedulingArgs']] scheduling: Optional. Job scheduling configuration.
        :param pulumi.Input[pulumi.InputType['SparkJobArgs']] spark_job: Optional. Job is a Spark job.
        :param pulumi.Input[pulumi.InputType['SparkRJobArgs']] spark_r_job: Optional. Job is a SparkR job.
        :param pulumi.Input[pulumi.InputType['SparkSqlJobArgs']] spark_sql_job: Optional. Job is a SparkSql job.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['hadoop_job'] = hadoop_job
            __props__['hive_job'] = hive_job
            if job_id is None and not opts.urn:
                raise TypeError("Missing required property 'job_id'")
            __props__['job_id'] = job_id
            __props__['labels'] = labels
            __props__['pig_job'] = pig_job
            __props__['placement'] = placement
            __props__['presto_job'] = presto_job
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__['project_id'] = project_id
            __props__['pyspark_job'] = pyspark_job
            __props__['reference'] = reference
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__['region'] = region
            __props__['request_id'] = request_id
            __props__['scheduling'] = scheduling
            __props__['spark_job'] = spark_job
            __props__['spark_r_job'] = spark_r_job
            __props__['spark_sql_job'] = spark_sql_job
            __props__['done'] = None
            __props__['driver_control_files_uri'] = None
            __props__['driver_output_resource_uri'] = None
            __props__['job_uuid'] = None
            __props__['status'] = None
            __props__['status_history'] = None
            __props__['submitted_by'] = None
            __props__['yarn_applications'] = None
        super(RegionJob, __self__).__init__(
            'gcp-native:dataproc/v1beta2:RegionJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'RegionJob':
        """
        Get an existing RegionJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["done"] = None
        __props__["driver_control_files_uri"] = None
        __props__["driver_output_resource_uri"] = None
        __props__["hadoop_job"] = None
        __props__["hive_job"] = None
        __props__["job_uuid"] = None
        __props__["labels"] = None
        __props__["pig_job"] = None
        __props__["placement"] = None
        __props__["presto_job"] = None
        __props__["pyspark_job"] = None
        __props__["reference"] = None
        __props__["scheduling"] = None
        __props__["spark_job"] = None
        __props__["spark_r_job"] = None
        __props__["spark_sql_job"] = None
        __props__["status"] = None
        __props__["status_history"] = None
        __props__["submitted_by"] = None
        __props__["yarn_applications"] = None
        return RegionJob(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def done(self) -> pulumi.Output[bool]:
        """
        Indicates whether the job is completed. If the value is false, the job is still in progress. If true, the job is completed, and status.state field will indicate if it was successful, failed, or cancelled.
        """
        return pulumi.get(self, "done")

    @property
    @pulumi.getter(name="driverControlFilesUri")
    def driver_control_files_uri(self) -> pulumi.Output[str]:
        """
        If present, the location of miscellaneous control files which may be used as part of job setup and handling. If not present, control files may be placed in the same location as driver_output_uri.
        """
        return pulumi.get(self, "driver_control_files_uri")

    @property
    @pulumi.getter(name="driverOutputResourceUri")
    def driver_output_resource_uri(self) -> pulumi.Output[str]:
        """
        A URI pointing to the location of the stdout of the job's driver program.
        """
        return pulumi.get(self, "driver_output_resource_uri")

    @property
    @pulumi.getter(name="hadoopJob")
    def hadoop_job(self) -> pulumi.Output['outputs.HadoopJobResponse']:
        """
        Optional. Job is a Hadoop job.
        """
        return pulumi.get(self, "hadoop_job")

    @property
    @pulumi.getter(name="hiveJob")
    def hive_job(self) -> pulumi.Output['outputs.HiveJobResponse']:
        """
        Optional. Job is a Hive job.
        """
        return pulumi.get(self, "hive_job")

    @property
    @pulumi.getter(name="jobUuid")
    def job_uuid(self) -> pulumi.Output[str]:
        """
        A UUID that uniquely identifies a job within the project over time. This is in contrast to a user-settable reference.job_id that may be reused over time.
        """
        return pulumi.get(self, "job_uuid")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Optional. The labels to associate with this job. Label keys must contain 1 to 63 characters, and must conform to RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt). Label values may be empty, but, if present, must contain 1 to 63 characters, and must conform to RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be associated with a job.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="pigJob")
    def pig_job(self) -> pulumi.Output['outputs.PigJobResponse']:
        """
        Optional. Job is a Pig job.
        """
        return pulumi.get(self, "pig_job")

    @property
    @pulumi.getter
    def placement(self) -> pulumi.Output['outputs.JobPlacementResponse']:
        """
        Required. Job information, including how, when, and where to run the job.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="prestoJob")
    def presto_job(self) -> pulumi.Output['outputs.PrestoJobResponse']:
        """
        Optional. Job is a Presto job.
        """
        return pulumi.get(self, "presto_job")

    @property
    @pulumi.getter(name="pysparkJob")
    def pyspark_job(self) -> pulumi.Output['outputs.PySparkJobResponse']:
        """
        Optional. Job is a PySpark job.
        """
        return pulumi.get(self, "pyspark_job")

    @property
    @pulumi.getter
    def reference(self) -> pulumi.Output['outputs.JobReferenceResponse']:
        """
        Optional. The fully qualified reference to the job, which can be used to obtain the equivalent REST path of the job resource. If this property is not specified when a job is created, the server generates a job_id.
        """
        return pulumi.get(self, "reference")

    @property
    @pulumi.getter
    def scheduling(self) -> pulumi.Output['outputs.JobSchedulingResponse']:
        """
        Optional. Job scheduling configuration.
        """
        return pulumi.get(self, "scheduling")

    @property
    @pulumi.getter(name="sparkJob")
    def spark_job(self) -> pulumi.Output['outputs.SparkJobResponse']:
        """
        Optional. Job is a Spark job.
        """
        return pulumi.get(self, "spark_job")

    @property
    @pulumi.getter(name="sparkRJob")
    def spark_r_job(self) -> pulumi.Output['outputs.SparkRJobResponse']:
        """
        Optional. Job is a SparkR job.
        """
        return pulumi.get(self, "spark_r_job")

    @property
    @pulumi.getter(name="sparkSqlJob")
    def spark_sql_job(self) -> pulumi.Output['outputs.SparkSqlJobResponse']:
        """
        Optional. Job is a SparkSql job.
        """
        return pulumi.get(self, "spark_sql_job")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['outputs.JobStatusResponse']:
        """
        The job status. Additional application-specific status information may be contained in the type_job and yarn_applications fields.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusHistory")
    def status_history(self) -> pulumi.Output[Sequence['outputs.JobStatusResponse']]:
        """
        The previous job status.
        """
        return pulumi.get(self, "status_history")

    @property
    @pulumi.getter(name="submittedBy")
    def submitted_by(self) -> pulumi.Output[str]:
        """
        The email address of the user submitting the job. For jobs submitted on the cluster, the address is username@hostname.
        """
        return pulumi.get(self, "submitted_by")

    @property
    @pulumi.getter(name="yarnApplications")
    def yarn_applications(self) -> pulumi.Output[Sequence['outputs.YarnApplicationResponse']]:
        """
        The collection of YARN applications spun up by this job.Beta Feature: This report is available for testing purposes only. It may be changed before final release.
        """
        return pulumi.get(self, "yarn_applications")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

