# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs

__all__ = [
    'AcceleratorConfigResponse',
    'AddonsConfigResponse',
    'AuthenticatorGroupsConfigResponse',
    'AutoUpgradeOptionsResponse',
    'AutopilotResponse',
    'AutoprovisioningNodePoolDefaultsResponse',
    'BigQueryDestinationResponse',
    'BinaryAuthorizationResponse',
    'CidrBlockResponse',
    'ClientCertificateConfigResponse',
    'CloudRunConfigResponse',
    'ClusterAutoscalingResponse',
    'ConfigConnectorConfigResponse',
    'ConsumptionMeteringConfigResponse',
    'DailyMaintenanceWindowResponse',
    'DatabaseEncryptionResponse',
    'DefaultSnatStatusResponse',
    'DnsCacheConfigResponse',
    'GcePersistentDiskCsiDriverConfigResponse',
    'HorizontalPodAutoscalingResponse',
    'HttpLoadBalancingResponse',
    'IPAllocationPolicyResponse',
    'KubernetesDashboardResponse',
    'LegacyAbacResponse',
    'LinuxNodeConfigResponse',
    'MaintenancePolicyResponse',
    'MaintenanceWindowResponse',
    'MasterAuthResponse',
    'MasterAuthorizedNetworksConfigResponse',
    'MaxPodsConstraintResponse',
    'NetworkConfigResponse',
    'NetworkPolicyConfigResponse',
    'NetworkPolicyResponse',
    'NodeConfigResponse',
    'NodeKubeletConfigResponse',
    'NodeManagementResponse',
    'NodePoolAutoscalingResponse',
    'NodePoolResponse',
    'NodeTaintResponse',
    'NotificationConfigResponse',
    'PrivateClusterConfigResponse',
    'PrivateClusterMasterGlobalAccessConfigResponse',
    'PubSubResponse',
    'RecurringTimeWindowResponse',
    'ReleaseChannelResponse',
    'ReservationAffinityResponse',
    'ResourceLimitResponse',
    'ResourceUsageExportConfigResponse',
    'SandboxConfigResponse',
    'ShieldedInstanceConfigResponse',
    'ShieldedNodesResponse',
    'StatusConditionResponse',
    'TimeWindowResponse',
    'UpgradeSettingsResponse',
    'VerticalPodAutoscalingResponse',
    'WorkloadIdentityConfigResponse',
    'WorkloadMetadataConfigResponse',
]

@pulumi.output_type
class AcceleratorConfigResponse(dict):
    """
    AcceleratorConfig represents a Hardware Accelerator request.
    """
    def __init__(__self__, *,
                 accelerator_count: str,
                 accelerator_type: str):
        """
        AcceleratorConfig represents a Hardware Accelerator request.
        :param str accelerator_count: The number of the accelerator cards exposed to an instance.
        :param str accelerator_type: The accelerator type resource name. List of supported accelerators [here](https://cloud.google.com/compute/docs/gpus)
        """
        pulumi.set(__self__, "accelerator_count", accelerator_count)
        pulumi.set(__self__, "accelerator_type", accelerator_type)

    @property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> str:
        """
        The number of the accelerator cards exposed to an instance.
        """
        return pulumi.get(self, "accelerator_count")

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> str:
        """
        The accelerator type resource name. List of supported accelerators [here](https://cloud.google.com/compute/docs/gpus)
        """
        return pulumi.get(self, "accelerator_type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AddonsConfigResponse(dict):
    """
    Configuration for the addons that can be automatically spun up in the cluster, enabling additional functionality.
    """
    def __init__(__self__, *,
                 cloud_run_config: 'outputs.CloudRunConfigResponse',
                 config_connector_config: 'outputs.ConfigConnectorConfigResponse',
                 dns_cache_config: 'outputs.DnsCacheConfigResponse',
                 gce_persistent_disk_csi_driver_config: 'outputs.GcePersistentDiskCsiDriverConfigResponse',
                 horizontal_pod_autoscaling: 'outputs.HorizontalPodAutoscalingResponse',
                 http_load_balancing: 'outputs.HttpLoadBalancingResponse',
                 kubernetes_dashboard: 'outputs.KubernetesDashboardResponse',
                 network_policy_config: 'outputs.NetworkPolicyConfigResponse'):
        """
        Configuration for the addons that can be automatically spun up in the cluster, enabling additional functionality.
        :param 'CloudRunConfigResponseArgs' cloud_run_config: Configuration for the Cloud Run addon, which allows the user to use a managed Knative service.
        :param 'ConfigConnectorConfigResponseArgs' config_connector_config: Configuration for the ConfigConnector add-on, a Kubernetes extension to manage hosted GCP services through the Kubernetes API
        :param 'DnsCacheConfigResponseArgs' dns_cache_config: Configuration for NodeLocalDNS, a dns cache running on cluster nodes
        :param 'GcePersistentDiskCsiDriverConfigResponseArgs' gce_persistent_disk_csi_driver_config: Configuration for the Compute Engine Persistent Disk CSI driver.
        :param 'HorizontalPodAutoscalingResponseArgs' horizontal_pod_autoscaling: Configuration for the horizontal pod autoscaling feature, which increases or decreases the number of replica pods a replication controller has based on the resource usage of the existing pods.
        :param 'HttpLoadBalancingResponseArgs' http_load_balancing: Configuration for the HTTP (L7) load balancing controller addon, which makes it easy to set up HTTP load balancers for services in a cluster.
        :param 'KubernetesDashboardResponseArgs' kubernetes_dashboard: Configuration for the Kubernetes Dashboard. This addon is deprecated, and will be disabled in 1.15. It is recommended to use the Cloud Console to manage and monitor your Kubernetes clusters, workloads and applications. For more information, see: https://cloud.google.com/kubernetes-engine/docs/concepts/dashboards
        :param 'NetworkPolicyConfigResponseArgs' network_policy_config: Configuration for NetworkPolicy. This only tracks whether the addon is enabled or not on the Master, it does not track whether network policy is enabled for the nodes.
        """
        pulumi.set(__self__, "cloud_run_config", cloud_run_config)
        pulumi.set(__self__, "config_connector_config", config_connector_config)
        pulumi.set(__self__, "dns_cache_config", dns_cache_config)
        pulumi.set(__self__, "gce_persistent_disk_csi_driver_config", gce_persistent_disk_csi_driver_config)
        pulumi.set(__self__, "horizontal_pod_autoscaling", horizontal_pod_autoscaling)
        pulumi.set(__self__, "http_load_balancing", http_load_balancing)
        pulumi.set(__self__, "kubernetes_dashboard", kubernetes_dashboard)
        pulumi.set(__self__, "network_policy_config", network_policy_config)

    @property
    @pulumi.getter(name="cloudRunConfig")
    def cloud_run_config(self) -> 'outputs.CloudRunConfigResponse':
        """
        Configuration for the Cloud Run addon, which allows the user to use a managed Knative service.
        """
        return pulumi.get(self, "cloud_run_config")

    @property
    @pulumi.getter(name="configConnectorConfig")
    def config_connector_config(self) -> 'outputs.ConfigConnectorConfigResponse':
        """
        Configuration for the ConfigConnector add-on, a Kubernetes extension to manage hosted GCP services through the Kubernetes API
        """
        return pulumi.get(self, "config_connector_config")

    @property
    @pulumi.getter(name="dnsCacheConfig")
    def dns_cache_config(self) -> 'outputs.DnsCacheConfigResponse':
        """
        Configuration for NodeLocalDNS, a dns cache running on cluster nodes
        """
        return pulumi.get(self, "dns_cache_config")

    @property
    @pulumi.getter(name="gcePersistentDiskCsiDriverConfig")
    def gce_persistent_disk_csi_driver_config(self) -> 'outputs.GcePersistentDiskCsiDriverConfigResponse':
        """
        Configuration for the Compute Engine Persistent Disk CSI driver.
        """
        return pulumi.get(self, "gce_persistent_disk_csi_driver_config")

    @property
    @pulumi.getter(name="horizontalPodAutoscaling")
    def horizontal_pod_autoscaling(self) -> 'outputs.HorizontalPodAutoscalingResponse':
        """
        Configuration for the horizontal pod autoscaling feature, which increases or decreases the number of replica pods a replication controller has based on the resource usage of the existing pods.
        """
        return pulumi.get(self, "horizontal_pod_autoscaling")

    @property
    @pulumi.getter(name="httpLoadBalancing")
    def http_load_balancing(self) -> 'outputs.HttpLoadBalancingResponse':
        """
        Configuration for the HTTP (L7) load balancing controller addon, which makes it easy to set up HTTP load balancers for services in a cluster.
        """
        return pulumi.get(self, "http_load_balancing")

    @property
    @pulumi.getter(name="kubernetesDashboard")
    def kubernetes_dashboard(self) -> 'outputs.KubernetesDashboardResponse':
        """
        Configuration for the Kubernetes Dashboard. This addon is deprecated, and will be disabled in 1.15. It is recommended to use the Cloud Console to manage and monitor your Kubernetes clusters, workloads and applications. For more information, see: https://cloud.google.com/kubernetes-engine/docs/concepts/dashboards
        """
        return pulumi.get(self, "kubernetes_dashboard")

    @property
    @pulumi.getter(name="networkPolicyConfig")
    def network_policy_config(self) -> 'outputs.NetworkPolicyConfigResponse':
        """
        Configuration for NetworkPolicy. This only tracks whether the addon is enabled or not on the Master, it does not track whether network policy is enabled for the nodes.
        """
        return pulumi.get(self, "network_policy_config")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AuthenticatorGroupsConfigResponse(dict):
    """
    Configuration for returning group information from authenticators.
    """
    def __init__(__self__, *,
                 enabled: bool,
                 security_group: str):
        """
        Configuration for returning group information from authenticators.
        :param bool enabled: Whether this cluster should return group membership lookups during authentication using a group of security groups.
        :param str security_group: The name of the security group-of-groups to be used. Only relevant if enabled = true.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "security_group", security_group)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether this cluster should return group membership lookups during authentication using a group of security groups.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="securityGroup")
    def security_group(self) -> str:
        """
        The name of the security group-of-groups to be used. Only relevant if enabled = true.
        """
        return pulumi.get(self, "security_group")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AutoUpgradeOptionsResponse(dict):
    """
    AutoUpgradeOptions defines the set of options for the user to control how the Auto Upgrades will proceed.
    """
    def __init__(__self__, *,
                 auto_upgrade_start_time: str,
                 description: str):
        """
        AutoUpgradeOptions defines the set of options for the user to control how the Auto Upgrades will proceed.
        :param str auto_upgrade_start_time: [Output only] This field is set when upgrades are about to commence with the approximate start time for the upgrades, in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
        :param str description: [Output only] This field is set when upgrades are about to commence with the description of the upgrade.
        """
        pulumi.set(__self__, "auto_upgrade_start_time", auto_upgrade_start_time)
        pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="autoUpgradeStartTime")
    def auto_upgrade_start_time(self) -> str:
        """
        [Output only] This field is set when upgrades are about to commence with the approximate start time for the upgrades, in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
        """
        return pulumi.get(self, "auto_upgrade_start_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        [Output only] This field is set when upgrades are about to commence with the description of the upgrade.
        """
        return pulumi.get(self, "description")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AutopilotResponse(dict):
    """
    Autopilot is the configuration for Autopilot settings on the cluster.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Autopilot is the configuration for Autopilot settings on the cluster.
        :param bool enabled: Enable Autopilot
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Enable Autopilot
        """
        return pulumi.get(self, "enabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AutoprovisioningNodePoolDefaultsResponse(dict):
    """
    AutoprovisioningNodePoolDefaults contains defaults for a node pool created by NAP.
    """
    def __init__(__self__, *,
                 boot_disk_kms_key: str,
                 disk_size_gb: int,
                 disk_type: str,
                 management: 'outputs.NodeManagementResponse',
                 min_cpu_platform: str,
                 oauth_scopes: Sequence[str],
                 service_account: str,
                 shielded_instance_config: 'outputs.ShieldedInstanceConfigResponse',
                 upgrade_settings: 'outputs.UpgradeSettingsResponse'):
        """
        AutoprovisioningNodePoolDefaults contains defaults for a node pool created by NAP.
        :param str boot_disk_kms_key: The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool. This should be of the form projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME]. For more information about protecting resources with Cloud KMS Keys please see: https://cloud.google.com/compute/docs/disks/customer-managed-encryption
        :param int disk_size_gb: Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB. If unspecified, the default disk size is 100GB.
        :param str disk_type: Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or 'pd-balanced') If unspecified, the default disk type is 'pd-standard'
        :param 'NodeManagementResponseArgs' management: Specifies the node management options for NAP created node-pools.
        :param str min_cpu_platform: Minimum CPU platform to be used for NAP created node pools. The instance may be scheduled on the specified or newer CPU platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: Intel Haswell or minCpuPlatform: Intel Sandy Bridge. For more information, read [how to specify min CPU platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform) To unset the min cpu platform field pass "automatic" as field value.
        :param Sequence[str] oauth_scopes: Scopes that are used by NAP when creating node pools.
        :param str service_account: The Google Cloud Platform Service Account to be used by the node VMs.
        :param 'ShieldedInstanceConfigResponseArgs' shielded_instance_config: Shielded Instance options.
        :param 'UpgradeSettingsResponseArgs' upgrade_settings: Specifies the upgrade settings for NAP created node pools
        """
        pulumi.set(__self__, "boot_disk_kms_key", boot_disk_kms_key)
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "management", management)
        pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        pulumi.set(__self__, "oauth_scopes", oauth_scopes)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        pulumi.set(__self__, "upgrade_settings", upgrade_settings)

    @property
    @pulumi.getter(name="bootDiskKmsKey")
    def boot_disk_kms_key(self) -> str:
        """
        The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool. This should be of the form projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME]. For more information about protecting resources with Cloud KMS Keys please see: https://cloud.google.com/compute/docs/disks/customer-managed-encryption
        """
        return pulumi.get(self, "boot_disk_kms_key")

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> int:
        """
        Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB. If unspecified, the default disk size is 100GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> str:
        """
        Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or 'pd-balanced') If unspecified, the default disk type is 'pd-standard'
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter
    def management(self) -> 'outputs.NodeManagementResponse':
        """
        Specifies the node management options for NAP created node-pools.
        """
        return pulumi.get(self, "management")

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> str:
        """
        Minimum CPU platform to be used for NAP created node pools. The instance may be scheduled on the specified or newer CPU platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: Intel Haswell or minCpuPlatform: Intel Sandy Bridge. For more information, read [how to specify min CPU platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform) To unset the min cpu platform field pass "automatic" as field value.
        """
        return pulumi.get(self, "min_cpu_platform")

    @property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> Sequence[str]:
        """
        Scopes that are used by NAP when creating node pools.
        """
        return pulumi.get(self, "oauth_scopes")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        The Google Cloud Platform Service Account to be used by the node VMs.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> 'outputs.ShieldedInstanceConfigResponse':
        """
        Shielded Instance options.
        """
        return pulumi.get(self, "shielded_instance_config")

    @property
    @pulumi.getter(name="upgradeSettings")
    def upgrade_settings(self) -> 'outputs.UpgradeSettingsResponse':
        """
        Specifies the upgrade settings for NAP created node pools
        """
        return pulumi.get(self, "upgrade_settings")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class BigQueryDestinationResponse(dict):
    """
    Parameters for using BigQuery as the destination of resource usage export.
    """
    def __init__(__self__, *,
                 dataset_id: str):
        """
        Parameters for using BigQuery as the destination of resource usage export.
        :param str dataset_id: The ID of a BigQuery Dataset.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        The ID of a BigQuery Dataset.
        """
        return pulumi.get(self, "dataset_id")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class BinaryAuthorizationResponse(dict):
    """
    Configuration for Binary Authorization.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Configuration for Binary Authorization.
        :param bool enabled: Enable Binary Authorization for this cluster. If enabled, all container images will be validated by Binary Authorization.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Enable Binary Authorization for this cluster. If enabled, all container images will be validated by Binary Authorization.
        """
        return pulumi.get(self, "enabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class CidrBlockResponse(dict):
    """
    CidrBlock contains an optional name and one CIDR block.
    """
    def __init__(__self__, *,
                 cidr_block: str,
                 display_name: str):
        """
        CidrBlock contains an optional name and one CIDR block.
        :param str cidr_block: cidr_block must be specified in CIDR notation.
        :param str display_name: display_name is an optional field for users to identify CIDR blocks.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> str:
        """
        cidr_block must be specified in CIDR notation.
        """
        return pulumi.get(self, "cidr_block")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        display_name is an optional field for users to identify CIDR blocks.
        """
        return pulumi.get(self, "display_name")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClientCertificateConfigResponse(dict):
    """
    Configuration for client certificates on the cluster.
    """
    def __init__(__self__, *,
                 issue_client_certificate: bool):
        """
        Configuration for client certificates on the cluster.
        :param bool issue_client_certificate: Issue a client certificate.
        """
        pulumi.set(__self__, "issue_client_certificate", issue_client_certificate)

    @property
    @pulumi.getter(name="issueClientCertificate")
    def issue_client_certificate(self) -> bool:
        """
        Issue a client certificate.
        """
        return pulumi.get(self, "issue_client_certificate")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class CloudRunConfigResponse(dict):
    """
    Configuration options for the Cloud Run feature.
    """
    def __init__(__self__, *,
                 disabled: bool,
                 load_balancer_type: str):
        """
        Configuration options for the Cloud Run feature.
        :param bool disabled: Whether Cloud Run addon is enabled for this cluster.
        :param str load_balancer_type: Which load balancer type is installed for Cloud Run.
        """
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "load_balancer_type", load_balancer_type)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        Whether Cloud Run addon is enabled for this cluster.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> str:
        """
        Which load balancer type is installed for Cloud Run.
        """
        return pulumi.get(self, "load_balancer_type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterAutoscalingResponse(dict):
    """
    ClusterAutoscaling contains global, per-cluster information required by Cluster Autoscaler to automatically adjust the size of the cluster and create/delete node pools based on the current needs.
    """
    def __init__(__self__, *,
                 autoprovisioning_locations: Sequence[str],
                 autoprovisioning_node_pool_defaults: 'outputs.AutoprovisioningNodePoolDefaultsResponse',
                 enable_node_autoprovisioning: bool,
                 resource_limits: Sequence['outputs.ResourceLimitResponse']):
        """
        ClusterAutoscaling contains global, per-cluster information required by Cluster Autoscaler to automatically adjust the size of the cluster and create/delete node pools based on the current needs.
        :param Sequence[str] autoprovisioning_locations: The list of Google Compute Engine [zones](https://cloud.google.com/compute/docs/zones#available) in which the NodePool's nodes can be created by NAP.
        :param 'AutoprovisioningNodePoolDefaultsResponseArgs' autoprovisioning_node_pool_defaults: AutoprovisioningNodePoolDefaults contains defaults for a node pool created by NAP.
        :param bool enable_node_autoprovisioning: Enables automatic node pool creation and deletion.
        :param Sequence['ResourceLimitResponseArgs'] resource_limits: Contains global constraints regarding minimum and maximum amount of resources in the cluster.
        """
        pulumi.set(__self__, "autoprovisioning_locations", autoprovisioning_locations)
        pulumi.set(__self__, "autoprovisioning_node_pool_defaults", autoprovisioning_node_pool_defaults)
        pulumi.set(__self__, "enable_node_autoprovisioning", enable_node_autoprovisioning)
        pulumi.set(__self__, "resource_limits", resource_limits)

    @property
    @pulumi.getter(name="autoprovisioningLocations")
    def autoprovisioning_locations(self) -> Sequence[str]:
        """
        The list of Google Compute Engine [zones](https://cloud.google.com/compute/docs/zones#available) in which the NodePool's nodes can be created by NAP.
        """
        return pulumi.get(self, "autoprovisioning_locations")

    @property
    @pulumi.getter(name="autoprovisioningNodePoolDefaults")
    def autoprovisioning_node_pool_defaults(self) -> 'outputs.AutoprovisioningNodePoolDefaultsResponse':
        """
        AutoprovisioningNodePoolDefaults contains defaults for a node pool created by NAP.
        """
        return pulumi.get(self, "autoprovisioning_node_pool_defaults")

    @property
    @pulumi.getter(name="enableNodeAutoprovisioning")
    def enable_node_autoprovisioning(self) -> bool:
        """
        Enables automatic node pool creation and deletion.
        """
        return pulumi.get(self, "enable_node_autoprovisioning")

    @property
    @pulumi.getter(name="resourceLimits")
    def resource_limits(self) -> Sequence['outputs.ResourceLimitResponse']:
        """
        Contains global constraints regarding minimum and maximum amount of resources in the cluster.
        """
        return pulumi.get(self, "resource_limits")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ConfigConnectorConfigResponse(dict):
    """
    Configuration options for the Config Connector add-on.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Configuration options for the Config Connector add-on.
        :param bool enabled: Whether Cloud Connector is enabled for this cluster.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether Cloud Connector is enabled for this cluster.
        """
        return pulumi.get(self, "enabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ConsumptionMeteringConfigResponse(dict):
    """
    Parameters for controlling consumption metering.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Parameters for controlling consumption metering.
        :param bool enabled: Whether to enable consumption metering for this cluster. If enabled, a second BigQuery table will be created to hold resource consumption records.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether to enable consumption metering for this cluster. If enabled, a second BigQuery table will be created to hold resource consumption records.
        """
        return pulumi.get(self, "enabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DailyMaintenanceWindowResponse(dict):
    """
    Time window specified for daily maintenance operations.
    """
    def __init__(__self__, *,
                 duration: str,
                 start_time: str):
        """
        Time window specified for daily maintenance operations.
        :param str duration: [Output only] Duration of the time window, automatically chosen to be smallest possible in the given scenario. Duration will be in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) format "PTnHnMnS".
        :param str start_time: Time within the maintenance window to start the maintenance operations. Time format should be in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) format "HH:MM", where HH : [00-23] and MM : [00-59] GMT.
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        [Output only] Duration of the time window, automatically chosen to be smallest possible in the given scenario. Duration will be in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) format "PTnHnMnS".
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Time within the maintenance window to start the maintenance operations. Time format should be in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) format "HH:MM", where HH : [00-23] and MM : [00-59] GMT.
        """
        return pulumi.get(self, "start_time")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DatabaseEncryptionResponse(dict):
    """
    Configuration of etcd encryption.
    """
    def __init__(__self__, *,
                 key_name: str,
                 state: str):
        """
        Configuration of etcd encryption.
        :param str key_name: Name of CloudKMS key to use for the encryption of secrets in etcd. Ex. projects/my-project/locations/global/keyRings/my-ring/cryptoKeys/my-key
        :param str state: Denotes the state of etcd encryption.
        """
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        """
        Name of CloudKMS key to use for the encryption of secrets in etcd. Ex. projects/my-project/locations/global/keyRings/my-ring/cryptoKeys/my-key
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Denotes the state of etcd encryption.
        """
        return pulumi.get(self, "state")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DefaultSnatStatusResponse(dict):
    """
    DefaultSnatStatus contains the desired state of whether default sNAT should be disabled on the cluster.
    """
    def __init__(__self__, *,
                 disabled: bool):
        """
        DefaultSnatStatus contains the desired state of whether default sNAT should be disabled on the cluster.
        :param bool disabled: Disables cluster default sNAT rules.
        """
        pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        Disables cluster default sNAT rules.
        """
        return pulumi.get(self, "disabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DnsCacheConfigResponse(dict):
    """
    Configuration for NodeLocal DNSCache
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Configuration for NodeLocal DNSCache
        :param bool enabled: Whether NodeLocal DNSCache is enabled for this cluster.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether NodeLocal DNSCache is enabled for this cluster.
        """
        return pulumi.get(self, "enabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GcePersistentDiskCsiDriverConfigResponse(dict):
    """
    Configuration for the Compute Engine PD CSI driver.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Configuration for the Compute Engine PD CSI driver.
        :param bool enabled: Whether the Compute Engine PD CSI driver is enabled for this cluster.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether the Compute Engine PD CSI driver is enabled for this cluster.
        """
        return pulumi.get(self, "enabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class HorizontalPodAutoscalingResponse(dict):
    """
    Configuration options for the horizontal pod autoscaling feature, which increases or decreases the number of replica pods a replication controller has based on the resource usage of the existing pods.
    """
    def __init__(__self__, *,
                 disabled: bool):
        """
        Configuration options for the horizontal pod autoscaling feature, which increases or decreases the number of replica pods a replication controller has based on the resource usage of the existing pods.
        :param bool disabled: Whether the Horizontal Pod Autoscaling feature is enabled in the cluster. When enabled, it ensures that metrics are collected into Stackdriver Monitoring.
        """
        pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        Whether the Horizontal Pod Autoscaling feature is enabled in the cluster. When enabled, it ensures that metrics are collected into Stackdriver Monitoring.
        """
        return pulumi.get(self, "disabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class HttpLoadBalancingResponse(dict):
    """
    Configuration options for the HTTP (L7) load balancing controller addon, which makes it easy to set up HTTP load balancers for services in a cluster.
    """
    def __init__(__self__, *,
                 disabled: bool):
        """
        Configuration options for the HTTP (L7) load balancing controller addon, which makes it easy to set up HTTP load balancers for services in a cluster.
        :param bool disabled: Whether the HTTP Load Balancing controller is enabled in the cluster. When enabled, it runs a small pod in the cluster that manages the load balancers.
        """
        pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        Whether the HTTP Load Balancing controller is enabled in the cluster. When enabled, it runs a small pod in the cluster that manages the load balancers.
        """
        return pulumi.get(self, "disabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class IPAllocationPolicyResponse(dict):
    """
    Configuration for controlling how IPs are allocated in the cluster.
    """
    def __init__(__self__, *,
                 cluster_ipv4_cidr: str,
                 cluster_ipv4_cidr_block: str,
                 cluster_secondary_range_name: str,
                 create_subnetwork: bool,
                 node_ipv4_cidr: str,
                 node_ipv4_cidr_block: str,
                 services_ipv4_cidr: str,
                 services_ipv4_cidr_block: str,
                 services_secondary_range_name: str,
                 subnetwork_name: str,
                 tpu_ipv4_cidr_block: str,
                 use_ip_aliases: bool,
                 use_routes: bool):
        """
        Configuration for controlling how IPs are allocated in the cluster.
        :param str cluster_ipv4_cidr: This field is deprecated, use cluster_ipv4_cidr_block.
        :param str cluster_ipv4_cidr_block: The IP address range for the cluster pod IPs. If this field is set, then `cluster.cluster_ipv4_cidr` must be left blank. This field is only applicable when `use_ip_aliases` is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
        :param str cluster_secondary_range_name: The name of the secondary range to be used for the cluster CIDR block. The secondary range will be used for pod IP addresses. This must be an existing secondary range associated with the cluster subnetwork. This field is only applicable with use_ip_aliases is true and create_subnetwork is false.
        :param bool create_subnetwork: Whether a new subnetwork will be created automatically for the cluster. This field is only applicable when `use_ip_aliases` is true.
        :param str node_ipv4_cidr: This field is deprecated, use node_ipv4_cidr_block.
        :param str node_ipv4_cidr_block: The IP address range of the instance IPs in this cluster. This is applicable only if `create_subnetwork` is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
        :param str services_ipv4_cidr: This field is deprecated, use services_ipv4_cidr_block.
        :param str services_ipv4_cidr_block: The IP address range of the services IPs in this cluster. If blank, a range will be automatically chosen with the default size. This field is only applicable when `use_ip_aliases` is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
        :param str services_secondary_range_name: The name of the secondary range to be used as for the services CIDR block. The secondary range will be used for service ClusterIPs. This must be an existing secondary range associated with the cluster subnetwork. This field is only applicable with use_ip_aliases is true and create_subnetwork is false.
        :param str subnetwork_name: A custom subnetwork name to be used if `create_subnetwork` is true. If this field is empty, then an automatic name will be chosen for the new subnetwork.
        :param str tpu_ipv4_cidr_block: The IP address range of the Cloud TPUs in this cluster. If unspecified, a range will be automatically chosen with the default size. This field is only applicable when `use_ip_aliases` is true. If unspecified, the range will use the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
        :param bool use_ip_aliases: Whether alias IPs will be used for pod IPs in the cluster. This is used in conjunction with use_routes. It cannot be true if use_routes is true. If both use_ip_aliases and use_routes are false, then the server picks the default IP allocation mode
        :param bool use_routes: Whether routes will be used for pod IPs in the cluster. This is used in conjunction with use_ip_aliases. It cannot be true if use_ip_aliases is true. If both use_ip_aliases and use_routes are false, then the server picks the default IP allocation mode
        """
        pulumi.set(__self__, "cluster_ipv4_cidr", cluster_ipv4_cidr)
        pulumi.set(__self__, "cluster_ipv4_cidr_block", cluster_ipv4_cidr_block)
        pulumi.set(__self__, "cluster_secondary_range_name", cluster_secondary_range_name)
        pulumi.set(__self__, "create_subnetwork", create_subnetwork)
        pulumi.set(__self__, "node_ipv4_cidr", node_ipv4_cidr)
        pulumi.set(__self__, "node_ipv4_cidr_block", node_ipv4_cidr_block)
        pulumi.set(__self__, "services_ipv4_cidr", services_ipv4_cidr)
        pulumi.set(__self__, "services_ipv4_cidr_block", services_ipv4_cidr_block)
        pulumi.set(__self__, "services_secondary_range_name", services_secondary_range_name)
        pulumi.set(__self__, "subnetwork_name", subnetwork_name)
        pulumi.set(__self__, "tpu_ipv4_cidr_block", tpu_ipv4_cidr_block)
        pulumi.set(__self__, "use_ip_aliases", use_ip_aliases)
        pulumi.set(__self__, "use_routes", use_routes)

    @property
    @pulumi.getter(name="clusterIpv4Cidr")
    def cluster_ipv4_cidr(self) -> str:
        """
        This field is deprecated, use cluster_ipv4_cidr_block.
        """
        return pulumi.get(self, "cluster_ipv4_cidr")

    @property
    @pulumi.getter(name="clusterIpv4CidrBlock")
    def cluster_ipv4_cidr_block(self) -> str:
        """
        The IP address range for the cluster pod IPs. If this field is set, then `cluster.cluster_ipv4_cidr` must be left blank. This field is only applicable when `use_ip_aliases` is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
        """
        return pulumi.get(self, "cluster_ipv4_cidr_block")

    @property
    @pulumi.getter(name="clusterSecondaryRangeName")
    def cluster_secondary_range_name(self) -> str:
        """
        The name of the secondary range to be used for the cluster CIDR block. The secondary range will be used for pod IP addresses. This must be an existing secondary range associated with the cluster subnetwork. This field is only applicable with use_ip_aliases is true and create_subnetwork is false.
        """
        return pulumi.get(self, "cluster_secondary_range_name")

    @property
    @pulumi.getter(name="createSubnetwork")
    def create_subnetwork(self) -> bool:
        """
        Whether a new subnetwork will be created automatically for the cluster. This field is only applicable when `use_ip_aliases` is true.
        """
        return pulumi.get(self, "create_subnetwork")

    @property
    @pulumi.getter(name="nodeIpv4Cidr")
    def node_ipv4_cidr(self) -> str:
        """
        This field is deprecated, use node_ipv4_cidr_block.
        """
        return pulumi.get(self, "node_ipv4_cidr")

    @property
    @pulumi.getter(name="nodeIpv4CidrBlock")
    def node_ipv4_cidr_block(self) -> str:
        """
        The IP address range of the instance IPs in this cluster. This is applicable only if `create_subnetwork` is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
        """
        return pulumi.get(self, "node_ipv4_cidr_block")

    @property
    @pulumi.getter(name="servicesIpv4Cidr")
    def services_ipv4_cidr(self) -> str:
        """
        This field is deprecated, use services_ipv4_cidr_block.
        """
        return pulumi.get(self, "services_ipv4_cidr")

    @property
    @pulumi.getter(name="servicesIpv4CidrBlock")
    def services_ipv4_cidr_block(self) -> str:
        """
        The IP address range of the services IPs in this cluster. If blank, a range will be automatically chosen with the default size. This field is only applicable when `use_ip_aliases` is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
        """
        return pulumi.get(self, "services_ipv4_cidr_block")

    @property
    @pulumi.getter(name="servicesSecondaryRangeName")
    def services_secondary_range_name(self) -> str:
        """
        The name of the secondary range to be used as for the services CIDR block. The secondary range will be used for service ClusterIPs. This must be an existing secondary range associated with the cluster subnetwork. This field is only applicable with use_ip_aliases is true and create_subnetwork is false.
        """
        return pulumi.get(self, "services_secondary_range_name")

    @property
    @pulumi.getter(name="subnetworkName")
    def subnetwork_name(self) -> str:
        """
        A custom subnetwork name to be used if `create_subnetwork` is true. If this field is empty, then an automatic name will be chosen for the new subnetwork.
        """
        return pulumi.get(self, "subnetwork_name")

    @property
    @pulumi.getter(name="tpuIpv4CidrBlock")
    def tpu_ipv4_cidr_block(self) -> str:
        """
        The IP address range of the Cloud TPUs in this cluster. If unspecified, a range will be automatically chosen with the default size. This field is only applicable when `use_ip_aliases` is true. If unspecified, the range will use the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
        """
        return pulumi.get(self, "tpu_ipv4_cidr_block")

    @property
    @pulumi.getter(name="useIpAliases")
    def use_ip_aliases(self) -> bool:
        """
        Whether alias IPs will be used for pod IPs in the cluster. This is used in conjunction with use_routes. It cannot be true if use_routes is true. If both use_ip_aliases and use_routes are false, then the server picks the default IP allocation mode
        """
        return pulumi.get(self, "use_ip_aliases")

    @property
    @pulumi.getter(name="useRoutes")
    def use_routes(self) -> bool:
        """
        Whether routes will be used for pod IPs in the cluster. This is used in conjunction with use_ip_aliases. It cannot be true if use_ip_aliases is true. If both use_ip_aliases and use_routes are false, then the server picks the default IP allocation mode
        """
        return pulumi.get(self, "use_routes")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class KubernetesDashboardResponse(dict):
    """
    Configuration for the Kubernetes Dashboard.
    """
    def __init__(__self__, *,
                 disabled: bool):
        """
        Configuration for the Kubernetes Dashboard.
        :param bool disabled: Whether the Kubernetes Dashboard is enabled for this cluster.
        """
        pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        Whether the Kubernetes Dashboard is enabled for this cluster.
        """
        return pulumi.get(self, "disabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class LegacyAbacResponse(dict):
    """
    Configuration for the legacy Attribute Based Access Control authorization mode.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Configuration for the legacy Attribute Based Access Control authorization mode.
        :param bool enabled: Whether the ABAC authorizer is enabled for this cluster. When enabled, identities in the system, including service accounts, nodes, and controllers, will have statically granted permissions beyond those provided by the RBAC configuration or IAM.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether the ABAC authorizer is enabled for this cluster. When enabled, identities in the system, including service accounts, nodes, and controllers, will have statically granted permissions beyond those provided by the RBAC configuration or IAM.
        """
        return pulumi.get(self, "enabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class LinuxNodeConfigResponse(dict):
    """
    Parameters that can be configured on Linux nodes.
    """
    def __init__(__self__, *,
                 sysctls: Mapping[str, str]):
        """
        Parameters that can be configured on Linux nodes.
        :param Mapping[str, str] sysctls: The Linux kernel parameters to be applied to the nodes and all pods running on the nodes. The following parameters are supported. net.core.netdev_max_backlog net.core.rmem_max net.core.wmem_default net.core.wmem_max net.core.optmem_max net.core.somaxconn net.ipv4.tcp_rmem net.ipv4.tcp_wmem net.ipv4.tcp_tw_reuse
        """
        pulumi.set(__self__, "sysctls", sysctls)

    @property
    @pulumi.getter
    def sysctls(self) -> Mapping[str, str]:
        """
        The Linux kernel parameters to be applied to the nodes and all pods running on the nodes. The following parameters are supported. net.core.netdev_max_backlog net.core.rmem_max net.core.wmem_default net.core.wmem_max net.core.optmem_max net.core.somaxconn net.ipv4.tcp_rmem net.ipv4.tcp_wmem net.ipv4.tcp_tw_reuse
        """
        return pulumi.get(self, "sysctls")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class MaintenancePolicyResponse(dict):
    """
    MaintenancePolicy defines the maintenance policy to be used for the cluster.
    """
    def __init__(__self__, *,
                 resource_version: str,
                 window: 'outputs.MaintenanceWindowResponse'):
        """
        MaintenancePolicy defines the maintenance policy to be used for the cluster.
        :param str resource_version: A hash identifying the version of this policy, so that updates to fields of the policy won't accidentally undo intermediate changes (and so that users of the API unaware of some fields won't accidentally remove other fields). Make a `get()` request to the cluster to get the current resource version and include it with requests to set the policy.
        :param 'MaintenanceWindowResponseArgs' window: Specifies the maintenance window in which maintenance may be performed.
        """
        pulumi.set(__self__, "resource_version", resource_version)
        pulumi.set(__self__, "window", window)

    @property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> str:
        """
        A hash identifying the version of this policy, so that updates to fields of the policy won't accidentally undo intermediate changes (and so that users of the API unaware of some fields won't accidentally remove other fields). Make a `get()` request to the cluster to get the current resource version and include it with requests to set the policy.
        """
        return pulumi.get(self, "resource_version")

    @property
    @pulumi.getter
    def window(self) -> 'outputs.MaintenanceWindowResponse':
        """
        Specifies the maintenance window in which maintenance may be performed.
        """
        return pulumi.get(self, "window")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class MaintenanceWindowResponse(dict):
    """
    MaintenanceWindow defines the maintenance window to be used for the cluster.
    """
    def __init__(__self__, *,
                 daily_maintenance_window: 'outputs.DailyMaintenanceWindowResponse',
                 maintenance_exclusions: Mapping[str, str],
                 recurring_window: 'outputs.RecurringTimeWindowResponse'):
        """
        MaintenanceWindow defines the maintenance window to be used for the cluster.
        :param 'DailyMaintenanceWindowResponseArgs' daily_maintenance_window: DailyMaintenanceWindow specifies a daily maintenance operation window.
        :param Mapping[str, str] maintenance_exclusions: Exceptions to maintenance window. Non-emergency maintenance should not occur in these windows.
        :param 'RecurringTimeWindowResponseArgs' recurring_window: RecurringWindow specifies some number of recurring time periods for maintenance to occur. The time windows may be overlapping. If no maintenance windows are set, maintenance can occur at any time.
        """
        pulumi.set(__self__, "daily_maintenance_window", daily_maintenance_window)
        pulumi.set(__self__, "maintenance_exclusions", maintenance_exclusions)
        pulumi.set(__self__, "recurring_window", recurring_window)

    @property
    @pulumi.getter(name="dailyMaintenanceWindow")
    def daily_maintenance_window(self) -> 'outputs.DailyMaintenanceWindowResponse':
        """
        DailyMaintenanceWindow specifies a daily maintenance operation window.
        """
        return pulumi.get(self, "daily_maintenance_window")

    @property
    @pulumi.getter(name="maintenanceExclusions")
    def maintenance_exclusions(self) -> Mapping[str, str]:
        """
        Exceptions to maintenance window. Non-emergency maintenance should not occur in these windows.
        """
        return pulumi.get(self, "maintenance_exclusions")

    @property
    @pulumi.getter(name="recurringWindow")
    def recurring_window(self) -> 'outputs.RecurringTimeWindowResponse':
        """
        RecurringWindow specifies some number of recurring time periods for maintenance to occur. The time windows may be overlapping. If no maintenance windows are set, maintenance can occur at any time.
        """
        return pulumi.get(self, "recurring_window")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class MasterAuthResponse(dict):
    """
    The authentication information for accessing the master endpoint. Authentication can be done using HTTP basic auth or using client certificates.
    """
    def __init__(__self__, *,
                 client_certificate: str,
                 client_certificate_config: 'outputs.ClientCertificateConfigResponse',
                 client_key: str,
                 cluster_ca_certificate: str,
                 password: str,
                 username: str):
        """
        The authentication information for accessing the master endpoint. Authentication can be done using HTTP basic auth or using client certificates.
        :param str client_certificate: [Output only] Base64-encoded public certificate used by clients to authenticate to the cluster endpoint.
        :param 'ClientCertificateConfigResponseArgs' client_certificate_config: Configuration for client certificate authentication on the cluster. For clusters before v1.12, if no configuration is specified, a client certificate is issued.
        :param str client_key: [Output only] Base64-encoded private key used by clients to authenticate to the cluster endpoint.
        :param str cluster_ca_certificate: [Output only] Base64-encoded public certificate that is the root of trust for the cluster.
        :param str password: The password to use for HTTP basic authentication to the master endpoint. Because the master endpoint is open to the Internet, you should create a strong password. If a password is provided for cluster creation, username must be non-empty. Warning: basic authentication is deprecated, and will be removed in GKE control plane versions 1.19 and newer. For a list of recommended authentication methods, see: https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
        :param str username: The username to use for HTTP basic authentication to the master endpoint. For clusters v1.6.0 and later, basic authentication can be disabled by leaving username unspecified (or setting it to the empty string). Warning: basic authentication is deprecated, and will be removed in GKE control plane versions 1.19 and newer. For a list of recommended authentication methods, see: https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
        """
        pulumi.set(__self__, "client_certificate", client_certificate)
        pulumi.set(__self__, "client_certificate_config", client_certificate_config)
        pulumi.set(__self__, "client_key", client_key)
        pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> str:
        """
        [Output only] Base64-encoded public certificate used by clients to authenticate to the cluster endpoint.
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientCertificateConfig")
    def client_certificate_config(self) -> 'outputs.ClientCertificateConfigResponse':
        """
        Configuration for client certificate authentication on the cluster. For clusters before v1.12, if no configuration is specified, a client certificate is issued.
        """
        return pulumi.get(self, "client_certificate_config")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> str:
        """
        [Output only] Base64-encoded private key used by clients to authenticate to the cluster endpoint.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> str:
        """
        [Output only] Base64-encoded public certificate that is the root of trust for the cluster.
        """
        return pulumi.get(self, "cluster_ca_certificate")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password to use for HTTP basic authentication to the master endpoint. Because the master endpoint is open to the Internet, you should create a strong password. If a password is provided for cluster creation, username must be non-empty. Warning: basic authentication is deprecated, and will be removed in GKE control plane versions 1.19 and newer. For a list of recommended authentication methods, see: https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The username to use for HTTP basic authentication to the master endpoint. For clusters v1.6.0 and later, basic authentication can be disabled by leaving username unspecified (or setting it to the empty string). Warning: basic authentication is deprecated, and will be removed in GKE control plane versions 1.19 and newer. For a list of recommended authentication methods, see: https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
        """
        return pulumi.get(self, "username")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class MasterAuthorizedNetworksConfigResponse(dict):
    """
    Configuration options for the master authorized networks feature. Enabled master authorized networks will disallow all external traffic to access Kubernetes master through HTTPS except traffic from the given CIDR blocks, Google Compute Engine Public IPs and Google Prod IPs.
    """
    def __init__(__self__, *,
                 cidr_blocks: Sequence['outputs.CidrBlockResponse'],
                 enabled: bool):
        """
        Configuration options for the master authorized networks feature. Enabled master authorized networks will disallow all external traffic to access Kubernetes master through HTTPS except traffic from the given CIDR blocks, Google Compute Engine Public IPs and Google Prod IPs.
        :param Sequence['CidrBlockResponseArgs'] cidr_blocks: cidr_blocks define up to 50 external networks that could access Kubernetes master through HTTPS.
        :param bool enabled: Whether or not master authorized networks is enabled.
        """
        pulumi.set(__self__, "cidr_blocks", cidr_blocks)
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="cidrBlocks")
    def cidr_blocks(self) -> Sequence['outputs.CidrBlockResponse']:
        """
        cidr_blocks define up to 50 external networks that could access Kubernetes master through HTTPS.
        """
        return pulumi.get(self, "cidr_blocks")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether or not master authorized networks is enabled.
        """
        return pulumi.get(self, "enabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class MaxPodsConstraintResponse(dict):
    """
    Constraints applied to pods.
    """
    def __init__(__self__, *,
                 max_pods_per_node: str):
        """
        Constraints applied to pods.
        :param str max_pods_per_node: Constraint enforced on the max num of pods per node.
        """
        pulumi.set(__self__, "max_pods_per_node", max_pods_per_node)

    @property
    @pulumi.getter(name="maxPodsPerNode")
    def max_pods_per_node(self) -> str:
        """
        Constraint enforced on the max num of pods per node.
        """
        return pulumi.get(self, "max_pods_per_node")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NetworkConfigResponse(dict):
    """
    NetworkConfig reports the relative names of network & subnetwork.
    """
    def __init__(__self__, *,
                 default_snat_status: 'outputs.DefaultSnatStatusResponse',
                 enable_intra_node_visibility: bool,
                 network: str,
                 private_ipv6_google_access: str,
                 subnetwork: str):
        """
        NetworkConfig reports the relative names of network & subnetwork.
        :param 'DefaultSnatStatusResponseArgs' default_snat_status: Whether the cluster disables default in-node sNAT rules. In-node sNAT rules will be disabled when default_snat_status is disabled. When disabled is set to false, default IP masquerade rules will be applied to the nodes to prevent sNAT on cluster internal traffic.
        :param bool enable_intra_node_visibility: Whether Intra-node visibility is enabled for this cluster. This makes same node pod to pod traffic visible for VPC network.
        :param str network: The relative name of the Google Compute Engine network(https://cloud.google.com/compute/docs/networks-and-firewalls#networks) to which the cluster is connected. Example: projects/my-project/global/networks/my-network
        :param str private_ipv6_google_access: The desired state of IPv6 connectivity to Google Services. By default, no private IPv6 access to or from Google Services (all access will be via IPv4)
        :param str subnetwork: The relative name of the Google Compute Engine [subnetwork](https://cloud.google.com/compute/docs/vpc) to which the cluster is connected. Example: projects/my-project/regions/us-central1/subnetworks/my-subnet
        """
        pulumi.set(__self__, "default_snat_status", default_snat_status)
        pulumi.set(__self__, "enable_intra_node_visibility", enable_intra_node_visibility)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "private_ipv6_google_access", private_ipv6_google_access)
        pulumi.set(__self__, "subnetwork", subnetwork)

    @property
    @pulumi.getter(name="defaultSnatStatus")
    def default_snat_status(self) -> 'outputs.DefaultSnatStatusResponse':
        """
        Whether the cluster disables default in-node sNAT rules. In-node sNAT rules will be disabled when default_snat_status is disabled. When disabled is set to false, default IP masquerade rules will be applied to the nodes to prevent sNAT on cluster internal traffic.
        """
        return pulumi.get(self, "default_snat_status")

    @property
    @pulumi.getter(name="enableIntraNodeVisibility")
    def enable_intra_node_visibility(self) -> bool:
        """
        Whether Intra-node visibility is enabled for this cluster. This makes same node pod to pod traffic visible for VPC network.
        """
        return pulumi.get(self, "enable_intra_node_visibility")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        The relative name of the Google Compute Engine network(https://cloud.google.com/compute/docs/networks-and-firewalls#networks) to which the cluster is connected. Example: projects/my-project/global/networks/my-network
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="privateIpv6GoogleAccess")
    def private_ipv6_google_access(self) -> str:
        """
        The desired state of IPv6 connectivity to Google Services. By default, no private IPv6 access to or from Google Services (all access will be via IPv4)
        """
        return pulumi.get(self, "private_ipv6_google_access")

    @property
    @pulumi.getter
    def subnetwork(self) -> str:
        """
        The relative name of the Google Compute Engine [subnetwork](https://cloud.google.com/compute/docs/vpc) to which the cluster is connected. Example: projects/my-project/regions/us-central1/subnetworks/my-subnet
        """
        return pulumi.get(self, "subnetwork")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NetworkPolicyConfigResponse(dict):
    """
    Configuration for NetworkPolicy. This only tracks whether the addon is enabled or not on the Master, it does not track whether network policy is enabled for the nodes.
    """
    def __init__(__self__, *,
                 disabled: bool):
        """
        Configuration for NetworkPolicy. This only tracks whether the addon is enabled or not on the Master, it does not track whether network policy is enabled for the nodes.
        :param bool disabled: Whether NetworkPolicy is enabled for this cluster.
        """
        pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        Whether NetworkPolicy is enabled for this cluster.
        """
        return pulumi.get(self, "disabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NetworkPolicyResponse(dict):
    """
    Configuration options for the NetworkPolicy feature. https://kubernetes.io/docs/concepts/services-networking/networkpolicies/
    """
    def __init__(__self__, *,
                 enabled: bool,
                 provider: str):
        """
        Configuration options for the NetworkPolicy feature. https://kubernetes.io/docs/concepts/services-networking/networkpolicies/
        :param bool enabled: Whether network policy is enabled on the cluster.
        :param str provider: The selected network policy provider.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "provider", provider)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether network policy is enabled on the cluster.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def provider(self) -> str:
        """
        The selected network policy provider.
        """
        return pulumi.get(self, "provider")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NodeConfigResponse(dict):
    """
    Parameters that describe the nodes in a cluster.
    """
    def __init__(__self__, *,
                 accelerators: Sequence['outputs.AcceleratorConfigResponse'],
                 boot_disk_kms_key: str,
                 disk_size_gb: int,
                 disk_type: str,
                 image_type: str,
                 kubelet_config: 'outputs.NodeKubeletConfigResponse',
                 labels: Mapping[str, str],
                 linux_node_config: 'outputs.LinuxNodeConfigResponse',
                 local_ssd_count: int,
                 machine_type: str,
                 metadata: Mapping[str, str],
                 min_cpu_platform: str,
                 node_group: str,
                 oauth_scopes: Sequence[str],
                 preemptible: bool,
                 reservation_affinity: 'outputs.ReservationAffinityResponse',
                 sandbox_config: 'outputs.SandboxConfigResponse',
                 service_account: str,
                 shielded_instance_config: 'outputs.ShieldedInstanceConfigResponse',
                 tags: Sequence[str],
                 taints: Sequence['outputs.NodeTaintResponse'],
                 workload_metadata_config: 'outputs.WorkloadMetadataConfigResponse'):
        """
        Parameters that describe the nodes in a cluster.
        :param Sequence['AcceleratorConfigResponseArgs'] accelerators: A list of hardware accelerators to be attached to each node. See https://cloud.google.com/compute/docs/gpus for more information about support for GPUs.
        :param str boot_disk_kms_key:  The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool. This should be of the form projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME]. For more information about protecting resources with Cloud KMS Keys please see: https://cloud.google.com/compute/docs/disks/customer-managed-encryption
        :param int disk_size_gb: Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB. If unspecified, the default disk size is 100GB.
        :param str disk_type: Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or 'pd-balanced') If unspecified, the default disk type is 'pd-standard'
        :param str image_type: The image type to use for this node. Note that for a given image type, the latest version of it will be used.
        :param 'NodeKubeletConfigResponseArgs' kubelet_config: Node kubelet configs.
        :param Mapping[str, str] labels: The map of Kubernetes labels (key/value pairs) to be applied to each node. These will added in addition to any default label(s) that Kubernetes may apply to the node. In case of conflict in label keys, the applied set may differ depending on the Kubernetes version -- it's best to assume the behavior is undefined and conflicts should be avoided. For more information, including usage and the valid values, see: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
        :param 'LinuxNodeConfigResponseArgs' linux_node_config: Parameters that can be configured on Linux nodes.
        :param int local_ssd_count: The number of local SSD disks to be attached to the node. The limit for this value is dependent upon the maximum number of disks available on a machine per zone. See: https://cloud.google.com/compute/docs/disks/local-ssd for more information.
        :param str machine_type: The name of a Google Compute Engine [machine type](https://cloud.google.com/compute/docs/machine-types) If unspecified, the default machine type is `e2-medium`.
        :param Mapping[str, str] metadata: The metadata key/value pairs assigned to instances in the cluster. Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes in length. These are reflected as part of a URL in the metadata server. Additionally, to avoid ambiguity, keys must not conflict with any other metadata keys for the project or be one of the reserved keys: - "cluster-location" - "cluster-name" - "cluster-uid" - "configure-sh" - "containerd-configure-sh" - "enable-os-login" - "gci-ensure-gke-docker" - "gci-metrics-enabled" - "gci-update-strategy" - "instance-template" - "kube-env" - "startup-script" - "user-data" - "disable-address-manager" - "windows-startup-script-ps1" - "common-psm1" - "k8s-node-setup-psm1" - "install-ssh-psm1" - "user-profile-psm1" The following keys are reserved for Windows nodes: - "serial-port-logging-enable" Values are free-form strings, and only have meaning as interpreted by the image running in the instance. The only restriction placed on them is that each value's size must be less than or equal to 32 KB. The total size of all keys and values must be less than 512 KB.
        :param str min_cpu_platform: Minimum CPU platform to be used by this instance. The instance may be scheduled on the specified or newer CPU platform. Applicable values are the friendly names of CPU platforms, such as `minCpuPlatform: "Intel Haswell"` or `minCpuPlatform: "Intel Sandy Bridge"`. For more information, read [how to specify min CPU platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
        :param str node_group: Setting this field will assign instances of this pool to run on the specified node group. This is useful for running workloads on [sole tenant nodes](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes).
        :param Sequence[str] oauth_scopes: The set of Google API scopes to be made available on all of the node VMs under the "default" service account. The following scopes are recommended, but not required, and by default are not included: * `https://www.googleapis.com/auth/compute` is required for mounting persistent storage on your nodes. * `https://www.googleapis.com/auth/devstorage.read_only` is required for communicating with **gcr.io** (the [Google Container Registry](https://cloud.google.com/container-registry/)). If unspecified, no scopes are added, unless Cloud Logging or Cloud Monitoring are enabled, in which case their required scopes will be added.
        :param bool preemptible: Whether the nodes are created as preemptible VM instances. See: https://cloud.google.com/compute/docs/instances/preemptible for more information about preemptible VM instances.
        :param 'ReservationAffinityResponseArgs' reservation_affinity: The optional reservation affinity. Setting this field will apply the specified [Zonal Compute Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources) to this node pool.
        :param 'SandboxConfigResponseArgs' sandbox_config: Sandbox configuration for this node.
        :param str service_account: The Google Cloud Platform Service Account to be used by the node VMs. Specify the email address of the Service Account; otherwise, if no Service Account is specified, the "default" service account is used.
        :param 'ShieldedInstanceConfigResponseArgs' shielded_instance_config: Shielded Instance options.
        :param Sequence[str] tags: The list of instance tags applied to all nodes. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during cluster or node pool creation. Each tag within the list must comply with RFC1035.
        :param Sequence['NodeTaintResponseArgs'] taints: List of kubernetes taints to be applied to each node. For more information, including usage and the valid values, see: https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
        :param 'WorkloadMetadataConfigResponseArgs' workload_metadata_config: The workload metadata configuration for this node.
        """
        pulumi.set(__self__, "accelerators", accelerators)
        pulumi.set(__self__, "boot_disk_kms_key", boot_disk_kms_key)
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "image_type", image_type)
        pulumi.set(__self__, "kubelet_config", kubelet_config)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "linux_node_config", linux_node_config)
        pulumi.set(__self__, "local_ssd_count", local_ssd_count)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        pulumi.set(__self__, "node_group", node_group)
        pulumi.set(__self__, "oauth_scopes", oauth_scopes)
        pulumi.set(__self__, "preemptible", preemptible)
        pulumi.set(__self__, "reservation_affinity", reservation_affinity)
        pulumi.set(__self__, "sandbox_config", sandbox_config)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "taints", taints)
        pulumi.set(__self__, "workload_metadata_config", workload_metadata_config)

    @property
    @pulumi.getter
    def accelerators(self) -> Sequence['outputs.AcceleratorConfigResponse']:
        """
        A list of hardware accelerators to be attached to each node. See https://cloud.google.com/compute/docs/gpus for more information about support for GPUs.
        """
        return pulumi.get(self, "accelerators")

    @property
    @pulumi.getter(name="bootDiskKmsKey")
    def boot_disk_kms_key(self) -> str:
        """
         The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool. This should be of the form projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME]. For more information about protecting resources with Cloud KMS Keys please see: https://cloud.google.com/compute/docs/disks/customer-managed-encryption
        """
        return pulumi.get(self, "boot_disk_kms_key")

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> int:
        """
        Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB. If unspecified, the default disk size is 100GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> str:
        """
        Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or 'pd-balanced') If unspecified, the default disk type is 'pd-standard'
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> str:
        """
        The image type to use for this node. Note that for a given image type, the latest version of it will be used.
        """
        return pulumi.get(self, "image_type")

    @property
    @pulumi.getter(name="kubeletConfig")
    def kubelet_config(self) -> 'outputs.NodeKubeletConfigResponse':
        """
        Node kubelet configs.
        """
        return pulumi.get(self, "kubelet_config")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        The map of Kubernetes labels (key/value pairs) to be applied to each node. These will added in addition to any default label(s) that Kubernetes may apply to the node. In case of conflict in label keys, the applied set may differ depending on the Kubernetes version -- it's best to assume the behavior is undefined and conflicts should be avoided. For more information, including usage and the valid values, see: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="linuxNodeConfig")
    def linux_node_config(self) -> 'outputs.LinuxNodeConfigResponse':
        """
        Parameters that can be configured on Linux nodes.
        """
        return pulumi.get(self, "linux_node_config")

    @property
    @pulumi.getter(name="localSsdCount")
    def local_ssd_count(self) -> int:
        """
        The number of local SSD disks to be attached to the node. The limit for this value is dependent upon the maximum number of disks available on a machine per zone. See: https://cloud.google.com/compute/docs/disks/local-ssd for more information.
        """
        return pulumi.get(self, "local_ssd_count")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> str:
        """
        The name of a Google Compute Engine [machine type](https://cloud.google.com/compute/docs/machine-types) If unspecified, the default machine type is `e2-medium`.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, str]:
        """
        The metadata key/value pairs assigned to instances in the cluster. Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes in length. These are reflected as part of a URL in the metadata server. Additionally, to avoid ambiguity, keys must not conflict with any other metadata keys for the project or be one of the reserved keys: - "cluster-location" - "cluster-name" - "cluster-uid" - "configure-sh" - "containerd-configure-sh" - "enable-os-login" - "gci-ensure-gke-docker" - "gci-metrics-enabled" - "gci-update-strategy" - "instance-template" - "kube-env" - "startup-script" - "user-data" - "disable-address-manager" - "windows-startup-script-ps1" - "common-psm1" - "k8s-node-setup-psm1" - "install-ssh-psm1" - "user-profile-psm1" The following keys are reserved for Windows nodes: - "serial-port-logging-enable" Values are free-form strings, and only have meaning as interpreted by the image running in the instance. The only restriction placed on them is that each value's size must be less than or equal to 32 KB. The total size of all keys and values must be less than 512 KB.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> str:
        """
        Minimum CPU platform to be used by this instance. The instance may be scheduled on the specified or newer CPU platform. Applicable values are the friendly names of CPU platforms, such as `minCpuPlatform: "Intel Haswell"` or `minCpuPlatform: "Intel Sandy Bridge"`. For more information, read [how to specify min CPU platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
        """
        return pulumi.get(self, "min_cpu_platform")

    @property
    @pulumi.getter(name="nodeGroup")
    def node_group(self) -> str:
        """
        Setting this field will assign instances of this pool to run on the specified node group. This is useful for running workloads on [sole tenant nodes](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes).
        """
        return pulumi.get(self, "node_group")

    @property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> Sequence[str]:
        """
        The set of Google API scopes to be made available on all of the node VMs under the "default" service account. The following scopes are recommended, but not required, and by default are not included: * `https://www.googleapis.com/auth/compute` is required for mounting persistent storage on your nodes. * `https://www.googleapis.com/auth/devstorage.read_only` is required for communicating with **gcr.io** (the [Google Container Registry](https://cloud.google.com/container-registry/)). If unspecified, no scopes are added, unless Cloud Logging or Cloud Monitoring are enabled, in which case their required scopes will be added.
        """
        return pulumi.get(self, "oauth_scopes")

    @property
    @pulumi.getter
    def preemptible(self) -> bool:
        """
        Whether the nodes are created as preemptible VM instances. See: https://cloud.google.com/compute/docs/instances/preemptible for more information about preemptible VM instances.
        """
        return pulumi.get(self, "preemptible")

    @property
    @pulumi.getter(name="reservationAffinity")
    def reservation_affinity(self) -> 'outputs.ReservationAffinityResponse':
        """
        The optional reservation affinity. Setting this field will apply the specified [Zonal Compute Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources) to this node pool.
        """
        return pulumi.get(self, "reservation_affinity")

    @property
    @pulumi.getter(name="sandboxConfig")
    def sandbox_config(self) -> 'outputs.SandboxConfigResponse':
        """
        Sandbox configuration for this node.
        """
        return pulumi.get(self, "sandbox_config")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        The Google Cloud Platform Service Account to be used by the node VMs. Specify the email address of the Service Account; otherwise, if no Service Account is specified, the "default" service account is used.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> 'outputs.ShieldedInstanceConfigResponse':
        """
        Shielded Instance options.
        """
        return pulumi.get(self, "shielded_instance_config")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        The list of instance tags applied to all nodes. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during cluster or node pool creation. Each tag within the list must comply with RFC1035.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def taints(self) -> Sequence['outputs.NodeTaintResponse']:
        """
        List of kubernetes taints to be applied to each node. For more information, including usage and the valid values, see: https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
        """
        return pulumi.get(self, "taints")

    @property
    @pulumi.getter(name="workloadMetadataConfig")
    def workload_metadata_config(self) -> 'outputs.WorkloadMetadataConfigResponse':
        """
        The workload metadata configuration for this node.
        """
        return pulumi.get(self, "workload_metadata_config")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NodeKubeletConfigResponse(dict):
    """
    Node kubelet configs.
    """
    def __init__(__self__, *,
                 cpu_cfs_quota: bool,
                 cpu_cfs_quota_period: str,
                 cpu_manager_policy: str):
        """
        Node kubelet configs.
        :param bool cpu_cfs_quota: Enable CPU CFS quota enforcement for containers that specify CPU limits. This option is enabled by default which makes kubelet use CFS quota (https://www.kernel.org/doc/Documentation/scheduler/sched-bwc.txt) to enforce container CPU limits. Otherwise, CPU limits will not be enforced at all. Disable this option to mitigate CPU throttling problems while still having your pods to be in Guaranteed QoS class by specifying the CPU limits. The default value is 'true' if unspecified.
        :param str cpu_cfs_quota_period: Set the CPU CFS quota period value 'cpu.cfs_period_us'. The string must be a sequence of decimal numbers, each with optional fraction and a unit suffix, such as "300ms". Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h". The value must be a positive duration.
        :param str cpu_manager_policy: Control the CPU management policy on the node. See https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/ The following values are allowed. - "none": the default, which represents the existing scheduling behavior. - "static": allows pods with certain resource characteristics to be granted increased CPU affinity and exclusivity on the node. The default value is 'none' if unspecified.
        """
        pulumi.set(__self__, "cpu_cfs_quota", cpu_cfs_quota)
        pulumi.set(__self__, "cpu_cfs_quota_period", cpu_cfs_quota_period)
        pulumi.set(__self__, "cpu_manager_policy", cpu_manager_policy)

    @property
    @pulumi.getter(name="cpuCfsQuota")
    def cpu_cfs_quota(self) -> bool:
        """
        Enable CPU CFS quota enforcement for containers that specify CPU limits. This option is enabled by default which makes kubelet use CFS quota (https://www.kernel.org/doc/Documentation/scheduler/sched-bwc.txt) to enforce container CPU limits. Otherwise, CPU limits will not be enforced at all. Disable this option to mitigate CPU throttling problems while still having your pods to be in Guaranteed QoS class by specifying the CPU limits. The default value is 'true' if unspecified.
        """
        return pulumi.get(self, "cpu_cfs_quota")

    @property
    @pulumi.getter(name="cpuCfsQuotaPeriod")
    def cpu_cfs_quota_period(self) -> str:
        """
        Set the CPU CFS quota period value 'cpu.cfs_period_us'. The string must be a sequence of decimal numbers, each with optional fraction and a unit suffix, such as "300ms". Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h". The value must be a positive duration.
        """
        return pulumi.get(self, "cpu_cfs_quota_period")

    @property
    @pulumi.getter(name="cpuManagerPolicy")
    def cpu_manager_policy(self) -> str:
        """
        Control the CPU management policy on the node. See https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/ The following values are allowed. - "none": the default, which represents the existing scheduling behavior. - "static": allows pods with certain resource characteristics to be granted increased CPU affinity and exclusivity on the node. The default value is 'none' if unspecified.
        """
        return pulumi.get(self, "cpu_manager_policy")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NodeManagementResponse(dict):
    """
    NodeManagement defines the set of node management services turned on for the node pool.
    """
    def __init__(__self__, *,
                 auto_repair: bool,
                 auto_upgrade: bool,
                 upgrade_options: 'outputs.AutoUpgradeOptionsResponse'):
        """
        NodeManagement defines the set of node management services turned on for the node pool.
        :param bool auto_repair: A flag that specifies whether the node auto-repair is enabled for the node pool. If enabled, the nodes in this node pool will be monitored and, if they fail health checks too many times, an automatic repair action will be triggered.
        :param bool auto_upgrade: A flag that specifies whether node auto-upgrade is enabled for the node pool. If enabled, node auto-upgrade helps keep the nodes in your node pool up to date with the latest release version of Kubernetes.
        :param 'AutoUpgradeOptionsResponseArgs' upgrade_options: Specifies the Auto Upgrade knobs for the node pool.
        """
        pulumi.set(__self__, "auto_repair", auto_repair)
        pulumi.set(__self__, "auto_upgrade", auto_upgrade)
        pulumi.set(__self__, "upgrade_options", upgrade_options)

    @property
    @pulumi.getter(name="autoRepair")
    def auto_repair(self) -> bool:
        """
        A flag that specifies whether the node auto-repair is enabled for the node pool. If enabled, the nodes in this node pool will be monitored and, if they fail health checks too many times, an automatic repair action will be triggered.
        """
        return pulumi.get(self, "auto_repair")

    @property
    @pulumi.getter(name="autoUpgrade")
    def auto_upgrade(self) -> bool:
        """
        A flag that specifies whether node auto-upgrade is enabled for the node pool. If enabled, node auto-upgrade helps keep the nodes in your node pool up to date with the latest release version of Kubernetes.
        """
        return pulumi.get(self, "auto_upgrade")

    @property
    @pulumi.getter(name="upgradeOptions")
    def upgrade_options(self) -> 'outputs.AutoUpgradeOptionsResponse':
        """
        Specifies the Auto Upgrade knobs for the node pool.
        """
        return pulumi.get(self, "upgrade_options")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NodePoolAutoscalingResponse(dict):
    """
    NodePoolAutoscaling contains information required by cluster autoscaler to adjust the size of the node pool to the current cluster usage.
    """
    def __init__(__self__, *,
                 autoprovisioned: bool,
                 enabled: bool,
                 max_node_count: int,
                 min_node_count: int):
        """
        NodePoolAutoscaling contains information required by cluster autoscaler to adjust the size of the node pool to the current cluster usage.
        :param bool autoprovisioned: Can this node pool be deleted automatically.
        :param bool enabled: Is autoscaling enabled for this node pool.
        :param int max_node_count: Maximum number of nodes in the NodePool. Must be >= min_node_count. There has to enough quota to scale up the cluster.
        :param int min_node_count: Minimum number of nodes in the NodePool. Must be >= 1 and <= max_node_count.
        """
        pulumi.set(__self__, "autoprovisioned", autoprovisioned)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "max_node_count", max_node_count)
        pulumi.set(__self__, "min_node_count", min_node_count)

    @property
    @pulumi.getter
    def autoprovisioned(self) -> bool:
        """
        Can this node pool be deleted automatically.
        """
        return pulumi.get(self, "autoprovisioned")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Is autoscaling enabled for this node pool.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> int:
        """
        Maximum number of nodes in the NodePool. Must be >= min_node_count. There has to enough quota to scale up the cluster.
        """
        return pulumi.get(self, "max_node_count")

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> int:
        """
        Minimum number of nodes in the NodePool. Must be >= 1 and <= max_node_count.
        """
        return pulumi.get(self, "min_node_count")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NodePoolResponse(dict):
    """
    NodePool contains the name and configuration for a cluster's node pool. Node pools are a set of nodes (i.e. VM's), with a common configuration and specification, under the control of the cluster master. They may have a set of Kubernetes labels applied to them, which may be used to reference them during pod scheduling. They may also be resized up or down, to accommodate the workload.
    """
    def __init__(__self__, *,
                 autoscaling: 'outputs.NodePoolAutoscalingResponse',
                 conditions: Sequence['outputs.StatusConditionResponse'],
                 config: 'outputs.NodeConfigResponse',
                 initial_node_count: int,
                 instance_group_urls: Sequence[str],
                 locations: Sequence[str],
                 management: 'outputs.NodeManagementResponse',
                 max_pods_constraint: 'outputs.MaxPodsConstraintResponse',
                 name: str,
                 pod_ipv4_cidr_size: int,
                 self_link: str,
                 status: str,
                 upgrade_settings: 'outputs.UpgradeSettingsResponse',
                 version: str):
        """
        NodePool contains the name and configuration for a cluster's node pool. Node pools are a set of nodes (i.e. VM's), with a common configuration and specification, under the control of the cluster master. They may have a set of Kubernetes labels applied to them, which may be used to reference them during pod scheduling. They may also be resized up or down, to accommodate the workload.
        :param 'NodePoolAutoscalingResponseArgs' autoscaling: Autoscaler configuration for this NodePool. Autoscaler is enabled only if a valid configuration is present.
        :param Sequence['StatusConditionResponseArgs'] conditions: Which conditions caused the current node pool state.
        :param 'NodeConfigResponseArgs' config: The node configuration of the pool.
        :param int initial_node_count: The initial node count for the pool. You must ensure that your Compute Engine [resource quota](https://cloud.google.com/compute/quotas) is sufficient for this number of instances. You must also have available firewall and routes quota.
        :param Sequence[str] instance_group_urls: [Output only] The resource URLs of the [managed instance groups](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances) associated with this node pool.
        :param Sequence[str] locations: The list of Google Compute Engine [zones](https://cloud.google.com/compute/docs/zones#available) in which the NodePool's nodes should be located. If this value is unspecified during node pool creation, the [Cluster.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters#Cluster.FIELDS.locations) value will be used, instead. Warning: changing node pool locations will result in nodes being added and/or removed.
        :param 'NodeManagementResponseArgs' management: NodeManagement configuration for this NodePool.
        :param 'MaxPodsConstraintResponseArgs' max_pods_constraint: The constraint on the maximum number of pods that can be run simultaneously on a node in the node pool.
        :param str name: The name of the node pool.
        :param int pod_ipv4_cidr_size: [Output only] The pod CIDR block size per node in this node pool.
        :param str self_link: [Output only] Server-defined URL for the resource.
        :param str status: [Output only] The status of the nodes in this pool instance.
        :param 'UpgradeSettingsResponseArgs' upgrade_settings: Upgrade settings control disruption and speed of the upgrade.
        :param str version: The version of the Kubernetes of this node.
        """
        pulumi.set(__self__, "autoscaling", autoscaling)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "initial_node_count", initial_node_count)
        pulumi.set(__self__, "instance_group_urls", instance_group_urls)
        pulumi.set(__self__, "locations", locations)
        pulumi.set(__self__, "management", management)
        pulumi.set(__self__, "max_pods_constraint", max_pods_constraint)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "pod_ipv4_cidr_size", pod_ipv4_cidr_size)
        pulumi.set(__self__, "self_link", self_link)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "upgrade_settings", upgrade_settings)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def autoscaling(self) -> 'outputs.NodePoolAutoscalingResponse':
        """
        Autoscaler configuration for this NodePool. Autoscaler is enabled only if a valid configuration is present.
        """
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.StatusConditionResponse']:
        """
        Which conditions caused the current node pool state.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def config(self) -> 'outputs.NodeConfigResponse':
        """
        The node configuration of the pool.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="initialNodeCount")
    def initial_node_count(self) -> int:
        """
        The initial node count for the pool. You must ensure that your Compute Engine [resource quota](https://cloud.google.com/compute/quotas) is sufficient for this number of instances. You must also have available firewall and routes quota.
        """
        return pulumi.get(self, "initial_node_count")

    @property
    @pulumi.getter(name="instanceGroupUrls")
    def instance_group_urls(self) -> Sequence[str]:
        """
        [Output only] The resource URLs of the [managed instance groups](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances) associated with this node pool.
        """
        return pulumi.get(self, "instance_group_urls")

    @property
    @pulumi.getter
    def locations(self) -> Sequence[str]:
        """
        The list of Google Compute Engine [zones](https://cloud.google.com/compute/docs/zones#available) in which the NodePool's nodes should be located. If this value is unspecified during node pool creation, the [Cluster.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters#Cluster.FIELDS.locations) value will be used, instead. Warning: changing node pool locations will result in nodes being added and/or removed.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter
    def management(self) -> 'outputs.NodeManagementResponse':
        """
        NodeManagement configuration for this NodePool.
        """
        return pulumi.get(self, "management")

    @property
    @pulumi.getter(name="maxPodsConstraint")
    def max_pods_constraint(self) -> 'outputs.MaxPodsConstraintResponse':
        """
        The constraint on the maximum number of pods that can be run simultaneously on a node in the node pool.
        """
        return pulumi.get(self, "max_pods_constraint")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the node pool.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="podIpv4CidrSize")
    def pod_ipv4_cidr_size(self) -> int:
        """
        [Output only] The pod CIDR block size per node in this node pool.
        """
        return pulumi.get(self, "pod_ipv4_cidr_size")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> str:
        """
        [Output only] Server-defined URL for the resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        [Output only] The status of the nodes in this pool instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="upgradeSettings")
    def upgrade_settings(self) -> 'outputs.UpgradeSettingsResponse':
        """
        Upgrade settings control disruption and speed of the upgrade.
        """
        return pulumi.get(self, "upgrade_settings")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of the Kubernetes of this node.
        """
        return pulumi.get(self, "version")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NodeTaintResponse(dict):
    """
    Kubernetes taint is comprised of three fields: key, value, and effect. Effect can only be one of three types: NoSchedule, PreferNoSchedule or NoExecute. See [here](https://kubernetes.io/docs/concepts/configuration/taint-and-toleration) for more information, including usage and the valid values.
    """
    def __init__(__self__, *,
                 effect: str,
                 key: str,
                 value: str):
        """
        Kubernetes taint is comprised of three fields: key, value, and effect. Effect can only be one of three types: NoSchedule, PreferNoSchedule or NoExecute. See [here](https://kubernetes.io/docs/concepts/configuration/taint-and-toleration) for more information, including usage and the valid values.
        :param str effect: Effect for taint.
        :param str key: Key for taint.
        :param str value: Value for taint.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> str:
        """
        Effect for taint.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Key for taint.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value for taint.
        """
        return pulumi.get(self, "value")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NotificationConfigResponse(dict):
    """
    NotificationConfig is the configuration of notifications.
    """
    def __init__(__self__, *,
                 pubsub: 'outputs.PubSubResponse'):
        """
        NotificationConfig is the configuration of notifications.
        :param 'PubSubResponseArgs' pubsub: Notification config for Pub/Sub.
        """
        pulumi.set(__self__, "pubsub", pubsub)

    @property
    @pulumi.getter
    def pubsub(self) -> 'outputs.PubSubResponse':
        """
        Notification config for Pub/Sub.
        """
        return pulumi.get(self, "pubsub")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class PrivateClusterConfigResponse(dict):
    """
    Configuration options for private clusters.
    """
    def __init__(__self__, *,
                 enable_private_endpoint: bool,
                 enable_private_nodes: bool,
                 master_global_access_config: 'outputs.PrivateClusterMasterGlobalAccessConfigResponse',
                 master_ipv4_cidr_block: str,
                 peering_name: str,
                 private_endpoint: str,
                 public_endpoint: str):
        """
        Configuration options for private clusters.
        :param bool enable_private_endpoint: Whether the master's internal IP address is used as the cluster endpoint.
        :param bool enable_private_nodes: Whether nodes have internal IP addresses only. If enabled, all nodes are given only RFC 1918 private addresses and communicate with the master via private networking.
        :param 'PrivateClusterMasterGlobalAccessConfigResponseArgs' master_global_access_config: Controls master global access settings.
        :param str master_ipv4_cidr_block: The IP range in CIDR notation to use for the hosted master network. This range will be used for assigning internal IP addresses to the master or set of masters, as well as the ILB VIP. This range must not overlap with any other ranges in use within the cluster's network.
        :param str peering_name: The peering name in the customer VPC used by this cluster.
        :param str private_endpoint: The internal IP address of this cluster's master endpoint.
        :param str public_endpoint: The external IP address of this cluster's master endpoint.
        """
        pulumi.set(__self__, "enable_private_endpoint", enable_private_endpoint)
        pulumi.set(__self__, "enable_private_nodes", enable_private_nodes)
        pulumi.set(__self__, "master_global_access_config", master_global_access_config)
        pulumi.set(__self__, "master_ipv4_cidr_block", master_ipv4_cidr_block)
        pulumi.set(__self__, "peering_name", peering_name)
        pulumi.set(__self__, "private_endpoint", private_endpoint)
        pulumi.set(__self__, "public_endpoint", public_endpoint)

    @property
    @pulumi.getter(name="enablePrivateEndpoint")
    def enable_private_endpoint(self) -> bool:
        """
        Whether the master's internal IP address is used as the cluster endpoint.
        """
        return pulumi.get(self, "enable_private_endpoint")

    @property
    @pulumi.getter(name="enablePrivateNodes")
    def enable_private_nodes(self) -> bool:
        """
        Whether nodes have internal IP addresses only. If enabled, all nodes are given only RFC 1918 private addresses and communicate with the master via private networking.
        """
        return pulumi.get(self, "enable_private_nodes")

    @property
    @pulumi.getter(name="masterGlobalAccessConfig")
    def master_global_access_config(self) -> 'outputs.PrivateClusterMasterGlobalAccessConfigResponse':
        """
        Controls master global access settings.
        """
        return pulumi.get(self, "master_global_access_config")

    @property
    @pulumi.getter(name="masterIpv4CidrBlock")
    def master_ipv4_cidr_block(self) -> str:
        """
        The IP range in CIDR notation to use for the hosted master network. This range will be used for assigning internal IP addresses to the master or set of masters, as well as the ILB VIP. This range must not overlap with any other ranges in use within the cluster's network.
        """
        return pulumi.get(self, "master_ipv4_cidr_block")

    @property
    @pulumi.getter(name="peeringName")
    def peering_name(self) -> str:
        """
        The peering name in the customer VPC used by this cluster.
        """
        return pulumi.get(self, "peering_name")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> str:
        """
        The internal IP address of this cluster's master endpoint.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> str:
        """
        The external IP address of this cluster's master endpoint.
        """
        return pulumi.get(self, "public_endpoint")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class PrivateClusterMasterGlobalAccessConfigResponse(dict):
    """
    Configuration for controlling master global access settings.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Configuration for controlling master global access settings.
        :param bool enabled: Whenever master is accessible globally or not.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whenever master is accessible globally or not.
        """
        return pulumi.get(self, "enabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class PubSubResponse(dict):
    """
    Pub/Sub specific notification config.
    """
    def __init__(__self__, *,
                 enabled: bool,
                 topic: str):
        """
        Pub/Sub specific notification config.
        :param bool enabled: Enable notifications for Pub/Sub.
        :param str topic: The desired Pub/Sub topic to which notifications will be sent by GKE. Format is `projects/{project}/topics/{topic}`.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Enable notifications for Pub/Sub.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The desired Pub/Sub topic to which notifications will be sent by GKE. Format is `projects/{project}/topics/{topic}`.
        """
        return pulumi.get(self, "topic")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class RecurringTimeWindowResponse(dict):
    """
    Represents an arbitrary window of time that recurs.
    """
    def __init__(__self__, *,
                 recurrence: str,
                 window: 'outputs.TimeWindowResponse'):
        """
        Represents an arbitrary window of time that recurs.
        :param str recurrence: An RRULE (https://tools.ietf.org/html/rfc5545#section-3.8.5.3) for how this window reccurs. They go on for the span of time between the start and end time. For example, to have something repeat every weekday, you'd use: `FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR` To repeat some window daily (equivalent to the DailyMaintenanceWindow): `FREQ=DAILY` For the first weekend of every month: `FREQ=MONTHLY;BYSETPOS=1;BYDAY=SA,SU` This specifies how frequently the window starts. Eg, if you wanted to have a 9-5 UTC-4 window every weekday, you'd use something like: ``` start time = 2019-01-01T09:00:00-0400 end time = 2019-01-01T17:00:00-0400 recurrence = FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR ``` Windows can span multiple days. Eg, to make the window encompass every weekend from midnight Saturday till the last minute of Sunday UTC: ``` start time = 2019-01-05T00:00:00Z end time = 2019-01-07T23:59:00Z recurrence = FREQ=WEEKLY;BYDAY=SA ``` Note the start and end time's specific dates are largely arbitrary except to specify duration of the window and when it first starts. The FREQ values of HOURLY, MINUTELY, and SECONDLY are not supported.
        :param 'TimeWindowResponseArgs' window: The window of the first recurrence.
        """
        pulumi.set(__self__, "recurrence", recurrence)
        pulumi.set(__self__, "window", window)

    @property
    @pulumi.getter
    def recurrence(self) -> str:
        """
        An RRULE (https://tools.ietf.org/html/rfc5545#section-3.8.5.3) for how this window reccurs. They go on for the span of time between the start and end time. For example, to have something repeat every weekday, you'd use: `FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR` To repeat some window daily (equivalent to the DailyMaintenanceWindow): `FREQ=DAILY` For the first weekend of every month: `FREQ=MONTHLY;BYSETPOS=1;BYDAY=SA,SU` This specifies how frequently the window starts. Eg, if you wanted to have a 9-5 UTC-4 window every weekday, you'd use something like: ``` start time = 2019-01-01T09:00:00-0400 end time = 2019-01-01T17:00:00-0400 recurrence = FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR ``` Windows can span multiple days. Eg, to make the window encompass every weekend from midnight Saturday till the last minute of Sunday UTC: ``` start time = 2019-01-05T00:00:00Z end time = 2019-01-07T23:59:00Z recurrence = FREQ=WEEKLY;BYDAY=SA ``` Note the start and end time's specific dates are largely arbitrary except to specify duration of the window and when it first starts. The FREQ values of HOURLY, MINUTELY, and SECONDLY are not supported.
        """
        return pulumi.get(self, "recurrence")

    @property
    @pulumi.getter
    def window(self) -> 'outputs.TimeWindowResponse':
        """
        The window of the first recurrence.
        """
        return pulumi.get(self, "window")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ReleaseChannelResponse(dict):
    """
    ReleaseChannel indicates which release channel a cluster is subscribed to. Release channels are arranged in order of risk. When a cluster is subscribed to a release channel, Google maintains both the master version and the node version. Node auto-upgrade defaults to true and cannot be disabled.
    """
    def __init__(__self__, *,
                 channel: str):
        """
        ReleaseChannel indicates which release channel a cluster is subscribed to. Release channels are arranged in order of risk. When a cluster is subscribed to a release channel, Google maintains both the master version and the node version. Node auto-upgrade defaults to true and cannot be disabled.
        :param str channel: channel specifies which release channel the cluster is subscribed to.
        """
        pulumi.set(__self__, "channel", channel)

    @property
    @pulumi.getter
    def channel(self) -> str:
        """
        channel specifies which release channel the cluster is subscribed to.
        """
        return pulumi.get(self, "channel")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ReservationAffinityResponse(dict):
    """
    [ReservationAffinity](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources) is the configuration of desired reservation which instances could take capacity from.
    """
    def __init__(__self__, *,
                 consume_reservation_type: str,
                 key: str,
                 values: Sequence[str]):
        """
        [ReservationAffinity](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources) is the configuration of desired reservation which instances could take capacity from.
        :param str consume_reservation_type: Corresponds to the type of reservation consumption.
        :param str key: Corresponds to the label key of a reservation resource. To target a SPECIFIC_RESERVATION by name, specify "googleapis.com/reservation-name" as the key and specify the name of your reservation as its value.
        :param Sequence[str] values: Corresponds to the label value(s) of reservation resource(s).
        """
        pulumi.set(__self__, "consume_reservation_type", consume_reservation_type)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="consumeReservationType")
    def consume_reservation_type(self) -> str:
        """
        Corresponds to the type of reservation consumption.
        """
        return pulumi.get(self, "consume_reservation_type")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Corresponds to the label key of a reservation resource. To target a SPECIFIC_RESERVATION by name, specify "googleapis.com/reservation-name" as the key and specify the name of your reservation as its value.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Corresponds to the label value(s) of reservation resource(s).
        """
        return pulumi.get(self, "values")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ResourceLimitResponse(dict):
    """
    Contains information about amount of some resource in the cluster. For memory, value should be in GB.
    """
    def __init__(__self__, *,
                 maximum: str,
                 minimum: str,
                 resource_type: str):
        """
        Contains information about amount of some resource in the cluster. For memory, value should be in GB.
        :param str maximum: Maximum amount of the resource in the cluster.
        :param str minimum: Minimum amount of the resource in the cluster.
        :param str resource_type: Resource name "cpu", "memory" or gpu-specific string.
        """
        pulumi.set(__self__, "maximum", maximum)
        pulumi.set(__self__, "minimum", minimum)
        pulumi.set(__self__, "resource_type", resource_type)

    @property
    @pulumi.getter
    def maximum(self) -> str:
        """
        Maximum amount of the resource in the cluster.
        """
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter
    def minimum(self) -> str:
        """
        Minimum amount of the resource in the cluster.
        """
        return pulumi.get(self, "minimum")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        Resource name "cpu", "memory" or gpu-specific string.
        """
        return pulumi.get(self, "resource_type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ResourceUsageExportConfigResponse(dict):
    """
    Configuration for exporting cluster resource usages.
    """
    def __init__(__self__, *,
                 bigquery_destination: 'outputs.BigQueryDestinationResponse',
                 consumption_metering_config: 'outputs.ConsumptionMeteringConfigResponse',
                 enable_network_egress_metering: bool):
        """
        Configuration for exporting cluster resource usages.
        :param 'BigQueryDestinationResponseArgs' bigquery_destination: Configuration to use BigQuery as usage export destination.
        :param 'ConsumptionMeteringConfigResponseArgs' consumption_metering_config: Configuration to enable resource consumption metering.
        :param bool enable_network_egress_metering: Whether to enable network egress metering for this cluster. If enabled, a daemonset will be created in the cluster to meter network egress traffic.
        """
        pulumi.set(__self__, "bigquery_destination", bigquery_destination)
        pulumi.set(__self__, "consumption_metering_config", consumption_metering_config)
        pulumi.set(__self__, "enable_network_egress_metering", enable_network_egress_metering)

    @property
    @pulumi.getter(name="bigqueryDestination")
    def bigquery_destination(self) -> 'outputs.BigQueryDestinationResponse':
        """
        Configuration to use BigQuery as usage export destination.
        """
        return pulumi.get(self, "bigquery_destination")

    @property
    @pulumi.getter(name="consumptionMeteringConfig")
    def consumption_metering_config(self) -> 'outputs.ConsumptionMeteringConfigResponse':
        """
        Configuration to enable resource consumption metering.
        """
        return pulumi.get(self, "consumption_metering_config")

    @property
    @pulumi.getter(name="enableNetworkEgressMetering")
    def enable_network_egress_metering(self) -> bool:
        """
        Whether to enable network egress metering for this cluster. If enabled, a daemonset will be created in the cluster to meter network egress traffic.
        """
        return pulumi.get(self, "enable_network_egress_metering")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SandboxConfigResponse(dict):
    """
    SandboxConfig contains configurations of the sandbox to use for the node.
    """
    def __init__(__self__, *,
                 type: str):
        """
        SandboxConfig contains configurations of the sandbox to use for the node.
        :param str type: Type of the sandbox to use for the node.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the sandbox to use for the node.
        """
        return pulumi.get(self, "type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ShieldedInstanceConfigResponse(dict):
    """
    A set of Shielded Instance options.
    """
    def __init__(__self__, *,
                 enable_integrity_monitoring: bool,
                 enable_secure_boot: bool):
        """
        A set of Shielded Instance options.
        :param bool enable_integrity_monitoring: Defines whether the instance has integrity monitoring enabled. Enables monitoring and attestation of the boot integrity of the instance. The attestation is performed against the integrity policy baseline. This baseline is initially derived from the implicitly trusted boot image when the instance is created.
        :param bool enable_secure_boot: Defines whether the instance has Secure Boot enabled. Secure Boot helps ensure that the system only runs authentic software by verifying the digital signature of all boot components, and halting the boot process if signature verification fails.
        """
        pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)

    @property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> bool:
        """
        Defines whether the instance has integrity monitoring enabled. Enables monitoring and attestation of the boot integrity of the instance. The attestation is performed against the integrity policy baseline. This baseline is initially derived from the implicitly trusted boot image when the instance is created.
        """
        return pulumi.get(self, "enable_integrity_monitoring")

    @property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> bool:
        """
        Defines whether the instance has Secure Boot enabled. Secure Boot helps ensure that the system only runs authentic software by verifying the digital signature of all boot components, and halting the boot process if signature verification fails.
        """
        return pulumi.get(self, "enable_secure_boot")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ShieldedNodesResponse(dict):
    """
    Configuration of Shielded Nodes feature.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Configuration of Shielded Nodes feature.
        :param bool enabled: Whether Shielded Nodes features are enabled on all nodes in this cluster.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether Shielded Nodes features are enabled on all nodes in this cluster.
        """
        return pulumi.get(self, "enabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class StatusConditionResponse(dict):
    """
    StatusCondition describes why a cluster or a node pool has a certain status (e.g., ERROR or DEGRADED).
    """
    def __init__(__self__, *,
                 canonical_code: str,
                 message: str):
        """
        StatusCondition describes why a cluster or a node pool has a certain status (e.g., ERROR or DEGRADED).
        :param str canonical_code: Canonical code of the condition.
        :param str message: Human-friendly representation of the condition
        """
        pulumi.set(__self__, "canonical_code", canonical_code)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter(name="canonicalCode")
    def canonical_code(self) -> str:
        """
        Canonical code of the condition.
        """
        return pulumi.get(self, "canonical_code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Human-friendly representation of the condition
        """
        return pulumi.get(self, "message")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TimeWindowResponse(dict):
    """
    Represents an arbitrary window of time.
    """
    def __init__(__self__, *,
                 end_time: str,
                 start_time: str):
        """
        Represents an arbitrary window of time.
        :param str end_time: The time that the window ends. The end time should take place after the start time.
        :param str start_time: The time that the window first starts.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The time that the window ends. The end time should take place after the start time.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The time that the window first starts.
        """
        return pulumi.get(self, "start_time")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class UpgradeSettingsResponse(dict):
    """
    These upgrade settings control the level of parallelism and the level of disruption caused by an upgrade. maxUnavailable controls the number of nodes that can be simultaneously unavailable. maxSurge controls the number of additional nodes that can be added to the node pool temporarily for the time of the upgrade to increase the number of available nodes. (maxUnavailable + maxSurge) determines the level of parallelism (how many nodes are being upgraded at the same time). Note: upgrades inevitably introduce some disruption since workloads need to be moved from old nodes to new, upgraded ones. Even if maxUnavailable=0, this holds true. (Disruption stays within the limits of PodDisruptionBudget, if it is configured.) Consider a hypothetical node pool with 5 nodes having maxSurge=2, maxUnavailable=1. This means the upgrade process upgrades 3 nodes simultaneously. It creates 2 additional (upgraded) nodes, then it brings down 3 old (not yet upgraded) nodes at the same time. This ensures that there are always at least 4 nodes available.
    """
    def __init__(__self__, *,
                 max_surge: int,
                 max_unavailable: int):
        """
        These upgrade settings control the level of parallelism and the level of disruption caused by an upgrade. maxUnavailable controls the number of nodes that can be simultaneously unavailable. maxSurge controls the number of additional nodes that can be added to the node pool temporarily for the time of the upgrade to increase the number of available nodes. (maxUnavailable + maxSurge) determines the level of parallelism (how many nodes are being upgraded at the same time). Note: upgrades inevitably introduce some disruption since workloads need to be moved from old nodes to new, upgraded ones. Even if maxUnavailable=0, this holds true. (Disruption stays within the limits of PodDisruptionBudget, if it is configured.) Consider a hypothetical node pool with 5 nodes having maxSurge=2, maxUnavailable=1. This means the upgrade process upgrades 3 nodes simultaneously. It creates 2 additional (upgraded) nodes, then it brings down 3 old (not yet upgraded) nodes at the same time. This ensures that there are always at least 4 nodes available.
        :param int max_surge: The maximum number of nodes that can be created beyond the current size of the node pool during the upgrade process.
        :param int max_unavailable: The maximum number of nodes that can be simultaneously unavailable during the upgrade process. A node is considered available if its status is Ready.
        """
        pulumi.set(__self__, "max_surge", max_surge)
        pulumi.set(__self__, "max_unavailable", max_unavailable)

    @property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> int:
        """
        The maximum number of nodes that can be created beyond the current size of the node pool during the upgrade process.
        """
        return pulumi.get(self, "max_surge")

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> int:
        """
        The maximum number of nodes that can be simultaneously unavailable during the upgrade process. A node is considered available if its status is Ready.
        """
        return pulumi.get(self, "max_unavailable")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class VerticalPodAutoscalingResponse(dict):
    """
    VerticalPodAutoscaling contains global, per-cluster information required by Vertical Pod Autoscaler to automatically adjust the resources of pods controlled by it.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        VerticalPodAutoscaling contains global, per-cluster information required by Vertical Pod Autoscaler to automatically adjust the resources of pods controlled by it.
        :param bool enabled: Enables vertical pod autoscaling.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Enables vertical pod autoscaling.
        """
        return pulumi.get(self, "enabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class WorkloadIdentityConfigResponse(dict):
    """
    Configuration for the use of Kubernetes Service Accounts in GCP IAM policies.
    """
    def __init__(__self__, *,
                 workload_pool: str):
        """
        Configuration for the use of Kubernetes Service Accounts in GCP IAM policies.
        :param str workload_pool: The workload pool to attach all Kubernetes service accounts to.
        """
        pulumi.set(__self__, "workload_pool", workload_pool)

    @property
    @pulumi.getter(name="workloadPool")
    def workload_pool(self) -> str:
        """
        The workload pool to attach all Kubernetes service accounts to.
        """
        return pulumi.get(self, "workload_pool")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class WorkloadMetadataConfigResponse(dict):
    """
    WorkloadMetadataConfig defines the metadata configuration to expose to workloads on the node pool.
    """
    def __init__(__self__, *,
                 mode: str):
        """
        WorkloadMetadataConfig defines the metadata configuration to expose to workloads on the node pool.
        :param str mode: Mode is the configuration for how to expose metadata to workloads running on the node pool.
        """
        pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Mode is the configuration for how to expose metadata to workloads running on the node pool.
        """
        return pulumi.get(self, "mode")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


