# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['InterconnectAttachment']


class InterconnectAttachment(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_enabled: Optional[pulumi.Input[bool]] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 candidate_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cloud_router_ip_address: Optional[pulumi.Input[str]] = None,
                 creation_timestamp: Optional[pulumi.Input[str]] = None,
                 customer_router_ip_address: Optional[pulumi.Input[str]] = None,
                 dataplane_version: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 edge_availability_domain: Optional[pulumi.Input[str]] = None,
                 encryption: Optional[pulumi.Input[str]] = None,
                 google_reference_id: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 interconnect: Optional[pulumi.Input[str]] = None,
                 interconnect_attachment: Optional[pulumi.Input[str]] = None,
                 ipsec_internal_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 label_fingerprint: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 mtu: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operational_status: Optional[pulumi.Input[str]] = None,
                 pairing_key: Optional[pulumi.Input[str]] = None,
                 partner_asn: Optional[pulumi.Input[str]] = None,
                 partner_metadata: Optional[pulumi.Input[pulumi.InputType['InterconnectAttachmentPartnerMetadataArgs']]] = None,
                 private_interconnect_info: Optional[pulumi.Input[pulumi.InputType['InterconnectAttachmentPrivateInfoArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 router: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vlan_tag8021q: Optional[pulumi.Input[int]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates an InterconnectAttachment in the specified project using the data included in the request.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admin_enabled: Determines whether this Attachment will carry packets. Not present for PARTNER_PROVIDER.
        :param pulumi.Input[str] bandwidth: Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: 
               - BPS_50M: 50 Mbit/s 
               - BPS_100M: 100 Mbit/s 
               - BPS_200M: 200 Mbit/s 
               - BPS_300M: 300 Mbit/s 
               - BPS_400M: 400 Mbit/s 
               - BPS_500M: 500 Mbit/s 
               - BPS_1G: 1 Gbit/s 
               - BPS_2G: 2 Gbit/s 
               - BPS_5G: 5 Gbit/s 
               - BPS_10G: 10 Gbit/s 
               - BPS_20G: 20 Gbit/s 
               - BPS_50G: 50 Gbit/s
        :param pulumi.Input[Sequence[pulumi.Input[str]]] candidate_subnets: Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
        :param pulumi.Input[str] cloud_router_ip_address: [Output Only] IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
        :param pulumi.Input[str] creation_timestamp: [Output Only] Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] customer_router_ip_address: [Output Only] IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
        :param pulumi.Input[int] dataplane_version: [Output Only] Dataplane version for this InterconnectAttachment.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[str] edge_availability_domain: Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values: 
               - AVAILABILITY_DOMAIN_ANY 
               - AVAILABILITY_DOMAIN_1 
               - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
        :param pulumi.Input[str] encryption: Indicates the user-supplied encryption option of this interconnect attachment: 
               - NONE is the default value, which means that the attachment carries unencrypted traffic. VMs can send traffic to, or receive traffic from, this type of attachment. 
               - IPSEC indicates that the attachment carries only traffic encrypted by an IPsec device such as an HA VPN gateway. VMs cannot directly send traffic to, or receive traffic from, such an attachment. To use IPsec-encrypted Cloud Interconnect, create the attachment using this option. 
               Not currently available in all Interconnect locations.
        :param pulumi.Input[str] google_reference_id: [Output Only] Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity issues. [Deprecated] This field is not used.
        :param pulumi.Input[str] id: [Output Only] The unique identifier for the resource. This identifier is defined by the server.
        :param pulumi.Input[str] interconnect: URL of the underlying Interconnect object that this attachment's traffic will traverse through.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipsec_internal_addresses: URL of addresses that have been reserved for the interconnect attachment, Used only for interconnect attachment that has the encryption option as IPSEC. The addresses must be RFC 1918 IP address ranges. When creating HA VPN gateway over the interconnect attachment, if the attachment is configured to use an RFC 1918 IP address, then the VPN gateway?s IP address will be allocated from the IP address range specified here. For example, if the HA VPN gateway?s interface 0 is paired to this interconnect attachment, then an RFC 1918 IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this interconnect attachment. If this field is not specified for interconnect attachment that has encryption option as IPSEC, later on when creating HA VPN gateway on this interconnect attachment, the HA VPN gateway's IP address will be allocated from regional external IP address pool.
               Not currently available in all Interconnect locations.
        :param pulumi.Input[str] kind: [Output Only] Type of the resource. Always compute#interconnectAttachment for interconnect attachments.
        :param pulumi.Input[str] label_fingerprint: A fingerprint for the labels being applied to this InterconnectAttachment, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
               
               To see the latest fingerprint, make a get() request to retrieve an InterconnectAttachment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
        :param pulumi.Input[int] mtu: Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment. Only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[str] operational_status: [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values: 
               - OS_ACTIVE: The attachment has been turned up and is ready to use. 
               - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
        :param pulumi.Input[str] pairing_key: [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of an PARTNER attachment used to initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
        :param pulumi.Input[str] partner_asn: Optional BGP ASN for the router supplied by a Layer 3 Partner if they configured BGP on behalf of the customer. Output only for PARTNER type, input only for PARTNER_PROVIDER, not available for DEDICATED.
        :param pulumi.Input[pulumi.InputType['InterconnectAttachmentPartnerMetadataArgs']] partner_metadata: Informational metadata about Partner attachments from Partners to display to customers. Output only for for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
        :param pulumi.Input[pulumi.InputType['InterconnectAttachmentPrivateInfoArgs']] private_interconnect_info: [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
        :param pulumi.Input[str] region: [Output Only] URL of the region where the regional interconnect attachment resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        :param pulumi.Input[str] router: URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network & region within which the Cloud Router is configured.
        :param pulumi.Input[str] self_link: [Output Only] Server-defined URL for the resource.
        :param pulumi.Input[str] state: [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values: 
               - ACTIVE: The attachment has been turned up and is ready to use. 
               - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete. 
               - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side. 
               - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it. 
               - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it. 
               - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
        :param pulumi.Input[str] type: The type of interconnect attachment this is, which can take one of the following values: 
               - DEDICATED: an attachment to a Dedicated Interconnect. 
               - PARTNER: an attachment to a Partner Interconnect, created by the customer. 
               - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
        :param pulumi.Input[int] vlan_tag8021q: The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. Only specified at creation time.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['admin_enabled'] = admin_enabled
            __props__['bandwidth'] = bandwidth
            __props__['candidate_subnets'] = candidate_subnets
            __props__['cloud_router_ip_address'] = cloud_router_ip_address
            __props__['creation_timestamp'] = creation_timestamp
            __props__['customer_router_ip_address'] = customer_router_ip_address
            __props__['dataplane_version'] = dataplane_version
            __props__['description'] = description
            __props__['edge_availability_domain'] = edge_availability_domain
            __props__['encryption'] = encryption
            __props__['google_reference_id'] = google_reference_id
            __props__['id'] = id
            __props__['interconnect'] = interconnect
            if interconnect_attachment is None and not opts.urn:
                raise TypeError("Missing required property 'interconnect_attachment'")
            __props__['interconnect_attachment'] = interconnect_attachment
            __props__['ipsec_internal_addresses'] = ipsec_internal_addresses
            __props__['kind'] = kind
            __props__['label_fingerprint'] = label_fingerprint
            __props__['labels'] = labels
            __props__['mtu'] = mtu
            __props__['name'] = name
            __props__['operational_status'] = operational_status
            __props__['pairing_key'] = pairing_key
            __props__['partner_asn'] = partner_asn
            __props__['partner_metadata'] = partner_metadata
            __props__['private_interconnect_info'] = private_interconnect_info
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__['region'] = region
            __props__['router'] = router
            __props__['self_link'] = self_link
            __props__['state'] = state
            __props__['type'] = type
            __props__['vlan_tag8021q'] = vlan_tag8021q
        super(InterconnectAttachment, __self__).__init__(
            'gcp-native:compute/beta:InterconnectAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'InterconnectAttachment':
        """
        Get an existing InterconnectAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["admin_enabled"] = None
        __props__["bandwidth"] = None
        __props__["candidate_subnets"] = None
        __props__["cloud_router_ip_address"] = None
        __props__["creation_timestamp"] = None
        __props__["customer_router_ip_address"] = None
        __props__["dataplane_version"] = None
        __props__["description"] = None
        __props__["edge_availability_domain"] = None
        __props__["encryption"] = None
        __props__["google_reference_id"] = None
        __props__["interconnect"] = None
        __props__["ipsec_internal_addresses"] = None
        __props__["kind"] = None
        __props__["label_fingerprint"] = None
        __props__["labels"] = None
        __props__["mtu"] = None
        __props__["name"] = None
        __props__["operational_status"] = None
        __props__["pairing_key"] = None
        __props__["partner_asn"] = None
        __props__["partner_metadata"] = None
        __props__["private_interconnect_info"] = None
        __props__["region"] = None
        __props__["router"] = None
        __props__["self_link"] = None
        __props__["state"] = None
        __props__["type"] = None
        __props__["vlan_tag8021q"] = None
        return InterconnectAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminEnabled")
    def admin_enabled(self) -> pulumi.Output[bool]:
        """
        Determines whether this Attachment will carry packets. Not present for PARTNER_PROVIDER.
        """
        return pulumi.get(self, "admin_enabled")

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[str]:
        """
        Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: 
        - BPS_50M: 50 Mbit/s 
        - BPS_100M: 100 Mbit/s 
        - BPS_200M: 200 Mbit/s 
        - BPS_300M: 300 Mbit/s 
        - BPS_400M: 400 Mbit/s 
        - BPS_500M: 500 Mbit/s 
        - BPS_1G: 1 Gbit/s 
        - BPS_2G: 2 Gbit/s 
        - BPS_5G: 5 Gbit/s 
        - BPS_10G: 10 Gbit/s 
        - BPS_20G: 20 Gbit/s 
        - BPS_50G: 50 Gbit/s
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="candidateSubnets")
    def candidate_subnets(self) -> pulumi.Output[Sequence[str]]:
        """
        Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
        """
        return pulumi.get(self, "candidate_subnets")

    @property
    @pulumi.getter(name="cloudRouterIpAddress")
    def cloud_router_ip_address(self) -> pulumi.Output[str]:
        """
        [Output Only] IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
        """
        return pulumi.get(self, "cloud_router_ip_address")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[str]:
        """
        [Output Only] Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter(name="customerRouterIpAddress")
    def customer_router_ip_address(self) -> pulumi.Output[str]:
        """
        [Output Only] IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
        """
        return pulumi.get(self, "customer_router_ip_address")

    @property
    @pulumi.getter(name="dataplaneVersion")
    def dataplane_version(self) -> pulumi.Output[int]:
        """
        [Output Only] Dataplane version for this InterconnectAttachment.
        """
        return pulumi.get(self, "dataplane_version")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="edgeAvailabilityDomain")
    def edge_availability_domain(self) -> pulumi.Output[str]:
        """
        Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values: 
        - AVAILABILITY_DOMAIN_ANY 
        - AVAILABILITY_DOMAIN_1 
        - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
        """
        return pulumi.get(self, "edge_availability_domain")

    @property
    @pulumi.getter
    def encryption(self) -> pulumi.Output[str]:
        """
        Indicates the user-supplied encryption option of this interconnect attachment: 
        - NONE is the default value, which means that the attachment carries unencrypted traffic. VMs can send traffic to, or receive traffic from, this type of attachment. 
        - IPSEC indicates that the attachment carries only traffic encrypted by an IPsec device such as an HA VPN gateway. VMs cannot directly send traffic to, or receive traffic from, such an attachment. To use IPsec-encrypted Cloud Interconnect, create the attachment using this option. 
        Not currently available in all Interconnect locations.
        """
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter(name="googleReferenceId")
    def google_reference_id(self) -> pulumi.Output[str]:
        """
        [Output Only] Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity issues. [Deprecated] This field is not used.
        """
        return pulumi.get(self, "google_reference_id")

    @property
    @pulumi.getter
    def interconnect(self) -> pulumi.Output[str]:
        """
        URL of the underlying Interconnect object that this attachment's traffic will traverse through.
        """
        return pulumi.get(self, "interconnect")

    @property
    @pulumi.getter(name="ipsecInternalAddresses")
    def ipsec_internal_addresses(self) -> pulumi.Output[Sequence[str]]:
        """
        URL of addresses that have been reserved for the interconnect attachment, Used only for interconnect attachment that has the encryption option as IPSEC. The addresses must be RFC 1918 IP address ranges. When creating HA VPN gateway over the interconnect attachment, if the attachment is configured to use an RFC 1918 IP address, then the VPN gateway?s IP address will be allocated from the IP address range specified here. For example, if the HA VPN gateway?s interface 0 is paired to this interconnect attachment, then an RFC 1918 IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this interconnect attachment. If this field is not specified for interconnect attachment that has encryption option as IPSEC, later on when creating HA VPN gateway on this interconnect attachment, the HA VPN gateway's IP address will be allocated from regional external IP address pool.
        Not currently available in all Interconnect locations.
        """
        return pulumi.get(self, "ipsec_internal_addresses")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[str]:
        """
        [Output Only] Type of the resource. Always compute#interconnectAttachment for interconnect attachments.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> pulumi.Output[str]:
        """
        A fingerprint for the labels being applied to this InterconnectAttachment, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.

        To see the latest fingerprint, make a get() request to retrieve an InterconnectAttachment.
        """
        return pulumi.get(self, "label_fingerprint")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def mtu(self) -> pulumi.Output[int]:
        """
        Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment. Only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
        """
        return pulumi.get(self, "mtu")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="operationalStatus")
    def operational_status(self) -> pulumi.Output[str]:
        """
        [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values: 
        - OS_ACTIVE: The attachment has been turned up and is ready to use. 
        - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
        """
        return pulumi.get(self, "operational_status")

    @property
    @pulumi.getter(name="pairingKey")
    def pairing_key(self) -> pulumi.Output[str]:
        """
        [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of an PARTNER attachment used to initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
        """
        return pulumi.get(self, "pairing_key")

    @property
    @pulumi.getter(name="partnerAsn")
    def partner_asn(self) -> pulumi.Output[str]:
        """
        Optional BGP ASN for the router supplied by a Layer 3 Partner if they configured BGP on behalf of the customer. Output only for PARTNER type, input only for PARTNER_PROVIDER, not available for DEDICATED.
        """
        return pulumi.get(self, "partner_asn")

    @property
    @pulumi.getter(name="partnerMetadata")
    def partner_metadata(self) -> pulumi.Output['outputs.InterconnectAttachmentPartnerMetadataResponse']:
        """
        Informational metadata about Partner attachments from Partners to display to customers. Output only for for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
        """
        return pulumi.get(self, "partner_metadata")

    @property
    @pulumi.getter(name="privateInterconnectInfo")
    def private_interconnect_info(self) -> pulumi.Output['outputs.InterconnectAttachmentPrivateInfoResponse']:
        """
        [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
        """
        return pulumi.get(self, "private_interconnect_info")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        [Output Only] URL of the region where the regional interconnect attachment resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def router(self) -> pulumi.Output[str]:
        """
        URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network & region within which the Cloud Router is configured.
        """
        return pulumi.get(self, "router")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        [Output Only] Server-defined URL for the resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values: 
        - ACTIVE: The attachment has been turned up and is ready to use. 
        - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete. 
        - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side. 
        - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it. 
        - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it. 
        - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of interconnect attachment this is, which can take one of the following values: 
        - DEDICATED: an attachment to a Dedicated Interconnect. 
        - PARTNER: an attachment to a Partner Interconnect, created by the customer. 
        - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vlanTag8021q")
    def vlan_tag8021q(self) -> pulumi.Output[int]:
        """
        The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. Only specified at creation time.
        """
        return pulumi.get(self, "vlan_tag8021q")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

