# coding: utf-8

"""
    NCBI Datasets API

    NCBI service to query and download biological sequence data across all domains of life from NCBI databases.  # noqa: E501

    The version of the OpenAPI document: v1alpha
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ncbi.datasets.configuration import Configuration


class V1alpha1AssemblyDatasetRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'assembly_accessions': 'list[str]',
        'chromosomes': 'list[str]',
        'include_annotation': 'bool',
        'include_annotation_type': 'list[AnnotationForAssemblyType]',
        'include_sequence': 'bool'
    }

    attribute_map = {
        'assembly_accessions': 'assembly_accessions',
        'chromosomes': 'chromosomes',
        'include_annotation': 'include_annotation',
        'include_annotation_type': 'include_annotation_type',
        'include_sequence': 'include_sequence'
    }

    def __init__(self, assembly_accessions=None, chromosomes=None, include_annotation=None, include_annotation_type=None, include_sequence=None, local_vars_configuration=None):  # noqa: E501
        """V1alpha1AssemblyDatasetRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._assembly_accessions = None
        self._chromosomes = None
        self._include_annotation = None
        self._include_annotation_type = None
        self._include_sequence = None
        self.discriminator = None

        if assembly_accessions is not None:
            self.assembly_accessions = assembly_accessions
        if chromosomes is not None:
            self.chromosomes = chromosomes
        if include_annotation is not None:
            self.include_annotation = include_annotation
        if include_annotation_type is not None:
            self.include_annotation_type = include_annotation_type
        if include_sequence is not None:
            self.include_sequence = include_sequence

    @property
    def assembly_accessions(self):
        """Gets the assembly_accessions of this V1alpha1AssemblyDatasetRequest.  # noqa: E501

        Use 'add item' to include multiple assembly accessions.  # noqa: E501

        :return: The assembly_accessions of this V1alpha1AssemblyDatasetRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._assembly_accessions

    @assembly_accessions.setter
    def assembly_accessions(self, assembly_accessions):
        """Sets the assembly_accessions of this V1alpha1AssemblyDatasetRequest.

        Use 'add item' to include multiple assembly accessions.  # noqa: E501

        :param assembly_accessions: The assembly_accessions of this V1alpha1AssemblyDatasetRequest.  # noqa: E501
        :type: list[str]
        """

        self._assembly_accessions = assembly_accessions

    @property
    def chromosomes(self):
        """Gets the chromosomes of this V1alpha1AssemblyDatasetRequest.  # noqa: E501

        The default setting is all chromosome. Specify individual chromosome by string (1,2,MT or chr1,chr2.chrMT). Unplaced sequences are treated like their own chromosome ('Un'). The filter only applies to fasta sequence.  # noqa: E501

        :return: The chromosomes of this V1alpha1AssemblyDatasetRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._chromosomes

    @chromosomes.setter
    def chromosomes(self, chromosomes):
        """Sets the chromosomes of this V1alpha1AssemblyDatasetRequest.

        The default setting is all chromosome. Specify individual chromosome by string (1,2,MT or chr1,chr2.chrMT). Unplaced sequences are treated like their own chromosome ('Un'). The filter only applies to fasta sequence.  # noqa: E501

        :param chromosomes: The chromosomes of this V1alpha1AssemblyDatasetRequest.  # noqa: E501
        :type: list[str]
        """

        self._chromosomes = chromosomes

    @property
    def include_annotation(self):
        """Gets the include_annotation of this V1alpha1AssemblyDatasetRequest.  # noqa: E501


        :return: The include_annotation of this V1alpha1AssemblyDatasetRequest.  # noqa: E501
        :rtype: bool
        """
        return self._include_annotation

    @include_annotation.setter
    def include_annotation(self, include_annotation):
        """Sets the include_annotation of this V1alpha1AssemblyDatasetRequest.


        :param include_annotation: The include_annotation of this V1alpha1AssemblyDatasetRequest.  # noqa: E501
        :type: bool
        """

        self._include_annotation = include_annotation

    @property
    def include_annotation_type(self):
        """Gets the include_annotation_type of this V1alpha1AssemblyDatasetRequest.  # noqa: E501


        :return: The include_annotation_type of this V1alpha1AssemblyDatasetRequest.  # noqa: E501
        :rtype: list[AnnotationForAssemblyType]
        """
        return self._include_annotation_type

    @include_annotation_type.setter
    def include_annotation_type(self, include_annotation_type):
        """Sets the include_annotation_type of this V1alpha1AssemblyDatasetRequest.


        :param include_annotation_type: The include_annotation_type of this V1alpha1AssemblyDatasetRequest.  # noqa: E501
        :type: list[AnnotationForAssemblyType]
        """

        self._include_annotation_type = include_annotation_type

    @property
    def include_sequence(self):
        """Gets the include_sequence of this V1alpha1AssemblyDatasetRequest.  # noqa: E501


        :return: The include_sequence of this V1alpha1AssemblyDatasetRequest.  # noqa: E501
        :rtype: bool
        """
        return self._include_sequence

    @include_sequence.setter
    def include_sequence(self, include_sequence):
        """Sets the include_sequence of this V1alpha1AssemblyDatasetRequest.


        :param include_sequence: The include_sequence of this V1alpha1AssemblyDatasetRequest.  # noqa: E501
        :type: bool
        """

        self._include_sequence = include_sequence

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1alpha1AssemblyDatasetRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1alpha1AssemblyDatasetRequest):
            return True

        return self.to_dict() != other.to_dict()
