# coding: utf-8

"""
    CloudCheckr API

    CloudCheckr API  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudcheckr.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class UserRequestModel(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'email': 'str',
        'saml_provider': 'UserSamlProviderRequestModel',
        'allowed_auth_types': 'list[str]',
        'organization_note': 'str',
        'personal_note': 'str',
        'roles': 'list[BasicRequestListModification]'
    }

    attribute_map = {
        'email': 'email',
        'saml_provider': 'samlProvider',
        'allowed_auth_types': 'allowedAuthTypes',
        'organization_note': 'organizationNote',
        'personal_note': 'personalNote',
        'roles': 'roles'
    }

    def __init__(self, email=None, saml_provider=None, allowed_auth_types=None, organization_note=None, personal_note=None, roles=None):  # noqa: E501
        """UserRequestModel - a model defined in Swagger"""  # noqa: E501

        self._email = None
        self._saml_provider = None
        self._allowed_auth_types = None
        self._organization_note = None
        self._personal_note = None
        self._roles = None
        self.discriminator = None

        self.email = email
        if saml_provider is not None:
            self.saml_provider = saml_provider
        self.allowed_auth_types = allowed_auth_types
        if organization_note is not None:
            self.organization_note = organization_note
        if personal_note is not None:
            self.personal_note = personal_note
        if roles is not None:
            self.roles = roles

    @property
    def email(self):
        """Gets the email of this UserRequestModel.  # noqa: E501

        The user's email address.  # noqa: E501

        :return: The email of this UserRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this UserRequestModel.

        The user's email address.  # noqa: E501

        :param email: The email of this UserRequestModel.  # noqa: E501
        :type: str
        """
        if email is None:
            raise ValueError("Invalid value for `email`, must not be `None`")  # noqa: E501

        self._email = email

    @property
    def saml_provider(self):
        """Gets the saml_provider of this UserRequestModel.  # noqa: E501

        The user's SAML provider. This property supports: resetting.  # noqa: E501

        :return: The saml_provider of this UserRequestModel.  # noqa: E501
        :rtype: UserSamlProviderRequestModel
        """
        return self._saml_provider

    @saml_provider.setter
    def saml_provider(self, saml_provider):
        """Sets the saml_provider of this UserRequestModel.

        The user's SAML provider. This property supports: resetting.  # noqa: E501

        :param saml_provider: The saml_provider of this UserRequestModel.  # noqa: E501
        :type: UserSamlProviderRequestModel
        """

        self._saml_provider = saml_provider

    @property
    def allowed_auth_types(self):
        """Gets the allowed_auth_types of this UserRequestModel.  # noqa: E501

        The user's allowed authorization types.  # noqa: E501

        :return: The allowed_auth_types of this UserRequestModel.  # noqa: E501
        :rtype: list[str]
        """
        return self._allowed_auth_types

    @allowed_auth_types.setter
    def allowed_auth_types(self, allowed_auth_types):
        """Sets the allowed_auth_types of this UserRequestModel.

        The user's allowed authorization types.  # noqa: E501

        :param allowed_auth_types: The allowed_auth_types of this UserRequestModel.  # noqa: E501
        :type: list[str]
        """
        if allowed_auth_types is None:
            raise ValueError("Invalid value for `allowed_auth_types`, must not be `None`")  # noqa: E501
        allowed_values = ["UsernamePassword", "Saml", "Ldap", "AzureAD"]  # noqa: E501
        if not set(allowed_auth_types).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `allowed_auth_types` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(allowed_auth_types) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._allowed_auth_types = allowed_auth_types

    @property
    def organization_note(self):
        """Gets the organization_note of this UserRequestModel.  # noqa: E501

        The user's organizational, shared note.  # noqa: E501

        :return: The organization_note of this UserRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._organization_note

    @organization_note.setter
    def organization_note(self, organization_note):
        """Sets the organization_note of this UserRequestModel.

        The user's organizational, shared note.  # noqa: E501

        :param organization_note: The organization_note of this UserRequestModel.  # noqa: E501
        :type: str
        """

        self._organization_note = organization_note

    @property
    def personal_note(self):
        """Gets the personal_note of this UserRequestModel.  # noqa: E501

        The user's personal note.  # noqa: E501

        :return: The personal_note of this UserRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._personal_note

    @personal_note.setter
    def personal_note(self, personal_note):
        """Sets the personal_note of this UserRequestModel.

        The user's personal note.  # noqa: E501

        :param personal_note: The personal_note of this UserRequestModel.  # noqa: E501
        :type: str
        """

        self._personal_note = personal_note

    @property
    def roles(self):
        """Gets the roles of this UserRequestModel.  # noqa: E501

        List of role ids to assign to the user. This property supports: resetting.  # noqa: E501

        :return: The roles of this UserRequestModel.  # noqa: E501
        :rtype: list[BasicRequestListModification]
        """
        return self._roles

    @roles.setter
    def roles(self, roles):
        """Sets the roles of this UserRequestModel.

        List of role ids to assign to the user. This property supports: resetting.  # noqa: E501

        :param roles: The roles of this UserRequestModel.  # noqa: E501
        :type: list[BasicRequestListModification]
        """

        self._roles = roles

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(UserRequestModel, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UserRequestModel):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
