# coding: utf-8

"""
    CloudCheckr API

    CloudCheckr API  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudcheckr.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from cloudcheckr_cmx.api_client import ApiClient


class RolesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_role(self, customer_id, **kwargs):  # noqa: E501
        """Create a new role.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_role(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param CreateRequestRoleRequestModel request: 
        :return: RoleResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_role_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_role_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def create_role_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Create a new role.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_role_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param CreateRequestRoleRequestModel request: 
        :return: RoleResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `create_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/policy/v1/customers/{customerId}/roles', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleResponseModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_role(self, customer_id, role_id, **kwargs):  # noqa: E501
        """Delete a role.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_role(customer_id, role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str role_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_role_with_http_info(customer_id, role_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_role_with_http_info(customer_id, role_id, **kwargs)  # noqa: E501
            return data

    def delete_role_with_http_info(self, customer_id, role_id, **kwargs):  # noqa: E501
        """Delete a role.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_role_with_http_info(customer_id, role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str role_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'role_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `delete_role`")  # noqa: E501
        # verify the required parameter 'role_id' is set
        if ('role_id' not in params or
                params['role_id'] is None):
            raise ValueError("Missing the required parameter `role_id` when calling `delete_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501
        if 'role_id' in params:
            path_params['roleId'] = params['role_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/policy/v1/customers/{customerId}/roles/{roleId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all(self, customer_id, **kwargs):  # noqa: E501
        """Get all roles.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param list[str] role_ids: 
        :param str search: finds all resources that match the specified value
        :param str owned_by: finds all resources owned by the specified entity.
        :param str action_type: determines which action is taken on a resource.
        :param str order_by: orders a given property
        :param int page_size: number of items to include in the response
        :param str pagination_key: key used to fetch the next page of items
        :return: PaginationResponseRoleResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_all_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def get_all_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Get all roles.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param list[str] role_ids: 
        :param str search: finds all resources that match the specified value
        :param str owned_by: finds all resources owned by the specified entity.
        :param str action_type: determines which action is taken on a resource.
        :param str order_by: orders a given property
        :param int page_size: number of items to include in the response
        :param str pagination_key: key used to fetch the next page of items
        :return: PaginationResponseRoleResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'role_ids', 'search', 'owned_by', 'action_type', 'order_by', 'page_size', 'pagination_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `get_all`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []
        if 'role_ids' in params:
            query_params.append(('roleIds', params['role_ids']))  # noqa: E501
            collection_formats['roleIds'] = 'multi'  # noqa: E501
        if 'search' in params:
            query_params.append(('search', params['search']))  # noqa: E501
        if 'owned_by' in params:
            query_params.append(('ownedBy', params['owned_by']))  # noqa: E501
        if 'action_type' in params:
            query_params.append(('actionType', params['action_type']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('$orderBy', params['order_by']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('$pageSize', params['page_size']))  # noqa: E501
        if 'pagination_key' in params:
            query_params.append(('$paginationKey', params['pagination_key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/policy/v1/customers/{customerId}/roles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaginationResponseRoleResponseModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_role(self, customer_id, role_id, **kwargs):  # noqa: E501
        """Get an individual role.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_role(customer_id, role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str role_id:  (required)
        :return: RoleResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_role_with_http_info(customer_id, role_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_role_with_http_info(customer_id, role_id, **kwargs)  # noqa: E501
            return data

    def get_role_with_http_info(self, customer_id, role_id, **kwargs):  # noqa: E501
        """Get an individual role.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_role_with_http_info(customer_id, role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str role_id:  (required)
        :return: RoleResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'role_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `get_role`")  # noqa: E501
        # verify the required parameter 'role_id' is set
        if ('role_id' not in params or
                params['role_id'] is None):
            raise ValueError("Missing the required parameter `role_id` when calling `get_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501
        if 'role_id' in params:
            path_params['roleId'] = params['role_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/policy/v1/customers/{customerId}/roles/{roleId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleResponseModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_clients_with_role_id(self, customer_id, role_id, **kwargs):  # noqa: E501
        """Get all clients belonging to a role.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_clients_with_role_id(customer_id, role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str role_id:  (required)
        :param int page_size: number of items to include in the response
        :param str pagination_key: key used to fetch the next page of items
        :param str order_by: orders a given property
        :return: PaginationWithCountResponseMinimalClientResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_clients_with_role_id_with_http_info(customer_id, role_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_clients_with_role_id_with_http_info(customer_id, role_id, **kwargs)  # noqa: E501
            return data

    def list_clients_with_role_id_with_http_info(self, customer_id, role_id, **kwargs):  # noqa: E501
        """Get all clients belonging to a role.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_clients_with_role_id_with_http_info(customer_id, role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str role_id:  (required)
        :param int page_size: number of items to include in the response
        :param str pagination_key: key used to fetch the next page of items
        :param str order_by: orders a given property
        :return: PaginationWithCountResponseMinimalClientResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'role_id', 'page_size', 'pagination_key', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_clients_with_role_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `list_clients_with_role_id`")  # noqa: E501
        # verify the required parameter 'role_id' is set
        if ('role_id' not in params or
                params['role_id'] is None):
            raise ValueError("Missing the required parameter `role_id` when calling `list_clients_with_role_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501
        if 'role_id' in params:
            path_params['roleId'] = params['role_id']  # noqa: E501

        query_params = []
        if 'page_size' in params:
            query_params.append(('$pageSize', params['page_size']))  # noqa: E501
        if 'pagination_key' in params:
            query_params.append(('$paginationKey', params['pagination_key']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('$orderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/auth/v1/customers/{customerId}/roles/{roleId}/clients', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaginationWithCountResponseMinimalClientResponseModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_users_with_role_id(self, customer_id, role_id, **kwargs):  # noqa: E501
        """Get all users belonging to a role.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_users_with_role_id(customer_id, role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str role_id:  (required)
        :param int page_size: number of items to include in the response
        :param str pagination_key: key used to fetch the next page of items
        :param str order_by: orders a given property
        :return: PaginationWithCountResponseMinimalUserResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_users_with_role_id_with_http_info(customer_id, role_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_users_with_role_id_with_http_info(customer_id, role_id, **kwargs)  # noqa: E501
            return data

    def list_users_with_role_id_with_http_info(self, customer_id, role_id, **kwargs):  # noqa: E501
        """Get all users belonging to a role.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_users_with_role_id_with_http_info(customer_id, role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str role_id:  (required)
        :param int page_size: number of items to include in the response
        :param str pagination_key: key used to fetch the next page of items
        :param str order_by: orders a given property
        :return: PaginationWithCountResponseMinimalUserResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'role_id', 'page_size', 'pagination_key', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_users_with_role_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `list_users_with_role_id`")  # noqa: E501
        # verify the required parameter 'role_id' is set
        if ('role_id' not in params or
                params['role_id'] is None):
            raise ValueError("Missing the required parameter `role_id` when calling `list_users_with_role_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501
        if 'role_id' in params:
            path_params['roleId'] = params['role_id']  # noqa: E501

        query_params = []
        if 'page_size' in params:
            query_params.append(('$pageSize', params['page_size']))  # noqa: E501
        if 'pagination_key' in params:
            query_params.append(('$paginationKey', params['pagination_key']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('$orderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/auth/v1/customers/{customerId}/roles/{roleId}/users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaginationWithCountResponseMinimalUserResponseModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def modify_client_roles(self, customer_id, role_id, **kwargs):  # noqa: E501
        """Add or remove a role from multiple clients.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_client_roles(customer_id, role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str role_id:  (required)
        :param ListModificationRequestModel request: 
        :return: ListModificationResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.modify_client_roles_with_http_info(customer_id, role_id, **kwargs)  # noqa: E501
        else:
            (data) = self.modify_client_roles_with_http_info(customer_id, role_id, **kwargs)  # noqa: E501
            return data

    def modify_client_roles_with_http_info(self, customer_id, role_id, **kwargs):  # noqa: E501
        """Add or remove a role from multiple clients.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_client_roles_with_http_info(customer_id, role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str role_id:  (required)
        :param ListModificationRequestModel request: 
        :return: ListModificationResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'role_id', 'request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_client_roles" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `modify_client_roles`")  # noqa: E501
        # verify the required parameter 'role_id' is set
        if ('role_id' not in params or
                params['role_id'] is None):
            raise ValueError("Missing the required parameter `role_id` when calling `modify_client_roles`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501
        if 'role_id' in params:
            path_params['roleId'] = params['role_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/auth/v1/customers/{customerId}/roles/{roleId}/clients', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListModificationResponseModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def modify_user_roles(self, customer_id, role_id, **kwargs):  # noqa: E501
        """Add or remove a role from multiple users.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_user_roles(customer_id, role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str role_id:  (required)
        :param ListModificationRequestModel request: 
        :return: ListModificationResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.modify_user_roles_with_http_info(customer_id, role_id, **kwargs)  # noqa: E501
        else:
            (data) = self.modify_user_roles_with_http_info(customer_id, role_id, **kwargs)  # noqa: E501
            return data

    def modify_user_roles_with_http_info(self, customer_id, role_id, **kwargs):  # noqa: E501
        """Add or remove a role from multiple users.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_user_roles_with_http_info(customer_id, role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str role_id:  (required)
        :param ListModificationRequestModel request: 
        :return: ListModificationResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'role_id', 'request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_user_roles" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `modify_user_roles`")  # noqa: E501
        # verify the required parameter 'role_id' is set
        if ('role_id' not in params or
                params['role_id'] is None):
            raise ValueError("Missing the required parameter `role_id` when calling `modify_user_roles`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501
        if 'role_id' in params:
            path_params['roleId'] = params['role_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/auth/v1/customers/{customerId}/roles/{roleId}/users', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListModificationResponseModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_role(self, customer_id, role_id, **kwargs):  # noqa: E501
        """Update a role.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_role(customer_id, role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str role_id:  (required)
        :param UpdateRequestRoleRequestModel request: 
        :return: RoleResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_role_with_http_info(customer_id, role_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_role_with_http_info(customer_id, role_id, **kwargs)  # noqa: E501
            return data

    def update_role_with_http_info(self, customer_id, role_id, **kwargs):  # noqa: E501
        """Update a role.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_role_with_http_info(customer_id, role_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str role_id:  (required)
        :param UpdateRequestRoleRequestModel request: 
        :return: RoleResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'role_id', 'request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `update_role`")  # noqa: E501
        # verify the required parameter 'role_id' is set
        if ('role_id' not in params or
                params['role_id'] is None):
            raise ValueError("Missing the required parameter `role_id` when calling `update_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501
        if 'role_id' in params:
            path_params['roleId'] = params['role_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/policy/v1/customers/{customerId}/roles/{roleId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleResponseModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
