# coding: utf-8

"""
    CloudCheckr API

    CloudCheckr API  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudcheckr.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from cloudcheckr_cmx.api_client import ApiClient


class AccountsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_account(self, customer_id, account_id, **kwargs):  # noqa: E501
        """Get an individual account, account group, or MAV.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account(customer_id, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: (required)
        :param str account_id: (required)
        :return: AccountGroupResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_account_with_http_info(customer_id, account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_account_with_http_info(customer_id, account_id, **kwargs)  # noqa: E501
            return data

    def get_account_with_http_info(self, customer_id, account_id, **kwargs):  # noqa: E501
        """Get an individual account, account group, or MAV.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_with_http_info(customer_id, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: (required)
        :param str account_id: (required)
        :return: AccountGroupResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'account_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `get_account`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/customer/v1/customers/{customerId}/accounts/{accountId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountGroupResponseModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_accounts(self, customer_id, **kwargs):  # noqa: E501
        """Get all accounts, account groups, and MAVs.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_accounts(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param list[str] account_types: 
        :param list[str] account_ids: Specific account IDs to return.
        :param list[str] account_attributes: Account attributes to be searched. This will attempt to match name or name:value combinations.               Matching is not case-sensitive.
        :param int page_size: number of items to include in the response
        :param str pagination_key: key used to fetch the next page of items
        :param str search: finds all resources that match the specified value
        :return: PaginationWithCountResponseAccountGroupSearchResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_accounts_with_http_info(customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_accounts_with_http_info(customer_id, **kwargs)  # noqa: E501
            return data

    def get_accounts_with_http_info(self, customer_id, **kwargs):  # noqa: E501
        """Get all accounts, account groups, and MAVs.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_accounts_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param list[str] account_types: 
        :param list[str] account_ids: Specific account IDs to return.
        :param list[str] account_attributes: Account attributes to be searched. This will attempt to match name or name:value combinations.               Matching is not case-sensitive.
        :param int page_size: number of items to include in the response
        :param str pagination_key: key used to fetch the next page of items
        :param str search: finds all resources that match the specified value
        :return: PaginationWithCountResponseAccountGroupSearchResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'account_types', 'account_ids', 'account_attributes', 'page_size', 'pagination_key', 'search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `get_accounts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501

        query_params = []
        if 'account_types' in params:
            query_params.append(('accountTypes', params['account_types']))  # noqa: E501
            collection_formats['accountTypes'] = 'multi'  # noqa: E501
        if 'account_ids' in params:
            query_params.append(('accountIds', params['account_ids']))  # noqa: E501
            collection_formats['accountIds'] = 'multi'  # noqa: E501
        if 'account_attributes' in params:
            query_params.append(('accountAttributes', params['account_attributes']))  # noqa: E501
            collection_formats['accountAttributes'] = 'multi'  # noqa: E501
        if 'page_size' in params:
            query_params.append(('$pageSize', params['page_size']))  # noqa: E501
        if 'pagination_key' in params:
            query_params.append(('$paginationKey', params['pagination_key']))  # noqa: E501
        if 'search' in params:
            query_params.append(('search', params['search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/customer/v1/customers/{customerId}/accounts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaginationWithCountResponseAccountGroupSearchResponseModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ancestors(self, customer_id, account_id, **kwargs):  # noqa: E501
        """Get all ancestors of an account.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ancestors(customer_id, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str account_id:  (required)
        :return: AncestorsResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ancestors_with_http_info(customer_id, account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ancestors_with_http_info(customer_id, account_id, **kwargs)  # noqa: E501
            return data

    def get_ancestors_with_http_info(self, customer_id, account_id, **kwargs):  # noqa: E501
        """Get all ancestors of an account.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ancestors_with_http_info(customer_id, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id:  (required)
        :param str account_id:  (required)
        :return: AncestorsResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'account_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ancestors" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if ('customer_id' not in params or
                params['customer_id'] is None):
            raise ValueError("Missing the required parameter `customer_id` when calling `get_ancestors`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_ancestors`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['customerId'] = params['customer_id']  # noqa: E501
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth']  # noqa: E501

        return self.api_client.call_api(
            '/customer/v1/customers/{customerId}/accounts/{accountId}/ancestors', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AncestorsResponseModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
