"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CdkCloudWatchAlarmChatBot = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class CdkCloudWatchAlarmChatBot extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const topic = new aws_cdk_lib_1.aws_sns.Topic(this, 'Topic', {
            displayName: props.topicName,
        });
        this.topic = topic;
        new aws_cdk_lib_1.aws_chatbot.SlackChannelConfiguration(this, 'MySlackChannel', {
            slackChannelConfigurationName: 'cw-alarm-slack',
            slackWorkspaceId: props.slackWorkSpaceId,
            slackChannelId: props.slackChannelId,
            notificationTopics: [topic],
        });
    }
}
exports.CdkCloudWatchAlarmChatBot = CdkCloudWatchAlarmChatBot;
_a = JSII_RTTI_SYMBOL_1;
CdkCloudWatchAlarmChatBot[_a] = { fqn: "cdk-cloudwatch-alarm-chatbot.CdkCloudWatchAlarmChatBot", version: "1.0.32" };
//# sourceMappingURL=data:application/json;base64,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