"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosCluster = exports.RosAutoScaleConfig = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosAutoScaleConfigProps`
 *
 * @param properties - the TypeScript properties of a `RosAutoScaleConfigProps`
 *
 * @returns the result of the validation.
 */
function RosAutoScaleConfigPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.extraNodesGrowRatio && (typeof properties.extraNodesGrowRatio) !== 'object') {
        errors.collect(ros.propertyValidator('extraNodesGrowRatio', ros.validateRange)({
            data: properties.extraNodesGrowRatio,
            min: 0,
            max: 100,
        }));
    }
    errors.collect(ros.propertyValidator('extraNodesGrowRatio', ros.validateNumber)(properties.extraNodesGrowRatio));
    errors.collect(ros.propertyValidator('enableAutoGrow', ros.validateBoolean)(properties.enableAutoGrow));
    errors.collect(ros.propertyValidator('clusterId', ros.requiredValidator)(properties.clusterId));
    errors.collect(ros.propertyValidator('clusterId', ros.validateString)(properties.clusterId));
    if (properties.shrinkIdleTimes && (typeof properties.shrinkIdleTimes) !== 'object') {
        errors.collect(ros.propertyValidator('shrinkIdleTimes', ros.validateRange)({
            data: properties.shrinkIdleTimes,
            min: 2,
            max: 5,
        }));
    }
    errors.collect(ros.propertyValidator('shrinkIdleTimes', ros.validateNumber)(properties.shrinkIdleTimes));
    if (properties.maxNodesInCluster && (typeof properties.maxNodesInCluster) !== 'object') {
        errors.collect(ros.propertyValidator('maxNodesInCluster', ros.validateRange)({
            data: properties.maxNodesInCluster,
            min: 1,
            max: 500,
        }));
    }
    errors.collect(ros.propertyValidator('maxNodesInCluster', ros.validateNumber)(properties.maxNodesInCluster));
    errors.collect(ros.propertyValidator('enableAutoShrink', ros.validateBoolean)(properties.enableAutoShrink));
    if (properties.growRatio && (typeof properties.growRatio) !== 'object') {
        errors.collect(ros.propertyValidator('growRatio', ros.validateRange)({
            data: properties.growRatio,
            min: 1,
            max: 100,
        }));
    }
    errors.collect(ros.propertyValidator('growRatio', ros.validateNumber)(properties.growRatio));
    if (properties.growIntervalInMinutes && (typeof properties.growIntervalInMinutes) !== 'object') {
        errors.collect(ros.propertyValidator('growIntervalInMinutes', ros.validateRange)({
            data: properties.growIntervalInMinutes,
            min: 2,
            max: 10,
        }));
    }
    errors.collect(ros.propertyValidator('growIntervalInMinutes', ros.validateNumber)(properties.growIntervalInMinutes));
    if (properties.growTimeoutInMinutes && (typeof properties.growTimeoutInMinutes) !== 'object') {
        errors.collect(ros.propertyValidator('growTimeoutInMinutes', ros.validateRange)({
            data: properties.growTimeoutInMinutes,
            min: 10,
            max: 60,
        }));
    }
    errors.collect(ros.propertyValidator('growTimeoutInMinutes', ros.validateNumber)(properties.growTimeoutInMinutes));
    errors.collect(ros.propertyValidator('imageId', ros.validateString)(properties.imageId));
    if (properties.shrinkIntervalInMinutes && (typeof properties.shrinkIntervalInMinutes) !== 'object') {
        errors.collect(ros.propertyValidator('shrinkIntervalInMinutes', ros.validateRange)({
            data: properties.shrinkIntervalInMinutes,
            min: 2,
            max: 10,
        }));
    }
    errors.collect(ros.propertyValidator('shrinkIntervalInMinutes', ros.validateNumber)(properties.shrinkIntervalInMinutes));
    errors.collect(ros.propertyValidator('spotPriceLimit', ros.validateNumber)(properties.spotPriceLimit));
    if (properties.queues && (Array.isArray(properties.queues) || (typeof properties.queues) === 'string')) {
        errors.collect(ros.propertyValidator('queues', ros.validateLength)({
            data: properties.queues.length,
            min: undefined,
            max: 8,
        }));
    }
    errors.collect(ros.propertyValidator('queues', ros.listValidator(RosAutoScaleConfig_QueuesPropertyValidator))(properties.queues));
    errors.collect(ros.propertyValidator('excludeNodes', ros.validateString)(properties.excludeNodes));
    if (properties.spotStrategy && (typeof properties.spotStrategy) !== 'object') {
        errors.collect(ros.propertyValidator('spotStrategy', ros.validateAllowedValues)({
            data: properties.spotStrategy,
            allowedValues: ["NoSpot", "SpotWithPriceLimit", "SpotAsPriceGo"],
        }));
    }
    errors.collect(ros.propertyValidator('spotStrategy', ros.validateString)(properties.spotStrategy));
    return errors.wrap('supplied properties not correct for "RosAutoScaleConfigProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::EHPC::AutoScaleConfig` resource
 *
 * @param properties - the TypeScript properties of a `RosAutoScaleConfigProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::EHPC::AutoScaleConfig` resource.
 */
// @ts-ignore TS6133
function rosAutoScaleConfigPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosAutoScaleConfigPropsValidator(properties).assertSuccess();
    }
    return {
        ClusterId: ros.stringToRosTemplate(properties.clusterId),
        EnableAutoGrow: ros.booleanToRosTemplate(properties.enableAutoGrow),
        EnableAutoShrink: ros.booleanToRosTemplate(properties.enableAutoShrink),
        ExcludeNodes: ros.stringToRosTemplate(properties.excludeNodes),
        ExtraNodesGrowRatio: ros.numberToRosTemplate(properties.extraNodesGrowRatio),
        GrowIntervalInMinutes: ros.numberToRosTemplate(properties.growIntervalInMinutes),
        GrowRatio: ros.numberToRosTemplate(properties.growRatio),
        GrowTimeoutInMinutes: ros.numberToRosTemplate(properties.growTimeoutInMinutes),
        ImageId: ros.stringToRosTemplate(properties.imageId),
        MaxNodesInCluster: ros.numberToRosTemplate(properties.maxNodesInCluster),
        Queues: ros.listMapper(rosAutoScaleConfigQueuesPropertyToRosTemplate)(properties.queues),
        ShrinkIdleTimes: ros.numberToRosTemplate(properties.shrinkIdleTimes),
        ShrinkIntervalInMinutes: ros.numberToRosTemplate(properties.shrinkIntervalInMinutes),
        SpotPriceLimit: ros.numberToRosTemplate(properties.spotPriceLimit),
        SpotStrategy: ros.stringToRosTemplate(properties.spotStrategy),
    };
}
/**
 * A ROS template type:  `ALIYUN::EHPC::AutoScaleConfig`
 */
class RosAutoScaleConfig extends ros.RosResource {
    /**
     * Create a new `ALIYUN::EHPC::AutoScaleConfig`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosAutoScaleConfig.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrClusterId = this.getAtt('ClusterId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.clusterId = props.clusterId;
        this.enableAutoGrow = props.enableAutoGrow;
        this.enableAutoShrink = props.enableAutoShrink;
        this.excludeNodes = props.excludeNodes;
        this.extraNodesGrowRatio = props.extraNodesGrowRatio;
        this.growIntervalInMinutes = props.growIntervalInMinutes;
        this.growRatio = props.growRatio;
        this.growTimeoutInMinutes = props.growTimeoutInMinutes;
        this.imageId = props.imageId;
        this.maxNodesInCluster = props.maxNodesInCluster;
        this.queues = props.queues;
        this.shrinkIdleTimes = props.shrinkIdleTimes;
        this.shrinkIntervalInMinutes = props.shrinkIntervalInMinutes;
        this.spotPriceLimit = props.spotPriceLimit;
        this.spotStrategy = props.spotStrategy;
    }
    get rosProperties() {
        return {
            clusterId: this.clusterId,
            enableAutoGrow: this.enableAutoGrow,
            enableAutoShrink: this.enableAutoShrink,
            excludeNodes: this.excludeNodes,
            extraNodesGrowRatio: this.extraNodesGrowRatio,
            growIntervalInMinutes: this.growIntervalInMinutes,
            growRatio: this.growRatio,
            growTimeoutInMinutes: this.growTimeoutInMinutes,
            imageId: this.imageId,
            maxNodesInCluster: this.maxNodesInCluster,
            queues: this.queues,
            shrinkIdleTimes: this.shrinkIdleTimes,
            shrinkIntervalInMinutes: this.shrinkIntervalInMinutes,
            spotPriceLimit: this.spotPriceLimit,
            spotStrategy: this.spotStrategy,
        };
    }
    renderProperties(props) {
        return rosAutoScaleConfigPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosAutoScaleConfig = RosAutoScaleConfig;
/**
 * The resource type name for this resource class.
 */
RosAutoScaleConfig.ROS_RESOURCE_TYPE_NAME = "ALIYUN::EHPC::AutoScaleConfig";
/**
 * Determine whether the given properties match those of a `DataDisksProperty`
 *
 * @param properties - the TypeScript properties of a `DataDisksProperty`
 *
 * @returns the result of the validation.
 */
function RosAutoScaleConfig_DataDisksPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('dataDiskKmsKeyId', ros.validateString)(properties.dataDiskKmsKeyId));
    errors.collect(ros.propertyValidator('dataDiskPerformanceLevel', ros.validateString)(properties.dataDiskPerformanceLevel));
    errors.collect(ros.propertyValidator('dataDiskEncrypted', ros.validateBoolean)(properties.dataDiskEncrypted));
    errors.collect(ros.propertyValidator('dataDiskDeleteWithInstance', ros.validateBoolean)(properties.dataDiskDeleteWithInstance));
    if (properties.dataDiskSize && (typeof properties.dataDiskSize) !== 'object') {
        errors.collect(ros.propertyValidator('dataDiskSize', ros.validateRange)({
            data: properties.dataDiskSize,
            min: 40,
            max: 500,
        }));
    }
    errors.collect(ros.propertyValidator('dataDiskSize', ros.validateNumber)(properties.dataDiskSize));
    errors.collect(ros.propertyValidator('dataDiskCategory', ros.validateString)(properties.dataDiskCategory));
    return errors.wrap('supplied properties not correct for "DataDisksProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::EHPC::AutoScaleConfig.DataDisks` resource
 *
 * @param properties - the TypeScript properties of a `DataDisksProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::EHPC::AutoScaleConfig.DataDisks` resource.
 */
// @ts-ignore TS6133
function rosAutoScaleConfigDataDisksPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosAutoScaleConfig_DataDisksPropertyValidator(properties).assertSuccess();
    return {
        DataDiskKMSKeyId: ros.stringToRosTemplate(properties.dataDiskKmsKeyId),
        DataDiskPerformanceLevel: ros.stringToRosTemplate(properties.dataDiskPerformanceLevel),
        DataDiskEncrypted: ros.booleanToRosTemplate(properties.dataDiskEncrypted),
        DataDiskDeleteWithInstance: ros.booleanToRosTemplate(properties.dataDiskDeleteWithInstance),
        DataDiskSize: ros.numberToRosTemplate(properties.dataDiskSize),
        DataDiskCategory: ros.stringToRosTemplate(properties.dataDiskCategory),
    };
}
/**
 * Determine whether the given properties match those of a `InstanceTypesProperty`
 *
 * @param properties - the TypeScript properties of a `InstanceTypesProperty`
 *
 * @returns the result of the validation.
 */
function RosAutoScaleConfig_InstanceTypesPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('zoneId', ros.requiredValidator)(properties.zoneId));
    errors.collect(ros.propertyValidator('zoneId', ros.validateString)(properties.zoneId));
    errors.collect(ros.propertyValidator('vSwitchId', ros.requiredValidator)(properties.vSwitchId));
    errors.collect(ros.propertyValidator('vSwitchId', ros.validateString)(properties.vSwitchId));
    errors.collect(ros.propertyValidator('spotPriceLimit', ros.validateNumber)(properties.spotPriceLimit));
    errors.collect(ros.propertyValidator('instanceType', ros.requiredValidator)(properties.instanceType));
    errors.collect(ros.propertyValidator('instanceType', ros.validateString)(properties.instanceType));
    if (properties.spotStrategy && (typeof properties.spotStrategy) !== 'object') {
        errors.collect(ros.propertyValidator('spotStrategy', ros.validateAllowedValues)({
            data: properties.spotStrategy,
            allowedValues: ["NoSpot", "SpotWithPriceLimit", "SpotAsPriceGo"],
        }));
    }
    errors.collect(ros.propertyValidator('spotStrategy', ros.validateString)(properties.spotStrategy));
    return errors.wrap('supplied properties not correct for "InstanceTypesProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::EHPC::AutoScaleConfig.InstanceTypes` resource
 *
 * @param properties - the TypeScript properties of a `InstanceTypesProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::EHPC::AutoScaleConfig.InstanceTypes` resource.
 */
// @ts-ignore TS6133
function rosAutoScaleConfigInstanceTypesPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosAutoScaleConfig_InstanceTypesPropertyValidator(properties).assertSuccess();
    return {
        ZoneId: ros.stringToRosTemplate(properties.zoneId),
        VSwitchId: ros.stringToRosTemplate(properties.vSwitchId),
        SpotPriceLimit: ros.numberToRosTemplate(properties.spotPriceLimit),
        InstanceType: ros.stringToRosTemplate(properties.instanceType),
        SpotStrategy: ros.stringToRosTemplate(properties.spotStrategy),
    };
}
/**
 * Determine whether the given properties match those of a `QueuesProperty`
 *
 * @param properties - the TypeScript properties of a `QueuesProperty`
 *
 * @returns the result of the validation.
 */
function RosAutoScaleConfig_QueuesPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('hostNameSuffix', ros.validateString)(properties.hostNameSuffix));
    if (properties.minNodesInQueue && (typeof properties.minNodesInQueue) !== 'object') {
        errors.collect(ros.propertyValidator('minNodesInQueue', ros.validateRange)({
            data: properties.minNodesInQueue,
            min: 0,
            max: 50,
        }));
    }
    errors.collect(ros.propertyValidator('minNodesInQueue', ros.validateNumber)(properties.minNodesInQueue));
    if (properties.maxNodesInQueue && (typeof properties.maxNodesInQueue) !== 'object') {
        errors.collect(ros.propertyValidator('maxNodesInQueue', ros.validateRange)({
            data: properties.maxNodesInQueue,
            min: 0,
            max: 500,
        }));
    }
    errors.collect(ros.propertyValidator('maxNodesInQueue', ros.validateNumber)(properties.maxNodesInQueue));
    errors.collect(ros.propertyValidator('enableAutoGrow', ros.validateBoolean)(properties.enableAutoGrow));
    if (properties.dataDisks && (Array.isArray(properties.dataDisks) || (typeof properties.dataDisks) === 'string')) {
        errors.collect(ros.propertyValidator('dataDisks', ros.validateLength)({
            data: properties.dataDisks.length,
            min: undefined,
            max: 16,
        }));
    }
    errors.collect(ros.propertyValidator('dataDisks', ros.listValidator(RosAutoScaleConfig_DataDisksPropertyValidator))(properties.dataDisks));
    if (properties.systemDiskSize && (typeof properties.systemDiskSize) !== 'object') {
        errors.collect(ros.propertyValidator('systemDiskSize', ros.validateRange)({
            data: properties.systemDiskSize,
            min: 40,
            max: 500,
        }));
    }
    errors.collect(ros.propertyValidator('systemDiskSize', ros.validateNumber)(properties.systemDiskSize));
    errors.collect(ros.propertyValidator('systemDiskLevel', ros.validateString)(properties.systemDiskLevel));
    errors.collect(ros.propertyValidator('queueImageId', ros.validateString)(properties.queueImageId));
    if (properties.minNodesPerCycle && (typeof properties.minNodesPerCycle) !== 'object') {
        errors.collect(ros.propertyValidator('minNodesPerCycle', ros.validateRange)({
            data: properties.minNodesPerCycle,
            min: 1,
            max: 99,
        }));
    }
    errors.collect(ros.propertyValidator('minNodesPerCycle', ros.validateNumber)(properties.minNodesPerCycle));
    if (properties.maxNodesPerCycle && (typeof properties.maxNodesPerCycle) !== 'object') {
        errors.collect(ros.propertyValidator('maxNodesPerCycle', ros.validateRange)({
            data: properties.maxNodesPerCycle,
            min: 0,
            max: 99,
        }));
    }
    errors.collect(ros.propertyValidator('maxNodesPerCycle', ros.validateNumber)(properties.maxNodesPerCycle));
    errors.collect(ros.propertyValidator('enableAutoShrink', ros.validateBoolean)(properties.enableAutoShrink));
    errors.collect(ros.propertyValidator('systemDiskCategory', ros.validateString)(properties.systemDiskCategory));
    errors.collect(ros.propertyValidator('hostNamePrefix', ros.validateString)(properties.hostNamePrefix));
    errors.collect(ros.propertyValidator('spotPriceLimit', ros.validateNumber)(properties.spotPriceLimit));
    if (properties.instanceTypes && (Array.isArray(properties.instanceTypes) || (typeof properties.instanceTypes) === 'string')) {
        errors.collect(ros.propertyValidator('instanceTypes', ros.validateLength)({
            data: properties.instanceTypes.length,
            min: undefined,
            max: 500,
        }));
    }
    errors.collect(ros.propertyValidator('instanceTypes', ros.listValidator(RosAutoScaleConfig_InstanceTypesPropertyValidator))(properties.instanceTypes));
    errors.collect(ros.propertyValidator('instanceType', ros.validateString)(properties.instanceType));
    errors.collect(ros.propertyValidator('queueName', ros.validateString)(properties.queueName));
    if (properties.spotStrategy && (typeof properties.spotStrategy) !== 'object') {
        errors.collect(ros.propertyValidator('spotStrategy', ros.validateAllowedValues)({
            data: properties.spotStrategy,
            allowedValues: ["NoSpot", "SpotWithPriceLimit", "SpotAsPriceGo"],
        }));
    }
    errors.collect(ros.propertyValidator('spotStrategy', ros.validateString)(properties.spotStrategy));
    return errors.wrap('supplied properties not correct for "QueuesProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::EHPC::AutoScaleConfig.Queues` resource
 *
 * @param properties - the TypeScript properties of a `QueuesProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::EHPC::AutoScaleConfig.Queues` resource.
 */
// @ts-ignore TS6133
function rosAutoScaleConfigQueuesPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosAutoScaleConfig_QueuesPropertyValidator(properties).assertSuccess();
    return {
        HostNameSuffix: ros.stringToRosTemplate(properties.hostNameSuffix),
        MinNodesInQueue: ros.numberToRosTemplate(properties.minNodesInQueue),
        MaxNodesInQueue: ros.numberToRosTemplate(properties.maxNodesInQueue),
        EnableAutoGrow: ros.booleanToRosTemplate(properties.enableAutoGrow),
        DataDisks: ros.listMapper(rosAutoScaleConfigDataDisksPropertyToRosTemplate)(properties.dataDisks),
        SystemDiskSize: ros.numberToRosTemplate(properties.systemDiskSize),
        SystemDiskLevel: ros.stringToRosTemplate(properties.systemDiskLevel),
        QueueImageId: ros.stringToRosTemplate(properties.queueImageId),
        MinNodesPerCycle: ros.numberToRosTemplate(properties.minNodesPerCycle),
        MaxNodesPerCycle: ros.numberToRosTemplate(properties.maxNodesPerCycle),
        EnableAutoShrink: ros.booleanToRosTemplate(properties.enableAutoShrink),
        SystemDiskCategory: ros.stringToRosTemplate(properties.systemDiskCategory),
        HostNamePrefix: ros.stringToRosTemplate(properties.hostNamePrefix),
        SpotPriceLimit: ros.numberToRosTemplate(properties.spotPriceLimit),
        InstanceTypes: ros.listMapper(rosAutoScaleConfigInstanceTypesPropertyToRosTemplate)(properties.instanceTypes),
        InstanceType: ros.stringToRosTemplate(properties.instanceType),
        QueueName: ros.stringToRosTemplate(properties.queueName),
        SpotStrategy: ros.stringToRosTemplate(properties.spotStrategy),
    };
}
/**
 * Determine whether the given properties match those of a `RosClusterProps`
 *
 * @param properties - the TypeScript properties of a `RosClusterProps`
 *
 * @returns the result of the validation.
 */
function RosClusterPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('volumeProtocol', ros.validateString)(properties.volumeProtocol));
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    errors.collect(ros.propertyValidator('computeEnableHt', ros.validateBoolean)(properties.computeEnableHt));
    errors.collect(ros.propertyValidator('withoutElasticIp', ros.validateBoolean)(properties.withoutElasticIp));
    errors.collect(ros.propertyValidator('systemDiskType', ros.validateString)(properties.systemDiskType));
    errors.collect(ros.propertyValidator('remoteVisEnable', ros.validateBoolean)(properties.remoteVisEnable));
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    errors.collect(ros.propertyValidator('volumeId', ros.validateString)(properties.volumeId));
    errors.collect(ros.propertyValidator('deployMode', ros.validateString)(properties.deployMode));
    if (properties.postInstallScript && (Array.isArray(properties.postInstallScript) || (typeof properties.postInstallScript) === 'string')) {
        errors.collect(ros.propertyValidator('postInstallScript', ros.validateLength)({
            data: properties.postInstallScript.length,
            min: undefined,
            max: 16,
        }));
    }
    errors.collect(ros.propertyValidator('postInstallScript', ros.listValidator(RosCluster_PostInstallScriptPropertyValidator))(properties.postInstallScript));
    errors.collect(ros.propertyValidator('imageId', ros.validateString)(properties.imageId));
    errors.collect(ros.propertyValidator('isComputeEss', ros.validateBoolean)(properties.isComputeEss));
    errors.collect(ros.propertyValidator('ecsOrderLoginInstanceType', ros.requiredValidator)(properties.ecsOrderLoginInstanceType));
    errors.collect(ros.propertyValidator('ecsOrderLoginInstanceType', ros.validateString)(properties.ecsOrderLoginInstanceType));
    errors.collect(ros.propertyValidator('jobQueue', ros.validateString)(properties.jobQueue));
    errors.collect(ros.propertyValidator('vSwitchId', ros.requiredValidator)(properties.vSwitchId));
    errors.collect(ros.propertyValidator('vSwitchId', ros.validateString)(properties.vSwitchId));
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    if (properties.computeSpotStrategy && (typeof properties.computeSpotStrategy) !== 'object') {
        errors.collect(ros.propertyValidator('computeSpotStrategy', ros.validateAllowedValues)({
            data: properties.computeSpotStrategy,
            allowedValues: ["NoSpot", "SpotWithPriceLimit", "SpotAsPriceGo"],
        }));
    }
    errors.collect(ros.propertyValidator('computeSpotStrategy', ros.validateString)(properties.computeSpotStrategy));
    errors.collect(ros.propertyValidator('ecsOrderManagerInstanceType', ros.requiredValidator)(properties.ecsOrderManagerInstanceType));
    errors.collect(ros.propertyValidator('ecsOrderManagerInstanceType', ros.validateString)(properties.ecsOrderManagerInstanceType));
    errors.collect(ros.propertyValidator('ehpcVersion', ros.validateString)(properties.ehpcVersion));
    errors.collect(ros.propertyValidator('volumeMountpoint', ros.validateString)(properties.volumeMountpoint));
    errors.collect(ros.propertyValidator('ecsOrderManagerCount', ros.validateNumber)(properties.ecsOrderManagerCount));
    errors.collect(ros.propertyValidator('ecsOrderComputeInstanceType', ros.requiredValidator)(properties.ecsOrderComputeInstanceType));
    errors.collect(ros.propertyValidator('ecsOrderComputeInstanceType', ros.validateString)(properties.ecsOrderComputeInstanceType));
    if (properties.application && (Array.isArray(properties.application) || (typeof properties.application) === 'string')) {
        errors.collect(ros.propertyValidator('application', ros.validateLength)({
            data: properties.application.length,
            min: undefined,
            max: 10,
        }));
    }
    errors.collect(ros.propertyValidator('application', ros.listValidator(RosCluster_ApplicationPropertyValidator))(properties.application));
    if (properties.periodUnit && (typeof properties.periodUnit) !== 'object') {
        errors.collect(ros.propertyValidator('periodUnit', ros.validateAllowedValues)({
            data: properties.periodUnit,
            allowedValues: ["Week", "Month", "Year"],
        }));
    }
    errors.collect(ros.propertyValidator('periodUnit', ros.validateString)(properties.periodUnit));
    if (properties.imageOwnerAlias && (typeof properties.imageOwnerAlias) !== 'object') {
        errors.collect(ros.propertyValidator('imageOwnerAlias', ros.validateAllowedValues)({
            data: properties.imageOwnerAlias,
            allowedValues: ["system", "self", "others", "marketplace"],
        }));
    }
    errors.collect(ros.propertyValidator('imageOwnerAlias', ros.validateString)(properties.imageOwnerAlias));
    errors.collect(ros.propertyValidator('ecsOrderComputeCount', ros.requiredValidator)(properties.ecsOrderComputeCount));
    if (properties.ecsOrderComputeCount && (typeof properties.ecsOrderComputeCount) !== 'object') {
        errors.collect(ros.propertyValidator('ecsOrderComputeCount', ros.validateRange)({
            data: properties.ecsOrderComputeCount,
            min: 1,
            max: 99,
        }));
    }
    errors.collect(ros.propertyValidator('ecsOrderComputeCount', ros.validateNumber)(properties.ecsOrderComputeCount));
    if (properties.description && (Array.isArray(properties.description) || (typeof properties.description) === 'string')) {
        errors.collect(ros.propertyValidator('description', ros.validateLength)({
            data: properties.description.length,
            min: 2,
            max: 128,
        }));
    }
    errors.collect(ros.propertyValidator('description', ros.validateString)(properties.description));
    errors.collect(ros.propertyValidator('securityGroupName', ros.validateString)(properties.securityGroupName));
    errors.collect(ros.propertyValidator('systemDiskSize', ros.validateNumber)(properties.systemDiskSize));
    if (properties.additionalVolumes && (Array.isArray(properties.additionalVolumes) || (typeof properties.additionalVolumes) === 'string')) {
        errors.collect(ros.propertyValidator('additionalVolumes', ros.validateLength)({
            data: properties.additionalVolumes.length,
            min: undefined,
            max: 10,
        }));
    }
    errors.collect(ros.propertyValidator('additionalVolumes', ros.listValidator(RosCluster_AdditionalVolumesPropertyValidator))(properties.additionalVolumes));
    errors.collect(ros.propertyValidator('autoRenew', ros.validateBoolean)(properties.autoRenew));
    errors.collect(ros.propertyValidator('computeSpotPriceLimit', ros.validateString)(properties.computeSpotPriceLimit));
    errors.collect(ros.propertyValidator('clientVersion', ros.validateString)(properties.clientVersion));
    errors.collect(ros.propertyValidator('volumeType', ros.validateString)(properties.volumeType));
    errors.collect(ros.propertyValidator('inputFileUrl', ros.validateString)(properties.inputFileUrl));
    if (properties.password && (Array.isArray(properties.password) || (typeof properties.password) === 'string')) {
        errors.collect(ros.propertyValidator('password', ros.validateLength)({
            data: properties.password.length,
            min: 8,
            max: 30,
        }));
    }
    errors.collect(ros.propertyValidator('password', ros.validateString)(properties.password));
    errors.collect(ros.propertyValidator('autoRenewPeriod', ros.validateNumber)(properties.autoRenewPeriod));
    errors.collect(ros.propertyValidator('keyPairName', ros.validateString)(properties.keyPairName));
    errors.collect(ros.propertyValidator('remoteDirectory', ros.validateString)(properties.remoteDirectory));
    errors.collect(ros.propertyValidator('sccClusterId', ros.validateString)(properties.sccClusterId));
    errors.collect(ros.propertyValidator('zoneId', ros.validateString)(properties.zoneId));
    errors.collect(ros.propertyValidator('systemDiskLevel', ros.validateString)(properties.systemDiskLevel));
    errors.collect(ros.propertyValidator('ecsOrderLoginCount', ros.requiredValidator)(properties.ecsOrderLoginCount));
    if (properties.ecsOrderLoginCount && (typeof properties.ecsOrderLoginCount) !== 'object') {
        errors.collect(ros.propertyValidator('ecsOrderLoginCount', ros.validateRange)({
            data: properties.ecsOrderLoginCount,
            min: 1,
            max: 1,
        }));
    }
    errors.collect(ros.propertyValidator('ecsOrderLoginCount', ros.validateNumber)(properties.ecsOrderLoginCount));
    errors.collect(ros.propertyValidator('securityGroupId', ros.validateString)(properties.securityGroupId));
    errors.collect(ros.propertyValidator('schedulerType', ros.validateString)(properties.schedulerType));
    errors.collect(ros.propertyValidator('accountType', ros.validateString)(properties.accountType));
    errors.collect(ros.propertyValidator('haEnable', ros.validateBoolean)(properties.haEnable));
    errors.collect(ros.propertyValidator('osTag', ros.requiredValidator)(properties.osTag));
    errors.collect(ros.propertyValidator('osTag', ros.validateString)(properties.osTag));
    if (properties.ecsChargeType && (typeof properties.ecsChargeType) !== 'object') {
        errors.collect(ros.propertyValidator('ecsChargeType', ros.validateAllowedValues)({
            data: properties.ecsChargeType,
            allowedValues: ["PayAsYouGo", "PostPaid", "PayOnDemand", "Postpaid", "PostPay", "POSTPAY", "POST", "Subscription", "PrePaid", "Prepaid", "PrePay", "PREPAY", "PRE"],
        }));
    }
    errors.collect(ros.propertyValidator('ecsChargeType', ros.validateString)(properties.ecsChargeType));
    return errors.wrap('supplied properties not correct for "RosClusterProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::EHPC::Cluster` resource
 *
 * @param properties - the TypeScript properties of a `RosClusterProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::EHPC::Cluster` resource.
 */
// @ts-ignore TS6133
function rosClusterPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosClusterPropsValidator(properties).assertSuccess();
    }
    return {
        EcsOrderComputeCount: ros.numberToRosTemplate(properties.ecsOrderComputeCount),
        EcsOrderComputeInstanceType: ros.stringToRosTemplate(properties.ecsOrderComputeInstanceType),
        EcsOrderLoginCount: ros.numberToRosTemplate(properties.ecsOrderLoginCount),
        EcsOrderLoginInstanceType: ros.stringToRosTemplate(properties.ecsOrderLoginInstanceType),
        EcsOrderManagerInstanceType: ros.stringToRosTemplate(properties.ecsOrderManagerInstanceType),
        Name: ros.stringToRosTemplate(properties.name),
        OsTag: ros.stringToRosTemplate(properties.osTag),
        VSwitchId: ros.stringToRosTemplate(properties.vSwitchId),
        AccountType: ros.stringToRosTemplate(properties.accountType),
        AdditionalVolumes: ros.listMapper(rosClusterAdditionalVolumesPropertyToRosTemplate)(properties.additionalVolumes),
        Application: ros.listMapper(rosClusterApplicationPropertyToRosTemplate)(properties.application),
        AutoRenew: ros.booleanToRosTemplate(properties.autoRenew),
        AutoRenewPeriod: ros.numberToRosTemplate(properties.autoRenewPeriod),
        ClientVersion: ros.stringToRosTemplate(properties.clientVersion),
        ComputeEnableHt: ros.booleanToRosTemplate(properties.computeEnableHt),
        ComputeSpotPriceLimit: ros.stringToRosTemplate(properties.computeSpotPriceLimit),
        ComputeSpotStrategy: ros.stringToRosTemplate(properties.computeSpotStrategy),
        DeployMode: ros.stringToRosTemplate(properties.deployMode),
        Description: ros.stringToRosTemplate(properties.description),
        EcsChargeType: ros.stringToRosTemplate(properties.ecsChargeType),
        EcsOrderManagerCount: ros.numberToRosTemplate(properties.ecsOrderManagerCount),
        EhpcVersion: ros.stringToRosTemplate(properties.ehpcVersion),
        HaEnable: ros.booleanToRosTemplate(properties.haEnable),
        ImageId: ros.stringToRosTemplate(properties.imageId),
        ImageOwnerAlias: ros.stringToRosTemplate(properties.imageOwnerAlias),
        InputFileUrl: ros.stringToRosTemplate(properties.inputFileUrl),
        IsComputeEss: ros.booleanToRosTemplate(properties.isComputeEss),
        JobQueue: ros.stringToRosTemplate(properties.jobQueue),
        KeyPairName: ros.stringToRosTemplate(properties.keyPairName),
        Password: ros.stringToRosTemplate(properties.password),
        Period: ros.numberToRosTemplate(properties.period),
        PeriodUnit: ros.stringToRosTemplate(properties.periodUnit),
        PostInstallScript: ros.listMapper(rosClusterPostInstallScriptPropertyToRosTemplate)(properties.postInstallScript),
        RemoteDirectory: ros.stringToRosTemplate(properties.remoteDirectory),
        RemoteVisEnable: ros.booleanToRosTemplate(properties.remoteVisEnable),
        ResourceGroupId: ros.stringToRosTemplate(properties.resourceGroupId),
        SccClusterId: ros.stringToRosTemplate(properties.sccClusterId),
        SchedulerType: ros.stringToRosTemplate(properties.schedulerType),
        SecurityGroupId: ros.stringToRosTemplate(properties.securityGroupId),
        SecurityGroupName: ros.stringToRosTemplate(properties.securityGroupName),
        SystemDiskLevel: ros.stringToRosTemplate(properties.systemDiskLevel),
        SystemDiskSize: ros.numberToRosTemplate(properties.systemDiskSize),
        SystemDiskType: ros.stringToRosTemplate(properties.systemDiskType),
        VolumeId: ros.stringToRosTemplate(properties.volumeId),
        VolumeMountpoint: ros.stringToRosTemplate(properties.volumeMountpoint),
        VolumeProtocol: ros.stringToRosTemplate(properties.volumeProtocol),
        VolumeType: ros.stringToRosTemplate(properties.volumeType),
        WithoutElasticIp: ros.booleanToRosTemplate(properties.withoutElasticIp),
        ZoneId: ros.stringToRosTemplate(properties.zoneId),
    };
}
/**
 * A ROS template type:  `ALIYUN::EHPC::Cluster`
 */
class RosCluster extends ros.RosResource {
    /**
     * Create a new `ALIYUN::EHPC::Cluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosCluster.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrClusterId = this.getAtt('ClusterId');
        this.attrEcsInfo = this.getAtt('EcsInfo');
        this.attrName = this.getAtt('Name');
        this.attrSecurityGroupId = this.getAtt('SecurityGroupId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.ecsOrderComputeCount = props.ecsOrderComputeCount;
        this.ecsOrderComputeInstanceType = props.ecsOrderComputeInstanceType;
        this.ecsOrderLoginCount = props.ecsOrderLoginCount;
        this.ecsOrderLoginInstanceType = props.ecsOrderLoginInstanceType;
        this.ecsOrderManagerInstanceType = props.ecsOrderManagerInstanceType;
        this.name = props.name;
        this.osTag = props.osTag;
        this.vSwitchId = props.vSwitchId;
        this.accountType = props.accountType;
        this.additionalVolumes = props.additionalVolumes;
        this.application = props.application;
        this.autoRenew = props.autoRenew;
        this.autoRenewPeriod = props.autoRenewPeriod;
        this.clientVersion = props.clientVersion;
        this.computeEnableHt = props.computeEnableHt;
        this.computeSpotPriceLimit = props.computeSpotPriceLimit;
        this.computeSpotStrategy = props.computeSpotStrategy;
        this.deployMode = props.deployMode;
        this.description = props.description;
        this.ecsChargeType = props.ecsChargeType;
        this.ecsOrderManagerCount = props.ecsOrderManagerCount;
        this.ehpcVersion = props.ehpcVersion;
        this.haEnable = props.haEnable;
        this.imageId = props.imageId;
        this.imageOwnerAlias = props.imageOwnerAlias;
        this.inputFileUrl = props.inputFileUrl;
        this.isComputeEss = props.isComputeEss;
        this.jobQueue = props.jobQueue;
        this.keyPairName = props.keyPairName;
        this.password = props.password;
        this.period = props.period;
        this.periodUnit = props.periodUnit;
        this.postInstallScript = props.postInstallScript;
        this.remoteDirectory = props.remoteDirectory;
        this.remoteVisEnable = props.remoteVisEnable;
        this.resourceGroupId = props.resourceGroupId;
        this.sccClusterId = props.sccClusterId;
        this.schedulerType = props.schedulerType;
        this.securityGroupId = props.securityGroupId;
        this.securityGroupName = props.securityGroupName;
        this.systemDiskLevel = props.systemDiskLevel;
        this.systemDiskSize = props.systemDiskSize;
        this.systemDiskType = props.systemDiskType;
        this.volumeId = props.volumeId;
        this.volumeMountpoint = props.volumeMountpoint;
        this.volumeProtocol = props.volumeProtocol;
        this.volumeType = props.volumeType;
        this.withoutElasticIp = props.withoutElasticIp;
        this.zoneId = props.zoneId;
    }
    get rosProperties() {
        return {
            ecsOrderComputeCount: this.ecsOrderComputeCount,
            ecsOrderComputeInstanceType: this.ecsOrderComputeInstanceType,
            ecsOrderLoginCount: this.ecsOrderLoginCount,
            ecsOrderLoginInstanceType: this.ecsOrderLoginInstanceType,
            ecsOrderManagerInstanceType: this.ecsOrderManagerInstanceType,
            name: this.name,
            osTag: this.osTag,
            vSwitchId: this.vSwitchId,
            accountType: this.accountType,
            additionalVolumes: this.additionalVolumes,
            application: this.application,
            autoRenew: this.autoRenew,
            autoRenewPeriod: this.autoRenewPeriod,
            clientVersion: this.clientVersion,
            computeEnableHt: this.computeEnableHt,
            computeSpotPriceLimit: this.computeSpotPriceLimit,
            computeSpotStrategy: this.computeSpotStrategy,
            deployMode: this.deployMode,
            description: this.description,
            ecsChargeType: this.ecsChargeType,
            ecsOrderManagerCount: this.ecsOrderManagerCount,
            ehpcVersion: this.ehpcVersion,
            haEnable: this.haEnable,
            imageId: this.imageId,
            imageOwnerAlias: this.imageOwnerAlias,
            inputFileUrl: this.inputFileUrl,
            isComputeEss: this.isComputeEss,
            jobQueue: this.jobQueue,
            keyPairName: this.keyPairName,
            password: this.password,
            period: this.period,
            periodUnit: this.periodUnit,
            postInstallScript: this.postInstallScript,
            remoteDirectory: this.remoteDirectory,
            remoteVisEnable: this.remoteVisEnable,
            resourceGroupId: this.resourceGroupId,
            sccClusterId: this.sccClusterId,
            schedulerType: this.schedulerType,
            securityGroupId: this.securityGroupId,
            securityGroupName: this.securityGroupName,
            systemDiskLevel: this.systemDiskLevel,
            systemDiskSize: this.systemDiskSize,
            systemDiskType: this.systemDiskType,
            volumeId: this.volumeId,
            volumeMountpoint: this.volumeMountpoint,
            volumeProtocol: this.volumeProtocol,
            volumeType: this.volumeType,
            withoutElasticIp: this.withoutElasticIp,
            zoneId: this.zoneId,
        };
    }
    renderProperties(props) {
        return rosClusterPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosCluster = RosCluster;
/**
 * The resource type name for this resource class.
 */
RosCluster.ROS_RESOURCE_TYPE_NAME = "ALIYUN::EHPC::Cluster";
/**
 * Determine whether the given properties match those of a `AdditionalVolumesProperty`
 *
 * @param properties - the TypeScript properties of a `AdditionalVolumesProperty`
 *
 * @returns the result of the validation.
 */
function RosCluster_AdditionalVolumesPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('volumeProtocol', ros.validateString)(properties.volumeProtocol));
    errors.collect(ros.propertyValidator('localDirectory', ros.requiredValidator)(properties.localDirectory));
    errors.collect(ros.propertyValidator('localDirectory', ros.validateString)(properties.localDirectory));
    errors.collect(ros.propertyValidator('volumeId', ros.requiredValidator)(properties.volumeId));
    errors.collect(ros.propertyValidator('volumeId', ros.validateString)(properties.volumeId));
    errors.collect(ros.propertyValidator('remoteDirectory', ros.validateString)(properties.remoteDirectory));
    errors.collect(ros.propertyValidator('volumeType', ros.validateString)(properties.volumeType));
    errors.collect(ros.propertyValidator('jobQueue', ros.validateString)(properties.jobQueue));
    errors.collect(ros.propertyValidator('volumeMountpoint', ros.requiredValidator)(properties.volumeMountpoint));
    errors.collect(ros.propertyValidator('volumeMountpoint', ros.validateString)(properties.volumeMountpoint));
    errors.collect(ros.propertyValidator('location', ros.validateString)(properties.location));
    return errors.wrap('supplied properties not correct for "AdditionalVolumesProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::EHPC::Cluster.AdditionalVolumes` resource
 *
 * @param properties - the TypeScript properties of a `AdditionalVolumesProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::EHPC::Cluster.AdditionalVolumes` resource.
 */
// @ts-ignore TS6133
function rosClusterAdditionalVolumesPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosCluster_AdditionalVolumesPropertyValidator(properties).assertSuccess();
    return {
        VolumeProtocol: ros.stringToRosTemplate(properties.volumeProtocol),
        LocalDirectory: ros.stringToRosTemplate(properties.localDirectory),
        VolumeId: ros.stringToRosTemplate(properties.volumeId),
        RemoteDirectory: ros.stringToRosTemplate(properties.remoteDirectory),
        VolumeType: ros.stringToRosTemplate(properties.volumeType),
        JobQueue: ros.stringToRosTemplate(properties.jobQueue),
        VolumeMountpoint: ros.stringToRosTemplate(properties.volumeMountpoint),
        Location: ros.stringToRosTemplate(properties.location),
    };
}
/**
 * Determine whether the given properties match those of a `ApplicationProperty`
 *
 * @param properties - the TypeScript properties of a `ApplicationProperty`
 *
 * @returns the result of the validation.
 */
function RosCluster_ApplicationPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('tag', ros.requiredValidator)(properties.tag));
    errors.collect(ros.propertyValidator('tag', ros.validateString)(properties.tag));
    return errors.wrap('supplied properties not correct for "ApplicationProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::EHPC::Cluster.Application` resource
 *
 * @param properties - the TypeScript properties of a `ApplicationProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::EHPC::Cluster.Application` resource.
 */
// @ts-ignore TS6133
function rosClusterApplicationPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosCluster_ApplicationPropertyValidator(properties).assertSuccess();
    return {
        Tag: ros.stringToRosTemplate(properties.tag),
    };
}
/**
 * Determine whether the given properties match those of a `PostInstallScriptProperty`
 *
 * @param properties - the TypeScript properties of a `PostInstallScriptProperty`
 *
 * @returns the result of the validation.
 */
function RosCluster_PostInstallScriptPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('args', ros.validateString)(properties.args));
    errors.collect(ros.propertyValidator('url', ros.validateString)(properties.url));
    return errors.wrap('supplied properties not correct for "PostInstallScriptProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::EHPC::Cluster.PostInstallScript` resource
 *
 * @param properties - the TypeScript properties of a `PostInstallScriptProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::EHPC::Cluster.PostInstallScript` resource.
 */
// @ts-ignore TS6133
function rosClusterPostInstallScriptPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosCluster_PostInstallScriptPropertyValidator(properties).assertSuccess();
    return {
        Args: ros.stringToRosTemplate(properties.args),
        Url: ros.stringToRosTemplate(properties.url),
    };
}
//# sourceMappingURL=data:application/json;base64,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