"""initial tables

Peek Plugin Database Migration Script

Revision ID: 007ac5377946
Revises: 
Create Date: 2019-06-12 17:25:41.798365

"""

# revision identifiers, used by Alembic.
revision = '007ac5377946'
down_revision = None
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
import geoalchemy2


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('Setting',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('name', sa.String(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    schema='pl_diagram_trace'
    )
    op.create_table('SettingProperty',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('settingId', sa.Integer(), nullable=False),
    sa.Column('key', sa.String(length=50), nullable=False),
    sa.Column('type', sa.String(length=16), nullable=True),
    sa.Column('int_value', sa.Integer(), nullable=True),
    sa.Column('char_value', sa.String(), nullable=True),
    sa.Column('boolean_value', sa.Boolean(), nullable=True),
    sa.ForeignKeyConstraint(['settingId'], ['pl_diagram_trace.Setting.id'], ),
    sa.PrimaryKeyConstraint('id'),
    schema='pl_diagram_trace'
    )
    op.create_index('idx_SettingProperty_settingId', 'SettingProperty', ['settingId'], unique=False, schema='pl_diagram_trace')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('idx_SettingProperty_settingId', table_name='SettingProperty', schema='pl_diagram_trace')
    op.drop_table('SettingProperty', schema='pl_diagram_trace')
    op.drop_table('Setting', schema='pl_diagram_trace')
    # ### end Alembic commands ###