import * as ec2 from '@aws-cdk/aws-ec2';
import * as ecs from '@aws-cdk/aws-ecs';
import { CommonEcsRunTaskProps, EcsRunTaskBase } from './run-ecs-task-base';
/**
 * Properties to run an ECS task on EC2 in StepFunctionsan ECS.
 *
 * @stability stable
 */
export interface RunEcsEc2TaskProps extends CommonEcsRunTaskProps {
    /**
     * In what subnets to place the task's ENIs.
     *
     * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
     *
     * @default Private subnets
     * @stability stable
     */
    readonly subnets?: ec2.SubnetSelection;
    /**
     * Existing security group to use for the task's ENIs.
     *
     * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
     *
     * @default A new security group is created
     * @stability stable
     */
    readonly securityGroup?: ec2.ISecurityGroup;
    /**
     * Placement constraints.
     *
     * @default No constraints
     * @stability stable
     */
    readonly placementConstraints?: ecs.PlacementConstraint[];
    /**
     * Placement strategies.
     *
     * @default No strategies
     * @stability stable
     */
    readonly placementStrategies?: ecs.PlacementStrategy[];
}
/**
 * (deprecated) Run an ECS/EC2 Task in a StepFunctions workflow.
 *
 * @deprecated - replaced by `EcsRunTask`
 */
export declare class RunEcsEc2Task extends EcsRunTaskBase {
    /**
     * @deprecated
     */
    constructor(props: RunEcsEc2TaskProps);
}
