import * as ddb from '@aws-cdk/aws-dynamodb';
import * as iam from '@aws-cdk/aws-iam';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Construct } from 'constructs';
import { DynamoAttributeValue, DynamoConsumedCapacity, DynamoItemCollectionMetrics, DynamoReturnValues } from './shared-types';
/**
 * Properties for DynamoPutItem Task.
 *
 * @stability stable
 */
export interface DynamoPutItemProps extends sfn.TaskStateBaseProps {
    /**
     * A map of attribute name/value pairs, one for each attribute.
     *
     * Only the primary key attributes are required;
     * you can optionally provide other attribute name-value pairs for the item.
     *
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_PutItem.html#DDB-PutItem-request-Item
     * @stability stable
     */
    readonly item: {
        [key: string]: DynamoAttributeValue;
    };
    /**
     * The name of the table where the item should be written .
     *
     * @stability stable
     */
    readonly table: ddb.ITable;
    /**
     * A condition that must be satisfied in order for a conditional PutItem operation to succeed.
     *
     * @default - No condition expression
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_PutItem.html#DDB-PutItem-request-ConditionExpression
     * @stability stable
     */
    readonly conditionExpression?: string;
    /**
     * One or more substitution tokens for attribute names in an expression.
     *
     * @default - No expression attribute names
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_PutItem.html#DDB-PutItem-request-ExpressionAttributeNames
     * @stability stable
     */
    readonly expressionAttributeNames?: {
        [key: string]: string;
    };
    /**
     * One or more values that can be substituted in an expression.
     *
     * @default - No expression attribute values
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_PutItem.html#DDB-PutItem-request-ExpressionAttributeValues
     * @stability stable
     */
    readonly expressionAttributeValues?: {
        [key: string]: DynamoAttributeValue;
    };
    /**
     * Determines the level of detail about provisioned throughput consumption that is returned in the response.
     *
     * @default DynamoConsumedCapacity.NONE
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_PutItem.html#DDB-PutItem-request-ReturnConsumedCapacity
     * @stability stable
     */
    readonly returnConsumedCapacity?: DynamoConsumedCapacity;
    /**
     * The item collection metrics to returned in the response.
     *
     * @default DynamoItemCollectionMetrics.NONE
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LSI.html#LSI.ItemCollections
     * @stability stable
     */
    readonly returnItemCollectionMetrics?: DynamoItemCollectionMetrics;
    /**
     * Use ReturnValues if you want to get the item attributes as they appeared before they were updated with the PutItem request.
     *
     * @default DynamoReturnValues.NONE
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_PutItem.html#DDB-PutItem-request-ReturnValues
     * @stability stable
     */
    readonly returnValues?: DynamoReturnValues;
}
/**
 * A StepFunctions task to call DynamoPutItem.
 *
 * @stability stable
 */
export declare class DynamoPutItem extends sfn.TaskStateBase {
    private readonly props;
    /**
     * @stability stable
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @stability stable
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: DynamoPutItemProps);
    /**
     * @internal
     */
    protected _renderTask(): any;
}
