# generated by datamodel-codegen:
#   filename:  schema/entity/teams/role.json
#   timestamp: 2022-04-08T13:29:14+00:00

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, Extra, Field, constr

from ...type import basic, entityHistory, entityReference


class RoleName(BaseModel):
    __root__: constr(min_length=1, max_length=128) = Field(
        ..., description='A unique name for the role.'
    )


class Role(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid
    name: RoleName
    displayName: Optional[str] = Field(
        None, description="Name used for display purposes. Example 'Data Consumer'."
    )
    description: Optional[str] = Field(None, description='Description of the role.')
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this entity.'
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
    policy: Optional[entityReference.EntityReference] = Field(
        None, description='Policy that is attached to this role.'
    )
    users: Optional[entityReference.EntityReferenceList] = Field(
        None, description='Users that have this role assigned.'
    )
    defaultRole: Optional[bool] = Field(
        False,
        description='If `true`, this role is set as default role and will be assigned to all users.',
    )
    teams: Optional[entityReference.EntityReferenceList] = Field(
        None, description='Teams that have this role assigned.'
    )
