# stest
 基于unittest开发的测试框架，更友好、更灵活的编写、管理与运行测试，生成更加美观的独立单文件HTML报告。内置参数化测试数据存取方案，省去设计的烦恼，节省更多的时间，从而更快的投入到编写用例阶段。
 * 现已支持的功能
    >* 支持命名测试方法且不与方法的doc string（文档字符串）冲突
    >* 支持设置测试方法编写人，修改人，最后修改人以及最后一次修改时间等额外记录信息
    >* 支持设置测试方法的执行顺序
    >* 支持参数化功能
    >* 支持数据驱动测试
    >* 支持设置用例依赖
    >* 内置参数化数据存取方案(使用excel（xlsx或xls格式）存取和管理维护参数化测试数据，简洁直观，易于修改维护)
    >* 支持生成更加简洁美观且可作为独立文件发送的HTML测试报告
    >    ![](data:image/png;base64,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)


## 安装

pip方式安装
> pip install stest

源码方式安装(注意以管理员方式执行)
> python setup.py install

## 执行测试
命令行执行
> python -m stest -v -html D:\temp\tms_apitest.html calculation_test.py

查看命令行参数
> python -m stest -h

代码中调stest.main()执行

    ```python
    #!/usr/bin/env python
    # -*- encoding: utf-8 -*-

    import stest
    from stest import AbstractTestCase
    from stest import Test as testcase


    def get_testdatas(test_class_name, test_method_name, *args, **kwargs):

        return [[1,2,3], [3,4,7]]


    class Demo1Test(AbstractTestCase):

        @testcase(priority=1, enabled=True, data_provider=get_testdatas, author='思文伟', description='两数加法测试01')
        def integer_addition_02(self, number_1, number_2, expected):

            result = number_1 + number_2
            self.assertEqual(result, expected)
    if __name__ == '__main__':
        # Demo1Test.run_test()
        stest.main()
    ```

## 快速开始

1. 导入抽象测试类（AbstractTestCase）和测试方法装饰器（Test）
2. 编写继承自AbstractTestCase的测试子类，子类提供以下实用方法
    - collect_testcases()
        > 获取类下所有使用Test装饰的enable为True，并根据priority排序后的测试用例对象列表
    - build_self_suite()
        > 构建该类测试用例构成的测试套件
    - run_test()
        > 执行该类所有使用Test装饰的enable为True，并根据priority排序后的测试用例
3. 使用Test标记测试方法。
4. 直接调用测试类的run_test()执行测试
* 简单示例
    ```python
    #!/usr/bin/env python
    # -*- encoding: utf-8 -*-

    from stest import AbstractTestCase
    from stest import Test as testcase


    def get_testdatas(test_class_name, test_method_name, *args, **kwargs):

        return [[1,2,3], [3,4,7]]


    class Demo1Test(AbstractTestCase):

        @testcase(priority=1, enabled=True, data_provider=get_testdatas, author='思文伟', description='两数加法测试01')
        def integer_addition_02(self, number_1, number_2, expected):

            result = number_1 + number_2
            self.assertEqual(result, expected)
    if __name__ == '__main__':
        Demo1Test.run_test()
    ```

* 综合示例（来自源码包下的samples/calculation_test.py）

    ```python
    #!/usr/bin/env python
    # -*- encoding: utf-8 -*-
    '''
    @Author: 思文伟
    @Date: 2021/03/30 15:49:32
    '''
    import os

    from stest import GLOBAL_CONFIG
    from stest import AbstractTestCase
    from stest import Test as testcase


    class DataProvider01(object):
        def get_testdatas(self, testclass, testmethod, *args, **kwargs):

            datas = [
                {'加数1':1,'加数2':2,'预期':3},
                {'加数1':4,'加数2':5,'预期':9}
            ]
            return datas

    class DataProvider02(object):
        def get_testdatas(self, testclass, testmethod, *args, **kwargs):

            datas = [
                [{'加数1':7}, {'加数2':5}, {'预期':12}],
                [{'加数1':10}, {'加数2':5}, {'预期':15}]
            ]
            return datas

    TEST_DATA_FILE_DIRPATH = os.path.dirname(os.path.abspath(__file__))

    # 全局配置 配置默认内置参数数据提供者 测试数据文件所在的目录路径
    # GLOBAL_CONFIG.seven_data_provider_data_file_dir = r'E:\sw'


    class CalculationTest(AbstractTestCase):
        """数学运算测试"""
        @classmethod
        def setUpClass(cls):
            pass

        def setUp(self):
            pass

        @testcase(priority=1, enabled=True, data_provider=DataProvider01().get_testdatas, author='思文伟', description='整数加法测试01')
        def integer_addition_01(self, testdata):
            """自定义数据提供者 - 测试方法一个参数化示例"""

            number_1 = testdata.get("加数1")
            number_2 = testdata.get("加数2")
            expected = testdata.get("预期")

            result = number_1 + number_2
            self.assertEqual(result, expected)

        @testcase(priority=2, enabled=True, data_provider=DataProvider02().get_testdatas, author='思文伟', description='整数加法测试02')
        def integer_addition_02(self, testdata_01, testdata_02, testdata_03):
            """自定义数据提供者 - 测试方法多个参数化示例"""

            number_1 = testdata_01.get("加数1")
            number_2 = testdata_02.get("加数2")
            expected = testdata_03.get("预期")

            result = number_1 + number_2
            self.assertEqual(result, expected)

        @testcase(priority=3, enabled=True, author='思文伟', description='整数减法测试01')
        def integer_subtraction_01(self):
            """不参数化示例"""

            number_1 = 21
            number_2 = 10
            result = number_1 - number_2
            expected = 11
            self.assertEqual(result, expected)

        @testcase(priority=4, enabled=True, author='思文伟', data_provider_kwargs={'data_file_dir_path':TEST_DATA_FILE_DIRPATH}, description='整数减法测试02')
        def integer_subtraction_02(self, testdata):
            """使用内置的数据提供者 - 传入测试数据文件所在的目录路径"""

            number_1 = testdata.get("减数1")
            number_2 = testdata.get("减数2")
            expected = testdata.get("预期")

            result = int(number_1) - int(number_2)
            self.assertEqual(result, int(expected))

        @testcase(priority=5, enabled=True, author='思文伟', description='整数减法测试03')
        def integer_subtraction_03(self,testdata):
            """使用内置的数据提供者 - 不传入测试数据文件所在的目录路径,
            则会检测GLOBAL_CONFIG.seven_data_provider_data_file_dir 是否设置
            ，没有设置则会使用该方法所属的测试类所在的模块目录路径作为测试数据文件的查找目录
            """

            number_1 = testdata.get("减数1")
            number_2 = testdata.get("减数2")
            expected = testdata.get("预期")

            result = int(number_1) - int(number_2)
            self.assertEqual(result, int(expected))

        def tearDown(self):
            pass

        @classmethod
        def tearDownClass(cls):
            pass

    if __name__ == '__main__':
        CalculationTest.run_test()

    ```

## Test参数说明

| 参数 | 类型 | 描述 |
| ---- | ---- | ---- |
| author | 字符串 | 用例编写者 |
| editors | 列表 | 修改者列表 |
| dname | 字符串或列表 | 用于给用例起一个用于设置依赖的名称 |
| depends | 列表 | 用于设置用例依赖，是一个用例依赖列表 |
| groups | 列表 | 方法所属的组的列表|
| enabled | 布尔值 | 是否启用执行该测试方法 |
| priority | 整数 | 测试方法的执行优先级，数值越小执行越靠前 |
| alway_run | 布尔值 | 如果设置为True，不管依赖它所依赖的其他用例结果如何都始终运行，为False时，则它所依赖的其他用例不成功，就不会执行，默认值为False |
| description | 字符串 | 测试用例名称 |
| data_provider | object | 测试方法的参数化数据提供者，默认值是None，AbsractDataProvider的子类或者一个可调用的对象，返回数据集列表（当测试方法只有一个参数化时，应返回一维列表，多个参数化时返回二维列表） |
| data_provider_args | 元祖 | 数据提供者变长位置参数(args) |
| data_provider_kwargs | 字典 | 数据提供者变长关键字参数(kwargs) |
| last_modifyied_by | 字符串 | 最后修改者 |
| last_modified_time | 字符串 | 最后一次修改的时间 |
| enable_default_data_provider | 布尔值 | 是否使用内置数据提供者(SevenDataProvider)，默认值是True，未设置data_provider，且该值为True 才会使用内置数据提供者(SevenDataProvider) |

## 用例依赖设置
用例依赖于其它用例成功后执行，如用例所依赖的用例不成功或没有执行，则该用例会被设置为失败。在实际当中，有时会需要用到两个或多个测试用例依赖运行，比如这一种场景：添加和删除设备，如果只有一台设备，那么添加和删除这两个用例就会共用测试数据，就会产生依赖（即：删除设备用例依赖于添加设备用例成功后执行）

* dname和depends参数使用示例

    ```python
    #!/usr/bin/env python
    # -*- encoding: utf-8 -*-
    '''
    @Author: 思文伟
    @Date: 2021/09/29
    '''

    import stest
    from stest import AbstractTestCase
    from stest import Test as testcase


    class DependTest(AbstractTestCase):
        """依赖设置测试"""
        @classmethod
        def setUpClass(cls):
            pass

        def setUp(self):
            pass

        @testcase(priority=1, enabled=True, author='思文伟', description='dtest1', depends=['vnctest.py'])
        def dtest1(self):
            """ 用例依赖于vnctest.py模块中的所有用例 """

            pass

        @testcase(priority=2, enabled=True, author='思文伟', description='dtest2', depends=['vnctest.py.LoginTest'])
        def dtest2(self):
            """ 用例依赖于vnctest.py模块中LoginTest类的所有用例 """

            pass

        @testcase(priority=2, enabled=True, author='思文伟', description='dtest3', depends=['vnctest.py.LoginTest.login'])
        def dtest3(self):
            """ 用例依赖于vnctest.py模块中LoginTest类的login用例 """
            pass

        @testcase(priority=2, enabled=True, author='思文伟', description='dtest4', dname='four')
        def dtest4(self):
            """ 命名用例为 four """
            pass

        @testcase(priority=2, enabled=True, author='思文伟', description='dtest5', depends=['dtest6'])
        def dtest5(self):
            """ 用例依赖于当前类的dtest6用例 """
            pass

        @testcase(priority=2, enabled=True, author='思文伟', description='dtest6', depends=['four'])
        def dtest6(self):
            """ 用例依赖于当前类的命名为four的dtest4用例 """
            pass

        def tearDown(self):
            pass

        @classmethod
        def tearDownClass(cls):
            pass


    if __name__ == '__main__':
        stest.main()

    ```

## 参数化数据提供者(data provider)

 测试方法装饰器Test会调用数据提供者(data provider), 传测试类名称和测试方法名称给data provider的前两个固定位置参数, data_provider_args参数传给data provider的变长位置参数，data_provider_kwargs参数传给data provider的变长关键字参数

### 内置参数化数据提供者 - SevenDataProvider

实现了参数化测试数据存取方案，使用excel（xlsx或xls格式）存取和管理维护参数化测试数据，简洁直观，易于修改维护。数据在文件中以用例数据块的方式存储。

* 数据块定义：
    >- 所有行中的第一列是标记列，第一行第一列是数据块开始标记
    >- 第一行: 用例名称信息(标记列的下一列是用例方法名称列，之后是用例名称列)
    >- 第二行: 用例数据标题
    >- 第三行 开始 每一行都是一组完整的测试数据直至遇见空行或者下一个数据块

    >![](data:image/png;base64,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)

* kwargs变长关键字参数接收参数:
    >- data_file_name - 数据文件名称
    >- data_file_dir_path - 数据文件所在目录路径
    >- sheet_name_or_index - 数据文件中数据所在的工作表索引(从0开始)或名称

* 返回值
    测试数据行信息字典构成的一维列表, 如：
    > [{"减数1": "36", "减数2": "10", "预期": "26"}, {"减数1": "57", "减数2": "30", "预期": "27"}]
    >![](data:image/png;base64,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)

* 使用
    框架是默认启用内置的数据提供者（SevenDataProvider）所以不需要做任何设置，返回值是测试数据行信息字典构成的一维列表，所以测试方法统一接收一个参数化参数
    - 启用条件
        >- 测试方法装饰器Test参数enable_default_data_provider 为True，默认值是True
        >- 测试方法装饰器Test参数data_provider 为None（即未设置数据提供者），默认值是True为None

    - 数据文件存放目录
        通过测试方法装饰器Test参数data_provider_kwargs传入data_file_dir_path，如果没有传入，则会去检查全局配置unittest_seven_helper.GLOBAL_CONFIG.seven_data_provider_data_file_dir是否设置，设置了则取该值作为参数化测试数据文件的查找目录，否则以被装饰的测试方法所在的模块目录作为查找目录
        > data_provider_kwargs={'data_file_dir_path':'E:\\mytestdatas'}

    - 数据文件名
        通过测试方法装饰器Test参数data_provider_kwargs传入data_file_name，如果没有传入，则取测试方法所属的测试类名作为测试数据文件名称
        > data_provider_kwargs={'data_file_name':'mytest'}

* 示例
```python
class CalculationTest(AbstractTestCase):
        @classmethod
        def setUpClass(cls):
            pass

        def setUp(self):
            pass

        @testcase(priority=4, enabled=True, author='思文伟', data_provider_kwargs={'data_file_dir_path':'E:\\alltest'}, description='整数减法测试02')
        def integer_subtraction_02(self, testdata):
            """使用内置的数据提供者 - 传入测试数据文件所在的目录路径"""

            number_1 = testdata.get("减数1")
            number_2 = testdata.get("减数2")
            expected = testdata.get("预期")

            result = int(number_1) - int(number_2)
            self.assertEqual(result, int(expected))

        @testcase(priority=5, enabled=True, author='思文伟', description='整数减法测试03')
        def integer_subtraction_03(self,testdata):
            """使用内置的数据提供者 - 不传入测试数据文件所在的目录路径,
            则会检测GLOBAL_CONFIG.seven_data_provider_data_file_dir 是否设置
            ，没有设置则会使用该方法所属的测试类所在的模块目录路径作为测试数据文件的查找目录
            """

            number_1 = testdata.get("减数1")
            number_2 = testdata.get("减数2")
            expected = testdata.get("预期")

            result = int(number_1) - int(number_2)
            self.assertEqual(result, int(expected))

        def tearDown(self):
            pass

        @classmethod
        def tearDownClass(cls):
            pass

    if __name__ == '__main__':
        CalculationTest.run_test()
```


### 自定义参数化数据提供者

自定义参数化数据提供者，可以是AbsractDataProvider的子类或者一个可调用的对象，返回数据集列表（当测试方法只有一个参数化时，应返回一维列表，多个参数化时返回二维列表），必须接收两个固定位置参数，变长位置参数(args)和变长关键字参数(kwargs)，固定位置参数，第一个是测试类名，第二个是测试方法名。

* 返回值
    > 返回测试方法的参数化测试数据列表
    >- 测试方法只有一个参数化时, 返回一维列表 如: demotest(self, testdata), data provider 返回 [{'name':'zhansan', 'age':17}, {'name':'xiaoming', 'age':18}]，方法demotest会执行两次，第一次参数testdata是：{'name':'zhansan', 'age':17}，
    第二次则是：{'name':'xiaoming', 'age':18}
    >- 测试方法有多个参数化时，返回二维列表 如: demotest(self, name, age), data provider 返回 [['zhansan', 17], ['xiaoming', 18]], 方法demotest会执行两次，第一次参数name和age的值分别是：'zhansan', 18，
    第二次则是：'xiaoming', 18

* 实现方式
    >- 继承AbsractDataProvider，实现get_testdatas(self, test_class_name, test_method_name, *args, **kwargs)方法
    >- 其他类型的类似接收以下参数的可调用对象 ------> get_testdatas(test_class_name, test_method_name, *args, **kwargs)

* 使用
    > 通过测试方法装饰器Test参数data_provider来设置为自己的数据提供者（data provider）, 参数data_provider_args和data_provider_kwargs分别用来传给数据提供者（data provider）对应的变长位置参数(args)和变长关键字参数(kwargs)

* 示例
    > 继承自AbsractDataProvider的数据提供者示例(来自内置数据提供者 - SevenDataProvider)
    ```python
    #!/usr/bin/env python
    # -*- encoding: utf-8 -*-
    '''
    @Author: 思文伟
    '''

    import os
    from stest import utils
    from stest.attrs_marker import AttributeMarker
    from stest.abstract_data_provider import AbsractDataProvider
    from stest.excel_file_reader import TestCaseExcelFileReader as ExcelReader


    class SevenDataProvider(AbsractDataProvider):

        FILE_EXT = AttributeMarker(".xlsx", True, "数据文件拓展名")
        BLOCK_FLAG = AttributeMarker("用例名称", True, "用例分隔标记")
        DEFAULT_SHEET_INDEX = AttributeMarker(0, True, "默认从索引为0的工作表读取数据")

        # get_datasets方法变长字典参数kwargs接收的参数的键名
        PARAM_DATA_FILE_NAME = AttributeMarker("data_file_name", True, "数据文件名称参数")
        PARAM_DATA_FILE_DIR_PATH = AttributeMarker("data_file_dir_path", True, "数据文件所在目录路径参数")
        PARAM_SHEET_NAME_OR_INDEX = AttributeMarker("sheet_name_or_index", True, "数据文件中数据所在的工作表索引(从0开始)或名称参数")
        KWARGS_NAMES = AttributeMarker((PARAM_DATA_FILE_NAME, PARAM_DATA_FILE_DIR_PATH, PARAM_SHEET_NAME_OR_INDEX), True, "接收的参数名")

        def _get_data_file_name(self, kwargs, default_value=None):

            param = self.PARAM_DATA_FILE_NAME
            filename = kwargs.get(param, default_value)
            if utils.is_blank_space(filename):
                raise ValueError("数据文件名必须是字符串类型且不能为空")
            return filename

        def _get_data_file_dir_paht(self, kwargs):

            param = self.PARAM_DATA_FILE_DIR_PATH
            if param not in kwargs.keys():
                raise AttributeError("没有传入数据文件目录")
            dirpath = kwargs[param]
            if utils.is_blank_space(dirpath):
                raise ValueError("数据文件目录必须是字符串类型且不能为空")
            return dirpath

        def _get_sheet_name_or_index(self, kwargs):
            return kwargs.get(self.PARAM_SHEET_NAME_OR_INDEX, self.DEFAULT_SHEET_INDEX)

        def _build_file_full_path(self, data_file_dir_path, data_file_name):
            """构建完整的excel数据文件路径

            Args:
                data_file_dir_path: 文件目录
                data_file_name: 文件名称
            """

            name = data_file_name
            ext = self.FILE_EXT
            if utils.is_blank_space(data_file_dir_path):
                raise ValueError("传入的数据文件目录路径不能为空：{}".format(data_file_dir_path))
            dir_path = data_file_dir_path
            if name and not utils.is_blank_space(name):
                full_name = name if name.endswith(ext) else name + ext
            else:
                raise ValueError("无效数据文件名称：{}".format(name))
            return os.path.join(dir_path, full_name)

        def get_testdatas(self, test_class_name, test_method_name, *args, **kwargs):
            """根据文件名从指定的excel文件(xlsx文件格式)读取出数据, 返回一维列表，每个元素是excel表中一行测试数据信息字典.
            eg: [{"减数1": "36", "减数2": "10", "预期": "26"}, {"减数1": "57", "减数2": "30", "预期": "27"}]

            Args:
                kwargs:
                    file_name 数据文件名, 不提供则测试类名称作为文件名
                    file_dir_path 数据文件所在目录路径
                    sheet_index_or_name Excel工作表索引(从0开始)或名称,不提供则默认取索引0的工作表
            """

            datasets = []

            filename = self._get_data_file_name(kwargs, test_class_name)
            dirpath = self._get_data_file_dir_paht(kwargs)
            full_file_path = self._build_file_full_path(dirpath, filename)

            reader = ExcelReader(full_file_path, testcase_block_separators=self.BLOCK_FLAG, sheet_index_or_name=self._get_sheet_name_or_index(kwargs))
            datas_blocks = reader.load_testcase_data()
            for block in datas_blocks:
                if block.name == test_method_name:
                    for row in block.datas:
                        line = {}
                        for cell in row:
                            for title, value in cell.items():
                                if title in line.keys():
                                    continue
                                else:
                                    line[title] = value
                        datasets.append(line)
                    break
            return datasets


    class CalculationTest(AbstractTestCase):
        @classmethod
        def setUpClass(cls):
            pass

        def setUp(self):
            pass

        @testcase(priority=1, enabled=True, data_provider=SevenDataProvider, data_provider_kwargs={'data_file_dir_path':'E:\\mytestdatas'}, author='思文伟', description='整数加法测试01')
        def integer_addition_01(self, testdata):
            """自定义数据提供者 - 测试方法一个参数化示例"""

            number_1 = testdata.get("加数1")
            number_2 = testdata.get("加数2")
            expected = testdata.get("预期")

            result = number_1 + number_2
            self.assertEqual(result, expected)

        def tearDown(self):
            pass

        @classmethod
        def tearDownClass(cls):
            pass

    if __name__ == '__main__':
        CalculationTest.run_test()

    ```

    > 非AbsractDataProvider子类数据提供者示例
    ```python
    #!/usr/bin/env python
    # -*- encoding: utf-8 -*-
    '''
    @Author: 思文伟
    '''

    from stest import AbstractTestCase
    from stest import Test as testcase


    class Demo1DataProvider(object):

        def get_testdatas(self, test_class_name, test_method_name, *args, **kwargs):

            return [[1,2,3],[3,4,7]]


    class Demo1Test(AbstractTestCase):

        @testcase(priority=1, enabled=True, data_provider=Demo1DataProvider().get_testdatas, author='思文伟', description='两数加法测试01')
        def integer_addition_02(self, number_1, number_2, expected):

            result = number_1 + number_2
            self.assertEqual(result, expected)

    if __name__ == '__main__':

        Demo1Test.run_test()
    ```

    > 函数数据提供者示例
    ```python
    #!/usr/bin/env python
    # -*- encoding: utf-8 -*-
    '''
    @Author: 思文伟
    '''

    from stest import AbstractTestCase
    from stest import Test as testcase


    def get_testdatas(test_class_name, test_method_name, *args, **kwargs):

        return [[1,2,3], [3,4,7]]


    class Demo1Test(AbstractTestCase):

        @testcase(priority=1, enabled=True, data_provider=get_testdatas, author='思文伟', description='两数加法测试01')
        def integer_addition_02(self, number_1, number_2, expected):

            result = number_1 + number_2
            self.assertEqual(result, expected)

    if __name__ == '__main__':

        Demo1Test.run_test()
    ```
