"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmtpCredentialsProvider = void 0;
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class SmtpCredentialsProvider extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.serviceToken = new aws_cdk_lib_1.custom_resources.Provider(this, "SmtpCredentialsProvider", {
            onEventHandler: new aws_cdk_lib_1.aws_lambda.Function(this, "SmtpCredentialsFunction", {
                code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, "../function")),
                runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_8,
                handler: "handler.on_event",
                initialPolicy: [
                    new aws_cdk_lib_1.aws_iam.PolicyStatement({
                        effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                        actions: ["iam:CreateAccessKey"],
                        resources: [props.userArn],
                    }),
                ],
            }),
            logRetention: aws_cdk_lib_1.aws_logs.RetentionDays.ONE_DAY,
        }).serviceToken;
    }
}
exports.SmtpCredentialsProvider = SmtpCredentialsProvider;
//# sourceMappingURL=data:application/json;base64,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