/*
 * Decompiled with CFR 0.152.
 */
package com.clicknium.customaccessiblecomponent.YonYou.ReportTable;

import com.clicknium.customaccessiblecomponent.Common.ClickniumAccessibleComponent;
import com.clicknium.customaccessiblecomponent.Common.ClickniumAccessibleRole;
import com.clicknium.utils.ReflectionUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClickniumOverrideAccessibleNCTableHeader
extends ClickniumAccessibleComponent {
    private Object headerModel;
    private ClickniumAccessibleRole role;
    private int headerCellCount = -1;
    private static Class<?> tableUtilities;

    public ClickniumOverrideAccessibleNCTableHeader(Object object, ClickniumAccessibleRole role) {
        super(object);
        this.role = role;
    }

    @Override
    public AccessibleRole getAccessibleRole() {
        return this.role;
    }

    @Override
    public Accessible getAccessibleChild(int index) {
        return new ClickniumAccessibleTableHeaderCell(null, index);
    }

    @Override
    public int getAccessibleChildrenCount() {
        return this.getCount();
    }

    private Object getHeaderModel() {
        if (this.headerModel == null) {
            this.headerModel = ReflectionUtil.InvokeMethod(this.getSource(), "getModel");
        }
        return this.headerModel;
    }

    private Integer getHeaderType() {
        Object typeResult = ReflectionUtil.InvokeMethod(this.getSource(), "getType");
        if (typeResult != null) {
            return ((Number)typeResult).intValue();
        }
        return -1;
    }

    private Integer getCount() {
        Object countResult;
        Object headerModel;
        if (this.headerCellCount < 0 && (headerModel = this.getHeaderModel()) != null && (countResult = ReflectionUtil.InvokeMethod(headerModel, "getCount")) != null) {
            this.headerCellCount = ((Number)countResult).intValue();
        }
        return this.headerCellCount;
    }

    private Rectangle getHeaderCellRectangle(int index) {
        if (index >= 0 && index < this.getCount()) {
            return (Rectangle)ReflectionUtil.InvokeMethod(this.getSource(), "getHeaderRect", new Object[]{index});
        }
        return null;
    }

    private String getCellText(int index) {
        if (this.getHeaderType() == 0) {
            return (String)this.InvokeTableUtilities("getRowName", index);
        }
        return (String)this.InvokeTableUtilities("getColName", index);
    }

    private Class<?> getTableUtilitiesClass() {
        if (tableUtilities == null) {
            try {
                tableUtilities = Class.forName("com.ufsoft.table.TableUtilities", true, this.source.getClass().getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return tableUtilities;
    }

    private Object InvokeTableUtilities(String methodName, Object ... args) {
        try {
            Method method;
            Class<?> tableUtilites = this.getTableUtilitiesClass();
            if (tableUtilites != null && (method = tableUtilites.getMethod(methodName, Integer.TYPE)) != null) {
                return method.invoke(null, args);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public class ClickniumAccessibleTableHeaderCell
    extends ClickniumAccessibleComponent {
        private int index;

        public ClickniumAccessibleTableHeaderCell(Object object, int index) {
            super(object);
            this.index = index;
        }

        public AccessibleRole getAccessibleRole() {
            return ClickniumAccessibleRole.LABEL;
        }

        public String getAccessibleName() {
            return this.getText();
        }

        public Rectangle getBounds() {
            return ClickniumOverrideAccessibleNCTableHeader.this.getHeaderCellRectangle(this.index);
        }

        public Point getLocationOnScreen() {
            Point parentLocation = ClickniumOverrideAccessibleNCTableHeader.this.getLocationOnScreen();
            if (parentLocation != null) {
                parentLocation.x += this.getBounds().x;
                parentLocation.y += this.getBounds().y;
            }
            return parentLocation;
        }

        public Accessible getAccessibleParent() {
            return ClickniumOverrideAccessibleNCTableHeader.this;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return ClickniumOverrideAccessibleNCTableHeader.this.getAccessibleStateSet();
        }

        protected String getText() {
            return ClickniumOverrideAccessibleNCTableHeader.this.getCellText(this.index);
        }
    }
}

