/*
 * Decompiled with CFR 0.152.
 */
package com.clicknium.customaccessiblecomponent.KingDee.Report;

import com.clicknium.customaccessiblecomponent.Common.ClickniumAccessibleComponent;
import com.clicknium.customaccessiblecomponent.Common.ClickniumAccessibleRole;
import com.clicknium.utils.ReflectionUtil;
import java.awt.Point;
import java.awt.Rectangle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;

public class ClickniumAccessibleKDTabbedBar
extends ClickniumAccessibleComponent {
    private int arrowWidth = -1;

    public ClickniumAccessibleKDTabbedBar(Object component) {
        super(component);
    }

    public AccessibleRole getAccessibleRole() {
        return ClickniumAccessibleRole.KD_TABBED_BAR;
    }

    public int getAccessibleChildrenCount() {
        return this.getTabCount() + 4;
    }

    public Accessible getAccessibleChild(int index) {
        if (index > 3) {
            return new ClickniumAccessibleKDTabbedBarItem(index, ClickniumAccessibleRole.KD_TABBED_BAR_TAB);
        }
        return new ClickniumAccessibleKDTabbedBarItem(index, ClickniumAccessibleRole.KD_TABBED_BAR_ARROW);
    }

    private int getTabCount() {
        Object tabCountObject = ReflectionUtil.InvokeDeclaredMethod(this.source, "getTabCount");
        if (tabCountObject != null) {
            return ((Number)tabCountObject).intValue();
        }
        return 0;
    }

    private int getArrowWidth() {
        Object arrowWidthObject;
        if (this.arrowWidth < 0 && (arrowWidthObject = ReflectionUtil.InvokeDeclaredMethod(this.source, "getArrowWidth")) != null) {
            return ((Number)arrowWidthObject).intValue();
        }
        return this.arrowWidth;
    }

    private int getTabWidth(int index) {
        Object tabWidthObject = ReflectionUtil.InvokeDeclaredMethod(this.source, "getTabWidth", new Object[]{index});
        if (tabWidthObject != null) {
            return ((Number)tabWidthObject).intValue();
        }
        return 0;
    }

    private int getTabStartX(int index) {
        Object tabStartXObject = ReflectionUtil.InvokeDeclaredMethod(this.source, "getTabStartX", new Object[]{index});
        if (tabStartXObject != null) {
            return ((Number)tabStartXObject).intValue();
        }
        return 0;
    }

    private String getTabName(int index) {
        return (String)ReflectionUtil.InvokeDeclaredMethod(this.source, "getTitleAt", new Object[]{index});
    }

    private Rectangle getTabbedBarItemRectangle(int index) {
        Rectangle bounds = new Rectangle();
        if (index < 4) {
            bounds.width = this.getArrowWidth();
            bounds.height = this.getArrowWidth();
            bounds.x = this.getArrowWidth() * index;
        } else {
            bounds.width = this.getTabWidth(index - 4);
            bounds.height = this.getArrowWidth();
            bounds.x = this.getTabStartX(index - 4);
        }
        return bounds;
    }

    public class ClickniumAccessibleKDTabbedBarItem
    extends ClickniumAccessibleComponent {
        private int indexInParent;
        private AccessibleRole role;

        public ClickniumAccessibleKDTabbedBarItem(int index, AccessibleRole role) {
            super(null);
            this.indexInParent = index;
            this.role = role;
        }

        public String getAccessibleName() {
            if (this.role.equals(ClickniumAccessibleRole.KD_TABBED_BAR_TAB)) {
                return ClickniumAccessibleKDTabbedBar.this.getTabName(this.indexInParent - 4);
            }
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return this.role;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return ClickniumAccessibleKDTabbedBar.this.getAccessibleStateSet();
        }

        public Accessible getAccessibleParent() {
            return ClickniumAccessibleKDTabbedBar.this;
        }

        public int getAccessibleIndexInParent() {
            return this.indexInParent;
        }

        public Point getLocationOnScreen() {
            Rectangle cellRectangle = ClickniumAccessibleKDTabbedBar.this.getTabbedBarItemRectangle(this.indexInParent);
            Point parentPosition = ClickniumAccessibleKDTabbedBar.this.getLocationOnScreen();
            parentPosition.x += cellRectangle.x;
            parentPosition.y += cellRectangle.y;
            return parentPosition;
        }

        public Rectangle getBounds() {
            return ClickniumAccessibleKDTabbedBar.this.getTabbedBarItemRectangle(this.indexInParent);
        }
    }
}

