/*
 * Decompiled with CFR 0.152.
 */
package com.clicknium;

import com.clicknium._AccessibleState;
import com.clicknium.customaccessiblecomponent.Common.ClickniumAccessibleComponent;
import com.clicknium.customaccessiblecomponent.Common.ClickniumAccessibleComponentFactory;
import com.clicknium.customaccessiblecomponent.Override.ClickniumOverrideAccessible;
import com.clicknium.utils.EventDispatchThreadResult;
import com.clicknium.utils.EventQueueInvokeUtil;
import com.sun.java.accessibility.util.AWTEventMonitor;
import com.sun.java.accessibility.util.AccessibilityEventMonitor;
import com.sun.java.accessibility.util.EventQueueMonitor;
import com.sun.java.accessibility.util.SwingEventMonitor;
import com.sun.java.accessibility.util.Translator;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleExtendedComponent;
import javax.accessibility.AccessibleExtendedTable;
import javax.accessibility.AccessibleHyperlink;
import javax.accessibility.AccessibleHypertext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleKeyBinding;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleTable;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.TreeUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabSet;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClickniumJavaBridge {
    public static final String ClickniumJavaBridgeVersion = "1.0.0.0";
    private static boolean nativeBridgeLoaded = false;
    private static boolean debugEnable = false;
    public static ClickniumJavaBridge theClickniumJavaBridge;
    private ObjectReferences references;
    private EventHandler eventHandler;
    private boolean runningOnJDK1_4 = false;
    private boolean runningOnJDK1_5 = false;
    private boolean useJAWT_DLL = false;
    private Hashtable accessibleRoleMap = new Hashtable();
    private ArrayList extendedVirtualNameSearchRoles = new ArrayList();
    private ArrayList noExtendedVirtualNameSearchParentRoles = new ArrayList();
    private ArrayList searchInContainerChildrenRoles = new ArrayList();
    private Method javaGetComponentFromNativeWindowHandleMethod;
    private Method javaGetNativeWindowHandleFromComponentMethod;
    Toolkit toolkit;
    private static Hashtable windowHandleToContextMap;
    private static Hashtable contextToWindowHandleMap;
    private static Vector nativeWindowHandlers;
    Hashtable hashtab = new Hashtable();
    private int _visibleChildrenCount;
    private AccessibleContext _visibleChild;
    private int _currentVisibleIndex;
    private boolean _foundVisibleChild;
    public static final long PROPERTY_CHANGE_EVENTS = 1L;
    public static final long FOCUS_GAINED_EVENTS = 2L;
    public static final long FOCUS_LOST_EVENTS = 4L;
    public static final long FOCUS_EVENTS = 6L;
    public static final long CARET_UPATE_EVENTS = 8L;
    public static final long CARET_EVENTS = 8L;
    public static final long MOUSE_CLICKED_EVENTS = 16L;
    public static final long MOUSE_ENTERED_EVENTS = 32L;
    public static final long MOUSE_EXITED_EVENTS = 64L;
    public static final long MOUSE_PRESSED_EVENTS = 128L;
    public static final long MOUSE_RELEASED_EVENTS = 256L;
    public static final long MOUSE_EVENTS = 496L;
    public static final long MENU_CANCELED_EVENTS = 512L;
    public static final long MENU_DESELECTED_EVENTS = 1024L;
    public static final long MENU_SELECTED_EVENTS = 2048L;
    public static final long MENU_EVENTS = 3584L;
    public static final long POPUPMENU_CANCELED_EVENTS = 4096L;
    public static final long POPUPMENU_WILL_BECOME_INVISIBLE_EVENTS = 8192L;
    public static final long POPUPMENU_WILL_BECOME_VISIBLE_EVENTS = 16384L;
    public static final long POPUPMENU_EVENTS = 28672L;
    public static final long PROPERTY_NAME_CHANGE_EVENTS = 1L;
    public static final long PROPERTY_DESCRIPTION_CHANGE_EVENTS = 2L;
    public static final long PROPERTY_STATE_CHANGE_EVENTS = 4L;
    public static final long PROPERTY_VALUE_CHANGE_EVENTS = 8L;
    public static final long PROPERTY_SELECTION_CHANGE_EVENTS = 16L;
    public static final long PROPERTY_TEXT_CHANGE_EVENTS = 32L;
    public static final long PROPERTY_CARET_CHANGE_EVENTS = 64L;
    public static final long PROPERTY_VISIBLEDATA_CHANGE_EVENTS = 128L;
    public static final long PROPERTY_CHILD_CHANGE_EVENTS = 256L;
    public static final long PROPERTY_ACTIVEDESCENDENT_CHANGE_EVENTS = 512L;
    public static final long PROPERTY_EVENTS = 1023L;
    private AccessibleRole[] allAccessibleRoles = new AccessibleRole[]{AccessibleRole.ALERT, AccessibleRole.COLUMN_HEADER, AccessibleRole.CANVAS, AccessibleRole.COMBO_BOX, AccessibleRole.DESKTOP_ICON, AccessibleRole.INTERNAL_FRAME, AccessibleRole.DESKTOP_PANE, AccessibleRole.OPTION_PANE, AccessibleRole.WINDOW, AccessibleRole.FRAME, AccessibleRole.DIALOG, AccessibleRole.COLOR_CHOOSER, AccessibleRole.DIRECTORY_PANE, AccessibleRole.FILE_CHOOSER, AccessibleRole.FILLER, AccessibleRole.ICON, AccessibleRole.LABEL, AccessibleRole.ROOT_PANE, AccessibleRole.GLASS_PANE, AccessibleRole.LAYERED_PANE, AccessibleRole.LIST, AccessibleRole.LIST_ITEM, AccessibleRole.MENU_BAR, AccessibleRole.POPUP_MENU, AccessibleRole.MENU, AccessibleRole.MENU_ITEM, AccessibleRole.SEPARATOR, AccessibleRole.PAGE_TAB_LIST, AccessibleRole.PAGE_TAB, AccessibleRole.PANEL, AccessibleRole.PROGRESS_BAR, AccessibleRole.PASSWORD_TEXT, AccessibleRole.PUSH_BUTTON, AccessibleRole.TOGGLE_BUTTON, AccessibleRole.CHECK_BOX, AccessibleRole.RADIO_BUTTON, AccessibleRole.ROW_HEADER, AccessibleRole.SCROLL_PANE, AccessibleRole.SCROLL_BAR, AccessibleRole.VIEWPORT, AccessibleRole.SLIDER, AccessibleRole.SPLIT_PANE, AccessibleRole.TABLE, AccessibleRole.TEXT, AccessibleRole.TREE, AccessibleRole.TOOL_BAR, AccessibleRole.TOOL_TIP, AccessibleRole.AWT_COMPONENT, AccessibleRole.SWING_COMPONENT, AccessibleRole.UNKNOWN};

    public static void agentmain(String agentArgs, Instrumentation inst) throws Exception {
        if (nativeBridgeLoaded) {
            return;
        }
        System.out.println("Start init ClickniumJavaBridge");
        ClickniumJavaBridge.main(null);
        System.out.println("ClickniumJavaBridge loaded by agent injection");
    }

    public static void main(String[] args) {
        new ClickniumJavaBridge();
    }

    public ClickniumJavaBridge() {
        nativeBridgeLoaded = true;
        theClickniumJavaBridge = this;
        this.references = new ObjectReferences();
        Runtime runTime = Runtime.getRuntime();
        shutdownHook hook = new shutdownHook();
        runTime.addShutdownHook(new Thread(hook));
        this.initAccessibleRoleMap();
        String version = this.getJavaVersionProperty();
        this.debugString("JDK version = " + version);
        this.useJAWT_DLL = version.compareTo("1.4.1") >= 0;
        this.runningOnJDK1_4 = version.compareTo("1.4") >= 0;
        boolean bl = this.runningOnJDK1_5 = version.compareTo("1.5") >= 0;
        if (this.useJAWT_DLL) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        System.loadLibrary("JAWT");
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    try {
                        System.load(ClickniumJavaBridge.GetNativeLibPath("ClickniumJAWTBridge"));
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            });
        }
        if (this.initHWNDcalls()) {
            EventQueueMonitor.isGUIInitialized();
            this.eventHandler = new EventHandler(this);
            if (this.runningOnJDK1_4) {
                MenuSelectionManager.defaultManager().addChangeListener(this.eventHandler);
            }
            ClickniumJavaBridge.addNativeWindowHandler(new DefaultNativeWindowHandler());
            Thread abthread = new Thread(new dllRunner());
            abthread.setDaemon(true);
            abthread.start();
            this.debugString("ClickniumJavaBridge started");
        } else {
            this.debugString("Cannot load the ClickniumJavaBridge - couldn't init HWND calls");
        }
    }

    private void initAccessibleRoleMap() {
        try {
            Class<?> clAccessibleRole = Class.forName("javax.accessibility.AccessibleRole");
            if (null != clAccessibleRole) {
                AccessibleRole roleUnknown = AccessibleRole.UNKNOWN;
                Field[] fields = clAccessibleRole.getFields();
                int i = 0;
                for (i = 0; i < fields.length; ++i) {
                    Field f = fields[i];
                    if (AccessibleRole.class != f.getType()) continue;
                    AccessibleRole nextRole = (AccessibleRole)f.get(roleUnknown);
                    String nextRoleString = nextRole.toDisplayString(Locale.US);
                    this.accessibleRoleMap.put(nextRoleString, nextRole);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.COMBO_BOX);
        try {
            this.extendedVirtualNameSearchRoles.add(AccessibleRole.DATE_EDITOR);
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.LIST);
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.PASSWORD_TEXT);
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.SLIDER);
        try {
            this.extendedVirtualNameSearchRoles.add(AccessibleRole.SPIN_BOX);
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.TABLE);
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.TEXT);
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.UNKNOWN);
        this.noExtendedVirtualNameSearchParentRoles.add(AccessibleRole.TABLE);
        this.noExtendedVirtualNameSearchParentRoles.add(AccessibleRole.TOOL_BAR);
        this.searchInContainerChildrenRoles.add(AccessibleRole.PANEL);
        this.searchInContainerChildrenRoles.add(AccessibleRole.GLASS_PANE);
        this.searchInContainerChildrenRoles.add(AccessibleRole.ROOT_PANE);
        this.searchInContainerChildrenRoles.add(AccessibleRole.SCROLL_PANE);
        this.searchInContainerChildrenRoles.add(AccessibleRole.VIEWPORT);
        this.searchInContainerChildrenRoles.add(AccessibleRole.FRAME);
        this.searchInContainerChildrenRoles.add(AccessibleRole.WINDOW);
        this.searchInContainerChildrenRoles.add(AccessibleRole.DIALOG);
        this.searchInContainerChildrenRoles.add(AccessibleRole.LAYERED_PANE);
        this.searchInContainerChildrenRoles.add(AccessibleRole.SPLIT_PANE);
        try {
            this.searchInContainerChildrenRoles.add(AccessibleRole.GROUP_BOX);
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        this.searchInContainerChildrenRoles.add(AccessibleRole.UNKNOWN);
    }

    public native void runDLL();

    public native void sendDebugString(String var1);

    public void debugString(String debugStr) {
        if (debugEnable) {
            this.sendDebugString(debugStr);
        }
    }

    public static void setDebugTrace(boolean flag) {
        debugEnable = flag;
    }

    public void decrementReference(Object o) {
        this.references.decrement(o);
    }

    public String getJavaVersionProperty() {
        String s = System.getProperty("java.version");
        if (s != null) {
            this.references.increment(s);
            return s;
        }
        return null;
    }

    public String getAccessBridgeVersion() {
        String s = ClickniumJavaBridgeVersion;
        this.references.increment(s);
        return s;
    }

    public native int isJAWTInstalled();

    public native int jawtGetNativeWindowHandleFromComponent(Component var1);

    public native Component jawtGetComponentFromNativeWindowHandle(int var1);

    public boolean initHWNDcalls() {
        Class[] integerParemter = new Class[]{Integer.TYPE};
        Class[] componentParemter = new Class[1];
        try {
            componentParemter[0] = Class.forName("java.awt.Component");
        }
        catch (ClassNotFoundException e) {
            this.debugString("Exception: " + e.toString());
        }
        Object[] args = new Object[1];
        boolean returnVal = false;
        this.toolkit = Toolkit.getDefaultToolkit();
        if (this.useJAWT_DLL) {
            returnVal = true;
        } else {
            try {
                this.javaGetComponentFromNativeWindowHandleMethod = this.toolkit.getClass().getMethod("getComponentFromNativeWindowHandle", integerParemter);
                if (this.javaGetComponentFromNativeWindowHandleMethod != null) {
                    try {
                        args[0] = new Integer(1);
                        Component c = (Component)this.javaGetComponentFromNativeWindowHandleMethod.invoke((Object)this.toolkit, args);
                        returnVal = true;
                    }
                    catch (InvocationTargetException e) {
                        this.debugString("Exception: " + e.toString());
                    }
                    catch (IllegalAccessException e) {
                        this.debugString("Exception: " + e.toString());
                    }
                }
            }
            catch (NoSuchMethodException e) {
                this.debugString("Exception: " + e.toString());
            }
            catch (SecurityException e) {
                this.debugString("Exception: " + e.toString());
            }
            try {
                this.javaGetNativeWindowHandleFromComponentMethod = this.toolkit.getClass().getMethod("getNativeWindowHandleFromComponent", componentParemter);
                if (this.javaGetNativeWindowHandleFromComponentMethod != null) {
                    try {
                        args[0] = new Button("OK");
                        Integer i = (Integer)this.javaGetNativeWindowHandleFromComponentMethod.invoke((Object)this.toolkit, args);
                        returnVal = true;
                    }
                    catch (InvocationTargetException e) {
                        this.debugString("Exception: " + e.toString());
                    }
                    catch (IllegalAccessException e) {
                        this.debugString("Exception: " + e.toString());
                    }
                    catch (Exception e) {
                        this.debugString("Exception: " + e.toString());
                    }
                }
            }
            catch (NoSuchMethodException e) {
                this.debugString("Exception: " + e.toString());
            }
            catch (SecurityException e) {
                this.debugString("Exception: " + e.toString());
            }
        }
        return returnVal;
    }

    public static void registerVirtualFrame(Accessible a, Integer nativeWindowHandle) {
        if (a != null) {
            windowHandleToContextMap.put(nativeWindowHandle, a.getAccessibleContext());
            contextToWindowHandleMap.put(a.getAccessibleContext(), nativeWindowHandle);
        }
    }

    public static void revokeVirtualFrame(Accessible a, Integer nativeWindowHandle) {
        windowHandleToContextMap.remove(nativeWindowHandle);
        contextToWindowHandleMap.remove(a.getAccessibleContext());
    }

    public static void addNativeWindowHandler(NativeWindowHandler handler) {
        theClickniumJavaBridge.debugString("addNativeWindowHandler=" + handler.getClass());
        if (handler == null) {
            throw new IllegalArgumentException();
        }
        nativeWindowHandlers.addElement(handler);
    }

    public static boolean removeNativeWindowHandler(NativeWindowHandler handler) {
        theClickniumJavaBridge.debugString("removeNativeWindowHandler=" + handler.getClass());
        if (handler == null) {
            throw new IllegalArgumentException();
        }
        return nativeWindowHandlers.removeElement(handler);
    }

    public boolean isJavaWindow(int nativeHandle) {
        AccessibleContext ac = this.getContextFromNativeWindowHandle(nativeHandle);
        if (ac != null) {
            this.saveContextToWindowHandleMapping(ac, nativeHandle);
            return true;
        }
        return false;
    }

    private void saveContextToWindowHandleMapping(AccessibleContext ac, int nativeHandle) {
        this.debugString("saveContextToWindowHandleMapping...");
        if (ac == null) {
            return;
        }
        if (!contextToWindowHandleMap.containsKey(ac)) {
            this.debugString("saveContextToWindowHandleMapping: ac = " + ac + "; handle = " + nativeHandle);
            contextToWindowHandleMap.put(ac, new Integer(nativeHandle));
        }
    }

    public AccessibleContext getContextFromNativeWindowHandle(int nativeHandle) {
        Object o = windowHandleToContextMap.get(new Integer(nativeHandle));
        if (o instanceof AccessibleContext) {
            this.saveContextToWindowHandleMapping((AccessibleContext)o, nativeHandle);
            return (AccessibleContext)o;
        }
        int numHandlers = nativeWindowHandlers.size();
        for (int i = 0; i < numHandlers; ++i) {
            NativeWindowHandler nextHandler = (NativeWindowHandler)nativeWindowHandlers.elementAt(i);
            Accessible a = nextHandler.getAccessibleFromNativeWindowHandle(nativeHandle);
            if (a == null) continue;
            this.saveContextToWindowHandleMapping(a.getAccessibleContext(), nativeHandle);
            return a.getAccessibleContext();
        }
        return null;
    }

    public int getNativeWindowHandleFromContext(AccessibleContext ac) {
        this.debugString("getNativeWindowHandleFromContext: ac = " + ac);
        Enumeration keys = contextToWindowHandleMap.keys();
        while (keys.hasMoreElements()) {
            this.debugString(" next elem = " + keys.nextElement());
        }
        Object o = contextToWindowHandleMap.get(ac);
        if (o instanceof Integer) {
            this.debugString(" returning (success) " + (Integer)o);
            return (Integer)o;
        }
        this.debugString(" returning (failure) 0");
        return 0;
    }

    public int getNativeWindowHandleFromComponent(Component target) {
        if (this.useJAWT_DLL) {
            this.debugString("*** calling jawtGetNativeWindowHandleFromComponent");
            return this.jawtGetNativeWindowHandleFromComponent(target);
        }
        Object[] args = new Object[1];
        this.debugString("*** calling javaGetNativeWindowHandleFromComponent");
        if (this.javaGetNativeWindowHandleFromComponentMethod != null) {
            try {
                args[0] = target;
                Integer i = (Integer)this.javaGetNativeWindowHandleFromComponentMethod.invoke((Object)this.toolkit, args);
                contextToWindowHandleMap.put(target.getAccessibleContext(), i);
                return i;
            }
            catch (InvocationTargetException e) {
                this.debugString("Exception: " + e.toString());
            }
            catch (IllegalAccessException e) {
                this.debugString("Exception: " + e.toString());
            }
        }
        return -1;
    }

    public AccessibleContext getAccessibleContextAt(int x, int y, AccessibleContext parent) {
        if (parent == null) {
            return null;
        }
        if (windowHandleToContextMap != null && windowHandleToContextMap.containsValue(this.getRootAccessibleContext(parent))) {
            return this.getAccessibleContextAt_1(x, y, parent);
        }
        return this.getAccessibleContextAt_2(x, y, parent);
    }

    private AccessibleContext getRootAccessibleContext(AccessibleContext ac) {
        if (ac == null) {
            return null;
        }
        Accessible parent = ac.getAccessibleParent();
        if (parent == null) {
            return ac;
        }
        Accessible tmp = parent.getAccessibleContext().getAccessibleParent();
        while (tmp != null) {
            parent = tmp;
            tmp = parent.getAccessibleContext().getAccessibleParent();
        }
        return parent.getAccessibleContext();
    }

    public AccessibleContext getAccessibleContextAt_1(int x, int y, AccessibleContext parent) {
        AccessibleComponent acmp;
        this.debugString(" : getAccessibleContextAt_1 called");
        this.debugString("   -> x = " + x + " y = " + y + " parent = " + parent);
        if (parent != null && (acmp = parent.getAccessibleComponent()) != null) {
            AccessibleContext foundAC;
            Point loc = acmp.getLocation();
            Accessible a = acmp.getAccessibleAt(new Point(x - loc.x, y - loc.y));
            if (a != null && (foundAC = a.getAccessibleContext()) != null) {
                if (foundAC != parent) {
                    return this.getAccessibleContextAt_1(x - loc.x, y - loc.y, foundAC);
                }
                this.debugString("   returning ac = " + foundAC);
                return foundAC;
            }
        }
        return parent;
    }

    public AccessibleContext getAccessibleContextAt_2(int x, int y, AccessibleContext parent) {
        AccessibleContext childAC;
        this.debugString("getAccessibleContextAt_2 called");
        this.debugString("   -> x = " + x + " y = " + y + " parent = " + parent);
        Accessible a = EventQueueMonitor.getAccessibleAt(new Point(x, y));
        if (a != null && (childAC = a.getAccessibleContext()) != null) {
            this.debugString("   returning childAC = " + childAC);
            return childAC;
        }
        this.debugString("returning AccessibleContext = null");
        return null;
    }

    public AccessibleContext[] getAccessibleContextFromPoint(final int x, final int y, final int windowHandle) {
        this.debugString("Enter into getAccessibleContextFromPoint, x: " + x + " y: " + y + " windowHandle: " + windowHandle);
        try {
            if (!EventQueue.isDispatchThread()) {
                final EventDispatchThreadResult eventDispatchThreadResult = new EventDispatchThreadResult();
                EventQueueInvokeUtil.invokeAndWait(new Runnable(){

                    public void run() {
                        eventDispatchThreadResult.result = ClickniumJavaBridge.this.getAccessibleContextFromPoint(x, y, windowHandle);
                    }
                }, this.getContextFromNativeWindowHandle(windowHandle));
                if (eventDispatchThreadResult.result != null) {
                    return (AccessibleContext[])eventDispatchThreadResult.result;
                }
                return null;
            }
            AccessibleContext windowsAccessibleContext = this.getContextFromNativeWindowHandle(windowHandle);
            if (windowsAccessibleContext == null) {
                this.debugString("can not get context from window handle : " + windowHandle);
                return null;
            }
            ArrayList<AccessibleContext> result = this.getChildrenAccessibleContextFromPoint(new Point(x, y), windowsAccessibleContext);
            return result.toArray(new AccessibleContext[result.size()]);
        }
        catch (Exception e) {
            this.debugString("error occured in getAccessibleContextFromPoint :" + e.getMessage() + ", StackTrace: " + e.getStackTrace());
            return null;
        }
    }

    private ArrayList<AccessibleContext> getChildrenAccessibleContextFromPoint(Point point, AccessibleContext parentContext) {
        ArrayList<AccessibleContext> result;
        block16: {
            AccessibleRole parenrRole;
            block15: {
                if (parentContext == null) {
                    this.debugString("getChildrenAccessibleContextFromPoint parent is null !");
                    return null;
                }
                if (!parentContext.getAccessibleStateSet().contains(AccessibleState.SHOWING)) {
                    this.debugString("getChildrenAccessibleContextFromPoint parent is not showing !");
                    return null;
                }
                parenrRole = parentContext.getAccessibleRole();
                if (parenrRole == AccessibleRole.VIEWPORT) {
                    AccessibleComponent parentComponent = parentContext.getAccessibleComponent();
                    if (parentComponent == null) {
                        this.debugString("getChildrenAccessibleContextFromPoint parent accessibleComponent is null !");
                        return null;
                    }
                    Rectangle parentBounds = parentComponent.getBounds();
                    parentBounds.setLocation(parentComponent.getLocationOnScreen());
                    if (!parentBounds.contains(point)) {
                        this.debugString("getChildrenAccessibleContextFromPoint the target point: " + point.toString() + "is not in rectangle: " + parentBounds.toString());
                        return null;
                    }
                }
                result = new ArrayList<AccessibleContext>();
                if (parenrRole != AccessibleRole.TABLE) break block15;
                AccessibleComponent parentComponent = parentContext.getAccessibleComponent();
                if (parentComponent == null) break block16;
                Point localPoint1 = parentComponent.getLocationOnScreen();
                if (localPoint1 == null) {
                    return null;
                }
                Point localPoint2 = new Point(point);
                localPoint2.translate(-localPoint1.x, -localPoint1.y);
                Accessible childAccessible = parentComponent.getAccessibleAt(localPoint2);
                if (childAccessible == null) break block16;
                result.add(childAccessible.getAccessibleContext());
                break block16;
            }
            if (parenrRole == AccessibleRole.TREE) {
                AccessibleContext treeItemContext = this.getAccessibleContextFromTree(point, parentContext);
                if (treeItemContext != null) {
                    result.add(treeItemContext);
                }
            } else {
                int childCount = this.getAccessibleChildrenCountFromContext(parentContext);
                for (int i = 0; i < childCount; ++i) {
                    AccessibleContext childContext = this.getAccessibleChildFromContext(parentContext, i);
                    ArrayList<AccessibleContext> childNodes = this.getChildrenAccessibleContextFromPoint(point, childContext);
                    if (childNodes == null || childNodes.size() <= 0) continue;
                    AccessibleContext samllestItem = null;
                    for (AccessibleContext childNode : childNodes) {
                        if (childNode == null) continue;
                        if (samllestItem == null) {
                            samllestItem = childNode;
                        }
                        if (!this.getAccessibleBoundsOnScreenFromContext(samllestItem).contains(this.getAccessibleBoundsOnScreenFromContext(childNode))) continue;
                        samllestItem = childNode;
                    }
                    if (samllestItem == null) continue;
                    result.add(samllestItem);
                }
            }
        }
        if (result.size() == 0) {
            AccessibleComponent parentComponent = parentContext.getAccessibleComponent();
            if (parentComponent == null) {
                this.debugString("getChildrenAccessibleContextFromPoint parent accessibleComponent is null !");
                return null;
            }
            Rectangle parentBounds = parentComponent.getBounds();
            parentBounds.setLocation(parentComponent.getLocationOnScreen());
            if (!parentBounds.contains(point)) {
                this.debugString("getChildrenAccessibleContextFromPoint the target point: " + point.toString() + "is not in rectangle: " + parentBounds.toString());
                return null;
            }
            result.add(parentContext);
        }
        return result;
    }

    private AccessibleContext getAccessibleContextFromTree(Point point, AccessibleContext parentContext) {
        if (parentContext == null) {
            this.debugString("getAccessibleContextFromTree tree accessible context is null!");
            return null;
        }
        if (parentContext.getAccessibleStateSet().contains(AccessibleState.COLLAPSED)) {
            this.debugString("getAccessibleContextFromTree current node is collapsed!");
            return null;
        }
        int childrenCount = this.getAccessibleChildrenCountFromContext(parentContext);
        for (int i = 0; i < childrenCount; ++i) {
            Rectangle currentChildRectangle;
            AccessibleContext currentChildContext = this.getAccessibleChildFromContext(parentContext, i);
            if (currentChildContext == null || (currentChildRectangle = this.getAccessibleBoundsOnScreenFromContext(currentChildContext)) == null) continue;
            if (currentChildRectangle.contains(point)) {
                return currentChildContext;
            }
            AccessibleContext treeItemContext = this.getAccessibleContextFromTree(point, currentChildContext);
            if (treeItemContext == null) continue;
            return treeItemContext;
        }
        return null;
    }

    public AccessibleContext getAccessibleContextWithFocus() {
        Accessible a;
        Component c = AWTEventMonitor.getComponentWithFocus();
        if (c != null && (a = ClickniumAccessibleComponentFactory.getAccessibleFromComponent(c)) != null) {
            AccessibleContext ac = a.getAccessibleContext();
            return ac;
        }
        return null;
    }

    public String getAccessibleNameFromContext(AccessibleContext ac) {
        this.debugString("***** ac = " + ac.getClass());
        if (ac != null) {
            String s = ac.getAccessibleName();
            if (s != null) {
                this.references.increment(s);
                this.debugString("Returning AccessibleName from Context: " + s);
                return s;
            }
            return null;
        }
        this.debugString("getAccessibleNameFromContext; ac = null!");
        return null;
    }

    public String getVirtualAccessibleNameFromContext(AccessibleContext ac) {
        if (null != ac) {
            int childIndex;
            String version;
            String nameString = ac.getAccessibleName();
            if (null != nameString && 0 != nameString.length()) {
                this.debugString("The Virtual Accessible Name was obtained from AccessibleContext::getAccessibleName.");
                this.references.increment(nameString);
                return nameString;
            }
            String descriptionString = ac.getAccessibleDescription();
            if (null != descriptionString && 0 != descriptionString.length()) {
                this.debugString("The Virtual Accessible Name was obtained from AccessibleContext::getAccessibleDescription.");
                this.references.increment(descriptionString);
                return descriptionString;
            }
            boolean bExtendedSearch = false;
            AccessibleRole role = ac.getAccessibleRole();
            AccessibleContext parentContext = null;
            AccessibleRole parentRole = AccessibleRole.UNKNOWN;
            if (this.extendedVirtualNameSearchRoles.contains(role) && null != (parentContext = this.getAccessibleParentFromContext(ac)) && AccessibleRole.UNKNOWN != (parentRole = parentContext.getAccessibleRole())) {
                boolean bl = bExtendedSearch = !this.noExtendedVirtualNameSearchParentRoles.contains(parentRole);
            }
            if (!bExtendedSearch) {
                AccessibleValue av;
                this.debugString("getVirtualAccessibleNameFromContext will not use the extended name search algorithm.  role = " + role.toDisplayString(Locale.US));
                if (AccessibleRole.LABEL == role) {
                    int charCount;
                    String text;
                    AccessibleText at = ac.getAccessibleText();
                    if (null != at && null != (text = this.getAccessibleTextRangeFromContext(ac, 0, charCount = at.getCharCount()))) {
                        this.debugString("The Virtual Accessible Name was obtained from the Accessible Text of the LABEL object.");
                        this.references.increment(text);
                        return text;
                    }
                    this.debugString("Attempting to obtain the Virtual Accessible Name from the Accessible Icon information.");
                    AccessibleIcon[] ai = ac.getAccessibleIcon();
                    if (null != ai && ai.length > 0) {
                        this.debugString("The Virtual Accessible Name was obtained from the description of the first Accessible Icon found in the LABEL object.");
                        String iconDescription = ai[0].getAccessibleIconDescription();
                        this.references.increment(iconDescription);
                        return iconDescription;
                    }
                    parentContext = this.getAccessibleParentFromContext(ac);
                    if (null != parentContext && AccessibleRole.TABLE == (parentRole = parentContext.getAccessibleRole())) {
                        AccessibleContext acTableCell = null;
                        int indexInParent = ac.getAccessibleIndexInParent();
                        acTableCell = this.getAccessibleChildFromContext(parentContext, indexInParent);
                        this.debugString("Making a second attempt to obtain the Virtual Accessible Name from the Accessible Icon information for the Table Cell.");
                        ai = acTableCell.getAccessibleIcon();
                        if (null != ai && ai.length > 0) {
                            this.debugString("The Virtual Accessible Name was obtained from the description of the first Accessible Icon found in the Table Cell object.");
                            String iconDescription = ai[0].getAccessibleIconDescription();
                            this.references.increment(iconDescription);
                            return iconDescription;
                        }
                    }
                } else if (AccessibleRole.TOGGLE_BUTTON == role || AccessibleRole.PUSH_BUTTON == role) {
                    this.debugString("Attempting to obtain the Virtual Accessible Name from the Accessible Icon information.");
                    AccessibleIcon[] ai = ac.getAccessibleIcon();
                    if (null != ai && ai.length > 0) {
                        this.debugString("The Virtual Accessible Name was obtained from the description of the first Accessible Icon found in the TOGGLE_BUTTON or PUSH_BUTTON object.");
                        String iconDescription = ai[0].getAccessibleIconDescription();
                        this.references.increment(iconDescription);
                        return iconDescription;
                    }
                } else if (AccessibleRole.CHECK_BOX == role && null != (av = ac.getAccessibleValue())) {
                    nameString = null;
                    Number value = av.getCurrentAccessibleValue();
                    if (null != value && null != (nameString = 1 == value.intValue() ? Boolean.TRUE.toString() : (0 == value.intValue() ? Boolean.FALSE.toString() : value.toString()))) {
                        this.references.increment(nameString);
                        return nameString;
                    }
                }
                return null;
            }
            String parentName = parentContext.getAccessibleName();
            String parentDescription = parentContext.getAccessibleDescription();
            if (AccessibleRole.SLIDER == role && AccessibleRole.PANEL == parentRole && null != parentName) {
                this.debugString("The Virtual Accessible Name was obtained from the Accessible Name of the SLIDER object's parent object.");
                this.references.increment(parentName);
                return parentName;
            }
            boolean bIsEditCombo = false;
            AccessibleContext testContext = ac;
            if (AccessibleRole.TEXT == role && AccessibleRole.COMBO_BOX == parentRole) {
                bIsEditCombo = true;
                if (null != parentName) {
                    this.debugString("The Virtual Accessible Name for this Edit Combo box was obtained from the Accessible Name of the object's parent object.");
                    this.references.increment(parentName);
                    return parentName;
                }
                if (null != parentDescription) {
                    this.debugString("The Virtual Accessible Name for this Edit Combo box was obtained from the Accessible Description of the object's parent object.");
                    this.references.increment(parentDescription);
                    return parentDescription;
                }
                testContext = parentContext;
                parentRole = AccessibleRole.UNKNOWN;
                parentContext = this.getAccessibleParentFromContext(testContext);
                if (null != parentContext) {
                    parentRole = parentContext.getAccessibleRole();
                }
            }
            if (null != (version = this.getJavaVersionProperty()) && version.compareTo("1.3") >= 0) {
                AccessibleRelation labeledByRelation;
                Object[] targets;
                Object o;
                AccessibleRelationSet ars = testContext.getAccessibleRelationSet();
                if (ars.size() > 0 && ars.contains(AccessibleRelation.LABELED_BY) && (o = (targets = (labeledByRelation = ars.get(AccessibleRelation.LABELED_BY)).getTarget())[0]) instanceof Accessible) {
                    AccessibleContext labelContext = ((Accessible)o).getAccessibleContext();
                    String labelName = labelContext.getAccessibleName();
                    String labelDescription = labelContext.getAccessibleDescription();
                    if (null != labelName) {
                        this.debugString("The Virtual Accessible Name was obtained using the LABELED_BY AccessibleRelation -- Name Case.");
                        this.references.increment(labelName);
                        return labelName;
                    }
                    if (null != labelDescription) {
                        this.debugString("The Virtual Accessible Name was obtained using the LABELED_BY AccessibleRelation -- Description Case.");
                        this.references.increment(labelDescription);
                        return labelDescription;
                    }
                }
            } else {
                this.debugString("This version of Java does not support AccessibleContext::getAccessibleRelationSet.");
            }
            int testIndex = 0;
            int testIndexMax = 0;
            int testX = 0;
            int testY = 0;
            int testWidth = 0;
            int testHeight = 0;
            int targetX = 0;
            int targetY = 0;
            testIndex = testContext.getAccessibleIndexInParent();
            if (null != parentContext) {
                testIndexMax = parentContext.getAccessibleChildrenCount() - 1;
            }
            testX = this.getAccessibleXcoordFromContext(testContext);
            testY = this.getAccessibleYcoordFromContext(testContext);
            testWidth = this.getAccessibleWidthFromContext(testContext);
            testHeight = this.getAccessibleHeightFromContext(testContext);
            targetX = testX + 2;
            targetY = testY + 2;
            Accessible child = null;
            AccessibleContext childContext = null;
            AccessibleRole childRole = AccessibleRole.UNKNOWN;
            int childX = 0;
            int childY = 0;
            int childWidth = 0;
            int childHeight = 0;
            String childName = null;
            String childDescription = null;
            for (childIndex = testIndex - 1; childIndex >= 0; --childIndex) {
                child = parentContext.getAccessibleChild(childIndex);
                if (null == child || null == (childContext = child.getAccessibleContext()) || AccessibleRole.LABEL != (childRole = childContext.getAccessibleRole())) continue;
                childX = this.getAccessibleXcoordFromContext(childContext);
                childY = this.getAccessibleYcoordFromContext(childContext);
                childWidth = this.getAccessibleWidthFromContext(childContext);
                childHeight = this.getAccessibleHeightFromContext(childContext);
                if (childX < testX && childY <= targetY && targetY <= childY + childHeight) {
                    childName = childContext.getAccessibleName();
                    if (null != childName) {
                        this.debugString("The Virtual Accessible Name was obtained from Accessible Name of a LABEL object positioned to the left of the object.");
                        this.references.increment(childName);
                        return childName;
                    }
                    childDescription = childContext.getAccessibleDescription();
                    if (null == childDescription) continue;
                    this.debugString("The Virtual Accessible Name was obtained from Accessible Description of a LABEL object positioned to the left of the object.");
                    this.references.increment(childDescription);
                    return childDescription;
                }
                if (childY >= targetY || childX > targetX || targetX > childX + childWidth) continue;
                childName = childContext.getAccessibleName();
                if (null != childName) {
                    this.debugString("The Virtual Accessible Name was obtained from Accessible Name of a LABEL object positioned above the object.");
                    this.references.increment(childName);
                    return childName;
                }
                childDescription = childContext.getAccessibleDescription();
                if (null == childDescription) continue;
                this.debugString("The Virtual Accessible Name was obtained from Accessible Description of a LABEL object positioned above the object.");
                this.references.increment(childDescription);
                return childDescription;
            }
            for (childIndex = testIndex + 1; childIndex <= testIndexMax; ++childIndex) {
                child = parentContext.getAccessibleChild(childIndex);
                if (null == child || null == (childContext = child.getAccessibleContext()) || AccessibleRole.LABEL != (childRole = childContext.getAccessibleRole())) continue;
                childX = this.getAccessibleXcoordFromContext(childContext);
                childY = this.getAccessibleYcoordFromContext(childContext);
                childWidth = this.getAccessibleWidthFromContext(childContext);
                childHeight = this.getAccessibleHeightFromContext(childContext);
                if (childX < testX && childY <= targetY && targetY <= childY + childHeight) {
                    childName = childContext.getAccessibleName();
                    if (null != childName) {
                        this.debugString("The Virtual Accessible Name was obtained from Accessible Name of a LABEL object positioned to the left of the object.");
                        this.references.increment(childName);
                        return childName;
                    }
                    childDescription = childContext.getAccessibleDescription();
                    if (null == childDescription) continue;
                    this.debugString("The Virtual Accessible Name was obtained from Accessible Description of a LABEL object positioned to the left of the object.");
                    this.references.increment(childDescription);
                    return childDescription;
                }
                if (childY >= targetY || childX > targetX || targetX > childX + childWidth) continue;
                childName = childContext.getAccessibleName();
                if (null != childName) {
                    this.debugString("The Virtual Accessible Name was obtained from Accessible Name of a LABEL object positioned above the object.");
                    this.references.increment(childName);
                    return childName;
                }
                childDescription = childContext.getAccessibleDescription();
                if (null == childDescription) continue;
                this.debugString("The Virtual Accessible Name was obtained from Accessible Description of a LABEL object positioned above the object.");
                this.references.increment(childDescription);
                return childDescription;
            }
            if (AccessibleRole.TEXT == role || AccessibleRole.COMBO_BOX == role || bIsEditCombo) {
                for (childIndex = testIndex - 1; childIndex >= 0; --childIndex) {
                    child = parentContext.getAccessibleChild(childIndex);
                    if (null == child || null == (childContext = child.getAccessibleContext()) || AccessibleRole.PUSH_BUTTON != (childRole = childContext.getAccessibleRole()) && AccessibleRole.TOGGLE_BUTTON != childRole) continue;
                    childX = this.getAccessibleXcoordFromContext(childContext);
                    childY = this.getAccessibleYcoordFromContext(childContext);
                    childWidth = this.getAccessibleWidthFromContext(childContext);
                    childHeight = this.getAccessibleHeightFromContext(childContext);
                    if (childX >= testX || childY > targetY || targetY > childY + childHeight) continue;
                    childName = childContext.getAccessibleName();
                    if (null != childName) {
                        this.debugString("The Virtual Accessible Name was obtained from Accessible Name of a PUSH_BUTTON or TOGGLE_BUTTON object positioned to the left of the object.");
                        this.references.increment(childName);
                        return childName;
                    }
                    childDescription = childContext.getAccessibleDescription();
                    if (null == childDescription) continue;
                    this.debugString("The Virtual Accessible Name was obtained from Accessible Description of a PUSH_BUTTON or TOGGLE_BUTTON object positioned to the left of the object.");
                    this.references.increment(childDescription);
                    return childDescription;
                }
                for (childIndex = testIndex + 1; childIndex <= testIndexMax; ++childIndex) {
                    child = parentContext.getAccessibleChild(childIndex);
                    if (null == child || null == (childContext = child.getAccessibleContext()) || AccessibleRole.PUSH_BUTTON != (childRole = childContext.getAccessibleRole()) && AccessibleRole.TOGGLE_BUTTON != childRole) continue;
                    childX = this.getAccessibleXcoordFromContext(childContext);
                    childY = this.getAccessibleYcoordFromContext(childContext);
                    childWidth = this.getAccessibleWidthFromContext(childContext);
                    childHeight = this.getAccessibleHeightFromContext(childContext);
                    if (childX >= testX || childY > targetY || targetY > childY + childHeight) continue;
                    childName = childContext.getAccessibleName();
                    if (null != childName) {
                        this.debugString("The Virtual Accessible Name was obtained from Accessible Name of a PUSH_BUTTON or TOGGLE_BUTTON object positioned to the left of the object.");
                        this.references.increment(childName);
                        return childName;
                    }
                    childDescription = childContext.getAccessibleDescription();
                    if (null == childDescription) continue;
                    this.debugString("The Virtual Accessible Name was obtained from Accessible Description of a PUSH_BUTTON or TOGGLE_BUTTON object positioned to the left of the object.");
                    this.references.increment(childDescription);
                    return childDescription;
                }
            }
            return null;
        }
        this.debugString("ClickniumJavaBridge::getVirtualAccessibleNameFromContext error - ac == null.");
        return null;
    }

    public String getAccessibleDescriptionFromContext(AccessibleContext ac) {
        if (ac != null) {
            String s = ac.getAccessibleDescription();
            if (s != null) {
                this.references.increment(s);
                this.debugString("Returning AccessibleDescription from Context: " + s);
                return s;
            }
        } else {
            this.debugString("getAccessibleDescriptionFromContext; ac = null");
        }
        return null;
    }

    public String getAccessibleRoleStringFromContext(AccessibleContext ac) {
        if (ac != null) {
            String s;
            AccessibleRole role = ac.getAccessibleRole();
            if (role != null && (s = role.toDisplayString(Locale.US)) != null) {
                this.references.increment(s);
                this.debugString("Returning AccessibleRole from Context: " + s);
                return s;
            }
        } else {
            this.debugString("getAccessibleRoleStringFromContext; ac = null");
        }
        return null;
    }

    public String getAccessibleRoleStringFromContext_en_US(AccessibleContext ac) {
        if (ac != null) {
            String s;
            AccessibleRole role = ac.getAccessibleRole();
            if (role != null && (s = role.toDisplayString(Locale.US)) != null) {
                this.references.increment(s);
                this.debugString("Returning AccessibleRole in en_US from Context: " + s);
                return s;
            }
        } else {
            this.debugString("getAccessibleRoleStringFromContext; ac = null");
        }
        return null;
    }

    public String getAccessibleStatesStringFromContext(AccessibleContext ac) {
        if (ac != null) {
            String s;
            AccessibleStateSet stateSet = ac.getAccessibleStateSet();
            if (stateSet != null && (s = stateSet.toString()) != null && s.indexOf(_AccessibleState.MANAGES_DESCENDANTS.toDisplayString(Locale.US)) == -1) {
                AccessibleRole role = ac.getAccessibleRole();
                if (role == AccessibleRole.LIST || role == AccessibleRole.TABLE || role == AccessibleRole.TREE) {
                    s = s + ",";
                    s = s + _AccessibleState.MANAGES_DESCENDANTS.toDisplayString(Locale.US);
                }
                this.references.increment(s);
                this.debugString("Returning AccessibleStateSet from Context: " + s);
                return s;
            }
        } else {
            this.debugString("getAccessibleStatesStringFromContext; ac = null");
        }
        return null;
    }

    public String getAccessibleStatesStringFromContext_en_US(AccessibleContext ac) {
        AccessibleStateSet stateSet;
        if (ac != null && (stateSet = ac.getAccessibleStateSet()) != null) {
            String s = "";
            AccessibleState[] states = stateSet.toArray();
            if (states != null && states.length > 0) {
                s = states[0].toDisplayString(Locale.US);
                for (int i = 1; i < states.length; ++i) {
                    s = s + "," + states[i].toDisplayString(Locale.US);
                }
            }
            this.references.increment(s);
            this.debugString("Returning AccessibleStateSet en_US from Context: " + s);
            return s;
        }
        this.debugString("getAccessibleStatesStringFromContext; ac = null");
        return null;
    }

    public AccessibleContext getAccessibleParentFromContext(AccessibleContext ac) {
        AccessibleContext parent = null;
        if (ac != null) {
            if (ac.getAccessibleRole() != AccessibleRole.WINDOW) {
                Accessible a = ac.getAccessibleParent();
                if (a != null) {
                    AccessibleContext apc = a.getAccessibleContext();
                    if (apc != null) {
                        this.debugString("Returning AccessibleParent from Context");
                        parent = apc;
                    }
                } else {
                    Accessible localAccessible2;
                    Component c = this.getComponentFromAccessibleContext(ac);
                    if (c != null && c.getParent() != null && (localAccessible2 = ClickniumAccessibleComponentFactory.getAccessibleFromComponent(c.getParent())) != null) {
                        this.debugString("getAccessibleParentFromContext: retrieved parent through component for " + ac.getClass());
                        parent = localAccessible2.getAccessibleContext();
                    }
                }
                if (ac == parent || ac.equals(parent)) {
                    parent = null;
                }
            }
        } else {
            this.debugString("getAccessibleParentFromContext; ac = null");
        }
        return parent;
    }

    public Component getComponentFromAccessibleContext(AccessibleContext paramAccessibleContext) {
        try {
            int i;
            Object localObject3;
            Object localObject2;
            Object source;
            if (paramAccessibleContext == null) {
                this.debugString("Start getComponentFromAccessibleContext: invalid argument");
                return null;
            }
            if (paramAccessibleContext instanceof ClickniumAccessibleComponent && (source = ((ClickniumAccessibleComponent)paramAccessibleContext).getSource()) instanceof Component) {
                return (Component)source;
            }
            if (paramAccessibleContext instanceof ClickniumOverrideAccessible && (source = ((ClickniumOverrideAccessible)paramAccessibleContext).getSource()) instanceof Component) {
                return (Component)source;
            }
            Accessible parent = paramAccessibleContext.getAccessibleParent();
            if (!(paramAccessibleContext instanceof ClickniumAccessibleComponent) && parent instanceof ClickniumAccessibleComponent) {
                Component[] localObject4;
                localObject2 = ((ClickniumAccessibleComponent)parent).getSource();
                Object object = localObject3 = localObject2 instanceof Container ? (Container)localObject2 : null;
                if (localObject3 != null && (localObject4 = ((Container)localObject3).getComponents()) != null) {
                    for (Component localComponent : localObject4) {
                        if (!paramAccessibleContext.equals(localComponent.getAccessibleContext())) continue;
                        return localComponent;
                    }
                }
            }
            try {
                Accessible parentAccessible;
                if (paramAccessibleContext.getAccessibleChildrenCount() > 0 && (localObject2 = paramAccessibleContext.getAccessibleChild(0)) != null && (localObject3 = ((Accessible)localObject2).getAccessibleContext()) != null && (parentAccessible = ((AccessibleContext)localObject3).getAccessibleParent()) instanceof Component) {
                    return (Component)((Object)parentAccessible);
                }
            }
            catch (Exception parentAccessible) {
                // empty catch block
            }
            if (parent instanceof Accessible) {
                int i2 = paramAccessibleContext.getAccessibleIndexInParent();
                if (i2 < 0) {
                    this.debugString("getComponentFromAccessibleContext: accessible index parent not found for acc = " + paramAccessibleContext);
                } else {
                    localObject3 = parent.getAccessibleContext().getAccessibleChild(i2);
                    if (localObject3 instanceof Component) {
                        return (Component)localObject3;
                    }
                    if (localObject3 == null) {
                        this.debugString("getComponentFromAccessibleContext: asChild is null");
                    }
                }
            }
            if ((i = this.getNativeWindowHandleFromContext(paramAccessibleContext)) != 0 && (localObject3 = ClickniumJavaBridge.getComponentFromNativeWindowHandle(i)) != null) {
                return (Component)localObject3;
            }
            this.debugString("End getComponentFromAccessibleContext: there is no awt component for acc = " + paramAccessibleContext);
            return null;
        }
        catch (Exception localException1) {
            this.debugString("getComponentFromAccessibleContext exception: " + localException1.getMessage());
            return null;
        }
    }

    public static Component getComponentFromNativeWindowHandle(int paramInt) {
        int i = nativeWindowHandlers.size();
        for (int j = 0; j < i; ++j) {
            NativeWindowHandler localNativeWindowHandler = (NativeWindowHandler)nativeWindowHandlers.elementAt(j);
            Component localComponent = localNativeWindowHandler.getComponentFromNativeWindowHandle(paramInt);
            if (localComponent == null) continue;
            return localComponent;
        }
        return null;
    }

    public int getAccessibleIndexInParentFromContext(AccessibleContext ac) {
        if (ac != null) {
            this.debugString("Returning Accessible IndexInParent from Context: " + ac.getAccessibleIndexInParent());
            return ac.getAccessibleIndexInParent();
        }
        this.debugString("AccessibleIndexInParent; ac = null");
        return -1;
    }

    public int getAccessibleChildrenCountFromContext(final AccessibleContext ac) {
        if (!EventQueue.isDispatchThread()) {
            final EventDispatchThreadResult eventDispatchThreadResult = new EventDispatchThreadResult();
            EventQueueInvokeUtil.invokeAndWait(new Runnable(){

                public void run() {
                    eventDispatchThreadResult.result = ClickniumJavaBridge.this.getAccessibleChildrenCountFromContext(ac);
                }
            }, ac);
            if (eventDispatchThreadResult.result != null) {
                return ((Number)eventDispatchThreadResult.result).intValue();
            }
            return 0;
        }
        if (ac != null) {
            int containerComponentsCount;
            Component currentComponent;
            this.debugString("Returning Accessible ChildrenCount from Context: " + ac.getAccessibleChildrenCount());
            if (this.searchInContainerChildrenRoles.contains(ac.getAccessibleRole()) && (currentComponent = this.getComponentFromAccessibleContext(ac)) != null && currentComponent instanceof Container && (containerComponentsCount = ((Container)currentComponent).getComponentCount()) > ac.getAccessibleChildrenCount()) {
                return containerComponentsCount;
            }
            return ac.getAccessibleChildrenCount();
        }
        this.debugString("getAccessibleChildrenCountFromContext; ac = null");
        return -1;
    }

    public AccessibleContext getAccessibleChildFromContext(final AccessibleContext ac, final int index) {
        Accessible a;
        Component currentComponent;
        if (!EventQueue.isDispatchThread()) {
            final EventDispatchThreadResult eventDispatchThreadResult = new EventDispatchThreadResult();
            EventQueueInvokeUtil.invokeAndWait(new Runnable(){

                public void run() {
                    eventDispatchThreadResult.result = ClickniumJavaBridge.this.getAccessibleChildFromContext(ac, index);
                }
            }, ac);
            return (AccessibleContext)eventDispatchThreadResult.result;
        }
        if (ac == null) {
            return null;
        }
        if (this.searchInContainerChildrenRoles.contains(ac.getAccessibleRole()) && (currentComponent = this.getComponentFromAccessibleContext(ac)) != null && currentComponent instanceof Container) {
            try {
                Accessible childComponentAccessible;
                Component childComponent;
                Container localContainer = (Container)currentComponent;
                Component[] arrayOfComponent = localContainer.getComponents();
                if (arrayOfComponent.length > ac.getAccessibleChildrenCount() && index <= arrayOfComponent.length - 1 && (childComponent = arrayOfComponent[index]) != null && (childComponentAccessible = ClickniumAccessibleComponentFactory.getAccessibleFromComponent(childComponent)) != null) {
                    AccessibleContext childContext = childComponentAccessible.getAccessibleContext();
                    if (ac != childContext && !ac.equals(childContext)) {
                        childContext.setAccessibleParent((Accessible)((Object)currentComponent));
                        return childContext;
                    }
                    return null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((a = ac.getAccessibleChild(index)) != null) {
            Accessible childAccessible = ClickniumAccessibleComponentFactory.getAccessibleFromComponent(a);
            if (childAccessible != null) {
                return childAccessible.getAccessibleContext();
            }
            return a.getAccessibleContext();
        }
        return null;
    }

    public Rectangle getAccessibleBoundsOnScreenFromContext(AccessibleContext ac) {
        if (ac != null) {
            Rectangle r;
            AccessibleComponent acmp = ac.getAccessibleComponent();
            if (acmp != null && (r = acmp.getBounds()) != null) {
                try {
                    Point p = acmp.getLocationOnScreen();
                    if (p != null) {
                        r.x = p.x;
                        r.y = p.y;
                        return r;
                    }
                }
                catch (Exception e) {
                    this.debugString("*** Caught EXCEPTION in getAccessibleBoundsOnScreenFromContext: " + e.toString());
                }
            }
        } else {
            this.debugString("getAccessibleBoundsOnScreenFromContext; ac = null");
        }
        return null;
    }

    public int getAccessibleXcoordFromContext(AccessibleContext ac) {
        if (ac != null) {
            Rectangle r = this.getAccessibleBoundsOnScreenFromContext(ac);
            if (r != null) {
                this.debugString(" - Returning Accessible x coord from Context: " + r.x);
                return r.x;
            }
        } else {
            this.debugString("getAccessibleXcoordFromContext ac = null");
        }
        return -1;
    }

    public int getAccessibleYcoordFromContext(AccessibleContext ac) {
        this.debugString("getAccessibleYcoordFromContext() called");
        if (ac != null) {
            Rectangle r = this.getAccessibleBoundsOnScreenFromContext(ac);
            if (r != null) {
                return r.y;
            }
        } else {
            this.debugString("getAccessibleYcoordFromContext; ac = null");
        }
        return -1;
    }

    public int getAccessibleHeightFromContext(AccessibleContext ac) {
        if (ac != null) {
            Rectangle r = this.getAccessibleBoundsOnScreenFromContext(ac);
            if (r != null) {
                return r.height;
            }
        } else {
            this.debugString("getAccessibleHeightFromContext; ac = null");
        }
        return -1;
    }

    public int getAccessibleWidthFromContext(AccessibleContext ac) {
        if (ac != null) {
            Rectangle r = this.getAccessibleBoundsOnScreenFromContext(ac);
            if (r != null) {
                return r.width;
            }
        } else {
            this.debugString("getAccessibleWidthFromContext; ac = null");
        }
        return -1;
    }

    public AccessibleComponent getAccessibleComponentFromContext(AccessibleContext ac) {
        if (ac != null) {
            AccessibleComponent acmp = ac.getAccessibleComponent();
            if (acmp != null) {
                this.debugString("Returning AccessibleComponent Context");
                return acmp;
            }
        } else {
            this.debugString("getAccessibleComponentFromContext; ac = null");
        }
        return null;
    }

    public AccessibleAction getAccessibleActionFromContext(AccessibleContext ac) {
        if (ac != null) {
            AccessibleAction aa = ac.getAccessibleAction();
            if (aa != null) {
                this.debugString("Returning AccessibleAction Context");
                return aa;
            }
        } else {
            this.debugString("getAccessibleActionFromContext; ac = null");
        }
        return null;
    }

    public AccessibleSelection getAccessibleSelectionFromContext(AccessibleContext ac) {
        if (ac != null) {
            AccessibleSelection as = ac.getAccessibleSelection();
            if (as != null) {
                this.debugString("returning AccessibleSelection Context=" + as.getClass());
                return as;
            }
        } else {
            this.debugString("getAccessibleSelectionFromContext; ac = null");
        }
        return null;
    }

    public AccessibleText getAccessibleTextFromContext(AccessibleContext ac) {
        if (ac != null) {
            AccessibleText at = ac.getAccessibleText();
            if (at != null) {
                this.debugString("Returning AccessibleText Context");
                return at;
            }
        } else {
            this.debugString("getAccessibleTextFromContext; ac = null");
        }
        return null;
    }

    public AccessibleValue getAccessibleValueFromContext(AccessibleContext ac) {
        if (ac != null) {
            AccessibleValue av = ac.getAccessibleValue();
            if (av != null) {
                this.debugString("Returning AccessibleValue Context");
                return av;
            }
        } else {
            this.debugString("getAccessibleValueFromContext; ac = null");
        }
        return null;
    }

    public Rectangle getCaretLocation(AccessibleContext ac) {
        this.debugString("getCaretLocation");
        Rectangle r = null;
        if (ac != null) {
            Accessible parent = ac.getAccessibleParent();
            this.debugString("  parent = " + parent.getClass());
            if (parent instanceof Accessible) {
                int indexInParent = ac.getAccessibleIndexInParent();
                this.debugString("  indexInParent = " + indexInParent);
                Accessible child = parent.getAccessibleContext().getAccessibleChild(indexInParent);
                if (child instanceof JTextComponent) {
                    JTextComponent text = (JTextComponent)child;
                    try {
                        r = text.modelToView(text.getCaretPosition());
                        if (r != null) {
                            Point p = text.getLocationOnScreen();
                            r.translate(p.x, p.y);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        }
        this.debugString("  returning = " + r);
        return r;
    }

    public int getCaretLocationX(AccessibleContext ac) {
        Rectangle r = this.getCaretLocation(ac);
        if (r != null) {
            return r.x;
        }
        return -1;
    }

    public int getCaretLocationY(AccessibleContext ac) {
        Rectangle r = this.getCaretLocation(ac);
        if (r != null) {
            return r.y;
        }
        return -1;
    }

    public int getCaretLocationHeight(AccessibleContext ac) {
        Rectangle r = this.getCaretLocation(ac);
        if (r != null) {
            return r.height;
        }
        return -1;
    }

    public int getCaretLocationWidth(AccessibleContext ac) {
        Rectangle r = this.getCaretLocation(ac);
        if (r != null) {
            return r.width;
        }
        return -1;
    }

    public int getAccessibleCharCountFromContext(AccessibleContext ac) {
        if (ac != null) {
            AccessibleText at = ac.getAccessibleText();
            if (at != null) {
                return at.getCharCount();
            }
        } else {
            this.debugString("getAccessibleCharCountFromContext; ac = null");
        }
        return -1;
    }

    public int getAccessibleCaretPositionFromContext(AccessibleContext ac) {
        if (ac != null) {
            AccessibleText at = ac.getAccessibleText();
            if (at != null) {
                return at.getCaretPosition();
            }
        } else {
            this.debugString("getAccessibleCaretPositionFromContext; ac = null");
        }
        return -1;
    }

    public int getAccessibleIndexAtPointFromContext(AccessibleContext ac, int x, int y) {
        this.debugString("getAccessibleIndexAtPointFromContext: x = " + x + "; y = " + y);
        if (ac != null) {
            AccessibleText at = ac.getAccessibleText();
            AccessibleComponent acomp = ac.getAccessibleComponent();
            if (at != null && acomp != null) {
                try {
                    Point p = acomp.getLocationOnScreen();
                    this.debugString("  getLocationOnScreen = " + p);
                    if (p != null) {
                        if ((x -= p.x) < 0) {
                            x = 0;
                        }
                        if ((y -= p.y) < 0) {
                            y = 0;
                        }
                        Point newPoint = new Point(x, y);
                        this.debugString("  newPoint = " + newPoint);
                        int indexAtPoint = at.getIndexAtPoint(new Point(x, y));
                        this.debugString("  indexAtPoint = " + indexAtPoint);
                        return indexAtPoint;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.debugString("  returning -1");
        return -1;
    }

    public String getAccessibleLetterAtIndexFromContext(AccessibleContext ac, int index) {
        if (ac != null) {
            String s;
            AccessibleText at = ac.getAccessibleText();
            if (at != null && (s = at.getAtIndex(1, index)) != null) {
                this.references.increment(s);
                return s;
            }
        } else {
            this.debugString("getAccessibleLetterAtIndexFromContext; ac = null");
        }
        return null;
    }

    public String getAccessibleWordAtIndexFromContext(AccessibleContext ac, int index) {
        if (ac != null) {
            String s;
            AccessibleText at = ac.getAccessibleText();
            if (at != null && (s = at.getAtIndex(2, index)) != null) {
                this.references.increment(s);
                return s;
            }
        } else {
            this.debugString("getAccessibleWordAtIndexFromContext; ac = null");
        }
        return null;
    }

    public String getAccessibleSentenceAtIndexFromContext(AccessibleContext ac, int index) {
        if (ac != null) {
            String s;
            AccessibleText at = ac.getAccessibleText();
            if (at != null && (s = at.getAtIndex(3, index)) != null) {
                this.references.increment(s);
                return s;
            }
        } else {
            this.debugString("getAccessibleSentenceAtIndexFromContext; ac = null");
        }
        return null;
    }

    public int getAccessibleTextSelectionStartFromContext(AccessibleContext ac) {
        if (ac != null) {
            AccessibleText at = ac.getAccessibleText();
            if (at != null) {
                return at.getSelectionStart();
            }
        } else {
            this.debugString("getAccessibleTextSelectionStartFromContext; ac = null");
        }
        return -1;
    }

    public int getAccessibleTextSelectionEndFromContext(AccessibleContext ac) {
        if (ac != null) {
            AccessibleText at = ac.getAccessibleText();
            if (at != null) {
                return at.getSelectionEnd();
            }
        } else {
            this.debugString("getAccessibleTextSelectionEndFromContext; ac = null");
        }
        return -1;
    }

    public String getAccessibleTextSelectedTextFromContext(AccessibleContext ac) {
        if (ac != null) {
            String s;
            AccessibleText at = ac.getAccessibleText();
            if (at != null && (s = at.getSelectedText()) != null) {
                this.references.increment(s);
                return s;
            }
        } else {
            this.debugString("getAccessibleTextSelectedTextFromContext; ac = null");
        }
        return null;
    }

    public String getAccessibleAttributesAtIndexFromContext(AccessibleContext ac, int index) {
        if (ac != null) {
            AttributeSet as;
            String s;
            AccessibleText at = ac.getAccessibleText();
            if (at != null && (s = this.expandStyleConstants(as = at.getCharacterAttribute(index))) != null) {
                this.references.increment(s);
                return s;
            }
        } else {
            this.debugString("getAccessibleAttributesAtIndexFromContext; ac = null");
        }
        return null;
    }

    public int getAccessibleTextLineLeftBoundsFromContext(AccessibleContext ac, int index) {
        if (ac != null) {
            AccessibleText at = ac.getAccessibleText();
            if (at != null) {
                Rectangle indexRect = at.getCharacterBounds(index);
                int textLen = at.getCharCount();
                if (indexRect == null) {
                    return -1;
                }
                int offset = 1;
                int lineStart = index - offset < 0 ? 0 : index - offset;
                Rectangle charRect = at.getCharacterBounds(lineStart);
                while (charRect != null && charRect.y >= indexRect.y && lineStart > 0) {
                    lineStart = index - (offset <<= 1) < 0 ? 0 : index - offset;
                    charRect = at.getCharacterBounds(lineStart);
                }
                if (lineStart != 0) {
                    offset >>= 1;
                    while (offset > 0) {
                        charRect = at.getCharacterBounds(lineStart + offset);
                        if (charRect.y < indexRect.y) {
                            lineStart += offset;
                        }
                        offset >>= 1;
                    }
                    ++lineStart;
                }
                return lineStart;
            }
        } else {
            this.debugString("getAccessibleTextLineLeftBoundsFromContext; ac = null");
        }
        return -1;
    }

    public int getAccessibleTextLineRightBoundsFromContext(AccessibleContext ac, int index) {
        if (ac != null) {
            AccessibleText at = ac.getAccessibleText();
            if (at != null) {
                Rectangle indexRect = at.getCharacterBounds(index);
                int textLen = at.getCharCount();
                if (indexRect == null) {
                    return -1;
                }
                int offset = 1;
                int lineEnd = index + offset > textLen - 1 ? textLen - 1 : index + offset;
                Rectangle charRect = at.getCharacterBounds(lineEnd);
                while (charRect != null && charRect.y <= indexRect.y && lineEnd < textLen - 1) {
                    lineEnd = index + (offset <<= 1) > textLen - 1 ? textLen - 1 : index + offset;
                    charRect = at.getCharacterBounds(lineEnd);
                }
                if (lineEnd != textLen - 1) {
                    offset >>= 1;
                    while (offset > 0) {
                        charRect = at.getCharacterBounds(lineEnd - offset);
                        if (charRect.y > indexRect.y) {
                            lineEnd -= offset;
                        }
                        offset >>= 1;
                    }
                    --lineEnd;
                }
                return lineEnd;
            }
        } else {
            this.debugString("getAccessibleTextLineRightBoundsFromContext; ac = null");
        }
        return -1;
    }

    public String getAccessibleTextRangeFromContext(AccessibleContext ac, int start, int end) {
        if (ac != null) {
            AccessibleText at = ac.getAccessibleText();
            if (at != null) {
                if (start > end) {
                    return null;
                }
                if (end >= at.getCharCount()) {
                    return null;
                }
                StringBuffer buf = new StringBuffer(end - start + 1);
                for (int i = start; i <= end; ++i) {
                    buf.append(at.getAtIndex(1, i));
                }
                String s = buf.toString();
                if (s != null) {
                    this.references.increment(s);
                    return s;
                }
            }
        } else {
            this.debugString("getAccessibleTextRangeFromContext; ac = null");
        }
        return null;
    }

    public AttributeSet getAccessibleAttributeSetAtIndexFromContext(AccessibleContext ac, int index) {
        if (ac != null) {
            AttributeSet as;
            AccessibleText at = ac.getAccessibleText();
            if (at != null && (as = at.getCharacterAttribute(index)) != null) {
                this.references.increment(as);
                return as;
            }
        } else {
            this.debugString("getAccessibleAttributeSetAtIndexFromContext; ac = null");
        }
        return null;
    }

    public Rectangle getAccessibleTextRectAtIndexFromContext(AccessibleContext ac, int index) {
        if (ac != null) {
            Rectangle r;
            AccessibleText at = ac.getAccessibleText();
            if (at != null && (r = at.getCharacterBounds(index)) != null) {
                Rectangle acRect;
                String s = at.getAtIndex(1, index);
                if (s != null && s.equals("\n")) {
                    r.width = 0;
                }
                if ((acRect = this.getAccessibleBoundsOnScreenFromContext(ac)) != null) {
                    r.translate(acRect.x, acRect.y);
                    return r;
                }
            }
        } else {
            this.debugString("getAccessibleTextRectAtIndexFromContext; ac = null");
        }
        return null;
    }

    public int getAccessibleXcoordTextRectAtIndexFromContext(AccessibleContext ac, int index) {
        if (ac != null) {
            Rectangle r = this.getAccessibleTextRectAtIndexFromContext(ac, index);
            if (r != null) {
                return r.x;
            }
        } else {
            this.debugString("getAccessibleXcoordTextRectAtIndexFromContext; ac = null");
        }
        return -1;
    }

    public int getAccessibleYcoordTextRectAtIndexFromContext(AccessibleContext ac, int index) {
        if (ac != null) {
            Rectangle r = this.getAccessibleTextRectAtIndexFromContext(ac, index);
            if (r != null) {
                return r.y;
            }
        } else {
            this.debugString("getAccessibleYcoordTextRectAtIndexFromContext; ac = null");
        }
        return -1;
    }

    public int getAccessibleHeightTextRectAtIndexFromContext(AccessibleContext ac, int index) {
        if (ac != null) {
            Rectangle r = this.getAccessibleTextRectAtIndexFromContext(ac, index);
            if (r != null) {
                return r.height;
            }
        } else {
            this.debugString("getAccessibleHeightTextRectAtIndexFromContext; ac = null");
        }
        return -1;
    }

    public int getAccessibleWidthTextRectAtIndexFromContext(AccessibleContext ac, int index) {
        if (ac != null) {
            Rectangle r = this.getAccessibleTextRectAtIndexFromContext(ac, index);
            if (r != null) {
                return r.width;
            }
        } else {
            this.debugString("getAccessibleWidthTextRectAtIndexFromContext; ac = null");
        }
        return -1;
    }

    public boolean getBoldFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.isBold(as);
        }
        this.debugString("getBoldFromAttributeSet; as = null");
        return false;
    }

    public boolean getItalicFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.isItalic(as);
        }
        this.debugString("getItalicFromAttributeSet; as = null");
        return false;
    }

    public boolean getUnderlineFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.isUnderline(as);
        }
        this.debugString("getUnderlineFromAttributeSet; as = null");
        return false;
    }

    public boolean getStrikethroughFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.isStrikeThrough(as);
        }
        this.debugString("getStrikethroughFromAttributeSet; as = null");
        return false;
    }

    public boolean getSuperscriptFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.isSuperscript(as);
        }
        this.debugString("getSuperscriptFromAttributeSet; as = null");
        return false;
    }

    public boolean getSubscriptFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.isSubscript(as);
        }
        this.debugString("getSubscriptFromAttributeSet; as = null");
        return false;
    }

    public String getBackgroundColorFromAttributeSet(AttributeSet as) {
        if (as != null) {
            String s = StyleConstants.getBackground(as).toString();
            if (s != null) {
                this.references.increment(s);
                return s;
            }
        } else {
            this.debugString("getBackgroundColorFromAttributeSet; as = null");
        }
        return null;
    }

    public String getForegroundColorFromAttributeSet(AttributeSet as) {
        if (as != null) {
            String s = StyleConstants.getForeground(as).toString();
            if (s != null) {
                this.references.increment(s);
                return s;
            }
        } else {
            this.debugString("getForegroundColorFromAttributeSet; as = null");
        }
        return null;
    }

    public String getFontFamilyFromAttributeSet(AttributeSet as) {
        if (as != null) {
            String s = StyleConstants.getFontFamily(as);
            if (s != null) {
                this.references.increment(s);
                return s;
            }
        } else {
            this.debugString("getFontFamilyFromAttributeSet; as = null");
        }
        return null;
    }

    public int getFontSizeFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.getFontSize(as);
        }
        this.debugString("getFontSizeFromAttributeSet; as = null");
        return -1;
    }

    public int getAlignmentFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.getAlignment(as);
        }
        this.debugString("getAlignmentFromAttributeSet; as = null");
        return -1;
    }

    public int getBidiLevelFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.getBidiLevel(as);
        }
        this.debugString("getBidiLevelFromAttributeSet; as = null");
        return -1;
    }

    public float getFirstLineIndentFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.getFirstLineIndent(as);
        }
        this.debugString("getFirstLineIndentFromAttributeSet; as = null");
        return -1.0f;
    }

    public float getLeftIndentFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.getLeftIndent(as);
        }
        this.debugString("getLeftIndentFromAttributeSet; as = null");
        return -1.0f;
    }

    public float getRightIndentFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.getRightIndent(as);
        }
        this.debugString("getRightIndentFromAttributeSet; as = null");
        return -1.0f;
    }

    public float getLineSpacingFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.getLineSpacing(as);
        }
        this.debugString("getLineSpacingFromAttributeSet; as = null");
        return -1.0f;
    }

    public float getSpaceAboveFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.getSpaceAbove(as);
        }
        this.debugString("getSpaceAboveFromAttributeSet; as = null");
        return -1.0f;
    }

    public float getSpaceBelowFromAttributeSet(AttributeSet as) {
        if (as != null) {
            return StyleConstants.getSpaceBelow(as);
        }
        this.debugString("getSpaceBelowFromAttributeSet; as = null");
        return -1.0f;
    }

    private String expandStyleConstants(AttributeSet as) {
        Color c;
        Icon i;
        String attrString = "";
        attrString = attrString + "BidiLevel = " + StyleConstants.getBidiLevel(as);
        Component comp = StyleConstants.getComponent(as);
        if (comp != null) {
            AccessibleContext ac;
            attrString = comp instanceof Accessible ? ((ac = ((Accessible)((Object)comp)).getAccessibleContext()) != null ? attrString + "; Accessible Component = " + ac.getAccessibleName() : attrString + "; Innaccessible Component = " + comp) : attrString + "; Innaccessible Component = " + comp;
        }
        if ((i = StyleConstants.getIcon(as)) != null) {
            attrString = i instanceof ImageIcon ? attrString + "; ImageIcon = " + ((ImageIcon)i).getDescription() : attrString + "; Icon = " + i;
        }
        attrString = attrString + "; FontFamily = " + StyleConstants.getFontFamily(as);
        attrString = attrString + "; FontSize = " + StyleConstants.getFontSize(as);
        if (StyleConstants.isBold(as)) {
            attrString = attrString + "; bold";
        }
        if (StyleConstants.isItalic(as)) {
            attrString = attrString + "; italic";
        }
        if (StyleConstants.isUnderline(as)) {
            attrString = attrString + "; underline";
        }
        if (StyleConstants.isStrikeThrough(as)) {
            attrString = attrString + "; strikethrough";
        }
        if (StyleConstants.isSuperscript(as)) {
            attrString = attrString + "; superscript";
        }
        if (StyleConstants.isSubscript(as)) {
            attrString = attrString + "; subscript";
        }
        if ((c = StyleConstants.getForeground(as)) != null) {
            attrString = attrString + "; Foreground = " + c;
        }
        if ((c = StyleConstants.getBackground(as)) != null) {
            attrString = attrString + "; Background = " + c;
        }
        attrString = attrString + "; FirstLineIndent = " + StyleConstants.getFirstLineIndent(as);
        attrString = attrString + "; RightIndent = " + StyleConstants.getRightIndent(as);
        attrString = attrString + "; LeftIndent = " + StyleConstants.getLeftIndent(as);
        attrString = attrString + "; LineSpacing = " + StyleConstants.getLineSpacing(as);
        attrString = attrString + "; SpaceAbove = " + StyleConstants.getSpaceAbove(as);
        attrString = attrString + "; SpaceBelow = " + StyleConstants.getSpaceBelow(as);
        attrString = attrString + "; Alignment = " + StyleConstants.getAlignment(as);
        TabSet ts = StyleConstants.getTabSet(as);
        if (ts != null) {
            attrString = attrString + "; TabSet = " + ts;
        }
        return attrString;
    }

    String getCurrentAccessibleValueFromContext(AccessibleContext ac) {
        if (ac != null) {
            String s;
            Number value;
            AccessibleValue av = ac.getAccessibleValue();
            if (av != null && (value = av.getCurrentAccessibleValue()) != null && (s = value.toString()) != null) {
                this.references.increment(s);
                return s;
            }
        } else {
            this.debugString("getCurrentAccessibleValueFromContext; ac = null");
        }
        return null;
    }

    String getMaximumAccessibleValueFromContext(AccessibleContext ac) {
        if (ac != null) {
            String s;
            Number value;
            AccessibleValue av = ac.getAccessibleValue();
            if (av != null && (value = av.getMaximumAccessibleValue()) != null && (s = value.toString()) != null) {
                this.references.increment(s);
                return s;
            }
        } else {
            this.debugString("getMaximumAccessibleValueFromContext; ac = null");
        }
        return null;
    }

    String getMinimumAccessibleValueFromContext(AccessibleContext ac) {
        if (ac != null) {
            String s;
            Number value;
            AccessibleValue av = ac.getAccessibleValue();
            if (av != null && (value = av.getMinimumAccessibleValue()) != null && (s = value.toString()) != null) {
                this.references.increment(s);
                return s;
            }
        } else {
            this.debugString("getMinimumAccessibleValueFromContext; ac = null");
        }
        return null;
    }

    void addAccessibleSelectionFromContext(final AccessibleContext ac, final int i) {
        if (!EventQueue.isDispatchThread()) {
            EventQueueInvokeUtil.invokeAndWait(new Runnable(){

                public void run() {
                    ClickniumJavaBridge.this.addAccessibleSelectionFromContext(ac, i);
                }
            }, ac);
            return;
        }
        if (ac != null) {
            AccessibleSelection as;
            Component component = this.getComponentFromAccessibleContext(ac);
            if (component != null && component instanceof JComboBox) {
                try {
                    ((JComboBox)component).setSelectedIndex(i);
                    component.repaint();
                    return;
                }
                catch (Exception e) {
                    this.debugString("addAccessibleSelectionFromContext; set combox selection failed" + e.getMessage());
                }
            }
            if ((as = ac.getAccessibleSelection()) != null) {
                as.addAccessibleSelection(i);
            }
        } else {
            this.debugString("addAccessibleSelectionFromContext; ac = null");
        }
    }

    void clearAccessibleSelectionFromContext(AccessibleContext ac) {
        if (ac != null) {
            AccessibleSelection as = ac.getAccessibleSelection();
            if (as != null) {
                as.clearAccessibleSelection();
            }
        } else {
            this.debugString("clearAccessibleSelectionFromContext; ac = null");
        }
    }

    AccessibleContext getAccessibleSelectionFromContext(AccessibleContext ac, int i) {
        if (ac != null) {
            Accessible a;
            AccessibleSelection as = ac.getAccessibleSelection();
            if (as != null && (a = as.getAccessibleSelection(i)) != null) {
                return a.getAccessibleContext();
            }
        } else {
            this.debugString("getAccessibleSelectionFromContext; ac = null");
        }
        return null;
    }

    int getAccessibleSelectionCountFromContext(AccessibleContext ac) {
        if (ac != null) {
            AccessibleSelection as = ac.getAccessibleSelection();
            if (as != null) {
                return as.getAccessibleSelectionCount();
            }
        } else {
            this.debugString("getAccessibleSelectionFromContext; ac = null");
        }
        return -1;
    }

    boolean isAccessibleChildSelectedFromContext(AccessibleContext ac, int i) {
        if (ac != null) {
            AccessibleSelection as = ac.getAccessibleSelection();
            if (as != null) {
                return as.isAccessibleChildSelected(i);
            }
        } else {
            this.debugString("isAccessibleChildSelectedFromContext; ac = null");
        }
        return false;
    }

    void removeAccessibleSelectionFromContext(AccessibleContext ac, int i) {
        if (ac != null) {
            AccessibleSelection as = ac.getAccessibleSelection();
            if (as != null) {
                as.removeAccessibleSelection(i);
            }
        } else {
            this.debugString("removeAccessibleSelectionFromContext; ac = null");
        }
    }

    void selectAllAccessibleSelectionFromContext(AccessibleContext ac) {
        if (ac != null) {
            AccessibleSelection as = ac.getAccessibleSelection();
            if (as != null) {
                as.selectAllAccessibleSelection();
            }
        } else {
            this.debugString("selectAllAccessibleSelectionFromContext; ac = null");
        }
    }

    public AccessibleTable getAccessibleTableFromContext(AccessibleContext ac) {
        AccessibleTable at;
        String version = this.getJavaVersionProperty();
        if (version != null && version.compareTo("1.3") >= 0 && ac != null && (at = ac.getAccessibleTable()) != null) {
            this.hashtab.put(at, ac);
            return at;
        }
        return null;
    }

    public AccessibleContext getContextFromAccessibleTable(AccessibleTable at) {
        Object o = this.hashtab.get(at);
        if (o instanceof AccessibleContext) {
            return (AccessibleContext)o;
        }
        return null;
    }

    public int getAccessibleTableRowCount(AccessibleContext ac) {
        AccessibleTable at;
        this.debugString("##### getAccessibleTableRowCount");
        if (ac != null && (at = ac.getAccessibleTable()) != null) {
            int rowCount = at.getAccessibleRowCount();
            this.debugString("   ##### getAccessibleTableRowCount=" + rowCount);
            return rowCount;
        }
        this.debugString("   ##### getAccessibleTableRowCount FAILED");
        return -1;
    }

    public int getAccessibleTableColumnCount(AccessibleContext ac) {
        AccessibleTable at;
        this.debugString("##### getAccessibleTableColumnCount");
        if (ac != null && (at = ac.getAccessibleTable()) != null) {
            int columnCount = at.getAccessibleColumnCount();
            this.debugString("   ##### getAccessibleTableColumnCount=" + columnCount);
            return columnCount;
        }
        this.debugString(" ##### getAccessibleTableColumnCount FAILED");
        return -1;
    }

    public AccessibleContext getAccessibleTableCellAccessibleContext(AccessibleTable at, int row, int column) {
        this.debugString("getAccessibleTableCellAccessibleContext: at = " + at.getClass());
        if (at == null) {
            return null;
        }
        if (!(at instanceof AccessibleContext) || at instanceof ClickniumAccessibleComponent) {
            Accessible a = at.getAccessibleAt(row, column);
            if (a != null) {
                return a.getAccessibleContext();
            }
        } else {
            AccessibleContext ac = (AccessibleContext)((Object)at);
            Accessible parent = ac.getAccessibleParent();
            if (parent instanceof Accessible) {
                int indexInParent = ac.getAccessibleIndexInParent();
                Accessible child = parent.getAccessibleContext().getAccessibleChild(indexInParent);
                if (child instanceof JTable) {
                    Component component;
                    JTable table = (JTable)child;
                    TableCellRenderer renderer = table.getCellRenderer(row, column);
                    if (renderer == null) {
                        Class<?> columnClass = table.getColumnClass(column);
                        renderer = table.getDefaultRenderer(columnClass);
                    }
                    if ((component = renderer.getTableCellRendererComponent(table, table.getValueAt(row, column), false, false, row, column)) instanceof Accessible) {
                        this.debugString("getAccessibleTableCellAccessibleContext returning = " + component.getClass());
                        return ((Accessible)((Object)component)).getAccessibleContext();
                    }
                }
            }
        }
        return null;
    }

    public int getAccessibleTableCellIndex(AccessibleTable at, int row, int column) {
        this.debugString("##### getAccessibleTableCellIndex: at=" + at);
        if (at != null) {
            int cellIndex = row * at.getAccessibleColumnCount() + column;
            this.debugString("   ##### getAccessibleTableCellIndex=" + cellIndex);
            return cellIndex;
        }
        this.debugString(" ##### getAccessibleTableCellIndex FAILED");
        return -1;
    }

    public int getAccessibleTableCellRowExtent(AccessibleTable at, int row, int column) {
        this.debugString("##### getAccessibleTableCellRowExtent");
        if (at != null) {
            int rowExtent = at.getAccessibleRowExtentAt(row, column);
            this.debugString("   ##### getAccessibleTableCellRowExtent=" + rowExtent);
            return rowExtent;
        }
        this.debugString(" ##### getAccessibleTableCellRowExtent FAILED");
        return -1;
    }

    public int getAccessibleTableCellColumnExtent(AccessibleTable at, int row, int column) {
        this.debugString("##### getAccessibleTableCellColumnExtent");
        if (at != null) {
            int columnExtent = at.getAccessibleColumnExtentAt(row, column);
            this.debugString("   ##### getAccessibleTableCellColumnExtent=" + columnExtent);
            return columnExtent;
        }
        this.debugString(" ##### getAccessibleTableCellColumnExtent FAILED");
        return -1;
    }

    public boolean isAccessibleTableCellSelected(AccessibleTable at, int row, int column) {
        boolean isSelected = false;
        this.debugString("##### isAccessibleTableCellSelected: [" + row + "][" + column + "]");
        if (at != null) {
            AccessibleContext ac;
            AccessibleStateSet as;
            Accessible a = at.getAccessibleAt(row, column);
            if (a != null && (as = (ac = a.getAccessibleContext()).getAccessibleStateSet()) != null) {
                isSelected = as.contains(AccessibleState.SELECTED);
            }
            this.debugString(" ##### isAccessibleTableCellSelected=" + isSelected);
            return isSelected;
        }
        this.debugString(" ##### isAccessibleTableCellSelected FAILED");
        return false;
    }

    public AccessibleTable getAccessibleTableRowHeader(AccessibleContext ac) {
        AccessibleTable at;
        this.debugString(" #####  getAccessibleTableRowHeader called");
        if (ac != null && (at = ac.getAccessibleTable()) != null) {
            return at.getAccessibleRowHeader();
        }
        this.debugString(" ##### getAccessibleTableRowHeader FAILED");
        return null;
    }

    public AccessibleTable getAccessibleTableColumnHeader(AccessibleContext ac) {
        this.debugString("##### getAccessibleTableColumnHeader");
        if (ac != null) {
            AccessibleTable at;
            Accessible parent = ac.getAccessibleParent();
            this.debugString("  parent = " + parent.getClass());
            if (parent instanceof Accessible) {
                JTable table;
                int indexInParent = ac.getAccessibleIndexInParent();
                this.debugString("  indexInParent = " + indexInParent);
                Accessible child = parent.getAccessibleContext().getAccessibleChild(indexInParent);
                if (child instanceof JTable && (table = (JTable)child).getTableHeader() == null) {
                    return null;
                }
            }
            if ((at = ac.getAccessibleTable()) != null) {
                return at.getAccessibleColumnHeader();
            }
        }
        this.debugString(" ##### getAccessibleTableColumnHeader FAILED");
        return null;
    }

    public int getAccessibleTableRowHeaderRowCount(AccessibleContext ac) {
        AccessibleTable atRowHeader;
        this.debugString(" #####  getAccessibleTableRowHeaderRowCount called");
        if (ac != null && (atRowHeader = this.getAccessibleTableRowHeader(ac)) != null) {
            return atRowHeader.getAccessibleRowCount();
        }
        this.debugString(" ##### getAccessibleTableRowHeaderRowCount FAILED");
        return -1;
    }

    public int getAccessibleTableRowHeaderColumnCount(AccessibleContext ac) {
        AccessibleTable atRowHeader;
        this.debugString(" #####  getAccessibleTableRowHeaderColumnCount called");
        if (ac != null && (atRowHeader = this.getAccessibleTableRowHeader(ac)) != null) {
            return atRowHeader.getAccessibleColumnCount();
        }
        this.debugString(" ##### getAccessibleTableRowHeaderColumnCount FAILED");
        return -1;
    }

    public int getAccessibleTableColumnHeaderRowCount(AccessibleContext ac) {
        AccessibleTable atColumnHeader;
        this.debugString("##### getAccessibleTableColumnHeaderRowCount");
        if (ac != null && (atColumnHeader = this.getAccessibleTableColumnHeader(ac)) != null) {
            return atColumnHeader.getAccessibleRowCount();
        }
        this.debugString(" ##### getAccessibleTableColumnHeaderRowCount FAILED");
        return -1;
    }

    public int getAccessibleTableColumnHeaderColumnCount(AccessibleContext ac) {
        AccessibleTable atColumnHeader;
        this.debugString("#####  getAccessibleTableColumnHeaderColumnCount");
        if (ac != null && (atColumnHeader = this.getAccessibleTableColumnHeader(ac)) != null) {
            return atColumnHeader.getAccessibleColumnCount();
        }
        this.debugString(" ##### getAccessibleTableColumnHeaderColumnCount FAILED");
        return -1;
    }

    public AccessibleContext getAccessibleTableRowDescription(AccessibleTable table, int row) {
        Accessible a;
        if (table != null && (a = table.getAccessibleRowDescription(row)) != null) {
            return a.getAccessibleContext();
        }
        return null;
    }

    public AccessibleContext getAccessibleTableColumnDescription(AccessibleTable at, int column) {
        Accessible a;
        if (at != null && (a = at.getAccessibleColumnDescription(column)) != null) {
            return a.getAccessibleContext();
        }
        return null;
    }

    public int getAccessibleTableRowSelectionCount(AccessibleTable at) {
        if (at != null) {
            int[] selections = at.getSelectedAccessibleRows();
            return selections.length;
        }
        return -1;
    }

    public int getAccessibleTableRowSelections(AccessibleTable at, int i) {
        int[] selections;
        if (at != null && (selections = at.getSelectedAccessibleRows()).length > i) {
            return selections[i];
        }
        return -1;
    }

    public boolean isAccessibleTableRowSelected(AccessibleTable at, int row) {
        if (at != null) {
            return at.isAccessibleRowSelected(row);
        }
        return false;
    }

    public boolean isAccessibleTableColumnSelected(AccessibleTable at, int column) {
        if (at != null) {
            return at.isAccessibleColumnSelected(column);
        }
        return false;
    }

    public int getAccessibleTableColumnSelectionCount(AccessibleTable at) {
        if (at != null) {
            int[] selections = at.getSelectedAccessibleColumns();
            return selections.length;
        }
        return -1;
    }

    public int getAccessibleTableColumnSelections(AccessibleTable at, int i) {
        int[] selections;
        if (at != null && (selections = at.getSelectedAccessibleColumns()).length > i) {
            return selections[i];
        }
        return -1;
    }

    public int getAccessibleTableRow(AccessibleTable at, int index) {
        if (!this.runningOnJDK1_4) {
            return index / at.getAccessibleColumnCount();
        }
        if (at instanceof AccessibleExtendedTable) {
            return index / at.getAccessibleColumnCount();
        }
        return index / at.getAccessibleColumnCount();
    }

    public int getAccessibleTableColumn(AccessibleTable at, int index) {
        if (!this.runningOnJDK1_4) {
            return index % at.getAccessibleColumnCount();
        }
        if (at instanceof AccessibleExtendedTable) {
            return index % at.getAccessibleColumnCount();
        }
        return index % at.getAccessibleColumnCount();
    }

    public int getAccessibleTableIndex(AccessibleTable at, int row, int column) {
        if (!this.runningOnJDK1_4) {
            return row * at.getAccessibleColumnCount() + column;
        }
        if (at instanceof AccessibleExtendedTable) {
            return row * at.getAccessibleColumnCount() + column;
        }
        return row * at.getAccessibleColumnCount() + column;
    }

    public int getAccessibleRelationCount(AccessibleContext ac) {
        String version = this.getJavaVersionProperty();
        if (version != null && version.compareTo("1.3") >= 0 && ac != null) {
            AccessibleRelationSet ars = ac.getAccessibleRelationSet();
            return ars.size();
        }
        return 0;
    }

    public String getAccessibleRelationKey(AccessibleContext ac, int i) {
        if (ac != null) {
            AccessibleRelationSet ars = ac.getAccessibleRelationSet();
            AccessibleRelation[] relations = ars.toArray();
            if (i >= 0 && i < relations.length) {
                return relations[i].getKey();
            }
        }
        return null;
    }

    public int getAccessibleRelationTargetCount(AccessibleContext ac, int i) {
        if (ac != null) {
            AccessibleRelationSet ars = ac.getAccessibleRelationSet();
            AccessibleRelation[] relations = ars.toArray();
            if (i >= 0 && i < relations.length) {
                Object[] targets = relations[i].getTarget();
                return targets.length;
            }
        }
        return -1;
    }

    public AccessibleContext getAccessibleRelationTarget(AccessibleContext ac, int i, int j) {
        this.debugString("***** getAccessibleRelationTarget");
        if (ac != null) {
            Object[] targets;
            AccessibleRelationSet ars = ac.getAccessibleRelationSet();
            AccessibleRelation[] relations = ars.toArray();
            if (i >= 0 && i < relations.length && j >= 0 & j < (targets = relations[i].getTarget()).length) {
                Object o = targets[j];
                this.debugString("***** target=" + o.getClass());
                if (o instanceof Accessible) {
                    return ((Accessible)o).getAccessibleContext();
                }
            }
        }
        return null;
    }

    AccessibleHypertext getAccessibleHypertext(AccessibleContext ac) {
        this.debugString("getAccessibleHyperlink");
        if (ac == null) {
            return null;
        }
        AccessibleText at = ac.getAccessibleText();
        if (!(at instanceof AccessibleHypertext)) {
            return null;
        }
        return (AccessibleHypertext)at;
    }

    int getAccessibleHyperlinkCount(AccessibleContext ac) {
        this.debugString("getAccessibleHyperlinkCount");
        if (ac == null) {
            return 0;
        }
        AccessibleHypertext hypertext = this.getAccessibleHypertext(ac);
        if (hypertext == null) {
            return 0;
        }
        return hypertext.getLinkCount();
    }

    AccessibleHyperlink getAccessibleHyperlink(AccessibleHypertext hypertext, int i) {
        this.debugString("getAccessibleHyperlink");
        if (hypertext == null) {
            return null;
        }
        if (i < 0 || i >= hypertext.getLinkCount()) {
            return null;
        }
        AccessibleHyperlink link = hypertext.getLink(i);
        if (link == null || !link.isValid()) {
            return null;
        }
        return link;
    }

    String getAccessibleHyperlinkText(AccessibleHyperlink link) {
        this.debugString("getAccessibleHyperlinkText");
        if (link == null) {
            return null;
        }
        String o = link.getAccessibleActionDescription(0);
        if (o != null) {
            this.debugString(" description = " + o);
            return o.toString();
        }
        return null;
    }

    String getAccessibleHyperlinkURL(AccessibleHyperlink link) {
        this.debugString("getAccessibleHyperlinkURL");
        if (link == null) {
            return null;
        }
        Object o = link.getAccessibleActionObject(0);
        if (o != null) {
            this.debugString("   URL = " + o);
            return o.toString();
        }
        return null;
    }

    int getAccessibleHyperlinkStartIndex(AccessibleHyperlink link) {
        this.debugString("getAccessibleHyperlinkStartIndex");
        if (link == null) {
            return -1;
        }
        return link.getStartIndex();
    }

    int getAccessibleHyperlinkEndIndex(AccessibleHyperlink link) {
        this.debugString("getAccessibleHyperlinkEndIndex");
        if (link == null) {
            return -1;
        }
        return link.getEndIndex();
    }

    int getAccessibleHypertextLinkIndex(AccessibleHypertext hypertext, int charIndex) {
        this.debugString("getAccessibleHypertextLinkIndex: charIndex = " + charIndex);
        if (hypertext == null) {
            return -1;
        }
        int linkIndex = hypertext.getLinkIndex(charIndex);
        this.debugString("getAccessibleHypertextLinkIndex returning " + linkIndex);
        return linkIndex;
    }

    boolean activateAccessibleHyperlink(AccessibleContext ac, AccessibleHyperlink link) {
        this.debugString("activateAccessibleHyperlink: link = " + link.getClass());
        if (link == null) {
            return false;
        }
        boolean retval = link.doAccessibleAction(0);
        this.debugString("activateAccessibleHyperlink: returning = " + retval);
        return retval;
    }

    private KeyStroke getMnemonic(AccessibleContext ac) {
        Object o;
        AccessibleComponent comp = ac.getAccessibleComponent();
        if (!(comp instanceof AccessibleExtendedComponent)) {
            return null;
        }
        AccessibleExtendedComponent aec = (AccessibleExtendedComponent)comp;
        AccessibleKeyBinding akb = aec.getAccessibleKeyBinding();
        if (akb != null && (o = akb.getAccessibleKeyBinding(0)) instanceof KeyStroke) {
            return (KeyStroke)o;
        }
        return null;
    }

    private KeyStroke getAccelerator(AccessibleContext ac) {
        Accessible parent = ac.getAccessibleParent();
        if (parent instanceof Accessible) {
            int indexInParent = ac.getAccessibleIndexInParent();
            Accessible child = parent.getAccessibleContext().getAccessibleChild(indexInParent);
            if (child instanceof JMenuItem) {
                JMenuItem menuItem = (JMenuItem)child;
                KeyStroke keyStroke = menuItem.getAccelerator();
                this.debugString("getAccelerator = " + keyStroke);
                return keyStroke;
            }
        }
        return null;
    }

    private char getKeyChar(KeyStroke keyStroke) {
        CharSequence seq;
        String keyText = KeyEvent.getKeyText(keyStroke.getKeyCode());
        this.debugString("   key text = " + keyText);
        if (!(keyText == null && keyText.length() <= 0 || (seq = keyText.subSequence(0, 1)) == null && seq.length() <= 0)) {
            return seq.charAt(0);
        }
        return '\u0000';
    }

    private int getModifiers(KeyStroke keyStroke) {
        int modifiers = 0;
        String text = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
        if (text.indexOf("Meta") >= 0) {
            modifiers |= 4;
        }
        if (text.indexOf("Ctrl") >= 0) {
            modifiers |= 2;
        }
        if (text.indexOf("Alt") >= 0) {
            modifiers |= 8;
        }
        if (text.indexOf("Shift") >= 0) {
            modifiers |= 1;
        }
        this.debugString("getModifiers: text = " + text + "; modifiers = " + modifiers);
        return modifiers;
    }

    int getAccessibleKeyBindingsCount(AccessibleContext ac) {
        this.debugString("getAccessibleKeyBindingsCount");
        if (ac == null || !this.runningOnJDK1_4) {
            return 0;
        }
        int count = 0;
        if (this.getMnemonic(ac) != null) {
            ++count;
        }
        if (this.getAccelerator(ac) != null) {
            ++count;
        }
        return count;
    }

    char getAccessibleKeyBindingChar(AccessibleContext ac, int index) {
        KeyStroke keyStroke;
        this.debugString("getAccessibleKeyBindingChar: index = " + index);
        if (ac == null || !this.runningOnJDK1_4) {
            return '\u0000';
        }
        if (index == 0) {
            KeyStroke keyStroke2 = this.getMnemonic(ac);
            if (keyStroke2 != null) {
                return this.getKeyChar(keyStroke2);
            }
        } else if (index == 1 && (keyStroke = this.getAccelerator(ac)) != null) {
            return this.getKeyChar(keyStroke);
        }
        return '\u0000';
    }

    int getAccessibleKeyBindingModifiers(AccessibleContext ac, int index) {
        KeyStroke keyStroke;
        this.debugString("getAccessibleKeyBindingModifiers: index = " + index);
        if (ac == null || !this.runningOnJDK1_4) {
            return 0;
        }
        if (index == 0) {
            KeyStroke keyStroke2 = this.getMnemonic(ac);
            if (keyStroke2 != null) {
                return this.getModifiers(keyStroke2);
            }
        } else if (index == 1 && (keyStroke = this.getAccelerator(ac)) != null) {
            return this.getModifiers(keyStroke);
        }
        return 0;
    }

    int getAccessibleIconsCount(AccessibleContext ac) {
        this.debugString("getAccessibleIconsCount");
        if (ac == null) {
            return 0;
        }
        AccessibleIcon[] ai = ac.getAccessibleIcon();
        if (ai == null) {
            return 0;
        }
        this.debugString("   #icons = " + ai.length);
        return ai.length;
    }

    String getAccessibleIconDescription(AccessibleContext ac, int index) {
        this.debugString("getAccessibleIconDescription: index = " + index);
        if (ac == null) {
            return null;
        }
        AccessibleIcon[] ai = ac.getAccessibleIcon();
        if (ai == null || index < 0 || index >= ai.length) {
            return null;
        }
        this.debugString("   icon description    = " + ai[index].getAccessibleIconDescription());
        return ai[index].getAccessibleIconDescription();
    }

    int getAccessibleIconHeight(AccessibleContext ac, int index) {
        this.debugString("getAccessibleIconHeight: index = " + index);
        if (ac == null) {
            return 0;
        }
        AccessibleIcon[] ai = ac.getAccessibleIcon();
        if (ai == null || index < 0 || index >= ai.length) {
            return 0;
        }
        this.debugString("   icon height    = " + ai[index].getAccessibleIconHeight());
        return ai[index].getAccessibleIconHeight();
    }

    int getAccessibleIconWidth(AccessibleContext ac, int index) {
        this.debugString("getAccessibleIconWidth: index = " + index);
        if (ac == null) {
            return 0;
        }
        AccessibleIcon[] ai = ac.getAccessibleIcon();
        if (ai == null || index < 0 || index >= ai.length) {
            return 0;
        }
        this.debugString("   icon height    = " + ai[index].getAccessibleIconWidth());
        return ai[index].getAccessibleIconWidth();
    }

    int getAccessibleActionsCount(AccessibleContext ac) {
        this.debugString("getAccessibleActionsCount");
        if (ac == null) {
            return 0;
        }
        AccessibleAction aa = ac.getAccessibleAction();
        if (aa == null) {
            return 0;
        }
        this.debugString("   #actions = " + aa.getAccessibleActionCount());
        return aa.getAccessibleActionCount();
    }

    String getAccessibleActionName(AccessibleContext ac, int index) {
        this.debugString("getAccessibleActionName: index = " + index);
        if (ac == null) {
            return null;
        }
        AccessibleAction aa = ac.getAccessibleAction();
        if (aa == null) {
            return null;
        }
        this.debugString("   action name    = " + aa.getAccessibleActionDescription(index));
        return aa.getAccessibleActionDescription(index);
    }

    boolean doAccessibleActions(AccessibleContext ac, String name) {
        this.debugString("doAccessibleActions: action name = " + name);
        if (ac == null || name == null) {
            return false;
        }
        AccessibleAction aa = ac.getAccessibleAction();
        if (aa == null) {
            return false;
        }
        int index = -1;
        int numActions = aa.getAccessibleActionCount();
        for (int i = 0; i < numActions; ++i) {
            String actionName = aa.getAccessibleActionDescription(i);
            if (!name.equals(actionName)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            this.debugString("  no such action: " + name);
            return false;
        }
        this.debugString(" doing action #" + index + ": " + name);
        boolean retval = aa.doAccessibleAction(index);
        this.debugString(" action " + name + ": " + retval);
        return retval;
    }

    boolean setTextContents(AccessibleContext ac, String text) {
        this.debugString("setTextContents: ac = " + ac + "; text = " + text);
        if (!(ac instanceof AccessibleEditableText)) {
            this.debugString("   ac not instanceof AccessibleEditableText: " + ac);
            return false;
        }
        if (text == null) {
            this.debugString("   text is null");
            return false;
        }
        AccessibleStateSet ass = ac.getAccessibleStateSet();
        if (!ass.contains(AccessibleState.ENABLED)) {
            this.debugString("   text is not editable");
            return false;
        }
        ((AccessibleEditableText)((Object)ac)).setTextContents(text);
        this.debugString("   setTextContents succeeded");
        return true;
    }

    AccessibleContext getInternalFrame(AccessibleContext ac) {
        return this.getParentWithRole(ac, AccessibleRole.INTERNAL_FRAME.toString());
    }

    private AccessibleContext getTopLevelObject(AccessibleContext ac) {
        this.debugString("getTopLevelObject; ac = " + ac);
        if (ac == null) {
            return null;
        }
        if (ac.getAccessibleRole() == AccessibleRole.DIALOG) {
            return ac;
        }
        Accessible parent = ac.getAccessibleParent();
        if (parent == null) {
            this.debugString("   getTopLevelObject; returning: " + ac);
            return ac;
        }
        Accessible tmp = parent;
        while (tmp != null && tmp.getAccessibleContext() != null) {
            AccessibleContext ac2 = tmp.getAccessibleContext();
            if (ac2.getAccessibleRole() == AccessibleRole.DIALOG) {
                return ac2;
            }
            this.debugString("   getTopLevelObject; next parent = " + tmp.getAccessibleContext().getClass());
            parent = tmp;
            tmp = parent.getAccessibleContext().getAccessibleParent();
        }
        this.debugString("   getTopLevelObject; returning: " + parent.getAccessibleContext().getClass());
        return parent.getAccessibleContext();
    }

    public AccessibleContext getParentWithRole(AccessibleContext ac, String roleName) {
        this.debugString("getParentWithRole; ac = " + ac + "; role = " + roleName);
        if (ac == null || roleName == null) {
            return null;
        }
        AccessibleRole role = (AccessibleRole)this.accessibleRoleMap.get(roleName);
        if (role == null) {
            this.debugString("   getParentWithRole; no such role: " + roleName);
            return ac;
        }
        Accessible parent = ac.getAccessibleParent();
        if (parent == null && ac.getAccessibleRole() == role) {
            this.debugString("   getParentWithRole; returning ac: " + ac.getClass());
            return ac;
        }
        Accessible tmp = parent;
        AccessibleContext tmp_ac = null;
        while (tmp != null && (tmp_ac = tmp.getAccessibleContext()) != null) {
            this.debugString("   getParentWithRole; next parent = " + tmp_ac.getClass());
            AccessibleRole ar = tmp_ac.getAccessibleRole();
            if (ar == role) {
                this.debugString("   getParentWithRole; returning tmp_ac: " + tmp_ac.getClass());
                return tmp_ac;
            }
            parent = tmp;
            tmp = parent.getAccessibleContext().getAccessibleParent();
        }
        this.debugString("   getParentWithRole; parent not found");
        return null;
    }

    AccessibleContext getParentWithRoleElseRoot(AccessibleContext ac, String roleName) {
        AccessibleContext retval = this.getParentWithRole(ac, roleName);
        if (retval == null) {
            retval = this.getTopLevelObject(ac);
        }
        return retval;
    }

    int getObjectDepth(AccessibleContext ac) {
        this.debugString("getObjectDepth: ac = " + ac);
        int count = 0;
        if (ac == null) {
            return -1;
        }
        Accessible parent = ac.getAccessibleParent();
        if (parent == null) {
            this.debugString("   getObjectDepth: count = " + count);
            return count;
        }
        Accessible tmp = parent;
        while (tmp != null && tmp.getAccessibleContext() != null) {
            this.debugString("   getTopLevelObject; next parent = " + tmp.getAccessibleContext().getClass());
            parent = tmp;
            tmp = parent.getAccessibleContext().getAccessibleParent();
            ++count;
        }
        this.debugString("   getObjectDepth: count = " + count);
        return count;
    }

    AccessibleContext getActiveDescendent(AccessibleContext ac) {
        AccessibleSelection as;
        this.debugString("getActiveDescendent: ac = " + ac);
        if (ac == null) {
            return null;
        }
        Accessible parent = ac.getAccessibleParent();
        if (parent instanceof Accessible) {
            int indexInParent = ac.getAccessibleIndexInParent();
            Accessible child = parent.getAccessibleContext().getAccessibleChild(indexInParent);
            if (child instanceof JTree) {
                JTree tree = (JTree)child;
                return new AccessibleJTreeNode(tree, tree.getSelectionPath(), null);
            }
        }
        if ((as = ac.getAccessibleSelection()) == null) {
            this.debugString("   getActiveDescendent: no selection");
            return null;
        }
        if (as.getAccessibleSelectionCount() != 1) {
            this.debugString("   getActiveDescendent: selection count > 1");
            return null;
        }
        Accessible a = as.getAccessibleSelection(0);
        if (a == null) {
            this.debugString("   getActiveDescendent: selection is null");
            return null;
        }
        this.debugString("   getActiveDescendent: returning: " + a.getAccessibleContext());
        return a.getAccessibleContext();
    }

    String getJAWSAccessibleName(AccessibleContext ac) {
        this.debugString("getJAWSAccessibleName");
        if (ac == null) {
            return null;
        }
        String name = ac.getAccessibleName();
        this.debugString("    getJAWSAccessibleName: name = " + name);
        return name;
    }

    boolean requestFocus(AccessibleContext ac) {
        this.debugString("requestFocus");
        if (ac == null) {
            return false;
        }
        AccessibleComponent acomp = ac.getAccessibleComponent();
        if (acomp == null) {
            return false;
        }
        acomp.requestFocus();
        boolean result = ac.getAccessibleStateSet().contains(AccessibleState.FOCUSED);
        this.debugString("    GGGG requestFocus: result = " + result);
        return result;
    }

    boolean selectTextRange(AccessibleContext ac, int startIndex, int endIndex) {
        this.debugString("selectTextRange: start = " + startIndex + "; end = " + endIndex);
        if (ac == null) {
            return false;
        }
        AccessibleText at = ac.getAccessibleText();
        if (!(at instanceof AccessibleEditableText)) {
            return false;
        }
        ((AccessibleEditableText)at).selectText(startIndex, endIndex);
        boolean result = at.getSelectionStart() == startIndex && at.getSelectionEnd() == endIndex;
        this.debugString("    selectTextRange: result = " + result);
        return result;
    }

    boolean setCaretPosition(AccessibleContext ac, int position) {
        this.debugString("setCaretPosition: position = " + position);
        if (ac == null) {
            return false;
        }
        AccessibleText at = ac.getAccessibleText();
        if (!(at instanceof AccessibleEditableText)) {
            return false;
        }
        ((AccessibleEditableText)at).selectText(position, position);
        boolean result = at.getCaretPosition() == position;
        this.debugString("    setCaretPosition: result = " + result);
        return result;
    }

    int getVisibleChildrenCount(AccessibleContext ac) {
        this.debugString("getVisibleChildrenCount");
        if (ac == null) {
            return -1;
        }
        this._visibleChildrenCount = 0;
        this._getVisibleChildrenCount(ac);
        this.debugString("  _visibleChildrenCount = " + this._visibleChildrenCount);
        return this._visibleChildrenCount;
    }

    private void _getVisibleChildrenCount(AccessibleContext ac) {
        int numChildren = ac.getAccessibleChildrenCount();
        for (int i = 0; i < numChildren; ++i) {
            Accessible a = ac.getAccessibleChild(i);
            AccessibleContext ac2 = a.getAccessibleContext();
            if (ac2 == null || !ac2.getAccessibleStateSet().contains(AccessibleState.SHOWING)) continue;
            ++this._visibleChildrenCount;
            if (ac2.getAccessibleChildrenCount() <= 0) continue;
            this._getVisibleChildrenCount(ac2);
        }
    }

    AccessibleContext getVisibleChild(AccessibleContext ac, int index) {
        this.debugString("getVisibleChild: index = " + index);
        if (ac == null) {
            return null;
        }
        this._visibleChild = null;
        this._currentVisibleIndex = 0;
        this._foundVisibleChild = false;
        this._getVisibleChild(ac, index);
        if (this._visibleChild != null) {
            this.debugString("    getVisibleChild: found child = " + this._visibleChild.getAccessibleName());
        }
        return this._visibleChild;
    }

    private void _getVisibleChild(AccessibleContext ac, int index) {
        if (this._visibleChild != null) {
            return;
        }
        int numChildren = ac.getAccessibleChildrenCount();
        for (int i = 0; i < numChildren; ++i) {
            Accessible a = ac.getAccessibleChild(i);
            AccessibleContext ac2 = a.getAccessibleContext();
            if (ac2 == null || !ac2.getAccessibleStateSet().contains(AccessibleState.SHOWING)) continue;
            if (!this._foundVisibleChild && this._currentVisibleIndex == index) {
                this._visibleChild = ac2;
                this._foundVisibleChild = true;
                return;
            }
            ++this._currentVisibleIndex;
            if (ac2.getAccessibleChildrenCount() <= 0) continue;
            this._getVisibleChild(ac2, index);
        }
    }

    public native void propertyCaretChange(PropertyChangeEvent var1, AccessibleContext var2, int var3, int var4);

    public native void propertyDescriptionChange(PropertyChangeEvent var1, AccessibleContext var2, String var3, String var4);

    public native void propertyNameChange(PropertyChangeEvent var1, AccessibleContext var2, String var3, String var4);

    public native void propertySelectionChange(PropertyChangeEvent var1, AccessibleContext var2);

    public native void propertyStateChange(PropertyChangeEvent var1, AccessibleContext var2, String var3, String var4);

    public native void propertyTextChange(PropertyChangeEvent var1, AccessibleContext var2);

    public native void propertyValueChange(PropertyChangeEvent var1, AccessibleContext var2, String var3, String var4);

    public native void propertyVisibleDataChange(PropertyChangeEvent var1, AccessibleContext var2);

    public native void propertyChildChange(PropertyChangeEvent var1, AccessibleContext var2, AccessibleContext var3, AccessibleContext var4);

    public native void propertyActiveDescendentChange(PropertyChangeEvent var1, AccessibleContext var2, AccessibleContext var3, AccessibleContext var4);

    public native void javaShutdown();

    public native void focusGained(FocusEvent var1, AccessibleContext var2);

    public native void focusLost(FocusEvent var1, AccessibleContext var2);

    public native void caretUpdate(CaretEvent var1, AccessibleContext var2);

    public native void mouseClicked(MouseEvent var1, AccessibleContext var2);

    public native void mouseEntered(MouseEvent var1, AccessibleContext var2);

    public native void mouseExited(MouseEvent var1, AccessibleContext var2);

    public native void mousePressed(MouseEvent var1, AccessibleContext var2);

    public native void mouseReleased(MouseEvent var1, AccessibleContext var2);

    public native void menuCanceled(MenuEvent var1, AccessibleContext var2);

    public native void menuDeselected(MenuEvent var1, AccessibleContext var2);

    public native void menuSelected(MenuEvent var1, AccessibleContext var2);

    public native void popupMenuCanceled(PopupMenuEvent var1, AccessibleContext var2);

    public native void popupMenuWillBecomeInvisible(PopupMenuEvent var1, AccessibleContext var2);

    public native void popupMenuWillBecomeVisible(PopupMenuEvent var1, AccessibleContext var2);

    public void addJavaEventNotification(long type) {
        this.eventHandler.addJavaEventNotification(type);
    }

    public void removeJavaEventNotification(long type) {
        this.eventHandler.removeJavaEventNotification(type);
    }

    public void addAccessibilityEventNotification(long type) {
        this.eventHandler.addAccessibilityEventNotification(type);
    }

    public void removeAccessibilityEventNotification(long type) {
        this.eventHandler.removeAccessibilityEventNotification(type);
    }

    private static String GetNativeLibPath(String libName) {
        String str2 = null;
        try {
            String processArchitecture;
            String location = ClickniumJavaBridge.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            int i = location.lastIndexOf("/");
            if (i != -1) {
                location = location.substring(0, i);
            }
            try {
                String rootPath_ = URLDecoder.decode(location, "utf-8");
                File f = new File(rootPath_);
                str2 = f.getAbsolutePath();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (str2.endsWith("\\ext")) {
                str2 = str2 + "\\..\\..\\bin";
            }
            str2 = (processArchitecture = System.getProperty("sun.arch.data.model")) != null && processArchitecture.equals("64") ? str2 + "\\" + libName + "-64.dll" : str2 + "\\" + libName + "-32.dll";
            str2 = new File(str2).getCanonicalPath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str2;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String javaBridgeDLLPath = ClickniumJavaBridge.GetNativeLibPath("ClickniumJavaBridge");
                System.load(javaBridgeDLLPath);
                System.out.println("Load ClickniumJavaBridge native library from:" + javaBridgeDLLPath);
                return null;
            }
        });
        windowHandleToContextMap = new Hashtable();
        contextToWindowHandleMap = new Hashtable();
        nativeWindowHandlers = new Vector();
    }

    protected class AccessibleJTreeNode
    extends AccessibleContext
    implements Accessible,
    AccessibleComponent,
    AccessibleSelection,
    AccessibleAction {
        private JTree tree = null;
        private TreeModel treeModel = null;
        private Object obj = null;
        private TreePath path = null;
        private Accessible accessibleParent = null;
        private int index = 0;
        private boolean isLeaf = false;

        public AccessibleJTreeNode(JTree t, TreePath p, Accessible ap) {
            this.tree = t;
            this.path = p;
            this.accessibleParent = ap;
            this.treeModel = t.getModel();
            if (p != null) {
                this.obj = p.getLastPathComponent();
                if (this.treeModel != null && this.obj != null) {
                    this.isLeaf = this.treeModel.isLeaf(this.obj);
                }
            }
            ClickniumJavaBridge.this.debugString("AccessibleJTreeNode: name = " + this.getAccessibleName() + "; TreePath = " + p + "; parent = " + ap);
        }

        private TreePath getChildTreePath(int i) {
            if (i < 0 || i >= this.getAccessibleChildrenCount() || this.path == null) {
                return null;
            }
            Object childObj = this.treeModel.getChild(this.obj, i);
            Object[] objPath = this.path.getPath();
            Object[] objChildPath = new Object[objPath.length + 1];
            System.arraycopy(objPath, 0, objChildPath, 0, objPath.length);
            objChildPath[objChildPath.length - 1] = childObj;
            return new TreePath(objChildPath);
        }

        public AccessibleContext getAccessibleContext() {
            return this;
        }

        private AccessibleContext getCurrentAccessibleContext() {
            Component c = this.getCurrentComponent();
            if (c instanceof Accessible) {
                return ((Accessible)((Object)c)).getAccessibleContext();
            }
            return null;
        }

        private Component getCurrentComponent() {
            ClickniumJavaBridge.this.debugString("AccessibleJTreeNode: getCurrentComponent");
            if (this.tree.isVisible(this.path)) {
                TreeCellRenderer r = this.tree.getCellRenderer();
                if (r == null) {
                    ClickniumJavaBridge.this.debugString("  returning null 1");
                    return null;
                }
                TreeUI ui = this.tree.getUI();
                if (ui != null) {
                    int row = ui.getRowForPath(this.tree, this.path);
                    boolean selected = this.tree.isPathSelected(this.path);
                    boolean expanded = this.tree.isExpanded(this.path);
                    boolean hasFocus = false;
                    Component retval = r.getTreeCellRendererComponent(this.tree, this.obj, selected, expanded, this.isLeaf, row, hasFocus);
                    ClickniumJavaBridge.this.debugString("  returning = " + retval.getClass());
                    return retval;
                }
            }
            ClickniumJavaBridge.this.debugString("  returning null 2");
            return null;
        }

        public String getAccessibleName() {
            ClickniumJavaBridge.this.debugString("AccessibleJTreeNode: getAccessibleName");
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac != null) {
                String name = ac.getAccessibleName();
                if (name != null && name != "") {
                    String retval = ac.getAccessibleName();
                    ClickniumJavaBridge.this.debugString("    returning " + retval);
                    return retval;
                }
                return null;
            }
            if (this.accessibleName != null && this.accessibleName != "") {
                return this.accessibleName;
            }
            return null;
        }

        public void setAccessibleName(String s) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac != null) {
                ac.setAccessibleName(s);
            } else {
                super.setAccessibleName(s);
            }
        }

        public String getAccessibleDescription() {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac != null) {
                return ac.getAccessibleDescription();
            }
            return super.getAccessibleDescription();
        }

        public void setAccessibleDescription(String s) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac != null) {
                ac.setAccessibleDescription(s);
            } else {
                super.setAccessibleDescription(s);
            }
        }

        public AccessibleRole getAccessibleRole() {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac != null) {
                return ac.getAccessibleRole();
            }
            return AccessibleRole.UNKNOWN;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            int row = this.tree.getUI().getRowForPath(this.tree, this.path);
            int lsr = this.tree.getLeadSelectionRow();
            AccessibleStateSet states = ac != null ? ac.getAccessibleStateSet() : new AccessibleStateSet();
            if (this.isShowing()) {
                states.add(AccessibleState.SHOWING);
            } else if (states.contains(AccessibleState.SHOWING)) {
                states.remove(AccessibleState.SHOWING);
            }
            if (this.isVisible()) {
                states.add(AccessibleState.VISIBLE);
            } else if (states.contains(AccessibleState.VISIBLE)) {
                states.remove(AccessibleState.VISIBLE);
            }
            if (this.tree.isPathSelected(this.path)) {
                states.add(AccessibleState.SELECTED);
            }
            if (lsr == row) {
                states.add(AccessibleState.ACTIVE);
            }
            if (!this.isLeaf) {
                states.add(AccessibleState.EXPANDABLE);
            }
            if (this.tree.isExpanded(this.path)) {
                states.add(AccessibleState.EXPANDED);
            } else {
                states.add(AccessibleState.COLLAPSED);
            }
            if (this.tree.isEditable()) {
                states.add(AccessibleState.EDITABLE);
            }
            return states;
        }

        public Accessible getAccessibleParent() {
            if (this.accessibleParent == null && this.path != null) {
                Object[] objPath = this.path.getPath();
                if (objPath.length > 1) {
                    Object objParent = objPath[objPath.length - 2];
                    if (this.treeModel != null) {
                        this.index = this.treeModel.getIndexOfChild(objParent, this.obj);
                    }
                    Object[] objParentPath = new Object[objPath.length - 1];
                    System.arraycopy(objPath, 0, objParentPath, 0, objPath.length - 1);
                    TreePath parentPath = new TreePath(objParentPath);
                    this.accessibleParent = new AccessibleJTreeNode(this.tree, parentPath, null);
                    this.setAccessibleParent(this.accessibleParent);
                } else if (this.treeModel != null) {
                    this.accessibleParent = this.tree;
                    this.index = 0;
                    this.setAccessibleParent(this.accessibleParent);
                }
            }
            return this.accessibleParent;
        }

        public int getAccessibleIndexInParent() {
            Object[] objPath;
            if (this.accessibleParent == null) {
                this.getAccessibleParent();
            }
            if (this.path != null && (objPath = this.path.getPath()).length > 1) {
                Object objParent = objPath[objPath.length - 2];
                if (this.treeModel != null) {
                    this.index = this.treeModel.getIndexOfChild(objParent, this.obj);
                }
            }
            return this.index;
        }

        public int getAccessibleChildrenCount() {
            if (this.obj != null) {
                return this.treeModel.getChildCount(this.obj);
            }
            return 0;
        }

        public Accessible getAccessibleChild(int i) {
            if (i < 0 || i >= this.getAccessibleChildrenCount() || this.path == null) {
                return null;
            }
            Object childObj = this.treeModel.getChild(this.obj, i);
            Object[] objPath = this.path.getPath();
            Object[] objChildPath = new Object[objPath.length + 1];
            System.arraycopy(objPath, 0, objChildPath, 0, objPath.length);
            objChildPath[objChildPath.length - 1] = childObj;
            TreePath childPath = new TreePath(objChildPath);
            return new AccessibleJTreeNode(this.tree, childPath, this);
        }

        public Locale getLocale() {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac != null) {
                return ac.getLocale();
            }
            return this.tree.getLocale();
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac != null) {
                ac.addPropertyChangeListener(l);
            } else {
                super.addPropertyChangeListener(l);
            }
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac != null) {
                ac.removePropertyChangeListener(l);
            } else {
                super.removePropertyChangeListener(l);
            }
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public AccessibleSelection getAccessibleSelection() {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac != null && this.isLeaf) {
                return this.getCurrentAccessibleContext().getAccessibleSelection();
            }
            return this;
        }

        public AccessibleText getAccessibleText() {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac != null) {
                return this.getCurrentAccessibleContext().getAccessibleText();
            }
            return null;
        }

        public AccessibleValue getAccessibleValue() {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac != null) {
                return this.getCurrentAccessibleContext().getAccessibleValue();
            }
            return null;
        }

        public Color getBackground() {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)ac)).getBackground();
            }
            Component c = this.getCurrentComponent();
            if (c != null) {
                return c.getBackground();
            }
            return null;
        }

        public void setBackground(Color c) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)ac)).setBackground(c);
            } else {
                Component cp = this.getCurrentComponent();
                if (cp != null) {
                    cp.setBackground(c);
                }
            }
        }

        public Color getForeground() {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)ac)).getForeground();
            }
            Component c = this.getCurrentComponent();
            if (c != null) {
                return c.getForeground();
            }
            return null;
        }

        public void setForeground(Color c) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)ac)).setForeground(c);
            } else {
                Component cp = this.getCurrentComponent();
                if (cp != null) {
                    cp.setForeground(c);
                }
            }
        }

        public Cursor getCursor() {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)ac)).getCursor();
            }
            Component c = this.getCurrentComponent();
            if (c != null) {
                return c.getCursor();
            }
            Accessible ap = this.getAccessibleParent();
            if (ap instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)ap)).getCursor();
            }
            return null;
        }

        public void setCursor(Cursor c) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)ac)).setCursor(c);
            } else {
                Component cp = this.getCurrentComponent();
                if (cp != null) {
                    cp.setCursor(c);
                }
            }
        }

        public Font getFont() {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)ac)).getFont();
            }
            Component c = this.getCurrentComponent();
            if (c != null) {
                return c.getFont();
            }
            return null;
        }

        public void setFont(Font f) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)ac)).setFont(f);
            } else {
                Component c = this.getCurrentComponent();
                if (c != null) {
                    c.setFont(f);
                }
            }
        }

        public FontMetrics getFontMetrics(Font f) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)ac)).getFontMetrics(f);
            }
            Component c = this.getCurrentComponent();
            if (c != null) {
                return c.getFontMetrics(f);
            }
            return null;
        }

        public boolean isEnabled() {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)ac)).isEnabled();
            }
            Component c = this.getCurrentComponent();
            if (c != null) {
                return c.isEnabled();
            }
            return false;
        }

        public void setEnabled(boolean b) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)ac)).setEnabled(b);
            } else {
                Component c = this.getCurrentComponent();
                if (c != null) {
                    c.setEnabled(b);
                }
            }
        }

        public boolean isVisible() {
            Rectangle pathBounds = this.tree.getPathBounds(this.path);
            Rectangle parentBounds = this.tree.getVisibleRect();
            return pathBounds != null && parentBounds != null && parentBounds.intersects(pathBounds);
        }

        public void setVisible(boolean b) {
        }

        public boolean isShowing() {
            return this.tree.isShowing() && this.isVisible();
        }

        public boolean contains(Point p) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                Rectangle r = ((AccessibleComponent)((Object)ac)).getBounds();
                return r.contains(p);
            }
            Component c = this.getCurrentComponent();
            if (c != null) {
                Rectangle r = c.getBounds();
                return r.contains(p);
            }
            return this.getBounds().contains(p);
        }

        public Point getLocationOnScreen() {
            if (this.tree != null) {
                Point treeLocation = this.tree.getLocationOnScreen();
                Rectangle pathBounds = this.tree.getPathBounds(this.path);
                if (treeLocation != null && pathBounds != null) {
                    Point nodeLocation = new Point(pathBounds.x, pathBounds.y);
                    nodeLocation.translate(treeLocation.x, treeLocation.y);
                    return nodeLocation;
                }
                return null;
            }
            return null;
        }

        protected Point getLocationInJTree() {
            Rectangle r = this.tree.getPathBounds(this.path);
            if (r != null) {
                return r.getLocation();
            }
            return null;
        }

        public Point getLocation() {
            Rectangle r = this.getBounds();
            if (r != null) {
                return r.getLocation();
            }
            return null;
        }

        public void setLocation(Point p) {
        }

        public Rectangle getBounds() {
            Rectangle r = this.tree.getPathBounds(this.path);
            Accessible parent = this.getAccessibleParent();
            if (parent instanceof AccessibleJTreeNode) {
                Point parentLoc = ((AccessibleJTreeNode)parent).getLocationInJTree();
                if (parentLoc != null && r != null) {
                    r.translate(-parentLoc.x, -parentLoc.y);
                } else {
                    return null;
                }
            }
            return r;
        }

        public void setBounds(Rectangle r) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)ac)).setBounds(r);
            } else {
                Component c = this.getCurrentComponent();
                if (c != null) {
                    c.setBounds(r);
                }
            }
        }

        public Dimension getSize() {
            return this.getBounds().getSize();
        }

        public void setSize(Dimension d) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)ac)).setSize(d);
            } else {
                Component c = this.getCurrentComponent();
                if (c != null) {
                    c.setSize(d);
                }
            }
        }

        public Accessible getAccessibleAt(Point p) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)ac)).getAccessibleAt(p);
            }
            return null;
        }

        public boolean isFocusTraversable() {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)ac)).isFocusTraversable();
            }
            Component c = this.getCurrentComponent();
            if (c != null) {
                return c.isFocusable();
            }
            return false;
        }

        public void requestFocus() {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)ac)).requestFocus();
            } else {
                Component c = this.getCurrentComponent();
                if (c != null) {
                    c.requestFocus();
                }
            }
        }

        public void addFocusListener(FocusListener l) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)ac)).addFocusListener(l);
            } else {
                Component c = this.getCurrentComponent();
                if (c != null) {
                    c.addFocusListener(l);
                }
            }
        }

        public void removeFocusListener(FocusListener l) {
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)ac)).removeFocusListener(l);
            } else {
                Component c = this.getCurrentComponent();
                if (c != null) {
                    c.removeFocusListener(l);
                }
            }
        }

        public int getAccessibleSelectionCount() {
            int count = 0;
            int childCount = this.getAccessibleChildrenCount();
            for (int i = 0; i < childCount; ++i) {
                TreePath childPath = this.getChildTreePath(i);
                if (!this.tree.isPathSelected(childPath)) continue;
                ++count;
            }
            return count;
        }

        public Accessible getAccessibleSelection(int i) {
            int childCount = this.getAccessibleChildrenCount();
            if (i < 0 || i >= childCount) {
                return null;
            }
            int count = 0;
            for (int j = 0; j < childCount && i >= count; ++j) {
                TreePath childPath = this.getChildTreePath(j);
                if (!this.tree.isPathSelected(childPath)) continue;
                if (count == i) {
                    return new AccessibleJTreeNode(this.tree, childPath, this);
                }
                ++count;
            }
            return null;
        }

        public boolean isAccessibleChildSelected(int i) {
            int childCount = this.getAccessibleChildrenCount();
            if (i < 0 || i >= childCount) {
                return false;
            }
            TreePath childPath = this.getChildTreePath(i);
            return this.tree.isPathSelected(childPath);
        }

        public void addAccessibleSelection(int i) {
            TreeModel model = this.tree.getModel();
            if (model != null && i >= 0 && i < this.getAccessibleChildrenCount()) {
                TreePath path = this.getChildTreePath(i);
                this.tree.addSelectionPath(path);
            }
        }

        public void removeAccessibleSelection(int i) {
            TreeModel model = this.tree.getModel();
            if (model != null && i >= 0 && i < this.getAccessibleChildrenCount()) {
                TreePath path = this.getChildTreePath(i);
                this.tree.removeSelectionPath(path);
            }
        }

        public void clearAccessibleSelection() {
            int childCount = this.getAccessibleChildrenCount();
            for (int i = 0; i < childCount; ++i) {
                this.removeAccessibleSelection(i);
            }
        }

        public void selectAllAccessibleSelection() {
            TreeModel model = this.tree.getModel();
            if (model != null) {
                int childCount = this.getAccessibleChildrenCount();
                for (int i = 0; i < childCount; ++i) {
                    TreePath path = this.getChildTreePath(i);
                    this.tree.addSelectionPath(path);
                }
            }
        }

        public int getAccessibleActionCount() {
            AccessibleAction aa;
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (ac != null && (aa = ac.getAccessibleAction()) != null) {
                return aa.getAccessibleActionCount() + (this.isLeaf ? 0 : 1);
            }
            return this.isLeaf ? 0 : 1;
        }

        public String getAccessibleActionDescription(int i) {
            AccessibleAction aa;
            if (i < 0 || i >= this.getAccessibleActionCount()) {
                return null;
            }
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (i == 0) {
                return "toggle expand";
            }
            if (ac != null && (aa = ac.getAccessibleAction()) != null) {
                return aa.getAccessibleActionDescription(i - 1);
            }
            return null;
        }

        public boolean doAccessibleAction(int i) {
            AccessibleAction aa;
            if (i < 0 || i >= this.getAccessibleActionCount()) {
                return false;
            }
            AccessibleContext ac = this.getCurrentAccessibleContext();
            if (i == 0) {
                if (this.tree.isExpanded(this.path)) {
                    this.tree.collapsePath(this.path);
                } else {
                    this.tree.expandPath(this.path);
                }
                return true;
            }
            if (ac != null && (aa = ac.getAccessibleAction()) != null) {
                return aa.doAccessibleAction(i - 1);
            }
            return false;
        }
    }

    class EventHandler
    implements PropertyChangeListener,
    FocusListener,
    CaretListener,
    MenuListener,
    PopupMenuListener,
    MouseListener,
    WindowListener,
    ChangeListener {
        ClickniumJavaBridge accessBridge;
        long javaEventMask = 0L;
        long accessibilityEventMask = 0L;
        AccessibleContext prevAC = null;
        private boolean stateChangeListenerAdded = false;

        public EventHandler(ClickniumJavaBridge bridge) {
            this.accessBridge = bridge;
        }

        public void windowOpened(WindowEvent e) {
            Object o = e.getSource();
            if (o instanceof NativeWindowHandler) {
                ClickniumJavaBridge.addNativeWindowHandler((NativeWindowHandler)o);
            }
        }

        public void windowClosing(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
            Object o = e.getSource();
            if (o instanceof NativeWindowHandler) {
                ClickniumJavaBridge.removeNativeWindowHandler((NativeWindowHandler)o);
            }
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void addJavaEventNotification(long type) {
            long newEventMask = this.javaEventMask | type;
            if ((this.javaEventMask & 6L) == 0L && (newEventMask & 6L) != 0L) {
                SwingEventMonitor.addFocusListener(this);
            }
            if ((this.javaEventMask & 8L) == 0L && (newEventMask & 8L) != 0L) {
                SwingEventMonitor.addCaretListener(this);
            }
            if ((this.javaEventMask & 0x1F0L) == 0L && (newEventMask & 0x1F0L) != 0L) {
                SwingEventMonitor.addMouseListener(this);
            }
            if ((this.javaEventMask & 0xE00L) == 0L && (newEventMask & 0xE00L) != 0L) {
                SwingEventMonitor.addMenuListener(this);
                SwingEventMonitor.addPopupMenuListener(this);
            }
            if ((this.javaEventMask & 0x7000L) == 0L && (newEventMask & 0x7000L) != 0L) {
                SwingEventMonitor.addPopupMenuListener(this);
            }
            this.javaEventMask = newEventMask;
        }

        public void removeJavaEventNotification(long type) {
            long newEventMask = this.javaEventMask & (type ^ 0xFFFFFFFFFFFFFFFFL);
            if ((this.javaEventMask & 6L) != 0L && (newEventMask & 6L) == 0L) {
                SwingEventMonitor.removeFocusListener(this);
            }
            if ((this.javaEventMask & 8L) != 0L && (newEventMask & 8L) == 0L) {
                SwingEventMonitor.removeCaretListener(this);
            }
            if ((this.javaEventMask & 0x1F0L) == 0L && (newEventMask & 0x1F0L) != 0L) {
                SwingEventMonitor.removeMouseListener(this);
            }
            if ((this.javaEventMask & 0xE00L) == 0L && (newEventMask & 0xE00L) != 0L) {
                SwingEventMonitor.removeMenuListener(this);
            }
            if ((this.javaEventMask & 0x7000L) == 0L && (newEventMask & 0x7000L) != 0L) {
                SwingEventMonitor.removePopupMenuListener(this);
            }
            this.javaEventMask = newEventMask;
        }

        public void addAccessibilityEventNotification(long type) {
            long newEventMask = this.accessibilityEventMask | type;
            if ((this.accessibilityEventMask & 0x3FFL) == 0L && (newEventMask & 0x3FFL) != 0L) {
                AccessibilityEventMonitor.addPropertyChangeListener(this);
            }
            this.accessibilityEventMask = newEventMask;
        }

        public void removeAccessibilityEventNotification(long type) {
            long newEventMask = this.accessibilityEventMask & (type ^ 0xFFFFFFFFFFFFFFFFL);
            if ((this.accessibilityEventMask & 0x3FFL) != 0L && (newEventMask & 0x3FFL) == 0L) {
                AccessibilityEventMonitor.removePropertyChangeListener(this);
            }
            this.accessibilityEventMask = newEventMask;
        }

        public void propertyChange(PropertyChangeEvent e) {
            this.accessBridge.debugString("propertyChange(" + e.toString() + ") called");
            if ((this.accessibilityEventMask & 0x3FFL) != 0L) {
                AccessibleContext ac;
                Object o = e.getSource();
                if (o instanceof AccessibleContext) {
                    ac = (AccessibleContext)o;
                } else {
                    Accessible a = Translator.getAccessible(e.getSource());
                    ac = a.getAccessibleContext();
                }
                if (ac != null) {
                    String propertyName = e.getPropertyName();
                    if (propertyName.compareTo("AccessibleCaret") == 0) {
                        int oldValue = 0;
                        int newValue = 0;
                        if (e.getOldValue() instanceof Integer) {
                            oldValue = (Integer)e.getOldValue();
                        }
                        if (e.getNewValue() instanceof Integer) {
                            newValue = (Integer)e.getNewValue();
                        }
                        this.accessBridge.debugString(" - about to call propertyCaretChange()");
                        this.accessBridge.propertyCaretChange(e, ac, oldValue, newValue);
                    } else if (propertyName.compareTo("AccessibleDescription") == 0) {
                        String oldValue = null;
                        String newValue = null;
                        if (e.getOldValue() != null) {
                            oldValue = e.getOldValue().toString();
                        }
                        if (e.getNewValue() != null) {
                            newValue = e.getNewValue().toString();
                        }
                        this.accessBridge.debugString(" - about to call propertyDescriptionChange()");
                        this.accessBridge.propertyDescriptionChange(e, ac, oldValue, newValue);
                    } else if (propertyName.compareTo("AccessibleName") == 0) {
                        String oldValue = null;
                        String newValue = null;
                        if (e.getOldValue() != null) {
                            oldValue = e.getOldValue().toString();
                        }
                        if (e.getNewValue() != null) {
                            newValue = e.getNewValue().toString();
                        }
                        this.accessBridge.debugString(" - about to call propertyNameChange()");
                        this.accessBridge.propertyNameChange(e, ac, oldValue, newValue);
                    } else if (propertyName.compareTo("AccessibleSelection") == 0) {
                        this.accessBridge.debugString(" - about to call propertySelectionChange()");
                        this.accessBridge.propertySelectionChange(e, ac);
                    } else if (propertyName.compareTo("AccessibleState") == 0) {
                        String oldValue = null;
                        String newValue = null;
                        if (e.getOldValue() != null) {
                            AccessibleState oldState = (AccessibleState)e.getOldValue();
                            oldValue = oldState.toDisplayString(Locale.US);
                        }
                        if (e.getNewValue() != null) {
                            AccessibleState newState = (AccessibleState)e.getNewValue();
                            newValue = newState.toDisplayString(Locale.US);
                        }
                        this.accessBridge.debugString(" - about to call propertyStateChange()");
                        this.accessBridge.propertyStateChange(e, ac, oldValue, newValue);
                    } else if (propertyName.compareTo("AccessibleText") == 0) {
                        this.accessBridge.debugString(" - about to call propertyTextChange()");
                        this.accessBridge.propertyTextChange(e, ac);
                    } else if (propertyName.compareTo("AccessibleValue") == 0) {
                        String oldValue = null;
                        String newValue = null;
                        if (e.getOldValue() != null) {
                            oldValue = e.getOldValue().toString();
                        }
                        if (e.getNewValue() != null) {
                            newValue = e.getNewValue().toString();
                        }
                        this.accessBridge.debugString(" - about to call propertyDescriptionChange()");
                        this.accessBridge.propertyValueChange(e, ac, oldValue, newValue);
                    } else if (propertyName.compareTo("AccessibleVisibleData") == 0) {
                        this.accessBridge.propertyVisibleDataChange(e, ac);
                    } else if (propertyName.compareTo("AccessibleChild") == 0) {
                        AccessibleContext oldAC = null;
                        AccessibleContext newAC = null;
                        if (e.getOldValue() instanceof AccessibleContext) {
                            oldAC = (AccessibleContext)e.getOldValue();
                        }
                        if (e.getNewValue() instanceof AccessibleContext) {
                            newAC = (AccessibleContext)e.getNewValue();
                        }
                        this.accessBridge.debugString(" - about to call propertyChildChange()");
                        this.accessBridge.propertyChildChange(e, ac, oldAC, newAC);
                    } else if (propertyName.compareTo("AccessibleActiveDescendant") == 0) {
                        this.handleActiveDescendentEvent(e, ac);
                    }
                }
            }
        }

        private void handleActiveDescendentEvent(PropertyChangeEvent e, AccessibleContext ac) {
            Accessible parent;
            Accessible a;
            AccessibleContext oldAC = null;
            AccessibleContext newAC = null;
            if (e.getOldValue() instanceof Accessible) {
                oldAC = ((Accessible)e.getOldValue()).getAccessibleContext();
            } else if (e.getOldValue() instanceof Component && (a = Translator.getAccessible(e.getOldValue())) != null) {
                oldAC = a.getAccessibleContext();
            }
            if (oldAC != null && (parent = oldAC.getAccessibleParent()) instanceof JTree) {
                oldAC = this.prevAC;
            }
            if (e.getNewValue() instanceof Accessible) {
                newAC = ((Accessible)e.getNewValue()).getAccessibleContext();
            } else if (e.getNewValue() instanceof Component && (a = Translator.getAccessible(e.getNewValue())) != null) {
                newAC = a.getAccessibleContext();
            }
            if (newAC != null && (parent = newAC.getAccessibleParent()) instanceof JTree) {
                JTree tree = (JTree)parent;
                newAC = new AccessibleJTreeNode(tree, tree.getSelectionPath(), null);
            }
            this.prevAC = newAC;
            this.accessBridge.debugString("  - about to call propertyActiveDescendentChange()");
            this.accessBridge.propertyActiveDescendentChange(e, ac, oldAC, newAC);
        }

        public void focusGained(FocusEvent e) {
            Accessible a;
            if (ClickniumJavaBridge.this.runningOnJDK1_4) {
                this.processFocusGained();
            } else if ((this.javaEventMask & 2L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                this.accessBridge.focusGained(e, a.getAccessibleContext());
            }
        }

        public void stateChanged(ChangeEvent e) {
            this.processFocusGained();
        }

        private void processFocusGained() {
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (focusOwner == null) {
                return;
            }
            if (focusOwner instanceof JRootPane) {
                MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
                if (path.length > 1) {
                    Component penult = path[path.length - 2].getComponent();
                    Component last = path[path.length - 1].getComponent();
                    if (last instanceof JPopupMenu) {
                        FocusEvent e = new FocusEvent(penult, 1004);
                        this.accessBridge.focusGained(e, ((Accessible)((Object)penult)).getAccessibleContext());
                    } else if (penult instanceof JPopupMenu) {
                        FocusEvent e = new FocusEvent(last, 1004);
                        this.accessBridge.focusGained(e, ((Accessible)((Object)last)).getAccessibleContext());
                    }
                }
            } else if (focusOwner instanceof Accessible) {
                FocusEvent e = new FocusEvent(focusOwner, 1004);
                this.accessBridge.focusGained(e, ((Accessible)((Object)focusOwner)).getAccessibleContext());
            }
        }

        public void focusLost(FocusEvent e) {
            Accessible a;
            if ((this.javaEventMask & 4L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                this.accessBridge.focusLost(e, a.getAccessibleContext());
            }
        }

        public void caretUpdate(CaretEvent e) {
            Accessible a;
            if ((this.javaEventMask & 8L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                this.accessBridge.caretUpdate(e, a.getAccessibleContext());
            }
        }

        public void mouseClicked(MouseEvent e) {
            Accessible a;
            if ((this.javaEventMask & 0x10L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                this.accessBridge.mouseClicked(e, a.getAccessibleContext());
            }
        }

        public void mouseEntered(MouseEvent e) {
            Accessible a;
            if ((this.javaEventMask & 0x20L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                this.accessBridge.mouseEntered(e, a.getAccessibleContext());
            }
        }

        public void mouseExited(MouseEvent e) {
            Accessible a;
            if ((this.javaEventMask & 0x40L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                this.accessBridge.mouseExited(e, a.getAccessibleContext());
            }
        }

        public void mousePressed(MouseEvent e) {
            Accessible a;
            if ((this.javaEventMask & 0x80L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                this.accessBridge.mousePressed(e, a.getAccessibleContext());
            }
        }

        public void mouseReleased(MouseEvent e) {
            Accessible a;
            if ((this.javaEventMask & 0x100L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                this.accessBridge.mouseReleased(e, a.getAccessibleContext());
            }
        }

        public void menuCanceled(MenuEvent e) {
            Accessible a;
            if ((this.javaEventMask & 0x200L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                this.accessBridge.menuCanceled(e, a.getAccessibleContext());
            }
        }

        public void menuDeselected(MenuEvent e) {
            Accessible a;
            if ((this.javaEventMask & 0x400L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                this.accessBridge.menuDeselected(e, a.getAccessibleContext());
            }
        }

        public void menuSelected(MenuEvent e) {
            Accessible a;
            if ((this.javaEventMask & 0x800L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                this.accessBridge.menuSelected(e, a.getAccessibleContext());
            }
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
            Accessible a;
            if ((this.javaEventMask & 0x1000L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                this.accessBridge.popupMenuCanceled(e, a.getAccessibleContext());
            }
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            Accessible a;
            if ((this.javaEventMask & 0x2000L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                this.accessBridge.popupMenuWillBecomeInvisible(e, a.getAccessibleContext());
            }
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            Accessible a;
            if ((this.javaEventMask & 0x4000L) != 0L && (a = Translator.getAccessible(e.getSource())) != null) {
                this.accessBridge.popupMenuWillBecomeVisible(e, a.getAccessibleContext());
            }
        }
    }

    protected class ObjectReferences {
        private Hashtable refs = new Hashtable(4);

        private String dump() {
            return this.refs.toString();
        }

        public void increment(Object o) {
            if (this.refs.containsKey(o)) {
                ++((Reference)this.refs.get((Object)o)).value;
            } else {
                this.refs.put(o, new Reference(1));
            }
        }

        public void decrement(Object o) {
            Reference aRef = (Reference)this.refs.get(o);
            if (aRef != null) {
                --aRef.value;
                if (aRef.value == 0) {
                    this.refs.remove(o);
                } else if (aRef.value < 0) {
                    ClickniumJavaBridge.this.debugString("ERROR: decrementing reference count below 0");
                }
            } else {
                ClickniumJavaBridge.this.debugString("ERROR: object to decrement not in ObjectReferences table");
            }
        }

        protected class Reference {
            public int value;

            public Reference(int i) {
                this.value = i;
            }

            public String toString() {
                return "refCount: " + this.value;
            }
        }
    }

    protected class DefaultNativeWindowHandler
    implements NativeWindowHandler {
        protected DefaultNativeWindowHandler() {
        }

        public Accessible getAccessibleFromNativeWindowHandle(int nativeHandle) {
            Component c = this.getComponentFromNativeWindowHandle(nativeHandle);
            Accessible accessible = ClickniumAccessibleComponentFactory.getAccessibleFromComponent(c);
            if (accessible instanceof Accessible) {
                ClickniumJavaBridge.this.saveContextToWindowHandleMapping(accessible.getAccessibleContext(), nativeHandle);
                return accessible;
            }
            return null;
        }

        public Component getComponentFromNativeWindowHandle(int nativeHandle) {
            if (ClickniumJavaBridge.this.useJAWT_DLL) {
                ClickniumJavaBridge.this.debugString("*** calling jawtGetComponentFromNativeWindowHandle");
                return ClickniumJavaBridge.this.jawtGetComponentFromNativeWindowHandle(nativeHandle);
            }
            ClickniumJavaBridge.this.debugString("*** calling javaGetComponentFromNativeWindowHandle");
            Object[] args = new Object[1];
            if (ClickniumJavaBridge.this.javaGetComponentFromNativeWindowHandleMethod != null) {
                try {
                    args[0] = new Integer(nativeHandle);
                    Object o = ClickniumJavaBridge.this.javaGetComponentFromNativeWindowHandleMethod.invoke((Object)ClickniumJavaBridge.this.toolkit, args);
                    if (o instanceof Accessible) {
                        ClickniumJavaBridge.this.saveContextToWindowHandleMapping(((Accessible)o).getAccessibleContext(), nativeHandle);
                    }
                    return (Component)o;
                }
                catch (InvocationTargetException e) {
                    ClickniumJavaBridge.this.debugString("Exception: " + e.toString());
                }
                catch (IllegalAccessException e) {
                    ClickniumJavaBridge.this.debugString("Exception: " + e.toString());
                }
            }
            return null;
        }
    }

    public static interface NativeWindowHandler {
        public Accessible getAccessibleFromNativeWindowHandle(int var1);

        public Component getComponentFromNativeWindowHandle(int var1);
    }

    private class shutdownHook
    implements Runnable {
        private shutdownHook() {
        }

        public void run() {
            ClickniumJavaBridge.this.debugString("***** shutdownHook: shutting down...");
            ClickniumJavaBridge.this.javaShutdown();
        }
    }

    private class dllRunner
    implements Runnable {
        private dllRunner() {
        }

        public void run() {
            try {
                ClickniumJavaBridge.this.runDLL();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

