import unittest
import numpy as np
from debyetools.electronic import fit_electronic
from debyetools.aux_functions import load_doscar
class ElectronicContributionFittingTestCase(unittest.TestCase):
    def setUp(self):
        pass

    def test_NfV_fitting(self):
        """ Test fitting of the NfV."""

        V_DFT = np.array([7.2328381349E-06,7.4766214899E-06,7.7258220323E-06,7.9804992917E-06,8.2407127976E-06,8.5065220794E-06,8.7779866668E-06,9.0551660893E-06,9.3381198763E-06,9.6269075575E-06,9.9215886624E-06,1.0222222720E-05,1.0528869261E-05,1.0841587814E-05,1.1160437909E-05,1.1485479075E-05,1.1816770842E-05,1.2154372740E-05,1.2498344297E-05,1.2848745044E-05,1.3205634510E-05])

        p_el_inittial = [2.828998e-01, -1.023899e+04,  0.000000e+00,  0.000000e+00]#[3.802734e-01, -1.887502e-02,  5.307103e-04, -7.010071e-06]

        E = [[-3.076, -2.981, -2.885, -2.789, -2.693, -2.597, -2.501, -2.405, -2.309, -2.213, -2.117, -2.021, -1.925, -1.829, -1.733, -1.637, -1.541, -1.445, -1.349, -1.253, -1.157, -1.061, -0.965, -0.869, -0.773, -0.677, -0.581, -0.485, -0.389, -0.293, -0.197, -0.101, -0.005, 0.091, 0.187, 0.283, 0.379, 0.475, 0.571, 0.667, 0.763, 0.859, 0.955, 1.051, 1.147, 1.243, 1.339, 1.435, 1.531, 1.627, 1.723, 1.819, 1.915, 2.011, 2.107, 2.202, 2.298, 2.394, 2.49, 2.586, 2.682, 2.778, 2.874, 2.97, 3.066, 3.162, 3.258, 3.354, 3.45, 3.546, 3.642, 3.738, 3.834, 3.93, 4.026, 4.122, 4.218, 4.314, 4.41, 4.506, 4.602, 4.698, 4.794, 4.89, 4.986, 5.082, 5.178, 5.274, 5.37, 5.466, 5.562, 5.658, 5.754, 5.85, 5.946, 6.042, 6.138, 6.234, 6.33, 6.426, 6.522, 6.618, 6.714, 6.81, 6.906, 7.002, 7.098, 7.194, 7.29, 7.386, 7.481, 7.577, 7.673, 7.769, 7.865, 7.961, 8.057, 8.153, 8.249, 8.345, 8.441, 8.537, 8.633, 8.729, 8.825, 8.921, 9.017, 9.113, 9.209, 9.305, 9.401, 9.497, 9.593, 9.689, 9.785, 9.881, 9.977, 10.073, 10.169, 10.265, 10.361, 10.457, 10.553, 10.649, 10.745, 10.841, 10.937, 11.033, 11.129, 11.225, 11.321, 11.417, 11.513, 11.609, 11.705, 11.801, 11.897, 11.993, 12.089, 12.185, 12.281, 12.377, 12.473, 12.569, 12.665, 12.76, 12.856, 12.952, 13.048, 13.144, 13.24, 13.336, 13.432, 13.528, 13.624, 13.72, 13.816, 13.912, 14.008, 14.104, 14.2, 14.296, 14.392, 14.488, 14.584, 14.68, 14.776, 14.872, 14.968, 15.064, 15.16, 15.256, 15.352, 15.448, 15.544, 15.64, 15.736, 15.832, 15.928, 16.024, 16.12, 16.216, 16.312, 16.408, 16.504, 16.6, 16.696, 16.792, 16.888, 16.984, 17.08, 17.176, 17.272, 17.368, 17.464, 17.56, 17.656, 17.752, 17.848, 17.944, 18.039, 18.135, 18.231, 18.327, 18.423, 18.519, 18.615, 18.711, 18.807, 18.903, 18.999, 19.095, 19.191, 19.287, 19.383, 19.479, 19.575, 19.671, 19.767, 19.863, 19.959, 20.055, 20.151, 20.247, 20.343, 20.439, 20.535, 20.631, 20.727, 20.823, 20.919, 21.015, 21.111, 21.207, 21.303, 21.399, 21.495, 21.591, 21.687, 21.783, 21.879, 21.975, 22.071, 22.167, 22.263, 22.359, 22.455, 22.551, 22.647, 22.743, 22.839, 22.935, 23.031, 23.127, 23.223, 23.318, 23.414, 23.51, 23.606, 23.702, 23.798, 23.894, 23.99, 24.086, 24.182, 24.278, 24.374, 24.47, 24.566, 24.662, 24.758, 24.854, 24.95, 25.046, 25.142, 25.238, 25.334, 25.43, 25.526, 25.622, 25.718, 25.71802966, -3.076, -2.981, -2.885, -2.789, -2.693, -2.597, -2.501, -2.405, -2.309, -2.213, -2.117, -2.021, -1.925, -1.829, -1.733, -1.637, -1.541, -1.445, -1.349, -1.253, -1.157, -1.061, -0.965, -0.869, -0.773, -0.677, -0.581, -0.485, -0.389, -0.293, -0.197, -0.101, -0.005, 0.091, 0.187, 0.283, 0.379, 0.475, 0.571, 0.667, 0.763, 0.859, 0.955, 1.051, 1.147, 1.243, 1.339, 1.435, 1.531, 1.627, 1.723, 1.819, 1.915, 2.011, 2.107, 2.202, 2.298, 2.394, 2.49, 2.586, 2.682, 2.778, 2.874, 2.97, 3.066, 3.162, 3.258, 3.354, 3.45, 3.546, 3.642, 3.738, 3.834, 3.93, 4.026, 4.122, 4.218, 4.314, 4.41, 4.506, 4.602, 4.698, 4.794, 4.89, 4.986, 5.082, 5.178, 5.274, 5.37, 5.466, 5.562, 5.658, 5.754, 5.85, 5.946, 6.042, 6.138, 6.234, 6.33, 6.426, 6.522, 6.618, 6.714, 6.81, 6.906, 7.002, 7.098, 7.194, 7.29, 7.386, 7.481, 7.577, 7.673, 7.769, 7.865, 7.961, 8.057, 8.153, 8.249, 8.345, 8.441, 8.537, 8.633, 8.729, 8.825, 8.921, 9.017, 9.113, 9.209, 9.305, 9.401, 9.497, 9.593, 9.689, 9.785, 9.881, 9.977, 10.073, 10.169, 10.265, 10.361, 10.457, 10.553, 10.649, 10.745, 10.841, 10.937, 11.033, 11.129, 11.225, 11.321, 11.417, 11.513, 11.609, 11.705, 11.801, 11.897, 11.993, 12.089, 12.185, 12.281, 12.377, 12.473, 12.569, 12.665, 12.76, 12.856, 12.952, 13.048, 13.144, 13.24, 13.336, 13.432, 13.528, 13.624, 13.72, 13.816, 13.912, 14.008, 14.104, 14.2, 14.296, 14.392, 14.488, 14.584, 14.68, 14.776, 14.872, 14.968, 15.064, 15.16, 15.256, 15.352, 15.448, 15.544, 15.64, 15.736, 15.832, 15.928, 16.024, 16.12, 16.216, 16.312, 16.408, 16.504, 16.6, 16.696, 16.792, 16.888, 16.984, 17.08, 17.176, 17.272, 17.368, 17.464, 17.56, 17.656, 17.752, 17.848, 17.944, 18.039, 18.135, 18.231, 18.327, 18.423, 18.519, 18.615, 18.711, 18.807, 18.903, 18.999, 19.095, 19.191, 19.287, 19.383, 19.479, 19.575, 19.671, 19.767, 19.863, 19.959, 20.055, 20.151, 20.247, 20.343, 20.439, 20.535, 20.631, 20.727, 20.823, 20.919, 21.015, 21.111, 21.207, 21.303, 21.399, 21.495, 21.591, 21.687, 21.783, 21.879, 21.975, 22.071, 22.167, 22.263, 22.359, 22.455, 22.551, 22.647, 22.743, 22.839, 22.935, 23.031, 23.127, 23.223, 23.318, 23.414, 23.51, 23.606, 23.702, 23.798, 23.894, 23.99, 24.086, 24.182, 24.278, 24.374, 24.47, 24.566, 24.662, 24.758, 24.854, 24.95, 25.046, 25.142, 25.238, 25.334, 25.43, 25.526, 25.622, 25.718, 25.71802966, -3.076, -2.981, -2.885, -2.789, -2.693, -2.597, -2.501, -2.405, -2.309, -2.213, -2.117, -2.021, -1.925, -1.829, -1.733, -1.637, -1.541, -1.445, -1.349, -1.253, -1.157, -1.061, -0.965, -0.869, -0.773, -0.677, -0.581, -0.485, -0.389, -0.293, -0.197, -0.101, -0.005, 0.091, 0.187, 0.283, 0.379, 0.475, 0.571, 0.667, 0.763, 0.859, 0.955, 1.051, 1.147, 1.243, 1.339, 1.435, 1.531, 1.627, 1.723, 1.819, 1.915, 2.011, 2.107, 2.202, 2.298, 2.394, 2.49, 2.586, 2.682, 2.778, 2.874, 2.97, 3.066, 3.162, 3.258, 3.354, 3.45, 3.546, 3.642, 3.738, 3.834, 3.93, 4.026, 4.122, 4.218, 4.314, 4.41, 4.506, 4.602, 4.698, 4.794, 4.89, 4.986, 5.082, 5.178, 5.274, 5.37, 5.466, 5.562, 5.658, 5.754, 5.85, 5.946, 6.042, 6.138, 6.234, 6.33, 6.426, 6.522, 6.618, 6.714, 6.81, 6.906, 7.002, 7.098, 7.194, 7.29, 7.386, 7.481, 7.577, 7.673, 7.769, 7.865, 7.961, 8.057, 8.153, 8.249, 8.345, 8.441, 8.537, 8.633, 8.729, 8.825, 8.921, 9.017, 9.113, 9.209, 9.305, 9.401, 9.497, 9.593, 9.689, 9.785, 9.881, 9.977, 10.073, 10.169, 10.265, 10.361, 10.457, 10.553, 10.649, 10.745, 10.841, 10.937, 11.033, 11.129, 11.225, 11.321, 11.417, 11.513, 11.609, 11.705, 11.801, 11.897, 11.993, 12.089, 12.185, 12.281, 12.377, 12.473, 12.569, 12.665, 12.76, 12.856, 12.952, 13.048, 13.144, 13.24, 13.336, 13.432, 13.528, 13.624, 13.72, 13.816, 13.912, 14.008, 14.104, 14.2, 14.296, 14.392, 14.488, 14.584, 14.68, 14.776, 14.872, 14.968, 15.064, 15.16, 15.256, 15.352, 15.448, 15.544, 15.64, 15.736, 15.832, 15.928, 16.024, 16.12, 16.216, 16.312, 16.408, 16.504, 16.6, 16.696, 16.792, 16.888, 16.984, 17.08, 17.176, 17.272, 17.368, 17.464, 17.56, 17.656, 17.752, 17.848, 17.944, 18.039, 18.135, 18.231, 18.327, 18.423, 18.519, 18.615, 18.711, 18.807, 18.903, 18.999, 19.095, 19.191, 19.287, 19.383, 19.479, 19.575, 19.671, 19.767, 19.863, 19.959, 20.055, 20.151, 20.247, 20.343, 20.439, 20.535, 20.631, 20.727, 20.823, 20.919, 21.015, 21.111, 21.207, 21.303, 21.399, 21.495, 21.591, 21.687, 21.783, 21.879, 21.975, 22.071, 22.167, 22.263, 22.359, 22.455, 22.551, 22.647, 22.743, 22.839, 22.935, 23.031, 23.127, 23.223, 23.318, 23.414, 23.51, 23.606, 23.702, 23.798, 23.894, 23.99, 24.086, 24.182, 24.278, 24.374, 24.47, 24.566, 24.662, 24.758, 24.854, 24.95, 25.046, 25.142, 25.238, 25.334, 25.43, 25.526, 25.622, 25.718, 25.71802966, -3.076, -2.981, -2.885, -2.789, -2.693, -2.597, -2.501, -2.405, -2.309, -2.213, -2.117, -2.021, -1.925, -1.829, -1.733, -1.637, -1.541, -1.445, -1.349, -1.253, -1.157, -1.061, -0.965, -0.869, -0.773, -0.677, -0.581, -0.485, -0.389, -0.293, -0.197, -0.101, -0.005, 0.091, 0.187, 0.283, 0.379, 0.475, 0.571, 0.667, 0.763, 0.859, 0.955, 1.051, 1.147, 1.243, 1.339, 1.435, 1.531, 1.627, 1.723, 1.819, 1.915, 2.011, 2.107, 2.202, 2.298, 2.394, 2.49, 2.586, 2.682, 2.778, 2.874, 2.97, 3.066, 3.162, 3.258, 3.354, 3.45, 3.546, 3.642, 3.738, 3.834, 3.93, 4.026, 4.122, 4.218, 4.314, 4.41, 4.506, 4.602, 4.698, 4.794, 4.89, 4.986, 5.082, 5.178, 5.274, 5.37, 5.466, 5.562, 5.658, 5.754, 5.85, 5.946, 6.042, 6.138, 6.234, 6.33, 6.426, 6.522, 6.618, 6.714, 6.81, 6.906, 7.002, 7.098, 7.194, 7.29, 7.386, 7.481, 7.577, 7.673, 7.769, 7.865, 7.961, 8.057, 8.153, 8.249, 8.345, 8.441, 8.537, 8.633, 8.729, 8.825, 8.921, 9.017, 9.113, 9.209, 9.305, 9.401, 9.497, 9.593, 9.689, 9.785, 9.881, 9.977, 10.073, 10.169, 10.265, 10.361, 10.457, 10.553, 10.649, 10.745, 10.841, 10.937, 11.033, 11.129, 11.225, 11.321, 11.417, 11.513, 11.609, 11.705, 11.801, 11.897, 11.993, 12.089, 12.185, 12.281, 12.377, 12.473, 12.569, 12.665, 12.76, 12.856, 12.952, 13.048, 13.144, 13.24, 13.336, 13.432, 13.528, 13.624, 13.72, 13.816, 13.912, 14.008, 14.104, 14.2, 14.296, 14.392, 14.488, 14.584, 14.68, 14.776, 14.872, 14.968, 15.064, 15.16, 15.256, 15.352, 15.448, 15.544, 15.64, 15.736, 15.832, 15.928, 16.024, 16.12, 16.216, 16.312, 16.408, 16.504, 16.6, 16.696, 16.792, 16.888, 16.984, 17.08, 17.176, 17.272, 17.368, 17.464, 17.56, 17.656, 17.752, 17.848, 17.944, 18.039, 18.135, 18.231, 18.327, 18.423, 18.519, 18.615, 18.711, 18.807, 18.903, 18.999, 19.095, 19.191, 19.287, 19.383, 19.479, 19.575, 19.671, 19.767, 19.863, 19.959, 20.055, 20.151, 20.247, 20.343, 20.439, 20.535, 20.631, 20.727, 20.823, 20.919, 21.015, 21.111, 21.207, 21.303, 21.399, 21.495, 21.591, 21.687, 21.783, 21.879, 21.975, 22.071, 22.167, 22.263, 22.359, 22.455, 22.551, 22.647, 22.743, 22.839, 22.935, 23.031, 23.127, 23.223, 23.318, 23.414, 23.51, 23.606, 23.702, 23.798, 23.894, 23.99, 24.086, 24.182, 24.278, 24.374, 24.47, 24.566, 24.662, 24.758, 24.854, 24.95, 25.046, 25.142, 25.238, 25.334, 25.43, 25.526, 25.622, 25.718, 25.71802966, -3.076, -2.981, -2.885, -2.789, -2.693, -2.597, -2.501, -2.405, -2.309, -2.213, -2.117, -2.021, -1.925, -1.829, -1.733, -1.637, -1.541, -1.445, -1.349, -1.253, -1.157, -1.061, -0.965, -0.869, -0.773, -0.677, -0.581, -0.485, -0.389, -0.293, -0.197, -0.101, -0.005, 0.091, 0.187, 0.283, 0.379, 0.475, 0.571, 0.667, 0.763, 0.859, 0.955, 1.051, 1.147, 1.243, 1.339, 1.435, 1.531, 1.627, 1.723, 1.819, 1.915, 2.011, 2.107, 2.202, 2.298, 2.394, 2.49, 2.586, 2.682, 2.778, 2.874, 2.97, 3.066, 3.162, 3.258, 3.354, 3.45, 3.546, 3.642, 3.738, 3.834, 3.93, 4.026, 4.122, 4.218, 4.314, 4.41, 4.506, 4.602, 4.698, 4.794, 4.89, 4.986, 5.082, 5.178, 5.274, 5.37, 5.466, 5.562, 5.658, 5.754, 5.85, 5.946, 6.042, 6.138, 6.234, 6.33, 6.426, 6.522, 6.618, 6.714, 6.81, 6.906, 7.002, 7.098, 7.194, 7.29, 7.386, 7.481, 7.577, 7.673, 7.769, 7.865, 7.961, 8.057, 8.153, 8.249, 8.345, 8.441, 8.537, 8.633, 8.729, 8.825, 8.921, 9.017, 9.113, 9.209, 9.305, 9.401, 9.497, 9.593, 9.689, 9.785, 9.881, 9.977, 10.073, 10.169, 10.265, 10.361, 10.457, 10.553, 10.649, 10.745, 10.841, 10.937, 11.033, 11.129, 11.225, 11.321, 11.417, 11.513, 11.609, 11.705, 11.801, 11.897, 11.993, 12.089, 12.185, 12.281, 12.377, 12.473, 12.569, 12.665, 12.76, 12.856, 12.952, 13.048, 13.144, 13.24, 13.336, 13.432, 13.528, 13.624, 13.72, 13.816, 13.912, 14.008, 14.104, 14.2, 14.296, 14.392, 14.488, 14.584, 14.68, 14.776, 14.872, 14.968, 15.064, 15.16, 15.256, 15.352, 15.448, 15.544, 15.64, 15.736, 15.832, 15.928, 16.024, 16.12, 16.216, 16.312, 16.408, 16.504, 16.6, 16.696, 16.792, 16.888, 16.984, 17.08, 17.176, 17.272, 17.368, 17.464, 17.56, 17.656, 17.752, 17.848, 17.944, 18.039, 18.135, 18.231, 18.327, 18.423, 18.519, 18.615, 18.711, 18.807, 18.903, 18.999, 19.095, 19.191, 19.287, 19.383, 19.479, 19.575, 19.671, 19.767, 19.863, 19.959, 20.055, 20.151, 20.247, 20.343, 20.439, 20.535, 20.631, 20.727, 20.823, 20.919, 21.015, 21.111, 21.207, 21.303, 21.399, 21.495, 21.591, 21.687, 21.783, 21.879, 21.975, 22.071, 22.167, 22.263, 22.359, 22.455, 22.551, 22.647, 22.743, 22.839, 22.935, 23.031, 23.127, 23.223, 23.318, 23.414, 23.51, 23.606, 23.702, 23.798, 23.894, 23.99, 24.086, 24.182, 24.278, 24.374, 24.47, 24.566, 24.662, 24.758, 24.854, 24.95, 25.046, 25.142, 25.238, 25.334, 25.43, 25.526, 25.622, 25.718], [-3.223, -3.128, -3.034, -2.94, -2.846, -2.751, -2.657, -2.563, -2.469, -2.374, -2.28, -2.186, -2.092, -1.997, -1.903, -1.809, -1.715, -1.62, -1.526, -1.432, -1.338, -1.243, -1.149, -1.055, -0.961, -0.866, -0.772, -0.678, -0.584, -0.489, -0.395, -0.301, -0.207, -0.112, -0.018, 0.076, 0.17, 0.264, 0.359, 0.453, 0.547, 0.641, 0.736, 0.83, 0.924, 1.018, 1.113, 1.207, 1.301, 1.395, 1.49, 1.584, 1.678, 1.772, 1.867, 1.961, 2.055, 2.149, 2.244, 2.338, 2.432, 2.526, 2.621, 2.715, 2.809, 2.903, 2.998, 3.092, 3.186, 3.28, 3.375, 3.469, 3.563, 3.657, 3.752, 3.846, 3.94, 4.034, 4.129, 4.223, 4.317, 4.411, 4.506, 4.6, 4.694, 4.788, 4.883, 4.977, 5.071, 5.165, 5.259, 5.354, 5.448, 5.542, 5.636, 5.731, 5.825, 5.919, 6.013, 6.108, 6.202, 6.296, 6.39, 6.485, 6.579, 6.673, 6.767, 6.862, 6.956, 7.05, 7.144, 7.239, 7.333, 7.427, 7.521, 7.616, 7.71, 7.804, 7.898, 7.993, 8.087, 8.181, 8.275, 8.37, 8.464, 8.558, 8.652, 8.747, 8.841, 8.935, 9.029, 9.124, 9.218, 9.312, 9.406, 9.501, 9.595, 9.689, 9.783, 9.878, 9.972, 10.066, 10.16, 10.254, 10.349, 10.443, 10.537, 10.631, 10.726, 10.82, 10.914, 11.008, 11.103, 11.197, 11.291, 11.385, 11.48, 11.574, 11.668, 11.762, 11.857, 11.951, 12.045, 12.139, 12.234, 12.328, 12.422, 12.516, 12.611, 12.705, 12.799, 12.893, 12.988, 13.082, 13.176, 13.27, 13.365, 13.459, 13.553, 13.647, 13.742, 13.836, 13.93, 14.024, 14.119, 14.213, 14.307, 14.401, 14.496, 14.59, 14.684, 14.778, 14.873, 14.967, 15.061, 15.155, 15.249, 15.344, 15.438, 15.532, 15.626, 15.721, 15.815, 15.909, 16.003, 16.098, 16.192, 16.286, 16.38, 16.475, 16.569, 16.663, 16.757, 16.852, 16.946, 17.04, 17.134, 17.229, 17.323, 17.417, 17.511, 17.606, 17.7, 17.794, 17.888, 17.983, 18.077, 18.171, 18.265, 18.36, 18.454, 18.548, 18.642, 18.737, 18.831, 18.925, 19.019, 19.114, 19.208, 19.302, 19.396, 19.491, 19.585, 19.679, 19.773, 19.868, 19.962, 20.056, 20.15, 20.244, 20.339, 20.433, 20.527, 20.621, 20.716, 20.81, 20.904, 20.998, 21.093, 21.187, 21.281, 21.375, 21.47, 21.564, 21.658, 21.752, 21.847, 21.941, 22.035, 22.129, 22.224, 22.318, 22.412, 22.506, 22.601, 22.695, 22.789, 22.883, 22.978, 23.072, 23.166, 23.26, 23.355, 23.449, 23.543, 23.637, 23.732, 23.826, 23.92, 24.014, 24.109, 24.203, 24.297, 24.391, 24.486, 24.58, 24.674, 24.768, 24.863, 24.957, 25.051, 25.05099547, -3.223, -3.128, -3.034, -2.94, -2.846, -2.751, -2.657, -2.563, -2.469, -2.374, -2.28, -2.186, -2.092, -1.997, -1.903, -1.809, -1.715, -1.62, -1.526, -1.432, -1.338, -1.243, -1.149, -1.055, -0.961, -0.866, -0.772, -0.678, -0.584, -0.489, -0.395, -0.301, -0.207, -0.112, -0.018, 0.076, 0.17, 0.264, 0.359, 0.453, 0.547, 0.641, 0.736, 0.83, 0.924, 1.018, 1.113, 1.207, 1.301, 1.395, 1.49, 1.584, 1.678, 1.772, 1.867, 1.961, 2.055, 2.149, 2.244, 2.338, 2.432, 2.526, 2.621, 2.715, 2.809, 2.903, 2.998, 3.092, 3.186, 3.28, 3.375, 3.469, 3.563, 3.657, 3.752, 3.846, 3.94, 4.034, 4.129, 4.223, 4.317, 4.411, 4.506, 4.6, 4.694, 4.788, 4.883, 4.977, 5.071, 5.165, 5.259, 5.354, 5.448, 5.542, 5.636, 5.731, 5.825, 5.919, 6.013, 6.108, 6.202, 6.296, 6.39, 6.485, 6.579, 6.673, 6.767, 6.862, 6.956, 7.05, 7.144, 7.239, 7.333, 7.427, 7.521, 7.616, 7.71, 7.804, 7.898, 7.993, 8.087, 8.181, 8.275, 8.37, 8.464, 8.558, 8.652, 8.747, 8.841, 8.935, 9.029, 9.124, 9.218, 9.312, 9.406, 9.501, 9.595, 9.689, 9.783, 9.878, 9.972, 10.066, 10.16, 10.254, 10.349, 10.443, 10.537, 10.631, 10.726, 10.82, 10.914, 11.008, 11.103, 11.197, 11.291, 11.385, 11.48, 11.574, 11.668, 11.762, 11.857, 11.951, 12.045, 12.139, 12.234, 12.328, 12.422, 12.516, 12.611, 12.705, 12.799, 12.893, 12.988, 13.082, 13.176, 13.27, 13.365, 13.459, 13.553, 13.647, 13.742, 13.836, 13.93, 14.024, 14.119, 14.213, 14.307, 14.401, 14.496, 14.59, 14.684, 14.778, 14.873, 14.967, 15.061, 15.155, 15.249, 15.344, 15.438, 15.532, 15.626, 15.721, 15.815, 15.909, 16.003, 16.098, 16.192, 16.286, 16.38, 16.475, 16.569, 16.663, 16.757, 16.852, 16.946, 17.04, 17.134, 17.229, 17.323, 17.417, 17.511, 17.606, 17.7, 17.794, 17.888, 17.983, 18.077, 18.171, 18.265, 18.36, 18.454, 18.548, 18.642, 18.737, 18.831, 18.925, 19.019, 19.114, 19.208, 19.302, 19.396, 19.491, 19.585, 19.679, 19.773, 19.868, 19.962, 20.056, 20.15, 20.244, 20.339, 20.433, 20.527, 20.621, 20.716, 20.81, 20.904, 20.998, 21.093, 21.187, 21.281, 21.375, 21.47, 21.564, 21.658, 21.752, 21.847, 21.941, 22.035, 22.129, 22.224, 22.318, 22.412, 22.506, 22.601, 22.695, 22.789, 22.883, 22.978, 23.072, 23.166, 23.26, 23.355, 23.449, 23.543, 23.637, 23.732, 23.826, 23.92, 24.014, 24.109, 24.203, 24.297, 24.391, 24.486, 24.58, 24.674, 24.768, 24.863, 24.957, 25.051, 25.05099547, -3.223, -3.128, -3.034, -2.94, -2.846, -2.751, -2.657, -2.563, -2.469, -2.374, -2.28, -2.186, -2.092, -1.997, -1.903, -1.809, -1.715, -1.62, -1.526, -1.432, -1.338, -1.243, -1.149, -1.055, -0.961, -0.866, -0.772, -0.678, -0.584, -0.489, -0.395, -0.301, -0.207, -0.112, -0.018, 0.076, 0.17, 0.264, 0.359, 0.453, 0.547, 0.641, 0.736, 0.83, 0.924, 1.018, 1.113, 1.207, 1.301, 1.395, 1.49, 1.584, 1.678, 1.772, 1.867, 1.961, 2.055, 2.149, 2.244, 2.338, 2.432, 2.526, 2.621, 2.715, 2.809, 2.903, 2.998, 3.092, 3.186, 3.28, 3.375, 3.469, 3.563, 3.657, 3.752, 3.846, 3.94, 4.034, 4.129, 4.223, 4.317, 4.411, 4.506, 4.6, 4.694, 4.788, 4.883, 4.977, 5.071, 5.165, 5.259, 5.354, 5.448, 5.542, 5.636, 5.731, 5.825, 5.919, 6.013, 6.108, 6.202, 6.296, 6.39, 6.485, 6.579, 6.673, 6.767, 6.862, 6.956, 7.05, 7.144, 7.239, 7.333, 7.427, 7.521, 7.616, 7.71, 7.804, 7.898, 7.993, 8.087, 8.181, 8.275, 8.37, 8.464, 8.558, 8.652, 8.747, 8.841, 8.935, 9.029, 9.124, 9.218, 9.312, 9.406, 9.501, 9.595, 9.689, 9.783, 9.878, 9.972, 10.066, 10.16, 10.254, 10.349, 10.443, 10.537, 10.631, 10.726, 10.82, 10.914, 11.008, 11.103, 11.197, 11.291, 11.385, 11.48, 11.574, 11.668, 11.762, 11.857, 11.951, 12.045, 12.139, 12.234, 12.328, 12.422, 12.516, 12.611, 12.705, 12.799, 12.893, 12.988, 13.082, 13.176, 13.27, 13.365, 13.459, 13.553, 13.647, 13.742, 13.836, 13.93, 14.024, 14.119, 14.213, 14.307, 14.401, 14.496, 14.59, 14.684, 14.778, 14.873, 14.967, 15.061, 15.155, 15.249, 15.344, 15.438, 15.532, 15.626, 15.721, 15.815, 15.909, 16.003, 16.098, 16.192, 16.286, 16.38, 16.475, 16.569, 16.663, 16.757, 16.852, 16.946, 17.04, 17.134, 17.229, 17.323, 17.417, 17.511, 17.606, 17.7, 17.794, 17.888, 17.983, 18.077, 18.171, 18.265, 18.36, 18.454, 18.548, 18.642, 18.737, 18.831, 18.925, 19.019, 19.114, 19.208, 19.302, 19.396, 19.491, 19.585, 19.679, 19.773, 19.868, 19.962, 20.056, 20.15, 20.244, 20.339, 20.433, 20.527, 20.621, 20.716, 20.81, 20.904, 20.998, 21.093, 21.187, 21.281, 21.375, 21.47, 21.564, 21.658, 21.752, 21.847, 21.941, 22.035, 22.129, 22.224, 22.318, 22.412, 22.506, 22.601, 22.695, 22.789, 22.883, 22.978, 23.072, 23.166, 23.26, 23.355, 23.449, 23.543, 23.637, 23.732, 23.826, 23.92, 24.014, 24.109, 24.203, 24.297, 24.391, 24.486, 24.58, 24.674, 24.768, 24.863, 24.957, 25.051, 25.05099547, -3.223, -3.128, -3.034, -2.94, -2.846, -2.751, -2.657, -2.563, -2.469, -2.374, -2.28, -2.186, -2.092, -1.997, -1.903, -1.809, -1.715, -1.62, -1.526, -1.432, -1.338, -1.243, -1.149, -1.055, -0.961, -0.866, -0.772, -0.678, -0.584, -0.489, -0.395, -0.301, -0.207, -0.112, -0.018, 0.076, 0.17, 0.264, 0.359, 0.453, 0.547, 0.641, 0.736, 0.83, 0.924, 1.018, 1.113, 1.207, 1.301, 1.395, 1.49, 1.584, 1.678, 1.772, 1.867, 1.961, 2.055, 2.149, 2.244, 2.338, 2.432, 2.526, 2.621, 2.715, 2.809, 2.903, 2.998, 3.092, 3.186, 3.28, 3.375, 3.469, 3.563, 3.657, 3.752, 3.846, 3.94, 4.034, 4.129, 4.223, 4.317, 4.411, 4.506, 4.6, 4.694, 4.788, 4.883, 4.977, 5.071, 5.165, 5.259, 5.354, 5.448, 5.542, 5.636, 5.731, 5.825, 5.919, 6.013, 6.108, 6.202, 6.296, 6.39, 6.485, 6.579, 6.673, 6.767, 6.862, 6.956, 7.05, 7.144, 7.239, 7.333, 7.427, 7.521, 7.616, 7.71, 7.804, 7.898, 7.993, 8.087, 8.181, 8.275, 8.37, 8.464, 8.558, 8.652, 8.747, 8.841, 8.935, 9.029, 9.124, 9.218, 9.312, 9.406, 9.501, 9.595, 9.689, 9.783, 9.878, 9.972, 10.066, 10.16, 10.254, 10.349, 10.443, 10.537, 10.631, 10.726, 10.82, 10.914, 11.008, 11.103, 11.197, 11.291, 11.385, 11.48, 11.574, 11.668, 11.762, 11.857, 11.951, 12.045, 12.139, 12.234, 12.328, 12.422, 12.516, 12.611, 12.705, 12.799, 12.893, 12.988, 13.082, 13.176, 13.27, 13.365, 13.459, 13.553, 13.647, 13.742, 13.836, 13.93, 14.024, 14.119, 14.213, 14.307, 14.401, 14.496, 14.59, 14.684, 14.778, 14.873, 14.967, 15.061, 15.155, 15.249, 15.344, 15.438, 15.532, 15.626, 15.721, 15.815, 15.909, 16.003, 16.098, 16.192, 16.286, 16.38, 16.475, 16.569, 16.663, 16.757, 16.852, 16.946, 17.04, 17.134, 17.229, 17.323, 17.417, 17.511, 17.606, 17.7, 17.794, 17.888, 17.983, 18.077, 18.171, 18.265, 18.36, 18.454, 18.548, 18.642, 18.737, 18.831, 18.925, 19.019, 19.114, 19.208, 19.302, 19.396, 19.491, 19.585, 19.679, 19.773, 19.868, 19.962, 20.056, 20.15, 20.244, 20.339, 20.433, 20.527, 20.621, 20.716, 20.81, 20.904, 20.998, 21.093, 21.187, 21.281, 21.375, 21.47, 21.564, 21.658, 21.752, 21.847, 21.941, 22.035, 22.129, 22.224, 22.318, 22.412, 22.506, 22.601, 22.695, 22.789, 22.883, 22.978, 23.072, 23.166, 23.26, 23.355, 23.449, 23.543, 23.637, 23.732, 23.826, 23.92, 24.014, 24.109, 24.203, 24.297, 24.391, 24.486, 24.58, 24.674, 24.768, 24.863, 24.957, 25.051, 25.05099547, -3.223, -3.128, -3.034, -2.94, -2.846, -2.751, -2.657, -2.563, -2.469, -2.374, -2.28, -2.186, -2.092, -1.997, -1.903, -1.809, -1.715, -1.62, -1.526, -1.432, -1.338, -1.243, -1.149, -1.055, -0.961, -0.866, -0.772, -0.678, -0.584, -0.489, -0.395, -0.301, -0.207, -0.112, -0.018, 0.076, 0.17, 0.264, 0.359, 0.453, 0.547, 0.641, 0.736, 0.83, 0.924, 1.018, 1.113, 1.207, 1.301, 1.395, 1.49, 1.584, 1.678, 1.772, 1.867, 1.961, 2.055, 2.149, 2.244, 2.338, 2.432, 2.526, 2.621, 2.715, 2.809, 2.903, 2.998, 3.092, 3.186, 3.28, 3.375, 3.469, 3.563, 3.657, 3.752, 3.846, 3.94, 4.034, 4.129, 4.223, 4.317, 4.411, 4.506, 4.6, 4.694, 4.788, 4.883, 4.977, 5.071, 5.165, 5.259, 5.354, 5.448, 5.542, 5.636, 5.731, 5.825, 5.919, 6.013, 6.108, 6.202, 6.296, 6.39, 6.485, 6.579, 6.673, 6.767, 6.862, 6.956, 7.05, 7.144, 7.239, 7.333, 7.427, 7.521, 7.616, 7.71, 7.804, 7.898, 7.993, 8.087, 8.181, 8.275, 8.37, 8.464, 8.558, 8.652, 8.747, 8.841, 8.935, 9.029, 9.124, 9.218, 9.312, 9.406, 9.501, 9.595, 9.689, 9.783, 9.878, 9.972, 10.066, 10.16, 10.254, 10.349, 10.443, 10.537, 10.631, 10.726, 10.82, 10.914, 11.008, 11.103, 11.197, 11.291, 11.385, 11.48, 11.574, 11.668, 11.762, 11.857, 11.951, 12.045, 12.139, 12.234, 12.328, 12.422, 12.516, 12.611, 12.705, 12.799, 12.893, 12.988, 13.082, 13.176, 13.27, 13.365, 13.459, 13.553, 13.647, 13.742, 13.836, 13.93, 14.024, 14.119, 14.213, 14.307, 14.401, 14.496, 14.59, 14.684, 14.778, 14.873, 14.967, 15.061, 15.155, 15.249, 15.344, 15.438, 15.532, 15.626, 15.721, 15.815, 15.909, 16.003, 16.098, 16.192, 16.286, 16.38, 16.475, 16.569, 16.663, 16.757, 16.852, 16.946, 17.04, 17.134, 17.229, 17.323, 17.417, 17.511, 17.606, 17.7, 17.794, 17.888, 17.983, 18.077, 18.171, 18.265, 18.36, 18.454, 18.548, 18.642, 18.737, 18.831, 18.925, 19.019, 19.114, 19.208, 19.302, 19.396, 19.491, 19.585, 19.679, 19.773, 19.868, 19.962, 20.056, 20.15, 20.244, 20.339, 20.433, 20.527, 20.621, 20.716, 20.81, 20.904, 20.998, 21.093, 21.187, 21.281, 21.375, 21.47, 21.564, 21.658, 21.752, 21.847, 21.941, 22.035, 22.129, 22.224, 22.318, 22.412, 22.506, 22.601, 22.695, 22.789, 22.883, 22.978, 23.072, 23.166, 23.26, 23.355, 23.449, 23.543, 23.637, 23.732, 23.826, 23.92, 24.014, 24.109, 24.203, 24.297, 24.391, 24.486, 24.58, 24.674, 24.768, 24.863, 24.957, 25.051], [-3.36, -3.268, -3.175, -3.082, -2.99, -2.897, -2.805, -2.712, -2.62, -2.527, -2.435, -2.342, -2.25, -2.157, -2.064, -1.972, -1.879, -1.787, -1.694, -1.602, -1.509, -1.417, -1.324, -1.232, -1.139, -1.046, -0.954, -0.861, -0.769, -0.676, -0.584, -0.491, -0.399, -0.306, -0.214, -0.121, -0.028, 0.064, 0.157, 0.249, 0.342, 0.434, 0.527, 0.619, 0.712, 0.804, 0.897, 0.99, 1.082, 1.175, 1.267, 1.36, 1.452, 1.545, 1.637, 1.73, 1.822, 1.915, 2.008, 2.1, 2.193, 2.285, 2.378, 2.47, 2.563, 2.655, 2.748, 2.84, 2.933, 3.026, 3.118, 3.211, 3.303, 3.396, 3.488, 3.581, 3.673, 3.766, 3.859, 3.951, 4.044, 4.136, 4.229, 4.321, 4.414, 4.506, 4.599, 4.691, 4.784, 4.877, 4.969, 5.062, 5.154, 5.247, 5.339, 5.432, 5.524, 5.617, 5.709, 5.802, 5.895, 5.987, 6.08, 6.172, 6.265, 6.357, 6.45, 6.542, 6.635, 6.727, 6.82, 6.913, 7.005, 7.098, 7.19, 7.283, 7.375, 7.468, 7.56, 7.653, 7.745, 7.838, 7.931, 8.023, 8.116, 8.208, 8.301, 8.393, 8.486, 8.578, 8.671, 8.763, 8.856, 8.949, 9.041, 9.134, 9.226, 9.319, 9.411, 9.504, 9.596, 9.689, 9.781, 9.874, 9.967, 10.059, 10.152, 10.244, 10.337, 10.429, 10.522, 10.614, 10.707, 10.799, 10.892, 10.985, 11.077, 11.17, 11.262, 11.355, 11.447, 11.54, 11.632, 11.725, 11.817, 11.91, 12.003, 12.095, 12.188, 12.28, 12.373, 12.465, 12.558, 12.65, 12.743, 12.835, 12.928, 13.021, 13.113, 13.206, 13.298, 13.391, 13.483, 13.576, 13.668, 13.761, 13.853, 13.946, 14.039, 14.131, 14.224, 14.316, 14.409, 14.501, 14.594, 14.686, 14.779, 14.871, 14.964, 15.057, 15.149, 15.242, 15.334, 15.427, 15.519, 15.612, 15.704, 15.797, 15.889, 15.982, 16.075, 16.167, 16.26, 16.352, 16.445, 16.537, 16.63, 16.722, 16.815, 16.907, 17.0, 17.093, 17.185, 17.278, 17.37, 17.463, 17.555, 17.648, 17.74, 17.833, 17.925, 18.018, 18.111, 18.203, 18.296, 18.388, 18.481, 18.573, 18.666, 18.758, 18.851, 18.943, 19.036, 19.129, 19.221, 19.314, 19.406, 19.499, 19.591, 19.684, 19.776, 19.869, 19.961, 20.054, 20.147, 20.239, 20.332, 20.424, 20.517, 20.609, 20.702, 20.794, 20.887, 20.979, 21.072, 21.165, 21.257, 21.35, 21.442, 21.535, 21.627, 21.72, 21.812, 21.905, 21.997, 22.09, 22.183, 22.275, 22.368, 22.46, 22.553, 22.645, 22.738, 22.83, 22.923, 23.015, 23.108, 23.201, 23.293, 23.386, 23.478, 23.571, 23.663, 23.756, 23.848, 23.941, 24.033, 24.126, 24.219, 24.311, 24.404, 24.40367941, -3.36, -3.268, -3.175, -3.082, -2.99, -2.897, -2.805, -2.712, -2.62, -2.527, -2.435, -2.342, -2.25, -2.157, -2.064, -1.972, -1.879, -1.787, -1.694, -1.602, -1.509, -1.417, -1.324, -1.232, -1.139, -1.046, -0.954, -0.861, -0.769, -0.676, -0.584, -0.491, -0.399, -0.306, -0.214, -0.121, -0.028, 0.064, 0.157, 0.249, 0.342, 0.434, 0.527, 0.619, 0.712, 0.804, 0.897, 0.99, 1.082, 1.175, 1.267, 1.36, 1.452, 1.545, 1.637, 1.73, 1.822, 1.915, 2.008, 2.1, 2.193, 2.285, 2.378, 2.47, 2.563, 2.655, 2.748, 2.84, 2.933, 3.026, 3.118, 3.211, 3.303, 3.396, 3.488, 3.581, 3.673, 3.766, 3.859, 3.951, 4.044, 4.136, 4.229, 4.321, 4.414, 4.506, 4.599, 4.691, 4.784, 4.877, 4.969, 5.062, 5.154, 5.247, 5.339, 5.432, 5.524, 5.617, 5.709, 5.802, 5.895, 5.987, 6.08, 6.172, 6.265, 6.357, 6.45, 6.542, 6.635, 6.727, 6.82, 6.913, 7.005, 7.098, 7.19, 7.283, 7.375, 7.468, 7.56, 7.653, 7.745, 7.838, 7.931, 8.023, 8.116, 8.208, 8.301, 8.393, 8.486, 8.578, 8.671, 8.763, 8.856, 8.949, 9.041, 9.134, 9.226, 9.319, 9.411, 9.504, 9.596, 9.689, 9.781, 9.874, 9.967, 10.059, 10.152, 10.244, 10.337, 10.429, 10.522, 10.614, 10.707, 10.799, 10.892, 10.985, 11.077, 11.17, 11.262, 11.355, 11.447, 11.54, 11.632, 11.725, 11.817, 11.91, 12.003, 12.095, 12.188, 12.28, 12.373, 12.465, 12.558, 12.65, 12.743, 12.835, 12.928, 13.021, 13.113, 13.206, 13.298, 13.391, 13.483, 13.576, 13.668, 13.761, 13.853, 13.946, 14.039, 14.131, 14.224, 14.316, 14.409, 14.501, 14.594, 14.686, 14.779, 14.871, 14.964, 15.057, 15.149, 15.242, 15.334, 15.427, 15.519, 15.612, 15.704, 15.797, 15.889, 15.982, 16.075, 16.167, 16.26, 16.352, 16.445, 16.537, 16.63, 16.722, 16.815, 16.907, 17.0, 17.093, 17.185, 17.278, 17.37, 17.463, 17.555, 17.648, 17.74, 17.833, 17.925, 18.018, 18.111, 18.203, 18.296, 18.388, 18.481, 18.573, 18.666, 18.758, 18.851, 18.943, 19.036, 19.129, 19.221, 19.314, 19.406, 19.499, 19.591, 19.684, 19.776, 19.869, 19.961, 20.054, 20.147, 20.239, 20.332, 20.424, 20.517, 20.609, 20.702, 20.794, 20.887, 20.979, 21.072, 21.165, 21.257, 21.35, 21.442, 21.535, 21.627, 21.72, 21.812, 21.905, 21.997, 22.09, 22.183, 22.275, 22.368, 22.46, 22.553, 22.645, 22.738, 22.83, 22.923, 23.015, 23.108, 23.201, 23.293, 23.386, 23.478, 23.571, 23.663, 23.756, 23.848, 23.941, 24.033, 24.126, 24.219, 24.311, 24.404, 24.40367941, -3.36, -3.268, -3.175, -3.082, -2.99, -2.897, -2.805, -2.712, -2.62, -2.527, -2.435, -2.342, -2.25, -2.157, -2.064, -1.972, -1.879, -1.787, -1.694, -1.602, -1.509, -1.417, -1.324, -1.232, -1.139, -1.046, -0.954, -0.861, -0.769, -0.676, -0.584, -0.491, -0.399, -0.306, -0.214, -0.121, -0.028, 0.064, 0.157, 0.249, 0.342, 0.434, 0.527, 0.619, 0.712, 0.804, 0.897, 0.99, 1.082, 1.175, 1.267, 1.36, 1.452, 1.545, 1.637, 1.73, 1.822, 1.915, 2.008, 2.1, 2.193, 2.285, 2.378, 2.47, 2.563, 2.655, 2.748, 2.84, 2.933, 3.026, 3.118, 3.211, 3.303, 3.396, 3.488, 3.581, 3.673, 3.766, 3.859, 3.951, 4.044, 4.136, 4.229, 4.321, 4.414, 4.506, 4.599, 4.691, 4.784, 4.877, 4.969, 5.062, 5.154, 5.247, 5.339, 5.432, 5.524, 5.617, 5.709, 5.802, 5.895, 5.987, 6.08, 6.172, 6.265, 6.357, 6.45, 6.542, 6.635, 6.727, 6.82, 6.913, 7.005, 7.098, 7.19, 7.283, 7.375, 7.468, 7.56, 7.653, 7.745, 7.838, 7.931, 8.023, 8.116, 8.208, 8.301, 8.393, 8.486, 8.578, 8.671, 8.763, 8.856, 8.949, 9.041, 9.134, 9.226, 9.319, 9.411, 9.504, 9.596, 9.689, 9.781, 9.874, 9.967, 10.059, 10.152, 10.244, 10.337, 10.429, 10.522, 10.614, 10.707, 10.799, 10.892, 10.985, 11.077, 11.17, 11.262, 11.355, 11.447, 11.54, 11.632, 11.725, 11.817, 11.91, 12.003, 12.095, 12.188, 12.28, 12.373, 12.465, 12.558, 12.65, 12.743, 12.835, 12.928, 13.021, 13.113, 13.206, 13.298, 13.391, 13.483, 13.576, 13.668, 13.761, 13.853, 13.946, 14.039, 14.131, 14.224, 14.316, 14.409, 14.501, 14.594, 14.686, 14.779, 14.871, 14.964, 15.057, 15.149, 15.242, 15.334, 15.427, 15.519, 15.612, 15.704, 15.797, 15.889, 15.982, 16.075, 16.167, 16.26, 16.352, 16.445, 16.537, 16.63, 16.722, 16.815, 16.907, 17.0, 17.093, 17.185, 17.278, 17.37, 17.463, 17.555, 17.648, 17.74, 17.833, 17.925, 18.018, 18.111, 18.203, 18.296, 18.388, 18.481, 18.573, 18.666, 18.758, 18.851, 18.943, 19.036, 19.129, 19.221, 19.314, 19.406, 19.499, 19.591, 19.684, 19.776, 19.869, 19.961, 20.054, 20.147, 20.239, 20.332, 20.424, 20.517, 20.609, 20.702, 20.794, 20.887, 20.979, 21.072, 21.165, 21.257, 21.35, 21.442, 21.535, 21.627, 21.72, 21.812, 21.905, 21.997, 22.09, 22.183, 22.275, 22.368, 22.46, 22.553, 22.645, 22.738, 22.83, 22.923, 23.015, 23.108, 23.201, 23.293, 23.386, 23.478, 23.571, 23.663, 23.756, 23.848, 23.941, 24.033, 24.126, 24.219, 24.311, 24.404, 24.40367941, -3.36, -3.268, -3.175, -3.082, -2.99, -2.897, -2.805, -2.712, -2.62, -2.527, -2.435, -2.342, -2.25, -2.157, -2.064, -1.972, -1.879, -1.787, -1.694, -1.602, -1.509, -1.417, -1.324, -1.232, -1.139, -1.046, -0.954, -0.861, -0.769, -0.676, -0.584, -0.491, -0.399, -0.306, -0.214, -0.121, -0.028, 0.064, 0.157, 0.249, 0.342, 0.434, 0.527, 0.619, 0.712, 0.804, 0.897, 0.99, 1.082, 1.175, 1.267, 1.36, 1.452, 1.545, 1.637, 1.73, 1.822, 1.915, 2.008, 2.1, 2.193, 2.285, 2.378, 2.47, 2.563, 2.655, 2.748, 2.84, 2.933, 3.026, 3.118, 3.211, 3.303, 3.396, 3.488, 3.581, 3.673, 3.766, 3.859, 3.951, 4.044, 4.136, 4.229, 4.321, 4.414, 4.506, 4.599, 4.691, 4.784, 4.877, 4.969, 5.062, 5.154, 5.247, 5.339, 5.432, 5.524, 5.617, 5.709, 5.802, 5.895, 5.987, 6.08, 6.172, 6.265, 6.357, 6.45, 6.542, 6.635, 6.727, 6.82, 6.913, 7.005, 7.098, 7.19, 7.283, 7.375, 7.468, 7.56, 7.653, 7.745, 7.838, 7.931, 8.023, 8.116, 8.208, 8.301, 8.393, 8.486, 8.578, 8.671, 8.763, 8.856, 8.949, 9.041, 9.134, 9.226, 9.319, 9.411, 9.504, 9.596, 9.689, 9.781, 9.874, 9.967, 10.059, 10.152, 10.244, 10.337, 10.429, 10.522, 10.614, 10.707, 10.799, 10.892, 10.985, 11.077, 11.17, 11.262, 11.355, 11.447, 11.54, 11.632, 11.725, 11.817, 11.91, 12.003, 12.095, 12.188, 12.28, 12.373, 12.465, 12.558, 12.65, 12.743, 12.835, 12.928, 13.021, 13.113, 13.206, 13.298, 13.391, 13.483, 13.576, 13.668, 13.761, 13.853, 13.946, 14.039, 14.131, 14.224, 14.316, 14.409, 14.501, 14.594, 14.686, 14.779, 14.871, 14.964, 15.057, 15.149, 15.242, 15.334, 15.427, 15.519, 15.612, 15.704, 15.797, 15.889, 15.982, 16.075, 16.167, 16.26, 16.352, 16.445, 16.537, 16.63, 16.722, 16.815, 16.907, 17.0, 17.093, 17.185, 17.278, 17.37, 17.463, 17.555, 17.648, 17.74, 17.833, 17.925, 18.018, 18.111, 18.203, 18.296, 18.388, 18.481, 18.573, 18.666, 18.758, 18.851, 18.943, 19.036, 19.129, 19.221, 19.314, 19.406, 19.499, 19.591, 19.684, 19.776, 19.869, 19.961, 20.054, 20.147, 20.239, 20.332, 20.424, 20.517, 20.609, 20.702, 20.794, 20.887, 20.979, 21.072, 21.165, 21.257, 21.35, 21.442, 21.535, 21.627, 21.72, 21.812, 21.905, 21.997, 22.09, 22.183, 22.275, 22.368, 22.46, 22.553, 22.645, 22.738, 22.83, 22.923, 23.015, 23.108, 23.201, 23.293, 23.386, 23.478, 23.571, 23.663, 23.756, 23.848, 23.941, 24.033, 24.126, 24.219, 24.311, 24.404, 24.40367941, -3.36, -3.268, -3.175, -3.082, -2.99, -2.897, -2.805, -2.712, -2.62, -2.527, -2.435, -2.342, -2.25, -2.157, -2.064, -1.972, -1.879, -1.787, -1.694, -1.602, -1.509, -1.417, -1.324, -1.232, -1.139, -1.046, -0.954, -0.861, -0.769, -0.676, -0.584, -0.491, -0.399, -0.306, -0.214, -0.121, -0.028, 0.064, 0.157, 0.249, 0.342, 0.434, 0.527, 0.619, 0.712, 0.804, 0.897, 0.99, 1.082, 1.175, 1.267, 1.36, 1.452, 1.545, 1.637, 1.73, 1.822, 1.915, 2.008, 2.1, 2.193, 2.285, 2.378, 2.47, 2.563, 2.655, 2.748, 2.84, 2.933, 3.026, 3.118, 3.211, 3.303, 3.396, 3.488, 3.581, 3.673, 3.766, 3.859, 3.951, 4.044, 4.136, 4.229, 4.321, 4.414, 4.506, 4.599, 4.691, 4.784, 4.877, 4.969, 5.062, 5.154, 5.247, 5.339, 5.432, 5.524, 5.617, 5.709, 5.802, 5.895, 5.987, 6.08, 6.172, 6.265, 6.357, 6.45, 6.542, 6.635, 6.727, 6.82, 6.913, 7.005, 7.098, 7.19, 7.283, 7.375, 7.468, 7.56, 7.653, 7.745, 7.838, 7.931, 8.023, 8.116, 8.208, 8.301, 8.393, 8.486, 8.578, 8.671, 8.763, 8.856, 8.949, 9.041, 9.134, 9.226, 9.319, 9.411, 9.504, 9.596, 9.689, 9.781, 9.874, 9.967, 10.059, 10.152, 10.244, 10.337, 10.429, 10.522, 10.614, 10.707, 10.799, 10.892, 10.985, 11.077, 11.17, 11.262, 11.355, 11.447, 11.54, 11.632, 11.725, 11.817, 11.91, 12.003, 12.095, 12.188, 12.28, 12.373, 12.465, 12.558, 12.65, 12.743, 12.835, 12.928, 13.021, 13.113, 13.206, 13.298, 13.391, 13.483, 13.576, 13.668, 13.761, 13.853, 13.946, 14.039, 14.131, 14.224, 14.316, 14.409, 14.501, 14.594, 14.686, 14.779, 14.871, 14.964, 15.057, 15.149, 15.242, 15.334, 15.427, 15.519, 15.612, 15.704, 15.797, 15.889, 15.982, 16.075, 16.167, 16.26, 16.352, 16.445, 16.537, 16.63, 16.722, 16.815, 16.907, 17.0, 17.093, 17.185, 17.278, 17.37, 17.463, 17.555, 17.648, 17.74, 17.833, 17.925, 18.018, 18.111, 18.203, 18.296, 18.388, 18.481, 18.573, 18.666, 18.758, 18.851, 18.943, 19.036, 19.129, 19.221, 19.314, 19.406, 19.499, 19.591, 19.684, 19.776, 19.869, 19.961, 20.054, 20.147, 20.239, 20.332, 20.424, 20.517, 20.609, 20.702, 20.794, 20.887, 20.979, 21.072, 21.165, 21.257, 21.35, 21.442, 21.535, 21.627, 21.72, 21.812, 21.905, 21.997, 22.09, 22.183, 22.275, 22.368, 22.46, 22.553, 22.645, 22.738, 22.83, 22.923, 23.015, 23.108, 23.201, 23.293, 23.386, 23.478, 23.571, 23.663, 23.756, 23.848, 23.941, 24.033, 24.126, 24.219, 24.311, 24.404], [-3.49, -3.399, -3.308, -3.217, -3.126, -3.036, -2.945, -2.854, -2.763, -2.672, -2.581, -2.49, -2.399, -2.309, -2.218, -2.127, -2.036, -1.945, -1.854, -1.763, -1.672, -1.582, -1.491, -1.4, -1.309, -1.218, -1.127, -1.036, -0.945, -0.855, -0.764, -0.673, -0.582, -0.491, -0.4, -0.309, -0.218, -0.128, -0.037, 0.054, 0.145, 0.236, 0.327, 0.418, 0.509, 0.599, 0.69, 0.781, 0.872, 0.963, 1.054, 1.145, 1.236, 1.326, 1.417, 1.508, 1.599, 1.69, 1.781, 1.872, 1.963, 2.053, 2.144, 2.235, 2.326, 2.417, 2.508, 2.599, 2.69, 2.78, 2.871, 2.962, 3.053, 3.144, 3.235, 3.326, 3.417, 3.507, 3.598, 3.689, 3.78, 3.871, 3.962, 4.053, 4.144, 4.234, 4.325, 4.416, 4.507, 4.598, 4.689, 4.78, 4.871, 4.961, 5.052, 5.143, 5.234, 5.325, 5.416, 5.507, 5.598, 5.688, 5.779, 5.87, 5.961, 6.052, 6.143, 6.234, 6.325, 6.415, 6.506, 6.597, 6.688, 6.779, 6.87, 6.961, 7.052, 7.142, 7.233, 7.324, 7.415, 7.506, 7.597, 7.688, 7.778, 7.869, 7.96, 8.051, 8.142, 8.233, 8.324, 8.415, 8.505, 8.596, 8.687, 8.778, 8.869, 8.96, 9.051, 9.142, 9.232, 9.323, 9.414, 9.505, 9.596, 9.687, 9.778, 9.869, 9.959, 10.05, 10.141, 10.232, 10.323, 10.414, 10.505, 10.596, 10.686, 10.777, 10.868, 10.959, 11.05, 11.141, 11.232, 11.323, 11.413, 11.504, 11.595, 11.686, 11.777, 11.868, 11.959, 12.05, 12.14, 12.231, 12.322, 12.413, 12.504, 12.595, 12.686, 12.777, 12.867, 12.958, 13.049, 13.14, 13.231, 13.322, 13.413, 13.504, 13.594, 13.685, 13.776, 13.867, 13.958, 14.049, 14.14, 14.231, 14.321, 14.412, 14.503, 14.594, 14.685, 14.776, 14.867, 14.958, 15.048, 15.139, 15.23, 15.321, 15.412, 15.503, 15.594, 15.685, 15.775, 15.866, 15.957, 16.048, 16.139, 16.23, 16.321, 16.412, 16.502, 16.593, 16.684, 16.775, 16.866, 16.957, 17.048, 17.139, 17.229, 17.32, 17.411, 17.502, 17.593, 17.684, 17.775, 17.866, 17.956, 18.047, 18.138, 18.229, 18.32, 18.411, 18.502, 18.593, 18.683, 18.774, 18.865, 18.956, 19.047, 19.138, 19.229, 19.32, 19.41, 19.501, 19.592, 19.683, 19.774, 19.865, 19.956, 20.047, 20.137, 20.228, 20.319, 20.41, 20.501, 20.592, 20.683, 20.774, 20.864, 20.955, 21.046, 21.137, 21.228, 21.319, 21.41, 21.501, 21.591, 21.682, 21.773, 21.864, 21.955, 22.046, 22.137, 22.228, 22.318, 22.409, 22.5, 22.591, 22.682, 22.773, 22.864, 22.955, 23.045, 23.136, 23.227, 23.318, 23.409, 23.5, 23.591, 23.681, 23.772, 23.77237044, -3.49, -3.399, -3.308, -3.217, -3.126, -3.036, -2.945, -2.854, -2.763, -2.672, -2.581, -2.49, -2.399, -2.309, -2.218, -2.127, -2.036, -1.945, -1.854, -1.763, -1.672, -1.582, -1.491, -1.4, -1.309, -1.218, -1.127, -1.036, -0.945, -0.855, -0.764, -0.673, -0.582, -0.491, -0.4, -0.309, -0.218, -0.128, -0.037, 0.054, 0.145, 0.236, 0.327, 0.418, 0.509, 0.599, 0.69, 0.781, 0.872, 0.963, 1.054, 1.145, 1.236, 1.326, 1.417, 1.508, 1.599, 1.69, 1.781, 1.872, 1.963, 2.053, 2.144, 2.235, 2.326, 2.417, 2.508, 2.599, 2.69, 2.78, 2.871, 2.962, 3.053, 3.144, 3.235, 3.326, 3.417, 3.507, 3.598, 3.689, 3.78, 3.871, 3.962, 4.053, 4.144, 4.234, 4.325, 4.416, 4.507, 4.598, 4.689, 4.78, 4.871, 4.961, 5.052, 5.143, 5.234, 5.325, 5.416, 5.507, 5.598, 5.688, 5.779, 5.87, 5.961, 6.052, 6.143, 6.234, 6.325, 6.415, 6.506, 6.597, 6.688, 6.779, 6.87, 6.961, 7.052, 7.142, 7.233, 7.324, 7.415, 7.506, 7.597, 7.688, 7.778, 7.869, 7.96, 8.051, 8.142, 8.233, 8.324, 8.415, 8.505, 8.596, 8.687, 8.778, 8.869, 8.96, 9.051, 9.142, 9.232, 9.323, 9.414, 9.505, 9.596, 9.687, 9.778, 9.869, 9.959, 10.05, 10.141, 10.232, 10.323, 10.414, 10.505, 10.596, 10.686, 10.777, 10.868, 10.959, 11.05, 11.141, 11.232, 11.323, 11.413, 11.504, 11.595, 11.686, 11.777, 11.868, 11.959, 12.05, 12.14, 12.231, 12.322, 12.413, 12.504, 12.595, 12.686, 12.777, 12.867, 12.958, 13.049, 13.14, 13.231, 13.322, 13.413, 13.504, 13.594, 13.685, 13.776, 13.867, 13.958, 14.049, 14.14, 14.231, 14.321, 14.412, 14.503, 14.594, 14.685, 14.776, 14.867, 14.958, 15.048, 15.139, 15.23, 15.321, 15.412, 15.503, 15.594, 15.685, 15.775, 15.866, 15.957, 16.048, 16.139, 16.23, 16.321, 16.412, 16.502, 16.593, 16.684, 16.775, 16.866, 16.957, 17.048, 17.139, 17.229, 17.32, 17.411, 17.502, 17.593, 17.684, 17.775, 17.866, 17.956, 18.047, 18.138, 18.229, 18.32, 18.411, 18.502, 18.593, 18.683, 18.774, 18.865, 18.956, 19.047, 19.138, 19.229, 19.32, 19.41, 19.501, 19.592, 19.683, 19.774, 19.865, 19.956, 20.047, 20.137, 20.228, 20.319, 20.41, 20.501, 20.592, 20.683, 20.774, 20.864, 20.955, 21.046, 21.137, 21.228, 21.319, 21.41, 21.501, 21.591, 21.682, 21.773, 21.864, 21.955, 22.046, 22.137, 22.228, 22.318, 22.409, 22.5, 22.591, 22.682, 22.773, 22.864, 22.955, 23.045, 23.136, 23.227, 23.318, 23.409, 23.5, 23.591, 23.681, 23.772, 23.77237044, -3.49, -3.399, -3.308, -3.217, -3.126, -3.036, -2.945, -2.854, -2.763, -2.672, -2.581, -2.49, -2.399, -2.309, -2.218, -2.127, -2.036, -1.945, -1.854, -1.763, -1.672, -1.582, -1.491, -1.4, -1.309, -1.218, -1.127, -1.036, -0.945, -0.855, -0.764, -0.673, -0.582, -0.491, -0.4, -0.309, -0.218, -0.128, -0.037, 0.054, 0.145, 0.236, 0.327, 0.418, 0.509, 0.599, 0.69, 0.781, 0.872, 0.963, 1.054, 1.145, 1.236, 1.326, 1.417, 1.508, 1.599, 1.69, 1.781, 1.872, 1.963, 2.053, 2.144, 2.235, 2.326, 2.417, 2.508, 2.599, 2.69, 2.78, 2.871, 2.962, 3.053, 3.144, 3.235, 3.326, 3.417, 3.507, 3.598, 3.689, 3.78, 3.871, 3.962, 4.053, 4.144, 4.234, 4.325, 4.416, 4.507, 4.598, 4.689, 4.78, 4.871, 4.961, 5.052, 5.143, 5.234, 5.325, 5.416, 5.507, 5.598, 5.688, 5.779, 5.87, 5.961, 6.052, 6.143, 6.234, 6.325, 6.415, 6.506, 6.597, 6.688, 6.779, 6.87, 6.961, 7.052, 7.142, 7.233, 7.324, 7.415, 7.506, 7.597, 7.688, 7.778, 7.869, 7.96, 8.051, 8.142, 8.233, 8.324, 8.415, 8.505, 8.596, 8.687, 8.778, 8.869, 8.96, 9.051, 9.142, 9.232, 9.323, 9.414, 9.505, 9.596, 9.687, 9.778, 9.869, 9.959, 10.05, 10.141, 10.232, 10.323, 10.414, 10.505, 10.596, 10.686, 10.777, 10.868, 10.959, 11.05, 11.141, 11.232, 11.323, 11.413, 11.504, 11.595, 11.686, 11.777, 11.868, 11.959, 12.05, 12.14, 12.231, 12.322, 12.413, 12.504, 12.595, 12.686, 12.777, 12.867, 12.958, 13.049, 13.14, 13.231, 13.322, 13.413, 13.504, 13.594, 13.685, 13.776, 13.867, 13.958, 14.049, 14.14, 14.231, 14.321, 14.412, 14.503, 14.594, 14.685, 14.776, 14.867, 14.958, 15.048, 15.139, 15.23, 15.321, 15.412, 15.503, 15.594, 15.685, 15.775, 15.866, 15.957, 16.048, 16.139, 16.23, 16.321, 16.412, 16.502, 16.593, 16.684, 16.775, 16.866, 16.957, 17.048, 17.139, 17.229, 17.32, 17.411, 17.502, 17.593, 17.684, 17.775, 17.866, 17.956, 18.047, 18.138, 18.229, 18.32, 18.411, 18.502, 18.593, 18.683, 18.774, 18.865, 18.956, 19.047, 19.138, 19.229, 19.32, 19.41, 19.501, 19.592, 19.683, 19.774, 19.865, 19.956, 20.047, 20.137, 20.228, 20.319, 20.41, 20.501, 20.592, 20.683, 20.774, 20.864, 20.955, 21.046, 21.137, 21.228, 21.319, 21.41, 21.501, 21.591, 21.682, 21.773, 21.864, 21.955, 22.046, 22.137, 22.228, 22.318, 22.409, 22.5, 22.591, 22.682, 22.773, 22.864, 22.955, 23.045, 23.136, 23.227, 23.318, 23.409, 23.5, 23.591, 23.681, 23.772, 23.77237044, -3.49, -3.399, -3.308, -3.217, -3.126, -3.036, -2.945, -2.854, -2.763, -2.672, -2.581, -2.49, -2.399, -2.309, -2.218, -2.127, -2.036, -1.945, -1.854, -1.763, -1.672, -1.582, -1.491, -1.4, -1.309, -1.218, -1.127, -1.036, -0.945, -0.855, -0.764, -0.673, -0.582, -0.491, -0.4, -0.309, -0.218, -0.128, -0.037, 0.054, 0.145, 0.236, 0.327, 0.418, 0.509, 0.599, 0.69, 0.781, 0.872, 0.963, 1.054, 1.145, 1.236, 1.326, 1.417, 1.508, 1.599, 1.69, 1.781, 1.872, 1.963, 2.053, 2.144, 2.235, 2.326, 2.417, 2.508, 2.599, 2.69, 2.78, 2.871, 2.962, 3.053, 3.144, 3.235, 3.326, 3.417, 3.507, 3.598, 3.689, 3.78, 3.871, 3.962, 4.053, 4.144, 4.234, 4.325, 4.416, 4.507, 4.598, 4.689, 4.78, 4.871, 4.961, 5.052, 5.143, 5.234, 5.325, 5.416, 5.507, 5.598, 5.688, 5.779, 5.87, 5.961, 6.052, 6.143, 6.234, 6.325, 6.415, 6.506, 6.597, 6.688, 6.779, 6.87, 6.961, 7.052, 7.142, 7.233, 7.324, 7.415, 7.506, 7.597, 7.688, 7.778, 7.869, 7.96, 8.051, 8.142, 8.233, 8.324, 8.415, 8.505, 8.596, 8.687, 8.778, 8.869, 8.96, 9.051, 9.142, 9.232, 9.323, 9.414, 9.505, 9.596, 9.687, 9.778, 9.869, 9.959, 10.05, 10.141, 10.232, 10.323, 10.414, 10.505, 10.596, 10.686, 10.777, 10.868, 10.959, 11.05, 11.141, 11.232, 11.323, 11.413, 11.504, 11.595, 11.686, 11.777, 11.868, 11.959, 12.05, 12.14, 12.231, 12.322, 12.413, 12.504, 12.595, 12.686, 12.777, 12.867, 12.958, 13.049, 13.14, 13.231, 13.322, 13.413, 13.504, 13.594, 13.685, 13.776, 13.867, 13.958, 14.049, 14.14, 14.231, 14.321, 14.412, 14.503, 14.594, 14.685, 14.776, 14.867, 14.958, 15.048, 15.139, 15.23, 15.321, 15.412, 15.503, 15.594, 15.685, 15.775, 15.866, 15.957, 16.048, 16.139, 16.23, 16.321, 16.412, 16.502, 16.593, 16.684, 16.775, 16.866, 16.957, 17.048, 17.139, 17.229, 17.32, 17.411, 17.502, 17.593, 17.684, 17.775, 17.866, 17.956, 18.047, 18.138, 18.229, 18.32, 18.411, 18.502, 18.593, 18.683, 18.774, 18.865, 18.956, 19.047, 19.138, 19.229, 19.32, 19.41, 19.501, 19.592, 19.683, 19.774, 19.865, 19.956, 20.047, 20.137, 20.228, 20.319, 20.41, 20.501, 20.592, 20.683, 20.774, 20.864, 20.955, 21.046, 21.137, 21.228, 21.319, 21.41, 21.501, 21.591, 21.682, 21.773, 21.864, 21.955, 22.046, 22.137, 22.228, 22.318, 22.409, 22.5, 22.591, 22.682, 22.773, 22.864, 22.955, 23.045, 23.136, 23.227, 23.318, 23.409, 23.5, 23.591, 23.681, 23.772, 23.77237044, -3.49, -3.399, -3.308, -3.217, -3.126, -3.036, -2.945, -2.854, -2.763, -2.672, -2.581, -2.49, -2.399, -2.309, -2.218, -2.127, -2.036, -1.945, -1.854, -1.763, -1.672, -1.582, -1.491, -1.4, -1.309, -1.218, -1.127, -1.036, -0.945, -0.855, -0.764, -0.673, -0.582, -0.491, -0.4, -0.309, -0.218, -0.128, -0.037, 0.054, 0.145, 0.236, 0.327, 0.418, 0.509, 0.599, 0.69, 0.781, 0.872, 0.963, 1.054, 1.145, 1.236, 1.326, 1.417, 1.508, 1.599, 1.69, 1.781, 1.872, 1.963, 2.053, 2.144, 2.235, 2.326, 2.417, 2.508, 2.599, 2.69, 2.78, 2.871, 2.962, 3.053, 3.144, 3.235, 3.326, 3.417, 3.507, 3.598, 3.689, 3.78, 3.871, 3.962, 4.053, 4.144, 4.234, 4.325, 4.416, 4.507, 4.598, 4.689, 4.78, 4.871, 4.961, 5.052, 5.143, 5.234, 5.325, 5.416, 5.507, 5.598, 5.688, 5.779, 5.87, 5.961, 6.052, 6.143, 6.234, 6.325, 6.415, 6.506, 6.597, 6.688, 6.779, 6.87, 6.961, 7.052, 7.142, 7.233, 7.324, 7.415, 7.506, 7.597, 7.688, 7.778, 7.869, 7.96, 8.051, 8.142, 8.233, 8.324, 8.415, 8.505, 8.596, 8.687, 8.778, 8.869, 8.96, 9.051, 9.142, 9.232, 9.323, 9.414, 9.505, 9.596, 9.687, 9.778, 9.869, 9.959, 10.05, 10.141, 10.232, 10.323, 10.414, 10.505, 10.596, 10.686, 10.777, 10.868, 10.959, 11.05, 11.141, 11.232, 11.323, 11.413, 11.504, 11.595, 11.686, 11.777, 11.868, 11.959, 12.05, 12.14, 12.231, 12.322, 12.413, 12.504, 12.595, 12.686, 12.777, 12.867, 12.958, 13.049, 13.14, 13.231, 13.322, 13.413, 13.504, 13.594, 13.685, 13.776, 13.867, 13.958, 14.049, 14.14, 14.231, 14.321, 14.412, 14.503, 14.594, 14.685, 14.776, 14.867, 14.958, 15.048, 15.139, 15.23, 15.321, 15.412, 15.503, 15.594, 15.685, 15.775, 15.866, 15.957, 16.048, 16.139, 16.23, 16.321, 16.412, 16.502, 16.593, 16.684, 16.775, 16.866, 16.957, 17.048, 17.139, 17.229, 17.32, 17.411, 17.502, 17.593, 17.684, 17.775, 17.866, 17.956, 18.047, 18.138, 18.229, 18.32, 18.411, 18.502, 18.593, 18.683, 18.774, 18.865, 18.956, 19.047, 19.138, 19.229, 19.32, 19.41, 19.501, 19.592, 19.683, 19.774, 19.865, 19.956, 20.047, 20.137, 20.228, 20.319, 20.41, 20.501, 20.592, 20.683, 20.774, 20.864, 20.955, 21.046, 21.137, 21.228, 21.319, 21.41, 21.501, 21.591, 21.682, 21.773, 21.864, 21.955, 22.046, 22.137, 22.228, 22.318, 22.409, 22.5, 22.591, 22.682, 22.773, 22.864, 22.955, 23.045, 23.136, 23.227, 23.318, 23.409, 23.5, 23.591, 23.681, 23.772], [-3.613, -3.524, -3.434, -3.345, -3.256, -3.167, -3.077, -2.988, -2.899, -2.81, -2.721, -2.631, -2.542, -2.453, -2.364, -2.274, -2.185, -2.096, -2.007, -1.917, -1.828, -1.739, -1.65, -1.561, -1.471, -1.382, -1.293, -1.204, -1.114, -1.025, -0.936, -0.847, -0.758, -0.668, -0.579, -0.49, -0.401, -0.311, -0.222, -0.133, -0.044, 0.046, 0.135, 0.224, 0.313, 0.402, 0.492, 0.581, 0.67, 0.759, 0.849, 0.938, 1.027, 1.116, 1.205, 1.295, 1.384, 1.473, 1.562, 1.652, 1.741, 1.83, 1.919, 2.008, 2.098, 2.187, 2.276, 2.365, 2.455, 2.544, 2.633, 2.722, 2.812, 2.901, 2.99, 3.079, 3.168, 3.258, 3.347, 3.436, 3.525, 3.615, 3.704, 3.793, 3.882, 3.971, 4.061, 4.15, 4.239, 4.328, 4.418, 4.507, 4.596, 4.685, 4.775, 4.864, 4.953, 5.042, 5.131, 5.221, 5.31, 5.399, 5.488, 5.578, 5.667, 5.756, 5.845, 5.934, 6.024, 6.113, 6.202, 6.291, 6.381, 6.47, 6.559, 6.648, 6.737, 6.827, 6.916, 7.005, 7.094, 7.184, 7.273, 7.362, 7.451, 7.541, 7.63, 7.719, 7.808, 7.897, 7.987, 8.076, 8.165, 8.254, 8.344, 8.433, 8.522, 8.611, 8.7, 8.79, 8.879, 8.968, 9.057, 9.147, 9.236, 9.325, 9.414, 9.504, 9.593, 9.682, 9.771, 9.86, 9.95, 10.039, 10.128, 10.217, 10.307, 10.396, 10.485, 10.574, 10.663, 10.753, 10.842, 10.931, 11.02, 11.11, 11.199, 11.288, 11.377, 11.466, 11.556, 11.645, 11.734, 11.823, 11.913, 12.002, 12.091, 12.18, 12.27, 12.359, 12.448, 12.537, 12.626, 12.716, 12.805, 12.894, 12.983, 13.073, 13.162, 13.251, 13.34, 13.429, 13.519, 13.608, 13.697, 13.786, 13.876, 13.965, 14.054, 14.143, 14.233, 14.322, 14.411, 14.5, 14.589, 14.679, 14.768, 14.857, 14.946, 15.036, 15.125, 15.214, 15.303, 15.392, 15.482, 15.571, 15.66, 15.749, 15.839, 15.928, 16.017, 16.106, 16.195, 16.285, 16.374, 16.463, 16.552, 16.642, 16.731, 16.82, 16.909, 16.999, 17.088, 17.177, 17.266, 17.355, 17.445, 17.534, 17.623, 17.712, 17.802, 17.891, 17.98, 18.069, 18.158, 18.248, 18.337, 18.426, 18.515, 18.605, 18.694, 18.783, 18.872, 18.962, 19.051, 19.14, 19.229, 19.318, 19.408, 19.497, 19.586, 19.675, 19.765, 19.854, 19.943, 20.032, 20.121, 20.211, 20.3, 20.389, 20.478, 20.568, 20.657, 20.746, 20.835, 20.924, 21.014, 21.103, 21.192, 21.281, 21.371, 21.46, 21.549, 21.638, 21.728, 21.817, 21.906, 21.995, 22.084, 22.174, 22.263, 22.352, 22.441, 22.531, 22.62, 22.709, 22.798, 22.887, 22.977, 23.066, 23.155, 23.15515042, -3.613, -3.524, -3.434, -3.345, -3.256, -3.167, -3.077, -2.988, -2.899, -2.81, -2.721, -2.631, -2.542, -2.453, -2.364, -2.274, -2.185, -2.096, -2.007, -1.917, -1.828, -1.739, -1.65, -1.561, -1.471, -1.382, -1.293, -1.204, -1.114, -1.025, -0.936, -0.847, -0.758, -0.668, -0.579, -0.49, -0.401, -0.311, -0.222, -0.133, -0.044, 0.046, 0.135, 0.224, 0.313, 0.402, 0.492, 0.581, 0.67, 0.759, 0.849, 0.938, 1.027, 1.116, 1.205, 1.295, 1.384, 1.473, 1.562, 1.652, 1.741, 1.83, 1.919, 2.008, 2.098, 2.187, 2.276, 2.365, 2.455, 2.544, 2.633, 2.722, 2.812, 2.901, 2.99, 3.079, 3.168, 3.258, 3.347, 3.436, 3.525, 3.615, 3.704, 3.793, 3.882, 3.971, 4.061, 4.15, 4.239, 4.328, 4.418, 4.507, 4.596, 4.685, 4.775, 4.864, 4.953, 5.042, 5.131, 5.221, 5.31, 5.399, 5.488, 5.578, 5.667, 5.756, 5.845, 5.934, 6.024, 6.113, 6.202, 6.291, 6.381, 6.47, 6.559, 6.648, 6.737, 6.827, 6.916, 7.005, 7.094, 7.184, 7.273, 7.362, 7.451, 7.541, 7.63, 7.719, 7.808, 7.897, 7.987, 8.076, 8.165, 8.254, 8.344, 8.433, 8.522, 8.611, 8.7, 8.79, 8.879, 8.968, 9.057, 9.147, 9.236, 9.325, 9.414, 9.504, 9.593, 9.682, 9.771, 9.86, 9.95, 10.039, 10.128, 10.217, 10.307, 10.396, 10.485, 10.574, 10.663, 10.753, 10.842, 10.931, 11.02, 11.11, 11.199, 11.288, 11.377, 11.466, 11.556, 11.645, 11.734, 11.823, 11.913, 12.002, 12.091, 12.18, 12.27, 12.359, 12.448, 12.537, 12.626, 12.716, 12.805, 12.894, 12.983, 13.073, 13.162, 13.251, 13.34, 13.429, 13.519, 13.608, 13.697, 13.786, 13.876, 13.965, 14.054, 14.143, 14.233, 14.322, 14.411, 14.5, 14.589, 14.679, 14.768, 14.857, 14.946, 15.036, 15.125, 15.214, 15.303, 15.392, 15.482, 15.571, 15.66, 15.749, 15.839, 15.928, 16.017, 16.106, 16.195, 16.285, 16.374, 16.463, 16.552, 16.642, 16.731, 16.82, 16.909, 16.999, 17.088, 17.177, 17.266, 17.355, 17.445, 17.534, 17.623, 17.712, 17.802, 17.891, 17.98, 18.069, 18.158, 18.248, 18.337, 18.426, 18.515, 18.605, 18.694, 18.783, 18.872, 18.962, 19.051, 19.14, 19.229, 19.318, 19.408, 19.497, 19.586, 19.675, 19.765, 19.854, 19.943, 20.032, 20.121, 20.211, 20.3, 20.389, 20.478, 20.568, 20.657, 20.746, 20.835, 20.924, 21.014, 21.103, 21.192, 21.281, 21.371, 21.46, 21.549, 21.638, 21.728, 21.817, 21.906, 21.995, 22.084, 22.174, 22.263, 22.352, 22.441, 22.531, 22.62, 22.709, 22.798, 22.887, 22.977, 23.066, 23.155, 23.15515042, -3.613, -3.524, -3.434, -3.345, -3.256, -3.167, -3.077, -2.988, -2.899, -2.81, -2.721, -2.631, -2.542, -2.453, -2.364, -2.274, -2.185, -2.096, -2.007, -1.917, -1.828, -1.739, -1.65, -1.561, -1.471, -1.382, -1.293, -1.204, -1.114, -1.025, -0.936, -0.847, -0.758, -0.668, -0.579, -0.49, -0.401, -0.311, -0.222, -0.133, -0.044, 0.046, 0.135, 0.224, 0.313, 0.402, 0.492, 0.581, 0.67, 0.759, 0.849, 0.938, 1.027, 1.116, 1.205, 1.295, 1.384, 1.473, 1.562, 1.652, 1.741, 1.83, 1.919, 2.008, 2.098, 2.187, 2.276, 2.365, 2.455, 2.544, 2.633, 2.722, 2.812, 2.901, 2.99, 3.079, 3.168, 3.258, 3.347, 3.436, 3.525, 3.615, 3.704, 3.793, 3.882, 3.971, 4.061, 4.15, 4.239, 4.328, 4.418, 4.507, 4.596, 4.685, 4.775, 4.864, 4.953, 5.042, 5.131, 5.221, 5.31, 5.399, 5.488, 5.578, 5.667, 5.756, 5.845, 5.934, 6.024, 6.113, 6.202, 6.291, 6.381, 6.47, 6.559, 6.648, 6.737, 6.827, 6.916, 7.005, 7.094, 7.184, 7.273, 7.362, 7.451, 7.541, 7.63, 7.719, 7.808, 7.897, 7.987, 8.076, 8.165, 8.254, 8.344, 8.433, 8.522, 8.611, 8.7, 8.79, 8.879, 8.968, 9.057, 9.147, 9.236, 9.325, 9.414, 9.504, 9.593, 9.682, 9.771, 9.86, 9.95, 10.039, 10.128, 10.217, 10.307, 10.396, 10.485, 10.574, 10.663, 10.753, 10.842, 10.931, 11.02, 11.11, 11.199, 11.288, 11.377, 11.466, 11.556, 11.645, 11.734, 11.823, 11.913, 12.002, 12.091, 12.18, 12.27, 12.359, 12.448, 12.537, 12.626, 12.716, 12.805, 12.894, 12.983, 13.073, 13.162, 13.251, 13.34, 13.429, 13.519, 13.608, 13.697, 13.786, 13.876, 13.965, 14.054, 14.143, 14.233, 14.322, 14.411, 14.5, 14.589, 14.679, 14.768, 14.857, 14.946, 15.036, 15.125, 15.214, 15.303, 15.392, 15.482, 15.571, 15.66, 15.749, 15.839, 15.928, 16.017, 16.106, 16.195, 16.285, 16.374, 16.463, 16.552, 16.642, 16.731, 16.82, 16.909, 16.999, 17.088, 17.177, 17.266, 17.355, 17.445, 17.534, 17.623, 17.712, 17.802, 17.891, 17.98, 18.069, 18.158, 18.248, 18.337, 18.426, 18.515, 18.605, 18.694, 18.783, 18.872, 18.962, 19.051, 19.14, 19.229, 19.318, 19.408, 19.497, 19.586, 19.675, 19.765, 19.854, 19.943, 20.032, 20.121, 20.211, 20.3, 20.389, 20.478, 20.568, 20.657, 20.746, 20.835, 20.924, 21.014, 21.103, 21.192, 21.281, 21.371, 21.46, 21.549, 21.638, 21.728, 21.817, 21.906, 21.995, 22.084, 22.174, 22.263, 22.352, 22.441, 22.531, 22.62, 22.709, 22.798, 22.887, 22.977, 23.066, 23.155, 23.15515042, -3.613, -3.524, -3.434, -3.345, -3.256, -3.167, -3.077, -2.988, -2.899, -2.81, -2.721, -2.631, -2.542, -2.453, -2.364, -2.274, -2.185, -2.096, -2.007, -1.917, -1.828, -1.739, -1.65, -1.561, -1.471, -1.382, -1.293, -1.204, -1.114, -1.025, -0.936, -0.847, -0.758, -0.668, -0.579, -0.49, -0.401, -0.311, -0.222, -0.133, -0.044, 0.046, 0.135, 0.224, 0.313, 0.402, 0.492, 0.581, 0.67, 0.759, 0.849, 0.938, 1.027, 1.116, 1.205, 1.295, 1.384, 1.473, 1.562, 1.652, 1.741, 1.83, 1.919, 2.008, 2.098, 2.187, 2.276, 2.365, 2.455, 2.544, 2.633, 2.722, 2.812, 2.901, 2.99, 3.079, 3.168, 3.258, 3.347, 3.436, 3.525, 3.615, 3.704, 3.793, 3.882, 3.971, 4.061, 4.15, 4.239, 4.328, 4.418, 4.507, 4.596, 4.685, 4.775, 4.864, 4.953, 5.042, 5.131, 5.221, 5.31, 5.399, 5.488, 5.578, 5.667, 5.756, 5.845, 5.934, 6.024, 6.113, 6.202, 6.291, 6.381, 6.47, 6.559, 6.648, 6.737, 6.827, 6.916, 7.005, 7.094, 7.184, 7.273, 7.362, 7.451, 7.541, 7.63, 7.719, 7.808, 7.897, 7.987, 8.076, 8.165, 8.254, 8.344, 8.433, 8.522, 8.611, 8.7, 8.79, 8.879, 8.968, 9.057, 9.147, 9.236, 9.325, 9.414, 9.504, 9.593, 9.682, 9.771, 9.86, 9.95, 10.039, 10.128, 10.217, 10.307, 10.396, 10.485, 10.574, 10.663, 10.753, 10.842, 10.931, 11.02, 11.11, 11.199, 11.288, 11.377, 11.466, 11.556, 11.645, 11.734, 11.823, 11.913, 12.002, 12.091, 12.18, 12.27, 12.359, 12.448, 12.537, 12.626, 12.716, 12.805, 12.894, 12.983, 13.073, 13.162, 13.251, 13.34, 13.429, 13.519, 13.608, 13.697, 13.786, 13.876, 13.965, 14.054, 14.143, 14.233, 14.322, 14.411, 14.5, 14.589, 14.679, 14.768, 14.857, 14.946, 15.036, 15.125, 15.214, 15.303, 15.392, 15.482, 15.571, 15.66, 15.749, 15.839, 15.928, 16.017, 16.106, 16.195, 16.285, 16.374, 16.463, 16.552, 16.642, 16.731, 16.82, 16.909, 16.999, 17.088, 17.177, 17.266, 17.355, 17.445, 17.534, 17.623, 17.712, 17.802, 17.891, 17.98, 18.069, 18.158, 18.248, 18.337, 18.426, 18.515, 18.605, 18.694, 18.783, 18.872, 18.962, 19.051, 19.14, 19.229, 19.318, 19.408, 19.497, 19.586, 19.675, 19.765, 19.854, 19.943, 20.032, 20.121, 20.211, 20.3, 20.389, 20.478, 20.568, 20.657, 20.746, 20.835, 20.924, 21.014, 21.103, 21.192, 21.281, 21.371, 21.46, 21.549, 21.638, 21.728, 21.817, 21.906, 21.995, 22.084, 22.174, 22.263, 22.352, 22.441, 22.531, 22.62, 22.709, 22.798, 22.887, 22.977, 23.066, 23.155, 23.15515042, -3.613, -3.524, -3.434, -3.345, -3.256, -3.167, -3.077, -2.988, -2.899, -2.81, -2.721, -2.631, -2.542, -2.453, -2.364, -2.274, -2.185, -2.096, -2.007, -1.917, -1.828, -1.739, -1.65, -1.561, -1.471, -1.382, -1.293, -1.204, -1.114, -1.025, -0.936, -0.847, -0.758, -0.668, -0.579, -0.49, -0.401, -0.311, -0.222, -0.133, -0.044, 0.046, 0.135, 0.224, 0.313, 0.402, 0.492, 0.581, 0.67, 0.759, 0.849, 0.938, 1.027, 1.116, 1.205, 1.295, 1.384, 1.473, 1.562, 1.652, 1.741, 1.83, 1.919, 2.008, 2.098, 2.187, 2.276, 2.365, 2.455, 2.544, 2.633, 2.722, 2.812, 2.901, 2.99, 3.079, 3.168, 3.258, 3.347, 3.436, 3.525, 3.615, 3.704, 3.793, 3.882, 3.971, 4.061, 4.15, 4.239, 4.328, 4.418, 4.507, 4.596, 4.685, 4.775, 4.864, 4.953, 5.042, 5.131, 5.221, 5.31, 5.399, 5.488, 5.578, 5.667, 5.756, 5.845, 5.934, 6.024, 6.113, 6.202, 6.291, 6.381, 6.47, 6.559, 6.648, 6.737, 6.827, 6.916, 7.005, 7.094, 7.184, 7.273, 7.362, 7.451, 7.541, 7.63, 7.719, 7.808, 7.897, 7.987, 8.076, 8.165, 8.254, 8.344, 8.433, 8.522, 8.611, 8.7, 8.79, 8.879, 8.968, 9.057, 9.147, 9.236, 9.325, 9.414, 9.504, 9.593, 9.682, 9.771, 9.86, 9.95, 10.039, 10.128, 10.217, 10.307, 10.396, 10.485, 10.574, 10.663, 10.753, 10.842, 10.931, 11.02, 11.11, 11.199, 11.288, 11.377, 11.466, 11.556, 11.645, 11.734, 11.823, 11.913, 12.002, 12.091, 12.18, 12.27, 12.359, 12.448, 12.537, 12.626, 12.716, 12.805, 12.894, 12.983, 13.073, 13.162, 13.251, 13.34, 13.429, 13.519, 13.608, 13.697, 13.786, 13.876, 13.965, 14.054, 14.143, 14.233, 14.322, 14.411, 14.5, 14.589, 14.679, 14.768, 14.857, 14.946, 15.036, 15.125, 15.214, 15.303, 15.392, 15.482, 15.571, 15.66, 15.749, 15.839, 15.928, 16.017, 16.106, 16.195, 16.285, 16.374, 16.463, 16.552, 16.642, 16.731, 16.82, 16.909, 16.999, 17.088, 17.177, 17.266, 17.355, 17.445, 17.534, 17.623, 17.712, 17.802, 17.891, 17.98, 18.069, 18.158, 18.248, 18.337, 18.426, 18.515, 18.605, 18.694, 18.783, 18.872, 18.962, 19.051, 19.14, 19.229, 19.318, 19.408, 19.497, 19.586, 19.675, 19.765, 19.854, 19.943, 20.032, 20.121, 20.211, 20.3, 20.389, 20.478, 20.568, 20.657, 20.746, 20.835, 20.924, 21.014, 21.103, 21.192, 21.281, 21.371, 21.46, 21.549, 21.638, 21.728, 21.817, 21.906, 21.995, 22.084, 22.174, 22.263, 22.352, 22.441, 22.531, 22.62, 22.709, 22.798, 22.887, 22.977, 23.066, 23.155], [-3.729, -3.641, -3.554, -3.466, -3.378, -3.291, -3.203, -3.116, -3.028, -2.94, -2.853, -2.765, -2.678, -2.59, -2.502, -2.415, -2.327, -2.24, -2.152, -2.064, -1.977, -1.889, -1.802, -1.714, -1.626, -1.539, -1.451, -1.364, -1.276, -1.189, -1.101, -1.013, -0.926, -0.838, -0.751, -0.663, -0.575, -0.488, -0.4, -0.313, -0.225, -0.137, -0.05, 0.038, 0.125, 0.213, 0.301, 0.388, 0.476, 0.563, 0.651, 0.739, 0.826, 0.914, 1.001, 1.089, 1.177, 1.264, 1.352, 1.439, 1.527, 1.615, 1.702, 1.79, 1.877, 1.965, 2.053, 2.14, 2.228, 2.315, 2.403, 2.491, 2.578, 2.666, 2.753, 2.841, 2.928, 3.016, 3.104, 3.191, 3.279, 3.366, 3.454, 3.542, 3.629, 3.717, 3.804, 3.892, 3.98, 4.067, 4.155, 4.242, 4.33, 4.418, 4.505, 4.593, 4.68, 4.768, 4.856, 4.943, 5.031, 5.118, 5.206, 5.294, 5.381, 5.469, 5.556, 5.644, 5.732, 5.819, 5.907, 5.994, 6.082, 6.17, 6.257, 6.345, 6.432, 6.52, 6.607, 6.695, 6.783, 6.87, 6.958, 7.045, 7.133, 7.221, 7.308, 7.396, 7.483, 7.571, 7.659, 7.746, 7.834, 7.921, 8.009, 8.097, 8.184, 8.272, 8.359, 8.447, 8.535, 8.622, 8.71, 8.797, 8.885, 8.973, 9.06, 9.148, 9.235, 9.323, 9.411, 9.498, 9.586, 9.673, 9.761, 9.849, 9.936, 10.024, 10.111, 10.199, 10.286, 10.374, 10.462, 10.549, 10.637, 10.724, 10.812, 10.9, 10.987, 11.075, 11.162, 11.25, 11.338, 11.425, 11.513, 11.6, 11.688, 11.776, 11.863, 11.951, 12.038, 12.126, 12.214, 12.301, 12.389, 12.476, 12.564, 12.652, 12.739, 12.827, 12.914, 13.002, 13.09, 13.177, 13.265, 13.352, 13.44, 13.528, 13.615, 13.703, 13.79, 13.878, 13.966, 14.053, 14.141, 14.228, 14.316, 14.403, 14.491, 14.579, 14.666, 14.754, 14.841, 14.929, 15.017, 15.104, 15.192, 15.279, 15.367, 15.455, 15.542, 15.63, 15.717, 15.805, 15.893, 15.98, 16.068, 16.155, 16.243, 16.331, 16.418, 16.506, 16.593, 16.681, 16.769, 16.856, 16.944, 17.031, 17.119, 17.207, 17.294, 17.382, 17.469, 17.557, 17.645, 17.732, 17.82, 17.907, 17.995, 18.082, 18.17, 18.258, 18.345, 18.433, 18.52, 18.608, 18.696, 18.783, 18.871, 18.958, 19.046, 19.134, 19.221, 19.309, 19.396, 19.484, 19.572, 19.659, 19.747, 19.834, 19.922, 20.01, 20.097, 20.185, 20.272, 20.36, 20.448, 20.535, 20.623, 20.71, 20.798, 20.886, 20.973, 21.061, 21.148, 21.236, 21.324, 21.411, 21.499, 21.586, 21.674, 21.762, 21.849, 21.937, 22.024, 22.112, 22.199, 22.287, 22.375, 22.462, 22.55, 22.54986277, -3.729, -3.641, -3.554, -3.466, -3.378, -3.291, -3.203, -3.116, -3.028, -2.94, -2.853, -2.765, -2.678, -2.59, -2.502, -2.415, -2.327, -2.24, -2.152, -2.064, -1.977, -1.889, -1.802, -1.714, -1.626, -1.539, -1.451, -1.364, -1.276, -1.189, -1.101, -1.013, -0.926, -0.838, -0.751, -0.663, -0.575, -0.488, -0.4, -0.313, -0.225, -0.137, -0.05, 0.038, 0.125, 0.213, 0.301, 0.388, 0.476, 0.563, 0.651, 0.739, 0.826, 0.914, 1.001, 1.089, 1.177, 1.264, 1.352, 1.439, 1.527, 1.615, 1.702, 1.79, 1.877, 1.965, 2.053, 2.14, 2.228, 2.315, 2.403, 2.491, 2.578, 2.666, 2.753, 2.841, 2.928, 3.016, 3.104, 3.191, 3.279, 3.366, 3.454, 3.542, 3.629, 3.717, 3.804, 3.892, 3.98, 4.067, 4.155, 4.242, 4.33, 4.418, 4.505, 4.593, 4.68, 4.768, 4.856, 4.943, 5.031, 5.118, 5.206, 5.294, 5.381, 5.469, 5.556, 5.644, 5.732, 5.819, 5.907, 5.994, 6.082, 6.17, 6.257, 6.345, 6.432, 6.52, 6.607, 6.695, 6.783, 6.87, 6.958, 7.045, 7.133, 7.221, 7.308, 7.396, 7.483, 7.571, 7.659, 7.746, 7.834, 7.921, 8.009, 8.097, 8.184, 8.272, 8.359, 8.447, 8.535, 8.622, 8.71, 8.797, 8.885, 8.973, 9.06, 9.148, 9.235, 9.323, 9.411, 9.498, 9.586, 9.673, 9.761, 9.849, 9.936, 10.024, 10.111, 10.199, 10.286, 10.374, 10.462, 10.549, 10.637, 10.724, 10.812, 10.9, 10.987, 11.075, 11.162, 11.25, 11.338, 11.425, 11.513, 11.6, 11.688, 11.776, 11.863, 11.951, 12.038, 12.126, 12.214, 12.301, 12.389, 12.476, 12.564, 12.652, 12.739, 12.827, 12.914, 13.002, 13.09, 13.177, 13.265, 13.352, 13.44, 13.528, 13.615, 13.703, 13.79, 13.878, 13.966, 14.053, 14.141, 14.228, 14.316, 14.403, 14.491, 14.579, 14.666, 14.754, 14.841, 14.929, 15.017, 15.104, 15.192, 15.279, 15.367, 15.455, 15.542, 15.63, 15.717, 15.805, 15.893, 15.98, 16.068, 16.155, 16.243, 16.331, 16.418, 16.506, 16.593, 16.681, 16.769, 16.856, 16.944, 17.031, 17.119, 17.207, 17.294, 17.382, 17.469, 17.557, 17.645, 17.732, 17.82, 17.907, 17.995, 18.082, 18.17, 18.258, 18.345, 18.433, 18.52, 18.608, 18.696, 18.783, 18.871, 18.958, 19.046, 19.134, 19.221, 19.309, 19.396, 19.484, 19.572, 19.659, 19.747, 19.834, 19.922, 20.01, 20.097, 20.185, 20.272, 20.36, 20.448, 20.535, 20.623, 20.71, 20.798, 20.886, 20.973, 21.061, 21.148, 21.236, 21.324, 21.411, 21.499, 21.586, 21.674, 21.762, 21.849, 21.937, 22.024, 22.112, 22.199, 22.287, 22.375, 22.462, 22.55, 22.54986277, -3.729, -3.641, -3.554, -3.466, -3.378, -3.291, -3.203, -3.116, -3.028, -2.94, -2.853, -2.765, -2.678, -2.59, -2.502, -2.415, -2.327, -2.24, -2.152, -2.064, -1.977, -1.889, -1.802, -1.714, -1.626, -1.539, -1.451, -1.364, -1.276, -1.189, -1.101, -1.013, -0.926, -0.838, -0.751, -0.663, -0.575, -0.488, -0.4, -0.313, -0.225, -0.137, -0.05, 0.038, 0.125, 0.213, 0.301, 0.388, 0.476, 0.563, 0.651, 0.739, 0.826, 0.914, 1.001, 1.089, 1.177, 1.264, 1.352, 1.439, 1.527, 1.615, 1.702, 1.79, 1.877, 1.965, 2.053, 2.14, 2.228, 2.315, 2.403, 2.491, 2.578, 2.666, 2.753, 2.841, 2.928, 3.016, 3.104, 3.191, 3.279, 3.366, 3.454, 3.542, 3.629, 3.717, 3.804, 3.892, 3.98, 4.067, 4.155, 4.242, 4.33, 4.418, 4.505, 4.593, 4.68, 4.768, 4.856, 4.943, 5.031, 5.118, 5.206, 5.294, 5.381, 5.469, 5.556, 5.644, 5.732, 5.819, 5.907, 5.994, 6.082, 6.17, 6.257, 6.345, 6.432, 6.52, 6.607, 6.695, 6.783, 6.87, 6.958, 7.045, 7.133, 7.221, 7.308, 7.396, 7.483, 7.571, 7.659, 7.746, 7.834, 7.921, 8.009, 8.097, 8.184, 8.272, 8.359, 8.447, 8.535, 8.622, 8.71, 8.797, 8.885, 8.973, 9.06, 9.148, 9.235, 9.323, 9.411, 9.498, 9.586, 9.673, 9.761, 9.849, 9.936, 10.024, 10.111, 10.199, 10.286, 10.374, 10.462, 10.549, 10.637, 10.724, 10.812, 10.9, 10.987, 11.075, 11.162, 11.25, 11.338, 11.425, 11.513, 11.6, 11.688, 11.776, 11.863, 11.951, 12.038, 12.126, 12.214, 12.301, 12.389, 12.476, 12.564, 12.652, 12.739, 12.827, 12.914, 13.002, 13.09, 13.177, 13.265, 13.352, 13.44, 13.528, 13.615, 13.703, 13.79, 13.878, 13.966, 14.053, 14.141, 14.228, 14.316, 14.403, 14.491, 14.579, 14.666, 14.754, 14.841, 14.929, 15.017, 15.104, 15.192, 15.279, 15.367, 15.455, 15.542, 15.63, 15.717, 15.805, 15.893, 15.98, 16.068, 16.155, 16.243, 16.331, 16.418, 16.506, 16.593, 16.681, 16.769, 16.856, 16.944, 17.031, 17.119, 17.207, 17.294, 17.382, 17.469, 17.557, 17.645, 17.732, 17.82, 17.907, 17.995, 18.082, 18.17, 18.258, 18.345, 18.433, 18.52, 18.608, 18.696, 18.783, 18.871, 18.958, 19.046, 19.134, 19.221, 19.309, 19.396, 19.484, 19.572, 19.659, 19.747, 19.834, 19.922, 20.01, 20.097, 20.185, 20.272, 20.36, 20.448, 20.535, 20.623, 20.71, 20.798, 20.886, 20.973, 21.061, 21.148, 21.236, 21.324, 21.411, 21.499, 21.586, 21.674, 21.762, 21.849, 21.937, 22.024, 22.112, 22.199, 22.287, 22.375, 22.462, 22.55, 22.54986277, -3.729, -3.641, -3.554, -3.466, -3.378, -3.291, -3.203, -3.116, -3.028, -2.94, -2.853, -2.765, -2.678, -2.59, -2.502, -2.415, -2.327, -2.24, -2.152, -2.064, -1.977, -1.889, -1.802, -1.714, -1.626, -1.539, -1.451, -1.364, -1.276, -1.189, -1.101, -1.013, -0.926, -0.838, -0.751, -0.663, -0.575, -0.488, -0.4, -0.313, -0.225, -0.137, -0.05, 0.038, 0.125, 0.213, 0.301, 0.388, 0.476, 0.563, 0.651, 0.739, 0.826, 0.914, 1.001, 1.089, 1.177, 1.264, 1.352, 1.439, 1.527, 1.615, 1.702, 1.79, 1.877, 1.965, 2.053, 2.14, 2.228, 2.315, 2.403, 2.491, 2.578, 2.666, 2.753, 2.841, 2.928, 3.016, 3.104, 3.191, 3.279, 3.366, 3.454, 3.542, 3.629, 3.717, 3.804, 3.892, 3.98, 4.067, 4.155, 4.242, 4.33, 4.418, 4.505, 4.593, 4.68, 4.768, 4.856, 4.943, 5.031, 5.118, 5.206, 5.294, 5.381, 5.469, 5.556, 5.644, 5.732, 5.819, 5.907, 5.994, 6.082, 6.17, 6.257, 6.345, 6.432, 6.52, 6.607, 6.695, 6.783, 6.87, 6.958, 7.045, 7.133, 7.221, 7.308, 7.396, 7.483, 7.571, 7.659, 7.746, 7.834, 7.921, 8.009, 8.097, 8.184, 8.272, 8.359, 8.447, 8.535, 8.622, 8.71, 8.797, 8.885, 8.973, 9.06, 9.148, 9.235, 9.323, 9.411, 9.498, 9.586, 9.673, 9.761, 9.849, 9.936, 10.024, 10.111, 10.199, 10.286, 10.374, 10.462, 10.549, 10.637, 10.724, 10.812, 10.9, 10.987, 11.075, 11.162, 11.25, 11.338, 11.425, 11.513, 11.6, 11.688, 11.776, 11.863, 11.951, 12.038, 12.126, 12.214, 12.301, 12.389, 12.476, 12.564, 12.652, 12.739, 12.827, 12.914, 13.002, 13.09, 13.177, 13.265, 13.352, 13.44, 13.528, 13.615, 13.703, 13.79, 13.878, 13.966, 14.053, 14.141, 14.228, 14.316, 14.403, 14.491, 14.579, 14.666, 14.754, 14.841, 14.929, 15.017, 15.104, 15.192, 15.279, 15.367, 15.455, 15.542, 15.63, 15.717, 15.805, 15.893, 15.98, 16.068, 16.155, 16.243, 16.331, 16.418, 16.506, 16.593, 16.681, 16.769, 16.856, 16.944, 17.031, 17.119, 17.207, 17.294, 17.382, 17.469, 17.557, 17.645, 17.732, 17.82, 17.907, 17.995, 18.082, 18.17, 18.258, 18.345, 18.433, 18.52, 18.608, 18.696, 18.783, 18.871, 18.958, 19.046, 19.134, 19.221, 19.309, 19.396, 19.484, 19.572, 19.659, 19.747, 19.834, 19.922, 20.01, 20.097, 20.185, 20.272, 20.36, 20.448, 20.535, 20.623, 20.71, 20.798, 20.886, 20.973, 21.061, 21.148, 21.236, 21.324, 21.411, 21.499, 21.586, 21.674, 21.762, 21.849, 21.937, 22.024, 22.112, 22.199, 22.287, 22.375, 22.462, 22.55, 22.54986277, -3.729, -3.641, -3.554, -3.466, -3.378, -3.291, -3.203, -3.116, -3.028, -2.94, -2.853, -2.765, -2.678, -2.59, -2.502, -2.415, -2.327, -2.24, -2.152, -2.064, -1.977, -1.889, -1.802, -1.714, -1.626, -1.539, -1.451, -1.364, -1.276, -1.189, -1.101, -1.013, -0.926, -0.838, -0.751, -0.663, -0.575, -0.488, -0.4, -0.313, -0.225, -0.137, -0.05, 0.038, 0.125, 0.213, 0.301, 0.388, 0.476, 0.563, 0.651, 0.739, 0.826, 0.914, 1.001, 1.089, 1.177, 1.264, 1.352, 1.439, 1.527, 1.615, 1.702, 1.79, 1.877, 1.965, 2.053, 2.14, 2.228, 2.315, 2.403, 2.491, 2.578, 2.666, 2.753, 2.841, 2.928, 3.016, 3.104, 3.191, 3.279, 3.366, 3.454, 3.542, 3.629, 3.717, 3.804, 3.892, 3.98, 4.067, 4.155, 4.242, 4.33, 4.418, 4.505, 4.593, 4.68, 4.768, 4.856, 4.943, 5.031, 5.118, 5.206, 5.294, 5.381, 5.469, 5.556, 5.644, 5.732, 5.819, 5.907, 5.994, 6.082, 6.17, 6.257, 6.345, 6.432, 6.52, 6.607, 6.695, 6.783, 6.87, 6.958, 7.045, 7.133, 7.221, 7.308, 7.396, 7.483, 7.571, 7.659, 7.746, 7.834, 7.921, 8.009, 8.097, 8.184, 8.272, 8.359, 8.447, 8.535, 8.622, 8.71, 8.797, 8.885, 8.973, 9.06, 9.148, 9.235, 9.323, 9.411, 9.498, 9.586, 9.673, 9.761, 9.849, 9.936, 10.024, 10.111, 10.199, 10.286, 10.374, 10.462, 10.549, 10.637, 10.724, 10.812, 10.9, 10.987, 11.075, 11.162, 11.25, 11.338, 11.425, 11.513, 11.6, 11.688, 11.776, 11.863, 11.951, 12.038, 12.126, 12.214, 12.301, 12.389, 12.476, 12.564, 12.652, 12.739, 12.827, 12.914, 13.002, 13.09, 13.177, 13.265, 13.352, 13.44, 13.528, 13.615, 13.703, 13.79, 13.878, 13.966, 14.053, 14.141, 14.228, 14.316, 14.403, 14.491, 14.579, 14.666, 14.754, 14.841, 14.929, 15.017, 15.104, 15.192, 15.279, 15.367, 15.455, 15.542, 15.63, 15.717, 15.805, 15.893, 15.98, 16.068, 16.155, 16.243, 16.331, 16.418, 16.506, 16.593, 16.681, 16.769, 16.856, 16.944, 17.031, 17.119, 17.207, 17.294, 17.382, 17.469, 17.557, 17.645, 17.732, 17.82, 17.907, 17.995, 18.082, 18.17, 18.258, 18.345, 18.433, 18.52, 18.608, 18.696, 18.783, 18.871, 18.958, 19.046, 19.134, 19.221, 19.309, 19.396, 19.484, 19.572, 19.659, 19.747, 19.834, 19.922, 20.01, 20.097, 20.185, 20.272, 20.36, 20.448, 20.535, 20.623, 20.71, 20.798, 20.886, 20.973, 21.061, 21.148, 21.236, 21.324, 21.411, 21.499, 21.586, 21.674, 21.762, 21.849, 21.937, 22.024, 22.112, 22.199, 22.287, 22.375, 22.462, 22.55], [-3.838, -3.752, -3.666, -3.58, -3.494, -3.408, -3.322, -3.236, -3.15, -3.064, -2.978, -2.892, -2.806, -2.721, -2.635, -2.549, -2.463, -2.377, -2.291, -2.205, -2.119, -2.033, -1.947, -1.861, -1.775, -1.689, -1.603, -1.517, -1.431, -1.345, -1.259, -1.173, -1.087, -1.001, -0.915, -0.829, -0.743, -0.657, -0.571, -0.485, -0.399, -0.313, -0.227, -0.141, -0.055, 0.031, 0.117, 0.203, 0.289, 0.375, 0.461, 0.547, 0.633, 0.719, 0.805, 0.891, 0.977, 1.063, 1.149, 1.235, 1.321, 1.407, 1.493, 1.579, 1.665, 1.751, 1.837, 1.922, 2.008, 2.094, 2.18, 2.266, 2.352, 2.438, 2.524, 2.61, 2.696, 2.782, 2.868, 2.954, 3.04, 3.126, 3.212, 3.298, 3.384, 3.47, 3.556, 3.642, 3.728, 3.814, 3.9, 3.986, 4.072, 4.158, 4.244, 4.33, 4.416, 4.502, 4.588, 4.674, 4.76, 4.846, 4.932, 5.018, 5.104, 5.19, 5.276, 5.362, 5.448, 5.534, 5.62, 5.706, 5.792, 5.878, 5.964, 6.05, 6.136, 6.222, 6.308, 6.394, 6.48, 6.565, 6.651, 6.737, 6.823, 6.909, 6.995, 7.081, 7.167, 7.253, 7.339, 7.425, 7.511, 7.597, 7.683, 7.769, 7.855, 7.941, 8.027, 8.113, 8.199, 8.285, 8.371, 8.457, 8.543, 8.629, 8.715, 8.801, 8.887, 8.973, 9.059, 9.145, 9.231, 9.317, 9.403, 9.489, 9.575, 9.661, 9.747, 9.833, 9.919, 10.005, 10.091, 10.177, 10.263, 10.349, 10.435, 10.521, 10.607, 10.693, 10.779, 10.865, 10.951, 11.037, 11.123, 11.208, 11.294, 11.38, 11.466, 11.552, 11.638, 11.724, 11.81, 11.896, 11.982, 12.068, 12.154, 12.24, 12.326, 12.412, 12.498, 12.584, 12.67, 12.756, 12.842, 12.928, 13.014, 13.1, 13.186, 13.272, 13.358, 13.444, 13.53, 13.616, 13.702, 13.788, 13.874, 13.96, 14.046, 14.132, 14.218, 14.304, 14.39, 14.476, 14.562, 14.648, 14.734, 14.82, 14.906, 14.992, 15.078, 15.164, 15.25, 15.336, 15.422, 15.508, 15.594, 15.68, 15.766, 15.851, 15.937, 16.023, 16.109, 16.195, 16.281, 16.367, 16.453, 16.539, 16.625, 16.711, 16.797, 16.883, 16.969, 17.055, 17.141, 17.227, 17.313, 17.399, 17.485, 17.571, 17.657, 17.743, 17.829, 17.915, 18.001, 18.087, 18.173, 18.259, 18.345, 18.431, 18.517, 18.603, 18.689, 18.775, 18.861, 18.947, 19.033, 19.119, 19.205, 19.291, 19.377, 19.463, 19.549, 19.635, 19.721, 19.807, 19.893, 19.979, 20.065, 20.151, 20.237, 20.323, 20.409, 20.494, 20.58, 20.666, 20.752, 20.838, 20.924, 21.01, 21.096, 21.182, 21.268, 21.354, 21.44, 21.526, 21.612, 21.698, 21.784, 21.87, 21.956, 21.95618438, -3.838, -3.752, -3.666, -3.58, -3.494, -3.408, -3.322, -3.236, -3.15, -3.064, -2.978, -2.892, -2.806, -2.721, -2.635, -2.549, -2.463, -2.377, -2.291, -2.205, -2.119, -2.033, -1.947, -1.861, -1.775, -1.689, -1.603, -1.517, -1.431, -1.345, -1.259, -1.173, -1.087, -1.001, -0.915, -0.829, -0.743, -0.657, -0.571, -0.485, -0.399, -0.313, -0.227, -0.141, -0.055, 0.031, 0.117, 0.203, 0.289, 0.375, 0.461, 0.547, 0.633, 0.719, 0.805, 0.891, 0.977, 1.063, 1.149, 1.235, 1.321, 1.407, 1.493, 1.579, 1.665, 1.751, 1.837, 1.922, 2.008, 2.094, 2.18, 2.266, 2.352, 2.438, 2.524, 2.61, 2.696, 2.782, 2.868, 2.954, 3.04, 3.126, 3.212, 3.298, 3.384, 3.47, 3.556, 3.642, 3.728, 3.814, 3.9, 3.986, 4.072, 4.158, 4.244, 4.33, 4.416, 4.502, 4.588, 4.674, 4.76, 4.846, 4.932, 5.018, 5.104, 5.19, 5.276, 5.362, 5.448, 5.534, 5.62, 5.706, 5.792, 5.878, 5.964, 6.05, 6.136, 6.222, 6.308, 6.394, 6.48, 6.565, 6.651, 6.737, 6.823, 6.909, 6.995, 7.081, 7.167, 7.253, 7.339, 7.425, 7.511, 7.597, 7.683, 7.769, 7.855, 7.941, 8.027, 8.113, 8.199, 8.285, 8.371, 8.457, 8.543, 8.629, 8.715, 8.801, 8.887, 8.973, 9.059, 9.145, 9.231, 9.317, 9.403, 9.489, 9.575, 9.661, 9.747, 9.833, 9.919, 10.005, 10.091, 10.177, 10.263, 10.349, 10.435, 10.521, 10.607, 10.693, 10.779, 10.865, 10.951, 11.037, 11.123, 11.208, 11.294, 11.38, 11.466, 11.552, 11.638, 11.724, 11.81, 11.896, 11.982, 12.068, 12.154, 12.24, 12.326, 12.412, 12.498, 12.584, 12.67, 12.756, 12.842, 12.928, 13.014, 13.1, 13.186, 13.272, 13.358, 13.444, 13.53, 13.616, 13.702, 13.788, 13.874, 13.96, 14.046, 14.132, 14.218, 14.304, 14.39, 14.476, 14.562, 14.648, 14.734, 14.82, 14.906, 14.992, 15.078, 15.164, 15.25, 15.336, 15.422, 15.508, 15.594, 15.68, 15.766, 15.851, 15.937, 16.023, 16.109, 16.195, 16.281, 16.367, 16.453, 16.539, 16.625, 16.711, 16.797, 16.883, 16.969, 17.055, 17.141, 17.227, 17.313, 17.399, 17.485, 17.571, 17.657, 17.743, 17.829, 17.915, 18.001, 18.087, 18.173, 18.259, 18.345, 18.431, 18.517, 18.603, 18.689, 18.775, 18.861, 18.947, 19.033, 19.119, 19.205, 19.291, 19.377, 19.463, 19.549, 19.635, 19.721, 19.807, 19.893, 19.979, 20.065, 20.151, 20.237, 20.323, 20.409, 20.494, 20.58, 20.666, 20.752, 20.838, 20.924, 21.01, 21.096, 21.182, 21.268, 21.354, 21.44, 21.526, 21.612, 21.698, 21.784, 21.87, 21.956, 21.95618438, -3.838, -3.752, -3.666, -3.58, -3.494, -3.408, -3.322, -3.236, -3.15, -3.064, -2.978, -2.892, -2.806, -2.721, -2.635, -2.549, -2.463, -2.377, -2.291, -2.205, -2.119, -2.033, -1.947, -1.861, -1.775, -1.689, -1.603, -1.517, -1.431, -1.345, -1.259, -1.173, -1.087, -1.001, -0.915, -0.829, -0.743, -0.657, -0.571, -0.485, -0.399, -0.313, -0.227, -0.141, -0.055, 0.031, 0.117, 0.203, 0.289, 0.375, 0.461, 0.547, 0.633, 0.719, 0.805, 0.891, 0.977, 1.063, 1.149, 1.235, 1.321, 1.407, 1.493, 1.579, 1.665, 1.751, 1.837, 1.922, 2.008, 2.094, 2.18, 2.266, 2.352, 2.438, 2.524, 2.61, 2.696, 2.782, 2.868, 2.954, 3.04, 3.126, 3.212, 3.298, 3.384, 3.47, 3.556, 3.642, 3.728, 3.814, 3.9, 3.986, 4.072, 4.158, 4.244, 4.33, 4.416, 4.502, 4.588, 4.674, 4.76, 4.846, 4.932, 5.018, 5.104, 5.19, 5.276, 5.362, 5.448, 5.534, 5.62, 5.706, 5.792, 5.878, 5.964, 6.05, 6.136, 6.222, 6.308, 6.394, 6.48, 6.565, 6.651, 6.737, 6.823, 6.909, 6.995, 7.081, 7.167, 7.253, 7.339, 7.425, 7.511, 7.597, 7.683, 7.769, 7.855, 7.941, 8.027, 8.113, 8.199, 8.285, 8.371, 8.457, 8.543, 8.629, 8.715, 8.801, 8.887, 8.973, 9.059, 9.145, 9.231, 9.317, 9.403, 9.489, 9.575, 9.661, 9.747, 9.833, 9.919, 10.005, 10.091, 10.177, 10.263, 10.349, 10.435, 10.521, 10.607, 10.693, 10.779, 10.865, 10.951, 11.037, 11.123, 11.208, 11.294, 11.38, 11.466, 11.552, 11.638, 11.724, 11.81, 11.896, 11.982, 12.068, 12.154, 12.24, 12.326, 12.412, 12.498, 12.584, 12.67, 12.756, 12.842, 12.928, 13.014, 13.1, 13.186, 13.272, 13.358, 13.444, 13.53, 13.616, 13.702, 13.788, 13.874, 13.96, 14.046, 14.132, 14.218, 14.304, 14.39, 14.476, 14.562, 14.648, 14.734, 14.82, 14.906, 14.992, 15.078, 15.164, 15.25, 15.336, 15.422, 15.508, 15.594, 15.68, 15.766, 15.851, 15.937, 16.023, 16.109, 16.195, 16.281, 16.367, 16.453, 16.539, 16.625, 16.711, 16.797, 16.883, 16.969, 17.055, 17.141, 17.227, 17.313, 17.399, 17.485, 17.571, 17.657, 17.743, 17.829, 17.915, 18.001, 18.087, 18.173, 18.259, 18.345, 18.431, 18.517, 18.603, 18.689, 18.775, 18.861, 18.947, 19.033, 19.119, 19.205, 19.291, 19.377, 19.463, 19.549, 19.635, 19.721, 19.807, 19.893, 19.979, 20.065, 20.151, 20.237, 20.323, 20.409, 20.494, 20.58, 20.666, 20.752, 20.838, 20.924, 21.01, 21.096, 21.182, 21.268, 21.354, 21.44, 21.526, 21.612, 21.698, 21.784, 21.87, 21.956, 21.95618438, -3.838, -3.752, -3.666, -3.58, -3.494, -3.408, -3.322, -3.236, -3.15, -3.064, -2.978, -2.892, -2.806, -2.721, -2.635, -2.549, -2.463, -2.377, -2.291, -2.205, -2.119, -2.033, -1.947, -1.861, -1.775, -1.689, -1.603, -1.517, -1.431, -1.345, -1.259, -1.173, -1.087, -1.001, -0.915, -0.829, -0.743, -0.657, -0.571, -0.485, -0.399, -0.313, -0.227, -0.141, -0.055, 0.031, 0.117, 0.203, 0.289, 0.375, 0.461, 0.547, 0.633, 0.719, 0.805, 0.891, 0.977, 1.063, 1.149, 1.235, 1.321, 1.407, 1.493, 1.579, 1.665, 1.751, 1.837, 1.922, 2.008, 2.094, 2.18, 2.266, 2.352, 2.438, 2.524, 2.61, 2.696, 2.782, 2.868, 2.954, 3.04, 3.126, 3.212, 3.298, 3.384, 3.47, 3.556, 3.642, 3.728, 3.814, 3.9, 3.986, 4.072, 4.158, 4.244, 4.33, 4.416, 4.502, 4.588, 4.674, 4.76, 4.846, 4.932, 5.018, 5.104, 5.19, 5.276, 5.362, 5.448, 5.534, 5.62, 5.706, 5.792, 5.878, 5.964, 6.05, 6.136, 6.222, 6.308, 6.394, 6.48, 6.565, 6.651, 6.737, 6.823, 6.909, 6.995, 7.081, 7.167, 7.253, 7.339, 7.425, 7.511, 7.597, 7.683, 7.769, 7.855, 7.941, 8.027, 8.113, 8.199, 8.285, 8.371, 8.457, 8.543, 8.629, 8.715, 8.801, 8.887, 8.973, 9.059, 9.145, 9.231, 9.317, 9.403, 9.489, 9.575, 9.661, 9.747, 9.833, 9.919, 10.005, 10.091, 10.177, 10.263, 10.349, 10.435, 10.521, 10.607, 10.693, 10.779, 10.865, 10.951, 11.037, 11.123, 11.208, 11.294, 11.38, 11.466, 11.552, 11.638, 11.724, 11.81, 11.896, 11.982, 12.068, 12.154, 12.24, 12.326, 12.412, 12.498, 12.584, 12.67, 12.756, 12.842, 12.928, 13.014, 13.1, 13.186, 13.272, 13.358, 13.444, 13.53, 13.616, 13.702, 13.788, 13.874, 13.96, 14.046, 14.132, 14.218, 14.304, 14.39, 14.476, 14.562, 14.648, 14.734, 14.82, 14.906, 14.992, 15.078, 15.164, 15.25, 15.336, 15.422, 15.508, 15.594, 15.68, 15.766, 15.851, 15.937, 16.023, 16.109, 16.195, 16.281, 16.367, 16.453, 16.539, 16.625, 16.711, 16.797, 16.883, 16.969, 17.055, 17.141, 17.227, 17.313, 17.399, 17.485, 17.571, 17.657, 17.743, 17.829, 17.915, 18.001, 18.087, 18.173, 18.259, 18.345, 18.431, 18.517, 18.603, 18.689, 18.775, 18.861, 18.947, 19.033, 19.119, 19.205, 19.291, 19.377, 19.463, 19.549, 19.635, 19.721, 19.807, 19.893, 19.979, 20.065, 20.151, 20.237, 20.323, 20.409, 20.494, 20.58, 20.666, 20.752, 20.838, 20.924, 21.01, 21.096, 21.182, 21.268, 21.354, 21.44, 21.526, 21.612, 21.698, 21.784, 21.87, 21.956, 21.95618438, -3.838, -3.752, -3.666, -3.58, -3.494, -3.408, -3.322, -3.236, -3.15, -3.064, -2.978, -2.892, -2.806, -2.721, -2.635, -2.549, -2.463, -2.377, -2.291, -2.205, -2.119, -2.033, -1.947, -1.861, -1.775, -1.689, -1.603, -1.517, -1.431, -1.345, -1.259, -1.173, -1.087, -1.001, -0.915, -0.829, -0.743, -0.657, -0.571, -0.485, -0.399, -0.313, -0.227, -0.141, -0.055, 0.031, 0.117, 0.203, 0.289, 0.375, 0.461, 0.547, 0.633, 0.719, 0.805, 0.891, 0.977, 1.063, 1.149, 1.235, 1.321, 1.407, 1.493, 1.579, 1.665, 1.751, 1.837, 1.922, 2.008, 2.094, 2.18, 2.266, 2.352, 2.438, 2.524, 2.61, 2.696, 2.782, 2.868, 2.954, 3.04, 3.126, 3.212, 3.298, 3.384, 3.47, 3.556, 3.642, 3.728, 3.814, 3.9, 3.986, 4.072, 4.158, 4.244, 4.33, 4.416, 4.502, 4.588, 4.674, 4.76, 4.846, 4.932, 5.018, 5.104, 5.19, 5.276, 5.362, 5.448, 5.534, 5.62, 5.706, 5.792, 5.878, 5.964, 6.05, 6.136, 6.222, 6.308, 6.394, 6.48, 6.565, 6.651, 6.737, 6.823, 6.909, 6.995, 7.081, 7.167, 7.253, 7.339, 7.425, 7.511, 7.597, 7.683, 7.769, 7.855, 7.941, 8.027, 8.113, 8.199, 8.285, 8.371, 8.457, 8.543, 8.629, 8.715, 8.801, 8.887, 8.973, 9.059, 9.145, 9.231, 9.317, 9.403, 9.489, 9.575, 9.661, 9.747, 9.833, 9.919, 10.005, 10.091, 10.177, 10.263, 10.349, 10.435, 10.521, 10.607, 10.693, 10.779, 10.865, 10.951, 11.037, 11.123, 11.208, 11.294, 11.38, 11.466, 11.552, 11.638, 11.724, 11.81, 11.896, 11.982, 12.068, 12.154, 12.24, 12.326, 12.412, 12.498, 12.584, 12.67, 12.756, 12.842, 12.928, 13.014, 13.1, 13.186, 13.272, 13.358, 13.444, 13.53, 13.616, 13.702, 13.788, 13.874, 13.96, 14.046, 14.132, 14.218, 14.304, 14.39, 14.476, 14.562, 14.648, 14.734, 14.82, 14.906, 14.992, 15.078, 15.164, 15.25, 15.336, 15.422, 15.508, 15.594, 15.68, 15.766, 15.851, 15.937, 16.023, 16.109, 16.195, 16.281, 16.367, 16.453, 16.539, 16.625, 16.711, 16.797, 16.883, 16.969, 17.055, 17.141, 17.227, 17.313, 17.399, 17.485, 17.571, 17.657, 17.743, 17.829, 17.915, 18.001, 18.087, 18.173, 18.259, 18.345, 18.431, 18.517, 18.603, 18.689, 18.775, 18.861, 18.947, 19.033, 19.119, 19.205, 19.291, 19.377, 19.463, 19.549, 19.635, 19.721, 19.807, 19.893, 19.979, 20.065, 20.151, 20.237, 20.323, 20.409, 20.494, 20.58, 20.666, 20.752, 20.838, 20.924, 21.01, 21.096, 21.182, 21.268, 21.354, 21.44, 21.526, 21.612, 21.698, 21.784, 21.87, 21.956], [-3.942, -3.857, -3.773, -3.688, -3.604, -3.52, -3.435, -3.351, -3.267, -3.182, -3.098, -3.013, -2.929, -2.845, -2.76, -2.676, -2.592, -2.507, -2.423, -2.338, -2.254, -2.17, -2.085, -2.001, -1.917, -1.832, -1.748, -1.663, -1.579, -1.495, -1.41, -1.326, -1.241, -1.157, -1.073, -0.988, -0.904, -0.82, -0.735, -0.651, -0.566, -0.482, -0.398, -0.313, -0.229, -0.145, -0.06, 0.024, 0.109, 0.193, 0.277, 0.362, 0.446, 0.53, 0.615, 0.699, 0.784, 0.868, 0.952, 1.037, 1.121, 1.206, 1.29, 1.374, 1.459, 1.543, 1.627, 1.712, 1.796, 1.881, 1.965, 2.049, 2.134, 2.218, 2.302, 2.387, 2.471, 2.556, 2.64, 2.724, 2.809, 2.893, 2.977, 3.062, 3.146, 3.231, 3.315, 3.399, 3.484, 3.568, 3.653, 3.737, 3.821, 3.906, 3.99, 4.074, 4.159, 4.243, 4.328, 4.412, 4.496, 4.581, 4.665, 4.749, 4.834, 4.918, 5.003, 5.087, 5.171, 5.256, 5.34, 5.424, 5.509, 5.593, 5.678, 5.762, 5.846, 5.931, 6.015, 6.1, 6.184, 6.268, 6.353, 6.437, 6.521, 6.606, 6.69, 6.775, 6.859, 6.943, 7.028, 7.112, 7.196, 7.281, 7.365, 7.45, 7.534, 7.618, 7.703, 7.787, 7.872, 7.956, 8.04, 8.125, 8.209, 8.293, 8.378, 8.462, 8.547, 8.631, 8.715, 8.8, 8.884, 8.968, 9.053, 9.137, 9.222, 9.306, 9.39, 9.475, 9.559, 9.643, 9.728, 9.812, 9.897, 9.981, 10.065, 10.15, 10.234, 10.319, 10.403, 10.487, 10.572, 10.656, 10.74, 10.825, 10.909, 10.994, 11.078, 11.162, 11.247, 11.331, 11.415, 11.5, 11.584, 11.669, 11.753, 11.837, 11.922, 12.006, 12.09, 12.175, 12.259, 12.344, 12.428, 12.512, 12.597, 12.681, 12.766, 12.85, 12.934, 13.019, 13.103, 13.187, 13.272, 13.356, 13.441, 13.525, 13.609, 13.694, 13.778, 13.862, 13.947, 14.031, 14.116, 14.2, 14.284, 14.369, 14.453, 14.537, 14.622, 14.706, 14.791, 14.875, 14.959, 15.044, 15.128, 15.213, 15.297, 15.381, 15.466, 15.55, 15.634, 15.719, 15.803, 15.888, 15.972, 16.056, 16.141, 16.225, 16.309, 16.394, 16.478, 16.563, 16.647, 16.731, 16.816, 16.9, 16.984, 17.069, 17.153, 17.238, 17.322, 17.406, 17.491, 17.575, 17.66, 17.744, 17.828, 17.913, 17.997, 18.081, 18.166, 18.25, 18.335, 18.419, 18.503, 18.588, 18.672, 18.756, 18.841, 18.925, 19.01, 19.094, 19.178, 19.263, 19.347, 19.431, 19.516, 19.6, 19.685, 19.769, 19.853, 19.938, 20.022, 20.107, 20.191, 20.275, 20.36, 20.444, 20.528, 20.613, 20.697, 20.782, 20.866, 20.95, 21.035, 21.119, 21.203, 21.288, 21.372, 21.37222051, -3.942, -3.857, -3.773, -3.688, -3.604, -3.52, -3.435, -3.351, -3.267, -3.182, -3.098, -3.013, -2.929, -2.845, -2.76, -2.676, -2.592, -2.507, -2.423, -2.338, -2.254, -2.17, -2.085, -2.001, -1.917, -1.832, -1.748, -1.663, -1.579, -1.495, -1.41, -1.326, -1.241, -1.157, -1.073, -0.988, -0.904, -0.82, -0.735, -0.651, -0.566, -0.482, -0.398, -0.313, -0.229, -0.145, -0.06, 0.024, 0.109, 0.193, 0.277, 0.362, 0.446, 0.53, 0.615, 0.699, 0.784, 0.868, 0.952, 1.037, 1.121, 1.206, 1.29, 1.374, 1.459, 1.543, 1.627, 1.712, 1.796, 1.881, 1.965, 2.049, 2.134, 2.218, 2.302, 2.387, 2.471, 2.556, 2.64, 2.724, 2.809, 2.893, 2.977, 3.062, 3.146, 3.231, 3.315, 3.399, 3.484, 3.568, 3.653, 3.737, 3.821, 3.906, 3.99, 4.074, 4.159, 4.243, 4.328, 4.412, 4.496, 4.581, 4.665, 4.749, 4.834, 4.918, 5.003, 5.087, 5.171, 5.256, 5.34, 5.424, 5.509, 5.593, 5.678, 5.762, 5.846, 5.931, 6.015, 6.1, 6.184, 6.268, 6.353, 6.437, 6.521, 6.606, 6.69, 6.775, 6.859, 6.943, 7.028, 7.112, 7.196, 7.281, 7.365, 7.45, 7.534, 7.618, 7.703, 7.787, 7.872, 7.956, 8.04, 8.125, 8.209, 8.293, 8.378, 8.462, 8.547, 8.631, 8.715, 8.8, 8.884, 8.968, 9.053, 9.137, 9.222, 9.306, 9.39, 9.475, 9.559, 9.643, 9.728, 9.812, 9.897, 9.981, 10.065, 10.15, 10.234, 10.319, 10.403, 10.487, 10.572, 10.656, 10.74, 10.825, 10.909, 10.994, 11.078, 11.162, 11.247, 11.331, 11.415, 11.5, 11.584, 11.669, 11.753, 11.837, 11.922, 12.006, 12.09, 12.175, 12.259, 12.344, 12.428, 12.512, 12.597, 12.681, 12.766, 12.85, 12.934, 13.019, 13.103, 13.187, 13.272, 13.356, 13.441, 13.525, 13.609, 13.694, 13.778, 13.862, 13.947, 14.031, 14.116, 14.2, 14.284, 14.369, 14.453, 14.537, 14.622, 14.706, 14.791, 14.875, 14.959, 15.044, 15.128, 15.213, 15.297, 15.381, 15.466, 15.55, 15.634, 15.719, 15.803, 15.888, 15.972, 16.056, 16.141, 16.225, 16.309, 16.394, 16.478, 16.563, 16.647, 16.731, 16.816, 16.9, 16.984, 17.069, 17.153, 17.238, 17.322, 17.406, 17.491, 17.575, 17.66, 17.744, 17.828, 17.913, 17.997, 18.081, 18.166, 18.25, 18.335, 18.419, 18.503, 18.588, 18.672, 18.756, 18.841, 18.925, 19.01, 19.094, 19.178, 19.263, 19.347, 19.431, 19.516, 19.6, 19.685, 19.769, 19.853, 19.938, 20.022, 20.107, 20.191, 20.275, 20.36, 20.444, 20.528, 20.613, 20.697, 20.782, 20.866, 20.95, 21.035, 21.119, 21.203, 21.288, 21.372, 21.37222051, -3.942, -3.857, -3.773, -3.688, -3.604, -3.52, -3.435, -3.351, -3.267, -3.182, -3.098, -3.013, -2.929, -2.845, -2.76, -2.676, -2.592, -2.507, -2.423, -2.338, -2.254, -2.17, -2.085, -2.001, -1.917, -1.832, -1.748, -1.663, -1.579, -1.495, -1.41, -1.326, -1.241, -1.157, -1.073, -0.988, -0.904, -0.82, -0.735, -0.651, -0.566, -0.482, -0.398, -0.313, -0.229, -0.145, -0.06, 0.024, 0.109, 0.193, 0.277, 0.362, 0.446, 0.53, 0.615, 0.699, 0.784, 0.868, 0.952, 1.037, 1.121, 1.206, 1.29, 1.374, 1.459, 1.543, 1.627, 1.712, 1.796, 1.881, 1.965, 2.049, 2.134, 2.218, 2.302, 2.387, 2.471, 2.556, 2.64, 2.724, 2.809, 2.893, 2.977, 3.062, 3.146, 3.231, 3.315, 3.399, 3.484, 3.568, 3.653, 3.737, 3.821, 3.906, 3.99, 4.074, 4.159, 4.243, 4.328, 4.412, 4.496, 4.581, 4.665, 4.749, 4.834, 4.918, 5.003, 5.087, 5.171, 5.256, 5.34, 5.424, 5.509, 5.593, 5.678, 5.762, 5.846, 5.931, 6.015, 6.1, 6.184, 6.268, 6.353, 6.437, 6.521, 6.606, 6.69, 6.775, 6.859, 6.943, 7.028, 7.112, 7.196, 7.281, 7.365, 7.45, 7.534, 7.618, 7.703, 7.787, 7.872, 7.956, 8.04, 8.125, 8.209, 8.293, 8.378, 8.462, 8.547, 8.631, 8.715, 8.8, 8.884, 8.968, 9.053, 9.137, 9.222, 9.306, 9.39, 9.475, 9.559, 9.643, 9.728, 9.812, 9.897, 9.981, 10.065, 10.15, 10.234, 10.319, 10.403, 10.487, 10.572, 10.656, 10.74, 10.825, 10.909, 10.994, 11.078, 11.162, 11.247, 11.331, 11.415, 11.5, 11.584, 11.669, 11.753, 11.837, 11.922, 12.006, 12.09, 12.175, 12.259, 12.344, 12.428, 12.512, 12.597, 12.681, 12.766, 12.85, 12.934, 13.019, 13.103, 13.187, 13.272, 13.356, 13.441, 13.525, 13.609, 13.694, 13.778, 13.862, 13.947, 14.031, 14.116, 14.2, 14.284, 14.369, 14.453, 14.537, 14.622, 14.706, 14.791, 14.875, 14.959, 15.044, 15.128, 15.213, 15.297, 15.381, 15.466, 15.55, 15.634, 15.719, 15.803, 15.888, 15.972, 16.056, 16.141, 16.225, 16.309, 16.394, 16.478, 16.563, 16.647, 16.731, 16.816, 16.9, 16.984, 17.069, 17.153, 17.238, 17.322, 17.406, 17.491, 17.575, 17.66, 17.744, 17.828, 17.913, 17.997, 18.081, 18.166, 18.25, 18.335, 18.419, 18.503, 18.588, 18.672, 18.756, 18.841, 18.925, 19.01, 19.094, 19.178, 19.263, 19.347, 19.431, 19.516, 19.6, 19.685, 19.769, 19.853, 19.938, 20.022, 20.107, 20.191, 20.275, 20.36, 20.444, 20.528, 20.613, 20.697, 20.782, 20.866, 20.95, 21.035, 21.119, 21.203, 21.288, 21.372, 21.37222051, -3.942, -3.857, -3.773, -3.688, -3.604, -3.52, -3.435, -3.351, -3.267, -3.182, -3.098, -3.013, -2.929, -2.845, -2.76, -2.676, -2.592, -2.507, -2.423, -2.338, -2.254, -2.17, -2.085, -2.001, -1.917, -1.832, -1.748, -1.663, -1.579, -1.495, -1.41, -1.326, -1.241, -1.157, -1.073, -0.988, -0.904, -0.82, -0.735, -0.651, -0.566, -0.482, -0.398, -0.313, -0.229, -0.145, -0.06, 0.024, 0.109, 0.193, 0.277, 0.362, 0.446, 0.53, 0.615, 0.699, 0.784, 0.868, 0.952, 1.037, 1.121, 1.206, 1.29, 1.374, 1.459, 1.543, 1.627, 1.712, 1.796, 1.881, 1.965, 2.049, 2.134, 2.218, 2.302, 2.387, 2.471, 2.556, 2.64, 2.724, 2.809, 2.893, 2.977, 3.062, 3.146, 3.231, 3.315, 3.399, 3.484, 3.568, 3.653, 3.737, 3.821, 3.906, 3.99, 4.074, 4.159, 4.243, 4.328, 4.412, 4.496, 4.581, 4.665, 4.749, 4.834, 4.918, 5.003, 5.087, 5.171, 5.256, 5.34, 5.424, 5.509, 5.593, 5.678, 5.762, 5.846, 5.931, 6.015, 6.1, 6.184, 6.268, 6.353, 6.437, 6.521, 6.606, 6.69, 6.775, 6.859, 6.943, 7.028, 7.112, 7.196, 7.281, 7.365, 7.45, 7.534, 7.618, 7.703, 7.787, 7.872, 7.956, 8.04, 8.125, 8.209, 8.293, 8.378, 8.462, 8.547, 8.631, 8.715, 8.8, 8.884, 8.968, 9.053, 9.137, 9.222, 9.306, 9.39, 9.475, 9.559, 9.643, 9.728, 9.812, 9.897, 9.981, 10.065, 10.15, 10.234, 10.319, 10.403, 10.487, 10.572, 10.656, 10.74, 10.825, 10.909, 10.994, 11.078, 11.162, 11.247, 11.331, 11.415, 11.5, 11.584, 11.669, 11.753, 11.837, 11.922, 12.006, 12.09, 12.175, 12.259, 12.344, 12.428, 12.512, 12.597, 12.681, 12.766, 12.85, 12.934, 13.019, 13.103, 13.187, 13.272, 13.356, 13.441, 13.525, 13.609, 13.694, 13.778, 13.862, 13.947, 14.031, 14.116, 14.2, 14.284, 14.369, 14.453, 14.537, 14.622, 14.706, 14.791, 14.875, 14.959, 15.044, 15.128, 15.213, 15.297, 15.381, 15.466, 15.55, 15.634, 15.719, 15.803, 15.888, 15.972, 16.056, 16.141, 16.225, 16.309, 16.394, 16.478, 16.563, 16.647, 16.731, 16.816, 16.9, 16.984, 17.069, 17.153, 17.238, 17.322, 17.406, 17.491, 17.575, 17.66, 17.744, 17.828, 17.913, 17.997, 18.081, 18.166, 18.25, 18.335, 18.419, 18.503, 18.588, 18.672, 18.756, 18.841, 18.925, 19.01, 19.094, 19.178, 19.263, 19.347, 19.431, 19.516, 19.6, 19.685, 19.769, 19.853, 19.938, 20.022, 20.107, 20.191, 20.275, 20.36, 20.444, 20.528, 20.613, 20.697, 20.782, 20.866, 20.95, 21.035, 21.119, 21.203, 21.288, 21.372, 21.37222051, -3.942, -3.857, -3.773, -3.688, -3.604, -3.52, -3.435, -3.351, -3.267, -3.182, -3.098, -3.013, -2.929, -2.845, -2.76, -2.676, -2.592, -2.507, -2.423, -2.338, -2.254, -2.17, -2.085, -2.001, -1.917, -1.832, -1.748, -1.663, -1.579, -1.495, -1.41, -1.326, -1.241, -1.157, -1.073, -0.988, -0.904, -0.82, -0.735, -0.651, -0.566, -0.482, -0.398, -0.313, -0.229, -0.145, -0.06, 0.024, 0.109, 0.193, 0.277, 0.362, 0.446, 0.53, 0.615, 0.699, 0.784, 0.868, 0.952, 1.037, 1.121, 1.206, 1.29, 1.374, 1.459, 1.543, 1.627, 1.712, 1.796, 1.881, 1.965, 2.049, 2.134, 2.218, 2.302, 2.387, 2.471, 2.556, 2.64, 2.724, 2.809, 2.893, 2.977, 3.062, 3.146, 3.231, 3.315, 3.399, 3.484, 3.568, 3.653, 3.737, 3.821, 3.906, 3.99, 4.074, 4.159, 4.243, 4.328, 4.412, 4.496, 4.581, 4.665, 4.749, 4.834, 4.918, 5.003, 5.087, 5.171, 5.256, 5.34, 5.424, 5.509, 5.593, 5.678, 5.762, 5.846, 5.931, 6.015, 6.1, 6.184, 6.268, 6.353, 6.437, 6.521, 6.606, 6.69, 6.775, 6.859, 6.943, 7.028, 7.112, 7.196, 7.281, 7.365, 7.45, 7.534, 7.618, 7.703, 7.787, 7.872, 7.956, 8.04, 8.125, 8.209, 8.293, 8.378, 8.462, 8.547, 8.631, 8.715, 8.8, 8.884, 8.968, 9.053, 9.137, 9.222, 9.306, 9.39, 9.475, 9.559, 9.643, 9.728, 9.812, 9.897, 9.981, 10.065, 10.15, 10.234, 10.319, 10.403, 10.487, 10.572, 10.656, 10.74, 10.825, 10.909, 10.994, 11.078, 11.162, 11.247, 11.331, 11.415, 11.5, 11.584, 11.669, 11.753, 11.837, 11.922, 12.006, 12.09, 12.175, 12.259, 12.344, 12.428, 12.512, 12.597, 12.681, 12.766, 12.85, 12.934, 13.019, 13.103, 13.187, 13.272, 13.356, 13.441, 13.525, 13.609, 13.694, 13.778, 13.862, 13.947, 14.031, 14.116, 14.2, 14.284, 14.369, 14.453, 14.537, 14.622, 14.706, 14.791, 14.875, 14.959, 15.044, 15.128, 15.213, 15.297, 15.381, 15.466, 15.55, 15.634, 15.719, 15.803, 15.888, 15.972, 16.056, 16.141, 16.225, 16.309, 16.394, 16.478, 16.563, 16.647, 16.731, 16.816, 16.9, 16.984, 17.069, 17.153, 17.238, 17.322, 17.406, 17.491, 17.575, 17.66, 17.744, 17.828, 17.913, 17.997, 18.081, 18.166, 18.25, 18.335, 18.419, 18.503, 18.588, 18.672, 18.756, 18.841, 18.925, 19.01, 19.094, 19.178, 19.263, 19.347, 19.431, 19.516, 19.6, 19.685, 19.769, 19.853, 19.938, 20.022, 20.107, 20.191, 20.275, 20.36, 20.444, 20.528, 20.613, 20.697, 20.782, 20.866, 20.95, 21.035, 21.119, 21.203, 21.288, 21.372], [-4.039, -3.956, -3.873, -3.791, -3.708, -3.625, -3.542, -3.459, -3.377, -3.294, -3.211, -3.128, -3.045, -2.963, -2.88, -2.797, -2.714, -2.632, -2.549, -2.466, -2.383, -2.3, -2.218, -2.135, -2.052, -1.969, -1.886, -1.804, -1.721, -1.638, -1.555, -1.472, -1.39, -1.307, -1.224, -1.141, -1.059, -0.976, -0.893, -0.81, -0.727, -0.645, -0.562, -0.479, -0.396, -0.313, -0.231, -0.148, -0.065, 0.018, 0.101, 0.183, 0.266, 0.349, 0.432, 0.515, 0.597, 0.68, 0.763, 0.846, 0.928, 1.011, 1.094, 1.177, 1.26, 1.342, 1.425, 1.508, 1.591, 1.674, 1.756, 1.839, 1.922, 2.005, 2.088, 2.17, 2.253, 2.336, 2.419, 2.501, 2.584, 2.667, 2.75, 2.833, 2.915, 2.998, 3.081, 3.164, 3.247, 3.329, 3.412, 3.495, 3.578, 3.661, 3.743, 3.826, 3.909, 3.992, 4.074, 4.157, 4.24, 4.323, 4.406, 4.488, 4.571, 4.654, 4.737, 4.82, 4.902, 4.985, 5.068, 5.151, 5.234, 5.316, 5.399, 5.482, 5.565, 5.647, 5.73, 5.813, 5.896, 5.979, 6.061, 6.144, 6.227, 6.31, 6.393, 6.475, 6.558, 6.641, 6.724, 6.807, 6.889, 6.972, 7.055, 7.138, 7.22, 7.303, 7.386, 7.469, 7.552, 7.634, 7.717, 7.8, 7.883, 7.966, 8.048, 8.131, 8.214, 8.297, 8.38, 8.462, 8.545, 8.628, 8.711, 8.793, 8.876, 8.959, 9.042, 9.125, 9.207, 9.29, 9.373, 9.456, 9.539, 9.621, 9.704, 9.787, 9.87, 9.953, 10.035, 10.118, 10.201, 10.284, 10.367, 10.449, 10.532, 10.615, 10.698, 10.78, 10.863, 10.946, 11.029, 11.112, 11.194, 11.277, 11.36, 11.443, 11.526, 11.608, 11.691, 11.774, 11.857, 11.94, 12.022, 12.105, 12.188, 12.271, 12.353, 12.436, 12.519, 12.602, 12.685, 12.767, 12.85, 12.933, 13.016, 13.099, 13.181, 13.264, 13.347, 13.43, 13.513, 13.595, 13.678, 13.761, 13.844, 13.926, 14.009, 14.092, 14.175, 14.258, 14.34, 14.423, 14.506, 14.589, 14.672, 14.754, 14.837, 14.92, 15.003, 15.086, 15.168, 15.251, 15.334, 15.417, 15.499, 15.582, 15.665, 15.748, 15.831, 15.913, 15.996, 16.079, 16.162, 16.245, 16.327, 16.41, 16.493, 16.576, 16.659, 16.741, 16.824, 16.907, 16.99, 17.072, 17.155, 17.238, 17.321, 17.404, 17.486, 17.569, 17.652, 17.735, 17.818, 17.9, 17.983, 18.066, 18.149, 18.232, 18.314, 18.397, 18.48, 18.563, 18.646, 18.728, 18.811, 18.894, 18.977, 19.059, 19.142, 19.225, 19.308, 19.391, 19.473, 19.556, 19.639, 19.722, 19.805, 19.887, 19.97, 20.053, 20.136, 20.219, 20.301, 20.384, 20.467, 20.55, 20.632, 20.715, 20.798, 20.79803832, -4.039, -3.956, -3.873, -3.791, -3.708, -3.625, -3.542, -3.459, -3.377, -3.294, -3.211, -3.128, -3.045, -2.963, -2.88, -2.797, -2.714, -2.632, -2.549, -2.466, -2.383, -2.3, -2.218, -2.135, -2.052, -1.969, -1.886, -1.804, -1.721, -1.638, -1.555, -1.472, -1.39, -1.307, -1.224, -1.141, -1.059, -0.976, -0.893, -0.81, -0.727, -0.645, -0.562, -0.479, -0.396, -0.313, -0.231, -0.148, -0.065, 0.018, 0.101, 0.183, 0.266, 0.349, 0.432, 0.515, 0.597, 0.68, 0.763, 0.846, 0.928, 1.011, 1.094, 1.177, 1.26, 1.342, 1.425, 1.508, 1.591, 1.674, 1.756, 1.839, 1.922, 2.005, 2.088, 2.17, 2.253, 2.336, 2.419, 2.501, 2.584, 2.667, 2.75, 2.833, 2.915, 2.998, 3.081, 3.164, 3.247, 3.329, 3.412, 3.495, 3.578, 3.661, 3.743, 3.826, 3.909, 3.992, 4.074, 4.157, 4.24, 4.323, 4.406, 4.488, 4.571, 4.654, 4.737, 4.82, 4.902, 4.985, 5.068, 5.151, 5.234, 5.316, 5.399, 5.482, 5.565, 5.647, 5.73, 5.813, 5.896, 5.979, 6.061, 6.144, 6.227, 6.31, 6.393, 6.475, 6.558, 6.641, 6.724, 6.807, 6.889, 6.972, 7.055, 7.138, 7.22, 7.303, 7.386, 7.469, 7.552, 7.634, 7.717, 7.8, 7.883, 7.966, 8.048, 8.131, 8.214, 8.297, 8.38, 8.462, 8.545, 8.628, 8.711, 8.793, 8.876, 8.959, 9.042, 9.125, 9.207, 9.29, 9.373, 9.456, 9.539, 9.621, 9.704, 9.787, 9.87, 9.953, 10.035, 10.118, 10.201, 10.284, 10.367, 10.449, 10.532, 10.615, 10.698, 10.78, 10.863, 10.946, 11.029, 11.112, 11.194, 11.277, 11.36, 11.443, 11.526, 11.608, 11.691, 11.774, 11.857, 11.94, 12.022, 12.105, 12.188, 12.271, 12.353, 12.436, 12.519, 12.602, 12.685, 12.767, 12.85, 12.933, 13.016, 13.099, 13.181, 13.264, 13.347, 13.43, 13.513, 13.595, 13.678, 13.761, 13.844, 13.926, 14.009, 14.092, 14.175, 14.258, 14.34, 14.423, 14.506, 14.589, 14.672, 14.754, 14.837, 14.92, 15.003, 15.086, 15.168, 15.251, 15.334, 15.417, 15.499, 15.582, 15.665, 15.748, 15.831, 15.913, 15.996, 16.079, 16.162, 16.245, 16.327, 16.41, 16.493, 16.576, 16.659, 16.741, 16.824, 16.907, 16.99, 17.072, 17.155, 17.238, 17.321, 17.404, 17.486, 17.569, 17.652, 17.735, 17.818, 17.9, 17.983, 18.066, 18.149, 18.232, 18.314, 18.397, 18.48, 18.563, 18.646, 18.728, 18.811, 18.894, 18.977, 19.059, 19.142, 19.225, 19.308, 19.391, 19.473, 19.556, 19.639, 19.722, 19.805, 19.887, 19.97, 20.053, 20.136, 20.219, 20.301, 20.384, 20.467, 20.55, 20.632, 20.715, 20.798, 20.79803832, -4.039, -3.956, -3.873, -3.791, -3.708, -3.625, -3.542, -3.459, -3.377, -3.294, -3.211, -3.128, -3.045, -2.963, -2.88, -2.797, -2.714, -2.632, -2.549, -2.466, -2.383, -2.3, -2.218, -2.135, -2.052, -1.969, -1.886, -1.804, -1.721, -1.638, -1.555, -1.472, -1.39, -1.307, -1.224, -1.141, -1.059, -0.976, -0.893, -0.81, -0.727, -0.645, -0.562, -0.479, -0.396, -0.313, -0.231, -0.148, -0.065, 0.018, 0.101, 0.183, 0.266, 0.349, 0.432, 0.515, 0.597, 0.68, 0.763, 0.846, 0.928, 1.011, 1.094, 1.177, 1.26, 1.342, 1.425, 1.508, 1.591, 1.674, 1.756, 1.839, 1.922, 2.005, 2.088, 2.17, 2.253, 2.336, 2.419, 2.501, 2.584, 2.667, 2.75, 2.833, 2.915, 2.998, 3.081, 3.164, 3.247, 3.329, 3.412, 3.495, 3.578, 3.661, 3.743, 3.826, 3.909, 3.992, 4.074, 4.157, 4.24, 4.323, 4.406, 4.488, 4.571, 4.654, 4.737, 4.82, 4.902, 4.985, 5.068, 5.151, 5.234, 5.316, 5.399, 5.482, 5.565, 5.647, 5.73, 5.813, 5.896, 5.979, 6.061, 6.144, 6.227, 6.31, 6.393, 6.475, 6.558, 6.641, 6.724, 6.807, 6.889, 6.972, 7.055, 7.138, 7.22, 7.303, 7.386, 7.469, 7.552, 7.634, 7.717, 7.8, 7.883, 7.966, 8.048, 8.131, 8.214, 8.297, 8.38, 8.462, 8.545, 8.628, 8.711, 8.793, 8.876, 8.959, 9.042, 9.125, 9.207, 9.29, 9.373, 9.456, 9.539, 9.621, 9.704, 9.787, 9.87, 9.953, 10.035, 10.118, 10.201, 10.284, 10.367, 10.449, 10.532, 10.615, 10.698, 10.78, 10.863, 10.946, 11.029, 11.112, 11.194, 11.277, 11.36, 11.443, 11.526, 11.608, 11.691, 11.774, 11.857, 11.94, 12.022, 12.105, 12.188, 12.271, 12.353, 12.436, 12.519, 12.602, 12.685, 12.767, 12.85, 12.933, 13.016, 13.099, 13.181, 13.264, 13.347, 13.43, 13.513, 13.595, 13.678, 13.761, 13.844, 13.926, 14.009, 14.092, 14.175, 14.258, 14.34, 14.423, 14.506, 14.589, 14.672, 14.754, 14.837, 14.92, 15.003, 15.086, 15.168, 15.251, 15.334, 15.417, 15.499, 15.582, 15.665, 15.748, 15.831, 15.913, 15.996, 16.079, 16.162, 16.245, 16.327, 16.41, 16.493, 16.576, 16.659, 16.741, 16.824, 16.907, 16.99, 17.072, 17.155, 17.238, 17.321, 17.404, 17.486, 17.569, 17.652, 17.735, 17.818, 17.9, 17.983, 18.066, 18.149, 18.232, 18.314, 18.397, 18.48, 18.563, 18.646, 18.728, 18.811, 18.894, 18.977, 19.059, 19.142, 19.225, 19.308, 19.391, 19.473, 19.556, 19.639, 19.722, 19.805, 19.887, 19.97, 20.053, 20.136, 20.219, 20.301, 20.384, 20.467, 20.55, 20.632, 20.715, 20.798, 20.79803832, -4.039, -3.956, -3.873, -3.791, -3.708, -3.625, -3.542, -3.459, -3.377, -3.294, -3.211, -3.128, -3.045, -2.963, -2.88, -2.797, -2.714, -2.632, -2.549, -2.466, -2.383, -2.3, -2.218, -2.135, -2.052, -1.969, -1.886, -1.804, -1.721, -1.638, -1.555, -1.472, -1.39, -1.307, -1.224, -1.141, -1.059, -0.976, -0.893, -0.81, -0.727, -0.645, -0.562, -0.479, -0.396, -0.313, -0.231, -0.148, -0.065, 0.018, 0.101, 0.183, 0.266, 0.349, 0.432, 0.515, 0.597, 0.68, 0.763, 0.846, 0.928, 1.011, 1.094, 1.177, 1.26, 1.342, 1.425, 1.508, 1.591, 1.674, 1.756, 1.839, 1.922, 2.005, 2.088, 2.17, 2.253, 2.336, 2.419, 2.501, 2.584, 2.667, 2.75, 2.833, 2.915, 2.998, 3.081, 3.164, 3.247, 3.329, 3.412, 3.495, 3.578, 3.661, 3.743, 3.826, 3.909, 3.992, 4.074, 4.157, 4.24, 4.323, 4.406, 4.488, 4.571, 4.654, 4.737, 4.82, 4.902, 4.985, 5.068, 5.151, 5.234, 5.316, 5.399, 5.482, 5.565, 5.647, 5.73, 5.813, 5.896, 5.979, 6.061, 6.144, 6.227, 6.31, 6.393, 6.475, 6.558, 6.641, 6.724, 6.807, 6.889, 6.972, 7.055, 7.138, 7.22, 7.303, 7.386, 7.469, 7.552, 7.634, 7.717, 7.8, 7.883, 7.966, 8.048, 8.131, 8.214, 8.297, 8.38, 8.462, 8.545, 8.628, 8.711, 8.793, 8.876, 8.959, 9.042, 9.125, 9.207, 9.29, 9.373, 9.456, 9.539, 9.621, 9.704, 9.787, 9.87, 9.953, 10.035, 10.118, 10.201, 10.284, 10.367, 10.449, 10.532, 10.615, 10.698, 10.78, 10.863, 10.946, 11.029, 11.112, 11.194, 11.277, 11.36, 11.443, 11.526, 11.608, 11.691, 11.774, 11.857, 11.94, 12.022, 12.105, 12.188, 12.271, 12.353, 12.436, 12.519, 12.602, 12.685, 12.767, 12.85, 12.933, 13.016, 13.099, 13.181, 13.264, 13.347, 13.43, 13.513, 13.595, 13.678, 13.761, 13.844, 13.926, 14.009, 14.092, 14.175, 14.258, 14.34, 14.423, 14.506, 14.589, 14.672, 14.754, 14.837, 14.92, 15.003, 15.086, 15.168, 15.251, 15.334, 15.417, 15.499, 15.582, 15.665, 15.748, 15.831, 15.913, 15.996, 16.079, 16.162, 16.245, 16.327, 16.41, 16.493, 16.576, 16.659, 16.741, 16.824, 16.907, 16.99, 17.072, 17.155, 17.238, 17.321, 17.404, 17.486, 17.569, 17.652, 17.735, 17.818, 17.9, 17.983, 18.066, 18.149, 18.232, 18.314, 18.397, 18.48, 18.563, 18.646, 18.728, 18.811, 18.894, 18.977, 19.059, 19.142, 19.225, 19.308, 19.391, 19.473, 19.556, 19.639, 19.722, 19.805, 19.887, 19.97, 20.053, 20.136, 20.219, 20.301, 20.384, 20.467, 20.55, 20.632, 20.715, 20.798, 20.79803832, -4.039, -3.956, -3.873, -3.791, -3.708, -3.625, -3.542, -3.459, -3.377, -3.294, -3.211, -3.128, -3.045, -2.963, -2.88, -2.797, -2.714, -2.632, -2.549, -2.466, -2.383, -2.3, -2.218, -2.135, -2.052, -1.969, -1.886, -1.804, -1.721, -1.638, -1.555, -1.472, -1.39, -1.307, -1.224, -1.141, -1.059, -0.976, -0.893, -0.81, -0.727, -0.645, -0.562, -0.479, -0.396, -0.313, -0.231, -0.148, -0.065, 0.018, 0.101, 0.183, 0.266, 0.349, 0.432, 0.515, 0.597, 0.68, 0.763, 0.846, 0.928, 1.011, 1.094, 1.177, 1.26, 1.342, 1.425, 1.508, 1.591, 1.674, 1.756, 1.839, 1.922, 2.005, 2.088, 2.17, 2.253, 2.336, 2.419, 2.501, 2.584, 2.667, 2.75, 2.833, 2.915, 2.998, 3.081, 3.164, 3.247, 3.329, 3.412, 3.495, 3.578, 3.661, 3.743, 3.826, 3.909, 3.992, 4.074, 4.157, 4.24, 4.323, 4.406, 4.488, 4.571, 4.654, 4.737, 4.82, 4.902, 4.985, 5.068, 5.151, 5.234, 5.316, 5.399, 5.482, 5.565, 5.647, 5.73, 5.813, 5.896, 5.979, 6.061, 6.144, 6.227, 6.31, 6.393, 6.475, 6.558, 6.641, 6.724, 6.807, 6.889, 6.972, 7.055, 7.138, 7.22, 7.303, 7.386, 7.469, 7.552, 7.634, 7.717, 7.8, 7.883, 7.966, 8.048, 8.131, 8.214, 8.297, 8.38, 8.462, 8.545, 8.628, 8.711, 8.793, 8.876, 8.959, 9.042, 9.125, 9.207, 9.29, 9.373, 9.456, 9.539, 9.621, 9.704, 9.787, 9.87, 9.953, 10.035, 10.118, 10.201, 10.284, 10.367, 10.449, 10.532, 10.615, 10.698, 10.78, 10.863, 10.946, 11.029, 11.112, 11.194, 11.277, 11.36, 11.443, 11.526, 11.608, 11.691, 11.774, 11.857, 11.94, 12.022, 12.105, 12.188, 12.271, 12.353, 12.436, 12.519, 12.602, 12.685, 12.767, 12.85, 12.933, 13.016, 13.099, 13.181, 13.264, 13.347, 13.43, 13.513, 13.595, 13.678, 13.761, 13.844, 13.926, 14.009, 14.092, 14.175, 14.258, 14.34, 14.423, 14.506, 14.589, 14.672, 14.754, 14.837, 14.92, 15.003, 15.086, 15.168, 15.251, 15.334, 15.417, 15.499, 15.582, 15.665, 15.748, 15.831, 15.913, 15.996, 16.079, 16.162, 16.245, 16.327, 16.41, 16.493, 16.576, 16.659, 16.741, 16.824, 16.907, 16.99, 17.072, 17.155, 17.238, 17.321, 17.404, 17.486, 17.569, 17.652, 17.735, 17.818, 17.9, 17.983, 18.066, 18.149, 18.232, 18.314, 18.397, 18.48, 18.563, 18.646, 18.728, 18.811, 18.894, 18.977, 19.059, 19.142, 19.225, 19.308, 19.391, 19.473, 19.556, 19.639, 19.722, 19.805, 19.887, 19.97, 20.053, 20.136, 20.219, 20.301, 20.384, 20.467, 20.55, 20.632, 20.715, 20.798], [-4.131, -4.05, -3.968, -3.887, -3.806, -3.725, -3.644, -3.562, -3.481, -3.4, -3.319, -3.237, -3.156, -3.075, -2.994, -2.913, -2.831, -2.75, -2.669, -2.588, -2.507, -2.425, -2.344, -2.263, -2.182, -2.101, -2.019, -1.938, -1.857, -1.776, -1.694, -1.613, -1.532, -1.451, -1.37, -1.288, -1.207, -1.126, -1.045, -0.964, -0.882, -0.801, -0.72, -0.639, -0.557, -0.476, -0.395, -0.314, -0.233, -0.151, -0.07, 0.011, 0.092, 0.173, 0.255, 0.336, 0.417, 0.498, 0.579, 0.661, 0.742, 0.823, 0.904, 0.986, 1.067, 1.148, 1.229, 1.31, 1.392, 1.473, 1.554, 1.635, 1.716, 1.798, 1.879, 1.96, 2.041, 2.122, 2.204, 2.285, 2.366, 2.447, 2.529, 2.61, 2.691, 2.772, 2.853, 2.935, 3.016, 3.097, 3.178, 3.259, 3.341, 3.422, 3.503, 3.584, 3.665, 3.747, 3.828, 3.909, 3.99, 4.072, 4.153, 4.234, 4.315, 4.396, 4.478, 4.559, 4.64, 4.721, 4.802, 4.884, 4.965, 5.046, 5.127, 5.209, 5.29, 5.371, 5.452, 5.533, 5.615, 5.696, 5.777, 5.858, 5.939, 6.021, 6.102, 6.183, 6.264, 6.345, 6.427, 6.508, 6.589, 6.67, 6.752, 6.833, 6.914, 6.995, 7.076, 7.158, 7.239, 7.32, 7.401, 7.482, 7.564, 7.645, 7.726, 7.807, 7.888, 7.97, 8.051, 8.132, 8.213, 8.295, 8.376, 8.457, 8.538, 8.619, 8.701, 8.782, 8.863, 8.944, 9.025, 9.107, 9.188, 9.269, 9.35, 9.431, 9.513, 9.594, 9.675, 9.756, 9.838, 9.919, 10.0, 10.081, 10.162, 10.244, 10.325, 10.406, 10.487, 10.568, 10.65, 10.731, 10.812, 10.893, 10.974, 11.056, 11.137, 11.218, 11.299, 11.381, 11.462, 11.543, 11.624, 11.705, 11.787, 11.868, 11.949, 12.03, 12.111, 12.193, 12.274, 12.355, 12.436, 12.518, 12.599, 12.68, 12.761, 12.842, 12.924, 13.005, 13.086, 13.167, 13.248, 13.33, 13.411, 13.492, 13.573, 13.654, 13.736, 13.817, 13.898, 13.979, 14.061, 14.142, 14.223, 14.304, 14.385, 14.467, 14.548, 14.629, 14.71, 14.791, 14.873, 14.954, 15.035, 15.116, 15.197, 15.279, 15.36, 15.441, 15.522, 15.604, 15.685, 15.766, 15.847, 15.928, 16.01, 16.091, 16.172, 16.253, 16.334, 16.416, 16.497, 16.578, 16.659, 16.74, 16.822, 16.903, 16.984, 17.065, 17.147, 17.228, 17.309, 17.39, 17.471, 17.553, 17.634, 17.715, 17.796, 17.877, 17.959, 18.04, 18.121, 18.202, 18.284, 18.365, 18.446, 18.527, 18.608, 18.69, 18.771, 18.852, 18.933, 19.014, 19.096, 19.177, 19.258, 19.339, 19.42, 19.502, 19.583, 19.664, 19.745, 19.827, 19.908, 19.989, 20.07, 20.151, 20.233, 20.2325738, -4.131, -4.05, -3.968, -3.887, -3.806, -3.725, -3.644, -3.562, -3.481, -3.4, -3.319, -3.237, -3.156, -3.075, -2.994, -2.913, -2.831, -2.75, -2.669, -2.588, -2.507, -2.425, -2.344, -2.263, -2.182, -2.101, -2.019, -1.938, -1.857, -1.776, -1.694, -1.613, -1.532, -1.451, -1.37, -1.288, -1.207, -1.126, -1.045, -0.964, -0.882, -0.801, -0.72, -0.639, -0.557, -0.476, -0.395, -0.314, -0.233, -0.151, -0.07, 0.011, 0.092, 0.173, 0.255, 0.336, 0.417, 0.498, 0.579, 0.661, 0.742, 0.823, 0.904, 0.986, 1.067, 1.148, 1.229, 1.31, 1.392, 1.473, 1.554, 1.635, 1.716, 1.798, 1.879, 1.96, 2.041, 2.122, 2.204, 2.285, 2.366, 2.447, 2.529, 2.61, 2.691, 2.772, 2.853, 2.935, 3.016, 3.097, 3.178, 3.259, 3.341, 3.422, 3.503, 3.584, 3.665, 3.747, 3.828, 3.909, 3.99, 4.072, 4.153, 4.234, 4.315, 4.396, 4.478, 4.559, 4.64, 4.721, 4.802, 4.884, 4.965, 5.046, 5.127, 5.209, 5.29, 5.371, 5.452, 5.533, 5.615, 5.696, 5.777, 5.858, 5.939, 6.021, 6.102, 6.183, 6.264, 6.345, 6.427, 6.508, 6.589, 6.67, 6.752, 6.833, 6.914, 6.995, 7.076, 7.158, 7.239, 7.32, 7.401, 7.482, 7.564, 7.645, 7.726, 7.807, 7.888, 7.97, 8.051, 8.132, 8.213, 8.295, 8.376, 8.457, 8.538, 8.619, 8.701, 8.782, 8.863, 8.944, 9.025, 9.107, 9.188, 9.269, 9.35, 9.431, 9.513, 9.594, 9.675, 9.756, 9.838, 9.919, 10.0, 10.081, 10.162, 10.244, 10.325, 10.406, 10.487, 10.568, 10.65, 10.731, 10.812, 10.893, 10.974, 11.056, 11.137, 11.218, 11.299, 11.381, 11.462, 11.543, 11.624, 11.705, 11.787, 11.868, 11.949, 12.03, 12.111, 12.193, 12.274, 12.355, 12.436, 12.518, 12.599, 12.68, 12.761, 12.842, 12.924, 13.005, 13.086, 13.167, 13.248, 13.33, 13.411, 13.492, 13.573, 13.654, 13.736, 13.817, 13.898, 13.979, 14.061, 14.142, 14.223, 14.304, 14.385, 14.467, 14.548, 14.629, 14.71, 14.791, 14.873, 14.954, 15.035, 15.116, 15.197, 15.279, 15.36, 15.441, 15.522, 15.604, 15.685, 15.766, 15.847, 15.928, 16.01, 16.091, 16.172, 16.253, 16.334, 16.416, 16.497, 16.578, 16.659, 16.74, 16.822, 16.903, 16.984, 17.065, 17.147, 17.228, 17.309, 17.39, 17.471, 17.553, 17.634, 17.715, 17.796, 17.877, 17.959, 18.04, 18.121, 18.202, 18.284, 18.365, 18.446, 18.527, 18.608, 18.69, 18.771, 18.852, 18.933, 19.014, 19.096, 19.177, 19.258, 19.339, 19.42, 19.502, 19.583, 19.664, 19.745, 19.827, 19.908, 19.989, 20.07, 20.151, 20.233, 20.2325738, -4.131, -4.05, -3.968, -3.887, -3.806, -3.725, -3.644, -3.562, -3.481, -3.4, -3.319, -3.237, -3.156, -3.075, -2.994, -2.913, -2.831, -2.75, -2.669, -2.588, -2.507, -2.425, -2.344, -2.263, -2.182, -2.101, -2.019, -1.938, -1.857, -1.776, -1.694, -1.613, -1.532, -1.451, -1.37, -1.288, -1.207, -1.126, -1.045, -0.964, -0.882, -0.801, -0.72, -0.639, -0.557, -0.476, -0.395, -0.314, -0.233, -0.151, -0.07, 0.011, 0.092, 0.173, 0.255, 0.336, 0.417, 0.498, 0.579, 0.661, 0.742, 0.823, 0.904, 0.986, 1.067, 1.148, 1.229, 1.31, 1.392, 1.473, 1.554, 1.635, 1.716, 1.798, 1.879, 1.96, 2.041, 2.122, 2.204, 2.285, 2.366, 2.447, 2.529, 2.61, 2.691, 2.772, 2.853, 2.935, 3.016, 3.097, 3.178, 3.259, 3.341, 3.422, 3.503, 3.584, 3.665, 3.747, 3.828, 3.909, 3.99, 4.072, 4.153, 4.234, 4.315, 4.396, 4.478, 4.559, 4.64, 4.721, 4.802, 4.884, 4.965, 5.046, 5.127, 5.209, 5.29, 5.371, 5.452, 5.533, 5.615, 5.696, 5.777, 5.858, 5.939, 6.021, 6.102, 6.183, 6.264, 6.345, 6.427, 6.508, 6.589, 6.67, 6.752, 6.833, 6.914, 6.995, 7.076, 7.158, 7.239, 7.32, 7.401, 7.482, 7.564, 7.645, 7.726, 7.807, 7.888, 7.97, 8.051, 8.132, 8.213, 8.295, 8.376, 8.457, 8.538, 8.619, 8.701, 8.782, 8.863, 8.944, 9.025, 9.107, 9.188, 9.269, 9.35, 9.431, 9.513, 9.594, 9.675, 9.756, 9.838, 9.919, 10.0, 10.081, 10.162, 10.244, 10.325, 10.406, 10.487, 10.568, 10.65, 10.731, 10.812, 10.893, 10.974, 11.056, 11.137, 11.218, 11.299, 11.381, 11.462, 11.543, 11.624, 11.705, 11.787, 11.868, 11.949, 12.03, 12.111, 12.193, 12.274, 12.355, 12.436, 12.518, 12.599, 12.68, 12.761, 12.842, 12.924, 13.005, 13.086, 13.167, 13.248, 13.33, 13.411, 13.492, 13.573, 13.654, 13.736, 13.817, 13.898, 13.979, 14.061, 14.142, 14.223, 14.304, 14.385, 14.467, 14.548, 14.629, 14.71, 14.791, 14.873, 14.954, 15.035, 15.116, 15.197, 15.279, 15.36, 15.441, 15.522, 15.604, 15.685, 15.766, 15.847, 15.928, 16.01, 16.091, 16.172, 16.253, 16.334, 16.416, 16.497, 16.578, 16.659, 16.74, 16.822, 16.903, 16.984, 17.065, 17.147, 17.228, 17.309, 17.39, 17.471, 17.553, 17.634, 17.715, 17.796, 17.877, 17.959, 18.04, 18.121, 18.202, 18.284, 18.365, 18.446, 18.527, 18.608, 18.69, 18.771, 18.852, 18.933, 19.014, 19.096, 19.177, 19.258, 19.339, 19.42, 19.502, 19.583, 19.664, 19.745, 19.827, 19.908, 19.989, 20.07, 20.151, 20.233, 20.2325738, -4.131, -4.05, -3.968, -3.887, -3.806, -3.725, -3.644, -3.562, -3.481, -3.4, -3.319, -3.237, -3.156, -3.075, -2.994, -2.913, -2.831, -2.75, -2.669, -2.588, -2.507, -2.425, -2.344, -2.263, -2.182, -2.101, -2.019, -1.938, -1.857, -1.776, -1.694, -1.613, -1.532, -1.451, -1.37, -1.288, -1.207, -1.126, -1.045, -0.964, -0.882, -0.801, -0.72, -0.639, -0.557, -0.476, -0.395, -0.314, -0.233, -0.151, -0.07, 0.011, 0.092, 0.173, 0.255, 0.336, 0.417, 0.498, 0.579, 0.661, 0.742, 0.823, 0.904, 0.986, 1.067, 1.148, 1.229, 1.31, 1.392, 1.473, 1.554, 1.635, 1.716, 1.798, 1.879, 1.96, 2.041, 2.122, 2.204, 2.285, 2.366, 2.447, 2.529, 2.61, 2.691, 2.772, 2.853, 2.935, 3.016, 3.097, 3.178, 3.259, 3.341, 3.422, 3.503, 3.584, 3.665, 3.747, 3.828, 3.909, 3.99, 4.072, 4.153, 4.234, 4.315, 4.396, 4.478, 4.559, 4.64, 4.721, 4.802, 4.884, 4.965, 5.046, 5.127, 5.209, 5.29, 5.371, 5.452, 5.533, 5.615, 5.696, 5.777, 5.858, 5.939, 6.021, 6.102, 6.183, 6.264, 6.345, 6.427, 6.508, 6.589, 6.67, 6.752, 6.833, 6.914, 6.995, 7.076, 7.158, 7.239, 7.32, 7.401, 7.482, 7.564, 7.645, 7.726, 7.807, 7.888, 7.97, 8.051, 8.132, 8.213, 8.295, 8.376, 8.457, 8.538, 8.619, 8.701, 8.782, 8.863, 8.944, 9.025, 9.107, 9.188, 9.269, 9.35, 9.431, 9.513, 9.594, 9.675, 9.756, 9.838, 9.919, 10.0, 10.081, 10.162, 10.244, 10.325, 10.406, 10.487, 10.568, 10.65, 10.731, 10.812, 10.893, 10.974, 11.056, 11.137, 11.218, 11.299, 11.381, 11.462, 11.543, 11.624, 11.705, 11.787, 11.868, 11.949, 12.03, 12.111, 12.193, 12.274, 12.355, 12.436, 12.518, 12.599, 12.68, 12.761, 12.842, 12.924, 13.005, 13.086, 13.167, 13.248, 13.33, 13.411, 13.492, 13.573, 13.654, 13.736, 13.817, 13.898, 13.979, 14.061, 14.142, 14.223, 14.304, 14.385, 14.467, 14.548, 14.629, 14.71, 14.791, 14.873, 14.954, 15.035, 15.116, 15.197, 15.279, 15.36, 15.441, 15.522, 15.604, 15.685, 15.766, 15.847, 15.928, 16.01, 16.091, 16.172, 16.253, 16.334, 16.416, 16.497, 16.578, 16.659, 16.74, 16.822, 16.903, 16.984, 17.065, 17.147, 17.228, 17.309, 17.39, 17.471, 17.553, 17.634, 17.715, 17.796, 17.877, 17.959, 18.04, 18.121, 18.202, 18.284, 18.365, 18.446, 18.527, 18.608, 18.69, 18.771, 18.852, 18.933, 19.014, 19.096, 19.177, 19.258, 19.339, 19.42, 19.502, 19.583, 19.664, 19.745, 19.827, 19.908, 19.989, 20.07, 20.151, 20.233, 20.2325738, -4.131, -4.05, -3.968, -3.887, -3.806, -3.725, -3.644, -3.562, -3.481, -3.4, -3.319, -3.237, -3.156, -3.075, -2.994, -2.913, -2.831, -2.75, -2.669, -2.588, -2.507, -2.425, -2.344, -2.263, -2.182, -2.101, -2.019, -1.938, -1.857, -1.776, -1.694, -1.613, -1.532, -1.451, -1.37, -1.288, -1.207, -1.126, -1.045, -0.964, -0.882, -0.801, -0.72, -0.639, -0.557, -0.476, -0.395, -0.314, -0.233, -0.151, -0.07, 0.011, 0.092, 0.173, 0.255, 0.336, 0.417, 0.498, 0.579, 0.661, 0.742, 0.823, 0.904, 0.986, 1.067, 1.148, 1.229, 1.31, 1.392, 1.473, 1.554, 1.635, 1.716, 1.798, 1.879, 1.96, 2.041, 2.122, 2.204, 2.285, 2.366, 2.447, 2.529, 2.61, 2.691, 2.772, 2.853, 2.935, 3.016, 3.097, 3.178, 3.259, 3.341, 3.422, 3.503, 3.584, 3.665, 3.747, 3.828, 3.909, 3.99, 4.072, 4.153, 4.234, 4.315, 4.396, 4.478, 4.559, 4.64, 4.721, 4.802, 4.884, 4.965, 5.046, 5.127, 5.209, 5.29, 5.371, 5.452, 5.533, 5.615, 5.696, 5.777, 5.858, 5.939, 6.021, 6.102, 6.183, 6.264, 6.345, 6.427, 6.508, 6.589, 6.67, 6.752, 6.833, 6.914, 6.995, 7.076, 7.158, 7.239, 7.32, 7.401, 7.482, 7.564, 7.645, 7.726, 7.807, 7.888, 7.97, 8.051, 8.132, 8.213, 8.295, 8.376, 8.457, 8.538, 8.619, 8.701, 8.782, 8.863, 8.944, 9.025, 9.107, 9.188, 9.269, 9.35, 9.431, 9.513, 9.594, 9.675, 9.756, 9.838, 9.919, 10.0, 10.081, 10.162, 10.244, 10.325, 10.406, 10.487, 10.568, 10.65, 10.731, 10.812, 10.893, 10.974, 11.056, 11.137, 11.218, 11.299, 11.381, 11.462, 11.543, 11.624, 11.705, 11.787, 11.868, 11.949, 12.03, 12.111, 12.193, 12.274, 12.355, 12.436, 12.518, 12.599, 12.68, 12.761, 12.842, 12.924, 13.005, 13.086, 13.167, 13.248, 13.33, 13.411, 13.492, 13.573, 13.654, 13.736, 13.817, 13.898, 13.979, 14.061, 14.142, 14.223, 14.304, 14.385, 14.467, 14.548, 14.629, 14.71, 14.791, 14.873, 14.954, 15.035, 15.116, 15.197, 15.279, 15.36, 15.441, 15.522, 15.604, 15.685, 15.766, 15.847, 15.928, 16.01, 16.091, 16.172, 16.253, 16.334, 16.416, 16.497, 16.578, 16.659, 16.74, 16.822, 16.903, 16.984, 17.065, 17.147, 17.228, 17.309, 17.39, 17.471, 17.553, 17.634, 17.715, 17.796, 17.877, 17.959, 18.04, 18.121, 18.202, 18.284, 18.365, 18.446, 18.527, 18.608, 18.69, 18.771, 18.852, 18.933, 19.014, 19.096, 19.177, 19.258, 19.339, 19.42, 19.502, 19.583, 19.664, 19.745, 19.827, 19.908, 19.989, 20.07, 20.151, 20.233], [-4.218, -4.138, -4.058, -3.979, -3.899, -3.819, -3.74, -3.66, -3.58, -3.501, -3.421, -3.342, -3.262, -3.182, -3.103, -3.023, -2.943, -2.864, -2.784, -2.704, -2.625, -2.545, -2.465, -2.386, -2.306, -2.226, -2.147, -2.067, -1.987, -1.908, -1.828, -1.749, -1.669, -1.589, -1.51, -1.43, -1.35, -1.271, -1.191, -1.111, -1.032, -0.952, -0.872, -0.793, -0.713, -0.633, -0.554, -0.474, -0.395, -0.315, -0.235, -0.156, -0.076, 0.004, 0.083, 0.163, 0.243, 0.322, 0.402, 0.482, 0.561, 0.641, 0.721, 0.8, 0.88, 0.959, 1.039, 1.119, 1.198, 1.278, 1.358, 1.437, 1.517, 1.597, 1.676, 1.756, 1.836, 1.915, 1.995, 2.075, 2.154, 2.234, 2.313, 2.393, 2.473, 2.552, 2.632, 2.712, 2.791, 2.871, 2.951, 3.03, 3.11, 3.19, 3.269, 3.349, 3.429, 3.508, 3.588, 3.667, 3.747, 3.827, 3.906, 3.986, 4.066, 4.145, 4.225, 4.305, 4.384, 4.464, 4.544, 4.623, 4.703, 4.783, 4.862, 4.942, 5.021, 5.101, 5.181, 5.26, 5.34, 5.42, 5.499, 5.579, 5.659, 5.738, 5.818, 5.898, 5.977, 6.057, 6.137, 6.216, 6.296, 6.375, 6.455, 6.535, 6.614, 6.694, 6.774, 6.853, 6.933, 7.013, 7.092, 7.172, 7.252, 7.331, 7.411, 7.491, 7.57, 7.65, 7.729, 7.809, 7.889, 7.968, 8.048, 8.128, 8.207, 8.287, 8.367, 8.446, 8.526, 8.606, 8.685, 8.765, 8.845, 8.924, 9.004, 9.083, 9.163, 9.243, 9.322, 9.402, 9.482, 9.561, 9.641, 9.721, 9.8, 9.88, 9.96, 10.039, 10.119, 10.199, 10.278, 10.358, 10.437, 10.517, 10.597, 10.676, 10.756, 10.836, 10.915, 10.995, 11.075, 11.154, 11.234, 11.314, 11.393, 11.473, 11.553, 11.632, 11.712, 11.791, 11.871, 11.951, 12.03, 12.11, 12.19, 12.269, 12.349, 12.429, 12.508, 12.588, 12.668, 12.747, 12.827, 12.907, 12.986, 13.066, 13.145, 13.225, 13.305, 13.384, 13.464, 13.544, 13.623, 13.703, 13.783, 13.862, 13.942, 14.022, 14.101, 14.181, 14.261, 14.34, 14.42, 14.499, 14.579, 14.659, 14.738, 14.818, 14.898, 14.977, 15.057, 15.137, 15.216, 15.296, 15.376, 15.455, 15.535, 15.615, 15.694, 15.774, 15.853, 15.933, 16.013, 16.092, 16.172, 16.252, 16.331, 16.411, 16.491, 16.57, 16.65, 16.73, 16.809, 16.889, 16.969, 17.048, 17.128, 17.207, 17.287, 17.367, 17.446, 17.526, 17.606, 17.685, 17.765, 17.845, 17.924, 18.004, 18.084, 18.163, 18.243, 18.323, 18.402, 18.482, 18.561, 18.641, 18.721, 18.8, 18.88, 18.96, 19.039, 19.119, 19.199, 19.278, 19.358, 19.438, 19.517, 19.597, 19.677, 19.67655714, -4.218, -4.138, -4.058, -3.979, -3.899, -3.819, -3.74, -3.66, -3.58, -3.501, -3.421, -3.342, -3.262, -3.182, -3.103, -3.023, -2.943, -2.864, -2.784, -2.704, -2.625, -2.545, -2.465, -2.386, -2.306, -2.226, -2.147, -2.067, -1.987, -1.908, -1.828, -1.749, -1.669, -1.589, -1.51, -1.43, -1.35, -1.271, -1.191, -1.111, -1.032, -0.952, -0.872, -0.793, -0.713, -0.633, -0.554, -0.474, -0.395, -0.315, -0.235, -0.156, -0.076, 0.004, 0.083, 0.163, 0.243, 0.322, 0.402, 0.482, 0.561, 0.641, 0.721, 0.8, 0.88, 0.959, 1.039, 1.119, 1.198, 1.278, 1.358, 1.437, 1.517, 1.597, 1.676, 1.756, 1.836, 1.915, 1.995, 2.075, 2.154, 2.234, 2.313, 2.393, 2.473, 2.552, 2.632, 2.712, 2.791, 2.871, 2.951, 3.03, 3.11, 3.19, 3.269, 3.349, 3.429, 3.508, 3.588, 3.667, 3.747, 3.827, 3.906, 3.986, 4.066, 4.145, 4.225, 4.305, 4.384, 4.464, 4.544, 4.623, 4.703, 4.783, 4.862, 4.942, 5.021, 5.101, 5.181, 5.26, 5.34, 5.42, 5.499, 5.579, 5.659, 5.738, 5.818, 5.898, 5.977, 6.057, 6.137, 6.216, 6.296, 6.375, 6.455, 6.535, 6.614, 6.694, 6.774, 6.853, 6.933, 7.013, 7.092, 7.172, 7.252, 7.331, 7.411, 7.491, 7.57, 7.65, 7.729, 7.809, 7.889, 7.968, 8.048, 8.128, 8.207, 8.287, 8.367, 8.446, 8.526, 8.606, 8.685, 8.765, 8.845, 8.924, 9.004, 9.083, 9.163, 9.243, 9.322, 9.402, 9.482, 9.561, 9.641, 9.721, 9.8, 9.88, 9.96, 10.039, 10.119, 10.199, 10.278, 10.358, 10.437, 10.517, 10.597, 10.676, 10.756, 10.836, 10.915, 10.995, 11.075, 11.154, 11.234, 11.314, 11.393, 11.473, 11.553, 11.632, 11.712, 11.791, 11.871, 11.951, 12.03, 12.11, 12.19, 12.269, 12.349, 12.429, 12.508, 12.588, 12.668, 12.747, 12.827, 12.907, 12.986, 13.066, 13.145, 13.225, 13.305, 13.384, 13.464, 13.544, 13.623, 13.703, 13.783, 13.862, 13.942, 14.022, 14.101, 14.181, 14.261, 14.34, 14.42, 14.499, 14.579, 14.659, 14.738, 14.818, 14.898, 14.977, 15.057, 15.137, 15.216, 15.296, 15.376, 15.455, 15.535, 15.615, 15.694, 15.774, 15.853, 15.933, 16.013, 16.092, 16.172, 16.252, 16.331, 16.411, 16.491, 16.57, 16.65, 16.73, 16.809, 16.889, 16.969, 17.048, 17.128, 17.207, 17.287, 17.367, 17.446, 17.526, 17.606, 17.685, 17.765, 17.845, 17.924, 18.004, 18.084, 18.163, 18.243, 18.323, 18.402, 18.482, 18.561, 18.641, 18.721, 18.8, 18.88, 18.96, 19.039, 19.119, 19.199, 19.278, 19.358, 19.438, 19.517, 19.597, 19.677, 19.67655714, -4.218, -4.138, -4.058, -3.979, -3.899, -3.819, -3.74, -3.66, -3.58, -3.501, -3.421, -3.342, -3.262, -3.182, -3.103, -3.023, -2.943, -2.864, -2.784, -2.704, -2.625, -2.545, -2.465, -2.386, -2.306, -2.226, -2.147, -2.067, -1.987, -1.908, -1.828, -1.749, -1.669, -1.589, -1.51, -1.43, -1.35, -1.271, -1.191, -1.111, -1.032, -0.952, -0.872, -0.793, -0.713, -0.633, -0.554, -0.474, -0.395, -0.315, -0.235, -0.156, -0.076, 0.004, 0.083, 0.163, 0.243, 0.322, 0.402, 0.482, 0.561, 0.641, 0.721, 0.8, 0.88, 0.959, 1.039, 1.119, 1.198, 1.278, 1.358, 1.437, 1.517, 1.597, 1.676, 1.756, 1.836, 1.915, 1.995, 2.075, 2.154, 2.234, 2.313, 2.393, 2.473, 2.552, 2.632, 2.712, 2.791, 2.871, 2.951, 3.03, 3.11, 3.19, 3.269, 3.349, 3.429, 3.508, 3.588, 3.667, 3.747, 3.827, 3.906, 3.986, 4.066, 4.145, 4.225, 4.305, 4.384, 4.464, 4.544, 4.623, 4.703, 4.783, 4.862, 4.942, 5.021, 5.101, 5.181, 5.26, 5.34, 5.42, 5.499, 5.579, 5.659, 5.738, 5.818, 5.898, 5.977, 6.057, 6.137, 6.216, 6.296, 6.375, 6.455, 6.535, 6.614, 6.694, 6.774, 6.853, 6.933, 7.013, 7.092, 7.172, 7.252, 7.331, 7.411, 7.491, 7.57, 7.65, 7.729, 7.809, 7.889, 7.968, 8.048, 8.128, 8.207, 8.287, 8.367, 8.446, 8.526, 8.606, 8.685, 8.765, 8.845, 8.924, 9.004, 9.083, 9.163, 9.243, 9.322, 9.402, 9.482, 9.561, 9.641, 9.721, 9.8, 9.88, 9.96, 10.039, 10.119, 10.199, 10.278, 10.358, 10.437, 10.517, 10.597, 10.676, 10.756, 10.836, 10.915, 10.995, 11.075, 11.154, 11.234, 11.314, 11.393, 11.473, 11.553, 11.632, 11.712, 11.791, 11.871, 11.951, 12.03, 12.11, 12.19, 12.269, 12.349, 12.429, 12.508, 12.588, 12.668, 12.747, 12.827, 12.907, 12.986, 13.066, 13.145, 13.225, 13.305, 13.384, 13.464, 13.544, 13.623, 13.703, 13.783, 13.862, 13.942, 14.022, 14.101, 14.181, 14.261, 14.34, 14.42, 14.499, 14.579, 14.659, 14.738, 14.818, 14.898, 14.977, 15.057, 15.137, 15.216, 15.296, 15.376, 15.455, 15.535, 15.615, 15.694, 15.774, 15.853, 15.933, 16.013, 16.092, 16.172, 16.252, 16.331, 16.411, 16.491, 16.57, 16.65, 16.73, 16.809, 16.889, 16.969, 17.048, 17.128, 17.207, 17.287, 17.367, 17.446, 17.526, 17.606, 17.685, 17.765, 17.845, 17.924, 18.004, 18.084, 18.163, 18.243, 18.323, 18.402, 18.482, 18.561, 18.641, 18.721, 18.8, 18.88, 18.96, 19.039, 19.119, 19.199, 19.278, 19.358, 19.438, 19.517, 19.597, 19.677, 19.67655714, -4.218, -4.138, -4.058, -3.979, -3.899, -3.819, -3.74, -3.66, -3.58, -3.501, -3.421, -3.342, -3.262, -3.182, -3.103, -3.023, -2.943, -2.864, -2.784, -2.704, -2.625, -2.545, -2.465, -2.386, -2.306, -2.226, -2.147, -2.067, -1.987, -1.908, -1.828, -1.749, -1.669, -1.589, -1.51, -1.43, -1.35, -1.271, -1.191, -1.111, -1.032, -0.952, -0.872, -0.793, -0.713, -0.633, -0.554, -0.474, -0.395, -0.315, -0.235, -0.156, -0.076, 0.004, 0.083, 0.163, 0.243, 0.322, 0.402, 0.482, 0.561, 0.641, 0.721, 0.8, 0.88, 0.959, 1.039, 1.119, 1.198, 1.278, 1.358, 1.437, 1.517, 1.597, 1.676, 1.756, 1.836, 1.915, 1.995, 2.075, 2.154, 2.234, 2.313, 2.393, 2.473, 2.552, 2.632, 2.712, 2.791, 2.871, 2.951, 3.03, 3.11, 3.19, 3.269, 3.349, 3.429, 3.508, 3.588, 3.667, 3.747, 3.827, 3.906, 3.986, 4.066, 4.145, 4.225, 4.305, 4.384, 4.464, 4.544, 4.623, 4.703, 4.783, 4.862, 4.942, 5.021, 5.101, 5.181, 5.26, 5.34, 5.42, 5.499, 5.579, 5.659, 5.738, 5.818, 5.898, 5.977, 6.057, 6.137, 6.216, 6.296, 6.375, 6.455, 6.535, 6.614, 6.694, 6.774, 6.853, 6.933, 7.013, 7.092, 7.172, 7.252, 7.331, 7.411, 7.491, 7.57, 7.65, 7.729, 7.809, 7.889, 7.968, 8.048, 8.128, 8.207, 8.287, 8.367, 8.446, 8.526, 8.606, 8.685, 8.765, 8.845, 8.924, 9.004, 9.083, 9.163, 9.243, 9.322, 9.402, 9.482, 9.561, 9.641, 9.721, 9.8, 9.88, 9.96, 10.039, 10.119, 10.199, 10.278, 10.358, 10.437, 10.517, 10.597, 10.676, 10.756, 10.836, 10.915, 10.995, 11.075, 11.154, 11.234, 11.314, 11.393, 11.473, 11.553, 11.632, 11.712, 11.791, 11.871, 11.951, 12.03, 12.11, 12.19, 12.269, 12.349, 12.429, 12.508, 12.588, 12.668, 12.747, 12.827, 12.907, 12.986, 13.066, 13.145, 13.225, 13.305, 13.384, 13.464, 13.544, 13.623, 13.703, 13.783, 13.862, 13.942, 14.022, 14.101, 14.181, 14.261, 14.34, 14.42, 14.499, 14.579, 14.659, 14.738, 14.818, 14.898, 14.977, 15.057, 15.137, 15.216, 15.296, 15.376, 15.455, 15.535, 15.615, 15.694, 15.774, 15.853, 15.933, 16.013, 16.092, 16.172, 16.252, 16.331, 16.411, 16.491, 16.57, 16.65, 16.73, 16.809, 16.889, 16.969, 17.048, 17.128, 17.207, 17.287, 17.367, 17.446, 17.526, 17.606, 17.685, 17.765, 17.845, 17.924, 18.004, 18.084, 18.163, 18.243, 18.323, 18.402, 18.482, 18.561, 18.641, 18.721, 18.8, 18.88, 18.96, 19.039, 19.119, 19.199, 19.278, 19.358, 19.438, 19.517, 19.597, 19.677, 19.67655714, -4.218, -4.138, -4.058, -3.979, -3.899, -3.819, -3.74, -3.66, -3.58, -3.501, -3.421, -3.342, -3.262, -3.182, -3.103, -3.023, -2.943, -2.864, -2.784, -2.704, -2.625, -2.545, -2.465, -2.386, -2.306, -2.226, -2.147, -2.067, -1.987, -1.908, -1.828, -1.749, -1.669, -1.589, -1.51, -1.43, -1.35, -1.271, -1.191, -1.111, -1.032, -0.952, -0.872, -0.793, -0.713, -0.633, -0.554, -0.474, -0.395, -0.315, -0.235, -0.156, -0.076, 0.004, 0.083, 0.163, 0.243, 0.322, 0.402, 0.482, 0.561, 0.641, 0.721, 0.8, 0.88, 0.959, 1.039, 1.119, 1.198, 1.278, 1.358, 1.437, 1.517, 1.597, 1.676, 1.756, 1.836, 1.915, 1.995, 2.075, 2.154, 2.234, 2.313, 2.393, 2.473, 2.552, 2.632, 2.712, 2.791, 2.871, 2.951, 3.03, 3.11, 3.19, 3.269, 3.349, 3.429, 3.508, 3.588, 3.667, 3.747, 3.827, 3.906, 3.986, 4.066, 4.145, 4.225, 4.305, 4.384, 4.464, 4.544, 4.623, 4.703, 4.783, 4.862, 4.942, 5.021, 5.101, 5.181, 5.26, 5.34, 5.42, 5.499, 5.579, 5.659, 5.738, 5.818, 5.898, 5.977, 6.057, 6.137, 6.216, 6.296, 6.375, 6.455, 6.535, 6.614, 6.694, 6.774, 6.853, 6.933, 7.013, 7.092, 7.172, 7.252, 7.331, 7.411, 7.491, 7.57, 7.65, 7.729, 7.809, 7.889, 7.968, 8.048, 8.128, 8.207, 8.287, 8.367, 8.446, 8.526, 8.606, 8.685, 8.765, 8.845, 8.924, 9.004, 9.083, 9.163, 9.243, 9.322, 9.402, 9.482, 9.561, 9.641, 9.721, 9.8, 9.88, 9.96, 10.039, 10.119, 10.199, 10.278, 10.358, 10.437, 10.517, 10.597, 10.676, 10.756, 10.836, 10.915, 10.995, 11.075, 11.154, 11.234, 11.314, 11.393, 11.473, 11.553, 11.632, 11.712, 11.791, 11.871, 11.951, 12.03, 12.11, 12.19, 12.269, 12.349, 12.429, 12.508, 12.588, 12.668, 12.747, 12.827, 12.907, 12.986, 13.066, 13.145, 13.225, 13.305, 13.384, 13.464, 13.544, 13.623, 13.703, 13.783, 13.862, 13.942, 14.022, 14.101, 14.181, 14.261, 14.34, 14.42, 14.499, 14.579, 14.659, 14.738, 14.818, 14.898, 14.977, 15.057, 15.137, 15.216, 15.296, 15.376, 15.455, 15.535, 15.615, 15.694, 15.774, 15.853, 15.933, 16.013, 16.092, 16.172, 16.252, 16.331, 16.411, 16.491, 16.57, 16.65, 16.73, 16.809, 16.889, 16.969, 17.048, 17.128, 17.207, 17.287, 17.367, 17.446, 17.526, 17.606, 17.685, 17.765, 17.845, 17.924, 18.004, 18.084, 18.163, 18.243, 18.323, 18.402, 18.482, 18.561, 18.641, 18.721, 18.8, 18.88, 18.96, 19.039, 19.119, 19.199, 19.278, 19.358, 19.438, 19.517, 19.597, 19.677], [-4.3, -4.222, -4.144, -4.065, -3.987, -3.909, -3.831, -3.753, -3.675, -3.597, -3.519, -3.441, -3.363, -3.285, -3.206, -3.128, -3.05, -2.972, -2.894, -2.816, -2.738, -2.66, -2.582, -2.504, -2.426, -2.347, -2.269, -2.191, -2.113, -2.035, -1.957, -1.879, -1.801, -1.723, -1.645, -1.567, -1.488, -1.41, -1.332, -1.254, -1.176, -1.098, -1.02, -0.942, -0.864, -0.786, -0.708, -0.629, -0.551, -0.473, -0.395, -0.317, -0.239, -0.161, -0.083, -0.005, 0.073, 0.151, 0.23, 0.308, 0.386, 0.464, 0.542, 0.62, 0.698, 0.776, 0.854, 0.932, 1.01, 1.089, 1.167, 1.245, 1.323, 1.401, 1.479, 1.557, 1.635, 1.713, 1.791, 1.869, 1.948, 2.026, 2.104, 2.182, 2.26, 2.338, 2.416, 2.494, 2.572, 2.65, 2.728, 2.807, 2.885, 2.963, 3.041, 3.119, 3.197, 3.275, 3.353, 3.431, 3.509, 3.588, 3.666, 3.744, 3.822, 3.9, 3.978, 4.056, 4.134, 4.212, 4.29, 4.368, 4.447, 4.525, 4.603, 4.681, 4.759, 4.837, 4.915, 4.993, 5.071, 5.149, 5.227, 5.306, 5.384, 5.462, 5.54, 5.618, 5.696, 5.774, 5.852, 5.93, 6.008, 6.086, 6.165, 6.243, 6.321, 6.399, 6.477, 6.555, 6.633, 6.711, 6.789, 6.867, 6.945, 7.024, 7.102, 7.18, 7.258, 7.336, 7.414, 7.492, 7.57, 7.648, 7.726, 7.804, 7.883, 7.961, 8.039, 8.117, 8.195, 8.273, 8.351, 8.429, 8.507, 8.585, 8.663, 8.742, 8.82, 8.898, 8.976, 9.054, 9.132, 9.21, 9.288, 9.366, 9.444, 9.522, 9.601, 9.679, 9.757, 9.835, 9.913, 9.991, 10.069, 10.147, 10.225, 10.303, 10.381, 10.46, 10.538, 10.616, 10.694, 10.772, 10.85, 10.928, 11.006, 11.084, 11.162, 11.24, 11.319, 11.397, 11.475, 11.553, 11.631, 11.709, 11.787, 11.865, 11.943, 12.021, 12.099, 12.178, 12.256, 12.334, 12.412, 12.49, 12.568, 12.646, 12.724, 12.802, 12.88, 12.958, 13.037, 13.115, 13.193, 13.271, 13.349, 13.427, 13.505, 13.583, 13.661, 13.739, 13.817, 13.896, 13.974, 14.052, 14.13, 14.208, 14.286, 14.364, 14.442, 14.52, 14.598, 14.676, 14.755, 14.833, 14.911, 14.989, 15.067, 15.145, 15.223, 15.301, 15.379, 15.457, 15.535, 15.614, 15.692, 15.77, 15.848, 15.926, 16.004, 16.082, 16.16, 16.238, 16.316, 16.394, 16.473, 16.551, 16.629, 16.707, 16.785, 16.863, 16.941, 17.019, 17.097, 17.175, 17.254, 17.332, 17.41, 17.488, 17.566, 17.644, 17.722, 17.8, 17.878, 17.956, 18.034, 18.113, 18.191, 18.269, 18.347, 18.425, 18.503, 18.581, 18.659, 18.737, 18.815, 18.893, 18.972, 19.05, 19.128, 19.12769785, -4.3, -4.222, -4.144, -4.065, -3.987, -3.909, -3.831, -3.753, -3.675, -3.597, -3.519, -3.441, -3.363, -3.285, -3.206, -3.128, -3.05, -2.972, -2.894, -2.816, -2.738, -2.66, -2.582, -2.504, -2.426, -2.347, -2.269, -2.191, -2.113, -2.035, -1.957, -1.879, -1.801, -1.723, -1.645, -1.567, -1.488, -1.41, -1.332, -1.254, -1.176, -1.098, -1.02, -0.942, -0.864, -0.786, -0.708, -0.629, -0.551, -0.473, -0.395, -0.317, -0.239, -0.161, -0.083, -0.005, 0.073, 0.151, 0.23, 0.308, 0.386, 0.464, 0.542, 0.62, 0.698, 0.776, 0.854, 0.932, 1.01, 1.089, 1.167, 1.245, 1.323, 1.401, 1.479, 1.557, 1.635, 1.713, 1.791, 1.869, 1.948, 2.026, 2.104, 2.182, 2.26, 2.338, 2.416, 2.494, 2.572, 2.65, 2.728, 2.807, 2.885, 2.963, 3.041, 3.119, 3.197, 3.275, 3.353, 3.431, 3.509, 3.588, 3.666, 3.744, 3.822, 3.9, 3.978, 4.056, 4.134, 4.212, 4.29, 4.368, 4.447, 4.525, 4.603, 4.681, 4.759, 4.837, 4.915, 4.993, 5.071, 5.149, 5.227, 5.306, 5.384, 5.462, 5.54, 5.618, 5.696, 5.774, 5.852, 5.93, 6.008, 6.086, 6.165, 6.243, 6.321, 6.399, 6.477, 6.555, 6.633, 6.711, 6.789, 6.867, 6.945, 7.024, 7.102, 7.18, 7.258, 7.336, 7.414, 7.492, 7.57, 7.648, 7.726, 7.804, 7.883, 7.961, 8.039, 8.117, 8.195, 8.273, 8.351, 8.429, 8.507, 8.585, 8.663, 8.742, 8.82, 8.898, 8.976, 9.054, 9.132, 9.21, 9.288, 9.366, 9.444, 9.522, 9.601, 9.679, 9.757, 9.835, 9.913, 9.991, 10.069, 10.147, 10.225, 10.303, 10.381, 10.46, 10.538, 10.616, 10.694, 10.772, 10.85, 10.928, 11.006, 11.084, 11.162, 11.24, 11.319, 11.397, 11.475, 11.553, 11.631, 11.709, 11.787, 11.865, 11.943, 12.021, 12.099, 12.178, 12.256, 12.334, 12.412, 12.49, 12.568, 12.646, 12.724, 12.802, 12.88, 12.958, 13.037, 13.115, 13.193, 13.271, 13.349, 13.427, 13.505, 13.583, 13.661, 13.739, 13.817, 13.896, 13.974, 14.052, 14.13, 14.208, 14.286, 14.364, 14.442, 14.52, 14.598, 14.676, 14.755, 14.833, 14.911, 14.989, 15.067, 15.145, 15.223, 15.301, 15.379, 15.457, 15.535, 15.614, 15.692, 15.77, 15.848, 15.926, 16.004, 16.082, 16.16, 16.238, 16.316, 16.394, 16.473, 16.551, 16.629, 16.707, 16.785, 16.863, 16.941, 17.019, 17.097, 17.175, 17.254, 17.332, 17.41, 17.488, 17.566, 17.644, 17.722, 17.8, 17.878, 17.956, 18.034, 18.113, 18.191, 18.269, 18.347, 18.425, 18.503, 18.581, 18.659, 18.737, 18.815, 18.893, 18.972, 19.05, 19.128, 19.12769785, -4.3, -4.222, -4.144, -4.065, -3.987, -3.909, -3.831, -3.753, -3.675, -3.597, -3.519, -3.441, -3.363, -3.285, -3.206, -3.128, -3.05, -2.972, -2.894, -2.816, -2.738, -2.66, -2.582, -2.504, -2.426, -2.347, -2.269, -2.191, -2.113, -2.035, -1.957, -1.879, -1.801, -1.723, -1.645, -1.567, -1.488, -1.41, -1.332, -1.254, -1.176, -1.098, -1.02, -0.942, -0.864, -0.786, -0.708, -0.629, -0.551, -0.473, -0.395, -0.317, -0.239, -0.161, -0.083, -0.005, 0.073, 0.151, 0.23, 0.308, 0.386, 0.464, 0.542, 0.62, 0.698, 0.776, 0.854, 0.932, 1.01, 1.089, 1.167, 1.245, 1.323, 1.401, 1.479, 1.557, 1.635, 1.713, 1.791, 1.869, 1.948, 2.026, 2.104, 2.182, 2.26, 2.338, 2.416, 2.494, 2.572, 2.65, 2.728, 2.807, 2.885, 2.963, 3.041, 3.119, 3.197, 3.275, 3.353, 3.431, 3.509, 3.588, 3.666, 3.744, 3.822, 3.9, 3.978, 4.056, 4.134, 4.212, 4.29, 4.368, 4.447, 4.525, 4.603, 4.681, 4.759, 4.837, 4.915, 4.993, 5.071, 5.149, 5.227, 5.306, 5.384, 5.462, 5.54, 5.618, 5.696, 5.774, 5.852, 5.93, 6.008, 6.086, 6.165, 6.243, 6.321, 6.399, 6.477, 6.555, 6.633, 6.711, 6.789, 6.867, 6.945, 7.024, 7.102, 7.18, 7.258, 7.336, 7.414, 7.492, 7.57, 7.648, 7.726, 7.804, 7.883, 7.961, 8.039, 8.117, 8.195, 8.273, 8.351, 8.429, 8.507, 8.585, 8.663, 8.742, 8.82, 8.898, 8.976, 9.054, 9.132, 9.21, 9.288, 9.366, 9.444, 9.522, 9.601, 9.679, 9.757, 9.835, 9.913, 9.991, 10.069, 10.147, 10.225, 10.303, 10.381, 10.46, 10.538, 10.616, 10.694, 10.772, 10.85, 10.928, 11.006, 11.084, 11.162, 11.24, 11.319, 11.397, 11.475, 11.553, 11.631, 11.709, 11.787, 11.865, 11.943, 12.021, 12.099, 12.178, 12.256, 12.334, 12.412, 12.49, 12.568, 12.646, 12.724, 12.802, 12.88, 12.958, 13.037, 13.115, 13.193, 13.271, 13.349, 13.427, 13.505, 13.583, 13.661, 13.739, 13.817, 13.896, 13.974, 14.052, 14.13, 14.208, 14.286, 14.364, 14.442, 14.52, 14.598, 14.676, 14.755, 14.833, 14.911, 14.989, 15.067, 15.145, 15.223, 15.301, 15.379, 15.457, 15.535, 15.614, 15.692, 15.77, 15.848, 15.926, 16.004, 16.082, 16.16, 16.238, 16.316, 16.394, 16.473, 16.551, 16.629, 16.707, 16.785, 16.863, 16.941, 17.019, 17.097, 17.175, 17.254, 17.332, 17.41, 17.488, 17.566, 17.644, 17.722, 17.8, 17.878, 17.956, 18.034, 18.113, 18.191, 18.269, 18.347, 18.425, 18.503, 18.581, 18.659, 18.737, 18.815, 18.893, 18.972, 19.05, 19.128, 19.12769785, -4.3, -4.222, -4.144, -4.065, -3.987, -3.909, -3.831, -3.753, -3.675, -3.597, -3.519, -3.441, -3.363, -3.285, -3.206, -3.128, -3.05, -2.972, -2.894, -2.816, -2.738, -2.66, -2.582, -2.504, -2.426, -2.347, -2.269, -2.191, -2.113, -2.035, -1.957, -1.879, -1.801, -1.723, -1.645, -1.567, -1.488, -1.41, -1.332, -1.254, -1.176, -1.098, -1.02, -0.942, -0.864, -0.786, -0.708, -0.629, -0.551, -0.473, -0.395, -0.317, -0.239, -0.161, -0.083, -0.005, 0.073, 0.151, 0.23, 0.308, 0.386, 0.464, 0.542, 0.62, 0.698, 0.776, 0.854, 0.932, 1.01, 1.089, 1.167, 1.245, 1.323, 1.401, 1.479, 1.557, 1.635, 1.713, 1.791, 1.869, 1.948, 2.026, 2.104, 2.182, 2.26, 2.338, 2.416, 2.494, 2.572, 2.65, 2.728, 2.807, 2.885, 2.963, 3.041, 3.119, 3.197, 3.275, 3.353, 3.431, 3.509, 3.588, 3.666, 3.744, 3.822, 3.9, 3.978, 4.056, 4.134, 4.212, 4.29, 4.368, 4.447, 4.525, 4.603, 4.681, 4.759, 4.837, 4.915, 4.993, 5.071, 5.149, 5.227, 5.306, 5.384, 5.462, 5.54, 5.618, 5.696, 5.774, 5.852, 5.93, 6.008, 6.086, 6.165, 6.243, 6.321, 6.399, 6.477, 6.555, 6.633, 6.711, 6.789, 6.867, 6.945, 7.024, 7.102, 7.18, 7.258, 7.336, 7.414, 7.492, 7.57, 7.648, 7.726, 7.804, 7.883, 7.961, 8.039, 8.117, 8.195, 8.273, 8.351, 8.429, 8.507, 8.585, 8.663, 8.742, 8.82, 8.898, 8.976, 9.054, 9.132, 9.21, 9.288, 9.366, 9.444, 9.522, 9.601, 9.679, 9.757, 9.835, 9.913, 9.991, 10.069, 10.147, 10.225, 10.303, 10.381, 10.46, 10.538, 10.616, 10.694, 10.772, 10.85, 10.928, 11.006, 11.084, 11.162, 11.24, 11.319, 11.397, 11.475, 11.553, 11.631, 11.709, 11.787, 11.865, 11.943, 12.021, 12.099, 12.178, 12.256, 12.334, 12.412, 12.49, 12.568, 12.646, 12.724, 12.802, 12.88, 12.958, 13.037, 13.115, 13.193, 13.271, 13.349, 13.427, 13.505, 13.583, 13.661, 13.739, 13.817, 13.896, 13.974, 14.052, 14.13, 14.208, 14.286, 14.364, 14.442, 14.52, 14.598, 14.676, 14.755, 14.833, 14.911, 14.989, 15.067, 15.145, 15.223, 15.301, 15.379, 15.457, 15.535, 15.614, 15.692, 15.77, 15.848, 15.926, 16.004, 16.082, 16.16, 16.238, 16.316, 16.394, 16.473, 16.551, 16.629, 16.707, 16.785, 16.863, 16.941, 17.019, 17.097, 17.175, 17.254, 17.332, 17.41, 17.488, 17.566, 17.644, 17.722, 17.8, 17.878, 17.956, 18.034, 18.113, 18.191, 18.269, 18.347, 18.425, 18.503, 18.581, 18.659, 18.737, 18.815, 18.893, 18.972, 19.05, 19.128, 19.12769785, -4.3, -4.222, -4.144, -4.065, -3.987, -3.909, -3.831, -3.753, -3.675, -3.597, -3.519, -3.441, -3.363, -3.285, -3.206, -3.128, -3.05, -2.972, -2.894, -2.816, -2.738, -2.66, -2.582, -2.504, -2.426, -2.347, -2.269, -2.191, -2.113, -2.035, -1.957, -1.879, -1.801, -1.723, -1.645, -1.567, -1.488, -1.41, -1.332, -1.254, -1.176, -1.098, -1.02, -0.942, -0.864, -0.786, -0.708, -0.629, -0.551, -0.473, -0.395, -0.317, -0.239, -0.161, -0.083, -0.005, 0.073, 0.151, 0.23, 0.308, 0.386, 0.464, 0.542, 0.62, 0.698, 0.776, 0.854, 0.932, 1.01, 1.089, 1.167, 1.245, 1.323, 1.401, 1.479, 1.557, 1.635, 1.713, 1.791, 1.869, 1.948, 2.026, 2.104, 2.182, 2.26, 2.338, 2.416, 2.494, 2.572, 2.65, 2.728, 2.807, 2.885, 2.963, 3.041, 3.119, 3.197, 3.275, 3.353, 3.431, 3.509, 3.588, 3.666, 3.744, 3.822, 3.9, 3.978, 4.056, 4.134, 4.212, 4.29, 4.368, 4.447, 4.525, 4.603, 4.681, 4.759, 4.837, 4.915, 4.993, 5.071, 5.149, 5.227, 5.306, 5.384, 5.462, 5.54, 5.618, 5.696, 5.774, 5.852, 5.93, 6.008, 6.086, 6.165, 6.243, 6.321, 6.399, 6.477, 6.555, 6.633, 6.711, 6.789, 6.867, 6.945, 7.024, 7.102, 7.18, 7.258, 7.336, 7.414, 7.492, 7.57, 7.648, 7.726, 7.804, 7.883, 7.961, 8.039, 8.117, 8.195, 8.273, 8.351, 8.429, 8.507, 8.585, 8.663, 8.742, 8.82, 8.898, 8.976, 9.054, 9.132, 9.21, 9.288, 9.366, 9.444, 9.522, 9.601, 9.679, 9.757, 9.835, 9.913, 9.991, 10.069, 10.147, 10.225, 10.303, 10.381, 10.46, 10.538, 10.616, 10.694, 10.772, 10.85, 10.928, 11.006, 11.084, 11.162, 11.24, 11.319, 11.397, 11.475, 11.553, 11.631, 11.709, 11.787, 11.865, 11.943, 12.021, 12.099, 12.178, 12.256, 12.334, 12.412, 12.49, 12.568, 12.646, 12.724, 12.802, 12.88, 12.958, 13.037, 13.115, 13.193, 13.271, 13.349, 13.427, 13.505, 13.583, 13.661, 13.739, 13.817, 13.896, 13.974, 14.052, 14.13, 14.208, 14.286, 14.364, 14.442, 14.52, 14.598, 14.676, 14.755, 14.833, 14.911, 14.989, 15.067, 15.145, 15.223, 15.301, 15.379, 15.457, 15.535, 15.614, 15.692, 15.77, 15.848, 15.926, 16.004, 16.082, 16.16, 16.238, 16.316, 16.394, 16.473, 16.551, 16.629, 16.707, 16.785, 16.863, 16.941, 17.019, 17.097, 17.175, 17.254, 17.332, 17.41, 17.488, 17.566, 17.644, 17.722, 17.8, 17.878, 17.956, 18.034, 18.113, 18.191, 18.269, 18.347, 18.425, 18.503, 18.581, 18.659, 18.737, 18.815, 18.893, 18.972, 19.05, 19.128], [-4.378, -4.301, -4.224, -4.148, -4.071, -3.995, -3.918, -3.842, -3.765, -3.689, -3.612, -3.535, -3.459, -3.382, -3.306, -3.229, -3.153, -3.076, -3.0, -2.923, -2.846, -2.77, -2.693, -2.617, -2.54, -2.464, -2.387, -2.311, -2.234, -2.157, -2.081, -2.004, -1.928, -1.851, -1.775, -1.698, -1.622, -1.545, -1.468, -1.392, -1.315, -1.239, -1.162, -1.086, -1.009, -0.933, -0.856, -0.779, -0.703, -0.626, -0.55, -0.473, -0.397, -0.32, -0.244, -0.167, -0.091, -0.014, 0.063, 0.139, 0.216, 0.292, 0.369, 0.445, 0.522, 0.598, 0.675, 0.752, 0.828, 0.905, 0.981, 1.058, 1.134, 1.211, 1.287, 1.364, 1.441, 1.517, 1.594, 1.67, 1.747, 1.823, 1.9, 1.976, 2.053, 2.13, 2.206, 2.283, 2.359, 2.436, 2.512, 2.589, 2.665, 2.742, 2.819, 2.895, 2.972, 3.048, 3.125, 3.201, 3.278, 3.354, 3.431, 3.508, 3.584, 3.661, 3.737, 3.814, 3.89, 3.967, 4.043, 4.12, 4.197, 4.273, 4.35, 4.426, 4.503, 4.579, 4.656, 4.732, 4.809, 4.885, 4.962, 5.039, 5.115, 5.192, 5.268, 5.345, 5.421, 5.498, 5.574, 5.651, 5.728, 5.804, 5.881, 5.957, 6.034, 6.11, 6.187, 6.263, 6.34, 6.417, 6.493, 6.57, 6.646, 6.723, 6.799, 6.876, 6.952, 7.029, 7.106, 7.182, 7.259, 7.335, 7.412, 7.488, 7.565, 7.641, 7.718, 7.795, 7.871, 7.948, 8.024, 8.101, 8.177, 8.254, 8.33, 8.407, 8.484, 8.56, 8.637, 8.713, 8.79, 8.866, 8.943, 9.019, 9.096, 9.173, 9.249, 9.326, 9.402, 9.479, 9.555, 9.632, 9.708, 9.785, 9.862, 9.938, 10.015, 10.091, 10.168, 10.244, 10.321, 10.397, 10.474, 10.55, 10.627, 10.704, 10.78, 10.857, 10.933, 11.01, 11.086, 11.163, 11.239, 11.316, 11.393, 11.469, 11.546, 11.622, 11.699, 11.775, 11.852, 11.928, 12.005, 12.082, 12.158, 12.235, 12.311, 12.388, 12.464, 12.541, 12.617, 12.694, 12.771, 12.847, 12.924, 13.0, 13.077, 13.153, 13.23, 13.306, 13.383, 13.46, 13.536, 13.613, 13.689, 13.766, 13.842, 13.919, 13.995, 14.072, 14.149, 14.225, 14.302, 14.378, 14.455, 14.531, 14.608, 14.684, 14.761, 14.838, 14.914, 14.991, 15.067, 15.144, 15.22, 15.297, 15.373, 15.45, 15.526, 15.603, 15.68, 15.756, 15.833, 15.909, 15.986, 16.062, 16.139, 16.215, 16.292, 16.369, 16.445, 16.522, 16.598, 16.675, 16.751, 16.828, 16.904, 16.981, 17.058, 17.134, 17.211, 17.287, 17.364, 17.44, 17.517, 17.593, 17.67, 17.747, 17.823, 17.9, 17.976, 18.053, 18.129, 18.206, 18.282, 18.359, 18.436, 18.512, 18.589, 18.58865598, -4.378, -4.301, -4.224, -4.148, -4.071, -3.995, -3.918, -3.842, -3.765, -3.689, -3.612, -3.535, -3.459, -3.382, -3.306, -3.229, -3.153, -3.076, -3.0, -2.923, -2.846, -2.77, -2.693, -2.617, -2.54, -2.464, -2.387, -2.311, -2.234, -2.157, -2.081, -2.004, -1.928, -1.851, -1.775, -1.698, -1.622, -1.545, -1.468, -1.392, -1.315, -1.239, -1.162, -1.086, -1.009, -0.933, -0.856, -0.779, -0.703, -0.626, -0.55, -0.473, -0.397, -0.32, -0.244, -0.167, -0.091, -0.014, 0.063, 0.139, 0.216, 0.292, 0.369, 0.445, 0.522, 0.598, 0.675, 0.752, 0.828, 0.905, 0.981, 1.058, 1.134, 1.211, 1.287, 1.364, 1.441, 1.517, 1.594, 1.67, 1.747, 1.823, 1.9, 1.976, 2.053, 2.13, 2.206, 2.283, 2.359, 2.436, 2.512, 2.589, 2.665, 2.742, 2.819, 2.895, 2.972, 3.048, 3.125, 3.201, 3.278, 3.354, 3.431, 3.508, 3.584, 3.661, 3.737, 3.814, 3.89, 3.967, 4.043, 4.12, 4.197, 4.273, 4.35, 4.426, 4.503, 4.579, 4.656, 4.732, 4.809, 4.885, 4.962, 5.039, 5.115, 5.192, 5.268, 5.345, 5.421, 5.498, 5.574, 5.651, 5.728, 5.804, 5.881, 5.957, 6.034, 6.11, 6.187, 6.263, 6.34, 6.417, 6.493, 6.57, 6.646, 6.723, 6.799, 6.876, 6.952, 7.029, 7.106, 7.182, 7.259, 7.335, 7.412, 7.488, 7.565, 7.641, 7.718, 7.795, 7.871, 7.948, 8.024, 8.101, 8.177, 8.254, 8.33, 8.407, 8.484, 8.56, 8.637, 8.713, 8.79, 8.866, 8.943, 9.019, 9.096, 9.173, 9.249, 9.326, 9.402, 9.479, 9.555, 9.632, 9.708, 9.785, 9.862, 9.938, 10.015, 10.091, 10.168, 10.244, 10.321, 10.397, 10.474, 10.55, 10.627, 10.704, 10.78, 10.857, 10.933, 11.01, 11.086, 11.163, 11.239, 11.316, 11.393, 11.469, 11.546, 11.622, 11.699, 11.775, 11.852, 11.928, 12.005, 12.082, 12.158, 12.235, 12.311, 12.388, 12.464, 12.541, 12.617, 12.694, 12.771, 12.847, 12.924, 13.0, 13.077, 13.153, 13.23, 13.306, 13.383, 13.46, 13.536, 13.613, 13.689, 13.766, 13.842, 13.919, 13.995, 14.072, 14.149, 14.225, 14.302, 14.378, 14.455, 14.531, 14.608, 14.684, 14.761, 14.838, 14.914, 14.991, 15.067, 15.144, 15.22, 15.297, 15.373, 15.45, 15.526, 15.603, 15.68, 15.756, 15.833, 15.909, 15.986, 16.062, 16.139, 16.215, 16.292, 16.369, 16.445, 16.522, 16.598, 16.675, 16.751, 16.828, 16.904, 16.981, 17.058, 17.134, 17.211, 17.287, 17.364, 17.44, 17.517, 17.593, 17.67, 17.747, 17.823, 17.9, 17.976, 18.053, 18.129, 18.206, 18.282, 18.359, 18.436, 18.512, 18.589, 18.58865598, -4.378, -4.301, -4.224, -4.148, -4.071, -3.995, -3.918, -3.842, -3.765, -3.689, -3.612, -3.535, -3.459, -3.382, -3.306, -3.229, -3.153, -3.076, -3.0, -2.923, -2.846, -2.77, -2.693, -2.617, -2.54, -2.464, -2.387, -2.311, -2.234, -2.157, -2.081, -2.004, -1.928, -1.851, -1.775, -1.698, -1.622, -1.545, -1.468, -1.392, -1.315, -1.239, -1.162, -1.086, -1.009, -0.933, -0.856, -0.779, -0.703, -0.626, -0.55, -0.473, -0.397, -0.32, -0.244, -0.167, -0.091, -0.014, 0.063, 0.139, 0.216, 0.292, 0.369, 0.445, 0.522, 0.598, 0.675, 0.752, 0.828, 0.905, 0.981, 1.058, 1.134, 1.211, 1.287, 1.364, 1.441, 1.517, 1.594, 1.67, 1.747, 1.823, 1.9, 1.976, 2.053, 2.13, 2.206, 2.283, 2.359, 2.436, 2.512, 2.589, 2.665, 2.742, 2.819, 2.895, 2.972, 3.048, 3.125, 3.201, 3.278, 3.354, 3.431, 3.508, 3.584, 3.661, 3.737, 3.814, 3.89, 3.967, 4.043, 4.12, 4.197, 4.273, 4.35, 4.426, 4.503, 4.579, 4.656, 4.732, 4.809, 4.885, 4.962, 5.039, 5.115, 5.192, 5.268, 5.345, 5.421, 5.498, 5.574, 5.651, 5.728, 5.804, 5.881, 5.957, 6.034, 6.11, 6.187, 6.263, 6.34, 6.417, 6.493, 6.57, 6.646, 6.723, 6.799, 6.876, 6.952, 7.029, 7.106, 7.182, 7.259, 7.335, 7.412, 7.488, 7.565, 7.641, 7.718, 7.795, 7.871, 7.948, 8.024, 8.101, 8.177, 8.254, 8.33, 8.407, 8.484, 8.56, 8.637, 8.713, 8.79, 8.866, 8.943, 9.019, 9.096, 9.173, 9.249, 9.326, 9.402, 9.479, 9.555, 9.632, 9.708, 9.785, 9.862, 9.938, 10.015, 10.091, 10.168, 10.244, 10.321, 10.397, 10.474, 10.55, 10.627, 10.704, 10.78, 10.857, 10.933, 11.01, 11.086, 11.163, 11.239, 11.316, 11.393, 11.469, 11.546, 11.622, 11.699, 11.775, 11.852, 11.928, 12.005, 12.082, 12.158, 12.235, 12.311, 12.388, 12.464, 12.541, 12.617, 12.694, 12.771, 12.847, 12.924, 13.0, 13.077, 13.153, 13.23, 13.306, 13.383, 13.46, 13.536, 13.613, 13.689, 13.766, 13.842, 13.919, 13.995, 14.072, 14.149, 14.225, 14.302, 14.378, 14.455, 14.531, 14.608, 14.684, 14.761, 14.838, 14.914, 14.991, 15.067, 15.144, 15.22, 15.297, 15.373, 15.45, 15.526, 15.603, 15.68, 15.756, 15.833, 15.909, 15.986, 16.062, 16.139, 16.215, 16.292, 16.369, 16.445, 16.522, 16.598, 16.675, 16.751, 16.828, 16.904, 16.981, 17.058, 17.134, 17.211, 17.287, 17.364, 17.44, 17.517, 17.593, 17.67, 17.747, 17.823, 17.9, 17.976, 18.053, 18.129, 18.206, 18.282, 18.359, 18.436, 18.512, 18.589, 18.58865598, -4.378, -4.301, -4.224, -4.148, -4.071, -3.995, -3.918, -3.842, -3.765, -3.689, -3.612, -3.535, -3.459, -3.382, -3.306, -3.229, -3.153, -3.076, -3.0, -2.923, -2.846, -2.77, -2.693, -2.617, -2.54, -2.464, -2.387, -2.311, -2.234, -2.157, -2.081, -2.004, -1.928, -1.851, -1.775, -1.698, -1.622, -1.545, -1.468, -1.392, -1.315, -1.239, -1.162, -1.086, -1.009, -0.933, -0.856, -0.779, -0.703, -0.626, -0.55, -0.473, -0.397, -0.32, -0.244, -0.167, -0.091, -0.014, 0.063, 0.139, 0.216, 0.292, 0.369, 0.445, 0.522, 0.598, 0.675, 0.752, 0.828, 0.905, 0.981, 1.058, 1.134, 1.211, 1.287, 1.364, 1.441, 1.517, 1.594, 1.67, 1.747, 1.823, 1.9, 1.976, 2.053, 2.13, 2.206, 2.283, 2.359, 2.436, 2.512, 2.589, 2.665, 2.742, 2.819, 2.895, 2.972, 3.048, 3.125, 3.201, 3.278, 3.354, 3.431, 3.508, 3.584, 3.661, 3.737, 3.814, 3.89, 3.967, 4.043, 4.12, 4.197, 4.273, 4.35, 4.426, 4.503, 4.579, 4.656, 4.732, 4.809, 4.885, 4.962, 5.039, 5.115, 5.192, 5.268, 5.345, 5.421, 5.498, 5.574, 5.651, 5.728, 5.804, 5.881, 5.957, 6.034, 6.11, 6.187, 6.263, 6.34, 6.417, 6.493, 6.57, 6.646, 6.723, 6.799, 6.876, 6.952, 7.029, 7.106, 7.182, 7.259, 7.335, 7.412, 7.488, 7.565, 7.641, 7.718, 7.795, 7.871, 7.948, 8.024, 8.101, 8.177, 8.254, 8.33, 8.407, 8.484, 8.56, 8.637, 8.713, 8.79, 8.866, 8.943, 9.019, 9.096, 9.173, 9.249, 9.326, 9.402, 9.479, 9.555, 9.632, 9.708, 9.785, 9.862, 9.938, 10.015, 10.091, 10.168, 10.244, 10.321, 10.397, 10.474, 10.55, 10.627, 10.704, 10.78, 10.857, 10.933, 11.01, 11.086, 11.163, 11.239, 11.316, 11.393, 11.469, 11.546, 11.622, 11.699, 11.775, 11.852, 11.928, 12.005, 12.082, 12.158, 12.235, 12.311, 12.388, 12.464, 12.541, 12.617, 12.694, 12.771, 12.847, 12.924, 13.0, 13.077, 13.153, 13.23, 13.306, 13.383, 13.46, 13.536, 13.613, 13.689, 13.766, 13.842, 13.919, 13.995, 14.072, 14.149, 14.225, 14.302, 14.378, 14.455, 14.531, 14.608, 14.684, 14.761, 14.838, 14.914, 14.991, 15.067, 15.144, 15.22, 15.297, 15.373, 15.45, 15.526, 15.603, 15.68, 15.756, 15.833, 15.909, 15.986, 16.062, 16.139, 16.215, 16.292, 16.369, 16.445, 16.522, 16.598, 16.675, 16.751, 16.828, 16.904, 16.981, 17.058, 17.134, 17.211, 17.287, 17.364, 17.44, 17.517, 17.593, 17.67, 17.747, 17.823, 17.9, 17.976, 18.053, 18.129, 18.206, 18.282, 18.359, 18.436, 18.512, 18.589, 18.58865598, -4.378, -4.301, -4.224, -4.148, -4.071, -3.995, -3.918, -3.842, -3.765, -3.689, -3.612, -3.535, -3.459, -3.382, -3.306, -3.229, -3.153, -3.076, -3.0, -2.923, -2.846, -2.77, -2.693, -2.617, -2.54, -2.464, -2.387, -2.311, -2.234, -2.157, -2.081, -2.004, -1.928, -1.851, -1.775, -1.698, -1.622, -1.545, -1.468, -1.392, -1.315, -1.239, -1.162, -1.086, -1.009, -0.933, -0.856, -0.779, -0.703, -0.626, -0.55, -0.473, -0.397, -0.32, -0.244, -0.167, -0.091, -0.014, 0.063, 0.139, 0.216, 0.292, 0.369, 0.445, 0.522, 0.598, 0.675, 0.752, 0.828, 0.905, 0.981, 1.058, 1.134, 1.211, 1.287, 1.364, 1.441, 1.517, 1.594, 1.67, 1.747, 1.823, 1.9, 1.976, 2.053, 2.13, 2.206, 2.283, 2.359, 2.436, 2.512, 2.589, 2.665, 2.742, 2.819, 2.895, 2.972, 3.048, 3.125, 3.201, 3.278, 3.354, 3.431, 3.508, 3.584, 3.661, 3.737, 3.814, 3.89, 3.967, 4.043, 4.12, 4.197, 4.273, 4.35, 4.426, 4.503, 4.579, 4.656, 4.732, 4.809, 4.885, 4.962, 5.039, 5.115, 5.192, 5.268, 5.345, 5.421, 5.498, 5.574, 5.651, 5.728, 5.804, 5.881, 5.957, 6.034, 6.11, 6.187, 6.263, 6.34, 6.417, 6.493, 6.57, 6.646, 6.723, 6.799, 6.876, 6.952, 7.029, 7.106, 7.182, 7.259, 7.335, 7.412, 7.488, 7.565, 7.641, 7.718, 7.795, 7.871, 7.948, 8.024, 8.101, 8.177, 8.254, 8.33, 8.407, 8.484, 8.56, 8.637, 8.713, 8.79, 8.866, 8.943, 9.019, 9.096, 9.173, 9.249, 9.326, 9.402, 9.479, 9.555, 9.632, 9.708, 9.785, 9.862, 9.938, 10.015, 10.091, 10.168, 10.244, 10.321, 10.397, 10.474, 10.55, 10.627, 10.704, 10.78, 10.857, 10.933, 11.01, 11.086, 11.163, 11.239, 11.316, 11.393, 11.469, 11.546, 11.622, 11.699, 11.775, 11.852, 11.928, 12.005, 12.082, 12.158, 12.235, 12.311, 12.388, 12.464, 12.541, 12.617, 12.694, 12.771, 12.847, 12.924, 13.0, 13.077, 13.153, 13.23, 13.306, 13.383, 13.46, 13.536, 13.613, 13.689, 13.766, 13.842, 13.919, 13.995, 14.072, 14.149, 14.225, 14.302, 14.378, 14.455, 14.531, 14.608, 14.684, 14.761, 14.838, 14.914, 14.991, 15.067, 15.144, 15.22, 15.297, 15.373, 15.45, 15.526, 15.603, 15.68, 15.756, 15.833, 15.909, 15.986, 16.062, 16.139, 16.215, 16.292, 16.369, 16.445, 16.522, 16.598, 16.675, 16.751, 16.828, 16.904, 16.981, 17.058, 17.134, 17.211, 17.287, 17.364, 17.44, 17.517, 17.593, 17.67, 17.747, 17.823, 17.9, 17.976, 18.053, 18.129, 18.206, 18.282, 18.359, 18.436, 18.512, 18.589], [-4.451, -4.376, -4.301, -4.226, -4.151, -4.076, -4.001, -3.926, -3.851, -3.776, -3.701, -3.626, -3.551, -3.476, -3.401, -3.326, -3.251, -3.176, -3.101, -3.026, -2.951, -2.876, -2.801, -2.726, -2.65, -2.575, -2.5, -2.425, -2.35, -2.275, -2.2, -2.125, -2.05, -1.975, -1.9, -1.825, -1.75, -1.675, -1.6, -1.525, -1.45, -1.375, -1.3, -1.225, -1.15, -1.075, -1.0, -0.925, -0.85, -0.775, -0.7, -0.624, -0.549, -0.474, -0.399, -0.324, -0.249, -0.174, -0.099, -0.024, 0.051, 0.126, 0.201, 0.276, 0.351, 0.426, 0.501, 0.576, 0.651, 0.726, 0.801, 0.876, 0.951, 1.026, 1.101, 1.176, 1.251, 1.326, 1.402, 1.477, 1.552, 1.627, 1.702, 1.777, 1.852, 1.927, 2.002, 2.077, 2.152, 2.227, 2.302, 2.377, 2.452, 2.527, 2.602, 2.677, 2.752, 2.827, 2.902, 2.977, 3.052, 3.127, 3.202, 3.277, 3.352, 3.427, 3.503, 3.578, 3.653, 3.728, 3.803, 3.878, 3.953, 4.028, 4.103, 4.178, 4.253, 4.328, 4.403, 4.478, 4.553, 4.628, 4.703, 4.778, 4.853, 4.928, 5.003, 5.078, 5.153, 5.228, 5.303, 5.378, 5.453, 5.529, 5.604, 5.679, 5.754, 5.829, 5.904, 5.979, 6.054, 6.129, 6.204, 6.279, 6.354, 6.429, 6.504, 6.579, 6.654, 6.729, 6.804, 6.879, 6.954, 7.029, 7.104, 7.179, 7.254, 7.329, 7.404, 7.479, 7.554, 7.63, 7.705, 7.78, 7.855, 7.93, 8.005, 8.08, 8.155, 8.23, 8.305, 8.38, 8.455, 8.53, 8.605, 8.68, 8.755, 8.83, 8.905, 8.98, 9.055, 9.13, 9.205, 9.28, 9.355, 9.43, 9.505, 9.58, 9.656, 9.731, 9.806, 9.881, 9.956, 10.031, 10.106, 10.181, 10.256, 10.331, 10.406, 10.481, 10.556, 10.631, 10.706, 10.781, 10.856, 10.931, 11.006, 11.081, 11.156, 11.231, 11.306, 11.381, 11.456, 11.531, 11.606, 11.681, 11.757, 11.832, 11.907, 11.982, 12.057, 12.132, 12.207, 12.282, 12.357, 12.432, 12.507, 12.582, 12.657, 12.732, 12.807, 12.882, 12.957, 13.032, 13.107, 13.182, 13.257, 13.332, 13.407, 13.482, 13.557, 13.632, 13.707, 13.783, 13.858, 13.933, 14.008, 14.083, 14.158, 14.233, 14.308, 14.383, 14.458, 14.533, 14.608, 14.683, 14.758, 14.833, 14.908, 14.983, 15.058, 15.133, 15.208, 15.283, 15.358, 15.433, 15.508, 15.583, 15.658, 15.733, 15.809, 15.884, 15.959, 16.034, 16.109, 16.184, 16.259, 16.334, 16.409, 16.484, 16.559, 16.634, 16.709, 16.784, 16.859, 16.934, 17.009, 17.084, 17.159, 17.234, 17.309, 17.384, 17.459, 17.534, 17.609, 17.684, 17.759, 17.834, 17.91, 17.985, 18.06, 18.05959736, -4.451, -4.376, -4.301, -4.226, -4.151, -4.076, -4.001, -3.926, -3.851, -3.776, -3.701, -3.626, -3.551, -3.476, -3.401, -3.326, -3.251, -3.176, -3.101, -3.026, -2.951, -2.876, -2.801, -2.726, -2.65, -2.575, -2.5, -2.425, -2.35, -2.275, -2.2, -2.125, -2.05, -1.975, -1.9, -1.825, -1.75, -1.675, -1.6, -1.525, -1.45, -1.375, -1.3, -1.225, -1.15, -1.075, -1.0, -0.925, -0.85, -0.775, -0.7, -0.624, -0.549, -0.474, -0.399, -0.324, -0.249, -0.174, -0.099, -0.024, 0.051, 0.126, 0.201, 0.276, 0.351, 0.426, 0.501, 0.576, 0.651, 0.726, 0.801, 0.876, 0.951, 1.026, 1.101, 1.176, 1.251, 1.326, 1.402, 1.477, 1.552, 1.627, 1.702, 1.777, 1.852, 1.927, 2.002, 2.077, 2.152, 2.227, 2.302, 2.377, 2.452, 2.527, 2.602, 2.677, 2.752, 2.827, 2.902, 2.977, 3.052, 3.127, 3.202, 3.277, 3.352, 3.427, 3.503, 3.578, 3.653, 3.728, 3.803, 3.878, 3.953, 4.028, 4.103, 4.178, 4.253, 4.328, 4.403, 4.478, 4.553, 4.628, 4.703, 4.778, 4.853, 4.928, 5.003, 5.078, 5.153, 5.228, 5.303, 5.378, 5.453, 5.529, 5.604, 5.679, 5.754, 5.829, 5.904, 5.979, 6.054, 6.129, 6.204, 6.279, 6.354, 6.429, 6.504, 6.579, 6.654, 6.729, 6.804, 6.879, 6.954, 7.029, 7.104, 7.179, 7.254, 7.329, 7.404, 7.479, 7.554, 7.63, 7.705, 7.78, 7.855, 7.93, 8.005, 8.08, 8.155, 8.23, 8.305, 8.38, 8.455, 8.53, 8.605, 8.68, 8.755, 8.83, 8.905, 8.98, 9.055, 9.13, 9.205, 9.28, 9.355, 9.43, 9.505, 9.58, 9.656, 9.731, 9.806, 9.881, 9.956, 10.031, 10.106, 10.181, 10.256, 10.331, 10.406, 10.481, 10.556, 10.631, 10.706, 10.781, 10.856, 10.931, 11.006, 11.081, 11.156, 11.231, 11.306, 11.381, 11.456, 11.531, 11.606, 11.681, 11.757, 11.832, 11.907, 11.982, 12.057, 12.132, 12.207, 12.282, 12.357, 12.432, 12.507, 12.582, 12.657, 12.732, 12.807, 12.882, 12.957, 13.032, 13.107, 13.182, 13.257, 13.332, 13.407, 13.482, 13.557, 13.632, 13.707, 13.783, 13.858, 13.933, 14.008, 14.083, 14.158, 14.233, 14.308, 14.383, 14.458, 14.533, 14.608, 14.683, 14.758, 14.833, 14.908, 14.983, 15.058, 15.133, 15.208, 15.283, 15.358, 15.433, 15.508, 15.583, 15.658, 15.733, 15.809, 15.884, 15.959, 16.034, 16.109, 16.184, 16.259, 16.334, 16.409, 16.484, 16.559, 16.634, 16.709, 16.784, 16.859, 16.934, 17.009, 17.084, 17.159, 17.234, 17.309, 17.384, 17.459, 17.534, 17.609, 17.684, 17.759, 17.834, 17.91, 17.985, 18.06, 18.05959736, -4.451, -4.376, -4.301, -4.226, -4.151, -4.076, -4.001, -3.926, -3.851, -3.776, -3.701, -3.626, -3.551, -3.476, -3.401, -3.326, -3.251, -3.176, -3.101, -3.026, -2.951, -2.876, -2.801, -2.726, -2.65, -2.575, -2.5, -2.425, -2.35, -2.275, -2.2, -2.125, -2.05, -1.975, -1.9, -1.825, -1.75, -1.675, -1.6, -1.525, -1.45, -1.375, -1.3, -1.225, -1.15, -1.075, -1.0, -0.925, -0.85, -0.775, -0.7, -0.624, -0.549, -0.474, -0.399, -0.324, -0.249, -0.174, -0.099, -0.024, 0.051, 0.126, 0.201, 0.276, 0.351, 0.426, 0.501, 0.576, 0.651, 0.726, 0.801, 0.876, 0.951, 1.026, 1.101, 1.176, 1.251, 1.326, 1.402, 1.477, 1.552, 1.627, 1.702, 1.777, 1.852, 1.927, 2.002, 2.077, 2.152, 2.227, 2.302, 2.377, 2.452, 2.527, 2.602, 2.677, 2.752, 2.827, 2.902, 2.977, 3.052, 3.127, 3.202, 3.277, 3.352, 3.427, 3.503, 3.578, 3.653, 3.728, 3.803, 3.878, 3.953, 4.028, 4.103, 4.178, 4.253, 4.328, 4.403, 4.478, 4.553, 4.628, 4.703, 4.778, 4.853, 4.928, 5.003, 5.078, 5.153, 5.228, 5.303, 5.378, 5.453, 5.529, 5.604, 5.679, 5.754, 5.829, 5.904, 5.979, 6.054, 6.129, 6.204, 6.279, 6.354, 6.429, 6.504, 6.579, 6.654, 6.729, 6.804, 6.879, 6.954, 7.029, 7.104, 7.179, 7.254, 7.329, 7.404, 7.479, 7.554, 7.63, 7.705, 7.78, 7.855, 7.93, 8.005, 8.08, 8.155, 8.23, 8.305, 8.38, 8.455, 8.53, 8.605, 8.68, 8.755, 8.83, 8.905, 8.98, 9.055, 9.13, 9.205, 9.28, 9.355, 9.43, 9.505, 9.58, 9.656, 9.731, 9.806, 9.881, 9.956, 10.031, 10.106, 10.181, 10.256, 10.331, 10.406, 10.481, 10.556, 10.631, 10.706, 10.781, 10.856, 10.931, 11.006, 11.081, 11.156, 11.231, 11.306, 11.381, 11.456, 11.531, 11.606, 11.681, 11.757, 11.832, 11.907, 11.982, 12.057, 12.132, 12.207, 12.282, 12.357, 12.432, 12.507, 12.582, 12.657, 12.732, 12.807, 12.882, 12.957, 13.032, 13.107, 13.182, 13.257, 13.332, 13.407, 13.482, 13.557, 13.632, 13.707, 13.783, 13.858, 13.933, 14.008, 14.083, 14.158, 14.233, 14.308, 14.383, 14.458, 14.533, 14.608, 14.683, 14.758, 14.833, 14.908, 14.983, 15.058, 15.133, 15.208, 15.283, 15.358, 15.433, 15.508, 15.583, 15.658, 15.733, 15.809, 15.884, 15.959, 16.034, 16.109, 16.184, 16.259, 16.334, 16.409, 16.484, 16.559, 16.634, 16.709, 16.784, 16.859, 16.934, 17.009, 17.084, 17.159, 17.234, 17.309, 17.384, 17.459, 17.534, 17.609, 17.684, 17.759, 17.834, 17.91, 17.985, 18.06, 18.05959736, -4.451, -4.376, -4.301, -4.226, -4.151, -4.076, -4.001, -3.926, -3.851, -3.776, -3.701, -3.626, -3.551, -3.476, -3.401, -3.326, -3.251, -3.176, -3.101, -3.026, -2.951, -2.876, -2.801, -2.726, -2.65, -2.575, -2.5, -2.425, -2.35, -2.275, -2.2, -2.125, -2.05, -1.975, -1.9, -1.825, -1.75, -1.675, -1.6, -1.525, -1.45, -1.375, -1.3, -1.225, -1.15, -1.075, -1.0, -0.925, -0.85, -0.775, -0.7, -0.624, -0.549, -0.474, -0.399, -0.324, -0.249, -0.174, -0.099, -0.024, 0.051, 0.126, 0.201, 0.276, 0.351, 0.426, 0.501, 0.576, 0.651, 0.726, 0.801, 0.876, 0.951, 1.026, 1.101, 1.176, 1.251, 1.326, 1.402, 1.477, 1.552, 1.627, 1.702, 1.777, 1.852, 1.927, 2.002, 2.077, 2.152, 2.227, 2.302, 2.377, 2.452, 2.527, 2.602, 2.677, 2.752, 2.827, 2.902, 2.977, 3.052, 3.127, 3.202, 3.277, 3.352, 3.427, 3.503, 3.578, 3.653, 3.728, 3.803, 3.878, 3.953, 4.028, 4.103, 4.178, 4.253, 4.328, 4.403, 4.478, 4.553, 4.628, 4.703, 4.778, 4.853, 4.928, 5.003, 5.078, 5.153, 5.228, 5.303, 5.378, 5.453, 5.529, 5.604, 5.679, 5.754, 5.829, 5.904, 5.979, 6.054, 6.129, 6.204, 6.279, 6.354, 6.429, 6.504, 6.579, 6.654, 6.729, 6.804, 6.879, 6.954, 7.029, 7.104, 7.179, 7.254, 7.329, 7.404, 7.479, 7.554, 7.63, 7.705, 7.78, 7.855, 7.93, 8.005, 8.08, 8.155, 8.23, 8.305, 8.38, 8.455, 8.53, 8.605, 8.68, 8.755, 8.83, 8.905, 8.98, 9.055, 9.13, 9.205, 9.28, 9.355, 9.43, 9.505, 9.58, 9.656, 9.731, 9.806, 9.881, 9.956, 10.031, 10.106, 10.181, 10.256, 10.331, 10.406, 10.481, 10.556, 10.631, 10.706, 10.781, 10.856, 10.931, 11.006, 11.081, 11.156, 11.231, 11.306, 11.381, 11.456, 11.531, 11.606, 11.681, 11.757, 11.832, 11.907, 11.982, 12.057, 12.132, 12.207, 12.282, 12.357, 12.432, 12.507, 12.582, 12.657, 12.732, 12.807, 12.882, 12.957, 13.032, 13.107, 13.182, 13.257, 13.332, 13.407, 13.482, 13.557, 13.632, 13.707, 13.783, 13.858, 13.933, 14.008, 14.083, 14.158, 14.233, 14.308, 14.383, 14.458, 14.533, 14.608, 14.683, 14.758, 14.833, 14.908, 14.983, 15.058, 15.133, 15.208, 15.283, 15.358, 15.433, 15.508, 15.583, 15.658, 15.733, 15.809, 15.884, 15.959, 16.034, 16.109, 16.184, 16.259, 16.334, 16.409, 16.484, 16.559, 16.634, 16.709, 16.784, 16.859, 16.934, 17.009, 17.084, 17.159, 17.234, 17.309, 17.384, 17.459, 17.534, 17.609, 17.684, 17.759, 17.834, 17.91, 17.985, 18.06, 18.05959736, -4.451, -4.376, -4.301, -4.226, -4.151, -4.076, -4.001, -3.926, -3.851, -3.776, -3.701, -3.626, -3.551, -3.476, -3.401, -3.326, -3.251, -3.176, -3.101, -3.026, -2.951, -2.876, -2.801, -2.726, -2.65, -2.575, -2.5, -2.425, -2.35, -2.275, -2.2, -2.125, -2.05, -1.975, -1.9, -1.825, -1.75, -1.675, -1.6, -1.525, -1.45, -1.375, -1.3, -1.225, -1.15, -1.075, -1.0, -0.925, -0.85, -0.775, -0.7, -0.624, -0.549, -0.474, -0.399, -0.324, -0.249, -0.174, -0.099, -0.024, 0.051, 0.126, 0.201, 0.276, 0.351, 0.426, 0.501, 0.576, 0.651, 0.726, 0.801, 0.876, 0.951, 1.026, 1.101, 1.176, 1.251, 1.326, 1.402, 1.477, 1.552, 1.627, 1.702, 1.777, 1.852, 1.927, 2.002, 2.077, 2.152, 2.227, 2.302, 2.377, 2.452, 2.527, 2.602, 2.677, 2.752, 2.827, 2.902, 2.977, 3.052, 3.127, 3.202, 3.277, 3.352, 3.427, 3.503, 3.578, 3.653, 3.728, 3.803, 3.878, 3.953, 4.028, 4.103, 4.178, 4.253, 4.328, 4.403, 4.478, 4.553, 4.628, 4.703, 4.778, 4.853, 4.928, 5.003, 5.078, 5.153, 5.228, 5.303, 5.378, 5.453, 5.529, 5.604, 5.679, 5.754, 5.829, 5.904, 5.979, 6.054, 6.129, 6.204, 6.279, 6.354, 6.429, 6.504, 6.579, 6.654, 6.729, 6.804, 6.879, 6.954, 7.029, 7.104, 7.179, 7.254, 7.329, 7.404, 7.479, 7.554, 7.63, 7.705, 7.78, 7.855, 7.93, 8.005, 8.08, 8.155, 8.23, 8.305, 8.38, 8.455, 8.53, 8.605, 8.68, 8.755, 8.83, 8.905, 8.98, 9.055, 9.13, 9.205, 9.28, 9.355, 9.43, 9.505, 9.58, 9.656, 9.731, 9.806, 9.881, 9.956, 10.031, 10.106, 10.181, 10.256, 10.331, 10.406, 10.481, 10.556, 10.631, 10.706, 10.781, 10.856, 10.931, 11.006, 11.081, 11.156, 11.231, 11.306, 11.381, 11.456, 11.531, 11.606, 11.681, 11.757, 11.832, 11.907, 11.982, 12.057, 12.132, 12.207, 12.282, 12.357, 12.432, 12.507, 12.582, 12.657, 12.732, 12.807, 12.882, 12.957, 13.032, 13.107, 13.182, 13.257, 13.332, 13.407, 13.482, 13.557, 13.632, 13.707, 13.783, 13.858, 13.933, 14.008, 14.083, 14.158, 14.233, 14.308, 14.383, 14.458, 14.533, 14.608, 14.683, 14.758, 14.833, 14.908, 14.983, 15.058, 15.133, 15.208, 15.283, 15.358, 15.433, 15.508, 15.583, 15.658, 15.733, 15.809, 15.884, 15.959, 16.034, 16.109, 16.184, 16.259, 16.334, 16.409, 16.484, 16.559, 16.634, 16.709, 16.784, 16.859, 16.934, 17.009, 17.084, 17.159, 17.234, 17.309, 17.384, 17.459, 17.534, 17.609, 17.684, 17.759, 17.834, 17.91, 17.985, 18.06], [-4.521, -4.448, -4.374, -4.301, -4.227, -4.153, -4.08, -4.006, -3.933, -3.859, -3.786, -3.712, -3.639, -3.565, -3.492, -3.418, -3.345, -3.271, -3.197, -3.124, -3.05, -2.977, -2.903, -2.83, -2.756, -2.683, -2.609, -2.536, -2.462, -2.389, -2.315, -2.242, -2.168, -2.094, -2.021, -1.947, -1.874, -1.8, -1.727, -1.653, -1.58, -1.506, -1.433, -1.359, -1.286, -1.212, -1.138, -1.065, -0.991, -0.918, -0.844, -0.771, -0.697, -0.624, -0.55, -0.477, -0.403, -0.33, -0.256, -0.182, -0.109, -0.035, 0.038, 0.112, 0.185, 0.259, 0.332, 0.406, 0.479, 0.553, 0.626, 0.7, 0.773, 0.847, 0.921, 0.994, 1.068, 1.141, 1.215, 1.288, 1.362, 1.435, 1.509, 1.582, 1.656, 1.729, 1.803, 1.877, 1.95, 2.024, 2.097, 2.171, 2.244, 2.318, 2.391, 2.465, 2.538, 2.612, 2.685, 2.759, 2.833, 2.906, 2.98, 3.053, 3.127, 3.2, 3.274, 3.347, 3.421, 3.494, 3.568, 3.641, 3.715, 3.789, 3.862, 3.936, 4.009, 4.083, 4.156, 4.23, 4.303, 4.377, 4.45, 4.524, 4.597, 4.671, 4.744, 4.818, 4.892, 4.965, 5.039, 5.112, 5.186, 5.259, 5.333, 5.406, 5.48, 5.553, 5.627, 5.7, 5.774, 5.848, 5.921, 5.995, 6.068, 6.142, 6.215, 6.289, 6.362, 6.436, 6.509, 6.583, 6.656, 6.73, 6.804, 6.877, 6.951, 7.024, 7.098, 7.171, 7.245, 7.318, 7.392, 7.465, 7.539, 7.612, 7.686, 7.76, 7.833, 7.907, 7.98, 8.054, 8.127, 8.201, 8.274, 8.348, 8.421, 8.495, 8.568, 8.642, 8.715, 8.789, 8.863, 8.936, 9.01, 9.083, 9.157, 9.23, 9.304, 9.377, 9.451, 9.524, 9.598, 9.671, 9.745, 9.819, 9.892, 9.966, 10.039, 10.113, 10.186, 10.26, 10.333, 10.407, 10.48, 10.554, 10.627, 10.701, 10.775, 10.848, 10.922, 10.995, 11.069, 11.142, 11.216, 11.289, 11.363, 11.436, 11.51, 11.583, 11.657, 11.73, 11.804, 11.878, 11.951, 12.025, 12.098, 12.172, 12.245, 12.319, 12.392, 12.466, 12.539, 12.613, 12.686, 12.76, 12.834, 12.907, 12.981, 13.054, 13.128, 13.201, 13.275, 13.348, 13.422, 13.495, 13.569, 13.642, 13.716, 13.79, 13.863, 13.937, 14.01, 14.084, 14.157, 14.231, 14.304, 14.378, 14.451, 14.525, 14.598, 14.672, 14.746, 14.819, 14.893, 14.966, 15.04, 15.113, 15.187, 15.26, 15.334, 15.407, 15.481, 15.554, 15.628, 15.701, 15.775, 15.849, 15.922, 15.996, 16.069, 16.143, 16.216, 16.29, 16.363, 16.437, 16.51, 16.584, 16.657, 16.731, 16.805, 16.878, 16.952, 17.025, 17.099, 17.172, 17.246, 17.319, 17.393, 17.466, 17.54, 17.53990615, -4.521, -4.448, -4.374, -4.301, -4.227, -4.153, -4.08, -4.006, -3.933, -3.859, -3.786, -3.712, -3.639, -3.565, -3.492, -3.418, -3.345, -3.271, -3.197, -3.124, -3.05, -2.977, -2.903, -2.83, -2.756, -2.683, -2.609, -2.536, -2.462, -2.389, -2.315, -2.242, -2.168, -2.094, -2.021, -1.947, -1.874, -1.8, -1.727, -1.653, -1.58, -1.506, -1.433, -1.359, -1.286, -1.212, -1.138, -1.065, -0.991, -0.918, -0.844, -0.771, -0.697, -0.624, -0.55, -0.477, -0.403, -0.33, -0.256, -0.182, -0.109, -0.035, 0.038, 0.112, 0.185, 0.259, 0.332, 0.406, 0.479, 0.553, 0.626, 0.7, 0.773, 0.847, 0.921, 0.994, 1.068, 1.141, 1.215, 1.288, 1.362, 1.435, 1.509, 1.582, 1.656, 1.729, 1.803, 1.877, 1.95, 2.024, 2.097, 2.171, 2.244, 2.318, 2.391, 2.465, 2.538, 2.612, 2.685, 2.759, 2.833, 2.906, 2.98, 3.053, 3.127, 3.2, 3.274, 3.347, 3.421, 3.494, 3.568, 3.641, 3.715, 3.789, 3.862, 3.936, 4.009, 4.083, 4.156, 4.23, 4.303, 4.377, 4.45, 4.524, 4.597, 4.671, 4.744, 4.818, 4.892, 4.965, 5.039, 5.112, 5.186, 5.259, 5.333, 5.406, 5.48, 5.553, 5.627, 5.7, 5.774, 5.848, 5.921, 5.995, 6.068, 6.142, 6.215, 6.289, 6.362, 6.436, 6.509, 6.583, 6.656, 6.73, 6.804, 6.877, 6.951, 7.024, 7.098, 7.171, 7.245, 7.318, 7.392, 7.465, 7.539, 7.612, 7.686, 7.76, 7.833, 7.907, 7.98, 8.054, 8.127, 8.201, 8.274, 8.348, 8.421, 8.495, 8.568, 8.642, 8.715, 8.789, 8.863, 8.936, 9.01, 9.083, 9.157, 9.23, 9.304, 9.377, 9.451, 9.524, 9.598, 9.671, 9.745, 9.819, 9.892, 9.966, 10.039, 10.113, 10.186, 10.26, 10.333, 10.407, 10.48, 10.554, 10.627, 10.701, 10.775, 10.848, 10.922, 10.995, 11.069, 11.142, 11.216, 11.289, 11.363, 11.436, 11.51, 11.583, 11.657, 11.73, 11.804, 11.878, 11.951, 12.025, 12.098, 12.172, 12.245, 12.319, 12.392, 12.466, 12.539, 12.613, 12.686, 12.76, 12.834, 12.907, 12.981, 13.054, 13.128, 13.201, 13.275, 13.348, 13.422, 13.495, 13.569, 13.642, 13.716, 13.79, 13.863, 13.937, 14.01, 14.084, 14.157, 14.231, 14.304, 14.378, 14.451, 14.525, 14.598, 14.672, 14.746, 14.819, 14.893, 14.966, 15.04, 15.113, 15.187, 15.26, 15.334, 15.407, 15.481, 15.554, 15.628, 15.701, 15.775, 15.849, 15.922, 15.996, 16.069, 16.143, 16.216, 16.29, 16.363, 16.437, 16.51, 16.584, 16.657, 16.731, 16.805, 16.878, 16.952, 17.025, 17.099, 17.172, 17.246, 17.319, 17.393, 17.466, 17.54, 17.53990615, -4.521, -4.448, -4.374, -4.301, -4.227, -4.153, -4.08, -4.006, -3.933, -3.859, -3.786, -3.712, -3.639, -3.565, -3.492, -3.418, -3.345, -3.271, -3.197, -3.124, -3.05, -2.977, -2.903, -2.83, -2.756, -2.683, -2.609, -2.536, -2.462, -2.389, -2.315, -2.242, -2.168, -2.094, -2.021, -1.947, -1.874, -1.8, -1.727, -1.653, -1.58, -1.506, -1.433, -1.359, -1.286, -1.212, -1.138, -1.065, -0.991, -0.918, -0.844, -0.771, -0.697, -0.624, -0.55, -0.477, -0.403, -0.33, -0.256, -0.182, -0.109, -0.035, 0.038, 0.112, 0.185, 0.259, 0.332, 0.406, 0.479, 0.553, 0.626, 0.7, 0.773, 0.847, 0.921, 0.994, 1.068, 1.141, 1.215, 1.288, 1.362, 1.435, 1.509, 1.582, 1.656, 1.729, 1.803, 1.877, 1.95, 2.024, 2.097, 2.171, 2.244, 2.318, 2.391, 2.465, 2.538, 2.612, 2.685, 2.759, 2.833, 2.906, 2.98, 3.053, 3.127, 3.2, 3.274, 3.347, 3.421, 3.494, 3.568, 3.641, 3.715, 3.789, 3.862, 3.936, 4.009, 4.083, 4.156, 4.23, 4.303, 4.377, 4.45, 4.524, 4.597, 4.671, 4.744, 4.818, 4.892, 4.965, 5.039, 5.112, 5.186, 5.259, 5.333, 5.406, 5.48, 5.553, 5.627, 5.7, 5.774, 5.848, 5.921, 5.995, 6.068, 6.142, 6.215, 6.289, 6.362, 6.436, 6.509, 6.583, 6.656, 6.73, 6.804, 6.877, 6.951, 7.024, 7.098, 7.171, 7.245, 7.318, 7.392, 7.465, 7.539, 7.612, 7.686, 7.76, 7.833, 7.907, 7.98, 8.054, 8.127, 8.201, 8.274, 8.348, 8.421, 8.495, 8.568, 8.642, 8.715, 8.789, 8.863, 8.936, 9.01, 9.083, 9.157, 9.23, 9.304, 9.377, 9.451, 9.524, 9.598, 9.671, 9.745, 9.819, 9.892, 9.966, 10.039, 10.113, 10.186, 10.26, 10.333, 10.407, 10.48, 10.554, 10.627, 10.701, 10.775, 10.848, 10.922, 10.995, 11.069, 11.142, 11.216, 11.289, 11.363, 11.436, 11.51, 11.583, 11.657, 11.73, 11.804, 11.878, 11.951, 12.025, 12.098, 12.172, 12.245, 12.319, 12.392, 12.466, 12.539, 12.613, 12.686, 12.76, 12.834, 12.907, 12.981, 13.054, 13.128, 13.201, 13.275, 13.348, 13.422, 13.495, 13.569, 13.642, 13.716, 13.79, 13.863, 13.937, 14.01, 14.084, 14.157, 14.231, 14.304, 14.378, 14.451, 14.525, 14.598, 14.672, 14.746, 14.819, 14.893, 14.966, 15.04, 15.113, 15.187, 15.26, 15.334, 15.407, 15.481, 15.554, 15.628, 15.701, 15.775, 15.849, 15.922, 15.996, 16.069, 16.143, 16.216, 16.29, 16.363, 16.437, 16.51, 16.584, 16.657, 16.731, 16.805, 16.878, 16.952, 17.025, 17.099, 17.172, 17.246, 17.319, 17.393, 17.466, 17.54, 17.53990615, -4.521, -4.448, -4.374, -4.301, -4.227, -4.153, -4.08, -4.006, -3.933, -3.859, -3.786, -3.712, -3.639, -3.565, -3.492, -3.418, -3.345, -3.271, -3.197, -3.124, -3.05, -2.977, -2.903, -2.83, -2.756, -2.683, -2.609, -2.536, -2.462, -2.389, -2.315, -2.242, -2.168, -2.094, -2.021, -1.947, -1.874, -1.8, -1.727, -1.653, -1.58, -1.506, -1.433, -1.359, -1.286, -1.212, -1.138, -1.065, -0.991, -0.918, -0.844, -0.771, -0.697, -0.624, -0.55, -0.477, -0.403, -0.33, -0.256, -0.182, -0.109, -0.035, 0.038, 0.112, 0.185, 0.259, 0.332, 0.406, 0.479, 0.553, 0.626, 0.7, 0.773, 0.847, 0.921, 0.994, 1.068, 1.141, 1.215, 1.288, 1.362, 1.435, 1.509, 1.582, 1.656, 1.729, 1.803, 1.877, 1.95, 2.024, 2.097, 2.171, 2.244, 2.318, 2.391, 2.465, 2.538, 2.612, 2.685, 2.759, 2.833, 2.906, 2.98, 3.053, 3.127, 3.2, 3.274, 3.347, 3.421, 3.494, 3.568, 3.641, 3.715, 3.789, 3.862, 3.936, 4.009, 4.083, 4.156, 4.23, 4.303, 4.377, 4.45, 4.524, 4.597, 4.671, 4.744, 4.818, 4.892, 4.965, 5.039, 5.112, 5.186, 5.259, 5.333, 5.406, 5.48, 5.553, 5.627, 5.7, 5.774, 5.848, 5.921, 5.995, 6.068, 6.142, 6.215, 6.289, 6.362, 6.436, 6.509, 6.583, 6.656, 6.73, 6.804, 6.877, 6.951, 7.024, 7.098, 7.171, 7.245, 7.318, 7.392, 7.465, 7.539, 7.612, 7.686, 7.76, 7.833, 7.907, 7.98, 8.054, 8.127, 8.201, 8.274, 8.348, 8.421, 8.495, 8.568, 8.642, 8.715, 8.789, 8.863, 8.936, 9.01, 9.083, 9.157, 9.23, 9.304, 9.377, 9.451, 9.524, 9.598, 9.671, 9.745, 9.819, 9.892, 9.966, 10.039, 10.113, 10.186, 10.26, 10.333, 10.407, 10.48, 10.554, 10.627, 10.701, 10.775, 10.848, 10.922, 10.995, 11.069, 11.142, 11.216, 11.289, 11.363, 11.436, 11.51, 11.583, 11.657, 11.73, 11.804, 11.878, 11.951, 12.025, 12.098, 12.172, 12.245, 12.319, 12.392, 12.466, 12.539, 12.613, 12.686, 12.76, 12.834, 12.907, 12.981, 13.054, 13.128, 13.201, 13.275, 13.348, 13.422, 13.495, 13.569, 13.642, 13.716, 13.79, 13.863, 13.937, 14.01, 14.084, 14.157, 14.231, 14.304, 14.378, 14.451, 14.525, 14.598, 14.672, 14.746, 14.819, 14.893, 14.966, 15.04, 15.113, 15.187, 15.26, 15.334, 15.407, 15.481, 15.554, 15.628, 15.701, 15.775, 15.849, 15.922, 15.996, 16.069, 16.143, 16.216, 16.29, 16.363, 16.437, 16.51, 16.584, 16.657, 16.731, 16.805, 16.878, 16.952, 17.025, 17.099, 17.172, 17.246, 17.319, 17.393, 17.466, 17.54, 17.53990615, -4.521, -4.448, -4.374, -4.301, -4.227, -4.153, -4.08, -4.006, -3.933, -3.859, -3.786, -3.712, -3.639, -3.565, -3.492, -3.418, -3.345, -3.271, -3.197, -3.124, -3.05, -2.977, -2.903, -2.83, -2.756, -2.683, -2.609, -2.536, -2.462, -2.389, -2.315, -2.242, -2.168, -2.094, -2.021, -1.947, -1.874, -1.8, -1.727, -1.653, -1.58, -1.506, -1.433, -1.359, -1.286, -1.212, -1.138, -1.065, -0.991, -0.918, -0.844, -0.771, -0.697, -0.624, -0.55, -0.477, -0.403, -0.33, -0.256, -0.182, -0.109, -0.035, 0.038, 0.112, 0.185, 0.259, 0.332, 0.406, 0.479, 0.553, 0.626, 0.7, 0.773, 0.847, 0.921, 0.994, 1.068, 1.141, 1.215, 1.288, 1.362, 1.435, 1.509, 1.582, 1.656, 1.729, 1.803, 1.877, 1.95, 2.024, 2.097, 2.171, 2.244, 2.318, 2.391, 2.465, 2.538, 2.612, 2.685, 2.759, 2.833, 2.906, 2.98, 3.053, 3.127, 3.2, 3.274, 3.347, 3.421, 3.494, 3.568, 3.641, 3.715, 3.789, 3.862, 3.936, 4.009, 4.083, 4.156, 4.23, 4.303, 4.377, 4.45, 4.524, 4.597, 4.671, 4.744, 4.818, 4.892, 4.965, 5.039, 5.112, 5.186, 5.259, 5.333, 5.406, 5.48, 5.553, 5.627, 5.7, 5.774, 5.848, 5.921, 5.995, 6.068, 6.142, 6.215, 6.289, 6.362, 6.436, 6.509, 6.583, 6.656, 6.73, 6.804, 6.877, 6.951, 7.024, 7.098, 7.171, 7.245, 7.318, 7.392, 7.465, 7.539, 7.612, 7.686, 7.76, 7.833, 7.907, 7.98, 8.054, 8.127, 8.201, 8.274, 8.348, 8.421, 8.495, 8.568, 8.642, 8.715, 8.789, 8.863, 8.936, 9.01, 9.083, 9.157, 9.23, 9.304, 9.377, 9.451, 9.524, 9.598, 9.671, 9.745, 9.819, 9.892, 9.966, 10.039, 10.113, 10.186, 10.26, 10.333, 10.407, 10.48, 10.554, 10.627, 10.701, 10.775, 10.848, 10.922, 10.995, 11.069, 11.142, 11.216, 11.289, 11.363, 11.436, 11.51, 11.583, 11.657, 11.73, 11.804, 11.878, 11.951, 12.025, 12.098, 12.172, 12.245, 12.319, 12.392, 12.466, 12.539, 12.613, 12.686, 12.76, 12.834, 12.907, 12.981, 13.054, 13.128, 13.201, 13.275, 13.348, 13.422, 13.495, 13.569, 13.642, 13.716, 13.79, 13.863, 13.937, 14.01, 14.084, 14.157, 14.231, 14.304, 14.378, 14.451, 14.525, 14.598, 14.672, 14.746, 14.819, 14.893, 14.966, 15.04, 15.113, 15.187, 15.26, 15.334, 15.407, 15.481, 15.554, 15.628, 15.701, 15.775, 15.849, 15.922, 15.996, 16.069, 16.143, 16.216, 16.29, 16.363, 16.437, 16.51, 16.584, 16.657, 16.731, 16.805, 16.878, 16.952, 17.025, 17.099, 17.172, 17.246, 17.319, 17.393, 17.466, 17.54], [-4.587, -4.515, -4.443, -4.371, -4.299, -4.227, -4.155, -4.083, -4.011, -3.939, -3.867, -3.795, -3.723, -3.65, -3.578, -3.506, -3.434, -3.362, -3.29, -3.218, -3.146, -3.074, -3.002, -2.93, -2.858, -2.786, -2.714, -2.642, -2.57, -2.498, -2.425, -2.353, -2.281, -2.209, -2.137, -2.065, -1.993, -1.921, -1.849, -1.777, -1.705, -1.633, -1.561, -1.489, -1.417, -1.345, -1.273, -1.2, -1.128, -1.056, -0.984, -0.912, -0.84, -0.768, -0.696, -0.624, -0.552, -0.48, -0.408, -0.336, -0.264, -0.192, -0.12, -0.047, 0.025, 0.097, 0.169, 0.241, 0.313, 0.385, 0.457, 0.529, 0.601, 0.673, 0.745, 0.817, 0.889, 0.961, 1.033, 1.105, 1.178, 1.25, 1.322, 1.394, 1.466, 1.538, 1.61, 1.682, 1.754, 1.826, 1.898, 1.97, 2.042, 2.114, 2.186, 2.258, 2.33, 2.403, 2.475, 2.547, 2.619, 2.691, 2.763, 2.835, 2.907, 2.979, 3.051, 3.123, 3.195, 3.267, 3.339, 3.411, 3.483, 3.555, 3.628, 3.7, 3.772, 3.844, 3.916, 3.988, 4.06, 4.132, 4.204, 4.276, 4.348, 4.42, 4.492, 4.564, 4.636, 4.708, 4.78, 4.853, 4.925, 4.997, 5.069, 5.141, 5.213, 5.285, 5.357, 5.429, 5.501, 5.573, 5.645, 5.717, 5.789, 5.861, 5.933, 6.006, 6.078, 6.15, 6.222, 6.294, 6.366, 6.438, 6.51, 6.582, 6.654, 6.726, 6.798, 6.87, 6.942, 7.014, 7.086, 7.158, 7.231, 7.303, 7.375, 7.447, 7.519, 7.591, 7.663, 7.735, 7.807, 7.879, 7.951, 8.023, 8.095, 8.167, 8.239, 8.311, 8.383, 8.456, 8.528, 8.6, 8.672, 8.744, 8.816, 8.888, 8.96, 9.032, 9.104, 9.176, 9.248, 9.32, 9.392, 9.464, 9.536, 9.608, 9.681, 9.753, 9.825, 9.897, 9.969, 10.041, 10.113, 10.185, 10.257, 10.329, 10.401, 10.473, 10.545, 10.617, 10.689, 10.761, 10.833, 10.906, 10.978, 11.05, 11.122, 11.194, 11.266, 11.338, 11.41, 11.482, 11.554, 11.626, 11.698, 11.77, 11.842, 11.914, 11.986, 12.059, 12.131, 12.203, 12.275, 12.347, 12.419, 12.491, 12.563, 12.635, 12.707, 12.779, 12.851, 12.923, 12.995, 13.067, 13.139, 13.211, 13.284, 13.356, 13.428, 13.5, 13.572, 13.644, 13.716, 13.788, 13.86, 13.932, 14.004, 14.076, 14.148, 14.22, 14.292, 14.364, 14.436, 14.509, 14.581, 14.653, 14.725, 14.797, 14.869, 14.941, 15.013, 15.085, 15.157, 15.229, 15.301, 15.373, 15.445, 15.517, 15.589, 15.661, 15.734, 15.806, 15.878, 15.95, 16.022, 16.094, 16.166, 16.238, 16.31, 16.382, 16.454, 16.526, 16.598, 16.67, 16.742, 16.814, 16.886, 16.959, 17.031, 17.03060885, -4.587, -4.515, -4.443, -4.371, -4.299, -4.227, -4.155, -4.083, -4.011, -3.939, -3.867, -3.795, -3.723, -3.65, -3.578, -3.506, -3.434, -3.362, -3.29, -3.218, -3.146, -3.074, -3.002, -2.93, -2.858, -2.786, -2.714, -2.642, -2.57, -2.498, -2.425, -2.353, -2.281, -2.209, -2.137, -2.065, -1.993, -1.921, -1.849, -1.777, -1.705, -1.633, -1.561, -1.489, -1.417, -1.345, -1.273, -1.2, -1.128, -1.056, -0.984, -0.912, -0.84, -0.768, -0.696, -0.624, -0.552, -0.48, -0.408, -0.336, -0.264, -0.192, -0.12, -0.047, 0.025, 0.097, 0.169, 0.241, 0.313, 0.385, 0.457, 0.529, 0.601, 0.673, 0.745, 0.817, 0.889, 0.961, 1.033, 1.105, 1.178, 1.25, 1.322, 1.394, 1.466, 1.538, 1.61, 1.682, 1.754, 1.826, 1.898, 1.97, 2.042, 2.114, 2.186, 2.258, 2.33, 2.403, 2.475, 2.547, 2.619, 2.691, 2.763, 2.835, 2.907, 2.979, 3.051, 3.123, 3.195, 3.267, 3.339, 3.411, 3.483, 3.555, 3.628, 3.7, 3.772, 3.844, 3.916, 3.988, 4.06, 4.132, 4.204, 4.276, 4.348, 4.42, 4.492, 4.564, 4.636, 4.708, 4.78, 4.853, 4.925, 4.997, 5.069, 5.141, 5.213, 5.285, 5.357, 5.429, 5.501, 5.573, 5.645, 5.717, 5.789, 5.861, 5.933, 6.006, 6.078, 6.15, 6.222, 6.294, 6.366, 6.438, 6.51, 6.582, 6.654, 6.726, 6.798, 6.87, 6.942, 7.014, 7.086, 7.158, 7.231, 7.303, 7.375, 7.447, 7.519, 7.591, 7.663, 7.735, 7.807, 7.879, 7.951, 8.023, 8.095, 8.167, 8.239, 8.311, 8.383, 8.456, 8.528, 8.6, 8.672, 8.744, 8.816, 8.888, 8.96, 9.032, 9.104, 9.176, 9.248, 9.32, 9.392, 9.464, 9.536, 9.608, 9.681, 9.753, 9.825, 9.897, 9.969, 10.041, 10.113, 10.185, 10.257, 10.329, 10.401, 10.473, 10.545, 10.617, 10.689, 10.761, 10.833, 10.906, 10.978, 11.05, 11.122, 11.194, 11.266, 11.338, 11.41, 11.482, 11.554, 11.626, 11.698, 11.77, 11.842, 11.914, 11.986, 12.059, 12.131, 12.203, 12.275, 12.347, 12.419, 12.491, 12.563, 12.635, 12.707, 12.779, 12.851, 12.923, 12.995, 13.067, 13.139, 13.211, 13.284, 13.356, 13.428, 13.5, 13.572, 13.644, 13.716, 13.788, 13.86, 13.932, 14.004, 14.076, 14.148, 14.22, 14.292, 14.364, 14.436, 14.509, 14.581, 14.653, 14.725, 14.797, 14.869, 14.941, 15.013, 15.085, 15.157, 15.229, 15.301, 15.373, 15.445, 15.517, 15.589, 15.661, 15.734, 15.806, 15.878, 15.95, 16.022, 16.094, 16.166, 16.238, 16.31, 16.382, 16.454, 16.526, 16.598, 16.67, 16.742, 16.814, 16.886, 16.959, 17.031, 17.03060885, -4.587, -4.515, -4.443, -4.371, -4.299, -4.227, -4.155, -4.083, -4.011, -3.939, -3.867, -3.795, -3.723, -3.65, -3.578, -3.506, -3.434, -3.362, -3.29, -3.218, -3.146, -3.074, -3.002, -2.93, -2.858, -2.786, -2.714, -2.642, -2.57, -2.498, -2.425, -2.353, -2.281, -2.209, -2.137, -2.065, -1.993, -1.921, -1.849, -1.777, -1.705, -1.633, -1.561, -1.489, -1.417, -1.345, -1.273, -1.2, -1.128, -1.056, -0.984, -0.912, -0.84, -0.768, -0.696, -0.624, -0.552, -0.48, -0.408, -0.336, -0.264, -0.192, -0.12, -0.047, 0.025, 0.097, 0.169, 0.241, 0.313, 0.385, 0.457, 0.529, 0.601, 0.673, 0.745, 0.817, 0.889, 0.961, 1.033, 1.105, 1.178, 1.25, 1.322, 1.394, 1.466, 1.538, 1.61, 1.682, 1.754, 1.826, 1.898, 1.97, 2.042, 2.114, 2.186, 2.258, 2.33, 2.403, 2.475, 2.547, 2.619, 2.691, 2.763, 2.835, 2.907, 2.979, 3.051, 3.123, 3.195, 3.267, 3.339, 3.411, 3.483, 3.555, 3.628, 3.7, 3.772, 3.844, 3.916, 3.988, 4.06, 4.132, 4.204, 4.276, 4.348, 4.42, 4.492, 4.564, 4.636, 4.708, 4.78, 4.853, 4.925, 4.997, 5.069, 5.141, 5.213, 5.285, 5.357, 5.429, 5.501, 5.573, 5.645, 5.717, 5.789, 5.861, 5.933, 6.006, 6.078, 6.15, 6.222, 6.294, 6.366, 6.438, 6.51, 6.582, 6.654, 6.726, 6.798, 6.87, 6.942, 7.014, 7.086, 7.158, 7.231, 7.303, 7.375, 7.447, 7.519, 7.591, 7.663, 7.735, 7.807, 7.879, 7.951, 8.023, 8.095, 8.167, 8.239, 8.311, 8.383, 8.456, 8.528, 8.6, 8.672, 8.744, 8.816, 8.888, 8.96, 9.032, 9.104, 9.176, 9.248, 9.32, 9.392, 9.464, 9.536, 9.608, 9.681, 9.753, 9.825, 9.897, 9.969, 10.041, 10.113, 10.185, 10.257, 10.329, 10.401, 10.473, 10.545, 10.617, 10.689, 10.761, 10.833, 10.906, 10.978, 11.05, 11.122, 11.194, 11.266, 11.338, 11.41, 11.482, 11.554, 11.626, 11.698, 11.77, 11.842, 11.914, 11.986, 12.059, 12.131, 12.203, 12.275, 12.347, 12.419, 12.491, 12.563, 12.635, 12.707, 12.779, 12.851, 12.923, 12.995, 13.067, 13.139, 13.211, 13.284, 13.356, 13.428, 13.5, 13.572, 13.644, 13.716, 13.788, 13.86, 13.932, 14.004, 14.076, 14.148, 14.22, 14.292, 14.364, 14.436, 14.509, 14.581, 14.653, 14.725, 14.797, 14.869, 14.941, 15.013, 15.085, 15.157, 15.229, 15.301, 15.373, 15.445, 15.517, 15.589, 15.661, 15.734, 15.806, 15.878, 15.95, 16.022, 16.094, 16.166, 16.238, 16.31, 16.382, 16.454, 16.526, 16.598, 16.67, 16.742, 16.814, 16.886, 16.959, 17.031, 17.03060885, -4.587, -4.515, -4.443, -4.371, -4.299, -4.227, -4.155, -4.083, -4.011, -3.939, -3.867, -3.795, -3.723, -3.65, -3.578, -3.506, -3.434, -3.362, -3.29, -3.218, -3.146, -3.074, -3.002, -2.93, -2.858, -2.786, -2.714, -2.642, -2.57, -2.498, -2.425, -2.353, -2.281, -2.209, -2.137, -2.065, -1.993, -1.921, -1.849, -1.777, -1.705, -1.633, -1.561, -1.489, -1.417, -1.345, -1.273, -1.2, -1.128, -1.056, -0.984, -0.912, -0.84, -0.768, -0.696, -0.624, -0.552, -0.48, -0.408, -0.336, -0.264, -0.192, -0.12, -0.047, 0.025, 0.097, 0.169, 0.241, 0.313, 0.385, 0.457, 0.529, 0.601, 0.673, 0.745, 0.817, 0.889, 0.961, 1.033, 1.105, 1.178, 1.25, 1.322, 1.394, 1.466, 1.538, 1.61, 1.682, 1.754, 1.826, 1.898, 1.97, 2.042, 2.114, 2.186, 2.258, 2.33, 2.403, 2.475, 2.547, 2.619, 2.691, 2.763, 2.835, 2.907, 2.979, 3.051, 3.123, 3.195, 3.267, 3.339, 3.411, 3.483, 3.555, 3.628, 3.7, 3.772, 3.844, 3.916, 3.988, 4.06, 4.132, 4.204, 4.276, 4.348, 4.42, 4.492, 4.564, 4.636, 4.708, 4.78, 4.853, 4.925, 4.997, 5.069, 5.141, 5.213, 5.285, 5.357, 5.429, 5.501, 5.573, 5.645, 5.717, 5.789, 5.861, 5.933, 6.006, 6.078, 6.15, 6.222, 6.294, 6.366, 6.438, 6.51, 6.582, 6.654, 6.726, 6.798, 6.87, 6.942, 7.014, 7.086, 7.158, 7.231, 7.303, 7.375, 7.447, 7.519, 7.591, 7.663, 7.735, 7.807, 7.879, 7.951, 8.023, 8.095, 8.167, 8.239, 8.311, 8.383, 8.456, 8.528, 8.6, 8.672, 8.744, 8.816, 8.888, 8.96, 9.032, 9.104, 9.176, 9.248, 9.32, 9.392, 9.464, 9.536, 9.608, 9.681, 9.753, 9.825, 9.897, 9.969, 10.041, 10.113, 10.185, 10.257, 10.329, 10.401, 10.473, 10.545, 10.617, 10.689, 10.761, 10.833, 10.906, 10.978, 11.05, 11.122, 11.194, 11.266, 11.338, 11.41, 11.482, 11.554, 11.626, 11.698, 11.77, 11.842, 11.914, 11.986, 12.059, 12.131, 12.203, 12.275, 12.347, 12.419, 12.491, 12.563, 12.635, 12.707, 12.779, 12.851, 12.923, 12.995, 13.067, 13.139, 13.211, 13.284, 13.356, 13.428, 13.5, 13.572, 13.644, 13.716, 13.788, 13.86, 13.932, 14.004, 14.076, 14.148, 14.22, 14.292, 14.364, 14.436, 14.509, 14.581, 14.653, 14.725, 14.797, 14.869, 14.941, 15.013, 15.085, 15.157, 15.229, 15.301, 15.373, 15.445, 15.517, 15.589, 15.661, 15.734, 15.806, 15.878, 15.95, 16.022, 16.094, 16.166, 16.238, 16.31, 16.382, 16.454, 16.526, 16.598, 16.67, 16.742, 16.814, 16.886, 16.959, 17.031, 17.03060885, -4.587, -4.515, -4.443, -4.371, -4.299, -4.227, -4.155, -4.083, -4.011, -3.939, -3.867, -3.795, -3.723, -3.65, -3.578, -3.506, -3.434, -3.362, -3.29, -3.218, -3.146, -3.074, -3.002, -2.93, -2.858, -2.786, -2.714, -2.642, -2.57, -2.498, -2.425, -2.353, -2.281, -2.209, -2.137, -2.065, -1.993, -1.921, -1.849, -1.777, -1.705, -1.633, -1.561, -1.489, -1.417, -1.345, -1.273, -1.2, -1.128, -1.056, -0.984, -0.912, -0.84, -0.768, -0.696, -0.624, -0.552, -0.48, -0.408, -0.336, -0.264, -0.192, -0.12, -0.047, 0.025, 0.097, 0.169, 0.241, 0.313, 0.385, 0.457, 0.529, 0.601, 0.673, 0.745, 0.817, 0.889, 0.961, 1.033, 1.105, 1.178, 1.25, 1.322, 1.394, 1.466, 1.538, 1.61, 1.682, 1.754, 1.826, 1.898, 1.97, 2.042, 2.114, 2.186, 2.258, 2.33, 2.403, 2.475, 2.547, 2.619, 2.691, 2.763, 2.835, 2.907, 2.979, 3.051, 3.123, 3.195, 3.267, 3.339, 3.411, 3.483, 3.555, 3.628, 3.7, 3.772, 3.844, 3.916, 3.988, 4.06, 4.132, 4.204, 4.276, 4.348, 4.42, 4.492, 4.564, 4.636, 4.708, 4.78, 4.853, 4.925, 4.997, 5.069, 5.141, 5.213, 5.285, 5.357, 5.429, 5.501, 5.573, 5.645, 5.717, 5.789, 5.861, 5.933, 6.006, 6.078, 6.15, 6.222, 6.294, 6.366, 6.438, 6.51, 6.582, 6.654, 6.726, 6.798, 6.87, 6.942, 7.014, 7.086, 7.158, 7.231, 7.303, 7.375, 7.447, 7.519, 7.591, 7.663, 7.735, 7.807, 7.879, 7.951, 8.023, 8.095, 8.167, 8.239, 8.311, 8.383, 8.456, 8.528, 8.6, 8.672, 8.744, 8.816, 8.888, 8.96, 9.032, 9.104, 9.176, 9.248, 9.32, 9.392, 9.464, 9.536, 9.608, 9.681, 9.753, 9.825, 9.897, 9.969, 10.041, 10.113, 10.185, 10.257, 10.329, 10.401, 10.473, 10.545, 10.617, 10.689, 10.761, 10.833, 10.906, 10.978, 11.05, 11.122, 11.194, 11.266, 11.338, 11.41, 11.482, 11.554, 11.626, 11.698, 11.77, 11.842, 11.914, 11.986, 12.059, 12.131, 12.203, 12.275, 12.347, 12.419, 12.491, 12.563, 12.635, 12.707, 12.779, 12.851, 12.923, 12.995, 13.067, 13.139, 13.211, 13.284, 13.356, 13.428, 13.5, 13.572, 13.644, 13.716, 13.788, 13.86, 13.932, 14.004, 14.076, 14.148, 14.22, 14.292, 14.364, 14.436, 14.509, 14.581, 14.653, 14.725, 14.797, 14.869, 14.941, 15.013, 15.085, 15.157, 15.229, 15.301, 15.373, 15.445, 15.517, 15.589, 15.661, 15.734, 15.806, 15.878, 15.95, 16.022, 16.094, 16.166, 16.238, 16.31, 16.382, 16.454, 16.526, 16.598, 16.67, 16.742, 16.814, 16.886, 16.959, 17.031], [-4.65, -4.579, -4.509, -4.438, -4.368, -4.297, -4.226, -4.156, -4.085, -4.015, -3.944, -3.873, -3.803, -3.732, -3.661, -3.591, -3.52, -3.45, -3.379, -3.308, -3.238, -3.167, -3.097, -3.026, -2.955, -2.885, -2.814, -2.744, -2.673, -2.602, -2.532, -2.461, -2.391, -2.32, -2.249, -2.179, -2.108, -2.037, -1.967, -1.896, -1.826, -1.755, -1.684, -1.614, -1.543, -1.473, -1.402, -1.331, -1.261, -1.19, -1.12, -1.049, -0.978, -0.908, -0.837, -0.766, -0.696, -0.625, -0.555, -0.484, -0.413, -0.343, -0.272, -0.202, -0.131, -0.06, 0.01, 0.081, 0.151, 0.222, 0.293, 0.363, 0.434, 0.504, 0.575, 0.646, 0.716, 0.787, 0.858, 0.928, 0.999, 1.069, 1.14, 1.211, 1.281, 1.352, 1.422, 1.493, 1.564, 1.634, 1.705, 1.775, 1.846, 1.917, 1.987, 2.058, 2.129, 2.199, 2.27, 2.34, 2.411, 2.482, 2.552, 2.623, 2.693, 2.764, 2.835, 2.905, 2.976, 3.046, 3.117, 3.188, 3.258, 3.329, 3.4, 3.47, 3.541, 3.611, 3.682, 3.753, 3.823, 3.894, 3.964, 4.035, 4.106, 4.176, 4.247, 4.317, 4.388, 4.459, 4.529, 4.6, 4.67, 4.741, 4.812, 4.882, 4.953, 5.024, 5.094, 5.165, 5.235, 5.306, 5.377, 5.447, 5.518, 5.588, 5.659, 5.73, 5.8, 5.871, 5.941, 6.012, 6.083, 6.153, 6.224, 6.295, 6.365, 6.436, 6.506, 6.577, 6.648, 6.718, 6.789, 6.859, 6.93, 7.001, 7.071, 7.142, 7.212, 7.283, 7.354, 7.424, 7.495, 7.565, 7.636, 7.707, 7.777, 7.848, 7.919, 7.989, 8.06, 8.13, 8.201, 8.272, 8.342, 8.413, 8.483, 8.554, 8.625, 8.695, 8.766, 8.836, 8.907, 8.978, 9.048, 9.119, 9.19, 9.26, 9.331, 9.401, 9.472, 9.543, 9.613, 9.684, 9.754, 9.825, 9.896, 9.966, 10.037, 10.107, 10.178, 10.249, 10.319, 10.39, 10.461, 10.531, 10.602, 10.672, 10.743, 10.814, 10.884, 10.955, 11.025, 11.096, 11.167, 11.237, 11.308, 11.378, 11.449, 11.52, 11.59, 11.661, 11.731, 11.802, 11.873, 11.943, 12.014, 12.085, 12.155, 12.226, 12.296, 12.367, 12.438, 12.508, 12.579, 12.649, 12.72, 12.791, 12.861, 12.932, 13.002, 13.073, 13.144, 13.214, 13.285, 13.356, 13.426, 13.497, 13.567, 13.638, 13.709, 13.779, 13.85, 13.92, 13.991, 14.062, 14.132, 14.203, 14.273, 14.344, 14.415, 14.485, 14.556, 14.627, 14.697, 14.768, 14.838, 14.909, 14.98, 15.05, 15.121, 15.191, 15.262, 15.333, 15.403, 15.474, 15.544, 15.615, 15.686, 15.756, 15.827, 15.897, 15.968, 16.039, 16.109, 16.18, 16.251, 16.321, 16.392, 16.462, 16.533, 16.53297296, -4.65, -4.579, -4.509, -4.438, -4.368, -4.297, -4.226, -4.156, -4.085, -4.015, -3.944, -3.873, -3.803, -3.732, -3.661, -3.591, -3.52, -3.45, -3.379, -3.308, -3.238, -3.167, -3.097, -3.026, -2.955, -2.885, -2.814, -2.744, -2.673, -2.602, -2.532, -2.461, -2.391, -2.32, -2.249, -2.179, -2.108, -2.037, -1.967, -1.896, -1.826, -1.755, -1.684, -1.614, -1.543, -1.473, -1.402, -1.331, -1.261, -1.19, -1.12, -1.049, -0.978, -0.908, -0.837, -0.766, -0.696, -0.625, -0.555, -0.484, -0.413, -0.343, -0.272, -0.202, -0.131, -0.06, 0.01, 0.081, 0.151, 0.222, 0.293, 0.363, 0.434, 0.504, 0.575, 0.646, 0.716, 0.787, 0.858, 0.928, 0.999, 1.069, 1.14, 1.211, 1.281, 1.352, 1.422, 1.493, 1.564, 1.634, 1.705, 1.775, 1.846, 1.917, 1.987, 2.058, 2.129, 2.199, 2.27, 2.34, 2.411, 2.482, 2.552, 2.623, 2.693, 2.764, 2.835, 2.905, 2.976, 3.046, 3.117, 3.188, 3.258, 3.329, 3.4, 3.47, 3.541, 3.611, 3.682, 3.753, 3.823, 3.894, 3.964, 4.035, 4.106, 4.176, 4.247, 4.317, 4.388, 4.459, 4.529, 4.6, 4.67, 4.741, 4.812, 4.882, 4.953, 5.024, 5.094, 5.165, 5.235, 5.306, 5.377, 5.447, 5.518, 5.588, 5.659, 5.73, 5.8, 5.871, 5.941, 6.012, 6.083, 6.153, 6.224, 6.295, 6.365, 6.436, 6.506, 6.577, 6.648, 6.718, 6.789, 6.859, 6.93, 7.001, 7.071, 7.142, 7.212, 7.283, 7.354, 7.424, 7.495, 7.565, 7.636, 7.707, 7.777, 7.848, 7.919, 7.989, 8.06, 8.13, 8.201, 8.272, 8.342, 8.413, 8.483, 8.554, 8.625, 8.695, 8.766, 8.836, 8.907, 8.978, 9.048, 9.119, 9.19, 9.26, 9.331, 9.401, 9.472, 9.543, 9.613, 9.684, 9.754, 9.825, 9.896, 9.966, 10.037, 10.107, 10.178, 10.249, 10.319, 10.39, 10.461, 10.531, 10.602, 10.672, 10.743, 10.814, 10.884, 10.955, 11.025, 11.096, 11.167, 11.237, 11.308, 11.378, 11.449, 11.52, 11.59, 11.661, 11.731, 11.802, 11.873, 11.943, 12.014, 12.085, 12.155, 12.226, 12.296, 12.367, 12.438, 12.508, 12.579, 12.649, 12.72, 12.791, 12.861, 12.932, 13.002, 13.073, 13.144, 13.214, 13.285, 13.356, 13.426, 13.497, 13.567, 13.638, 13.709, 13.779, 13.85, 13.92, 13.991, 14.062, 14.132, 14.203, 14.273, 14.344, 14.415, 14.485, 14.556, 14.627, 14.697, 14.768, 14.838, 14.909, 14.98, 15.05, 15.121, 15.191, 15.262, 15.333, 15.403, 15.474, 15.544, 15.615, 15.686, 15.756, 15.827, 15.897, 15.968, 16.039, 16.109, 16.18, 16.251, 16.321, 16.392, 16.462, 16.533, 16.53297296, -4.65, -4.579, -4.509, -4.438, -4.368, -4.297, -4.226, -4.156, -4.085, -4.015, -3.944, -3.873, -3.803, -3.732, -3.661, -3.591, -3.52, -3.45, -3.379, -3.308, -3.238, -3.167, -3.097, -3.026, -2.955, -2.885, -2.814, -2.744, -2.673, -2.602, -2.532, -2.461, -2.391, -2.32, -2.249, -2.179, -2.108, -2.037, -1.967, -1.896, -1.826, -1.755, -1.684, -1.614, -1.543, -1.473, -1.402, -1.331, -1.261, -1.19, -1.12, -1.049, -0.978, -0.908, -0.837, -0.766, -0.696, -0.625, -0.555, -0.484, -0.413, -0.343, -0.272, -0.202, -0.131, -0.06, 0.01, 0.081, 0.151, 0.222, 0.293, 0.363, 0.434, 0.504, 0.575, 0.646, 0.716, 0.787, 0.858, 0.928, 0.999, 1.069, 1.14, 1.211, 1.281, 1.352, 1.422, 1.493, 1.564, 1.634, 1.705, 1.775, 1.846, 1.917, 1.987, 2.058, 2.129, 2.199, 2.27, 2.34, 2.411, 2.482, 2.552, 2.623, 2.693, 2.764, 2.835, 2.905, 2.976, 3.046, 3.117, 3.188, 3.258, 3.329, 3.4, 3.47, 3.541, 3.611, 3.682, 3.753, 3.823, 3.894, 3.964, 4.035, 4.106, 4.176, 4.247, 4.317, 4.388, 4.459, 4.529, 4.6, 4.67, 4.741, 4.812, 4.882, 4.953, 5.024, 5.094, 5.165, 5.235, 5.306, 5.377, 5.447, 5.518, 5.588, 5.659, 5.73, 5.8, 5.871, 5.941, 6.012, 6.083, 6.153, 6.224, 6.295, 6.365, 6.436, 6.506, 6.577, 6.648, 6.718, 6.789, 6.859, 6.93, 7.001, 7.071, 7.142, 7.212, 7.283, 7.354, 7.424, 7.495, 7.565, 7.636, 7.707, 7.777, 7.848, 7.919, 7.989, 8.06, 8.13, 8.201, 8.272, 8.342, 8.413, 8.483, 8.554, 8.625, 8.695, 8.766, 8.836, 8.907, 8.978, 9.048, 9.119, 9.19, 9.26, 9.331, 9.401, 9.472, 9.543, 9.613, 9.684, 9.754, 9.825, 9.896, 9.966, 10.037, 10.107, 10.178, 10.249, 10.319, 10.39, 10.461, 10.531, 10.602, 10.672, 10.743, 10.814, 10.884, 10.955, 11.025, 11.096, 11.167, 11.237, 11.308, 11.378, 11.449, 11.52, 11.59, 11.661, 11.731, 11.802, 11.873, 11.943, 12.014, 12.085, 12.155, 12.226, 12.296, 12.367, 12.438, 12.508, 12.579, 12.649, 12.72, 12.791, 12.861, 12.932, 13.002, 13.073, 13.144, 13.214, 13.285, 13.356, 13.426, 13.497, 13.567, 13.638, 13.709, 13.779, 13.85, 13.92, 13.991, 14.062, 14.132, 14.203, 14.273, 14.344, 14.415, 14.485, 14.556, 14.627, 14.697, 14.768, 14.838, 14.909, 14.98, 15.05, 15.121, 15.191, 15.262, 15.333, 15.403, 15.474, 15.544, 15.615, 15.686, 15.756, 15.827, 15.897, 15.968, 16.039, 16.109, 16.18, 16.251, 16.321, 16.392, 16.462, 16.533, 16.53297296, -4.65, -4.579, -4.509, -4.438, -4.368, -4.297, -4.226, -4.156, -4.085, -4.015, -3.944, -3.873, -3.803, -3.732, -3.661, -3.591, -3.52, -3.45, -3.379, -3.308, -3.238, -3.167, -3.097, -3.026, -2.955, -2.885, -2.814, -2.744, -2.673, -2.602, -2.532, -2.461, -2.391, -2.32, -2.249, -2.179, -2.108, -2.037, -1.967, -1.896, -1.826, -1.755, -1.684, -1.614, -1.543, -1.473, -1.402, -1.331, -1.261, -1.19, -1.12, -1.049, -0.978, -0.908, -0.837, -0.766, -0.696, -0.625, -0.555, -0.484, -0.413, -0.343, -0.272, -0.202, -0.131, -0.06, 0.01, 0.081, 0.151, 0.222, 0.293, 0.363, 0.434, 0.504, 0.575, 0.646, 0.716, 0.787, 0.858, 0.928, 0.999, 1.069, 1.14, 1.211, 1.281, 1.352, 1.422, 1.493, 1.564, 1.634, 1.705, 1.775, 1.846, 1.917, 1.987, 2.058, 2.129, 2.199, 2.27, 2.34, 2.411, 2.482, 2.552, 2.623, 2.693, 2.764, 2.835, 2.905, 2.976, 3.046, 3.117, 3.188, 3.258, 3.329, 3.4, 3.47, 3.541, 3.611, 3.682, 3.753, 3.823, 3.894, 3.964, 4.035, 4.106, 4.176, 4.247, 4.317, 4.388, 4.459, 4.529, 4.6, 4.67, 4.741, 4.812, 4.882, 4.953, 5.024, 5.094, 5.165, 5.235, 5.306, 5.377, 5.447, 5.518, 5.588, 5.659, 5.73, 5.8, 5.871, 5.941, 6.012, 6.083, 6.153, 6.224, 6.295, 6.365, 6.436, 6.506, 6.577, 6.648, 6.718, 6.789, 6.859, 6.93, 7.001, 7.071, 7.142, 7.212, 7.283, 7.354, 7.424, 7.495, 7.565, 7.636, 7.707, 7.777, 7.848, 7.919, 7.989, 8.06, 8.13, 8.201, 8.272, 8.342, 8.413, 8.483, 8.554, 8.625, 8.695, 8.766, 8.836, 8.907, 8.978, 9.048, 9.119, 9.19, 9.26, 9.331, 9.401, 9.472, 9.543, 9.613, 9.684, 9.754, 9.825, 9.896, 9.966, 10.037, 10.107, 10.178, 10.249, 10.319, 10.39, 10.461, 10.531, 10.602, 10.672, 10.743, 10.814, 10.884, 10.955, 11.025, 11.096, 11.167, 11.237, 11.308, 11.378, 11.449, 11.52, 11.59, 11.661, 11.731, 11.802, 11.873, 11.943, 12.014, 12.085, 12.155, 12.226, 12.296, 12.367, 12.438, 12.508, 12.579, 12.649, 12.72, 12.791, 12.861, 12.932, 13.002, 13.073, 13.144, 13.214, 13.285, 13.356, 13.426, 13.497, 13.567, 13.638, 13.709, 13.779, 13.85, 13.92, 13.991, 14.062, 14.132, 14.203, 14.273, 14.344, 14.415, 14.485, 14.556, 14.627, 14.697, 14.768, 14.838, 14.909, 14.98, 15.05, 15.121, 15.191, 15.262, 15.333, 15.403, 15.474, 15.544, 15.615, 15.686, 15.756, 15.827, 15.897, 15.968, 16.039, 16.109, 16.18, 16.251, 16.321, 16.392, 16.462, 16.533, 16.53297296, -4.65, -4.579, -4.509, -4.438, -4.368, -4.297, -4.226, -4.156, -4.085, -4.015, -3.944, -3.873, -3.803, -3.732, -3.661, -3.591, -3.52, -3.45, -3.379, -3.308, -3.238, -3.167, -3.097, -3.026, -2.955, -2.885, -2.814, -2.744, -2.673, -2.602, -2.532, -2.461, -2.391, -2.32, -2.249, -2.179, -2.108, -2.037, -1.967, -1.896, -1.826, -1.755, -1.684, -1.614, -1.543, -1.473, -1.402, -1.331, -1.261, -1.19, -1.12, -1.049, -0.978, -0.908, -0.837, -0.766, -0.696, -0.625, -0.555, -0.484, -0.413, -0.343, -0.272, -0.202, -0.131, -0.06, 0.01, 0.081, 0.151, 0.222, 0.293, 0.363, 0.434, 0.504, 0.575, 0.646, 0.716, 0.787, 0.858, 0.928, 0.999, 1.069, 1.14, 1.211, 1.281, 1.352, 1.422, 1.493, 1.564, 1.634, 1.705, 1.775, 1.846, 1.917, 1.987, 2.058, 2.129, 2.199, 2.27, 2.34, 2.411, 2.482, 2.552, 2.623, 2.693, 2.764, 2.835, 2.905, 2.976, 3.046, 3.117, 3.188, 3.258, 3.329, 3.4, 3.47, 3.541, 3.611, 3.682, 3.753, 3.823, 3.894, 3.964, 4.035, 4.106, 4.176, 4.247, 4.317, 4.388, 4.459, 4.529, 4.6, 4.67, 4.741, 4.812, 4.882, 4.953, 5.024, 5.094, 5.165, 5.235, 5.306, 5.377, 5.447, 5.518, 5.588, 5.659, 5.73, 5.8, 5.871, 5.941, 6.012, 6.083, 6.153, 6.224, 6.295, 6.365, 6.436, 6.506, 6.577, 6.648, 6.718, 6.789, 6.859, 6.93, 7.001, 7.071, 7.142, 7.212, 7.283, 7.354, 7.424, 7.495, 7.565, 7.636, 7.707, 7.777, 7.848, 7.919, 7.989, 8.06, 8.13, 8.201, 8.272, 8.342, 8.413, 8.483, 8.554, 8.625, 8.695, 8.766, 8.836, 8.907, 8.978, 9.048, 9.119, 9.19, 9.26, 9.331, 9.401, 9.472, 9.543, 9.613, 9.684, 9.754, 9.825, 9.896, 9.966, 10.037, 10.107, 10.178, 10.249, 10.319, 10.39, 10.461, 10.531, 10.602, 10.672, 10.743, 10.814, 10.884, 10.955, 11.025, 11.096, 11.167, 11.237, 11.308, 11.378, 11.449, 11.52, 11.59, 11.661, 11.731, 11.802, 11.873, 11.943, 12.014, 12.085, 12.155, 12.226, 12.296, 12.367, 12.438, 12.508, 12.579, 12.649, 12.72, 12.791, 12.861, 12.932, 13.002, 13.073, 13.144, 13.214, 13.285, 13.356, 13.426, 13.497, 13.567, 13.638, 13.709, 13.779, 13.85, 13.92, 13.991, 14.062, 14.132, 14.203, 14.273, 14.344, 14.415, 14.485, 14.556, 14.627, 14.697, 14.768, 14.838, 14.909, 14.98, 15.05, 15.121, 15.191, 15.262, 15.333, 15.403, 15.474, 15.544, 15.615, 15.686, 15.756, 15.827, 15.897, 15.968, 16.039, 16.109, 16.18, 16.251, 16.321, 16.392, 16.462, 16.533], [-4.71, -4.64, -4.571, -4.502, -4.433, -4.364, -4.294, -4.225, -4.156, -4.087, -4.018, -3.949, -3.879, -3.81, -3.741, -3.672, -3.603, -3.533, -3.464, -3.395, -3.326, -3.257, -3.188, -3.118, -3.049, -2.98, -2.911, -2.842, -2.772, -2.703, -2.634, -2.565, -2.496, -2.426, -2.357, -2.288, -2.219, -2.15, -2.081, -2.011, -1.942, -1.873, -1.804, -1.735, -1.665, -1.596, -1.527, -1.458, -1.389, -1.32, -1.25, -1.181, -1.112, -1.043, -0.974, -0.904, -0.835, -0.766, -0.697, -0.628, -0.558, -0.489, -0.42, -0.351, -0.282, -0.213, -0.143, -0.074, -0.005, 0.064, 0.133, 0.203, 0.272, 0.341, 0.41, 0.479, 0.548, 0.618, 0.687, 0.756, 0.825, 0.894, 0.964, 1.033, 1.102, 1.171, 1.24, 1.31, 1.379, 1.448, 1.517, 1.586, 1.655, 1.725, 1.794, 1.863, 1.932, 2.001, 2.071, 2.14, 2.209, 2.278, 2.347, 2.416, 2.486, 2.555, 2.624, 2.693, 2.762, 2.832, 2.901, 2.97, 3.039, 3.108, 3.178, 3.247, 3.316, 3.385, 3.454, 3.523, 3.593, 3.662, 3.731, 3.8, 3.869, 3.939, 4.008, 4.077, 4.146, 4.215, 4.284, 4.354, 4.423, 4.492, 4.561, 4.63, 4.7, 4.769, 4.838, 4.907, 4.976, 5.046, 5.115, 5.184, 5.253, 5.322, 5.391, 5.461, 5.53, 5.599, 5.668, 5.737, 5.807, 5.876, 5.945, 6.014, 6.083, 6.152, 6.222, 6.291, 6.36, 6.429, 6.498, 6.568, 6.637, 6.706, 6.775, 6.844, 6.914, 6.983, 7.052, 7.121, 7.19, 7.259, 7.329, 7.398, 7.467, 7.536, 7.605, 7.675, 7.744, 7.813, 7.882, 7.951, 8.02, 8.09, 8.159, 8.228, 8.297, 8.366, 8.436, 8.505, 8.574, 8.643, 8.712, 8.782, 8.851, 8.92, 8.989, 9.058, 9.127, 9.197, 9.266, 9.335, 9.404, 9.473, 9.543, 9.612, 9.681, 9.75, 9.819, 9.888, 9.958, 10.027, 10.096, 10.165, 10.234, 10.304, 10.373, 10.442, 10.511, 10.58, 10.65, 10.719, 10.788, 10.857, 10.926, 10.995, 11.065, 11.134, 11.203, 11.272, 11.341, 11.411, 11.48, 11.549, 11.618, 11.687, 11.756, 11.826, 11.895, 11.964, 12.033, 12.102, 12.172, 12.241, 12.31, 12.379, 12.448, 12.518, 12.587, 12.656, 12.725, 12.794, 12.863, 12.933, 13.002, 13.071, 13.14, 13.209, 13.279, 13.348, 13.417, 13.486, 13.555, 13.624, 13.694, 13.763, 13.832, 13.901, 13.97, 14.04, 14.109, 14.178, 14.247, 14.316, 14.386, 14.455, 14.524, 14.593, 14.662, 14.731, 14.801, 14.87, 14.939, 15.008, 15.077, 15.147, 15.216, 15.285, 15.354, 15.423, 15.492, 15.562, 15.631, 15.7, 15.769, 15.838, 15.908, 15.977, 16.046, 16.04596769, -4.71, -4.64, -4.571, -4.502, -4.433, -4.364, -4.294, -4.225, -4.156, -4.087, -4.018, -3.949, -3.879, -3.81, -3.741, -3.672, -3.603, -3.533, -3.464, -3.395, -3.326, -3.257, -3.188, -3.118, -3.049, -2.98, -2.911, -2.842, -2.772, -2.703, -2.634, -2.565, -2.496, -2.426, -2.357, -2.288, -2.219, -2.15, -2.081, -2.011, -1.942, -1.873, -1.804, -1.735, -1.665, -1.596, -1.527, -1.458, -1.389, -1.32, -1.25, -1.181, -1.112, -1.043, -0.974, -0.904, -0.835, -0.766, -0.697, -0.628, -0.558, -0.489, -0.42, -0.351, -0.282, -0.213, -0.143, -0.074, -0.005, 0.064, 0.133, 0.203, 0.272, 0.341, 0.41, 0.479, 0.548, 0.618, 0.687, 0.756, 0.825, 0.894, 0.964, 1.033, 1.102, 1.171, 1.24, 1.31, 1.379, 1.448, 1.517, 1.586, 1.655, 1.725, 1.794, 1.863, 1.932, 2.001, 2.071, 2.14, 2.209, 2.278, 2.347, 2.416, 2.486, 2.555, 2.624, 2.693, 2.762, 2.832, 2.901, 2.97, 3.039, 3.108, 3.178, 3.247, 3.316, 3.385, 3.454, 3.523, 3.593, 3.662, 3.731, 3.8, 3.869, 3.939, 4.008, 4.077, 4.146, 4.215, 4.284, 4.354, 4.423, 4.492, 4.561, 4.63, 4.7, 4.769, 4.838, 4.907, 4.976, 5.046, 5.115, 5.184, 5.253, 5.322, 5.391, 5.461, 5.53, 5.599, 5.668, 5.737, 5.807, 5.876, 5.945, 6.014, 6.083, 6.152, 6.222, 6.291, 6.36, 6.429, 6.498, 6.568, 6.637, 6.706, 6.775, 6.844, 6.914, 6.983, 7.052, 7.121, 7.19, 7.259, 7.329, 7.398, 7.467, 7.536, 7.605, 7.675, 7.744, 7.813, 7.882, 7.951, 8.02, 8.09, 8.159, 8.228, 8.297, 8.366, 8.436, 8.505, 8.574, 8.643, 8.712, 8.782, 8.851, 8.92, 8.989, 9.058, 9.127, 9.197, 9.266, 9.335, 9.404, 9.473, 9.543, 9.612, 9.681, 9.75, 9.819, 9.888, 9.958, 10.027, 10.096, 10.165, 10.234, 10.304, 10.373, 10.442, 10.511, 10.58, 10.65, 10.719, 10.788, 10.857, 10.926, 10.995, 11.065, 11.134, 11.203, 11.272, 11.341, 11.411, 11.48, 11.549, 11.618, 11.687, 11.756, 11.826, 11.895, 11.964, 12.033, 12.102, 12.172, 12.241, 12.31, 12.379, 12.448, 12.518, 12.587, 12.656, 12.725, 12.794, 12.863, 12.933, 13.002, 13.071, 13.14, 13.209, 13.279, 13.348, 13.417, 13.486, 13.555, 13.624, 13.694, 13.763, 13.832, 13.901, 13.97, 14.04, 14.109, 14.178, 14.247, 14.316, 14.386, 14.455, 14.524, 14.593, 14.662, 14.731, 14.801, 14.87, 14.939, 15.008, 15.077, 15.147, 15.216, 15.285, 15.354, 15.423, 15.492, 15.562, 15.631, 15.7, 15.769, 15.838, 15.908, 15.977, 16.046, 16.04596769, -4.71, -4.64, -4.571, -4.502, -4.433, -4.364, -4.294, -4.225, -4.156, -4.087, -4.018, -3.949, -3.879, -3.81, -3.741, -3.672, -3.603, -3.533, -3.464, -3.395, -3.326, -3.257, -3.188, -3.118, -3.049, -2.98, -2.911, -2.842, -2.772, -2.703, -2.634, -2.565, -2.496, -2.426, -2.357, -2.288, -2.219, -2.15, -2.081, -2.011, -1.942, -1.873, -1.804, -1.735, -1.665, -1.596, -1.527, -1.458, -1.389, -1.32, -1.25, -1.181, -1.112, -1.043, -0.974, -0.904, -0.835, -0.766, -0.697, -0.628, -0.558, -0.489, -0.42, -0.351, -0.282, -0.213, -0.143, -0.074, -0.005, 0.064, 0.133, 0.203, 0.272, 0.341, 0.41, 0.479, 0.548, 0.618, 0.687, 0.756, 0.825, 0.894, 0.964, 1.033, 1.102, 1.171, 1.24, 1.31, 1.379, 1.448, 1.517, 1.586, 1.655, 1.725, 1.794, 1.863, 1.932, 2.001, 2.071, 2.14, 2.209, 2.278, 2.347, 2.416, 2.486, 2.555, 2.624, 2.693, 2.762, 2.832, 2.901, 2.97, 3.039, 3.108, 3.178, 3.247, 3.316, 3.385, 3.454, 3.523, 3.593, 3.662, 3.731, 3.8, 3.869, 3.939, 4.008, 4.077, 4.146, 4.215, 4.284, 4.354, 4.423, 4.492, 4.561, 4.63, 4.7, 4.769, 4.838, 4.907, 4.976, 5.046, 5.115, 5.184, 5.253, 5.322, 5.391, 5.461, 5.53, 5.599, 5.668, 5.737, 5.807, 5.876, 5.945, 6.014, 6.083, 6.152, 6.222, 6.291, 6.36, 6.429, 6.498, 6.568, 6.637, 6.706, 6.775, 6.844, 6.914, 6.983, 7.052, 7.121, 7.19, 7.259, 7.329, 7.398, 7.467, 7.536, 7.605, 7.675, 7.744, 7.813, 7.882, 7.951, 8.02, 8.09, 8.159, 8.228, 8.297, 8.366, 8.436, 8.505, 8.574, 8.643, 8.712, 8.782, 8.851, 8.92, 8.989, 9.058, 9.127, 9.197, 9.266, 9.335, 9.404, 9.473, 9.543, 9.612, 9.681, 9.75, 9.819, 9.888, 9.958, 10.027, 10.096, 10.165, 10.234, 10.304, 10.373, 10.442, 10.511, 10.58, 10.65, 10.719, 10.788, 10.857, 10.926, 10.995, 11.065, 11.134, 11.203, 11.272, 11.341, 11.411, 11.48, 11.549, 11.618, 11.687, 11.756, 11.826, 11.895, 11.964, 12.033, 12.102, 12.172, 12.241, 12.31, 12.379, 12.448, 12.518, 12.587, 12.656, 12.725, 12.794, 12.863, 12.933, 13.002, 13.071, 13.14, 13.209, 13.279, 13.348, 13.417, 13.486, 13.555, 13.624, 13.694, 13.763, 13.832, 13.901, 13.97, 14.04, 14.109, 14.178, 14.247, 14.316, 14.386, 14.455, 14.524, 14.593, 14.662, 14.731, 14.801, 14.87, 14.939, 15.008, 15.077, 15.147, 15.216, 15.285, 15.354, 15.423, 15.492, 15.562, 15.631, 15.7, 15.769, 15.838, 15.908, 15.977, 16.046, 16.04596769, -4.71, -4.64, -4.571, -4.502, -4.433, -4.364, -4.294, -4.225, -4.156, -4.087, -4.018, -3.949, -3.879, -3.81, -3.741, -3.672, -3.603, -3.533, -3.464, -3.395, -3.326, -3.257, -3.188, -3.118, -3.049, -2.98, -2.911, -2.842, -2.772, -2.703, -2.634, -2.565, -2.496, -2.426, -2.357, -2.288, -2.219, -2.15, -2.081, -2.011, -1.942, -1.873, -1.804, -1.735, -1.665, -1.596, -1.527, -1.458, -1.389, -1.32, -1.25, -1.181, -1.112, -1.043, -0.974, -0.904, -0.835, -0.766, -0.697, -0.628, -0.558, -0.489, -0.42, -0.351, -0.282, -0.213, -0.143, -0.074, -0.005, 0.064, 0.133, 0.203, 0.272, 0.341, 0.41, 0.479, 0.548, 0.618, 0.687, 0.756, 0.825, 0.894, 0.964, 1.033, 1.102, 1.171, 1.24, 1.31, 1.379, 1.448, 1.517, 1.586, 1.655, 1.725, 1.794, 1.863, 1.932, 2.001, 2.071, 2.14, 2.209, 2.278, 2.347, 2.416, 2.486, 2.555, 2.624, 2.693, 2.762, 2.832, 2.901, 2.97, 3.039, 3.108, 3.178, 3.247, 3.316, 3.385, 3.454, 3.523, 3.593, 3.662, 3.731, 3.8, 3.869, 3.939, 4.008, 4.077, 4.146, 4.215, 4.284, 4.354, 4.423, 4.492, 4.561, 4.63, 4.7, 4.769, 4.838, 4.907, 4.976, 5.046, 5.115, 5.184, 5.253, 5.322, 5.391, 5.461, 5.53, 5.599, 5.668, 5.737, 5.807, 5.876, 5.945, 6.014, 6.083, 6.152, 6.222, 6.291, 6.36, 6.429, 6.498, 6.568, 6.637, 6.706, 6.775, 6.844, 6.914, 6.983, 7.052, 7.121, 7.19, 7.259, 7.329, 7.398, 7.467, 7.536, 7.605, 7.675, 7.744, 7.813, 7.882, 7.951, 8.02, 8.09, 8.159, 8.228, 8.297, 8.366, 8.436, 8.505, 8.574, 8.643, 8.712, 8.782, 8.851, 8.92, 8.989, 9.058, 9.127, 9.197, 9.266, 9.335, 9.404, 9.473, 9.543, 9.612, 9.681, 9.75, 9.819, 9.888, 9.958, 10.027, 10.096, 10.165, 10.234, 10.304, 10.373, 10.442, 10.511, 10.58, 10.65, 10.719, 10.788, 10.857, 10.926, 10.995, 11.065, 11.134, 11.203, 11.272, 11.341, 11.411, 11.48, 11.549, 11.618, 11.687, 11.756, 11.826, 11.895, 11.964, 12.033, 12.102, 12.172, 12.241, 12.31, 12.379, 12.448, 12.518, 12.587, 12.656, 12.725, 12.794, 12.863, 12.933, 13.002, 13.071, 13.14, 13.209, 13.279, 13.348, 13.417, 13.486, 13.555, 13.624, 13.694, 13.763, 13.832, 13.901, 13.97, 14.04, 14.109, 14.178, 14.247, 14.316, 14.386, 14.455, 14.524, 14.593, 14.662, 14.731, 14.801, 14.87, 14.939, 15.008, 15.077, 15.147, 15.216, 15.285, 15.354, 15.423, 15.492, 15.562, 15.631, 15.7, 15.769, 15.838, 15.908, 15.977, 16.046, 16.04596769, -4.71, -4.64, -4.571, -4.502, -4.433, -4.364, -4.294, -4.225, -4.156, -4.087, -4.018, -3.949, -3.879, -3.81, -3.741, -3.672, -3.603, -3.533, -3.464, -3.395, -3.326, -3.257, -3.188, -3.118, -3.049, -2.98, -2.911, -2.842, -2.772, -2.703, -2.634, -2.565, -2.496, -2.426, -2.357, -2.288, -2.219, -2.15, -2.081, -2.011, -1.942, -1.873, -1.804, -1.735, -1.665, -1.596, -1.527, -1.458, -1.389, -1.32, -1.25, -1.181, -1.112, -1.043, -0.974, -0.904, -0.835, -0.766, -0.697, -0.628, -0.558, -0.489, -0.42, -0.351, -0.282, -0.213, -0.143, -0.074, -0.005, 0.064, 0.133, 0.203, 0.272, 0.341, 0.41, 0.479, 0.548, 0.618, 0.687, 0.756, 0.825, 0.894, 0.964, 1.033, 1.102, 1.171, 1.24, 1.31, 1.379, 1.448, 1.517, 1.586, 1.655, 1.725, 1.794, 1.863, 1.932, 2.001, 2.071, 2.14, 2.209, 2.278, 2.347, 2.416, 2.486, 2.555, 2.624, 2.693, 2.762, 2.832, 2.901, 2.97, 3.039, 3.108, 3.178, 3.247, 3.316, 3.385, 3.454, 3.523, 3.593, 3.662, 3.731, 3.8, 3.869, 3.939, 4.008, 4.077, 4.146, 4.215, 4.284, 4.354, 4.423, 4.492, 4.561, 4.63, 4.7, 4.769, 4.838, 4.907, 4.976, 5.046, 5.115, 5.184, 5.253, 5.322, 5.391, 5.461, 5.53, 5.599, 5.668, 5.737, 5.807, 5.876, 5.945, 6.014, 6.083, 6.152, 6.222, 6.291, 6.36, 6.429, 6.498, 6.568, 6.637, 6.706, 6.775, 6.844, 6.914, 6.983, 7.052, 7.121, 7.19, 7.259, 7.329, 7.398, 7.467, 7.536, 7.605, 7.675, 7.744, 7.813, 7.882, 7.951, 8.02, 8.09, 8.159, 8.228, 8.297, 8.366, 8.436, 8.505, 8.574, 8.643, 8.712, 8.782, 8.851, 8.92, 8.989, 9.058, 9.127, 9.197, 9.266, 9.335, 9.404, 9.473, 9.543, 9.612, 9.681, 9.75, 9.819, 9.888, 9.958, 10.027, 10.096, 10.165, 10.234, 10.304, 10.373, 10.442, 10.511, 10.58, 10.65, 10.719, 10.788, 10.857, 10.926, 10.995, 11.065, 11.134, 11.203, 11.272, 11.341, 11.411, 11.48, 11.549, 11.618, 11.687, 11.756, 11.826, 11.895, 11.964, 12.033, 12.102, 12.172, 12.241, 12.31, 12.379, 12.448, 12.518, 12.587, 12.656, 12.725, 12.794, 12.863, 12.933, 13.002, 13.071, 13.14, 13.209, 13.279, 13.348, 13.417, 13.486, 13.555, 13.624, 13.694, 13.763, 13.832, 13.901, 13.97, 14.04, 14.109, 14.178, 14.247, 14.316, 14.386, 14.455, 14.524, 14.593, 14.662, 14.731, 14.801, 14.87, 14.939, 15.008, 15.077, 15.147, 15.216, 15.285, 15.354, 15.423, 15.492, 15.562, 15.631, 15.7, 15.769, 15.838, 15.908, 15.977, 16.046], [-4.766, -4.699, -4.631, -4.563, -4.495, -4.427, -4.36, -4.292, -4.224, -4.156, -4.088, -4.021, -3.953, -3.885, -3.817, -3.749, -3.682, -3.614, -3.546, -3.478, -3.411, -3.343, -3.275, -3.207, -3.139, -3.072, -3.004, -2.936, -2.868, -2.8, -2.733, -2.665, -2.597, -2.529, -2.461, -2.394, -2.326, -2.258, -2.19, -2.122, -2.055, -1.987, -1.919, -1.851, -1.783, -1.716, -1.648, -1.58, -1.512, -1.445, -1.377, -1.309, -1.241, -1.173, -1.106, -1.038, -0.97, -0.902, -0.834, -0.767, -0.699, -0.631, -0.563, -0.495, -0.428, -0.36, -0.292, -0.224, -0.156, -0.089, -0.021, 0.047, 0.115, 0.183, 0.25, 0.318, 0.386, 0.454, 0.521, 0.589, 0.657, 0.725, 0.793, 0.86, 0.928, 0.996, 1.064, 1.132, 1.199, 1.267, 1.335, 1.403, 1.471, 1.538, 1.606, 1.674, 1.742, 1.81, 1.877, 1.945, 2.013, 2.081, 2.149, 2.216, 2.284, 2.352, 2.42, 2.487, 2.555, 2.623, 2.691, 2.759, 2.826, 2.894, 2.962, 3.03, 3.098, 3.165, 3.233, 3.301, 3.369, 3.437, 3.504, 3.572, 3.64, 3.708, 3.776, 3.843, 3.911, 3.979, 4.047, 4.114, 4.182, 4.25, 4.318, 4.386, 4.453, 4.521, 4.589, 4.657, 4.725, 4.792, 4.86, 4.928, 4.996, 5.064, 5.131, 5.199, 5.267, 5.335, 5.403, 5.47, 5.538, 5.606, 5.674, 5.742, 5.809, 5.877, 5.945, 6.013, 6.08, 6.148, 6.216, 6.284, 6.352, 6.419, 6.487, 6.555, 6.623, 6.691, 6.758, 6.826, 6.894, 6.962, 7.03, 7.097, 7.165, 7.233, 7.301, 7.369, 7.436, 7.504, 7.572, 7.64, 7.708, 7.775, 7.843, 7.911, 7.979, 8.046, 8.114, 8.182, 8.25, 8.318, 8.385, 8.453, 8.521, 8.589, 8.657, 8.724, 8.792, 8.86, 8.928, 8.996, 9.063, 9.131, 9.199, 9.267, 9.335, 9.402, 9.47, 9.538, 9.606, 9.674, 9.741, 9.809, 9.877, 9.945, 10.012, 10.08, 10.148, 10.216, 10.284, 10.351, 10.419, 10.487, 10.555, 10.623, 10.69, 10.758, 10.826, 10.894, 10.962, 11.029, 11.097, 11.165, 11.233, 11.301, 11.368, 11.436, 11.504, 11.572, 11.64, 11.707, 11.775, 11.843, 11.911, 11.978, 12.046, 12.114, 12.182, 12.25, 12.317, 12.385, 12.453, 12.521, 12.589, 12.656, 12.724, 12.792, 12.86, 12.928, 12.995, 13.063, 13.131, 13.199, 13.267, 13.334, 13.402, 13.47, 13.538, 13.606, 13.673, 13.741, 13.809, 13.877, 13.944, 14.012, 14.08, 14.148, 14.216, 14.283, 14.351, 14.419, 14.487, 14.555, 14.622, 14.69, 14.758, 14.826, 14.894, 14.961, 15.029, 15.097, 15.165, 15.233, 15.3, 15.368, 15.436, 15.504, 15.572, 15.57152435, -4.766, -4.699, -4.631, -4.563, -4.495, -4.427, -4.36, -4.292, -4.224, -4.156, -4.088, -4.021, -3.953, -3.885, -3.817, -3.749, -3.682, -3.614, -3.546, -3.478, -3.411, -3.343, -3.275, -3.207, -3.139, -3.072, -3.004, -2.936, -2.868, -2.8, -2.733, -2.665, -2.597, -2.529, -2.461, -2.394, -2.326, -2.258, -2.19, -2.122, -2.055, -1.987, -1.919, -1.851, -1.783, -1.716, -1.648, -1.58, -1.512, -1.445, -1.377, -1.309, -1.241, -1.173, -1.106, -1.038, -0.97, -0.902, -0.834, -0.767, -0.699, -0.631, -0.563, -0.495, -0.428, -0.36, -0.292, -0.224, -0.156, -0.089, -0.021, 0.047, 0.115, 0.183, 0.25, 0.318, 0.386, 0.454, 0.521, 0.589, 0.657, 0.725, 0.793, 0.86, 0.928, 0.996, 1.064, 1.132, 1.199, 1.267, 1.335, 1.403, 1.471, 1.538, 1.606, 1.674, 1.742, 1.81, 1.877, 1.945, 2.013, 2.081, 2.149, 2.216, 2.284, 2.352, 2.42, 2.487, 2.555, 2.623, 2.691, 2.759, 2.826, 2.894, 2.962, 3.03, 3.098, 3.165, 3.233, 3.301, 3.369, 3.437, 3.504, 3.572, 3.64, 3.708, 3.776, 3.843, 3.911, 3.979, 4.047, 4.114, 4.182, 4.25, 4.318, 4.386, 4.453, 4.521, 4.589, 4.657, 4.725, 4.792, 4.86, 4.928, 4.996, 5.064, 5.131, 5.199, 5.267, 5.335, 5.403, 5.47, 5.538, 5.606, 5.674, 5.742, 5.809, 5.877, 5.945, 6.013, 6.08, 6.148, 6.216, 6.284, 6.352, 6.419, 6.487, 6.555, 6.623, 6.691, 6.758, 6.826, 6.894, 6.962, 7.03, 7.097, 7.165, 7.233, 7.301, 7.369, 7.436, 7.504, 7.572, 7.64, 7.708, 7.775, 7.843, 7.911, 7.979, 8.046, 8.114, 8.182, 8.25, 8.318, 8.385, 8.453, 8.521, 8.589, 8.657, 8.724, 8.792, 8.86, 8.928, 8.996, 9.063, 9.131, 9.199, 9.267, 9.335, 9.402, 9.47, 9.538, 9.606, 9.674, 9.741, 9.809, 9.877, 9.945, 10.012, 10.08, 10.148, 10.216, 10.284, 10.351, 10.419, 10.487, 10.555, 10.623, 10.69, 10.758, 10.826, 10.894, 10.962, 11.029, 11.097, 11.165, 11.233, 11.301, 11.368, 11.436, 11.504, 11.572, 11.64, 11.707, 11.775, 11.843, 11.911, 11.978, 12.046, 12.114, 12.182, 12.25, 12.317, 12.385, 12.453, 12.521, 12.589, 12.656, 12.724, 12.792, 12.86, 12.928, 12.995, 13.063, 13.131, 13.199, 13.267, 13.334, 13.402, 13.47, 13.538, 13.606, 13.673, 13.741, 13.809, 13.877, 13.944, 14.012, 14.08, 14.148, 14.216, 14.283, 14.351, 14.419, 14.487, 14.555, 14.622, 14.69, 14.758, 14.826, 14.894, 14.961, 15.029, 15.097, 15.165, 15.233, 15.3, 15.368, 15.436, 15.504, 15.572, 15.57152435, -4.766, -4.699, -4.631, -4.563, -4.495, -4.427, -4.36, -4.292, -4.224, -4.156, -4.088, -4.021, -3.953, -3.885, -3.817, -3.749, -3.682, -3.614, -3.546, -3.478, -3.411, -3.343, -3.275, -3.207, -3.139, -3.072, -3.004, -2.936, -2.868, -2.8, -2.733, -2.665, -2.597, -2.529, -2.461, -2.394, -2.326, -2.258, -2.19, -2.122, -2.055, -1.987, -1.919, -1.851, -1.783, -1.716, -1.648, -1.58, -1.512, -1.445, -1.377, -1.309, -1.241, -1.173, -1.106, -1.038, -0.97, -0.902, -0.834, -0.767, -0.699, -0.631, -0.563, -0.495, -0.428, -0.36, -0.292, -0.224, -0.156, -0.089, -0.021, 0.047, 0.115, 0.183, 0.25, 0.318, 0.386, 0.454, 0.521, 0.589, 0.657, 0.725, 0.793, 0.86, 0.928, 0.996, 1.064, 1.132, 1.199, 1.267, 1.335, 1.403, 1.471, 1.538, 1.606, 1.674, 1.742, 1.81, 1.877, 1.945, 2.013, 2.081, 2.149, 2.216, 2.284, 2.352, 2.42, 2.487, 2.555, 2.623, 2.691, 2.759, 2.826, 2.894, 2.962, 3.03, 3.098, 3.165, 3.233, 3.301, 3.369, 3.437, 3.504, 3.572, 3.64, 3.708, 3.776, 3.843, 3.911, 3.979, 4.047, 4.114, 4.182, 4.25, 4.318, 4.386, 4.453, 4.521, 4.589, 4.657, 4.725, 4.792, 4.86, 4.928, 4.996, 5.064, 5.131, 5.199, 5.267, 5.335, 5.403, 5.47, 5.538, 5.606, 5.674, 5.742, 5.809, 5.877, 5.945, 6.013, 6.08, 6.148, 6.216, 6.284, 6.352, 6.419, 6.487, 6.555, 6.623, 6.691, 6.758, 6.826, 6.894, 6.962, 7.03, 7.097, 7.165, 7.233, 7.301, 7.369, 7.436, 7.504, 7.572, 7.64, 7.708, 7.775, 7.843, 7.911, 7.979, 8.046, 8.114, 8.182, 8.25, 8.318, 8.385, 8.453, 8.521, 8.589, 8.657, 8.724, 8.792, 8.86, 8.928, 8.996, 9.063, 9.131, 9.199, 9.267, 9.335, 9.402, 9.47, 9.538, 9.606, 9.674, 9.741, 9.809, 9.877, 9.945, 10.012, 10.08, 10.148, 10.216, 10.284, 10.351, 10.419, 10.487, 10.555, 10.623, 10.69, 10.758, 10.826, 10.894, 10.962, 11.029, 11.097, 11.165, 11.233, 11.301, 11.368, 11.436, 11.504, 11.572, 11.64, 11.707, 11.775, 11.843, 11.911, 11.978, 12.046, 12.114, 12.182, 12.25, 12.317, 12.385, 12.453, 12.521, 12.589, 12.656, 12.724, 12.792, 12.86, 12.928, 12.995, 13.063, 13.131, 13.199, 13.267, 13.334, 13.402, 13.47, 13.538, 13.606, 13.673, 13.741, 13.809, 13.877, 13.944, 14.012, 14.08, 14.148, 14.216, 14.283, 14.351, 14.419, 14.487, 14.555, 14.622, 14.69, 14.758, 14.826, 14.894, 14.961, 15.029, 15.097, 15.165, 15.233, 15.3, 15.368, 15.436, 15.504, 15.572, 15.57152435, -4.766, -4.699, -4.631, -4.563, -4.495, -4.427, -4.36, -4.292, -4.224, -4.156, -4.088, -4.021, -3.953, -3.885, -3.817, -3.749, -3.682, -3.614, -3.546, -3.478, -3.411, -3.343, -3.275, -3.207, -3.139, -3.072, -3.004, -2.936, -2.868, -2.8, -2.733, -2.665, -2.597, -2.529, -2.461, -2.394, -2.326, -2.258, -2.19, -2.122, -2.055, -1.987, -1.919, -1.851, -1.783, -1.716, -1.648, -1.58, -1.512, -1.445, -1.377, -1.309, -1.241, -1.173, -1.106, -1.038, -0.97, -0.902, -0.834, -0.767, -0.699, -0.631, -0.563, -0.495, -0.428, -0.36, -0.292, -0.224, -0.156, -0.089, -0.021, 0.047, 0.115, 0.183, 0.25, 0.318, 0.386, 0.454, 0.521, 0.589, 0.657, 0.725, 0.793, 0.86, 0.928, 0.996, 1.064, 1.132, 1.199, 1.267, 1.335, 1.403, 1.471, 1.538, 1.606, 1.674, 1.742, 1.81, 1.877, 1.945, 2.013, 2.081, 2.149, 2.216, 2.284, 2.352, 2.42, 2.487, 2.555, 2.623, 2.691, 2.759, 2.826, 2.894, 2.962, 3.03, 3.098, 3.165, 3.233, 3.301, 3.369, 3.437, 3.504, 3.572, 3.64, 3.708, 3.776, 3.843, 3.911, 3.979, 4.047, 4.114, 4.182, 4.25, 4.318, 4.386, 4.453, 4.521, 4.589, 4.657, 4.725, 4.792, 4.86, 4.928, 4.996, 5.064, 5.131, 5.199, 5.267, 5.335, 5.403, 5.47, 5.538, 5.606, 5.674, 5.742, 5.809, 5.877, 5.945, 6.013, 6.08, 6.148, 6.216, 6.284, 6.352, 6.419, 6.487, 6.555, 6.623, 6.691, 6.758, 6.826, 6.894, 6.962, 7.03, 7.097, 7.165, 7.233, 7.301, 7.369, 7.436, 7.504, 7.572, 7.64, 7.708, 7.775, 7.843, 7.911, 7.979, 8.046, 8.114, 8.182, 8.25, 8.318, 8.385, 8.453, 8.521, 8.589, 8.657, 8.724, 8.792, 8.86, 8.928, 8.996, 9.063, 9.131, 9.199, 9.267, 9.335, 9.402, 9.47, 9.538, 9.606, 9.674, 9.741, 9.809, 9.877, 9.945, 10.012, 10.08, 10.148, 10.216, 10.284, 10.351, 10.419, 10.487, 10.555, 10.623, 10.69, 10.758, 10.826, 10.894, 10.962, 11.029, 11.097, 11.165, 11.233, 11.301, 11.368, 11.436, 11.504, 11.572, 11.64, 11.707, 11.775, 11.843, 11.911, 11.978, 12.046, 12.114, 12.182, 12.25, 12.317, 12.385, 12.453, 12.521, 12.589, 12.656, 12.724, 12.792, 12.86, 12.928, 12.995, 13.063, 13.131, 13.199, 13.267, 13.334, 13.402, 13.47, 13.538, 13.606, 13.673, 13.741, 13.809, 13.877, 13.944, 14.012, 14.08, 14.148, 14.216, 14.283, 14.351, 14.419, 14.487, 14.555, 14.622, 14.69, 14.758, 14.826, 14.894, 14.961, 15.029, 15.097, 15.165, 15.233, 15.3, 15.368, 15.436, 15.504, 15.572, 15.57152435, -4.766, -4.699, -4.631, -4.563, -4.495, -4.427, -4.36, -4.292, -4.224, -4.156, -4.088, -4.021, -3.953, -3.885, -3.817, -3.749, -3.682, -3.614, -3.546, -3.478, -3.411, -3.343, -3.275, -3.207, -3.139, -3.072, -3.004, -2.936, -2.868, -2.8, -2.733, -2.665, -2.597, -2.529, -2.461, -2.394, -2.326, -2.258, -2.19, -2.122, -2.055, -1.987, -1.919, -1.851, -1.783, -1.716, -1.648, -1.58, -1.512, -1.445, -1.377, -1.309, -1.241, -1.173, -1.106, -1.038, -0.97, -0.902, -0.834, -0.767, -0.699, -0.631, -0.563, -0.495, -0.428, -0.36, -0.292, -0.224, -0.156, -0.089, -0.021, 0.047, 0.115, 0.183, 0.25, 0.318, 0.386, 0.454, 0.521, 0.589, 0.657, 0.725, 0.793, 0.86, 0.928, 0.996, 1.064, 1.132, 1.199, 1.267, 1.335, 1.403, 1.471, 1.538, 1.606, 1.674, 1.742, 1.81, 1.877, 1.945, 2.013, 2.081, 2.149, 2.216, 2.284, 2.352, 2.42, 2.487, 2.555, 2.623, 2.691, 2.759, 2.826, 2.894, 2.962, 3.03, 3.098, 3.165, 3.233, 3.301, 3.369, 3.437, 3.504, 3.572, 3.64, 3.708, 3.776, 3.843, 3.911, 3.979, 4.047, 4.114, 4.182, 4.25, 4.318, 4.386, 4.453, 4.521, 4.589, 4.657, 4.725, 4.792, 4.86, 4.928, 4.996, 5.064, 5.131, 5.199, 5.267, 5.335, 5.403, 5.47, 5.538, 5.606, 5.674, 5.742, 5.809, 5.877, 5.945, 6.013, 6.08, 6.148, 6.216, 6.284, 6.352, 6.419, 6.487, 6.555, 6.623, 6.691, 6.758, 6.826, 6.894, 6.962, 7.03, 7.097, 7.165, 7.233, 7.301, 7.369, 7.436, 7.504, 7.572, 7.64, 7.708, 7.775, 7.843, 7.911, 7.979, 8.046, 8.114, 8.182, 8.25, 8.318, 8.385, 8.453, 8.521, 8.589, 8.657, 8.724, 8.792, 8.86, 8.928, 8.996, 9.063, 9.131, 9.199, 9.267, 9.335, 9.402, 9.47, 9.538, 9.606, 9.674, 9.741, 9.809, 9.877, 9.945, 10.012, 10.08, 10.148, 10.216, 10.284, 10.351, 10.419, 10.487, 10.555, 10.623, 10.69, 10.758, 10.826, 10.894, 10.962, 11.029, 11.097, 11.165, 11.233, 11.301, 11.368, 11.436, 11.504, 11.572, 11.64, 11.707, 11.775, 11.843, 11.911, 11.978, 12.046, 12.114, 12.182, 12.25, 12.317, 12.385, 12.453, 12.521, 12.589, 12.656, 12.724, 12.792, 12.86, 12.928, 12.995, 13.063, 13.131, 13.199, 13.267, 13.334, 13.402, 13.47, 13.538, 13.606, 13.673, 13.741, 13.809, 13.877, 13.944, 14.012, 14.08, 14.148, 14.216, 14.283, 14.351, 14.419, 14.487, 14.555, 14.622, 14.69, 14.758, 14.826, 14.894, 14.961, 15.029, 15.097, 15.165, 15.233, 15.3, 15.368, 15.436, 15.504, 15.572], [-4.821, -4.754, -4.688, -4.621, -4.555, -4.488, -4.422, -4.355, -4.289, -4.223, -4.156, -4.09, -4.023, -3.957, -3.89, -3.824, -3.757, -3.691, -3.625, -3.558, -3.492, -3.425, -3.359, -3.292, -3.226, -3.159, -3.093, -3.026, -2.96, -2.894, -2.827, -2.761, -2.694, -2.628, -2.561, -2.495, -2.428, -2.362, -2.296, -2.229, -2.163, -2.096, -2.03, -1.963, -1.897, -1.83, -1.764, -1.697, -1.631, -1.565, -1.498, -1.432, -1.365, -1.299, -1.232, -1.166, -1.099, -1.033, -0.967, -0.9, -0.834, -0.767, -0.701, -0.634, -0.568, -0.501, -0.435, -0.368, -0.302, -0.236, -0.169, -0.103, -0.036, 0.03, 0.097, 0.163, 0.23, 0.296, 0.362, 0.429, 0.495, 0.562, 0.628, 0.695, 0.761, 0.828, 0.894, 0.961, 1.027, 1.093, 1.16, 1.226, 1.293, 1.359, 1.426, 1.492, 1.559, 1.625, 1.691, 1.758, 1.824, 1.891, 1.957, 2.024, 2.09, 2.157, 2.223, 2.29, 2.356, 2.422, 2.489, 2.555, 2.622, 2.688, 2.755, 2.821, 2.888, 2.954, 3.02, 3.087, 3.153, 3.22, 3.286, 3.353, 3.419, 3.486, 3.552, 3.619, 3.685, 3.751, 3.818, 3.884, 3.951, 4.017, 4.084, 4.15, 4.217, 4.283, 4.349, 4.416, 4.482, 4.549, 4.615, 4.682, 4.748, 4.815, 4.881, 4.948, 5.014, 5.08, 5.147, 5.213, 5.28, 5.346, 5.413, 5.479, 5.546, 5.612, 5.678, 5.745, 5.811, 5.878, 5.944, 6.011, 6.077, 6.144, 6.21, 6.277, 6.343, 6.409, 6.476, 6.542, 6.609, 6.675, 6.742, 6.808, 6.875, 6.941, 7.007, 7.074, 7.14, 7.207, 7.273, 7.34, 7.406, 7.473, 7.539, 7.606, 7.672, 7.738, 7.805, 7.871, 7.938, 8.004, 8.071, 8.137, 8.204, 8.27, 8.337, 8.403, 8.469, 8.536, 8.602, 8.669, 8.735, 8.802, 8.868, 8.935, 9.001, 9.067, 9.134, 9.2, 9.267, 9.333, 9.4, 9.466, 9.533, 9.599, 9.666, 9.732, 9.798, 9.865, 9.931, 9.998, 10.064, 10.131, 10.197, 10.264, 10.33, 10.396, 10.463, 10.529, 10.596, 10.662, 10.729, 10.795, 10.862, 10.928, 10.995, 11.061, 11.127, 11.194, 11.26, 11.327, 11.393, 11.46, 11.526, 11.593, 11.659, 11.725, 11.792, 11.858, 11.925, 11.991, 12.058, 12.124, 12.191, 12.257, 12.324, 12.39, 12.456, 12.523, 12.589, 12.656, 12.722, 12.789, 12.855, 12.922, 12.988, 13.054, 13.121, 13.187, 13.254, 13.32, 13.387, 13.453, 13.52, 13.586, 13.653, 13.719, 13.785, 13.852, 13.918, 13.985, 14.051, 14.118, 14.184, 14.251, 14.317, 14.383, 14.45, 14.516, 14.583, 14.649, 14.716, 14.782, 14.849, 14.915, 14.982, 15.048, 15.114, 15.1144251, -4.821, -4.754, -4.688, -4.621, -4.555, -4.488, -4.422, -4.355, -4.289, -4.223, -4.156, -4.09, -4.023, -3.957, -3.89, -3.824, -3.757, -3.691, -3.625, -3.558, -3.492, -3.425, -3.359, -3.292, -3.226, -3.159, -3.093, -3.026, -2.96, -2.894, -2.827, -2.761, -2.694, -2.628, -2.561, -2.495, -2.428, -2.362, -2.296, -2.229, -2.163, -2.096, -2.03, -1.963, -1.897, -1.83, -1.764, -1.697, -1.631, -1.565, -1.498, -1.432, -1.365, -1.299, -1.232, -1.166, -1.099, -1.033, -0.967, -0.9, -0.834, -0.767, -0.701, -0.634, -0.568, -0.501, -0.435, -0.368, -0.302, -0.236, -0.169, -0.103, -0.036, 0.03, 0.097, 0.163, 0.23, 0.296, 0.362, 0.429, 0.495, 0.562, 0.628, 0.695, 0.761, 0.828, 0.894, 0.961, 1.027, 1.093, 1.16, 1.226, 1.293, 1.359, 1.426, 1.492, 1.559, 1.625, 1.691, 1.758, 1.824, 1.891, 1.957, 2.024, 2.09, 2.157, 2.223, 2.29, 2.356, 2.422, 2.489, 2.555, 2.622, 2.688, 2.755, 2.821, 2.888, 2.954, 3.02, 3.087, 3.153, 3.22, 3.286, 3.353, 3.419, 3.486, 3.552, 3.619, 3.685, 3.751, 3.818, 3.884, 3.951, 4.017, 4.084, 4.15, 4.217, 4.283, 4.349, 4.416, 4.482, 4.549, 4.615, 4.682, 4.748, 4.815, 4.881, 4.948, 5.014, 5.08, 5.147, 5.213, 5.28, 5.346, 5.413, 5.479, 5.546, 5.612, 5.678, 5.745, 5.811, 5.878, 5.944, 6.011, 6.077, 6.144, 6.21, 6.277, 6.343, 6.409, 6.476, 6.542, 6.609, 6.675, 6.742, 6.808, 6.875, 6.941, 7.007, 7.074, 7.14, 7.207, 7.273, 7.34, 7.406, 7.473, 7.539, 7.606, 7.672, 7.738, 7.805, 7.871, 7.938, 8.004, 8.071, 8.137, 8.204, 8.27, 8.337, 8.403, 8.469, 8.536, 8.602, 8.669, 8.735, 8.802, 8.868, 8.935, 9.001, 9.067, 9.134, 9.2, 9.267, 9.333, 9.4, 9.466, 9.533, 9.599, 9.666, 9.732, 9.798, 9.865, 9.931, 9.998, 10.064, 10.131, 10.197, 10.264, 10.33, 10.396, 10.463, 10.529, 10.596, 10.662, 10.729, 10.795, 10.862, 10.928, 10.995, 11.061, 11.127, 11.194, 11.26, 11.327, 11.393, 11.46, 11.526, 11.593, 11.659, 11.725, 11.792, 11.858, 11.925, 11.991, 12.058, 12.124, 12.191, 12.257, 12.324, 12.39, 12.456, 12.523, 12.589, 12.656, 12.722, 12.789, 12.855, 12.922, 12.988, 13.054, 13.121, 13.187, 13.254, 13.32, 13.387, 13.453, 13.52, 13.586, 13.653, 13.719, 13.785, 13.852, 13.918, 13.985, 14.051, 14.118, 14.184, 14.251, 14.317, 14.383, 14.45, 14.516, 14.583, 14.649, 14.716, 14.782, 14.849, 14.915, 14.982, 15.048, 15.114, 15.1144251, -4.821, -4.754, -4.688, -4.621, -4.555, -4.488, -4.422, -4.355, -4.289, -4.223, -4.156, -4.09, -4.023, -3.957, -3.89, -3.824, -3.757, -3.691, -3.625, -3.558, -3.492, -3.425, -3.359, -3.292, -3.226, -3.159, -3.093, -3.026, -2.96, -2.894, -2.827, -2.761, -2.694, -2.628, -2.561, -2.495, -2.428, -2.362, -2.296, -2.229, -2.163, -2.096, -2.03, -1.963, -1.897, -1.83, -1.764, -1.697, -1.631, -1.565, -1.498, -1.432, -1.365, -1.299, -1.232, -1.166, -1.099, -1.033, -0.967, -0.9, -0.834, -0.767, -0.701, -0.634, -0.568, -0.501, -0.435, -0.368, -0.302, -0.236, -0.169, -0.103, -0.036, 0.03, 0.097, 0.163, 0.23, 0.296, 0.362, 0.429, 0.495, 0.562, 0.628, 0.695, 0.761, 0.828, 0.894, 0.961, 1.027, 1.093, 1.16, 1.226, 1.293, 1.359, 1.426, 1.492, 1.559, 1.625, 1.691, 1.758, 1.824, 1.891, 1.957, 2.024, 2.09, 2.157, 2.223, 2.29, 2.356, 2.422, 2.489, 2.555, 2.622, 2.688, 2.755, 2.821, 2.888, 2.954, 3.02, 3.087, 3.153, 3.22, 3.286, 3.353, 3.419, 3.486, 3.552, 3.619, 3.685, 3.751, 3.818, 3.884, 3.951, 4.017, 4.084, 4.15, 4.217, 4.283, 4.349, 4.416, 4.482, 4.549, 4.615, 4.682, 4.748, 4.815, 4.881, 4.948, 5.014, 5.08, 5.147, 5.213, 5.28, 5.346, 5.413, 5.479, 5.546, 5.612, 5.678, 5.745, 5.811, 5.878, 5.944, 6.011, 6.077, 6.144, 6.21, 6.277, 6.343, 6.409, 6.476, 6.542, 6.609, 6.675, 6.742, 6.808, 6.875, 6.941, 7.007, 7.074, 7.14, 7.207, 7.273, 7.34, 7.406, 7.473, 7.539, 7.606, 7.672, 7.738, 7.805, 7.871, 7.938, 8.004, 8.071, 8.137, 8.204, 8.27, 8.337, 8.403, 8.469, 8.536, 8.602, 8.669, 8.735, 8.802, 8.868, 8.935, 9.001, 9.067, 9.134, 9.2, 9.267, 9.333, 9.4, 9.466, 9.533, 9.599, 9.666, 9.732, 9.798, 9.865, 9.931, 9.998, 10.064, 10.131, 10.197, 10.264, 10.33, 10.396, 10.463, 10.529, 10.596, 10.662, 10.729, 10.795, 10.862, 10.928, 10.995, 11.061, 11.127, 11.194, 11.26, 11.327, 11.393, 11.46, 11.526, 11.593, 11.659, 11.725, 11.792, 11.858, 11.925, 11.991, 12.058, 12.124, 12.191, 12.257, 12.324, 12.39, 12.456, 12.523, 12.589, 12.656, 12.722, 12.789, 12.855, 12.922, 12.988, 13.054, 13.121, 13.187, 13.254, 13.32, 13.387, 13.453, 13.52, 13.586, 13.653, 13.719, 13.785, 13.852, 13.918, 13.985, 14.051, 14.118, 14.184, 14.251, 14.317, 14.383, 14.45, 14.516, 14.583, 14.649, 14.716, 14.782, 14.849, 14.915, 14.982, 15.048, 15.114, 15.1144251, -4.821, -4.754, -4.688, -4.621, -4.555, -4.488, -4.422, -4.355, -4.289, -4.223, -4.156, -4.09, -4.023, -3.957, -3.89, -3.824, -3.757, -3.691, -3.625, -3.558, -3.492, -3.425, -3.359, -3.292, -3.226, -3.159, -3.093, -3.026, -2.96, -2.894, -2.827, -2.761, -2.694, -2.628, -2.561, -2.495, -2.428, -2.362, -2.296, -2.229, -2.163, -2.096, -2.03, -1.963, -1.897, -1.83, -1.764, -1.697, -1.631, -1.565, -1.498, -1.432, -1.365, -1.299, -1.232, -1.166, -1.099, -1.033, -0.967, -0.9, -0.834, -0.767, -0.701, -0.634, -0.568, -0.501, -0.435, -0.368, -0.302, -0.236, -0.169, -0.103, -0.036, 0.03, 0.097, 0.163, 0.23, 0.296, 0.362, 0.429, 0.495, 0.562, 0.628, 0.695, 0.761, 0.828, 0.894, 0.961, 1.027, 1.093, 1.16, 1.226, 1.293, 1.359, 1.426, 1.492, 1.559, 1.625, 1.691, 1.758, 1.824, 1.891, 1.957, 2.024, 2.09, 2.157, 2.223, 2.29, 2.356, 2.422, 2.489, 2.555, 2.622, 2.688, 2.755, 2.821, 2.888, 2.954, 3.02, 3.087, 3.153, 3.22, 3.286, 3.353, 3.419, 3.486, 3.552, 3.619, 3.685, 3.751, 3.818, 3.884, 3.951, 4.017, 4.084, 4.15, 4.217, 4.283, 4.349, 4.416, 4.482, 4.549, 4.615, 4.682, 4.748, 4.815, 4.881, 4.948, 5.014, 5.08, 5.147, 5.213, 5.28, 5.346, 5.413, 5.479, 5.546, 5.612, 5.678, 5.745, 5.811, 5.878, 5.944, 6.011, 6.077, 6.144, 6.21, 6.277, 6.343, 6.409, 6.476, 6.542, 6.609, 6.675, 6.742, 6.808, 6.875, 6.941, 7.007, 7.074, 7.14, 7.207, 7.273, 7.34, 7.406, 7.473, 7.539, 7.606, 7.672, 7.738, 7.805, 7.871, 7.938, 8.004, 8.071, 8.137, 8.204, 8.27, 8.337, 8.403, 8.469, 8.536, 8.602, 8.669, 8.735, 8.802, 8.868, 8.935, 9.001, 9.067, 9.134, 9.2, 9.267, 9.333, 9.4, 9.466, 9.533, 9.599, 9.666, 9.732, 9.798, 9.865, 9.931, 9.998, 10.064, 10.131, 10.197, 10.264, 10.33, 10.396, 10.463, 10.529, 10.596, 10.662, 10.729, 10.795, 10.862, 10.928, 10.995, 11.061, 11.127, 11.194, 11.26, 11.327, 11.393, 11.46, 11.526, 11.593, 11.659, 11.725, 11.792, 11.858, 11.925, 11.991, 12.058, 12.124, 12.191, 12.257, 12.324, 12.39, 12.456, 12.523, 12.589, 12.656, 12.722, 12.789, 12.855, 12.922, 12.988, 13.054, 13.121, 13.187, 13.254, 13.32, 13.387, 13.453, 13.52, 13.586, 13.653, 13.719, 13.785, 13.852, 13.918, 13.985, 14.051, 14.118, 14.184, 14.251, 14.317, 14.383, 14.45, 14.516, 14.583, 14.649, 14.716, 14.782, 14.849, 14.915, 14.982, 15.048, 15.114, 15.1144251, -4.821, -4.754, -4.688, -4.621, -4.555, -4.488, -4.422, -4.355, -4.289, -4.223, -4.156, -4.09, -4.023, -3.957, -3.89, -3.824, -3.757, -3.691, -3.625, -3.558, -3.492, -3.425, -3.359, -3.292, -3.226, -3.159, -3.093, -3.026, -2.96, -2.894, -2.827, -2.761, -2.694, -2.628, -2.561, -2.495, -2.428, -2.362, -2.296, -2.229, -2.163, -2.096, -2.03, -1.963, -1.897, -1.83, -1.764, -1.697, -1.631, -1.565, -1.498, -1.432, -1.365, -1.299, -1.232, -1.166, -1.099, -1.033, -0.967, -0.9, -0.834, -0.767, -0.701, -0.634, -0.568, -0.501, -0.435, -0.368, -0.302, -0.236, -0.169, -0.103, -0.036, 0.03, 0.097, 0.163, 0.23, 0.296, 0.362, 0.429, 0.495, 0.562, 0.628, 0.695, 0.761, 0.828, 0.894, 0.961, 1.027, 1.093, 1.16, 1.226, 1.293, 1.359, 1.426, 1.492, 1.559, 1.625, 1.691, 1.758, 1.824, 1.891, 1.957, 2.024, 2.09, 2.157, 2.223, 2.29, 2.356, 2.422, 2.489, 2.555, 2.622, 2.688, 2.755, 2.821, 2.888, 2.954, 3.02, 3.087, 3.153, 3.22, 3.286, 3.353, 3.419, 3.486, 3.552, 3.619, 3.685, 3.751, 3.818, 3.884, 3.951, 4.017, 4.084, 4.15, 4.217, 4.283, 4.349, 4.416, 4.482, 4.549, 4.615, 4.682, 4.748, 4.815, 4.881, 4.948, 5.014, 5.08, 5.147, 5.213, 5.28, 5.346, 5.413, 5.479, 5.546, 5.612, 5.678, 5.745, 5.811, 5.878, 5.944, 6.011, 6.077, 6.144, 6.21, 6.277, 6.343, 6.409, 6.476, 6.542, 6.609, 6.675, 6.742, 6.808, 6.875, 6.941, 7.007, 7.074, 7.14, 7.207, 7.273, 7.34, 7.406, 7.473, 7.539, 7.606, 7.672, 7.738, 7.805, 7.871, 7.938, 8.004, 8.071, 8.137, 8.204, 8.27, 8.337, 8.403, 8.469, 8.536, 8.602, 8.669, 8.735, 8.802, 8.868, 8.935, 9.001, 9.067, 9.134, 9.2, 9.267, 9.333, 9.4, 9.466, 9.533, 9.599, 9.666, 9.732, 9.798, 9.865, 9.931, 9.998, 10.064, 10.131, 10.197, 10.264, 10.33, 10.396, 10.463, 10.529, 10.596, 10.662, 10.729, 10.795, 10.862, 10.928, 10.995, 11.061, 11.127, 11.194, 11.26, 11.327, 11.393, 11.46, 11.526, 11.593, 11.659, 11.725, 11.792, 11.858, 11.925, 11.991, 12.058, 12.124, 12.191, 12.257, 12.324, 12.39, 12.456, 12.523, 12.589, 12.656, 12.722, 12.789, 12.855, 12.922, 12.988, 13.054, 13.121, 13.187, 13.254, 13.32, 13.387, 13.453, 13.52, 13.586, 13.653, 13.719, 13.785, 13.852, 13.918, 13.985, 14.051, 14.118, 14.184, 14.251, 14.317, 14.383, 14.45, 14.516, 14.583, 14.649, 14.716, 14.782, 14.849, 14.915, 14.982, 15.048, 15.114], [-4.872, -4.807, -4.742, -4.676, -4.611, -4.546, -4.481, -4.416, -4.351, -4.286, -4.221, -4.156, -4.091, -4.026, -3.96, -3.895, -3.83, -3.765, -3.7, -3.635, -3.57, -3.505, -3.44, -3.375, -3.309, -3.244, -3.179, -3.114, -3.049, -2.984, -2.919, -2.854, -2.789, -2.724, -2.659, -2.593, -2.528, -2.463, -2.398, -2.333, -2.268, -2.203, -2.138, -2.073, -2.008, -1.942, -1.877, -1.812, -1.747, -1.682, -1.617, -1.552, -1.487, -1.422, -1.357, -1.292, -1.226, -1.161, -1.096, -1.031, -0.966, -0.901, -0.836, -0.771, -0.706, -0.641, -0.575, -0.51, -0.445, -0.38, -0.315, -0.25, -0.185, -0.12, -0.055, 0.01, 0.075, 0.141, 0.206, 0.271, 0.336, 0.401, 0.466, 0.531, 0.596, 0.661, 0.726, 0.792, 0.857, 0.922, 0.987, 1.052, 1.117, 1.182, 1.247, 1.312, 1.377, 1.442, 1.508, 1.573, 1.638, 1.703, 1.768, 1.833, 1.898, 1.963, 2.028, 2.093, 2.159, 2.224, 2.289, 2.354, 2.419, 2.484, 2.549, 2.614, 2.679, 2.744, 2.809, 2.875, 2.94, 3.005, 3.07, 3.135, 3.2, 3.265, 3.33, 3.395, 3.46, 3.526, 3.591, 3.656, 3.721, 3.786, 3.851, 3.916, 3.981, 4.046, 4.111, 4.176, 4.242, 4.307, 4.372, 4.437, 4.502, 4.567, 4.632, 4.697, 4.762, 4.827, 4.893, 4.958, 5.023, 5.088, 5.153, 5.218, 5.283, 5.348, 5.413, 5.478, 5.543, 5.609, 5.674, 5.739, 5.804, 5.869, 5.934, 5.999, 6.064, 6.129, 6.194, 6.26, 6.325, 6.39, 6.455, 6.52, 6.585, 6.65, 6.715, 6.78, 6.845, 6.91, 6.976, 7.041, 7.106, 7.171, 7.236, 7.301, 7.366, 7.431, 7.496, 7.561, 7.627, 7.692, 7.757, 7.822, 7.887, 7.952, 8.017, 8.082, 8.147, 8.212, 8.278, 8.343, 8.408, 8.473, 8.538, 8.603, 8.668, 8.733, 8.798, 8.863, 8.928, 8.994, 9.059, 9.124, 9.189, 9.254, 9.319, 9.384, 9.449, 9.514, 9.579, 9.645, 9.71, 9.775, 9.84, 9.905, 9.97, 10.035, 10.1, 10.165, 10.23, 10.295, 10.361, 10.426, 10.491, 10.556, 10.621, 10.686, 10.751, 10.816, 10.881, 10.946, 11.012, 11.077, 11.142, 11.207, 11.272, 11.337, 11.402, 11.467, 11.532, 11.597, 11.662, 11.728, 11.793, 11.858, 11.923, 11.988, 12.053, 12.118, 12.183, 12.248, 12.313, 12.379, 12.444, 12.509, 12.574, 12.639, 12.704, 12.769, 12.834, 12.899, 12.964, 13.029, 13.095, 13.16, 13.225, 13.29, 13.355, 13.42, 13.485, 13.55, 13.615, 13.68, 13.746, 13.811, 13.876, 13.941, 14.006, 14.071, 14.136, 14.201, 14.266, 14.331, 14.396, 14.462, 14.527, 14.592, 14.657, 14.65684246, -4.872, -4.807, -4.742, -4.676, -4.611, -4.546, -4.481, -4.416, -4.351, -4.286, -4.221, -4.156, -4.091, -4.026, -3.96, -3.895, -3.83, -3.765, -3.7, -3.635, -3.57, -3.505, -3.44, -3.375, -3.309, -3.244, -3.179, -3.114, -3.049, -2.984, -2.919, -2.854, -2.789, -2.724, -2.659, -2.593, -2.528, -2.463, -2.398, -2.333, -2.268, -2.203, -2.138, -2.073, -2.008, -1.942, -1.877, -1.812, -1.747, -1.682, -1.617, -1.552, -1.487, -1.422, -1.357, -1.292, -1.226, -1.161, -1.096, -1.031, -0.966, -0.901, -0.836, -0.771, -0.706, -0.641, -0.575, -0.51, -0.445, -0.38, -0.315, -0.25, -0.185, -0.12, -0.055, 0.01, 0.075, 0.141, 0.206, 0.271, 0.336, 0.401, 0.466, 0.531, 0.596, 0.661, 0.726, 0.792, 0.857, 0.922, 0.987, 1.052, 1.117, 1.182, 1.247, 1.312, 1.377, 1.442, 1.508, 1.573, 1.638, 1.703, 1.768, 1.833, 1.898, 1.963, 2.028, 2.093, 2.159, 2.224, 2.289, 2.354, 2.419, 2.484, 2.549, 2.614, 2.679, 2.744, 2.809, 2.875, 2.94, 3.005, 3.07, 3.135, 3.2, 3.265, 3.33, 3.395, 3.46, 3.526, 3.591, 3.656, 3.721, 3.786, 3.851, 3.916, 3.981, 4.046, 4.111, 4.176, 4.242, 4.307, 4.372, 4.437, 4.502, 4.567, 4.632, 4.697, 4.762, 4.827, 4.893, 4.958, 5.023, 5.088, 5.153, 5.218, 5.283, 5.348, 5.413, 5.478, 5.543, 5.609, 5.674, 5.739, 5.804, 5.869, 5.934, 5.999, 6.064, 6.129, 6.194, 6.26, 6.325, 6.39, 6.455, 6.52, 6.585, 6.65, 6.715, 6.78, 6.845, 6.91, 6.976, 7.041, 7.106, 7.171, 7.236, 7.301, 7.366, 7.431, 7.496, 7.561, 7.627, 7.692, 7.757, 7.822, 7.887, 7.952, 8.017, 8.082, 8.147, 8.212, 8.278, 8.343, 8.408, 8.473, 8.538, 8.603, 8.668, 8.733, 8.798, 8.863, 8.928, 8.994, 9.059, 9.124, 9.189, 9.254, 9.319, 9.384, 9.449, 9.514, 9.579, 9.645, 9.71, 9.775, 9.84, 9.905, 9.97, 10.035, 10.1, 10.165, 10.23, 10.295, 10.361, 10.426, 10.491, 10.556, 10.621, 10.686, 10.751, 10.816, 10.881, 10.946, 11.012, 11.077, 11.142, 11.207, 11.272, 11.337, 11.402, 11.467, 11.532, 11.597, 11.662, 11.728, 11.793, 11.858, 11.923, 11.988, 12.053, 12.118, 12.183, 12.248, 12.313, 12.379, 12.444, 12.509, 12.574, 12.639, 12.704, 12.769, 12.834, 12.899, 12.964, 13.029, 13.095, 13.16, 13.225, 13.29, 13.355, 13.42, 13.485, 13.55, 13.615, 13.68, 13.746, 13.811, 13.876, 13.941, 14.006, 14.071, 14.136, 14.201, 14.266, 14.331, 14.396, 14.462, 14.527, 14.592, 14.657, 14.65684246, -4.872, -4.807, -4.742, -4.676, -4.611, -4.546, -4.481, -4.416, -4.351, -4.286, -4.221, -4.156, -4.091, -4.026, -3.96, -3.895, -3.83, -3.765, -3.7, -3.635, -3.57, -3.505, -3.44, -3.375, -3.309, -3.244, -3.179, -3.114, -3.049, -2.984, -2.919, -2.854, -2.789, -2.724, -2.659, -2.593, -2.528, -2.463, -2.398, -2.333, -2.268, -2.203, -2.138, -2.073, -2.008, -1.942, -1.877, -1.812, -1.747, -1.682, -1.617, -1.552, -1.487, -1.422, -1.357, -1.292, -1.226, -1.161, -1.096, -1.031, -0.966, -0.901, -0.836, -0.771, -0.706, -0.641, -0.575, -0.51, -0.445, -0.38, -0.315, -0.25, -0.185, -0.12, -0.055, 0.01, 0.075, 0.141, 0.206, 0.271, 0.336, 0.401, 0.466, 0.531, 0.596, 0.661, 0.726, 0.792, 0.857, 0.922, 0.987, 1.052, 1.117, 1.182, 1.247, 1.312, 1.377, 1.442, 1.508, 1.573, 1.638, 1.703, 1.768, 1.833, 1.898, 1.963, 2.028, 2.093, 2.159, 2.224, 2.289, 2.354, 2.419, 2.484, 2.549, 2.614, 2.679, 2.744, 2.809, 2.875, 2.94, 3.005, 3.07, 3.135, 3.2, 3.265, 3.33, 3.395, 3.46, 3.526, 3.591, 3.656, 3.721, 3.786, 3.851, 3.916, 3.981, 4.046, 4.111, 4.176, 4.242, 4.307, 4.372, 4.437, 4.502, 4.567, 4.632, 4.697, 4.762, 4.827, 4.893, 4.958, 5.023, 5.088, 5.153, 5.218, 5.283, 5.348, 5.413, 5.478, 5.543, 5.609, 5.674, 5.739, 5.804, 5.869, 5.934, 5.999, 6.064, 6.129, 6.194, 6.26, 6.325, 6.39, 6.455, 6.52, 6.585, 6.65, 6.715, 6.78, 6.845, 6.91, 6.976, 7.041, 7.106, 7.171, 7.236, 7.301, 7.366, 7.431, 7.496, 7.561, 7.627, 7.692, 7.757, 7.822, 7.887, 7.952, 8.017, 8.082, 8.147, 8.212, 8.278, 8.343, 8.408, 8.473, 8.538, 8.603, 8.668, 8.733, 8.798, 8.863, 8.928, 8.994, 9.059, 9.124, 9.189, 9.254, 9.319, 9.384, 9.449, 9.514, 9.579, 9.645, 9.71, 9.775, 9.84, 9.905, 9.97, 10.035, 10.1, 10.165, 10.23, 10.295, 10.361, 10.426, 10.491, 10.556, 10.621, 10.686, 10.751, 10.816, 10.881, 10.946, 11.012, 11.077, 11.142, 11.207, 11.272, 11.337, 11.402, 11.467, 11.532, 11.597, 11.662, 11.728, 11.793, 11.858, 11.923, 11.988, 12.053, 12.118, 12.183, 12.248, 12.313, 12.379, 12.444, 12.509, 12.574, 12.639, 12.704, 12.769, 12.834, 12.899, 12.964, 13.029, 13.095, 13.16, 13.225, 13.29, 13.355, 13.42, 13.485, 13.55, 13.615, 13.68, 13.746, 13.811, 13.876, 13.941, 14.006, 14.071, 14.136, 14.201, 14.266, 14.331, 14.396, 14.462, 14.527, 14.592, 14.657, 14.65684246, -4.872, -4.807, -4.742, -4.676, -4.611, -4.546, -4.481, -4.416, -4.351, -4.286, -4.221, -4.156, -4.091, -4.026, -3.96, -3.895, -3.83, -3.765, -3.7, -3.635, -3.57, -3.505, -3.44, -3.375, -3.309, -3.244, -3.179, -3.114, -3.049, -2.984, -2.919, -2.854, -2.789, -2.724, -2.659, -2.593, -2.528, -2.463, -2.398, -2.333, -2.268, -2.203, -2.138, -2.073, -2.008, -1.942, -1.877, -1.812, -1.747, -1.682, -1.617, -1.552, -1.487, -1.422, -1.357, -1.292, -1.226, -1.161, -1.096, -1.031, -0.966, -0.901, -0.836, -0.771, -0.706, -0.641, -0.575, -0.51, -0.445, -0.38, -0.315, -0.25, -0.185, -0.12, -0.055, 0.01, 0.075, 0.141, 0.206, 0.271, 0.336, 0.401, 0.466, 0.531, 0.596, 0.661, 0.726, 0.792, 0.857, 0.922, 0.987, 1.052, 1.117, 1.182, 1.247, 1.312, 1.377, 1.442, 1.508, 1.573, 1.638, 1.703, 1.768, 1.833, 1.898, 1.963, 2.028, 2.093, 2.159, 2.224, 2.289, 2.354, 2.419, 2.484, 2.549, 2.614, 2.679, 2.744, 2.809, 2.875, 2.94, 3.005, 3.07, 3.135, 3.2, 3.265, 3.33, 3.395, 3.46, 3.526, 3.591, 3.656, 3.721, 3.786, 3.851, 3.916, 3.981, 4.046, 4.111, 4.176, 4.242, 4.307, 4.372, 4.437, 4.502, 4.567, 4.632, 4.697, 4.762, 4.827, 4.893, 4.958, 5.023, 5.088, 5.153, 5.218, 5.283, 5.348, 5.413, 5.478, 5.543, 5.609, 5.674, 5.739, 5.804, 5.869, 5.934, 5.999, 6.064, 6.129, 6.194, 6.26, 6.325, 6.39, 6.455, 6.52, 6.585, 6.65, 6.715, 6.78, 6.845, 6.91, 6.976, 7.041, 7.106, 7.171, 7.236, 7.301, 7.366, 7.431, 7.496, 7.561, 7.627, 7.692, 7.757, 7.822, 7.887, 7.952, 8.017, 8.082, 8.147, 8.212, 8.278, 8.343, 8.408, 8.473, 8.538, 8.603, 8.668, 8.733, 8.798, 8.863, 8.928, 8.994, 9.059, 9.124, 9.189, 9.254, 9.319, 9.384, 9.449, 9.514, 9.579, 9.645, 9.71, 9.775, 9.84, 9.905, 9.97, 10.035, 10.1, 10.165, 10.23, 10.295, 10.361, 10.426, 10.491, 10.556, 10.621, 10.686, 10.751, 10.816, 10.881, 10.946, 11.012, 11.077, 11.142, 11.207, 11.272, 11.337, 11.402, 11.467, 11.532, 11.597, 11.662, 11.728, 11.793, 11.858, 11.923, 11.988, 12.053, 12.118, 12.183, 12.248, 12.313, 12.379, 12.444, 12.509, 12.574, 12.639, 12.704, 12.769, 12.834, 12.899, 12.964, 13.029, 13.095, 13.16, 13.225, 13.29, 13.355, 13.42, 13.485, 13.55, 13.615, 13.68, 13.746, 13.811, 13.876, 13.941, 14.006, 14.071, 14.136, 14.201, 14.266, 14.331, 14.396, 14.462, 14.527, 14.592, 14.657, 14.65684246, -4.872, -4.807, -4.742, -4.676, -4.611, -4.546, -4.481, -4.416, -4.351, -4.286, -4.221, -4.156, -4.091, -4.026, -3.96, -3.895, -3.83, -3.765, -3.7, -3.635, -3.57, -3.505, -3.44, -3.375, -3.309, -3.244, -3.179, -3.114, -3.049, -2.984, -2.919, -2.854, -2.789, -2.724, -2.659, -2.593, -2.528, -2.463, -2.398, -2.333, -2.268, -2.203, -2.138, -2.073, -2.008, -1.942, -1.877, -1.812, -1.747, -1.682, -1.617, -1.552, -1.487, -1.422, -1.357, -1.292, -1.226, -1.161, -1.096, -1.031, -0.966, -0.901, -0.836, -0.771, -0.706, -0.641, -0.575, -0.51, -0.445, -0.38, -0.315, -0.25, -0.185, -0.12, -0.055, 0.01, 0.075, 0.141, 0.206, 0.271, 0.336, 0.401, 0.466, 0.531, 0.596, 0.661, 0.726, 0.792, 0.857, 0.922, 0.987, 1.052, 1.117, 1.182, 1.247, 1.312, 1.377, 1.442, 1.508, 1.573, 1.638, 1.703, 1.768, 1.833, 1.898, 1.963, 2.028, 2.093, 2.159, 2.224, 2.289, 2.354, 2.419, 2.484, 2.549, 2.614, 2.679, 2.744, 2.809, 2.875, 2.94, 3.005, 3.07, 3.135, 3.2, 3.265, 3.33, 3.395, 3.46, 3.526, 3.591, 3.656, 3.721, 3.786, 3.851, 3.916, 3.981, 4.046, 4.111, 4.176, 4.242, 4.307, 4.372, 4.437, 4.502, 4.567, 4.632, 4.697, 4.762, 4.827, 4.893, 4.958, 5.023, 5.088, 5.153, 5.218, 5.283, 5.348, 5.413, 5.478, 5.543, 5.609, 5.674, 5.739, 5.804, 5.869, 5.934, 5.999, 6.064, 6.129, 6.194, 6.26, 6.325, 6.39, 6.455, 6.52, 6.585, 6.65, 6.715, 6.78, 6.845, 6.91, 6.976, 7.041, 7.106, 7.171, 7.236, 7.301, 7.366, 7.431, 7.496, 7.561, 7.627, 7.692, 7.757, 7.822, 7.887, 7.952, 8.017, 8.082, 8.147, 8.212, 8.278, 8.343, 8.408, 8.473, 8.538, 8.603, 8.668, 8.733, 8.798, 8.863, 8.928, 8.994, 9.059, 9.124, 9.189, 9.254, 9.319, 9.384, 9.449, 9.514, 9.579, 9.645, 9.71, 9.775, 9.84, 9.905, 9.97, 10.035, 10.1, 10.165, 10.23, 10.295, 10.361, 10.426, 10.491, 10.556, 10.621, 10.686, 10.751, 10.816, 10.881, 10.946, 11.012, 11.077, 11.142, 11.207, 11.272, 11.337, 11.402, 11.467, 11.532, 11.597, 11.662, 11.728, 11.793, 11.858, 11.923, 11.988, 12.053, 12.118, 12.183, 12.248, 12.313, 12.379, 12.444, 12.509, 12.574, 12.639, 12.704, 12.769, 12.834, 12.899, 12.964, 13.029, 13.095, 13.16, 13.225, 13.29, 13.355, 13.42, 13.485, 13.55, 13.615, 13.68, 13.746, 13.811, 13.876, 13.941, 14.006, 14.071, 14.136, 14.201, 14.266, 14.331, 14.396, 14.462, 14.527, 14.592, 14.657]]
        N =  [[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.6045e-07, 3.6175e-06, 2.30575e-05, 0.000156675, 0.00096725, 0.004395, 0.0112075, 0.0161225, 0.022395, 0.02785, 0.0239825, 0.032175, 0.038525, 0.03535, 0.039975, 0.0389, 0.036325, 0.052575, 0.052975, 0.052925, 0.04605, 0.03685, 0.055275, 0.0704, 0.06075, 0.0675, 0.051525, 0.0479, 0.068975, 0.0714, 0.0652, 0.065275, 0.065025, 0.089125, 0.077975, 0.071075, 0.07265, 0.04975, 0.064925, 0.095275, 0.09195, 0.1011, 0.089775, 0.0728, 0.0737, 0.076025, 0.086, 0.09075, 0.0734, 0.1068, 0.10915, 0.1032, 0.09365, 0.06805, 0.094125, 0.1227, 0.10735, 0.096875, 0.070525, 0.088575, 0.111825, 0.10965, 0.112975, 0.1069, 0.119675, 0.15575, 0.109275, 0.083725, 0.083775, 0.075125, 0.11245, 0.136225, 0.147725, 0.122925, 0.109675, 0.133625, 0.129375, 0.130025, 0.124375, 0.09105, 0.125325, 0.138325, 0.1408, 0.13765, 0.124375, 0.152675, 0.12645, 0.125475, 0.159125, 0.125, 0.143775, 0.158575, 0.129, 0.120525, 0.10985, 0.13085, 0.12255, 0.10105, 0.0935, 0.115775, 0.172575, 0.17115, 0.168625, 0.17385, 0.1538, 0.12235, 0.090675, 0.134325, 0.18515, 0.18395, 0.153325, 0.127025, 0.145575, 0.17075, 0.1922, 0.1723, 0.1153, 0.108325, 0.132375, 0.1535, 0.17365, 0.13125, 0.129675, 0.152975, 0.161525, 0.167975, 0.15735, 0.182625, 0.1648, 0.1642, 0.162575, 0.1736, 0.20335, 0.1647, 0.142375, 0.1369, 0.139975, 0.17365, 0.176225, 0.2022, 0.200725, 0.17405, 0.1524, 0.10855, 0.123875, 0.117775, 0.1255, 0.168525, 0.18195, 0.1468, 0.083925, 0.094075, 0.17485, 0.235475, 0.281, 0.26025, 0.21005, 0.190675, 0.17145, 0.154975, 0.1263, 0.1328, 0.117075, 0.14715, 0.221025, 0.220725, 0.197575, 0.17645, 0.156675, 0.13865, 0.155675, 0.199875, 0.214275, 0.157625, 0.14215, 0.150125, 0.171125, 0.178275, 0.193, 0.206325, 0.14745, 0.1431, 0.181275, 0.148725, 0.109125, 0.1788, 0.26025, 0.223075, 0.17205, 0.14265, 0.155925, 0.173825, 0.162025, 0.203125, 0.23975, 0.2341, 0.20045, 0.14485, 0.153325, 0.175725, 0.1901, 0.238225, 0.2525, 0.2308, 0.18715, 0.1303, 0.11645, 0.149375, 0.172525, 0.201125, 0.25775, 0.2965, 0.273, 0.1839, 0.1136, 0.112275, 0.137125, 0.170925, 0.2088, 0.208525, 0.147825, 0.1037, 0.090475, 0.093325, 0.117075, 0.1285, 0.156475, 0.121825, 0.0419, 0.0208325, 0.029525, 0.043075, 0.0615, 0.071875, 0.07675, 0.089125, 0.08775, 0.0682, 0.039, 0.0121275, 0.0037125, 0.0103975, 0.036375, 0.05685, 0.059325, 0.047975, 0.0258, 0.0198375, 0.02515, 0.028875, 0.0189575, 0.029225, 0.035475, 0.048325, 0.03655, 0.01172, 0.0091025, 0.0127625, 0.0054425, 0.00123375, 0.001538, 0.0083825, 0.0326, 0.048775, 0.025275, 0.0055975, 0.00087825, 0.000118325, 0.0004215, 0.0025725, 0.0097975, 0.0113825, 0.0041175, 0.00376, 0.0102625, 0.01045, 0.00402, 0.0032375, 0.00421, 0.0016685, 0.00030975, 4.72e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7691246675, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37325e-08, 3.08e-07, 1.96225e-06, 1.33275e-05, 8.225e-05, 0.000373, 0.00094875, 0.00135725, 0.00187, 0.002314, 0.00197575, 0.002625, 0.0031225, 0.0028425, 0.0031875, 0.003085, 0.0028475, 0.00409, 0.0040925, 0.0040525, 0.003505, 0.0027725, 0.004115, 0.00521, 0.00446, 0.0049125, 0.003725, 0.003415, 0.0048775, 0.005015, 0.0045375, 0.0045025, 0.0044325, 0.006025, 0.005235, 0.0047175, 0.004785, 0.003245, 0.00417, 0.0060775, 0.005815, 0.006325, 0.005575, 0.004465, 0.00447, 0.0045625, 0.0050975, 0.0053425, 0.0042625, 0.006125, 0.00621, 0.0058, 0.005215, 0.0037375, 0.0050925, 0.00658, 0.005685, 0.005065, 0.0036425, 0.0044975, 0.005625, 0.00545, 0.00554, 0.005165, 0.0056625, 0.00731, 0.0050925, 0.0038175, 0.00375, 0.00327, 0.0048225, 0.005785, 0.0061875, 0.0050975, 0.004435, 0.0052975, 0.00501, 0.00483, 0.00454, 0.0032625, 0.0043225, 0.004645, 0.004655, 0.0043375, 0.00353, 0.00402, 0.003215, 0.0034, 0.004175, 0.003085, 0.0035525, 0.00392, 0.003125, 0.0026825, 0.0022335, 0.0027375, 0.0028575, 0.0029675, 0.0029025, 0.00372, 0.0046975, 0.0040975, 0.004505, 0.004405, 0.0043825, 0.0042875, 0.002915, 0.00396, 0.00543, 0.0051725, 0.00341, 0.0026975, 0.0043775, 0.0046875, 0.00459, 0.004375, 0.00364, 0.0037075, 0.004225, 0.0043175, 0.00436, 0.0034975, 0.00321, 0.0036825, 0.0042375, 0.0042175, 0.003835, 0.00448, 0.003915, 0.003875, 0.00356, 0.003705, 0.004115, 0.00306, 0.0025025, 0.002685, 0.0029175, 0.003015, 0.00283, 0.003405, 0.0033575, 0.0029475, 0.00248925, 0.00170675, 0.00194925, 0.001838, 0.001972, 0.002965, 0.0039875, 0.0034775, 0.00175225, 0.00161475, 0.003645, 0.005975, 0.006835, 0.0056325, 0.0051075, 0.00486, 0.00359, 0.002413, 0.0021545, 0.002685, 0.00218975, 0.0029325, 0.003995, 0.0039225, 0.00423, 0.0037525, 0.003035, 0.00235575, 0.0025225, 0.0035575, 0.003965, 0.00234625, 0.00138975, 0.00164475, 0.0024915, 0.003, 0.003555, 0.0039225, 0.0026025, 0.002805, 0.00421, 0.003905, 0.0039775, 0.005995, 0.0071075, 0.0042225, 0.0026675, 0.0029575, 0.004745, 0.00641, 0.0051, 0.005995, 0.00681, 0.0066375, 0.0056225, 0.0043225, 0.0038875, 0.00351, 0.003675, 0.0072525, 0.00859, 0.0072175, 0.0064525, 0.0046675, 0.0049625, 0.0062425, 0.005, 0.00378, 0.00464, 0.0071325, 0.008145, 0.0056725, 0.0037275, 0.0036, 0.0033425, 0.00419, 0.00504, 0.00475, 0.003425, 0.0027075, 0.002006, 0.002167, 0.00193075, 0.00196625, 0.0028675, 0.0020745, 0.00056125, 0.00016115, 0.00033225, 0.0009585, 0.001889, 0.001688, 0.00101975, 0.00094125, 0.0010485, 0.0007425, 0.000447, 0.000153625, 6.72e-05, 0.00025325, 0.000807, 0.00093125, 0.00074, 0.00051125, 0.0002845, 0.0001982, 7.725e-05, 4.2375e-05, 2.9275e-05, 7.0825e-05, 0.000239325, 0.00063175, 0.0005925, 0.000183775, 5.4975e-05, 4.545e-05, 1.79175e-05, 3.755e-06, 2.9725e-06, 1.574e-05, 7.8325e-05, 0.000187675, 0.000129975, 3.09e-05, 4.9675e-06, 3.4625e-07, 6.2525e-07, 3.815e-06, 1.4515e-05, 1.67875e-05, 5.4725e-06, 1.887e-06, 3.2525e-06, 3.095e-06, 1.00325e-06, 1.789e-07, 2.16775e-08, 1.51625e-10, 2.815e-11, 4.2875e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7691246675, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37325e-08, 3.08e-07, 1.96225e-06, 1.33275e-05, 8.225e-05, 0.000373, 0.00094875, 0.00135725, 0.00187, 0.002314, 0.00197575, 0.002625, 0.0031225, 0.0028425, 0.0031875, 0.003085, 0.0028475, 0.00409, 0.0040925, 0.0040525, 0.003505, 0.0027725, 0.004115, 0.00521, 0.00446, 0.0049125, 0.003725, 0.003415, 0.0048775, 0.005015, 0.0045375, 0.0045025, 0.0044325, 0.006025, 0.005235, 0.0047175, 0.004785, 0.003245, 0.00417, 0.0060775, 0.005815, 0.006325, 0.005575, 0.004465, 0.00447, 0.0045625, 0.0050975, 0.0053425, 0.0042625, 0.006125, 0.00621, 0.0058, 0.005215, 0.0037375, 0.0050925, 0.00658, 0.005685, 0.005065, 0.0036425, 0.0044975, 0.005625, 0.00545, 0.00554, 0.005165, 0.0056625, 0.00731, 0.0050925, 0.0038175, 0.00375, 0.00327, 0.0048225, 0.005785, 0.0061875, 0.0050975, 0.004435, 0.0052975, 0.00501, 0.00483, 0.00454, 0.0032625, 0.0043225, 0.004645, 0.004655, 0.0043375, 0.00353, 0.00402, 0.003215, 0.0034, 0.004175, 0.003085, 0.0035525, 0.00392, 0.003125, 0.0026825, 0.0022335, 0.0027375, 0.0028575, 0.0029675, 0.0029025, 0.00372, 0.0046975, 0.0040975, 0.004505, 0.004405, 0.0043825, 0.0042875, 0.002915, 0.00396, 0.00543, 0.0051725, 0.00341, 0.0026975, 0.0043775, 0.0046875, 0.00459, 0.004375, 0.00364, 0.0037075, 0.004225, 0.0043175, 0.00436, 0.0034975, 0.00321, 0.0036825, 0.0042375, 0.0042175, 0.003835, 0.00448, 0.003915, 0.003875, 0.00356, 0.003705, 0.004115, 0.00306, 0.0025025, 0.002685, 0.0029175, 0.003015, 0.00283, 0.003405, 0.0033575, 0.0029475, 0.00248925, 0.00170675, 0.00194925, 0.001838, 0.001972, 0.002965, 0.0039875, 0.0034775, 0.00175225, 0.00161475, 0.003645, 0.005975, 0.006835, 0.0056325, 0.0051075, 0.00486, 0.00359, 0.002413, 0.0021545, 0.002685, 0.00218975, 0.0029325, 0.003995, 0.0039225, 0.00423, 0.0037525, 0.003035, 0.00235575, 0.0025225, 0.0035575, 0.003965, 0.00234625, 0.00138975, 0.00164475, 0.0024915, 0.003, 0.003555, 0.0039225, 0.0026025, 0.002805, 0.00421, 0.003905, 0.0039775, 0.005995, 0.0071075, 0.0042225, 0.0026675, 0.0029575, 0.004745, 0.00641, 0.0051, 0.005995, 0.00681, 0.0066375, 0.0056225, 0.0043225, 0.0038875, 0.00351, 0.003675, 0.0072525, 0.00859, 0.0072175, 0.0064525, 0.0046675, 0.0049625, 0.0062425, 0.005, 0.00378, 0.00464, 0.0071325, 0.008145, 0.0056725, 0.0037275, 0.0036, 0.0033425, 0.00419, 0.00504, 0.00475, 0.003425, 0.0027075, 0.002006, 0.002167, 0.00193075, 0.00196625, 0.0028675, 0.0020745, 0.00056125, 0.00016115, 0.00033225, 0.0009585, 0.001889, 0.001688, 0.00101975, 0.00094125, 0.0010485, 0.0007425, 0.000447, 0.000153625, 6.72e-05, 0.00025325, 0.000807, 0.00093125, 0.00074, 0.00051125, 0.0002845, 0.0001982, 7.725e-05, 4.2375e-05, 2.9275e-05, 7.0825e-05, 0.000239325, 0.00063175, 0.0005925, 0.000183775, 5.4975e-05, 4.545e-05, 1.79175e-05, 3.755e-06, 2.9725e-06, 1.574e-05, 7.8325e-05, 0.000187675, 0.000129975, 3.09e-05, 4.9675e-06, 3.4625e-07, 6.2525e-07, 3.815e-06, 1.4515e-05, 1.67875e-05, 5.4725e-06, 1.887e-06, 3.2525e-06, 3.095e-06, 1.00325e-06, 1.789e-07, 2.16775e-08, 1.51625e-10, 2.815e-11, 4.2875e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7691246675, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37325e-08, 3.08e-07, 1.96225e-06, 1.33275e-05, 8.225e-05, 0.000373, 0.00094875, 0.00135725, 0.00187, 0.002314, 0.00197575, 0.002625, 0.0031225, 0.0028425, 0.0031875, 0.003085, 0.0028475, 0.00409, 0.0040925, 0.0040525, 0.003505, 0.0027725, 0.004115, 0.00521, 0.00446, 0.0049125, 0.003725, 0.003415, 0.0048775, 0.005015, 0.0045375, 0.0045025, 0.0044325, 0.006025, 0.005235, 0.0047175, 0.004785, 0.003245, 0.00417, 0.0060775, 0.005815, 0.006325, 0.005575, 0.004465, 0.00447, 0.0045625, 0.0050975, 0.0053425, 0.0042625, 0.006125, 0.00621, 0.0058, 0.005215, 0.0037375, 0.0050925, 0.00658, 0.005685, 0.005065, 0.0036425, 0.0044975, 0.005625, 0.00545, 0.00554, 0.005165, 0.0056625, 0.00731, 0.0050925, 0.0038175, 0.00375, 0.00327, 0.0048225, 0.005785, 0.0061875, 0.0050975, 0.004435, 0.0052975, 0.00501, 0.00483, 0.00454, 0.0032625, 0.0043225, 0.004645, 0.004655, 0.0043375, 0.00353, 0.00402, 0.003215, 0.0034, 0.004175, 0.003085, 0.0035525, 0.00392, 0.003125, 0.0026825, 0.0022335, 0.0027375, 0.0028575, 0.0029675, 0.0029025, 0.00372, 0.0046975, 0.0040975, 0.004505, 0.004405, 0.0043825, 0.0042875, 0.002915, 0.00396, 0.00543, 0.0051725, 0.00341, 0.0026975, 0.0043775, 0.0046875, 0.00459, 0.004375, 0.00364, 0.0037075, 0.004225, 0.0043175, 0.00436, 0.0034975, 0.00321, 0.0036825, 0.0042375, 0.0042175, 0.003835, 0.00448, 0.003915, 0.003875, 0.00356, 0.003705, 0.004115, 0.00306, 0.0025025, 0.002685, 0.0029175, 0.003015, 0.00283, 0.003405, 0.0033575, 0.0029475, 0.00248925, 0.00170675, 0.00194925, 0.001838, 0.001972, 0.002965, 0.0039875, 0.0034775, 0.00175225, 0.00161475, 0.003645, 0.005975, 0.006835, 0.0056325, 0.0051075, 0.00486, 0.00359, 0.002413, 0.0021545, 0.002685, 0.00218975, 0.0029325, 0.003995, 0.0039225, 0.00423, 0.0037525, 0.003035, 0.00235575, 0.0025225, 0.0035575, 0.003965, 0.00234625, 0.00138975, 0.00164475, 0.0024915, 0.003, 0.003555, 0.0039225, 0.0026025, 0.002805, 0.00421, 0.003905, 0.0039775, 0.005995, 0.0071075, 0.0042225, 0.0026675, 0.0029575, 0.004745, 0.00641, 0.0051, 0.005995, 0.00681, 0.0066375, 0.0056225, 0.0043225, 0.0038875, 0.00351, 0.003675, 0.0072525, 0.00859, 0.0072175, 0.0064525, 0.0046675, 0.0049625, 0.0062425, 0.005, 0.00378, 0.00464, 0.0071325, 0.008145, 0.0056725, 0.0037275, 0.0036, 0.0033425, 0.00419, 0.00504, 0.00475, 0.003425, 0.0027075, 0.002006, 0.002167, 0.00193075, 0.00196625, 0.0028675, 0.0020745, 0.00056125, 0.00016115, 0.00033225, 0.0009585, 0.001889, 0.001688, 0.00101975, 0.00094125, 0.0010485, 0.0007425, 0.000447, 0.000153625, 6.72e-05, 0.00025325, 0.000807, 0.00093125, 0.00074, 0.00051125, 0.0002845, 0.0001982, 7.725e-05, 4.2375e-05, 2.9275e-05, 7.0825e-05, 0.000239325, 0.00063175, 0.0005925, 0.000183775, 5.4975e-05, 4.545e-05, 1.79175e-05, 3.755e-06, 2.9725e-06, 1.574e-05, 7.8325e-05, 0.000187675, 0.000129975, 3.09e-05, 4.9675e-06, 3.4625e-07, 6.2525e-07, 3.815e-06, 1.4515e-05, 1.67875e-05, 5.4725e-06, 1.887e-06, 3.2525e-06, 3.095e-06, 1.00325e-06, 1.789e-07, 2.16775e-08, 1.51625e-10, 2.815e-11, 4.2875e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7691246675, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37325e-08, 3.08e-07, 1.96225e-06, 1.33275e-05, 8.225e-05, 0.000373, 0.00094875, 0.00135725, 0.00187, 0.002314, 0.00197575, 0.002625, 0.0031225, 0.0028425, 0.0031875, 0.003085, 0.0028475, 0.00409, 0.0040925, 0.0040525, 0.003505, 0.0027725, 0.004115, 0.00521, 0.00446, 0.0049125, 0.003725, 0.003415, 0.0048775, 0.005015, 0.0045375, 0.0045025, 0.0044325, 0.006025, 0.005235, 0.0047175, 0.004785, 0.003245, 0.00417, 0.0060775, 0.005815, 0.006325, 0.005575, 0.004465, 0.00447, 0.0045625, 0.0050975, 0.0053425, 0.0042625, 0.006125, 0.00621, 0.0058, 0.005215, 0.0037375, 0.0050925, 0.00658, 0.005685, 0.005065, 0.0036425, 0.0044975, 0.005625, 0.00545, 0.00554, 0.005165, 0.0056625, 0.00731, 0.0050925, 0.0038175, 0.00375, 0.00327, 0.0048225, 0.005785, 0.0061875, 0.0050975, 0.004435, 0.0052975, 0.00501, 0.00483, 0.00454, 0.0032625, 0.0043225, 0.004645, 0.004655, 0.0043375, 0.00353, 0.00402, 0.003215, 0.0034, 0.004175, 0.003085, 0.0035525, 0.00392, 0.003125, 0.0026825, 0.0022335, 0.0027375, 0.0028575, 0.0029675, 0.0029025, 0.00372, 0.0046975, 0.0040975, 0.004505, 0.004405, 0.0043825, 0.0042875, 0.002915, 0.00396, 0.00543, 0.0051725, 0.00341, 0.0026975, 0.0043775, 0.0046875, 0.00459, 0.004375, 0.00364, 0.0037075, 0.004225, 0.0043175, 0.00436, 0.0034975, 0.00321, 0.0036825, 0.0042375, 0.0042175, 0.003835, 0.00448, 0.003915, 0.003875, 0.00356, 0.003705, 0.004115, 0.00306, 0.0025025, 0.002685, 0.0029175, 0.003015, 0.00283, 0.003405, 0.0033575, 0.0029475, 0.00248925, 0.00170675, 0.00194925, 0.001838, 0.001972, 0.002965, 0.0039875, 0.0034775, 0.00175225, 0.00161475, 0.003645, 0.005975, 0.006835, 0.0056325, 0.0051075, 0.00486, 0.00359, 0.002413, 0.0021545, 0.002685, 0.00218975, 0.0029325, 0.003995, 0.0039225, 0.00423, 0.0037525, 0.003035, 0.00235575, 0.0025225, 0.0035575, 0.003965, 0.00234625, 0.00138975, 0.00164475, 0.0024915, 0.003, 0.003555, 0.0039225, 0.0026025, 0.002805, 0.00421, 0.003905, 0.0039775, 0.005995, 0.0071075, 0.0042225, 0.0026675, 0.0029575, 0.004745, 0.00641, 0.0051, 0.005995, 0.00681, 0.0066375, 0.0056225, 0.0043225, 0.0038875, 0.00351, 0.003675, 0.0072525, 0.00859, 0.0072175, 0.0064525, 0.0046675, 0.0049625, 0.0062425, 0.005, 0.00378, 0.00464, 0.0071325, 0.008145, 0.0056725, 0.0037275, 0.0036, 0.0033425, 0.00419, 0.00504, 0.00475, 0.003425, 0.0027075, 0.002006, 0.002167, 0.00193075, 0.00196625, 0.0028675, 0.0020745, 0.00056125, 0.00016115, 0.00033225, 0.0009585, 0.001889, 0.001688, 0.00101975, 0.00094125, 0.0010485, 0.0007425, 0.000447, 0.000153625, 6.72e-05, 0.00025325, 0.000807, 0.00093125, 0.00074, 0.00051125, 0.0002845, 0.0001982, 7.725e-05, 4.2375e-05, 2.9275e-05, 7.0825e-05, 0.000239325, 0.00063175, 0.0005925, 0.000183775, 5.4975e-05, 4.545e-05, 1.79175e-05, 3.755e-06, 2.9725e-06, 1.574e-05, 7.8325e-05, 0.000187675, 0.000129975, 3.09e-05, 4.9675e-06, 3.4625e-07, 6.2525e-07, 3.815e-06, 1.4515e-05, 1.67875e-05, 5.4725e-06, 1.887e-06, 3.2525e-06, 3.095e-06, 1.00325e-06, 1.789e-07, 2.16775e-08, 1.51625e-10, 2.815e-11, 4.2875e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.91625e-07, 4.2875e-06, 2.6325e-05, 0.000172875, 0.00103, 0.0045475, 0.011435, 0.0165175, 0.0229525, 0.028275, 0.0247325, 0.03305, 0.039175, 0.036175, 0.040975, 0.03945, 0.037875, 0.053775, 0.05395, 0.05395, 0.0463, 0.0384, 0.057675, 0.07125, 0.06225, 0.0685, 0.051525, 0.050425, 0.071, 0.072225, 0.066675, 0.06615, 0.0682, 0.091025, 0.0781, 0.073275, 0.07235, 0.0505, 0.0697, 0.0974, 0.0939, 0.1035, 0.08895, 0.07435, 0.0754, 0.077825, 0.0895, 0.090075, 0.077, 0.11125, 0.109525, 0.105575, 0.09195, 0.0703, 0.10045, 0.123975, 0.108125, 0.0961, 0.071675, 0.09425, 0.114, 0.11145, 0.115575, 0.107375, 0.1275, 0.156125, 0.105825, 0.086025, 0.0833, 0.078975, 0.1185, 0.139425, 0.1504, 0.121175, 0.1144, 0.136075, 0.129925, 0.1327, 0.1232, 0.09345, 0.12925, 0.140225, 0.143975, 0.13605, 0.126025, 0.153575, 0.129625, 0.1319, 0.1578, 0.127225, 0.14775, 0.160425, 0.130075, 0.120475, 0.112175, 0.1354, 0.12975, 0.10545, 0.098275, 0.1231, 0.1686, 0.17915, 0.170725, 0.1768, 0.164525, 0.118175, 0.094175, 0.146625, 0.191625, 0.176675, 0.1451, 0.1415, 0.157475, 0.1691, 0.193425, 0.1753, 0.121075, 0.11515, 0.133625, 0.154475, 0.171775, 0.132675, 0.134525, 0.158775, 0.169775, 0.165, 0.1598, 0.180025, 0.161875, 0.16625, 0.1645, 0.18125, 0.203675, 0.156225, 0.149225, 0.14745, 0.14175, 0.168175, 0.177225, 0.206675, 0.19975, 0.1786, 0.1568, 0.1169, 0.128175, 0.12045, 0.13325, 0.1753, 0.184675, 0.137925, 0.08435, 0.111425, 0.196675, 0.244725, 0.2705, 0.25875, 0.22035, 0.185425, 0.165725, 0.1515, 0.134675, 0.135375, 0.12545, 0.159275, 0.215375, 0.2278, 0.20765, 0.178425, 0.1528, 0.136775, 0.1604, 0.206225, 0.20395, 0.14855, 0.14525, 0.169875, 0.1891, 0.1858, 0.197825, 0.200425, 0.157825, 0.162725, 0.192475, 0.157575, 0.132225, 0.1702, 0.22505, 0.225525, 0.20175, 0.18375, 0.157925, 0.15655, 0.167325, 0.230075, 0.25475, 0.209375, 0.18505, 0.14555, 0.1482, 0.20125, 0.26125, 0.257, 0.2412, 0.2119, 0.16495, 0.165125, 0.132425, 0.11345, 0.150225, 0.23635, 0.31925, 0.3275, 0.224125, 0.153525, 0.11105, 0.1088, 0.166075, 0.20635, 0.202525, 0.179075, 0.12965, 0.0928, 0.09825, 0.082075, 0.105425, 0.15515, 0.141475, 0.085975, 0.03555, 0.022585, 0.053925, 0.0714, 0.050825, 0.048625, 0.080375, 0.095375, 0.07875, 0.0622, 0.029825, 0.009175, 0.0126775, 0.030225, 0.0387, 0.05095, 0.05125, 0.0452, 0.02515, 0.013455, 0.0193225, 0.028075, 0.0222975, 0.03895, 0.05935, 0.047325, 0.0148125, 0.004335, 0.0080525, 0.01255, 0.00544, 0.001398, 0.0023495, 0.0118025, 0.038375, 0.04735, 0.020325, 0.004305, 0.00070275, 0.0001469, 0.000562, 0.0032175, 0.0107525, 0.01066, 0.0035375, 0.003025, 0.0094875, 0.011725, 0.00468, 0.0033425, 0.0042925, 0.00178025, 0.00034725, 5.5025e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.805643605, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.5945e-08, 3.5475e-07, 2.17775e-06, 1.42975e-05, 8.5175e-05, 0.0003755, 0.00094125, 0.00135225, 0.0018645, 0.00228475, 0.0019825, 0.002625, 0.0030925, 0.002835, 0.0031825, 0.003045, 0.00289, 0.004075, 0.0040625, 0.0040275, 0.003435, 0.002815, 0.0041875, 0.005145, 0.0044575, 0.004865, 0.003635, 0.00351, 0.004905, 0.004955, 0.0045325, 0.0044575, 0.0045425, 0.0060175, 0.0051275, 0.0047575, 0.004665, 0.0032225, 0.0043825, 0.006085, 0.0058125, 0.0063475, 0.0054125, 0.00447, 0.004485, 0.00458, 0.0052075, 0.0052025, 0.004385, 0.00627, 0.00612, 0.00583, 0.005035, 0.003795, 0.0053475, 0.006545, 0.0056375, 0.0049525, 0.003645, 0.00472, 0.0056525, 0.005465, 0.0055925, 0.00512, 0.0059625, 0.00725, 0.0048725, 0.0038775, 0.00369, 0.0034075, 0.005045, 0.005875, 0.006255, 0.004985, 0.0045925, 0.005365, 0.005005, 0.0049175, 0.00449, 0.0033375, 0.004465, 0.0047275, 0.0047975, 0.0043125, 0.0036025, 0.0040975, 0.0033175, 0.00361, 0.0041875, 0.00316, 0.0037, 0.0039725, 0.00317, 0.00275, 0.00236925, 0.002965, 0.003275, 0.003235, 0.0031525, 0.0039175, 0.004335, 0.004485, 0.0047025, 0.00455, 0.0047375, 0.00376, 0.002955, 0.004605, 0.0056325, 0.004685, 0.0029125, 0.003305, 0.00473, 0.00445, 0.0046225, 0.00432, 0.003735, 0.003815, 0.0041425, 0.00432, 0.00425, 0.00337, 0.003295, 0.00378, 0.004345, 0.00405, 0.003945, 0.0044525, 0.00386, 0.0039075, 0.003485, 0.003895, 0.0042775, 0.0029275, 0.0025825, 0.00286, 0.002935, 0.002905, 0.002915, 0.0036375, 0.0033675, 0.0031, 0.0025925, 0.00178175, 0.002014, 0.001955, 0.0025175, 0.0039375, 0.004195, 0.00272, 0.00138625, 0.00217325, 0.0047, 0.00662, 0.006645, 0.0058525, 0.0052525, 0.00438, 0.0032125, 0.002372, 0.00246125, 0.002605, 0.00240475, 0.0033725, 0.0040325, 0.0043475, 0.0042425, 0.003695, 0.00302, 0.00237925, 0.002725, 0.0038925, 0.003635, 0.00207175, 0.001503, 0.0020565, 0.003345, 0.0040325, 0.0037875, 0.0038, 0.0038075, 0.00427, 0.00509, 0.0048975, 0.0054575, 0.00454, 0.0037575, 0.0038225, 0.0051675, 0.0068875, 0.005275, 0.00443, 0.00491, 0.00679, 0.0076875, 0.0055225, 0.0039775, 0.0033425, 0.0030325, 0.00513, 0.008075, 0.0078625, 0.00763, 0.005995, 0.0046275, 0.00632, 0.0055825, 0.0036625, 0.003225, 0.00536, 0.007425, 0.0079975, 0.0055375, 0.00413, 0.003685, 0.003235, 0.003835, 0.00483, 0.00447, 0.00369, 0.0028725, 0.00214625, 0.00206325, 0.001495, 0.00178025, 0.0026575, 0.00212525, 0.000818, 0.000237975, 0.00037875, 0.0013335, 0.0019935, 0.0012795, 0.0007115, 0.00100925, 0.0012505, 0.000741, 0.00047125, 0.000235875, 0.0001163, 0.00033475, 0.0008015, 0.00075425, 0.0007285, 0.000532, 0.00039225, 0.00025275, 7.8975e-05, 3.5425e-05, 4.52e-05, 6.2375e-05, 0.000228975, 0.00064825, 0.00065975, 0.000212325, 4.4125e-05, 3.305e-05, 4.5225e-05, 1.958e-05, 4.8125e-06, 7.1475e-06, 3.815e-05, 0.000138625, 0.000172925, 7.2525e-05, 1.525e-05, 2.491e-06, 3.6025e-07, 9.7325e-07, 5.5725e-06, 1.8605e-05, 1.83725e-05, 5.56e-06, 1.895e-06, 3.7575e-06, 4.4525e-06, 1.561e-06, 2.8675e-07, 4.4975e-08, 1.95875e-11, 3.8225e-12, 6.055e-13, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.805643605, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.5945e-08, 3.5475e-07, 2.17775e-06, 1.42975e-05, 8.5175e-05, 0.0003755, 0.00094125, 0.00135225, 0.0018645, 0.00228475, 0.0019825, 0.002625, 0.0030925, 0.002835, 0.0031825, 0.003045, 0.00289, 0.004075, 0.0040625, 0.0040275, 0.003435, 0.002815, 0.0041875, 0.005145, 0.0044575, 0.004865, 0.003635, 0.00351, 0.004905, 0.004955, 0.0045325, 0.0044575, 0.0045425, 0.0060175, 0.0051275, 0.0047575, 0.004665, 0.0032225, 0.0043825, 0.006085, 0.0058125, 0.0063475, 0.0054125, 0.00447, 0.004485, 0.00458, 0.0052075, 0.0052025, 0.004385, 0.00627, 0.00612, 0.00583, 0.005035, 0.003795, 0.0053475, 0.006545, 0.0056375, 0.0049525, 0.003645, 0.00472, 0.0056525, 0.005465, 0.0055925, 0.00512, 0.0059625, 0.00725, 0.0048725, 0.0038775, 0.00369, 0.0034075, 0.005045, 0.005875, 0.006255, 0.004985, 0.0045925, 0.005365, 0.005005, 0.0049175, 0.00449, 0.0033375, 0.004465, 0.0047275, 0.0047975, 0.0043125, 0.0036025, 0.0040975, 0.0033175, 0.00361, 0.0041875, 0.00316, 0.0037, 0.0039725, 0.00317, 0.00275, 0.00236925, 0.002965, 0.003275, 0.003235, 0.0031525, 0.0039175, 0.004335, 0.004485, 0.0047025, 0.00455, 0.0047375, 0.00376, 0.002955, 0.004605, 0.0056325, 0.004685, 0.0029125, 0.003305, 0.00473, 0.00445, 0.0046225, 0.00432, 0.003735, 0.003815, 0.0041425, 0.00432, 0.00425, 0.00337, 0.003295, 0.00378, 0.004345, 0.00405, 0.003945, 0.0044525, 0.00386, 0.0039075, 0.003485, 0.003895, 0.0042775, 0.0029275, 0.0025825, 0.00286, 0.002935, 0.002905, 0.002915, 0.0036375, 0.0033675, 0.0031, 0.0025925, 0.00178175, 0.002014, 0.001955, 0.0025175, 0.0039375, 0.004195, 0.00272, 0.00138625, 0.00217325, 0.0047, 0.00662, 0.006645, 0.0058525, 0.0052525, 0.00438, 0.0032125, 0.002372, 0.00246125, 0.002605, 0.00240475, 0.0033725, 0.0040325, 0.0043475, 0.0042425, 0.003695, 0.00302, 0.00237925, 0.002725, 0.0038925, 0.003635, 0.00207175, 0.001503, 0.0020565, 0.003345, 0.0040325, 0.0037875, 0.0038, 0.0038075, 0.00427, 0.00509, 0.0048975, 0.0054575, 0.00454, 0.0037575, 0.0038225, 0.0051675, 0.0068875, 0.005275, 0.00443, 0.00491, 0.00679, 0.0076875, 0.0055225, 0.0039775, 0.0033425, 0.0030325, 0.00513, 0.008075, 0.0078625, 0.00763, 0.005995, 0.0046275, 0.00632, 0.0055825, 0.0036625, 0.003225, 0.00536, 0.007425, 0.0079975, 0.0055375, 0.00413, 0.003685, 0.003235, 0.003835, 0.00483, 0.00447, 0.00369, 0.0028725, 0.00214625, 0.00206325, 0.001495, 0.00178025, 0.0026575, 0.00212525, 0.000818, 0.000237975, 0.00037875, 0.0013335, 0.0019935, 0.0012795, 0.0007115, 0.00100925, 0.0012505, 0.000741, 0.00047125, 0.000235875, 0.0001163, 0.00033475, 0.0008015, 0.00075425, 0.0007285, 0.000532, 0.00039225, 0.00025275, 7.8975e-05, 3.5425e-05, 4.52e-05, 6.2375e-05, 0.000228975, 0.00064825, 0.00065975, 0.000212325, 4.4125e-05, 3.305e-05, 4.5225e-05, 1.958e-05, 4.8125e-06, 7.1475e-06, 3.815e-05, 0.000138625, 0.000172925, 7.2525e-05, 1.525e-05, 2.491e-06, 3.6025e-07, 9.7325e-07, 5.5725e-06, 1.8605e-05, 1.83725e-05, 5.56e-06, 1.895e-06, 3.7575e-06, 4.4525e-06, 1.561e-06, 2.8675e-07, 4.4975e-08, 1.95875e-11, 3.8225e-12, 6.055e-13, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.805643605, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.5945e-08, 3.5475e-07, 2.17775e-06, 1.42975e-05, 8.5175e-05, 0.0003755, 0.00094125, 0.00135225, 0.0018645, 0.00228475, 0.0019825, 0.002625, 0.0030925, 0.002835, 0.0031825, 0.003045, 0.00289, 0.004075, 0.0040625, 0.0040275, 0.003435, 0.002815, 0.0041875, 0.005145, 0.0044575, 0.004865, 0.003635, 0.00351, 0.004905, 0.004955, 0.0045325, 0.0044575, 0.0045425, 0.0060175, 0.0051275, 0.0047575, 0.004665, 0.0032225, 0.0043825, 0.006085, 0.0058125, 0.0063475, 0.0054125, 0.00447, 0.004485, 0.00458, 0.0052075, 0.0052025, 0.004385, 0.00627, 0.00612, 0.00583, 0.005035, 0.003795, 0.0053475, 0.006545, 0.0056375, 0.0049525, 0.003645, 0.00472, 0.0056525, 0.005465, 0.0055925, 0.00512, 0.0059625, 0.00725, 0.0048725, 0.0038775, 0.00369, 0.0034075, 0.005045, 0.005875, 0.006255, 0.004985, 0.0045925, 0.005365, 0.005005, 0.0049175, 0.00449, 0.0033375, 0.004465, 0.0047275, 0.0047975, 0.0043125, 0.0036025, 0.0040975, 0.0033175, 0.00361, 0.0041875, 0.00316, 0.0037, 0.0039725, 0.00317, 0.00275, 0.00236925, 0.002965, 0.003275, 0.003235, 0.0031525, 0.0039175, 0.004335, 0.004485, 0.0047025, 0.00455, 0.0047375, 0.00376, 0.002955, 0.004605, 0.0056325, 0.004685, 0.0029125, 0.003305, 0.00473, 0.00445, 0.0046225, 0.00432, 0.003735, 0.003815, 0.0041425, 0.00432, 0.00425, 0.00337, 0.003295, 0.00378, 0.004345, 0.00405, 0.003945, 0.0044525, 0.00386, 0.0039075, 0.003485, 0.003895, 0.0042775, 0.0029275, 0.0025825, 0.00286, 0.002935, 0.002905, 0.002915, 0.0036375, 0.0033675, 0.0031, 0.0025925, 0.00178175, 0.002014, 0.001955, 0.0025175, 0.0039375, 0.004195, 0.00272, 0.00138625, 0.00217325, 0.0047, 0.00662, 0.006645, 0.0058525, 0.0052525, 0.00438, 0.0032125, 0.002372, 0.00246125, 0.002605, 0.00240475, 0.0033725, 0.0040325, 0.0043475, 0.0042425, 0.003695, 0.00302, 0.00237925, 0.002725, 0.0038925, 0.003635, 0.00207175, 0.001503, 0.0020565, 0.003345, 0.0040325, 0.0037875, 0.0038, 0.0038075, 0.00427, 0.00509, 0.0048975, 0.0054575, 0.00454, 0.0037575, 0.0038225, 0.0051675, 0.0068875, 0.005275, 0.00443, 0.00491, 0.00679, 0.0076875, 0.0055225, 0.0039775, 0.0033425, 0.0030325, 0.00513, 0.008075, 0.0078625, 0.00763, 0.005995, 0.0046275, 0.00632, 0.0055825, 0.0036625, 0.003225, 0.00536, 0.007425, 0.0079975, 0.0055375, 0.00413, 0.003685, 0.003235, 0.003835, 0.00483, 0.00447, 0.00369, 0.0028725, 0.00214625, 0.00206325, 0.001495, 0.00178025, 0.0026575, 0.00212525, 0.000818, 0.000237975, 0.00037875, 0.0013335, 0.0019935, 0.0012795, 0.0007115, 0.00100925, 0.0012505, 0.000741, 0.00047125, 0.000235875, 0.0001163, 0.00033475, 0.0008015, 0.00075425, 0.0007285, 0.000532, 0.00039225, 0.00025275, 7.8975e-05, 3.5425e-05, 4.52e-05, 6.2375e-05, 0.000228975, 0.00064825, 0.00065975, 0.000212325, 4.4125e-05, 3.305e-05, 4.5225e-05, 1.958e-05, 4.8125e-06, 7.1475e-06, 3.815e-05, 0.000138625, 0.000172925, 7.2525e-05, 1.525e-05, 2.491e-06, 3.6025e-07, 9.7325e-07, 5.5725e-06, 1.8605e-05, 1.83725e-05, 5.56e-06, 1.895e-06, 3.7575e-06, 4.4525e-06, 1.561e-06, 2.8675e-07, 4.4975e-08, 1.95875e-11, 3.8225e-12, 6.055e-13, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.805643605, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.5945e-08, 3.5475e-07, 2.17775e-06, 1.42975e-05, 8.5175e-05, 0.0003755, 0.00094125, 0.00135225, 0.0018645, 0.00228475, 0.0019825, 0.002625, 0.0030925, 0.002835, 0.0031825, 0.003045, 0.00289, 0.004075, 0.0040625, 0.0040275, 0.003435, 0.002815, 0.0041875, 0.005145, 0.0044575, 0.004865, 0.003635, 0.00351, 0.004905, 0.004955, 0.0045325, 0.0044575, 0.0045425, 0.0060175, 0.0051275, 0.0047575, 0.004665, 0.0032225, 0.0043825, 0.006085, 0.0058125, 0.0063475, 0.0054125, 0.00447, 0.004485, 0.00458, 0.0052075, 0.0052025, 0.004385, 0.00627, 0.00612, 0.00583, 0.005035, 0.003795, 0.0053475, 0.006545, 0.0056375, 0.0049525, 0.003645, 0.00472, 0.0056525, 0.005465, 0.0055925, 0.00512, 0.0059625, 0.00725, 0.0048725, 0.0038775, 0.00369, 0.0034075, 0.005045, 0.005875, 0.006255, 0.004985, 0.0045925, 0.005365, 0.005005, 0.0049175, 0.00449, 0.0033375, 0.004465, 0.0047275, 0.0047975, 0.0043125, 0.0036025, 0.0040975, 0.0033175, 0.00361, 0.0041875, 0.00316, 0.0037, 0.0039725, 0.00317, 0.00275, 0.00236925, 0.002965, 0.003275, 0.003235, 0.0031525, 0.0039175, 0.004335, 0.004485, 0.0047025, 0.00455, 0.0047375, 0.00376, 0.002955, 0.004605, 0.0056325, 0.004685, 0.0029125, 0.003305, 0.00473, 0.00445, 0.0046225, 0.00432, 0.003735, 0.003815, 0.0041425, 0.00432, 0.00425, 0.00337, 0.003295, 0.00378, 0.004345, 0.00405, 0.003945, 0.0044525, 0.00386, 0.0039075, 0.003485, 0.003895, 0.0042775, 0.0029275, 0.0025825, 0.00286, 0.002935, 0.002905, 0.002915, 0.0036375, 0.0033675, 0.0031, 0.0025925, 0.00178175, 0.002014, 0.001955, 0.0025175, 0.0039375, 0.004195, 0.00272, 0.00138625, 0.00217325, 0.0047, 0.00662, 0.006645, 0.0058525, 0.0052525, 0.00438, 0.0032125, 0.002372, 0.00246125, 0.002605, 0.00240475, 0.0033725, 0.0040325, 0.0043475, 0.0042425, 0.003695, 0.00302, 0.00237925, 0.002725, 0.0038925, 0.003635, 0.00207175, 0.001503, 0.0020565, 0.003345, 0.0040325, 0.0037875, 0.0038, 0.0038075, 0.00427, 0.00509, 0.0048975, 0.0054575, 0.00454, 0.0037575, 0.0038225, 0.0051675, 0.0068875, 0.005275, 0.00443, 0.00491, 0.00679, 0.0076875, 0.0055225, 0.0039775, 0.0033425, 0.0030325, 0.00513, 0.008075, 0.0078625, 0.00763, 0.005995, 0.0046275, 0.00632, 0.0055825, 0.0036625, 0.003225, 0.00536, 0.007425, 0.0079975, 0.0055375, 0.00413, 0.003685, 0.003235, 0.003835, 0.00483, 0.00447, 0.00369, 0.0028725, 0.00214625, 0.00206325, 0.001495, 0.00178025, 0.0026575, 0.00212525, 0.000818, 0.000237975, 0.00037875, 0.0013335, 0.0019935, 0.0012795, 0.0007115, 0.00100925, 0.0012505, 0.000741, 0.00047125, 0.000235875, 0.0001163, 0.00033475, 0.0008015, 0.00075425, 0.0007285, 0.000532, 0.00039225, 0.00025275, 7.8975e-05, 3.5425e-05, 4.52e-05, 6.2375e-05, 0.000228975, 0.00064825, 0.00065975, 0.000212325, 4.4125e-05, 3.305e-05, 4.5225e-05, 1.958e-05, 4.8125e-06, 7.1475e-06, 3.815e-05, 0.000138625, 0.000172925, 7.2525e-05, 1.525e-05, 2.491e-06, 3.6025e-07, 9.7325e-07, 5.5725e-06, 1.8605e-05, 1.83725e-05, 5.56e-06, 1.895e-06, 3.7575e-06, 4.4525e-06, 1.561e-06, 2.8675e-07, 4.4975e-08, 1.95875e-11, 3.8225e-12, 6.055e-13, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.29225e-07, 5.0925e-06, 3.0125e-05, 0.000191425, 0.00110125, 0.00472, 0.011685, 0.0169275, 0.0235325, 0.0287, 0.0255, 0.033975, 0.03985, 0.037125, 0.04195, 0.039975, 0.03945, 0.05495, 0.054975, 0.05495, 0.046575, 0.04005, 0.06005, 0.07205, 0.063825, 0.06935, 0.051725, 0.053025, 0.07295, 0.0731, 0.0682, 0.067075, 0.071525, 0.0926, 0.078475, 0.075425, 0.0719, 0.051775, 0.07445, 0.099325, 0.0961, 0.105525, 0.0883, 0.075975, 0.0771, 0.079775, 0.0928, 0.08935, 0.0813, 0.11505, 0.11015, 0.107625, 0.0903, 0.073325, 0.106525, 0.1248, 0.109125, 0.0951, 0.073625, 0.099675, 0.116025, 0.11345, 0.117875, 0.10855, 0.1353, 0.155425, 0.103025, 0.08835, 0.0829, 0.083525, 0.1242, 0.1428, 0.15235, 0.119975, 0.11925, 0.1382, 0.130775, 0.1353, 0.1218, 0.096525, 0.13285, 0.1425, 0.14685, 0.13425, 0.1279, 0.15435, 0.1329, 0.138475, 0.15595, 0.130175, 0.151575, 0.1618, 0.131775, 0.12055, 0.115025, 0.141075, 0.137, 0.1097, 0.103225, 0.1257, 0.168725, 0.1883, 0.171175, 0.182025, 0.169925, 0.114825, 0.104675, 0.157825, 0.192375, 0.166375, 0.1441, 0.15855, 0.162625, 0.170325, 0.1934, 0.1798, 0.126525, 0.121625, 0.135, 0.156225, 0.168425, 0.134925, 0.13975, 0.16505, 0.176925, 0.161725, 0.1645, 0.1761, 0.160475, 0.16695, 0.1671, 0.1904, 0.2017, 0.148325, 0.1554, 0.157975, 0.1431, 0.16445, 0.18115, 0.2095, 0.198, 0.183375, 0.158425, 0.12665, 0.133, 0.12755, 0.14885, 0.175025, 0.175575, 0.1297, 0.0936, 0.137225, 0.2178, 0.2478, 0.26275, 0.252, 0.2242, 0.18165, 0.1634, 0.152525, 0.138875, 0.138525, 0.139725, 0.16815, 0.21335, 0.231475, 0.21365, 0.18365, 0.147225, 0.13625, 0.16945, 0.2082, 0.189375, 0.145725, 0.1524, 0.196025, 0.206575, 0.186425, 0.206475, 0.20515, 0.169375, 0.1813, 0.2045, 0.146625, 0.116525, 0.16675, 0.238775, 0.27325, 0.223475, 0.162325, 0.14385, 0.163175, 0.199425, 0.242775, 0.233925, 0.18645, 0.17665, 0.156875, 0.209225, 0.23735, 0.2625, 0.26925, 0.202, 0.2075, 0.20705, 0.15435, 0.0943, 0.108525, 0.206175, 0.2785, 0.33125, 0.292, 0.202, 0.148575, 0.1066, 0.131875, 0.1988, 0.202125, 0.180425, 0.1567, 0.12455, 0.088625, 0.087075, 0.083175, 0.123725, 0.1434, 0.112475, 0.074675, 0.04295, 0.0531, 0.07215, 0.050775, 0.031175, 0.057125, 0.0958, 0.078975, 0.0688, 0.0553, 0.029475, 0.02059, 0.029025, 0.025925, 0.03965, 0.04265, 0.0499, 0.044975, 0.018115, 0.0094475, 0.0157525, 0.029625, 0.0336, 0.062775, 0.061075, 0.0248025, 0.005905, 0.002965, 0.008385, 0.012445, 0.00532, 0.00213375, 0.006525, 0.0254, 0.0471, 0.034875, 0.01053, 0.001932, 0.00026875, 0.0001101, 0.000682, 0.003695, 0.01127, 0.010235, 0.003235, 0.0023085, 0.0077275, 0.0126675, 0.006355, 0.003785, 0.004395, 0.001862, 0.00037975, 6.245e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.84001899, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.85675e-08, 4.1025e-07, 2.42675e-06, 1.54125e-05, 8.8625e-05, 0.00037925, 0.0009365, 0.0013495, 0.001862, 0.0022585, 0.0019915, 0.0026275, 0.003065, 0.002835, 0.003175, 0.00301, 0.0029375, 0.0040625, 0.0040375, 0.004005, 0.0033725, 0.0028675, 0.00426, 0.0050825, 0.004465, 0.0048125, 0.003565, 0.00361, 0.0049275, 0.004905, 0.004535, 0.0044225, 0.0046625, 0.005995, 0.0050425, 0.0047975, 0.00454, 0.0032325, 0.00459, 0.0060825, 0.005835, 0.0063475, 0.0052725, 0.0044825, 0.0045, 0.00461, 0.005305, 0.0050725, 0.00455, 0.0063775, 0.0060525, 0.00585, 0.0048675, 0.0038925, 0.0055875, 0.0064925, 0.0056075, 0.004835, 0.0036925, 0.004925, 0.00568, 0.0054925, 0.005635, 0.0051125, 0.006265, 0.0071475, 0.004695, 0.0039425, 0.00364, 0.003575, 0.005255, 0.00598, 0.0063, 0.004905, 0.00476, 0.005425, 0.0050175, 0.00501, 0.00444, 0.0034475, 0.004605, 0.0048325, 0.004935, 0.00429, 0.003695, 0.0041825, 0.0034425, 0.0038325, 0.004195, 0.0032675, 0.003855, 0.00403, 0.0032375, 0.00283, 0.0025475, 0.0033075, 0.00369, 0.00345, 0.003415, 0.0037875, 0.00426, 0.0049925, 0.0047225, 0.004855, 0.00478, 0.0033125, 0.003375, 0.005145, 0.00556, 0.0040475, 0.0028175, 0.0040075, 0.00474, 0.0043775, 0.00459, 0.00438, 0.00378, 0.00389, 0.0040625, 0.0043525, 0.0041175, 0.003285, 0.0033925, 0.0038875, 0.004415, 0.0039025, 0.0041275, 0.0043875, 0.00386, 0.0039125, 0.0034525, 0.004105, 0.00435, 0.00283, 0.00268, 0.0030275, 0.0029425, 0.00286, 0.003055, 0.00382, 0.0033775, 0.003275, 0.0026675, 0.001892, 0.00210775, 0.00233675, 0.003595, 0.004445, 0.00361, 0.0021385, 0.001494, 0.0031475, 0.0057, 0.00681, 0.00664, 0.005985, 0.005065, 0.0038725, 0.0030025, 0.00254, 0.00266, 0.00255, 0.0028075, 0.0036175, 0.0042375, 0.0046925, 0.0041475, 0.00379, 0.00295, 0.0023615, 0.0030375, 0.0040625, 0.0032, 0.00203, 0.00212575, 0.003275, 0.0039825, 0.00425, 0.004795, 0.0046825, 0.0047425, 0.0054775, 0.0061925, 0.003635, 0.002685, 0.0038325, 0.0054825, 0.0076775, 0.0068, 0.0049825, 0.00431, 0.0044175, 0.0063725, 0.00682, 0.0059425, 0.00427, 0.00332, 0.0034225, 0.00663, 0.00736, 0.007065, 0.0079825, 0.0055075, 0.0055825, 0.006695, 0.005025, 0.002995, 0.0030675, 0.00572, 0.0072825, 0.0073925, 0.0057725, 0.0047075, 0.0039625, 0.003115, 0.0035075, 0.00454, 0.0041525, 0.0037575, 0.00313, 0.00268, 0.00194275, 0.0014725, 0.001646, 0.002383, 0.001996, 0.0011675, 0.00055425, 0.000616, 0.00154575, 0.0018865, 0.0010685, 0.0005295, 0.00084225, 0.00138825, 0.0008615, 0.0004765, 0.00030375, 0.000231325, 0.00045375, 0.00080025, 0.00060375, 0.000648, 0.00050925, 0.00043225, 0.000388, 0.00013265, 3.0475e-05, 3.205e-05, 7.98e-05, 0.000226, 0.00064825, 0.00069525, 0.00026475, 5.69e-05, 1.727e-05, 3.34e-05, 4.93e-05, 2.143e-05, 1.086e-05, 4.0675e-05, 0.000167425, 0.00027075, 0.00013415, 3.125e-05, 5.375e-06, 3.3075e-07, 2.1065e-07, 1.305e-06, 7.07e-06, 2.15525e-05, 1.95175e-05, 5.755e-06, 1.8465e-06, 3.7825e-06, 5.9475e-06, 2.7125e-06, 5.615e-07, 9.295e-08, 1.38575e-10, 2.825e-11, 4.6475e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.84001899, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.85675e-08, 4.1025e-07, 2.42675e-06, 1.54125e-05, 8.8625e-05, 0.00037925, 0.0009365, 0.0013495, 0.001862, 0.0022585, 0.0019915, 0.0026275, 0.003065, 0.002835, 0.003175, 0.00301, 0.0029375, 0.0040625, 0.0040375, 0.004005, 0.0033725, 0.0028675, 0.00426, 0.0050825, 0.004465, 0.0048125, 0.003565, 0.00361, 0.0049275, 0.004905, 0.004535, 0.0044225, 0.0046625, 0.005995, 0.0050425, 0.0047975, 0.00454, 0.0032325, 0.00459, 0.0060825, 0.005835, 0.0063475, 0.0052725, 0.0044825, 0.0045, 0.00461, 0.005305, 0.0050725, 0.00455, 0.0063775, 0.0060525, 0.00585, 0.0048675, 0.0038925, 0.0055875, 0.0064925, 0.0056075, 0.004835, 0.0036925, 0.004925, 0.00568, 0.0054925, 0.005635, 0.0051125, 0.006265, 0.0071475, 0.004695, 0.0039425, 0.00364, 0.003575, 0.005255, 0.00598, 0.0063, 0.004905, 0.00476, 0.005425, 0.0050175, 0.00501, 0.00444, 0.0034475, 0.004605, 0.0048325, 0.004935, 0.00429, 0.003695, 0.0041825, 0.0034425, 0.0038325, 0.004195, 0.0032675, 0.003855, 0.00403, 0.0032375, 0.00283, 0.0025475, 0.0033075, 0.00369, 0.00345, 0.003415, 0.0037875, 0.00426, 0.0049925, 0.0047225, 0.004855, 0.00478, 0.0033125, 0.003375, 0.005145, 0.00556, 0.0040475, 0.0028175, 0.0040075, 0.00474, 0.0043775, 0.00459, 0.00438, 0.00378, 0.00389, 0.0040625, 0.0043525, 0.0041175, 0.003285, 0.0033925, 0.0038875, 0.004415, 0.0039025, 0.0041275, 0.0043875, 0.00386, 0.0039125, 0.0034525, 0.004105, 0.00435, 0.00283, 0.00268, 0.0030275, 0.0029425, 0.00286, 0.003055, 0.00382, 0.0033775, 0.003275, 0.0026675, 0.001892, 0.00210775, 0.00233675, 0.003595, 0.004445, 0.00361, 0.0021385, 0.001494, 0.0031475, 0.0057, 0.00681, 0.00664, 0.005985, 0.005065, 0.0038725, 0.0030025, 0.00254, 0.00266, 0.00255, 0.0028075, 0.0036175, 0.0042375, 0.0046925, 0.0041475, 0.00379, 0.00295, 0.0023615, 0.0030375, 0.0040625, 0.0032, 0.00203, 0.00212575, 0.003275, 0.0039825, 0.00425, 0.004795, 0.0046825, 0.0047425, 0.0054775, 0.0061925, 0.003635, 0.002685, 0.0038325, 0.0054825, 0.0076775, 0.0068, 0.0049825, 0.00431, 0.0044175, 0.0063725, 0.00682, 0.0059425, 0.00427, 0.00332, 0.0034225, 0.00663, 0.00736, 0.007065, 0.0079825, 0.0055075, 0.0055825, 0.006695, 0.005025, 0.002995, 0.0030675, 0.00572, 0.0072825, 0.0073925, 0.0057725, 0.0047075, 0.0039625, 0.003115, 0.0035075, 0.00454, 0.0041525, 0.0037575, 0.00313, 0.00268, 0.00194275, 0.0014725, 0.001646, 0.002383, 0.001996, 0.0011675, 0.00055425, 0.000616, 0.00154575, 0.0018865, 0.0010685, 0.0005295, 0.00084225, 0.00138825, 0.0008615, 0.0004765, 0.00030375, 0.000231325, 0.00045375, 0.00080025, 0.00060375, 0.000648, 0.00050925, 0.00043225, 0.000388, 0.00013265, 3.0475e-05, 3.205e-05, 7.98e-05, 0.000226, 0.00064825, 0.00069525, 0.00026475, 5.69e-05, 1.727e-05, 3.34e-05, 4.93e-05, 2.143e-05, 1.086e-05, 4.0675e-05, 0.000167425, 0.00027075, 0.00013415, 3.125e-05, 5.375e-06, 3.3075e-07, 2.1065e-07, 1.305e-06, 7.07e-06, 2.15525e-05, 1.95175e-05, 5.755e-06, 1.8465e-06, 3.7825e-06, 5.9475e-06, 2.7125e-06, 5.615e-07, 9.295e-08, 1.38575e-10, 2.825e-11, 4.6475e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.84001899, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.85675e-08, 4.1025e-07, 2.42675e-06, 1.54125e-05, 8.8625e-05, 0.00037925, 0.0009365, 0.0013495, 0.001862, 0.0022585, 0.0019915, 0.0026275, 0.003065, 0.002835, 0.003175, 0.00301, 0.0029375, 0.0040625, 0.0040375, 0.004005, 0.0033725, 0.0028675, 0.00426, 0.0050825, 0.004465, 0.0048125, 0.003565, 0.00361, 0.0049275, 0.004905, 0.004535, 0.0044225, 0.0046625, 0.005995, 0.0050425, 0.0047975, 0.00454, 0.0032325, 0.00459, 0.0060825, 0.005835, 0.0063475, 0.0052725, 0.0044825, 0.0045, 0.00461, 0.005305, 0.0050725, 0.00455, 0.0063775, 0.0060525, 0.00585, 0.0048675, 0.0038925, 0.0055875, 0.0064925, 0.0056075, 0.004835, 0.0036925, 0.004925, 0.00568, 0.0054925, 0.005635, 0.0051125, 0.006265, 0.0071475, 0.004695, 0.0039425, 0.00364, 0.003575, 0.005255, 0.00598, 0.0063, 0.004905, 0.00476, 0.005425, 0.0050175, 0.00501, 0.00444, 0.0034475, 0.004605, 0.0048325, 0.004935, 0.00429, 0.003695, 0.0041825, 0.0034425, 0.0038325, 0.004195, 0.0032675, 0.003855, 0.00403, 0.0032375, 0.00283, 0.0025475, 0.0033075, 0.00369, 0.00345, 0.003415, 0.0037875, 0.00426, 0.0049925, 0.0047225, 0.004855, 0.00478, 0.0033125, 0.003375, 0.005145, 0.00556, 0.0040475, 0.0028175, 0.0040075, 0.00474, 0.0043775, 0.00459, 0.00438, 0.00378, 0.00389, 0.0040625, 0.0043525, 0.0041175, 0.003285, 0.0033925, 0.0038875, 0.004415, 0.0039025, 0.0041275, 0.0043875, 0.00386, 0.0039125, 0.0034525, 0.004105, 0.00435, 0.00283, 0.00268, 0.0030275, 0.0029425, 0.00286, 0.003055, 0.00382, 0.0033775, 0.003275, 0.0026675, 0.001892, 0.00210775, 0.00233675, 0.003595, 0.004445, 0.00361, 0.0021385, 0.001494, 0.0031475, 0.0057, 0.00681, 0.00664, 0.005985, 0.005065, 0.0038725, 0.0030025, 0.00254, 0.00266, 0.00255, 0.0028075, 0.0036175, 0.0042375, 0.0046925, 0.0041475, 0.00379, 0.00295, 0.0023615, 0.0030375, 0.0040625, 0.0032, 0.00203, 0.00212575, 0.003275, 0.0039825, 0.00425, 0.004795, 0.0046825, 0.0047425, 0.0054775, 0.0061925, 0.003635, 0.002685, 0.0038325, 0.0054825, 0.0076775, 0.0068, 0.0049825, 0.00431, 0.0044175, 0.0063725, 0.00682, 0.0059425, 0.00427, 0.00332, 0.0034225, 0.00663, 0.00736, 0.007065, 0.0079825, 0.0055075, 0.0055825, 0.006695, 0.005025, 0.002995, 0.0030675, 0.00572, 0.0072825, 0.0073925, 0.0057725, 0.0047075, 0.0039625, 0.003115, 0.0035075, 0.00454, 0.0041525, 0.0037575, 0.00313, 0.00268, 0.00194275, 0.0014725, 0.001646, 0.002383, 0.001996, 0.0011675, 0.00055425, 0.000616, 0.00154575, 0.0018865, 0.0010685, 0.0005295, 0.00084225, 0.00138825, 0.0008615, 0.0004765, 0.00030375, 0.000231325, 0.00045375, 0.00080025, 0.00060375, 0.000648, 0.00050925, 0.00043225, 0.000388, 0.00013265, 3.0475e-05, 3.205e-05, 7.98e-05, 0.000226, 0.00064825, 0.00069525, 0.00026475, 5.69e-05, 1.727e-05, 3.34e-05, 4.93e-05, 2.143e-05, 1.086e-05, 4.0675e-05, 0.000167425, 0.00027075, 0.00013415, 3.125e-05, 5.375e-06, 3.3075e-07, 2.1065e-07, 1.305e-06, 7.07e-06, 2.15525e-05, 1.95175e-05, 5.755e-06, 1.8465e-06, 3.7825e-06, 5.9475e-06, 2.7125e-06, 5.615e-07, 9.295e-08, 1.38575e-10, 2.825e-11, 4.6475e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.84001899, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.85675e-08, 4.1025e-07, 2.42675e-06, 1.54125e-05, 8.8625e-05, 0.00037925, 0.0009365, 0.0013495, 0.001862, 0.0022585, 0.0019915, 0.0026275, 0.003065, 0.002835, 0.003175, 0.00301, 0.0029375, 0.0040625, 0.0040375, 0.004005, 0.0033725, 0.0028675, 0.00426, 0.0050825, 0.004465, 0.0048125, 0.003565, 0.00361, 0.0049275, 0.004905, 0.004535, 0.0044225, 0.0046625, 0.005995, 0.0050425, 0.0047975, 0.00454, 0.0032325, 0.00459, 0.0060825, 0.005835, 0.0063475, 0.0052725, 0.0044825, 0.0045, 0.00461, 0.005305, 0.0050725, 0.00455, 0.0063775, 0.0060525, 0.00585, 0.0048675, 0.0038925, 0.0055875, 0.0064925, 0.0056075, 0.004835, 0.0036925, 0.004925, 0.00568, 0.0054925, 0.005635, 0.0051125, 0.006265, 0.0071475, 0.004695, 0.0039425, 0.00364, 0.003575, 0.005255, 0.00598, 0.0063, 0.004905, 0.00476, 0.005425, 0.0050175, 0.00501, 0.00444, 0.0034475, 0.004605, 0.0048325, 0.004935, 0.00429, 0.003695, 0.0041825, 0.0034425, 0.0038325, 0.004195, 0.0032675, 0.003855, 0.00403, 0.0032375, 0.00283, 0.0025475, 0.0033075, 0.00369, 0.00345, 0.003415, 0.0037875, 0.00426, 0.0049925, 0.0047225, 0.004855, 0.00478, 0.0033125, 0.003375, 0.005145, 0.00556, 0.0040475, 0.0028175, 0.0040075, 0.00474, 0.0043775, 0.00459, 0.00438, 0.00378, 0.00389, 0.0040625, 0.0043525, 0.0041175, 0.003285, 0.0033925, 0.0038875, 0.004415, 0.0039025, 0.0041275, 0.0043875, 0.00386, 0.0039125, 0.0034525, 0.004105, 0.00435, 0.00283, 0.00268, 0.0030275, 0.0029425, 0.00286, 0.003055, 0.00382, 0.0033775, 0.003275, 0.0026675, 0.001892, 0.00210775, 0.00233675, 0.003595, 0.004445, 0.00361, 0.0021385, 0.001494, 0.0031475, 0.0057, 0.00681, 0.00664, 0.005985, 0.005065, 0.0038725, 0.0030025, 0.00254, 0.00266, 0.00255, 0.0028075, 0.0036175, 0.0042375, 0.0046925, 0.0041475, 0.00379, 0.00295, 0.0023615, 0.0030375, 0.0040625, 0.0032, 0.00203, 0.00212575, 0.003275, 0.0039825, 0.00425, 0.004795, 0.0046825, 0.0047425, 0.0054775, 0.0061925, 0.003635, 0.002685, 0.0038325, 0.0054825, 0.0076775, 0.0068, 0.0049825, 0.00431, 0.0044175, 0.0063725, 0.00682, 0.0059425, 0.00427, 0.00332, 0.0034225, 0.00663, 0.00736, 0.007065, 0.0079825, 0.0055075, 0.0055825, 0.006695, 0.005025, 0.002995, 0.0030675, 0.00572, 0.0072825, 0.0073925, 0.0057725, 0.0047075, 0.0039625, 0.003115, 0.0035075, 0.00454, 0.0041525, 0.0037575, 0.00313, 0.00268, 0.00194275, 0.0014725, 0.001646, 0.002383, 0.001996, 0.0011675, 0.00055425, 0.000616, 0.00154575, 0.0018865, 0.0010685, 0.0005295, 0.00084225, 0.00138825, 0.0008615, 0.0004765, 0.00030375, 0.000231325, 0.00045375, 0.00080025, 0.00060375, 0.000648, 0.00050925, 0.00043225, 0.000388, 0.00013265, 3.0475e-05, 3.205e-05, 7.98e-05, 0.000226, 0.00064825, 0.00069525, 0.00026475, 5.69e-05, 1.727e-05, 3.34e-05, 4.93e-05, 2.143e-05, 1.086e-05, 4.0675e-05, 0.000167425, 0.00027075, 0.00013415, 3.125e-05, 5.375e-06, 3.3075e-07, 2.1065e-07, 1.305e-06, 7.07e-06, 2.15525e-05, 1.95175e-05, 5.755e-06, 1.8465e-06, 3.7825e-06, 5.9475e-06, 2.7125e-06, 5.615e-07, 9.295e-08, 1.38575e-10, 2.825e-11, 4.6475e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.505e-07, 5.5675e-06, 3.4925e-05, 0.00021165, 0.00117825, 0.0049025, 0.011945, 0.01735, 0.0241175, 0.029125, 0.0263, 0.03485, 0.040525, 0.038025, 0.0429, 0.04055, 0.04105, 0.0561, 0.056, 0.055925, 0.04695, 0.041775, 0.062325, 0.072875, 0.065475, 0.070075, 0.05215, 0.055625, 0.07475, 0.074, 0.069725, 0.068125, 0.074975, 0.093925, 0.07905, 0.07745, 0.07145, 0.053475, 0.07895, 0.101025, 0.098525, 0.10715, 0.08805, 0.07765, 0.078875, 0.08185, 0.09575, 0.0889, 0.085925, 0.11815, 0.111175, 0.10935, 0.08905, 0.076875, 0.112025, 0.1254, 0.110275, 0.0942, 0.0763, 0.1045, 0.117925, 0.11565, 0.119825, 0.11055, 0.14245, 0.154, 0.101275, 0.090475, 0.08285, 0.08835, 0.12925, 0.146275, 0.153675, 0.119725, 0.123875, 0.14005, 0.132, 0.137675, 0.120725, 0.1, 0.135975, 0.145225, 0.149375, 0.13265, 0.129725, 0.15495, 0.13645, 0.1448, 0.154025, 0.133525, 0.154975, 0.1629, 0.13435, 0.12115, 0.11855, 0.1477, 0.143, 0.115125, 0.1064, 0.125325, 0.1746, 0.193675, 0.17335, 0.1871, 0.1698, 0.117375, 0.118425, 0.164725, 0.187975, 0.157075, 0.150675, 0.17245, 0.1656, 0.17215, 0.194, 0.185125, 0.132325, 0.12665, 0.137875, 0.1575, 0.163475, 0.138725, 0.144925, 0.17175, 0.1822, 0.160225, 0.169325, 0.172, 0.1607, 0.166125, 0.170125, 0.199825, 0.198375, 0.14265, 0.1597, 0.1684, 0.1443, 0.162075, 0.186925, 0.21045, 0.196275, 0.188575, 0.158375, 0.1367, 0.1409, 0.14275, 0.162225, 0.16185, 0.1653, 0.12595, 0.11155, 0.167325, 0.23135, 0.2495, 0.25675, 0.2377, 0.224575, 0.182525, 0.16485, 0.156675, 0.13865, 0.144625, 0.1557, 0.174675, 0.216375, 0.227325, 0.22085, 0.18925, 0.14085, 0.1385, 0.18105, 0.203975, 0.1787, 0.15325, 0.1595, 0.215725, 0.231325, 0.19125, 0.2123, 0.2151, 0.185425, 0.1796, 0.17465, 0.1403, 0.14405, 0.206375, 0.26325, 0.26325, 0.21225, 0.1573, 0.1487, 0.1817, 0.2059, 0.237475, 0.22175, 0.17335, 0.1962, 0.2218, 0.21345, 0.23845, 0.27975, 0.242075, 0.218775, 0.221725, 0.181725, 0.12635, 0.109675, 0.162075, 0.23615, 0.28, 0.30275, 0.2865, 0.192075, 0.1353, 0.130425, 0.164975, 0.191075, 0.1846, 0.1783, 0.167925, 0.10325, 0.0774, 0.083875, 0.102225, 0.10385, 0.121625, 0.1032, 0.075625, 0.0743, 0.06, 0.051775, 0.0361, 0.0365, 0.07735, 0.088975, 0.064375, 0.0567, 0.056175, 0.0443, 0.03335, 0.020865, 0.026525, 0.036575, 0.03975, 0.053325, 0.0375, 0.014005, 0.0066175, 0.014995, 0.03755, 0.057025, 0.06645, 0.0423, 0.015245, 0.0037, 0.0028525, 0.009015, 0.012335, 0.005535, 0.0048575, 0.0172825, 0.0349, 0.0346, 0.0273, 0.0094275, 0.001742, 0.00030325, 6.5875e-05, 0.00039925, 0.0022415, 0.0087025, 0.012365, 0.005225, 0.00199975, 0.0045925, 0.0092825, 0.00811, 0.00798, 0.0062575, 0.00226325, 0.00046025, 6.695e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.872477275, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.905e-08, 4.3725e-07, 2.7425e-06, 1.66075e-05, 9.2425e-05, 0.000384, 0.000933, 0.001348, 0.00186025, 0.00223525, 0.002002, 0.00263, 0.00304, 0.0028325, 0.00317, 0.00298, 0.0029825, 0.00405, 0.0040175, 0.0039825, 0.00332, 0.0029225, 0.0043225, 0.005025, 0.0044775, 0.0047575, 0.003515, 0.003705, 0.004945, 0.00486, 0.00454, 0.0044, 0.0047875, 0.00596, 0.00498, 0.00483, 0.004425, 0.003275, 0.004775, 0.006075, 0.0058725, 0.00633, 0.0051625, 0.0045, 0.0045275, 0.00465, 0.005385, 0.004965, 0.0047325, 0.0064475, 0.006015, 0.005855, 0.0047275, 0.0040225, 0.005795, 0.0064375, 0.005595, 0.00473, 0.0037775, 0.005105, 0.0057075, 0.005535, 0.0056675, 0.0051525, 0.0065375, 0.0070225, 0.0045725, 0.004005, 0.00361, 0.00376, 0.0054425, 0.0060925, 0.0063275, 0.0048675, 0.004925, 0.0054825, 0.0050525, 0.0051025, 0.0044075, 0.0035775, 0.0047375, 0.00496, 0.0050625, 0.0042825, 0.0038, 0.0042775, 0.0035925, 0.0040475, 0.0042125, 0.003405, 0.0040075, 0.0041025, 0.0033375, 0.0029375, 0.0027925, 0.0037475, 0.0039925, 0.0036925, 0.00356, 0.003495, 0.0045875, 0.00527, 0.0048075, 0.0051575, 0.0045325, 0.003215, 0.003935, 0.0054475, 0.00527, 0.003475, 0.00312, 0.004505, 0.004665, 0.0043325, 0.0046, 0.0044975, 0.0037875, 0.003895, 0.00404, 0.0043725, 0.00394, 0.00327, 0.003485, 0.004, 0.004425, 0.00383, 0.00431, 0.00432, 0.003905, 0.00389, 0.00348, 0.0043075, 0.0043475, 0.002795, 0.00278, 0.0031825, 0.0029475, 0.00287, 0.0032325, 0.0039425, 0.0034175, 0.0034525, 0.0027475, 0.00204875, 0.0023725, 0.0032525, 0.0045575, 0.0039525, 0.0030475, 0.00190775, 0.00208225, 0.0042875, 0.006275, 0.0068475, 0.0067975, 0.0057875, 0.00474, 0.0035375, 0.002955, 0.002815, 0.002705, 0.0026775, 0.00318, 0.0037575, 0.0046725, 0.00471, 0.004225, 0.0039275, 0.0028075, 0.00236, 0.0034525, 0.0040625, 0.0032475, 0.002755, 0.0025475, 0.003945, 0.00541, 0.0049375, 0.0054425, 0.0057625, 0.0060275, 0.0047225, 0.0030675, 0.00252, 0.004125, 0.007275, 0.0081475, 0.00652, 0.0054175, 0.00443, 0.0046875, 0.0050275, 0.0056325, 0.00588, 0.0052175, 0.0038125, 0.0048675, 0.007035, 0.00606, 0.00665, 0.0072075, 0.0060975, 0.0067275, 0.006325, 0.004475, 0.00312, 0.0035675, 0.0053475, 0.006655, 0.0069075, 0.005945, 0.005515, 0.0042025, 0.0030525, 0.003365, 0.0042475, 0.004, 0.00351, 0.0035425, 0.004005, 0.0025275, 0.00168875, 0.001784, 0.002283, 0.00167175, 0.00122775, 0.00097725, 0.00103075, 0.00174075, 0.00158575, 0.00093, 0.0005505, 0.00065625, 0.00123275, 0.00110525, 0.00059925, 0.00032075, 0.0003555, 0.0006225, 0.000802, 0.000524, 0.000524, 0.0004795, 0.00040325, 0.0004645, 0.00028025, 7.38e-05, 2.33625e-05, 5.8725e-05, 0.000229775, 0.00062125, 0.00071075, 0.0003355, 0.000106825, 2.43625e-05, 1.287e-05, 3.9275e-05, 5.3825e-05, 2.6475e-05, 3.57e-05, 0.000141825, 0.00027725, 0.000173725, 6.6775e-05, 1.812e-05, 2.43175e-06, 4.325e-07, 1.50125e-07, 9.1e-07, 5.1075e-06, 1.98225e-05, 2.8125e-05, 1.1625e-05, 2.93e-06, 3.0225e-06, 5.305e-06, 3.5e-06, 1.62125e-06, 5.4125e-07, 8.9525e-08, 1.5245e-08, 1.736e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.872477275, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.905e-08, 4.3725e-07, 2.7425e-06, 1.66075e-05, 9.2425e-05, 0.000384, 0.000933, 0.001348, 0.00186025, 0.00223525, 0.002002, 0.00263, 0.00304, 0.0028325, 0.00317, 0.00298, 0.0029825, 0.00405, 0.0040175, 0.0039825, 0.00332, 0.0029225, 0.0043225, 0.005025, 0.0044775, 0.0047575, 0.003515, 0.003705, 0.004945, 0.00486, 0.00454, 0.0044, 0.0047875, 0.00596, 0.00498, 0.00483, 0.004425, 0.003275, 0.004775, 0.006075, 0.0058725, 0.00633, 0.0051625, 0.0045, 0.0045275, 0.00465, 0.005385, 0.004965, 0.0047325, 0.0064475, 0.006015, 0.005855, 0.0047275, 0.0040225, 0.005795, 0.0064375, 0.005595, 0.00473, 0.0037775, 0.005105, 0.0057075, 0.005535, 0.0056675, 0.0051525, 0.0065375, 0.0070225, 0.0045725, 0.004005, 0.00361, 0.00376, 0.0054425, 0.0060925, 0.0063275, 0.0048675, 0.004925, 0.0054825, 0.0050525, 0.0051025, 0.0044075, 0.0035775, 0.0047375, 0.00496, 0.0050625, 0.0042825, 0.0038, 0.0042775, 0.0035925, 0.0040475, 0.0042125, 0.003405, 0.0040075, 0.0041025, 0.0033375, 0.0029375, 0.0027925, 0.0037475, 0.0039925, 0.0036925, 0.00356, 0.003495, 0.0045875, 0.00527, 0.0048075, 0.0051575, 0.0045325, 0.003215, 0.003935, 0.0054475, 0.00527, 0.003475, 0.00312, 0.004505, 0.004665, 0.0043325, 0.0046, 0.0044975, 0.0037875, 0.003895, 0.00404, 0.0043725, 0.00394, 0.00327, 0.003485, 0.004, 0.004425, 0.00383, 0.00431, 0.00432, 0.003905, 0.00389, 0.00348, 0.0043075, 0.0043475, 0.002795, 0.00278, 0.0031825, 0.0029475, 0.00287, 0.0032325, 0.0039425, 0.0034175, 0.0034525, 0.0027475, 0.00204875, 0.0023725, 0.0032525, 0.0045575, 0.0039525, 0.0030475, 0.00190775, 0.00208225, 0.0042875, 0.006275, 0.0068475, 0.0067975, 0.0057875, 0.00474, 0.0035375, 0.002955, 0.002815, 0.002705, 0.0026775, 0.00318, 0.0037575, 0.0046725, 0.00471, 0.004225, 0.0039275, 0.0028075, 0.00236, 0.0034525, 0.0040625, 0.0032475, 0.002755, 0.0025475, 0.003945, 0.00541, 0.0049375, 0.0054425, 0.0057625, 0.0060275, 0.0047225, 0.0030675, 0.00252, 0.004125, 0.007275, 0.0081475, 0.00652, 0.0054175, 0.00443, 0.0046875, 0.0050275, 0.0056325, 0.00588, 0.0052175, 0.0038125, 0.0048675, 0.007035, 0.00606, 0.00665, 0.0072075, 0.0060975, 0.0067275, 0.006325, 0.004475, 0.00312, 0.0035675, 0.0053475, 0.006655, 0.0069075, 0.005945, 0.005515, 0.0042025, 0.0030525, 0.003365, 0.0042475, 0.004, 0.00351, 0.0035425, 0.004005, 0.0025275, 0.00168875, 0.001784, 0.002283, 0.00167175, 0.00122775, 0.00097725, 0.00103075, 0.00174075, 0.00158575, 0.00093, 0.0005505, 0.00065625, 0.00123275, 0.00110525, 0.00059925, 0.00032075, 0.0003555, 0.0006225, 0.000802, 0.000524, 0.000524, 0.0004795, 0.00040325, 0.0004645, 0.00028025, 7.38e-05, 2.33625e-05, 5.8725e-05, 0.000229775, 0.00062125, 0.00071075, 0.0003355, 0.000106825, 2.43625e-05, 1.287e-05, 3.9275e-05, 5.3825e-05, 2.6475e-05, 3.57e-05, 0.000141825, 0.00027725, 0.000173725, 6.6775e-05, 1.812e-05, 2.43175e-06, 4.325e-07, 1.50125e-07, 9.1e-07, 5.1075e-06, 1.98225e-05, 2.8125e-05, 1.1625e-05, 2.93e-06, 3.0225e-06, 5.305e-06, 3.5e-06, 1.62125e-06, 5.4125e-07, 8.9525e-08, 1.5245e-08, 1.736e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.872477275, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.905e-08, 4.3725e-07, 2.7425e-06, 1.66075e-05, 9.2425e-05, 0.000384, 0.000933, 0.001348, 0.00186025, 0.00223525, 0.002002, 0.00263, 0.00304, 0.0028325, 0.00317, 0.00298, 0.0029825, 0.00405, 0.0040175, 0.0039825, 0.00332, 0.0029225, 0.0043225, 0.005025, 0.0044775, 0.0047575, 0.003515, 0.003705, 0.004945, 0.00486, 0.00454, 0.0044, 0.0047875, 0.00596, 0.00498, 0.00483, 0.004425, 0.003275, 0.004775, 0.006075, 0.0058725, 0.00633, 0.0051625, 0.0045, 0.0045275, 0.00465, 0.005385, 0.004965, 0.0047325, 0.0064475, 0.006015, 0.005855, 0.0047275, 0.0040225, 0.005795, 0.0064375, 0.005595, 0.00473, 0.0037775, 0.005105, 0.0057075, 0.005535, 0.0056675, 0.0051525, 0.0065375, 0.0070225, 0.0045725, 0.004005, 0.00361, 0.00376, 0.0054425, 0.0060925, 0.0063275, 0.0048675, 0.004925, 0.0054825, 0.0050525, 0.0051025, 0.0044075, 0.0035775, 0.0047375, 0.00496, 0.0050625, 0.0042825, 0.0038, 0.0042775, 0.0035925, 0.0040475, 0.0042125, 0.003405, 0.0040075, 0.0041025, 0.0033375, 0.0029375, 0.0027925, 0.0037475, 0.0039925, 0.0036925, 0.00356, 0.003495, 0.0045875, 0.00527, 0.0048075, 0.0051575, 0.0045325, 0.003215, 0.003935, 0.0054475, 0.00527, 0.003475, 0.00312, 0.004505, 0.004665, 0.0043325, 0.0046, 0.0044975, 0.0037875, 0.003895, 0.00404, 0.0043725, 0.00394, 0.00327, 0.003485, 0.004, 0.004425, 0.00383, 0.00431, 0.00432, 0.003905, 0.00389, 0.00348, 0.0043075, 0.0043475, 0.002795, 0.00278, 0.0031825, 0.0029475, 0.00287, 0.0032325, 0.0039425, 0.0034175, 0.0034525, 0.0027475, 0.00204875, 0.0023725, 0.0032525, 0.0045575, 0.0039525, 0.0030475, 0.00190775, 0.00208225, 0.0042875, 0.006275, 0.0068475, 0.0067975, 0.0057875, 0.00474, 0.0035375, 0.002955, 0.002815, 0.002705, 0.0026775, 0.00318, 0.0037575, 0.0046725, 0.00471, 0.004225, 0.0039275, 0.0028075, 0.00236, 0.0034525, 0.0040625, 0.0032475, 0.002755, 0.0025475, 0.003945, 0.00541, 0.0049375, 0.0054425, 0.0057625, 0.0060275, 0.0047225, 0.0030675, 0.00252, 0.004125, 0.007275, 0.0081475, 0.00652, 0.0054175, 0.00443, 0.0046875, 0.0050275, 0.0056325, 0.00588, 0.0052175, 0.0038125, 0.0048675, 0.007035, 0.00606, 0.00665, 0.0072075, 0.0060975, 0.0067275, 0.006325, 0.004475, 0.00312, 0.0035675, 0.0053475, 0.006655, 0.0069075, 0.005945, 0.005515, 0.0042025, 0.0030525, 0.003365, 0.0042475, 0.004, 0.00351, 0.0035425, 0.004005, 0.0025275, 0.00168875, 0.001784, 0.002283, 0.00167175, 0.00122775, 0.00097725, 0.00103075, 0.00174075, 0.00158575, 0.00093, 0.0005505, 0.00065625, 0.00123275, 0.00110525, 0.00059925, 0.00032075, 0.0003555, 0.0006225, 0.000802, 0.000524, 0.000524, 0.0004795, 0.00040325, 0.0004645, 0.00028025, 7.38e-05, 2.33625e-05, 5.8725e-05, 0.000229775, 0.00062125, 0.00071075, 0.0003355, 0.000106825, 2.43625e-05, 1.287e-05, 3.9275e-05, 5.3825e-05, 2.6475e-05, 3.57e-05, 0.000141825, 0.00027725, 0.000173725, 6.6775e-05, 1.812e-05, 2.43175e-06, 4.325e-07, 1.50125e-07, 9.1e-07, 5.1075e-06, 1.98225e-05, 2.8125e-05, 1.1625e-05, 2.93e-06, 3.0225e-06, 5.305e-06, 3.5e-06, 1.62125e-06, 5.4125e-07, 8.9525e-08, 1.5245e-08, 1.736e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.872477275, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.905e-08, 4.3725e-07, 2.7425e-06, 1.66075e-05, 9.2425e-05, 0.000384, 0.000933, 0.001348, 0.00186025, 0.00223525, 0.002002, 0.00263, 0.00304, 0.0028325, 0.00317, 0.00298, 0.0029825, 0.00405, 0.0040175, 0.0039825, 0.00332, 0.0029225, 0.0043225, 0.005025, 0.0044775, 0.0047575, 0.003515, 0.003705, 0.004945, 0.00486, 0.00454, 0.0044, 0.0047875, 0.00596, 0.00498, 0.00483, 0.004425, 0.003275, 0.004775, 0.006075, 0.0058725, 0.00633, 0.0051625, 0.0045, 0.0045275, 0.00465, 0.005385, 0.004965, 0.0047325, 0.0064475, 0.006015, 0.005855, 0.0047275, 0.0040225, 0.005795, 0.0064375, 0.005595, 0.00473, 0.0037775, 0.005105, 0.0057075, 0.005535, 0.0056675, 0.0051525, 0.0065375, 0.0070225, 0.0045725, 0.004005, 0.00361, 0.00376, 0.0054425, 0.0060925, 0.0063275, 0.0048675, 0.004925, 0.0054825, 0.0050525, 0.0051025, 0.0044075, 0.0035775, 0.0047375, 0.00496, 0.0050625, 0.0042825, 0.0038, 0.0042775, 0.0035925, 0.0040475, 0.0042125, 0.003405, 0.0040075, 0.0041025, 0.0033375, 0.0029375, 0.0027925, 0.0037475, 0.0039925, 0.0036925, 0.00356, 0.003495, 0.0045875, 0.00527, 0.0048075, 0.0051575, 0.0045325, 0.003215, 0.003935, 0.0054475, 0.00527, 0.003475, 0.00312, 0.004505, 0.004665, 0.0043325, 0.0046, 0.0044975, 0.0037875, 0.003895, 0.00404, 0.0043725, 0.00394, 0.00327, 0.003485, 0.004, 0.004425, 0.00383, 0.00431, 0.00432, 0.003905, 0.00389, 0.00348, 0.0043075, 0.0043475, 0.002795, 0.00278, 0.0031825, 0.0029475, 0.00287, 0.0032325, 0.0039425, 0.0034175, 0.0034525, 0.0027475, 0.00204875, 0.0023725, 0.0032525, 0.0045575, 0.0039525, 0.0030475, 0.00190775, 0.00208225, 0.0042875, 0.006275, 0.0068475, 0.0067975, 0.0057875, 0.00474, 0.0035375, 0.002955, 0.002815, 0.002705, 0.0026775, 0.00318, 0.0037575, 0.0046725, 0.00471, 0.004225, 0.0039275, 0.0028075, 0.00236, 0.0034525, 0.0040625, 0.0032475, 0.002755, 0.0025475, 0.003945, 0.00541, 0.0049375, 0.0054425, 0.0057625, 0.0060275, 0.0047225, 0.0030675, 0.00252, 0.004125, 0.007275, 0.0081475, 0.00652, 0.0054175, 0.00443, 0.0046875, 0.0050275, 0.0056325, 0.00588, 0.0052175, 0.0038125, 0.0048675, 0.007035, 0.00606, 0.00665, 0.0072075, 0.0060975, 0.0067275, 0.006325, 0.004475, 0.00312, 0.0035675, 0.0053475, 0.006655, 0.0069075, 0.005945, 0.005515, 0.0042025, 0.0030525, 0.003365, 0.0042475, 0.004, 0.00351, 0.0035425, 0.004005, 0.0025275, 0.00168875, 0.001784, 0.002283, 0.00167175, 0.00122775, 0.00097725, 0.00103075, 0.00174075, 0.00158575, 0.00093, 0.0005505, 0.00065625, 0.00123275, 0.00110525, 0.00059925, 0.00032075, 0.0003555, 0.0006225, 0.000802, 0.000524, 0.000524, 0.0004795, 0.00040325, 0.0004645, 0.00028025, 7.38e-05, 2.33625e-05, 5.8725e-05, 0.000229775, 0.00062125, 0.00071075, 0.0003355, 0.000106825, 2.43625e-05, 1.287e-05, 3.9275e-05, 5.3825e-05, 2.6475e-05, 3.57e-05, 0.000141825, 0.00027725, 0.000173725, 6.6775e-05, 1.812e-05, 2.43175e-06, 4.325e-07, 1.50125e-07, 9.1e-07, 5.1075e-06, 1.98225e-05, 2.8125e-05, 1.1625e-05, 2.93e-06, 3.0225e-06, 5.305e-06, 3.5e-06, 1.62125e-06, 5.4125e-07, 8.9525e-08, 1.5245e-08, 1.736e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.055e-07, 6.54e-06, 3.975e-05, 0.000232925, 0.00125375, 0.0050725, 0.01219, 0.0177625, 0.02467, 0.029575, 0.0271, 0.0357, 0.0412, 0.03895, 0.0438, 0.041225, 0.04255, 0.0572, 0.057075, 0.05685, 0.047475, 0.0435, 0.0644, 0.073725, 0.06715, 0.070725, 0.052925, 0.05805, 0.076425, 0.075025, 0.07125, 0.06935, 0.078125, 0.095075, 0.079975, 0.0793, 0.071225, 0.05555, 0.082925, 0.102675, 0.101075, 0.1085, 0.088275, 0.079325, 0.080725, 0.084075, 0.09825, 0.088975, 0.090525, 0.120625, 0.112575, 0.11075, 0.08845, 0.08065, 0.116725, 0.126075, 0.111525, 0.0937, 0.0794, 0.10865, 0.119825, 0.118, 0.12155, 0.11325, 0.1485, 0.152675, 0.10065, 0.092325, 0.083325, 0.093025, 0.133575, 0.1497, 0.1547, 0.120475, 0.128025, 0.141775, 0.1335, 0.13975, 0.12035, 0.103475, 0.138575, 0.148025, 0.151625, 0.1315, 0.131175, 0.155475, 0.140175, 0.150625, 0.1526, 0.136725, 0.15805, 0.16395, 0.137825, 0.122725, 0.123025, 0.15395, 0.148425, 0.12175, 0.105625, 0.126675, 0.18255, 0.195925, 0.17825, 0.188975, 0.168625, 0.1262, 0.1325, 0.16685, 0.1793, 0.153025, 0.160825, 0.18215, 0.168325, 0.1735, 0.19635, 0.188975, 0.1397, 0.1308, 0.1425, 0.1575, 0.157725, 0.143675, 0.149975, 0.178175, 0.1859, 0.1613, 0.173275, 0.16855, 0.16205, 0.164325, 0.1732, 0.208175, 0.19575, 0.139675, 0.16085, 0.178325, 0.14705, 0.16065, 0.1935, 0.210625, 0.194675, 0.1944, 0.158, 0.1465, 0.1559, 0.161675, 0.1618, 0.14775, 0.156075, 0.12975, 0.13425, 0.194525, 0.2385, 0.25525, 0.2461, 0.220425, 0.222075, 0.18815, 0.171025, 0.1617, 0.137175, 0.151825, 0.1699, 0.18405, 0.219125, 0.22015, 0.228425, 0.1925, 0.1352, 0.1468, 0.19375, 0.19995, 0.168475, 0.159425, 0.179025, 0.233675, 0.25025, 0.2031, 0.221625, 0.21405, 0.161125, 0.166025, 0.182375, 0.179325, 0.19795, 0.20845, 0.2375, 0.2535, 0.21595, 0.167725, 0.14455, 0.18915, 0.211175, 0.2399, 0.217025, 0.207425, 0.22165, 0.204175, 0.2349, 0.24335, 0.27975, 0.2735, 0.206775, 0.187025, 0.1673, 0.1575, 0.145, 0.18095, 0.249975, 0.26, 0.29175, 0.26975, 0.179275, 0.163925, 0.162525, 0.1596, 0.1678, 0.18545, 0.2126, 0.140775, 0.084225, 0.07265, 0.0913, 0.082675, 0.0901, 0.12415, 0.11255, 0.0923, 0.069775, 0.0449, 0.0454, 0.038825, 0.052225, 0.0801, 0.0773, 0.04675, 0.055425, 0.07225, 0.0559, 0.025275, 0.02049, 0.025225, 0.03655, 0.041275, 0.0493, 0.03255, 0.0109625, 0.0062525, 0.0206175, 0.0574, 0.063825, 0.04925, 0.03415, 0.0121025, 0.00291, 0.0031275, 0.0095825, 0.012425, 0.0070225, 0.012465, 0.02955, 0.0268, 0.02473, 0.025275, 0.009655, 0.001959, 0.00035325, 7.13e-05, 0.00041775, 0.00227, 0.0086325, 0.0124875, 0.005525, 0.00208025, 0.00475, 0.011955, 0.01037, 0.0055725, 0.0047325, 0.001985, 0.00041175, 7.255e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.9031960675, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.95e-08, 5.01e-07, 3.0425e-06, 1.78275e-05, 9.5925e-05, 0.0003875, 0.000929, 0.0013465, 0.00185725, 0.002215, 0.00201375, 0.0026325, 0.00302, 0.0028325, 0.0031625, 0.00296, 0.0030225, 0.0040375, 0.004005, 0.00396, 0.003285, 0.0029775, 0.00437, 0.0049775, 0.0044975, 0.004705, 0.003495, 0.0037875, 0.0049525, 0.00483, 0.0045475, 0.00439, 0.004895, 0.00592, 0.0049425, 0.0048525, 0.0043325, 0.0033375, 0.00493, 0.006065, 0.00592, 0.0063025, 0.00509, 0.0045225, 0.0045575, 0.0047, 0.005445, 0.0048925, 0.00491, 0.00649, 0.006005, 0.00585, 0.0046325, 0.0041625, 0.0059625, 0.0063925, 0.0055925, 0.0046525, 0.0038875, 0.0052525, 0.00574, 0.00559, 0.005695, 0.00523, 0.006765, 0.00691, 0.0045075, 0.00406, 0.00361, 0.0039425, 0.005605, 0.0062125, 0.0063475, 0.00488, 0.0050775, 0.0055425, 0.00511, 0.0051925, 0.0044075, 0.003715, 0.00486, 0.0051, 0.00519, 0.0043025, 0.00391, 0.004385, 0.0037675, 0.0042575, 0.0042575, 0.0035575, 0.00416, 0.0041925, 0.003475, 0.0030925, 0.0031225, 0.004175, 0.0042425, 0.0039525, 0.0034525, 0.00339, 0.0050425, 0.00536, 0.005015, 0.0052725, 0.0042875, 0.00344, 0.0044725, 0.0054925, 0.0048175, 0.0031925, 0.0035775, 0.004775, 0.0046125, 0.00427, 0.004705, 0.004555, 0.0038125, 0.00386, 0.0040875, 0.004355, 0.00375, 0.003315, 0.0035725, 0.0041075, 0.004405, 0.003845, 0.0044675, 0.0042775, 0.00398, 0.003855, 0.0035525, 0.004485, 0.00431, 0.00282, 0.00287, 0.003325, 0.002995, 0.0029325, 0.003425, 0.00402, 0.003485, 0.00363, 0.002875, 0.00234325, 0.0030775, 0.004345, 0.0045475, 0.00328, 0.002715, 0.002111, 0.002995, 0.00523, 0.0064675, 0.0070875, 0.0066725, 0.005435, 0.00444, 0.0033875, 0.003085, 0.003075, 0.00271, 0.0029275, 0.0034, 0.0040275, 0.0050775, 0.0045775, 0.0045025, 0.00398, 0.002585, 0.0026375, 0.00419, 0.0044575, 0.0030675, 0.00293, 0.004025, 0.005025, 0.0060725, 0.0060425, 0.0066075, 0.0055525, 0.00326, 0.0029075, 0.00352, 0.00532, 0.0077225, 0.0075175, 0.0065675, 0.0057525, 0.00511, 0.0047425, 0.0039125, 0.0047175, 0.0052375, 0.0057725, 0.0053625, 0.00646, 0.0066475, 0.00502, 0.006125, 0.0060925, 0.006825, 0.00781, 0.0059275, 0.00406, 0.003455, 0.00443, 0.0050075, 0.005505, 0.00648, 0.00621, 0.0059625, 0.004665, 0.0030275, 0.0034375, 0.004155, 0.00381, 0.0032575, 0.0033325, 0.004375, 0.0030025, 0.00185025, 0.001743, 0.0020745, 0.00136975, 0.00107125, 0.00124325, 0.00157725, 0.00194475, 0.001409, 0.00071525, 0.00061125, 0.000653, 0.0009795, 0.00108075, 0.00086575, 0.00039925, 0.0003745, 0.00078175, 0.00087625, 0.0005115, 0.00045375, 0.0003735, 0.00040175, 0.0004165, 0.00039575, 0.00021475, 5.9725e-05, 4.7125e-05, 0.000193975, 0.0006175, 0.00072525, 0.00035575, 0.000177475, 6.5125e-05, 1.4715e-05, 1.50475e-05, 4.5625e-05, 6.0625e-05, 4.3825e-05, 0.000109925, 0.00026575, 0.000208575, 8.57e-05, 4.94e-05, 1.707e-05, 3.17e-06, 5.835e-07, 1.87225e-07, 1.0975e-06, 5.9625e-06, 2.26625e-05, 3.275e-05, 1.42e-05, 3.7e-06, 3.8825e-06, 8.73e-06, 7.0925e-06, 2.06125e-06, 3.9e-07, 6.69e-08, 4.8125e-12, 8.4825e-13, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.9031960675, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.95e-08, 5.01e-07, 3.0425e-06, 1.78275e-05, 9.5925e-05, 0.0003875, 0.000929, 0.0013465, 0.00185725, 0.002215, 0.00201375, 0.0026325, 0.00302, 0.0028325, 0.0031625, 0.00296, 0.0030225, 0.0040375, 0.004005, 0.00396, 0.003285, 0.0029775, 0.00437, 0.0049775, 0.0044975, 0.004705, 0.003495, 0.0037875, 0.0049525, 0.00483, 0.0045475, 0.00439, 0.004895, 0.00592, 0.0049425, 0.0048525, 0.0043325, 0.0033375, 0.00493, 0.006065, 0.00592, 0.0063025, 0.00509, 0.0045225, 0.0045575, 0.0047, 0.005445, 0.0048925, 0.00491, 0.00649, 0.006005, 0.00585, 0.0046325, 0.0041625, 0.0059625, 0.0063925, 0.0055925, 0.0046525, 0.0038875, 0.0052525, 0.00574, 0.00559, 0.005695, 0.00523, 0.006765, 0.00691, 0.0045075, 0.00406, 0.00361, 0.0039425, 0.005605, 0.0062125, 0.0063475, 0.00488, 0.0050775, 0.0055425, 0.00511, 0.0051925, 0.0044075, 0.003715, 0.00486, 0.0051, 0.00519, 0.0043025, 0.00391, 0.004385, 0.0037675, 0.0042575, 0.0042575, 0.0035575, 0.00416, 0.0041925, 0.003475, 0.0030925, 0.0031225, 0.004175, 0.0042425, 0.0039525, 0.0034525, 0.00339, 0.0050425, 0.00536, 0.005015, 0.0052725, 0.0042875, 0.00344, 0.0044725, 0.0054925, 0.0048175, 0.0031925, 0.0035775, 0.004775, 0.0046125, 0.00427, 0.004705, 0.004555, 0.0038125, 0.00386, 0.0040875, 0.004355, 0.00375, 0.003315, 0.0035725, 0.0041075, 0.004405, 0.003845, 0.0044675, 0.0042775, 0.00398, 0.003855, 0.0035525, 0.004485, 0.00431, 0.00282, 0.00287, 0.003325, 0.002995, 0.0029325, 0.003425, 0.00402, 0.003485, 0.00363, 0.002875, 0.00234325, 0.0030775, 0.004345, 0.0045475, 0.00328, 0.002715, 0.002111, 0.002995, 0.00523, 0.0064675, 0.0070875, 0.0066725, 0.005435, 0.00444, 0.0033875, 0.003085, 0.003075, 0.00271, 0.0029275, 0.0034, 0.0040275, 0.0050775, 0.0045775, 0.0045025, 0.00398, 0.002585, 0.0026375, 0.00419, 0.0044575, 0.0030675, 0.00293, 0.004025, 0.005025, 0.0060725, 0.0060425, 0.0066075, 0.0055525, 0.00326, 0.0029075, 0.00352, 0.00532, 0.0077225, 0.0075175, 0.0065675, 0.0057525, 0.00511, 0.0047425, 0.0039125, 0.0047175, 0.0052375, 0.0057725, 0.0053625, 0.00646, 0.0066475, 0.00502, 0.006125, 0.0060925, 0.006825, 0.00781, 0.0059275, 0.00406, 0.003455, 0.00443, 0.0050075, 0.005505, 0.00648, 0.00621, 0.0059625, 0.004665, 0.0030275, 0.0034375, 0.004155, 0.00381, 0.0032575, 0.0033325, 0.004375, 0.0030025, 0.00185025, 0.001743, 0.0020745, 0.00136975, 0.00107125, 0.00124325, 0.00157725, 0.00194475, 0.001409, 0.00071525, 0.00061125, 0.000653, 0.0009795, 0.00108075, 0.00086575, 0.00039925, 0.0003745, 0.00078175, 0.00087625, 0.0005115, 0.00045375, 0.0003735, 0.00040175, 0.0004165, 0.00039575, 0.00021475, 5.9725e-05, 4.7125e-05, 0.000193975, 0.0006175, 0.00072525, 0.00035575, 0.000177475, 6.5125e-05, 1.4715e-05, 1.50475e-05, 4.5625e-05, 6.0625e-05, 4.3825e-05, 0.000109925, 0.00026575, 0.000208575, 8.57e-05, 4.94e-05, 1.707e-05, 3.17e-06, 5.835e-07, 1.87225e-07, 1.0975e-06, 5.9625e-06, 2.26625e-05, 3.275e-05, 1.42e-05, 3.7e-06, 3.8825e-06, 8.73e-06, 7.0925e-06, 2.06125e-06, 3.9e-07, 6.69e-08, 4.8125e-12, 8.4825e-13, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.9031960675, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.95e-08, 5.01e-07, 3.0425e-06, 1.78275e-05, 9.5925e-05, 0.0003875, 0.000929, 0.0013465, 0.00185725, 0.002215, 0.00201375, 0.0026325, 0.00302, 0.0028325, 0.0031625, 0.00296, 0.0030225, 0.0040375, 0.004005, 0.00396, 0.003285, 0.0029775, 0.00437, 0.0049775, 0.0044975, 0.004705, 0.003495, 0.0037875, 0.0049525, 0.00483, 0.0045475, 0.00439, 0.004895, 0.00592, 0.0049425, 0.0048525, 0.0043325, 0.0033375, 0.00493, 0.006065, 0.00592, 0.0063025, 0.00509, 0.0045225, 0.0045575, 0.0047, 0.005445, 0.0048925, 0.00491, 0.00649, 0.006005, 0.00585, 0.0046325, 0.0041625, 0.0059625, 0.0063925, 0.0055925, 0.0046525, 0.0038875, 0.0052525, 0.00574, 0.00559, 0.005695, 0.00523, 0.006765, 0.00691, 0.0045075, 0.00406, 0.00361, 0.0039425, 0.005605, 0.0062125, 0.0063475, 0.00488, 0.0050775, 0.0055425, 0.00511, 0.0051925, 0.0044075, 0.003715, 0.00486, 0.0051, 0.00519, 0.0043025, 0.00391, 0.004385, 0.0037675, 0.0042575, 0.0042575, 0.0035575, 0.00416, 0.0041925, 0.003475, 0.0030925, 0.0031225, 0.004175, 0.0042425, 0.0039525, 0.0034525, 0.00339, 0.0050425, 0.00536, 0.005015, 0.0052725, 0.0042875, 0.00344, 0.0044725, 0.0054925, 0.0048175, 0.0031925, 0.0035775, 0.004775, 0.0046125, 0.00427, 0.004705, 0.004555, 0.0038125, 0.00386, 0.0040875, 0.004355, 0.00375, 0.003315, 0.0035725, 0.0041075, 0.004405, 0.003845, 0.0044675, 0.0042775, 0.00398, 0.003855, 0.0035525, 0.004485, 0.00431, 0.00282, 0.00287, 0.003325, 0.002995, 0.0029325, 0.003425, 0.00402, 0.003485, 0.00363, 0.002875, 0.00234325, 0.0030775, 0.004345, 0.0045475, 0.00328, 0.002715, 0.002111, 0.002995, 0.00523, 0.0064675, 0.0070875, 0.0066725, 0.005435, 0.00444, 0.0033875, 0.003085, 0.003075, 0.00271, 0.0029275, 0.0034, 0.0040275, 0.0050775, 0.0045775, 0.0045025, 0.00398, 0.002585, 0.0026375, 0.00419, 0.0044575, 0.0030675, 0.00293, 0.004025, 0.005025, 0.0060725, 0.0060425, 0.0066075, 0.0055525, 0.00326, 0.0029075, 0.00352, 0.00532, 0.0077225, 0.0075175, 0.0065675, 0.0057525, 0.00511, 0.0047425, 0.0039125, 0.0047175, 0.0052375, 0.0057725, 0.0053625, 0.00646, 0.0066475, 0.00502, 0.006125, 0.0060925, 0.006825, 0.00781, 0.0059275, 0.00406, 0.003455, 0.00443, 0.0050075, 0.005505, 0.00648, 0.00621, 0.0059625, 0.004665, 0.0030275, 0.0034375, 0.004155, 0.00381, 0.0032575, 0.0033325, 0.004375, 0.0030025, 0.00185025, 0.001743, 0.0020745, 0.00136975, 0.00107125, 0.00124325, 0.00157725, 0.00194475, 0.001409, 0.00071525, 0.00061125, 0.000653, 0.0009795, 0.00108075, 0.00086575, 0.00039925, 0.0003745, 0.00078175, 0.00087625, 0.0005115, 0.00045375, 0.0003735, 0.00040175, 0.0004165, 0.00039575, 0.00021475, 5.9725e-05, 4.7125e-05, 0.000193975, 0.0006175, 0.00072525, 0.00035575, 0.000177475, 6.5125e-05, 1.4715e-05, 1.50475e-05, 4.5625e-05, 6.0625e-05, 4.3825e-05, 0.000109925, 0.00026575, 0.000208575, 8.57e-05, 4.94e-05, 1.707e-05, 3.17e-06, 5.835e-07, 1.87225e-07, 1.0975e-06, 5.9625e-06, 2.26625e-05, 3.275e-05, 1.42e-05, 3.7e-06, 3.8825e-06, 8.73e-06, 7.0925e-06, 2.06125e-06, 3.9e-07, 6.69e-08, 4.8125e-12, 8.4825e-13, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.9031960675, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.95e-08, 5.01e-07, 3.0425e-06, 1.78275e-05, 9.5925e-05, 0.0003875, 0.000929, 0.0013465, 0.00185725, 0.002215, 0.00201375, 0.0026325, 0.00302, 0.0028325, 0.0031625, 0.00296, 0.0030225, 0.0040375, 0.004005, 0.00396, 0.003285, 0.0029775, 0.00437, 0.0049775, 0.0044975, 0.004705, 0.003495, 0.0037875, 0.0049525, 0.00483, 0.0045475, 0.00439, 0.004895, 0.00592, 0.0049425, 0.0048525, 0.0043325, 0.0033375, 0.00493, 0.006065, 0.00592, 0.0063025, 0.00509, 0.0045225, 0.0045575, 0.0047, 0.005445, 0.0048925, 0.00491, 0.00649, 0.006005, 0.00585, 0.0046325, 0.0041625, 0.0059625, 0.0063925, 0.0055925, 0.0046525, 0.0038875, 0.0052525, 0.00574, 0.00559, 0.005695, 0.00523, 0.006765, 0.00691, 0.0045075, 0.00406, 0.00361, 0.0039425, 0.005605, 0.0062125, 0.0063475, 0.00488, 0.0050775, 0.0055425, 0.00511, 0.0051925, 0.0044075, 0.003715, 0.00486, 0.0051, 0.00519, 0.0043025, 0.00391, 0.004385, 0.0037675, 0.0042575, 0.0042575, 0.0035575, 0.00416, 0.0041925, 0.003475, 0.0030925, 0.0031225, 0.004175, 0.0042425, 0.0039525, 0.0034525, 0.00339, 0.0050425, 0.00536, 0.005015, 0.0052725, 0.0042875, 0.00344, 0.0044725, 0.0054925, 0.0048175, 0.0031925, 0.0035775, 0.004775, 0.0046125, 0.00427, 0.004705, 0.004555, 0.0038125, 0.00386, 0.0040875, 0.004355, 0.00375, 0.003315, 0.0035725, 0.0041075, 0.004405, 0.003845, 0.0044675, 0.0042775, 0.00398, 0.003855, 0.0035525, 0.004485, 0.00431, 0.00282, 0.00287, 0.003325, 0.002995, 0.0029325, 0.003425, 0.00402, 0.003485, 0.00363, 0.002875, 0.00234325, 0.0030775, 0.004345, 0.0045475, 0.00328, 0.002715, 0.002111, 0.002995, 0.00523, 0.0064675, 0.0070875, 0.0066725, 0.005435, 0.00444, 0.0033875, 0.003085, 0.003075, 0.00271, 0.0029275, 0.0034, 0.0040275, 0.0050775, 0.0045775, 0.0045025, 0.00398, 0.002585, 0.0026375, 0.00419, 0.0044575, 0.0030675, 0.00293, 0.004025, 0.005025, 0.0060725, 0.0060425, 0.0066075, 0.0055525, 0.00326, 0.0029075, 0.00352, 0.00532, 0.0077225, 0.0075175, 0.0065675, 0.0057525, 0.00511, 0.0047425, 0.0039125, 0.0047175, 0.0052375, 0.0057725, 0.0053625, 0.00646, 0.0066475, 0.00502, 0.006125, 0.0060925, 0.006825, 0.00781, 0.0059275, 0.00406, 0.003455, 0.00443, 0.0050075, 0.005505, 0.00648, 0.00621, 0.0059625, 0.004665, 0.0030275, 0.0034375, 0.004155, 0.00381, 0.0032575, 0.0033325, 0.004375, 0.0030025, 0.00185025, 0.001743, 0.0020745, 0.00136975, 0.00107125, 0.00124325, 0.00157725, 0.00194475, 0.001409, 0.00071525, 0.00061125, 0.000653, 0.0009795, 0.00108075, 0.00086575, 0.00039925, 0.0003745, 0.00078175, 0.00087625, 0.0005115, 0.00045375, 0.0003735, 0.00040175, 0.0004165, 0.00039575, 0.00021475, 5.9725e-05, 4.7125e-05, 0.000193975, 0.0006175, 0.00072525, 0.00035575, 0.000177475, 6.5125e-05, 1.4715e-05, 1.50475e-05, 4.5625e-05, 6.0625e-05, 4.3825e-05, 0.000109925, 0.00026575, 0.000208575, 8.57e-05, 4.94e-05, 1.707e-05, 3.17e-06, 5.835e-07, 1.87225e-07, 1.0975e-06, 5.9625e-06, 2.26625e-05, 3.275e-05, 1.42e-05, 3.7e-06, 3.8825e-06, 8.73e-06, 7.0925e-06, 2.06125e-06, 3.9e-07, 6.69e-08, 4.8125e-12, 8.4825e-13, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.09075e-06, 7.6725e-06, 4.5175e-05, 0.00025625, 0.00133375, 0.0052475, 0.0124375, 0.0181775, 0.025225, 0.030025, 0.0279, 0.036525, 0.0419, 0.039875, 0.044675, 0.041975, 0.044025, 0.05825, 0.0582, 0.057775, 0.048125, 0.045225, 0.06635, 0.07465, 0.068875, 0.0714, 0.0539, 0.06035, 0.077975, 0.076125, 0.07275, 0.070725, 0.081075, 0.096125, 0.08115, 0.080975, 0.07125, 0.0578, 0.086475, 0.104275, 0.103625, 0.1097, 0.088925, 0.081, 0.0825, 0.08635, 0.1004, 0.08955, 0.09485, 0.12275, 0.114275, 0.112, 0.0885, 0.08445, 0.12065, 0.12695, 0.11285, 0.093675, 0.08265, 0.112175, 0.12175, 0.1204, 0.123225, 0.116425, 0.153475, 0.151875, 0.100975, 0.094, 0.084325, 0.097325, 0.137275, 0.153, 0.15575, 0.122025, 0.1316, 0.1435, 0.135325, 0.1416, 0.12085, 0.1067, 0.140775, 0.1509, 0.1538, 0.130975, 0.13205, 0.155975, 0.1438, 0.156025, 0.152125, 0.139575, 0.160675, 0.165025, 0.14215, 0.125775, 0.12825, 0.158225, 0.153975, 0.128575, 0.102375, 0.13115, 0.18825, 0.19775, 0.1846, 0.187575, 0.169575, 0.138575, 0.144725, 0.165775, 0.168675, 0.154825, 0.170275, 0.1894, 0.17115, 0.175375, 0.1998, 0.190725, 0.148675, 0.135325, 0.147825, 0.156475, 0.152125, 0.1487, 0.155, 0.183775, 0.189025, 0.165, 0.1763, 0.16625, 0.163775, 0.16235, 0.17565, 0.214025, 0.19545, 0.139625, 0.158875, 0.1866, 0.152275, 0.159675, 0.199325, 0.21135, 0.19345, 0.199975, 0.160625, 0.15625, 0.176025, 0.1733, 0.1542, 0.1387, 0.14885, 0.141275, 0.15685, 0.21305, 0.247275, 0.258, 0.23475, 0.203125, 0.21675, 0.1964, 0.181625, 0.166525, 0.1379, 0.1572, 0.181825, 0.19865, 0.216525, 0.2173, 0.232125, 0.193, 0.137025, 0.163075, 0.198925, 0.1896, 0.17055, 0.172025, 0.19515, 0.2525, 0.2725, 0.2116, 0.1952, 0.19095, 0.162625, 0.1893, 0.224475, 0.215775, 0.1995, 0.1923, 0.219725, 0.252, 0.217275, 0.16885, 0.154475, 0.19465, 0.222975, 0.25575, 0.25425, 0.19845, 0.193475, 0.21995, 0.243075, 0.27175, 0.30675, 0.2494, 0.1772, 0.1815, 0.2016, 0.1773, 0.151825, 0.20375, 0.2545, 0.25925, 0.2555, 0.237125, 0.213475, 0.20505, 0.15875, 0.1364, 0.16145, 0.2171, 0.202225, 0.12445, 0.075675, 0.074875, 0.068925, 0.073225, 0.09885, 0.1395, 0.12805, 0.075125, 0.05215, 0.045525, 0.049825, 0.050125, 0.053375, 0.080575, 0.064975, 0.0414, 0.066725, 0.079, 0.049675, 0.02605, 0.0164225, 0.026525, 0.040425, 0.03885, 0.046525, 0.029725, 0.0098325, 0.0108275, 0.0358, 0.06255, 0.04655, 0.040775, 0.03625, 0.0130125, 0.003255, 0.0035075, 0.0101775, 0.0133125, 0.011875, 0.024725, 0.028375, 0.0154075, 0.02047, 0.025025, 0.0103225, 0.002247, 0.00041275, 2.7525e-05, 0.0001577, 0.000879, 0.004235, 0.0116025, 0.0104125, 0.0038425, 0.0038025, 0.010355, 0.0123975, 0.0072125, 0.0051325, 0.002095, 0.000434, 7.92e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.9321930625, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.175e-08, 5.7375e-07, 3.375e-06, 1.91425e-05, 9.9625e-05, 0.0003915, 0.0009255, 0.00134575, 0.00185425, 0.0021975, 0.002026, 0.0026325, 0.0030025, 0.0028375, 0.003155, 0.0029475, 0.00306, 0.004025, 0.003995, 0.00394, 0.00326, 0.00303, 0.0044125, 0.0049375, 0.00452, 0.004655, 0.0034875, 0.0038625, 0.0049575, 0.0048075, 0.0045575, 0.004395, 0.0049875, 0.00588, 0.0049275, 0.00487, 0.00426, 0.003415, 0.005055, 0.00606, 0.00597, 0.0062725, 0.0050475, 0.00455, 0.00459, 0.0047575, 0.005485, 0.004855, 0.0050725, 0.0065175, 0.006015, 0.00584, 0.0045775, 0.0043075, 0.0060925, 0.0063675, 0.0056, 0.004605, 0.004005, 0.0053725, 0.00578, 0.005655, 0.0057225, 0.005335, 0.006945, 0.00683, 0.0044925, 0.0041125, 0.003635, 0.0041125, 0.0057475, 0.006335, 0.0063775, 0.0049325, 0.005215, 0.0056125, 0.0051875, 0.005285, 0.004445, 0.0038525, 0.0049775, 0.00525, 0.0053175, 0.0043525, 0.00402, 0.0045075, 0.003965, 0.0044625, 0.0043375, 0.0037225, 0.0043175, 0.0043125, 0.0036525, 0.0033075, 0.003515, 0.0045, 0.0044975, 0.0041675, 0.0032025, 0.0035575, 0.0053525, 0.0054475, 0.00527, 0.0052025, 0.00423, 0.0038275, 0.0048725, 0.0053825, 0.0043325, 0.003225, 0.0039625, 0.0049375, 0.00458, 0.0042475, 0.00486, 0.0045375, 0.0038575, 0.003835, 0.004165, 0.004305, 0.003575, 0.0033825, 0.003655, 0.004195, 0.0043825, 0.0039375, 0.0045925, 0.004275, 0.004065, 0.003825, 0.0036475, 0.0046325, 0.0042775, 0.0028875, 0.0029475, 0.00346, 0.00309, 0.003025, 0.003605, 0.00408, 0.003575, 0.0038275, 0.003145, 0.0029725, 0.004065, 0.004755, 0.0040175, 0.0029125, 0.0025925, 0.002705, 0.0039925, 0.00572, 0.0066875, 0.00718, 0.006405, 0.0050175, 0.0042975, 0.0033525, 0.00334, 0.00328, 0.00277, 0.003155, 0.00356, 0.0045025, 0.00519, 0.004615, 0.004855, 0.00397, 0.002805, 0.0036025, 0.004365, 0.0040575, 0.003915, 0.0037, 0.0046275, 0.0066575, 0.0073925, 0.0063825, 0.0043725, 0.003145, 0.00296, 0.00451, 0.0067075, 0.007465, 0.0070775, 0.0064375, 0.005795, 0.0057925, 0.00441, 0.003795, 0.00406, 0.0047025, 0.00553, 0.00687, 0.008115, 0.0060375, 0.004735, 0.0051025, 0.0053675, 0.00698, 0.00833, 0.006175, 0.0039725, 0.003745, 0.0049875, 0.0050975, 0.00459, 0.0057675, 0.0065275, 0.0063775, 0.0051175, 0.003335, 0.00344, 0.0043675, 0.0037675, 0.0029775, 0.00312, 0.0040525, 0.00362, 0.00233325, 0.0017275, 0.001953, 0.00127225, 0.000859, 0.0012115, 0.00196425, 0.00228875, 0.00139575, 0.000633, 0.0005215, 0.00069025, 0.000913, 0.00085075, 0.00097925, 0.000717, 0.00042375, 0.00077425, 0.00098975, 0.00060475, 0.0004565, 0.00028825, 0.0003135, 0.00044875, 0.0003755, 0.00034925, 0.00019895, 7.5275e-05, 0.000146425, 0.0005055, 0.00076025, 0.00040925, 0.000222325, 0.000175975, 6.305e-05, 1.63e-05, 1.8215e-05, 5.37e-05, 7.555e-05, 9.5775e-05, 0.0002342, 0.0002555, 0.00010075, 5.305e-05, 4.9375e-05, 1.9285e-05, 4.1975e-06, 7.8125e-07, 9.91e-08, 5.68e-07, 3.165e-06, 1.5245e-05, 4.1725e-05, 3.72e-05, 1.2155e-05, 5.155e-06, 9.5725e-06, 1.05025e-05, 3.9475e-06, 8.305e-07, 1.4945e-07, 6.985e-12, 1.2745e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.9321930625, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.175e-08, 5.7375e-07, 3.375e-06, 1.91425e-05, 9.9625e-05, 0.0003915, 0.0009255, 0.00134575, 0.00185425, 0.0021975, 0.002026, 0.0026325, 0.0030025, 0.0028375, 0.003155, 0.0029475, 0.00306, 0.004025, 0.003995, 0.00394, 0.00326, 0.00303, 0.0044125, 0.0049375, 0.00452, 0.004655, 0.0034875, 0.0038625, 0.0049575, 0.0048075, 0.0045575, 0.004395, 0.0049875, 0.00588, 0.0049275, 0.00487, 0.00426, 0.003415, 0.005055, 0.00606, 0.00597, 0.0062725, 0.0050475, 0.00455, 0.00459, 0.0047575, 0.005485, 0.004855, 0.0050725, 0.0065175, 0.006015, 0.00584, 0.0045775, 0.0043075, 0.0060925, 0.0063675, 0.0056, 0.004605, 0.004005, 0.0053725, 0.00578, 0.005655, 0.0057225, 0.005335, 0.006945, 0.00683, 0.0044925, 0.0041125, 0.003635, 0.0041125, 0.0057475, 0.006335, 0.0063775, 0.0049325, 0.005215, 0.0056125, 0.0051875, 0.005285, 0.004445, 0.0038525, 0.0049775, 0.00525, 0.0053175, 0.0043525, 0.00402, 0.0045075, 0.003965, 0.0044625, 0.0043375, 0.0037225, 0.0043175, 0.0043125, 0.0036525, 0.0033075, 0.003515, 0.0045, 0.0044975, 0.0041675, 0.0032025, 0.0035575, 0.0053525, 0.0054475, 0.00527, 0.0052025, 0.00423, 0.0038275, 0.0048725, 0.0053825, 0.0043325, 0.003225, 0.0039625, 0.0049375, 0.00458, 0.0042475, 0.00486, 0.0045375, 0.0038575, 0.003835, 0.004165, 0.004305, 0.003575, 0.0033825, 0.003655, 0.004195, 0.0043825, 0.0039375, 0.0045925, 0.004275, 0.004065, 0.003825, 0.0036475, 0.0046325, 0.0042775, 0.0028875, 0.0029475, 0.00346, 0.00309, 0.003025, 0.003605, 0.00408, 0.003575, 0.0038275, 0.003145, 0.0029725, 0.004065, 0.004755, 0.0040175, 0.0029125, 0.0025925, 0.002705, 0.0039925, 0.00572, 0.0066875, 0.00718, 0.006405, 0.0050175, 0.0042975, 0.0033525, 0.00334, 0.00328, 0.00277, 0.003155, 0.00356, 0.0045025, 0.00519, 0.004615, 0.004855, 0.00397, 0.002805, 0.0036025, 0.004365, 0.0040575, 0.003915, 0.0037, 0.0046275, 0.0066575, 0.0073925, 0.0063825, 0.0043725, 0.003145, 0.00296, 0.00451, 0.0067075, 0.007465, 0.0070775, 0.0064375, 0.005795, 0.0057925, 0.00441, 0.003795, 0.00406, 0.0047025, 0.00553, 0.00687, 0.008115, 0.0060375, 0.004735, 0.0051025, 0.0053675, 0.00698, 0.00833, 0.006175, 0.0039725, 0.003745, 0.0049875, 0.0050975, 0.00459, 0.0057675, 0.0065275, 0.0063775, 0.0051175, 0.003335, 0.00344, 0.0043675, 0.0037675, 0.0029775, 0.00312, 0.0040525, 0.00362, 0.00233325, 0.0017275, 0.001953, 0.00127225, 0.000859, 0.0012115, 0.00196425, 0.00228875, 0.00139575, 0.000633, 0.0005215, 0.00069025, 0.000913, 0.00085075, 0.00097925, 0.000717, 0.00042375, 0.00077425, 0.00098975, 0.00060475, 0.0004565, 0.00028825, 0.0003135, 0.00044875, 0.0003755, 0.00034925, 0.00019895, 7.5275e-05, 0.000146425, 0.0005055, 0.00076025, 0.00040925, 0.000222325, 0.000175975, 6.305e-05, 1.63e-05, 1.8215e-05, 5.37e-05, 7.555e-05, 9.5775e-05, 0.0002342, 0.0002555, 0.00010075, 5.305e-05, 4.9375e-05, 1.9285e-05, 4.1975e-06, 7.8125e-07, 9.91e-08, 5.68e-07, 3.165e-06, 1.5245e-05, 4.1725e-05, 3.72e-05, 1.2155e-05, 5.155e-06, 9.5725e-06, 1.05025e-05, 3.9475e-06, 8.305e-07, 1.4945e-07, 6.985e-12, 1.2745e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.9321930625, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.175e-08, 5.7375e-07, 3.375e-06, 1.91425e-05, 9.9625e-05, 0.0003915, 0.0009255, 0.00134575, 0.00185425, 0.0021975, 0.002026, 0.0026325, 0.0030025, 0.0028375, 0.003155, 0.0029475, 0.00306, 0.004025, 0.003995, 0.00394, 0.00326, 0.00303, 0.0044125, 0.0049375, 0.00452, 0.004655, 0.0034875, 0.0038625, 0.0049575, 0.0048075, 0.0045575, 0.004395, 0.0049875, 0.00588, 0.0049275, 0.00487, 0.00426, 0.003415, 0.005055, 0.00606, 0.00597, 0.0062725, 0.0050475, 0.00455, 0.00459, 0.0047575, 0.005485, 0.004855, 0.0050725, 0.0065175, 0.006015, 0.00584, 0.0045775, 0.0043075, 0.0060925, 0.0063675, 0.0056, 0.004605, 0.004005, 0.0053725, 0.00578, 0.005655, 0.0057225, 0.005335, 0.006945, 0.00683, 0.0044925, 0.0041125, 0.003635, 0.0041125, 0.0057475, 0.006335, 0.0063775, 0.0049325, 0.005215, 0.0056125, 0.0051875, 0.005285, 0.004445, 0.0038525, 0.0049775, 0.00525, 0.0053175, 0.0043525, 0.00402, 0.0045075, 0.003965, 0.0044625, 0.0043375, 0.0037225, 0.0043175, 0.0043125, 0.0036525, 0.0033075, 0.003515, 0.0045, 0.0044975, 0.0041675, 0.0032025, 0.0035575, 0.0053525, 0.0054475, 0.00527, 0.0052025, 0.00423, 0.0038275, 0.0048725, 0.0053825, 0.0043325, 0.003225, 0.0039625, 0.0049375, 0.00458, 0.0042475, 0.00486, 0.0045375, 0.0038575, 0.003835, 0.004165, 0.004305, 0.003575, 0.0033825, 0.003655, 0.004195, 0.0043825, 0.0039375, 0.0045925, 0.004275, 0.004065, 0.003825, 0.0036475, 0.0046325, 0.0042775, 0.0028875, 0.0029475, 0.00346, 0.00309, 0.003025, 0.003605, 0.00408, 0.003575, 0.0038275, 0.003145, 0.0029725, 0.004065, 0.004755, 0.0040175, 0.0029125, 0.0025925, 0.002705, 0.0039925, 0.00572, 0.0066875, 0.00718, 0.006405, 0.0050175, 0.0042975, 0.0033525, 0.00334, 0.00328, 0.00277, 0.003155, 0.00356, 0.0045025, 0.00519, 0.004615, 0.004855, 0.00397, 0.002805, 0.0036025, 0.004365, 0.0040575, 0.003915, 0.0037, 0.0046275, 0.0066575, 0.0073925, 0.0063825, 0.0043725, 0.003145, 0.00296, 0.00451, 0.0067075, 0.007465, 0.0070775, 0.0064375, 0.005795, 0.0057925, 0.00441, 0.003795, 0.00406, 0.0047025, 0.00553, 0.00687, 0.008115, 0.0060375, 0.004735, 0.0051025, 0.0053675, 0.00698, 0.00833, 0.006175, 0.0039725, 0.003745, 0.0049875, 0.0050975, 0.00459, 0.0057675, 0.0065275, 0.0063775, 0.0051175, 0.003335, 0.00344, 0.0043675, 0.0037675, 0.0029775, 0.00312, 0.0040525, 0.00362, 0.00233325, 0.0017275, 0.001953, 0.00127225, 0.000859, 0.0012115, 0.00196425, 0.00228875, 0.00139575, 0.000633, 0.0005215, 0.00069025, 0.000913, 0.00085075, 0.00097925, 0.000717, 0.00042375, 0.00077425, 0.00098975, 0.00060475, 0.0004565, 0.00028825, 0.0003135, 0.00044875, 0.0003755, 0.00034925, 0.00019895, 7.5275e-05, 0.000146425, 0.0005055, 0.00076025, 0.00040925, 0.000222325, 0.000175975, 6.305e-05, 1.63e-05, 1.8215e-05, 5.37e-05, 7.555e-05, 9.5775e-05, 0.0002342, 0.0002555, 0.00010075, 5.305e-05, 4.9375e-05, 1.9285e-05, 4.1975e-06, 7.8125e-07, 9.91e-08, 5.68e-07, 3.165e-06, 1.5245e-05, 4.1725e-05, 3.72e-05, 1.2155e-05, 5.155e-06, 9.5725e-06, 1.05025e-05, 3.9475e-06, 8.305e-07, 1.4945e-07, 6.985e-12, 1.2745e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.9321930625, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.175e-08, 5.7375e-07, 3.375e-06, 1.91425e-05, 9.9625e-05, 0.0003915, 0.0009255, 0.00134575, 0.00185425, 0.0021975, 0.002026, 0.0026325, 0.0030025, 0.0028375, 0.003155, 0.0029475, 0.00306, 0.004025, 0.003995, 0.00394, 0.00326, 0.00303, 0.0044125, 0.0049375, 0.00452, 0.004655, 0.0034875, 0.0038625, 0.0049575, 0.0048075, 0.0045575, 0.004395, 0.0049875, 0.00588, 0.0049275, 0.00487, 0.00426, 0.003415, 0.005055, 0.00606, 0.00597, 0.0062725, 0.0050475, 0.00455, 0.00459, 0.0047575, 0.005485, 0.004855, 0.0050725, 0.0065175, 0.006015, 0.00584, 0.0045775, 0.0043075, 0.0060925, 0.0063675, 0.0056, 0.004605, 0.004005, 0.0053725, 0.00578, 0.005655, 0.0057225, 0.005335, 0.006945, 0.00683, 0.0044925, 0.0041125, 0.003635, 0.0041125, 0.0057475, 0.006335, 0.0063775, 0.0049325, 0.005215, 0.0056125, 0.0051875, 0.005285, 0.004445, 0.0038525, 0.0049775, 0.00525, 0.0053175, 0.0043525, 0.00402, 0.0045075, 0.003965, 0.0044625, 0.0043375, 0.0037225, 0.0043175, 0.0043125, 0.0036525, 0.0033075, 0.003515, 0.0045, 0.0044975, 0.0041675, 0.0032025, 0.0035575, 0.0053525, 0.0054475, 0.00527, 0.0052025, 0.00423, 0.0038275, 0.0048725, 0.0053825, 0.0043325, 0.003225, 0.0039625, 0.0049375, 0.00458, 0.0042475, 0.00486, 0.0045375, 0.0038575, 0.003835, 0.004165, 0.004305, 0.003575, 0.0033825, 0.003655, 0.004195, 0.0043825, 0.0039375, 0.0045925, 0.004275, 0.004065, 0.003825, 0.0036475, 0.0046325, 0.0042775, 0.0028875, 0.0029475, 0.00346, 0.00309, 0.003025, 0.003605, 0.00408, 0.003575, 0.0038275, 0.003145, 0.0029725, 0.004065, 0.004755, 0.0040175, 0.0029125, 0.0025925, 0.002705, 0.0039925, 0.00572, 0.0066875, 0.00718, 0.006405, 0.0050175, 0.0042975, 0.0033525, 0.00334, 0.00328, 0.00277, 0.003155, 0.00356, 0.0045025, 0.00519, 0.004615, 0.004855, 0.00397, 0.002805, 0.0036025, 0.004365, 0.0040575, 0.003915, 0.0037, 0.0046275, 0.0066575, 0.0073925, 0.0063825, 0.0043725, 0.003145, 0.00296, 0.00451, 0.0067075, 0.007465, 0.0070775, 0.0064375, 0.005795, 0.0057925, 0.00441, 0.003795, 0.00406, 0.0047025, 0.00553, 0.00687, 0.008115, 0.0060375, 0.004735, 0.0051025, 0.0053675, 0.00698, 0.00833, 0.006175, 0.0039725, 0.003745, 0.0049875, 0.0050975, 0.00459, 0.0057675, 0.0065275, 0.0063775, 0.0051175, 0.003335, 0.00344, 0.0043675, 0.0037675, 0.0029775, 0.00312, 0.0040525, 0.00362, 0.00233325, 0.0017275, 0.001953, 0.00127225, 0.000859, 0.0012115, 0.00196425, 0.00228875, 0.00139575, 0.000633, 0.0005215, 0.00069025, 0.000913, 0.00085075, 0.00097925, 0.000717, 0.00042375, 0.00077425, 0.00098975, 0.00060475, 0.0004565, 0.00028825, 0.0003135, 0.00044875, 0.0003755, 0.00034925, 0.00019895, 7.5275e-05, 0.000146425, 0.0005055, 0.00076025, 0.00040925, 0.000222325, 0.000175975, 6.305e-05, 1.63e-05, 1.8215e-05, 5.37e-05, 7.555e-05, 9.5775e-05, 0.0002342, 0.0002555, 0.00010075, 5.305e-05, 4.9375e-05, 1.9285e-05, 4.1975e-06, 7.8125e-07, 9.91e-08, 5.68e-07, 3.165e-06, 1.5245e-05, 4.1725e-05, 3.72e-05, 1.2155e-05, 5.155e-06, 9.5725e-06, 1.05025e-05, 3.9475e-06, 8.305e-07, 1.4945e-07, 6.985e-12, 1.2745e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.1725e-08, 1.229e-06, 8.98e-06, 5.1225e-05, 0.00028125, 0.001417, 0.0054225, 0.0126825, 0.0185925, 0.02575, 0.0305, 0.0287, 0.037325, 0.042625, 0.040825, 0.04555, 0.0428, 0.0455, 0.0593, 0.059375, 0.0587, 0.0489, 0.046925, 0.0681, 0.07565, 0.070525, 0.072125, 0.05505, 0.062475, 0.079475, 0.077325, 0.074275, 0.072225, 0.083775, 0.0972, 0.082525, 0.082525, 0.071575, 0.060175, 0.089575, 0.10595, 0.1061, 0.110875, 0.08995, 0.082725, 0.084275, 0.088625, 0.102275, 0.090625, 0.098825, 0.124675, 0.116325, 0.1132, 0.08915, 0.08805, 0.12395, 0.1281, 0.11425, 0.0942, 0.08585, 0.115175, 0.12375, 0.122825, 0.124925, 0.1198, 0.1575, 0.1516, 0.102025, 0.09555, 0.0857, 0.1011, 0.14045, 0.156075, 0.157025, 0.124175, 0.134725, 0.14535, 0.13745, 0.1433, 0.12215, 0.1096, 0.142675, 0.15375, 0.156075, 0.13115, 0.1324, 0.15645, 0.14715, 0.16095, 0.15295, 0.141675, 0.163125, 0.166225, 0.1471, 0.13075, 0.133425, 0.16095, 0.15945, 0.13415, 0.100425, 0.136425, 0.1912, 0.2006, 0.1901, 0.1857, 0.1724, 0.152375, 0.15455, 0.1626, 0.1591, 0.159925, 0.177775, 0.19545, 0.173575, 0.178525, 0.203125, 0.1911, 0.158425, 0.141075, 0.153475, 0.155025, 0.14705, 0.152925, 0.159975, 0.188275, 0.19235, 0.17035, 0.179325, 0.16505, 0.1653, 0.160975, 0.177425, 0.21695, 0.197425, 0.142525, 0.155425, 0.19125, 0.1606, 0.159425, 0.2034, 0.2139, 0.1935, 0.2047, 0.170625, 0.1656, 0.1899, 0.178825, 0.150075, 0.132375, 0.14675, 0.15685, 0.17465, 0.22435, 0.258, 0.25675, 0.225375, 0.19035, 0.206825, 0.204775, 0.19605, 0.171975, 0.141225, 0.1603, 0.1922, 0.2156, 0.2115, 0.22125, 0.23215, 0.193825, 0.144225, 0.17155, 0.2073, 0.1878, 0.1667, 0.19115, 0.22635, 0.262, 0.26275, 0.193625, 0.18035, 0.1984, 0.1954, 0.22875, 0.24295, 0.21855, 0.1932, 0.184525, 0.211, 0.22665, 0.2243, 0.18945, 0.1666, 0.207825, 0.252, 0.28925, 0.227275, 0.1766, 0.191025, 0.2238, 0.28375, 0.3095, 0.27525, 0.2238, 0.1842, 0.20815, 0.21625, 0.1709, 0.18145, 0.220375, 0.25325, 0.239075, 0.206675, 0.24535, 0.26525, 0.212175, 0.141625, 0.129675, 0.1758, 0.21515, 0.197375, 0.12, 0.08085, 0.055075, 0.04725, 0.0816, 0.1214, 0.148925, 0.11375, 0.0573, 0.051775, 0.050025, 0.06105, 0.052725, 0.05715, 0.076525, 0.057275, 0.048225, 0.071275, 0.069625, 0.052025, 0.0247975, 0.0169, 0.034375, 0.03855, 0.03395, 0.045425, 0.027925, 0.01279, 0.0246725, 0.04635, 0.0463, 0.042225, 0.044325, 0.031975, 0.010185, 0.0026975, 0.0037325, 0.0109725, 0.01587, 0.020745, 0.030625, 0.0187875, 0.0096925, 0.0186225, 0.02525, 0.0113425, 0.002615, 0.000514, 0.00012375, 0.0006735, 0.0032875, 0.0103, 0.0117325, 0.0045375, 0.0014195, 0.00249875, 0.008475, 0.013375, 0.0090475, 0.0056975, 0.00225075, 0.0004815, 8.6675e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.959568795, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.0025e-09, 9e-08, 6.565e-07, 3.7425e-06, 2.054e-05, 0.000103425, 0.00039525, 0.00092225, 0.0013455, 0.00185125, 0.00218275, 0.00203925, 0.0026325, 0.0029875, 0.0028425, 0.0031475, 0.0029425, 0.0030975, 0.0040125, 0.0039925, 0.0039225, 0.0032475, 0.0030825, 0.00444, 0.0049075, 0.00454, 0.0046125, 0.003495, 0.003925, 0.0049625, 0.0047975, 0.00457, 0.00441, 0.005065, 0.005845, 0.0049275, 0.0048825, 0.00421, 0.0034975, 0.005155, 0.0060625, 0.0060225, 0.0062475, 0.00503, 0.00458, 0.004625, 0.0048175, 0.005515, 0.00485, 0.00522, 0.00654, 0.00605, 0.0058375, 0.00456, 0.0044425, 0.0061975, 0.00636, 0.0056175, 0.00459, 0.0041225, 0.00547, 0.0058275, 0.005725, 0.0057625, 0.005455, 0.00709, 0.006785, 0.004515, 0.004165, 0.0036825, 0.004265, 0.0058725, 0.006455, 0.006425, 0.0050125, 0.0053425, 0.0056925, 0.005285, 0.00538, 0.0045225, 0.0039875, 0.005095, 0.0054075, 0.005455, 0.004435, 0.0041275, 0.004645, 0.00418, 0.0046725, 0.0044625, 0.0038925, 0.004485, 0.00446, 0.003875, 0.0036025, 0.0039025, 0.004745, 0.0047625, 0.0042675, 0.0030325, 0.0038525, 0.005485, 0.005605, 0.005455, 0.0051075, 0.0043475, 0.00427, 0.005105, 0.0051725, 0.0039525, 0.0034375, 0.004225, 0.0050675, 0.0045375, 0.0043075, 0.0049875, 0.00449, 0.0039125, 0.0038475, 0.00425, 0.00422, 0.0034325, 0.00345, 0.00374, 0.0042625, 0.00438, 0.004075, 0.00471, 0.0043075, 0.004155, 0.0038075, 0.003755, 0.004755, 0.004265, 0.0029775, 0.0030175, 0.0035875, 0.003235, 0.0031425, 0.0037725, 0.004155, 0.003685, 0.0041025, 0.00376, 0.0038925, 0.0046075, 0.0045325, 0.0036975, 0.0026975, 0.0027675, 0.0035075, 0.0047575, 0.00599, 0.006945, 0.0070325, 0.0060575, 0.004725, 0.00424, 0.0034325, 0.0036575, 0.0034775, 0.00286, 0.0032775, 0.0038325, 0.0050125, 0.0051025, 0.00498, 0.0054125, 0.004375, 0.0029825, 0.00367, 0.0050775, 0.004375, 0.003645, 0.0049675, 0.0066425, 0.007725, 0.0061825, 0.00372, 0.0032475, 0.0036975, 0.0050625, 0.00711, 0.0077475, 0.007015, 0.0062375, 0.005745, 0.005655, 0.0042175, 0.00399, 0.004115, 0.004275, 0.0054875, 0.0072625, 0.0088975, 0.006465, 0.0047225, 0.004335, 0.0046575, 0.0067025, 0.00814, 0.00661, 0.004575, 0.004095, 0.0050275, 0.0052575, 0.00436, 0.0052225, 0.00634, 0.0064775, 0.00546, 0.0035475, 0.0035175, 0.004525, 0.00409, 0.00286, 0.0028275, 0.00357, 0.0036925, 0.0031625, 0.002143, 0.00197525, 0.00131975, 0.00069475, 0.00097975, 0.001936, 0.00261, 0.00177375, 0.00068975, 0.00048825, 0.00058325, 0.0009295, 0.0008465, 0.00076025, 0.00091025, 0.00068775, 0.000731, 0.0009735, 0.00074025, 0.0005745, 0.00032575, 0.00020245, 0.00038175, 0.00041875, 0.00029975, 0.00033975, 0.00021115, 0.00014935, 0.00040825, 0.00073225, 0.00048375, 0.0002276, 0.000188475, 0.000144625, 4.8925e-05, 1.389e-05, 2.1295e-05, 6.4975e-05, 0.00010745, 0.00018815, 0.00028775, 0.0001566, 4.8925e-05, 4.5675e-05, 5.5675e-05, 2.45825e-05, 5.67e-06, 1.1235e-06, 3.2175e-07, 1.75175e-06, 8.5525e-06, 2.6775e-05, 3.05e-05, 1.168e-05, 3.025e-06, 3.1e-06, 9.5225e-06, 1.4275e-05, 6.9525e-06, 1.662e-06, 3.16e-07, 2.3525e-08, 2.4625e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.959568795, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.0025e-09, 9e-08, 6.565e-07, 3.7425e-06, 2.054e-05, 0.000103425, 0.00039525, 0.00092225, 0.0013455, 0.00185125, 0.00218275, 0.00203925, 0.0026325, 0.0029875, 0.0028425, 0.0031475, 0.0029425, 0.0030975, 0.0040125, 0.0039925, 0.0039225, 0.0032475, 0.0030825, 0.00444, 0.0049075, 0.00454, 0.0046125, 0.003495, 0.003925, 0.0049625, 0.0047975, 0.00457, 0.00441, 0.005065, 0.005845, 0.0049275, 0.0048825, 0.00421, 0.0034975, 0.005155, 0.0060625, 0.0060225, 0.0062475, 0.00503, 0.00458, 0.004625, 0.0048175, 0.005515, 0.00485, 0.00522, 0.00654, 0.00605, 0.0058375, 0.00456, 0.0044425, 0.0061975, 0.00636, 0.0056175, 0.00459, 0.0041225, 0.00547, 0.0058275, 0.005725, 0.0057625, 0.005455, 0.00709, 0.006785, 0.004515, 0.004165, 0.0036825, 0.004265, 0.0058725, 0.006455, 0.006425, 0.0050125, 0.0053425, 0.0056925, 0.005285, 0.00538, 0.0045225, 0.0039875, 0.005095, 0.0054075, 0.005455, 0.004435, 0.0041275, 0.004645, 0.00418, 0.0046725, 0.0044625, 0.0038925, 0.004485, 0.00446, 0.003875, 0.0036025, 0.0039025, 0.004745, 0.0047625, 0.0042675, 0.0030325, 0.0038525, 0.005485, 0.005605, 0.005455, 0.0051075, 0.0043475, 0.00427, 0.005105, 0.0051725, 0.0039525, 0.0034375, 0.004225, 0.0050675, 0.0045375, 0.0043075, 0.0049875, 0.00449, 0.0039125, 0.0038475, 0.00425, 0.00422, 0.0034325, 0.00345, 0.00374, 0.0042625, 0.00438, 0.004075, 0.00471, 0.0043075, 0.004155, 0.0038075, 0.003755, 0.004755, 0.004265, 0.0029775, 0.0030175, 0.0035875, 0.003235, 0.0031425, 0.0037725, 0.004155, 0.003685, 0.0041025, 0.00376, 0.0038925, 0.0046075, 0.0045325, 0.0036975, 0.0026975, 0.0027675, 0.0035075, 0.0047575, 0.00599, 0.006945, 0.0070325, 0.0060575, 0.004725, 0.00424, 0.0034325, 0.0036575, 0.0034775, 0.00286, 0.0032775, 0.0038325, 0.0050125, 0.0051025, 0.00498, 0.0054125, 0.004375, 0.0029825, 0.00367, 0.0050775, 0.004375, 0.003645, 0.0049675, 0.0066425, 0.007725, 0.0061825, 0.00372, 0.0032475, 0.0036975, 0.0050625, 0.00711, 0.0077475, 0.007015, 0.0062375, 0.005745, 0.005655, 0.0042175, 0.00399, 0.004115, 0.004275, 0.0054875, 0.0072625, 0.0088975, 0.006465, 0.0047225, 0.004335, 0.0046575, 0.0067025, 0.00814, 0.00661, 0.004575, 0.004095, 0.0050275, 0.0052575, 0.00436, 0.0052225, 0.00634, 0.0064775, 0.00546, 0.0035475, 0.0035175, 0.004525, 0.00409, 0.00286, 0.0028275, 0.00357, 0.0036925, 0.0031625, 0.002143, 0.00197525, 0.00131975, 0.00069475, 0.00097975, 0.001936, 0.00261, 0.00177375, 0.00068975, 0.00048825, 0.00058325, 0.0009295, 0.0008465, 0.00076025, 0.00091025, 0.00068775, 0.000731, 0.0009735, 0.00074025, 0.0005745, 0.00032575, 0.00020245, 0.00038175, 0.00041875, 0.00029975, 0.00033975, 0.00021115, 0.00014935, 0.00040825, 0.00073225, 0.00048375, 0.0002276, 0.000188475, 0.000144625, 4.8925e-05, 1.389e-05, 2.1295e-05, 6.4975e-05, 0.00010745, 0.00018815, 0.00028775, 0.0001566, 4.8925e-05, 4.5675e-05, 5.5675e-05, 2.45825e-05, 5.67e-06, 1.1235e-06, 3.2175e-07, 1.75175e-06, 8.5525e-06, 2.6775e-05, 3.05e-05, 1.168e-05, 3.025e-06, 3.1e-06, 9.5225e-06, 1.4275e-05, 6.9525e-06, 1.662e-06, 3.16e-07, 2.3525e-08, 2.4625e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.959568795, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.0025e-09, 9e-08, 6.565e-07, 3.7425e-06, 2.054e-05, 0.000103425, 0.00039525, 0.00092225, 0.0013455, 0.00185125, 0.00218275, 0.00203925, 0.0026325, 0.0029875, 0.0028425, 0.0031475, 0.0029425, 0.0030975, 0.0040125, 0.0039925, 0.0039225, 0.0032475, 0.0030825, 0.00444, 0.0049075, 0.00454, 0.0046125, 0.003495, 0.003925, 0.0049625, 0.0047975, 0.00457, 0.00441, 0.005065, 0.005845, 0.0049275, 0.0048825, 0.00421, 0.0034975, 0.005155, 0.0060625, 0.0060225, 0.0062475, 0.00503, 0.00458, 0.004625, 0.0048175, 0.005515, 0.00485, 0.00522, 0.00654, 0.00605, 0.0058375, 0.00456, 0.0044425, 0.0061975, 0.00636, 0.0056175, 0.00459, 0.0041225, 0.00547, 0.0058275, 0.005725, 0.0057625, 0.005455, 0.00709, 0.006785, 0.004515, 0.004165, 0.0036825, 0.004265, 0.0058725, 0.006455, 0.006425, 0.0050125, 0.0053425, 0.0056925, 0.005285, 0.00538, 0.0045225, 0.0039875, 0.005095, 0.0054075, 0.005455, 0.004435, 0.0041275, 0.004645, 0.00418, 0.0046725, 0.0044625, 0.0038925, 0.004485, 0.00446, 0.003875, 0.0036025, 0.0039025, 0.004745, 0.0047625, 0.0042675, 0.0030325, 0.0038525, 0.005485, 0.005605, 0.005455, 0.0051075, 0.0043475, 0.00427, 0.005105, 0.0051725, 0.0039525, 0.0034375, 0.004225, 0.0050675, 0.0045375, 0.0043075, 0.0049875, 0.00449, 0.0039125, 0.0038475, 0.00425, 0.00422, 0.0034325, 0.00345, 0.00374, 0.0042625, 0.00438, 0.004075, 0.00471, 0.0043075, 0.004155, 0.0038075, 0.003755, 0.004755, 0.004265, 0.0029775, 0.0030175, 0.0035875, 0.003235, 0.0031425, 0.0037725, 0.004155, 0.003685, 0.0041025, 0.00376, 0.0038925, 0.0046075, 0.0045325, 0.0036975, 0.0026975, 0.0027675, 0.0035075, 0.0047575, 0.00599, 0.006945, 0.0070325, 0.0060575, 0.004725, 0.00424, 0.0034325, 0.0036575, 0.0034775, 0.00286, 0.0032775, 0.0038325, 0.0050125, 0.0051025, 0.00498, 0.0054125, 0.004375, 0.0029825, 0.00367, 0.0050775, 0.004375, 0.003645, 0.0049675, 0.0066425, 0.007725, 0.0061825, 0.00372, 0.0032475, 0.0036975, 0.0050625, 0.00711, 0.0077475, 0.007015, 0.0062375, 0.005745, 0.005655, 0.0042175, 0.00399, 0.004115, 0.004275, 0.0054875, 0.0072625, 0.0088975, 0.006465, 0.0047225, 0.004335, 0.0046575, 0.0067025, 0.00814, 0.00661, 0.004575, 0.004095, 0.0050275, 0.0052575, 0.00436, 0.0052225, 0.00634, 0.0064775, 0.00546, 0.0035475, 0.0035175, 0.004525, 0.00409, 0.00286, 0.0028275, 0.00357, 0.0036925, 0.0031625, 0.002143, 0.00197525, 0.00131975, 0.00069475, 0.00097975, 0.001936, 0.00261, 0.00177375, 0.00068975, 0.00048825, 0.00058325, 0.0009295, 0.0008465, 0.00076025, 0.00091025, 0.00068775, 0.000731, 0.0009735, 0.00074025, 0.0005745, 0.00032575, 0.00020245, 0.00038175, 0.00041875, 0.00029975, 0.00033975, 0.00021115, 0.00014935, 0.00040825, 0.00073225, 0.00048375, 0.0002276, 0.000188475, 0.000144625, 4.8925e-05, 1.389e-05, 2.1295e-05, 6.4975e-05, 0.00010745, 0.00018815, 0.00028775, 0.0001566, 4.8925e-05, 4.5675e-05, 5.5675e-05, 2.45825e-05, 5.67e-06, 1.1235e-06, 3.2175e-07, 1.75175e-06, 8.5525e-06, 2.6775e-05, 3.05e-05, 1.168e-05, 3.025e-06, 3.1e-06, 9.5225e-06, 1.4275e-05, 6.9525e-06, 1.662e-06, 3.16e-07, 2.3525e-08, 2.4625e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.959568795, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.0025e-09, 9e-08, 6.565e-07, 3.7425e-06, 2.054e-05, 0.000103425, 0.00039525, 0.00092225, 0.0013455, 0.00185125, 0.00218275, 0.00203925, 0.0026325, 0.0029875, 0.0028425, 0.0031475, 0.0029425, 0.0030975, 0.0040125, 0.0039925, 0.0039225, 0.0032475, 0.0030825, 0.00444, 0.0049075, 0.00454, 0.0046125, 0.003495, 0.003925, 0.0049625, 0.0047975, 0.00457, 0.00441, 0.005065, 0.005845, 0.0049275, 0.0048825, 0.00421, 0.0034975, 0.005155, 0.0060625, 0.0060225, 0.0062475, 0.00503, 0.00458, 0.004625, 0.0048175, 0.005515, 0.00485, 0.00522, 0.00654, 0.00605, 0.0058375, 0.00456, 0.0044425, 0.0061975, 0.00636, 0.0056175, 0.00459, 0.0041225, 0.00547, 0.0058275, 0.005725, 0.0057625, 0.005455, 0.00709, 0.006785, 0.004515, 0.004165, 0.0036825, 0.004265, 0.0058725, 0.006455, 0.006425, 0.0050125, 0.0053425, 0.0056925, 0.005285, 0.00538, 0.0045225, 0.0039875, 0.005095, 0.0054075, 0.005455, 0.004435, 0.0041275, 0.004645, 0.00418, 0.0046725, 0.0044625, 0.0038925, 0.004485, 0.00446, 0.003875, 0.0036025, 0.0039025, 0.004745, 0.0047625, 0.0042675, 0.0030325, 0.0038525, 0.005485, 0.005605, 0.005455, 0.0051075, 0.0043475, 0.00427, 0.005105, 0.0051725, 0.0039525, 0.0034375, 0.004225, 0.0050675, 0.0045375, 0.0043075, 0.0049875, 0.00449, 0.0039125, 0.0038475, 0.00425, 0.00422, 0.0034325, 0.00345, 0.00374, 0.0042625, 0.00438, 0.004075, 0.00471, 0.0043075, 0.004155, 0.0038075, 0.003755, 0.004755, 0.004265, 0.0029775, 0.0030175, 0.0035875, 0.003235, 0.0031425, 0.0037725, 0.004155, 0.003685, 0.0041025, 0.00376, 0.0038925, 0.0046075, 0.0045325, 0.0036975, 0.0026975, 0.0027675, 0.0035075, 0.0047575, 0.00599, 0.006945, 0.0070325, 0.0060575, 0.004725, 0.00424, 0.0034325, 0.0036575, 0.0034775, 0.00286, 0.0032775, 0.0038325, 0.0050125, 0.0051025, 0.00498, 0.0054125, 0.004375, 0.0029825, 0.00367, 0.0050775, 0.004375, 0.003645, 0.0049675, 0.0066425, 0.007725, 0.0061825, 0.00372, 0.0032475, 0.0036975, 0.0050625, 0.00711, 0.0077475, 0.007015, 0.0062375, 0.005745, 0.005655, 0.0042175, 0.00399, 0.004115, 0.004275, 0.0054875, 0.0072625, 0.0088975, 0.006465, 0.0047225, 0.004335, 0.0046575, 0.0067025, 0.00814, 0.00661, 0.004575, 0.004095, 0.0050275, 0.0052575, 0.00436, 0.0052225, 0.00634, 0.0064775, 0.00546, 0.0035475, 0.0035175, 0.004525, 0.00409, 0.00286, 0.0028275, 0.00357, 0.0036925, 0.0031625, 0.002143, 0.00197525, 0.00131975, 0.00069475, 0.00097975, 0.001936, 0.00261, 0.00177375, 0.00068975, 0.00048825, 0.00058325, 0.0009295, 0.0008465, 0.00076025, 0.00091025, 0.00068775, 0.000731, 0.0009735, 0.00074025, 0.0005745, 0.00032575, 0.00020245, 0.00038175, 0.00041875, 0.00029975, 0.00033975, 0.00021115, 0.00014935, 0.00040825, 0.00073225, 0.00048375, 0.0002276, 0.000188475, 0.000144625, 4.8925e-05, 1.389e-05, 2.1295e-05, 6.4975e-05, 0.00010745, 0.00018815, 0.00028775, 0.0001566, 4.8925e-05, 4.5675e-05, 5.5675e-05, 2.45825e-05, 5.67e-06, 1.1235e-06, 3.2175e-07, 1.75175e-06, 8.5525e-06, 2.6775e-05, 3.05e-05, 1.168e-05, 3.025e-06, 3.1e-06, 9.5225e-06, 1.4275e-05, 6.9525e-06, 1.662e-06, 3.16e-07, 2.3525e-08, 2.4625e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.975e-08, 1.47375e-06, 1.1265e-05, 5.73e-05, 0.00031075, 0.00150275, 0.005605, 0.0129275, 0.01901, 0.026275, 0.030975, 0.029525, 0.038125, 0.04335, 0.041775, 0.046375, 0.043675, 0.04685, 0.060325, 0.060525, 0.059625, 0.0498, 0.0486, 0.0697, 0.076725, 0.07215, 0.0729, 0.05635, 0.06445, 0.080875, 0.078625, 0.075775, 0.07385, 0.086225, 0.09835, 0.084075, 0.084, 0.072225, 0.062525, 0.092225, 0.10765, 0.108525, 0.1121, 0.091275, 0.084475, 0.086075, 0.09085, 0.103975, 0.092125, 0.10225, 0.1265, 0.118375, 0.1145, 0.090375, 0.09135, 0.1267, 0.12955, 0.115825, 0.095275, 0.0888, 0.117725, 0.1258, 0.125225, 0.126775, 0.1231, 0.160625, 0.152225, 0.10375, 0.0971, 0.087425, 0.104175, 0.143125, 0.1589, 0.15875, 0.126775, 0.137325, 0.147325, 0.139575, 0.14495, 0.124425, 0.112075, 0.144175, 0.156425, 0.158575, 0.132225, 0.13215, 0.15695, 0.15015, 0.16525, 0.1553, 0.14295, 0.165275, 0.167725, 0.152625, 0.137525, 0.137825, 0.16285, 0.1643, 0.138725, 0.101875, 0.1395, 0.192675, 0.204375, 0.1938, 0.18565, 0.17635, 0.16595, 0.162725, 0.158675, 0.1522, 0.16495, 0.183725, 0.20085, 0.1762, 0.182675, 0.205925, 0.19075, 0.1683, 0.1486, 0.159075, 0.15365, 0.1428, 0.15595, 0.164675, 0.1915, 0.196475, 0.176975, 0.182975, 0.165125, 0.166125, 0.1606, 0.177925, 0.2176, 0.2003, 0.14885, 0.15225, 0.191225, 0.171275, 0.16055, 0.204475, 0.218325, 0.1961, 0.2105, 0.18695, 0.170125, 0.191575, 0.186125, 0.15115, 0.128925, 0.1502, 0.172025, 0.187475, 0.230825, 0.26425, 0.2565, 0.218825, 0.184575, 0.192525, 0.20945, 0.21335, 0.17955, 0.146575, 0.162875, 0.201575, 0.22925, 0.2132, 0.23275, 0.226175, 0.184325, 0.16065, 0.18595, 0.203175, 0.188025, 0.187925, 0.2119, 0.23855, 0.237325, 0.236525, 0.2059, 0.19365, 0.2198, 0.23345, 0.248675, 0.2376, 0.21595, 0.192675, 0.177625, 0.1851, 0.219025, 0.23815, 0.212525, 0.199075, 0.233825, 0.27175, 0.264, 0.21145, 0.167475, 0.193025, 0.25, 0.316, 0.30125, 0.25425, 0.228575, 0.21215, 0.213025, 0.20805, 0.20335, 0.2098, 0.215325, 0.236175, 0.2016, 0.199975, 0.27625, 0.27975, 0.2032, 0.1425, 0.1436, 0.17805, 0.205625, 0.194125, 0.12815, 0.072525, 0.037725, 0.0423, 0.101375, 0.143875, 0.1345, 0.091225, 0.05445, 0.053275, 0.060375, 0.065175, 0.05235, 0.061525, 0.072575, 0.062025, 0.053, 0.059575, 0.06765, 0.0523, 0.0255, 0.021175, 0.038875, 0.035375, 0.03295, 0.045125, 0.029125, 0.0220925, 0.0386, 0.03585, 0.02975, 0.03435, 0.03635, 0.0394, 0.020205, 0.00583, 0.0047375, 0.01253, 0.0215275, 0.0303, 0.02635, 0.010945, 0.006965, 0.017205, 0.025575, 0.0127175, 0.003135, 0.00066525, 0.00039025, 0.00141175, 0.0058925, 0.01261, 0.0089, 0.0026275, 0.00080125, 0.001484, 0.00549, 0.011375, 0.012055, 0.0084975, 0.0031375, 0.00071175, 0.00012845, 1.7765e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.9854054975, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.1675e-09, 1.0555e-07, 8.05e-07, 4.095e-06, 2.22025e-05, 0.0001073, 0.00039975, 0.00091975, 0.00134625, 0.0018485, 0.0021705, 0.002054, 0.00263, 0.0029775, 0.00285, 0.0031425, 0.0029425, 0.0031275, 0.0040025, 0.00399, 0.0039075, 0.0032425, 0.0031325, 0.00446, 0.004885, 0.00456, 0.00458, 0.003515, 0.00398, 0.004965, 0.004795, 0.004585, 0.0044325, 0.00513, 0.00582, 0.00494, 0.004895, 0.0041825, 0.00358, 0.0052325, 0.0060725, 0.0060725, 0.00623, 0.005035, 0.004615, 0.0046625, 0.0048775, 0.00554, 0.00487, 0.00534, 0.0065625, 0.00609, 0.0058425, 0.004575, 0.0045625, 0.006275, 0.006375, 0.00565, 0.0046075, 0.0042325, 0.0055525, 0.0058825, 0.0057975, 0.005815, 0.0055775, 0.0072025, 0.006785, 0.004575, 0.00422, 0.00375, 0.0043925, 0.0059825, 0.0065725, 0.0065, 0.0051225, 0.005455, 0.005785, 0.00539, 0.00548, 0.0046425, 0.004115, 0.0052075, 0.0055725, 0.00561, 0.0045525, 0.004235, 0.0048, 0.00441, 0.0048925, 0.0046425, 0.004065, 0.004665, 0.0046475, 0.00415, 0.00396, 0.00423, 0.0049575, 0.0050075, 0.0042925, 0.0030525, 0.00409, 0.00554, 0.0058075, 0.005545, 0.005105, 0.004575, 0.00469, 0.0052225, 0.00492, 0.003745, 0.0036775, 0.0043975, 0.005175, 0.0045175, 0.0044375, 0.0050575, 0.004445, 0.0039775, 0.00391, 0.0043275, 0.00412, 0.0033225, 0.0035, 0.003825, 0.0043125, 0.00441, 0.0042425, 0.0048275, 0.0043725, 0.004245, 0.003805, 0.003855, 0.00486, 0.0042975, 0.0030825, 0.003085, 0.0037125, 0.0034325, 0.0032725, 0.00391, 0.00427, 0.0038675, 0.004605, 0.0047325, 0.004505, 0.0045425, 0.0043225, 0.003605, 0.0026475, 0.003185, 0.0043025, 0.005215, 0.00625, 0.00699, 0.0068625, 0.0056525, 0.0046625, 0.0041625, 0.00362, 0.0040175, 0.003685, 0.0029375, 0.0033375, 0.004275, 0.005415, 0.0053075, 0.00601, 0.0056625, 0.0038875, 0.0037175, 0.00458, 0.0044675, 0.004315, 0.0054075, 0.006635, 0.0069975, 0.0055825, 0.0042425, 0.0036175, 0.0042925, 0.0053475, 0.006825, 0.008165, 0.0074075, 0.0062225, 0.005855, 0.004885, 0.00405, 0.004155, 0.004355, 0.004415, 0.005635, 0.007345, 0.00822, 0.0071675, 0.00549, 0.003955, 0.0043075, 0.00579, 0.00752, 0.0068575, 0.0053475, 0.004875, 0.0050475, 0.0050925, 0.0044175, 0.0051475, 0.00617, 0.0061125, 0.0058275, 0.0039775, 0.00345, 0.00467, 0.0045675, 0.00318, 0.00266, 0.00307, 0.0034425, 0.003335, 0.002855, 0.002297, 0.00162075, 0.00077, 0.0006595, 0.001618, 0.00258, 0.0021715, 0.001046, 0.000486, 0.00050625, 0.000766, 0.0009895, 0.000709, 0.00075725, 0.0009025, 0.00091075, 0.00093225, 0.0007405, 0.000695, 0.0005095, 0.0002264, 0.000223575, 0.000438, 0.00037775, 0.000281, 0.0003585, 0.00026325, 0.000321, 0.0006605, 0.000565, 0.000255, 0.0001836, 0.00022515, 0.00026425, 0.000135725, 3.9175e-05, 3.115e-05, 8.515e-05, 0.000171075, 0.0002835, 0.000233175, 7.86e-05, 2.7975e-05, 4.6225e-05, 6.5825e-05, 3.2775e-05, 8.0875e-06, 1.7385e-06, 1.13425e-06, 4.295e-06, 1.7925e-05, 3.835e-05, 2.705e-05, 7.9075e-06, 1.98475e-06, 2.2195e-06, 7.4325e-06, 1.373e-05, 9.5125e-06, 3.4775e-06, 8.36e-07, 1.6465e-07, 1.75225e-08, 1.3655e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.9854054975, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.1675e-09, 1.0555e-07, 8.05e-07, 4.095e-06, 2.22025e-05, 0.0001073, 0.00039975, 0.00091975, 0.00134625, 0.0018485, 0.0021705, 0.002054, 0.00263, 0.0029775, 0.00285, 0.0031425, 0.0029425, 0.0031275, 0.0040025, 0.00399, 0.0039075, 0.0032425, 0.0031325, 0.00446, 0.004885, 0.00456, 0.00458, 0.003515, 0.00398, 0.004965, 0.004795, 0.004585, 0.0044325, 0.00513, 0.00582, 0.00494, 0.004895, 0.0041825, 0.00358, 0.0052325, 0.0060725, 0.0060725, 0.00623, 0.005035, 0.004615, 0.0046625, 0.0048775, 0.00554, 0.00487, 0.00534, 0.0065625, 0.00609, 0.0058425, 0.004575, 0.0045625, 0.006275, 0.006375, 0.00565, 0.0046075, 0.0042325, 0.0055525, 0.0058825, 0.0057975, 0.005815, 0.0055775, 0.0072025, 0.006785, 0.004575, 0.00422, 0.00375, 0.0043925, 0.0059825, 0.0065725, 0.0065, 0.0051225, 0.005455, 0.005785, 0.00539, 0.00548, 0.0046425, 0.004115, 0.0052075, 0.0055725, 0.00561, 0.0045525, 0.004235, 0.0048, 0.00441, 0.0048925, 0.0046425, 0.004065, 0.004665, 0.0046475, 0.00415, 0.00396, 0.00423, 0.0049575, 0.0050075, 0.0042925, 0.0030525, 0.00409, 0.00554, 0.0058075, 0.005545, 0.005105, 0.004575, 0.00469, 0.0052225, 0.00492, 0.003745, 0.0036775, 0.0043975, 0.005175, 0.0045175, 0.0044375, 0.0050575, 0.004445, 0.0039775, 0.00391, 0.0043275, 0.00412, 0.0033225, 0.0035, 0.003825, 0.0043125, 0.00441, 0.0042425, 0.0048275, 0.0043725, 0.004245, 0.003805, 0.003855, 0.00486, 0.0042975, 0.0030825, 0.003085, 0.0037125, 0.0034325, 0.0032725, 0.00391, 0.00427, 0.0038675, 0.004605, 0.0047325, 0.004505, 0.0045425, 0.0043225, 0.003605, 0.0026475, 0.003185, 0.0043025, 0.005215, 0.00625, 0.00699, 0.0068625, 0.0056525, 0.0046625, 0.0041625, 0.00362, 0.0040175, 0.003685, 0.0029375, 0.0033375, 0.004275, 0.005415, 0.0053075, 0.00601, 0.0056625, 0.0038875, 0.0037175, 0.00458, 0.0044675, 0.004315, 0.0054075, 0.006635, 0.0069975, 0.0055825, 0.0042425, 0.0036175, 0.0042925, 0.0053475, 0.006825, 0.008165, 0.0074075, 0.0062225, 0.005855, 0.004885, 0.00405, 0.004155, 0.004355, 0.004415, 0.005635, 0.007345, 0.00822, 0.0071675, 0.00549, 0.003955, 0.0043075, 0.00579, 0.00752, 0.0068575, 0.0053475, 0.004875, 0.0050475, 0.0050925, 0.0044175, 0.0051475, 0.00617, 0.0061125, 0.0058275, 0.0039775, 0.00345, 0.00467, 0.0045675, 0.00318, 0.00266, 0.00307, 0.0034425, 0.003335, 0.002855, 0.002297, 0.00162075, 0.00077, 0.0006595, 0.001618, 0.00258, 0.0021715, 0.001046, 0.000486, 0.00050625, 0.000766, 0.0009895, 0.000709, 0.00075725, 0.0009025, 0.00091075, 0.00093225, 0.0007405, 0.000695, 0.0005095, 0.0002264, 0.000223575, 0.000438, 0.00037775, 0.000281, 0.0003585, 0.00026325, 0.000321, 0.0006605, 0.000565, 0.000255, 0.0001836, 0.00022515, 0.00026425, 0.000135725, 3.9175e-05, 3.115e-05, 8.515e-05, 0.000171075, 0.0002835, 0.000233175, 7.86e-05, 2.7975e-05, 4.6225e-05, 6.5825e-05, 3.2775e-05, 8.0875e-06, 1.7385e-06, 1.13425e-06, 4.295e-06, 1.7925e-05, 3.835e-05, 2.705e-05, 7.9075e-06, 1.98475e-06, 2.2195e-06, 7.4325e-06, 1.373e-05, 9.5125e-06, 3.4775e-06, 8.36e-07, 1.6465e-07, 1.75225e-08, 1.3655e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.9854054975, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.1675e-09, 1.0555e-07, 8.05e-07, 4.095e-06, 2.22025e-05, 0.0001073, 0.00039975, 0.00091975, 0.00134625, 0.0018485, 0.0021705, 0.002054, 0.00263, 0.0029775, 0.00285, 0.0031425, 0.0029425, 0.0031275, 0.0040025, 0.00399, 0.0039075, 0.0032425, 0.0031325, 0.00446, 0.004885, 0.00456, 0.00458, 0.003515, 0.00398, 0.004965, 0.004795, 0.004585, 0.0044325, 0.00513, 0.00582, 0.00494, 0.004895, 0.0041825, 0.00358, 0.0052325, 0.0060725, 0.0060725, 0.00623, 0.005035, 0.004615, 0.0046625, 0.0048775, 0.00554, 0.00487, 0.00534, 0.0065625, 0.00609, 0.0058425, 0.004575, 0.0045625, 0.006275, 0.006375, 0.00565, 0.0046075, 0.0042325, 0.0055525, 0.0058825, 0.0057975, 0.005815, 0.0055775, 0.0072025, 0.006785, 0.004575, 0.00422, 0.00375, 0.0043925, 0.0059825, 0.0065725, 0.0065, 0.0051225, 0.005455, 0.005785, 0.00539, 0.00548, 0.0046425, 0.004115, 0.0052075, 0.0055725, 0.00561, 0.0045525, 0.004235, 0.0048, 0.00441, 0.0048925, 0.0046425, 0.004065, 0.004665, 0.0046475, 0.00415, 0.00396, 0.00423, 0.0049575, 0.0050075, 0.0042925, 0.0030525, 0.00409, 0.00554, 0.0058075, 0.005545, 0.005105, 0.004575, 0.00469, 0.0052225, 0.00492, 0.003745, 0.0036775, 0.0043975, 0.005175, 0.0045175, 0.0044375, 0.0050575, 0.004445, 0.0039775, 0.00391, 0.0043275, 0.00412, 0.0033225, 0.0035, 0.003825, 0.0043125, 0.00441, 0.0042425, 0.0048275, 0.0043725, 0.004245, 0.003805, 0.003855, 0.00486, 0.0042975, 0.0030825, 0.003085, 0.0037125, 0.0034325, 0.0032725, 0.00391, 0.00427, 0.0038675, 0.004605, 0.0047325, 0.004505, 0.0045425, 0.0043225, 0.003605, 0.0026475, 0.003185, 0.0043025, 0.005215, 0.00625, 0.00699, 0.0068625, 0.0056525, 0.0046625, 0.0041625, 0.00362, 0.0040175, 0.003685, 0.0029375, 0.0033375, 0.004275, 0.005415, 0.0053075, 0.00601, 0.0056625, 0.0038875, 0.0037175, 0.00458, 0.0044675, 0.004315, 0.0054075, 0.006635, 0.0069975, 0.0055825, 0.0042425, 0.0036175, 0.0042925, 0.0053475, 0.006825, 0.008165, 0.0074075, 0.0062225, 0.005855, 0.004885, 0.00405, 0.004155, 0.004355, 0.004415, 0.005635, 0.007345, 0.00822, 0.0071675, 0.00549, 0.003955, 0.0043075, 0.00579, 0.00752, 0.0068575, 0.0053475, 0.004875, 0.0050475, 0.0050925, 0.0044175, 0.0051475, 0.00617, 0.0061125, 0.0058275, 0.0039775, 0.00345, 0.00467, 0.0045675, 0.00318, 0.00266, 0.00307, 0.0034425, 0.003335, 0.002855, 0.002297, 0.00162075, 0.00077, 0.0006595, 0.001618, 0.00258, 0.0021715, 0.001046, 0.000486, 0.00050625, 0.000766, 0.0009895, 0.000709, 0.00075725, 0.0009025, 0.00091075, 0.00093225, 0.0007405, 0.000695, 0.0005095, 0.0002264, 0.000223575, 0.000438, 0.00037775, 0.000281, 0.0003585, 0.00026325, 0.000321, 0.0006605, 0.000565, 0.000255, 0.0001836, 0.00022515, 0.00026425, 0.000135725, 3.9175e-05, 3.115e-05, 8.515e-05, 0.000171075, 0.0002835, 0.000233175, 7.86e-05, 2.7975e-05, 4.6225e-05, 6.5825e-05, 3.2775e-05, 8.0875e-06, 1.7385e-06, 1.13425e-06, 4.295e-06, 1.7925e-05, 3.835e-05, 2.705e-05, 7.9075e-06, 1.98475e-06, 2.2195e-06, 7.4325e-06, 1.373e-05, 9.5125e-06, 3.4775e-06, 8.36e-07, 1.6465e-07, 1.75225e-08, 1.3655e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.9854054975, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.1675e-09, 1.0555e-07, 8.05e-07, 4.095e-06, 2.22025e-05, 0.0001073, 0.00039975, 0.00091975, 0.00134625, 0.0018485, 0.0021705, 0.002054, 0.00263, 0.0029775, 0.00285, 0.0031425, 0.0029425, 0.0031275, 0.0040025, 0.00399, 0.0039075, 0.0032425, 0.0031325, 0.00446, 0.004885, 0.00456, 0.00458, 0.003515, 0.00398, 0.004965, 0.004795, 0.004585, 0.0044325, 0.00513, 0.00582, 0.00494, 0.004895, 0.0041825, 0.00358, 0.0052325, 0.0060725, 0.0060725, 0.00623, 0.005035, 0.004615, 0.0046625, 0.0048775, 0.00554, 0.00487, 0.00534, 0.0065625, 0.00609, 0.0058425, 0.004575, 0.0045625, 0.006275, 0.006375, 0.00565, 0.0046075, 0.0042325, 0.0055525, 0.0058825, 0.0057975, 0.005815, 0.0055775, 0.0072025, 0.006785, 0.004575, 0.00422, 0.00375, 0.0043925, 0.0059825, 0.0065725, 0.0065, 0.0051225, 0.005455, 0.005785, 0.00539, 0.00548, 0.0046425, 0.004115, 0.0052075, 0.0055725, 0.00561, 0.0045525, 0.004235, 0.0048, 0.00441, 0.0048925, 0.0046425, 0.004065, 0.004665, 0.0046475, 0.00415, 0.00396, 0.00423, 0.0049575, 0.0050075, 0.0042925, 0.0030525, 0.00409, 0.00554, 0.0058075, 0.005545, 0.005105, 0.004575, 0.00469, 0.0052225, 0.00492, 0.003745, 0.0036775, 0.0043975, 0.005175, 0.0045175, 0.0044375, 0.0050575, 0.004445, 0.0039775, 0.00391, 0.0043275, 0.00412, 0.0033225, 0.0035, 0.003825, 0.0043125, 0.00441, 0.0042425, 0.0048275, 0.0043725, 0.004245, 0.003805, 0.003855, 0.00486, 0.0042975, 0.0030825, 0.003085, 0.0037125, 0.0034325, 0.0032725, 0.00391, 0.00427, 0.0038675, 0.004605, 0.0047325, 0.004505, 0.0045425, 0.0043225, 0.003605, 0.0026475, 0.003185, 0.0043025, 0.005215, 0.00625, 0.00699, 0.0068625, 0.0056525, 0.0046625, 0.0041625, 0.00362, 0.0040175, 0.003685, 0.0029375, 0.0033375, 0.004275, 0.005415, 0.0053075, 0.00601, 0.0056625, 0.0038875, 0.0037175, 0.00458, 0.0044675, 0.004315, 0.0054075, 0.006635, 0.0069975, 0.0055825, 0.0042425, 0.0036175, 0.0042925, 0.0053475, 0.006825, 0.008165, 0.0074075, 0.0062225, 0.005855, 0.004885, 0.00405, 0.004155, 0.004355, 0.004415, 0.005635, 0.007345, 0.00822, 0.0071675, 0.00549, 0.003955, 0.0043075, 0.00579, 0.00752, 0.0068575, 0.0053475, 0.004875, 0.0050475, 0.0050925, 0.0044175, 0.0051475, 0.00617, 0.0061125, 0.0058275, 0.0039775, 0.00345, 0.00467, 0.0045675, 0.00318, 0.00266, 0.00307, 0.0034425, 0.003335, 0.002855, 0.002297, 0.00162075, 0.00077, 0.0006595, 0.001618, 0.00258, 0.0021715, 0.001046, 0.000486, 0.00050625, 0.000766, 0.0009895, 0.000709, 0.00075725, 0.0009025, 0.00091075, 0.00093225, 0.0007405, 0.000695, 0.0005095, 0.0002264, 0.000223575, 0.000438, 0.00037775, 0.000281, 0.0003585, 0.00026325, 0.000321, 0.0006605, 0.000565, 0.000255, 0.0001836, 0.00022515, 0.00026425, 0.000135725, 3.9175e-05, 3.115e-05, 8.515e-05, 0.000171075, 0.0002835, 0.000233175, 7.86e-05, 2.7975e-05, 4.6225e-05, 6.5825e-05, 3.2775e-05, 8.0875e-06, 1.7385e-06, 1.13425e-06, 4.295e-06, 1.7925e-05, 3.835e-05, 2.705e-05, 7.9075e-06, 1.98475e-06, 2.2195e-06, 7.4325e-06, 1.373e-05, 9.5125e-06, 3.4775e-06, 8.36e-07, 1.6465e-07, 1.75225e-08, 1.3655e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.216e-07, 1.765e-06, 1.32025e-05, 6.4825e-05, 0.00034125, 0.001595, 0.00579, 0.01318, 0.0194325, 0.026775, 0.031475, 0.03035, 0.0389, 0.0441, 0.04275, 0.047225, 0.044625, 0.048175, 0.06135, 0.061675, 0.0606, 0.0508, 0.050225, 0.071175, 0.077875, 0.07375, 0.0738, 0.057775, 0.0663, 0.08225, 0.080025, 0.077275, 0.07555, 0.08845, 0.099575, 0.08575, 0.085425, 0.073175, 0.0648, 0.094525, 0.109425, 0.110825, 0.113475, 0.092875, 0.086225, 0.08785, 0.092975, 0.105575, 0.09395, 0.105225, 0.1283, 0.12055, 0.11595, 0.092075, 0.094275, 0.12905, 0.1313, 0.117675, 0.09685, 0.091475, 0.119925, 0.127925, 0.1276, 0.128825, 0.12625, 0.1631, 0.15375, 0.106025, 0.098725, 0.089375, 0.106825, 0.145325, 0.161575, 0.160975, 0.12975, 0.13955, 0.14945, 0.141825, 0.146625, 0.12735, 0.11425, 0.1455, 0.158925, 0.1613, 0.134225, 0.131575, 0.157175, 0.152925, 0.16855, 0.159225, 0.143825, 0.1671, 0.16985, 0.157975, 0.145675, 0.14165, 0.16415, 0.1681, 0.1429, 0.10675, 0.1394, 0.1933, 0.208825, 0.196175, 0.188025, 0.18025, 0.1778, 0.17005, 0.155575, 0.147725, 0.16795, 0.188975, 0.205675, 0.1797, 0.186675, 0.208175, 0.1907, 0.1776, 0.1581, 0.16455, 0.153475, 0.13915, 0.157375, 0.168875, 0.19355, 0.2013, 0.1844, 0.187775, 0.16665, 0.166125, 0.16085, 0.178, 0.217, 0.20185, 0.1577, 0.151425, 0.1877, 0.1812, 0.164575, 0.202575, 0.224575, 0.2031, 0.220075, 0.20105, 0.1708, 0.185325, 0.195125, 0.157575, 0.13005, 0.1573, 0.183, 0.198175, 0.23275, 0.26525, 0.25725, 0.218375, 0.18535, 0.178325, 0.2066, 0.230025, 0.1908, 0.15255, 0.1684, 0.2122, 0.2391, 0.2241, 0.236425, 0.219025, 0.1844, 0.1698, 0.18645, 0.213775, 0.210425, 0.20545, 0.205725, 0.218925, 0.22715, 0.2316, 0.23045, 0.214375, 0.24345, 0.26525, 0.247775, 0.223675, 0.22195, 0.1788, 0.165075, 0.188375, 0.21435, 0.243525, 0.25825, 0.243025, 0.237225, 0.254, 0.24815, 0.19895, 0.178425, 0.2094, 0.262, 0.314, 0.29625, 0.269, 0.241075, 0.22555, 0.197125, 0.230225, 0.243275, 0.208625, 0.21195, 0.198, 0.1918, 0.2274, 0.281, 0.262, 0.2076, 0.155625, 0.157875, 0.1779, 0.196675, 0.194425, 0.1332, 0.063725, 0.0329, 0.0534, 0.117675, 0.137875, 0.114225, 0.083875, 0.05925, 0.05585, 0.07085, 0.065825, 0.0532, 0.0622, 0.076825, 0.07075, 0.04645, 0.05215, 0.065225, 0.049775, 0.03135, 0.02965, 0.04125, 0.030525, 0.031675, 0.04505, 0.034425, 0.035425, 0.039675, 0.0222125, 0.0221175, 0.0378, 0.046425, 0.0389, 0.0149825, 0.0043175, 0.004885, 0.014685, 0.0286, 0.033625, 0.019915, 0.007205, 0.005695, 0.01593, 0.02585, 0.0143125, 0.0037925, 0.0007995, 0.0002675, 0.00059925, 0.0028125, 0.00923, 0.012565, 0.005895, 0.00166925, 0.00144, 0.00479, 0.0111925, 0.0130225, 0.0091675, 0.0034275, 0.00080275, 0.000146275, 2.02575e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.009734505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.555e-09, 1.238e-07, 9.24e-07, 4.5375e-06, 2.38675e-05, 0.000111525, 0.0004045, 0.0009185, 0.00134775, 0.00184675, 0.002161, 0.00206925, 0.0026325, 0.00297, 0.00286, 0.0031375, 0.0029475, 0.003155, 0.003995, 0.0039925, 0.0038975, 0.0032475, 0.00318, 0.004475, 0.0048725, 0.0045825, 0.0045575, 0.0035425, 0.0040275, 0.0049675, 0.0048025, 0.0046025, 0.004465, 0.0051825, 0.005805, 0.004965, 0.004905, 0.0041775, 0.00366, 0.00529, 0.00609, 0.0061225, 0.0062275, 0.00506, 0.004655, 0.0047025, 0.004935, 0.0055625, 0.0049125, 0.00544, 0.0065875, 0.0061425, 0.0058625, 0.00462, 0.00467, 0.0063425, 0.0064125, 0.0057, 0.0046525, 0.0043325, 0.0056225, 0.0059475, 0.0058775, 0.00588, 0.0057, 0.00729, 0.0068325, 0.0046625, 0.004285, 0.0038325, 0.00451, 0.0060825, 0.006695, 0.0066025, 0.005255, 0.0055625, 0.005895, 0.0055125, 0.0055925, 0.0047975, 0.00424, 0.0053225, 0.0057375, 0.00578, 0.0047075, 0.00434, 0.0049625, 0.0046575, 0.0051175, 0.00488, 0.004245, 0.0048625, 0.004875, 0.0044625, 0.00436, 0.0044975, 0.0051425, 0.00521, 0.00433, 0.0032275, 0.0041925, 0.00558, 0.00602, 0.005595, 0.005215, 0.004835, 0.0050525, 0.0052875, 0.0046975, 0.0036825, 0.00386, 0.004545, 0.005255, 0.0045475, 0.004595, 0.0050825, 0.0044225, 0.004065, 0.004015, 0.0043925, 0.00403, 0.0032325, 0.0035225, 0.00391, 0.0043575, 0.00447, 0.004425, 0.004955, 0.00447, 0.0043325, 0.00382, 0.00395, 0.0049525, 0.00437, 0.0032, 0.0031475, 0.003835, 0.0036725, 0.003425, 0.0040275, 0.0044675, 0.0042575, 0.0053925, 0.0055425, 0.0046325, 0.0043175, 0.004335, 0.0035975, 0.00284, 0.003705, 0.004875, 0.00555, 0.00638, 0.0069575, 0.0066275, 0.0053675, 0.004735, 0.004085, 0.003855, 0.004415, 0.0039175, 0.0029925, 0.0034725, 0.004975, 0.0060975, 0.0058125, 0.0061175, 0.0056775, 0.00469, 0.003775, 0.004005, 0.00511, 0.005975, 0.00655, 0.006025, 0.0049525, 0.004605, 0.0045375, 0.0048275, 0.0050825, 0.0067, 0.008165, 0.0079525, 0.0065225, 0.0061575, 0.0044575, 0.003475, 0.0042025, 0.0045175, 0.00458, 0.0060325, 0.0075325, 0.007395, 0.007005, 0.0062675, 0.0044925, 0.004175, 0.0052325, 0.006155, 0.00677, 0.0059225, 0.0057125, 0.00551, 0.0051625, 0.00421, 0.00498, 0.006215, 0.0056875, 0.00567, 0.0045025, 0.0034825, 0.0043275, 0.0050875, 0.0037375, 0.0028925, 0.002735, 0.0030375, 0.00329, 0.00308, 0.0029325, 0.00227, 0.00115125, 0.000607, 0.0010415, 0.0022195, 0.002375, 0.00155875, 0.000821, 0.0004955, 0.000571, 0.00092075, 0.00091075, 0.0006775, 0.00078075, 0.001043, 0.00114575, 0.0007755, 0.0006315, 0.000679, 0.000419, 0.0002361, 0.000294, 0.0004435, 0.00030675, 0.0002655, 0.00039025, 0.00036925, 0.0005455, 0.00066675, 0.0003285, 0.000160225, 0.000202275, 0.000267, 0.000231275, 8.885e-05, 2.6675e-05, 3.4875e-05, 0.00011185, 0.00024375, 0.0003035, 0.0001575, 4.365e-05, 2.11375e-05, 4.89e-05, 7.8075e-05, 4.3275e-05, 1.147e-05, 2.42075e-06, 8.245e-07, 1.8925e-06, 8.8825e-06, 2.915e-05, 3.9675e-05, 1.85475e-05, 4.9425e-06, 2.9e-06, 8.1825e-06, 1.71275e-05, 1.3865e-05, 5.3825e-06, 1.34525e-06, 2.7475e-07, 2.695e-08, 4.7925e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.009734505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.555e-09, 1.238e-07, 9.24e-07, 4.5375e-06, 2.38675e-05, 0.000111525, 0.0004045, 0.0009185, 0.00134775, 0.00184675, 0.002161, 0.00206925, 0.0026325, 0.00297, 0.00286, 0.0031375, 0.0029475, 0.003155, 0.003995, 0.0039925, 0.0038975, 0.0032475, 0.00318, 0.004475, 0.0048725, 0.0045825, 0.0045575, 0.0035425, 0.0040275, 0.0049675, 0.0048025, 0.0046025, 0.004465, 0.0051825, 0.005805, 0.004965, 0.004905, 0.0041775, 0.00366, 0.00529, 0.00609, 0.0061225, 0.0062275, 0.00506, 0.004655, 0.0047025, 0.004935, 0.0055625, 0.0049125, 0.00544, 0.0065875, 0.0061425, 0.0058625, 0.00462, 0.00467, 0.0063425, 0.0064125, 0.0057, 0.0046525, 0.0043325, 0.0056225, 0.0059475, 0.0058775, 0.00588, 0.0057, 0.00729, 0.0068325, 0.0046625, 0.004285, 0.0038325, 0.00451, 0.0060825, 0.006695, 0.0066025, 0.005255, 0.0055625, 0.005895, 0.0055125, 0.0055925, 0.0047975, 0.00424, 0.0053225, 0.0057375, 0.00578, 0.0047075, 0.00434, 0.0049625, 0.0046575, 0.0051175, 0.00488, 0.004245, 0.0048625, 0.004875, 0.0044625, 0.00436, 0.0044975, 0.0051425, 0.00521, 0.00433, 0.0032275, 0.0041925, 0.00558, 0.00602, 0.005595, 0.005215, 0.004835, 0.0050525, 0.0052875, 0.0046975, 0.0036825, 0.00386, 0.004545, 0.005255, 0.0045475, 0.004595, 0.0050825, 0.0044225, 0.004065, 0.004015, 0.0043925, 0.00403, 0.0032325, 0.0035225, 0.00391, 0.0043575, 0.00447, 0.004425, 0.004955, 0.00447, 0.0043325, 0.00382, 0.00395, 0.0049525, 0.00437, 0.0032, 0.0031475, 0.003835, 0.0036725, 0.003425, 0.0040275, 0.0044675, 0.0042575, 0.0053925, 0.0055425, 0.0046325, 0.0043175, 0.004335, 0.0035975, 0.00284, 0.003705, 0.004875, 0.00555, 0.00638, 0.0069575, 0.0066275, 0.0053675, 0.004735, 0.004085, 0.003855, 0.004415, 0.0039175, 0.0029925, 0.0034725, 0.004975, 0.0060975, 0.0058125, 0.0061175, 0.0056775, 0.00469, 0.003775, 0.004005, 0.00511, 0.005975, 0.00655, 0.006025, 0.0049525, 0.004605, 0.0045375, 0.0048275, 0.0050825, 0.0067, 0.008165, 0.0079525, 0.0065225, 0.0061575, 0.0044575, 0.003475, 0.0042025, 0.0045175, 0.00458, 0.0060325, 0.0075325, 0.007395, 0.007005, 0.0062675, 0.0044925, 0.004175, 0.0052325, 0.006155, 0.00677, 0.0059225, 0.0057125, 0.00551, 0.0051625, 0.00421, 0.00498, 0.006215, 0.0056875, 0.00567, 0.0045025, 0.0034825, 0.0043275, 0.0050875, 0.0037375, 0.0028925, 0.002735, 0.0030375, 0.00329, 0.00308, 0.0029325, 0.00227, 0.00115125, 0.000607, 0.0010415, 0.0022195, 0.002375, 0.00155875, 0.000821, 0.0004955, 0.000571, 0.00092075, 0.00091075, 0.0006775, 0.00078075, 0.001043, 0.00114575, 0.0007755, 0.0006315, 0.000679, 0.000419, 0.0002361, 0.000294, 0.0004435, 0.00030675, 0.0002655, 0.00039025, 0.00036925, 0.0005455, 0.00066675, 0.0003285, 0.000160225, 0.000202275, 0.000267, 0.000231275, 8.885e-05, 2.6675e-05, 3.4875e-05, 0.00011185, 0.00024375, 0.0003035, 0.0001575, 4.365e-05, 2.11375e-05, 4.89e-05, 7.8075e-05, 4.3275e-05, 1.147e-05, 2.42075e-06, 8.245e-07, 1.8925e-06, 8.8825e-06, 2.915e-05, 3.9675e-05, 1.85475e-05, 4.9425e-06, 2.9e-06, 8.1825e-06, 1.71275e-05, 1.3865e-05, 5.3825e-06, 1.34525e-06, 2.7475e-07, 2.695e-08, 4.7925e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.009734505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.555e-09, 1.238e-07, 9.24e-07, 4.5375e-06, 2.38675e-05, 0.000111525, 0.0004045, 0.0009185, 0.00134775, 0.00184675, 0.002161, 0.00206925, 0.0026325, 0.00297, 0.00286, 0.0031375, 0.0029475, 0.003155, 0.003995, 0.0039925, 0.0038975, 0.0032475, 0.00318, 0.004475, 0.0048725, 0.0045825, 0.0045575, 0.0035425, 0.0040275, 0.0049675, 0.0048025, 0.0046025, 0.004465, 0.0051825, 0.005805, 0.004965, 0.004905, 0.0041775, 0.00366, 0.00529, 0.00609, 0.0061225, 0.0062275, 0.00506, 0.004655, 0.0047025, 0.004935, 0.0055625, 0.0049125, 0.00544, 0.0065875, 0.0061425, 0.0058625, 0.00462, 0.00467, 0.0063425, 0.0064125, 0.0057, 0.0046525, 0.0043325, 0.0056225, 0.0059475, 0.0058775, 0.00588, 0.0057, 0.00729, 0.0068325, 0.0046625, 0.004285, 0.0038325, 0.00451, 0.0060825, 0.006695, 0.0066025, 0.005255, 0.0055625, 0.005895, 0.0055125, 0.0055925, 0.0047975, 0.00424, 0.0053225, 0.0057375, 0.00578, 0.0047075, 0.00434, 0.0049625, 0.0046575, 0.0051175, 0.00488, 0.004245, 0.0048625, 0.004875, 0.0044625, 0.00436, 0.0044975, 0.0051425, 0.00521, 0.00433, 0.0032275, 0.0041925, 0.00558, 0.00602, 0.005595, 0.005215, 0.004835, 0.0050525, 0.0052875, 0.0046975, 0.0036825, 0.00386, 0.004545, 0.005255, 0.0045475, 0.004595, 0.0050825, 0.0044225, 0.004065, 0.004015, 0.0043925, 0.00403, 0.0032325, 0.0035225, 0.00391, 0.0043575, 0.00447, 0.004425, 0.004955, 0.00447, 0.0043325, 0.00382, 0.00395, 0.0049525, 0.00437, 0.0032, 0.0031475, 0.003835, 0.0036725, 0.003425, 0.0040275, 0.0044675, 0.0042575, 0.0053925, 0.0055425, 0.0046325, 0.0043175, 0.004335, 0.0035975, 0.00284, 0.003705, 0.004875, 0.00555, 0.00638, 0.0069575, 0.0066275, 0.0053675, 0.004735, 0.004085, 0.003855, 0.004415, 0.0039175, 0.0029925, 0.0034725, 0.004975, 0.0060975, 0.0058125, 0.0061175, 0.0056775, 0.00469, 0.003775, 0.004005, 0.00511, 0.005975, 0.00655, 0.006025, 0.0049525, 0.004605, 0.0045375, 0.0048275, 0.0050825, 0.0067, 0.008165, 0.0079525, 0.0065225, 0.0061575, 0.0044575, 0.003475, 0.0042025, 0.0045175, 0.00458, 0.0060325, 0.0075325, 0.007395, 0.007005, 0.0062675, 0.0044925, 0.004175, 0.0052325, 0.006155, 0.00677, 0.0059225, 0.0057125, 0.00551, 0.0051625, 0.00421, 0.00498, 0.006215, 0.0056875, 0.00567, 0.0045025, 0.0034825, 0.0043275, 0.0050875, 0.0037375, 0.0028925, 0.002735, 0.0030375, 0.00329, 0.00308, 0.0029325, 0.00227, 0.00115125, 0.000607, 0.0010415, 0.0022195, 0.002375, 0.00155875, 0.000821, 0.0004955, 0.000571, 0.00092075, 0.00091075, 0.0006775, 0.00078075, 0.001043, 0.00114575, 0.0007755, 0.0006315, 0.000679, 0.000419, 0.0002361, 0.000294, 0.0004435, 0.00030675, 0.0002655, 0.00039025, 0.00036925, 0.0005455, 0.00066675, 0.0003285, 0.000160225, 0.000202275, 0.000267, 0.000231275, 8.885e-05, 2.6675e-05, 3.4875e-05, 0.00011185, 0.00024375, 0.0003035, 0.0001575, 4.365e-05, 2.11375e-05, 4.89e-05, 7.8075e-05, 4.3275e-05, 1.147e-05, 2.42075e-06, 8.245e-07, 1.8925e-06, 8.8825e-06, 2.915e-05, 3.9675e-05, 1.85475e-05, 4.9425e-06, 2.9e-06, 8.1825e-06, 1.71275e-05, 1.3865e-05, 5.3825e-06, 1.34525e-06, 2.7475e-07, 2.695e-08, 4.7925e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.009734505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.555e-09, 1.238e-07, 9.24e-07, 4.5375e-06, 2.38675e-05, 0.000111525, 0.0004045, 0.0009185, 0.00134775, 0.00184675, 0.002161, 0.00206925, 0.0026325, 0.00297, 0.00286, 0.0031375, 0.0029475, 0.003155, 0.003995, 0.0039925, 0.0038975, 0.0032475, 0.00318, 0.004475, 0.0048725, 0.0045825, 0.0045575, 0.0035425, 0.0040275, 0.0049675, 0.0048025, 0.0046025, 0.004465, 0.0051825, 0.005805, 0.004965, 0.004905, 0.0041775, 0.00366, 0.00529, 0.00609, 0.0061225, 0.0062275, 0.00506, 0.004655, 0.0047025, 0.004935, 0.0055625, 0.0049125, 0.00544, 0.0065875, 0.0061425, 0.0058625, 0.00462, 0.00467, 0.0063425, 0.0064125, 0.0057, 0.0046525, 0.0043325, 0.0056225, 0.0059475, 0.0058775, 0.00588, 0.0057, 0.00729, 0.0068325, 0.0046625, 0.004285, 0.0038325, 0.00451, 0.0060825, 0.006695, 0.0066025, 0.005255, 0.0055625, 0.005895, 0.0055125, 0.0055925, 0.0047975, 0.00424, 0.0053225, 0.0057375, 0.00578, 0.0047075, 0.00434, 0.0049625, 0.0046575, 0.0051175, 0.00488, 0.004245, 0.0048625, 0.004875, 0.0044625, 0.00436, 0.0044975, 0.0051425, 0.00521, 0.00433, 0.0032275, 0.0041925, 0.00558, 0.00602, 0.005595, 0.005215, 0.004835, 0.0050525, 0.0052875, 0.0046975, 0.0036825, 0.00386, 0.004545, 0.005255, 0.0045475, 0.004595, 0.0050825, 0.0044225, 0.004065, 0.004015, 0.0043925, 0.00403, 0.0032325, 0.0035225, 0.00391, 0.0043575, 0.00447, 0.004425, 0.004955, 0.00447, 0.0043325, 0.00382, 0.00395, 0.0049525, 0.00437, 0.0032, 0.0031475, 0.003835, 0.0036725, 0.003425, 0.0040275, 0.0044675, 0.0042575, 0.0053925, 0.0055425, 0.0046325, 0.0043175, 0.004335, 0.0035975, 0.00284, 0.003705, 0.004875, 0.00555, 0.00638, 0.0069575, 0.0066275, 0.0053675, 0.004735, 0.004085, 0.003855, 0.004415, 0.0039175, 0.0029925, 0.0034725, 0.004975, 0.0060975, 0.0058125, 0.0061175, 0.0056775, 0.00469, 0.003775, 0.004005, 0.00511, 0.005975, 0.00655, 0.006025, 0.0049525, 0.004605, 0.0045375, 0.0048275, 0.0050825, 0.0067, 0.008165, 0.0079525, 0.0065225, 0.0061575, 0.0044575, 0.003475, 0.0042025, 0.0045175, 0.00458, 0.0060325, 0.0075325, 0.007395, 0.007005, 0.0062675, 0.0044925, 0.004175, 0.0052325, 0.006155, 0.00677, 0.0059225, 0.0057125, 0.00551, 0.0051625, 0.00421, 0.00498, 0.006215, 0.0056875, 0.00567, 0.0045025, 0.0034825, 0.0043275, 0.0050875, 0.0037375, 0.0028925, 0.002735, 0.0030375, 0.00329, 0.00308, 0.0029325, 0.00227, 0.00115125, 0.000607, 0.0010415, 0.0022195, 0.002375, 0.00155875, 0.000821, 0.0004955, 0.000571, 0.00092075, 0.00091075, 0.0006775, 0.00078075, 0.001043, 0.00114575, 0.0007755, 0.0006315, 0.000679, 0.000419, 0.0002361, 0.000294, 0.0004435, 0.00030675, 0.0002655, 0.00039025, 0.00036925, 0.0005455, 0.00066675, 0.0003285, 0.000160225, 0.000202275, 0.000267, 0.000231275, 8.885e-05, 2.6675e-05, 3.4875e-05, 0.00011185, 0.00024375, 0.0003035, 0.0001575, 4.365e-05, 2.11375e-05, 4.89e-05, 7.8075e-05, 4.3275e-05, 1.147e-05, 2.42075e-06, 8.245e-07, 1.8925e-06, 8.8825e-06, 2.915e-05, 3.9675e-05, 1.85475e-05, 4.9425e-06, 2.9e-06, 8.1825e-06, 1.71275e-05, 1.3865e-05, 5.3825e-06, 1.34525e-06, 2.7475e-07, 2.695e-08, 4.7925e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.48125e-07, 2.11175e-06, 1.546e-05, 7.3275e-05, 0.00037425, 0.00169225, 0.00598, 0.013435, 0.019855, 0.0273, 0.032, 0.031175, 0.03965, 0.04485, 0.043725, 0.04805, 0.0456, 0.04945, 0.06235, 0.06285, 0.061575, 0.0519, 0.051775, 0.072525, 0.0791, 0.075325, 0.074775, 0.059325, 0.068125, 0.0836, 0.0816, 0.0788, 0.077325, 0.0904, 0.100975, 0.087525, 0.086825, 0.074425, 0.066975, 0.096425, 0.111225, 0.11305, 0.115025, 0.09475, 0.088, 0.089625, 0.095, 0.107125, 0.096025, 0.1077, 0.1301, 0.122825, 0.117625, 0.094175, 0.09675, 0.130925, 0.133325, 0.11965, 0.098925, 0.093925, 0.121725, 0.130125, 0.12995, 0.13105, 0.129125, 0.16495, 0.1562, 0.108875, 0.100475, 0.091525, 0.1085, 0.147, 0.163925, 0.163675, 0.133175, 0.1414, 0.151825, 0.144275, 0.1483, 0.13095, 0.116175, 0.146275, 0.16115, 0.16455, 0.137325, 0.13095, 0.157075, 0.155575, 0.170675, 0.1646, 0.144625, 0.168275, 0.17245, 0.1631, 0.154425, 0.145475, 0.165025, 0.17045, 0.147425, 0.114, 0.137075, 0.1923, 0.213425, 0.198275, 0.192325, 0.18425, 0.187225, 0.1772, 0.154775, 0.14495, 0.16845, 0.193475, 0.210025, 0.184325, 0.190125, 0.209775, 0.191625, 0.184675, 0.1695, 0.170125, 0.155375, 0.136425, 0.157025, 0.172525, 0.19425, 0.206425, 0.1926, 0.1938, 0.170225, 0.16575, 0.160975, 0.17785, 0.2159, 0.2028, 0.1658, 0.1547, 0.1835, 0.18755, 0.17135, 0.199225, 0.23205, 0.2156, 0.230325, 0.208475, 0.172475, 0.1782, 0.198225, 0.170675, 0.136825, 0.16485, 0.1909, 0.205925, 0.231875, 0.26225, 0.25525, 0.225725, 0.1912, 0.168925, 0.1967, 0.239575, 0.207, 0.160325, 0.1805, 0.225925, 0.2375, 0.234075, 0.248575, 0.2162, 0.171025, 0.173025, 0.20665, 0.233275, 0.223525, 0.19965, 0.1864, 0.21275, 0.237925, 0.233925, 0.239425, 0.25, 0.271, 0.27175, 0.24085, 0.221975, 0.2033, 0.1694, 0.174675, 0.201725, 0.20715, 0.26, 0.30325, 0.26275, 0.229075, 0.239275, 0.22685, 0.207525, 0.2031, 0.213475, 0.25425, 0.3035, 0.315, 0.292, 0.25025, 0.21675, 0.205225, 0.25775, 0.25675, 0.213, 0.19955, 0.171775, 0.20315, 0.25675, 0.25675, 0.24155, 0.222875, 0.177575, 0.178325, 0.176875, 0.18795, 0.191525, 0.128475, 0.06305, 0.04155, 0.070575, 0.11375, 0.11775, 0.101875, 0.086, 0.067025, 0.0615, 0.075875, 0.069625, 0.056975, 0.06215, 0.082725, 0.072775, 0.0418, 0.048625, 0.05965, 0.047925, 0.03755, 0.03375, 0.0401, 0.03255, 0.033175, 0.046725, 0.0435, 0.044925, 0.032275, 0.0139825, 0.017215, 0.038125, 0.051925, 0.0401, 0.01482, 0.0044725, 0.005585, 0.017655, 0.0349, 0.032425, 0.0153175, 0.005375, 0.00492, 0.014515, 0.025875, 0.01623, 0.00469, 0.001041, 0.00036725, 0.000812, 0.0035775, 0.010385, 0.01203, 0.0051075, 0.00140825, 0.00111, 0.00373, 0.0103675, 0.0143825, 0.0103025, 0.003865, 0.00092925, 0.000165825, 2.3e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0326962525, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0215e-08, 1.452e-07, 1.0605e-06, 5.0275e-06, 2.5675e-05, 0.000116, 0.0004095, 0.00091775, 0.00135, 0.0018455, 0.00215375, 0.002085, 0.0026325, 0.0029625, 0.00287, 0.003135, 0.0029575, 0.00318, 0.00399, 0.0039975, 0.0038925, 0.0032625, 0.0032225, 0.004485, 0.0048675, 0.004605, 0.0045475, 0.00358, 0.004075, 0.0049725, 0.004825, 0.004625, 0.004505, 0.0052225, 0.005805, 0.005, 0.00492, 0.004195, 0.0037325, 0.0053325, 0.0061175, 0.00617, 0.00624, 0.005105, 0.0047, 0.0047475, 0.0049925, 0.00559, 0.0049725, 0.005515, 0.0066225, 0.006205, 0.0058975, 0.0046875, 0.0047575, 0.00639, 0.00647, 0.0057625, 0.004725, 0.0044275, 0.00568, 0.006025, 0.0059625, 0.0059625, 0.005815, 0.00736, 0.0069275, 0.0047825, 0.00436, 0.00393, 0.00459, 0.0061675, 0.00681, 0.0067325, 0.0054125, 0.0056625, 0.00602, 0.0056475, 0.0057125, 0.0049875, 0.0043625, 0.005425, 0.005905, 0.0059775, 0.004905, 0.00445, 0.0051325, 0.004925, 0.00534, 0.005185, 0.0044375, 0.00507, 0.0051425, 0.0048075, 0.00477, 0.004725, 0.0052975, 0.0053625, 0.0044475, 0.0034875, 0.004195, 0.0055975, 0.006215, 0.0056675, 0.0054075, 0.0050975, 0.00534, 0.0053575, 0.0045625, 0.0037025, 0.00397, 0.004675, 0.0053175, 0.00463, 0.00475, 0.0050875, 0.00442, 0.0041575, 0.0041575, 0.0044525, 0.0039775, 0.0031525, 0.0035025, 0.003985, 0.0044075, 0.0045625, 0.0046175, 0.0050975, 0.004605, 0.004425, 0.0038525, 0.00403, 0.0050275, 0.0044925, 0.0033375, 0.0032125, 0.00395, 0.003945, 0.0036075, 0.00416, 0.00485, 0.0049525, 0.006065, 0.005875, 0.0046575, 0.0042375, 0.0043525, 0.00374, 0.0032375, 0.0042, 0.0052275, 0.005775, 0.006345, 0.00698, 0.00632, 0.0052975, 0.0048225, 0.0040675, 0.004095, 0.0048, 0.004225, 0.00316, 0.0040225, 0.00596, 0.006075, 0.005905, 0.00704, 0.0058425, 0.00391, 0.0037325, 0.005215, 0.0064925, 0.0064575, 0.0054775, 0.0044375, 0.0045825, 0.0053225, 0.0051575, 0.005055, 0.006365, 0.0081725, 0.00815, 0.0070575, 0.00649, 0.004755, 0.0032125, 0.0035725, 0.0047225, 0.0047475, 0.0059, 0.00769, 0.007405, 0.00661, 0.006295, 0.005115, 0.00457, 0.0050725, 0.0053075, 0.0057525, 0.0059975, 0.00629, 0.0062625, 0.0055875, 0.0045725, 0.0043175, 0.00581, 0.0060275, 0.0053625, 0.0049125, 0.003655, 0.00388, 0.005055, 0.00451, 0.00327, 0.0029575, 0.0027275, 0.0031875, 0.00316, 0.00303, 0.0030025, 0.00205025, 0.00092875, 0.00074875, 0.00150875, 0.002201, 0.00187375, 0.00135925, 0.00091975, 0.00059625, 0.0006545, 0.00095625, 0.00087025, 0.000709, 0.00085675, 0.0012385, 0.0011375, 0.00063175, 0.00062075, 0.00061325, 0.00038975, 0.00028975, 0.00033625, 0.000455, 0.000351, 0.00029975, 0.000447, 0.000517, 0.00067875, 0.0005165, 0.0001911, 0.00012145, 0.00022245, 0.0003065, 0.000238775, 8.7975e-05, 2.85e-05, 4.32e-05, 0.000144175, 0.00029975, 0.00027325, 0.000105175, 2.755e-05, 1.83425e-05, 4.975e-05, 8.8125e-05, 5.535e-05, 1.59925e-05, 3.5425e-06, 1.221e-06, 2.6175e-06, 1.15325e-05, 3.3475e-05, 3.875e-05, 1.64175e-05, 4.3125e-06, 2.462e-06, 7.085e-06, 1.78925e-05, 1.885e-05, 8.44e-06, 2.23375e-06, 4.7425e-07, 4.075e-08, 1.74125e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0326962525, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0215e-08, 1.452e-07, 1.0605e-06, 5.0275e-06, 2.5675e-05, 0.000116, 0.0004095, 0.00091775, 0.00135, 0.0018455, 0.00215375, 0.002085, 0.0026325, 0.0029625, 0.00287, 0.003135, 0.0029575, 0.00318, 0.00399, 0.0039975, 0.0038925, 0.0032625, 0.0032225, 0.004485, 0.0048675, 0.004605, 0.0045475, 0.00358, 0.004075, 0.0049725, 0.004825, 0.004625, 0.004505, 0.0052225, 0.005805, 0.005, 0.00492, 0.004195, 0.0037325, 0.0053325, 0.0061175, 0.00617, 0.00624, 0.005105, 0.0047, 0.0047475, 0.0049925, 0.00559, 0.0049725, 0.005515, 0.0066225, 0.006205, 0.0058975, 0.0046875, 0.0047575, 0.00639, 0.00647, 0.0057625, 0.004725, 0.0044275, 0.00568, 0.006025, 0.0059625, 0.0059625, 0.005815, 0.00736, 0.0069275, 0.0047825, 0.00436, 0.00393, 0.00459, 0.0061675, 0.00681, 0.0067325, 0.0054125, 0.0056625, 0.00602, 0.0056475, 0.0057125, 0.0049875, 0.0043625, 0.005425, 0.005905, 0.0059775, 0.004905, 0.00445, 0.0051325, 0.004925, 0.00534, 0.005185, 0.0044375, 0.00507, 0.0051425, 0.0048075, 0.00477, 0.004725, 0.0052975, 0.0053625, 0.0044475, 0.0034875, 0.004195, 0.0055975, 0.006215, 0.0056675, 0.0054075, 0.0050975, 0.00534, 0.0053575, 0.0045625, 0.0037025, 0.00397, 0.004675, 0.0053175, 0.00463, 0.00475, 0.0050875, 0.00442, 0.0041575, 0.0041575, 0.0044525, 0.0039775, 0.0031525, 0.0035025, 0.003985, 0.0044075, 0.0045625, 0.0046175, 0.0050975, 0.004605, 0.004425, 0.0038525, 0.00403, 0.0050275, 0.0044925, 0.0033375, 0.0032125, 0.00395, 0.003945, 0.0036075, 0.00416, 0.00485, 0.0049525, 0.006065, 0.005875, 0.0046575, 0.0042375, 0.0043525, 0.00374, 0.0032375, 0.0042, 0.0052275, 0.005775, 0.006345, 0.00698, 0.00632, 0.0052975, 0.0048225, 0.0040675, 0.004095, 0.0048, 0.004225, 0.00316, 0.0040225, 0.00596, 0.006075, 0.005905, 0.00704, 0.0058425, 0.00391, 0.0037325, 0.005215, 0.0064925, 0.0064575, 0.0054775, 0.0044375, 0.0045825, 0.0053225, 0.0051575, 0.005055, 0.006365, 0.0081725, 0.00815, 0.0070575, 0.00649, 0.004755, 0.0032125, 0.0035725, 0.0047225, 0.0047475, 0.0059, 0.00769, 0.007405, 0.00661, 0.006295, 0.005115, 0.00457, 0.0050725, 0.0053075, 0.0057525, 0.0059975, 0.00629, 0.0062625, 0.0055875, 0.0045725, 0.0043175, 0.00581, 0.0060275, 0.0053625, 0.0049125, 0.003655, 0.00388, 0.005055, 0.00451, 0.00327, 0.0029575, 0.0027275, 0.0031875, 0.00316, 0.00303, 0.0030025, 0.00205025, 0.00092875, 0.00074875, 0.00150875, 0.002201, 0.00187375, 0.00135925, 0.00091975, 0.00059625, 0.0006545, 0.00095625, 0.00087025, 0.000709, 0.00085675, 0.0012385, 0.0011375, 0.00063175, 0.00062075, 0.00061325, 0.00038975, 0.00028975, 0.00033625, 0.000455, 0.000351, 0.00029975, 0.000447, 0.000517, 0.00067875, 0.0005165, 0.0001911, 0.00012145, 0.00022245, 0.0003065, 0.000238775, 8.7975e-05, 2.85e-05, 4.32e-05, 0.000144175, 0.00029975, 0.00027325, 0.000105175, 2.755e-05, 1.83425e-05, 4.975e-05, 8.8125e-05, 5.535e-05, 1.59925e-05, 3.5425e-06, 1.221e-06, 2.6175e-06, 1.15325e-05, 3.3475e-05, 3.875e-05, 1.64175e-05, 4.3125e-06, 2.462e-06, 7.085e-06, 1.78925e-05, 1.885e-05, 8.44e-06, 2.23375e-06, 4.7425e-07, 4.075e-08, 1.74125e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0326962525, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0215e-08, 1.452e-07, 1.0605e-06, 5.0275e-06, 2.5675e-05, 0.000116, 0.0004095, 0.00091775, 0.00135, 0.0018455, 0.00215375, 0.002085, 0.0026325, 0.0029625, 0.00287, 0.003135, 0.0029575, 0.00318, 0.00399, 0.0039975, 0.0038925, 0.0032625, 0.0032225, 0.004485, 0.0048675, 0.004605, 0.0045475, 0.00358, 0.004075, 0.0049725, 0.004825, 0.004625, 0.004505, 0.0052225, 0.005805, 0.005, 0.00492, 0.004195, 0.0037325, 0.0053325, 0.0061175, 0.00617, 0.00624, 0.005105, 0.0047, 0.0047475, 0.0049925, 0.00559, 0.0049725, 0.005515, 0.0066225, 0.006205, 0.0058975, 0.0046875, 0.0047575, 0.00639, 0.00647, 0.0057625, 0.004725, 0.0044275, 0.00568, 0.006025, 0.0059625, 0.0059625, 0.005815, 0.00736, 0.0069275, 0.0047825, 0.00436, 0.00393, 0.00459, 0.0061675, 0.00681, 0.0067325, 0.0054125, 0.0056625, 0.00602, 0.0056475, 0.0057125, 0.0049875, 0.0043625, 0.005425, 0.005905, 0.0059775, 0.004905, 0.00445, 0.0051325, 0.004925, 0.00534, 0.005185, 0.0044375, 0.00507, 0.0051425, 0.0048075, 0.00477, 0.004725, 0.0052975, 0.0053625, 0.0044475, 0.0034875, 0.004195, 0.0055975, 0.006215, 0.0056675, 0.0054075, 0.0050975, 0.00534, 0.0053575, 0.0045625, 0.0037025, 0.00397, 0.004675, 0.0053175, 0.00463, 0.00475, 0.0050875, 0.00442, 0.0041575, 0.0041575, 0.0044525, 0.0039775, 0.0031525, 0.0035025, 0.003985, 0.0044075, 0.0045625, 0.0046175, 0.0050975, 0.004605, 0.004425, 0.0038525, 0.00403, 0.0050275, 0.0044925, 0.0033375, 0.0032125, 0.00395, 0.003945, 0.0036075, 0.00416, 0.00485, 0.0049525, 0.006065, 0.005875, 0.0046575, 0.0042375, 0.0043525, 0.00374, 0.0032375, 0.0042, 0.0052275, 0.005775, 0.006345, 0.00698, 0.00632, 0.0052975, 0.0048225, 0.0040675, 0.004095, 0.0048, 0.004225, 0.00316, 0.0040225, 0.00596, 0.006075, 0.005905, 0.00704, 0.0058425, 0.00391, 0.0037325, 0.005215, 0.0064925, 0.0064575, 0.0054775, 0.0044375, 0.0045825, 0.0053225, 0.0051575, 0.005055, 0.006365, 0.0081725, 0.00815, 0.0070575, 0.00649, 0.004755, 0.0032125, 0.0035725, 0.0047225, 0.0047475, 0.0059, 0.00769, 0.007405, 0.00661, 0.006295, 0.005115, 0.00457, 0.0050725, 0.0053075, 0.0057525, 0.0059975, 0.00629, 0.0062625, 0.0055875, 0.0045725, 0.0043175, 0.00581, 0.0060275, 0.0053625, 0.0049125, 0.003655, 0.00388, 0.005055, 0.00451, 0.00327, 0.0029575, 0.0027275, 0.0031875, 0.00316, 0.00303, 0.0030025, 0.00205025, 0.00092875, 0.00074875, 0.00150875, 0.002201, 0.00187375, 0.00135925, 0.00091975, 0.00059625, 0.0006545, 0.00095625, 0.00087025, 0.000709, 0.00085675, 0.0012385, 0.0011375, 0.00063175, 0.00062075, 0.00061325, 0.00038975, 0.00028975, 0.00033625, 0.000455, 0.000351, 0.00029975, 0.000447, 0.000517, 0.00067875, 0.0005165, 0.0001911, 0.00012145, 0.00022245, 0.0003065, 0.000238775, 8.7975e-05, 2.85e-05, 4.32e-05, 0.000144175, 0.00029975, 0.00027325, 0.000105175, 2.755e-05, 1.83425e-05, 4.975e-05, 8.8125e-05, 5.535e-05, 1.59925e-05, 3.5425e-06, 1.221e-06, 2.6175e-06, 1.15325e-05, 3.3475e-05, 3.875e-05, 1.64175e-05, 4.3125e-06, 2.462e-06, 7.085e-06, 1.78925e-05, 1.885e-05, 8.44e-06, 2.23375e-06, 4.7425e-07, 4.075e-08, 1.74125e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0326962525, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0215e-08, 1.452e-07, 1.0605e-06, 5.0275e-06, 2.5675e-05, 0.000116, 0.0004095, 0.00091775, 0.00135, 0.0018455, 0.00215375, 0.002085, 0.0026325, 0.0029625, 0.00287, 0.003135, 0.0029575, 0.00318, 0.00399, 0.0039975, 0.0038925, 0.0032625, 0.0032225, 0.004485, 0.0048675, 0.004605, 0.0045475, 0.00358, 0.004075, 0.0049725, 0.004825, 0.004625, 0.004505, 0.0052225, 0.005805, 0.005, 0.00492, 0.004195, 0.0037325, 0.0053325, 0.0061175, 0.00617, 0.00624, 0.005105, 0.0047, 0.0047475, 0.0049925, 0.00559, 0.0049725, 0.005515, 0.0066225, 0.006205, 0.0058975, 0.0046875, 0.0047575, 0.00639, 0.00647, 0.0057625, 0.004725, 0.0044275, 0.00568, 0.006025, 0.0059625, 0.0059625, 0.005815, 0.00736, 0.0069275, 0.0047825, 0.00436, 0.00393, 0.00459, 0.0061675, 0.00681, 0.0067325, 0.0054125, 0.0056625, 0.00602, 0.0056475, 0.0057125, 0.0049875, 0.0043625, 0.005425, 0.005905, 0.0059775, 0.004905, 0.00445, 0.0051325, 0.004925, 0.00534, 0.005185, 0.0044375, 0.00507, 0.0051425, 0.0048075, 0.00477, 0.004725, 0.0052975, 0.0053625, 0.0044475, 0.0034875, 0.004195, 0.0055975, 0.006215, 0.0056675, 0.0054075, 0.0050975, 0.00534, 0.0053575, 0.0045625, 0.0037025, 0.00397, 0.004675, 0.0053175, 0.00463, 0.00475, 0.0050875, 0.00442, 0.0041575, 0.0041575, 0.0044525, 0.0039775, 0.0031525, 0.0035025, 0.003985, 0.0044075, 0.0045625, 0.0046175, 0.0050975, 0.004605, 0.004425, 0.0038525, 0.00403, 0.0050275, 0.0044925, 0.0033375, 0.0032125, 0.00395, 0.003945, 0.0036075, 0.00416, 0.00485, 0.0049525, 0.006065, 0.005875, 0.0046575, 0.0042375, 0.0043525, 0.00374, 0.0032375, 0.0042, 0.0052275, 0.005775, 0.006345, 0.00698, 0.00632, 0.0052975, 0.0048225, 0.0040675, 0.004095, 0.0048, 0.004225, 0.00316, 0.0040225, 0.00596, 0.006075, 0.005905, 0.00704, 0.0058425, 0.00391, 0.0037325, 0.005215, 0.0064925, 0.0064575, 0.0054775, 0.0044375, 0.0045825, 0.0053225, 0.0051575, 0.005055, 0.006365, 0.0081725, 0.00815, 0.0070575, 0.00649, 0.004755, 0.0032125, 0.0035725, 0.0047225, 0.0047475, 0.0059, 0.00769, 0.007405, 0.00661, 0.006295, 0.005115, 0.00457, 0.0050725, 0.0053075, 0.0057525, 0.0059975, 0.00629, 0.0062625, 0.0055875, 0.0045725, 0.0043175, 0.00581, 0.0060275, 0.0053625, 0.0049125, 0.003655, 0.00388, 0.005055, 0.00451, 0.00327, 0.0029575, 0.0027275, 0.0031875, 0.00316, 0.00303, 0.0030025, 0.00205025, 0.00092875, 0.00074875, 0.00150875, 0.002201, 0.00187375, 0.00135925, 0.00091975, 0.00059625, 0.0006545, 0.00095625, 0.00087025, 0.000709, 0.00085675, 0.0012385, 0.0011375, 0.00063175, 0.00062075, 0.00061325, 0.00038975, 0.00028975, 0.00033625, 0.000455, 0.000351, 0.00029975, 0.000447, 0.000517, 0.00067875, 0.0005165, 0.0001911, 0.00012145, 0.00022245, 0.0003065, 0.000238775, 8.7975e-05, 2.85e-05, 4.32e-05, 0.000144175, 0.00029975, 0.00027325, 0.000105175, 2.755e-05, 1.83425e-05, 4.975e-05, 8.8125e-05, 5.535e-05, 1.59925e-05, 3.5425e-06, 1.221e-06, 2.6175e-06, 1.15325e-05, 3.3475e-05, 3.875e-05, 1.64175e-05, 4.3125e-06, 2.462e-06, 7.085e-06, 1.78925e-05, 1.885e-05, 8.44e-06, 2.23375e-06, 4.7425e-07, 4.075e-08, 1.74125e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.8015e-07, 3.765e-06, 1.68275e-05, 8.5075e-05, 0.00040775, 0.001795, 0.00617, 0.01369, 0.0202725, 0.0278, 0.032525, 0.032, 0.040425, 0.0456, 0.04475, 0.048875, 0.04665, 0.050675, 0.0634, 0.06405, 0.062675, 0.053075, 0.053375, 0.07375, 0.080425, 0.07685, 0.075875, 0.06095, 0.069675, 0.0849, 0.08315, 0.08035, 0.079125, 0.0922, 0.1024, 0.089425, 0.0884, 0.07595, 0.0692, 0.09805, 0.1131, 0.115175, 0.11675, 0.09685, 0.089975, 0.0914, 0.097025, 0.108675, 0.0984, 0.109775, 0.1319, 0.1252, 0.11955, 0.09665, 0.098875, 0.13245, 0.135625, 0.121875, 0.101375, 0.096, 0.1232, 0.132325, 0.132275, 0.13345, 0.131775, 0.1664, 0.1594, 0.1124, 0.102325, 0.093875, 0.109575, 0.1482, 0.16605, 0.166725, 0.136925, 0.14295, 0.15425, 0.14695, 0.1501, 0.135075, 0.1182, 0.146675, 0.16315, 0.167575, 0.141425, 0.1307, 0.156625, 0.15835, 0.1717, 0.1707, 0.14625, 0.16855, 0.17555, 0.16765, 0.1628, 0.14985, 0.165575, 0.1719, 0.1522, 0.122425, 0.134125, 0.189175, 0.217625, 0.201075, 0.1974, 0.1885, 0.194, 0.18425, 0.1571, 0.143525, 0.16655, 0.196325, 0.21415, 0.190475, 0.1932, 0.210325, 0.194575, 0.188925, 0.181975, 0.1763, 0.1591, 0.1352, 0.15495, 0.17555, 0.19415, 0.210825, 0.2017, 0.2007, 0.17645, 0.16595, 0.160275, 0.177275, 0.214825, 0.2046, 0.170225, 0.161025, 0.18175, 0.19075, 0.178125, 0.198275, 0.239625, 0.22995, 0.237025, 0.215175, 0.175725, 0.172975, 0.19355, 0.187025, 0.150925, 0.169725, 0.19835, 0.208825, 0.231325, 0.259, 0.247575, 0.23635, 0.202375, 0.168075, 0.185225, 0.237225, 0.225725, 0.175175, 0.192825, 0.2333, 0.23905, 0.25, 0.248725, 0.20745, 0.173675, 0.184425, 0.22855, 0.236375, 0.217175, 0.1947, 0.18735, 0.2158, 0.241725, 0.233275, 0.25875, 0.28775, 0.284, 0.26275, 0.24895, 0.2053, 0.1824, 0.1782, 0.1918, 0.216625, 0.217025, 0.27075, 0.31425, 0.28025, 0.229525, 0.219225, 0.2192, 0.2298, 0.212875, 0.214875, 0.2415, 0.30025, 0.33925, 0.30675, 0.257, 0.215175, 0.222375, 0.26875, 0.2655, 0.222675, 0.187525, 0.1796, 0.24445, 0.271, 0.214225, 0.20535, 0.21615, 0.202325, 0.194775, 0.183575, 0.18555, 0.190825, 0.1279, 0.067275, 0.05655, 0.082625, 0.10075, 0.107, 0.10195, 0.0818, 0.066825, 0.06715, 0.0784, 0.076975, 0.064075, 0.0663, 0.08295, 0.0675, 0.0424, 0.045875, 0.0549, 0.047925, 0.04335, 0.039675, 0.04025, 0.0336, 0.033575, 0.04895, 0.053025, 0.048275, 0.025625, 0.0099475, 0.0137225, 0.0358, 0.055275, 0.0435, 0.0166125, 0.00522, 0.006445, 0.0202975, 0.038325, 0.03055, 0.013175, 0.0046275, 0.00439, 0.0131125, 0.02555, 0.0181825, 0.0057725, 0.001398, 0.00072275, 0.00205675, 0.0073075, 0.01295, 0.00826, 0.0025025, 0.00073, 0.00097375, 0.0036525, 0.0105625, 0.014965, 0.0103625, 0.003875, 0.00095775, 0.000189125, 2.5875e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0544051375, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.2185e-08, 2.535e-07, 1.13275e-06, 5.7225e-06, 2.7425e-05, 0.0001207, 0.0004145, 0.0009175, 0.00135275, 0.00184475, 0.00214875, 0.00210125, 0.002635, 0.00296, 0.0028875, 0.003135, 0.0029725, 0.003205, 0.0039875, 0.0040075, 0.0039, 0.0032825, 0.00327, 0.00449, 0.004875, 0.0046275, 0.004545, 0.003625, 0.0041075, 0.0049775, 0.0048475, 0.00465, 0.004545, 0.0052575, 0.00581, 0.0050425, 0.00495, 0.0042275, 0.0038125, 0.00536, 0.00615, 0.0062175, 0.006265, 0.005165, 0.0047575, 0.004795, 0.0050525, 0.00562, 0.0050525, 0.005575, 0.00666, 0.0062775, 0.0059525, 0.0047775, 0.0048325, 0.006425, 0.006545, 0.00584, 0.00482, 0.0045075, 0.0057275, 0.006105, 0.0060525, 0.0060575, 0.0059275, 0.00742, 0.007065, 0.0049375, 0.004445, 0.0040375, 0.0046525, 0.0062375, 0.006925, 0.0068875, 0.0055925, 0.0057575, 0.0061575, 0.0058025, 0.0058425, 0.0052075, 0.0044975, 0.00552, 0.006075, 0.0061825, 0.005145, 0.004575, 0.0053, 0.00522, 0.0055675, 0.0055425, 0.00467, 0.0052775, 0.0054475, 0.0051625, 0.0051725, 0.0049475, 0.0054175, 0.0054925, 0.0046475, 0.003785, 0.0041525, 0.005575, 0.0063875, 0.0057925, 0.0056375, 0.0053475, 0.005565, 0.0054575, 0.004545, 0.00376, 0.00402, 0.0047675, 0.0053875, 0.0047525, 0.0048925, 0.0050975, 0.0044475, 0.00424, 0.0043325, 0.0045225, 0.0039675, 0.003085, 0.0034375, 0.0040425, 0.0044725, 0.004685, 0.004815, 0.00525, 0.00478, 0.0045175, 0.003905, 0.0041025, 0.0050775, 0.004645, 0.00351, 0.00329, 0.0040525, 0.0042325, 0.00385, 0.0044075, 0.0054925, 0.0056725, 0.0062775, 0.0060125, 0.004845, 0.0042675, 0.0042575, 0.0040925, 0.0037825, 0.0045725, 0.0054575, 0.00579, 0.00629, 0.006975, 0.00605, 0.005375, 0.004895, 0.0041475, 0.0043375, 0.0051475, 0.004785, 0.0038175, 0.0044625, 0.0060175, 0.00646, 0.0069275, 0.0066275, 0.0049275, 0.00414, 0.00494, 0.00661, 0.0065425, 0.0051925, 0.0044375, 0.0045025, 0.0052575, 0.0054825, 0.0049375, 0.0061, 0.0080175, 0.0084075, 0.00732, 0.006905, 0.0053675, 0.0036725, 0.0031425, 0.0040875, 0.00523, 0.0056625, 0.006955, 0.0076375, 0.0070575, 0.0061425, 0.0053175, 0.0047525, 0.0053325, 0.0051525, 0.0050425, 0.0053325, 0.0059475, 0.0069575, 0.0063825, 0.00532, 0.0044725, 0.004695, 0.0058325, 0.0058325, 0.0051675, 0.00431, 0.0038875, 0.0053475, 0.005635, 0.0038425, 0.0030375, 0.0027775, 0.00277, 0.0032025, 0.0031375, 0.0029825, 0.002985, 0.00193275, 0.000935, 0.00102275, 0.0016785, 0.001834, 0.00157575, 0.001312, 0.00091675, 0.0006485, 0.00069975, 0.000919, 0.000899, 0.000788, 0.0009575, 0.0012935, 0.00101625, 0.0006, 0.000601, 0.00057325, 0.000416, 0.00036775, 0.00039325, 0.000461, 0.00037475, 0.0003225, 0.00050425, 0.00064875, 0.000689, 0.0003815, 0.000126975, 0.00010265, 0.0002343, 0.00035275, 0.00027125, 0.00010245, 3.445e-05, 5.115e-05, 0.000167075, 0.0003175, 0.00023645, 7.9375e-05, 2.1205e-05, 1.76875e-05, 5.16e-05, 0.00010125, 7.21e-05, 2.28775e-05, 5.485e-06, 2.585e-06, 6.8725e-06, 2.4415e-05, 4.3275e-05, 2.76e-05, 8.32e-06, 2.25775e-06, 2.38275e-06, 8.37e-06, 2.26375e-05, 2.5975e-05, 1.2175e-05, 3.275e-06, 7.13e-07, 1.06225e-07, 9.0825e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0544051375, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.2185e-08, 2.535e-07, 1.13275e-06, 5.7225e-06, 2.7425e-05, 0.0001207, 0.0004145, 0.0009175, 0.00135275, 0.00184475, 0.00214875, 0.00210125, 0.002635, 0.00296, 0.0028875, 0.003135, 0.0029725, 0.003205, 0.0039875, 0.0040075, 0.0039, 0.0032825, 0.00327, 0.00449, 0.004875, 0.0046275, 0.004545, 0.003625, 0.0041075, 0.0049775, 0.0048475, 0.00465, 0.004545, 0.0052575, 0.00581, 0.0050425, 0.00495, 0.0042275, 0.0038125, 0.00536, 0.00615, 0.0062175, 0.006265, 0.005165, 0.0047575, 0.004795, 0.0050525, 0.00562, 0.0050525, 0.005575, 0.00666, 0.0062775, 0.0059525, 0.0047775, 0.0048325, 0.006425, 0.006545, 0.00584, 0.00482, 0.0045075, 0.0057275, 0.006105, 0.0060525, 0.0060575, 0.0059275, 0.00742, 0.007065, 0.0049375, 0.004445, 0.0040375, 0.0046525, 0.0062375, 0.006925, 0.0068875, 0.0055925, 0.0057575, 0.0061575, 0.0058025, 0.0058425, 0.0052075, 0.0044975, 0.00552, 0.006075, 0.0061825, 0.005145, 0.004575, 0.0053, 0.00522, 0.0055675, 0.0055425, 0.00467, 0.0052775, 0.0054475, 0.0051625, 0.0051725, 0.0049475, 0.0054175, 0.0054925, 0.0046475, 0.003785, 0.0041525, 0.005575, 0.0063875, 0.0057925, 0.0056375, 0.0053475, 0.005565, 0.0054575, 0.004545, 0.00376, 0.00402, 0.0047675, 0.0053875, 0.0047525, 0.0048925, 0.0050975, 0.0044475, 0.00424, 0.0043325, 0.0045225, 0.0039675, 0.003085, 0.0034375, 0.0040425, 0.0044725, 0.004685, 0.004815, 0.00525, 0.00478, 0.0045175, 0.003905, 0.0041025, 0.0050775, 0.004645, 0.00351, 0.00329, 0.0040525, 0.0042325, 0.00385, 0.0044075, 0.0054925, 0.0056725, 0.0062775, 0.0060125, 0.004845, 0.0042675, 0.0042575, 0.0040925, 0.0037825, 0.0045725, 0.0054575, 0.00579, 0.00629, 0.006975, 0.00605, 0.005375, 0.004895, 0.0041475, 0.0043375, 0.0051475, 0.004785, 0.0038175, 0.0044625, 0.0060175, 0.00646, 0.0069275, 0.0066275, 0.0049275, 0.00414, 0.00494, 0.00661, 0.0065425, 0.0051925, 0.0044375, 0.0045025, 0.0052575, 0.0054825, 0.0049375, 0.0061, 0.0080175, 0.0084075, 0.00732, 0.006905, 0.0053675, 0.0036725, 0.0031425, 0.0040875, 0.00523, 0.0056625, 0.006955, 0.0076375, 0.0070575, 0.0061425, 0.0053175, 0.0047525, 0.0053325, 0.0051525, 0.0050425, 0.0053325, 0.0059475, 0.0069575, 0.0063825, 0.00532, 0.0044725, 0.004695, 0.0058325, 0.0058325, 0.0051675, 0.00431, 0.0038875, 0.0053475, 0.005635, 0.0038425, 0.0030375, 0.0027775, 0.00277, 0.0032025, 0.0031375, 0.0029825, 0.002985, 0.00193275, 0.000935, 0.00102275, 0.0016785, 0.001834, 0.00157575, 0.001312, 0.00091675, 0.0006485, 0.00069975, 0.000919, 0.000899, 0.000788, 0.0009575, 0.0012935, 0.00101625, 0.0006, 0.000601, 0.00057325, 0.000416, 0.00036775, 0.00039325, 0.000461, 0.00037475, 0.0003225, 0.00050425, 0.00064875, 0.000689, 0.0003815, 0.000126975, 0.00010265, 0.0002343, 0.00035275, 0.00027125, 0.00010245, 3.445e-05, 5.115e-05, 0.000167075, 0.0003175, 0.00023645, 7.9375e-05, 2.1205e-05, 1.76875e-05, 5.16e-05, 0.00010125, 7.21e-05, 2.28775e-05, 5.485e-06, 2.585e-06, 6.8725e-06, 2.4415e-05, 4.3275e-05, 2.76e-05, 8.32e-06, 2.25775e-06, 2.38275e-06, 8.37e-06, 2.26375e-05, 2.5975e-05, 1.2175e-05, 3.275e-06, 7.13e-07, 1.06225e-07, 9.0825e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0544051375, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.2185e-08, 2.535e-07, 1.13275e-06, 5.7225e-06, 2.7425e-05, 0.0001207, 0.0004145, 0.0009175, 0.00135275, 0.00184475, 0.00214875, 0.00210125, 0.002635, 0.00296, 0.0028875, 0.003135, 0.0029725, 0.003205, 0.0039875, 0.0040075, 0.0039, 0.0032825, 0.00327, 0.00449, 0.004875, 0.0046275, 0.004545, 0.003625, 0.0041075, 0.0049775, 0.0048475, 0.00465, 0.004545, 0.0052575, 0.00581, 0.0050425, 0.00495, 0.0042275, 0.0038125, 0.00536, 0.00615, 0.0062175, 0.006265, 0.005165, 0.0047575, 0.004795, 0.0050525, 0.00562, 0.0050525, 0.005575, 0.00666, 0.0062775, 0.0059525, 0.0047775, 0.0048325, 0.006425, 0.006545, 0.00584, 0.00482, 0.0045075, 0.0057275, 0.006105, 0.0060525, 0.0060575, 0.0059275, 0.00742, 0.007065, 0.0049375, 0.004445, 0.0040375, 0.0046525, 0.0062375, 0.006925, 0.0068875, 0.0055925, 0.0057575, 0.0061575, 0.0058025, 0.0058425, 0.0052075, 0.0044975, 0.00552, 0.006075, 0.0061825, 0.005145, 0.004575, 0.0053, 0.00522, 0.0055675, 0.0055425, 0.00467, 0.0052775, 0.0054475, 0.0051625, 0.0051725, 0.0049475, 0.0054175, 0.0054925, 0.0046475, 0.003785, 0.0041525, 0.005575, 0.0063875, 0.0057925, 0.0056375, 0.0053475, 0.005565, 0.0054575, 0.004545, 0.00376, 0.00402, 0.0047675, 0.0053875, 0.0047525, 0.0048925, 0.0050975, 0.0044475, 0.00424, 0.0043325, 0.0045225, 0.0039675, 0.003085, 0.0034375, 0.0040425, 0.0044725, 0.004685, 0.004815, 0.00525, 0.00478, 0.0045175, 0.003905, 0.0041025, 0.0050775, 0.004645, 0.00351, 0.00329, 0.0040525, 0.0042325, 0.00385, 0.0044075, 0.0054925, 0.0056725, 0.0062775, 0.0060125, 0.004845, 0.0042675, 0.0042575, 0.0040925, 0.0037825, 0.0045725, 0.0054575, 0.00579, 0.00629, 0.006975, 0.00605, 0.005375, 0.004895, 0.0041475, 0.0043375, 0.0051475, 0.004785, 0.0038175, 0.0044625, 0.0060175, 0.00646, 0.0069275, 0.0066275, 0.0049275, 0.00414, 0.00494, 0.00661, 0.0065425, 0.0051925, 0.0044375, 0.0045025, 0.0052575, 0.0054825, 0.0049375, 0.0061, 0.0080175, 0.0084075, 0.00732, 0.006905, 0.0053675, 0.0036725, 0.0031425, 0.0040875, 0.00523, 0.0056625, 0.006955, 0.0076375, 0.0070575, 0.0061425, 0.0053175, 0.0047525, 0.0053325, 0.0051525, 0.0050425, 0.0053325, 0.0059475, 0.0069575, 0.0063825, 0.00532, 0.0044725, 0.004695, 0.0058325, 0.0058325, 0.0051675, 0.00431, 0.0038875, 0.0053475, 0.005635, 0.0038425, 0.0030375, 0.0027775, 0.00277, 0.0032025, 0.0031375, 0.0029825, 0.002985, 0.00193275, 0.000935, 0.00102275, 0.0016785, 0.001834, 0.00157575, 0.001312, 0.00091675, 0.0006485, 0.00069975, 0.000919, 0.000899, 0.000788, 0.0009575, 0.0012935, 0.00101625, 0.0006, 0.000601, 0.00057325, 0.000416, 0.00036775, 0.00039325, 0.000461, 0.00037475, 0.0003225, 0.00050425, 0.00064875, 0.000689, 0.0003815, 0.000126975, 0.00010265, 0.0002343, 0.00035275, 0.00027125, 0.00010245, 3.445e-05, 5.115e-05, 0.000167075, 0.0003175, 0.00023645, 7.9375e-05, 2.1205e-05, 1.76875e-05, 5.16e-05, 0.00010125, 7.21e-05, 2.28775e-05, 5.485e-06, 2.585e-06, 6.8725e-06, 2.4415e-05, 4.3275e-05, 2.76e-05, 8.32e-06, 2.25775e-06, 2.38275e-06, 8.37e-06, 2.26375e-05, 2.5975e-05, 1.2175e-05, 3.275e-06, 7.13e-07, 1.06225e-07, 9.0825e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0544051375, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.2185e-08, 2.535e-07, 1.13275e-06, 5.7225e-06, 2.7425e-05, 0.0001207, 0.0004145, 0.0009175, 0.00135275, 0.00184475, 0.00214875, 0.00210125, 0.002635, 0.00296, 0.0028875, 0.003135, 0.0029725, 0.003205, 0.0039875, 0.0040075, 0.0039, 0.0032825, 0.00327, 0.00449, 0.004875, 0.0046275, 0.004545, 0.003625, 0.0041075, 0.0049775, 0.0048475, 0.00465, 0.004545, 0.0052575, 0.00581, 0.0050425, 0.00495, 0.0042275, 0.0038125, 0.00536, 0.00615, 0.0062175, 0.006265, 0.005165, 0.0047575, 0.004795, 0.0050525, 0.00562, 0.0050525, 0.005575, 0.00666, 0.0062775, 0.0059525, 0.0047775, 0.0048325, 0.006425, 0.006545, 0.00584, 0.00482, 0.0045075, 0.0057275, 0.006105, 0.0060525, 0.0060575, 0.0059275, 0.00742, 0.007065, 0.0049375, 0.004445, 0.0040375, 0.0046525, 0.0062375, 0.006925, 0.0068875, 0.0055925, 0.0057575, 0.0061575, 0.0058025, 0.0058425, 0.0052075, 0.0044975, 0.00552, 0.006075, 0.0061825, 0.005145, 0.004575, 0.0053, 0.00522, 0.0055675, 0.0055425, 0.00467, 0.0052775, 0.0054475, 0.0051625, 0.0051725, 0.0049475, 0.0054175, 0.0054925, 0.0046475, 0.003785, 0.0041525, 0.005575, 0.0063875, 0.0057925, 0.0056375, 0.0053475, 0.005565, 0.0054575, 0.004545, 0.00376, 0.00402, 0.0047675, 0.0053875, 0.0047525, 0.0048925, 0.0050975, 0.0044475, 0.00424, 0.0043325, 0.0045225, 0.0039675, 0.003085, 0.0034375, 0.0040425, 0.0044725, 0.004685, 0.004815, 0.00525, 0.00478, 0.0045175, 0.003905, 0.0041025, 0.0050775, 0.004645, 0.00351, 0.00329, 0.0040525, 0.0042325, 0.00385, 0.0044075, 0.0054925, 0.0056725, 0.0062775, 0.0060125, 0.004845, 0.0042675, 0.0042575, 0.0040925, 0.0037825, 0.0045725, 0.0054575, 0.00579, 0.00629, 0.006975, 0.00605, 0.005375, 0.004895, 0.0041475, 0.0043375, 0.0051475, 0.004785, 0.0038175, 0.0044625, 0.0060175, 0.00646, 0.0069275, 0.0066275, 0.0049275, 0.00414, 0.00494, 0.00661, 0.0065425, 0.0051925, 0.0044375, 0.0045025, 0.0052575, 0.0054825, 0.0049375, 0.0061, 0.0080175, 0.0084075, 0.00732, 0.006905, 0.0053675, 0.0036725, 0.0031425, 0.0040875, 0.00523, 0.0056625, 0.006955, 0.0076375, 0.0070575, 0.0061425, 0.0053175, 0.0047525, 0.0053325, 0.0051525, 0.0050425, 0.0053325, 0.0059475, 0.0069575, 0.0063825, 0.00532, 0.0044725, 0.004695, 0.0058325, 0.0058325, 0.0051675, 0.00431, 0.0038875, 0.0053475, 0.005635, 0.0038425, 0.0030375, 0.0027775, 0.00277, 0.0032025, 0.0031375, 0.0029825, 0.002985, 0.00193275, 0.000935, 0.00102275, 0.0016785, 0.001834, 0.00157575, 0.001312, 0.00091675, 0.0006485, 0.00069975, 0.000919, 0.000899, 0.000788, 0.0009575, 0.0012935, 0.00101625, 0.0006, 0.000601, 0.00057325, 0.000416, 0.00036775, 0.00039325, 0.000461, 0.00037475, 0.0003225, 0.00050425, 0.00064875, 0.000689, 0.0003815, 0.000126975, 0.00010265, 0.0002343, 0.00035275, 0.00027125, 0.00010245, 3.445e-05, 5.115e-05, 0.000167075, 0.0003175, 0.00023645, 7.9375e-05, 2.1205e-05, 1.76875e-05, 5.16e-05, 0.00010125, 7.21e-05, 2.28775e-05, 5.485e-06, 2.585e-06, 6.8725e-06, 2.4415e-05, 4.3275e-05, 2.76e-05, 8.32e-06, 2.25775e-06, 2.38275e-06, 8.37e-06, 2.26375e-05, 2.5975e-05, 1.2175e-05, 3.275e-06, 7.13e-07, 1.06225e-07, 9.0825e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1895e-07, 4.5375e-06, 1.959e-05, 9.6225e-05, 0.00044675, 0.001903, 0.00637, 0.0139525, 0.0206925, 0.0283, 0.03305, 0.032825, 0.04115, 0.046375, 0.045725, 0.049725, 0.0477, 0.05185, 0.064375, 0.06525, 0.06375, 0.05435, 0.054825, 0.074875, 0.08175, 0.0784, 0.0771, 0.062675, 0.071075, 0.08615, 0.08475, 0.081925, 0.080925, 0.09375, 0.103925, 0.091425, 0.089875, 0.077725, 0.0711, 0.0993, 0.11495, 0.117225, 0.11865, 0.099225, 0.09185, 0.09315, 0.098825, 0.1102, 0.1009, 0.111375, 0.133825, 0.127675, 0.121925, 0.0995, 0.1008, 0.133575, 0.13825, 0.124375, 0.1043, 0.0978, 0.12425, 0.134525, 0.1346, 0.136025, 0.134225, 0.16715, 0.1634, 0.1166, 0.10435, 0.0964, 0.11, 0.1488, 0.1679, 0.170275, 0.1413, 0.14425, 0.156675, 0.1499, 0.151925, 0.139775, 0.120375, 0.146525, 0.164875, 0.17055, 0.14665, 0.131025, 0.155875, 0.1611, 0.17175, 0.176975, 0.149175, 0.168025, 0.17885, 0.172075, 0.170075, 0.155125, 0.165725, 0.17325, 0.1572, 0.13115, 0.13175, 0.18325, 0.2209, 0.205575, 0.202225, 0.19355, 0.198275, 0.19125, 0.162375, 0.14355, 0.162675, 0.1965, 0.2177, 0.19815, 0.196275, 0.209575, 0.1991, 0.191525, 0.1933, 0.184025, 0.16485, 0.136325, 0.1514, 0.17735, 0.19385, 0.21315, 0.211375, 0.208575, 0.185325, 0.16785, 0.158975, 0.175375, 0.2127, 0.20925, 0.1732, 0.16555, 0.18375, 0.194175, 0.183975, 0.20105, 0.2439, 0.2409, 0.24135, 0.227825, 0.18075, 0.167775, 0.185975, 0.200425, 0.1717, 0.172825, 0.2035, 0.20945, 0.2311, 0.25625, 0.240475, 0.24075, 0.21855, 0.177625, 0.179275, 0.226375, 0.23995, 0.190525, 0.200575, 0.2505, 0.24325, 0.247, 0.244725, 0.215175, 0.193725, 0.19565, 0.22905, 0.222825, 0.2127, 0.2103, 0.198125, 0.20615, 0.23775, 0.248225, 0.286, 0.3055, 0.28425, 0.2635, 0.2458, 0.19785, 0.171875, 0.187975, 0.214, 0.2341, 0.232025, 0.2655, 0.30825, 0.29825, 0.233875, 0.210375, 0.22325, 0.242475, 0.21435, 0.219475, 0.23635, 0.29675, 0.3545, 0.31675, 0.2685, 0.2249, 0.23025, 0.2755, 0.2735, 0.233375, 0.186525, 0.19215, 0.25975, 0.26175, 0.203075, 0.18425, 0.203975, 0.226325, 0.218025, 0.192775, 0.181425, 0.187225, 0.136925, 0.0773, 0.0708, 0.0835, 0.0881, 0.097725, 0.104475, 0.0861, 0.0684, 0.066175, 0.07875, 0.08535, 0.073325, 0.071375, 0.0828, 0.065625, 0.0436, 0.043725, 0.0508, 0.048525, 0.0473, 0.04745, 0.043425, 0.033425, 0.03195, 0.0498, 0.060325, 0.0499, 0.02298, 0.0083375, 0.010945, 0.031575, 0.05645, 0.04855, 0.019975, 0.0063975, 0.00709, 0.02121, 0.0395, 0.03045, 0.0130075, 0.0045775, 0.0039625, 0.0115425, 0.02472, 0.02044, 0.007265, 0.00178725, 0.00056325, 0.00085575, 0.0035625, 0.0101225, 0.0124125, 0.0058525, 0.00175075, 0.001278, 0.0039475, 0.0111, 0.015285, 0.0101025, 0.0038225, 0.00097925, 0.0002157, 3e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.074932775, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.454e-08, 3e-07, 1.29475e-06, 6.355e-06, 2.95e-05, 0.000125625, 0.00042, 0.000918, 0.00135575, 0.00184475, 0.00214525, 0.00211825, 0.0026375, 0.00296, 0.0029, 0.003135, 0.00299, 0.003225, 0.003985, 0.0040175, 0.0039025, 0.00331, 0.00331, 0.0044925, 0.0048825, 0.0046525, 0.0045525, 0.003675, 0.0041325, 0.004985, 0.004875, 0.00468, 0.0045925, 0.00528, 0.0058275, 0.005095, 0.004975, 0.0042775, 0.003875, 0.00537, 0.006185, 0.0062625, 0.006305, 0.00524, 0.004815, 0.004845, 0.0051025, 0.0056525, 0.00514, 0.0056175, 0.00671, 0.00636, 0.0060325, 0.00489, 0.0049, 0.0064475, 0.0066425, 0.0059375, 0.0049425, 0.0045775, 0.00576, 0.0061925, 0.006145, 0.006165, 0.006035, 0.0074525, 0.007245, 0.0051275, 0.0045425, 0.00416, 0.00469, 0.00629, 0.0070375, 0.00707, 0.005805, 0.0058475, 0.0063025, 0.0059725, 0.005985, 0.00546, 0.0046475, 0.0056, 0.006245, 0.006395, 0.0054325, 0.00472, 0.0054675, 0.005535, 0.0057925, 0.005945, 0.004955, 0.0054825, 0.005785, 0.0055325, 0.00555, 0.005185, 0.0055025, 0.0056275, 0.0049125, 0.0041025, 0.0041125, 0.0054775, 0.006545, 0.0059925, 0.005875, 0.0055975, 0.005725, 0.0056025, 0.0046525, 0.00385, 0.0040275, 0.0047975, 0.005465, 0.0049125, 0.0050125, 0.00513, 0.0045125, 0.00431, 0.00451, 0.0046125, 0.0040225, 0.003045, 0.00332, 0.0040525, 0.004545, 0.0048375, 0.0050075, 0.0054125, 0.005, 0.0046175, 0.00399, 0.004165, 0.0050825, 0.004825, 0.003745, 0.0033925, 0.0041275, 0.0045325, 0.00422, 0.0048925, 0.006155, 0.006035, 0.0062275, 0.0062825, 0.005165, 0.004295, 0.00414, 0.0045475, 0.004425, 0.00483, 0.0055525, 0.005645, 0.0062475, 0.006885, 0.005955, 0.0055075, 0.0049875, 0.0043425, 0.004685, 0.00564, 0.0055725, 0.004055, 0.00461, 0.006845, 0.00683, 0.00634, 0.0060125, 0.0051025, 0.005185, 0.00604, 0.00672, 0.0054725, 0.0043775, 0.00484, 0.005145, 0.0048975, 0.00516, 0.0055775, 0.0074475, 0.00871, 0.007825, 0.00705, 0.00607, 0.004565, 0.003475, 0.003475, 0.0047625, 0.00595, 0.006155, 0.0069575, 0.007365, 0.0069, 0.005525, 0.0048225, 0.005035, 0.0055625, 0.004865, 0.00491, 0.005195, 0.006195, 0.0072925, 0.006385, 0.0052575, 0.004495, 0.0046825, 0.0057625, 0.0057275, 0.0050025, 0.0040725, 0.0041275, 0.0055575, 0.005085, 0.0034775, 0.0029, 0.00272, 0.0029325, 0.003185, 0.0030975, 0.002945, 0.0029375, 0.002008, 0.001088, 0.00120975, 0.00155825, 0.00148125, 0.00143025, 0.001415, 0.00107375, 0.0007685, 0.00073725, 0.000867, 0.00095375, 0.00089425, 0.001039, 0.00127175, 0.000965, 0.00062025, 0.000561, 0.000544, 0.00046425, 0.00044475, 0.0004725, 0.0004695, 0.00035175, 0.0003065, 0.0005275, 0.0007195, 0.00065575, 0.00031225, 0.00010145, 8.9975e-05, 0.000233075, 0.00039825, 0.000326, 0.0001308, 4.3375e-05, 5.4725e-05, 0.000167825, 0.000308, 0.000217475, 7.16e-05, 1.97075e-05, 1.727e-05, 5.1575e-05, 0.00011135, 9.215e-05, 3.275e-05, 8.0475e-06, 2.496e-06, 3.66e-06, 1.52275e-05, 4.3275e-05, 5.3075e-05, 2.49625e-05, 7.19e-06, 4.0875e-06, 1.1065e-05, 2.95e-05, 3.4925e-05, 1.63125e-05, 4.3775e-06, 9.735e-07, 2.06775e-07, 6.025e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.074932775, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.454e-08, 3e-07, 1.29475e-06, 6.355e-06, 2.95e-05, 0.000125625, 0.00042, 0.000918, 0.00135575, 0.00184475, 0.00214525, 0.00211825, 0.0026375, 0.00296, 0.0029, 0.003135, 0.00299, 0.003225, 0.003985, 0.0040175, 0.0039025, 0.00331, 0.00331, 0.0044925, 0.0048825, 0.0046525, 0.0045525, 0.003675, 0.0041325, 0.004985, 0.004875, 0.00468, 0.0045925, 0.00528, 0.0058275, 0.005095, 0.004975, 0.0042775, 0.003875, 0.00537, 0.006185, 0.0062625, 0.006305, 0.00524, 0.004815, 0.004845, 0.0051025, 0.0056525, 0.00514, 0.0056175, 0.00671, 0.00636, 0.0060325, 0.00489, 0.0049, 0.0064475, 0.0066425, 0.0059375, 0.0049425, 0.0045775, 0.00576, 0.0061925, 0.006145, 0.006165, 0.006035, 0.0074525, 0.007245, 0.0051275, 0.0045425, 0.00416, 0.00469, 0.00629, 0.0070375, 0.00707, 0.005805, 0.0058475, 0.0063025, 0.0059725, 0.005985, 0.00546, 0.0046475, 0.0056, 0.006245, 0.006395, 0.0054325, 0.00472, 0.0054675, 0.005535, 0.0057925, 0.005945, 0.004955, 0.0054825, 0.005785, 0.0055325, 0.00555, 0.005185, 0.0055025, 0.0056275, 0.0049125, 0.0041025, 0.0041125, 0.0054775, 0.006545, 0.0059925, 0.005875, 0.0055975, 0.005725, 0.0056025, 0.0046525, 0.00385, 0.0040275, 0.0047975, 0.005465, 0.0049125, 0.0050125, 0.00513, 0.0045125, 0.00431, 0.00451, 0.0046125, 0.0040225, 0.003045, 0.00332, 0.0040525, 0.004545, 0.0048375, 0.0050075, 0.0054125, 0.005, 0.0046175, 0.00399, 0.004165, 0.0050825, 0.004825, 0.003745, 0.0033925, 0.0041275, 0.0045325, 0.00422, 0.0048925, 0.006155, 0.006035, 0.0062275, 0.0062825, 0.005165, 0.004295, 0.00414, 0.0045475, 0.004425, 0.00483, 0.0055525, 0.005645, 0.0062475, 0.006885, 0.005955, 0.0055075, 0.0049875, 0.0043425, 0.004685, 0.00564, 0.0055725, 0.004055, 0.00461, 0.006845, 0.00683, 0.00634, 0.0060125, 0.0051025, 0.005185, 0.00604, 0.00672, 0.0054725, 0.0043775, 0.00484, 0.005145, 0.0048975, 0.00516, 0.0055775, 0.0074475, 0.00871, 0.007825, 0.00705, 0.00607, 0.004565, 0.003475, 0.003475, 0.0047625, 0.00595, 0.006155, 0.0069575, 0.007365, 0.0069, 0.005525, 0.0048225, 0.005035, 0.0055625, 0.004865, 0.00491, 0.005195, 0.006195, 0.0072925, 0.006385, 0.0052575, 0.004495, 0.0046825, 0.0057625, 0.0057275, 0.0050025, 0.0040725, 0.0041275, 0.0055575, 0.005085, 0.0034775, 0.0029, 0.00272, 0.0029325, 0.003185, 0.0030975, 0.002945, 0.0029375, 0.002008, 0.001088, 0.00120975, 0.00155825, 0.00148125, 0.00143025, 0.001415, 0.00107375, 0.0007685, 0.00073725, 0.000867, 0.00095375, 0.00089425, 0.001039, 0.00127175, 0.000965, 0.00062025, 0.000561, 0.000544, 0.00046425, 0.00044475, 0.0004725, 0.0004695, 0.00035175, 0.0003065, 0.0005275, 0.0007195, 0.00065575, 0.00031225, 0.00010145, 8.9975e-05, 0.000233075, 0.00039825, 0.000326, 0.0001308, 4.3375e-05, 5.4725e-05, 0.000167825, 0.000308, 0.000217475, 7.16e-05, 1.97075e-05, 1.727e-05, 5.1575e-05, 0.00011135, 9.215e-05, 3.275e-05, 8.0475e-06, 2.496e-06, 3.66e-06, 1.52275e-05, 4.3275e-05, 5.3075e-05, 2.49625e-05, 7.19e-06, 4.0875e-06, 1.1065e-05, 2.95e-05, 3.4925e-05, 1.63125e-05, 4.3775e-06, 9.735e-07, 2.06775e-07, 6.025e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.074932775, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.454e-08, 3e-07, 1.29475e-06, 6.355e-06, 2.95e-05, 0.000125625, 0.00042, 0.000918, 0.00135575, 0.00184475, 0.00214525, 0.00211825, 0.0026375, 0.00296, 0.0029, 0.003135, 0.00299, 0.003225, 0.003985, 0.0040175, 0.0039025, 0.00331, 0.00331, 0.0044925, 0.0048825, 0.0046525, 0.0045525, 0.003675, 0.0041325, 0.004985, 0.004875, 0.00468, 0.0045925, 0.00528, 0.0058275, 0.005095, 0.004975, 0.0042775, 0.003875, 0.00537, 0.006185, 0.0062625, 0.006305, 0.00524, 0.004815, 0.004845, 0.0051025, 0.0056525, 0.00514, 0.0056175, 0.00671, 0.00636, 0.0060325, 0.00489, 0.0049, 0.0064475, 0.0066425, 0.0059375, 0.0049425, 0.0045775, 0.00576, 0.0061925, 0.006145, 0.006165, 0.006035, 0.0074525, 0.007245, 0.0051275, 0.0045425, 0.00416, 0.00469, 0.00629, 0.0070375, 0.00707, 0.005805, 0.0058475, 0.0063025, 0.0059725, 0.005985, 0.00546, 0.0046475, 0.0056, 0.006245, 0.006395, 0.0054325, 0.00472, 0.0054675, 0.005535, 0.0057925, 0.005945, 0.004955, 0.0054825, 0.005785, 0.0055325, 0.00555, 0.005185, 0.0055025, 0.0056275, 0.0049125, 0.0041025, 0.0041125, 0.0054775, 0.006545, 0.0059925, 0.005875, 0.0055975, 0.005725, 0.0056025, 0.0046525, 0.00385, 0.0040275, 0.0047975, 0.005465, 0.0049125, 0.0050125, 0.00513, 0.0045125, 0.00431, 0.00451, 0.0046125, 0.0040225, 0.003045, 0.00332, 0.0040525, 0.004545, 0.0048375, 0.0050075, 0.0054125, 0.005, 0.0046175, 0.00399, 0.004165, 0.0050825, 0.004825, 0.003745, 0.0033925, 0.0041275, 0.0045325, 0.00422, 0.0048925, 0.006155, 0.006035, 0.0062275, 0.0062825, 0.005165, 0.004295, 0.00414, 0.0045475, 0.004425, 0.00483, 0.0055525, 0.005645, 0.0062475, 0.006885, 0.005955, 0.0055075, 0.0049875, 0.0043425, 0.004685, 0.00564, 0.0055725, 0.004055, 0.00461, 0.006845, 0.00683, 0.00634, 0.0060125, 0.0051025, 0.005185, 0.00604, 0.00672, 0.0054725, 0.0043775, 0.00484, 0.005145, 0.0048975, 0.00516, 0.0055775, 0.0074475, 0.00871, 0.007825, 0.00705, 0.00607, 0.004565, 0.003475, 0.003475, 0.0047625, 0.00595, 0.006155, 0.0069575, 0.007365, 0.0069, 0.005525, 0.0048225, 0.005035, 0.0055625, 0.004865, 0.00491, 0.005195, 0.006195, 0.0072925, 0.006385, 0.0052575, 0.004495, 0.0046825, 0.0057625, 0.0057275, 0.0050025, 0.0040725, 0.0041275, 0.0055575, 0.005085, 0.0034775, 0.0029, 0.00272, 0.0029325, 0.003185, 0.0030975, 0.002945, 0.0029375, 0.002008, 0.001088, 0.00120975, 0.00155825, 0.00148125, 0.00143025, 0.001415, 0.00107375, 0.0007685, 0.00073725, 0.000867, 0.00095375, 0.00089425, 0.001039, 0.00127175, 0.000965, 0.00062025, 0.000561, 0.000544, 0.00046425, 0.00044475, 0.0004725, 0.0004695, 0.00035175, 0.0003065, 0.0005275, 0.0007195, 0.00065575, 0.00031225, 0.00010145, 8.9975e-05, 0.000233075, 0.00039825, 0.000326, 0.0001308, 4.3375e-05, 5.4725e-05, 0.000167825, 0.000308, 0.000217475, 7.16e-05, 1.97075e-05, 1.727e-05, 5.1575e-05, 0.00011135, 9.215e-05, 3.275e-05, 8.0475e-06, 2.496e-06, 3.66e-06, 1.52275e-05, 4.3275e-05, 5.3075e-05, 2.49625e-05, 7.19e-06, 4.0875e-06, 1.1065e-05, 2.95e-05, 3.4925e-05, 1.63125e-05, 4.3775e-06, 9.735e-07, 2.06775e-07, 6.025e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.074932775, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.454e-08, 3e-07, 1.29475e-06, 6.355e-06, 2.95e-05, 0.000125625, 0.00042, 0.000918, 0.00135575, 0.00184475, 0.00214525, 0.00211825, 0.0026375, 0.00296, 0.0029, 0.003135, 0.00299, 0.003225, 0.003985, 0.0040175, 0.0039025, 0.00331, 0.00331, 0.0044925, 0.0048825, 0.0046525, 0.0045525, 0.003675, 0.0041325, 0.004985, 0.004875, 0.00468, 0.0045925, 0.00528, 0.0058275, 0.005095, 0.004975, 0.0042775, 0.003875, 0.00537, 0.006185, 0.0062625, 0.006305, 0.00524, 0.004815, 0.004845, 0.0051025, 0.0056525, 0.00514, 0.0056175, 0.00671, 0.00636, 0.0060325, 0.00489, 0.0049, 0.0064475, 0.0066425, 0.0059375, 0.0049425, 0.0045775, 0.00576, 0.0061925, 0.006145, 0.006165, 0.006035, 0.0074525, 0.007245, 0.0051275, 0.0045425, 0.00416, 0.00469, 0.00629, 0.0070375, 0.00707, 0.005805, 0.0058475, 0.0063025, 0.0059725, 0.005985, 0.00546, 0.0046475, 0.0056, 0.006245, 0.006395, 0.0054325, 0.00472, 0.0054675, 0.005535, 0.0057925, 0.005945, 0.004955, 0.0054825, 0.005785, 0.0055325, 0.00555, 0.005185, 0.0055025, 0.0056275, 0.0049125, 0.0041025, 0.0041125, 0.0054775, 0.006545, 0.0059925, 0.005875, 0.0055975, 0.005725, 0.0056025, 0.0046525, 0.00385, 0.0040275, 0.0047975, 0.005465, 0.0049125, 0.0050125, 0.00513, 0.0045125, 0.00431, 0.00451, 0.0046125, 0.0040225, 0.003045, 0.00332, 0.0040525, 0.004545, 0.0048375, 0.0050075, 0.0054125, 0.005, 0.0046175, 0.00399, 0.004165, 0.0050825, 0.004825, 0.003745, 0.0033925, 0.0041275, 0.0045325, 0.00422, 0.0048925, 0.006155, 0.006035, 0.0062275, 0.0062825, 0.005165, 0.004295, 0.00414, 0.0045475, 0.004425, 0.00483, 0.0055525, 0.005645, 0.0062475, 0.006885, 0.005955, 0.0055075, 0.0049875, 0.0043425, 0.004685, 0.00564, 0.0055725, 0.004055, 0.00461, 0.006845, 0.00683, 0.00634, 0.0060125, 0.0051025, 0.005185, 0.00604, 0.00672, 0.0054725, 0.0043775, 0.00484, 0.005145, 0.0048975, 0.00516, 0.0055775, 0.0074475, 0.00871, 0.007825, 0.00705, 0.00607, 0.004565, 0.003475, 0.003475, 0.0047625, 0.00595, 0.006155, 0.0069575, 0.007365, 0.0069, 0.005525, 0.0048225, 0.005035, 0.0055625, 0.004865, 0.00491, 0.005195, 0.006195, 0.0072925, 0.006385, 0.0052575, 0.004495, 0.0046825, 0.0057625, 0.0057275, 0.0050025, 0.0040725, 0.0041275, 0.0055575, 0.005085, 0.0034775, 0.0029, 0.00272, 0.0029325, 0.003185, 0.0030975, 0.002945, 0.0029375, 0.002008, 0.001088, 0.00120975, 0.00155825, 0.00148125, 0.00143025, 0.001415, 0.00107375, 0.0007685, 0.00073725, 0.000867, 0.00095375, 0.00089425, 0.001039, 0.00127175, 0.000965, 0.00062025, 0.000561, 0.000544, 0.00046425, 0.00044475, 0.0004725, 0.0004695, 0.00035175, 0.0003065, 0.0005275, 0.0007195, 0.00065575, 0.00031225, 0.00010145, 8.9975e-05, 0.000233075, 0.00039825, 0.000326, 0.0001308, 4.3375e-05, 5.4725e-05, 0.000167825, 0.000308, 0.000217475, 7.16e-05, 1.97075e-05, 1.727e-05, 5.1575e-05, 0.00011135, 9.215e-05, 3.275e-05, 8.0475e-06, 2.496e-06, 3.66e-06, 1.52275e-05, 4.3275e-05, 5.3075e-05, 2.49625e-05, 7.19e-06, 4.0875e-06, 1.1065e-05, 2.95e-05, 3.4925e-05, 1.63125e-05, 4.3775e-06, 9.735e-07, 2.06775e-07, 6.025e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.655e-07, 5.46e-06, 2.277e-05, 0.0001087, 0.00048875, 0.0020165, 0.006575, 0.0142175, 0.0211125, 0.0288, 0.033575, 0.03365, 0.041875, 0.047175, 0.046725, 0.05055, 0.048775, 0.052975, 0.06535, 0.066475, 0.06485, 0.0557, 0.056225, 0.075925, 0.083125, 0.079925, 0.0784, 0.06445, 0.0724, 0.0874, 0.0864, 0.08355, 0.08275, 0.0952, 0.105525, 0.0935, 0.091425, 0.0797, 0.07295, 0.1003, 0.11675, 0.119225, 0.1207, 0.1018, 0.0938, 0.094925, 0.100525, 0.1117, 0.103475, 0.11275, 0.135575, 0.13025, 0.124325, 0.102625, 0.102375, 0.1344, 0.140925, 0.127125, 0.1075, 0.09955, 0.12525, 0.1367, 0.137125, 0.138625, 0.1367, 0.167525, 0.1678, 0.121475, 0.10655, 0.099075, 0.110175, 0.148825, 0.169575, 0.173675, 0.146125, 0.145525, 0.159025, 0.1532, 0.1538, 0.144675, 0.122975, 0.146225, 0.16635, 0.17325, 0.152525, 0.1325, 0.154825, 0.163875, 0.17175, 0.182325, 0.15385, 0.1669, 0.1819, 0.176175, 0.175575, 0.16105, 0.165825, 0.17515, 0.161825, 0.1394, 0.131075, 0.1756, 0.222175, 0.2114, 0.2064, 0.1993, 0.20105, 0.198125, 0.169525, 0.145575, 0.158, 0.19385, 0.220775, 0.20625, 0.200525, 0.2084, 0.203225, 0.19495, 0.20115, 0.193725, 0.1716, 0.140175, 0.147525, 0.17755, 0.194975, 0.2132, 0.219525, 0.217675, 0.196075, 0.172375, 0.158925, 0.171875, 0.208825, 0.215625, 0.178825, 0.1659, 0.18635, 0.200875, 0.192175, 0.205125, 0.241825, 0.24605, 0.248125, 0.243625, 0.18965, 0.162575, 0.178625, 0.208075, 0.1934, 0.17875, 0.202975, 0.21135, 0.23105, 0.25375, 0.24005, 0.236975, 0.23095, 0.198425, 0.1866, 0.212625, 0.235775, 0.20975, 0.216025, 0.25725, 0.2416, 0.246575, 0.2468, 0.229075, 0.218575, 0.203575, 0.21175, 0.2112, 0.2182, 0.229425, 0.201375, 0.19775, 0.237925, 0.2695, 0.30875, 0.30875, 0.285, 0.26125, 0.239925, 0.2069, 0.171325, 0.19255, 0.23675, 0.2449, 0.2468, 0.2625, 0.295, 0.30175, 0.247575, 0.219225, 0.226725, 0.2428, 0.219475, 0.224775, 0.240825, 0.29325, 0.3555, 0.327, 0.276, 0.239925, 0.24145, 0.27875, 0.2785, 0.246325, 0.198, 0.202125, 0.26525, 0.2545, 0.204575, 0.17515, 0.1849, 0.2257, 0.2389, 0.2111, 0.187875, 0.182575, 0.147325, 0.090525, 0.082375, 0.08445, 0.0785, 0.0907, 0.1072, 0.09255, 0.07125, 0.062275, 0.07305, 0.0932, 0.0861, 0.077075, 0.08285, 0.067325, 0.0472, 0.04215, 0.0467, 0.0485, 0.0483, 0.050975, 0.045575, 0.0369, 0.0327, 0.049625, 0.064775, 0.052875, 0.02363, 0.0081425, 0.0089775, 0.026225, 0.0536, 0.05405, 0.025975, 0.00858, 0.007415, 0.0204425, 0.0394, 0.0321, 0.014185, 0.0050275, 0.00376, 0.01023, 0.0235825, 0.0223725, 0.0089325, 0.00233475, 0.00070425, 0.000956, 0.0034275, 0.0097925, 0.0126675, 0.0064225, 0.0019795, 0.00122325, 0.0033675, 0.0095375, 0.01493, 0.012005, 0.0050325, 0.0013525, 0.00030875, 5.6425e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09438183, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.733e-08, 3.5475e-07, 1.4785e-06, 7.055e-06, 3.17e-05, 0.0001308, 0.000426, 0.00091925, 0.00135975, 0.00184525, 0.00214375, 0.0021355, 0.00264, 0.00296, 0.002915, 0.0031375, 0.00301, 0.0032475, 0.003985, 0.0040325, 0.0039125, 0.0033425, 0.003345, 0.0044925, 0.004895, 0.00468, 0.0045675, 0.00373, 0.0041575, 0.0049925, 0.0049075, 0.004715, 0.00464, 0.0053, 0.00585, 0.0051525, 0.005005, 0.00434, 0.003935, 0.0053725, 0.0062225, 0.0063125, 0.006355, 0.00533, 0.004875, 0.0048975, 0.0051525, 0.00569, 0.005235, 0.00565, 0.006755, 0.00645, 0.0061175, 0.0050175, 0.0049525, 0.00646, 0.006745, 0.00605, 0.0050825, 0.00465, 0.005795, 0.0062825, 0.006255, 0.00628, 0.0061475, 0.0074775, 0.0074475, 0.00535, 0.00465, 0.0042925, 0.00472, 0.006325, 0.00715, 0.0072575, 0.006045, 0.005945, 0.00645, 0.0061675, 0.0061325, 0.00573, 0.00482, 0.00568, 0.0064125, 0.00661, 0.005755, 0.0049025, 0.005625, 0.0058675, 0.00604, 0.0063575, 0.005315, 0.0056825, 0.00614, 0.0059125, 0.0059, 0.0054525, 0.0055675, 0.0057825, 0.0052025, 0.0044375, 0.0041175, 0.005325, 0.0066675, 0.00625, 0.0061, 0.005855, 0.0058475, 0.00579, 0.00486, 0.0039775, 0.004025, 0.00477, 0.005555, 0.0051025, 0.0051175, 0.0051875, 0.0046125, 0.00439, 0.0046675, 0.00474, 0.004135, 0.0030525, 0.00317, 0.0040025, 0.0046275, 0.0050275, 0.0052, 0.0055675, 0.005265, 0.0047175, 0.0041175, 0.00424, 0.005045, 0.0049975, 0.0040475, 0.0035475, 0.0042075, 0.004865, 0.00482, 0.00552, 0.006465, 0.0060525, 0.00636, 0.00666, 0.0054275, 0.0043225, 0.0041325, 0.004965, 0.0050875, 0.0050775, 0.005515, 0.00546, 0.0061575, 0.0067275, 0.0060275, 0.0056375, 0.0051325, 0.00474, 0.0053175, 0.006015, 0.0056825, 0.0046975, 0.00558, 0.0067825, 0.00605, 0.00611, 0.006055, 0.005725, 0.006115, 0.0062325, 0.00599, 0.0049075, 0.004815, 0.0054225, 0.00477, 0.0044625, 0.0053375, 0.00651, 0.00828, 0.00847, 0.0075875, 0.00653, 0.00532, 0.00448, 0.00366, 0.0040375, 0.0054675, 0.006055, 0.0062725, 0.006795, 0.0071025, 0.006565, 0.0051475, 0.00487, 0.005225, 0.00535, 0.00471, 0.00494, 0.0052775, 0.006385, 0.00742, 0.0065, 0.005165, 0.004345, 0.004755, 0.0056925, 0.0055875, 0.005, 0.0041225, 0.0042275, 0.0053575, 0.00469, 0.0033725, 0.002825, 0.002765, 0.003035, 0.0032325, 0.0031425, 0.002975, 0.00291, 0.0021835, 0.0012825, 0.001263, 0.001361, 0.00124625, 0.0013495, 0.001523, 0.001251, 0.000897, 0.00079325, 0.00085575, 0.0010345, 0.00103775, 0.0010855, 0.00122475, 0.0009605, 0.000653, 0.00052975, 0.00052375, 0.00051725, 0.00051175, 0.00054475, 0.0005065, 0.000404, 0.0003255, 0.00052775, 0.000739, 0.0006345, 0.0002905, 9.4925e-05, 8.3025e-05, 0.000224325, 0.00044025, 0.000421, 0.00019515, 6.365e-05, 5.4925e-05, 0.00015055, 0.000284, 0.00021235, 7.3675e-05, 2.09025e-05, 1.73675e-05, 5.0725e-05, 0.00011825, 0.0001123, 4.4825e-05, 1.164e-05, 3.175e-06, 3.1825e-06, 1.064e-05, 3.04e-05, 3.93e-05, 1.99225e-05, 6.1175e-06, 3.6725e-06, 9.7625e-06, 2.5475e-05, 3.0925e-05, 1.60325e-05, 4.8675e-06, 1.16175e-06, 2.5725e-07, 1.77825e-08, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09438183, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.733e-08, 3.5475e-07, 1.4785e-06, 7.055e-06, 3.17e-05, 0.0001308, 0.000426, 0.00091925, 0.00135975, 0.00184525, 0.00214375, 0.0021355, 0.00264, 0.00296, 0.002915, 0.0031375, 0.00301, 0.0032475, 0.003985, 0.0040325, 0.0039125, 0.0033425, 0.003345, 0.0044925, 0.004895, 0.00468, 0.0045675, 0.00373, 0.0041575, 0.0049925, 0.0049075, 0.004715, 0.00464, 0.0053, 0.00585, 0.0051525, 0.005005, 0.00434, 0.003935, 0.0053725, 0.0062225, 0.0063125, 0.006355, 0.00533, 0.004875, 0.0048975, 0.0051525, 0.00569, 0.005235, 0.00565, 0.006755, 0.00645, 0.0061175, 0.0050175, 0.0049525, 0.00646, 0.006745, 0.00605, 0.0050825, 0.00465, 0.005795, 0.0062825, 0.006255, 0.00628, 0.0061475, 0.0074775, 0.0074475, 0.00535, 0.00465, 0.0042925, 0.00472, 0.006325, 0.00715, 0.0072575, 0.006045, 0.005945, 0.00645, 0.0061675, 0.0061325, 0.00573, 0.00482, 0.00568, 0.0064125, 0.00661, 0.005755, 0.0049025, 0.005625, 0.0058675, 0.00604, 0.0063575, 0.005315, 0.0056825, 0.00614, 0.0059125, 0.0059, 0.0054525, 0.0055675, 0.0057825, 0.0052025, 0.0044375, 0.0041175, 0.005325, 0.0066675, 0.00625, 0.0061, 0.005855, 0.0058475, 0.00579, 0.00486, 0.0039775, 0.004025, 0.00477, 0.005555, 0.0051025, 0.0051175, 0.0051875, 0.0046125, 0.00439, 0.0046675, 0.00474, 0.004135, 0.0030525, 0.00317, 0.0040025, 0.0046275, 0.0050275, 0.0052, 0.0055675, 0.005265, 0.0047175, 0.0041175, 0.00424, 0.005045, 0.0049975, 0.0040475, 0.0035475, 0.0042075, 0.004865, 0.00482, 0.00552, 0.006465, 0.0060525, 0.00636, 0.00666, 0.0054275, 0.0043225, 0.0041325, 0.004965, 0.0050875, 0.0050775, 0.005515, 0.00546, 0.0061575, 0.0067275, 0.0060275, 0.0056375, 0.0051325, 0.00474, 0.0053175, 0.006015, 0.0056825, 0.0046975, 0.00558, 0.0067825, 0.00605, 0.00611, 0.006055, 0.005725, 0.006115, 0.0062325, 0.00599, 0.0049075, 0.004815, 0.0054225, 0.00477, 0.0044625, 0.0053375, 0.00651, 0.00828, 0.00847, 0.0075875, 0.00653, 0.00532, 0.00448, 0.00366, 0.0040375, 0.0054675, 0.006055, 0.0062725, 0.006795, 0.0071025, 0.006565, 0.0051475, 0.00487, 0.005225, 0.00535, 0.00471, 0.00494, 0.0052775, 0.006385, 0.00742, 0.0065, 0.005165, 0.004345, 0.004755, 0.0056925, 0.0055875, 0.005, 0.0041225, 0.0042275, 0.0053575, 0.00469, 0.0033725, 0.002825, 0.002765, 0.003035, 0.0032325, 0.0031425, 0.002975, 0.00291, 0.0021835, 0.0012825, 0.001263, 0.001361, 0.00124625, 0.0013495, 0.001523, 0.001251, 0.000897, 0.00079325, 0.00085575, 0.0010345, 0.00103775, 0.0010855, 0.00122475, 0.0009605, 0.000653, 0.00052975, 0.00052375, 0.00051725, 0.00051175, 0.00054475, 0.0005065, 0.000404, 0.0003255, 0.00052775, 0.000739, 0.0006345, 0.0002905, 9.4925e-05, 8.3025e-05, 0.000224325, 0.00044025, 0.000421, 0.00019515, 6.365e-05, 5.4925e-05, 0.00015055, 0.000284, 0.00021235, 7.3675e-05, 2.09025e-05, 1.73675e-05, 5.0725e-05, 0.00011825, 0.0001123, 4.4825e-05, 1.164e-05, 3.175e-06, 3.1825e-06, 1.064e-05, 3.04e-05, 3.93e-05, 1.99225e-05, 6.1175e-06, 3.6725e-06, 9.7625e-06, 2.5475e-05, 3.0925e-05, 1.60325e-05, 4.8675e-06, 1.16175e-06, 2.5725e-07, 1.77825e-08, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09438183, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.733e-08, 3.5475e-07, 1.4785e-06, 7.055e-06, 3.17e-05, 0.0001308, 0.000426, 0.00091925, 0.00135975, 0.00184525, 0.00214375, 0.0021355, 0.00264, 0.00296, 0.002915, 0.0031375, 0.00301, 0.0032475, 0.003985, 0.0040325, 0.0039125, 0.0033425, 0.003345, 0.0044925, 0.004895, 0.00468, 0.0045675, 0.00373, 0.0041575, 0.0049925, 0.0049075, 0.004715, 0.00464, 0.0053, 0.00585, 0.0051525, 0.005005, 0.00434, 0.003935, 0.0053725, 0.0062225, 0.0063125, 0.006355, 0.00533, 0.004875, 0.0048975, 0.0051525, 0.00569, 0.005235, 0.00565, 0.006755, 0.00645, 0.0061175, 0.0050175, 0.0049525, 0.00646, 0.006745, 0.00605, 0.0050825, 0.00465, 0.005795, 0.0062825, 0.006255, 0.00628, 0.0061475, 0.0074775, 0.0074475, 0.00535, 0.00465, 0.0042925, 0.00472, 0.006325, 0.00715, 0.0072575, 0.006045, 0.005945, 0.00645, 0.0061675, 0.0061325, 0.00573, 0.00482, 0.00568, 0.0064125, 0.00661, 0.005755, 0.0049025, 0.005625, 0.0058675, 0.00604, 0.0063575, 0.005315, 0.0056825, 0.00614, 0.0059125, 0.0059, 0.0054525, 0.0055675, 0.0057825, 0.0052025, 0.0044375, 0.0041175, 0.005325, 0.0066675, 0.00625, 0.0061, 0.005855, 0.0058475, 0.00579, 0.00486, 0.0039775, 0.004025, 0.00477, 0.005555, 0.0051025, 0.0051175, 0.0051875, 0.0046125, 0.00439, 0.0046675, 0.00474, 0.004135, 0.0030525, 0.00317, 0.0040025, 0.0046275, 0.0050275, 0.0052, 0.0055675, 0.005265, 0.0047175, 0.0041175, 0.00424, 0.005045, 0.0049975, 0.0040475, 0.0035475, 0.0042075, 0.004865, 0.00482, 0.00552, 0.006465, 0.0060525, 0.00636, 0.00666, 0.0054275, 0.0043225, 0.0041325, 0.004965, 0.0050875, 0.0050775, 0.005515, 0.00546, 0.0061575, 0.0067275, 0.0060275, 0.0056375, 0.0051325, 0.00474, 0.0053175, 0.006015, 0.0056825, 0.0046975, 0.00558, 0.0067825, 0.00605, 0.00611, 0.006055, 0.005725, 0.006115, 0.0062325, 0.00599, 0.0049075, 0.004815, 0.0054225, 0.00477, 0.0044625, 0.0053375, 0.00651, 0.00828, 0.00847, 0.0075875, 0.00653, 0.00532, 0.00448, 0.00366, 0.0040375, 0.0054675, 0.006055, 0.0062725, 0.006795, 0.0071025, 0.006565, 0.0051475, 0.00487, 0.005225, 0.00535, 0.00471, 0.00494, 0.0052775, 0.006385, 0.00742, 0.0065, 0.005165, 0.004345, 0.004755, 0.0056925, 0.0055875, 0.005, 0.0041225, 0.0042275, 0.0053575, 0.00469, 0.0033725, 0.002825, 0.002765, 0.003035, 0.0032325, 0.0031425, 0.002975, 0.00291, 0.0021835, 0.0012825, 0.001263, 0.001361, 0.00124625, 0.0013495, 0.001523, 0.001251, 0.000897, 0.00079325, 0.00085575, 0.0010345, 0.00103775, 0.0010855, 0.00122475, 0.0009605, 0.000653, 0.00052975, 0.00052375, 0.00051725, 0.00051175, 0.00054475, 0.0005065, 0.000404, 0.0003255, 0.00052775, 0.000739, 0.0006345, 0.0002905, 9.4925e-05, 8.3025e-05, 0.000224325, 0.00044025, 0.000421, 0.00019515, 6.365e-05, 5.4925e-05, 0.00015055, 0.000284, 0.00021235, 7.3675e-05, 2.09025e-05, 1.73675e-05, 5.0725e-05, 0.00011825, 0.0001123, 4.4825e-05, 1.164e-05, 3.175e-06, 3.1825e-06, 1.064e-05, 3.04e-05, 3.93e-05, 1.99225e-05, 6.1175e-06, 3.6725e-06, 9.7625e-06, 2.5475e-05, 3.0925e-05, 1.60325e-05, 4.8675e-06, 1.16175e-06, 2.5725e-07, 1.77825e-08, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.09438183, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.733e-08, 3.5475e-07, 1.4785e-06, 7.055e-06, 3.17e-05, 0.0001308, 0.000426, 0.00091925, 0.00135975, 0.00184525, 0.00214375, 0.0021355, 0.00264, 0.00296, 0.002915, 0.0031375, 0.00301, 0.0032475, 0.003985, 0.0040325, 0.0039125, 0.0033425, 0.003345, 0.0044925, 0.004895, 0.00468, 0.0045675, 0.00373, 0.0041575, 0.0049925, 0.0049075, 0.004715, 0.00464, 0.0053, 0.00585, 0.0051525, 0.005005, 0.00434, 0.003935, 0.0053725, 0.0062225, 0.0063125, 0.006355, 0.00533, 0.004875, 0.0048975, 0.0051525, 0.00569, 0.005235, 0.00565, 0.006755, 0.00645, 0.0061175, 0.0050175, 0.0049525, 0.00646, 0.006745, 0.00605, 0.0050825, 0.00465, 0.005795, 0.0062825, 0.006255, 0.00628, 0.0061475, 0.0074775, 0.0074475, 0.00535, 0.00465, 0.0042925, 0.00472, 0.006325, 0.00715, 0.0072575, 0.006045, 0.005945, 0.00645, 0.0061675, 0.0061325, 0.00573, 0.00482, 0.00568, 0.0064125, 0.00661, 0.005755, 0.0049025, 0.005625, 0.0058675, 0.00604, 0.0063575, 0.005315, 0.0056825, 0.00614, 0.0059125, 0.0059, 0.0054525, 0.0055675, 0.0057825, 0.0052025, 0.0044375, 0.0041175, 0.005325, 0.0066675, 0.00625, 0.0061, 0.005855, 0.0058475, 0.00579, 0.00486, 0.0039775, 0.004025, 0.00477, 0.005555, 0.0051025, 0.0051175, 0.0051875, 0.0046125, 0.00439, 0.0046675, 0.00474, 0.004135, 0.0030525, 0.00317, 0.0040025, 0.0046275, 0.0050275, 0.0052, 0.0055675, 0.005265, 0.0047175, 0.0041175, 0.00424, 0.005045, 0.0049975, 0.0040475, 0.0035475, 0.0042075, 0.004865, 0.00482, 0.00552, 0.006465, 0.0060525, 0.00636, 0.00666, 0.0054275, 0.0043225, 0.0041325, 0.004965, 0.0050875, 0.0050775, 0.005515, 0.00546, 0.0061575, 0.0067275, 0.0060275, 0.0056375, 0.0051325, 0.00474, 0.0053175, 0.006015, 0.0056825, 0.0046975, 0.00558, 0.0067825, 0.00605, 0.00611, 0.006055, 0.005725, 0.006115, 0.0062325, 0.00599, 0.0049075, 0.004815, 0.0054225, 0.00477, 0.0044625, 0.0053375, 0.00651, 0.00828, 0.00847, 0.0075875, 0.00653, 0.00532, 0.00448, 0.00366, 0.0040375, 0.0054675, 0.006055, 0.0062725, 0.006795, 0.0071025, 0.006565, 0.0051475, 0.00487, 0.005225, 0.00535, 0.00471, 0.00494, 0.0052775, 0.006385, 0.00742, 0.0065, 0.005165, 0.004345, 0.004755, 0.0056925, 0.0055875, 0.005, 0.0041225, 0.0042275, 0.0053575, 0.00469, 0.0033725, 0.002825, 0.002765, 0.003035, 0.0032325, 0.0031425, 0.002975, 0.00291, 0.0021835, 0.0012825, 0.001263, 0.001361, 0.00124625, 0.0013495, 0.001523, 0.001251, 0.000897, 0.00079325, 0.00085575, 0.0010345, 0.00103775, 0.0010855, 0.00122475, 0.0009605, 0.000653, 0.00052975, 0.00052375, 0.00051725, 0.00051175, 0.00054475, 0.0005065, 0.000404, 0.0003255, 0.00052775, 0.000739, 0.0006345, 0.0002905, 9.4925e-05, 8.3025e-05, 0.000224325, 0.00044025, 0.000421, 0.00019515, 6.365e-05, 5.4925e-05, 0.00015055, 0.000284, 0.00021235, 7.3675e-05, 2.09025e-05, 1.73675e-05, 5.0725e-05, 0.00011825, 0.0001123, 4.4825e-05, 1.164e-05, 3.175e-06, 3.1825e-06, 1.064e-05, 3.04e-05, 3.93e-05, 1.99225e-05, 6.1175e-06, 3.6725e-06, 9.7625e-06, 2.5475e-05, 3.0925e-05, 1.60325e-05, 4.8675e-06, 1.16175e-06, 2.5725e-07, 1.77825e-08, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.02275e-06, 5.85e-06, 2.64e-05, 0.00012255, 0.00053375, 0.00213375, 0.00678, 0.01448, 0.0215275, 0.029275, 0.034125, 0.034475, 0.0426, 0.04795, 0.0477, 0.05145, 0.049875, 0.05415, 0.0663, 0.0677, 0.065975, 0.0571, 0.057575, 0.076975, 0.0845, 0.08155, 0.0798, 0.066325, 0.07365, 0.08865, 0.088075, 0.085275, 0.084575, 0.096625, 0.10715, 0.095725, 0.093, 0.0818, 0.07475, 0.1012, 0.1185, 0.121325, 0.12285, 0.104575, 0.095825, 0.096775, 0.1022, 0.113325, 0.1062, 0.114025, 0.137175, 0.13295, 0.126875, 0.106025, 0.103825, 0.13495, 0.143675, 0.130075, 0.110975, 0.1013, 0.12575, 0.138775, 0.139525, 0.141275, 0.139225, 0.167525, 0.172275, 0.127, 0.109225, 0.10195, 0.11055, 0.1483, 0.17105, 0.17695, 0.1515, 0.146825, 0.1613, 0.156725, 0.15585, 0.149575, 0.126225, 0.14565, 0.1676, 0.17575, 0.1587, 0.135325, 0.153975, 0.16675, 0.171675, 0.186425, 0.15985, 0.1659, 0.1844, 0.180225, 0.1795, 0.16695, 0.16635, 0.177525, 0.1667, 0.1465, 0.132, 0.16745, 0.22085, 0.218275, 0.2103, 0.205025, 0.202975, 0.2047, 0.177975, 0.149875, 0.153775, 0.187775, 0.2225, 0.213975, 0.206, 0.20855, 0.205, 0.200075, 0.20545, 0.20375, 0.18, 0.14595, 0.1451, 0.175625, 0.197775, 0.212875, 0.22365, 0.227625, 0.20825, 0.17975, 0.1621, 0.167425, 0.202175, 0.22015, 0.190525, 0.165725, 0.1855, 0.210125, 0.204925, 0.20845, 0.23185, 0.248325, 0.25825, 0.25625, 0.204875, 0.162025, 0.170975, 0.211275, 0.2115, 0.1888, 0.197875, 0.212525, 0.232125, 0.25175, 0.244975, 0.234025, 0.23335, 0.22335, 0.20515, 0.20165, 0.22675, 0.226775, 0.222625, 0.25075, 0.2497, 0.25175, 0.25425, 0.24225, 0.2352, 0.21345, 0.1991, 0.207575, 0.220075, 0.231025, 0.211075, 0.1997, 0.2386, 0.2875, 0.3195, 0.3125, 0.2885, 0.254, 0.239325, 0.2229, 0.184, 0.19385, 0.240425, 0.25875, 0.2605, 0.2645, 0.28275, 0.29075, 0.265, 0.24075, 0.23035, 0.235775, 0.2299, 0.231175, 0.247425, 0.29375, 0.34925, 0.3315, 0.2795, 0.2555, 0.2595, 0.28125, 0.28025, 0.26125, 0.2143, 0.2083, 0.26475, 0.25575, 0.207, 0.17875, 0.1781, 0.21355, 0.24785, 0.234575, 0.197425, 0.180825, 0.1568, 0.1039, 0.08695, 0.087725, 0.077725, 0.086575, 0.106525, 0.099075, 0.075975, 0.06485, 0.068825, 0.0906, 0.0935, 0.0804, 0.084725, 0.07185, 0.051575, 0.042175, 0.0447, 0.049125, 0.049475, 0.0549, 0.0505, 0.03875, 0.0313, 0.0464, 0.065825, 0.05755, 0.02765, 0.009435, 0.0079575, 0.021925, 0.0495, 0.05775, 0.032375, 0.0112575, 0.0074375, 0.01826, 0.03795, 0.0352, 0.0167775, 0.006065, 0.0037925, 0.0092825, 0.0222425, 0.0239475, 0.01076, 0.0029975, 0.00085525, 0.000857, 0.0028325, 0.0086125, 0.01304, 0.00785, 0.0026425, 0.001458, 0.0035175, 0.009585, 0.014985, 0.0122525, 0.005285, 0.00147075, 0.000347, 6.4925e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1128346125, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.545e-08, 3.7375e-07, 1.6855e-06, 7.82e-06, 3.405e-05, 0.0001361, 0.000432, 0.00092075, 0.001364, 0.00184625, 0.002144, 0.0021535, 0.002645, 0.0029625, 0.0029325, 0.003145, 0.003035, 0.00327, 0.003985, 0.00405, 0.003925, 0.00338, 0.0033825, 0.0044925, 0.0049125, 0.004715, 0.00459, 0.0037925, 0.0041775, 0.005005, 0.0049475, 0.00476, 0.00469, 0.0053225, 0.0058775, 0.0052225, 0.0050425, 0.0044125, 0.003995, 0.0053725, 0.00626, 0.00637, 0.006415, 0.0054325, 0.004945, 0.0049575, 0.0052025, 0.005735, 0.00534, 0.0056825, 0.0067975, 0.00655, 0.006215, 0.0051625, 0.0050075, 0.006465, 0.0068575, 0.0061775, 0.0052375, 0.0047275, 0.005815, 0.0063725, 0.0063625, 0.0064025, 0.00627, 0.0074925, 0.0076625, 0.00561, 0.004785, 0.0044375, 0.004765, 0.0063425, 0.00726, 0.0074475, 0.006315, 0.00605, 0.0066, 0.006375, 0.006295, 0.00601, 0.005025, 0.00575, 0.0065825, 0.00683, 0.0061, 0.0051375, 0.00579, 0.006215, 0.0063, 0.0067575, 0.005745, 0.005895, 0.006495, 0.0063075, 0.0062325, 0.0057425, 0.0056425, 0.0059475, 0.0055175, 0.0047725, 0.0041825, 0.0051475, 0.0067325, 0.0065625, 0.0063225, 0.0061225, 0.00595, 0.006, 0.0051425, 0.004165, 0.004035, 0.0046875, 0.005615, 0.00533, 0.0052125, 0.0052675, 0.0047325, 0.004495, 0.00479, 0.0048875, 0.0042975, 0.0031275, 0.00302, 0.0038875, 0.00471, 0.005245, 0.005405, 0.005705, 0.0055575, 0.0048325, 0.004305, 0.004345, 0.0049475, 0.0051275, 0.00441, 0.0037925, 0.00436, 0.00529, 0.0055825, 0.0059575, 0.006285, 0.006175, 0.0067375, 0.00694, 0.0056175, 0.0044225, 0.00426, 0.0052975, 0.00569, 0.0053625, 0.0054, 0.0052875, 0.00596, 0.00655, 0.0061925, 0.005795, 0.0053775, 0.0053625, 0.0058625, 0.0060025, 0.0061425, 0.0057575, 0.0055625, 0.0061225, 0.005805, 0.00615, 0.0063325, 0.0062575, 0.0063825, 0.0059825, 0.005535, 0.0053275, 0.005295, 0.0050975, 0.0045175, 0.0044875, 0.005605, 0.0071775, 0.00842, 0.0080875, 0.0074575, 0.00601, 0.005095, 0.0047675, 0.0041475, 0.004545, 0.0054275, 0.00602, 0.0064375, 0.0065575, 0.0067325, 0.006185, 0.005095, 0.005085, 0.0051925, 0.0050625, 0.0047425, 0.00503, 0.0054425, 0.006485, 0.0074975, 0.0065175, 0.004935, 0.004355, 0.004835, 0.0056025, 0.005465, 0.00509, 0.004265, 0.00411, 0.0050375, 0.0044875, 0.0033125, 0.00274, 0.0027425, 0.0030975, 0.0033575, 0.0032775, 0.0029725, 0.0028475, 0.00236375, 0.001472, 0.00123375, 0.00119625, 0.001098, 0.00128375, 0.00157225, 0.001407, 0.00100825, 0.0008405, 0.00082025, 0.0010095, 0.00111175, 0.00108425, 0.00121125, 0.0010115, 0.00071125, 0.000545, 0.000542, 0.000584, 0.00058375, 0.000631, 0.00056175, 0.00040925, 0.00030225, 0.00048175, 0.000712, 0.00062775, 0.00030425, 0.0001026, 7.94e-05, 0.000208625, 0.00045025, 0.00048875, 0.000259, 8.7025e-05, 5.2925e-05, 0.000123625, 0.000249975, 0.0002151, 8.335e-05, 2.46175e-05, 1.839e-05, 5.185e-05, 0.000125825, 0.000135675, 6.095e-05, 1.6925e-05, 4.5725e-06, 3.66e-06, 1.121e-05, 3.4075e-05, 5.1575e-05, 3.1025e-05, 1.02975e-05, 5.0825e-06, 1.09975e-05, 2.7175e-05, 3.275e-05, 1.73175e-05, 5.42e-06, 1.338e-06, 3.0575e-07, 1.9885e-08, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1128346125, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.545e-08, 3.7375e-07, 1.6855e-06, 7.82e-06, 3.405e-05, 0.0001361, 0.000432, 0.00092075, 0.001364, 0.00184625, 0.002144, 0.0021535, 0.002645, 0.0029625, 0.0029325, 0.003145, 0.003035, 0.00327, 0.003985, 0.00405, 0.003925, 0.00338, 0.0033825, 0.0044925, 0.0049125, 0.004715, 0.00459, 0.0037925, 0.0041775, 0.005005, 0.0049475, 0.00476, 0.00469, 0.0053225, 0.0058775, 0.0052225, 0.0050425, 0.0044125, 0.003995, 0.0053725, 0.00626, 0.00637, 0.006415, 0.0054325, 0.004945, 0.0049575, 0.0052025, 0.005735, 0.00534, 0.0056825, 0.0067975, 0.00655, 0.006215, 0.0051625, 0.0050075, 0.006465, 0.0068575, 0.0061775, 0.0052375, 0.0047275, 0.005815, 0.0063725, 0.0063625, 0.0064025, 0.00627, 0.0074925, 0.0076625, 0.00561, 0.004785, 0.0044375, 0.004765, 0.0063425, 0.00726, 0.0074475, 0.006315, 0.00605, 0.0066, 0.006375, 0.006295, 0.00601, 0.005025, 0.00575, 0.0065825, 0.00683, 0.0061, 0.0051375, 0.00579, 0.006215, 0.0063, 0.0067575, 0.005745, 0.005895, 0.006495, 0.0063075, 0.0062325, 0.0057425, 0.0056425, 0.0059475, 0.0055175, 0.0047725, 0.0041825, 0.0051475, 0.0067325, 0.0065625, 0.0063225, 0.0061225, 0.00595, 0.006, 0.0051425, 0.004165, 0.004035, 0.0046875, 0.005615, 0.00533, 0.0052125, 0.0052675, 0.0047325, 0.004495, 0.00479, 0.0048875, 0.0042975, 0.0031275, 0.00302, 0.0038875, 0.00471, 0.005245, 0.005405, 0.005705, 0.0055575, 0.0048325, 0.004305, 0.004345, 0.0049475, 0.0051275, 0.00441, 0.0037925, 0.00436, 0.00529, 0.0055825, 0.0059575, 0.006285, 0.006175, 0.0067375, 0.00694, 0.0056175, 0.0044225, 0.00426, 0.0052975, 0.00569, 0.0053625, 0.0054, 0.0052875, 0.00596, 0.00655, 0.0061925, 0.005795, 0.0053775, 0.0053625, 0.0058625, 0.0060025, 0.0061425, 0.0057575, 0.0055625, 0.0061225, 0.005805, 0.00615, 0.0063325, 0.0062575, 0.0063825, 0.0059825, 0.005535, 0.0053275, 0.005295, 0.0050975, 0.0045175, 0.0044875, 0.005605, 0.0071775, 0.00842, 0.0080875, 0.0074575, 0.00601, 0.005095, 0.0047675, 0.0041475, 0.004545, 0.0054275, 0.00602, 0.0064375, 0.0065575, 0.0067325, 0.006185, 0.005095, 0.005085, 0.0051925, 0.0050625, 0.0047425, 0.00503, 0.0054425, 0.006485, 0.0074975, 0.0065175, 0.004935, 0.004355, 0.004835, 0.0056025, 0.005465, 0.00509, 0.004265, 0.00411, 0.0050375, 0.0044875, 0.0033125, 0.00274, 0.0027425, 0.0030975, 0.0033575, 0.0032775, 0.0029725, 0.0028475, 0.00236375, 0.001472, 0.00123375, 0.00119625, 0.001098, 0.00128375, 0.00157225, 0.001407, 0.00100825, 0.0008405, 0.00082025, 0.0010095, 0.00111175, 0.00108425, 0.00121125, 0.0010115, 0.00071125, 0.000545, 0.000542, 0.000584, 0.00058375, 0.000631, 0.00056175, 0.00040925, 0.00030225, 0.00048175, 0.000712, 0.00062775, 0.00030425, 0.0001026, 7.94e-05, 0.000208625, 0.00045025, 0.00048875, 0.000259, 8.7025e-05, 5.2925e-05, 0.000123625, 0.000249975, 0.0002151, 8.335e-05, 2.46175e-05, 1.839e-05, 5.185e-05, 0.000125825, 0.000135675, 6.095e-05, 1.6925e-05, 4.5725e-06, 3.66e-06, 1.121e-05, 3.4075e-05, 5.1575e-05, 3.1025e-05, 1.02975e-05, 5.0825e-06, 1.09975e-05, 2.7175e-05, 3.275e-05, 1.73175e-05, 5.42e-06, 1.338e-06, 3.0575e-07, 1.9885e-08, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1128346125, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.545e-08, 3.7375e-07, 1.6855e-06, 7.82e-06, 3.405e-05, 0.0001361, 0.000432, 0.00092075, 0.001364, 0.00184625, 0.002144, 0.0021535, 0.002645, 0.0029625, 0.0029325, 0.003145, 0.003035, 0.00327, 0.003985, 0.00405, 0.003925, 0.00338, 0.0033825, 0.0044925, 0.0049125, 0.004715, 0.00459, 0.0037925, 0.0041775, 0.005005, 0.0049475, 0.00476, 0.00469, 0.0053225, 0.0058775, 0.0052225, 0.0050425, 0.0044125, 0.003995, 0.0053725, 0.00626, 0.00637, 0.006415, 0.0054325, 0.004945, 0.0049575, 0.0052025, 0.005735, 0.00534, 0.0056825, 0.0067975, 0.00655, 0.006215, 0.0051625, 0.0050075, 0.006465, 0.0068575, 0.0061775, 0.0052375, 0.0047275, 0.005815, 0.0063725, 0.0063625, 0.0064025, 0.00627, 0.0074925, 0.0076625, 0.00561, 0.004785, 0.0044375, 0.004765, 0.0063425, 0.00726, 0.0074475, 0.006315, 0.00605, 0.0066, 0.006375, 0.006295, 0.00601, 0.005025, 0.00575, 0.0065825, 0.00683, 0.0061, 0.0051375, 0.00579, 0.006215, 0.0063, 0.0067575, 0.005745, 0.005895, 0.006495, 0.0063075, 0.0062325, 0.0057425, 0.0056425, 0.0059475, 0.0055175, 0.0047725, 0.0041825, 0.0051475, 0.0067325, 0.0065625, 0.0063225, 0.0061225, 0.00595, 0.006, 0.0051425, 0.004165, 0.004035, 0.0046875, 0.005615, 0.00533, 0.0052125, 0.0052675, 0.0047325, 0.004495, 0.00479, 0.0048875, 0.0042975, 0.0031275, 0.00302, 0.0038875, 0.00471, 0.005245, 0.005405, 0.005705, 0.0055575, 0.0048325, 0.004305, 0.004345, 0.0049475, 0.0051275, 0.00441, 0.0037925, 0.00436, 0.00529, 0.0055825, 0.0059575, 0.006285, 0.006175, 0.0067375, 0.00694, 0.0056175, 0.0044225, 0.00426, 0.0052975, 0.00569, 0.0053625, 0.0054, 0.0052875, 0.00596, 0.00655, 0.0061925, 0.005795, 0.0053775, 0.0053625, 0.0058625, 0.0060025, 0.0061425, 0.0057575, 0.0055625, 0.0061225, 0.005805, 0.00615, 0.0063325, 0.0062575, 0.0063825, 0.0059825, 0.005535, 0.0053275, 0.005295, 0.0050975, 0.0045175, 0.0044875, 0.005605, 0.0071775, 0.00842, 0.0080875, 0.0074575, 0.00601, 0.005095, 0.0047675, 0.0041475, 0.004545, 0.0054275, 0.00602, 0.0064375, 0.0065575, 0.0067325, 0.006185, 0.005095, 0.005085, 0.0051925, 0.0050625, 0.0047425, 0.00503, 0.0054425, 0.006485, 0.0074975, 0.0065175, 0.004935, 0.004355, 0.004835, 0.0056025, 0.005465, 0.00509, 0.004265, 0.00411, 0.0050375, 0.0044875, 0.0033125, 0.00274, 0.0027425, 0.0030975, 0.0033575, 0.0032775, 0.0029725, 0.0028475, 0.00236375, 0.001472, 0.00123375, 0.00119625, 0.001098, 0.00128375, 0.00157225, 0.001407, 0.00100825, 0.0008405, 0.00082025, 0.0010095, 0.00111175, 0.00108425, 0.00121125, 0.0010115, 0.00071125, 0.000545, 0.000542, 0.000584, 0.00058375, 0.000631, 0.00056175, 0.00040925, 0.00030225, 0.00048175, 0.000712, 0.00062775, 0.00030425, 0.0001026, 7.94e-05, 0.000208625, 0.00045025, 0.00048875, 0.000259, 8.7025e-05, 5.2925e-05, 0.000123625, 0.000249975, 0.0002151, 8.335e-05, 2.46175e-05, 1.839e-05, 5.185e-05, 0.000125825, 0.000135675, 6.095e-05, 1.6925e-05, 4.5725e-06, 3.66e-06, 1.121e-05, 3.4075e-05, 5.1575e-05, 3.1025e-05, 1.02975e-05, 5.0825e-06, 1.09975e-05, 2.7175e-05, 3.275e-05, 1.73175e-05, 5.42e-06, 1.338e-06, 3.0575e-07, 1.9885e-08, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1128346125, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.545e-08, 3.7375e-07, 1.6855e-06, 7.82e-06, 3.405e-05, 0.0001361, 0.000432, 0.00092075, 0.001364, 0.00184625, 0.002144, 0.0021535, 0.002645, 0.0029625, 0.0029325, 0.003145, 0.003035, 0.00327, 0.003985, 0.00405, 0.003925, 0.00338, 0.0033825, 0.0044925, 0.0049125, 0.004715, 0.00459, 0.0037925, 0.0041775, 0.005005, 0.0049475, 0.00476, 0.00469, 0.0053225, 0.0058775, 0.0052225, 0.0050425, 0.0044125, 0.003995, 0.0053725, 0.00626, 0.00637, 0.006415, 0.0054325, 0.004945, 0.0049575, 0.0052025, 0.005735, 0.00534, 0.0056825, 0.0067975, 0.00655, 0.006215, 0.0051625, 0.0050075, 0.006465, 0.0068575, 0.0061775, 0.0052375, 0.0047275, 0.005815, 0.0063725, 0.0063625, 0.0064025, 0.00627, 0.0074925, 0.0076625, 0.00561, 0.004785, 0.0044375, 0.004765, 0.0063425, 0.00726, 0.0074475, 0.006315, 0.00605, 0.0066, 0.006375, 0.006295, 0.00601, 0.005025, 0.00575, 0.0065825, 0.00683, 0.0061, 0.0051375, 0.00579, 0.006215, 0.0063, 0.0067575, 0.005745, 0.005895, 0.006495, 0.0063075, 0.0062325, 0.0057425, 0.0056425, 0.0059475, 0.0055175, 0.0047725, 0.0041825, 0.0051475, 0.0067325, 0.0065625, 0.0063225, 0.0061225, 0.00595, 0.006, 0.0051425, 0.004165, 0.004035, 0.0046875, 0.005615, 0.00533, 0.0052125, 0.0052675, 0.0047325, 0.004495, 0.00479, 0.0048875, 0.0042975, 0.0031275, 0.00302, 0.0038875, 0.00471, 0.005245, 0.005405, 0.005705, 0.0055575, 0.0048325, 0.004305, 0.004345, 0.0049475, 0.0051275, 0.00441, 0.0037925, 0.00436, 0.00529, 0.0055825, 0.0059575, 0.006285, 0.006175, 0.0067375, 0.00694, 0.0056175, 0.0044225, 0.00426, 0.0052975, 0.00569, 0.0053625, 0.0054, 0.0052875, 0.00596, 0.00655, 0.0061925, 0.005795, 0.0053775, 0.0053625, 0.0058625, 0.0060025, 0.0061425, 0.0057575, 0.0055625, 0.0061225, 0.005805, 0.00615, 0.0063325, 0.0062575, 0.0063825, 0.0059825, 0.005535, 0.0053275, 0.005295, 0.0050975, 0.0045175, 0.0044875, 0.005605, 0.0071775, 0.00842, 0.0080875, 0.0074575, 0.00601, 0.005095, 0.0047675, 0.0041475, 0.004545, 0.0054275, 0.00602, 0.0064375, 0.0065575, 0.0067325, 0.006185, 0.005095, 0.005085, 0.0051925, 0.0050625, 0.0047425, 0.00503, 0.0054425, 0.006485, 0.0074975, 0.0065175, 0.004935, 0.004355, 0.004835, 0.0056025, 0.005465, 0.00509, 0.004265, 0.00411, 0.0050375, 0.0044875, 0.0033125, 0.00274, 0.0027425, 0.0030975, 0.0033575, 0.0032775, 0.0029725, 0.0028475, 0.00236375, 0.001472, 0.00123375, 0.00119625, 0.001098, 0.00128375, 0.00157225, 0.001407, 0.00100825, 0.0008405, 0.00082025, 0.0010095, 0.00111175, 0.00108425, 0.00121125, 0.0010115, 0.00071125, 0.000545, 0.000542, 0.000584, 0.00058375, 0.000631, 0.00056175, 0.00040925, 0.00030225, 0.00048175, 0.000712, 0.00062775, 0.00030425, 0.0001026, 7.94e-05, 0.000208625, 0.00045025, 0.00048875, 0.000259, 8.7025e-05, 5.2925e-05, 0.000123625, 0.000249975, 0.0002151, 8.335e-05, 2.46175e-05, 1.839e-05, 5.185e-05, 0.000125825, 0.000135675, 6.095e-05, 1.6925e-05, 4.5725e-06, 3.66e-06, 1.121e-05, 3.4075e-05, 5.1575e-05, 3.1025e-05, 1.02975e-05, 5.0825e-06, 1.09975e-05, 2.7175e-05, 3.275e-05, 1.73175e-05, 5.42e-06, 1.338e-06, 3.0575e-07, 1.9885e-08, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.2525e-06, 6.985e-06, 3.14e-05, 0.000137225, 0.000583, 0.002258, 0.006995, 0.0147475, 0.0219525, 0.029775, 0.0347, 0.035325, 0.043325, 0.048775, 0.048725, 0.0523, 0.051025, 0.05525, 0.067275, 0.068925, 0.06715, 0.058525, 0.058925, 0.0779, 0.0859, 0.0831, 0.08125, 0.068225, 0.07485, 0.089825, 0.0898, 0.08695, 0.0864, 0.097875, 0.1088, 0.097975, 0.09465, 0.08405, 0.076525, 0.101825, 0.1202, 0.123325, 0.125075, 0.107525, 0.097925, 0.098575, 0.103825, 0.114775, 0.108975, 0.115125, 0.13865, 0.135725, 0.12955, 0.1097, 0.1053, 0.13535, 0.146425, 0.133475, 0.114725, 0.10325, 0.12595, 0.14085, 0.141975, 0.144025, 0.1419, 0.1674, 0.176625, 0.13335, 0.112025, 0.105, 0.110725, 0.147225, 0.17225, 0.180025, 0.157325, 0.148375, 0.16335, 0.160475, 0.1585, 0.1544, 0.130375, 0.14495, 0.1688, 0.1778, 0.1651, 0.139575, 0.15365, 0.1695, 0.1721, 0.18895, 0.16685, 0.165625, 0.186075, 0.1843, 0.181925, 0.172075, 0.166925, 0.17995, 0.17235, 0.1525, 0.134, 0.159525, 0.216575, 0.22505, 0.214775, 0.210375, 0.204625, 0.21045, 0.187425, 0.15615, 0.151025, 0.179275, 0.221275, 0.2215, 0.21165, 0.211275, 0.2053, 0.205325, 0.209075, 0.21125, 0.190825, 0.1533, 0.144575, 0.172075, 0.201175, 0.21475, 0.223475, 0.2351, 0.2228, 0.189025, 0.169975, 0.164725, 0.191475, 0.22065, 0.206, 0.172275, 0.1824, 0.215825, 0.21915, 0.210525, 0.222375, 0.24815, 0.26675, 0.26375, 0.224775, 0.171925, 0.164775, 0.20785, 0.22545, 0.200175, 0.19365, 0.207775, 0.233775, 0.253, 0.25175, 0.23795, 0.233, 0.2385, 0.229175, 0.207325, 0.217775, 0.22445, 0.22545, 0.2455, 0.255, 0.26225, 0.265, 0.25275, 0.243975, 0.22665, 0.2064, 0.2037, 0.210075, 0.22465, 0.2232, 0.2116, 0.2388, 0.29425, 0.32475, 0.318, 0.29725, 0.25225, 0.2397, 0.239675, 0.2041, 0.19205, 0.2311, 0.2725, 0.27475, 0.2655, 0.277, 0.27925, 0.27125, 0.2665, 0.24055, 0.231375, 0.236525, 0.2429, 0.25375, 0.29325, 0.34225, 0.327, 0.28525, 0.26725, 0.27725, 0.29125, 0.2815, 0.27375, 0.233525, 0.211825, 0.2615, 0.2635, 0.213275, 0.18595, 0.1778, 0.19395, 0.225825, 0.248625, 0.232025, 0.1964, 0.168275, 0.118675, 0.0904, 0.0887, 0.08185, 0.086075, 0.104825, 0.105725, 0.0818, 0.0673, 0.065675, 0.08435, 0.1013, 0.088175, 0.08605, 0.075625, 0.056975, 0.045275, 0.0435, 0.048225, 0.0493, 0.0537, 0.0508, 0.0432, 0.034725, 0.0431, 0.063725, 0.062825, 0.03535, 0.012845, 0.0080725, 0.0191975, 0.046225, 0.060225, 0.03745, 0.0135725, 0.0070825, 0.014795, 0.0344, 0.039025, 0.0213375, 0.0080625, 0.004155, 0.0083475, 0.0206375, 0.0252, 0.0128725, 0.0038875, 0.0011885, 0.00126175, 0.003925, 0.0102975, 0.0126125, 0.0064925, 0.002188, 0.00161675, 0.004405, 0.0113675, 0.0156025, 0.01078, 0.0043575, 0.00122625, 0.0002975, 4.305e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.130289465, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.89e-08, 4.3925e-07, 1.973e-06, 8.62e-06, 3.66e-05, 0.00014175, 0.00043875, 0.00092325, 0.00136925, 0.001848, 0.002146, 0.00217225, 0.00265, 0.00297, 0.0029525, 0.0031525, 0.00306, 0.0032925, 0.0039875, 0.0040675, 0.003945, 0.00342, 0.0034175, 0.0044925, 0.0049325, 0.0047475, 0.00462, 0.0038575, 0.0042, 0.0050175, 0.00499, 0.0048025, 0.0047425, 0.00534, 0.00591, 0.0052975, 0.005085, 0.0044925, 0.0040575, 0.0053625, 0.0063, 0.006425, 0.006485, 0.00555, 0.00502, 0.00502, 0.005255, 0.0057775, 0.0054525, 0.00571, 0.00684, 0.00666, 0.0063225, 0.0053225, 0.005065, 0.0064675, 0.0069725, 0.00633, 0.0054075, 0.0048175, 0.0058225, 0.00647, 0.00648, 0.006535, 0.0064025, 0.0075075, 0.00788, 0.00591, 0.00493, 0.0045925, 0.004805, 0.00634, 0.007365, 0.007635, 0.006615, 0.0061725, 0.0067525, 0.0066025, 0.0064875, 0.006295, 0.0052775, 0.0058225, 0.006755, 0.007045, 0.0064725, 0.0054325, 0.0059725, 0.00657, 0.00659, 0.007125, 0.00623, 0.00614, 0.0068375, 0.006725, 0.0065525, 0.00605, 0.00573, 0.006115, 0.0058575, 0.005115, 0.004305, 0.004965, 0.006715, 0.006895, 0.0065725, 0.0064, 0.00606, 0.0062025, 0.0054775, 0.004415, 0.00407, 0.0045825, 0.00562, 0.0055925, 0.00533, 0.005355, 0.0048675, 0.0046375, 0.0049025, 0.0050375, 0.0045075, 0.00329, 0.0028875, 0.0037175, 0.0047675, 0.00548, 0.005625, 0.005825, 0.0058525, 0.00498, 0.0045525, 0.0045025, 0.004795, 0.0052, 0.00481, 0.004185, 0.004705, 0.0057825, 0.0061875, 0.00595, 0.0060575, 0.0065925, 0.007155, 0.0069825, 0.0058475, 0.00466, 0.004465, 0.0055225, 0.0062025, 0.0056925, 0.005275, 0.0051225, 0.0056625, 0.00638, 0.00635, 0.006005, 0.005725, 0.0059175, 0.00636, 0.0063925, 0.00649, 0.0058625, 0.00546, 0.00593, 0.0057425, 0.0061475, 0.0065925, 0.0064225, 0.006265, 0.0059575, 0.0057675, 0.005705, 0.00516, 0.004905, 0.00457, 0.0046625, 0.005775, 0.007335, 0.0081925, 0.00782, 0.0073, 0.005905, 0.0052375, 0.0053025, 0.00466, 0.0044275, 0.005135, 0.0061425, 0.00656, 0.00628, 0.0062875, 0.00593, 0.00517, 0.005255, 0.0050875, 0.0048875, 0.0048675, 0.005175, 0.0056575, 0.006505, 0.0073425, 0.0063925, 0.004925, 0.0044675, 0.0048575, 0.005505, 0.0054075, 0.0051725, 0.0044325, 0.0039125, 0.0046725, 0.0044175, 0.0033225, 0.0028075, 0.00278, 0.003085, 0.0033875, 0.00351, 0.00328, 0.00298, 0.00258, 0.00167625, 0.001191, 0.00108175, 0.0010065, 0.0012195, 0.001577, 0.00156475, 0.00114475, 0.00090825, 0.00083225, 0.001003, 0.00121125, 0.001109, 0.001135, 0.001013, 0.00075225, 0.0005545, 0.0005345, 0.00062425, 0.00064575, 0.00068, 0.0006005, 0.00047525, 0.00034775, 0.00044075, 0.000663, 0.00062725, 0.00034525, 0.00012585, 8.24e-05, 0.0001981, 0.00045875, 0.0005545, 0.0003245, 0.00011285, 5.1425e-05, 9.3825e-05, 0.000208075, 0.000218725, 0.00010065, 3.15e-05, 1.96e-05, 4.94e-05, 0.00012535, 0.000153475, 7.835e-05, 2.3525e-05, 6.6075e-06, 5.04e-06, 1.394e-05, 3.6575e-05, 4.48e-05, 2.30625e-05, 7.7675e-06, 5.7125e-06, 1.5315e-05, 3.7525e-05, 4.4375e-05, 2.266e-05, 6.8075e-06, 1.678e-06, 3.92e-07, 8.43e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.130289465, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.89e-08, 4.3925e-07, 1.973e-06, 8.62e-06, 3.66e-05, 0.00014175, 0.00043875, 0.00092325, 0.00136925, 0.001848, 0.002146, 0.00217225, 0.00265, 0.00297, 0.0029525, 0.0031525, 0.00306, 0.0032925, 0.0039875, 0.0040675, 0.003945, 0.00342, 0.0034175, 0.0044925, 0.0049325, 0.0047475, 0.00462, 0.0038575, 0.0042, 0.0050175, 0.00499, 0.0048025, 0.0047425, 0.00534, 0.00591, 0.0052975, 0.005085, 0.0044925, 0.0040575, 0.0053625, 0.0063, 0.006425, 0.006485, 0.00555, 0.00502, 0.00502, 0.005255, 0.0057775, 0.0054525, 0.00571, 0.00684, 0.00666, 0.0063225, 0.0053225, 0.005065, 0.0064675, 0.0069725, 0.00633, 0.0054075, 0.0048175, 0.0058225, 0.00647, 0.00648, 0.006535, 0.0064025, 0.0075075, 0.00788, 0.00591, 0.00493, 0.0045925, 0.004805, 0.00634, 0.007365, 0.007635, 0.006615, 0.0061725, 0.0067525, 0.0066025, 0.0064875, 0.006295, 0.0052775, 0.0058225, 0.006755, 0.007045, 0.0064725, 0.0054325, 0.0059725, 0.00657, 0.00659, 0.007125, 0.00623, 0.00614, 0.0068375, 0.006725, 0.0065525, 0.00605, 0.00573, 0.006115, 0.0058575, 0.005115, 0.004305, 0.004965, 0.006715, 0.006895, 0.0065725, 0.0064, 0.00606, 0.0062025, 0.0054775, 0.004415, 0.00407, 0.0045825, 0.00562, 0.0055925, 0.00533, 0.005355, 0.0048675, 0.0046375, 0.0049025, 0.0050375, 0.0045075, 0.00329, 0.0028875, 0.0037175, 0.0047675, 0.00548, 0.005625, 0.005825, 0.0058525, 0.00498, 0.0045525, 0.0045025, 0.004795, 0.0052, 0.00481, 0.004185, 0.004705, 0.0057825, 0.0061875, 0.00595, 0.0060575, 0.0065925, 0.007155, 0.0069825, 0.0058475, 0.00466, 0.004465, 0.0055225, 0.0062025, 0.0056925, 0.005275, 0.0051225, 0.0056625, 0.00638, 0.00635, 0.006005, 0.005725, 0.0059175, 0.00636, 0.0063925, 0.00649, 0.0058625, 0.00546, 0.00593, 0.0057425, 0.0061475, 0.0065925, 0.0064225, 0.006265, 0.0059575, 0.0057675, 0.005705, 0.00516, 0.004905, 0.00457, 0.0046625, 0.005775, 0.007335, 0.0081925, 0.00782, 0.0073, 0.005905, 0.0052375, 0.0053025, 0.00466, 0.0044275, 0.005135, 0.0061425, 0.00656, 0.00628, 0.0062875, 0.00593, 0.00517, 0.005255, 0.0050875, 0.0048875, 0.0048675, 0.005175, 0.0056575, 0.006505, 0.0073425, 0.0063925, 0.004925, 0.0044675, 0.0048575, 0.005505, 0.0054075, 0.0051725, 0.0044325, 0.0039125, 0.0046725, 0.0044175, 0.0033225, 0.0028075, 0.00278, 0.003085, 0.0033875, 0.00351, 0.00328, 0.00298, 0.00258, 0.00167625, 0.001191, 0.00108175, 0.0010065, 0.0012195, 0.001577, 0.00156475, 0.00114475, 0.00090825, 0.00083225, 0.001003, 0.00121125, 0.001109, 0.001135, 0.001013, 0.00075225, 0.0005545, 0.0005345, 0.00062425, 0.00064575, 0.00068, 0.0006005, 0.00047525, 0.00034775, 0.00044075, 0.000663, 0.00062725, 0.00034525, 0.00012585, 8.24e-05, 0.0001981, 0.00045875, 0.0005545, 0.0003245, 0.00011285, 5.1425e-05, 9.3825e-05, 0.000208075, 0.000218725, 0.00010065, 3.15e-05, 1.96e-05, 4.94e-05, 0.00012535, 0.000153475, 7.835e-05, 2.3525e-05, 6.6075e-06, 5.04e-06, 1.394e-05, 3.6575e-05, 4.48e-05, 2.30625e-05, 7.7675e-06, 5.7125e-06, 1.5315e-05, 3.7525e-05, 4.4375e-05, 2.266e-05, 6.8075e-06, 1.678e-06, 3.92e-07, 8.43e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.130289465, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.89e-08, 4.3925e-07, 1.973e-06, 8.62e-06, 3.66e-05, 0.00014175, 0.00043875, 0.00092325, 0.00136925, 0.001848, 0.002146, 0.00217225, 0.00265, 0.00297, 0.0029525, 0.0031525, 0.00306, 0.0032925, 0.0039875, 0.0040675, 0.003945, 0.00342, 0.0034175, 0.0044925, 0.0049325, 0.0047475, 0.00462, 0.0038575, 0.0042, 0.0050175, 0.00499, 0.0048025, 0.0047425, 0.00534, 0.00591, 0.0052975, 0.005085, 0.0044925, 0.0040575, 0.0053625, 0.0063, 0.006425, 0.006485, 0.00555, 0.00502, 0.00502, 0.005255, 0.0057775, 0.0054525, 0.00571, 0.00684, 0.00666, 0.0063225, 0.0053225, 0.005065, 0.0064675, 0.0069725, 0.00633, 0.0054075, 0.0048175, 0.0058225, 0.00647, 0.00648, 0.006535, 0.0064025, 0.0075075, 0.00788, 0.00591, 0.00493, 0.0045925, 0.004805, 0.00634, 0.007365, 0.007635, 0.006615, 0.0061725, 0.0067525, 0.0066025, 0.0064875, 0.006295, 0.0052775, 0.0058225, 0.006755, 0.007045, 0.0064725, 0.0054325, 0.0059725, 0.00657, 0.00659, 0.007125, 0.00623, 0.00614, 0.0068375, 0.006725, 0.0065525, 0.00605, 0.00573, 0.006115, 0.0058575, 0.005115, 0.004305, 0.004965, 0.006715, 0.006895, 0.0065725, 0.0064, 0.00606, 0.0062025, 0.0054775, 0.004415, 0.00407, 0.0045825, 0.00562, 0.0055925, 0.00533, 0.005355, 0.0048675, 0.0046375, 0.0049025, 0.0050375, 0.0045075, 0.00329, 0.0028875, 0.0037175, 0.0047675, 0.00548, 0.005625, 0.005825, 0.0058525, 0.00498, 0.0045525, 0.0045025, 0.004795, 0.0052, 0.00481, 0.004185, 0.004705, 0.0057825, 0.0061875, 0.00595, 0.0060575, 0.0065925, 0.007155, 0.0069825, 0.0058475, 0.00466, 0.004465, 0.0055225, 0.0062025, 0.0056925, 0.005275, 0.0051225, 0.0056625, 0.00638, 0.00635, 0.006005, 0.005725, 0.0059175, 0.00636, 0.0063925, 0.00649, 0.0058625, 0.00546, 0.00593, 0.0057425, 0.0061475, 0.0065925, 0.0064225, 0.006265, 0.0059575, 0.0057675, 0.005705, 0.00516, 0.004905, 0.00457, 0.0046625, 0.005775, 0.007335, 0.0081925, 0.00782, 0.0073, 0.005905, 0.0052375, 0.0053025, 0.00466, 0.0044275, 0.005135, 0.0061425, 0.00656, 0.00628, 0.0062875, 0.00593, 0.00517, 0.005255, 0.0050875, 0.0048875, 0.0048675, 0.005175, 0.0056575, 0.006505, 0.0073425, 0.0063925, 0.004925, 0.0044675, 0.0048575, 0.005505, 0.0054075, 0.0051725, 0.0044325, 0.0039125, 0.0046725, 0.0044175, 0.0033225, 0.0028075, 0.00278, 0.003085, 0.0033875, 0.00351, 0.00328, 0.00298, 0.00258, 0.00167625, 0.001191, 0.00108175, 0.0010065, 0.0012195, 0.001577, 0.00156475, 0.00114475, 0.00090825, 0.00083225, 0.001003, 0.00121125, 0.001109, 0.001135, 0.001013, 0.00075225, 0.0005545, 0.0005345, 0.00062425, 0.00064575, 0.00068, 0.0006005, 0.00047525, 0.00034775, 0.00044075, 0.000663, 0.00062725, 0.00034525, 0.00012585, 8.24e-05, 0.0001981, 0.00045875, 0.0005545, 0.0003245, 0.00011285, 5.1425e-05, 9.3825e-05, 0.000208075, 0.000218725, 0.00010065, 3.15e-05, 1.96e-05, 4.94e-05, 0.00012535, 0.000153475, 7.835e-05, 2.3525e-05, 6.6075e-06, 5.04e-06, 1.394e-05, 3.6575e-05, 4.48e-05, 2.30625e-05, 7.7675e-06, 5.7125e-06, 1.5315e-05, 3.7525e-05, 4.4375e-05, 2.266e-05, 6.8075e-06, 1.678e-06, 3.92e-07, 8.43e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.130289465, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.89e-08, 4.3925e-07, 1.973e-06, 8.62e-06, 3.66e-05, 0.00014175, 0.00043875, 0.00092325, 0.00136925, 0.001848, 0.002146, 0.00217225, 0.00265, 0.00297, 0.0029525, 0.0031525, 0.00306, 0.0032925, 0.0039875, 0.0040675, 0.003945, 0.00342, 0.0034175, 0.0044925, 0.0049325, 0.0047475, 0.00462, 0.0038575, 0.0042, 0.0050175, 0.00499, 0.0048025, 0.0047425, 0.00534, 0.00591, 0.0052975, 0.005085, 0.0044925, 0.0040575, 0.0053625, 0.0063, 0.006425, 0.006485, 0.00555, 0.00502, 0.00502, 0.005255, 0.0057775, 0.0054525, 0.00571, 0.00684, 0.00666, 0.0063225, 0.0053225, 0.005065, 0.0064675, 0.0069725, 0.00633, 0.0054075, 0.0048175, 0.0058225, 0.00647, 0.00648, 0.006535, 0.0064025, 0.0075075, 0.00788, 0.00591, 0.00493, 0.0045925, 0.004805, 0.00634, 0.007365, 0.007635, 0.006615, 0.0061725, 0.0067525, 0.0066025, 0.0064875, 0.006295, 0.0052775, 0.0058225, 0.006755, 0.007045, 0.0064725, 0.0054325, 0.0059725, 0.00657, 0.00659, 0.007125, 0.00623, 0.00614, 0.0068375, 0.006725, 0.0065525, 0.00605, 0.00573, 0.006115, 0.0058575, 0.005115, 0.004305, 0.004965, 0.006715, 0.006895, 0.0065725, 0.0064, 0.00606, 0.0062025, 0.0054775, 0.004415, 0.00407, 0.0045825, 0.00562, 0.0055925, 0.00533, 0.005355, 0.0048675, 0.0046375, 0.0049025, 0.0050375, 0.0045075, 0.00329, 0.0028875, 0.0037175, 0.0047675, 0.00548, 0.005625, 0.005825, 0.0058525, 0.00498, 0.0045525, 0.0045025, 0.004795, 0.0052, 0.00481, 0.004185, 0.004705, 0.0057825, 0.0061875, 0.00595, 0.0060575, 0.0065925, 0.007155, 0.0069825, 0.0058475, 0.00466, 0.004465, 0.0055225, 0.0062025, 0.0056925, 0.005275, 0.0051225, 0.0056625, 0.00638, 0.00635, 0.006005, 0.005725, 0.0059175, 0.00636, 0.0063925, 0.00649, 0.0058625, 0.00546, 0.00593, 0.0057425, 0.0061475, 0.0065925, 0.0064225, 0.006265, 0.0059575, 0.0057675, 0.005705, 0.00516, 0.004905, 0.00457, 0.0046625, 0.005775, 0.007335, 0.0081925, 0.00782, 0.0073, 0.005905, 0.0052375, 0.0053025, 0.00466, 0.0044275, 0.005135, 0.0061425, 0.00656, 0.00628, 0.0062875, 0.00593, 0.00517, 0.005255, 0.0050875, 0.0048875, 0.0048675, 0.005175, 0.0056575, 0.006505, 0.0073425, 0.0063925, 0.004925, 0.0044675, 0.0048575, 0.005505, 0.0054075, 0.0051725, 0.0044325, 0.0039125, 0.0046725, 0.0044175, 0.0033225, 0.0028075, 0.00278, 0.003085, 0.0033875, 0.00351, 0.00328, 0.00298, 0.00258, 0.00167625, 0.001191, 0.00108175, 0.0010065, 0.0012195, 0.001577, 0.00156475, 0.00114475, 0.00090825, 0.00083225, 0.001003, 0.00121125, 0.001109, 0.001135, 0.001013, 0.00075225, 0.0005545, 0.0005345, 0.00062425, 0.00064575, 0.00068, 0.0006005, 0.00047525, 0.00034775, 0.00044075, 0.000663, 0.00062725, 0.00034525, 0.00012585, 8.24e-05, 0.0001981, 0.00045875, 0.0005545, 0.0003245, 0.00011285, 5.1425e-05, 9.3825e-05, 0.000208075, 0.000218725, 0.00010065, 3.15e-05, 1.96e-05, 4.94e-05, 0.00012535, 0.000153475, 7.835e-05, 2.3525e-05, 6.6075e-06, 5.04e-06, 1.394e-05, 3.6575e-05, 4.48e-05, 2.30625e-05, 7.7675e-06, 5.7125e-06, 1.5315e-05, 3.7525e-05, 4.4375e-05, 2.266e-05, 6.8075e-06, 1.678e-06, 3.92e-07, 8.43e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.52975e-06, 8.3225e-06, 3.635e-05, 0.000154275, 0.00063575, 0.0023875, 0.007215, 0.0150225, 0.022375, 0.03025, 0.03525, 0.03615, 0.044025, 0.049575, 0.049725, 0.053175, 0.05215, 0.05635, 0.0682, 0.070175, 0.06835, 0.060025, 0.060275, 0.078775, 0.0873, 0.084675, 0.082775, 0.070175, 0.076075, 0.090975, 0.09155, 0.088675, 0.08825, 0.0991, 0.110525, 0.100325, 0.096425, 0.0864, 0.078375, 0.102325, 0.12185, 0.1253, 0.127425, 0.110675, 0.100225, 0.1004, 0.105475, 0.116175, 0.1118, 0.116225, 0.139975, 0.138575, 0.13245, 0.11355, 0.1069, 0.135375, 0.149075, 0.136875, 0.118625, 0.105375, 0.125975, 0.14265, 0.144475, 0.146675, 0.144775, 0.16705, 0.1806, 0.1402, 0.1152, 0.108175, 0.1112, 0.146025, 0.173175, 0.18285, 0.163425, 0.150475, 0.1651, 0.164525, 0.161225, 0.159025, 0.1352, 0.144525, 0.169725, 0.179575, 0.171125, 0.145175, 0.15435, 0.1722, 0.17345, 0.18995, 0.174125, 0.166525, 0.187225, 0.1884, 0.183575, 0.1756, 0.167675, 0.181825, 0.179075, 0.15825, 0.1362, 0.152875, 0.209725, 0.2306, 0.22035, 0.215325, 0.206275, 0.2146, 0.197675, 0.1643, 0.15075, 0.1705, 0.21555, 0.2288, 0.216875, 0.2155, 0.20675, 0.20835, 0.213825, 0.215625, 0.201475, 0.1632, 0.14505, 0.168675, 0.20355, 0.219975, 0.222575, 0.236, 0.23785, 0.20085, 0.181525, 0.1675, 0.17835, 0.216125, 0.21935, 0.1898, 0.183725, 0.2126, 0.2265, 0.2136, 0.2235, 0.2467, 0.26475, 0.2685, 0.243825, 0.192925, 0.1666, 0.1988, 0.233375, 0.21115, 0.19165, 0.199975, 0.22935, 0.259, 0.259, 0.248, 0.2378, 0.244975, 0.25025, 0.22255, 0.2108, 0.2175, 0.2244, 0.24225, 0.2515, 0.27175, 0.27875, 0.2615, 0.2535, 0.241925, 0.221925, 0.205, 0.19785, 0.214775, 0.226, 0.228675, 0.243025, 0.28825, 0.32675, 0.32375, 0.31075, 0.265, 0.241675, 0.249125, 0.21795, 0.195775, 0.223625, 0.2755, 0.29, 0.267, 0.27275, 0.279, 0.26775, 0.28125, 0.26, 0.23775, 0.240125, 0.25325, 0.26475, 0.286, 0.33275, 0.3265, 0.28975, 0.27575, 0.28575, 0.30675, 0.2915, 0.27875, 0.2535, 0.2158, 0.25325, 0.27425, 0.226475, 0.196075, 0.1878, 0.20055, 0.2282, 0.252, 0.2385, 0.2009, 0.176075, 0.131025, 0.09485, 0.089175, 0.08605, 0.089925, 0.104525, 0.1116, 0.089425, 0.070525, 0.065525, 0.078475, 0.100875, 0.092675, 0.0877, 0.082375, 0.0624, 0.046875, 0.0449, 0.051425, 0.052175, 0.054725, 0.05465, 0.046225, 0.03475, 0.03785, 0.057725, 0.06495, 0.045875, 0.019515, 0.0095025, 0.0168525, 0.041075, 0.06005, 0.044175, 0.0178275, 0.0074775, 0.0113875, 0.028475, 0.041075, 0.027875, 0.011545, 0.00511, 0.00773, 0.01908, 0.025975, 0.0150725, 0.004935, 0.001517, 0.00137, 0.00391, 0.01016, 0.012765, 0.00691, 0.00245575, 0.00185475, 0.004775, 0.0113675, 0.015155, 0.011065, 0.0047225, 0.001383, 0.000347, 6.9475e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1468091975, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.4925e-08, 5.155e-07, 2.2495e-06, 9.5475e-06, 3.9325e-05, 0.000147675, 0.00044575, 0.0009265, 0.00137525, 0.0018515, 0.00215, 0.00219225, 0.0026575, 0.0029775, 0.0029725, 0.0031625, 0.0030875, 0.003315, 0.0039925, 0.00409, 0.003965, 0.003465, 0.003455, 0.00449, 0.0049575, 0.004785, 0.004655, 0.003925, 0.0042275, 0.00503, 0.0050375, 0.0048525, 0.0048, 0.0053575, 0.0059525, 0.0053775, 0.00514, 0.0045825, 0.004125, 0.00535, 0.0063425, 0.0064875, 0.006565, 0.005675, 0.00511, 0.005085, 0.0053125, 0.0058225, 0.00557, 0.0057425, 0.00688, 0.00678, 0.006445, 0.0054975, 0.0051325, 0.0064575, 0.00709, 0.0064875, 0.0055925, 0.00492, 0.00583, 0.00656, 0.006605, 0.0066675, 0.0065525, 0.0075175, 0.0080875, 0.0062425, 0.005095, 0.00476, 0.0048625, 0.00634, 0.0074675, 0.007825, 0.0069375, 0.006325, 0.0068975, 0.00685, 0.00669, 0.006585, 0.005565, 0.0059075, 0.0069225, 0.0072625, 0.006845, 0.00579, 0.0061975, 0.00693, 0.0069225, 0.0074475, 0.0067425, 0.0064275, 0.007175, 0.0071675, 0.006885, 0.0063525, 0.0058575, 0.0062725, 0.00622, 0.00548, 0.00447, 0.004815, 0.00662, 0.00721, 0.0068775, 0.0066975, 0.00621, 0.0063725, 0.00584, 0.00473, 0.0041625, 0.0044925, 0.0055675, 0.005865, 0.0055125, 0.00543, 0.005005, 0.0048, 0.0050325, 0.0051875, 0.0047175, 0.0035375, 0.0028225, 0.003515, 0.0047925, 0.0057275, 0.0058575, 0.0059425, 0.0060925, 0.0051825, 0.00485, 0.004725, 0.004635, 0.0052075, 0.00521, 0.0048325, 0.0053, 0.0061, 0.006305, 0.0057425, 0.0062025, 0.0071525, 0.0072875, 0.006905, 0.0061575, 0.005075, 0.004735, 0.0056725, 0.0066125, 0.00601, 0.00515, 0.0049425, 0.0053225, 0.006205, 0.00644, 0.0062225, 0.0061725, 0.00654, 0.006985, 0.0066325, 0.0062325, 0.00593, 0.00567, 0.00588, 0.005665, 0.0060575, 0.0066675, 0.0064225, 0.0062025, 0.006185, 0.0059875, 0.0057725, 0.0051625, 0.0048575, 0.004665, 0.004855, 0.0058525, 0.007105, 0.007825, 0.0076025, 0.007245, 0.0062075, 0.00566, 0.005735, 0.0048125, 0.0041675, 0.00491, 0.00619, 0.0066325, 0.0060525, 0.005845, 0.0058025, 0.00525, 0.0053125, 0.005025, 0.00483, 0.0050575, 0.005405, 0.00588, 0.0063125, 0.0069275, 0.0063325, 0.0051425, 0.0046125, 0.0048125, 0.00539, 0.0054, 0.0052, 0.0045975, 0.003765, 0.00425, 0.0043925, 0.0033825, 0.0028775, 0.0029625, 0.0033225, 0.003565, 0.00358, 0.0032175, 0.0028775, 0.0026975, 0.00188925, 0.001173, 0.0009945, 0.000954, 0.001166, 0.00155975, 0.0017085, 0.001311, 0.00099125, 0.0008735, 0.001035, 0.00133825, 0.00120275, 0.0011155, 0.00106525, 0.000828, 0.0006005, 0.000583, 0.0007125, 0.00073975, 0.00074625, 0.000674, 0.00051575, 0.00034975, 0.00038025, 0.00059325, 0.0006105, 0.0003965, 0.0001671, 9.25e-05, 0.0001861, 0.00044375, 0.00060025, 0.0004095, 0.00015815, 5.885e-05, 7.1725e-05, 0.00016355, 0.0002124, 0.000122025, 4.2375e-05, 2.25875e-05, 4.8875e-05, 0.000127475, 0.00017455, 0.0001013, 3.3025e-05, 9.4775e-06, 6.2675e-06, 1.5495e-05, 4.025e-05, 5.0575e-05, 2.7375e-05, 9.6875e-06, 7.1475e-06, 1.783e-05, 3.9225e-05, 4.22e-05, 2.1545e-05, 6.82e-06, 1.7555e-06, 4.2425e-07, 4.05e-08, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1468091975, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.4925e-08, 5.155e-07, 2.2495e-06, 9.5475e-06, 3.9325e-05, 0.000147675, 0.00044575, 0.0009265, 0.00137525, 0.0018515, 0.00215, 0.00219225, 0.0026575, 0.0029775, 0.0029725, 0.0031625, 0.0030875, 0.003315, 0.0039925, 0.00409, 0.003965, 0.003465, 0.003455, 0.00449, 0.0049575, 0.004785, 0.004655, 0.003925, 0.0042275, 0.00503, 0.0050375, 0.0048525, 0.0048, 0.0053575, 0.0059525, 0.0053775, 0.00514, 0.0045825, 0.004125, 0.00535, 0.0063425, 0.0064875, 0.006565, 0.005675, 0.00511, 0.005085, 0.0053125, 0.0058225, 0.00557, 0.0057425, 0.00688, 0.00678, 0.006445, 0.0054975, 0.0051325, 0.0064575, 0.00709, 0.0064875, 0.0055925, 0.00492, 0.00583, 0.00656, 0.006605, 0.0066675, 0.0065525, 0.0075175, 0.0080875, 0.0062425, 0.005095, 0.00476, 0.0048625, 0.00634, 0.0074675, 0.007825, 0.0069375, 0.006325, 0.0068975, 0.00685, 0.00669, 0.006585, 0.005565, 0.0059075, 0.0069225, 0.0072625, 0.006845, 0.00579, 0.0061975, 0.00693, 0.0069225, 0.0074475, 0.0067425, 0.0064275, 0.007175, 0.0071675, 0.006885, 0.0063525, 0.0058575, 0.0062725, 0.00622, 0.00548, 0.00447, 0.004815, 0.00662, 0.00721, 0.0068775, 0.0066975, 0.00621, 0.0063725, 0.00584, 0.00473, 0.0041625, 0.0044925, 0.0055675, 0.005865, 0.0055125, 0.00543, 0.005005, 0.0048, 0.0050325, 0.0051875, 0.0047175, 0.0035375, 0.0028225, 0.003515, 0.0047925, 0.0057275, 0.0058575, 0.0059425, 0.0060925, 0.0051825, 0.00485, 0.004725, 0.004635, 0.0052075, 0.00521, 0.0048325, 0.0053, 0.0061, 0.006305, 0.0057425, 0.0062025, 0.0071525, 0.0072875, 0.006905, 0.0061575, 0.005075, 0.004735, 0.0056725, 0.0066125, 0.00601, 0.00515, 0.0049425, 0.0053225, 0.006205, 0.00644, 0.0062225, 0.0061725, 0.00654, 0.006985, 0.0066325, 0.0062325, 0.00593, 0.00567, 0.00588, 0.005665, 0.0060575, 0.0066675, 0.0064225, 0.0062025, 0.006185, 0.0059875, 0.0057725, 0.0051625, 0.0048575, 0.004665, 0.004855, 0.0058525, 0.007105, 0.007825, 0.0076025, 0.007245, 0.0062075, 0.00566, 0.005735, 0.0048125, 0.0041675, 0.00491, 0.00619, 0.0066325, 0.0060525, 0.005845, 0.0058025, 0.00525, 0.0053125, 0.005025, 0.00483, 0.0050575, 0.005405, 0.00588, 0.0063125, 0.0069275, 0.0063325, 0.0051425, 0.0046125, 0.0048125, 0.00539, 0.0054, 0.0052, 0.0045975, 0.003765, 0.00425, 0.0043925, 0.0033825, 0.0028775, 0.0029625, 0.0033225, 0.003565, 0.00358, 0.0032175, 0.0028775, 0.0026975, 0.00188925, 0.001173, 0.0009945, 0.000954, 0.001166, 0.00155975, 0.0017085, 0.001311, 0.00099125, 0.0008735, 0.001035, 0.00133825, 0.00120275, 0.0011155, 0.00106525, 0.000828, 0.0006005, 0.000583, 0.0007125, 0.00073975, 0.00074625, 0.000674, 0.00051575, 0.00034975, 0.00038025, 0.00059325, 0.0006105, 0.0003965, 0.0001671, 9.25e-05, 0.0001861, 0.00044375, 0.00060025, 0.0004095, 0.00015815, 5.885e-05, 7.1725e-05, 0.00016355, 0.0002124, 0.000122025, 4.2375e-05, 2.25875e-05, 4.8875e-05, 0.000127475, 0.00017455, 0.0001013, 3.3025e-05, 9.4775e-06, 6.2675e-06, 1.5495e-05, 4.025e-05, 5.0575e-05, 2.7375e-05, 9.6875e-06, 7.1475e-06, 1.783e-05, 3.9225e-05, 4.22e-05, 2.1545e-05, 6.82e-06, 1.7555e-06, 4.2425e-07, 4.05e-08, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1468091975, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.4925e-08, 5.155e-07, 2.2495e-06, 9.5475e-06, 3.9325e-05, 0.000147675, 0.00044575, 0.0009265, 0.00137525, 0.0018515, 0.00215, 0.00219225, 0.0026575, 0.0029775, 0.0029725, 0.0031625, 0.0030875, 0.003315, 0.0039925, 0.00409, 0.003965, 0.003465, 0.003455, 0.00449, 0.0049575, 0.004785, 0.004655, 0.003925, 0.0042275, 0.00503, 0.0050375, 0.0048525, 0.0048, 0.0053575, 0.0059525, 0.0053775, 0.00514, 0.0045825, 0.004125, 0.00535, 0.0063425, 0.0064875, 0.006565, 0.005675, 0.00511, 0.005085, 0.0053125, 0.0058225, 0.00557, 0.0057425, 0.00688, 0.00678, 0.006445, 0.0054975, 0.0051325, 0.0064575, 0.00709, 0.0064875, 0.0055925, 0.00492, 0.00583, 0.00656, 0.006605, 0.0066675, 0.0065525, 0.0075175, 0.0080875, 0.0062425, 0.005095, 0.00476, 0.0048625, 0.00634, 0.0074675, 0.007825, 0.0069375, 0.006325, 0.0068975, 0.00685, 0.00669, 0.006585, 0.005565, 0.0059075, 0.0069225, 0.0072625, 0.006845, 0.00579, 0.0061975, 0.00693, 0.0069225, 0.0074475, 0.0067425, 0.0064275, 0.007175, 0.0071675, 0.006885, 0.0063525, 0.0058575, 0.0062725, 0.00622, 0.00548, 0.00447, 0.004815, 0.00662, 0.00721, 0.0068775, 0.0066975, 0.00621, 0.0063725, 0.00584, 0.00473, 0.0041625, 0.0044925, 0.0055675, 0.005865, 0.0055125, 0.00543, 0.005005, 0.0048, 0.0050325, 0.0051875, 0.0047175, 0.0035375, 0.0028225, 0.003515, 0.0047925, 0.0057275, 0.0058575, 0.0059425, 0.0060925, 0.0051825, 0.00485, 0.004725, 0.004635, 0.0052075, 0.00521, 0.0048325, 0.0053, 0.0061, 0.006305, 0.0057425, 0.0062025, 0.0071525, 0.0072875, 0.006905, 0.0061575, 0.005075, 0.004735, 0.0056725, 0.0066125, 0.00601, 0.00515, 0.0049425, 0.0053225, 0.006205, 0.00644, 0.0062225, 0.0061725, 0.00654, 0.006985, 0.0066325, 0.0062325, 0.00593, 0.00567, 0.00588, 0.005665, 0.0060575, 0.0066675, 0.0064225, 0.0062025, 0.006185, 0.0059875, 0.0057725, 0.0051625, 0.0048575, 0.004665, 0.004855, 0.0058525, 0.007105, 0.007825, 0.0076025, 0.007245, 0.0062075, 0.00566, 0.005735, 0.0048125, 0.0041675, 0.00491, 0.00619, 0.0066325, 0.0060525, 0.005845, 0.0058025, 0.00525, 0.0053125, 0.005025, 0.00483, 0.0050575, 0.005405, 0.00588, 0.0063125, 0.0069275, 0.0063325, 0.0051425, 0.0046125, 0.0048125, 0.00539, 0.0054, 0.0052, 0.0045975, 0.003765, 0.00425, 0.0043925, 0.0033825, 0.0028775, 0.0029625, 0.0033225, 0.003565, 0.00358, 0.0032175, 0.0028775, 0.0026975, 0.00188925, 0.001173, 0.0009945, 0.000954, 0.001166, 0.00155975, 0.0017085, 0.001311, 0.00099125, 0.0008735, 0.001035, 0.00133825, 0.00120275, 0.0011155, 0.00106525, 0.000828, 0.0006005, 0.000583, 0.0007125, 0.00073975, 0.00074625, 0.000674, 0.00051575, 0.00034975, 0.00038025, 0.00059325, 0.0006105, 0.0003965, 0.0001671, 9.25e-05, 0.0001861, 0.00044375, 0.00060025, 0.0004095, 0.00015815, 5.885e-05, 7.1725e-05, 0.00016355, 0.0002124, 0.000122025, 4.2375e-05, 2.25875e-05, 4.8875e-05, 0.000127475, 0.00017455, 0.0001013, 3.3025e-05, 9.4775e-06, 6.2675e-06, 1.5495e-05, 4.025e-05, 5.0575e-05, 2.7375e-05, 9.6875e-06, 7.1475e-06, 1.783e-05, 3.9225e-05, 4.22e-05, 2.1545e-05, 6.82e-06, 1.7555e-06, 4.2425e-07, 4.05e-08, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1468091975, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.4925e-08, 5.155e-07, 2.2495e-06, 9.5475e-06, 3.9325e-05, 0.000147675, 0.00044575, 0.0009265, 0.00137525, 0.0018515, 0.00215, 0.00219225, 0.0026575, 0.0029775, 0.0029725, 0.0031625, 0.0030875, 0.003315, 0.0039925, 0.00409, 0.003965, 0.003465, 0.003455, 0.00449, 0.0049575, 0.004785, 0.004655, 0.003925, 0.0042275, 0.00503, 0.0050375, 0.0048525, 0.0048, 0.0053575, 0.0059525, 0.0053775, 0.00514, 0.0045825, 0.004125, 0.00535, 0.0063425, 0.0064875, 0.006565, 0.005675, 0.00511, 0.005085, 0.0053125, 0.0058225, 0.00557, 0.0057425, 0.00688, 0.00678, 0.006445, 0.0054975, 0.0051325, 0.0064575, 0.00709, 0.0064875, 0.0055925, 0.00492, 0.00583, 0.00656, 0.006605, 0.0066675, 0.0065525, 0.0075175, 0.0080875, 0.0062425, 0.005095, 0.00476, 0.0048625, 0.00634, 0.0074675, 0.007825, 0.0069375, 0.006325, 0.0068975, 0.00685, 0.00669, 0.006585, 0.005565, 0.0059075, 0.0069225, 0.0072625, 0.006845, 0.00579, 0.0061975, 0.00693, 0.0069225, 0.0074475, 0.0067425, 0.0064275, 0.007175, 0.0071675, 0.006885, 0.0063525, 0.0058575, 0.0062725, 0.00622, 0.00548, 0.00447, 0.004815, 0.00662, 0.00721, 0.0068775, 0.0066975, 0.00621, 0.0063725, 0.00584, 0.00473, 0.0041625, 0.0044925, 0.0055675, 0.005865, 0.0055125, 0.00543, 0.005005, 0.0048, 0.0050325, 0.0051875, 0.0047175, 0.0035375, 0.0028225, 0.003515, 0.0047925, 0.0057275, 0.0058575, 0.0059425, 0.0060925, 0.0051825, 0.00485, 0.004725, 0.004635, 0.0052075, 0.00521, 0.0048325, 0.0053, 0.0061, 0.006305, 0.0057425, 0.0062025, 0.0071525, 0.0072875, 0.006905, 0.0061575, 0.005075, 0.004735, 0.0056725, 0.0066125, 0.00601, 0.00515, 0.0049425, 0.0053225, 0.006205, 0.00644, 0.0062225, 0.0061725, 0.00654, 0.006985, 0.0066325, 0.0062325, 0.00593, 0.00567, 0.00588, 0.005665, 0.0060575, 0.0066675, 0.0064225, 0.0062025, 0.006185, 0.0059875, 0.0057725, 0.0051625, 0.0048575, 0.004665, 0.004855, 0.0058525, 0.007105, 0.007825, 0.0076025, 0.007245, 0.0062075, 0.00566, 0.005735, 0.0048125, 0.0041675, 0.00491, 0.00619, 0.0066325, 0.0060525, 0.005845, 0.0058025, 0.00525, 0.0053125, 0.005025, 0.00483, 0.0050575, 0.005405, 0.00588, 0.0063125, 0.0069275, 0.0063325, 0.0051425, 0.0046125, 0.0048125, 0.00539, 0.0054, 0.0052, 0.0045975, 0.003765, 0.00425, 0.0043925, 0.0033825, 0.0028775, 0.0029625, 0.0033225, 0.003565, 0.00358, 0.0032175, 0.0028775, 0.0026975, 0.00188925, 0.001173, 0.0009945, 0.000954, 0.001166, 0.00155975, 0.0017085, 0.001311, 0.00099125, 0.0008735, 0.001035, 0.00133825, 0.00120275, 0.0011155, 0.00106525, 0.000828, 0.0006005, 0.000583, 0.0007125, 0.00073975, 0.00074625, 0.000674, 0.00051575, 0.00034975, 0.00038025, 0.00059325, 0.0006105, 0.0003965, 0.0001671, 9.25e-05, 0.0001861, 0.00044375, 0.00060025, 0.0004095, 0.00015815, 5.885e-05, 7.1725e-05, 0.00016355, 0.0002124, 0.000122025, 4.2375e-05, 2.25875e-05, 4.8875e-05, 0.000127475, 0.00017455, 0.0001013, 3.3025e-05, 9.4775e-06, 6.2675e-06, 1.5495e-05, 4.025e-05, 5.0575e-05, 2.7375e-05, 9.6875e-06, 7.1475e-06, 1.783e-05, 3.9225e-05, 4.22e-05, 2.1545e-05, 6.82e-06, 1.7555e-06, 4.2425e-07, 4.05e-08, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.371e-07, 1.725e-06, 1.09375e-05, 4.09e-05, 0.000173125, 0.0006925, 0.0025225, 0.0074375, 0.0153, 0.0227975, 0.03075, 0.035825, 0.036975, 0.044775, 0.050375, 0.050725, 0.054075, 0.0533, 0.05745, 0.0692, 0.071425, 0.069625, 0.06155, 0.061625, 0.07965, 0.08875, 0.086275, 0.084375, 0.072175, 0.0773, 0.0921, 0.0933, 0.090425, 0.0901, 0.10035, 0.112175, 0.1027, 0.0982, 0.088775, 0.080275, 0.102775, 0.12335, 0.127325, 0.129675, 0.1139, 0.102575, 0.10225, 0.10715, 0.117575, 0.114625, 0.117425, 0.141125, 0.14145, 0.135275, 0.1175, 0.108725, 0.1353, 0.151625, 0.140425, 0.1227, 0.1078, 0.126025, 0.144275, 0.14705, 0.149275, 0.147875, 0.16685, 0.1841, 0.147325, 0.118925, 0.1114, 0.112175, 0.1445, 0.173975, 0.1853, 0.169625, 0.15315, 0.16665, 0.1685, 0.16435, 0.1633, 0.140575, 0.144675, 0.1706, 0.1813, 0.1764, 0.151875, 0.156225, 0.175125, 0.175525, 0.19005, 0.1809, 0.16915, 0.187925, 0.1924, 0.1853, 0.176975, 0.168475, 0.182625, 0.186275, 0.16485, 0.13815, 0.147675, 0.2017, 0.233675, 0.227275, 0.220125, 0.20805, 0.2164, 0.207475, 0.1744, 0.152875, 0.16385, 0.20565, 0.233275, 0.223225, 0.21805, 0.211025, 0.21005, 0.218625, 0.2196, 0.2086, 0.176025, 0.147125, 0.165625, 0.204875, 0.2275, 0.22475, 0.231875, 0.246675, 0.2175, 0.194, 0.176975, 0.1687, 0.20545, 0.22835, 0.213575, 0.193975, 0.20165, 0.223425, 0.220875, 0.2331, 0.247425, 0.2535, 0.2685, 0.26025, 0.21895, 0.180175, 0.19225, 0.2305, 0.219975, 0.1916, 0.193975, 0.218575, 0.2615, 0.26975, 0.261, 0.2535, 0.24895, 0.2575, 0.239775, 0.213625, 0.215525, 0.218675, 0.23555, 0.245625, 0.2705, 0.29325, 0.27575, 0.261, 0.2565, 0.24035, 0.21875, 0.191475, 0.199725, 0.2215, 0.238225, 0.25525, 0.2785, 0.31925, 0.33175, 0.32425, 0.292, 0.25075, 0.246775, 0.2269, 0.201025, 0.223325, 0.27225, 0.298, 0.27475, 0.2655, 0.28575, 0.2705, 0.2775, 0.2785, 0.2565, 0.25275, 0.258, 0.2725, 0.2795, 0.31925, 0.331, 0.30025, 0.2775, 0.287, 0.3145, 0.31275, 0.28725, 0.267, 0.22835, 0.246175, 0.283, 0.240375, 0.20745, 0.204475, 0.2046, 0.216425, 0.2386, 0.245375, 0.220125, 0.194425, 0.14675, 0.0992, 0.08965, 0.089675, 0.0943, 0.107325, 0.116575, 0.099225, 0.0755, 0.0664, 0.077275, 0.09915, 0.094225, 0.085075, 0.088, 0.071475, 0.051175, 0.04705, 0.053675, 0.054575, 0.052875, 0.0509, 0.04565, 0.04135, 0.03885, 0.052225, 0.0625, 0.054575, 0.0301, 0.0133775, 0.015435, 0.034875, 0.055575, 0.050725, 0.0254, 0.00974, 0.0091925, 0.0219275, 0.039025, 0.0349, 0.017085, 0.0070675, 0.0075975, 0.01772, 0.026275, 0.017175, 0.006105, 0.0018695, 0.00133525, 0.003475, 0.0092075, 0.0131, 0.008165, 0.00318, 0.002389, 0.0057, 0.0124275, 0.014965, 0.010285, 0.004415, 0.001334, 0.00034575, 7.155e-05, 1.35175e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1625100425, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.405e-09, 1.055e-07, 6.675e-07, 2.4965e-06, 1.05625e-05, 4.225e-05, 0.000153825, 0.000453, 0.0009305, 0.00138175, 0.0018555, 0.0021555, 0.002213, 0.002665, 0.0029875, 0.002995, 0.003175, 0.0031175, 0.0033375, 0.0040025, 0.004115, 0.003995, 0.0035125, 0.003495, 0.0044925, 0.0049875, 0.004825, 0.0046975, 0.0039975, 0.0042525, 0.005045, 0.0050875, 0.004905, 0.00486, 0.00538, 0.0059925, 0.0054625, 0.005195, 0.004675, 0.0041975, 0.0053375, 0.00638, 0.0065525, 0.0066425, 0.00581, 0.005205, 0.0051575, 0.005375, 0.0058675, 0.0056925, 0.005785, 0.006915, 0.0069025, 0.0065675, 0.00568, 0.005215, 0.00645, 0.0072075, 0.006655, 0.0057875, 0.0050425, 0.00584, 0.0066475, 0.0067375, 0.006805, 0.006715, 0.00754, 0.00828, 0.00659, 0.00529, 0.004935, 0.004945, 0.0063275, 0.00757, 0.008005, 0.0072725, 0.0065075, 0.00704, 0.0071025, 0.0069175, 0.0068675, 0.005885, 0.0060225, 0.007095, 0.0074875, 0.007205, 0.006205, 0.0064675, 0.0073025, 0.0072875, 0.007735, 0.007245, 0.006785, 0.007495, 0.0076175, 0.0072575, 0.0066375, 0.00603, 0.0064275, 0.0065925, 0.005875, 0.0046725, 0.0047175, 0.0064875, 0.0074525, 0.0072375, 0.00702, 0.00642, 0.0065125, 0.0061725, 0.0050825, 0.0043125, 0.0044525, 0.0054725, 0.006095, 0.005785, 0.0055075, 0.00512, 0.00496, 0.00521, 0.0053475, 0.004905, 0.0038325, 0.00287, 0.003325, 0.0047975, 0.0059825, 0.0061, 0.0060675, 0.006225, 0.005465, 0.0051725, 0.004995, 0.0045725, 0.0051525, 0.0056275, 0.0057675, 0.005925, 0.0059925, 0.0059625, 0.005865, 0.0067275, 0.0074475, 0.0071125, 0.00691, 0.0065075, 0.005635, 0.0051075, 0.00587, 0.0068175, 0.0061275, 0.00505, 0.0047625, 0.0050225, 0.0060075, 0.006465, 0.0064775, 0.00686, 0.007075, 0.0071275, 0.00674, 0.0061775, 0.006115, 0.00586, 0.0058025, 0.005565, 0.0058925, 0.0066425, 0.0065625, 0.0062075, 0.006035, 0.0061, 0.006145, 0.0053075, 0.0047325, 0.0047125, 0.00502, 0.005925, 0.006765, 0.00737, 0.0074225, 0.00731, 0.006805, 0.00611, 0.0057275, 0.00488, 0.0041025, 0.0047025, 0.0060575, 0.0066375, 0.0059375, 0.00547, 0.0057275, 0.0053525, 0.0052275, 0.0049925, 0.004855, 0.0053575, 0.00574, 0.0059625, 0.0059125, 0.006425, 0.0063275, 0.0054775, 0.0048025, 0.0047175, 0.0051975, 0.00542, 0.00523, 0.0047325, 0.0037575, 0.0038875, 0.004305, 0.003465, 0.0029, 0.0031025, 0.0034125, 0.0035125, 0.003565, 0.0033375, 0.0029425, 0.0028375, 0.00214875, 0.00121425, 0.000905, 0.000908, 0.00111475, 0.0015105, 0.00177625, 0.00147875, 0.0010885, 0.0009, 0.0010405, 0.0013725, 0.0012615, 0.0010655, 0.00108175, 0.0009155, 0.00065, 0.00060225, 0.0007685, 0.0008295, 0.00078675, 0.0006645, 0.00050075, 0.00040825, 0.00038375, 0.000545, 0.00058725, 0.0004275, 0.000220225, 0.00011255, 0.00017275, 0.00039875, 0.00057225, 0.00045625, 0.000211175, 7.5825e-05, 6.0675e-05, 0.00012735, 0.0001938, 0.0001403, 5.6825e-05, 2.7075e-05, 4.7775e-05, 0.000124875, 0.00018725, 0.00012255, 4.34e-05, 1.25975e-05, 6.55e-06, 1.3935e-05, 3.6075e-05, 5.1325e-05, 3.2e-05, 1.251e-05, 9.545e-06, 2.2505e-05, 4.5775e-05, 4.5425e-05, 2.19525e-05, 6.8225e-06, 1.7805e-06, 4.415e-07, 4.43e-08, 2.4905e-11, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1625100425, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.405e-09, 1.055e-07, 6.675e-07, 2.4965e-06, 1.05625e-05, 4.225e-05, 0.000153825, 0.000453, 0.0009305, 0.00138175, 0.0018555, 0.0021555, 0.002213, 0.002665, 0.0029875, 0.002995, 0.003175, 0.0031175, 0.0033375, 0.0040025, 0.004115, 0.003995, 0.0035125, 0.003495, 0.0044925, 0.0049875, 0.004825, 0.0046975, 0.0039975, 0.0042525, 0.005045, 0.0050875, 0.004905, 0.00486, 0.00538, 0.0059925, 0.0054625, 0.005195, 0.004675, 0.0041975, 0.0053375, 0.00638, 0.0065525, 0.0066425, 0.00581, 0.005205, 0.0051575, 0.005375, 0.0058675, 0.0056925, 0.005785, 0.006915, 0.0069025, 0.0065675, 0.00568, 0.005215, 0.00645, 0.0072075, 0.006655, 0.0057875, 0.0050425, 0.00584, 0.0066475, 0.0067375, 0.006805, 0.006715, 0.00754, 0.00828, 0.00659, 0.00529, 0.004935, 0.004945, 0.0063275, 0.00757, 0.008005, 0.0072725, 0.0065075, 0.00704, 0.0071025, 0.0069175, 0.0068675, 0.005885, 0.0060225, 0.007095, 0.0074875, 0.007205, 0.006205, 0.0064675, 0.0073025, 0.0072875, 0.007735, 0.007245, 0.006785, 0.007495, 0.0076175, 0.0072575, 0.0066375, 0.00603, 0.0064275, 0.0065925, 0.005875, 0.0046725, 0.0047175, 0.0064875, 0.0074525, 0.0072375, 0.00702, 0.00642, 0.0065125, 0.0061725, 0.0050825, 0.0043125, 0.0044525, 0.0054725, 0.006095, 0.005785, 0.0055075, 0.00512, 0.00496, 0.00521, 0.0053475, 0.004905, 0.0038325, 0.00287, 0.003325, 0.0047975, 0.0059825, 0.0061, 0.0060675, 0.006225, 0.005465, 0.0051725, 0.004995, 0.0045725, 0.0051525, 0.0056275, 0.0057675, 0.005925, 0.0059925, 0.0059625, 0.005865, 0.0067275, 0.0074475, 0.0071125, 0.00691, 0.0065075, 0.005635, 0.0051075, 0.00587, 0.0068175, 0.0061275, 0.00505, 0.0047625, 0.0050225, 0.0060075, 0.006465, 0.0064775, 0.00686, 0.007075, 0.0071275, 0.00674, 0.0061775, 0.006115, 0.00586, 0.0058025, 0.005565, 0.0058925, 0.0066425, 0.0065625, 0.0062075, 0.006035, 0.0061, 0.006145, 0.0053075, 0.0047325, 0.0047125, 0.00502, 0.005925, 0.006765, 0.00737, 0.0074225, 0.00731, 0.006805, 0.00611, 0.0057275, 0.00488, 0.0041025, 0.0047025, 0.0060575, 0.0066375, 0.0059375, 0.00547, 0.0057275, 0.0053525, 0.0052275, 0.0049925, 0.004855, 0.0053575, 0.00574, 0.0059625, 0.0059125, 0.006425, 0.0063275, 0.0054775, 0.0048025, 0.0047175, 0.0051975, 0.00542, 0.00523, 0.0047325, 0.0037575, 0.0038875, 0.004305, 0.003465, 0.0029, 0.0031025, 0.0034125, 0.0035125, 0.003565, 0.0033375, 0.0029425, 0.0028375, 0.00214875, 0.00121425, 0.000905, 0.000908, 0.00111475, 0.0015105, 0.00177625, 0.00147875, 0.0010885, 0.0009, 0.0010405, 0.0013725, 0.0012615, 0.0010655, 0.00108175, 0.0009155, 0.00065, 0.00060225, 0.0007685, 0.0008295, 0.00078675, 0.0006645, 0.00050075, 0.00040825, 0.00038375, 0.000545, 0.00058725, 0.0004275, 0.000220225, 0.00011255, 0.00017275, 0.00039875, 0.00057225, 0.00045625, 0.000211175, 7.5825e-05, 6.0675e-05, 0.00012735, 0.0001938, 0.0001403, 5.6825e-05, 2.7075e-05, 4.7775e-05, 0.000124875, 0.00018725, 0.00012255, 4.34e-05, 1.25975e-05, 6.55e-06, 1.3935e-05, 3.6075e-05, 5.1325e-05, 3.2e-05, 1.251e-05, 9.545e-06, 2.2505e-05, 4.5775e-05, 4.5425e-05, 2.19525e-05, 6.8225e-06, 1.7805e-06, 4.415e-07, 4.43e-08, 2.4905e-11, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1625100425, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.405e-09, 1.055e-07, 6.675e-07, 2.4965e-06, 1.05625e-05, 4.225e-05, 0.000153825, 0.000453, 0.0009305, 0.00138175, 0.0018555, 0.0021555, 0.002213, 0.002665, 0.0029875, 0.002995, 0.003175, 0.0031175, 0.0033375, 0.0040025, 0.004115, 0.003995, 0.0035125, 0.003495, 0.0044925, 0.0049875, 0.004825, 0.0046975, 0.0039975, 0.0042525, 0.005045, 0.0050875, 0.004905, 0.00486, 0.00538, 0.0059925, 0.0054625, 0.005195, 0.004675, 0.0041975, 0.0053375, 0.00638, 0.0065525, 0.0066425, 0.00581, 0.005205, 0.0051575, 0.005375, 0.0058675, 0.0056925, 0.005785, 0.006915, 0.0069025, 0.0065675, 0.00568, 0.005215, 0.00645, 0.0072075, 0.006655, 0.0057875, 0.0050425, 0.00584, 0.0066475, 0.0067375, 0.006805, 0.006715, 0.00754, 0.00828, 0.00659, 0.00529, 0.004935, 0.004945, 0.0063275, 0.00757, 0.008005, 0.0072725, 0.0065075, 0.00704, 0.0071025, 0.0069175, 0.0068675, 0.005885, 0.0060225, 0.007095, 0.0074875, 0.007205, 0.006205, 0.0064675, 0.0073025, 0.0072875, 0.007735, 0.007245, 0.006785, 0.007495, 0.0076175, 0.0072575, 0.0066375, 0.00603, 0.0064275, 0.0065925, 0.005875, 0.0046725, 0.0047175, 0.0064875, 0.0074525, 0.0072375, 0.00702, 0.00642, 0.0065125, 0.0061725, 0.0050825, 0.0043125, 0.0044525, 0.0054725, 0.006095, 0.005785, 0.0055075, 0.00512, 0.00496, 0.00521, 0.0053475, 0.004905, 0.0038325, 0.00287, 0.003325, 0.0047975, 0.0059825, 0.0061, 0.0060675, 0.006225, 0.005465, 0.0051725, 0.004995, 0.0045725, 0.0051525, 0.0056275, 0.0057675, 0.005925, 0.0059925, 0.0059625, 0.005865, 0.0067275, 0.0074475, 0.0071125, 0.00691, 0.0065075, 0.005635, 0.0051075, 0.00587, 0.0068175, 0.0061275, 0.00505, 0.0047625, 0.0050225, 0.0060075, 0.006465, 0.0064775, 0.00686, 0.007075, 0.0071275, 0.00674, 0.0061775, 0.006115, 0.00586, 0.0058025, 0.005565, 0.0058925, 0.0066425, 0.0065625, 0.0062075, 0.006035, 0.0061, 0.006145, 0.0053075, 0.0047325, 0.0047125, 0.00502, 0.005925, 0.006765, 0.00737, 0.0074225, 0.00731, 0.006805, 0.00611, 0.0057275, 0.00488, 0.0041025, 0.0047025, 0.0060575, 0.0066375, 0.0059375, 0.00547, 0.0057275, 0.0053525, 0.0052275, 0.0049925, 0.004855, 0.0053575, 0.00574, 0.0059625, 0.0059125, 0.006425, 0.0063275, 0.0054775, 0.0048025, 0.0047175, 0.0051975, 0.00542, 0.00523, 0.0047325, 0.0037575, 0.0038875, 0.004305, 0.003465, 0.0029, 0.0031025, 0.0034125, 0.0035125, 0.003565, 0.0033375, 0.0029425, 0.0028375, 0.00214875, 0.00121425, 0.000905, 0.000908, 0.00111475, 0.0015105, 0.00177625, 0.00147875, 0.0010885, 0.0009, 0.0010405, 0.0013725, 0.0012615, 0.0010655, 0.00108175, 0.0009155, 0.00065, 0.00060225, 0.0007685, 0.0008295, 0.00078675, 0.0006645, 0.00050075, 0.00040825, 0.00038375, 0.000545, 0.00058725, 0.0004275, 0.000220225, 0.00011255, 0.00017275, 0.00039875, 0.00057225, 0.00045625, 0.000211175, 7.5825e-05, 6.0675e-05, 0.00012735, 0.0001938, 0.0001403, 5.6825e-05, 2.7075e-05, 4.7775e-05, 0.000124875, 0.00018725, 0.00012255, 4.34e-05, 1.25975e-05, 6.55e-06, 1.3935e-05, 3.6075e-05, 5.1325e-05, 3.2e-05, 1.251e-05, 9.545e-06, 2.2505e-05, 4.5775e-05, 4.5425e-05, 2.19525e-05, 6.8225e-06, 1.7805e-06, 4.415e-07, 4.43e-08, 2.4905e-11, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1625100425, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.405e-09, 1.055e-07, 6.675e-07, 2.4965e-06, 1.05625e-05, 4.225e-05, 0.000153825, 0.000453, 0.0009305, 0.00138175, 0.0018555, 0.0021555, 0.002213, 0.002665, 0.0029875, 0.002995, 0.003175, 0.0031175, 0.0033375, 0.0040025, 0.004115, 0.003995, 0.0035125, 0.003495, 0.0044925, 0.0049875, 0.004825, 0.0046975, 0.0039975, 0.0042525, 0.005045, 0.0050875, 0.004905, 0.00486, 0.00538, 0.0059925, 0.0054625, 0.005195, 0.004675, 0.0041975, 0.0053375, 0.00638, 0.0065525, 0.0066425, 0.00581, 0.005205, 0.0051575, 0.005375, 0.0058675, 0.0056925, 0.005785, 0.006915, 0.0069025, 0.0065675, 0.00568, 0.005215, 0.00645, 0.0072075, 0.006655, 0.0057875, 0.0050425, 0.00584, 0.0066475, 0.0067375, 0.006805, 0.006715, 0.00754, 0.00828, 0.00659, 0.00529, 0.004935, 0.004945, 0.0063275, 0.00757, 0.008005, 0.0072725, 0.0065075, 0.00704, 0.0071025, 0.0069175, 0.0068675, 0.005885, 0.0060225, 0.007095, 0.0074875, 0.007205, 0.006205, 0.0064675, 0.0073025, 0.0072875, 0.007735, 0.007245, 0.006785, 0.007495, 0.0076175, 0.0072575, 0.0066375, 0.00603, 0.0064275, 0.0065925, 0.005875, 0.0046725, 0.0047175, 0.0064875, 0.0074525, 0.0072375, 0.00702, 0.00642, 0.0065125, 0.0061725, 0.0050825, 0.0043125, 0.0044525, 0.0054725, 0.006095, 0.005785, 0.0055075, 0.00512, 0.00496, 0.00521, 0.0053475, 0.004905, 0.0038325, 0.00287, 0.003325, 0.0047975, 0.0059825, 0.0061, 0.0060675, 0.006225, 0.005465, 0.0051725, 0.004995, 0.0045725, 0.0051525, 0.0056275, 0.0057675, 0.005925, 0.0059925, 0.0059625, 0.005865, 0.0067275, 0.0074475, 0.0071125, 0.00691, 0.0065075, 0.005635, 0.0051075, 0.00587, 0.0068175, 0.0061275, 0.00505, 0.0047625, 0.0050225, 0.0060075, 0.006465, 0.0064775, 0.00686, 0.007075, 0.0071275, 0.00674, 0.0061775, 0.006115, 0.00586, 0.0058025, 0.005565, 0.0058925, 0.0066425, 0.0065625, 0.0062075, 0.006035, 0.0061, 0.006145, 0.0053075, 0.0047325, 0.0047125, 0.00502, 0.005925, 0.006765, 0.00737, 0.0074225, 0.00731, 0.006805, 0.00611, 0.0057275, 0.00488, 0.0041025, 0.0047025, 0.0060575, 0.0066375, 0.0059375, 0.00547, 0.0057275, 0.0053525, 0.0052275, 0.0049925, 0.004855, 0.0053575, 0.00574, 0.0059625, 0.0059125, 0.006425, 0.0063275, 0.0054775, 0.0048025, 0.0047175, 0.0051975, 0.00542, 0.00523, 0.0047325, 0.0037575, 0.0038875, 0.004305, 0.003465, 0.0029, 0.0031025, 0.0034125, 0.0035125, 0.003565, 0.0033375, 0.0029425, 0.0028375, 0.00214875, 0.00121425, 0.000905, 0.000908, 0.00111475, 0.0015105, 0.00177625, 0.00147875, 0.0010885, 0.0009, 0.0010405, 0.0013725, 0.0012615, 0.0010655, 0.00108175, 0.0009155, 0.00065, 0.00060225, 0.0007685, 0.0008295, 0.00078675, 0.0006645, 0.00050075, 0.00040825, 0.00038375, 0.000545, 0.00058725, 0.0004275, 0.000220225, 0.00011255, 0.00017275, 0.00039875, 0.00057225, 0.00045625, 0.000211175, 7.5825e-05, 6.0675e-05, 0.00012735, 0.0001938, 0.0001403, 5.6825e-05, 2.7075e-05, 4.7775e-05, 0.000124875, 0.00018725, 0.00012255, 4.34e-05, 1.25975e-05, 6.55e-06, 1.3935e-05, 3.6075e-05, 5.1325e-05, 3.2e-05, 1.251e-05, 9.545e-06, 2.2505e-05, 4.5775e-05, 4.5425e-05, 2.19525e-05, 6.8225e-06, 1.7805e-06, 4.415e-07, 4.43e-08, 2.4905e-11, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.6905e-07, 2.09075e-06, 1.3005e-05, 4.705e-05, 0.000197675, 0.00074975, 0.0026675, 0.00766, 0.015585, 0.02322, 0.031225, 0.036425, 0.037825, 0.0455, 0.0512, 0.05175, 0.054975, 0.054475, 0.05855, 0.07015, 0.072675, 0.0709, 0.0631, 0.063, 0.080525, 0.090125, 0.0879, 0.085975, 0.0742, 0.0785, 0.0932, 0.09505, 0.0922, 0.091975, 0.101575, 0.113775, 0.105225, 0.10005, 0.091325, 0.08225, 0.103325, 0.124725, 0.129375, 0.13195, 0.11725, 0.10505, 0.1043, 0.108825, 0.11905, 0.11745, 0.11885, 0.142075, 0.144475, 0.138175, 0.12175, 0.110825, 0.135325, 0.1539, 0.1442, 0.1268, 0.11055, 0.126, 0.145875, 0.1496, 0.15195, 0.151125, 0.16685, 0.18695, 0.154675, 0.123125, 0.114725, 0.1136, 0.142925, 0.174375, 0.1875, 0.1756, 0.156525, 0.16815, 0.172475, 0.168025, 0.167325, 0.146375, 0.14535, 0.171575, 0.183025, 0.18115, 0.159375, 0.1594, 0.178075, 0.1784, 0.1892, 0.186825, 0.173375, 0.18845, 0.19635, 0.18765, 0.176825, 0.168775, 0.18255, 0.192075, 0.173375, 0.14025, 0.14295, 0.193425, 0.233275, 0.234925, 0.22585, 0.210775, 0.2155, 0.2151, 0.18605, 0.1585, 0.159775, 0.19475, 0.23155, 0.231625, 0.21905, 0.214975, 0.213725, 0.2225, 0.224725, 0.2123, 0.1881, 0.154025, 0.161075, 0.205875, 0.235225, 0.230775, 0.228125, 0.244925, 0.236025, 0.209075, 0.190075, 0.16885, 0.190975, 0.23225, 0.235725, 0.20795, 0.191825, 0.214975, 0.2325, 0.240725, 0.24715, 0.2483, 0.2615, 0.27025, 0.2449, 0.203625, 0.195325, 0.2173, 0.2221, 0.197775, 0.18905, 0.208275, 0.25325, 0.28125, 0.2785, 0.2735, 0.2545, 0.2575, 0.25575, 0.22685, 0.21605, 0.2144, 0.223925, 0.239, 0.262, 0.29925, 0.2955, 0.2645, 0.26475, 0.26975, 0.243725, 0.192925, 0.182325, 0.2132, 0.237875, 0.26525, 0.27675, 0.30225, 0.33475, 0.3405, 0.321, 0.27025, 0.2436, 0.233175, 0.2071, 0.2199, 0.2695, 0.30025, 0.28425, 0.264, 0.28525, 0.28375, 0.271, 0.2815, 0.2805, 0.2795, 0.26675, 0.26725, 0.275, 0.3065, 0.3335, 0.3165, 0.28425, 0.279, 0.31125, 0.33175, 0.3085, 0.27825, 0.241175, 0.239475, 0.282, 0.2635, 0.21985, 0.22045, 0.21785, 0.214675, 0.2279, 0.23895, 0.230675, 0.21555, 0.1718, 0.108, 0.086775, 0.09265, 0.099475, 0.1141, 0.124575, 0.108625, 0.081075, 0.065675, 0.0752, 0.09595, 0.0952, 0.07995, 0.08935, 0.085925, 0.0612, 0.05165, 0.056725, 0.05725, 0.052875, 0.050325, 0.046575, 0.043375, 0.038375, 0.04635, 0.056875, 0.05635, 0.04285, 0.0220575, 0.0175325, 0.03365, 0.055175, 0.053325, 0.02845, 0.010655, 0.007415, 0.01598, 0.032875, 0.039275, 0.0251, 0.0108825, 0.008205, 0.0165575, 0.02625, 0.019235, 0.00745, 0.00229375, 0.001252, 0.0027125, 0.007575, 0.0129925, 0.0101025, 0.0044875, 0.003175, 0.006715, 0.013275, 0.01454, 0.009635, 0.00425, 0.00133575, 0.000358, 7.7025e-05, 1.59625e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1774004775, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0225e-08, 1.26175e-07, 7.83e-07, 2.8325e-06, 1.1895e-05, 4.5125e-05, 0.000160525, 0.0004605, 0.00093525, 0.001389, 0.00186075, 0.0021625, 0.00223475, 0.002675, 0.003, 0.0030175, 0.0031925, 0.0031475, 0.003365, 0.004015, 0.0041425, 0.0040225, 0.003565, 0.003535, 0.004495, 0.005015, 0.00487, 0.0047425, 0.004075, 0.0042825, 0.0050625, 0.00514, 0.00496, 0.0049225, 0.0054075, 0.006035, 0.00556, 0.0052575, 0.0047775, 0.004275, 0.0053375, 0.0064175, 0.006625, 0.006725, 0.0059525, 0.0053075, 0.00524, 0.00544, 0.0059225, 0.005815, 0.0058425, 0.00695, 0.0070375, 0.0066975, 0.0058775, 0.005315, 0.00645, 0.0073175, 0.00684, 0.00599, 0.0051825, 0.0058525, 0.0067375, 0.006875, 0.00695, 0.00689, 0.0075775, 0.0084525, 0.0069575, 0.0055125, 0.00512, 0.00505, 0.0063175, 0.0076625, 0.0081825, 0.0076075, 0.0067275, 0.0071875, 0.0073625, 0.007175, 0.00715, 0.006235, 0.0061625, 0.007275, 0.0077225, 0.007565, 0.0066725, 0.0068025, 0.00768, 0.0076825, 0.007975, 0.0077225, 0.0072075, 0.0078075, 0.008075, 0.00767, 0.006925, 0.00625, 0.006605, 0.00694, 0.0063025, 0.00491, 0.004665, 0.0063425, 0.007605, 0.007625, 0.0073875, 0.0067225, 0.006645, 0.00645, 0.0054325, 0.004545, 0.004475, 0.005385, 0.0062475, 0.0061375, 0.0056475, 0.00519, 0.005105, 0.00543, 0.005555, 0.0050675, 0.00411, 0.00305, 0.0031975, 0.004785, 0.006235, 0.006365, 0.0061975, 0.0062375, 0.0058175, 0.00552, 0.0052575, 0.0047175, 0.0051175, 0.0061425, 0.0067275, 0.006205, 0.0054675, 0.00571, 0.00645, 0.0072575, 0.007215, 0.0069175, 0.00703, 0.0068975, 0.0062925, 0.0057025, 0.00614, 0.0065475, 0.00596, 0.005075, 0.0046675, 0.004805, 0.005815, 0.0065175, 0.006875, 0.0073575, 0.0070925, 0.0071925, 0.007055, 0.00645, 0.00627, 0.00593, 0.0056675, 0.005475, 0.0057125, 0.0066725, 0.00681, 0.00587, 0.0056075, 0.00639, 0.0067725, 0.005525, 0.004505, 0.0046725, 0.005135, 0.0059975, 0.0065325, 0.00691, 0.0072575, 0.00751, 0.0073325, 0.0062925, 0.00563, 0.00502, 0.0042425, 0.004495, 0.0057275, 0.006525, 0.0059325, 0.005245, 0.0056325, 0.00551, 0.0050875, 0.00492, 0.0049625, 0.00576, 0.0060725, 0.0058175, 0.005525, 0.00591, 0.0062975, 0.00583, 0.0051, 0.0046425, 0.0049075, 0.005375, 0.0052975, 0.0048425, 0.00386, 0.003575, 0.004105, 0.003665, 0.003055, 0.0033375, 0.003635, 0.0035275, 0.00351, 0.00337, 0.003025, 0.002945, 0.00245725, 0.00137, 0.00083325, 0.00083875, 0.001088, 0.00152875, 0.00190025, 0.00169125, 0.001223, 0.00092275, 0.00102075, 0.001352, 0.001292, 0.0009935, 0.00104525, 0.00102725, 0.00074075, 0.00060625, 0.000757, 0.0008695, 0.00082975, 0.00069925, 0.000522, 0.0004335, 0.0003775, 0.000495, 0.00057, 0.0004325, 0.000271, 0.00015215, 0.00018455, 0.00040875, 0.00063275, 0.00055825, 0.0002825, 0.0001006, 5.745e-05, 0.0001021, 0.0001706, 0.000149725, 7.4e-05, 3.4125e-05, 4.735e-05, 0.000120325, 0.000195725, 0.00014395, 5.565e-05, 1.6535e-05, 6.85e-06, 1.1075e-05, 2.9525e-05, 5.065e-05, 3.9425e-05, 1.7695e-05, 1.30675e-05, 2.785e-05, 5.1925e-05, 4.7475e-05, 2.17375e-05, 6.6925e-06, 1.77675e-06, 4.52e-07, 4.6375e-08, 6.5375e-11, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1774004775, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0225e-08, 1.26175e-07, 7.83e-07, 2.8325e-06, 1.1895e-05, 4.5125e-05, 0.000160525, 0.0004605, 0.00093525, 0.001389, 0.00186075, 0.0021625, 0.00223475, 0.002675, 0.003, 0.0030175, 0.0031925, 0.0031475, 0.003365, 0.004015, 0.0041425, 0.0040225, 0.003565, 0.003535, 0.004495, 0.005015, 0.00487, 0.0047425, 0.004075, 0.0042825, 0.0050625, 0.00514, 0.00496, 0.0049225, 0.0054075, 0.006035, 0.00556, 0.0052575, 0.0047775, 0.004275, 0.0053375, 0.0064175, 0.006625, 0.006725, 0.0059525, 0.0053075, 0.00524, 0.00544, 0.0059225, 0.005815, 0.0058425, 0.00695, 0.0070375, 0.0066975, 0.0058775, 0.005315, 0.00645, 0.0073175, 0.00684, 0.00599, 0.0051825, 0.0058525, 0.0067375, 0.006875, 0.00695, 0.00689, 0.0075775, 0.0084525, 0.0069575, 0.0055125, 0.00512, 0.00505, 0.0063175, 0.0076625, 0.0081825, 0.0076075, 0.0067275, 0.0071875, 0.0073625, 0.007175, 0.00715, 0.006235, 0.0061625, 0.007275, 0.0077225, 0.007565, 0.0066725, 0.0068025, 0.00768, 0.0076825, 0.007975, 0.0077225, 0.0072075, 0.0078075, 0.008075, 0.00767, 0.006925, 0.00625, 0.006605, 0.00694, 0.0063025, 0.00491, 0.004665, 0.0063425, 0.007605, 0.007625, 0.0073875, 0.0067225, 0.006645, 0.00645, 0.0054325, 0.004545, 0.004475, 0.005385, 0.0062475, 0.0061375, 0.0056475, 0.00519, 0.005105, 0.00543, 0.005555, 0.0050675, 0.00411, 0.00305, 0.0031975, 0.004785, 0.006235, 0.006365, 0.0061975, 0.0062375, 0.0058175, 0.00552, 0.0052575, 0.0047175, 0.0051175, 0.0061425, 0.0067275, 0.006205, 0.0054675, 0.00571, 0.00645, 0.0072575, 0.007215, 0.0069175, 0.00703, 0.0068975, 0.0062925, 0.0057025, 0.00614, 0.0065475, 0.00596, 0.005075, 0.0046675, 0.004805, 0.005815, 0.0065175, 0.006875, 0.0073575, 0.0070925, 0.0071925, 0.007055, 0.00645, 0.00627, 0.00593, 0.0056675, 0.005475, 0.0057125, 0.0066725, 0.00681, 0.00587, 0.0056075, 0.00639, 0.0067725, 0.005525, 0.004505, 0.0046725, 0.005135, 0.0059975, 0.0065325, 0.00691, 0.0072575, 0.00751, 0.0073325, 0.0062925, 0.00563, 0.00502, 0.0042425, 0.004495, 0.0057275, 0.006525, 0.0059325, 0.005245, 0.0056325, 0.00551, 0.0050875, 0.00492, 0.0049625, 0.00576, 0.0060725, 0.0058175, 0.005525, 0.00591, 0.0062975, 0.00583, 0.0051, 0.0046425, 0.0049075, 0.005375, 0.0052975, 0.0048425, 0.00386, 0.003575, 0.004105, 0.003665, 0.003055, 0.0033375, 0.003635, 0.0035275, 0.00351, 0.00337, 0.003025, 0.002945, 0.00245725, 0.00137, 0.00083325, 0.00083875, 0.001088, 0.00152875, 0.00190025, 0.00169125, 0.001223, 0.00092275, 0.00102075, 0.001352, 0.001292, 0.0009935, 0.00104525, 0.00102725, 0.00074075, 0.00060625, 0.000757, 0.0008695, 0.00082975, 0.00069925, 0.000522, 0.0004335, 0.0003775, 0.000495, 0.00057, 0.0004325, 0.000271, 0.00015215, 0.00018455, 0.00040875, 0.00063275, 0.00055825, 0.0002825, 0.0001006, 5.745e-05, 0.0001021, 0.0001706, 0.000149725, 7.4e-05, 3.4125e-05, 4.735e-05, 0.000120325, 0.000195725, 0.00014395, 5.565e-05, 1.6535e-05, 6.85e-06, 1.1075e-05, 2.9525e-05, 5.065e-05, 3.9425e-05, 1.7695e-05, 1.30675e-05, 2.785e-05, 5.1925e-05, 4.7475e-05, 2.17375e-05, 6.6925e-06, 1.77675e-06, 4.52e-07, 4.6375e-08, 6.5375e-11, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1774004775, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0225e-08, 1.26175e-07, 7.83e-07, 2.8325e-06, 1.1895e-05, 4.5125e-05, 0.000160525, 0.0004605, 0.00093525, 0.001389, 0.00186075, 0.0021625, 0.00223475, 0.002675, 0.003, 0.0030175, 0.0031925, 0.0031475, 0.003365, 0.004015, 0.0041425, 0.0040225, 0.003565, 0.003535, 0.004495, 0.005015, 0.00487, 0.0047425, 0.004075, 0.0042825, 0.0050625, 0.00514, 0.00496, 0.0049225, 0.0054075, 0.006035, 0.00556, 0.0052575, 0.0047775, 0.004275, 0.0053375, 0.0064175, 0.006625, 0.006725, 0.0059525, 0.0053075, 0.00524, 0.00544, 0.0059225, 0.005815, 0.0058425, 0.00695, 0.0070375, 0.0066975, 0.0058775, 0.005315, 0.00645, 0.0073175, 0.00684, 0.00599, 0.0051825, 0.0058525, 0.0067375, 0.006875, 0.00695, 0.00689, 0.0075775, 0.0084525, 0.0069575, 0.0055125, 0.00512, 0.00505, 0.0063175, 0.0076625, 0.0081825, 0.0076075, 0.0067275, 0.0071875, 0.0073625, 0.007175, 0.00715, 0.006235, 0.0061625, 0.007275, 0.0077225, 0.007565, 0.0066725, 0.0068025, 0.00768, 0.0076825, 0.007975, 0.0077225, 0.0072075, 0.0078075, 0.008075, 0.00767, 0.006925, 0.00625, 0.006605, 0.00694, 0.0063025, 0.00491, 0.004665, 0.0063425, 0.007605, 0.007625, 0.0073875, 0.0067225, 0.006645, 0.00645, 0.0054325, 0.004545, 0.004475, 0.005385, 0.0062475, 0.0061375, 0.0056475, 0.00519, 0.005105, 0.00543, 0.005555, 0.0050675, 0.00411, 0.00305, 0.0031975, 0.004785, 0.006235, 0.006365, 0.0061975, 0.0062375, 0.0058175, 0.00552, 0.0052575, 0.0047175, 0.0051175, 0.0061425, 0.0067275, 0.006205, 0.0054675, 0.00571, 0.00645, 0.0072575, 0.007215, 0.0069175, 0.00703, 0.0068975, 0.0062925, 0.0057025, 0.00614, 0.0065475, 0.00596, 0.005075, 0.0046675, 0.004805, 0.005815, 0.0065175, 0.006875, 0.0073575, 0.0070925, 0.0071925, 0.007055, 0.00645, 0.00627, 0.00593, 0.0056675, 0.005475, 0.0057125, 0.0066725, 0.00681, 0.00587, 0.0056075, 0.00639, 0.0067725, 0.005525, 0.004505, 0.0046725, 0.005135, 0.0059975, 0.0065325, 0.00691, 0.0072575, 0.00751, 0.0073325, 0.0062925, 0.00563, 0.00502, 0.0042425, 0.004495, 0.0057275, 0.006525, 0.0059325, 0.005245, 0.0056325, 0.00551, 0.0050875, 0.00492, 0.0049625, 0.00576, 0.0060725, 0.0058175, 0.005525, 0.00591, 0.0062975, 0.00583, 0.0051, 0.0046425, 0.0049075, 0.005375, 0.0052975, 0.0048425, 0.00386, 0.003575, 0.004105, 0.003665, 0.003055, 0.0033375, 0.003635, 0.0035275, 0.00351, 0.00337, 0.003025, 0.002945, 0.00245725, 0.00137, 0.00083325, 0.00083875, 0.001088, 0.00152875, 0.00190025, 0.00169125, 0.001223, 0.00092275, 0.00102075, 0.001352, 0.001292, 0.0009935, 0.00104525, 0.00102725, 0.00074075, 0.00060625, 0.000757, 0.0008695, 0.00082975, 0.00069925, 0.000522, 0.0004335, 0.0003775, 0.000495, 0.00057, 0.0004325, 0.000271, 0.00015215, 0.00018455, 0.00040875, 0.00063275, 0.00055825, 0.0002825, 0.0001006, 5.745e-05, 0.0001021, 0.0001706, 0.000149725, 7.4e-05, 3.4125e-05, 4.735e-05, 0.000120325, 0.000195725, 0.00014395, 5.565e-05, 1.6535e-05, 6.85e-06, 1.1075e-05, 2.9525e-05, 5.065e-05, 3.9425e-05, 1.7695e-05, 1.30675e-05, 2.785e-05, 5.1925e-05, 4.7475e-05, 2.17375e-05, 6.6925e-06, 1.77675e-06, 4.52e-07, 4.6375e-08, 6.5375e-11, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1774004775, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0225e-08, 1.26175e-07, 7.83e-07, 2.8325e-06, 1.1895e-05, 4.5125e-05, 0.000160525, 0.0004605, 0.00093525, 0.001389, 0.00186075, 0.0021625, 0.00223475, 0.002675, 0.003, 0.0030175, 0.0031925, 0.0031475, 0.003365, 0.004015, 0.0041425, 0.0040225, 0.003565, 0.003535, 0.004495, 0.005015, 0.00487, 0.0047425, 0.004075, 0.0042825, 0.0050625, 0.00514, 0.00496, 0.0049225, 0.0054075, 0.006035, 0.00556, 0.0052575, 0.0047775, 0.004275, 0.0053375, 0.0064175, 0.006625, 0.006725, 0.0059525, 0.0053075, 0.00524, 0.00544, 0.0059225, 0.005815, 0.0058425, 0.00695, 0.0070375, 0.0066975, 0.0058775, 0.005315, 0.00645, 0.0073175, 0.00684, 0.00599, 0.0051825, 0.0058525, 0.0067375, 0.006875, 0.00695, 0.00689, 0.0075775, 0.0084525, 0.0069575, 0.0055125, 0.00512, 0.00505, 0.0063175, 0.0076625, 0.0081825, 0.0076075, 0.0067275, 0.0071875, 0.0073625, 0.007175, 0.00715, 0.006235, 0.0061625, 0.007275, 0.0077225, 0.007565, 0.0066725, 0.0068025, 0.00768, 0.0076825, 0.007975, 0.0077225, 0.0072075, 0.0078075, 0.008075, 0.00767, 0.006925, 0.00625, 0.006605, 0.00694, 0.0063025, 0.00491, 0.004665, 0.0063425, 0.007605, 0.007625, 0.0073875, 0.0067225, 0.006645, 0.00645, 0.0054325, 0.004545, 0.004475, 0.005385, 0.0062475, 0.0061375, 0.0056475, 0.00519, 0.005105, 0.00543, 0.005555, 0.0050675, 0.00411, 0.00305, 0.0031975, 0.004785, 0.006235, 0.006365, 0.0061975, 0.0062375, 0.0058175, 0.00552, 0.0052575, 0.0047175, 0.0051175, 0.0061425, 0.0067275, 0.006205, 0.0054675, 0.00571, 0.00645, 0.0072575, 0.007215, 0.0069175, 0.00703, 0.0068975, 0.0062925, 0.0057025, 0.00614, 0.0065475, 0.00596, 0.005075, 0.0046675, 0.004805, 0.005815, 0.0065175, 0.006875, 0.0073575, 0.0070925, 0.0071925, 0.007055, 0.00645, 0.00627, 0.00593, 0.0056675, 0.005475, 0.0057125, 0.0066725, 0.00681, 0.00587, 0.0056075, 0.00639, 0.0067725, 0.005525, 0.004505, 0.0046725, 0.005135, 0.0059975, 0.0065325, 0.00691, 0.0072575, 0.00751, 0.0073325, 0.0062925, 0.00563, 0.00502, 0.0042425, 0.004495, 0.0057275, 0.006525, 0.0059325, 0.005245, 0.0056325, 0.00551, 0.0050875, 0.00492, 0.0049625, 0.00576, 0.0060725, 0.0058175, 0.005525, 0.00591, 0.0062975, 0.00583, 0.0051, 0.0046425, 0.0049075, 0.005375, 0.0052975, 0.0048425, 0.00386, 0.003575, 0.004105, 0.003665, 0.003055, 0.0033375, 0.003635, 0.0035275, 0.00351, 0.00337, 0.003025, 0.002945, 0.00245725, 0.00137, 0.00083325, 0.00083875, 0.001088, 0.00152875, 0.00190025, 0.00169125, 0.001223, 0.00092275, 0.00102075, 0.001352, 0.001292, 0.0009935, 0.00104525, 0.00102725, 0.00074075, 0.00060625, 0.000757, 0.0008695, 0.00082975, 0.00069925, 0.000522, 0.0004335, 0.0003775, 0.000495, 0.00057, 0.0004325, 0.000271, 0.00015215, 0.00018455, 0.00040875, 0.00063275, 0.00055825, 0.0002825, 0.0001006, 5.745e-05, 0.0001021, 0.0001706, 0.000149725, 7.4e-05, 3.4125e-05, 4.735e-05, 0.000120325, 0.000195725, 0.00014395, 5.565e-05, 1.6535e-05, 6.85e-06, 1.1075e-05, 2.9525e-05, 5.065e-05, 3.9425e-05, 1.7695e-05, 1.30675e-05, 2.785e-05, 5.1925e-05, 4.7475e-05, 2.17375e-05, 6.6925e-06, 1.77675e-06, 4.52e-07, 4.6375e-08, 6.5375e-11, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.07525e-07, 2.525e-06, 1.541e-05, 5.395e-05, 0.0002214, 0.000814, 0.002815, 0.007895, 0.015875, 0.0236475, 0.031725, 0.037, 0.038675, 0.04625, 0.052025, 0.052775, 0.055925, 0.05565, 0.0597, 0.071125, 0.073925, 0.072175, 0.06475, 0.0644, 0.081475, 0.0915, 0.0896, 0.087575, 0.076275, 0.0798, 0.09445, 0.096825, 0.09415, 0.093875, 0.102925, 0.11535, 0.107725, 0.101975, 0.09375, 0.08435, 0.103825, 0.12605, 0.13145, 0.1342, 0.1206, 0.107625, 0.1063, 0.11055, 0.12045, 0.120175, 0.120425, 0.143, 0.14735, 0.1411, 0.125825, 0.11325, 0.13535, 0.15595, 0.14795, 0.13085, 0.113625, 0.12615, 0.147175, 0.15215, 0.1547, 0.1545, 0.16745, 0.1892, 0.161925, 0.127825, 0.118325, 0.115575, 0.14195, 0.174625, 0.189475, 0.1811, 0.16055, 0.1697, 0.1765, 0.17205, 0.1714, 0.15225, 0.1471, 0.172625, 0.185025, 0.185175, 0.167325, 0.16405, 0.181425, 0.181675, 0.188075, 0.191675, 0.179075, 0.189425, 0.2, 0.191, 0.1758, 0.16805, 0.18165, 0.195425, 0.181925, 0.1447, 0.138225, 0.1857, 0.2304, 0.241375, 0.2335, 0.21525, 0.21295, 0.217675, 0.1968, 0.1689, 0.159175, 0.18615, 0.2245, 0.2379, 0.222475, 0.213975, 0.219875, 0.227275, 0.2296, 0.21565, 0.194875, 0.165975, 0.15875, 0.203975, 0.24315, 0.23945, 0.22815, 0.23725, 0.24765, 0.2277, 0.20405, 0.180725, 0.1822, 0.228575, 0.247725, 0.21725, 0.194275, 0.21125, 0.24255, 0.242425, 0.2406, 0.25325, 0.2605, 0.26975, 0.26525, 0.2308, 0.205725, 0.2035, 0.21535, 0.2085, 0.1899, 0.198925, 0.24195, 0.283, 0.29525, 0.29025, 0.27025, 0.26325, 0.2635, 0.2461, 0.220875, 0.209175, 0.21355, 0.2303, 0.25375, 0.2955, 0.30475, 0.27125, 0.269, 0.299, 0.2825, 0.20545, 0.167075, 0.199775, 0.23565, 0.2665, 0.282, 0.28975, 0.32475, 0.35375, 0.34075, 0.2975, 0.25675, 0.234925, 0.217, 0.212625, 0.25925, 0.304, 0.29225, 0.269, 0.28325, 0.29225, 0.27475, 0.27575, 0.2945, 0.31225, 0.288, 0.2595, 0.2665, 0.29575, 0.33425, 0.3315, 0.30025, 0.27275, 0.29525, 0.33825, 0.33475, 0.29825, 0.2545, 0.2377, 0.27375, 0.283, 0.2438, 0.23295, 0.23325, 0.218375, 0.2233, 0.229725, 0.23065, 0.227825, 0.201925, 0.1295, 0.085125, 0.088525, 0.1043, 0.12, 0.1325, 0.1214, 0.0919, 0.0686, 0.075625, 0.098625, 0.09765, 0.07835, 0.080425, 0.089675, 0.0714, 0.0541, 0.060725, 0.06435, 0.055875, 0.04865, 0.044775, 0.045025, 0.041075, 0.04365, 0.052275, 0.0517, 0.04935, 0.034525, 0.02243, 0.030925, 0.048575, 0.054375, 0.0375, 0.0159475, 0.00788, 0.01203, 0.02525, 0.0373, 0.03345, 0.017665, 0.010345, 0.016095, 0.02605, 0.020965, 0.00881, 0.00272, 0.0009945, 0.00124925, 0.003645, 0.009425, 0.0133275, 0.0091925, 0.00578, 0.0086975, 0.0143175, 0.013725, 0.008725, 0.003935, 0.001278, 0.0003535, 6.865e-05, 1.78075e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1915973975, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.239e-08, 1.5035e-07, 9.16e-07, 3.2075e-06, 1.31525e-05, 4.8375e-05, 0.000167225, 0.0004685, 0.0009405, 0.00139675, 0.001867, 0.00217075, 0.00225775, 0.0026875, 0.0030125, 0.0030425, 0.00321, 0.00318, 0.0033925, 0.0040275, 0.00417, 0.004055, 0.0036225, 0.00358, 0.0045075, 0.005045, 0.0049175, 0.00479, 0.0041525, 0.0043175, 0.00509, 0.005195, 0.0050275, 0.0049875, 0.00544, 0.0060775, 0.005655, 0.0053275, 0.0048775, 0.0043625, 0.0053375, 0.0064525, 0.0067, 0.00681, 0.0061, 0.00542, 0.0053225, 0.00551, 0.0059775, 0.0059375, 0.00591, 0.0069825, 0.0071675, 0.006835, 0.00607, 0.0054325, 0.0064525, 0.00742, 0.007025, 0.0061925, 0.00534, 0.0058775, 0.00682, 0.007015, 0.0071025, 0.007075, 0.007645, 0.0086025, 0.0073275, 0.00576, 0.00532, 0.0051825, 0.006335, 0.00775, 0.0083575, 0.0079325, 0.00698, 0.007345, 0.0076325, 0.007455, 0.0074425, 0.006595, 0.00635, 0.0074625, 0.007975, 0.00791, 0.0071825, 0.007205, 0.0080775, 0.0080925, 0.00819, 0.00816, 0.007695, 0.00813, 0.0085175, 0.0081175, 0.0072125, 0.00651, 0.0068175, 0.0072625, 0.0067075, 0.0052025, 0.004665, 0.00622, 0.0076975, 0.007995, 0.0078, 0.007125, 0.0068225, 0.0066225, 0.005705, 0.00485, 0.0046025, 0.0053575, 0.006335, 0.0064975, 0.005895, 0.00522, 0.00523, 0.00567, 0.0058125, 0.0052275, 0.00431, 0.00333, 0.003225, 0.00478, 0.0064675, 0.0066725, 0.00632, 0.0061625, 0.0061725, 0.0058775, 0.0055, 0.005125, 0.0053325, 0.0066725, 0.00719, 0.005905, 0.005115, 0.005915, 0.00719, 0.0073225, 0.0067325, 0.0068375, 0.0072775, 0.0073575, 0.0070275, 0.00643, 0.006165, 0.00591, 0.0055875, 0.0052025, 0.0047625, 0.0047275, 0.0056875, 0.006695, 0.007045, 0.0072125, 0.0071625, 0.007485, 0.0074225, 0.0068825, 0.0064025, 0.00586, 0.005505, 0.0054425, 0.00568, 0.00668, 0.0066525, 0.0054125, 0.00534, 0.00671, 0.0074025, 0.00581, 0.0042925, 0.0045175, 0.0052175, 0.0060675, 0.0065025, 0.00664, 0.0071275, 0.0076825, 0.00734, 0.00634, 0.0057, 0.0051825, 0.0044975, 0.0043675, 0.005275, 0.00629, 0.0059425, 0.0051975, 0.00555, 0.0056425, 0.0050025, 0.004785, 0.00514, 0.0061625, 0.0063025, 0.0055875, 0.0052175, 0.0054525, 0.0061625, 0.0061125, 0.005445, 0.004665, 0.0045925, 0.0051725, 0.00537, 0.00493, 0.0040225, 0.00343, 0.00382, 0.00381, 0.0033525, 0.0035025, 0.00373, 0.00352, 0.0034675, 0.003405, 0.0032, 0.0031075, 0.0027825, 0.001659, 0.000846, 0.0007345, 0.00101525, 0.00150075, 0.00191675, 0.001841, 0.0013865, 0.000994, 0.00105925, 0.0014415, 0.0014005, 0.00103175, 0.0009735, 0.00104225, 0.0008425, 0.00064925, 0.0008055, 0.00097125, 0.0009065, 0.000726, 0.0005125, 0.000442, 0.00039775, 0.000467, 0.000568, 0.0004375, 0.000287, 0.0001922, 0.0001935, 0.00037225, 0.00056825, 0.0005515, 0.000346, 0.000141225, 6.5225e-05, 8.7625e-05, 0.0001502, 0.000148675, 8.8975e-05, 4.4425e-05, 4.92e-05, 0.000116825, 0.000200925, 0.00016345, 6.8675e-05, 2.08775e-05, 6.4075e-06, 4.6575e-06, 1.0995e-05, 2.845e-05, 4.0425e-05, 2.8825e-05, 2.13925e-05, 3.7175e-05, 5.935e-05, 4.7125e-05, 1.973e-05, 5.96e-06, 1.6055e-06, 4.185e-07, 1.35875e-11, 3.525e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1915973975, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.239e-08, 1.5035e-07, 9.16e-07, 3.2075e-06, 1.31525e-05, 4.8375e-05, 0.000167225, 0.0004685, 0.0009405, 0.00139675, 0.001867, 0.00217075, 0.00225775, 0.0026875, 0.0030125, 0.0030425, 0.00321, 0.00318, 0.0033925, 0.0040275, 0.00417, 0.004055, 0.0036225, 0.00358, 0.0045075, 0.005045, 0.0049175, 0.00479, 0.0041525, 0.0043175, 0.00509, 0.005195, 0.0050275, 0.0049875, 0.00544, 0.0060775, 0.005655, 0.0053275, 0.0048775, 0.0043625, 0.0053375, 0.0064525, 0.0067, 0.00681, 0.0061, 0.00542, 0.0053225, 0.00551, 0.0059775, 0.0059375, 0.00591, 0.0069825, 0.0071675, 0.006835, 0.00607, 0.0054325, 0.0064525, 0.00742, 0.007025, 0.0061925, 0.00534, 0.0058775, 0.00682, 0.007015, 0.0071025, 0.007075, 0.007645, 0.0086025, 0.0073275, 0.00576, 0.00532, 0.0051825, 0.006335, 0.00775, 0.0083575, 0.0079325, 0.00698, 0.007345, 0.0076325, 0.007455, 0.0074425, 0.006595, 0.00635, 0.0074625, 0.007975, 0.00791, 0.0071825, 0.007205, 0.0080775, 0.0080925, 0.00819, 0.00816, 0.007695, 0.00813, 0.0085175, 0.0081175, 0.0072125, 0.00651, 0.0068175, 0.0072625, 0.0067075, 0.0052025, 0.004665, 0.00622, 0.0076975, 0.007995, 0.0078, 0.007125, 0.0068225, 0.0066225, 0.005705, 0.00485, 0.0046025, 0.0053575, 0.006335, 0.0064975, 0.005895, 0.00522, 0.00523, 0.00567, 0.0058125, 0.0052275, 0.00431, 0.00333, 0.003225, 0.00478, 0.0064675, 0.0066725, 0.00632, 0.0061625, 0.0061725, 0.0058775, 0.0055, 0.005125, 0.0053325, 0.0066725, 0.00719, 0.005905, 0.005115, 0.005915, 0.00719, 0.0073225, 0.0067325, 0.0068375, 0.0072775, 0.0073575, 0.0070275, 0.00643, 0.006165, 0.00591, 0.0055875, 0.0052025, 0.0047625, 0.0047275, 0.0056875, 0.006695, 0.007045, 0.0072125, 0.0071625, 0.007485, 0.0074225, 0.0068825, 0.0064025, 0.00586, 0.005505, 0.0054425, 0.00568, 0.00668, 0.0066525, 0.0054125, 0.00534, 0.00671, 0.0074025, 0.00581, 0.0042925, 0.0045175, 0.0052175, 0.0060675, 0.0065025, 0.00664, 0.0071275, 0.0076825, 0.00734, 0.00634, 0.0057, 0.0051825, 0.0044975, 0.0043675, 0.005275, 0.00629, 0.0059425, 0.0051975, 0.00555, 0.0056425, 0.0050025, 0.004785, 0.00514, 0.0061625, 0.0063025, 0.0055875, 0.0052175, 0.0054525, 0.0061625, 0.0061125, 0.005445, 0.004665, 0.0045925, 0.0051725, 0.00537, 0.00493, 0.0040225, 0.00343, 0.00382, 0.00381, 0.0033525, 0.0035025, 0.00373, 0.00352, 0.0034675, 0.003405, 0.0032, 0.0031075, 0.0027825, 0.001659, 0.000846, 0.0007345, 0.00101525, 0.00150075, 0.00191675, 0.001841, 0.0013865, 0.000994, 0.00105925, 0.0014415, 0.0014005, 0.00103175, 0.0009735, 0.00104225, 0.0008425, 0.00064925, 0.0008055, 0.00097125, 0.0009065, 0.000726, 0.0005125, 0.000442, 0.00039775, 0.000467, 0.000568, 0.0004375, 0.000287, 0.0001922, 0.0001935, 0.00037225, 0.00056825, 0.0005515, 0.000346, 0.000141225, 6.5225e-05, 8.7625e-05, 0.0001502, 0.000148675, 8.8975e-05, 4.4425e-05, 4.92e-05, 0.000116825, 0.000200925, 0.00016345, 6.8675e-05, 2.08775e-05, 6.4075e-06, 4.6575e-06, 1.0995e-05, 2.845e-05, 4.0425e-05, 2.8825e-05, 2.13925e-05, 3.7175e-05, 5.935e-05, 4.7125e-05, 1.973e-05, 5.96e-06, 1.6055e-06, 4.185e-07, 1.35875e-11, 3.525e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1915973975, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.239e-08, 1.5035e-07, 9.16e-07, 3.2075e-06, 1.31525e-05, 4.8375e-05, 0.000167225, 0.0004685, 0.0009405, 0.00139675, 0.001867, 0.00217075, 0.00225775, 0.0026875, 0.0030125, 0.0030425, 0.00321, 0.00318, 0.0033925, 0.0040275, 0.00417, 0.004055, 0.0036225, 0.00358, 0.0045075, 0.005045, 0.0049175, 0.00479, 0.0041525, 0.0043175, 0.00509, 0.005195, 0.0050275, 0.0049875, 0.00544, 0.0060775, 0.005655, 0.0053275, 0.0048775, 0.0043625, 0.0053375, 0.0064525, 0.0067, 0.00681, 0.0061, 0.00542, 0.0053225, 0.00551, 0.0059775, 0.0059375, 0.00591, 0.0069825, 0.0071675, 0.006835, 0.00607, 0.0054325, 0.0064525, 0.00742, 0.007025, 0.0061925, 0.00534, 0.0058775, 0.00682, 0.007015, 0.0071025, 0.007075, 0.007645, 0.0086025, 0.0073275, 0.00576, 0.00532, 0.0051825, 0.006335, 0.00775, 0.0083575, 0.0079325, 0.00698, 0.007345, 0.0076325, 0.007455, 0.0074425, 0.006595, 0.00635, 0.0074625, 0.007975, 0.00791, 0.0071825, 0.007205, 0.0080775, 0.0080925, 0.00819, 0.00816, 0.007695, 0.00813, 0.0085175, 0.0081175, 0.0072125, 0.00651, 0.0068175, 0.0072625, 0.0067075, 0.0052025, 0.004665, 0.00622, 0.0076975, 0.007995, 0.0078, 0.007125, 0.0068225, 0.0066225, 0.005705, 0.00485, 0.0046025, 0.0053575, 0.006335, 0.0064975, 0.005895, 0.00522, 0.00523, 0.00567, 0.0058125, 0.0052275, 0.00431, 0.00333, 0.003225, 0.00478, 0.0064675, 0.0066725, 0.00632, 0.0061625, 0.0061725, 0.0058775, 0.0055, 0.005125, 0.0053325, 0.0066725, 0.00719, 0.005905, 0.005115, 0.005915, 0.00719, 0.0073225, 0.0067325, 0.0068375, 0.0072775, 0.0073575, 0.0070275, 0.00643, 0.006165, 0.00591, 0.0055875, 0.0052025, 0.0047625, 0.0047275, 0.0056875, 0.006695, 0.007045, 0.0072125, 0.0071625, 0.007485, 0.0074225, 0.0068825, 0.0064025, 0.00586, 0.005505, 0.0054425, 0.00568, 0.00668, 0.0066525, 0.0054125, 0.00534, 0.00671, 0.0074025, 0.00581, 0.0042925, 0.0045175, 0.0052175, 0.0060675, 0.0065025, 0.00664, 0.0071275, 0.0076825, 0.00734, 0.00634, 0.0057, 0.0051825, 0.0044975, 0.0043675, 0.005275, 0.00629, 0.0059425, 0.0051975, 0.00555, 0.0056425, 0.0050025, 0.004785, 0.00514, 0.0061625, 0.0063025, 0.0055875, 0.0052175, 0.0054525, 0.0061625, 0.0061125, 0.005445, 0.004665, 0.0045925, 0.0051725, 0.00537, 0.00493, 0.0040225, 0.00343, 0.00382, 0.00381, 0.0033525, 0.0035025, 0.00373, 0.00352, 0.0034675, 0.003405, 0.0032, 0.0031075, 0.0027825, 0.001659, 0.000846, 0.0007345, 0.00101525, 0.00150075, 0.00191675, 0.001841, 0.0013865, 0.000994, 0.00105925, 0.0014415, 0.0014005, 0.00103175, 0.0009735, 0.00104225, 0.0008425, 0.00064925, 0.0008055, 0.00097125, 0.0009065, 0.000726, 0.0005125, 0.000442, 0.00039775, 0.000467, 0.000568, 0.0004375, 0.000287, 0.0001922, 0.0001935, 0.00037225, 0.00056825, 0.0005515, 0.000346, 0.000141225, 6.5225e-05, 8.7625e-05, 0.0001502, 0.000148675, 8.8975e-05, 4.4425e-05, 4.92e-05, 0.000116825, 0.000200925, 0.00016345, 6.8675e-05, 2.08775e-05, 6.4075e-06, 4.6575e-06, 1.0995e-05, 2.845e-05, 4.0425e-05, 2.8825e-05, 2.13925e-05, 3.7175e-05, 5.935e-05, 4.7125e-05, 1.973e-05, 5.96e-06, 1.6055e-06, 4.185e-07, 1.35875e-11, 3.525e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1915973975, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.239e-08, 1.5035e-07, 9.16e-07, 3.2075e-06, 1.31525e-05, 4.8375e-05, 0.000167225, 0.0004685, 0.0009405, 0.00139675, 0.001867, 0.00217075, 0.00225775, 0.0026875, 0.0030125, 0.0030425, 0.00321, 0.00318, 0.0033925, 0.0040275, 0.00417, 0.004055, 0.0036225, 0.00358, 0.0045075, 0.005045, 0.0049175, 0.00479, 0.0041525, 0.0043175, 0.00509, 0.005195, 0.0050275, 0.0049875, 0.00544, 0.0060775, 0.005655, 0.0053275, 0.0048775, 0.0043625, 0.0053375, 0.0064525, 0.0067, 0.00681, 0.0061, 0.00542, 0.0053225, 0.00551, 0.0059775, 0.0059375, 0.00591, 0.0069825, 0.0071675, 0.006835, 0.00607, 0.0054325, 0.0064525, 0.00742, 0.007025, 0.0061925, 0.00534, 0.0058775, 0.00682, 0.007015, 0.0071025, 0.007075, 0.007645, 0.0086025, 0.0073275, 0.00576, 0.00532, 0.0051825, 0.006335, 0.00775, 0.0083575, 0.0079325, 0.00698, 0.007345, 0.0076325, 0.007455, 0.0074425, 0.006595, 0.00635, 0.0074625, 0.007975, 0.00791, 0.0071825, 0.007205, 0.0080775, 0.0080925, 0.00819, 0.00816, 0.007695, 0.00813, 0.0085175, 0.0081175, 0.0072125, 0.00651, 0.0068175, 0.0072625, 0.0067075, 0.0052025, 0.004665, 0.00622, 0.0076975, 0.007995, 0.0078, 0.007125, 0.0068225, 0.0066225, 0.005705, 0.00485, 0.0046025, 0.0053575, 0.006335, 0.0064975, 0.005895, 0.00522, 0.00523, 0.00567, 0.0058125, 0.0052275, 0.00431, 0.00333, 0.003225, 0.00478, 0.0064675, 0.0066725, 0.00632, 0.0061625, 0.0061725, 0.0058775, 0.0055, 0.005125, 0.0053325, 0.0066725, 0.00719, 0.005905, 0.005115, 0.005915, 0.00719, 0.0073225, 0.0067325, 0.0068375, 0.0072775, 0.0073575, 0.0070275, 0.00643, 0.006165, 0.00591, 0.0055875, 0.0052025, 0.0047625, 0.0047275, 0.0056875, 0.006695, 0.007045, 0.0072125, 0.0071625, 0.007485, 0.0074225, 0.0068825, 0.0064025, 0.00586, 0.005505, 0.0054425, 0.00568, 0.00668, 0.0066525, 0.0054125, 0.00534, 0.00671, 0.0074025, 0.00581, 0.0042925, 0.0045175, 0.0052175, 0.0060675, 0.0065025, 0.00664, 0.0071275, 0.0076825, 0.00734, 0.00634, 0.0057, 0.0051825, 0.0044975, 0.0043675, 0.005275, 0.00629, 0.0059425, 0.0051975, 0.00555, 0.0056425, 0.0050025, 0.004785, 0.00514, 0.0061625, 0.0063025, 0.0055875, 0.0052175, 0.0054525, 0.0061625, 0.0061125, 0.005445, 0.004665, 0.0045925, 0.0051725, 0.00537, 0.00493, 0.0040225, 0.00343, 0.00382, 0.00381, 0.0033525, 0.0035025, 0.00373, 0.00352, 0.0034675, 0.003405, 0.0032, 0.0031075, 0.0027825, 0.001659, 0.000846, 0.0007345, 0.00101525, 0.00150075, 0.00191675, 0.001841, 0.0013865, 0.000994, 0.00105925, 0.0014415, 0.0014005, 0.00103175, 0.0009735, 0.00104225, 0.0008425, 0.00064925, 0.0008055, 0.00097125, 0.0009065, 0.000726, 0.0005125, 0.000442, 0.00039775, 0.000467, 0.000568, 0.0004375, 0.000287, 0.0001922, 0.0001935, 0.00037225, 0.00056825, 0.0005515, 0.000346, 0.000141225, 6.5225e-05, 8.7625e-05, 0.0001502, 0.000148675, 8.8975e-05, 4.4425e-05, 4.92e-05, 0.000116825, 0.000200925, 0.00016345, 6.8675e-05, 2.08775e-05, 6.4075e-06, 4.6575e-06, 1.0995e-05, 2.845e-05, 4.0425e-05, 2.8825e-05, 2.13925e-05, 3.7175e-05, 5.935e-05, 4.7125e-05, 1.973e-05, 5.96e-06, 1.6055e-06, 4.185e-07, 1.35875e-11, 3.525e-12, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.53e-07, 4.9175e-06, 1.62775e-05, 6.16e-05, 0.000247175, 0.000882, 0.0029675, 0.0081325, 0.0161725, 0.0240825, 0.032225, 0.0376, 0.039525, 0.047025, 0.052875, 0.0538, 0.0569, 0.056825, 0.060875, 0.072125, 0.07525, 0.073475, 0.0663, 0.06585, 0.082475, 0.092875, 0.091275, 0.089175, 0.078325, 0.081225, 0.09565, 0.098525, 0.096025, 0.095775, 0.104425, 0.116925, 0.110125, 0.103925, 0.096075, 0.08655, 0.1047, 0.127475, 0.133575, 0.136525, 0.123775, 0.1103, 0.108375, 0.112525, 0.122025, 0.1229, 0.1224, 0.144175, 0.1501, 0.14395, 0.129575, 0.116, 0.135975, 0.158075, 0.151525, 0.13475, 0.116825, 0.127, 0.14855, 0.15485, 0.157425, 0.158025, 0.16895, 0.1913, 0.167975, 0.132675, 0.1217, 0.11815, 0.1419, 0.175375, 0.191525, 0.1857, 0.164925, 0.1718, 0.180275, 0.176425, 0.175275, 0.157475, 0.14995, 0.17445, 0.18745, 0.18875, 0.17505, 0.170175, 0.185775, 0.184925, 0.1872, 0.195375, 0.185575, 0.1913, 0.203575, 0.194575, 0.175375, 0.16665, 0.18045, 0.19655, 0.1869, 0.151275, 0.13585, 0.178875, 0.2274, 0.24495, 0.2417, 0.22245, 0.21135, 0.213975, 0.20245, 0.181925, 0.165, 0.18095, 0.216975, 0.238375, 0.2279, 0.2105, 0.22315, 0.2357, 0.2346, 0.218425, 0.19745, 0.1767, 0.1644, 0.200275, 0.249575, 0.24915, 0.23105, 0.231025, 0.25025, 0.2434, 0.220525, 0.199975, 0.187225, 0.2174, 0.241525, 0.223925, 0.20955, 0.2198, 0.243025, 0.241425, 0.23295, 0.257, 0.273, 0.271, 0.2695, 0.25075, 0.219325, 0.1975, 0.20585, 0.216475, 0.200225, 0.1939, 0.23145, 0.27675, 0.2955, 0.30775, 0.2965, 0.2795, 0.26825, 0.259, 0.23195, 0.205875, 0.205325, 0.223175, 0.246875, 0.2825, 0.29925, 0.282, 0.2785, 0.3175, 0.32025, 0.234575, 0.16295, 0.183075, 0.231925, 0.26625, 0.2855, 0.2895, 0.31175, 0.34775, 0.34925, 0.32425, 0.285, 0.246675, 0.2217, 0.212575, 0.2421, 0.3015, 0.304, 0.2765, 0.28675, 0.294, 0.2785, 0.277, 0.301, 0.33325, 0.3165, 0.2635, 0.2555, 0.2865, 0.33325, 0.345, 0.3165, 0.2775, 0.2775, 0.328, 0.35475, 0.32175, 0.27375, 0.241575, 0.2655, 0.29075, 0.2715, 0.2472, 0.243, 0.2298, 0.2253, 0.227175, 0.226925, 0.230375, 0.220275, 0.1575, 0.09315, 0.080725, 0.1025, 0.129675, 0.14325, 0.13405, 0.102325, 0.072675, 0.07395, 0.098775, 0.098325, 0.0777, 0.0739, 0.088375, 0.083675, 0.062475, 0.0635, 0.07075, 0.06105, 0.0492, 0.04535, 0.04725, 0.040975, 0.04065, 0.0489, 0.0462, 0.0459, 0.044175, 0.031825, 0.031575, 0.04005, 0.0442, 0.04365, 0.0289, 0.0139575, 0.01212, 0.02115, 0.032525, 0.0365, 0.0247175, 0.014025, 0.017155, 0.02625, 0.0217425, 0.00948, 0.00303, 0.00109125, 0.00121475, 0.003355, 0.00883, 0.0133775, 0.0100725, 0.0062925, 0.00825, 0.0127725, 0.013835, 0.01044, 0.00498, 0.00165525, 0.00046975, 0.000112675, 1.944e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.2051608375, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4925e-08, 2.89e-07, 9.5625e-07, 3.6175e-06, 1.45075e-05, 5.1775e-05, 0.000174175, 0.000477, 0.00094675, 0.00140575, 0.00187475, 0.00218075, 0.002282, 0.0027025, 0.00303, 0.00307, 0.0032325, 0.003215, 0.0034275, 0.0040425, 0.0042025, 0.00409, 0.003675, 0.00363, 0.004525, 0.0050775, 0.00497, 0.0048375, 0.00423, 0.0043625, 0.0051175, 0.0052525, 0.005095, 0.0050575, 0.0054875, 0.006125, 0.0057475, 0.0054, 0.0049725, 0.004455, 0.0053575, 0.0065, 0.00678, 0.006905, 0.00624, 0.0055375, 0.005415, 0.005595, 0.006045, 0.0060625, 0.006, 0.007035, 0.0072975, 0.0069725, 0.0062525, 0.0055675, 0.00649, 0.00753, 0.00721, 0.0063925, 0.0055075, 0.00594, 0.0069075, 0.00717, 0.0072625, 0.0072725, 0.00776, 0.008755, 0.0076525, 0.0060225, 0.005515, 0.0053475, 0.0063975, 0.007865, 0.0085425, 0.0082275, 0.00726, 0.0075325, 0.0079025, 0.00776, 0.0077375, 0.00694, 0.0065925, 0.0076925, 0.008255, 0.008255, 0.007715, 0.0076925, 0.008525, 0.0084975, 0.0083875, 0.0085575, 0.0082225, 0.008475, 0.0089525, 0.0085525, 0.0075175, 0.00682, 0.0070975, 0.007575, 0.007015, 0.0054875, 0.004775, 0.0061675, 0.0077975, 0.008335, 0.0082075, 0.00761, 0.0071025, 0.0066875, 0.0058275, 0.0051475, 0.004895, 0.00545, 0.0064225, 0.006805, 0.0062025, 0.0052575, 0.0053375, 0.00595, 0.0061, 0.005375, 0.004405, 0.003615, 0.00349, 0.0049075, 0.0067, 0.0069925, 0.0064025, 0.0061125, 0.00644, 0.0062, 0.0058025, 0.005775, 0.0059825, 0.0068625, 0.006645, 0.00547, 0.005425, 0.0065525, 0.00742, 0.0070125, 0.006365, 0.006885, 0.0077325, 0.0079975, 0.0075625, 0.006705, 0.0060775, 0.0053, 0.0051, 0.00532, 0.00506, 0.0048775, 0.0057125, 0.00671, 0.0066375, 0.006995, 0.00752, 0.0079075, 0.0077375, 0.0073025, 0.006535, 0.005705, 0.005405, 0.0055475, 0.005825, 0.006285, 0.006025, 0.005215, 0.005375, 0.0069925, 0.0077925, 0.006055, 0.0042, 0.0043475, 0.00529, 0.006165, 0.0066575, 0.0067125, 0.0071075, 0.00745, 0.006925, 0.00632, 0.0058675, 0.005385, 0.004775, 0.004335, 0.00485, 0.0059725, 0.005905, 0.0052475, 0.00557, 0.005705, 0.0049725, 0.00472, 0.0053675, 0.0064075, 0.006415, 0.0054125, 0.0048775, 0.0051425, 0.0059925, 0.006275, 0.0057025, 0.004775, 0.00438, 0.004845, 0.0053575, 0.004985, 0.0041375, 0.003455, 0.00362, 0.00383, 0.0036625, 0.00361, 0.00369, 0.003525, 0.00338, 0.0032575, 0.00311, 0.00315, 0.0029875, 0.00197, 0.00095975, 0.00066675, 0.0009275, 0.00150925, 0.0019995, 0.00198275, 0.00153275, 0.00106975, 0.00107175, 0.00145675, 0.001408, 0.00101625, 0.0009075, 0.001035, 0.000935, 0.000699, 0.00079775, 0.001021, 0.00097575, 0.000761, 0.0005445, 0.0004825, 0.00041075, 0.0004405, 0.000563, 0.0004505, 0.00027475, 0.00020995, 0.000217775, 0.00035775, 0.000483, 0.000422, 0.00030225, 0.000165775, 8.1325e-05, 8.5925e-05, 0.00014035, 0.00014335, 9.1475e-05, 5.1575e-05, 5.4425e-05, 0.000121025, 0.000207425, 0.00017455, 7.66e-05, 2.41325e-05, 7.4075e-06, 4.6025e-06, 9.5175e-06, 2.505e-05, 3.815e-05, 2.96e-05, 2.146e-05, 3.2025e-05, 4.4625e-05, 3.3875e-05, 1.57125e-05, 5.405e-06, 1.56975e-06, 4.27e-07, 4.8525e-08, 1.9015e-10, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.2051608375, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4925e-08, 2.89e-07, 9.5625e-07, 3.6175e-06, 1.45075e-05, 5.1775e-05, 0.000174175, 0.000477, 0.00094675, 0.00140575, 0.00187475, 0.00218075, 0.002282, 0.0027025, 0.00303, 0.00307, 0.0032325, 0.003215, 0.0034275, 0.0040425, 0.0042025, 0.00409, 0.003675, 0.00363, 0.004525, 0.0050775, 0.00497, 0.0048375, 0.00423, 0.0043625, 0.0051175, 0.0052525, 0.005095, 0.0050575, 0.0054875, 0.006125, 0.0057475, 0.0054, 0.0049725, 0.004455, 0.0053575, 0.0065, 0.00678, 0.006905, 0.00624, 0.0055375, 0.005415, 0.005595, 0.006045, 0.0060625, 0.006, 0.007035, 0.0072975, 0.0069725, 0.0062525, 0.0055675, 0.00649, 0.00753, 0.00721, 0.0063925, 0.0055075, 0.00594, 0.0069075, 0.00717, 0.0072625, 0.0072725, 0.00776, 0.008755, 0.0076525, 0.0060225, 0.005515, 0.0053475, 0.0063975, 0.007865, 0.0085425, 0.0082275, 0.00726, 0.0075325, 0.0079025, 0.00776, 0.0077375, 0.00694, 0.0065925, 0.0076925, 0.008255, 0.008255, 0.007715, 0.0076925, 0.008525, 0.0084975, 0.0083875, 0.0085575, 0.0082225, 0.008475, 0.0089525, 0.0085525, 0.0075175, 0.00682, 0.0070975, 0.007575, 0.007015, 0.0054875, 0.004775, 0.0061675, 0.0077975, 0.008335, 0.0082075, 0.00761, 0.0071025, 0.0066875, 0.0058275, 0.0051475, 0.004895, 0.00545, 0.0064225, 0.006805, 0.0062025, 0.0052575, 0.0053375, 0.00595, 0.0061, 0.005375, 0.004405, 0.003615, 0.00349, 0.0049075, 0.0067, 0.0069925, 0.0064025, 0.0061125, 0.00644, 0.0062, 0.0058025, 0.005775, 0.0059825, 0.0068625, 0.006645, 0.00547, 0.005425, 0.0065525, 0.00742, 0.0070125, 0.006365, 0.006885, 0.0077325, 0.0079975, 0.0075625, 0.006705, 0.0060775, 0.0053, 0.0051, 0.00532, 0.00506, 0.0048775, 0.0057125, 0.00671, 0.0066375, 0.006995, 0.00752, 0.0079075, 0.0077375, 0.0073025, 0.006535, 0.005705, 0.005405, 0.0055475, 0.005825, 0.006285, 0.006025, 0.005215, 0.005375, 0.0069925, 0.0077925, 0.006055, 0.0042, 0.0043475, 0.00529, 0.006165, 0.0066575, 0.0067125, 0.0071075, 0.00745, 0.006925, 0.00632, 0.0058675, 0.005385, 0.004775, 0.004335, 0.00485, 0.0059725, 0.005905, 0.0052475, 0.00557, 0.005705, 0.0049725, 0.00472, 0.0053675, 0.0064075, 0.006415, 0.0054125, 0.0048775, 0.0051425, 0.0059925, 0.006275, 0.0057025, 0.004775, 0.00438, 0.004845, 0.0053575, 0.004985, 0.0041375, 0.003455, 0.00362, 0.00383, 0.0036625, 0.00361, 0.00369, 0.003525, 0.00338, 0.0032575, 0.00311, 0.00315, 0.0029875, 0.00197, 0.00095975, 0.00066675, 0.0009275, 0.00150925, 0.0019995, 0.00198275, 0.00153275, 0.00106975, 0.00107175, 0.00145675, 0.001408, 0.00101625, 0.0009075, 0.001035, 0.000935, 0.000699, 0.00079775, 0.001021, 0.00097575, 0.000761, 0.0005445, 0.0004825, 0.00041075, 0.0004405, 0.000563, 0.0004505, 0.00027475, 0.00020995, 0.000217775, 0.00035775, 0.000483, 0.000422, 0.00030225, 0.000165775, 8.1325e-05, 8.5925e-05, 0.00014035, 0.00014335, 9.1475e-05, 5.1575e-05, 5.4425e-05, 0.000121025, 0.000207425, 0.00017455, 7.66e-05, 2.41325e-05, 7.4075e-06, 4.6025e-06, 9.5175e-06, 2.505e-05, 3.815e-05, 2.96e-05, 2.146e-05, 3.2025e-05, 4.4625e-05, 3.3875e-05, 1.57125e-05, 5.405e-06, 1.56975e-06, 4.27e-07, 4.8525e-08, 1.9015e-10, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.2051608375, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4925e-08, 2.89e-07, 9.5625e-07, 3.6175e-06, 1.45075e-05, 5.1775e-05, 0.000174175, 0.000477, 0.00094675, 0.00140575, 0.00187475, 0.00218075, 0.002282, 0.0027025, 0.00303, 0.00307, 0.0032325, 0.003215, 0.0034275, 0.0040425, 0.0042025, 0.00409, 0.003675, 0.00363, 0.004525, 0.0050775, 0.00497, 0.0048375, 0.00423, 0.0043625, 0.0051175, 0.0052525, 0.005095, 0.0050575, 0.0054875, 0.006125, 0.0057475, 0.0054, 0.0049725, 0.004455, 0.0053575, 0.0065, 0.00678, 0.006905, 0.00624, 0.0055375, 0.005415, 0.005595, 0.006045, 0.0060625, 0.006, 0.007035, 0.0072975, 0.0069725, 0.0062525, 0.0055675, 0.00649, 0.00753, 0.00721, 0.0063925, 0.0055075, 0.00594, 0.0069075, 0.00717, 0.0072625, 0.0072725, 0.00776, 0.008755, 0.0076525, 0.0060225, 0.005515, 0.0053475, 0.0063975, 0.007865, 0.0085425, 0.0082275, 0.00726, 0.0075325, 0.0079025, 0.00776, 0.0077375, 0.00694, 0.0065925, 0.0076925, 0.008255, 0.008255, 0.007715, 0.0076925, 0.008525, 0.0084975, 0.0083875, 0.0085575, 0.0082225, 0.008475, 0.0089525, 0.0085525, 0.0075175, 0.00682, 0.0070975, 0.007575, 0.007015, 0.0054875, 0.004775, 0.0061675, 0.0077975, 0.008335, 0.0082075, 0.00761, 0.0071025, 0.0066875, 0.0058275, 0.0051475, 0.004895, 0.00545, 0.0064225, 0.006805, 0.0062025, 0.0052575, 0.0053375, 0.00595, 0.0061, 0.005375, 0.004405, 0.003615, 0.00349, 0.0049075, 0.0067, 0.0069925, 0.0064025, 0.0061125, 0.00644, 0.0062, 0.0058025, 0.005775, 0.0059825, 0.0068625, 0.006645, 0.00547, 0.005425, 0.0065525, 0.00742, 0.0070125, 0.006365, 0.006885, 0.0077325, 0.0079975, 0.0075625, 0.006705, 0.0060775, 0.0053, 0.0051, 0.00532, 0.00506, 0.0048775, 0.0057125, 0.00671, 0.0066375, 0.006995, 0.00752, 0.0079075, 0.0077375, 0.0073025, 0.006535, 0.005705, 0.005405, 0.0055475, 0.005825, 0.006285, 0.006025, 0.005215, 0.005375, 0.0069925, 0.0077925, 0.006055, 0.0042, 0.0043475, 0.00529, 0.006165, 0.0066575, 0.0067125, 0.0071075, 0.00745, 0.006925, 0.00632, 0.0058675, 0.005385, 0.004775, 0.004335, 0.00485, 0.0059725, 0.005905, 0.0052475, 0.00557, 0.005705, 0.0049725, 0.00472, 0.0053675, 0.0064075, 0.006415, 0.0054125, 0.0048775, 0.0051425, 0.0059925, 0.006275, 0.0057025, 0.004775, 0.00438, 0.004845, 0.0053575, 0.004985, 0.0041375, 0.003455, 0.00362, 0.00383, 0.0036625, 0.00361, 0.00369, 0.003525, 0.00338, 0.0032575, 0.00311, 0.00315, 0.0029875, 0.00197, 0.00095975, 0.00066675, 0.0009275, 0.00150925, 0.0019995, 0.00198275, 0.00153275, 0.00106975, 0.00107175, 0.00145675, 0.001408, 0.00101625, 0.0009075, 0.001035, 0.000935, 0.000699, 0.00079775, 0.001021, 0.00097575, 0.000761, 0.0005445, 0.0004825, 0.00041075, 0.0004405, 0.000563, 0.0004505, 0.00027475, 0.00020995, 0.000217775, 0.00035775, 0.000483, 0.000422, 0.00030225, 0.000165775, 8.1325e-05, 8.5925e-05, 0.00014035, 0.00014335, 9.1475e-05, 5.1575e-05, 5.4425e-05, 0.000121025, 0.000207425, 0.00017455, 7.66e-05, 2.41325e-05, 7.4075e-06, 4.6025e-06, 9.5175e-06, 2.505e-05, 3.815e-05, 2.96e-05, 2.146e-05, 3.2025e-05, 4.4625e-05, 3.3875e-05, 1.57125e-05, 5.405e-06, 1.56975e-06, 4.27e-07, 4.8525e-08, 1.9015e-10, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.2051608375, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4925e-08, 2.89e-07, 9.5625e-07, 3.6175e-06, 1.45075e-05, 5.1775e-05, 0.000174175, 0.000477, 0.00094675, 0.00140575, 0.00187475, 0.00218075, 0.002282, 0.0027025, 0.00303, 0.00307, 0.0032325, 0.003215, 0.0034275, 0.0040425, 0.0042025, 0.00409, 0.003675, 0.00363, 0.004525, 0.0050775, 0.00497, 0.0048375, 0.00423, 0.0043625, 0.0051175, 0.0052525, 0.005095, 0.0050575, 0.0054875, 0.006125, 0.0057475, 0.0054, 0.0049725, 0.004455, 0.0053575, 0.0065, 0.00678, 0.006905, 0.00624, 0.0055375, 0.005415, 0.005595, 0.006045, 0.0060625, 0.006, 0.007035, 0.0072975, 0.0069725, 0.0062525, 0.0055675, 0.00649, 0.00753, 0.00721, 0.0063925, 0.0055075, 0.00594, 0.0069075, 0.00717, 0.0072625, 0.0072725, 0.00776, 0.008755, 0.0076525, 0.0060225, 0.005515, 0.0053475, 0.0063975, 0.007865, 0.0085425, 0.0082275, 0.00726, 0.0075325, 0.0079025, 0.00776, 0.0077375, 0.00694, 0.0065925, 0.0076925, 0.008255, 0.008255, 0.007715, 0.0076925, 0.008525, 0.0084975, 0.0083875, 0.0085575, 0.0082225, 0.008475, 0.0089525, 0.0085525, 0.0075175, 0.00682, 0.0070975, 0.007575, 0.007015, 0.0054875, 0.004775, 0.0061675, 0.0077975, 0.008335, 0.0082075, 0.00761, 0.0071025, 0.0066875, 0.0058275, 0.0051475, 0.004895, 0.00545, 0.0064225, 0.006805, 0.0062025, 0.0052575, 0.0053375, 0.00595, 0.0061, 0.005375, 0.004405, 0.003615, 0.00349, 0.0049075, 0.0067, 0.0069925, 0.0064025, 0.0061125, 0.00644, 0.0062, 0.0058025, 0.005775, 0.0059825, 0.0068625, 0.006645, 0.00547, 0.005425, 0.0065525, 0.00742, 0.0070125, 0.006365, 0.006885, 0.0077325, 0.0079975, 0.0075625, 0.006705, 0.0060775, 0.0053, 0.0051, 0.00532, 0.00506, 0.0048775, 0.0057125, 0.00671, 0.0066375, 0.006995, 0.00752, 0.0079075, 0.0077375, 0.0073025, 0.006535, 0.005705, 0.005405, 0.0055475, 0.005825, 0.006285, 0.006025, 0.005215, 0.005375, 0.0069925, 0.0077925, 0.006055, 0.0042, 0.0043475, 0.00529, 0.006165, 0.0066575, 0.0067125, 0.0071075, 0.00745, 0.006925, 0.00632, 0.0058675, 0.005385, 0.004775, 0.004335, 0.00485, 0.0059725, 0.005905, 0.0052475, 0.00557, 0.005705, 0.0049725, 0.00472, 0.0053675, 0.0064075, 0.006415, 0.0054125, 0.0048775, 0.0051425, 0.0059925, 0.006275, 0.0057025, 0.004775, 0.00438, 0.004845, 0.0053575, 0.004985, 0.0041375, 0.003455, 0.00362, 0.00383, 0.0036625, 0.00361, 0.00369, 0.003525, 0.00338, 0.0032575, 0.00311, 0.00315, 0.0029875, 0.00197, 0.00095975, 0.00066675, 0.0009275, 0.00150925, 0.0019995, 0.00198275, 0.00153275, 0.00106975, 0.00107175, 0.00145675, 0.001408, 0.00101625, 0.0009075, 0.001035, 0.000935, 0.000699, 0.00079775, 0.001021, 0.00097575, 0.000761, 0.0005445, 0.0004825, 0.00041075, 0.0004405, 0.000563, 0.0004505, 0.00027475, 0.00020995, 0.000217775, 0.00035775, 0.000483, 0.000422, 0.00030225, 0.000165775, 8.1325e-05, 8.5925e-05, 0.00014035, 0.00014335, 9.1475e-05, 5.1575e-05, 5.4425e-05, 0.000121025, 0.000207425, 0.00017455, 7.66e-05, 2.41325e-05, 7.4075e-06, 4.6025e-06, 9.5175e-06, 2.505e-05, 3.815e-05, 2.96e-05, 2.146e-05, 3.2025e-05, 4.4625e-05, 3.3875e-05, 1.57125e-05, 5.405e-06, 1.56975e-06, 4.27e-07, 4.8525e-08, 1.9015e-10, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.0925e-07, 5.9625e-06, 1.91175e-05, 7.48e-05, 0.00027175, 0.00095775, 0.0031275, 0.0083825, 0.016465, 0.0245175, 0.0327, 0.0382, 0.040375, 0.04775, 0.053725, 0.05485, 0.057875, 0.058025, 0.062025, 0.073075, 0.076525, 0.074825, 0.067975, 0.067275, 0.083325, 0.0942, 0.092975, 0.09095, 0.0805, 0.082575, 0.096725, 0.10035, 0.097925, 0.097775, 0.105725, 0.118525, 0.11275, 0.106075, 0.09865, 0.088825, 0.105075, 0.128525, 0.135625, 0.138825, 0.1274, 0.113225, 0.1105, 0.1143, 0.1234, 0.1256, 0.1242, 0.144775, 0.1529, 0.147075, 0.1339, 0.118975, 0.135875, 0.159625, 0.15555, 0.1392, 0.120525, 0.127275, 0.1493, 0.157325, 0.160125, 0.161525, 0.17005, 0.192775, 0.1752, 0.138675, 0.1255, 0.120875, 0.140875, 0.174975, 0.193125, 0.1908, 0.170075, 0.1736, 0.183975, 0.18135, 0.17945, 0.163725, 0.152975, 0.175775, 0.189925, 0.19255, 0.1836, 0.17685, 0.190075, 0.188425, 0.185875, 0.198775, 0.1928, 0.19315, 0.2068, 0.1995, 0.177375, 0.16625, 0.17675, 0.195325, 0.189325, 0.15985, 0.138475, 0.1677, 0.22155, 0.246, 0.2483, 0.2349, 0.21355, 0.205875, 0.20195, 0.19465, 0.180075, 0.177925, 0.207325, 0.23415, 0.232075, 0.2105, 0.219325, 0.243375, 0.242675, 0.222275, 0.200575, 0.1859, 0.1764, 0.1956, 0.245925, 0.26025, 0.238225, 0.229025, 0.245275, 0.25375, 0.240675, 0.226675, 0.203875, 0.19645, 0.220275, 0.23385, 0.2326, 0.2314, 0.237675, 0.241075, 0.231, 0.253, 0.287, 0.282, 0.263, 0.25975, 0.238775, 0.20045, 0.197375, 0.220525, 0.217275, 0.198925, 0.2147, 0.257, 0.28325, 0.316, 0.33, 0.309, 0.28075, 0.26775, 0.24465, 0.212475, 0.203, 0.21415, 0.23285, 0.2565, 0.28575, 0.29275, 0.293, 0.32375, 0.34525, 0.2855, 0.1899, 0.168525, 0.213725, 0.2615, 0.28825, 0.29325, 0.29925, 0.321, 0.34275, 0.3465, 0.324, 0.28225, 0.237875, 0.20995, 0.2242, 0.2785, 0.31225, 0.294, 0.29, 0.299, 0.28075, 0.279, 0.3035, 0.33625, 0.3445, 0.2915, 0.249025, 0.27225, 0.32275, 0.353, 0.33725, 0.29625, 0.26875, 0.29575, 0.3555, 0.35275, 0.30425, 0.262, 0.257, 0.28775, 0.294, 0.27325, 0.25275, 0.240425, 0.2303, 0.228725, 0.227875, 0.235125, 0.23735, 0.19505, 0.1185, 0.077325, 0.086175, 0.1246, 0.15435, 0.150425, 0.1228, 0.08595, 0.072275, 0.092525, 0.10125, 0.083775, 0.07145, 0.079925, 0.0878, 0.0757, 0.06735, 0.075575, 0.07065, 0.0528, 0.041325, 0.04565, 0.0463, 0.042025, 0.0474, 0.04535, 0.0384, 0.0446, 0.04585, 0.042225, 0.04895, 0.0543, 0.04545, 0.023575, 0.00989, 0.0084875, 0.0156325, 0.025375, 0.034, 0.0332, 0.0211825, 0.01834, 0.02595, 0.0242775, 0.01205, 0.004065, 0.0013395, 0.00095925, 0.002269, 0.00638, 0.0124375, 0.012745, 0.0088625, 0.00967, 0.01315, 0.013555, 0.0103575, 0.005145, 0.00179, 0.00052625, 0.00013195, 2.42425e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.21793867, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.803e-08, 3.465e-07, 1.1105e-06, 4.3425e-06, 1.57725e-05, 5.56e-05, 0.000181425, 0.000486, 0.00095325, 0.0014155, 0.0018825, 0.002192, 0.0023065, 0.0027175, 0.0030475, 0.0030975, 0.003255, 0.0032525, 0.0034575, 0.00406, 0.0042375, 0.00413, 0.003735, 0.0036775, 0.004535, 0.00511, 0.005025, 0.0048975, 0.00432, 0.0044075, 0.0051425, 0.005315, 0.005165, 0.005135, 0.0055275, 0.006175, 0.0058575, 0.0054875, 0.005085, 0.004555, 0.0053575, 0.00653, 0.0068625, 0.007, 0.006405, 0.0056725, 0.0055125, 0.0056775, 0.0061075, 0.00619, 0.0060875, 0.0070625, 0.007435, 0.0071275, 0.0064675, 0.00572, 0.0064975, 0.00762, 0.0074175, 0.006625, 0.005705, 0.00598, 0.006975, 0.00732, 0.007425, 0.0074775, 0.00786, 0.008885, 0.0080425, 0.0063425, 0.0057375, 0.005525, 0.0064225, 0.0079375, 0.0087175, 0.0085575, 0.0075825, 0.007715, 0.00818, 0.0081, 0.008055, 0.00734, 0.0068525, 0.0079075, 0.0085525, 0.0086325, 0.008305, 0.0082075, 0.0089725, 0.0089125, 0.008565, 0.008955, 0.008785, 0.008815, 0.0093725, 0.00903, 0.007915, 0.007225, 0.0073875, 0.00788, 0.0073325, 0.0058425, 0.0050025, 0.006035, 0.0078325, 0.0086575, 0.0086025, 0.008215, 0.00753, 0.0067525, 0.0058725, 0.0053975, 0.0053475, 0.0056325, 0.00646, 0.007055, 0.0065925, 0.0054225, 0.0054175, 0.00621, 0.006415, 0.005595, 0.0045225, 0.00393, 0.0039275, 0.00505, 0.0068075, 0.0072775, 0.006565, 0.0062025, 0.0065125, 0.00653, 0.0063, 0.0066, 0.006745, 0.00621, 0.00561, 0.0055425, 0.006175, 0.0068475, 0.00706, 0.00682, 0.0062775, 0.0070075, 0.008355, 0.008455, 0.0074775, 0.0068875, 0.006245, 0.0049475, 0.0045825, 0.0053125, 0.0055325, 0.0052225, 0.0055875, 0.0061625, 0.0061525, 0.006865, 0.0079025, 0.0083325, 0.00806, 0.0077, 0.00681, 0.00566, 0.0054475, 0.0057775, 0.00576, 0.0054925, 0.0053825, 0.0052275, 0.00556, 0.0069925, 0.0079225, 0.006545, 0.00445, 0.0041625, 0.0051675, 0.0061875, 0.006905, 0.0070725, 0.0070175, 0.0068425, 0.00646, 0.00625, 0.0060475, 0.00572, 0.0052, 0.004395, 0.0043725, 0.005465, 0.0058825, 0.0054025, 0.0055675, 0.005795, 0.0051125, 0.0047625, 0.0053675, 0.0063175, 0.0065975, 0.0055275, 0.00453, 0.004755, 0.005745, 0.006355, 0.0059475, 0.00506, 0.0043725, 0.0043875, 0.0051125, 0.00514, 0.0043475, 0.0036575, 0.0035525, 0.00384, 0.003885, 0.0037875, 0.0037025, 0.0035475, 0.0033225, 0.0031, 0.00296, 0.003175, 0.0033825, 0.0026825, 0.00142875, 0.00074525, 0.00078175, 0.00133925, 0.00197975, 0.0021165, 0.00176625, 0.0012415, 0.0010775, 0.0014025, 0.0014525, 0.001092, 0.00087875, 0.00098875, 0.00102675, 0.00083275, 0.000836, 0.001075, 0.00108475, 0.00083325, 0.00053675, 0.0004585, 0.00044825, 0.0004355, 0.000552, 0.00051575, 0.00030225, 0.000208825, 0.00024255, 0.0003865, 0.00057825, 0.00061575, 0.00047725, 0.00023975, 9.775e-05, 7.6825e-05, 0.00012415, 0.00014585, 9.9725e-05, 6.0175e-05, 5.5475e-05, 0.000109175, 0.000201775, 0.000196925, 9.845e-05, 3.3275e-05, 1.0065e-05, 4.31e-06, 6.35e-06, 1.6475e-05, 3.235e-05, 3.4425e-05, 2.8425e-05, 3.8175e-05, 4.9125e-05, 3.705e-05, 1.85125e-05, 6.9025e-06, 2.12825e-06, 6.02e-07, 9.435e-08, 5.65e-09, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.21793867, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.803e-08, 3.465e-07, 1.1105e-06, 4.3425e-06, 1.57725e-05, 5.56e-05, 0.000181425, 0.000486, 0.00095325, 0.0014155, 0.0018825, 0.002192, 0.0023065, 0.0027175, 0.0030475, 0.0030975, 0.003255, 0.0032525, 0.0034575, 0.00406, 0.0042375, 0.00413, 0.003735, 0.0036775, 0.004535, 0.00511, 0.005025, 0.0048975, 0.00432, 0.0044075, 0.0051425, 0.005315, 0.005165, 0.005135, 0.0055275, 0.006175, 0.0058575, 0.0054875, 0.005085, 0.004555, 0.0053575, 0.00653, 0.0068625, 0.007, 0.006405, 0.0056725, 0.0055125, 0.0056775, 0.0061075, 0.00619, 0.0060875, 0.0070625, 0.007435, 0.0071275, 0.0064675, 0.00572, 0.0064975, 0.00762, 0.0074175, 0.006625, 0.005705, 0.00598, 0.006975, 0.00732, 0.007425, 0.0074775, 0.00786, 0.008885, 0.0080425, 0.0063425, 0.0057375, 0.005525, 0.0064225, 0.0079375, 0.0087175, 0.0085575, 0.0075825, 0.007715, 0.00818, 0.0081, 0.008055, 0.00734, 0.0068525, 0.0079075, 0.0085525, 0.0086325, 0.008305, 0.0082075, 0.0089725, 0.0089125, 0.008565, 0.008955, 0.008785, 0.008815, 0.0093725, 0.00903, 0.007915, 0.007225, 0.0073875, 0.00788, 0.0073325, 0.0058425, 0.0050025, 0.006035, 0.0078325, 0.0086575, 0.0086025, 0.008215, 0.00753, 0.0067525, 0.0058725, 0.0053975, 0.0053475, 0.0056325, 0.00646, 0.007055, 0.0065925, 0.0054225, 0.0054175, 0.00621, 0.006415, 0.005595, 0.0045225, 0.00393, 0.0039275, 0.00505, 0.0068075, 0.0072775, 0.006565, 0.0062025, 0.0065125, 0.00653, 0.0063, 0.0066, 0.006745, 0.00621, 0.00561, 0.0055425, 0.006175, 0.0068475, 0.00706, 0.00682, 0.0062775, 0.0070075, 0.008355, 0.008455, 0.0074775, 0.0068875, 0.006245, 0.0049475, 0.0045825, 0.0053125, 0.0055325, 0.0052225, 0.0055875, 0.0061625, 0.0061525, 0.006865, 0.0079025, 0.0083325, 0.00806, 0.0077, 0.00681, 0.00566, 0.0054475, 0.0057775, 0.00576, 0.0054925, 0.0053825, 0.0052275, 0.00556, 0.0069925, 0.0079225, 0.006545, 0.00445, 0.0041625, 0.0051675, 0.0061875, 0.006905, 0.0070725, 0.0070175, 0.0068425, 0.00646, 0.00625, 0.0060475, 0.00572, 0.0052, 0.004395, 0.0043725, 0.005465, 0.0058825, 0.0054025, 0.0055675, 0.005795, 0.0051125, 0.0047625, 0.0053675, 0.0063175, 0.0065975, 0.0055275, 0.00453, 0.004755, 0.005745, 0.006355, 0.0059475, 0.00506, 0.0043725, 0.0043875, 0.0051125, 0.00514, 0.0043475, 0.0036575, 0.0035525, 0.00384, 0.003885, 0.0037875, 0.0037025, 0.0035475, 0.0033225, 0.0031, 0.00296, 0.003175, 0.0033825, 0.0026825, 0.00142875, 0.00074525, 0.00078175, 0.00133925, 0.00197975, 0.0021165, 0.00176625, 0.0012415, 0.0010775, 0.0014025, 0.0014525, 0.001092, 0.00087875, 0.00098875, 0.00102675, 0.00083275, 0.000836, 0.001075, 0.00108475, 0.00083325, 0.00053675, 0.0004585, 0.00044825, 0.0004355, 0.000552, 0.00051575, 0.00030225, 0.000208825, 0.00024255, 0.0003865, 0.00057825, 0.00061575, 0.00047725, 0.00023975, 9.775e-05, 7.6825e-05, 0.00012415, 0.00014585, 9.9725e-05, 6.0175e-05, 5.5475e-05, 0.000109175, 0.000201775, 0.000196925, 9.845e-05, 3.3275e-05, 1.0065e-05, 4.31e-06, 6.35e-06, 1.6475e-05, 3.235e-05, 3.4425e-05, 2.8425e-05, 3.8175e-05, 4.9125e-05, 3.705e-05, 1.85125e-05, 6.9025e-06, 2.12825e-06, 6.02e-07, 9.435e-08, 5.65e-09, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.21793867, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.803e-08, 3.465e-07, 1.1105e-06, 4.3425e-06, 1.57725e-05, 5.56e-05, 0.000181425, 0.000486, 0.00095325, 0.0014155, 0.0018825, 0.002192, 0.0023065, 0.0027175, 0.0030475, 0.0030975, 0.003255, 0.0032525, 0.0034575, 0.00406, 0.0042375, 0.00413, 0.003735, 0.0036775, 0.004535, 0.00511, 0.005025, 0.0048975, 0.00432, 0.0044075, 0.0051425, 0.005315, 0.005165, 0.005135, 0.0055275, 0.006175, 0.0058575, 0.0054875, 0.005085, 0.004555, 0.0053575, 0.00653, 0.0068625, 0.007, 0.006405, 0.0056725, 0.0055125, 0.0056775, 0.0061075, 0.00619, 0.0060875, 0.0070625, 0.007435, 0.0071275, 0.0064675, 0.00572, 0.0064975, 0.00762, 0.0074175, 0.006625, 0.005705, 0.00598, 0.006975, 0.00732, 0.007425, 0.0074775, 0.00786, 0.008885, 0.0080425, 0.0063425, 0.0057375, 0.005525, 0.0064225, 0.0079375, 0.0087175, 0.0085575, 0.0075825, 0.007715, 0.00818, 0.0081, 0.008055, 0.00734, 0.0068525, 0.0079075, 0.0085525, 0.0086325, 0.008305, 0.0082075, 0.0089725, 0.0089125, 0.008565, 0.008955, 0.008785, 0.008815, 0.0093725, 0.00903, 0.007915, 0.007225, 0.0073875, 0.00788, 0.0073325, 0.0058425, 0.0050025, 0.006035, 0.0078325, 0.0086575, 0.0086025, 0.008215, 0.00753, 0.0067525, 0.0058725, 0.0053975, 0.0053475, 0.0056325, 0.00646, 0.007055, 0.0065925, 0.0054225, 0.0054175, 0.00621, 0.006415, 0.005595, 0.0045225, 0.00393, 0.0039275, 0.00505, 0.0068075, 0.0072775, 0.006565, 0.0062025, 0.0065125, 0.00653, 0.0063, 0.0066, 0.006745, 0.00621, 0.00561, 0.0055425, 0.006175, 0.0068475, 0.00706, 0.00682, 0.0062775, 0.0070075, 0.008355, 0.008455, 0.0074775, 0.0068875, 0.006245, 0.0049475, 0.0045825, 0.0053125, 0.0055325, 0.0052225, 0.0055875, 0.0061625, 0.0061525, 0.006865, 0.0079025, 0.0083325, 0.00806, 0.0077, 0.00681, 0.00566, 0.0054475, 0.0057775, 0.00576, 0.0054925, 0.0053825, 0.0052275, 0.00556, 0.0069925, 0.0079225, 0.006545, 0.00445, 0.0041625, 0.0051675, 0.0061875, 0.006905, 0.0070725, 0.0070175, 0.0068425, 0.00646, 0.00625, 0.0060475, 0.00572, 0.0052, 0.004395, 0.0043725, 0.005465, 0.0058825, 0.0054025, 0.0055675, 0.005795, 0.0051125, 0.0047625, 0.0053675, 0.0063175, 0.0065975, 0.0055275, 0.00453, 0.004755, 0.005745, 0.006355, 0.0059475, 0.00506, 0.0043725, 0.0043875, 0.0051125, 0.00514, 0.0043475, 0.0036575, 0.0035525, 0.00384, 0.003885, 0.0037875, 0.0037025, 0.0035475, 0.0033225, 0.0031, 0.00296, 0.003175, 0.0033825, 0.0026825, 0.00142875, 0.00074525, 0.00078175, 0.00133925, 0.00197975, 0.0021165, 0.00176625, 0.0012415, 0.0010775, 0.0014025, 0.0014525, 0.001092, 0.00087875, 0.00098875, 0.00102675, 0.00083275, 0.000836, 0.001075, 0.00108475, 0.00083325, 0.00053675, 0.0004585, 0.00044825, 0.0004355, 0.000552, 0.00051575, 0.00030225, 0.000208825, 0.00024255, 0.0003865, 0.00057825, 0.00061575, 0.00047725, 0.00023975, 9.775e-05, 7.6825e-05, 0.00012415, 0.00014585, 9.9725e-05, 6.0175e-05, 5.5475e-05, 0.000109175, 0.000201775, 0.000196925, 9.845e-05, 3.3275e-05, 1.0065e-05, 4.31e-06, 6.35e-06, 1.6475e-05, 3.235e-05, 3.4425e-05, 2.8425e-05, 3.8175e-05, 4.9125e-05, 3.705e-05, 1.85125e-05, 6.9025e-06, 2.12825e-06, 6.02e-07, 9.435e-08, 5.65e-09, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.21793867, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.803e-08, 3.465e-07, 1.1105e-06, 4.3425e-06, 1.57725e-05, 5.56e-05, 0.000181425, 0.000486, 0.00095325, 0.0014155, 0.0018825, 0.002192, 0.0023065, 0.0027175, 0.0030475, 0.0030975, 0.003255, 0.0032525, 0.0034575, 0.00406, 0.0042375, 0.00413, 0.003735, 0.0036775, 0.004535, 0.00511, 0.005025, 0.0048975, 0.00432, 0.0044075, 0.0051425, 0.005315, 0.005165, 0.005135, 0.0055275, 0.006175, 0.0058575, 0.0054875, 0.005085, 0.004555, 0.0053575, 0.00653, 0.0068625, 0.007, 0.006405, 0.0056725, 0.0055125, 0.0056775, 0.0061075, 0.00619, 0.0060875, 0.0070625, 0.007435, 0.0071275, 0.0064675, 0.00572, 0.0064975, 0.00762, 0.0074175, 0.006625, 0.005705, 0.00598, 0.006975, 0.00732, 0.007425, 0.0074775, 0.00786, 0.008885, 0.0080425, 0.0063425, 0.0057375, 0.005525, 0.0064225, 0.0079375, 0.0087175, 0.0085575, 0.0075825, 0.007715, 0.00818, 0.0081, 0.008055, 0.00734, 0.0068525, 0.0079075, 0.0085525, 0.0086325, 0.008305, 0.0082075, 0.0089725, 0.0089125, 0.008565, 0.008955, 0.008785, 0.008815, 0.0093725, 0.00903, 0.007915, 0.007225, 0.0073875, 0.00788, 0.0073325, 0.0058425, 0.0050025, 0.006035, 0.0078325, 0.0086575, 0.0086025, 0.008215, 0.00753, 0.0067525, 0.0058725, 0.0053975, 0.0053475, 0.0056325, 0.00646, 0.007055, 0.0065925, 0.0054225, 0.0054175, 0.00621, 0.006415, 0.005595, 0.0045225, 0.00393, 0.0039275, 0.00505, 0.0068075, 0.0072775, 0.006565, 0.0062025, 0.0065125, 0.00653, 0.0063, 0.0066, 0.006745, 0.00621, 0.00561, 0.0055425, 0.006175, 0.0068475, 0.00706, 0.00682, 0.0062775, 0.0070075, 0.008355, 0.008455, 0.0074775, 0.0068875, 0.006245, 0.0049475, 0.0045825, 0.0053125, 0.0055325, 0.0052225, 0.0055875, 0.0061625, 0.0061525, 0.006865, 0.0079025, 0.0083325, 0.00806, 0.0077, 0.00681, 0.00566, 0.0054475, 0.0057775, 0.00576, 0.0054925, 0.0053825, 0.0052275, 0.00556, 0.0069925, 0.0079225, 0.006545, 0.00445, 0.0041625, 0.0051675, 0.0061875, 0.006905, 0.0070725, 0.0070175, 0.0068425, 0.00646, 0.00625, 0.0060475, 0.00572, 0.0052, 0.004395, 0.0043725, 0.005465, 0.0058825, 0.0054025, 0.0055675, 0.005795, 0.0051125, 0.0047625, 0.0053675, 0.0063175, 0.0065975, 0.0055275, 0.00453, 0.004755, 0.005745, 0.006355, 0.0059475, 0.00506, 0.0043725, 0.0043875, 0.0051125, 0.00514, 0.0043475, 0.0036575, 0.0035525, 0.00384, 0.003885, 0.0037875, 0.0037025, 0.0035475, 0.0033225, 0.0031, 0.00296, 0.003175, 0.0033825, 0.0026825, 0.00142875, 0.00074525, 0.00078175, 0.00133925, 0.00197975, 0.0021165, 0.00176625, 0.0012415, 0.0010775, 0.0014025, 0.0014525, 0.001092, 0.00087875, 0.00098875, 0.00102675, 0.00083275, 0.000836, 0.001075, 0.00108475, 0.00083325, 0.00053675, 0.0004585, 0.00044825, 0.0004355, 0.000552, 0.00051575, 0.00030225, 0.000208825, 0.00024255, 0.0003865, 0.00057825, 0.00061575, 0.00047725, 0.00023975, 9.775e-05, 7.6825e-05, 0.00012415, 0.00014585, 9.9725e-05, 6.0175e-05, 5.5475e-05, 0.000109175, 0.000201775, 0.000196925, 9.845e-05, 3.3275e-05, 1.0065e-05, 4.31e-06, 6.35e-06, 1.6475e-05, 3.235e-05, 3.4425e-05, 2.8425e-05, 3.8175e-05, 4.9125e-05, 3.705e-05, 1.85125e-05, 6.9025e-06, 2.12825e-06, 6.02e-07, 9.435e-08, 5.65e-09, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]]
        Ef =  [11.67302353, 11.25108797, 10.84338223, 10.44727947, 10.06067677, 9.68460247, 9.32198386, 8.97425327, 8.64003753, 8.31659488, 8.00285946, 7.69867685, 7.40309847, 7.11468182, 6.83256146, 6.55628297, 6.28531296, 6.01988332, 5.76265758, 5.51614726, 5.2808033]

        p_el_optimal = fit_electronic(V_DFT, p_el_inittial,E,N,Ef)

        np.testing.assert_array_almost_equal(p_el_optimal, [2.8916e-01, -1.0806e+04,  0.0000e+00,  0.0000e+00],decimal=1)


    def test_NfV_fitting_reading_from_DOSCAR(self):
        """ Test fitting of the NfV."""

        V_DFT = np.array([7.2328381349E-06,7.4766214899E-06,7.7258220323E-06,7.9804992917E-06,8.2407127976E-06,8.5065220794E-06,8.7779866668E-06,9.0551660893E-06,9.3381198763E-06,9.6269075575E-06,9.9215886624E-06,1.0222222720E-05,1.0528869261E-05,1.0841587814E-05,1.1160437909E-05,1.1485479075E-05,1.1816770842E-05,1.2154372740E-05,1.2498344297E-05,1.2848745044E-05,1.3205634510E-05])

        p_el_inittial = [2.828998e-01, -1.023899e+04,  0.000000e+00,  0.000000e+00]#[3.802734e-01, -1.887502e-02,  5.307103e-04, -7.010071e-06]

        E, N, Ef = load_doscar('../tests/inpt_files/Al_fcc/DOSCAR.EvV.')
        p_el_optimal = fit_electronic(V_DFT, p_el_inittial,E,N,Ef)

        np.testing.assert_array_almost_equal(p_el_optimal, [2.8916e-01, -1.0806e+04,  0.0000e+00,  0.0000e+00],decimal=1)


if __name__=='__main__':
    unittest.main()
