import unittest
import numpy as np
from debyetools.fs_compound_db import fit_FS
class FSBBTestCase(unittest.TestCase):
    def setUp(self):
        pass

    def test_FSDB(self):
        """Test the calculation of FS comp database paramters to thermoprops."""
        T_from = 298.15
        T_to = 1000

        trops_dict = {'T': np.array([0.1,111.2,222.3,298.15,333.4,444.5,555.6,666.7,777.8,888.9,1000]),
                      'V': np.array([0.0000119324700832,0.0000119819944952,0.0000120791141771,0.0000121528392393,0.0000121890366608,0.0000123098557254,0.0000124444947724,0.0000125961012883,0.0000127726189186,0.000012987159002,0.0000132763262142]),
                      'a': np.array([4.95424921367E-11,0.0000656868972107,0.0000775439623943,0.0000826669592961,0.0000850228045616,0.0000930463117211,0.000102981091424,0.00011620370587,0.00013551095776,0.000167805977053,0.000241115774383]),
                      'Cp': np.array([0.00000707790458322,22.2295895256,25.306610895,26.2261911472,26.5962629282,27.7501299479,29.0736847816,30.7716452013,33.1836412271,37.1314666385,45.8977632433]),
                      'Ks': np.array([79839710318.2,78609476010.9,76231032161.2,74461132231.3,73600658838.5,70787078970.8,67727147420.7,64373678943,60562840695.7,56041377037.8,50055074214.2]),
                      'Ksp': np.array([5.8319949069,5.92581128531,6.07262421928,6.19042232876,6.25170399681,6.47798983546,6.77772999144,7.19617691273,7.83503505035,8.95883489939,11.6736878299])
                      }

        np.testing.assert_array_almost_equal(fit_FS(trops_dict,T_from, T_to)['Cp'], [ 571.405655,-4.96294005e-01,6.38732214e+06,2.31428439e-04,-8.45158274e+03,1.00000000e+00], decimal=2)





if __name__=='__main__':
    unittest.main()
