# coding: utf-8

"""
    Odin

    ODIN APIs to search across IP Services, CVEs, Certificates, Exposed Files/Buckets, Domains and more  # noqa: E501

    OpenAPI spec version: 1.0

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from odin.api_client import ApiClient


class HostsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def v1_cves_all_ip_page_get(self, ip, page, **kwargs):  # noqa: E501
        """Get cve details  # noqa: E501

        Get the detailed cve details for ip based on page  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_cves_all_ip_page_get(ip, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ip: get the ip (required)
        :param str page: get the page (required)
        :return: IpservicesIpCveResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v1_cves_all_ip_page_get_with_http_info(ip, page, **kwargs)  # noqa: E501
        else:
            (data) = self.v1_cves_all_ip_page_get_with_http_info(ip, page, **kwargs)  # noqa: E501
            return data

    def v1_cves_all_ip_page_get_with_http_info(self, ip, page, **kwargs):  # noqa: E501
        """Get cve details  # noqa: E501

        Get the detailed cve details for ip based on page  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_cves_all_ip_page_get_with_http_info(ip, page, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ip: get the ip (required)
        :param str page: get the page (required)
        :return: IpservicesIpCveResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ip', 'page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_cves_all_ip_page_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ip' is set
        if ('ip' not in params or
                params['ip'] is None):
            raise ValueError("Missing the required parameter `ip` when calling `v1_cves_all_ip_page_get`")  # noqa: E501
        # verify the required parameter 'page' is set
        if ('page' not in params or
                params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `v1_cves_all_ip_page_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ip' in params:
            path_params['ip'] = params['ip']  # noqa: E501
        if 'page' in params:
            path_params['page'] = params['page']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/cves/all/{ip}/{page}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IpservicesIpCveResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_hosts_count_post(self, body, **kwargs):  # noqa: E501
        """Get the record count  # noqa: E501

        Returns the total no of records based on query  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_hosts_count_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CountRequest body: Count Query (required)
        :return: InlineResponse20013
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v1_hosts_count_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.v1_hosts_count_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def v1_hosts_count_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get the record count  # noqa: E501

        Returns the total no of records based on query  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_hosts_count_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CountRequest body: Count Query (required)
        :return: InlineResponse20013
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_hosts_count_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `v1_hosts_count_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/hosts/count', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20013',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_hosts_cve_ip_get(self, ip, **kwargs):  # noqa: E501
        """Get ip cve details  # noqa: E501

        Get detailed lost of cve ips  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_hosts_cve_ip_get(ip, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ip: get the ip (required)
        :return: IpservicesIpCveResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v1_hosts_cve_ip_get_with_http_info(ip, **kwargs)  # noqa: E501
        else:
            (data) = self.v1_hosts_cve_ip_get_with_http_info(ip, **kwargs)  # noqa: E501
            return data

    def v1_hosts_cve_ip_get_with_http_info(self, ip, **kwargs):  # noqa: E501
        """Get ip cve details  # noqa: E501

        Get detailed lost of cve ips  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_hosts_cve_ip_get_with_http_info(ip, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ip: get the ip (required)
        :return: IpservicesIpCveResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ip']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_hosts_cve_ip_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ip' is set
        if ('ip' not in params or
                params['ip'] is None):
            raise ValueError("Missing the required parameter `ip` when calling `v1_hosts_cve_ip_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ip' in params:
            path_params['ip'] = params['ip']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/hosts/cve/{ip}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IpservicesIpCveResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_hosts_cves_ip_cve_get(self, ip, cve, **kwargs):  # noqa: E501
        """Get cve  # noqa: E501

        Get the detailed cve based on ip and cve  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_hosts_cves_ip_cve_get(ip, cve, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ip: host ip ip (required)
        :param str cve: cve id (required)
        :return: IpservicesIpCveResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v1_hosts_cves_ip_cve_get_with_http_info(ip, cve, **kwargs)  # noqa: E501
        else:
            (data) = self.v1_hosts_cves_ip_cve_get_with_http_info(ip, cve, **kwargs)  # noqa: E501
            return data

    def v1_hosts_cves_ip_cve_get_with_http_info(self, ip, cve, **kwargs):  # noqa: E501
        """Get cve  # noqa: E501

        Get the detailed cve based on ip and cve  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_hosts_cves_ip_cve_get_with_http_info(ip, cve, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ip: host ip ip (required)
        :param str cve: cve id (required)
        :return: IpservicesIpCveResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ip', 'cve']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_hosts_cves_ip_cve_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ip' is set
        if ('ip' not in params or
                params['ip'] is None):
            raise ValueError("Missing the required parameter `ip` when calling `v1_hosts_cves_ip_cve_get`")  # noqa: E501
        # verify the required parameter 'cve' is set
        if ('cve' not in params or
                params['cve'] is None):
            raise ValueError("Missing the required parameter `cve` when calling `v1_hosts_cves_ip_cve_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ip' in params:
            path_params['ip'] = params['ip']  # noqa: E501
        if 'cve' in params:
            path_params['cve'] = params['cve']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/hosts/cves/{ip}/{cve}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IpservicesIpCveResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_hosts_exploits_ip_cve_get(self, ip, cve, **kwargs):  # noqa: E501
        """Get exploits for ip and cve  # noqa: E501

        Get the detailed exploit details for ip and cve  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_hosts_exploits_ip_cve_get(ip, cve, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ip: ip address of the host (required)
        :param str cve: cve id (required)
        :return: InlineResponse20014
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v1_hosts_exploits_ip_cve_get_with_http_info(ip, cve, **kwargs)  # noqa: E501
        else:
            (data) = self.v1_hosts_exploits_ip_cve_get_with_http_info(ip, cve, **kwargs)  # noqa: E501
            return data

    def v1_hosts_exploits_ip_cve_get_with_http_info(self, ip, cve, **kwargs):  # noqa: E501
        """Get exploits for ip and cve  # noqa: E501

        Get the detailed exploit details for ip and cve  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_hosts_exploits_ip_cve_get_with_http_info(ip, cve, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ip: ip address of the host (required)
        :param str cve: cve id (required)
        :return: InlineResponse20014
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ip', 'cve']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_hosts_exploits_ip_cve_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ip' is set
        if ('ip' not in params or
                params['ip'] is None):
            raise ValueError("Missing the required parameter `ip` when calling `v1_hosts_exploits_ip_cve_get`")  # noqa: E501
        # verify the required parameter 'cve' is set
        if ('cve' not in params or
                params['cve'] is None):
            raise ValueError("Missing the required parameter `cve` when calling `v1_hosts_exploits_ip_cve_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ip' in params:
            path_params['ip'] = params['ip']  # noqa: E501
        if 'cve' in params:
            path_params['cve'] = params['cve']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/hosts/exploits/{ip}/{cve}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20014',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_hosts_exploits_ip_get(self, ip, **kwargs):  # noqa: E501
        """Get exploits for ip  # noqa: E501

        Get the detailed list of exploits for the ip  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_hosts_exploits_ip_get(ip, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ip: get the ip (required)
        :return: IpservicesIpCveResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v1_hosts_exploits_ip_get_with_http_info(ip, **kwargs)  # noqa: E501
        else:
            (data) = self.v1_hosts_exploits_ip_get_with_http_info(ip, **kwargs)  # noqa: E501
            return data

    def v1_hosts_exploits_ip_get_with_http_info(self, ip, **kwargs):  # noqa: E501
        """Get exploits for ip  # noqa: E501

        Get the detailed list of exploits for the ip  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_hosts_exploits_ip_get_with_http_info(ip, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ip: get the ip (required)
        :return: IpservicesIpCveResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ip']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_hosts_exploits_ip_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ip' is set
        if ('ip' not in params or
                params['ip'] is None):
            raise ValueError("Missing the required parameter `ip` when calling `v1_hosts_exploits_ip_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ip' in params:
            path_params['ip'] = params['ip']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/hosts/exploits/{ip}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IpservicesIpCveResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_hosts_ip_get(self, ip, **kwargs):  # noqa: E501
        """Get the latest ip details  # noqa: E501

        Get the complete and latest ip details  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_hosts_ip_get(ip, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ip: get the ip (required)
        :return: InlineResponse20016
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v1_hosts_ip_get_with_http_info(ip, **kwargs)  # noqa: E501
        else:
            (data) = self.v1_hosts_ip_get_with_http_info(ip, **kwargs)  # noqa: E501
            return data

    def v1_hosts_ip_get_with_http_info(self, ip, **kwargs):  # noqa: E501
        """Get the latest ip details  # noqa: E501

        Get the complete and latest ip details  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_hosts_ip_get_with_http_info(ip, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ip: get the ip (required)
        :return: InlineResponse20016
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ip']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_hosts_ip_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ip' is set
        if ('ip' not in params or
                params['ip'] is None):
            raise ValueError("Missing the required parameter `ip` when calling `v1_hosts_ip_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ip' in params:
            path_params['ip'] = params['ip']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/hosts/{ip}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20016',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_hosts_search_post(self, body, **kwargs):  # noqa: E501
        """Search hosts  # noqa: E501

        Get the detailed list of hosts based on query  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_hosts_search_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SearchRequest body: Search Query (required)
        :return: InlineResponse20015
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v1_hosts_search_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.v1_hosts_search_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def v1_hosts_search_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Search hosts  # noqa: E501

        Get the detailed list of hosts based on query  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_hosts_search_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SearchRequest body: Search Query (required)
        :return: InlineResponse20015
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_hosts_search_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `v1_hosts_search_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/hosts/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20015',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_hosts_summary_post(self, body, **kwargs):  # noqa: E501
        """Get summary  # noqa: E501

        Get the summary of hosts based on the field  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_hosts_summary_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SummaryRequest body: Summary (required)
        :return: IpservicesHostsSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v1_hosts_summary_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.v1_hosts_summary_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def v1_hosts_summary_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get summary  # noqa: E501

        Get the summary of hosts based on the field  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_hosts_summary_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SummaryRequest body: Summary (required)
        :return: IpservicesHostsSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_hosts_summary_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `v1_hosts_summary_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/hosts/summary', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IpservicesHostsSummaryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_hosts_count_post(self, body, **kwargs):  # noqa: E501
        """Fetch the record count  # noqa: E501

        Returns the total no of records based on query  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_hosts_count_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CybleComOdinApiControllersV2IpservicesCountRequest body: Count Query (required)
        :return: InlineResponse20017
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_hosts_count_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_hosts_count_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def v2_hosts_count_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Fetch the record count  # noqa: E501

        Returns the total no of records based on query  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_hosts_count_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CybleComOdinApiControllersV2IpservicesCountRequest body: Count Query (required)
        :return: InlineResponse20017
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_hosts_count_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `v2_hosts_count_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/hosts/count', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20017',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_hosts_ip_post(self, ip, **kwargs):  # noqa: E501
        """Fetch the latest ip details  # noqa: E501

        Returns the complete ip details  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_hosts_ip_post(ip, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ip: get the ip (required)
        :return: CybleComOdinApiControllersV2IpservicesAPIResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_hosts_ip_post_with_http_info(ip, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_hosts_ip_post_with_http_info(ip, **kwargs)  # noqa: E501
            return data

    def v2_hosts_ip_post_with_http_info(self, ip, **kwargs):  # noqa: E501
        """Fetch the latest ip details  # noqa: E501

        Returns the complete ip details  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_hosts_ip_post_with_http_info(ip, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ip: get the ip (required)
        :return: CybleComOdinApiControllersV2IpservicesAPIResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ip']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_hosts_ip_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ip' is set
        if ('ip' not in params or
                params['ip'] is None):
            raise ValueError("Missing the required parameter `ip` when calling `v2_hosts_ip_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ip' in params:
            path_params['ip'] = params['ip']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/hosts/{ip}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CybleComOdinApiControllersV2IpservicesAPIResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_hosts_search_post(self, body, **kwargs):  # noqa: E501
        """Fetch the record based on query  # noqa: E501

        Returns the record based on query and blank query will return all records. It uses es searchafter for the pagination.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_hosts_search_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CybleComOdinApiControllersV2IpservicesSearchRequest body: Search Query (required)
        :return: InlineResponse20018
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_hosts_search_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_hosts_search_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def v2_hosts_search_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Fetch the record based on query  # noqa: E501

        Returns the record based on query and blank query will return all records. It uses es searchafter for the pagination.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_hosts_search_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CybleComOdinApiControllersV2IpservicesSearchRequest body: Search Query (required)
        :return: InlineResponse20018
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_hosts_search_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `v2_hosts_search_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/hosts/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20018',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_hosts_summary_post(self, body, **kwargs):  # noqa: E501
        """Create the summary of the field based on query  # noqa: E501

        Returns the summary of the field based on query  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_hosts_summary_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CybleComOdinApiControllersV2IpservicesSummaryRequest body: Summary (required)
        :return: InlineResponse20019
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_hosts_summary_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_hosts_summary_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def v2_hosts_summary_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create the summary of the field based on query  # noqa: E501

        Returns the summary of the field based on query  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_hosts_summary_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CybleComOdinApiControllersV2IpservicesSummaryRequest body: Summary (required)
        :return: InlineResponse20019
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_hosts_summary_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `v2_hosts_summary_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/hosts/summary', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20019',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
