#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 411
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 110
#define ALIAS_COUNT 11
#define TOKEN_COUNT 52
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 32
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 68

enum ts_symbol_identifiers {
  sym_atom = 1,
  sym_comment = 2,
  sym_integer = 3,
  sym_decimal = 4,
  sym_string = 5,
  sym_boolean = 6,
  sym_symbol = 7,
  anon_sym_LBRACK = 8,
  anon_sym_RBRACK = 9,
  anon_sym_COMMA = 10,
  anon_sym_LBRACE = 11,
  anon_sym_RBRACE = 12,
  anon_sym_LPAREN = 13,
  anon_sym_RPAREN = 14,
  anon_sym_DOT = 15,
  anon_sym_object = 16,
  anon_sym_table = 17,
  anon_sym_integer = 18,
  anon_sym_decimal = 19,
  anon_sym_time = 20,
  anon_sym_bool = 21,
  anon_sym_string = 22,
  anon_sym_list = 23,
  anon_sym_value = 24,
  anon_sym_keyset = 25,
  anon_sym_guard = 26,
  anon_sym_COLON = 27,
  anon_sym_COLON_EQ = 28,
  anon_sym_ATdoc = 29,
  anon_sym_ATmodel = 30,
  anon_sym_defproperty = 31,
  anon_sym_ATmanaged = 32,
  anon_sym_ATevent = 33,
  anon_sym_AT = 34,
  anon_sym_namespace = 35,
  anon_sym_bless = 36,
  anon_sym_defun = 37,
  anon_sym_defcap = 38,
  anon_sym_defconst = 39,
  anon_sym_defpact = 40,
  anon_sym_defschema = 41,
  anon_sym_deftable = 42,
  anon_sym_let = 43,
  anon_sym_let_STAR = 44,
  anon_sym_cond = 45,
  anon_sym_step = 46,
  anon_sym_step_DASHwith_DASHrollback = 47,
  anon_sym_use = 48,
  anon_sym_interface = 49,
  anon_sym_module = 50,
  anon_sym_implements = 51,
  sym_source_file = 52,
  sym_list = 53,
  sym_object = 54,
  sym__literal = 55,
  sym__from = 56,
  sym_s_expression = 57,
  sym_reference = 58,
  sym__parametrized_object = 59,
  sym__parametrized_list = 60,
  sym_type_identifier = 61,
  sym_type_annotation = 62,
  sym_parameter_list = 63,
  sym_parameter = 64,
  sym_schema_field_list = 65,
  sym_schema_field = 66,
  sym_pair = 67,
  sym_bind_pair = 68,
  sym__property_name = 69,
  sym__def_name = 70,
  sym__doc_or_meta = 71,
  sym_doc = 72,
  sym_model = 73,
  sym_defproperty = 74,
  sym_managed = 75,
  sym_event = 76,
  sym_meta = 77,
  sym_namespace = 78,
  sym_bless = 79,
  sym_defun = 80,
  sym_defcap = 81,
  sym_defconst = 82,
  sym_defpact = 83,
  sym_defschema = 84,
  sym_deftable = 85,
  sym_let_variable = 86,
  sym_let_bind_pair = 87,
  sym_let_binding = 88,
  sym_cond = 89,
  sym_step = 90,
  sym_step_with_rollback = 91,
  sym_use = 92,
  sym_interface = 93,
  sym_module = 94,
  sym_implements = 95,
  aux_sym_source_file_repeat1 = 96,
  aux_sym_list_repeat1 = 97,
  aux_sym_list_repeat2 = 98,
  aux_sym_object_repeat1 = 99,
  aux_sym_reference_repeat1 = 100,
  aux_sym_parameter_list_repeat1 = 101,
  aux_sym_schema_field_list_repeat1 = 102,
  aux_sym__doc_or_meta_repeat1 = 103,
  aux_sym_model_repeat1 = 104,
  aux_sym_defpact_repeat1 = 105,
  aux_sym_let_binding_repeat1 = 106,
  aux_sym_cond_repeat1 = 107,
  aux_sym_interface_repeat1 = 108,
  aux_sym_module_repeat1 = 109,
  alias_sym_def_identifier = 110,
  alias_sym_doc_string = 111,
  alias_sym_let_variable_identifier = 112,
  alias_sym_module_governance = 113,
  alias_sym_module_identifier = 114,
  alias_sym_parameter_identifier = 115,
  alias_sym_property_identifier = 116,
  alias_sym_s_expression_head = 117,
  alias_sym_schema_field_identifier = 118,
  alias_sym_table_schema = 119,
  alias_sym_type_parameter = 120,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_atom] = "atom",
  [sym_comment] = "comment",
  [sym_integer] = "integer",
  [sym_decimal] = "decimal",
  [sym_string] = "string",
  [sym_boolean] = "boolean",
  [sym_symbol] = "symbol",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_COMMA] = ",",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_DOT] = ".",
  [anon_sym_object] = "object",
  [anon_sym_table] = "table",
  [anon_sym_integer] = "integer",
  [anon_sym_decimal] = "decimal",
  [anon_sym_time] = "time",
  [anon_sym_bool] = "bool",
  [anon_sym_string] = "string",
  [anon_sym_list] = "list",
  [anon_sym_value] = "value",
  [anon_sym_keyset] = "keyset",
  [anon_sym_guard] = "guard",
  [anon_sym_COLON] = ":",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_ATdoc] = "@doc",
  [anon_sym_ATmodel] = "@model",
  [anon_sym_defproperty] = "defproperty",
  [anon_sym_ATmanaged] = "@managed",
  [anon_sym_ATevent] = "@event",
  [anon_sym_AT] = "@",
  [anon_sym_namespace] = "namespace",
  [anon_sym_bless] = "bless",
  [anon_sym_defun] = "defun",
  [anon_sym_defcap] = "defcap",
  [anon_sym_defconst] = "defconst",
  [anon_sym_defpact] = "defpact",
  [anon_sym_defschema] = "defschema",
  [anon_sym_deftable] = "deftable",
  [anon_sym_let] = "let",
  [anon_sym_let_STAR] = "let*",
  [anon_sym_cond] = "cond",
  [anon_sym_step] = "step",
  [anon_sym_step_DASHwith_DASHrollback] = "step-with-rollback",
  [anon_sym_use] = "use",
  [anon_sym_interface] = "interface",
  [anon_sym_module] = "module",
  [anon_sym_implements] = "implements",
  [sym_source_file] = "source_file",
  [sym_list] = "list",
  [sym_object] = "object",
  [sym__literal] = "_literal",
  [sym__from] = "_from",
  [sym_s_expression] = "s_expression",
  [sym_reference] = "reference",
  [sym__parametrized_object] = "_parametrized_object",
  [sym__parametrized_list] = "_parametrized_list",
  [sym_type_identifier] = "type_identifier",
  [sym_type_annotation] = "type_annotation",
  [sym_parameter_list] = "parameter_list",
  [sym_parameter] = "parameter",
  [sym_schema_field_list] = "schema_field_list",
  [sym_schema_field] = "schema_field",
  [sym_pair] = "pair",
  [sym_bind_pair] = "bind_pair",
  [sym__property_name] = "_property_name",
  [sym__def_name] = "_def_name",
  [sym__doc_or_meta] = "_doc_or_meta",
  [sym_doc] = "doc",
  [sym_model] = "model",
  [sym_defproperty] = "defproperty",
  [sym_managed] = "managed",
  [sym_event] = "event",
  [sym_meta] = "meta",
  [sym_namespace] = "namespace",
  [sym_bless] = "bless",
  [sym_defun] = "defun",
  [sym_defcap] = "defcap",
  [sym_defconst] = "defconst",
  [sym_defpact] = "defpact",
  [sym_defschema] = "defschema",
  [sym_deftable] = "deftable",
  [sym_let_variable] = "let_variable",
  [sym_let_bind_pair] = "let_bind_pair",
  [sym_let_binding] = "let_binding",
  [sym_cond] = "cond",
  [sym_step] = "step",
  [sym_step_with_rollback] = "step_with_rollback",
  [sym_use] = "use",
  [sym_interface] = "interface",
  [sym_module] = "module",
  [sym_implements] = "implements",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_list_repeat1] = "list_repeat1",
  [aux_sym_list_repeat2] = "list_repeat2",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym_reference_repeat1] = "reference_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
  [aux_sym_schema_field_list_repeat1] = "schema_field_list_repeat1",
  [aux_sym__doc_or_meta_repeat1] = "_doc_or_meta_repeat1",
  [aux_sym_model_repeat1] = "model_repeat1",
  [aux_sym_defpact_repeat1] = "defpact_repeat1",
  [aux_sym_let_binding_repeat1] = "let_binding_repeat1",
  [aux_sym_cond_repeat1] = "cond_repeat1",
  [aux_sym_interface_repeat1] = "interface_repeat1",
  [aux_sym_module_repeat1] = "module_repeat1",
  [alias_sym_def_identifier] = "def_identifier",
  [alias_sym_doc_string] = "doc_string",
  [alias_sym_let_variable_identifier] = "let_variable_identifier",
  [alias_sym_module_governance] = "module_governance",
  [alias_sym_module_identifier] = "module_identifier",
  [alias_sym_parameter_identifier] = "parameter_identifier",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_s_expression_head] = "s_expression_head",
  [alias_sym_schema_field_identifier] = "schema_field_identifier",
  [alias_sym_table_schema] = "table_schema",
  [alias_sym_type_parameter] = "type_parameter",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_atom] = sym_atom,
  [sym_comment] = sym_comment,
  [sym_integer] = sym_integer,
  [sym_decimal] = sym_decimal,
  [sym_string] = sym_string,
  [sym_boolean] = sym_boolean,
  [sym_symbol] = sym_symbol,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_object] = anon_sym_object,
  [anon_sym_table] = anon_sym_table,
  [anon_sym_integer] = anon_sym_integer,
  [anon_sym_decimal] = anon_sym_decimal,
  [anon_sym_time] = anon_sym_time,
  [anon_sym_bool] = anon_sym_bool,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_list] = anon_sym_list,
  [anon_sym_value] = anon_sym_value,
  [anon_sym_keyset] = anon_sym_keyset,
  [anon_sym_guard] = anon_sym_guard,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_ATdoc] = anon_sym_ATdoc,
  [anon_sym_ATmodel] = anon_sym_ATmodel,
  [anon_sym_defproperty] = anon_sym_defproperty,
  [anon_sym_ATmanaged] = anon_sym_ATmanaged,
  [anon_sym_ATevent] = anon_sym_ATevent,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_namespace] = anon_sym_namespace,
  [anon_sym_bless] = anon_sym_bless,
  [anon_sym_defun] = anon_sym_defun,
  [anon_sym_defcap] = anon_sym_defcap,
  [anon_sym_defconst] = anon_sym_defconst,
  [anon_sym_defpact] = anon_sym_defpact,
  [anon_sym_defschema] = anon_sym_defschema,
  [anon_sym_deftable] = anon_sym_deftable,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_let_STAR] = anon_sym_let_STAR,
  [anon_sym_cond] = anon_sym_cond,
  [anon_sym_step] = anon_sym_step,
  [anon_sym_step_DASHwith_DASHrollback] = anon_sym_step_DASHwith_DASHrollback,
  [anon_sym_use] = anon_sym_use,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_implements] = anon_sym_implements,
  [sym_source_file] = sym_source_file,
  [sym_list] = sym_list,
  [sym_object] = sym_object,
  [sym__literal] = sym__literal,
  [sym__from] = sym__from,
  [sym_s_expression] = sym_s_expression,
  [sym_reference] = sym_reference,
  [sym__parametrized_object] = sym__parametrized_object,
  [sym__parametrized_list] = sym__parametrized_list,
  [sym_type_identifier] = sym_type_identifier,
  [sym_type_annotation] = sym_type_annotation,
  [sym_parameter_list] = sym_parameter_list,
  [sym_parameter] = sym_parameter,
  [sym_schema_field_list] = sym_schema_field_list,
  [sym_schema_field] = sym_schema_field,
  [sym_pair] = sym_pair,
  [sym_bind_pair] = sym_bind_pair,
  [sym__property_name] = sym__property_name,
  [sym__def_name] = sym__def_name,
  [sym__doc_or_meta] = sym__doc_or_meta,
  [sym_doc] = sym_doc,
  [sym_model] = sym_model,
  [sym_defproperty] = sym_defproperty,
  [sym_managed] = sym_managed,
  [sym_event] = sym_event,
  [sym_meta] = sym_meta,
  [sym_namespace] = sym_namespace,
  [sym_bless] = sym_bless,
  [sym_defun] = sym_defun,
  [sym_defcap] = sym_defcap,
  [sym_defconst] = sym_defconst,
  [sym_defpact] = sym_defpact,
  [sym_defschema] = sym_defschema,
  [sym_deftable] = sym_deftable,
  [sym_let_variable] = sym_let_variable,
  [sym_let_bind_pair] = sym_let_bind_pair,
  [sym_let_binding] = sym_let_binding,
  [sym_cond] = sym_cond,
  [sym_step] = sym_step,
  [sym_step_with_rollback] = sym_step_with_rollback,
  [sym_use] = sym_use,
  [sym_interface] = sym_interface,
  [sym_module] = sym_module,
  [sym_implements] = sym_implements,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_list_repeat1] = aux_sym_list_repeat1,
  [aux_sym_list_repeat2] = aux_sym_list_repeat2,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym_reference_repeat1] = aux_sym_reference_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
  [aux_sym_schema_field_list_repeat1] = aux_sym_schema_field_list_repeat1,
  [aux_sym__doc_or_meta_repeat1] = aux_sym__doc_or_meta_repeat1,
  [aux_sym_model_repeat1] = aux_sym_model_repeat1,
  [aux_sym_defpact_repeat1] = aux_sym_defpact_repeat1,
  [aux_sym_let_binding_repeat1] = aux_sym_let_binding_repeat1,
  [aux_sym_cond_repeat1] = aux_sym_cond_repeat1,
  [aux_sym_interface_repeat1] = aux_sym_interface_repeat1,
  [aux_sym_module_repeat1] = aux_sym_module_repeat1,
  [alias_sym_def_identifier] = alias_sym_def_identifier,
  [alias_sym_doc_string] = alias_sym_doc_string,
  [alias_sym_let_variable_identifier] = alias_sym_let_variable_identifier,
  [alias_sym_module_governance] = alias_sym_module_governance,
  [alias_sym_module_identifier] = alias_sym_module_identifier,
  [alias_sym_parameter_identifier] = alias_sym_parameter_identifier,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_s_expression_head] = alias_sym_s_expression_head,
  [alias_sym_schema_field_identifier] = alias_sym_schema_field_identifier,
  [alias_sym_table_schema] = alias_sym_table_schema,
  [alias_sym_type_parameter] = alias_sym_type_parameter,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_atom] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_symbol] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_object] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_table] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_integer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_decimal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_time] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_list] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_value] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_keyset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_guard] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATdoc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATmodel] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defproperty] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATmanaged] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATevent] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bless] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defun] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defcap] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defconst] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defpact] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defschema] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_deftable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cond] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_step] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_step_DASHwith_DASHrollback] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_use] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
  },
  [sym__from] = {
    .visible = false,
    .named = true,
  },
  [sym_s_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_reference] = {
    .visible = true,
    .named = true,
  },
  [sym__parametrized_object] = {
    .visible = false,
    .named = true,
  },
  [sym__parametrized_list] = {
    .visible = false,
    .named = true,
  },
  [sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_schema_field_list] = {
    .visible = true,
    .named = true,
  },
  [sym_schema_field] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_bind_pair] = {
    .visible = true,
    .named = true,
  },
  [sym__property_name] = {
    .visible = false,
    .named = true,
  },
  [sym__def_name] = {
    .visible = false,
    .named = true,
  },
  [sym__doc_or_meta] = {
    .visible = false,
    .named = true,
  },
  [sym_doc] = {
    .visible = true,
    .named = true,
  },
  [sym_model] = {
    .visible = true,
    .named = true,
  },
  [sym_defproperty] = {
    .visible = true,
    .named = true,
  },
  [sym_managed] = {
    .visible = true,
    .named = true,
  },
  [sym_event] = {
    .visible = true,
    .named = true,
  },
  [sym_meta] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace] = {
    .visible = true,
    .named = true,
  },
  [sym_bless] = {
    .visible = true,
    .named = true,
  },
  [sym_defun] = {
    .visible = true,
    .named = true,
  },
  [sym_defcap] = {
    .visible = true,
    .named = true,
  },
  [sym_defconst] = {
    .visible = true,
    .named = true,
  },
  [sym_defpact] = {
    .visible = true,
    .named = true,
  },
  [sym_defschema] = {
    .visible = true,
    .named = true,
  },
  [sym_deftable] = {
    .visible = true,
    .named = true,
  },
  [sym_let_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_let_bind_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_let_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_cond] = {
    .visible = true,
    .named = true,
  },
  [sym_step] = {
    .visible = true,
    .named = true,
  },
  [sym_step_with_rollback] = {
    .visible = true,
    .named = true,
  },
  [sym_use] = {
    .visible = true,
    .named = true,
  },
  [sym_interface] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_implements] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_reference_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_schema_field_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__doc_or_meta_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_model_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_defpact_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_let_binding_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_cond_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interface_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_def_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_doc_string] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_let_variable_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_module_governance] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_module_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_parameter_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_s_expression_head] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_schema_field_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_table_schema] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_args = 1,
  field_bind_pairs = 2,
  field_body = 3,
  field_branch = 4,
  field_doc = 5,
  field_else_branch = 6,
  field_entity = 7,
  field_event = 8,
  field_expr = 9,
  field_fields = 10,
  field_governance = 11,
  field_hash = 12,
  field_head = 13,
  field_imports = 14,
  field_interface = 15,
  field_key = 16,
  field_managed = 17,
  field_manager = 18,
  field_meta = 19,
  field_model = 20,
  field_module = 21,
  field_name = 22,
  field_namespace = 23,
  field_parameters = 24,
  field_return_type = 25,
  field_rollback_expr = 26,
  field_schema = 27,
  field_tail = 28,
  field_test = 29,
  field_type = 30,
  field_type_parameter = 31,
  field_value = 32,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_args] = "args",
  [field_bind_pairs] = "bind_pairs",
  [field_body] = "body",
  [field_branch] = "branch",
  [field_doc] = "doc",
  [field_else_branch] = "else_branch",
  [field_entity] = "entity",
  [field_event] = "event",
  [field_expr] = "expr",
  [field_fields] = "fields",
  [field_governance] = "governance",
  [field_hash] = "hash",
  [field_head] = "head",
  [field_imports] = "imports",
  [field_interface] = "interface",
  [field_key] = "key",
  [field_managed] = "managed",
  [field_manager] = "manager",
  [field_meta] = "meta",
  [field_model] = "model",
  [field_module] = "module",
  [field_name] = "name",
  [field_namespace] = "namespace",
  [field_parameters] = "parameters",
  [field_return_type] = "return_type",
  [field_rollback_expr] = "rollback_expr",
  [field_schema] = "schema",
  [field_tail] = "tail",
  [field_test] = "test",
  [field_type] = "type",
  [field_type_parameter] = "type_parameter",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 1},
  [6] = {.index = 3, .length = 1},
  [7] = {.index = 4, .length = 1},
  [8] = {.index = 5, .length = 1},
  [9] = {.index = 6, .length = 1},
  [10] = {.index = 7, .length = 1},
  [11] = {.index = 8, .length = 1},
  [12] = {.index = 9, .length = 5},
  [14] = {.index = 14, .length = 2},
  [15] = {.index = 16, .length = 2},
  [17] = {.index = 18, .length = 1},
  [18] = {.index = 19, .length = 1},
  [19] = {.index = 20, .length = 6},
  [20] = {.index = 26, .length = 10},
  [21] = {.index = 36, .length = 2},
  [22] = {.index = 38, .length = 2},
  [23] = {.index = 40, .length = 3},
  [24] = {.index = 43, .length = 2},
  [25] = {.index = 45, .length = 7},
  [26] = {.index = 52, .length = 7},
  [27] = {.index = 59, .length = 3},
  [28] = {.index = 62, .length = 2},
  [29] = {.index = 64, .length = 1},
  [30] = {.index = 65, .length = 4},
  [31] = {.index = 69, .length = 1},
  [32] = {.index = 70, .length = 1},
  [33] = {.index = 71, .length = 8},
  [34] = {.index = 69, .length = 1},
  [35] = {.index = 79, .length = 2},
  [36] = {.index = 81, .length = 3},
  [37] = {.index = 69, .length = 1},
  [38] = {.index = 84, .length = 1},
  [39] = {.index = 85, .length = 2},
  [40] = {.index = 87, .length = 2},
  [41] = {.index = 89, .length = 2},
  [42] = {.index = 91, .length = 1},
  [43] = {.index = 92, .length = 1},
  [44] = {.index = 87, .length = 2},
  [45] = {.index = 93, .length = 3},
  [46] = {.index = 96, .length = 3},
  [47] = {.index = 99, .length = 2},
  [48] = {.index = 87, .length = 2},
  [49] = {.index = 101, .length = 3},
  [50] = {.index = 104, .length = 7},
  [51] = {.index = 111, .length = 3},
  [52] = {.index = 114, .length = 7},
  [53] = {.index = 121, .length = 7},
  [54] = {.index = 128, .length = 1},
  [55] = {.index = 129, .length = 4},
  [56] = {.index = 133, .length = 1},
  [57] = {.index = 134, .length = 8},
  [58] = {.index = 142, .length = 4},
  [59] = {.index = 146, .length = 8},
  [60] = {.index = 154, .length = 1},
  [61] = {.index = 155, .length = 9},
  [62] = {.index = 164, .length = 1},
  [63] = {.index = 165, .length = 2},
  [64] = {.index = 167, .length = 2},
  [65] = {.index = 169, .length = 2},
  [66] = {.index = 171, .length = 3},
  [67] = {.index = 174, .length = 7},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_head, 1},
  [1] =
    {field_namespace, 2},
  [2] =
    {field_module, 2},
  [3] =
    {field_name, 2},
  [4] =
    {field_doc, 0},
  [5] =
    {field_model, 0},
  [6] =
    {field_managed, 0},
  [7] =
    {field_event, 0},
  [8] =
    {field_meta, 0},
  [9] =
    {field_doc, 0, .inherited = true},
    {field_event, 0, .inherited = true},
    {field_managed, 0, .inherited = true},
    {field_meta, 0, .inherited = true},
    {field_model, 0, .inherited = true},
  [14] =
    {field_head, 1},
    {field_tail, 2},
  [16] =
    {field_imports, 3},
    {field_module, 2},
  [18] =
    {field_manager, 1},
  [19] =
    {field_args, 1},
  [20] =
    {field_doc, 3, .inherited = true},
    {field_event, 3, .inherited = true},
    {field_managed, 3, .inherited = true},
    {field_meta, 3, .inherited = true},
    {field_model, 3, .inherited = true},
    {field_name, 2},
  [26] =
    {field_doc, 0, .inherited = true},
    {field_doc, 1, .inherited = true},
    {field_event, 0, .inherited = true},
    {field_event, 1, .inherited = true},
    {field_managed, 0, .inherited = true},
    {field_managed, 1, .inherited = true},
    {field_meta, 0, .inherited = true},
    {field_meta, 1, .inherited = true},
    {field_model, 0, .inherited = true},
    {field_model, 1, .inherited = true},
  [36] =
    {field_body, 3},
    {field_name, 2},
  [38] =
    {field_governance, 3},
    {field_name, 2},
  [40] =
    {field_hash, 3},
    {field_imports, 4},
    {field_module, 2},
  [43] =
    {field_args, 1},
    {field_manager, 2},
  [45] =
    {field_body, 4},
    {field_doc, 3, .inherited = true},
    {field_event, 3, .inherited = true},
    {field_managed, 3, .inherited = true},
    {field_meta, 3, .inherited = true},
    {field_model, 3, .inherited = true},
    {field_name, 2},
  [52] =
    {field_doc, 4, .inherited = true},
    {field_event, 4, .inherited = true},
    {field_governance, 3},
    {field_managed, 4, .inherited = true},
    {field_meta, 4, .inherited = true},
    {field_model, 4, .inherited = true},
    {field_name, 2},
  [59] =
    {field_body, 4},
    {field_governance, 3},
    {field_name, 2},
  [62] =
    {field_key, 0},
    {field_value, 2},
  [64] =
    {field_else_branch, 2},
  [65] =
    {field_branch, 0, .inherited = true},
    {field_branch, 1, .inherited = true},
    {field_test, 0, .inherited = true},
    {field_test, 1, .inherited = true},
  [69] =
    {field_name, 0},
  [70] =
    {field_body, 2},
  [71] =
    {field_body, 5},
    {field_doc, 4, .inherited = true},
    {field_event, 4, .inherited = true},
    {field_governance, 3},
    {field_managed, 4, .inherited = true},
    {field_meta, 4, .inherited = true},
    {field_model, 4, .inherited = true},
    {field_name, 2},
  [79] =
    {field_bind_pairs, 2},
    {field_bind_pairs, 3},
  [81] =
    {field_branch, 2, .inherited = true},
    {field_else_branch, 3},
    {field_test, 2, .inherited = true},
  [84] =
    {field_type_parameter, 0, .inherited = true},
  [85] =
    {field_name, 2},
    {field_parameters, 3},
  [87] =
    {field_name, 0},
    {field_type, 1},
  [89] =
    {field_fields, 3},
    {field_name, 2},
  [91] =
    {field_hash, 2},
  [92] =
    {field_interface, 2},
  [93] =
    {field_bind_pairs, 2},
    {field_bind_pairs, 3},
    {field_body, 4},
  [96] =
    {field_bind_pairs, 2},
    {field_bind_pairs, 3},
    {field_bind_pairs, 4},
  [99] =
    {field_branch, 2},
    {field_test, 1},
  [101] =
    {field_name, 2},
    {field_parameters, 4},
    {field_return_type, 3},
  [104] =
    {field_doc, 4, .inherited = true},
    {field_event, 4, .inherited = true},
    {field_managed, 4, .inherited = true},
    {field_meta, 4, .inherited = true},
    {field_model, 4, .inherited = true},
    {field_name, 2},
    {field_parameters, 3},
  [111] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3},
  [114] =
    {field_body, 3},
    {field_doc, 4, .inherited = true},
    {field_event, 4, .inherited = true},
    {field_managed, 4, .inherited = true},
    {field_meta, 4, .inherited = true},
    {field_model, 4, .inherited = true},
    {field_name, 2},
  [121] =
    {field_doc, 3, .inherited = true},
    {field_event, 3, .inherited = true},
    {field_fields, 4},
    {field_managed, 3, .inherited = true},
    {field_meta, 3, .inherited = true},
    {field_model, 3, .inherited = true},
    {field_name, 2},
  [128] =
    {field_value, 2},
  [129] =
    {field_bind_pairs, 2},
    {field_bind_pairs, 3},
    {field_bind_pairs, 4},
    {field_body, 5},
  [133] =
    {field_type_parameter, 1},
  [134] =
    {field_doc, 5, .inherited = true},
    {field_event, 5, .inherited = true},
    {field_managed, 5, .inherited = true},
    {field_meta, 5, .inherited = true},
    {field_model, 5, .inherited = true},
    {field_name, 2},
    {field_parameters, 4},
    {field_return_type, 3},
  [142] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 4},
    {field_return_type, 3},
  [146] =
    {field_body, 5},
    {field_doc, 4, .inherited = true},
    {field_event, 4, .inherited = true},
    {field_managed, 4, .inherited = true},
    {field_meta, 4, .inherited = true},
    {field_model, 4, .inherited = true},
    {field_name, 2},
    {field_parameters, 3},
  [154] =
    {field_type_parameter, 2},
  [155] =
    {field_body, 6},
    {field_doc, 5, .inherited = true},
    {field_event, 5, .inherited = true},
    {field_managed, 5, .inherited = true},
    {field_meta, 5, .inherited = true},
    {field_model, 5, .inherited = true},
    {field_name, 2},
    {field_parameters, 4},
    {field_return_type, 3},
  [164] =
    {field_expr, 2},
  [165] =
    {field_entity, 2},
    {field_expr, 3},
  [167] =
    {field_expr, 2},
    {field_rollback_expr, 3},
  [169] =
    {field_name, 2},
    {field_schema, 5},
  [171] =
    {field_entity, 2},
    {field_expr, 3},
    {field_rollback_expr, 4},
  [174] =
    {field_doc, 7, .inherited = true},
    {field_event, 7, .inherited = true},
    {field_managed, 7, .inherited = true},
    {field_meta, 7, .inherited = true},
    {field_model, 7, .inherited = true},
    {field_name, 2},
    {field_schema, 5},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_def_identifier,
  },
  [2] = {
    [1] = alias_sym_s_expression_head,
  },
  [5] = {
    [0] = alias_sym_doc_string,
  },
  [13] = {
    [0] = alias_sym_property_identifier,
  },
  [14] = {
    [1] = alias_sym_s_expression_head,
  },
  [16] = {
    [1] = alias_sym_doc_string,
  },
  [22] = {
    [2] = alias_sym_module_identifier,
    [3] = alias_sym_module_governance,
  },
  [26] = {
    [2] = alias_sym_module_identifier,
    [3] = alias_sym_module_governance,
  },
  [27] = {
    [2] = alias_sym_module_identifier,
    [3] = alias_sym_module_governance,
  },
  [31] = {
    [0] = alias_sym_schema_field_identifier,
  },
  [33] = {
    [2] = alias_sym_module_identifier,
    [3] = alias_sym_module_governance,
  },
  [34] = {
    [0] = alias_sym_let_variable_identifier,
  },
  [37] = {
    [0] = alias_sym_parameter_identifier,
  },
  [40] = {
    [0] = alias_sym_schema_field_identifier,
  },
  [44] = {
    [0] = alias_sym_let_variable_identifier,
  },
  [48] = {
    [0] = alias_sym_parameter_identifier,
  },
  [56] = {
    [1] = alias_sym_type_parameter,
  },
  [60] = {
    [2] = alias_sym_type_parameter,
  },
  [65] = {
    [5] = alias_sym_table_schema,
  },
  [67] = {
    [5] = alias_sym_table_schema,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_reference, 3,
    sym_reference,
    alias_sym_s_expression_head,
    alias_sym_type_parameter,
  sym_type_identifier, 2,
    sym_type_identifier,
    alias_sym_type_parameter,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 18,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 16,
  [24] = 14,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 26,
  [29] = 16,
  [30] = 15,
  [31] = 13,
  [32] = 32,
  [33] = 22,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 20,
  [40] = 40,
  [41] = 14,
  [42] = 42,
  [43] = 17,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 14,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 50,
  [53] = 51,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 13,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 71,
  [74] = 72,
  [75] = 75,
  [76] = 76,
  [77] = 58,
  [78] = 78,
  [79] = 79,
  [80] = 60,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 8,
  [100] = 100,
  [101] = 70,
  [102] = 102,
  [103] = 103,
  [104] = 9,
  [105] = 105,
  [106] = 106,
  [107] = 86,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 82,
  [113] = 8,
  [114] = 114,
  [115] = 81,
  [116] = 9,
  [117] = 85,
  [118] = 118,
  [119] = 119,
  [120] = 84,
  [121] = 75,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 123,
  [128] = 123,
  [129] = 123,
  [130] = 58,
  [131] = 131,
  [132] = 60,
  [133] = 133,
  [134] = 134,
  [135] = 76,
  [136] = 79,
  [137] = 137,
  [138] = 70,
  [139] = 139,
  [140] = 85,
  [141] = 141,
  [142] = 142,
  [143] = 137,
  [144] = 144,
  [145] = 78,
  [146] = 146,
  [147] = 147,
  [148] = 86,
  [149] = 75,
  [150] = 93,
  [151] = 151,
  [152] = 152,
  [153] = 84,
  [154] = 60,
  [155] = 82,
  [156] = 81,
  [157] = 58,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 76,
  [166] = 79,
  [167] = 89,
  [168] = 70,
  [169] = 98,
  [170] = 97,
  [171] = 96,
  [172] = 95,
  [173] = 94,
  [174] = 90,
  [175] = 92,
  [176] = 87,
  [177] = 91,
  [178] = 178,
  [179] = 179,
  [180] = 88,
  [181] = 181,
  [182] = 182,
  [183] = 103,
  [184] = 88,
  [185] = 92,
  [186] = 91,
  [187] = 97,
  [188] = 96,
  [189] = 189,
  [190] = 95,
  [191] = 102,
  [192] = 98,
  [193] = 93,
  [194] = 90,
  [195] = 89,
  [196] = 87,
  [197] = 94,
  [198] = 81,
  [199] = 82,
  [200] = 84,
  [201] = 85,
  [202] = 75,
  [203] = 86,
  [204] = 137,
  [205] = 119,
  [206] = 114,
  [207] = 109,
  [208] = 111,
  [209] = 110,
  [210] = 108,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 212,
  [215] = 212,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 218,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 217,
  [227] = 222,
  [228] = 161,
  [229] = 222,
  [230] = 230,
  [231] = 217,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 234,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 160,
  [244] = 159,
  [245] = 245,
  [246] = 164,
  [247] = 163,
  [248] = 245,
  [249] = 139,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 245,
  [254] = 254,
  [255] = 255,
  [256] = 251,
  [257] = 240,
  [258] = 158,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 261,
  [263] = 263,
  [264] = 260,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 263,
  [269] = 263,
  [270] = 270,
  [271] = 271,
  [272] = 261,
  [273] = 273,
  [274] = 260,
  [275] = 162,
  [276] = 276,
  [277] = 263,
  [278] = 261,
  [279] = 260,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 283,
  [284] = 281,
  [285] = 285,
  [286] = 286,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 293,
  [294] = 294,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 304,
  [305] = 305,
  [306] = 306,
  [307] = 307,
  [308] = 308,
  [309] = 309,
  [310] = 310,
  [311] = 311,
  [312] = 312,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 287,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 324,
  [325] = 325,
  [326] = 326,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 345,
  [346] = 346,
  [347] = 347,
  [348] = 348,
  [349] = 349,
  [350] = 350,
  [351] = 351,
  [352] = 352,
  [353] = 353,
  [354] = 354,
  [355] = 355,
  [356] = 356,
  [357] = 357,
  [358] = 358,
  [359] = 359,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 367,
  [368] = 368,
  [369] = 369,
  [370] = 361,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 367,
  [375] = 372,
  [376] = 376,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 365,
  [382] = 365,
  [383] = 383,
  [384] = 367,
  [385] = 372,
  [386] = 361,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 390,
  [391] = 368,
  [392] = 392,
  [393] = 393,
  [394] = 394,
  [395] = 365,
  [396] = 378,
  [397] = 379,
  [398] = 398,
  [399] = 399,
  [400] = 380,
  [401] = 362,
  [402] = 402,
  [403] = 371,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 362,
  [410] = 394,
};

static TSCharacterRange extras_character_set_1[] = {
  {'\t', '\r'}, {' ', ' '}, {0xa0, 0xa0}, {0x1680, 0x1680}, {0x2000, 0x200b}, {0x2028, 0x2029}, {0x202f, 0x202f}, {0x205f, 0x2060},
  {0x3000, 0x3000}, {0xfeff, 0xfeff},
};

static TSCharacterRange sym_symbol_character_set_1[] = {
  {0, 0x08}, {0x0e, 0x1f}, {'!', '!'}, {'#', '&'}, {'*', '+'}, {'-', '-'}, {'/', '9'}, {';', 'Z'},
  {'\\', '\\'}, {'^', 0x10ffff},
};

static TSCharacterRange sym_atom_character_set_2[] = {
  {'!', '!'}, {'#', '&'}, {'*', '+'}, {'-', '-'}, {'/', '9'}, {'<', 'Z'}, {'_', '_'}, {'a', 'z'},
  {'|', '|'},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(25);
      ADVANCE_MAP(
        '"', 6,
        '\'', 23,
        '(', 37,
        ')', 38,
        ',', 34,
        '-', 54,
        '.', 56,
        ':', 58,
        ';', 26,
        '@', 68,
        '[', 32,
        ']', 33,
        '{', 35,
        '}', 36,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(27);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(0);
      if (('!' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= '|')) ADVANCE(55);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(5);
      if (lookahead != 0) ADVANCE(6);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '"', 6,
        '\'', 23,
        '(', 37,
        ')', 38,
        ':', 57,
        ';', 26,
        '[', 32,
        ']', 33,
        '{', 35,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(2);
      if (('!' <= lookahead && lookahead <= '+') ||
          lookahead == '-' ||
          lookahead == '/' ||
          ('<' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= '|')) ADVANCE(55);
      END_STATE();
    case 3:
      if (lookahead == '"') ADVANCE(6);
      if (lookahead == '(') ADVANCE(37);
      if (lookahead == ')') ADVANCE(38);
      if (lookahead == '.') ADVANCE(56);
      if (lookahead == ':') ADVANCE(57);
      if (lookahead == ';') ADVANCE(26);
      if (lookahead == '@') ADVANCE(69);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(3);
      END_STATE();
    case 4:
      if (lookahead == '"') ADVANCE(6);
      if (lookahead == '(') ADVANCE(37);
      if (lookahead == ')') ADVANCE(38);
      if (lookahead == '.') ADVANCE(56);
      if (lookahead == ';') ADVANCE(26);
      if (lookahead == '@') ADVANCE(68);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(4);
      if (('!' <= lookahead && lookahead <= '&') ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '/') ||
          ('<' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '|') ADVANCE(55);
      END_STATE();
    case 5:
      if (lookahead == '"') ADVANCE(30);
      if (lookahead == '\\') ADVANCE(1);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(5);
      if (lookahead != 0) ADVANCE(6);
      END_STATE();
    case 6:
      if (lookahead == '"') ADVANCE(30);
      if (lookahead == '\\') ADVANCE(1);
      if (lookahead != 0) ADVANCE(6);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(17);
      if (lookahead == 'o') ADVANCE(11);
      END_STATE();
    case 8:
      if (lookahead == 'a') ADVANCE(15);
      END_STATE();
    case 9:
      if (lookahead == 'c') ADVANCE(60);
      END_STATE();
    case 10:
      if (lookahead == 'd') ADVANCE(64);
      END_STATE();
    case 11:
      if (lookahead == 'd') ADVANCE(12);
      END_STATE();
    case 12:
      if (lookahead == 'e') ADVANCE(16);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(18);
      END_STATE();
    case 14:
      if (lookahead == 'e') ADVANCE(10);
      END_STATE();
    case 15:
      if (lookahead == 'g') ADVANCE(14);
      END_STATE();
    case 16:
      if (lookahead == 'l') ADVANCE(62);
      END_STATE();
    case 17:
      if (lookahead == 'n') ADVANCE(8);
      END_STATE();
    case 18:
      if (lookahead == 'n') ADVANCE(20);
      END_STATE();
    case 19:
      if (lookahead == 'o') ADVANCE(9);
      END_STATE();
    case 20:
      if (lookahead == 't') ADVANCE(66);
      END_STATE();
    case 21:
      if (lookahead == 'v') ADVANCE(13);
      END_STATE();
    case 22:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(29);
      END_STATE();
    case 23:
      if ((!eof && set_contains(sym_symbol_character_set_1, 10, lookahead))) ADVANCE(31);
      END_STATE();
    case 24:
      if (eof) ADVANCE(25);
      ADVANCE_MAP(
        '"', 6,
        '\'', 23,
        '(', 37,
        ')', 38,
        ',', 34,
        '-', 54,
        '.', 56,
        ':', 57,
        ';', 26,
        '[', 32,
        ']', 33,
        '{', 35,
        '}', 36,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(27);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(24);
      if (('!' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= '|')) ADVANCE(55);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(26);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(27);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(28);
      if (set_contains(sym_atom_character_set_2, 9, lookahead)) ADVANCE(55);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(sym_decimal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(29);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(sym_string);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(sym_symbol);
      if ((!eof && set_contains(sym_symbol_character_set_1, 10, lookahead))) ADVANCE(31);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'a') ADVANCE(49);
      if (lookahead == 'o') ADVANCE(43);
      if (set_contains(sym_atom_character_set_2, 9, lookahead)) ADVANCE(55);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'a') ADVANCE(47);
      if (set_contains(sym_atom_character_set_2, 9, lookahead)) ADVANCE(55);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'c') ADVANCE(61);
      if (set_contains(sym_atom_character_set_2, 9, lookahead)) ADVANCE(55);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'd') ADVANCE(65);
      if (set_contains(sym_atom_character_set_2, 9, lookahead)) ADVANCE(55);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'd') ADVANCE(44);
      if (set_contains(sym_atom_character_set_2, 9, lookahead)) ADVANCE(55);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'e') ADVANCE(48);
      if (set_contains(sym_atom_character_set_2, 9, lookahead)) ADVANCE(55);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'e') ADVANCE(50);
      if (set_contains(sym_atom_character_set_2, 9, lookahead)) ADVANCE(55);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'e') ADVANCE(42);
      if (set_contains(sym_atom_character_set_2, 9, lookahead)) ADVANCE(55);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'g') ADVANCE(46);
      if (set_contains(sym_atom_character_set_2, 9, lookahead)) ADVANCE(55);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'l') ADVANCE(63);
      if (set_contains(sym_atom_character_set_2, 9, lookahead)) ADVANCE(55);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'n') ADVANCE(40);
      if (set_contains(sym_atom_character_set_2, 9, lookahead)) ADVANCE(55);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'n') ADVANCE(52);
      if (set_contains(sym_atom_character_set_2, 9, lookahead)) ADVANCE(55);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'o') ADVANCE(41);
      if (set_contains(sym_atom_character_set_2, 9, lookahead)) ADVANCE(55);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 't') ADVANCE(67);
      if (set_contains(sym_atom_character_set_2, 9, lookahead)) ADVANCE(55);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_atom);
      if (lookahead == 'v') ADVANCE(45);
      if (set_contains(sym_atom_character_set_2, 9, lookahead)) ADVANCE(55);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_atom);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(28);
      if (set_contains(sym_atom_character_set_2, 9, lookahead)) ADVANCE(55);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(sym_atom);
      if (set_contains(sym_atom_character_set_2, 9, lookahead)) ADVANCE(55);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(59);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_ATdoc);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_ATdoc);
      if (set_contains(sym_atom_character_set_2, 9, lookahead)) ADVANCE(55);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_ATmodel);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_ATmodel);
      if (set_contains(sym_atom_character_set_2, 9, lookahead)) ADVANCE(55);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_ATmanaged);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_ATmanaged);
      if (set_contains(sym_atom_character_set_2, 9, lookahead)) ADVANCE(55);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_ATevent);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_ATevent);
      if (set_contains(sym_atom_character_set_2, 9, lookahead)) ADVANCE(55);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == 'd') ADVANCE(51);
      if (lookahead == 'e') ADVANCE(53);
      if (lookahead == 'm') ADVANCE(39);
      if (set_contains(sym_atom_character_set_2, 9, lookahead)) ADVANCE(55);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == 'd') ADVANCE(19);
      if (lookahead == 'e') ADVANCE(21);
      if (lookahead == 'm') ADVANCE(7);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'b', 1,
        'c', 2,
        'd', 3,
        'f', 4,
        'g', 5,
        'i', 6,
        'k', 7,
        'l', 8,
        'm', 9,
        'n', 10,
        'o', 11,
        's', 12,
        't', 13,
        'u', 14,
        'v', 15,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'l') ADVANCE(16);
      if (lookahead == 'o') ADVANCE(17);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(18);
      END_STATE();
    case 3:
      if (lookahead == 'e') ADVANCE(19);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(20);
      END_STATE();
    case 5:
      if (lookahead == 'u') ADVANCE(21);
      END_STATE();
    case 6:
      if (lookahead == 'm') ADVANCE(22);
      if (lookahead == 'n') ADVANCE(23);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(24);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(25);
      if (lookahead == 'i') ADVANCE(26);
      END_STATE();
    case 9:
      if (lookahead == 'o') ADVANCE(27);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(28);
      END_STATE();
    case 11:
      if (lookahead == 'b') ADVANCE(29);
      END_STATE();
    case 12:
      if (lookahead == 't') ADVANCE(30);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(31);
      if (lookahead == 'i') ADVANCE(32);
      if (lookahead == 'r') ADVANCE(33);
      END_STATE();
    case 14:
      if (lookahead == 's') ADVANCE(34);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(35);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(36);
      END_STATE();
    case 17:
      if (lookahead == 'o') ADVANCE(37);
      END_STATE();
    case 18:
      if (lookahead == 'n') ADVANCE(38);
      END_STATE();
    case 19:
      if (lookahead == 'c') ADVANCE(39);
      if (lookahead == 'f') ADVANCE(40);
      END_STATE();
    case 20:
      if (lookahead == 'l') ADVANCE(41);
      END_STATE();
    case 21:
      if (lookahead == 'a') ADVANCE(42);
      END_STATE();
    case 22:
      if (lookahead == 'p') ADVANCE(43);
      END_STATE();
    case 23:
      if (lookahead == 't') ADVANCE(44);
      END_STATE();
    case 24:
      if (lookahead == 'y') ADVANCE(45);
      END_STATE();
    case 25:
      if (lookahead == 't') ADVANCE(46);
      END_STATE();
    case 26:
      if (lookahead == 's') ADVANCE(47);
      END_STATE();
    case 27:
      if (lookahead == 'd') ADVANCE(48);
      END_STATE();
    case 28:
      if (lookahead == 'm') ADVANCE(49);
      END_STATE();
    case 29:
      if (lookahead == 'j') ADVANCE(50);
      END_STATE();
    case 30:
      if (lookahead == 'e') ADVANCE(51);
      if (lookahead == 'r') ADVANCE(52);
      END_STATE();
    case 31:
      if (lookahead == 'b') ADVANCE(53);
      END_STATE();
    case 32:
      if (lookahead == 'm') ADVANCE(54);
      END_STATE();
    case 33:
      if (lookahead == 'u') ADVANCE(55);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(56);
      END_STATE();
    case 35:
      if (lookahead == 'l') ADVANCE(57);
      END_STATE();
    case 36:
      if (lookahead == 's') ADVANCE(58);
      END_STATE();
    case 37:
      if (lookahead == 'l') ADVANCE(59);
      END_STATE();
    case 38:
      if (lookahead == 'd') ADVANCE(60);
      END_STATE();
    case 39:
      if (lookahead == 'i') ADVANCE(61);
      END_STATE();
    case 40:
      if (lookahead == 'c') ADVANCE(62);
      if (lookahead == 'p') ADVANCE(63);
      if (lookahead == 's') ADVANCE(64);
      if (lookahead == 't') ADVANCE(65);
      if (lookahead == 'u') ADVANCE(66);
      END_STATE();
    case 41:
      if (lookahead == 's') ADVANCE(67);
      END_STATE();
    case 42:
      if (lookahead == 'r') ADVANCE(68);
      END_STATE();
    case 43:
      if (lookahead == 'l') ADVANCE(69);
      END_STATE();
    case 44:
      if (lookahead == 'e') ADVANCE(70);
      END_STATE();
    case 45:
      if (lookahead == 's') ADVANCE(71);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_let);
      if (lookahead == '*') ADVANCE(72);
      END_STATE();
    case 47:
      if (lookahead == 't') ADVANCE(73);
      END_STATE();
    case 48:
      if (lookahead == 'u') ADVANCE(74);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(75);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(76);
      END_STATE();
    case 51:
      if (lookahead == 'p') ADVANCE(77);
      END_STATE();
    case 52:
      if (lookahead == 'i') ADVANCE(78);
      END_STATE();
    case 53:
      if (lookahead == 'l') ADVANCE(79);
      END_STATE();
    case 54:
      if (lookahead == 'e') ADVANCE(80);
      END_STATE();
    case 55:
      if (lookahead == 'e') ADVANCE(81);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_use);
      END_STATE();
    case 57:
      if (lookahead == 'u') ADVANCE(82);
      END_STATE();
    case 58:
      if (lookahead == 's') ADVANCE(83);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_bool);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_cond);
      END_STATE();
    case 61:
      if (lookahead == 'm') ADVANCE(84);
      END_STATE();
    case 62:
      if (lookahead == 'a') ADVANCE(85);
      if (lookahead == 'o') ADVANCE(86);
      END_STATE();
    case 63:
      if (lookahead == 'a') ADVANCE(87);
      if (lookahead == 'r') ADVANCE(88);
      END_STATE();
    case 64:
      if (lookahead == 'c') ADVANCE(89);
      END_STATE();
    case 65:
      if (lookahead == 'a') ADVANCE(90);
      END_STATE();
    case 66:
      if (lookahead == 'n') ADVANCE(91);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(81);
      END_STATE();
    case 68:
      if (lookahead == 'd') ADVANCE(92);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(93);
      END_STATE();
    case 70:
      if (lookahead == 'g') ADVANCE(94);
      if (lookahead == 'r') ADVANCE(95);
      END_STATE();
    case 71:
      if (lookahead == 'e') ADVANCE(96);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_let_STAR);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_list);
      END_STATE();
    case 74:
      if (lookahead == 'l') ADVANCE(97);
      END_STATE();
    case 75:
      if (lookahead == 's') ADVANCE(98);
      END_STATE();
    case 76:
      if (lookahead == 'c') ADVANCE(99);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_step);
      if (lookahead == '-') ADVANCE(100);
      END_STATE();
    case 78:
      if (lookahead == 'n') ADVANCE(101);
      END_STATE();
    case 79:
      if (lookahead == 'e') ADVANCE(102);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_time);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_boolean);
      END_STATE();
    case 82:
      if (lookahead == 'e') ADVANCE(103);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_bless);
      END_STATE();
    case 84:
      if (lookahead == 'a') ADVANCE(104);
      END_STATE();
    case 85:
      if (lookahead == 'p') ADVANCE(105);
      END_STATE();
    case 86:
      if (lookahead == 'n') ADVANCE(106);
      END_STATE();
    case 87:
      if (lookahead == 'c') ADVANCE(107);
      END_STATE();
    case 88:
      if (lookahead == 'o') ADVANCE(108);
      END_STATE();
    case 89:
      if (lookahead == 'h') ADVANCE(109);
      END_STATE();
    case 90:
      if (lookahead == 'b') ADVANCE(110);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_defun);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_guard);
      END_STATE();
    case 93:
      if (lookahead == 'm') ADVANCE(111);
      END_STATE();
    case 94:
      if (lookahead == 'e') ADVANCE(112);
      END_STATE();
    case 95:
      if (lookahead == 'f') ADVANCE(113);
      END_STATE();
    case 96:
      if (lookahead == 't') ADVANCE(114);
      END_STATE();
    case 97:
      if (lookahead == 'e') ADVANCE(115);
      END_STATE();
    case 98:
      if (lookahead == 'p') ADVANCE(116);
      END_STATE();
    case 99:
      if (lookahead == 't') ADVANCE(117);
      END_STATE();
    case 100:
      if (lookahead == 'w') ADVANCE(118);
      END_STATE();
    case 101:
      if (lookahead == 'g') ADVANCE(119);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_table);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_value);
      END_STATE();
    case 104:
      if (lookahead == 'l') ADVANCE(120);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_defcap);
      END_STATE();
    case 106:
      if (lookahead == 's') ADVANCE(121);
      END_STATE();
    case 107:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 108:
      if (lookahead == 'p') ADVANCE(123);
      END_STATE();
    case 109:
      if (lookahead == 'e') ADVANCE(124);
      END_STATE();
    case 110:
      if (lookahead == 'l') ADVANCE(125);
      END_STATE();
    case 111:
      if (lookahead == 'e') ADVANCE(126);
      END_STATE();
    case 112:
      if (lookahead == 'r') ADVANCE(127);
      END_STATE();
    case 113:
      if (lookahead == 'a') ADVANCE(128);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_keyset);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 116:
      if (lookahead == 'a') ADVANCE(129);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_object);
      END_STATE();
    case 118:
      if (lookahead == 'i') ADVANCE(130);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_decimal);
      END_STATE();
    case 121:
      if (lookahead == 't') ADVANCE(131);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_defpact);
      END_STATE();
    case 123:
      if (lookahead == 'e') ADVANCE(132);
      END_STATE();
    case 124:
      if (lookahead == 'm') ADVANCE(133);
      END_STATE();
    case 125:
      if (lookahead == 'e') ADVANCE(134);
      END_STATE();
    case 126:
      if (lookahead == 'n') ADVANCE(135);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_integer);
      END_STATE();
    case 128:
      if (lookahead == 'c') ADVANCE(136);
      END_STATE();
    case 129:
      if (lookahead == 'c') ADVANCE(137);
      END_STATE();
    case 130:
      if (lookahead == 't') ADVANCE(138);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_defconst);
      END_STATE();
    case 132:
      if (lookahead == 'r') ADVANCE(139);
      END_STATE();
    case 133:
      if (lookahead == 'a') ADVANCE(140);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_deftable);
      END_STATE();
    case 135:
      if (lookahead == 't') ADVANCE(141);
      END_STATE();
    case 136:
      if (lookahead == 'e') ADVANCE(142);
      END_STATE();
    case 137:
      if (lookahead == 'e') ADVANCE(143);
      END_STATE();
    case 138:
      if (lookahead == 'h') ADVANCE(144);
      END_STATE();
    case 139:
      if (lookahead == 't') ADVANCE(145);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_defschema);
      END_STATE();
    case 141:
      if (lookahead == 's') ADVANCE(146);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_namespace);
      END_STATE();
    case 144:
      if (lookahead == '-') ADVANCE(147);
      END_STATE();
    case 145:
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 147:
      if (lookahead == 'r') ADVANCE(149);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_defproperty);
      END_STATE();
    case 149:
      if (lookahead == 'o') ADVANCE(150);
      END_STATE();
    case 150:
      if (lookahead == 'l') ADVANCE(151);
      END_STATE();
    case 151:
      if (lookahead == 'l') ADVANCE(152);
      END_STATE();
    case 152:
      if (lookahead == 'b') ADVANCE(153);
      END_STATE();
    case 153:
      if (lookahead == 'a') ADVANCE(154);
      END_STATE();
    case 154:
      if (lookahead == 'c') ADVANCE(155);
      END_STATE();
    case 155:
      if (lookahead == 'k') ADVANCE(156);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_step_DASHwith_DASHrollback);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 0},
  [3] = {.lex_state = 0},
  [4] = {.lex_state = 0},
  [5] = {.lex_state = 0},
  [6] = {.lex_state = 3},
  [7] = {.lex_state = 3},
  [8] = {.lex_state = 0},
  [9] = {.lex_state = 0},
  [10] = {.lex_state = 24},
  [11] = {.lex_state = 24},
  [12] = {.lex_state = 24},
  [13] = {.lex_state = 0},
  [14] = {.lex_state = 24},
  [15] = {.lex_state = 24},
  [16] = {.lex_state = 24},
  [17] = {.lex_state = 24},
  [18] = {.lex_state = 24},
  [19] = {.lex_state = 24},
  [20] = {.lex_state = 24},
  [21] = {.lex_state = 24},
  [22] = {.lex_state = 24},
  [23] = {.lex_state = 24},
  [24] = {.lex_state = 24},
  [25] = {.lex_state = 24},
  [26] = {.lex_state = 24},
  [27] = {.lex_state = 24},
  [28] = {.lex_state = 24},
  [29] = {.lex_state = 24},
  [30] = {.lex_state = 24},
  [31] = {.lex_state = 0},
  [32] = {.lex_state = 24},
  [33] = {.lex_state = 24},
  [34] = {.lex_state = 24},
  [35] = {.lex_state = 24},
  [36] = {.lex_state = 24},
  [37] = {.lex_state = 24},
  [38] = {.lex_state = 24},
  [39] = {.lex_state = 24},
  [40] = {.lex_state = 24},
  [41] = {.lex_state = 24},
  [42] = {.lex_state = 24},
  [43] = {.lex_state = 24},
  [44] = {.lex_state = 24},
  [45] = {.lex_state = 24},
  [46] = {.lex_state = 24},
  [47] = {.lex_state = 24},
  [48] = {.lex_state = 24},
  [49] = {.lex_state = 24},
  [50] = {.lex_state = 24},
  [51] = {.lex_state = 24},
  [52] = {.lex_state = 24},
  [53] = {.lex_state = 24},
  [54] = {.lex_state = 3},
  [55] = {.lex_state = 3},
  [56] = {.lex_state = 24},
  [57] = {.lex_state = 24},
  [58] = {.lex_state = 0},
  [59] = {.lex_state = 24},
  [60] = {.lex_state = 0},
  [61] = {.lex_state = 24},
  [62] = {.lex_state = 4},
  [63] = {.lex_state = 24},
  [64] = {.lex_state = 24},
  [65] = {.lex_state = 24},
  [66] = {.lex_state = 0},
  [67] = {.lex_state = 24},
  [68] = {.lex_state = 24},
  [69] = {.lex_state = 24},
  [70] = {.lex_state = 0},
  [71] = {.lex_state = 2},
  [72] = {.lex_state = 2},
  [73] = {.lex_state = 2},
  [74] = {.lex_state = 2},
  [75] = {.lex_state = 0},
  [76] = {.lex_state = 0},
  [77] = {.lex_state = 24},
  [78] = {.lex_state = 24},
  [79] = {.lex_state = 0},
  [80] = {.lex_state = 24},
  [81] = {.lex_state = 0},
  [82] = {.lex_state = 0},
  [83] = {.lex_state = 0},
  [84] = {.lex_state = 0},
  [85] = {.lex_state = 0},
  [86] = {.lex_state = 0},
  [87] = {.lex_state = 0},
  [88] = {.lex_state = 0},
  [89] = {.lex_state = 0},
  [90] = {.lex_state = 0},
  [91] = {.lex_state = 0},
  [92] = {.lex_state = 0},
  [93] = {.lex_state = 0},
  [94] = {.lex_state = 0},
  [95] = {.lex_state = 0},
  [96] = {.lex_state = 0},
  [97] = {.lex_state = 0},
  [98] = {.lex_state = 0},
  [99] = {.lex_state = 3},
  [100] = {.lex_state = 24},
  [101] = {.lex_state = 24},
  [102] = {.lex_state = 24},
  [103] = {.lex_state = 24},
  [104] = {.lex_state = 3},
  [105] = {.lex_state = 3},
  [106] = {.lex_state = 3},
  [107] = {.lex_state = 24},
  [108] = {.lex_state = 24},
  [109] = {.lex_state = 24},
  [110] = {.lex_state = 24},
  [111] = {.lex_state = 24},
  [112] = {.lex_state = 24},
  [113] = {.lex_state = 4},
  [114] = {.lex_state = 24},
  [115] = {.lex_state = 24},
  [116] = {.lex_state = 4},
  [117] = {.lex_state = 24},
  [118] = {.lex_state = 24},
  [119] = {.lex_state = 24},
  [120] = {.lex_state = 24},
  [121] = {.lex_state = 24},
  [122] = {.lex_state = 0},
  [123] = {.lex_state = 24},
  [124] = {.lex_state = 0},
  [125] = {.lex_state = 0},
  [126] = {.lex_state = 0},
  [127] = {.lex_state = 24},
  [128] = {.lex_state = 24},
  [129] = {.lex_state = 24},
  [130] = {.lex_state = 4},
  [131] = {.lex_state = 24},
  [132] = {.lex_state = 4},
  [133] = {.lex_state = 4},
  [134] = {.lex_state = 24},
  [135] = {.lex_state = 24},
  [136] = {.lex_state = 24},
  [137] = {.lex_state = 24},
  [138] = {.lex_state = 4},
  [139] = {.lex_state = 24},
  [140] = {.lex_state = 4},
  [141] = {.lex_state = 2},
  [142] = {.lex_state = 24},
  [143] = {.lex_state = 3},
  [144] = {.lex_state = 0},
  [145] = {.lex_state = 3},
  [146] = {.lex_state = 0},
  [147] = {.lex_state = 0},
  [148] = {.lex_state = 4},
  [149] = {.lex_state = 4},
  [150] = {.lex_state = 4},
  [151] = {.lex_state = 24},
  [152] = {.lex_state = 0},
  [153] = {.lex_state = 4},
  [154] = {.lex_state = 3},
  [155] = {.lex_state = 4},
  [156] = {.lex_state = 4},
  [157] = {.lex_state = 3},
  [158] = {.lex_state = 24},
  [159] = {.lex_state = 24},
  [160] = {.lex_state = 24},
  [161] = {.lex_state = 24},
  [162] = {.lex_state = 24},
  [163] = {.lex_state = 24},
  [164] = {.lex_state = 24},
  [165] = {.lex_state = 3},
  [166] = {.lex_state = 3},
  [167] = {.lex_state = 3},
  [168] = {.lex_state = 3},
  [169] = {.lex_state = 3},
  [170] = {.lex_state = 3},
  [171] = {.lex_state = 3},
  [172] = {.lex_state = 3},
  [173] = {.lex_state = 3},
  [174] = {.lex_state = 3},
  [175] = {.lex_state = 3},
  [176] = {.lex_state = 3},
  [177] = {.lex_state = 3},
  [178] = {.lex_state = 0},
  [179] = {.lex_state = 2},
  [180] = {.lex_state = 3},
  [181] = {.lex_state = 3},
  [182] = {.lex_state = 0},
  [183] = {.lex_state = 3},
  [184] = {.lex_state = 4},
  [185] = {.lex_state = 4},
  [186] = {.lex_state = 4},
  [187] = {.lex_state = 4},
  [188] = {.lex_state = 4},
  [189] = {.lex_state = 2},
  [190] = {.lex_state = 4},
  [191] = {.lex_state = 3},
  [192] = {.lex_state = 4},
  [193] = {.lex_state = 4},
  [194] = {.lex_state = 4},
  [195] = {.lex_state = 4},
  [196] = {.lex_state = 4},
  [197] = {.lex_state = 4},
  [198] = {.lex_state = 3},
  [199] = {.lex_state = 3},
  [200] = {.lex_state = 3},
  [201] = {.lex_state = 3},
  [202] = {.lex_state = 3},
  [203] = {.lex_state = 3},
  [204] = {.lex_state = 4},
  [205] = {.lex_state = 3},
  [206] = {.lex_state = 3},
  [207] = {.lex_state = 3},
  [208] = {.lex_state = 3},
  [209] = {.lex_state = 3},
  [210] = {.lex_state = 3},
  [211] = {.lex_state = 2},
  [212] = {.lex_state = 0},
  [213] = {.lex_state = 2},
  [214] = {.lex_state = 0},
  [215] = {.lex_state = 0},
  [216] = {.lex_state = 0},
  [217] = {.lex_state = 0},
  [218] = {.lex_state = 2},
  [219] = {.lex_state = 0},
  [220] = {.lex_state = 0},
  [221] = {.lex_state = 2},
  [222] = {.lex_state = 0},
  [223] = {.lex_state = 0},
  [224] = {.lex_state = 0},
  [225] = {.lex_state = 0},
  [226] = {.lex_state = 0},
  [227] = {.lex_state = 0},
  [228] = {.lex_state = 2},
  [229] = {.lex_state = 0},
  [230] = {.lex_state = 0},
  [231] = {.lex_state = 0},
  [232] = {.lex_state = 0},
  [233] = {.lex_state = 0},
  [234] = {.lex_state = 0},
  [235] = {.lex_state = 2},
  [236] = {.lex_state = 0},
  [237] = {.lex_state = 2},
  [238] = {.lex_state = 3},
  [239] = {.lex_state = 3},
  [240] = {.lex_state = 0},
  [241] = {.lex_state = 2},
  [242] = {.lex_state = 3},
  [243] = {.lex_state = 2},
  [244] = {.lex_state = 2},
  [245] = {.lex_state = 2},
  [246] = {.lex_state = 2},
  [247] = {.lex_state = 2},
  [248] = {.lex_state = 2},
  [249] = {.lex_state = 2},
  [250] = {.lex_state = 2},
  [251] = {.lex_state = 2},
  [252] = {.lex_state = 2},
  [253] = {.lex_state = 2},
  [254] = {.lex_state = 0},
  [255] = {.lex_state = 0},
  [256] = {.lex_state = 2},
  [257] = {.lex_state = 0},
  [258] = {.lex_state = 2},
  [259] = {.lex_state = 2},
  [260] = {.lex_state = 0},
  [261] = {.lex_state = 0},
  [262] = {.lex_state = 0},
  [263] = {.lex_state = 0},
  [264] = {.lex_state = 0},
  [265] = {.lex_state = 0},
  [266] = {.lex_state = 0},
  [267] = {.lex_state = 2},
  [268] = {.lex_state = 0},
  [269] = {.lex_state = 0},
  [270] = {.lex_state = 0},
  [271] = {.lex_state = 2},
  [272] = {.lex_state = 0},
  [273] = {.lex_state = 0},
  [274] = {.lex_state = 0},
  [275] = {.lex_state = 2},
  [276] = {.lex_state = 0},
  [277] = {.lex_state = 0},
  [278] = {.lex_state = 0},
  [279] = {.lex_state = 0},
  [280] = {.lex_state = 0},
  [281] = {.lex_state = 2},
  [282] = {.lex_state = 0},
  [283] = {.lex_state = 0},
  [284] = {.lex_state = 2},
  [285] = {.lex_state = 0},
  [286] = {.lex_state = 0},
  [287] = {.lex_state = 2},
  [288] = {.lex_state = 0},
  [289] = {.lex_state = 0},
  [290] = {.lex_state = 0},
  [291] = {.lex_state = 0},
  [292] = {.lex_state = 0},
  [293] = {.lex_state = 0},
  [294] = {.lex_state = 0},
  [295] = {.lex_state = 0},
  [296] = {.lex_state = 0},
  [297] = {.lex_state = 0},
  [298] = {.lex_state = 0},
  [299] = {.lex_state = 0},
  [300] = {.lex_state = 0},
  [301] = {.lex_state = 0},
  [302] = {.lex_state = 2},
  [303] = {.lex_state = 2},
  [304] = {.lex_state = 0},
  [305] = {.lex_state = 2},
  [306] = {.lex_state = 0},
  [307] = {.lex_state = 0},
  [308] = {.lex_state = 0},
  [309] = {.lex_state = 0},
  [310] = {.lex_state = 0},
  [311] = {.lex_state = 0},
  [312] = {.lex_state = 0},
  [313] = {.lex_state = 0},
  [314] = {.lex_state = 2},
  [315] = {.lex_state = 0},
  [316] = {.lex_state = 0},
  [317] = {.lex_state = 2},
  [318] = {.lex_state = 0},
  [319] = {.lex_state = 0},
  [320] = {.lex_state = 0},
  [321] = {.lex_state = 0},
  [322] = {.lex_state = 2},
  [323] = {.lex_state = 2},
  [324] = {.lex_state = 2},
  [325] = {.lex_state = 2},
  [326] = {.lex_state = 2},
  [327] = {.lex_state = 0},
  [328] = {.lex_state = 2},
  [329] = {.lex_state = 2},
  [330] = {.lex_state = 0},
  [331] = {.lex_state = 2},
  [332] = {.lex_state = 0},
  [333] = {.lex_state = 0},
  [334] = {.lex_state = 0},
  [335] = {.lex_state = 0},
  [336] = {.lex_state = 0},
  [337] = {.lex_state = 0},
  [338] = {.lex_state = 0},
  [339] = {.lex_state = 2},
  [340] = {.lex_state = 0},
  [341] = {.lex_state = 0},
  [342] = {.lex_state = 0},
  [343] = {.lex_state = 0},
  [344] = {.lex_state = 0},
  [345] = {.lex_state = 0},
  [346] = {.lex_state = 0},
  [347] = {.lex_state = 0},
  [348] = {.lex_state = 0},
  [349] = {.lex_state = 0},
  [350] = {.lex_state = 0},
  [351] = {.lex_state = 0},
  [352] = {.lex_state = 0},
  [353] = {.lex_state = 0},
  [354] = {.lex_state = 0},
  [355] = {.lex_state = 0},
  [356] = {.lex_state = 0},
  [357] = {.lex_state = 0},
  [358] = {.lex_state = 0},
  [359] = {.lex_state = 2},
  [360] = {.lex_state = 0},
  [361] = {.lex_state = 2},
  [362] = {.lex_state = 0},
  [363] = {.lex_state = 0},
  [364] = {.lex_state = 0},
  [365] = {.lex_state = 2},
  [366] = {.lex_state = 0},
  [367] = {.lex_state = 0},
  [368] = {.lex_state = 0},
  [369] = {.lex_state = 0},
  [370] = {.lex_state = 2},
  [371] = {.lex_state = 0},
  [372] = {.lex_state = 2},
  [373] = {.lex_state = 0},
  [374] = {.lex_state = 0},
  [375] = {.lex_state = 2},
  [376] = {.lex_state = 0},
  [377] = {.lex_state = 0},
  [378] = {.lex_state = 0},
  [379] = {.lex_state = 0},
  [380] = {.lex_state = 0},
  [381] = {.lex_state = 2},
  [382] = {.lex_state = 2},
  [383] = {.lex_state = 0},
  [384] = {.lex_state = 0},
  [385] = {.lex_state = 2},
  [386] = {.lex_state = 2},
  [387] = {.lex_state = 0},
  [388] = {.lex_state = 2},
  [389] = {.lex_state = 3},
  [390] = {.lex_state = 0},
  [391] = {.lex_state = 0},
  [392] = {.lex_state = 0},
  [393] = {.lex_state = 0},
  [394] = {.lex_state = 0},
  [395] = {.lex_state = 2},
  [396] = {.lex_state = 0},
  [397] = {.lex_state = 0},
  [398] = {.lex_state = 0},
  [399] = {.lex_state = 2},
  [400] = {.lex_state = 0},
  [401] = {.lex_state = 0},
  [402] = {.lex_state = 0},
  [403] = {.lex_state = 0},
  [404] = {.lex_state = 2},
  [405] = {.lex_state = 0},
  [406] = {.lex_state = 0},
  [407] = {.lex_state = 0},
  [408] = {.lex_state = 0},
  [409] = {.lex_state = 0},
  [410] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_atom] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_integer] = ACTIONS(1),
    [sym_decimal] = ACTIONS(1),
    [sym_string] = ACTIONS(1),
    [sym_boolean] = ACTIONS(1),
    [sym_symbol] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_object] = ACTIONS(1),
    [anon_sym_table] = ACTIONS(1),
    [anon_sym_integer] = ACTIONS(1),
    [anon_sym_decimal] = ACTIONS(1),
    [anon_sym_time] = ACTIONS(1),
    [anon_sym_bool] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_list] = ACTIONS(1),
    [anon_sym_value] = ACTIONS(1),
    [anon_sym_keyset] = ACTIONS(1),
    [anon_sym_guard] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_ATdoc] = ACTIONS(1),
    [anon_sym_ATmodel] = ACTIONS(1),
    [anon_sym_defproperty] = ACTIONS(1),
    [anon_sym_ATmanaged] = ACTIONS(1),
    [anon_sym_ATevent] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_namespace] = ACTIONS(1),
    [anon_sym_bless] = ACTIONS(1),
    [anon_sym_defun] = ACTIONS(1),
    [anon_sym_defcap] = ACTIONS(1),
    [anon_sym_defconst] = ACTIONS(1),
    [anon_sym_defpact] = ACTIONS(1),
    [anon_sym_defschema] = ACTIONS(1),
    [anon_sym_deftable] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_let_STAR] = ACTIONS(1),
    [anon_sym_cond] = ACTIONS(1),
    [anon_sym_step] = ACTIONS(1),
    [anon_sym_step_DASHwith_DASHrollback] = ACTIONS(1),
    [anon_sym_use] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(406),
    [sym_s_expression] = STATE(182),
    [sym_namespace] = STATE(182),
    [sym_use] = STATE(182),
    [sym_interface] = STATE(182),
    [sym_module] = STATE(182),
    [aux_sym_source_file_repeat1] = STATE(182),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(7),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(15), 1,
      sym_string,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_RPAREN,
    ACTIONS(25), 1,
      anon_sym_ATdoc,
    ACTIONS(27), 1,
      anon_sym_ATmodel,
    ACTIONS(29), 1,
      anon_sym_ATmanaged,
    ACTIONS(31), 1,
      anon_sym_ATevent,
    ACTIONS(33), 1,
      anon_sym_AT,
    STATE(8), 1,
      aux_sym__doc_or_meta_repeat1,
    STATE(32), 1,
      sym__doc_or_meta,
    STATE(92), 1,
      sym_doc,
    STATE(94), 1,
      sym_model,
    STATE(95), 1,
      sym_managed,
    STATE(96), 1,
      sym_event,
    STATE(97), 1,
      sym_meta,
    ACTIONS(11), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(13), 2,
      sym_decimal,
      sym_symbol,
    STATE(34), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [77] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(15), 1,
      sym_string,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_ATdoc,
    ACTIONS(27), 1,
      anon_sym_ATmodel,
    ACTIONS(29), 1,
      anon_sym_ATmanaged,
    ACTIONS(31), 1,
      anon_sym_ATevent,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(39), 1,
      anon_sym_RPAREN,
    STATE(8), 1,
      aux_sym__doc_or_meta_repeat1,
    STATE(49), 1,
      sym__doc_or_meta,
    STATE(92), 1,
      sym_doc,
    STATE(94), 1,
      sym_model,
    STATE(95), 1,
      sym_managed,
    STATE(96), 1,
      sym_event,
    STATE(97), 1,
      sym_meta,
    ACTIONS(35), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(37), 2,
      sym_decimal,
      sym_symbol,
    STATE(44), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [154] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(15), 1,
      sym_string,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_ATdoc,
    ACTIONS(27), 1,
      anon_sym_ATmodel,
    ACTIONS(29), 1,
      anon_sym_ATmanaged,
    ACTIONS(31), 1,
      anon_sym_ATevent,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(45), 1,
      anon_sym_RPAREN,
    STATE(8), 1,
      aux_sym__doc_or_meta_repeat1,
    STATE(45), 1,
      sym__doc_or_meta,
    STATE(92), 1,
      sym_doc,
    STATE(94), 1,
      sym_model,
    STATE(95), 1,
      sym_managed,
    STATE(96), 1,
      sym_event,
    STATE(97), 1,
      sym_meta,
    ACTIONS(41), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(43), 2,
      sym_decimal,
      sym_symbol,
    STATE(46), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [231] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(15), 1,
      sym_string,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_ATdoc,
    ACTIONS(27), 1,
      anon_sym_ATmodel,
    ACTIONS(29), 1,
      anon_sym_ATmanaged,
    ACTIONS(31), 1,
      anon_sym_ATevent,
    ACTIONS(33), 1,
      anon_sym_AT,
    ACTIONS(51), 1,
      anon_sym_RPAREN,
    STATE(8), 1,
      aux_sym__doc_or_meta_repeat1,
    STATE(35), 1,
      sym__doc_or_meta,
    STATE(92), 1,
      sym_doc,
    STATE(94), 1,
      sym_model,
    STATE(95), 1,
      sym_managed,
    STATE(96), 1,
      sym_event,
    STATE(97), 1,
      sym_meta,
    ACTIONS(47), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(49), 2,
      sym_decimal,
      sym_symbol,
    STATE(40), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [308] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(53), 1,
      sym_string,
    ACTIONS(55), 1,
      anon_sym_LPAREN,
    ACTIONS(57), 1,
      anon_sym_RPAREN,
    ACTIONS(59), 1,
      anon_sym_ATdoc,
    ACTIONS(61), 1,
      anon_sym_ATmodel,
    ACTIONS(63), 1,
      anon_sym_ATmanaged,
    ACTIONS(65), 1,
      anon_sym_ATevent,
    ACTIONS(67), 1,
      anon_sym_AT,
    STATE(99), 1,
      aux_sym__doc_or_meta_repeat1,
    STATE(122), 1,
      sym__doc_or_meta,
    STATE(170), 1,
      sym_meta,
    STATE(171), 1,
      sym_event,
    STATE(172), 1,
      sym_managed,
    STATE(173), 1,
      sym_model,
    STATE(175), 1,
      sym_doc,
    STATE(124), 10,
      sym_bless,
      sym_defun,
      sym_defcap,
      sym_defconst,
      sym_defpact,
      sym_defschema,
      sym_deftable,
      sym_use,
      sym_implements,
      aux_sym_module_repeat1,
  [369] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(53), 1,
      sym_string,
    ACTIONS(59), 1,
      anon_sym_ATdoc,
    ACTIONS(61), 1,
      anon_sym_ATmodel,
    ACTIONS(63), 1,
      anon_sym_ATmanaged,
    ACTIONS(65), 1,
      anon_sym_ATevent,
    ACTIONS(67), 1,
      anon_sym_AT,
    ACTIONS(69), 1,
      anon_sym_LPAREN,
    ACTIONS(71), 1,
      anon_sym_RPAREN,
    STATE(99), 1,
      aux_sym__doc_or_meta_repeat1,
    STATE(146), 1,
      sym__doc_or_meta,
    STATE(170), 1,
      sym_meta,
    STATE(171), 1,
      sym_event,
    STATE(172), 1,
      sym_managed,
    STATE(173), 1,
      sym_model,
    STATE(175), 1,
      sym_doc,
    STATE(152), 7,
      sym_defun,
      sym_defcap,
      sym_defconst,
      sym_defpact,
      sym_defschema,
      sym_use,
      aux_sym_interface_repeat1,
  [427] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(25), 1,
      anon_sym_ATdoc,
    ACTIONS(27), 1,
      anon_sym_ATmodel,
    ACTIONS(29), 1,
      anon_sym_ATmanaged,
    ACTIONS(31), 1,
      anon_sym_ATevent,
    ACTIONS(33), 1,
      anon_sym_AT,
    STATE(9), 1,
      aux_sym__doc_or_meta_repeat1,
    STATE(92), 1,
      sym_doc,
    STATE(94), 1,
      sym_model,
    STATE(95), 1,
      sym_managed,
    STATE(96), 1,
      sym_event,
    STATE(97), 1,
      sym_meta,
    ACTIONS(73), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(75), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [478] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      sym_string,
    ACTIONS(84), 1,
      anon_sym_ATdoc,
    ACTIONS(87), 1,
      anon_sym_ATmodel,
    ACTIONS(90), 1,
      anon_sym_ATmanaged,
    ACTIONS(93), 1,
      anon_sym_ATevent,
    ACTIONS(96), 1,
      anon_sym_AT,
    STATE(9), 1,
      aux_sym__doc_or_meta_repeat1,
    STATE(92), 1,
      sym_doc,
    STATE(94), 1,
      sym_model,
    STATE(95), 1,
      sym_managed,
    STATE(96), 1,
      sym_event,
    STATE(97), 1,
      sym_meta,
    ACTIONS(77), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(79), 6,
      sym_decimal,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [531] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(103), 1,
      anon_sym_RPAREN,
    ACTIONS(105), 1,
      anon_sym_DOT,
    STATE(77), 1,
      aux_sym_reference_repeat1,
    ACTIONS(99), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(101), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(392), 8,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
  [575] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      sym_atom,
    ACTIONS(116), 1,
      anon_sym_LBRACK,
    ACTIONS(121), 1,
      anon_sym_LBRACE,
    ACTIONS(124), 1,
      anon_sym_LPAREN,
    ACTIONS(110), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(119), 2,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
    ACTIONS(113), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(11), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [615] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(131), 1,
      anon_sym_LPAREN,
    ACTIONS(133), 1,
      anon_sym_RPAREN,
    STATE(38), 1,
      sym_parameter_list,
    ACTIONS(127), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(129), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(37), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [657] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(135), 1,
      sym_atom,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(137), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(139), 2,
      sym_decimal,
      sym_symbol,
    ACTIONS(141), 3,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    STATE(150), 4,
      sym_list,
      sym_object,
      sym__literal,
      sym_reference,
    ACTIONS(147), 5,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [696] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(153), 1,
      anon_sym_RBRACK,
    ACTIONS(149), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(151), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(11), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [735] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(159), 1,
      anon_sym_RPAREN,
    ACTIONS(155), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(157), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(26), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [774] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(165), 1,
      anon_sym_RBRACK,
    STATE(14), 1,
      aux_sym_list_repeat1,
    ACTIONS(161), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(163), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(128), 8,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
  [815] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_RPAREN,
    ACTIONS(149), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(151), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(11), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [854] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(173), 1,
      anon_sym_RPAREN,
    ACTIONS(169), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(171), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(43), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [893] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(179), 1,
      anon_sym_RPAREN,
    ACTIONS(175), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(177), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(17), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [932] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(181), 1,
      anon_sym_RPAREN,
    ACTIONS(149), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(151), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(11), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [971] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(183), 1,
      anon_sym_RPAREN,
    ACTIONS(149), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(151), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(11), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [1010] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(189), 1,
      anon_sym_RPAREN,
    ACTIONS(185), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(187), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(20), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [1049] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(195), 1,
      anon_sym_RBRACK,
    STATE(47), 1,
      aux_sym_list_repeat1,
    ACTIONS(191), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(193), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(123), 8,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
  [1090] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(197), 1,
      anon_sym_RBRACK,
    ACTIONS(149), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(151), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(11), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [1129] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(105), 1,
      anon_sym_DOT,
    STATE(77), 1,
      aux_sym_reference_repeat1,
    ACTIONS(199), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(103), 6,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
    STATE(68), 8,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
  [1162] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(201), 1,
      anon_sym_RPAREN,
    ACTIONS(149), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(151), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(11), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [1201] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(203), 1,
      anon_sym_RPAREN,
    ACTIONS(149), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(151), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(11), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [1240] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_RPAREN,
    ACTIONS(149), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(151), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(11), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [1279] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(211), 1,
      anon_sym_RBRACK,
    STATE(24), 1,
      aux_sym_list_repeat1,
    ACTIONS(207), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(209), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(127), 8,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
  [1320] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(217), 1,
      anon_sym_RPAREN,
    ACTIONS(213), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(215), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(28), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [1359] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(93), 4,
      sym_list,
      sym_object,
      sym__literal,
      sym_reference,
    ACTIONS(141), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(147), 8,
      sym_integer,
      sym_boolean,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [1388] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(223), 1,
      anon_sym_RPAREN,
    ACTIONS(219), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(221), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(48), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [1427] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(229), 1,
      anon_sym_RPAREN,
    ACTIONS(225), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(227), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(39), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [1466] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(231), 1,
      anon_sym_RPAREN,
    ACTIONS(149), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(151), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(11), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [1505] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_RPAREN,
    ACTIONS(233), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(235), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(42), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [1544] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(239), 1,
      anon_sym_RPAREN,
    ACTIONS(149), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(151), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(11), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [1583] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(241), 1,
      anon_sym_RPAREN,
    ACTIONS(149), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(151), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(11), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [1622] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(247), 1,
      anon_sym_RPAREN,
    ACTIONS(243), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(245), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(21), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [1661] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_RPAREN,
    ACTIONS(149), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(151), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(11), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [1700] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(251), 1,
      anon_sym_RPAREN,
    ACTIONS(149), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(151), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(11), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [1739] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(253), 1,
      anon_sym_RBRACK,
    ACTIONS(149), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(151), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(11), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [1778] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(255), 1,
      anon_sym_RPAREN,
    ACTIONS(149), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(151), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(11), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [1817] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(257), 1,
      anon_sym_RPAREN,
    ACTIONS(149), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(151), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(11), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [1856] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_RPAREN,
    ACTIONS(149), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(151), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(11), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [1895] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(265), 1,
      anon_sym_RPAREN,
    ACTIONS(261), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(263), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(36), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [1934] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(267), 1,
      anon_sym_RPAREN,
    ACTIONS(149), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(151), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(11), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [1973] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(269), 1,
      anon_sym_RBRACK,
    ACTIONS(149), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(151), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(11), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [2012] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(271), 1,
      anon_sym_RPAREN,
    ACTIONS(149), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(151), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(11), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [2051] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(277), 1,
      anon_sym_RPAREN,
    ACTIONS(273), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(275), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(27), 9,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
      aux_sym_list_repeat1,
  [2090] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(283), 1,
      anon_sym_LPAREN,
    STATE(134), 1,
      aux_sym_cond_repeat1,
    ACTIONS(279), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(281), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(403), 8,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
  [2128] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(283), 1,
      anon_sym_LPAREN,
    STATE(50), 1,
      aux_sym_cond_repeat1,
    ACTIONS(285), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(287), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(391), 8,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
  [2166] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(283), 1,
      anon_sym_LPAREN,
    STATE(134), 1,
      aux_sym_cond_repeat1,
    ACTIONS(289), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(291), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(371), 8,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
  [2204] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(283), 1,
      anon_sym_LPAREN,
    STATE(52), 1,
      aux_sym_cond_repeat1,
    ACTIONS(293), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(295), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(368), 8,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
  [2242] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(53), 1,
      sym_string,
    ACTIONS(59), 1,
      anon_sym_ATdoc,
    ACTIONS(61), 1,
      anon_sym_ATmodel,
    ACTIONS(63), 1,
      anon_sym_ATmanaged,
    ACTIONS(65), 1,
      anon_sym_ATevent,
    ACTIONS(67), 1,
      anon_sym_AT,
    ACTIONS(297), 1,
      anon_sym_LPAREN,
    ACTIONS(299), 1,
      anon_sym_RPAREN,
    STATE(99), 1,
      aux_sym__doc_or_meta_repeat1,
    STATE(170), 1,
      sym_meta,
    STATE(171), 1,
      sym_event,
    STATE(172), 1,
      sym_managed,
    STATE(173), 1,
      sym_model,
    STATE(175), 1,
      sym_doc,
    STATE(233), 1,
      sym__doc_or_meta,
    STATE(230), 3,
      sym_step,
      sym_step_with_rollback,
      aux_sym_defpact_repeat1,
  [2296] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(53), 1,
      sym_string,
    ACTIONS(59), 1,
      anon_sym_ATdoc,
    ACTIONS(61), 1,
      anon_sym_ATmodel,
    ACTIONS(63), 1,
      anon_sym_ATmanaged,
    ACTIONS(65), 1,
      anon_sym_ATevent,
    ACTIONS(67), 1,
      anon_sym_AT,
    ACTIONS(297), 1,
      anon_sym_LPAREN,
    ACTIONS(301), 1,
      anon_sym_RPAREN,
    STATE(99), 1,
      aux_sym__doc_or_meta_repeat1,
    STATE(170), 1,
      sym_meta,
    STATE(171), 1,
      sym_event,
    STATE(172), 1,
      sym_managed,
    STATE(173), 1,
      sym_model,
    STATE(175), 1,
      sym_doc,
    STATE(219), 1,
      sym__doc_or_meta,
    STATE(220), 3,
      sym_step,
      sym_step_with_rollback,
      aux_sym_defpact_repeat1,
  [2350] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(303), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(305), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(295), 8,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
  [2385] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(307), 1,
      sym_atom,
    ACTIONS(309), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(311), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(67), 8,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
  [2420] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(317), 1,
      anon_sym_DOT,
    STATE(60), 1,
      aux_sym_reference_repeat1,
    ACTIONS(315), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(313), 8,
      sym_integer,
      sym_boolean,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [2449] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(319), 1,
      sym_atom,
    ACTIONS(325), 1,
      anon_sym_LBRACK,
    ACTIONS(327), 1,
      anon_sym_LBRACE,
    ACTIONS(329), 1,
      anon_sym_LPAREN,
    ACTIONS(321), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(323), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(105), 8,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
  [2484] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(335), 1,
      anon_sym_DOT,
    STATE(60), 1,
      aux_sym_reference_repeat1,
    ACTIONS(333), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(331), 8,
      sym_integer,
      sym_boolean,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [2513] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(338), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(340), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(369), 8,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
  [2548] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym_atom,
    ACTIONS(344), 1,
      sym_string,
    ACTIONS(346), 1,
      anon_sym_ATdoc,
    ACTIONS(348), 1,
      anon_sym_ATmodel,
    ACTIONS(350), 1,
      anon_sym_ATmanaged,
    ACTIONS(352), 1,
      anon_sym_ATevent,
    ACTIONS(354), 1,
      anon_sym_AT,
    STATE(113), 1,
      aux_sym__doc_or_meta_repeat1,
    STATE(185), 1,
      sym_doc,
    STATE(187), 1,
      sym_meta,
    STATE(188), 1,
      sym_event,
    STATE(190), 1,
      sym_managed,
    STATE(197), 1,
      sym_model,
    STATE(237), 1,
      sym__doc_or_meta,
    STATE(405), 1,
      sym_schema_field_list,
    STATE(252), 2,
      sym_schema_field,
      aux_sym_schema_field_list_repeat1,
  [2601] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(356), 1,
      sym_atom,
    ACTIONS(358), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(360), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(373), 8,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
  [2636] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(362), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(364), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(296), 8,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
  [2671] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(368), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(393), 8,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
  [2706] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(141), 1,
      sym_string,
    ACTIONS(143), 1,
      anon_sym_LBRACK,
    ACTIONS(145), 1,
      anon_sym_LBRACE,
    ACTIONS(370), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(372), 2,
      sym_decimal,
      sym_symbol,
    STATE(193), 4,
      sym_list,
      sym_object,
      sym__literal,
      sym_reference,
    ACTIONS(147), 6,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [2741] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(374), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(376), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(387), 8,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
  [2776] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(378), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(380), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(376), 8,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
  [2811] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_atom,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_LPAREN,
    ACTIONS(382), 2,
      sym_integer,
      sym_boolean,
    ACTIONS(384), 3,
      sym_decimal,
      sym_string,
      sym_symbol,
    STATE(347), 8,
      sym_list,
      sym_object,
      sym__literal,
      sym__from,
      sym_s_expression,
      sym_reference,
      sym_let_binding,
      sym_cond,
  [2846] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(331), 8,
      sym_integer,
      sym_boolean,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
    ACTIONS(333), 8,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
  [2870] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(386), 1,
      anon_sym_LBRACK,
    ACTIONS(388), 1,
      anon_sym_LBRACE,
    STATE(246), 1,
      sym__parametrized_object,
    STATE(247), 1,
      sym__parametrized_list,
    STATE(378), 1,
      sym_type_identifier,
    ACTIONS(390), 2,
      anon_sym_object,
      anon_sym_table,
    ACTIONS(392), 9,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_time,
      anon_sym_bool,
      anon_sym_string,
      anon_sym_list,
      anon_sym_value,
      anon_sym_keyset,
      anon_sym_guard,
  [2904] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(386), 1,
      anon_sym_LBRACK,
    ACTIONS(388), 1,
      anon_sym_LBRACE,
    STATE(246), 1,
      sym__parametrized_object,
    STATE(247), 1,
      sym__parametrized_list,
    STATE(275), 1,
      sym_type_identifier,
    ACTIONS(390), 2,
      anon_sym_object,
      anon_sym_table,
    ACTIONS(392), 9,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_time,
      anon_sym_bool,
      anon_sym_string,
      anon_sym_list,
      anon_sym_value,
      anon_sym_keyset,
      anon_sym_guard,
  [2938] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(386), 1,
      anon_sym_LBRACK,
    ACTIONS(388), 1,
      anon_sym_LBRACE,
    STATE(246), 1,
      sym__parametrized_object,
    STATE(247), 1,
      sym__parametrized_list,
    STATE(396), 1,
      sym_type_identifier,
    ACTIONS(390), 2,
      anon_sym_object,
      anon_sym_table,
    ACTIONS(392), 9,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_time,
      anon_sym_bool,
      anon_sym_string,
      anon_sym_list,
      anon_sym_value,
      anon_sym_keyset,
      anon_sym_guard,
  [2972] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(394), 1,
      anon_sym_LBRACK,
    ACTIONS(396), 1,
      anon_sym_LBRACE,
    STATE(162), 1,
      sym_type_identifier,
    STATE(163), 1,
      sym__parametrized_list,
    STATE(164), 1,
      sym__parametrized_object,
    ACTIONS(398), 2,
      anon_sym_object,
      anon_sym_table,
    ACTIONS(400), 9,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_time,
      anon_sym_bool,
      anon_sym_string,
      anon_sym_list,
      anon_sym_value,
      anon_sym_keyset,
      anon_sym_guard,
  [3006] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(402), 8,
      sym_integer,
      sym_boolean,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [3029] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(408), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(406), 8,
      sym_integer,
      sym_boolean,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [3052] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(105), 1,
      anon_sym_DOT,
    STATE(80), 1,
      aux_sym_reference_repeat1,
    ACTIONS(313), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(315), 10,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [3079] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(105), 1,
      anon_sym_DOT,
    STATE(77), 1,
      aux_sym_reference_repeat1,
    ACTIONS(199), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(103), 10,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [3106] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(412), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(410), 8,
      sym_integer,
      sym_boolean,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [3129] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(414), 1,
      anon_sym_DOT,
    STATE(80), 1,
      aux_sym_reference_repeat1,
    ACTIONS(331), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(333), 10,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [3156] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(417), 8,
      sym_integer,
      sym_boolean,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [3179] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(423), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(421), 8,
      sym_integer,
      sym_boolean,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [3202] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(425), 8,
      sym_integer,
      sym_boolean,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [3225] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(431), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(429), 8,
      sym_integer,
      sym_boolean,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [3248] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(435), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(433), 8,
      sym_integer,
      sym_boolean,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [3271] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(439), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(437), 8,
      sym_integer,
      sym_boolean,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [3294] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(443), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(441), 8,
      sym_integer,
      sym_boolean,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [3317] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(447), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(445), 8,
      sym_integer,
      sym_boolean,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [3340] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(449), 8,
      sym_integer,
      sym_boolean,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [3363] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(455), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(453), 8,
      sym_integer,
      sym_boolean,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [3386] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(425), 8,
      sym_integer,
      sym_boolean,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [3409] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(457), 8,
      sym_integer,
      sym_boolean,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [3432] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(463), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(461), 8,
      sym_integer,
      sym_boolean,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [3455] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(467), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(465), 8,
      sym_integer,
      sym_boolean,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [3478] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(469), 8,
      sym_integer,
      sym_boolean,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [3501] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(473), 8,
      sym_integer,
      sym_boolean,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [3524] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(479), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(477), 8,
      sym_integer,
      sym_boolean,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [3547] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(483), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(481), 8,
      sym_integer,
      sym_boolean,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [3570] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(53), 1,
      sym_string,
    ACTIONS(59), 1,
      anon_sym_ATdoc,
    ACTIONS(61), 1,
      anon_sym_ATmodel,
    ACTIONS(63), 1,
      anon_sym_ATmanaged,
    ACTIONS(65), 1,
      anon_sym_ATevent,
    ACTIONS(67), 1,
      anon_sym_AT,
    STATE(104), 1,
      aux_sym__doc_or_meta_repeat1,
    STATE(170), 1,
      sym_meta,
    STATE(171), 1,
      sym_event,
    STATE(172), 1,
      sym_managed,
    STATE(173), 1,
      sym_model,
    STATE(175), 1,
      sym_doc,
    ACTIONS(75), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [3614] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(105), 1,
      anon_sym_DOT,
    ACTIONS(485), 1,
      anon_sym_COLON,
    STATE(77), 1,
      aux_sym_reference_repeat1,
    STATE(339), 1,
      sym_type_annotation,
    ACTIONS(199), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(103), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [3644] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(331), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(333), 11,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
  [3666] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(489), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(487), 11,
      ts_builtin_sym_end,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [3688] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(493), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(491), 11,
      ts_builtin_sym_end,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [3710] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(495), 1,
      sym_string,
    ACTIONS(498), 1,
      anon_sym_ATdoc,
    ACTIONS(501), 1,
      anon_sym_ATmodel,
    ACTIONS(504), 1,
      anon_sym_ATmanaged,
    ACTIONS(507), 1,
      anon_sym_ATevent,
    ACTIONS(510), 1,
      anon_sym_AT,
    STATE(104), 1,
      aux_sym__doc_or_meta_repeat1,
    STATE(170), 1,
      sym_meta,
    STATE(171), 1,
      sym_event,
    STATE(172), 1,
      sym_managed,
    STATE(173), 1,
      sym_model,
    STATE(175), 1,
      sym_doc,
    ACTIONS(79), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [3754] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(53), 1,
      sym_string,
    ACTIONS(59), 1,
      anon_sym_ATdoc,
    ACTIONS(61), 1,
      anon_sym_ATmodel,
    ACTIONS(63), 1,
      anon_sym_ATmanaged,
    ACTIONS(65), 1,
      anon_sym_ATevent,
    ACTIONS(67), 1,
      anon_sym_AT,
    ACTIONS(513), 1,
      anon_sym_RPAREN,
    STATE(99), 1,
      aux_sym__doc_or_meta_repeat1,
    STATE(170), 1,
      sym_meta,
    STATE(171), 1,
      sym_event,
    STATE(172), 1,
      sym_managed,
    STATE(173), 1,
      sym_model,
    STATE(175), 1,
      sym_doc,
    STATE(407), 1,
      sym__doc_or_meta,
  [3800] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(53), 1,
      sym_string,
    ACTIONS(59), 1,
      anon_sym_ATdoc,
    ACTIONS(61), 1,
      anon_sym_ATmodel,
    ACTIONS(63), 1,
      anon_sym_ATmanaged,
    ACTIONS(65), 1,
      anon_sym_ATevent,
    ACTIONS(67), 1,
      anon_sym_AT,
    ACTIONS(515), 1,
      anon_sym_RPAREN,
    STATE(99), 1,
      aux_sym__doc_or_meta_repeat1,
    STATE(170), 1,
      sym_meta,
    STATE(171), 1,
      sym_event,
    STATE(172), 1,
      sym_managed,
    STATE(173), 1,
      sym_model,
    STATE(175), 1,
      sym_doc,
    STATE(408), 1,
      sym__doc_or_meta,
  [3846] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(439), 10,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [3867] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(517), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(519), 10,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [3888] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(521), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(523), 10,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [3909] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(525), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(527), 10,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [3930] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(529), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(531), 10,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [3951] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(421), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(423), 10,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [3972] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(73), 1,
      sym_atom,
    ACTIONS(344), 1,
      sym_string,
    ACTIONS(346), 1,
      anon_sym_ATdoc,
    ACTIONS(348), 1,
      anon_sym_ATmodel,
    ACTIONS(350), 1,
      anon_sym_ATmanaged,
    ACTIONS(352), 1,
      anon_sym_ATevent,
    ACTIONS(354), 1,
      anon_sym_AT,
    STATE(116), 1,
      aux_sym__doc_or_meta_repeat1,
    STATE(185), 1,
      sym_doc,
    STATE(187), 1,
      sym_meta,
    STATE(188), 1,
      sym_event,
    STATE(190), 1,
      sym_managed,
    STATE(197), 1,
      sym_model,
  [4015] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(533), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(535), 10,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [4036] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(417), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(419), 10,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [4057] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(77), 1,
      sym_atom,
    ACTIONS(537), 1,
      sym_string,
    ACTIONS(540), 1,
      anon_sym_ATdoc,
    ACTIONS(543), 1,
      anon_sym_ATmodel,
    ACTIONS(546), 1,
      anon_sym_ATmanaged,
    ACTIONS(549), 1,
      anon_sym_ATevent,
    ACTIONS(552), 1,
      anon_sym_AT,
    STATE(116), 1,
      aux_sym__doc_or_meta_repeat1,
    STATE(185), 1,
      sym_doc,
    STATE(187), 1,
      sym_meta,
    STATE(188), 1,
      sym_event,
    STATE(190), 1,
      sym_managed,
    STATE(197), 1,
      sym_model,
  [4100] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(435), 10,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [4121] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(105), 1,
      anon_sym_DOT,
    STATE(77), 1,
      aux_sym_reference_repeat1,
    ACTIONS(199), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(103), 8,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [4146] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(555), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(557), 10,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [4167] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(431), 10,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [4188] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(404), 10,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [4209] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(55), 1,
      anon_sym_LPAREN,
    ACTIONS(559), 1,
      anon_sym_RPAREN,
    STATE(126), 10,
      sym_bless,
      sym_defun,
      sym_defcap,
      sym_defconst,
      sym_defpact,
      sym_defschema,
      sym_deftable,
      sym_use,
      sym_implements,
      aux_sym_module_repeat1,
  [4231] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(565), 1,
      anon_sym_RBRACK,
    ACTIONS(568), 1,
      anon_sym_COMMA,
    STATE(261), 1,
      aux_sym_list_repeat2,
    ACTIONS(561), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(563), 6,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
  [4257] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(55), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      anon_sym_RPAREN,
    STATE(125), 10,
      sym_bless,
      sym_defun,
      sym_defcap,
      sym_defconst,
      sym_defpact,
      sym_defschema,
      sym_deftable,
      sym_use,
      sym_implements,
      aux_sym_module_repeat1,
  [4279] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(572), 1,
      anon_sym_LPAREN,
    ACTIONS(575), 1,
      anon_sym_RPAREN,
    STATE(125), 10,
      sym_bless,
      sym_defun,
      sym_defcap,
      sym_defconst,
      sym_defpact,
      sym_defschema,
      sym_deftable,
      sym_use,
      sym_implements,
      aux_sym_module_repeat1,
  [4301] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(55), 1,
      anon_sym_LPAREN,
    ACTIONS(577), 1,
      anon_sym_RPAREN,
    STATE(125), 10,
      sym_bless,
      sym_defun,
      sym_defcap,
      sym_defconst,
      sym_defpact,
      sym_defschema,
      sym_deftable,
      sym_use,
      sym_implements,
      aux_sym_module_repeat1,
  [4323] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(568), 1,
      anon_sym_COMMA,
    ACTIONS(579), 1,
      anon_sym_RBRACK,
    STATE(262), 1,
      aux_sym_list_repeat2,
    ACTIONS(561), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(563), 6,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
  [4349] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(568), 1,
      anon_sym_COMMA,
    ACTIONS(582), 1,
      anon_sym_RBRACK,
    STATE(272), 1,
      aux_sym_list_repeat2,
    ACTIONS(561), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(563), 6,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
  [4375] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(568), 1,
      anon_sym_COMMA,
    ACTIONS(585), 1,
      anon_sym_RBRACK,
    STATE(278), 1,
      aux_sym_list_repeat2,
    ACTIONS(561), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(563), 6,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
  [4401] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(588), 1,
      anon_sym_DOT,
    STATE(132), 1,
      aux_sym_reference_repeat1,
    ACTIONS(315), 3,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(313), 6,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [4424] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(594), 1,
      anon_sym_COLON,
    STATE(142), 1,
      sym_type_annotation,
    ACTIONS(590), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(592), 6,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
  [4447] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(596), 1,
      anon_sym_DOT,
    STATE(132), 1,
      aux_sym_reference_repeat1,
    ACTIONS(333), 3,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(331), 6,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [4470] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(588), 1,
      anon_sym_DOT,
    STATE(130), 1,
      aux_sym_reference_repeat1,
    ACTIONS(103), 3,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(199), 6,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [4493] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(603), 1,
      anon_sym_LPAREN,
    STATE(134), 1,
      aux_sym_cond_repeat1,
    ACTIONS(599), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(601), 5,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
  [4515] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(406), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(408), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [4533] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(410), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(412), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [4551] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(606), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(608), 7,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [4569] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(333), 4,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
    ACTIONS(331), 6,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [4587] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(610), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(612), 6,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
  [4604] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(435), 3,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(433), 6,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [4621] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(614), 1,
      anon_sym_bless,
    ACTIONS(616), 1,
      anon_sym_defun,
    ACTIONS(618), 1,
      anon_sym_defcap,
    ACTIONS(620), 1,
      anon_sym_defconst,
    ACTIONS(622), 1,
      anon_sym_defpact,
    ACTIONS(624), 1,
      anon_sym_defschema,
    ACTIONS(626), 1,
      anon_sym_deftable,
    ACTIONS(628), 1,
      anon_sym_use,
    ACTIONS(630), 1,
      anon_sym_implements,
  [4652] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(632), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(634), 6,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
  [4669] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(606), 1,
      anon_sym_AT,
    ACTIONS(608), 8,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [4686] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(636), 1,
      anon_sym_LPAREN,
    ACTIONS(639), 1,
      anon_sym_RPAREN,
    STATE(144), 7,
      sym_defun,
      sym_defcap,
      sym_defconst,
      sym_defpact,
      sym_defschema,
      sym_use,
      aux_sym_interface_repeat1,
  [4705] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(199), 1,
      anon_sym_AT,
    ACTIONS(641), 1,
      anon_sym_DOT,
    STATE(157), 1,
      aux_sym_reference_repeat1,
    ACTIONS(103), 6,
      sym_string,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [4726] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(69), 1,
      anon_sym_LPAREN,
    ACTIONS(643), 1,
      anon_sym_RPAREN,
    STATE(147), 7,
      sym_defun,
      sym_defcap,
      sym_defconst,
      sym_defpact,
      sym_defschema,
      sym_use,
      aux_sym_interface_repeat1,
  [4745] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(69), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_RPAREN,
    STATE(144), 7,
      sym_defun,
      sym_defcap,
      sym_defconst,
      sym_defpact,
      sym_defschema,
      sym_use,
      aux_sym_interface_repeat1,
  [4764] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(439), 3,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(437), 6,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [4781] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 3,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(402), 6,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [4798] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(647), 1,
      sym_atom,
    ACTIONS(463), 3,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(461), 5,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [4817] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(649), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(651), 6,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
  [4834] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(69), 1,
      anon_sym_LPAREN,
    ACTIONS(653), 1,
      anon_sym_RPAREN,
    STATE(144), 7,
      sym_defun,
      sym_defcap,
      sym_defconst,
      sym_defpact,
      sym_defschema,
      sym_use,
      aux_sym_interface_repeat1,
  [4853] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(431), 3,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(429), 6,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [4870] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(331), 1,
      anon_sym_AT,
    ACTIONS(655), 1,
      anon_sym_DOT,
    STATE(154), 1,
      aux_sym_reference_repeat1,
    ACTIONS(333), 6,
      sym_string,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [4891] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(423), 3,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(421), 6,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [4908] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 3,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(417), 6,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [4925] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(313), 1,
      anon_sym_AT,
    ACTIONS(641), 1,
      anon_sym_DOT,
    STATE(154), 1,
      aux_sym_reference_repeat1,
    ACTIONS(315), 6,
      sym_string,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [4946] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(658), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(660), 6,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
  [4963] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(662), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(664), 6,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
  [4980] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(666), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(668), 6,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
  [4997] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 1,
      anon_sym_LBRACE,
    ACTIONS(610), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(612), 5,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [5016] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(674), 6,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
  [5033] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(676), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(678), 6,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
  [5050] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(676), 3,
      sym_integer,
      sym_boolean,
      sym_atom,
    ACTIONS(678), 6,
      sym_decimal,
      sym_string,
      sym_symbol,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
  [5067] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(406), 1,
      anon_sym_AT,
    ACTIONS(408), 7,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5083] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(410), 1,
      anon_sym_AT,
    ACTIONS(412), 7,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5099] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(449), 1,
      anon_sym_AT,
    ACTIONS(451), 7,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5115] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(331), 1,
      anon_sym_AT,
    ACTIONS(333), 7,
      sym_string,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5131] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(481), 1,
      anon_sym_AT,
    ACTIONS(483), 7,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5147] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(477), 1,
      anon_sym_AT,
    ACTIONS(479), 7,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5163] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      anon_sym_AT,
    ACTIONS(475), 7,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5179] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(469), 1,
      anon_sym_AT,
    ACTIONS(471), 7,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5195] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(465), 1,
      anon_sym_AT,
    ACTIONS(467), 7,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5211] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 1,
      anon_sym_AT,
    ACTIONS(455), 7,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5227] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      anon_sym_AT,
    ACTIONS(459), 7,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5243] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_AT,
    ACTIONS(443), 7,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5259] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(425), 1,
      anon_sym_AT,
    ACTIONS(427), 7,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5275] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 1,
      ts_builtin_sym_end,
    ACTIONS(682), 1,
      anon_sym_LPAREN,
    STATE(178), 6,
      sym_s_expression,
      sym_namespace,
      sym_use,
      sym_interface,
      sym_module,
      aux_sym_source_file_repeat1,
  [5293] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(685), 1,
      sym_atom,
    ACTIONS(687), 1,
      anon_sym_RPAREN,
    ACTIONS(691), 1,
      anon_sym_cond,
    STATE(15), 1,
      sym_reference,
    ACTIONS(689), 2,
      anon_sym_let,
      anon_sym_let_STAR,
    STATE(248), 2,
      sym_parameter,
      aux_sym_parameter_list_repeat1,
  [5317] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 1,
      anon_sym_AT,
    ACTIONS(447), 7,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5333] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(695), 1,
      anon_sym_AT,
    ACTIONS(693), 7,
      sym_string,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5349] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_LPAREN,
    ACTIONS(697), 1,
      ts_builtin_sym_end,
    STATE(178), 6,
      sym_s_expression,
      sym_namespace,
      sym_use,
      sym_interface,
      sym_module,
      aux_sym_source_file_repeat1,
  [5367] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(493), 1,
      anon_sym_AT,
    ACTIONS(491), 6,
      sym_string,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5382] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(447), 1,
      sym_string,
    ACTIONS(445), 6,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [5397] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 1,
      sym_string,
    ACTIONS(457), 6,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [5412] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_string,
    ACTIONS(425), 6,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [5427] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(479), 1,
      sym_string,
    ACTIONS(477), 6,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [5442] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 1,
      sym_string,
    ACTIONS(473), 6,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [5457] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(691), 1,
      anon_sym_cond,
    ACTIONS(699), 1,
      sym_atom,
    ACTIONS(701), 1,
      anon_sym_LPAREN,
    STATE(15), 1,
      sym_reference,
    STATE(65), 1,
      sym_s_expression,
    ACTIONS(689), 2,
      anon_sym_let,
      anon_sym_let_STAR,
  [5480] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      sym_string,
    ACTIONS(469), 6,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [5495] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_AT,
    ACTIONS(487), 6,
      sym_string,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5510] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(483), 1,
      sym_string,
    ACTIONS(481), 6,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [5525] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(463), 1,
      sym_string,
    ACTIONS(461), 6,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [5540] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(455), 1,
      sym_string,
    ACTIONS(453), 6,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [5555] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      sym_string,
    ACTIONS(449), 6,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [5570] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(443), 1,
      sym_string,
    ACTIONS(441), 6,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [5585] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(467), 1,
      sym_string,
    ACTIONS(465), 6,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [5600] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(417), 1,
      anon_sym_AT,
    ACTIONS(419), 6,
      sym_string,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5615] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(421), 1,
      anon_sym_AT,
    ACTIONS(423), 6,
      sym_string,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5630] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_AT,
    ACTIONS(431), 6,
      sym_string,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5645] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 1,
      anon_sym_AT,
    ACTIONS(435), 6,
      sym_string,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5660] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 1,
      anon_sym_AT,
    ACTIONS(404), 6,
      sym_string,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5675] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 1,
      anon_sym_AT,
    ACTIONS(439), 6,
      sym_string,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5690] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(608), 1,
      sym_string,
    ACTIONS(606), 6,
      sym_atom,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
      anon_sym_AT,
  [5705] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(555), 1,
      anon_sym_AT,
    ACTIONS(557), 6,
      sym_string,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5720] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(533), 1,
      anon_sym_AT,
    ACTIONS(535), 6,
      sym_string,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5735] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(521), 1,
      anon_sym_AT,
    ACTIONS(523), 6,
      sym_string,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5750] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(529), 1,
      anon_sym_AT,
    ACTIONS(531), 6,
      sym_string,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5765] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(525), 1,
      anon_sym_AT,
    ACTIONS(527), 6,
      sym_string,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5780] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(517), 1,
      anon_sym_AT,
    ACTIONS(519), 6,
      sym_string,
      anon_sym_RPAREN,
      anon_sym_ATdoc,
      anon_sym_ATmodel,
      anon_sym_ATmanaged,
      anon_sym_ATevent,
  [5795] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(616), 1,
      anon_sym_defun,
    ACTIONS(618), 1,
      anon_sym_defcap,
    ACTIONS(620), 1,
      anon_sym_defconst,
    ACTIONS(622), 1,
      anon_sym_defpact,
    ACTIONS(624), 1,
      anon_sym_defschema,
    ACTIONS(628), 1,
      anon_sym_use,
  [5817] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(705), 1,
      anon_sym_RBRACE,
    STATE(332), 1,
      sym__property_name,
    ACTIONS(703), 2,
      sym_string,
      sym_symbol,
    STATE(269), 2,
      sym_pair,
      sym_bind_pair,
  [5835] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(699), 1,
      sym_atom,
    ACTIONS(707), 1,
      anon_sym_namespace,
    ACTIONS(709), 1,
      anon_sym_use,
    ACTIONS(711), 1,
      anon_sym_interface,
    ACTIONS(713), 1,
      anon_sym_module,
    STATE(15), 1,
      sym_reference,
  [5857] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(715), 1,
      anon_sym_RBRACE,
    STATE(332), 1,
      sym__property_name,
    ACTIONS(703), 2,
      sym_string,
      sym_symbol,
    STATE(268), 2,
      sym_pair,
      sym_bind_pair,
  [5875] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(717), 1,
      anon_sym_RBRACE,
    STATE(332), 1,
      sym__property_name,
    ACTIONS(703), 2,
      sym_string,
      sym_symbol,
    STATE(263), 2,
      sym_pair,
      sym_bind_pair,
  [5893] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(719), 1,
      anon_sym_RBRACK,
    ACTIONS(721), 1,
      anon_sym_LPAREN,
    STATE(216), 3,
      sym_s_expression,
      sym_defproperty,
      aux_sym_model_repeat1,
  [5908] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 1,
      anon_sym_RBRACK,
    ACTIONS(726), 1,
      anon_sym_LPAREN,
    STATE(216), 3,
      sym_s_expression,
      sym_defproperty,
      aux_sym_model_repeat1,
  [5923] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(699), 1,
      sym_atom,
    ACTIONS(730), 1,
      anon_sym_cond,
    STATE(30), 1,
      sym_reference,
    ACTIONS(728), 2,
      anon_sym_let,
      anon_sym_let_STAR,
  [5940] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 1,
      anon_sym_LPAREN,
    ACTIONS(732), 1,
      anon_sym_RPAREN,
    STATE(224), 3,
      sym_step,
      sym_step_with_rollback,
      aux_sym_defpact_repeat1,
  [5955] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 1,
      anon_sym_LPAREN,
    ACTIONS(734), 1,
      anon_sym_RPAREN,
    STATE(225), 3,
      sym_step,
      sym_step_with_rollback,
      aux_sym_defpact_repeat1,
  [5970] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(691), 1,
      anon_sym_cond,
    ACTIONS(699), 1,
      sym_atom,
    STATE(15), 1,
      sym_reference,
    ACTIONS(689), 2,
      anon_sym_let,
      anon_sym_let_STAR,
  [5987] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(726), 1,
      anon_sym_LPAREN,
    ACTIONS(736), 1,
      anon_sym_RBRACK,
    STATE(226), 3,
      sym_s_expression,
      sym_defproperty,
      aux_sym_model_repeat1,
  [6002] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 1,
      anon_sym_LPAREN,
    ACTIONS(738), 1,
      anon_sym_RPAREN,
    STATE(225), 3,
      sym_step,
      sym_step_with_rollback,
      aux_sym_defpact_repeat1,
  [6017] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 1,
      anon_sym_LPAREN,
    ACTIONS(740), 1,
      anon_sym_RPAREN,
    STATE(225), 3,
      sym_step,
      sym_step_with_rollback,
      aux_sym_defpact_repeat1,
  [6032] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(742), 1,
      anon_sym_LPAREN,
    ACTIONS(745), 1,
      anon_sym_RPAREN,
    STATE(225), 3,
      sym_step,
      sym_step_with_rollback,
      aux_sym_defpact_repeat1,
  [6047] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(726), 1,
      anon_sym_LPAREN,
    ACTIONS(747), 1,
      anon_sym_RBRACK,
    STATE(216), 3,
      sym_s_expression,
      sym_defproperty,
      aux_sym_model_repeat1,
  [6062] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(726), 1,
      anon_sym_LPAREN,
    ACTIONS(749), 1,
      anon_sym_RBRACK,
    STATE(217), 3,
      sym_s_expression,
      sym_defproperty,
      aux_sym_model_repeat1,
  [6077] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 1,
      anon_sym_LBRACE,
    ACTIONS(612), 4,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_atom,
  [6090] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(726), 1,
      anon_sym_LPAREN,
    ACTIONS(753), 1,
      anon_sym_RBRACK,
    STATE(231), 3,
      sym_s_expression,
      sym_defproperty,
      aux_sym_model_repeat1,
  [6105] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 1,
      anon_sym_LPAREN,
    ACTIONS(755), 1,
      anon_sym_RPAREN,
    STATE(225), 3,
      sym_step,
      sym_step_with_rollback,
      aux_sym_defpact_repeat1,
  [6120] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(726), 1,
      anon_sym_LPAREN,
    ACTIONS(757), 1,
      anon_sym_RBRACK,
    STATE(216), 3,
      sym_s_expression,
      sym_defproperty,
      aux_sym_model_repeat1,
  [6135] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(332), 1,
      sym__property_name,
    ACTIONS(703), 2,
      sym_string,
      sym_symbol,
    STATE(356), 2,
      sym_pair,
      sym_bind_pair,
  [6150] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 1,
      anon_sym_LPAREN,
    ACTIONS(759), 1,
      anon_sym_RPAREN,
    STATE(223), 3,
      sym_step,
      sym_step_with_rollback,
      aux_sym_defpact_repeat1,
  [6165] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(761), 1,
      anon_sym_LPAREN,
    ACTIONS(763), 1,
      anon_sym_RPAREN,
    STATE(255), 2,
      sym_let_bind_pair,
      aux_sym_let_binding_repeat1,
  [6179] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(765), 1,
      sym_atom,
    ACTIONS(768), 1,
      anon_sym_RPAREN,
    STATE(235), 2,
      sym_parameter,
      aux_sym_parameter_list_repeat1,
  [6193] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(761), 1,
      anon_sym_LPAREN,
    ACTIONS(770), 1,
      anon_sym_RPAREN,
    STATE(255), 2,
      sym_let_bind_pair,
      aux_sym_let_binding_repeat1,
  [6207] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(772), 1,
      sym_atom,
    STATE(383), 1,
      sym_schema_field_list,
    STATE(252), 2,
      sym_schema_field,
      aux_sym_schema_field_list_repeat1,
  [6221] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(485), 1,
      anon_sym_COLON,
    ACTIONS(774), 1,
      anon_sym_LPAREN,
    STATE(54), 1,
      sym_parameter_list,
    STATE(321), 1,
      sym_type_annotation,
  [6237] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(485), 1,
      anon_sym_COLON,
    ACTIONS(776), 1,
      anon_sym_LPAREN,
    STATE(5), 1,
      sym_parameter_list,
    STATE(341), 1,
      sym_type_annotation,
  [6253] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(761), 1,
      anon_sym_LPAREN,
    ACTIONS(778), 1,
      anon_sym_RPAREN,
    STATE(236), 2,
      sym_let_bind_pair,
      aux_sym_let_binding_repeat1,
  [6267] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(485), 1,
      anon_sym_COLON,
    STATE(339), 1,
      sym_type_annotation,
    ACTIONS(780), 2,
      anon_sym_RPAREN,
      sym_atom,
  [6281] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(485), 1,
      anon_sym_COLON,
    ACTIONS(776), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_parameter_list,
    STATE(318), 1,
      sym_type_annotation,
  [6297] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(668), 4,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_atom,
  [6307] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(664), 4,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_atom,
  [6317] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(782), 1,
      sym_atom,
    ACTIONS(784), 1,
      anon_sym_RPAREN,
    STATE(235), 2,
      sym_parameter,
      aux_sym_parameter_list_repeat1,
  [6331] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(678), 4,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_atom,
  [6341] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(678), 4,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_atom,
  [6351] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(782), 1,
      sym_atom,
    ACTIONS(786), 1,
      anon_sym_RPAREN,
    STATE(235), 2,
      sym_parameter,
      aux_sym_parameter_list_repeat1,
  [6365] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(612), 4,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_atom,
  [6375] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(485), 1,
      anon_sym_COLON,
    STATE(331), 1,
      sym_type_annotation,
    ACTIONS(788), 2,
      anon_sym_RPAREN,
      sym_atom,
  [6389] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(782), 1,
      sym_atom,
    ACTIONS(790), 1,
      anon_sym_RPAREN,
    STATE(245), 2,
      sym_parameter,
      aux_sym_parameter_list_repeat1,
  [6403] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(772), 1,
      sym_atom,
    ACTIONS(792), 1,
      anon_sym_RPAREN,
    STATE(259), 2,
      sym_schema_field,
      aux_sym_schema_field_list_repeat1,
  [6417] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(782), 1,
      sym_atom,
    ACTIONS(794), 1,
      anon_sym_RPAREN,
    STATE(235), 2,
      sym_parameter,
      aux_sym_parameter_list_repeat1,
  [6431] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    ACTIONS(796), 1,
      sym_string,
    ACTIONS(798), 1,
      anon_sym_RPAREN,
    STATE(364), 1,
      sym_list,
  [6447] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(800), 1,
      anon_sym_LPAREN,
    ACTIONS(803), 1,
      anon_sym_RPAREN,
    STATE(255), 2,
      sym_let_bind_pair,
      aux_sym_let_binding_repeat1,
  [6461] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(782), 1,
      sym_atom,
    ACTIONS(805), 1,
      anon_sym_RPAREN,
    STATE(253), 2,
      sym_parameter,
      aux_sym_parameter_list_repeat1,
  [6475] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(761), 1,
      anon_sym_LPAREN,
    ACTIONS(807), 1,
      anon_sym_RPAREN,
    STATE(234), 2,
      sym_let_bind_pair,
      aux_sym_let_binding_repeat1,
  [6489] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(660), 4,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_atom,
  [6499] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(809), 1,
      sym_atom,
    ACTIONS(812), 1,
      anon_sym_RPAREN,
    STATE(259), 2,
      sym_schema_field,
      aux_sym_schema_field_list_repeat1,
  [6513] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(814), 1,
      anon_sym_COMMA,
    ACTIONS(816), 1,
      anon_sym_RBRACE,
    STATE(273), 1,
      aux_sym_object_repeat1,
  [6526] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(568), 1,
      anon_sym_COMMA,
    ACTIONS(818), 1,
      anon_sym_RBRACK,
    STATE(266), 1,
      aux_sym_list_repeat2,
  [6539] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(568), 1,
      anon_sym_COMMA,
    ACTIONS(820), 1,
      anon_sym_RBRACK,
    STATE(266), 1,
      aux_sym_list_repeat2,
  [6552] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(814), 1,
      anon_sym_COMMA,
    ACTIONS(822), 1,
      anon_sym_RBRACE,
    STATE(260), 1,
      aux_sym_object_repeat1,
  [6565] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(814), 1,
      anon_sym_COMMA,
    ACTIONS(824), 1,
      anon_sym_RBRACE,
    STATE(273), 1,
      aux_sym_object_repeat1,
  [6578] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(826), 3,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [6587] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(828), 1,
      anon_sym_RBRACK,
    ACTIONS(830), 1,
      anon_sym_COMMA,
    STATE(266), 1,
      aux_sym_list_repeat2,
  [6600] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 3,
      sym_string,
      sym_symbol,
      sym_atom,
  [6609] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(814), 1,
      anon_sym_COMMA,
    ACTIONS(835), 1,
      anon_sym_RBRACE,
    STATE(274), 1,
      aux_sym_object_repeat1,
  [6622] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(814), 1,
      anon_sym_COMMA,
    ACTIONS(837), 1,
      anon_sym_RBRACE,
    STATE(264), 1,
      aux_sym_object_repeat1,
  [6635] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 3,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [6644] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(699), 1,
      sym_atom,
    ACTIONS(841), 1,
      anon_sym_defproperty,
    STATE(15), 1,
      sym_reference,
  [6657] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(568), 1,
      anon_sym_COMMA,
    ACTIONS(843), 1,
      anon_sym_RBRACK,
    STATE(266), 1,
      aux_sym_list_repeat2,
  [6670] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(845), 1,
      anon_sym_COMMA,
    ACTIONS(848), 1,
      anon_sym_RBRACE,
    STATE(273), 1,
      aux_sym_object_repeat1,
  [6683] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(814), 1,
      anon_sym_COMMA,
    ACTIONS(850), 1,
      anon_sym_RBRACE,
    STATE(273), 1,
      aux_sym_object_repeat1,
  [6696] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(674), 3,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_atom,
  [6705] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(852), 3,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [6714] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(814), 1,
      anon_sym_COMMA,
    ACTIONS(854), 1,
      anon_sym_RBRACE,
    STATE(279), 1,
      aux_sym_object_repeat1,
  [6727] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(568), 1,
      anon_sym_COMMA,
    ACTIONS(856), 1,
      anon_sym_RBRACK,
    STATE(266), 1,
      aux_sym_list_repeat2,
  [6740] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(814), 1,
      anon_sym_COMMA,
    ACTIONS(858), 1,
      anon_sym_RBRACE,
    STATE(273), 1,
      aux_sym_object_repeat1,
  [6753] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(860), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [6761] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 1,
      sym_atom,
    STATE(400), 1,
      sym_reference,
  [6771] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(864), 2,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [6779] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(866), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [6787] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 1,
      sym_atom,
    STATE(380), 1,
      sym_reference,
  [6797] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(868), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [6805] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [6813] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 1,
      sym_atom,
    STATE(379), 1,
      sym_reference,
  [6823] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(872), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [6831] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(874), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [6839] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(876), 2,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [6847] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(878), 2,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
  [6855] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(880), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [6863] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(882), 2,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
  [6871] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(884), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [6879] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(886), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [6887] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [6895] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(890), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [6903] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(892), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [6911] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(894), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [6919] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(896), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [6927] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(898), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [6935] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(900), 1,
      sym_atom,
    STATE(61), 1,
      sym_let_variable,
  [6945] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(902), 1,
      anon_sym_step,
    ACTIONS(904), 1,
      anon_sym_step_DASHwith_DASHrollback,
  [6955] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(906), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [6963] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 1,
      sym_atom,
    STATE(15), 1,
      sym_reference,
  [6973] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(908), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [6981] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(910), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [6989] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(912), 2,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
  [6997] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(914), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [7005] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(916), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [7013] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(918), 2,
      sym_string,
      sym_symbol,
  [7021] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [7029] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(922), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [7037] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 1,
      sym_atom,
    STATE(389), 1,
      sym__def_name,
  [7047] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(926), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [7055] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(928), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [7063] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 1,
      sym_atom,
    STATE(397), 1,
      sym_reference,
  [7073] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(776), 1,
      anon_sym_LPAREN,
    STATE(4), 1,
      sym_parameter_list,
  [7083] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(930), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [7091] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(701), 1,
      anon_sym_LPAREN,
    STATE(65), 1,
      sym_s_expression,
  [7101] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(774), 1,
      anon_sym_LPAREN,
    STATE(55), 1,
      sym_parameter_list,
  [7111] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(932), 1,
      sym_atom,
    STATE(62), 1,
      sym__def_name,
  [7121] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 1,
      sym_atom,
    STATE(238), 1,
      sym__def_name,
  [7131] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(934), 1,
      sym_atom,
    STATE(59), 1,
      sym__def_name,
  [7141] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 1,
      sym_atom,
    STATE(239), 1,
      sym__def_name,
  [7151] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 1,
      sym_atom,
    STATE(242), 1,
      sym__def_name,
  [7161] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(936), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [7169] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 1,
      sym_atom,
    STATE(254), 1,
      sym_reference,
  [7179] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 1,
      sym_atom,
    STATE(7), 1,
      sym__def_name,
  [7189] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(938), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [7197] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(940), 2,
      anon_sym_RPAREN,
      sym_atom,
  [7205] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(942), 1,
      anon_sym_COLON,
    ACTIONS(944), 1,
      anon_sym_COLON_EQ,
  [7215] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(946), 2,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
  [7223] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(948), 1,
      anon_sym_COLON,
    ACTIONS(950), 1,
      anon_sym_COLON_EQ,
  [7233] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(952), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [7241] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(954), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [7249] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(956), 2,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
  [7257] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(958), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [7265] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(960), 2,
      anon_sym_RPAREN,
      sym_atom,
  [7273] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(962), 2,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
  [7281] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(776), 1,
      anon_sym_LPAREN,
    STATE(3), 1,
      sym_parameter_list,
  [7291] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(964), 2,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
  [7299] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(966), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [7307] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(968), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [7315] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(970), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [7323] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(972), 2,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
  [7331] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(828), 2,
      anon_sym_RBRACK,
      anon_sym_COMMA,
  [7339] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [7347] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(976), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [7355] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(978), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [7363] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(17), 1,
      anon_sym_LBRACK,
    STATE(398), 1,
      sym_list,
  [7373] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(980), 2,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
  [7381] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(982), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [7389] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [7397] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(986), 2,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [7405] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [7413] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(988), 2,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [7421] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(990), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [7429] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(934), 1,
      sym_atom,
    STATE(12), 1,
      sym__def_name,
  [7439] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 1,
      anon_sym_RPAREN,
  [7446] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(994), 1,
      sym_atom,
  [7453] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(996), 1,
      anon_sym_LBRACK,
  [7460] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(998), 1,
      anon_sym_LBRACE,
  [7467] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1000), 1,
      anon_sym_RPAREN,
  [7474] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1002), 1,
      sym_atom,
  [7481] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1004), 1,
      anon_sym_RBRACE,
  [7488] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1006), 1,
      sym_string,
  [7495] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1008), 1,
      anon_sym_RPAREN,
  [7502] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1010), 1,
      anon_sym_RPAREN,
  [7509] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1012), 1,
      sym_atom,
  [7516] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 1,
      anon_sym_RPAREN,
  [7523] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1016), 1,
      sym_boolean,
  [7530] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1018), 1,
      anon_sym_RPAREN,
  [7537] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1020), 1,
      sym_string,
  [7544] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1022), 1,
      sym_boolean,
  [7551] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 1,
      anon_sym_RPAREN,
  [7558] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1026), 1,
      anon_sym_RPAREN,
  [7565] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1028), 1,
      anon_sym_RBRACK,
  [7572] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1030), 1,
      anon_sym_RBRACE,
  [7579] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1032), 1,
      anon_sym_RBRACE,
  [7586] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1034), 1,
      sym_atom,
  [7593] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1036), 1,
      sym_atom,
  [7600] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1038), 1,
      anon_sym_RPAREN,
  [7607] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1040), 1,
      sym_string,
  [7614] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1042), 1,
      sym_boolean,
  [7621] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 1,
      sym_atom,
  [7628] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1046), 1,
      anon_sym_RPAREN,
  [7635] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1048), 1,
      sym_atom,
  [7642] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1050), 1,
      anon_sym_COLON,
  [7649] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1052), 1,
      anon_sym_RPAREN,
  [7656] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1054), 1,
      anon_sym_RPAREN,
  [7663] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1056), 1,
      anon_sym_RPAREN,
  [7670] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1058), 1,
      anon_sym_RPAREN,
  [7677] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1060), 1,
      anon_sym_LPAREN,
  [7684] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1062), 1,
      sym_atom,
  [7691] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1064), 1,
      anon_sym_RBRACK,
  [7698] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1066), 1,
      anon_sym_RBRACE,
  [7705] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1068), 1,
      anon_sym_RPAREN,
  [7712] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1070), 1,
      sym_atom,
  [7719] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1072), 1,
      anon_sym_RBRACE,
  [7726] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1074), 1,
      anon_sym_LBRACK,
  [7733] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      sym_string,
  [7740] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1078), 1,
      anon_sym_RPAREN,
  [7747] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1080), 1,
      sym_atom,
  [7754] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1082), 1,
      anon_sym_RPAREN,
  [7761] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1084), 1,
      ts_builtin_sym_end,
  [7768] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1086), 1,
      anon_sym_RPAREN,
  [7775] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1088), 1,
      anon_sym_RPAREN,
  [7782] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1090), 1,
      anon_sym_LBRACK,
  [7789] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1092), 1,
      anon_sym_LPAREN,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 77,
  [SMALL_STATE(4)] = 154,
  [SMALL_STATE(5)] = 231,
  [SMALL_STATE(6)] = 308,
  [SMALL_STATE(7)] = 369,
  [SMALL_STATE(8)] = 427,
  [SMALL_STATE(9)] = 478,
  [SMALL_STATE(10)] = 531,
  [SMALL_STATE(11)] = 575,
  [SMALL_STATE(12)] = 615,
  [SMALL_STATE(13)] = 657,
  [SMALL_STATE(14)] = 696,
  [SMALL_STATE(15)] = 735,
  [SMALL_STATE(16)] = 774,
  [SMALL_STATE(17)] = 815,
  [SMALL_STATE(18)] = 854,
  [SMALL_STATE(19)] = 893,
  [SMALL_STATE(20)] = 932,
  [SMALL_STATE(21)] = 971,
  [SMALL_STATE(22)] = 1010,
  [SMALL_STATE(23)] = 1049,
  [SMALL_STATE(24)] = 1090,
  [SMALL_STATE(25)] = 1129,
  [SMALL_STATE(26)] = 1162,
  [SMALL_STATE(27)] = 1201,
  [SMALL_STATE(28)] = 1240,
  [SMALL_STATE(29)] = 1279,
  [SMALL_STATE(30)] = 1320,
  [SMALL_STATE(31)] = 1359,
  [SMALL_STATE(32)] = 1388,
  [SMALL_STATE(33)] = 1427,
  [SMALL_STATE(34)] = 1466,
  [SMALL_STATE(35)] = 1505,
  [SMALL_STATE(36)] = 1544,
  [SMALL_STATE(37)] = 1583,
  [SMALL_STATE(38)] = 1622,
  [SMALL_STATE(39)] = 1661,
  [SMALL_STATE(40)] = 1700,
  [SMALL_STATE(41)] = 1739,
  [SMALL_STATE(42)] = 1778,
  [SMALL_STATE(43)] = 1817,
  [SMALL_STATE(44)] = 1856,
  [SMALL_STATE(45)] = 1895,
  [SMALL_STATE(46)] = 1934,
  [SMALL_STATE(47)] = 1973,
  [SMALL_STATE(48)] = 2012,
  [SMALL_STATE(49)] = 2051,
  [SMALL_STATE(50)] = 2090,
  [SMALL_STATE(51)] = 2128,
  [SMALL_STATE(52)] = 2166,
  [SMALL_STATE(53)] = 2204,
  [SMALL_STATE(54)] = 2242,
  [SMALL_STATE(55)] = 2296,
  [SMALL_STATE(56)] = 2350,
  [SMALL_STATE(57)] = 2385,
  [SMALL_STATE(58)] = 2420,
  [SMALL_STATE(59)] = 2449,
  [SMALL_STATE(60)] = 2484,
  [SMALL_STATE(61)] = 2513,
  [SMALL_STATE(62)] = 2548,
  [SMALL_STATE(63)] = 2601,
  [SMALL_STATE(64)] = 2636,
  [SMALL_STATE(65)] = 2671,
  [SMALL_STATE(66)] = 2706,
  [SMALL_STATE(67)] = 2741,
  [SMALL_STATE(68)] = 2776,
  [SMALL_STATE(69)] = 2811,
  [SMALL_STATE(70)] = 2846,
  [SMALL_STATE(71)] = 2870,
  [SMALL_STATE(72)] = 2904,
  [SMALL_STATE(73)] = 2938,
  [SMALL_STATE(74)] = 2972,
  [SMALL_STATE(75)] = 3006,
  [SMALL_STATE(76)] = 3029,
  [SMALL_STATE(77)] = 3052,
  [SMALL_STATE(78)] = 3079,
  [SMALL_STATE(79)] = 3106,
  [SMALL_STATE(80)] = 3129,
  [SMALL_STATE(81)] = 3156,
  [SMALL_STATE(82)] = 3179,
  [SMALL_STATE(83)] = 3202,
  [SMALL_STATE(84)] = 3225,
  [SMALL_STATE(85)] = 3248,
  [SMALL_STATE(86)] = 3271,
  [SMALL_STATE(87)] = 3294,
  [SMALL_STATE(88)] = 3317,
  [SMALL_STATE(89)] = 3340,
  [SMALL_STATE(90)] = 3363,
  [SMALL_STATE(91)] = 3386,
  [SMALL_STATE(92)] = 3409,
  [SMALL_STATE(93)] = 3432,
  [SMALL_STATE(94)] = 3455,
  [SMALL_STATE(95)] = 3478,
  [SMALL_STATE(96)] = 3501,
  [SMALL_STATE(97)] = 3524,
  [SMALL_STATE(98)] = 3547,
  [SMALL_STATE(99)] = 3570,
  [SMALL_STATE(100)] = 3614,
  [SMALL_STATE(101)] = 3644,
  [SMALL_STATE(102)] = 3666,
  [SMALL_STATE(103)] = 3688,
  [SMALL_STATE(104)] = 3710,
  [SMALL_STATE(105)] = 3754,
  [SMALL_STATE(106)] = 3800,
  [SMALL_STATE(107)] = 3846,
  [SMALL_STATE(108)] = 3867,
  [SMALL_STATE(109)] = 3888,
  [SMALL_STATE(110)] = 3909,
  [SMALL_STATE(111)] = 3930,
  [SMALL_STATE(112)] = 3951,
  [SMALL_STATE(113)] = 3972,
  [SMALL_STATE(114)] = 4015,
  [SMALL_STATE(115)] = 4036,
  [SMALL_STATE(116)] = 4057,
  [SMALL_STATE(117)] = 4100,
  [SMALL_STATE(118)] = 4121,
  [SMALL_STATE(119)] = 4146,
  [SMALL_STATE(120)] = 4167,
  [SMALL_STATE(121)] = 4188,
  [SMALL_STATE(122)] = 4209,
  [SMALL_STATE(123)] = 4231,
  [SMALL_STATE(124)] = 4257,
  [SMALL_STATE(125)] = 4279,
  [SMALL_STATE(126)] = 4301,
  [SMALL_STATE(127)] = 4323,
  [SMALL_STATE(128)] = 4349,
  [SMALL_STATE(129)] = 4375,
  [SMALL_STATE(130)] = 4401,
  [SMALL_STATE(131)] = 4424,
  [SMALL_STATE(132)] = 4447,
  [SMALL_STATE(133)] = 4470,
  [SMALL_STATE(134)] = 4493,
  [SMALL_STATE(135)] = 4515,
  [SMALL_STATE(136)] = 4533,
  [SMALL_STATE(137)] = 4551,
  [SMALL_STATE(138)] = 4569,
  [SMALL_STATE(139)] = 4587,
  [SMALL_STATE(140)] = 4604,
  [SMALL_STATE(141)] = 4621,
  [SMALL_STATE(142)] = 4652,
  [SMALL_STATE(143)] = 4669,
  [SMALL_STATE(144)] = 4686,
  [SMALL_STATE(145)] = 4705,
  [SMALL_STATE(146)] = 4726,
  [SMALL_STATE(147)] = 4745,
  [SMALL_STATE(148)] = 4764,
  [SMALL_STATE(149)] = 4781,
  [SMALL_STATE(150)] = 4798,
  [SMALL_STATE(151)] = 4817,
  [SMALL_STATE(152)] = 4834,
  [SMALL_STATE(153)] = 4853,
  [SMALL_STATE(154)] = 4870,
  [SMALL_STATE(155)] = 4891,
  [SMALL_STATE(156)] = 4908,
  [SMALL_STATE(157)] = 4925,
  [SMALL_STATE(158)] = 4946,
  [SMALL_STATE(159)] = 4963,
  [SMALL_STATE(160)] = 4980,
  [SMALL_STATE(161)] = 4997,
  [SMALL_STATE(162)] = 5016,
  [SMALL_STATE(163)] = 5033,
  [SMALL_STATE(164)] = 5050,
  [SMALL_STATE(165)] = 5067,
  [SMALL_STATE(166)] = 5083,
  [SMALL_STATE(167)] = 5099,
  [SMALL_STATE(168)] = 5115,
  [SMALL_STATE(169)] = 5131,
  [SMALL_STATE(170)] = 5147,
  [SMALL_STATE(171)] = 5163,
  [SMALL_STATE(172)] = 5179,
  [SMALL_STATE(173)] = 5195,
  [SMALL_STATE(174)] = 5211,
  [SMALL_STATE(175)] = 5227,
  [SMALL_STATE(176)] = 5243,
  [SMALL_STATE(177)] = 5259,
  [SMALL_STATE(178)] = 5275,
  [SMALL_STATE(179)] = 5293,
  [SMALL_STATE(180)] = 5317,
  [SMALL_STATE(181)] = 5333,
  [SMALL_STATE(182)] = 5349,
  [SMALL_STATE(183)] = 5367,
  [SMALL_STATE(184)] = 5382,
  [SMALL_STATE(185)] = 5397,
  [SMALL_STATE(186)] = 5412,
  [SMALL_STATE(187)] = 5427,
  [SMALL_STATE(188)] = 5442,
  [SMALL_STATE(189)] = 5457,
  [SMALL_STATE(190)] = 5480,
  [SMALL_STATE(191)] = 5495,
  [SMALL_STATE(192)] = 5510,
  [SMALL_STATE(193)] = 5525,
  [SMALL_STATE(194)] = 5540,
  [SMALL_STATE(195)] = 5555,
  [SMALL_STATE(196)] = 5570,
  [SMALL_STATE(197)] = 5585,
  [SMALL_STATE(198)] = 5600,
  [SMALL_STATE(199)] = 5615,
  [SMALL_STATE(200)] = 5630,
  [SMALL_STATE(201)] = 5645,
  [SMALL_STATE(202)] = 5660,
  [SMALL_STATE(203)] = 5675,
  [SMALL_STATE(204)] = 5690,
  [SMALL_STATE(205)] = 5705,
  [SMALL_STATE(206)] = 5720,
  [SMALL_STATE(207)] = 5735,
  [SMALL_STATE(208)] = 5750,
  [SMALL_STATE(209)] = 5765,
  [SMALL_STATE(210)] = 5780,
  [SMALL_STATE(211)] = 5795,
  [SMALL_STATE(212)] = 5817,
  [SMALL_STATE(213)] = 5835,
  [SMALL_STATE(214)] = 5857,
  [SMALL_STATE(215)] = 5875,
  [SMALL_STATE(216)] = 5893,
  [SMALL_STATE(217)] = 5908,
  [SMALL_STATE(218)] = 5923,
  [SMALL_STATE(219)] = 5940,
  [SMALL_STATE(220)] = 5955,
  [SMALL_STATE(221)] = 5970,
  [SMALL_STATE(222)] = 5987,
  [SMALL_STATE(223)] = 6002,
  [SMALL_STATE(224)] = 6017,
  [SMALL_STATE(225)] = 6032,
  [SMALL_STATE(226)] = 6047,
  [SMALL_STATE(227)] = 6062,
  [SMALL_STATE(228)] = 6077,
  [SMALL_STATE(229)] = 6090,
  [SMALL_STATE(230)] = 6105,
  [SMALL_STATE(231)] = 6120,
  [SMALL_STATE(232)] = 6135,
  [SMALL_STATE(233)] = 6150,
  [SMALL_STATE(234)] = 6165,
  [SMALL_STATE(235)] = 6179,
  [SMALL_STATE(236)] = 6193,
  [SMALL_STATE(237)] = 6207,
  [SMALL_STATE(238)] = 6221,
  [SMALL_STATE(239)] = 6237,
  [SMALL_STATE(240)] = 6253,
  [SMALL_STATE(241)] = 6267,
  [SMALL_STATE(242)] = 6281,
  [SMALL_STATE(243)] = 6297,
  [SMALL_STATE(244)] = 6307,
  [SMALL_STATE(245)] = 6317,
  [SMALL_STATE(246)] = 6331,
  [SMALL_STATE(247)] = 6341,
  [SMALL_STATE(248)] = 6351,
  [SMALL_STATE(249)] = 6365,
  [SMALL_STATE(250)] = 6375,
  [SMALL_STATE(251)] = 6389,
  [SMALL_STATE(252)] = 6403,
  [SMALL_STATE(253)] = 6417,
  [SMALL_STATE(254)] = 6431,
  [SMALL_STATE(255)] = 6447,
  [SMALL_STATE(256)] = 6461,
  [SMALL_STATE(257)] = 6475,
  [SMALL_STATE(258)] = 6489,
  [SMALL_STATE(259)] = 6499,
  [SMALL_STATE(260)] = 6513,
  [SMALL_STATE(261)] = 6526,
  [SMALL_STATE(262)] = 6539,
  [SMALL_STATE(263)] = 6552,
  [SMALL_STATE(264)] = 6565,
  [SMALL_STATE(265)] = 6578,
  [SMALL_STATE(266)] = 6587,
  [SMALL_STATE(267)] = 6600,
  [SMALL_STATE(268)] = 6609,
  [SMALL_STATE(269)] = 6622,
  [SMALL_STATE(270)] = 6635,
  [SMALL_STATE(271)] = 6644,
  [SMALL_STATE(272)] = 6657,
  [SMALL_STATE(273)] = 6670,
  [SMALL_STATE(274)] = 6683,
  [SMALL_STATE(275)] = 6696,
  [SMALL_STATE(276)] = 6705,
  [SMALL_STATE(277)] = 6714,
  [SMALL_STATE(278)] = 6727,
  [SMALL_STATE(279)] = 6740,
  [SMALL_STATE(280)] = 6753,
  [SMALL_STATE(281)] = 6761,
  [SMALL_STATE(282)] = 6771,
  [SMALL_STATE(283)] = 6779,
  [SMALL_STATE(284)] = 6787,
  [SMALL_STATE(285)] = 6797,
  [SMALL_STATE(286)] = 6805,
  [SMALL_STATE(287)] = 6813,
  [SMALL_STATE(288)] = 6823,
  [SMALL_STATE(289)] = 6831,
  [SMALL_STATE(290)] = 6839,
  [SMALL_STATE(291)] = 6847,
  [SMALL_STATE(292)] = 6855,
  [SMALL_STATE(293)] = 6863,
  [SMALL_STATE(294)] = 6871,
  [SMALL_STATE(295)] = 6879,
  [SMALL_STATE(296)] = 6887,
  [SMALL_STATE(297)] = 6895,
  [SMALL_STATE(298)] = 6903,
  [SMALL_STATE(299)] = 6911,
  [SMALL_STATE(300)] = 6919,
  [SMALL_STATE(301)] = 6927,
  [SMALL_STATE(302)] = 6935,
  [SMALL_STATE(303)] = 6945,
  [SMALL_STATE(304)] = 6955,
  [SMALL_STATE(305)] = 6963,
  [SMALL_STATE(306)] = 6973,
  [SMALL_STATE(307)] = 6981,
  [SMALL_STATE(308)] = 6989,
  [SMALL_STATE(309)] = 6997,
  [SMALL_STATE(310)] = 7005,
  [SMALL_STATE(311)] = 7013,
  [SMALL_STATE(312)] = 7021,
  [SMALL_STATE(313)] = 7029,
  [SMALL_STATE(314)] = 7037,
  [SMALL_STATE(315)] = 7047,
  [SMALL_STATE(316)] = 7055,
  [SMALL_STATE(317)] = 7063,
  [SMALL_STATE(318)] = 7073,
  [SMALL_STATE(319)] = 7083,
  [SMALL_STATE(320)] = 7091,
  [SMALL_STATE(321)] = 7101,
  [SMALL_STATE(322)] = 7111,
  [SMALL_STATE(323)] = 7121,
  [SMALL_STATE(324)] = 7131,
  [SMALL_STATE(325)] = 7141,
  [SMALL_STATE(326)] = 7151,
  [SMALL_STATE(327)] = 7161,
  [SMALL_STATE(328)] = 7169,
  [SMALL_STATE(329)] = 7179,
  [SMALL_STATE(330)] = 7189,
  [SMALL_STATE(331)] = 7197,
  [SMALL_STATE(332)] = 7205,
  [SMALL_STATE(333)] = 7215,
  [SMALL_STATE(334)] = 7223,
  [SMALL_STATE(335)] = 7233,
  [SMALL_STATE(336)] = 7241,
  [SMALL_STATE(337)] = 7249,
  [SMALL_STATE(338)] = 7257,
  [SMALL_STATE(339)] = 7265,
  [SMALL_STATE(340)] = 7273,
  [SMALL_STATE(341)] = 7281,
  [SMALL_STATE(342)] = 7291,
  [SMALL_STATE(343)] = 7299,
  [SMALL_STATE(344)] = 7307,
  [SMALL_STATE(345)] = 7315,
  [SMALL_STATE(346)] = 7323,
  [SMALL_STATE(347)] = 7331,
  [SMALL_STATE(348)] = 7339,
  [SMALL_STATE(349)] = 7347,
  [SMALL_STATE(350)] = 7355,
  [SMALL_STATE(351)] = 7363,
  [SMALL_STATE(352)] = 7373,
  [SMALL_STATE(353)] = 7381,
  [SMALL_STATE(354)] = 7389,
  [SMALL_STATE(355)] = 7397,
  [SMALL_STATE(356)] = 7405,
  [SMALL_STATE(357)] = 7413,
  [SMALL_STATE(358)] = 7421,
  [SMALL_STATE(359)] = 7429,
  [SMALL_STATE(360)] = 7439,
  [SMALL_STATE(361)] = 7446,
  [SMALL_STATE(362)] = 7453,
  [SMALL_STATE(363)] = 7460,
  [SMALL_STATE(364)] = 7467,
  [SMALL_STATE(365)] = 7474,
  [SMALL_STATE(366)] = 7481,
  [SMALL_STATE(367)] = 7488,
  [SMALL_STATE(368)] = 7495,
  [SMALL_STATE(369)] = 7502,
  [SMALL_STATE(370)] = 7509,
  [SMALL_STATE(371)] = 7516,
  [SMALL_STATE(372)] = 7523,
  [SMALL_STATE(373)] = 7530,
  [SMALL_STATE(374)] = 7537,
  [SMALL_STATE(375)] = 7544,
  [SMALL_STATE(376)] = 7551,
  [SMALL_STATE(377)] = 7558,
  [SMALL_STATE(378)] = 7565,
  [SMALL_STATE(379)] = 7572,
  [SMALL_STATE(380)] = 7579,
  [SMALL_STATE(381)] = 7586,
  [SMALL_STATE(382)] = 7593,
  [SMALL_STATE(383)] = 7600,
  [SMALL_STATE(384)] = 7607,
  [SMALL_STATE(385)] = 7614,
  [SMALL_STATE(386)] = 7621,
  [SMALL_STATE(387)] = 7628,
  [SMALL_STATE(388)] = 7635,
  [SMALL_STATE(389)] = 7642,
  [SMALL_STATE(390)] = 7649,
  [SMALL_STATE(391)] = 7656,
  [SMALL_STATE(392)] = 7663,
  [SMALL_STATE(393)] = 7670,
  [SMALL_STATE(394)] = 7677,
  [SMALL_STATE(395)] = 7684,
  [SMALL_STATE(396)] = 7691,
  [SMALL_STATE(397)] = 7698,
  [SMALL_STATE(398)] = 7705,
  [SMALL_STATE(399)] = 7712,
  [SMALL_STATE(400)] = 7719,
  [SMALL_STATE(401)] = 7726,
  [SMALL_STATE(402)] = 7733,
  [SMALL_STATE(403)] = 7740,
  [SMALL_STATE(404)] = 7747,
  [SMALL_STATE(405)] = 7754,
  [SMALL_STATE(406)] = 7761,
  [SMALL_STATE(407)] = 7768,
  [SMALL_STATE(408)] = 7775,
  [SMALL_STATE(409)] = 7782,
  [SMALL_STATE(410)] = 7789,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0, 0, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(78),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(34),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(384),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(409),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(31),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(385),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(386),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(44),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(46),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(40),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [67] = {.entry = {.count = 1, .reusable = false}}, SHIFT(370),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [73] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__doc_or_meta, 1, 0, 12),
  [75] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__doc_or_meta, 1, 0, 12),
  [77] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__doc_or_meta_repeat1, 2, 0, 20),
  [79] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__doc_or_meta_repeat1, 2, 0, 20),
  [81] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__doc_or_meta_repeat1, 2, 0, 20), SHIFT_REPEAT(91),
  [84] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__doc_or_meta_repeat1, 2, 0, 20), SHIFT_REPEAT(384),
  [87] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__doc_or_meta_repeat1, 2, 0, 20), SHIFT_REPEAT(409),
  [90] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__doc_or_meta_repeat1, 2, 0, 20), SHIFT_REPEAT(31),
  [93] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__doc_or_meta_repeat1, 2, 0, 20), SHIFT_REPEAT(385),
  [96] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__doc_or_meta_repeat1, 2, 0, 20), SHIFT_REPEAT(386),
  [99] = {.entry = {.count = 1, .reusable = false}}, SHIFT(392),
  [101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [103] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_reference, 1, 0, 0),
  [105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [107] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_list_repeat1, 2, 0, 0), SHIFT_REPEAT(78),
  [110] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_list_repeat1, 2, 0, 0), SHIFT_REPEAT(11),
  [113] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2, 0, 0), SHIFT_REPEAT(11),
  [116] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2, 0, 0), SHIFT_REPEAT(23),
  [119] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2, 0, 0),
  [121] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2, 0, 0), SHIFT_REPEAT(212),
  [124] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2, 0, 0), SHIFT_REPEAT(221),
  [127] = {.entry = {.count = 1, .reusable = false}}, SHIFT(37),
  [129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [135] = {.entry = {.count = 1, .reusable = false}}, SHIFT(133),
  [137] = {.entry = {.count = 1, .reusable = false}}, SHIFT(150),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [141] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_managed, 1, 0, 0),
  [143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [147] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_managed, 1, 0, 0),
  [149] = {.entry = {.count = 1, .reusable = false}}, SHIFT(11),
  [151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [155] = {.entry = {.count = 1, .reusable = false}}, SHIFT(26),
  [157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [161] = {.entry = {.count = 1, .reusable = false}}, SHIFT(128),
  [163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [169] = {.entry = {.count = 1, .reusable = false}}, SHIFT(43),
  [171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [175] = {.entry = {.count = 1, .reusable = false}}, SHIFT(17),
  [177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [185] = {.entry = {.count = 1, .reusable = false}}, SHIFT(20),
  [187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [191] = {.entry = {.count = 1, .reusable = false}}, SHIFT(123),
  [193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [199] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_reference, 1, 0, 0),
  [201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [207] = {.entry = {.count = 1, .reusable = false}}, SHIFT(127),
  [209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [213] = {.entry = {.count = 1, .reusable = false}}, SHIFT(28),
  [215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [219] = {.entry = {.count = 1, .reusable = false}}, SHIFT(48),
  [221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [225] = {.entry = {.count = 1, .reusable = false}}, SHIFT(39),
  [227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [233] = {.entry = {.count = 1, .reusable = false}}, SHIFT(42),
  [235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [243] = {.entry = {.count = 1, .reusable = false}}, SHIFT(21),
  [245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(357),
  [249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [253] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [261] = {.entry = {.count = 1, .reusable = false}}, SHIFT(36),
  [263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [265] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(330),
  [273] = {.entry = {.count = 1, .reusable = false}}, SHIFT(27),
  [275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [279] = {.entry = {.count = 1, .reusable = false}}, SHIFT(403),
  [281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(403),
  [283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [285] = {.entry = {.count = 1, .reusable = false}}, SHIFT(391),
  [287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [289] = {.entry = {.count = 1, .reusable = false}}, SHIFT(371),
  [291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [293] = {.entry = {.count = 1, .reusable = false}}, SHIFT(368),
  [295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [303] = {.entry = {.count = 1, .reusable = false}}, SHIFT(295),
  [305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [307] = {.entry = {.count = 1, .reusable = false}}, SHIFT(25),
  [309] = {.entry = {.count = 1, .reusable = false}}, SHIFT(67),
  [311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [313] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_reference, 2, 0, 0),
  [315] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_reference, 2, 0, 0),
  [317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [319] = {.entry = {.count = 1, .reusable = false}}, SHIFT(145),
  [321] = {.entry = {.count = 1, .reusable = false}}, SHIFT(105),
  [323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [325] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [331] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_reference_repeat1, 2, 0, 0),
  [333] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_reference_repeat1, 2, 0, 0),
  [335] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_reference_repeat1, 2, 0, 0), SHIFT_REPEAT(395),
  [338] = {.entry = {.count = 1, .reusable = false}}, SHIFT(369),
  [340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(369),
  [342] = {.entry = {.count = 1, .reusable = false}}, SHIFT(250),
  [344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [346] = {.entry = {.count = 1, .reusable = false}}, SHIFT(374),
  [348] = {.entry = {.count = 1, .reusable = false}}, SHIFT(401),
  [350] = {.entry = {.count = 1, .reusable = false}}, SHIFT(66),
  [352] = {.entry = {.count = 1, .reusable = false}}, SHIFT(375),
  [354] = {.entry = {.count = 1, .reusable = false}}, SHIFT(361),
  [356] = {.entry = {.count = 1, .reusable = false}}, SHIFT(10),
  [358] = {.entry = {.count = 1, .reusable = false}}, SHIFT(373),
  [360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [362] = {.entry = {.count = 1, .reusable = false}}, SHIFT(296),
  [364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [366] = {.entry = {.count = 1, .reusable = false}}, SHIFT(393),
  [368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(393),
  [370] = {.entry = {.count = 1, .reusable = false}}, SHIFT(193),
  [372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [374] = {.entry = {.count = 1, .reusable = false}}, SHIFT(387),
  [376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(387),
  [378] = {.entry = {.count = 1, .reusable = false}}, SHIFT(376),
  [380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [382] = {.entry = {.count = 1, .reusable = false}}, SHIFT(347),
  [384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [402] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_object, 2, 0, 0),
  [404] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_object, 2, 0, 0),
  [406] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameter_list, 3, 0, 0),
  [408] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 3, 0, 0),
  [410] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameter_list, 2, 0, 0),
  [412] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 2, 0, 0),
  [414] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_reference_repeat1, 2, 0, 0), SHIFT_REPEAT(382),
  [417] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_object, 4, 0, 0),
  [419] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_object, 4, 0, 0),
  [421] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 4, 0, 0),
  [423] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 4, 0, 0),
  [425] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_doc, 1, 0, 5),
  [427] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_doc, 1, 0, 5),
  [429] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_object, 3, 0, 0),
  [431] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_object, 3, 0, 0),
  [433] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 3, 0, 0),
  [435] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 3, 0, 0),
  [437] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 2, 0, 0),
  [439] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 2, 0, 0),
  [441] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_model, 4, 0, 32),
  [443] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_model, 4, 0, 32),
  [445] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_model, 3, 0, 0),
  [447] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_model, 3, 0, 0),
  [449] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_meta, 2, 0, 0),
  [451] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_meta, 2, 0, 0),
  [453] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_event, 2, 0, 0),
  [455] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_event, 2, 0, 0),
  [457] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__doc_or_meta_repeat1, 1, 0, 7),
  [459] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__doc_or_meta_repeat1, 1, 0, 7),
  [461] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_managed, 2, 0, 18),
  [463] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_managed, 2, 0, 18),
  [465] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__doc_or_meta_repeat1, 1, 0, 8),
  [467] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__doc_or_meta_repeat1, 1, 0, 8),
  [469] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__doc_or_meta_repeat1, 1, 0, 9),
  [471] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__doc_or_meta_repeat1, 1, 0, 9),
  [473] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__doc_or_meta_repeat1, 1, 0, 10),
  [475] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__doc_or_meta_repeat1, 1, 0, 10),
  [477] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__doc_or_meta_repeat1, 1, 0, 11),
  [479] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__doc_or_meta_repeat1, 1, 0, 11),
  [481] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_doc, 2, 0, 16),
  [483] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_doc, 2, 0, 16),
  [485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [487] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_s_expression, 4, 0, 14),
  [489] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_s_expression, 4, 0, 14),
  [491] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_s_expression, 3, 0, 2),
  [493] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_s_expression, 3, 0, 2),
  [495] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__doc_or_meta_repeat1, 2, 0, 20), SHIFT_REPEAT(177),
  [498] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__doc_or_meta_repeat1, 2, 0, 20), SHIFT_REPEAT(367),
  [501] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__doc_or_meta_repeat1, 2, 0, 20), SHIFT_REPEAT(362),
  [504] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__doc_or_meta_repeat1, 2, 0, 20), SHIFT_REPEAT(13),
  [507] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__doc_or_meta_repeat1, 2, 0, 20), SHIFT_REPEAT(372),
  [510] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__doc_or_meta_repeat1, 2, 0, 20), SHIFT_REPEAT(370),
  [513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [517] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_binding, 5, 0, 35),
  [519] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_binding, 5, 0, 35),
  [521] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_binding, 6, 0, 46),
  [523] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_binding, 6, 0, 46),
  [525] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cond, 5, 0, 36),
  [527] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cond, 5, 0, 36),
  [529] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_binding, 6, 0, 45),
  [531] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_binding, 6, 0, 45),
  [533] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_binding, 7, 0, 55),
  [535] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_binding, 7, 0, 55),
  [537] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__doc_or_meta_repeat1, 2, 0, 20), SHIFT_REPEAT(186),
  [540] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__doc_or_meta_repeat1, 2, 0, 20), SHIFT_REPEAT(374),
  [543] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__doc_or_meta_repeat1, 2, 0, 20), SHIFT_REPEAT(401),
  [546] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__doc_or_meta_repeat1, 2, 0, 20), SHIFT_REPEAT(66),
  [549] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__doc_or_meta_repeat1, 2, 0, 20), SHIFT_REPEAT(375),
  [552] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__doc_or_meta_repeat1, 2, 0, 20), SHIFT_REPEAT(361),
  [555] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cond, 4, 0, 29),
  [557] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cond, 4, 0, 29),
  [559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [561] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_list_repeat1, 1, 0, 0),
  [563] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 1, 0, 0),
  [565] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 1, 0, 0), SHIFT(117),
  [568] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [572] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_repeat1, 2, 0, 0), SHIFT_REPEAT(141),
  [575] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_module_repeat1, 2, 0, 0),
  [577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(342),
  [579] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 1, 0, 0), SHIFT(140),
  [582] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 1, 0, 0), SHIFT(201),
  [585] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 1, 0, 0), SHIFT(85),
  [588] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [590] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_variable, 1, 0, 34),
  [592] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_variable, 1, 0, 34),
  [594] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [596] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_reference_repeat1, 2, 0, 0), SHIFT_REPEAT(365),
  [599] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_cond_repeat1, 2, 0, 30),
  [601] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_cond_repeat1, 2, 0, 30),
  [603] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_cond_repeat1, 2, 0, 30), SHIFT_REPEAT(320),
  [606] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__def_name, 1, 0, 1),
  [608] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__def_name, 1, 0, 1),
  [610] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_identifier, 1, 0, 0),
  [612] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_identifier, 1, 0, 0),
  [614] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [616] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [618] = {.entry = {.count = 1, .reusable = true}}, SHIFT(325),
  [620] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [622] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [624] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [626] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [628] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [630] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [632] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_variable, 2, 0, 44),
  [634] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_variable, 2, 0, 44),
  [636] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_interface_repeat1, 2, 0, 0), SHIFT_REPEAT(211),
  [639] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_interface_repeat1, 2, 0, 0),
  [641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [647] = {.entry = {.count = 1, .reusable = false}}, SHIFT(181),
  [649] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_cond_repeat1, 4, 0, 47),
  [651] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_cond_repeat1, 4, 0, 47),
  [653] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [655] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_reference_repeat1, 2, 0, 0), SHIFT_REPEAT(381),
  [658] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__parametrized_object, 4, 0, 60),
  [660] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parametrized_object, 4, 0, 60),
  [662] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__parametrized_object, 3, 0, 56),
  [664] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parametrized_object, 3, 0, 56),
  [666] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__parametrized_list, 3, 0, 56),
  [668] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parametrized_list, 3, 0, 56),
  [670] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [672] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_annotation, 2, 0, 0),
  [674] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_annotation, 2, 0, 0),
  [676] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_identifier, 1, 0, 38),
  [678] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_identifier, 1, 0, 38),
  [680] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0),
  [682] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(213),
  [685] = {.entry = {.count = 1, .reusable = false}}, SHIFT(100),
  [687] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [689] = {.entry = {.count = 1, .reusable = false}}, SHIFT(394),
  [691] = {.entry = {.count = 1, .reusable = false}}, SHIFT(51),
  [693] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_managed, 3, 0, 24),
  [695] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_managed, 3, 0, 24),
  [697] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1, 0, 0),
  [699] = {.entry = {.count = 1, .reusable = false}}, SHIFT(118),
  [701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(334),
  [705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [707] = {.entry = {.count = 1, .reusable = false}}, SHIFT(311),
  [709] = {.entry = {.count = 1, .reusable = false}}, SHIFT(328),
  [711] = {.entry = {.count = 1, .reusable = false}}, SHIFT(329),
  [713] = {.entry = {.count = 1, .reusable = false}}, SHIFT(388),
  [715] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [717] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [719] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_model_repeat1, 2, 0, 0),
  [721] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_model_repeat1, 2, 0, 0), SHIFT_REPEAT(271),
  [724] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [726] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [728] = {.entry = {.count = 1, .reusable = false}}, SHIFT(410),
  [730] = {.entry = {.count = 1, .reusable = false}}, SHIFT(53),
  [732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [734] = {.entry = {.count = 1, .reusable = true}}, SHIFT(319),
  [736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(358),
  [740] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [742] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_defpact_repeat1, 2, 0, 0), SHIFT_REPEAT(303),
  [745] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_defpact_repeat1, 2, 0, 0),
  [747] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [749] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [751] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [753] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [755] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [757] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [759] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [761] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [763] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [765] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameter_list_repeat1, 2, 0, 0), SHIFT_REPEAT(241),
  [768] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parameter_list_repeat1, 2, 0, 0),
  [770] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [772] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [774] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [776] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [778] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [780] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 1, 0, 37),
  [782] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [784] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [786] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [788] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_schema_field, 1, 0, 31),
  [790] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [792] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_schema_field_list, 1, 0, 0),
  [794] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [796] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [798] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [800] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_let_binding_repeat1, 2, 0, 0), SHIFT_REPEAT(302),
  [803] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_let_binding_repeat1, 2, 0, 0),
  [805] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [807] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [809] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_schema_field_list_repeat1, 2, 0, 0), SHIFT_REPEAT(250),
  [812] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_schema_field_list_repeat1, 2, 0, 0),
  [814] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [816] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [818] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [820] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [822] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [824] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [826] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_use, 4, 0, 4),
  [828] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_repeat2, 2, 0, 0),
  [830] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_repeat2, 2, 0, 0), SHIFT_REPEAT(69),
  [833] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [835] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [837] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [839] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_use, 5, 0, 15),
  [841] = {.entry = {.count = 1, .reusable = false}}, SHIFT(359),
  [843] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [845] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_object_repeat1, 2, 0, 0), SHIFT_REPEAT(232),
  [848] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_object_repeat1, 2, 0, 0),
  [850] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [852] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_use, 6, 0, 23),
  [854] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [856] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [858] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [860] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_deftable, 9, 0, 67),
  [862] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [864] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defproperty, 6, 0, 51),
  [866] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_step, 5, 0, 63),
  [868] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_step_with_rollback, 5, 0, 64),
  [870] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_deftable, 8, 0, 65),
  [872] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_step_with_rollback, 6, 0, 66),
  [874] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defpact, 6, 0, 51),
  [876] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defproperty, 4, 0, 6),
  [878] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 5, 0, 21),
  [880] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_bind_pair, 4, 0, 54),
  [882] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 5, 0, 19),
  [884] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defconst, 5, 0, 21),
  [886] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pair, 3, 0, 28),
  [888] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bind_pair, 3, 0, 28),
  [890] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defpact, 5, 0, 39),
  [892] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defpact, 6, 0, 50),
  [894] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defpact, 6, 0, 49),
  [896] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defconst, 6, 0, 52),
  [898] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defcap, 5, 0, 39),
  [900] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [902] = {.entry = {.count = 1, .reusable = false}}, SHIFT(63),
  [904] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [906] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defcap, 6, 0, 51),
  [908] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defun, 5, 0, 39),
  [910] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defcap, 6, 0, 50),
  [912] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 6, 0, 25),
  [914] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defcap, 6, 0, 49),
  [916] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defun, 6, 0, 51),
  [918] = {.entry = {.count = 1, .reusable = true}}, SHIFT(377),
  [920] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defun, 7, 0, 57),
  [922] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defun, 6, 0, 50),
  [924] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [926] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defun, 7, 0, 58),
  [928] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defun, 6, 0, 49),
  [930] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defpact, 7, 0, 58),
  [932] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [934] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [936] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defschema, 6, 0, 53),
  [938] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defun, 7, 0, 59),
  [940] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_schema_field, 2, 0, 40),
  [942] = {.entry = {.count = 1, .reusable = false}}, SHIFT(56),
  [944] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [946] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module, 5, 0, 22),
  [948] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__property_name, 1, 0, 13),
  [950] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__property_name, 1, 0, 13),
  [952] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defcap, 7, 0, 57),
  [954] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_step, 4, 0, 62),
  [956] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module, 6, 0, 26),
  [958] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defschema, 5, 0, 41),
  [960] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 2, 0, 48),
  [962] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module, 6, 0, 27),
  [964] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module, 7, 0, 33),
  [966] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defcap, 7, 0, 58),
  [968] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defcap, 7, 0, 59),
  [970] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defpact, 7, 0, 57),
  [972] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 4, 0, 6),
  [974] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defpact, 8, 0, 61),
  [976] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defcap, 8, 0, 61),
  [978] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_implements, 4, 0, 43),
  [980] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_namespace, 4, 0, 3),
  [982] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defun, 8, 0, 61),
  [984] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bless, 4, 0, 42),
  [986] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defproperty, 5, 0, 21),
  [988] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defproperty, 5, 0, 39),
  [990] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defpact, 7, 0, 59),
  [992] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [994] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [996] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [998] = {.entry = {.count = 1, .reusable = true}}, SHIFT(404),
  [1000] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [1002] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [1004] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [1006] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [1008] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [1010] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [1012] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [1014] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [1016] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [1018] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [1020] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [1022] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [1024] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [1026] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [1028] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [1030] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [1032] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [1034] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [1036] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [1038] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [1040] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [1042] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [1044] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [1046] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [1048] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [1050] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [1052] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [1054] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [1056] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [1058] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [1060] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [1062] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [1064] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [1066] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [1068] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [1070] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [1072] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [1074] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [1076] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [1078] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [1080] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [1082] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [1084] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1086] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [1088] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [1090] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [1092] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_pact(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_atom,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
