# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['think_sql']

package_data = \
{'': ['*']}

install_requires = \
['PyMySQL>=1.0.2,<2.0.0',
 'cacheout>=0.13.1,<0.14.0',
 'dill>=0.3.4,<0.4.0',
 'jsonpath>=0.82,<0.83',
 'loguru>=0.5.3,<0.6.0',
 'pretty-errors>=1.2.24,<2.0.0',
 'redis>=3.5.3,<4.0.0']

setup_kwargs = {
    'name': 'think-sql',
    'version': '0.1.2',
    'description': 'ThinkSQL link think-orm(ThinkPHP)',
    'long_description': '# ThinkSQL 类似ThinkPHP的数据库引擎\n\n## Install\n```\npip install think-sql\n```\n\n## How to use\n\n### 1. simple demo\n\n> Database: `test` Table: `user`\n\n```\nfrom think-sql.database import DB\n\nconfig = {\n    \'database\': \'test\',\n    \'host\': \'127.0.0.1\',\n    \'port\': 3306,\n    \'username\': \'root\',\n    \'password\': \'root\',\n}\n\nwith DB(**config) as db:\n    data = db.table(\'user\').where(\'id\',1).find()\n    print(data)\n```\nresult\n```\n{\n    "id":1,\n    "username":"hbh112233abc",\n    "age":"36",\n    "address":"FUJIAN.XIAMEN"\n}\n```\n\n### 2. Introduction\n\n#### think_sql.database.DB\n\n- __init__(database=\'test\',host=\'127.0.0.1\',username=\'root\',password=\'root\',port=3306,params={})\n\n- connect()\n    connect database use __init__ params\n\n- table(table_name):Table\n    return class Table <think_sql.table.Table>\n\n- check_connected():bool\n    check connected, try reconnect database\n\n- query(sql,params=())\n    query sql return cursor.fetchall\n\n- execute(sql,params=())\n    execute sql write operate(ex:insert,update,delete,...)\n\n#### think_sql.table.Table\n\n- __init__(connector: Connection,cursor: Cursor,table_name: str,debug: bool = True)\n\n- init()\n    initialize query condition\n\n- debug(flag=True)\n    set debug flag\n\n- set_cache_storage(storage: CacheStorage)\n    set cache storage ex: Redis\n\n- cache(key: str = None, expire: int = 3600)\n    use cache at query\n\n- cursor(sql: str, params: list = []) -> Cursor\n    return cursor object\n\n- get_last_sql() -> str\n    return last sql string\n\n- get_lastid() -> str\n    return last row id\n\n- get_rowcount() -> int\n    return affect rows count\n\n- fetch_sql(flag: bool = True)\n    set fetch sql flag,if flag = True then `query` and `execute` will only return sql\n\n- build_sql(operation: str, params: list = []) -> str\n    return build sql\n\n- query(sql: str, params: list = []) -> list\n    execute read operation sql and return cursor.fetchall()\n    when `fetch_sql`=True then return sql and not execute the sql\n\n- execute(sql: str, params: list = []) -> int\n    execute write operation sql and return affect rows count\n    when `fetch_sql`=True then return sql and not execute the sql\n\n- where(field: Union[str, list, tuple], symbol: str = \'\', value: Any = None)\n    set query conditions, support multipe use\n\n    > where(field,value)\n\n    ```\n    where field = value\n    ```\n    > where(field,symbol,value)\n\n    ```\n    where field symbol value\n    ```\n    > where(\n        [\n            [field1,symbol1,value1],\n            [field2,symbol2,value2]\n        ]\n    )\n\n    ```\n    where field1 symbol1 value1 and field2 symbol2 value2\n    ```\n\n    > where(field1,symbol1,value1).where(field2,symbol2,value2)\n\n    ```\n    where field1 symbol1 value1 and field2 symbol2 value2\n    ```\n\n    - symbol\n\n    |symbol|another|demo|\n    |-|-|-|\n    |`=`|`eq`,`=`| where(\'id\',\'=\',1)|\n    |`<>`|`neq`, `!=`, `<>`| where(\'id\',\'<>\',1)|\n    |`>`|`gt`,`>`| where(\'id\',\'>\',1)|\n    |`>=`|`egt`,`>=`| where(\'id\',\'>=\',1)|\n    |`<`|`lt`, `<`|where(\'id\',\'<\',1)|\n    |`<=`|`elt`,`<=`| where(\'id\',\'<=\',1)|\n    |`in`|`in`,`not in`| where(\'id\',\'in\',[1,2,3])|\n    |`between`|`between`,`not between`| where(\'id\',\'between\',[1,5]) where(\'id\',\'between\',\'1,5\') where(\'id\',\'between\',\'1 and 5\')|\n    |`like`|`like`, `not like`| where(\'name\',\'like\',\'%hbh%\')|\n    |`null`|`is null`,`null`| where(\'remark\',\'is null\')|\n    |`not null`|`is not null`,`not null`| where(\'remark\',\'is not null\')|\n    |`exists`|`exists`, `not exists`| where(\'remark\',\'exists\')|\n    |`exp`|`exp`| where(\'id\',\'exp\',\'in (1,2,3)\')|\n\n- where_or(field: Union[str, list], symbol: str = \'\', value: Any = None)\n\n    > where(\'id\',1).where_or(\'id\',5)\n\n    ```\n    where id = 1 or id = 5\n    ```\n\n- limit(start: int, step: int = None)\n    LIMIT start,step\n\n- page(index: int = 1, size: int = 20)\n    LIMIT index*size-1,size\n\n- order(field: str, sort: str = \'asc\')\n    ORDER BY field sort\n\n- group(field:str)\n    GROUP BY field\n\n- field(fields: Any, exclude: bool = False)\n    SELECT fields\n    if `exclude`=True then select the fields of table (exlude:`fields`)\n\n- select(build_sql: bool = False) -> list\n    return select query result\n    if `build_sql`=True then return sql\n\n- find()\n    return select ... limit 1\n\n- value(field: str)\n    return the field of first row\n\n- column(field: str,key: str = \'\')\n\n    > column(\'name\')\n\n    return [\'hbh\',\'mondy\']\n\n    > column(\'name,score\')\n\n    return [{\'hbh\':80},{\'mondy\':88}]\n\n    > column(\'score\',\'name\')\n\n    return {\'hbh\':80, \'mondy\':88}\n\n    > column(\'id,score\',\'name\')\n\n    return {\n                \'hbh\':{\'id\':1,\'score\':80},\n                \'mondy\':{\'id\':2,\'score\':88}\n           }\n\n- alias(short_name: str = \'\')\n    set alias table_name\n\n- join(table_name: str, as_name: str = \'\', on: str = \'\', join: str = \'inner\', and_str: str = \'\')\n    - `table_name` join table_name\n    - `as_name` alias short_table_name for `table_name`\n    - `on` join condition\n    - `join` join type in \'INNER\', \'LEFT\', \'RIGHT\', \'FULL OUTER\'\n    - `and_str` and condition\n    demo\n    ```\n    db.table(\'table1\').alias(\'a\').join(\'table2\',\'b\',\'a.id=b.a_id\',\'left\').join(\'table2\',\'c\',\'c.a_id=a.id\').field(\'a.id,a.name,b.id as b_id,b.score,c.id as c_id,c.remark\').where(\'a.id\',1).find()\n    ```\n    sql\n    ```\n    SELECT\n        a.id,\n        a.name,\n        b.id AS b_id,\n        b.score,\n        c.id AS c_id,\n        c.remark\n    FROM\n        table1 AS a\n        LEFT JOIN table2 AS b ON a.id = b.a_id\n        INNER JOIN table3 AS c ON c.a_id = a.id\n    WHERE\n        a.id = 1\n        LIMIT 1\n    ```\n- union(sql1: str, sql2: str, union_all: bool = False)\n    union sql1 and sql2\n    - union_all if union_all is True then `UNION ALL`\n\n    *demo*\n    ```\n    sql1 = db.table(\'table1\').field(\'name,score\').where(\'status\',1).select(build_sql=True)\n    sql2 = db.table(\'table2\').field(\'name,score\').where(\'status\',1).select(build_sql=True)\n\n    result = db.table().union(sql1,sql2).where(\'score\',\'>\',60).select()\n    ```\n    *sql*\n    ```\n    SELECT\n\t*\n    FROM\n        ( SELECT `name`, `score` FROM table1 WHERE `status` = 1 )\n        UNION\n        ( SELECT `name`, `score` FROM table2 WHERE `status` = 1 )\n    WHERE\n        score > 60\n    ```\n\n- insert(data: Union[dict, List[dict]], replace: bool = False) -> int\n    insert data to database\n    - `data` dict: insert one record; list: insert multiple records\n    - `replace` bool if `replace` is True then use `REPLACE INTO`\n\n- update(data: dict, all_record: bool = False) -> int\n    update data\n    - `data` dict you want update data\n    - `all_record` bool if `all_record` is False then you must set update condition; if you want to update all records then you need set `all_record` = True\n\n- delete(all_record: bool = False) -> int\n    delete record\n    - `all_record` bool if `all_record` is False then you must set delete condition; if you want to delete all records then you need set `all_record` = True\n\n- inc(field: str, step: Union[str, int, float] = 1) -> int\n\n    increase `field` +`step`\n\n- dec(field: str, step: int = 1) -> int\n\n    decrease `field` -`step`\n\n- max(field: str) -> Union[int, float]\n\n    get the max value of `field`\n\n- sum(field: str) -> Union[int, float, Decimal]\n\n    get the sum value of `field`\n\n- avg(field: str) -> Union[int, float, Decimal]\n\n    get the avg value of `field`\n\n- count(field: str = \'*\') -> int\n\n    get the count of records\n\n- copy_to(new_table: str = None, create_blank_table: bool = False) -> int\n\n    copy data to `new_table`\n    - `new_table` if `new_table` is None then `new_table` will auto set like `{table_name}_copy`\n    - `create_blank_table` bool if `create_blank_table` is True then only create a blank table like current table.\n\n    *demo*\n    ```\n    db.table(\'user\').field(\'name,score\').where(\'score\',\'>\',60).copy_to(\'good_boy\')\n    ```\n\n    *sql*\n    ```\n    SELECT\n\t    `name`,\n        `score`\n    INTO `good_boy`\n    FROM\n    `user`\n    WHERE\n        score > 60\n    ```\n\n\n- insert_to(new_table: str, fields: Union[str, list, tuple] = None) -> int\n\n    ```\n    INSERT INTO {new_table} SELECT {select_fields} FROM {table} {join} WHERE {where}{group}{order}{limit}\n    ```\n\n- exists(self) -> bool\n\n    check record exists with some query conditions, it use `SELECT 1 FROM {table} {join} WHERE {where} LIMIT 1`\n\n- batch_update(data:List[dict],key:str) -> int\n\n    batch update multiple records\n\n    *demo*\n    ```\n    data = [\n        {\'id\':1,\'score\':66},\n        {\'id\':2,\'score\':59},\n        {\'id\':3,\'score\':86},\n        {\'id\':4,\'score\':90},\n    ]\n    db.table(\'user\').batch(data,key=\'id\')\n    ```\n    *sql*\n    ```\n    update `user` set score = 66 where id = 1;\n    update `user` set score = 59 where id = 2;\n    update `user` set score = 86 where id = 3;\n    update `user` set score = 90 where id = 4;\n    ```\n\n\n\n\n## Development\n\n### poetry包管理器\n[官网](https://python-poetry.org/)\n\n[Python包管理之poetry的使用](https://blog.csdn.net/zhoubihui0000/article/details/104937285)\n\n[Python包管理之poetry基本使用](https://zhuanlan.zhihu.com/p/110721747)\n\n\n```\n# 配置虚拟环境在项目目录下\npoetry config virtualenvs.path true\n# 安装依赖\npoetry install\n# 进入虚拟环境\npoetry shell\n```\n### poetry command\n\n|名称| 功能|\n|-|-|\n|new|创建一个项目脚手架，包含基本结构、pyproject.toml 文件|\n|init|基于已有的项目代码创建 pyproject.toml 文件，支持交互式填写|\n|install|安装依赖库|\n|update|更新依赖库|\n|add|添加依赖库|\n|remove|移除依赖库|\n|show|查看具体依赖库信息，支持显示树形依赖链|\n|build|构建 tar.gz 或 wheel 包|\n|publish|发布到 PyPI|\n|run|运行脚本和代码|\n\n## unit test\n```\npytest --cov --cov-report=html\n```\n\n## publish\n```\npoetry build\npoetry config pypi-token.pypi "your pypi.org api token"\npoetry publish -n\n```\n',
    'author': 'hbh112233abc',
    'author_email': 'hbh112233abc@163.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/hbh112233abc/think-sql',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
