# WARNING: Please don't edit this file. It was generated by Python/WinRT v1.0.0-beta.7

import enum
import datetime
import sys
import types
import typing

import winsdk._winrt as _winrt
import winsdk.windows.applicationmodel.appservice
import winsdk.windows.foundation
import winsdk.windows.foundation.collections
import winsdk.windows.graphics.directx.direct3d11
import winsdk.windows.graphics.imaging
import winsdk.windows.media.capture
import winsdk.windows.media.capture.frames
import winsdk.windows.media.devices
import winsdk.windows.media.devices.core
import winsdk.windows.media.faceanalysis
import winsdk.windows.media.mediaproperties
import winsdk.windows.media.playback
import winsdk.windows.media.protection
import winsdk.windows.media.streaming.adaptive
import winsdk.windows.networking.backgroundtransfer
import winsdk.windows.storage
import winsdk.windows.storage.fileproperties
import winsdk.windows.storage.streams
import winsdk.windows.ui

class AudioDecoderDegradation(enum.IntEnum):
    NONE = 0
    DOWNMIX_TO2_CHANNELS = 1
    DOWNMIX_TO6_CHANNELS = 2
    DOWNMIX_TO8_CHANNELS = 3

class AudioDecoderDegradationReason(enum.IntEnum):
    NONE = 0
    LICENSING_REQUIREMENT = 1
    SPATIAL_AUDIO_NOT_SUPPORTED = 2

class CodecCategory(enum.IntEnum):
    ENCODER = 0
    DECODER = 1

class CodecKind(enum.IntEnum):
    AUDIO = 0
    VIDEO = 1

class FaceDetectionMode(enum.IntEnum):
    HIGH_PERFORMANCE = 0
    BALANCED = 1
    HIGH_QUALITY = 2

class MediaDecoderStatus(enum.IntEnum):
    FULLY_SUPPORTED = 0
    UNSUPPORTED_SUBTYPE = 1
    UNSUPPORTED_ENCODER_PROPERTIES = 2
    DEGRADED = 3

class MediaSourceState(enum.IntEnum):
    INITIAL = 0
    OPENING = 1
    OPENED = 2
    FAILED = 3
    CLOSED = 4

class MediaSourceStatus(enum.IntEnum):
    FULLY_SUPPORTED = 0
    UNKNOWN = 1

class MediaStreamSourceClosedReason(enum.IntEnum):
    DONE = 0
    UNKNOWN_ERROR = 1
    APP_REPORTED_ERROR = 2
    UNSUPPORTED_PROTECTION_SYSTEM = 3
    PROTECTION_SYSTEM_FAILURE = 4
    UNSUPPORTED_ENCODING_FORMAT = 5
    MISSING_SAMPLE_REQUESTED_EVENT_HANDLER = 6

class MediaStreamSourceErrorStatus(enum.IntEnum):
    OTHER = 0
    OUT_OF_MEMORY = 1
    FAILED_TO_OPEN_FILE = 2
    FAILED_TO_CONNECT_TO_SERVER = 3
    CONNECTION_TO_SERVER_LOST = 4
    UNSPECIFIED_NETWORK_ERROR = 5
    DECODE_ERROR = 6
    UNSUPPORTED_MEDIA_FORMAT = 7

class MediaTrackKind(enum.IntEnum):
    AUDIO = 0
    VIDEO = 1
    TIMED_METADATA = 2

class MseAppendMode(enum.IntEnum):
    SEGMENTS = 0
    SEQUENCE = 1

class MseEndOfStreamStatus(enum.IntEnum):
    SUCCESS = 0
    NETWORK_ERROR = 1
    DECODE_ERROR = 2
    UNKNOWN_ERROR = 3

class MseReadyState(enum.IntEnum):
    CLOSED = 0
    OPEN = 1
    ENDED = 2

class SceneAnalysisRecommendation(enum.IntEnum):
    STANDARD = 0
    HDR = 1
    LOW_LIGHT = 2

class TimedMetadataKind(enum.IntEnum):
    CAPTION = 0
    CHAPTER = 1
    CUSTOM = 2
    DATA = 3
    DESCRIPTION = 4
    SUBTITLE = 5
    IMAGE_SUBTITLE = 6
    SPEECH = 7

class TimedMetadataTrackErrorCode(enum.IntEnum):
    NONE = 0
    DATA_FORMAT_ERROR = 1
    NETWORK_ERROR = 2
    INTERNAL_ERROR = 3

class TimedTextBoutenPosition(enum.IntEnum):
    BEFORE = 0
    AFTER = 1
    OUTSIDE = 2

class TimedTextBoutenType(enum.IntEnum):
    NONE = 0
    AUTO = 1
    FILLED_CIRCLE = 2
    OPEN_CIRCLE = 3
    FILLED_DOT = 4
    OPEN_DOT = 5
    FILLED_SESAME = 6
    OPEN_SESAME = 7

class TimedTextDisplayAlignment(enum.IntEnum):
    BEFORE = 0
    AFTER = 1
    CENTER = 2

class TimedTextFlowDirection(enum.IntEnum):
    LEFT_TO_RIGHT = 0
    RIGHT_TO_LEFT = 1

class TimedTextFontStyle(enum.IntEnum):
    NORMAL = 0
    OBLIQUE = 1
    ITALIC = 2

class TimedTextLineAlignment(enum.IntEnum):
    START = 0
    END = 1
    CENTER = 2

class TimedTextRubyAlign(enum.IntEnum):
    CENTER = 0
    START = 1
    END = 2
    SPACE_AROUND = 3
    SPACE_BETWEEN = 4
    WITH_BASE = 5

class TimedTextRubyPosition(enum.IntEnum):
    BEFORE = 0
    AFTER = 1
    OUTSIDE = 2

class TimedTextRubyReserve(enum.IntEnum):
    NONE = 0
    BEFORE = 1
    AFTER = 2
    BOTH = 3
    OUTSIDE = 4

class TimedTextScrollMode(enum.IntEnum):
    POPON = 0
    ROLLUP = 1

class TimedTextUnit(enum.IntEnum):
    PIXELS = 0
    PERCENTAGE = 1

class TimedTextWeight(enum.IntEnum):
    NORMAL = 400
    BOLD = 700

class TimedTextWrapping(enum.IntEnum):
    NO_WRAP = 0
    WRAP = 1

class TimedTextWritingMode(enum.IntEnum):
    LEFT_RIGHT_TOP_BOTTOM = 0
    RIGHT_LEFT_TOP_BOTTOM = 1
    TOP_BOTTOM_RIGHT_LEFT = 2
    TOP_BOTTOM_LEFT_RIGHT = 3
    LEFT_RIGHT = 4
    RIGHT_LEFT = 5
    TOP_BOTTOM = 6

class VideoStabilizationEffectEnabledChangedReason(enum.IntEnum):
    PROGRAMMATIC = 0
    PIXEL_RATE_TOO_HIGH = 1
    RUNNING_SLOWLY = 2

Self = typing.TypeVar('Self')

class MseTimeRange:
    start: datetime.timedelta
    end: datetime.timedelta
    def __new__(cls: typing.Type[MseTimeRange], start: datetime.timedelta, end: datetime.timedelta) -> MseTimeRange: ...

class TimedTextDouble:
    value: _winrt.Double
    unit: TimedTextUnit
    def __new__(cls: typing.Type[TimedTextDouble], value: _winrt.Double, unit: TimedTextUnit) -> TimedTextDouble: ...

class TimedTextPadding:
    before: _winrt.Double
    after: _winrt.Double
    start: _winrt.Double
    end: _winrt.Double
    unit: TimedTextUnit
    def __new__(cls: typing.Type[TimedTextPadding], before: _winrt.Double, after: _winrt.Double, start: _winrt.Double, end: _winrt.Double, unit: TimedTextUnit) -> TimedTextPadding: ...

class TimedTextPoint:
    x: _winrt.Double
    y: _winrt.Double
    unit: TimedTextUnit
    def __new__(cls: typing.Type[TimedTextPoint], x: _winrt.Double, y: _winrt.Double, unit: TimedTextUnit) -> TimedTextPoint: ...

class TimedTextSize:
    height: _winrt.Double
    width: _winrt.Double
    unit: TimedTextUnit
    def __new__(cls: typing.Type[TimedTextSize], height: _winrt.Double, width: _winrt.Double, unit: TimedTextUnit) -> TimedTextSize: ...

class AudioStreamDescriptor(_winrt.Object):
    encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties]
    trailing_encoder_padding: typing.Optional[typing.Optional[_winrt.UInt32]]
    leading_encoder_padding: typing.Optional[typing.Optional[_winrt.UInt32]]
    name: str
    language: str
    is_selected: _winrt.Boolean
    label: str
    @staticmethod
    def _from(obj: _winrt.Object) -> AudioStreamDescriptor: ...
    def __new__(cls: typing.Type[AudioStreamDescriptor], encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties]) -> AudioStreamDescriptor:...
    def copy(self) -> typing.Optional[AudioStreamDescriptor]: ...

class AudioTrack(_winrt.Object):
    name: str
    playback_item: typing.Optional[winsdk.windows.media.playback.MediaPlaybackItem]
    support_info: typing.Optional[AudioTrackSupportInfo]
    label: str
    id: str
    language: str
    track_kind: MediaTrackKind
    @staticmethod
    def _from(obj: _winrt.Object) -> AudioTrack: ...
    def get_encoding_properties(self) -> typing.Optional[winsdk.windows.media.mediaproperties.AudioEncodingProperties]: ...
    def add_open_failed(self, handler: winsdk.windows.foundation.TypedEventHandler[AudioTrack, AudioTrackOpenFailedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_open_failed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class AudioTrackOpenFailedEventArgs(_winrt.Object):
    extended_error: winsdk.windows.foundation.HResult
    @staticmethod
    def _from(obj: _winrt.Object) -> AudioTrackOpenFailedEventArgs: ...

class AudioTrackSupportInfo(_winrt.Object):
    decoder_status: MediaDecoderStatus
    degradation: AudioDecoderDegradation
    degradation_reason: AudioDecoderDegradationReason
    media_source_status: MediaSourceStatus
    @staticmethod
    def _from(obj: _winrt.Object) -> AudioTrackSupportInfo: ...

class ChapterCue(_winrt.Object):
    title: str
    start_time: datetime.timedelta
    id: str
    duration: datetime.timedelta
    @staticmethod
    def _from(obj: _winrt.Object) -> ChapterCue: ...
    def __new__(cls: typing.Type[ChapterCue]) -> ChapterCue:...

class CodecInfo(_winrt.Object):
    category: CodecCategory
    display_name: str
    is_trusted: _winrt.Boolean
    kind: CodecKind
    subtypes: typing.Optional[winsdk.windows.foundation.collections.IVectorView[str]]
    @staticmethod
    def _from(obj: _winrt.Object) -> CodecInfo: ...

class CodecQuery(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> CodecQuery: ...
    def __new__(cls: typing.Type[CodecQuery]) -> CodecQuery:...
    def find_all_async(self, kind: CodecKind, category: CodecCategory, sub_type: str) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.foundation.collections.IVectorView[CodecInfo]]: ...

class CodecSubtypes(_winrt.Object):
    audio_format_aac: str
    audio_format_adts: str
    audio_format_alac: str
    audio_format_amr_n_b: str
    audio_format_amr_w_b: str
    audio_format_amr_w_p: str
    audio_format_dolby_a_c3: str
    audio_format_dolby_a_c3_spdif: str
    audio_format_dolby_d_d_plus: str
    audio_format_drm: str
    audio_format_dts: str
    audio_format_flac: str
    audio_format_float: str
    audio_format_m_p3: str
    audio_format_m_peg: str
    audio_format_msp1: str
    audio_format_opus: str
    audio_format_pcm: str
    audio_format_w_m_audio_lossless: str
    audio_format_w_m_audio_v8: str
    audio_format_w_m_audio_v9: str
    audio_format_wma_spdif: str
    video_format420_o: str
    video_format_d_v25: str
    video_format_d_v50: str
    video_format_dvc: str
    video_format_dvh1: str
    video_format_dvh_d: str
    video_format_dvsd: str
    video_format_dvsl: str
    video_format_h263: str
    video_format_h264: str
    video_format_h264_e_s: str
    video_format_h265: str
    video_format_hevc: str
    video_format_hevc_e_s: str
    video_format_m4_s2: str
    video_format_m_p43: str
    video_format_m_p4_s: str
    video_format_m_p4_v: str
    video_format_mjpg: str
    video_format_mpeg2: str
    video_format_mpg1: str
    video_format_mss1: str
    video_format_mss2: str
    video_format_v_p80: str
    video_format_v_p90: str
    video_format_wmv1: str
    video_format_wmv2: str
    video_format_wmv3: str
    video_format_wvc1: str
    @staticmethod
    def _from(obj: _winrt.Object) -> CodecSubtypes: ...

class DataCue(_winrt.Object):
    data: typing.Optional[winsdk.windows.storage.streams.IBuffer]
    properties: typing.Optional[winsdk.windows.foundation.collections.PropertySet]
    start_time: datetime.timedelta
    id: str
    duration: datetime.timedelta
    @staticmethod
    def _from(obj: _winrt.Object) -> DataCue: ...
    def __new__(cls: typing.Type[DataCue]) -> DataCue:...

class FaceDetectedEventArgs(_winrt.Object):
    result_frame: typing.Optional[FaceDetectionEffectFrame]
    @staticmethod
    def _from(obj: _winrt.Object) -> FaceDetectedEventArgs: ...

class FaceDetectionEffect(_winrt.Object):
    enabled: _winrt.Boolean
    desired_detection_interval: datetime.timedelta
    @staticmethod
    def _from(obj: _winrt.Object) -> FaceDetectionEffect: ...
    def set_properties(self, configuration: typing.Optional[winsdk.windows.foundation.collections.IPropertySet]) -> None: ...
    def add_face_detected(self, handler: winsdk.windows.foundation.TypedEventHandler[FaceDetectionEffect, FaceDetectedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_face_detected(self, cookie: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class FaceDetectionEffectDefinition(_winrt.Object):
    synchronous_detection_enabled: _winrt.Boolean
    detection_mode: FaceDetectionMode
    activatable_class_id: str
    properties: typing.Optional[winsdk.windows.foundation.collections.IPropertySet]
    @staticmethod
    def _from(obj: _winrt.Object) -> FaceDetectionEffectDefinition: ...
    def __new__(cls: typing.Type[FaceDetectionEffectDefinition]) -> FaceDetectionEffectDefinition:...

class FaceDetectionEffectFrame(_winrt.Object):
    detected_faces: typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.windows.media.faceanalysis.DetectedFace]]
    system_relative_time: typing.Optional[typing.Optional[datetime.timedelta]]
    relative_time: typing.Optional[typing.Optional[datetime.timedelta]]
    is_discontinuous: _winrt.Boolean
    duration: typing.Optional[typing.Optional[datetime.timedelta]]
    extended_properties: typing.Optional[winsdk.windows.foundation.collections.IPropertySet]
    is_read_only: _winrt.Boolean
    type: str
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: _winrt.Object) -> FaceDetectionEffectFrame: ...
    def close(self) -> None: ...

class HighDynamicRangeControl(_winrt.Object):
    enabled: _winrt.Boolean
    @staticmethod
    def _from(obj: _winrt.Object) -> HighDynamicRangeControl: ...

class HighDynamicRangeOutput(_winrt.Object):
    certainty: _winrt.Double
    frame_controllers: typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.windows.media.devices.core.FrameController]]
    @staticmethod
    def _from(obj: _winrt.Object) -> HighDynamicRangeOutput: ...

class ImageCue(_winrt.Object):
    software_bitmap: typing.Optional[winsdk.windows.graphics.imaging.SoftwareBitmap]
    position: TimedTextPoint
    extent: TimedTextSize
    start_time: datetime.timedelta
    id: str
    duration: datetime.timedelta
    @staticmethod
    def _from(obj: _winrt.Object) -> ImageCue: ...
    def __new__(cls: typing.Type[ImageCue]) -> ImageCue:...

class InitializeMediaStreamSourceRequestedEventArgs(_winrt.Object):
    random_access_stream: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStream]
    source: typing.Optional[MediaStreamSource]
    @staticmethod
    def _from(obj: _winrt.Object) -> InitializeMediaStreamSourceRequestedEventArgs: ...
    def get_deferral(self) -> typing.Optional[winsdk.windows.foundation.Deferral]: ...

class LowLightFusion(_winrt.Object):
    max_supported_frame_count: _winrt.Int32
    supported_bitmap_pixel_formats: typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.windows.graphics.imaging.BitmapPixelFormat]]
    @staticmethod
    def _from(obj: _winrt.Object) -> LowLightFusion: ...
    @staticmethod
    def fuse_async(frame_set: typing.Iterable[winsdk.windows.graphics.imaging.SoftwareBitmap]) -> winsdk.windows.foundation.IAsyncOperationWithProgress[LowLightFusionResult, _winrt.Double]: ...

class LowLightFusionResult(_winrt.Object):
    frame: typing.Optional[winsdk.windows.graphics.imaging.SoftwareBitmap]
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: _winrt.Object) -> LowLightFusionResult: ...
    def close(self) -> None: ...

class MediaBinder(_winrt.Object):
    token: str
    source: typing.Optional[MediaSource]
    @staticmethod
    def _from(obj: _winrt.Object) -> MediaBinder: ...
    def __new__(cls: typing.Type[MediaBinder]) -> MediaBinder:...
    def add_binding(self, handler: winsdk.windows.foundation.TypedEventHandler[MediaBinder, MediaBindingEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_binding(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class MediaBindingEventArgs(_winrt.Object):
    media_binder: typing.Optional[MediaBinder]
    @staticmethod
    def _from(obj: _winrt.Object) -> MediaBindingEventArgs: ...
    def get_deferral(self) -> typing.Optional[winsdk.windows.foundation.Deferral]: ...
    def set_adaptive_media_source(self, media_source: typing.Optional[winsdk.windows.media.streaming.adaptive.AdaptiveMediaSource]) -> None: ...
    def set_download_operation(self, download_operation: typing.Optional[winsdk.windows.networking.backgroundtransfer.DownloadOperation]) -> None: ...
    def set_storage_file(self, file: typing.Optional[winsdk.windows.storage.IStorageFile]) -> None: ...
    def set_stream(self, stream: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStream], content_type: str) -> None: ...
    def set_stream_reference(self, stream: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStreamReference], content_type: str) -> None: ...
    def set_uri(self, uri: typing.Optional[winsdk.windows.foundation.Uri]) -> None: ...
    def add_canceled(self, handler: winsdk.windows.foundation.TypedEventHandler[MediaBindingEventArgs, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_canceled(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class MediaCueEventArgs(_winrt.Object):
    cue: typing.Optional[IMediaCue]
    @staticmethod
    def _from(obj: _winrt.Object) -> MediaCueEventArgs: ...

class MediaSource(_winrt.Object):
    custom_properties: typing.Optional[winsdk.windows.foundation.collections.ValueSet]
    duration: typing.Optional[typing.Optional[datetime.timedelta]]
    external_timed_metadata_tracks: typing.Optional[winsdk.windows.foundation.collections.IObservableVector[TimedMetadataTrack]]
    external_timed_text_sources: typing.Optional[winsdk.windows.foundation.collections.IObservableVector[TimedTextSource]]
    is_open: _winrt.Boolean
    state: MediaSourceState
    adaptive_media_source: typing.Optional[winsdk.windows.media.streaming.adaptive.AdaptiveMediaSource]
    media_stream_source: typing.Optional[MediaStreamSource]
    mse_stream_source: typing.Optional[MseStreamSource]
    uri: typing.Optional[winsdk.windows.foundation.Uri]
    download_operation: typing.Optional[winsdk.windows.networking.backgroundtransfer.DownloadOperation]
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: _winrt.Object) -> MediaSource: ...
    def close(self) -> None: ...
    @staticmethod
    def create_from_adaptive_media_source(media_source: typing.Optional[winsdk.windows.media.streaming.adaptive.AdaptiveMediaSource]) -> typing.Optional[MediaSource]: ...
    @staticmethod
    def create_from_download_operation(download_operation: typing.Optional[winsdk.windows.networking.backgroundtransfer.DownloadOperation]) -> typing.Optional[MediaSource]: ...
    @staticmethod
    def create_from_i_media_source(media_source: typing.Optional[IMediaSource]) -> typing.Optional[MediaSource]: ...
    @staticmethod
    def create_from_media_binder(binder: typing.Optional[MediaBinder]) -> typing.Optional[MediaSource]: ...
    @staticmethod
    def create_from_media_frame_source(frame_source: typing.Optional[winsdk.windows.media.capture.frames.MediaFrameSource]) -> typing.Optional[MediaSource]: ...
    @staticmethod
    def create_from_media_stream_source(media_source: typing.Optional[MediaStreamSource]) -> typing.Optional[MediaSource]: ...
    @staticmethod
    def create_from_mse_stream_source(media_source: typing.Optional[MseStreamSource]) -> typing.Optional[MediaSource]: ...
    @staticmethod
    def create_from_storage_file(file: typing.Optional[winsdk.windows.storage.IStorageFile]) -> typing.Optional[MediaSource]: ...
    @staticmethod
    def create_from_stream(stream: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStream], content_type: str) -> typing.Optional[MediaSource]: ...
    @staticmethod
    def create_from_stream_reference(stream: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStreamReference], content_type: str) -> typing.Optional[MediaSource]: ...
    @staticmethod
    def create_from_uri(uri: typing.Optional[winsdk.windows.foundation.Uri]) -> typing.Optional[MediaSource]: ...
    def open_async(self) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    def reset(self) -> None: ...
    def add_open_operation_completed(self, handler: winsdk.windows.foundation.TypedEventHandler[MediaSource, MediaSourceOpenOperationCompletedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_open_operation_completed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_state_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[MediaSource, MediaSourceStateChangedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_state_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class MediaSourceAppServiceConnection(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> MediaSourceAppServiceConnection: ...
    def __new__(cls: typing.Type[MediaSourceAppServiceConnection], app_service_connection: typing.Optional[winsdk.windows.applicationmodel.appservice.AppServiceConnection]) -> MediaSourceAppServiceConnection:...
    def start(self) -> None: ...
    def add_initialize_media_stream_source_requested(self, handler: winsdk.windows.foundation.TypedEventHandler[MediaSourceAppServiceConnection, InitializeMediaStreamSourceRequestedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_initialize_media_stream_source_requested(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class MediaSourceError(_winrt.Object):
    extended_error: winsdk.windows.foundation.HResult
    @staticmethod
    def _from(obj: _winrt.Object) -> MediaSourceError: ...

class MediaSourceOpenOperationCompletedEventArgs(_winrt.Object):
    error: typing.Optional[MediaSourceError]
    @staticmethod
    def _from(obj: _winrt.Object) -> MediaSourceOpenOperationCompletedEventArgs: ...

class MediaSourceStateChangedEventArgs(_winrt.Object):
    new_state: MediaSourceState
    old_state: MediaSourceState
    @staticmethod
    def _from(obj: _winrt.Object) -> MediaSourceStateChangedEventArgs: ...

class MediaStreamSample(_winrt.Object):
    key_frame: _winrt.Boolean
    duration: datetime.timedelta
    discontinuous: _winrt.Boolean
    decode_timestamp: datetime.timedelta
    buffer: typing.Optional[winsdk.windows.storage.streams.Buffer]
    extended_properties: typing.Optional[MediaStreamSamplePropertySet]
    protection: typing.Optional[MediaStreamSampleProtectionProperties]
    timestamp: datetime.timedelta
    direct3_d11_surface: typing.Optional[winsdk.windows.graphics.directx.direct3d11.IDirect3DSurface]
    @staticmethod
    def _from(obj: _winrt.Object) -> MediaStreamSample: ...
    @staticmethod
    def create_from_buffer(buffer: typing.Optional[winsdk.windows.storage.streams.IBuffer], timestamp: datetime.timedelta) -> typing.Optional[MediaStreamSample]: ...
    @staticmethod
    def create_from_direct3_d11_surface(surface: typing.Optional[winsdk.windows.graphics.directx.direct3d11.IDirect3DSurface], timestamp: datetime.timedelta) -> typing.Optional[MediaStreamSample]: ...
    @staticmethod
    def create_from_stream_async(stream: typing.Optional[winsdk.windows.storage.streams.IInputStream], count: _winrt.UInt32, timestamp: datetime.timedelta) -> winsdk.windows.foundation.IAsyncOperation[MediaStreamSample]: ...
    def add_processed(self, handler: winsdk.windows.foundation.TypedEventHandler[MediaStreamSample, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_processed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class MediaStreamSamplePropertySet(_winrt.Object, typing.MutableMapping[_winrt.Guid, _winrt.Object]):
    size: _winrt.UInt32
    def __len__(self) -> int: ...
    def __iter__(self) -> typing.Iterator[_winrt.Guid]: ...
    def __contains__(self, key: object) -> bool:...
    def __setitem__(self, key: _winrt.Guid, value: _winrt.Object) -> None: ...
    def __getitem__(self, key: _winrt.Guid) -> _winrt.Object: ...
    def __delitem__(self, key: _winrt.Guid) -> None: ...
    @staticmethod
    def _from(obj: _winrt.Object) -> MediaStreamSamplePropertySet: ...
    def clear(self) -> None: ...
    def first(self) -> typing.Optional[winsdk.windows.foundation.collections.IIterator[winsdk.windows.foundation.collections.IKeyValuePair[_winrt.Guid, _winrt.Object]]]: ...
    def get_view(self) -> typing.Optional[winsdk.windows.foundation.collections.IMapView[_winrt.Guid, _winrt.Object]]: ...
    def has_key(self, key: _winrt.Guid) -> _winrt.Boolean: ...
    def insert(self, key: _winrt.Guid, value: typing.Optional[_winrt.Object]) -> _winrt.Boolean: ...
    def lookup(self, key: _winrt.Guid) -> typing.Optional[_winrt.Object]: ...
    def remove(self, key: _winrt.Guid) -> None: ...

class MediaStreamSampleProtectionProperties(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> MediaStreamSampleProtectionProperties: ...
    def get_initialization_vector(self) -> typing.List[_winrt.UInt8]: ...
    def get_key_identifier(self) -> typing.List[_winrt.UInt8]: ...
    def get_sub_sample_mapping(self) -> typing.List[_winrt.UInt8]: ...
    def set_initialization_vector(self, value: typing.Sequence[_winrt.UInt8]) -> None: ...
    def set_key_identifier(self, value: typing.Sequence[_winrt.UInt8]) -> None: ...
    def set_sub_sample_mapping(self, value: typing.Sequence[_winrt.UInt8]) -> None: ...

class MediaStreamSource(_winrt.Object):
    thumbnail: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStreamReference]
    media_protection_manager: typing.Optional[winsdk.windows.media.protection.MediaProtectionManager]
    duration: datetime.timedelta
    can_seek: _winrt.Boolean
    buffer_time: datetime.timedelta
    music_properties: typing.Optional[winsdk.windows.storage.fileproperties.MusicProperties]
    video_properties: typing.Optional[winsdk.windows.storage.fileproperties.VideoProperties]
    max_supported_playback_rate: typing.Optional[typing.Optional[_winrt.Double]]
    is_live: _winrt.Boolean
    @staticmethod
    def _from(obj: _winrt.Object) -> MediaStreamSource: ...
    @typing.overload
    def __new__(cls: typing.Type[MediaStreamSource], descriptor: typing.Optional[IMediaStreamDescriptor]) -> MediaStreamSource:...
    @typing.overload
    def __new__(cls: typing.Type[MediaStreamSource], descriptor: typing.Optional[IMediaStreamDescriptor], descriptor2: typing.Optional[IMediaStreamDescriptor]) -> MediaStreamSource:...
    def add_protection_key(self, stream_descriptor: typing.Optional[IMediaStreamDescriptor], key_identifier: typing.Sequence[_winrt.UInt8], license_data: typing.Sequence[_winrt.UInt8]) -> None: ...
    def add_stream_descriptor(self, descriptor: typing.Optional[IMediaStreamDescriptor]) -> None: ...
    def notify_error(self, error_status: MediaStreamSourceErrorStatus) -> None: ...
    def set_buffered_range(self, start_offset: datetime.timedelta, end_offset: datetime.timedelta) -> None: ...
    def add_closed(self, handler: winsdk.windows.foundation.TypedEventHandler[MediaStreamSource, MediaStreamSourceClosedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_closed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_paused(self, handler: winsdk.windows.foundation.TypedEventHandler[MediaStreamSource, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_paused(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_sample_requested(self, handler: winsdk.windows.foundation.TypedEventHandler[MediaStreamSource, MediaStreamSourceSampleRequestedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_sample_requested(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_starting(self, handler: winsdk.windows.foundation.TypedEventHandler[MediaStreamSource, MediaStreamSourceStartingEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_starting(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_switch_streams_requested(self, handler: winsdk.windows.foundation.TypedEventHandler[MediaStreamSource, MediaStreamSourceSwitchStreamsRequestedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_switch_streams_requested(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_sample_rendered(self, handler: winsdk.windows.foundation.TypedEventHandler[MediaStreamSource, MediaStreamSourceSampleRenderedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_sample_rendered(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class MediaStreamSourceClosedEventArgs(_winrt.Object):
    request: typing.Optional[MediaStreamSourceClosedRequest]
    @staticmethod
    def _from(obj: _winrt.Object) -> MediaStreamSourceClosedEventArgs: ...

class MediaStreamSourceClosedRequest(_winrt.Object):
    reason: MediaStreamSourceClosedReason
    @staticmethod
    def _from(obj: _winrt.Object) -> MediaStreamSourceClosedRequest: ...

class MediaStreamSourceSampleRenderedEventArgs(_winrt.Object):
    sample_lag: datetime.timedelta
    @staticmethod
    def _from(obj: _winrt.Object) -> MediaStreamSourceSampleRenderedEventArgs: ...

class MediaStreamSourceSampleRequest(_winrt.Object):
    sample: typing.Optional[MediaStreamSample]
    stream_descriptor: typing.Optional[IMediaStreamDescriptor]
    @staticmethod
    def _from(obj: _winrt.Object) -> MediaStreamSourceSampleRequest: ...
    def get_deferral(self) -> typing.Optional[MediaStreamSourceSampleRequestDeferral]: ...
    def report_sample_progress(self, progress: _winrt.UInt32) -> None: ...

class MediaStreamSourceSampleRequestDeferral(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> MediaStreamSourceSampleRequestDeferral: ...
    def complete(self) -> None: ...

class MediaStreamSourceSampleRequestedEventArgs(_winrt.Object):
    request: typing.Optional[MediaStreamSourceSampleRequest]
    @staticmethod
    def _from(obj: _winrt.Object) -> MediaStreamSourceSampleRequestedEventArgs: ...

class MediaStreamSourceStartingEventArgs(_winrt.Object):
    request: typing.Optional[MediaStreamSourceStartingRequest]
    @staticmethod
    def _from(obj: _winrt.Object) -> MediaStreamSourceStartingEventArgs: ...

class MediaStreamSourceStartingRequest(_winrt.Object):
    start_position: typing.Optional[typing.Optional[datetime.timedelta]]
    @staticmethod
    def _from(obj: _winrt.Object) -> MediaStreamSourceStartingRequest: ...
    def get_deferral(self) -> typing.Optional[MediaStreamSourceStartingRequestDeferral]: ...
    def set_actual_start_position(self, position: datetime.timedelta) -> None: ...

class MediaStreamSourceStartingRequestDeferral(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> MediaStreamSourceStartingRequestDeferral: ...
    def complete(self) -> None: ...

class MediaStreamSourceSwitchStreamsRequest(_winrt.Object):
    new_stream_descriptor: typing.Optional[IMediaStreamDescriptor]
    old_stream_descriptor: typing.Optional[IMediaStreamDescriptor]
    @staticmethod
    def _from(obj: _winrt.Object) -> MediaStreamSourceSwitchStreamsRequest: ...
    def get_deferral(self) -> typing.Optional[MediaStreamSourceSwitchStreamsRequestDeferral]: ...

class MediaStreamSourceSwitchStreamsRequestDeferral(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> MediaStreamSourceSwitchStreamsRequestDeferral: ...
    def complete(self) -> None: ...

class MediaStreamSourceSwitchStreamsRequestedEventArgs(_winrt.Object):
    request: typing.Optional[MediaStreamSourceSwitchStreamsRequest]
    @staticmethod
    def _from(obj: _winrt.Object) -> MediaStreamSourceSwitchStreamsRequestedEventArgs: ...

class MseSourceBuffer(_winrt.Object):
    timestamp_offset: datetime.timedelta
    mode: MseAppendMode
    append_window_start: datetime.timedelta
    append_window_end: typing.Optional[typing.Optional[datetime.timedelta]]
    buffered: typing.Optional[winsdk.windows.foundation.collections.IVectorView[MseTimeRange]]
    is_updating: _winrt.Boolean
    @staticmethod
    def _from(obj: _winrt.Object) -> MseSourceBuffer: ...
    def abort(self) -> None: ...
    def append_buffer(self, buffer: typing.Optional[winsdk.windows.storage.streams.IBuffer]) -> None: ...
    @typing.overload
    def append_stream(self, stream: typing.Optional[winsdk.windows.storage.streams.IInputStream]) -> None: ...
    @typing.overload
    def append_stream(self, stream: typing.Optional[winsdk.windows.storage.streams.IInputStream], max_size: _winrt.UInt64) -> None: ...
    def remove(self, start: datetime.timedelta, end: typing.Optional[datetime.timedelta]) -> None: ...
    def add_aborted(self, handler: winsdk.windows.foundation.TypedEventHandler[MseSourceBuffer, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_aborted(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_error_occurred(self, handler: winsdk.windows.foundation.TypedEventHandler[MseSourceBuffer, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_error_occurred(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_update_ended(self, handler: winsdk.windows.foundation.TypedEventHandler[MseSourceBuffer, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_update_ended(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_update_starting(self, handler: winsdk.windows.foundation.TypedEventHandler[MseSourceBuffer, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_update_starting(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_updated(self, handler: winsdk.windows.foundation.TypedEventHandler[MseSourceBuffer, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_updated(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class MseSourceBufferList(_winrt.Object):
    buffers: typing.Optional[winsdk.windows.foundation.collections.IVectorView[MseSourceBuffer]]
    @staticmethod
    def _from(obj: _winrt.Object) -> MseSourceBufferList: ...
    def add_source_buffer_added(self, handler: winsdk.windows.foundation.TypedEventHandler[MseSourceBufferList, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_source_buffer_added(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_source_buffer_removed(self, handler: winsdk.windows.foundation.TypedEventHandler[MseSourceBufferList, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_source_buffer_removed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class MseStreamSource(_winrt.Object):
    duration: typing.Optional[typing.Optional[datetime.timedelta]]
    active_source_buffers: typing.Optional[MseSourceBufferList]
    ready_state: MseReadyState
    source_buffers: typing.Optional[MseSourceBufferList]
    live_seekable_range: typing.Optional[typing.Optional[MseTimeRange]]
    @staticmethod
    def _from(obj: _winrt.Object) -> MseStreamSource: ...
    def __new__(cls: typing.Type[MseStreamSource]) -> MseStreamSource:...
    def add_source_buffer(self, mime_type: str) -> typing.Optional[MseSourceBuffer]: ...
    def end_of_stream(self, status: MseEndOfStreamStatus) -> None: ...
    @staticmethod
    def is_content_type_supported(content_type: str) -> _winrt.Boolean: ...
    def remove_source_buffer(self, buffer: typing.Optional[MseSourceBuffer]) -> None: ...
    def add_closed(self, handler: winsdk.windows.foundation.TypedEventHandler[MseStreamSource, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_closed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_ended(self, handler: winsdk.windows.foundation.TypedEventHandler[MseStreamSource, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_ended(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_opened(self, handler: winsdk.windows.foundation.TypedEventHandler[MseStreamSource, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_opened(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class SceneAnalysisEffect(_winrt.Object):
    desired_analysis_interval: datetime.timedelta
    high_dynamic_range_analyzer: typing.Optional[HighDynamicRangeControl]
    @staticmethod
    def _from(obj: _winrt.Object) -> SceneAnalysisEffect: ...
    def set_properties(self, configuration: typing.Optional[winsdk.windows.foundation.collections.IPropertySet]) -> None: ...
    def add_scene_analyzed(self, handler: winsdk.windows.foundation.TypedEventHandler[SceneAnalysisEffect, SceneAnalyzedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_scene_analyzed(self, cookie: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class SceneAnalysisEffectDefinition(_winrt.Object):
    activatable_class_id: str
    properties: typing.Optional[winsdk.windows.foundation.collections.IPropertySet]
    @staticmethod
    def _from(obj: _winrt.Object) -> SceneAnalysisEffectDefinition: ...
    def __new__(cls: typing.Type[SceneAnalysisEffectDefinition]) -> SceneAnalysisEffectDefinition:...

class SceneAnalysisEffectFrame(_winrt.Object):
    frame_control_values: typing.Optional[winsdk.windows.media.capture.CapturedFrameControlValues]
    high_dynamic_range: typing.Optional[HighDynamicRangeOutput]
    analysis_recommendation: SceneAnalysisRecommendation
    system_relative_time: typing.Optional[typing.Optional[datetime.timedelta]]
    relative_time: typing.Optional[typing.Optional[datetime.timedelta]]
    is_discontinuous: _winrt.Boolean
    duration: typing.Optional[typing.Optional[datetime.timedelta]]
    extended_properties: typing.Optional[winsdk.windows.foundation.collections.IPropertySet]
    is_read_only: _winrt.Boolean
    type: str
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: _winrt.Object) -> SceneAnalysisEffectFrame: ...
    def close(self) -> None: ...

class SceneAnalyzedEventArgs(_winrt.Object):
    result_frame: typing.Optional[SceneAnalysisEffectFrame]
    @staticmethod
    def _from(obj: _winrt.Object) -> SceneAnalyzedEventArgs: ...

class SpeechCue(_winrt.Object):
    start_time: datetime.timedelta
    id: str
    duration: datetime.timedelta
    text: str
    start_position_in_input: typing.Optional[typing.Optional[_winrt.Int32]]
    end_position_in_input: typing.Optional[typing.Optional[_winrt.Int32]]
    @staticmethod
    def _from(obj: _winrt.Object) -> SpeechCue: ...
    def __new__(cls: typing.Type[SpeechCue]) -> SpeechCue:...

class TimedMetadataStreamDescriptor(_winrt.Object):
    name: str
    language: str
    is_selected: _winrt.Boolean
    label: str
    encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.TimedMetadataEncodingProperties]
    @staticmethod
    def _from(obj: _winrt.Object) -> TimedMetadataStreamDescriptor: ...
    def __new__(cls: typing.Type[TimedMetadataStreamDescriptor], encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.TimedMetadataEncodingProperties]) -> TimedMetadataStreamDescriptor:...
    def copy(self) -> typing.Optional[TimedMetadataStreamDescriptor]: ...

class TimedMetadataTrack(_winrt.Object):
    label: str
    id: str
    language: str
    track_kind: MediaTrackKind
    active_cues: typing.Optional[winsdk.windows.foundation.collections.IVectorView[IMediaCue]]
    cues: typing.Optional[winsdk.windows.foundation.collections.IVectorView[IMediaCue]]
    dispatch_type: str
    timed_metadata_kind: TimedMetadataKind
    name: str
    playback_item: typing.Optional[winsdk.windows.media.playback.MediaPlaybackItem]
    @staticmethod
    def _from(obj: _winrt.Object) -> TimedMetadataTrack: ...
    def __new__(cls: typing.Type[TimedMetadataTrack], id: str, language: str, kind: TimedMetadataKind) -> TimedMetadataTrack:...
    def add_cue(self, cue: typing.Optional[IMediaCue]) -> None: ...
    def remove_cue(self, cue: typing.Optional[IMediaCue]) -> None: ...
    def add_cue_entered(self, handler: winsdk.windows.foundation.TypedEventHandler[TimedMetadataTrack, MediaCueEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_cue_entered(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_cue_exited(self, handler: winsdk.windows.foundation.TypedEventHandler[TimedMetadataTrack, MediaCueEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_cue_exited(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_track_failed(self, handler: winsdk.windows.foundation.TypedEventHandler[TimedMetadataTrack, TimedMetadataTrackFailedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_track_failed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class TimedMetadataTrackError(_winrt.Object):
    error_code: TimedMetadataTrackErrorCode
    extended_error: winsdk.windows.foundation.HResult
    @staticmethod
    def _from(obj: _winrt.Object) -> TimedMetadataTrackError: ...

class TimedMetadataTrackFailedEventArgs(_winrt.Object):
    error: typing.Optional[TimedMetadataTrackError]
    @staticmethod
    def _from(obj: _winrt.Object) -> TimedMetadataTrackFailedEventArgs: ...

class TimedTextBouten(_winrt.Object):
    type: TimedTextBoutenType
    position: TimedTextBoutenPosition
    color: winsdk.windows.ui.Color
    @staticmethod
    def _from(obj: _winrt.Object) -> TimedTextBouten: ...

class TimedTextCue(_winrt.Object):
    start_time: datetime.timedelta
    id: str
    duration: datetime.timedelta
    cue_style: typing.Optional[TimedTextStyle]
    cue_region: typing.Optional[TimedTextRegion]
    lines: typing.Optional[winsdk.windows.foundation.collections.IVector[TimedTextLine]]
    @staticmethod
    def _from(obj: _winrt.Object) -> TimedTextCue: ...
    def __new__(cls: typing.Type[TimedTextCue]) -> TimedTextCue:...

class TimedTextLine(_winrt.Object):
    text: str
    subformats: typing.Optional[winsdk.windows.foundation.collections.IVector[TimedTextSubformat]]
    @staticmethod
    def _from(obj: _winrt.Object) -> TimedTextLine: ...
    def __new__(cls: typing.Type[TimedTextLine]) -> TimedTextLine:...

class TimedTextRegion(_winrt.Object):
    name: str
    line_height: TimedTextDouble
    is_overflow_clipped: _winrt.Boolean
    extent: TimedTextSize
    display_alignment: TimedTextDisplayAlignment
    padding: TimedTextPadding
    background: winsdk.windows.ui.Color
    z_index: _winrt.Int32
    writing_mode: TimedTextWritingMode
    text_wrapping: TimedTextWrapping
    scroll_mode: TimedTextScrollMode
    position: TimedTextPoint
    @staticmethod
    def _from(obj: _winrt.Object) -> TimedTextRegion: ...
    def __new__(cls: typing.Type[TimedTextRegion]) -> TimedTextRegion:...

class TimedTextRuby(_winrt.Object):
    text: str
    reserve: TimedTextRubyReserve
    position: TimedTextRubyPosition
    align: TimedTextRubyAlign
    @staticmethod
    def _from(obj: _winrt.Object) -> TimedTextRuby: ...

class TimedTextSource(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> TimedTextSource: ...
    @typing.overload
    @staticmethod
    def create_from_stream(stream: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStream]) -> typing.Optional[TimedTextSource]: ...
    @typing.overload
    @staticmethod
    def create_from_stream(stream: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStream], default_language: str) -> typing.Optional[TimedTextSource]: ...
    @typing.overload
    @staticmethod
    def create_from_stream_with_index(stream: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStream], index_stream: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStream]) -> typing.Optional[TimedTextSource]: ...
    @typing.overload
    @staticmethod
    def create_from_stream_with_index(stream: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStream], index_stream: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStream], default_language: str) -> typing.Optional[TimedTextSource]: ...
    @typing.overload
    @staticmethod
    def create_from_uri(uri: typing.Optional[winsdk.windows.foundation.Uri]) -> typing.Optional[TimedTextSource]: ...
    @typing.overload
    @staticmethod
    def create_from_uri(uri: typing.Optional[winsdk.windows.foundation.Uri], default_language: str) -> typing.Optional[TimedTextSource]: ...
    @typing.overload
    @staticmethod
    def create_from_uri_with_index(uri: typing.Optional[winsdk.windows.foundation.Uri], index_uri: typing.Optional[winsdk.windows.foundation.Uri]) -> typing.Optional[TimedTextSource]: ...
    @typing.overload
    @staticmethod
    def create_from_uri_with_index(uri: typing.Optional[winsdk.windows.foundation.Uri], index_uri: typing.Optional[winsdk.windows.foundation.Uri], default_language: str) -> typing.Optional[TimedTextSource]: ...
    def add_resolved(self, handler: winsdk.windows.foundation.TypedEventHandler[TimedTextSource, TimedTextSourceResolveResultEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_resolved(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class TimedTextSourceResolveResultEventArgs(_winrt.Object):
    error: typing.Optional[TimedMetadataTrackError]
    tracks: typing.Optional[winsdk.windows.foundation.collections.IVectorView[TimedMetadataTrack]]
    @staticmethod
    def _from(obj: _winrt.Object) -> TimedTextSourceResolveResultEventArgs: ...

class TimedTextStyle(_winrt.Object):
    line_alignment: TimedTextLineAlignment
    is_background_always_shown: _winrt.Boolean
    outline_color: winsdk.windows.ui.Color
    foreground: winsdk.windows.ui.Color
    font_weight: TimedTextWeight
    background: winsdk.windows.ui.Color
    font_size: TimedTextDouble
    font_family: str
    flow_direction: TimedTextFlowDirection
    outline_thickness: TimedTextDouble
    outline_radius: TimedTextDouble
    name: str
    is_underline_enabled: _winrt.Boolean
    is_overline_enabled: _winrt.Boolean
    is_line_through_enabled: _winrt.Boolean
    font_style: TimedTextFontStyle
    is_text_combined: _winrt.Boolean
    font_angle_in_degrees: _winrt.Double
    bouten: typing.Optional[TimedTextBouten]
    ruby: typing.Optional[TimedTextRuby]
    @staticmethod
    def _from(obj: _winrt.Object) -> TimedTextStyle: ...
    def __new__(cls: typing.Type[TimedTextStyle]) -> TimedTextStyle:...

class TimedTextSubformat(_winrt.Object):
    subformat_style: typing.Optional[TimedTextStyle]
    start_index: _winrt.Int32
    length: _winrt.Int32
    @staticmethod
    def _from(obj: _winrt.Object) -> TimedTextSubformat: ...
    def __new__(cls: typing.Type[TimedTextSubformat]) -> TimedTextSubformat:...

class VideoStabilizationEffect(_winrt.Object):
    enabled: _winrt.Boolean
    @staticmethod
    def _from(obj: _winrt.Object) -> VideoStabilizationEffect: ...
    def get_recommended_stream_configuration(self, controller: typing.Optional[winsdk.windows.media.devices.VideoDeviceController], desired_properties: typing.Optional[winsdk.windows.media.mediaproperties.VideoEncodingProperties]) -> typing.Optional[winsdk.windows.media.capture.VideoStreamConfiguration]: ...
    def set_properties(self, configuration: typing.Optional[winsdk.windows.foundation.collections.IPropertySet]) -> None: ...
    def add_enabled_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[VideoStabilizationEffect, VideoStabilizationEffectEnabledChangedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_enabled_changed(self, cookie: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class VideoStabilizationEffectDefinition(_winrt.Object):
    activatable_class_id: str
    properties: typing.Optional[winsdk.windows.foundation.collections.IPropertySet]
    @staticmethod
    def _from(obj: _winrt.Object) -> VideoStabilizationEffectDefinition: ...
    def __new__(cls: typing.Type[VideoStabilizationEffectDefinition]) -> VideoStabilizationEffectDefinition:...

class VideoStabilizationEffectEnabledChangedEventArgs(_winrt.Object):
    reason: VideoStabilizationEffectEnabledChangedReason
    @staticmethod
    def _from(obj: _winrt.Object) -> VideoStabilizationEffectEnabledChangedEventArgs: ...

class VideoStreamDescriptor(_winrt.Object):
    name: str
    language: str
    is_selected: _winrt.Boolean
    label: str
    encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.VideoEncodingProperties]
    @staticmethod
    def _from(obj: _winrt.Object) -> VideoStreamDescriptor: ...
    def __new__(cls: typing.Type[VideoStreamDescriptor], encoding_properties: typing.Optional[winsdk.windows.media.mediaproperties.VideoEncodingProperties]) -> VideoStreamDescriptor:...
    def copy(self) -> typing.Optional[VideoStreamDescriptor]: ...

class VideoTrack(_winrt.Object):
    label: str
    id: str
    language: str
    track_kind: MediaTrackKind
    name: str
    playback_item: typing.Optional[winsdk.windows.media.playback.MediaPlaybackItem]
    support_info: typing.Optional[VideoTrackSupportInfo]
    @staticmethod
    def _from(obj: _winrt.Object) -> VideoTrack: ...
    def get_encoding_properties(self) -> typing.Optional[winsdk.windows.media.mediaproperties.VideoEncodingProperties]: ...
    def add_open_failed(self, handler: winsdk.windows.foundation.TypedEventHandler[VideoTrack, VideoTrackOpenFailedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_open_failed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class VideoTrackOpenFailedEventArgs(_winrt.Object):
    extended_error: winsdk.windows.foundation.HResult
    @staticmethod
    def _from(obj: _winrt.Object) -> VideoTrackOpenFailedEventArgs: ...

class VideoTrackSupportInfo(_winrt.Object):
    decoder_status: MediaDecoderStatus
    media_source_status: MediaSourceStatus
    @staticmethod
    def _from(obj: _winrt.Object) -> VideoTrackSupportInfo: ...

class IMediaCue(_winrt.Object):
    duration: datetime.timedelta
    id: str
    start_time: datetime.timedelta
    @staticmethod
    def _from(obj: _winrt.Object) -> IMediaCue: ...

class IMediaSource(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> IMediaSource: ...

class IMediaStreamDescriptor(_winrt.Object):
    is_selected: _winrt.Boolean
    language: str
    name: str
    @staticmethod
    def _from(obj: _winrt.Object) -> IMediaStreamDescriptor: ...

class IMediaStreamDescriptor2(_winrt.Object):
    label: str
    is_selected: _winrt.Boolean
    language: str
    name: str
    @staticmethod
    def _from(obj: _winrt.Object) -> IMediaStreamDescriptor2: ...

class IMediaTrack(_winrt.Object):
    id: str
    label: str
    language: str
    track_kind: MediaTrackKind
    @staticmethod
    def _from(obj: _winrt.Object) -> IMediaTrack: ...

class ISingleSelectMediaTrackList(_winrt.Object):
    selected_index: _winrt.Int32
    @staticmethod
    def _from(obj: _winrt.Object) -> ISingleSelectMediaTrackList: ...
    def add_selected_index_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[ISingleSelectMediaTrackList, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_selected_index_changed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class ITimedMetadataTrackProvider(_winrt.Object):
    timed_metadata_tracks: typing.Optional[winsdk.windows.foundation.collections.IVectorView[TimedMetadataTrack]]
    @staticmethod
    def _from(obj: _winrt.Object) -> ITimedMetadataTrackProvider: ...

