// WARNING: Please don't edit this file. It was generated by Python/WinRT v1.0.0-beta.7

#include "pybase.h"
#include "py.Windows.Security.Credentials.h"


namespace py::cpp::Windows::Security::Credentials
{
    struct module_state
    {
        PyObject* type_KeyCredentialAttestationStatus;
        PyObject* type_KeyCredentialCreationOption;
        PyObject* type_KeyCredentialStatus;
        PyObject* type_WebAccountPictureSize;
        PyObject* type_WebAccountState;
        PyTypeObject* type_KeyCredential;
        PyTypeObject* type_KeyCredentialAttestationResult;
        PyTypeObject* type_KeyCredentialManager;
        PyTypeObject* type_KeyCredentialOperationResult;
        PyTypeObject* type_KeyCredentialRetrievalResult;
        PyTypeObject* type_PasswordCredential;
        PyTypeObject* type_PasswordCredentialPropertyStore;
        PyTypeObject* type_PasswordVault;
        PyTypeObject* type_WebAccount;
        PyTypeObject* type_WebAccountProvider;
        PyTypeObject* type_IWebAccount;
    };

    static PyObject* register_KeyCredentialAttestationStatus(PyObject* module, PyObject* type)
    {
        auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));
        assert(state);

        if (state->type_KeyCredentialAttestationStatus)
        {
            PyErr_SetString(PyExc_RuntimeError, "type has already been registered");
            return nullptr;
        }

        if (!PyType_Check(type))
        {
            PyErr_SetString(PyExc_TypeError, "argument is not a type");
            return nullptr;
        }

        state->type_KeyCredentialAttestationStatus = type;
        Py_INCREF(state->type_KeyCredentialAttestationStatus);


        Py_RETURN_NONE;
    }

    static PyObject* register_KeyCredentialCreationOption(PyObject* module, PyObject* type)
    {
        auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));
        assert(state);

        if (state->type_KeyCredentialCreationOption)
        {
            PyErr_SetString(PyExc_RuntimeError, "type has already been registered");
            return nullptr;
        }

        if (!PyType_Check(type))
        {
            PyErr_SetString(PyExc_TypeError, "argument is not a type");
            return nullptr;
        }

        state->type_KeyCredentialCreationOption = type;
        Py_INCREF(state->type_KeyCredentialCreationOption);


        Py_RETURN_NONE;
    }

    static PyObject* register_KeyCredentialStatus(PyObject* module, PyObject* type)
    {
        auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));
        assert(state);

        if (state->type_KeyCredentialStatus)
        {
            PyErr_SetString(PyExc_RuntimeError, "type has already been registered");
            return nullptr;
        }

        if (!PyType_Check(type))
        {
            PyErr_SetString(PyExc_TypeError, "argument is not a type");
            return nullptr;
        }

        state->type_KeyCredentialStatus = type;
        Py_INCREF(state->type_KeyCredentialStatus);


        Py_RETURN_NONE;
    }

    static PyObject* register_WebAccountPictureSize(PyObject* module, PyObject* type)
    {
        auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));
        assert(state);

        if (state->type_WebAccountPictureSize)
        {
            PyErr_SetString(PyExc_RuntimeError, "type has already been registered");
            return nullptr;
        }

        if (!PyType_Check(type))
        {
            PyErr_SetString(PyExc_TypeError, "argument is not a type");
            return nullptr;
        }

        state->type_WebAccountPictureSize = type;
        Py_INCREF(state->type_WebAccountPictureSize);


        Py_RETURN_NONE;
    }

    static PyObject* register_WebAccountState(PyObject* module, PyObject* type)
    {
        auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));
        assert(state);

        if (state->type_WebAccountState)
        {
            PyErr_SetString(PyExc_RuntimeError, "type has already been registered");
            return nullptr;
        }

        if (!PyType_Check(type))
        {
            PyErr_SetString(PyExc_TypeError, "argument is not a type");
            return nullptr;
        }

        state->type_WebAccountState = type;
        Py_INCREF(state->type_WebAccountState);


        Py_RETURN_NONE;
    }

    // ----- KeyCredential class --------------------
    constexpr const char* const type_name_KeyCredential = "KeyCredential";

    static PyObject* _new_KeyCredential(PyTypeObject* type, PyObject* args, PyObject* kwds) noexcept
    {
        py::set_invalid_activation_error(type_name_KeyCredential);
        return nullptr;
    }

    static void _dealloc_KeyCredential(py::wrapper::Windows::Security::Credentials::KeyCredential* self)
    {
        auto tp = Py_TYPE(self);
        self->obj = nullptr;
        tp->tp_free(self);
        Py_DECREF(tp);
    }

    static PyObject* KeyCredential_GetAttestationAsync(py::wrapper::Windows::Security::Credentials::KeyCredential* self, PyObject* args) noexcept
    {
        Py_ssize_t arg_count = PyTuple_Size(args);

        if (arg_count == 0)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Security.Credentials.KeyCredential", L"GetAttestationAsync", 0))
            {
                PyErr_SetString(PyExc_AttributeError, "method 0 args is not available in this version of Windows");
                return nullptr;
            }

            try
            {
                return py::convert(self->obj.GetAttestationAsync());
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* KeyCredential_RequestSignAsync(py::wrapper::Windows::Security::Credentials::KeyCredential* self, PyObject* args) noexcept
    {
        Py_ssize_t arg_count = PyTuple_Size(args);

        if (arg_count == 1)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Security.Credentials.KeyCredential", L"RequestSignAsync", 1))
            {
                PyErr_SetString(PyExc_AttributeError, "method 1 args is not available in this version of Windows");
                return nullptr;
            }

            try
            {
                auto param0 = py::convert_to<winrt::Windows::Storage::Streams::IBuffer>(args, 0);

                return py::convert(self->obj.RequestSignAsync(param0));
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* KeyCredential_RetrievePublicKey(py::wrapper::Windows::Security::Credentials::KeyCredential* self, PyObject* args) noexcept
    {
        Py_ssize_t arg_count = PyTuple_Size(args);

        if (arg_count == 0)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Security.Credentials.KeyCredential", L"RetrievePublicKey", 0))
            {
                PyErr_SetString(PyExc_AttributeError, "method 0 args is not available in this version of Windows");
                return nullptr;
            }

            try
            {
                return py::convert(self->obj.RetrievePublicKey());
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else if (arg_count == 1)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Security.Credentials.KeyCredential", L"RetrievePublicKey", 1))
            {
                PyErr_SetString(PyExc_AttributeError, "method 1 args is not available in this version of Windows");
                return nullptr;
            }

            try
            {
                auto param0 = py::convert_to<winrt::Windows::Security::Cryptography::Core::CryptographicPublicKeyBlobType>(args, 0);

                return py::convert(self->obj.RetrievePublicKey(param0));
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* KeyCredential_get_Name(py::wrapper::Windows::Security::Credentials::KeyCredential* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.KeyCredential", L"Name"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.Name());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* _from_KeyCredential(PyObject* /*unused*/, PyObject* arg) noexcept
    {
        try
        {
            auto return_value = py::convert_to<winrt::Windows::Foundation::IInspectable>(arg);
            return py::convert(return_value.as<winrt::Windows::Security::Credentials::KeyCredential>());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyMethodDef _methods_KeyCredential[] = {
        { "get_attestation_async", reinterpret_cast<PyCFunction>(KeyCredential_GetAttestationAsync), METH_VARARGS, nullptr },
        { "request_sign_async", reinterpret_cast<PyCFunction>(KeyCredential_RequestSignAsync), METH_VARARGS, nullptr },
        { "retrieve_public_key", reinterpret_cast<PyCFunction>(KeyCredential_RetrievePublicKey), METH_VARARGS, nullptr },
        { "_from", reinterpret_cast<PyCFunction>(_from_KeyCredential), METH_O | METH_STATIC, nullptr },
        { }
    };

    static PyGetSetDef _getset_KeyCredential[] = {
        { "name", reinterpret_cast<getter>(KeyCredential_get_Name), nullptr, nullptr, nullptr },
        { }
    };

    static PyType_Slot _type_slots_KeyCredential[] = 
    {
        { Py_tp_new, _new_KeyCredential },
        { Py_tp_dealloc, _dealloc_KeyCredential },
        { Py_tp_methods, _methods_KeyCredential },
        { Py_tp_getset, _getset_KeyCredential },
        { },
    };

    static PyType_Spec type_spec_KeyCredential =
    {
        "_winsdk_Windows_Security_Credentials.KeyCredential",
        sizeof(py::wrapper::Windows::Security::Credentials::KeyCredential),
        0,
        Py_TPFLAGS_DEFAULT,
        _type_slots_KeyCredential
    };

    // ----- KeyCredentialAttestationResult class --------------------
    constexpr const char* const type_name_KeyCredentialAttestationResult = "KeyCredentialAttestationResult";

    static PyObject* _new_KeyCredentialAttestationResult(PyTypeObject* type, PyObject* args, PyObject* kwds) noexcept
    {
        py::set_invalid_activation_error(type_name_KeyCredentialAttestationResult);
        return nullptr;
    }

    static void _dealloc_KeyCredentialAttestationResult(py::wrapper::Windows::Security::Credentials::KeyCredentialAttestationResult* self)
    {
        auto tp = Py_TYPE(self);
        self->obj = nullptr;
        tp->tp_free(self);
        Py_DECREF(tp);
    }

    static PyObject* KeyCredentialAttestationResult_get_AttestationBuffer(py::wrapper::Windows::Security::Credentials::KeyCredentialAttestationResult* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.KeyCredentialAttestationResult", L"AttestationBuffer"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.AttestationBuffer());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* KeyCredentialAttestationResult_get_CertificateChainBuffer(py::wrapper::Windows::Security::Credentials::KeyCredentialAttestationResult* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.KeyCredentialAttestationResult", L"CertificateChainBuffer"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.CertificateChainBuffer());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* KeyCredentialAttestationResult_get_Status(py::wrapper::Windows::Security::Credentials::KeyCredentialAttestationResult* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.KeyCredentialAttestationResult", L"Status"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.Status());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* _from_KeyCredentialAttestationResult(PyObject* /*unused*/, PyObject* arg) noexcept
    {
        try
        {
            auto return_value = py::convert_to<winrt::Windows::Foundation::IInspectable>(arg);
            return py::convert(return_value.as<winrt::Windows::Security::Credentials::KeyCredentialAttestationResult>());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyMethodDef _methods_KeyCredentialAttestationResult[] = {
        { "_from", reinterpret_cast<PyCFunction>(_from_KeyCredentialAttestationResult), METH_O | METH_STATIC, nullptr },
        { }
    };

    static PyGetSetDef _getset_KeyCredentialAttestationResult[] = {
        { "attestation_buffer", reinterpret_cast<getter>(KeyCredentialAttestationResult_get_AttestationBuffer), nullptr, nullptr, nullptr },
        { "certificate_chain_buffer", reinterpret_cast<getter>(KeyCredentialAttestationResult_get_CertificateChainBuffer), nullptr, nullptr, nullptr },
        { "status", reinterpret_cast<getter>(KeyCredentialAttestationResult_get_Status), nullptr, nullptr, nullptr },
        { }
    };

    static PyType_Slot _type_slots_KeyCredentialAttestationResult[] = 
    {
        { Py_tp_new, _new_KeyCredentialAttestationResult },
        { Py_tp_dealloc, _dealloc_KeyCredentialAttestationResult },
        { Py_tp_methods, _methods_KeyCredentialAttestationResult },
        { Py_tp_getset, _getset_KeyCredentialAttestationResult },
        { },
    };

    static PyType_Spec type_spec_KeyCredentialAttestationResult =
    {
        "_winsdk_Windows_Security_Credentials.KeyCredentialAttestationResult",
        sizeof(py::wrapper::Windows::Security::Credentials::KeyCredentialAttestationResult),
        0,
        Py_TPFLAGS_DEFAULT,
        _type_slots_KeyCredentialAttestationResult
    };

    // ----- KeyCredentialManager class --------------------
    constexpr const char* const type_name_KeyCredentialManager = "KeyCredentialManager";

    static PyObject* _new_KeyCredentialManager(PyTypeObject* type, PyObject* args, PyObject* kwds) noexcept
    {
        py::set_invalid_activation_error(type_name_KeyCredentialManager);
        return nullptr;
    }

    static PyObject* KeyCredentialManager_DeleteAsync(PyObject* /*unused*/, PyObject* args) noexcept
    {
        Py_ssize_t arg_count = PyTuple_Size(args);

        if (arg_count == 1)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Security.Credentials.KeyCredentialManager", L"DeleteAsync", 1))
            {
                PyErr_SetString(PyExc_AttributeError, "method 1 args is not available in this version of Windows");
                return nullptr;
            }

            try
            {
                auto param0 = py::convert_to<winrt::hstring>(args, 0);

                return py::convert(winrt::Windows::Security::Credentials::KeyCredentialManager::DeleteAsync(param0));
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* KeyCredentialManager_IsSupportedAsync(PyObject* /*unused*/, PyObject* args) noexcept
    {
        Py_ssize_t arg_count = PyTuple_Size(args);

        if (arg_count == 0)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Security.Credentials.KeyCredentialManager", L"IsSupportedAsync", 0))
            {
                PyErr_SetString(PyExc_AttributeError, "method 0 args is not available in this version of Windows");
                return nullptr;
            }

            try
            {
                return py::convert(winrt::Windows::Security::Credentials::KeyCredentialManager::IsSupportedAsync());
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* KeyCredentialManager_OpenAsync(PyObject* /*unused*/, PyObject* args) noexcept
    {
        Py_ssize_t arg_count = PyTuple_Size(args);

        if (arg_count == 1)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Security.Credentials.KeyCredentialManager", L"OpenAsync", 1))
            {
                PyErr_SetString(PyExc_AttributeError, "method 1 args is not available in this version of Windows");
                return nullptr;
            }

            try
            {
                auto param0 = py::convert_to<winrt::hstring>(args, 0);

                return py::convert(winrt::Windows::Security::Credentials::KeyCredentialManager::OpenAsync(param0));
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* KeyCredentialManager_RenewAttestationAsync(PyObject* /*unused*/, PyObject* args) noexcept
    {
        Py_ssize_t arg_count = PyTuple_Size(args);

        if (arg_count == 0)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Security.Credentials.KeyCredentialManager", L"RenewAttestationAsync", 0))
            {
                PyErr_SetString(PyExc_AttributeError, "method 0 args is not available in this version of Windows");
                return nullptr;
            }

            try
            {
                return py::convert(winrt::Windows::Security::Credentials::KeyCredentialManager::RenewAttestationAsync());
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* KeyCredentialManager_RequestCreateAsync(PyObject* /*unused*/, PyObject* args) noexcept
    {
        Py_ssize_t arg_count = PyTuple_Size(args);

        if (arg_count == 2)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Security.Credentials.KeyCredentialManager", L"RequestCreateAsync", 2))
            {
                PyErr_SetString(PyExc_AttributeError, "method 2 args is not available in this version of Windows");
                return nullptr;
            }

            try
            {
                auto param0 = py::convert_to<winrt::hstring>(args, 0);
                auto param1 = py::convert_to<winrt::Windows::Security::Credentials::KeyCredentialCreationOption>(args, 1);

                return py::convert(winrt::Windows::Security::Credentials::KeyCredentialManager::RequestCreateAsync(param0, param1));
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyMethodDef _methods_KeyCredentialManager[] = {
        { "delete_async", reinterpret_cast<PyCFunction>(KeyCredentialManager_DeleteAsync), METH_VARARGS | METH_STATIC, nullptr },
        { "is_supported_async", reinterpret_cast<PyCFunction>(KeyCredentialManager_IsSupportedAsync), METH_VARARGS | METH_STATIC, nullptr },
        { "open_async", reinterpret_cast<PyCFunction>(KeyCredentialManager_OpenAsync), METH_VARARGS | METH_STATIC, nullptr },
        { "renew_attestation_async", reinterpret_cast<PyCFunction>(KeyCredentialManager_RenewAttestationAsync), METH_VARARGS | METH_STATIC, nullptr },
        { "request_create_async", reinterpret_cast<PyCFunction>(KeyCredentialManager_RequestCreateAsync), METH_VARARGS | METH_STATIC, nullptr },
        { }
    };

    static PyGetSetDef _getset_KeyCredentialManager[] = {
        { }
    };

    static PyType_Slot _type_slots_KeyCredentialManager[] = 
    {
        { Py_tp_new, _new_KeyCredentialManager },
        { Py_tp_methods, _methods_KeyCredentialManager },
        { Py_tp_getset, _getset_KeyCredentialManager },
        { },
    };

    static PyType_Spec type_spec_KeyCredentialManager =
    {
        "_winsdk_Windows_Security_Credentials.KeyCredentialManager",
        0,
        0,
        Py_TPFLAGS_DEFAULT,
        _type_slots_KeyCredentialManager
    };

    // ----- KeyCredentialOperationResult class --------------------
    constexpr const char* const type_name_KeyCredentialOperationResult = "KeyCredentialOperationResult";

    static PyObject* _new_KeyCredentialOperationResult(PyTypeObject* type, PyObject* args, PyObject* kwds) noexcept
    {
        py::set_invalid_activation_error(type_name_KeyCredentialOperationResult);
        return nullptr;
    }

    static void _dealloc_KeyCredentialOperationResult(py::wrapper::Windows::Security::Credentials::KeyCredentialOperationResult* self)
    {
        auto tp = Py_TYPE(self);
        self->obj = nullptr;
        tp->tp_free(self);
        Py_DECREF(tp);
    }

    static PyObject* KeyCredentialOperationResult_get_Result(py::wrapper::Windows::Security::Credentials::KeyCredentialOperationResult* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.KeyCredentialOperationResult", L"Result"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.Result());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* KeyCredentialOperationResult_get_Status(py::wrapper::Windows::Security::Credentials::KeyCredentialOperationResult* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.KeyCredentialOperationResult", L"Status"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.Status());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* _from_KeyCredentialOperationResult(PyObject* /*unused*/, PyObject* arg) noexcept
    {
        try
        {
            auto return_value = py::convert_to<winrt::Windows::Foundation::IInspectable>(arg);
            return py::convert(return_value.as<winrt::Windows::Security::Credentials::KeyCredentialOperationResult>());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyMethodDef _methods_KeyCredentialOperationResult[] = {
        { "_from", reinterpret_cast<PyCFunction>(_from_KeyCredentialOperationResult), METH_O | METH_STATIC, nullptr },
        { }
    };

    static PyGetSetDef _getset_KeyCredentialOperationResult[] = {
        { "result", reinterpret_cast<getter>(KeyCredentialOperationResult_get_Result), nullptr, nullptr, nullptr },
        { "status", reinterpret_cast<getter>(KeyCredentialOperationResult_get_Status), nullptr, nullptr, nullptr },
        { }
    };

    static PyType_Slot _type_slots_KeyCredentialOperationResult[] = 
    {
        { Py_tp_new, _new_KeyCredentialOperationResult },
        { Py_tp_dealloc, _dealloc_KeyCredentialOperationResult },
        { Py_tp_methods, _methods_KeyCredentialOperationResult },
        { Py_tp_getset, _getset_KeyCredentialOperationResult },
        { },
    };

    static PyType_Spec type_spec_KeyCredentialOperationResult =
    {
        "_winsdk_Windows_Security_Credentials.KeyCredentialOperationResult",
        sizeof(py::wrapper::Windows::Security::Credentials::KeyCredentialOperationResult),
        0,
        Py_TPFLAGS_DEFAULT,
        _type_slots_KeyCredentialOperationResult
    };

    // ----- KeyCredentialRetrievalResult class --------------------
    constexpr const char* const type_name_KeyCredentialRetrievalResult = "KeyCredentialRetrievalResult";

    static PyObject* _new_KeyCredentialRetrievalResult(PyTypeObject* type, PyObject* args, PyObject* kwds) noexcept
    {
        py::set_invalid_activation_error(type_name_KeyCredentialRetrievalResult);
        return nullptr;
    }

    static void _dealloc_KeyCredentialRetrievalResult(py::wrapper::Windows::Security::Credentials::KeyCredentialRetrievalResult* self)
    {
        auto tp = Py_TYPE(self);
        self->obj = nullptr;
        tp->tp_free(self);
        Py_DECREF(tp);
    }

    static PyObject* KeyCredentialRetrievalResult_get_Credential(py::wrapper::Windows::Security::Credentials::KeyCredentialRetrievalResult* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.KeyCredentialRetrievalResult", L"Credential"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.Credential());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* KeyCredentialRetrievalResult_get_Status(py::wrapper::Windows::Security::Credentials::KeyCredentialRetrievalResult* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.KeyCredentialRetrievalResult", L"Status"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.Status());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* _from_KeyCredentialRetrievalResult(PyObject* /*unused*/, PyObject* arg) noexcept
    {
        try
        {
            auto return_value = py::convert_to<winrt::Windows::Foundation::IInspectable>(arg);
            return py::convert(return_value.as<winrt::Windows::Security::Credentials::KeyCredentialRetrievalResult>());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyMethodDef _methods_KeyCredentialRetrievalResult[] = {
        { "_from", reinterpret_cast<PyCFunction>(_from_KeyCredentialRetrievalResult), METH_O | METH_STATIC, nullptr },
        { }
    };

    static PyGetSetDef _getset_KeyCredentialRetrievalResult[] = {
        { "credential", reinterpret_cast<getter>(KeyCredentialRetrievalResult_get_Credential), nullptr, nullptr, nullptr },
        { "status", reinterpret_cast<getter>(KeyCredentialRetrievalResult_get_Status), nullptr, nullptr, nullptr },
        { }
    };

    static PyType_Slot _type_slots_KeyCredentialRetrievalResult[] = 
    {
        { Py_tp_new, _new_KeyCredentialRetrievalResult },
        { Py_tp_dealloc, _dealloc_KeyCredentialRetrievalResult },
        { Py_tp_methods, _methods_KeyCredentialRetrievalResult },
        { Py_tp_getset, _getset_KeyCredentialRetrievalResult },
        { },
    };

    static PyType_Spec type_spec_KeyCredentialRetrievalResult =
    {
        "_winsdk_Windows_Security_Credentials.KeyCredentialRetrievalResult",
        sizeof(py::wrapper::Windows::Security::Credentials::KeyCredentialRetrievalResult),
        0,
        Py_TPFLAGS_DEFAULT,
        _type_slots_KeyCredentialRetrievalResult
    };

    // ----- PasswordCredential class --------------------
    constexpr const char* const type_name_PasswordCredential = "PasswordCredential";

    static PyObject* _new_PasswordCredential(PyTypeObject* type, PyObject* args, PyObject* kwds) noexcept
    {
        if (kwds != nullptr)
        {
            py::set_invalid_kwd_args_error();
            return nullptr;
        }

        Py_ssize_t arg_count = PyTuple_Size(args);
        if (arg_count == 3)
        {
            try
            {
                auto param0 = py::convert_to<winrt::hstring>(args, 0);
                auto param1 = py::convert_to<winrt::hstring>(args, 1);
                auto param2 = py::convert_to<winrt::hstring>(args, 2);

                winrt::Windows::Security::Credentials::PasswordCredential instance{ param0, param1, param2 };
                return py::wrap(instance, type);
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else if (arg_count == 0)
        {
            try
            {
                winrt::Windows::Security::Credentials::PasswordCredential instance{  };
                return py::wrap(instance, type);
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static void _dealloc_PasswordCredential(py::wrapper::Windows::Security::Credentials::PasswordCredential* self)
    {
        auto tp = Py_TYPE(self);
        self->obj = nullptr;
        tp->tp_free(self);
        Py_DECREF(tp);
    }

    static PyObject* PasswordCredential_RetrievePassword(py::wrapper::Windows::Security::Credentials::PasswordCredential* self, PyObject* args) noexcept
    {
        Py_ssize_t arg_count = PyTuple_Size(args);

        if (arg_count == 0)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Security.Credentials.PasswordCredential", L"RetrievePassword", 0))
            {
                PyErr_SetString(PyExc_AttributeError, "method 0 args is not available in this version of Windows");
                return nullptr;
            }

            try
            {
                self->obj.RetrievePassword();
                Py_RETURN_NONE;
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* PasswordCredential_get_UserName(py::wrapper::Windows::Security::Credentials::PasswordCredential* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.PasswordCredential", L"UserName"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.UserName());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static int PasswordCredential_put_UserName(py::wrapper::Windows::Security::Credentials::PasswordCredential* self, PyObject* arg, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.PasswordCredential", L"UserName"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return -1;
        }

        if (arg == nullptr)
        {
            PyErr_SetString(PyExc_AttributeError, "can't delete attribute");
            return -1;
        }

        try
        {
            auto param0 = py::convert_to<winrt::hstring>(arg);

            self->obj.UserName(param0);
            return 0;
        }
        catch (...)
        {
            py::to_PyErr();
            return -1;
        }
    }

    static PyObject* PasswordCredential_get_Resource(py::wrapper::Windows::Security::Credentials::PasswordCredential* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.PasswordCredential", L"Resource"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.Resource());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static int PasswordCredential_put_Resource(py::wrapper::Windows::Security::Credentials::PasswordCredential* self, PyObject* arg, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.PasswordCredential", L"Resource"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return -1;
        }

        if (arg == nullptr)
        {
            PyErr_SetString(PyExc_AttributeError, "can't delete attribute");
            return -1;
        }

        try
        {
            auto param0 = py::convert_to<winrt::hstring>(arg);

            self->obj.Resource(param0);
            return 0;
        }
        catch (...)
        {
            py::to_PyErr();
            return -1;
        }
    }

    static PyObject* PasswordCredential_get_Password(py::wrapper::Windows::Security::Credentials::PasswordCredential* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.PasswordCredential", L"Password"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.Password());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static int PasswordCredential_put_Password(py::wrapper::Windows::Security::Credentials::PasswordCredential* self, PyObject* arg, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.PasswordCredential", L"Password"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return -1;
        }

        if (arg == nullptr)
        {
            PyErr_SetString(PyExc_AttributeError, "can't delete attribute");
            return -1;
        }

        try
        {
            auto param0 = py::convert_to<winrt::hstring>(arg);

            self->obj.Password(param0);
            return 0;
        }
        catch (...)
        {
            py::to_PyErr();
            return -1;
        }
    }

    static PyObject* PasswordCredential_get_Properties(py::wrapper::Windows::Security::Credentials::PasswordCredential* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.PasswordCredential", L"Properties"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.Properties());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* _from_PasswordCredential(PyObject* /*unused*/, PyObject* arg) noexcept
    {
        try
        {
            auto return_value = py::convert_to<winrt::Windows::Foundation::IInspectable>(arg);
            return py::convert(return_value.as<winrt::Windows::Security::Credentials::PasswordCredential>());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyMethodDef _methods_PasswordCredential[] = {
        { "retrieve_password", reinterpret_cast<PyCFunction>(PasswordCredential_RetrievePassword), METH_VARARGS, nullptr },
        { "_from", reinterpret_cast<PyCFunction>(_from_PasswordCredential), METH_O | METH_STATIC, nullptr },
        { }
    };

    static PyGetSetDef _getset_PasswordCredential[] = {
        { "user_name", reinterpret_cast<getter>(PasswordCredential_get_UserName), reinterpret_cast<setter>(PasswordCredential_put_UserName), nullptr, nullptr },
        { "resource", reinterpret_cast<getter>(PasswordCredential_get_Resource), reinterpret_cast<setter>(PasswordCredential_put_Resource), nullptr, nullptr },
        { "password", reinterpret_cast<getter>(PasswordCredential_get_Password), reinterpret_cast<setter>(PasswordCredential_put_Password), nullptr, nullptr },
        { "properties", reinterpret_cast<getter>(PasswordCredential_get_Properties), nullptr, nullptr, nullptr },
        { }
    };

    static PyType_Slot _type_slots_PasswordCredential[] = 
    {
        { Py_tp_new, _new_PasswordCredential },
        { Py_tp_dealloc, _dealloc_PasswordCredential },
        { Py_tp_methods, _methods_PasswordCredential },
        { Py_tp_getset, _getset_PasswordCredential },
        { },
    };

    static PyType_Spec type_spec_PasswordCredential =
    {
        "_winsdk_Windows_Security_Credentials.PasswordCredential",
        sizeof(py::wrapper::Windows::Security::Credentials::PasswordCredential),
        0,
        Py_TPFLAGS_DEFAULT,
        _type_slots_PasswordCredential
    };

    // ----- PasswordCredentialPropertyStore class --------------------
    constexpr const char* const type_name_PasswordCredentialPropertyStore = "PasswordCredentialPropertyStore";

    static PyObject* _new_PasswordCredentialPropertyStore(PyTypeObject* type, PyObject* args, PyObject* kwds) noexcept
    {
        if (kwds != nullptr)
        {
            py::set_invalid_kwd_args_error();
            return nullptr;
        }

        Py_ssize_t arg_count = PyTuple_Size(args);
        if (arg_count == 0)
        {
            try
            {
                winrt::Windows::Security::Credentials::PasswordCredentialPropertyStore instance{  };
                return py::wrap(instance, type);
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static void _dealloc_PasswordCredentialPropertyStore(py::wrapper::Windows::Security::Credentials::PasswordCredentialPropertyStore* self)
    {
        auto tp = Py_TYPE(self);
        self->obj = nullptr;
        tp->tp_free(self);
        Py_DECREF(tp);
    }

    static PyObject* PasswordCredentialPropertyStore_Clear(py::wrapper::Windows::Security::Credentials::PasswordCredentialPropertyStore* self, PyObject* args) noexcept
    {
        Py_ssize_t arg_count = PyTuple_Size(args);

        if (arg_count == 0)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Security.Credentials.PasswordCredentialPropertyStore", L"Clear", 0))
            {
                PyErr_SetString(PyExc_AttributeError, "method 0 args is not available in this version of Windows");
                return nullptr;
            }

            try
            {
                self->obj.Clear();
                Py_RETURN_NONE;
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* PasswordCredentialPropertyStore_First(py::wrapper::Windows::Security::Credentials::PasswordCredentialPropertyStore* self, PyObject* args) noexcept
    {
        Py_ssize_t arg_count = PyTuple_Size(args);

        if (arg_count == 0)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Security.Credentials.PasswordCredentialPropertyStore", L"First", 0))
            {
                PyErr_SetString(PyExc_AttributeError, "method 0 args is not available in this version of Windows");
                return nullptr;
            }

            try
            {
                return py::convert(self->obj.First());
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* PasswordCredentialPropertyStore_GetView(py::wrapper::Windows::Security::Credentials::PasswordCredentialPropertyStore* self, PyObject* args) noexcept
    {
        Py_ssize_t arg_count = PyTuple_Size(args);

        if (arg_count == 0)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Security.Credentials.PasswordCredentialPropertyStore", L"GetView", 0))
            {
                PyErr_SetString(PyExc_AttributeError, "method 0 args is not available in this version of Windows");
                return nullptr;
            }

            try
            {
                return py::convert(self->obj.GetView());
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* PasswordCredentialPropertyStore_HasKey(py::wrapper::Windows::Security::Credentials::PasswordCredentialPropertyStore* self, PyObject* args) noexcept
    {
        Py_ssize_t arg_count = PyTuple_Size(args);

        if (arg_count == 1)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Security.Credentials.PasswordCredentialPropertyStore", L"HasKey", 1))
            {
                PyErr_SetString(PyExc_AttributeError, "method 1 args is not available in this version of Windows");
                return nullptr;
            }

            try
            {
                auto param0 = py::convert_to<winrt::hstring>(args, 0);

                return py::convert(self->obj.HasKey(param0));
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* PasswordCredentialPropertyStore_Insert(py::wrapper::Windows::Security::Credentials::PasswordCredentialPropertyStore* self, PyObject* args) noexcept
    {
        Py_ssize_t arg_count = PyTuple_Size(args);

        if (arg_count == 2)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Security.Credentials.PasswordCredentialPropertyStore", L"Insert", 2))
            {
                PyErr_SetString(PyExc_AttributeError, "method 2 args is not available in this version of Windows");
                return nullptr;
            }

            try
            {
                auto param0 = py::convert_to<winrt::hstring>(args, 0);
                auto param1 = py::convert_to<winrt::Windows::Foundation::IInspectable>(args, 1);

                return py::convert(self->obj.Insert(param0, param1));
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* PasswordCredentialPropertyStore_Lookup(py::wrapper::Windows::Security::Credentials::PasswordCredentialPropertyStore* self, PyObject* args) noexcept
    {
        Py_ssize_t arg_count = PyTuple_Size(args);

        if (arg_count == 1)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Security.Credentials.PasswordCredentialPropertyStore", L"Lookup", 1))
            {
                PyErr_SetString(PyExc_AttributeError, "method 1 args is not available in this version of Windows");
                return nullptr;
            }

            try
            {
                auto param0 = py::convert_to<winrt::hstring>(args, 0);

                return py::convert(self->obj.Lookup(param0));
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* PasswordCredentialPropertyStore_Remove(py::wrapper::Windows::Security::Credentials::PasswordCredentialPropertyStore* self, PyObject* args) noexcept
    {
        Py_ssize_t arg_count = PyTuple_Size(args);

        if (arg_count == 1)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Security.Credentials.PasswordCredentialPropertyStore", L"Remove", 1))
            {
                PyErr_SetString(PyExc_AttributeError, "method 1 args is not available in this version of Windows");
                return nullptr;
            }

            try
            {
                auto param0 = py::convert_to<winrt::hstring>(args, 0);

                self->obj.Remove(param0);
                Py_RETURN_NONE;
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* PasswordCredentialPropertyStore_get_Size(py::wrapper::Windows::Security::Credentials::PasswordCredentialPropertyStore* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.PasswordCredentialPropertyStore", L"Size"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.Size());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* PasswordCredentialPropertyStore_add_MapChanged(py::wrapper::Windows::Security::Credentials::PasswordCredentialPropertyStore* self, PyObject* arg) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsEventPresent(L"Windows.Security.Credentials.PasswordCredentialPropertyStore", L"MapChanged"))
        {
            PyErr_SetString(PyExc_AttributeError, "event is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            auto param0 = py::convert_to<winrt::Windows::Foundation::Collections::MapChangedEventHandler<winrt::hstring, winrt::Windows::Foundation::IInspectable>>(arg);

            return py::convert(self->obj.MapChanged(param0));
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* PasswordCredentialPropertyStore_remove_MapChanged(py::wrapper::Windows::Security::Credentials::PasswordCredentialPropertyStore* self, PyObject* arg) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsEventPresent(L"Windows.Security.Credentials.PasswordCredentialPropertyStore", L"MapChanged"))
        {
            PyErr_SetString(PyExc_AttributeError, "event is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            auto param0 = py::convert_to<winrt::event_token>(arg);

            self->obj.MapChanged(param0);
            Py_RETURN_NONE;
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* _from_PasswordCredentialPropertyStore(PyObject* /*unused*/, PyObject* arg) noexcept
    {
        try
        {
            auto return_value = py::convert_to<winrt::Windows::Foundation::IInspectable>(arg);
            return py::convert(return_value.as<winrt::Windows::Security::Credentials::PasswordCredentialPropertyStore>());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* _iterator_PasswordCredentialPropertyStore(py::wrapper::Windows::Security::Credentials::PasswordCredentialPropertyStore* self) noexcept
    {
        try
        {
            py::pyobj_handle iter{py::convert(self->obj.First())};
            return py::wrap_mapping_iter(iter.get());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static int _map_contains_PasswordCredentialPropertyStore(py::wrapper::Windows::Security::Credentials::PasswordCredentialPropertyStore* self, PyObject* key) noexcept
    {
        try
        {
            return static_cast<int>(self->obj.HasKey(py::convert_to<winrt::hstring>(key)));
        }
        catch (...)
        {
            py::to_PyErr();
            return -1;
        }
    }

    static Py_ssize_t _map_length_PasswordCredentialPropertyStore(py::wrapper::Windows::Security::Credentials::PasswordCredentialPropertyStore* self) noexcept
    {
        try
        {
            return static_cast<Py_ssize_t>(self->obj.Size());
        }
        catch (...)
        {
            py::to_PyErr();
            return -1;
        }
    }

    static PyObject* _map_subscript_PasswordCredentialPropertyStore(py::wrapper::Windows::Security::Credentials::PasswordCredentialPropertyStore* self, PyObject* key) noexcept
    {
        try
        {
            auto value = self->obj.TryLookup(py::convert_to<winrt::hstring>(key));

            if (!value) {
                PyErr_SetObject(PyExc_KeyError, key);
                return nullptr;
            }

            return py::convert(value);
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static int _map_assign_PasswordCredentialPropertyStore(py::wrapper::Windows::Security::Credentials::PasswordCredentialPropertyStore* self, PyObject* key, PyObject* value) noexcept
    {
        try
        {
            auto _key = py::convert_to<winrt::hstring>(key);

            if (value == nullptr) {
                if (!self->obj.TryRemove(_key)) {
                    PyErr_SetObject(PyExc_KeyError, key);
                    return -1;
                }

                return 0;
            }

            self->obj.Insert(_key, py::convert_to<winrt::Windows::Foundation::IInspectable>(value));

            return 0;
        }
        catch (...)
        {
            py::to_PyErr();
            return -1;
        }
    }

    static PyMethodDef _methods_PasswordCredentialPropertyStore[] = {
        { "clear", reinterpret_cast<PyCFunction>(PasswordCredentialPropertyStore_Clear), METH_VARARGS, nullptr },
        { "first", reinterpret_cast<PyCFunction>(PasswordCredentialPropertyStore_First), METH_VARARGS, nullptr },
        { "get_view", reinterpret_cast<PyCFunction>(PasswordCredentialPropertyStore_GetView), METH_VARARGS, nullptr },
        { "has_key", reinterpret_cast<PyCFunction>(PasswordCredentialPropertyStore_HasKey), METH_VARARGS, nullptr },
        { "insert", reinterpret_cast<PyCFunction>(PasswordCredentialPropertyStore_Insert), METH_VARARGS, nullptr },
        { "lookup", reinterpret_cast<PyCFunction>(PasswordCredentialPropertyStore_Lookup), METH_VARARGS, nullptr },
        { "remove", reinterpret_cast<PyCFunction>(PasswordCredentialPropertyStore_Remove), METH_VARARGS, nullptr },
        { "add_map_changed", reinterpret_cast<PyCFunction>(PasswordCredentialPropertyStore_add_MapChanged), METH_O, nullptr },
        { "remove_map_changed", reinterpret_cast<PyCFunction>(PasswordCredentialPropertyStore_remove_MapChanged), METH_O, nullptr },
        { "_from", reinterpret_cast<PyCFunction>(_from_PasswordCredentialPropertyStore), METH_O | METH_STATIC, nullptr },
        { }
    };

    static PyGetSetDef _getset_PasswordCredentialPropertyStore[] = {
        { "size", reinterpret_cast<getter>(PasswordCredentialPropertyStore_get_Size), nullptr, nullptr, nullptr },
        { }
    };

    static PyType_Slot _type_slots_PasswordCredentialPropertyStore[] = 
    {
        { Py_tp_new, _new_PasswordCredentialPropertyStore },
        { Py_tp_dealloc, _dealloc_PasswordCredentialPropertyStore },
        { Py_tp_methods, _methods_PasswordCredentialPropertyStore },
        { Py_tp_getset, _getset_PasswordCredentialPropertyStore },
        { Py_tp_iter, _iterator_PasswordCredentialPropertyStore },
        { Py_sq_contains, _map_contains_PasswordCredentialPropertyStore },
        { Py_mp_length, _map_length_PasswordCredentialPropertyStore },
        { Py_mp_subscript, _map_subscript_PasswordCredentialPropertyStore },
        { Py_mp_ass_subscript, _map_assign_PasswordCredentialPropertyStore },
        { },
    };

    static PyType_Spec type_spec_PasswordCredentialPropertyStore =
    {
        "_winsdk_Windows_Security_Credentials.PasswordCredentialPropertyStore",
        sizeof(py::wrapper::Windows::Security::Credentials::PasswordCredentialPropertyStore),
        0,
        Py_TPFLAGS_DEFAULT,
        _type_slots_PasswordCredentialPropertyStore
    };

    // ----- PasswordVault class --------------------
    constexpr const char* const type_name_PasswordVault = "PasswordVault";

    static PyObject* _new_PasswordVault(PyTypeObject* type, PyObject* args, PyObject* kwds) noexcept
    {
        if (kwds != nullptr)
        {
            py::set_invalid_kwd_args_error();
            return nullptr;
        }

        Py_ssize_t arg_count = PyTuple_Size(args);
        if (arg_count == 0)
        {
            try
            {
                winrt::Windows::Security::Credentials::PasswordVault instance{  };
                return py::wrap(instance, type);
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static void _dealloc_PasswordVault(py::wrapper::Windows::Security::Credentials::PasswordVault* self)
    {
        auto tp = Py_TYPE(self);
        self->obj = nullptr;
        tp->tp_free(self);
        Py_DECREF(tp);
    }

    static PyObject* PasswordVault_Add(py::wrapper::Windows::Security::Credentials::PasswordVault* self, PyObject* args) noexcept
    {
        Py_ssize_t arg_count = PyTuple_Size(args);

        if (arg_count == 1)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Security.Credentials.PasswordVault", L"Add", 1))
            {
                PyErr_SetString(PyExc_AttributeError, "method 1 args is not available in this version of Windows");
                return nullptr;
            }

            try
            {
                auto param0 = py::convert_to<winrt::Windows::Security::Credentials::PasswordCredential>(args, 0);

                self->obj.Add(param0);
                Py_RETURN_NONE;
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* PasswordVault_FindAllByResource(py::wrapper::Windows::Security::Credentials::PasswordVault* self, PyObject* args) noexcept
    {
        Py_ssize_t arg_count = PyTuple_Size(args);

        if (arg_count == 1)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Security.Credentials.PasswordVault", L"FindAllByResource", 1))
            {
                PyErr_SetString(PyExc_AttributeError, "method 1 args is not available in this version of Windows");
                return nullptr;
            }

            try
            {
                auto param0 = py::convert_to<winrt::hstring>(args, 0);

                return py::convert(self->obj.FindAllByResource(param0));
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* PasswordVault_FindAllByUserName(py::wrapper::Windows::Security::Credentials::PasswordVault* self, PyObject* args) noexcept
    {
        Py_ssize_t arg_count = PyTuple_Size(args);

        if (arg_count == 1)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Security.Credentials.PasswordVault", L"FindAllByUserName", 1))
            {
                PyErr_SetString(PyExc_AttributeError, "method 1 args is not available in this version of Windows");
                return nullptr;
            }

            try
            {
                auto param0 = py::convert_to<winrt::hstring>(args, 0);

                return py::convert(self->obj.FindAllByUserName(param0));
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* PasswordVault_Remove(py::wrapper::Windows::Security::Credentials::PasswordVault* self, PyObject* args) noexcept
    {
        Py_ssize_t arg_count = PyTuple_Size(args);

        if (arg_count == 1)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Security.Credentials.PasswordVault", L"Remove", 1))
            {
                PyErr_SetString(PyExc_AttributeError, "method 1 args is not available in this version of Windows");
                return nullptr;
            }

            try
            {
                auto param0 = py::convert_to<winrt::Windows::Security::Credentials::PasswordCredential>(args, 0);

                self->obj.Remove(param0);
                Py_RETURN_NONE;
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* PasswordVault_Retrieve(py::wrapper::Windows::Security::Credentials::PasswordVault* self, PyObject* args) noexcept
    {
        Py_ssize_t arg_count = PyTuple_Size(args);

        if (arg_count == 2)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Security.Credentials.PasswordVault", L"Retrieve", 2))
            {
                PyErr_SetString(PyExc_AttributeError, "method 2 args is not available in this version of Windows");
                return nullptr;
            }

            try
            {
                auto param0 = py::convert_to<winrt::hstring>(args, 0);
                auto param1 = py::convert_to<winrt::hstring>(args, 1);

                return py::convert(self->obj.Retrieve(param0, param1));
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* PasswordVault_RetrieveAll(py::wrapper::Windows::Security::Credentials::PasswordVault* self, PyObject* args) noexcept
    {
        Py_ssize_t arg_count = PyTuple_Size(args);

        if (arg_count == 0)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Security.Credentials.PasswordVault", L"RetrieveAll", 0))
            {
                PyErr_SetString(PyExc_AttributeError, "method 0 args is not available in this version of Windows");
                return nullptr;
            }

            try
            {
                return py::convert(self->obj.RetrieveAll());
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* _from_PasswordVault(PyObject* /*unused*/, PyObject* arg) noexcept
    {
        try
        {
            auto return_value = py::convert_to<winrt::Windows::Foundation::IInspectable>(arg);
            return py::convert(return_value.as<winrt::Windows::Security::Credentials::PasswordVault>());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyMethodDef _methods_PasswordVault[] = {
        { "add", reinterpret_cast<PyCFunction>(PasswordVault_Add), METH_VARARGS, nullptr },
        { "find_all_by_resource", reinterpret_cast<PyCFunction>(PasswordVault_FindAllByResource), METH_VARARGS, nullptr },
        { "find_all_by_user_name", reinterpret_cast<PyCFunction>(PasswordVault_FindAllByUserName), METH_VARARGS, nullptr },
        { "remove", reinterpret_cast<PyCFunction>(PasswordVault_Remove), METH_VARARGS, nullptr },
        { "retrieve", reinterpret_cast<PyCFunction>(PasswordVault_Retrieve), METH_VARARGS, nullptr },
        { "retrieve_all", reinterpret_cast<PyCFunction>(PasswordVault_RetrieveAll), METH_VARARGS, nullptr },
        { "_from", reinterpret_cast<PyCFunction>(_from_PasswordVault), METH_O | METH_STATIC, nullptr },
        { }
    };

    static PyGetSetDef _getset_PasswordVault[] = {
        { }
    };

    static PyType_Slot _type_slots_PasswordVault[] = 
    {
        { Py_tp_new, _new_PasswordVault },
        { Py_tp_dealloc, _dealloc_PasswordVault },
        { Py_tp_methods, _methods_PasswordVault },
        { Py_tp_getset, _getset_PasswordVault },
        { },
    };

    static PyType_Spec type_spec_PasswordVault =
    {
        "_winsdk_Windows_Security_Credentials.PasswordVault",
        sizeof(py::wrapper::Windows::Security::Credentials::PasswordVault),
        0,
        Py_TPFLAGS_DEFAULT,
        _type_slots_PasswordVault
    };

    // ----- WebAccount class --------------------
    constexpr const char* const type_name_WebAccount = "WebAccount";

    static PyObject* _new_WebAccount(PyTypeObject* type, PyObject* args, PyObject* kwds) noexcept
    {
        if (kwds != nullptr)
        {
            py::set_invalid_kwd_args_error();
            return nullptr;
        }

        Py_ssize_t arg_count = PyTuple_Size(args);
        if (arg_count == 3)
        {
            try
            {
                auto param0 = py::convert_to<winrt::Windows::Security::Credentials::WebAccountProvider>(args, 0);
                auto param1 = py::convert_to<winrt::hstring>(args, 1);
                auto param2 = py::convert_to<winrt::Windows::Security::Credentials::WebAccountState>(args, 2);

                winrt::Windows::Security::Credentials::WebAccount instance{ param0, param1, param2 };
                return py::wrap(instance, type);
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static void _dealloc_WebAccount(py::wrapper::Windows::Security::Credentials::WebAccount* self)
    {
        auto tp = Py_TYPE(self);
        self->obj = nullptr;
        tp->tp_free(self);
        Py_DECREF(tp);
    }

    static PyObject* WebAccount_GetPictureAsync(py::wrapper::Windows::Security::Credentials::WebAccount* self, PyObject* args) noexcept
    {
        Py_ssize_t arg_count = PyTuple_Size(args);

        if (arg_count == 1)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Security.Credentials.WebAccount", L"GetPictureAsync", 1))
            {
                PyErr_SetString(PyExc_AttributeError, "method 1 args is not available in this version of Windows");
                return nullptr;
            }

            try
            {
                auto param0 = py::convert_to<winrt::Windows::Security::Credentials::WebAccountPictureSize>(args, 0);

                return py::convert(self->obj.GetPictureAsync(param0));
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* WebAccount_SignOutAsync(py::wrapper::Windows::Security::Credentials::WebAccount* self, PyObject* args) noexcept
    {
        Py_ssize_t arg_count = PyTuple_Size(args);

        if (arg_count == 0)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Security.Credentials.WebAccount", L"SignOutAsync", 0))
            {
                PyErr_SetString(PyExc_AttributeError, "method 0 args is not available in this version of Windows");
                return nullptr;
            }

            try
            {
                return py::convert(self->obj.SignOutAsync());
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else if (arg_count == 1)
        {
            if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsMethodPresent(L"Windows.Security.Credentials.WebAccount", L"SignOutAsync", 1))
            {
                PyErr_SetString(PyExc_AttributeError, "method 1 args is not available in this version of Windows");
                return nullptr;
            }

            try
            {
                auto param0 = py::convert_to<winrt::hstring>(args, 0);

                return py::convert(self->obj.SignOutAsync(param0));
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static PyObject* WebAccount_get_State(py::wrapper::Windows::Security::Credentials::WebAccount* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.WebAccount", L"State"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.State());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* WebAccount_get_UserName(py::wrapper::Windows::Security::Credentials::WebAccount* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.WebAccount", L"UserName"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.UserName());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* WebAccount_get_WebAccountProvider(py::wrapper::Windows::Security::Credentials::WebAccount* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.WebAccount", L"WebAccountProvider"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.WebAccountProvider());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* WebAccount_get_Id(py::wrapper::Windows::Security::Credentials::WebAccount* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.WebAccount", L"Id"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.Id());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* WebAccount_get_Properties(py::wrapper::Windows::Security::Credentials::WebAccount* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.WebAccount", L"Properties"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.Properties());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* _from_WebAccount(PyObject* /*unused*/, PyObject* arg) noexcept
    {
        try
        {
            auto return_value = py::convert_to<winrt::Windows::Foundation::IInspectable>(arg);
            return py::convert(return_value.as<winrt::Windows::Security::Credentials::WebAccount>());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyMethodDef _methods_WebAccount[] = {
        { "get_picture_async", reinterpret_cast<PyCFunction>(WebAccount_GetPictureAsync), METH_VARARGS, nullptr },
        { "sign_out_async", reinterpret_cast<PyCFunction>(WebAccount_SignOutAsync), METH_VARARGS, nullptr },
        { "_from", reinterpret_cast<PyCFunction>(_from_WebAccount), METH_O | METH_STATIC, nullptr },
        { }
    };

    static PyGetSetDef _getset_WebAccount[] = {
        { "state", reinterpret_cast<getter>(WebAccount_get_State), nullptr, nullptr, nullptr },
        { "user_name", reinterpret_cast<getter>(WebAccount_get_UserName), nullptr, nullptr, nullptr },
        { "web_account_provider", reinterpret_cast<getter>(WebAccount_get_WebAccountProvider), nullptr, nullptr, nullptr },
        { "id", reinterpret_cast<getter>(WebAccount_get_Id), nullptr, nullptr, nullptr },
        { "properties", reinterpret_cast<getter>(WebAccount_get_Properties), nullptr, nullptr, nullptr },
        { }
    };

    static PyType_Slot _type_slots_WebAccount[] = 
    {
        { Py_tp_new, _new_WebAccount },
        { Py_tp_dealloc, _dealloc_WebAccount },
        { Py_tp_methods, _methods_WebAccount },
        { Py_tp_getset, _getset_WebAccount },
        { },
    };

    static PyType_Spec type_spec_WebAccount =
    {
        "_winsdk_Windows_Security_Credentials.WebAccount",
        sizeof(py::wrapper::Windows::Security::Credentials::WebAccount),
        0,
        Py_TPFLAGS_DEFAULT,
        _type_slots_WebAccount
    };

    // ----- WebAccountProvider class --------------------
    constexpr const char* const type_name_WebAccountProvider = "WebAccountProvider";

    static PyObject* _new_WebAccountProvider(PyTypeObject* type, PyObject* args, PyObject* kwds) noexcept
    {
        if (kwds != nullptr)
        {
            py::set_invalid_kwd_args_error();
            return nullptr;
        }

        Py_ssize_t arg_count = PyTuple_Size(args);
        if (arg_count == 3)
        {
            try
            {
                auto param0 = py::convert_to<winrt::hstring>(args, 0);
                auto param1 = py::convert_to<winrt::hstring>(args, 1);
                auto param2 = py::convert_to<winrt::Windows::Foundation::Uri>(args, 2);

                winrt::Windows::Security::Credentials::WebAccountProvider instance{ param0, param1, param2 };
                return py::wrap(instance, type);
            }
            catch (...)
            {
                py::to_PyErr();
                return nullptr;
            }
        }
        else
        {
            py::set_invalid_arg_count_error(arg_count);
            return nullptr;
        }
    }

    static void _dealloc_WebAccountProvider(py::wrapper::Windows::Security::Credentials::WebAccountProvider* self)
    {
        auto tp = Py_TYPE(self);
        self->obj = nullptr;
        tp->tp_free(self);
        Py_DECREF(tp);
    }

    static PyObject* WebAccountProvider_get_DisplayName(py::wrapper::Windows::Security::Credentials::WebAccountProvider* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.WebAccountProvider", L"DisplayName"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.DisplayName());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* WebAccountProvider_get_IconUri(py::wrapper::Windows::Security::Credentials::WebAccountProvider* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.WebAccountProvider", L"IconUri"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.IconUri());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* WebAccountProvider_get_Id(py::wrapper::Windows::Security::Credentials::WebAccountProvider* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.WebAccountProvider", L"Id"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.Id());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* WebAccountProvider_get_Authority(py::wrapper::Windows::Security::Credentials::WebAccountProvider* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.WebAccountProvider", L"Authority"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.Authority());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* WebAccountProvider_get_DisplayPurpose(py::wrapper::Windows::Security::Credentials::WebAccountProvider* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.WebAccountProvider", L"DisplayPurpose"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.DisplayPurpose());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* WebAccountProvider_get_User(py::wrapper::Windows::Security::Credentials::WebAccountProvider* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.WebAccountProvider", L"User"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.User());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* WebAccountProvider_get_IsSystemProvider(py::wrapper::Windows::Security::Credentials::WebAccountProvider* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.WebAccountProvider", L"IsSystemProvider"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.IsSystemProvider());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* _from_WebAccountProvider(PyObject* /*unused*/, PyObject* arg) noexcept
    {
        try
        {
            auto return_value = py::convert_to<winrt::Windows::Foundation::IInspectable>(arg);
            return py::convert(return_value.as<winrt::Windows::Security::Credentials::WebAccountProvider>());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyMethodDef _methods_WebAccountProvider[] = {
        { "_from", reinterpret_cast<PyCFunction>(_from_WebAccountProvider), METH_O | METH_STATIC, nullptr },
        { }
    };

    static PyGetSetDef _getset_WebAccountProvider[] = {
        { "display_name", reinterpret_cast<getter>(WebAccountProvider_get_DisplayName), nullptr, nullptr, nullptr },
        { "icon_uri", reinterpret_cast<getter>(WebAccountProvider_get_IconUri), nullptr, nullptr, nullptr },
        { "id", reinterpret_cast<getter>(WebAccountProvider_get_Id), nullptr, nullptr, nullptr },
        { "authority", reinterpret_cast<getter>(WebAccountProvider_get_Authority), nullptr, nullptr, nullptr },
        { "display_purpose", reinterpret_cast<getter>(WebAccountProvider_get_DisplayPurpose), nullptr, nullptr, nullptr },
        { "user", reinterpret_cast<getter>(WebAccountProvider_get_User), nullptr, nullptr, nullptr },
        { "is_system_provider", reinterpret_cast<getter>(WebAccountProvider_get_IsSystemProvider), nullptr, nullptr, nullptr },
        { }
    };

    static PyType_Slot _type_slots_WebAccountProvider[] = 
    {
        { Py_tp_new, _new_WebAccountProvider },
        { Py_tp_dealloc, _dealloc_WebAccountProvider },
        { Py_tp_methods, _methods_WebAccountProvider },
        { Py_tp_getset, _getset_WebAccountProvider },
        { },
    };

    static PyType_Spec type_spec_WebAccountProvider =
    {
        "_winsdk_Windows_Security_Credentials.WebAccountProvider",
        sizeof(py::wrapper::Windows::Security::Credentials::WebAccountProvider),
        0,
        Py_TPFLAGS_DEFAULT,
        _type_slots_WebAccountProvider
    };

    // ----- IWebAccount interface --------------------
    constexpr const char* const type_name_IWebAccount = "IWebAccount";

    static PyObject* _new_IWebAccount(PyTypeObject* /* unused */, PyObject* /* unused */, PyObject* /* unused */)
    {
        py::set_invalid_activation_error(type_name_IWebAccount);
        return nullptr;
    }

    static void _dealloc_IWebAccount(py::wrapper::Windows::Security::Credentials::IWebAccount* self)
    {
        auto tp = Py_TYPE(self);
        self->obj = nullptr;
        tp->tp_free(self);
        Py_DECREF(tp);
    }

    static PyObject* IWebAccount_get_State(py::wrapper::Windows::Security::Credentials::IWebAccount* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.IWebAccount", L"State"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.State());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* IWebAccount_get_UserName(py::wrapper::Windows::Security::Credentials::IWebAccount* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.IWebAccount", L"UserName"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.UserName());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* IWebAccount_get_WebAccountProvider(py::wrapper::Windows::Security::Credentials::IWebAccount* self, void* /*unused*/) noexcept
    {
        if (!winrt::Windows::Foundation::Metadata::ApiInformation::IsPropertyPresent(L"Windows.Security.Credentials.IWebAccount", L"WebAccountProvider"))
        {
            PyErr_SetString(PyExc_AttributeError, "property is not available in this version of Windows");
            return nullptr;
        }

        try
        {
            return py::convert(self->obj.WebAccountProvider());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyObject* _from_IWebAccount(PyObject* /*unused*/, PyObject* arg) noexcept
    {
        try
        {
            auto return_value = py::convert_to<winrt::Windows::Foundation::IInspectable>(arg);
            return py::convert(return_value.as<winrt::Windows::Security::Credentials::IWebAccount>());
        }
        catch (...)
        {
            py::to_PyErr();
            return nullptr;
        }
    }

    static PyMethodDef _methods_IWebAccount[] = {
        { "_from", reinterpret_cast<PyCFunction>(_from_IWebAccount), METH_O | METH_STATIC, nullptr },
        { }
    };

    static PyGetSetDef _getset_IWebAccount[] = {
        { "state", reinterpret_cast<getter>(IWebAccount_get_State), nullptr, nullptr, nullptr },
        { "user_name", reinterpret_cast<getter>(IWebAccount_get_UserName), nullptr, nullptr, nullptr },
        { "web_account_provider", reinterpret_cast<getter>(IWebAccount_get_WebAccountProvider), nullptr, nullptr, nullptr },
        { }
    };

    static PyType_Slot _type_slots_IWebAccount[] = 
    {
        { Py_tp_new, _new_IWebAccount },
        { Py_tp_dealloc, _dealloc_IWebAccount },
        { Py_tp_methods, _methods_IWebAccount },
        { Py_tp_getset, _getset_IWebAccount },
        { },
    };

    static PyType_Spec type_spec_IWebAccount =
    {
        "_winsdk_Windows_Security_Credentials.IWebAccount",
        sizeof(py::wrapper::Windows::Security::Credentials::IWebAccount),
        0,
        Py_TPFLAGS_DEFAULT,
        _type_slots_IWebAccount
    };

    // ----- Windows.Security.Credentials Initialization --------------------
    PyDoc_STRVAR(module_doc, "Windows::Security::Credentials");

    static PyMethodDef module_methods[] = {
        {"_register_KeyCredentialAttestationStatus", register_KeyCredentialAttestationStatus, METH_O, "registers type"},
        {"_register_KeyCredentialCreationOption", register_KeyCredentialCreationOption, METH_O, "registers type"},
        {"_register_KeyCredentialStatus", register_KeyCredentialStatus, METH_O, "registers type"},
        {"_register_WebAccountPictureSize", register_WebAccountPictureSize, METH_O, "registers type"},
        {"_register_WebAccountState", register_WebAccountState, METH_O, "registers type"},
        {}};


    static int module_traverse(PyObject* module, visitproc visit, void* arg) noexcept
    {
        auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));

        if (!state)
        {
            return 0;
        }

        Py_VISIT(state->type_KeyCredentialAttestationStatus);
        Py_VISIT(state->type_KeyCredentialCreationOption);
        Py_VISIT(state->type_KeyCredentialStatus);
        Py_VISIT(state->type_WebAccountPictureSize);
        Py_VISIT(state->type_WebAccountState);
        Py_VISIT(state->type_KeyCredential);
        Py_VISIT(state->type_KeyCredentialAttestationResult);
        Py_VISIT(state->type_KeyCredentialManager);
        Py_VISIT(state->type_KeyCredentialOperationResult);
        Py_VISIT(state->type_KeyCredentialRetrievalResult);
        Py_VISIT(state->type_PasswordCredential);
        Py_VISIT(state->type_PasswordCredentialPropertyStore);
        Py_VISIT(state->type_PasswordVault);
        Py_VISIT(state->type_WebAccount);
        Py_VISIT(state->type_WebAccountProvider);
        Py_VISIT(state->type_IWebAccount);

        return 0;
    }

    static int module_clear(PyObject* module) noexcept
    {
        auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));

        if (!state)
        {
            return 0;
        }

        Py_CLEAR(state->type_KeyCredentialAttestationStatus);
        Py_CLEAR(state->type_KeyCredentialCreationOption);
        Py_CLEAR(state->type_KeyCredentialStatus);
        Py_CLEAR(state->type_WebAccountPictureSize);
        Py_CLEAR(state->type_WebAccountState);
        Py_CLEAR(state->type_KeyCredential);
        Py_CLEAR(state->type_KeyCredentialAttestationResult);
        Py_CLEAR(state->type_KeyCredentialManager);
        Py_CLEAR(state->type_KeyCredentialOperationResult);
        Py_CLEAR(state->type_KeyCredentialRetrievalResult);
        Py_CLEAR(state->type_PasswordCredential);
        Py_CLEAR(state->type_PasswordCredentialPropertyStore);
        Py_CLEAR(state->type_PasswordVault);
        Py_CLEAR(state->type_WebAccount);
        Py_CLEAR(state->type_WebAccountProvider);
        Py_CLEAR(state->type_IWebAccount);

        return 0;
    }


    static PyModuleDef module_def
        = {PyModuleDef_HEAD_INIT,
           "_winsdk_Windows_Security_Credentials",
           module_doc,
           sizeof(module_state),
           module_methods,
           nullptr,
           module_traverse,
           module_clear,
           nullptr};

} // py::cpp::Windows::Security::Credentials

PyMODINIT_FUNC PyInit__winsdk_Windows_Security_Credentials(void) noexcept
{
    using namespace py::cpp::Windows::Security::Credentials;

    py::pyobj_handle module{PyModule_Create(&module_def)};

    if (!module)
    {
        return nullptr;
    }

    auto object_type = py::get_python_type<py::Object>();
    if (!object_type)
    {
        return nullptr;
    }

    py::pyobj_handle bases{PyTuple_Pack(1, object_type)};

    if (!bases)
    {
        return nullptr;
    }

    py::pyobj_handle collections_abc_module{PyImport_ImportModule("collections.abc")};

    if (!collections_abc_module)
    {
        return nullptr;
    }

    py::pyobj_handle sequence_type{PyObject_GetAttrString(collections_abc_module.get(), "Sequence")};

    if (!sequence_type)
    {
        return nullptr;
    }

    py::pyobj_handle sequence_bases{PyTuple_Pack(2, object_type, sequence_type.get())};

    if (!sequence_bases)
    {
        return nullptr;
    }

    py::pyobj_handle mutable_sequence_type{PyObject_GetAttrString(collections_abc_module.get(), "MutableSequence")};

    if (!mutable_sequence_type)
    {
        return nullptr;
    }

    py::pyobj_handle mutable_sequence_bases{PyTuple_Pack(2, object_type, mutable_sequence_type.get())};

    if (!mutable_sequence_bases)
    {
        return nullptr;
    }

    py::pyobj_handle mapping_type{PyObject_GetAttrString(collections_abc_module.get(), "Mapping")};

    if (!mapping_type)
    {
        return nullptr;
    }

    py::pyobj_handle mapping_bases{PyTuple_Pack(2, object_type, mapping_type.get())};

    if (!mapping_bases)
    {
        return nullptr;
    }

    py::pyobj_handle mutable_mapping_type{PyObject_GetAttrString(collections_abc_module.get(), "MutableMapping")};

    if (!mutable_mapping_type)
    {
        return nullptr;
    }

    py::pyobj_handle mutable_mapping_bases{PyTuple_Pack(2, object_type, mutable_mapping_type.get())};

    if (!mutable_mapping_bases)
    {
        return nullptr;
    }

    auto state = reinterpret_cast<module_state*>(PyModule_GetState(module.get()));
    assert(state);

    state->type_KeyCredential = py::register_python_type(module.get(), type_name_KeyCredential, &type_spec_KeyCredential, bases.get());
    if (!state->type_KeyCredential)
    {
        return nullptr;
    }

    Py_INCREF(state->type_KeyCredential);

    state->type_KeyCredentialAttestationResult = py::register_python_type(module.get(), type_name_KeyCredentialAttestationResult, &type_spec_KeyCredentialAttestationResult, bases.get());
    if (!state->type_KeyCredentialAttestationResult)
    {
        return nullptr;
    }

    Py_INCREF(state->type_KeyCredentialAttestationResult);

    state->type_KeyCredentialManager = py::register_python_type(module.get(), type_name_KeyCredentialManager, &type_spec_KeyCredentialManager, nullptr);
    if (!state->type_KeyCredentialManager)
    {
        return nullptr;
    }

    Py_INCREF(state->type_KeyCredentialManager);

    state->type_KeyCredentialOperationResult = py::register_python_type(module.get(), type_name_KeyCredentialOperationResult, &type_spec_KeyCredentialOperationResult, bases.get());
    if (!state->type_KeyCredentialOperationResult)
    {
        return nullptr;
    }

    Py_INCREF(state->type_KeyCredentialOperationResult);

    state->type_KeyCredentialRetrievalResult = py::register_python_type(module.get(), type_name_KeyCredentialRetrievalResult, &type_spec_KeyCredentialRetrievalResult, bases.get());
    if (!state->type_KeyCredentialRetrievalResult)
    {
        return nullptr;
    }

    Py_INCREF(state->type_KeyCredentialRetrievalResult);

    state->type_PasswordCredential = py::register_python_type(module.get(), type_name_PasswordCredential, &type_spec_PasswordCredential, bases.get());
    if (!state->type_PasswordCredential)
    {
        return nullptr;
    }

    Py_INCREF(state->type_PasswordCredential);

    state->type_PasswordCredentialPropertyStore = py::register_python_type(module.get(), type_name_PasswordCredentialPropertyStore, &type_spec_PasswordCredentialPropertyStore, mutable_mapping_bases.get());
    if (!state->type_PasswordCredentialPropertyStore)
    {
        return nullptr;
    }

    Py_INCREF(state->type_PasswordCredentialPropertyStore);

    state->type_PasswordVault = py::register_python_type(module.get(), type_name_PasswordVault, &type_spec_PasswordVault, bases.get());
    if (!state->type_PasswordVault)
    {
        return nullptr;
    }

    Py_INCREF(state->type_PasswordVault);

    state->type_WebAccount = py::register_python_type(module.get(), type_name_WebAccount, &type_spec_WebAccount, bases.get());
    if (!state->type_WebAccount)
    {
        return nullptr;
    }

    Py_INCREF(state->type_WebAccount);

    state->type_WebAccountProvider = py::register_python_type(module.get(), type_name_WebAccountProvider, &type_spec_WebAccountProvider, bases.get());
    if (!state->type_WebAccountProvider)
    {
        return nullptr;
    }

    Py_INCREF(state->type_WebAccountProvider);

    state->type_IWebAccount = py::register_python_type(module.get(), type_name_IWebAccount, &type_spec_IWebAccount, bases.get());
    if (!state->type_IWebAccount)
    {
        return nullptr;
    }

    Py_INCREF(state->type_IWebAccount);


    return module.detach();
}

PyObject* py::py_type<winrt::Windows::Security::Credentials::KeyCredentialAttestationStatus>::get_python_type() noexcept {
    using namespace py::cpp::Windows::Security::Credentials;

    PyObject* module = PyState_FindModule(&module_def);

    if (!module) {
        PyErr_SetString(PyExc_RuntimeError, "could not find module for Windows::Security::Credentials");
        return nullptr;
    }

    auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));
    assert(state);

    auto python_type = state->type_KeyCredentialAttestationStatus;

    if (!python_type) {
        PyErr_SetString(PyExc_RuntimeError, "type winrt::Windows::Security::Credentials::KeyCredentialAttestationStatus is not registered");
        return nullptr;
    }

    return python_type;
}

PyObject* py::py_type<winrt::Windows::Security::Credentials::KeyCredentialCreationOption>::get_python_type() noexcept {
    using namespace py::cpp::Windows::Security::Credentials;

    PyObject* module = PyState_FindModule(&module_def);

    if (!module) {
        PyErr_SetString(PyExc_RuntimeError, "could not find module for Windows::Security::Credentials");
        return nullptr;
    }

    auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));
    assert(state);

    auto python_type = state->type_KeyCredentialCreationOption;

    if (!python_type) {
        PyErr_SetString(PyExc_RuntimeError, "type winrt::Windows::Security::Credentials::KeyCredentialCreationOption is not registered");
        return nullptr;
    }

    return python_type;
}

PyObject* py::py_type<winrt::Windows::Security::Credentials::KeyCredentialStatus>::get_python_type() noexcept {
    using namespace py::cpp::Windows::Security::Credentials;

    PyObject* module = PyState_FindModule(&module_def);

    if (!module) {
        PyErr_SetString(PyExc_RuntimeError, "could not find module for Windows::Security::Credentials");
        return nullptr;
    }

    auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));
    assert(state);

    auto python_type = state->type_KeyCredentialStatus;

    if (!python_type) {
        PyErr_SetString(PyExc_RuntimeError, "type winrt::Windows::Security::Credentials::KeyCredentialStatus is not registered");
        return nullptr;
    }

    return python_type;
}

PyObject* py::py_type<winrt::Windows::Security::Credentials::WebAccountPictureSize>::get_python_type() noexcept {
    using namespace py::cpp::Windows::Security::Credentials;

    PyObject* module = PyState_FindModule(&module_def);

    if (!module) {
        PyErr_SetString(PyExc_RuntimeError, "could not find module for Windows::Security::Credentials");
        return nullptr;
    }

    auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));
    assert(state);

    auto python_type = state->type_WebAccountPictureSize;

    if (!python_type) {
        PyErr_SetString(PyExc_RuntimeError, "type winrt::Windows::Security::Credentials::WebAccountPictureSize is not registered");
        return nullptr;
    }

    return python_type;
}

PyObject* py::py_type<winrt::Windows::Security::Credentials::WebAccountState>::get_python_type() noexcept {
    using namespace py::cpp::Windows::Security::Credentials;

    PyObject* module = PyState_FindModule(&module_def);

    if (!module) {
        PyErr_SetString(PyExc_RuntimeError, "could not find module for Windows::Security::Credentials");
        return nullptr;
    }

    auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));
    assert(state);

    auto python_type = state->type_WebAccountState;

    if (!python_type) {
        PyErr_SetString(PyExc_RuntimeError, "type winrt::Windows::Security::Credentials::WebAccountState is not registered");
        return nullptr;
    }

    return python_type;
}

PyTypeObject* py::winrt_type<winrt::Windows::Security::Credentials::KeyCredential>::get_python_type() noexcept {
    using namespace py::cpp::Windows::Security::Credentials;

    PyObject* module = PyState_FindModule(&module_def);

    if (!module) {
        PyErr_SetString(PyExc_RuntimeError, "could not find module for Windows::Security::Credentials");
        return nullptr;
    }

    auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));
    assert(state);

    auto python_type = state->type_KeyCredential;

    if (!python_type) {
        PyErr_SetString(PyExc_RuntimeError, "type winrt::Windows::Security::Credentials::KeyCredential is not registered");
        return nullptr;
    }

    return python_type;
}

PyTypeObject* py::winrt_type<winrt::Windows::Security::Credentials::KeyCredentialAttestationResult>::get_python_type() noexcept {
    using namespace py::cpp::Windows::Security::Credentials;

    PyObject* module = PyState_FindModule(&module_def);

    if (!module) {
        PyErr_SetString(PyExc_RuntimeError, "could not find module for Windows::Security::Credentials");
        return nullptr;
    }

    auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));
    assert(state);

    auto python_type = state->type_KeyCredentialAttestationResult;

    if (!python_type) {
        PyErr_SetString(PyExc_RuntimeError, "type winrt::Windows::Security::Credentials::KeyCredentialAttestationResult is not registered");
        return nullptr;
    }

    return python_type;
}

PyTypeObject* py::winrt_type<winrt::Windows::Security::Credentials::KeyCredentialManager>::get_python_type() noexcept {
    using namespace py::cpp::Windows::Security::Credentials;

    PyObject* module = PyState_FindModule(&module_def);

    if (!module) {
        PyErr_SetString(PyExc_RuntimeError, "could not find module for Windows::Security::Credentials");
        return nullptr;
    }

    auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));
    assert(state);

    auto python_type = state->type_KeyCredentialManager;

    if (!python_type) {
        PyErr_SetString(PyExc_RuntimeError, "type winrt::Windows::Security::Credentials::KeyCredentialManager is not registered");
        return nullptr;
    }

    return python_type;
}

PyTypeObject* py::winrt_type<winrt::Windows::Security::Credentials::KeyCredentialOperationResult>::get_python_type() noexcept {
    using namespace py::cpp::Windows::Security::Credentials;

    PyObject* module = PyState_FindModule(&module_def);

    if (!module) {
        PyErr_SetString(PyExc_RuntimeError, "could not find module for Windows::Security::Credentials");
        return nullptr;
    }

    auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));
    assert(state);

    auto python_type = state->type_KeyCredentialOperationResult;

    if (!python_type) {
        PyErr_SetString(PyExc_RuntimeError, "type winrt::Windows::Security::Credentials::KeyCredentialOperationResult is not registered");
        return nullptr;
    }

    return python_type;
}

PyTypeObject* py::winrt_type<winrt::Windows::Security::Credentials::KeyCredentialRetrievalResult>::get_python_type() noexcept {
    using namespace py::cpp::Windows::Security::Credentials;

    PyObject* module = PyState_FindModule(&module_def);

    if (!module) {
        PyErr_SetString(PyExc_RuntimeError, "could not find module for Windows::Security::Credentials");
        return nullptr;
    }

    auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));
    assert(state);

    auto python_type = state->type_KeyCredentialRetrievalResult;

    if (!python_type) {
        PyErr_SetString(PyExc_RuntimeError, "type winrt::Windows::Security::Credentials::KeyCredentialRetrievalResult is not registered");
        return nullptr;
    }

    return python_type;
}

PyTypeObject* py::winrt_type<winrt::Windows::Security::Credentials::PasswordCredential>::get_python_type() noexcept {
    using namespace py::cpp::Windows::Security::Credentials;

    PyObject* module = PyState_FindModule(&module_def);

    if (!module) {
        PyErr_SetString(PyExc_RuntimeError, "could not find module for Windows::Security::Credentials");
        return nullptr;
    }

    auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));
    assert(state);

    auto python_type = state->type_PasswordCredential;

    if (!python_type) {
        PyErr_SetString(PyExc_RuntimeError, "type winrt::Windows::Security::Credentials::PasswordCredential is not registered");
        return nullptr;
    }

    return python_type;
}

PyTypeObject* py::winrt_type<winrt::Windows::Security::Credentials::PasswordCredentialPropertyStore>::get_python_type() noexcept {
    using namespace py::cpp::Windows::Security::Credentials;

    PyObject* module = PyState_FindModule(&module_def);

    if (!module) {
        PyErr_SetString(PyExc_RuntimeError, "could not find module for Windows::Security::Credentials");
        return nullptr;
    }

    auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));
    assert(state);

    auto python_type = state->type_PasswordCredentialPropertyStore;

    if (!python_type) {
        PyErr_SetString(PyExc_RuntimeError, "type winrt::Windows::Security::Credentials::PasswordCredentialPropertyStore is not registered");
        return nullptr;
    }

    return python_type;
}

PyTypeObject* py::winrt_type<winrt::Windows::Security::Credentials::PasswordVault>::get_python_type() noexcept {
    using namespace py::cpp::Windows::Security::Credentials;

    PyObject* module = PyState_FindModule(&module_def);

    if (!module) {
        PyErr_SetString(PyExc_RuntimeError, "could not find module for Windows::Security::Credentials");
        return nullptr;
    }

    auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));
    assert(state);

    auto python_type = state->type_PasswordVault;

    if (!python_type) {
        PyErr_SetString(PyExc_RuntimeError, "type winrt::Windows::Security::Credentials::PasswordVault is not registered");
        return nullptr;
    }

    return python_type;
}

PyTypeObject* py::winrt_type<winrt::Windows::Security::Credentials::WebAccount>::get_python_type() noexcept {
    using namespace py::cpp::Windows::Security::Credentials;

    PyObject* module = PyState_FindModule(&module_def);

    if (!module) {
        PyErr_SetString(PyExc_RuntimeError, "could not find module for Windows::Security::Credentials");
        return nullptr;
    }

    auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));
    assert(state);

    auto python_type = state->type_WebAccount;

    if (!python_type) {
        PyErr_SetString(PyExc_RuntimeError, "type winrt::Windows::Security::Credentials::WebAccount is not registered");
        return nullptr;
    }

    return python_type;
}

PyTypeObject* py::winrt_type<winrt::Windows::Security::Credentials::WebAccountProvider>::get_python_type() noexcept {
    using namespace py::cpp::Windows::Security::Credentials;

    PyObject* module = PyState_FindModule(&module_def);

    if (!module) {
        PyErr_SetString(PyExc_RuntimeError, "could not find module for Windows::Security::Credentials");
        return nullptr;
    }

    auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));
    assert(state);

    auto python_type = state->type_WebAccountProvider;

    if (!python_type) {
        PyErr_SetString(PyExc_RuntimeError, "type winrt::Windows::Security::Credentials::WebAccountProvider is not registered");
        return nullptr;
    }

    return python_type;
}

PyTypeObject* py::winrt_type<winrt::Windows::Security::Credentials::IWebAccount>::get_python_type() noexcept {
    using namespace py::cpp::Windows::Security::Credentials;

    PyObject* module = PyState_FindModule(&module_def);

    if (!module) {
        PyErr_SetString(PyExc_RuntimeError, "could not find module for Windows::Security::Credentials");
        return nullptr;
    }

    auto state = reinterpret_cast<module_state*>(PyModule_GetState(module));
    assert(state);

    auto python_type = state->type_IWebAccount;

    if (!python_type) {
        PyErr_SetString(PyExc_RuntimeError, "type winrt::Windows::Security::Credentials::IWebAccount is not registered");
        return nullptr;
    }

    return python_type;
}
