<!--
# Autogenerated from Broadworks XML Schemas
# Do not edit as changes will be overwritten.
# Generated on 2022-03-12T10:21:34.210723
-->
# Types


## `AccessDevice`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Uniquely identifies an Identity/device profile created anywhere in the system.


**Attributes:**

|Name         |Type|Description |
|-------------|----|------------|
|device_level |str |deviceLevel |
|device_name  |str |deviceName  |
</div>


## `AccessDeviceKey`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Key to uniquely identify a system, service provider, or group device.


**Attributes:**

|Name                |Type|Description                  |
|--------------------|----|-----------------------------|
|service_provider_id |str |serviceProviderId *Optional* |
|group_id            |str |groupId *Optional*           |
|device_name         |str |deviceName                   |
</div>


## `AccessDeviceReorderEndpointIdentity`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point identity in the context of a reorder command.

The following elements are only used in XS data mode and ignored in AS data mode:
privateIdentity

**Attributes:**

|Name             |Type|Description                |
|-----------------|----|---------------------------|
|line_port        |str |linePort                   |
|private_identity |str |privateIdentity *Optional* |
</div>


## `AccessDeviceTypeRename`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Pair of DeviceManagementTagSetName

**Attributes:**

|Name                      |Type|Description            |
|--------------------------|----|-----------------------|
|original_device_type_name |str |originalDeviceTypeName |
|new_device_type_name      |str |newDeviceTypeName      |
</div>


## `AccountAuthorizationCodeEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Account/Authorization Code.


**Attributes:**

|Name        |Type|Description            |
|------------|----|-----------------------|
|code        |str |code                   |
|description |str |description *Optional* |
</div>


## `ActivatableDN`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Activatable directory Number in E164 Format.


**Attributes:**

|Name     |Type |Description         |
|---------|-----|--------------------|
|dn       |str  |DN                  |
|activate |bool |activate *Optional* |
</div>


## `ActivatableDNRange`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Activatable directory number range.

The minimum and maximum values are inclusive.

**Attributes:**

|Name             |Type |Description         |
|-----------------|-----|--------------------|
|min_phone_number |str  |minPhoneNumber      |
|max_phone_number |str  |maxPhoneNumber      |
|activate         |bool |activate *Optional* |
</div>


## `AdditionalMessageOptionsMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal additional message options modify entry.


**Attributes:**

|Name                    |Type|Description                     |
|------------------------|----|--------------------------------|
|save_message            |str |saveMessage *Optional*          |
|delete_message          |str |deleteMessage *Optional*        |
|play_envelope           |str |playEnvelope *Optional*         |
|callback_caller         |str |callbackCaller *Optional*       |
|compose_message         |str |composeMessage *Optional*       |
|reply_message           |str |replyMessage *Optional*         |
|forward_message         |str |forwardMessage *Optional*       |
|personalized_name       |str |personalizedName *Optional*     |
|passcode                |str |passcode *Optional*             |
|return_to_previous_menu |str |returnToPreviousMenu *Optional* |
|repeat_menu             |str |repeatMenu *Optional*           |
</div>


## `AdditionalMessageOptionsMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal additional message options menu keys.


**Attributes:**

|Name                    |Type|Description                 |
|------------------------|----|----------------------------|
|save_message            |str |saveMessage *Optional*      |
|delete_message          |str |deleteMessage *Optional*    |
|play_envelope           |str |playEnvelope *Optional*     |
|callback_caller         |str |callbackCaller *Optional*   |
|compose_message         |str |composeMessage *Optional*   |
|reply_message           |str |replyMessage *Optional*     |
|forward_message         |str |forwardMessage *Optional*   |
|personalized_name       |str |personalizedName *Optional* |
|passcode                |str |passcode *Optional*         |
|return_to_previous_menu |str |returnToPreviousMenu        |
|repeat_menu             |str |repeatMenu *Optional*       |
</div>


## `AdviceOfChargeCostInformationSourceEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The advice of charge cost information source entry.


**Attributes:**

|Name          |Type|Description  |
|--------------|----|-------------|
|peer_identity |str |peerIdentity |
|priority      |int |priority     |
</div>


## `AgentStatistics`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains Call Center Agent statistics for a given time frame.


**Attributes:**

|Name                       |Type|Description             |
|---------------------------|----|------------------------|
|number_of_calls_handled    |int |numberOfCallsHandled    |
|number_of_calls_unanswered |int |numberOfCallsUnanswered |
|average_call_seconds       |int |averageCallSeconds      |
|total_talk_seconds         |int |totalTalkSeconds        |
|total_staffed_seconds      |int |totalStaffedSeconds     |
</div>


## `AlternateNumberEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Alternate Number Entry.


**Attributes:**

|Name         |Type|Description            |
|-------------|----|-----------------------|
|phone_number |str |phoneNumber *Optional* |
|extension    |str |extension *Optional*   |
|ring_pattern |str |ringPattern *Optional* |
</div>


## `AlternateNumberEntry17`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Alternate Number Entry.


**Attributes:**

|Name         |Type|Description            |
|-------------|----|-----------------------|
|phone_number |str |phoneNumber *Optional* |
|extension    |str |extension *Optional*   |
|ring_pattern |str |ringPattern *Optional* |
</div>


## `AlternateNumberEntry21`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Alternate Number Entry.


**Attributes:**

|Name         |Type|Description            |
|-------------|----|-----------------------|
|phone_number |str |phoneNumber *Optional* |
|extension    |str |extension *Optional*   |
|ring_pattern |str |ringPattern *Optional* |
|description  |str |description *Optional* |
</div>


## `AlternateUserIdEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Alternate user id.


**Attributes:**

|Name              |Type|Description            |
|------------------|----|-----------------------|
|alternate_user_id |str |alternateUserId        |
|description       |str |description *Optional* |
</div>


## `AnnouncementFileKey`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Uniquely identifies a file within a group or user repository.


**Attributes:**

|Name            |Type|Description   |
|----------------|----|--------------|
|name            |str |name          |
|media_file_type |str |mediaFileType |
</div>


## `AnnouncementFileLevelKey`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Uniquely identifies a file within a group or user repository.

Includes level to distinguish between group and user announcements in scenarios where
both are listed.

**Attributes:**

|Name            |Type|Description   |
|----------------|----|--------------|
|name            |str |name          |
|media_file_type |str |mediaFileType |
|level           |str |level         |
</div>


## `AnnouncementMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal announcement menu keys modify entry.


**Attributes:**

|Name                    |Type|Description                     |
|------------------------|----|--------------------------------|
|record_audio            |str |recordAudio *Optional*          |
|record_audio_video      |str |recordAudioVideo *Optional*     |
|return_to_previous_menu |str |returnToPreviousMenu *Optional* |
|repeat_menu             |str |repeatMenu *Optional*           |
</div>


## `AnnouncementMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal announcement menu keys.


**Attributes:**

|Name                    |Type|Description                 |
|------------------------|----|----------------------------|
|record_audio            |str |recordAudio *Optional*      |
|record_audio_video      |str |recordAudioVideo *Optional* |
|return_to_previous_menu |str |returnToPreviousMenu        |
|repeat_menu             |str |repeatMenu *Optional*       |
</div>


## `AnnouncementRecordingMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal announcement recording menu keys modify entry.


**Attributes:**

|Name                    |Type|Description                     |
|------------------------|----|--------------------------------|
|accept_recording        |str |acceptRecording *Optional*      |
|reject_rerecord         |str |rejectRerecord *Optional*       |
|return_to_previous_menu |str |returnToPreviousMenu *Optional* |
|repeat_menu             |str |repeatMenu *Optional*           |
|end                     |str |end *Optional*                  |
</div>


## `AnnouncementRecordingMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal announcement recording menu keys.


**Attributes:**

|Name                    |Type|Description           |
|------------------------|----|----------------------|
|accept_recording        |str |acceptRecording       |
|reject_rerecord         |str |rejectRerecord        |
|return_to_previous_menu |str |returnToPreviousMenu  |
|repeat_menu             |str |repeatMenu *Optional* |
|end                     |str |end                   |
</div>


## `AssignedGroupServicesEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Assigned Group Services List Entry.

The isActive element is true, false, or could be missing completely.

**Attributes:**

|Name         |Type |Description         |
|-------------|-----|--------------------|
|service_name |str  |serviceName         |
|is_active    |bool |isActive *Optional* |
</div>


## `AssignedUserServicesEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Assigned User Services List Entry.

The isActive element is true, false, or could be missing completely.

**Attributes:**

|Name         |Type |Description         |
|-------------|-----|--------------------|
|service_name |str  |serviceName         |
|is_active    |bool |isActive *Optional* |
</div>


## `AutoAttendantKeyConfigurationReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The read configuration entry of a key for Auto Attendant.

The following elements are only used in AS data mode and not returned in XS data mode:
audioFileDescription audioMediaType videoFileDescription videoMediaType

**Attributes:**

|Name                   |Type|Description                     |
|-----------------------|----|--------------------------------|
|description            |str |description *Optional*          |
|action                 |str |action                          |
|phone_number           |str |phoneNumber *Optional*          |
|audio_file_description |str |audioFileDescription *Optional* |
|audio_media_type       |str |audioMediaType *Optional*       |
|video_file_description |str |videoFileDescription *Optional* |
|video_media_type       |str |videoMediaType *Optional*       |
</div>


## `AutoAttendantKeyConfigurationReadEntry19`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The read configuration entry of a key for Auto Attendant.

The following data elements are only valid for Standard Auto Attendants: submenuId

**Attributes:**

|Name                   |Type|Description                     |
|-----------------------|----|--------------------------------|
|description            |str |description *Optional*          |
|action                 |str |action                          |
|phone_number           |str |phoneNumber *Optional*          |
|audio_file_description |str |audioFileDescription *Optional* |
|audio_media_type       |str |audioMediaType *Optional*       |
|video_file_description |str |videoFileDescription *Optional* |
|video_media_type       |str |videoMediaType *Optional*       |
|submenu_id             |str |submenuId *Optional*            |
</div>


## `AutomaticCollectCallPrefixDigitsEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The Automatic Collect Call prefix digits entry.


**Attributes:**

|Name          |Type|Description  |
|--------------|----|-------------|
|country_code  |str |countryCode  |
|prefix_digits |str |prefixDigits |
</div>


## `BasicCallLogsEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Call Log entry describing a placed, received, or missed call.

Replaced By: CallLogsEntry

**Attributes:**

|Name         |Type|Description            |
|-------------|----|-----------------------|
|country_code |str |countryCode *Optional* |
|phone_number |str |phoneNumber            |
|name         |str |name                   |
|time         |str |time                   |
</div>


## `BroadWorksMobilityAlertingMobileNumberReplacementList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of Mobile Numbers to be alerted.

By convention, an element of this type may be set nil to clear the list.

**Attributes:**

|Name          |Type      |Description  |
|--------------|----------|-------------|
|mobile_number |List[str] |mobileNumber |
</div>


## `BroadWorksMobilityUserMobileIdentityEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
User's Mobile Identity Read Entry

**Attributes:**

|Name            |Type |Description            |
|----------------|-----|-----------------------|
|mobile_number   |str  |mobileNumber           |
|description     |str  |description *Optional* |
|is_primary      |bool |isPrimary              |
|enable_alerting |bool |enableAlerting         |
</div>


## `BroadWorksMobilityUserMobileIdentityModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
User's Mobile Identity Modify Entry

**Attributes:**

|Name            |Type |Description               |
|----------------|-----|--------------------------|
|mobile_number   |str  |mobileNumber              |
|description     |str  |description *Optional*    |
|is_primary      |bool |isPrimary *Optional*      |
|enable_alerting |bool |enableAlerting *Optional* |
</div>


## `CPEDeviceOptions`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CPE device's options.

Replaced by: CPEDeviceOptions14sp6

**Attributes:**

|Name               |Type |Description           |
|-------------------|-----|----------------------|
|enable_monitoring  |bool |enableMonitoring      |
|reset_event        |str  |resetEvent *Optional* |
|config_type        |str  |configType            |
|system_file_name   |str  |systemFileName        |
|device_file_format |str  |deviceFileFormat      |
</div>


## `CallBlockingServiceMapEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The call blocking service map entry.


**Attributes:**

|Name                  |Type|Description            |
|----------------------|----|-----------------------|
|call_blocking_service |str |callBlockingService    |
|treatment_id          |str |treatmentId *Optional* |
</div>


## `CallCenterAgentAvailability`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Specifies an agent's login state (availability) for a particular Call Center.


**Attributes:**

|Name            |Type |Description   |
|----------------|-----|--------------|
|service_user_id |str  |serviceUserId |
|available       |bool |available     |
</div>


## `CallCenterAgentDailyStatistics13mp8`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains Call Center Agent statistics for one day.


**Attributes:**

|Name                            |Type|Description                |
|--------------------------------|----|---------------------------|
|number_of_calls_received        |int |numberOfCallsReceived      |
|number_of_calls_not_answered    |int |numberOfCallsNotAnswered   |
|average_time_per_call_seconds   |int |averageTimePerCallSeconds  |
|time_in_calls_seconds           |int |timeInCallsSeconds         |
|time_logged_off_seconds         |int |timeLoggedOffSeconds       |
|time_logged_on_and_idle_seconds |int |timeLoggedOnAndIdleSeconds |
</div>


## `CallCenterAgentSettings`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Specifies an agent's settings for a particular Call Center.

The skillLevel only applies to Premium agents.

**Attributes:**

|Name            |Type |Description           |
|----------------|-----|----------------------|
|service_user_id |str  |serviceUserId         |
|available       |bool |available *Optional*  |
|skill_level     |int  |skillLevel *Optional* |
</div>


## `CallCenterAgentThresholdProfileReplacementNotificationEmailList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
List of email addresses to which the Agent Threshold Profile email is sent.

The list replaces a previously configured list.

**Attributes:**

|Name          |Type      |Description  |
|--------------|----------|-------------|
|email_address |List[str] |emailAddress |
</div>


## `CallCenterAgentUnavailableCodeStateModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains a Call Center Agent Unavailable Code and its active state

**Attributes:**

|Name      |Type |Description|
|----------|-----|-----------|
|code      |str  |code       |
|is_active |bool |isActive   |
</div>


## `CallCenterAnnouncementDescriptionList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains list of file descriptions for audio or video files

**Attributes:**

|Name              |Type|Description                 |
|------------------|----|----------------------------|
|file_description1 |str |fileDescription1 *Optional* |
|file_description2 |str |fileDescription2 *Optional* |
|file_description3 |str |fileDescription3 *Optional* |
|file_description4 |str |fileDescription4 *Optional* |
</div>


## `CallCenterAnnouncementMediaFileTypeList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains list of file media types for audio or video files

**Attributes:**

|Name        |Type|Description           |
|------------|----|----------------------|
|media_type1 |str |mediaType1 *Optional* |
|media_type2 |str |mediaType2 *Optional* |
|media_type3 |str |mediaType3 *Optional* |
|media_type4 |str |mediaType4 *Optional* |
</div>


## `CallCenterAnnouncementURLList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains list of urls

**Attributes:**

|Name |Type|Description     |
|-----|----|----------------|
|url1 |str |url1 *Optional* |
|url2 |str |url2 *Optional* |
|url3 |str |url3 *Optional* |
|url4 |str |url4 *Optional* |
</div>


## `CallCenterAnnouncementURLListModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains a list of URLs for modify.


**Attributes:**

|Name |Type|Description     |
|-----|----|----------------|
|url1 |str |url1 *Optional* |
|url2 |str |url2 *Optional* |
|url3 |str |url3 *Optional* |
|url4 |str |url4 *Optional* |
</div>


## `CallCenterMusicOnHoldSourceModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold source configuration.


**Attributes:**

|Name                       |Type         |Description                        |
|---------------------------|-------------|-----------------------------------|
|audio_file_preferred_codec |str          |audioFilePreferredCodec *Optional* |
|message_source_selection   |str          |messageSourceSelection *Optional*  |
|custom_source              |customSource |customSource *Optional*            |
</div>


## `CallCenterMusicOnHoldSourceRead`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold source configuration.


**Attributes:**

|Name                       |Type         |Description             |
|---------------------------|-------------|------------------------|
|audio_file_preferred_codec |str          |audioFilePreferredCodec |
|message_source_selection   |str          |messageSourceSelection  |
|custom_source              |customSource |customSource *Optional* |
</div>


## `CallCenterQueueStatistics13mp8`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains Call Center Queue statistics.


**Attributes:**

|Name                                       |Type|Description                          |
|-------------------------------------------|----|-------------------------------------|
|number_of_incoming_calls                   |int |numberOfIncomingCalls                |
|number_of_calls_queued                     |int |numberOfCallsQueued                  |
|number_of_busy_overflows                   |int |numberOfBusyOverflows                |
|number_of_calls_answered                   |int |numberOfCallsAnswered                |
|average_time_with_agent_seconds            |int |averageTimeWithAgentSeconds          |
|average_time_in_queue_seconds              |int |averageTimeInQueueSeconds            |
|average_number_of_agents_busy              |int |averageNumberOfAgentsBusy            |
|average_number_of_agents_logged_off        |int |averageNumberOfAgentsLoggedOff       |
|average_hold_time_before_call_loss_seconds |int |averageHoldTimeBeforeCallLossSeconds |
</div>


## `CallCenterQueueStatistics14sp9`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains Call Center Queue statistics.


**Attributes:**

|Name                             |Type|Description                  |
|---------------------------------|----|-----------------------------|
|number_of_busy_overflows         |int |numberOfBusyOverflows        |
|number_of_calls_answered         |int |numberOfCallsAnswered        |
|number_of_calls_abandoned        |int |numberOfCallsAbandoned       |
|number_of_calls_transferred      |int |numberOfCallsTransferred     |
|number_of_calls_timedout         |int |numberOfCallsTimedout        |
|average_number_of_agents_talking |int |averageNumberOfAgentsTalking |
|average_number_of_agents_staffed |int |averageNumberOfAgentsStaffed |
|average_wait_seconds             |int |averageWaitSeconds           |
|average_abandonment_seconds      |int |averageAbandonmentSeconds    |
</div>


## `CallCenterQueueThresholdReplacementNotificationEmailList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
List of email addresses to which the Call Center Queue Threshold email is sent.

The list replaces a previously configured list.

**Attributes:**

|Name          |Type      |Description  |
|--------------|----------|-------------|
|email_address |List[str] |emailAddress |
</div>


## `CallCenterReportAbandonedCallThresholdReplacementList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of call center reporting abandoned call threshold seconds that replaces a
previously configured list.


**Attributes:**

|Name                             |Type      |Description                   |
|---------------------------------|----------|------------------------------|
|abandoned_call_threshold_seconds |List[int] |abandonedCallThresholdSeconds |
</div>


## `CallCenterReportCurrentInterval`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The call center enhanced reporting report current interval, for example, current week.


**Attributes:**

|Name      |Type|Description|
|----------|----|-----------|
|time_unit |str |timeUnit   |
</div>


## `CallCenterReportDataTemplateInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Call center reporting data template info.


**Attributes:**

|Name                                                |Type |Description                                   |
|----------------------------------------------------|-----|----------------------------------------------|
|data_template                                       |str  |dataTemplate                                  |
|report_type                                         |str  |reportType                                    |
|is_realtime_report                                  |bool |isRealtimeReport                              |
|is_agent_param_required                             |str  |isAgentParamRequired                          |
|is_call_center_param_required                       |str  |isCallCenterParamRequired                     |
|is_call_center_dnis_param_required                  |str  |isCallCenterDnisParamRequired                 |
|is_sampling_period_param_required                   |str  |isSamplingPeriodParamRequired                 |
|is_call_completion_threshold_param_required         |str  |isCallCompletionThresholdParamRequired        |
|is_short_duration_threshold_param_required          |str  |isShortDurationThresholdParamRequired         |
|is_service_level_threshold_param_required           |str  |isServiceLevelThresholdParamRequired          |
|is_service_level_inclusions_param_required          |str  |isServiceLevelInclusionsParamRequired         |
|is_service_level_objective_threshold_param_required |str  |isServiceLevelObjectiveThresholdParamRequired |
|is_abandoned_call_threshold_param_required          |str  |isAbandonedCallThresholdParamRequired         |
</div>


## `CallCenterReportDataTemplateQueryFilterValueReplacementList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of call center reporting data template query filter values that replaces a
previously configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name         |Type      |Description |
|-------------|----------|------------|
|filter_value |List[str] |filterValue |
</div>


## `CallCenterReportPastInterval`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The call center enhanced reporting report past interval, for example, last 24 month.


**Attributes:**

|Name      |Type|Description|
|----------|----|-----------|
|number    |int |number     |
|time_unit |str |timeUnit   |
</div>


## `CallCenterReportReplacementEmailList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of call center reporting email addresses that replaces a previously configured
list.


**Attributes:**

|Name          |Type      |Description  |
|--------------|----------|-------------|
|email_address |List[str] |emailAddress |
</div>


## `CallCenterReportServiceLevelThresholdReplacementList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of call center reporting service level threshold seconds that replaces a
previously configured list.


**Attributes:**

|Name                            |Type      |Description                  |
|--------------------------------|----------|-----------------------------|
|service_level_threshold_seconds |List[int] |serviceLevelThresholdSeconds |
</div>


## `CallCenterReportTemplateKey`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Uniquely identifies a call center report template created in the system.


**Attributes:**

|Name           |Type|Description   |
|---------------|----|--------------|
|template_level |str |templateLevel |
|template_name  |str |templateName  |
</div>


## `CallCenterRoutingPriorityOrder`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Call center routing order

**Attributes:**

|Name            |Type|Description   |
|----------------|----|--------------|
|service_user_id |str |serviceUserId |
|priority        |str |priority      |
</div>


## `CallCenterScheduledReportAgentSelection`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Either all agents or list of agents.


**Attributes:**

|Name          |Type      |Description            |
|--------------|----------|-----------------------|
|all_agent     |bool      |allAgent *Optional*    |
|agent_user_id |List[str] |agentUserId *Optional* |
</div>


## `CallCenterScheduledReportAgentSelectionAdminRead`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Either all agents or 2 list of agents: one for current and one for past (deleted)
agents.

This is used when an admin reads a Scheduled Report.  Each agent table has the
following column headings: "User Id", "Last Name", "First Name", "Hiragana Last Name"
and "Hiragana First Name".

**Attributes:**

|Name                |Type                    |Description                                                                    |
|--------------------|------------------------|-------------------------------------------------------------------------------|
|all_agent           |bool                    |allAgent *Optional*                                                            |
|current_agent_table |List(currentAgentTable) |currentAgentTable - *Table* array of currentAgentTable named tuples *Optional* |
|past_agent_table    |List(pastAgentTable)    |pastAgentTable - *Table* array of pastAgentTable named tuples *Optional*       |
</div>


## `CallCenterScheduledReportAgentSelectionRead`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Either all agents or list of agents.

The agent table has the following column headings: "User Id", "Last Name", "First
Name", "Hiragana Last Name" and "Hiragana First Name".

**Attributes:**

|Name        |Type             |Description                                                      |
|------------|-----------------|-----------------------------------------------------------------|
|all_agent   |bool             |allAgent *Optional*                                              |
|agent_table |List(agentTable) |agentTable - *Table* array of agentTable named tuples *Optional* |
</div>


## `CallCenterScheduledReportCallCenterSelection`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Either all call centers or list of call centers.


**Attributes:**

|Name            |Type      |Description              |
|----------------|----------|-------------------------|
|all_call_center |bool      |allCallCenter *Optional* |
|service_user_id |List[str] |serviceUserId *Optional* |
</div>


## `CallCenterScheduledReportCallCenterSelectionRead`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
User for admin read.

Either all call centers or 2 lists of call centers: one for current and one for
deleted call centers.

**Attributes:**

|Name            |Type      |Description              |
|----------------|----------|-------------------------|
|all_call_center |bool      |allCallCenter *Optional* |
|current_user_id |List[str] |currentUserId *Optional* |
|past_user_id    |List[str] |pastUserId *Optional*    |
</div>


## `CallCenterScheduledReportDNISSelection`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Either all DNIS under the specified Call Center or list of DNIS.


**Attributes:**

|Name            |Type      |Description        |
|----------------|----------|-------------------|
|service_user_id |str       |serviceUserId      |
|all_dnis        |bool      |allDNIS *Optional* |
|name            |List[str] |name *Optional*    |
</div>


## `CallCenterScheduledReportDNISSelectionRead`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Either all DNIS under the specified Call Center or 2 lists of DNIS, one for current
one for past (deleted).


**Attributes:**

|Name            |Type      |Description            |
|----------------|----------|-----------------------|
|service_user_id |str       |serviceUserId          |
|deleted         |bool      |deleted *Optional*     |
|all_dnis        |bool      |allDNIS *Optional*     |
|current_name    |List[str] |currentName *Optional* |
|past_name       |List[str] |pastName *Optional*    |
</div>


## `CallCenterScheduledReportServiceLevelInclusions`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The call center enhanced reporting scheduled report inclusions related to the Service
Level thresholds

**Attributes:**

|Name                                              |Type |Description                                 |
|--------------------------------------------------|-----|--------------------------------------------|
|include_overflow_time_transfered_in_service_level |bool |includeOverflowTimeTransferedInServiceLevel |
|include_other_transfers_in_service_level          |bool |includeOtherTransfersInServiceLevel         |
|abandoned_calls_in_service_level                  |str  |abandonedCallsInServiceLevel                |
|abandoned_call_interval_seconds                   |int  |abandonedCallIntervalSeconds *Optional*     |
</div>


## `CallCenterScheduledReportServiceLevelInclusionsModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The call center enhanced reporting scheduled report modified inclusions related to the
Service Level thresholds

**Attributes:**

|Name                                              |Type |Description                                            |
|--------------------------------------------------|-----|-------------------------------------------------------|
|include_overflow_time_transfered_in_service_level |bool |includeOverflowTimeTransferedInServiceLevel *Optional* |
|include_other_transfers_in_service_level          |bool |includeOtherTransfersInServiceLevel *Optional*         |
|abandoned_calls_in_service_level                  |str  |abandonedCallsInServiceLevel *Optional*                |
|abandoned_call_interval_seconds                   |int  |abandonedCallIntervalSeconds *Optional*                |
</div>


## `CallCenterSkillAgentList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of agents for a particular skill Level.


**Attributes:**

|Name        |Type      |Description      |
|------------|----------|-----------------|
|skill_level |int       |skillLevel       |
|agent       |List[str] |agent *Optional* |
</div>


## `CallCenterStatisticsRange`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Statistics Range

**Attributes:**

|Name  |Type|Description    |
|------|----|---------------|
|start |str |start          |
|end   |str |end *Optional* |
</div>


## `CallDispositionCodeActivation`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains a Call Center Call Disposition Code and its active state

**Attributes:**

|Name      |Type |Description|
|----------|-----|-----------|
|code      |str  |code       |
|is_active |bool |isActive   |
</div>


## `CallDispositionCodeWithLevel`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains a Call Center Call Disposition Code and its Level

**Attributes:**

|Name  |Type|Description|
|------|----|-----------|
|code  |str |code       |
|level |str |level      |
</div>


## `CallForwardingOptionsMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal call forwarding option menu keys modify entry.


**Attributes:**

|Name                               |Type|Description                                |
|-----------------------------------|----|-------------------------------------------|
|activate_call_forwarding           |str |activateCallForwarding *Optional*          |
|deactivate_call_forwarding         |str |deactivateCallForwarding *Optional*        |
|change_call_forwarding_destination |str |changeCallForwardingDestination *Optional* |
|listen_to_call_forwarding_status   |str |listenToCallForwardingStatus *Optional*    |
|return_to_previous_menu            |str |returnToPreviousMenu *Optional*            |
|repeat_menu                        |str |repeatMenu *Optional*                      |
</div>


## `CallForwardingOptionsMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">


**Attributes:**

|Name                               |Type|Description                                |
|-----------------------------------|----|-------------------------------------------|
|activate_call_forwarding           |str |activateCallForwarding *Optional*          |
|deactivate_call_forwarding         |str |deactivateCallForwarding *Optional*        |
|change_call_forwarding_destination |str |changeCallForwardingDestination *Optional* |
|listen_to_call_forwarding_status   |str |listenToCallForwardingStatus *Optional*    |
|return_to_previous_menu            |str |returnToPreviousMenu                       |
|repeat_menu                        |str |repeatMenu *Optional*                      |
</div>


## `CallLogsEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Call Log entry describing a placed, received, or missed call.


**Attributes:**

|Name         |Type|Description            |
|-------------|----|-----------------------|
|country_code |str |countryCode *Optional* |
|call_log_id  |str |callLogId              |
|phone_number |str |phoneNumber            |
|name         |str |name                   |
|time         |str |time                   |
</div>


## `CallMeNowToDnCriteria`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The To dn criteria used on the call me now external number.


**Attributes:**

|Name                     |Type      |Description            |
|-------------------------|----------|-----------------------|
|to_dn_criteria_selection |str       |toDnCriteriaSelection  |
|phone_number             |List[str] |phoneNumber *Optional* |
</div>


## `CallToNumber`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Call to Number.


**Attributes:**

|Name      |Type|Description          |
|----------|----|---------------------|
|type      |str |type                 |
|number    |str |number *Optional*    |
|extension |str |extension *Optional* |
</div>


## `CallTypeMappingEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The call type mapping entry.


**Attributes:**

|Name         |Type|Description |
|-------------|----|------------|
|country_code |str |countryCode |
|digit_map    |str |digitMap    |
|call_type    |str |callType    |
</div>


## `CallTypeMappingKey`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The call type mapping Key.


**Attributes:**

|Name         |Type|Description |
|-------------|----|------------|
|country_code |str |countryCode |
|digit_map    |str |digitMap    |
</div>


## `ChangeBusyOrNoAnswerGreetingMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal change busy or not answer greeting menu keys modify entry.


**Attributes:**

|Name                              |Type|Description                              |
|----------------------------------|----|-----------------------------------------|
|record_new_greeting               |str |recordNewGreeting *Optional*             |
|listen_to_current_greeting        |str |listenToCurrentGreeting *Optional*       |
|revert_to_system_default_greeting |str |revertToSystemDefaultGreeting *Optional* |
|return_to_previous_menu           |str |returnToPreviousMenu *Optional*          |
|repeat_menu                       |str |repeatMenu *Optional*                    |
</div>


## `ChangeBusyOrNoAnswerGreetingMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal change busy or not answer greeting menu keys.


**Attributes:**

|Name                              |Type|Description                              |
|----------------------------------|----|-----------------------------------------|
|record_new_greeting               |str |recordNewGreeting *Optional*             |
|listen_to_current_greeting        |str |listenToCurrentGreeting *Optional*       |
|revert_to_system_default_greeting |str |revertToSystemDefaultGreeting *Optional* |
|return_to_previous_menu           |str |returnToPreviousMenu                     |
|repeat_menu                       |str |repeatMenu *Optional*                    |
</div>


## `ChangeCallForwardingDestinationMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal change call forwarding destination menu keys modify entry.


**Attributes:**

|Name                                   |Type|Description                                   |
|---------------------------------------|----|----------------------------------------------|
|finish_entering_new_destination_number |str |finishEnteringNewDestinationNumber *Optional* |
</div>


## `ChangeCallForwardingDestinationMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal change call forwarding destination menu keys.


**Attributes:**

|Name                                   |Type|Description                        |
|---------------------------------------|----|-----------------------------------|
|finish_entering_new_destination_number |str |finishEnteringNewDestinationNumber |
</div>


## `ChangeCurrentIntroductionOrMessageOrReplyMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal change current introduction or message or reply menu keys modify
entry.


**Attributes:**

|Name          |Type|Description             |
|--------------|----|------------------------|
|end_recording |str |endRecording *Optional* |
</div>


## `ChangeCurrentIntroductionOrMessageOrReplyMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal change current introduction or message or reply menu keys.


**Attributes:**

|Name          |Type|Description  |
|--------------|----|-------------|
|end_recording |str |endRecording |
</div>


## `ChangeExtendedAwayGreetingMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal change extended away greeting menu keys modify entry.


**Attributes:**

|Name                              |Type|Description                               |
|----------------------------------|----|------------------------------------------|
|activate_extended_away_greeting   |str |activateExtendedAwayGreeting *Optional*   |
|deactivate_extended_away_greeting |str |deactivateExtendedAwayGreeting *Optional* |
|record_new_greeting               |str |recordNewGreeting *Optional*              |
|listen_to_current_greeting        |str |listenToCurrentGreeting *Optional*        |
|enable_message_deposit            |str |enableMessageDeposit *Optional*           |
|disable_message_deposit           |str |disableMessageDeposit *Optional*          |
|return_to_previous_menu           |str |returnToPreviousMenu *Optional*           |
|repeat_menu                       |str |repeatMenu *Optional*                     |
</div>


## `ChangeExtendedAwayGreetingMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal change extended away greeting menu keys.


**Attributes:**

|Name                              |Type|Description                               |
|----------------------------------|----|------------------------------------------|
|activate_extended_away_greeting   |str |activateExtendedAwayGreeting *Optional*   |
|deactivate_extended_away_greeting |str |deactivateExtendedAwayGreeting *Optional* |
|record_new_greeting               |str |recordNewGreeting *Optional*              |
|listen_to_current_greeting        |str |listenToCurrentGreeting *Optional*        |
|return_to_previous_menu           |str |returnToPreviousMenu                      |
|repeat_menu                       |str |repeatMenu *Optional*                     |
</div>


## `CollaborateBridgeMaximumParticipants`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Maximum number of Collaborate bridge participants.

Can either be unlimited or limited to a value between 3 and 999999.

**Attributes:**

|Name      |Type |Description          |
|----------|-----|---------------------|
|unlimited |bool |unlimited *Optional* |
|quantity  |int  |quantity *Optional*  |
</div>


## `CollaborateGracePeriodDuration`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Collaborate grace period duration.


**Attributes:**

|Name    |Type|Description|
|--------|----|-----------|
|hours   |int |hours      |
|minutes |int |minutes    |
</div>


## `CollaborateRoomSchedule`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Collaborate room schedule.


**Attributes:**

|Name                     |Type                    |Description                        |
|-------------------------|------------------------|-----------------------------------|
|schedule_reservationless |scheduleReservationless |scheduleReservationless *Optional* |
|schedule_one_time        |scheduleOneTime         |scheduleOneTime *Optional*         |
|schedule_recurring       |scheduleRecurring       |scheduleRecurring *Optional*       |
</div>


## `CollaborateRoomScheduleDuration`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Collaborate room schedule duration.


**Attributes:**

|Name    |Type|Description|
|--------|----|-----------|
|hours   |int |hours      |
|minutes |int |minutes    |
</div>


## `CommPilotExpressEmailNotify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CommPilot Express Email Notify configuration used in the context of a get.


**Attributes:**

|Name          |Type |Description             |
|--------------|-----|------------------------|
|send_email    |bool |sendEmail               |
|email_address |str  |emailAddress *Optional* |
</div>


## `CommPilotExpressEmailNotifyModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CommPilot Express Email Notify configuration used in the context of a modify.


**Attributes:**

|Name          |Type |Description             |
|--------------|-----|------------------------|
|send_email    |bool |sendEmail *Optional*    |
|email_address |str  |emailAddress *Optional* |
</div>


## `CommPilotExpressProfileMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal commPilot express profile menu keys modify entry.


**Attributes:**

|Name                                     |Type|Description                                    |
|-----------------------------------------|----|-----------------------------------------------|
|activate_available_in_office_profile     |str |activateAvailableInOfficeProfile *Optional*    |
|activate_available_out_of_office_profile |str |activateAvailableOutOfOfficeProfile *Optional* |
|activate_busy_profile                    |str |activateBusyProfile *Optional*                 |
|activate_unavailable_profile             |str |activateUnavailableProfile *Optional*          |
|no_profile                               |str |noProfile *Optional*                           |
|return_to_previous_menu                  |str |returnToPreviousMenu *Optional*                |
|repeat_menu                              |str |repeatMenu *Optional*                          |
</div>


## `CommPilotExpressProfileMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal commPilot express profile menu keys.


**Attributes:**

|Name                                     |Type|Description                                    |
|-----------------------------------------|----|-----------------------------------------------|
|activate_available_in_office_profile     |str |activateAvailableInOfficeProfile *Optional*    |
|activate_available_out_of_office_profile |str |activateAvailableOutOfOfficeProfile *Optional* |
|activate_busy_profile                    |str |activateBusyProfile *Optional*                 |
|activate_unavailable_profile             |str |activateUnavailableProfile *Optional*          |
|no_profile                               |str |noProfile *Optional*                           |
|return_to_previous_menu                  |str |returnToPreviousMenu                           |
|repeat_menu                              |str |repeatMenu *Optional*                          |
</div>


## `CommPilotExpressRedirection`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CommPilot Express type to transfer to voice Mail or forward to a number used in the
context of a get.


**Attributes:**

|Name                    |Type|Description                      |
|------------------------|----|---------------------------------|
|action                  |str |action                           |
|forwarding_phone_number |str |forwardingPhoneNumber *Optional* |
</div>


## `CommPilotExpressRedirectionModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CommPilot Express type to transfer to voice Mail or forward to a number used in the
context of a modify.


**Attributes:**

|Name                    |Type|Description                      |
|------------------------|----|---------------------------------|
|action                  |str |action *Optional*                |
|forwarding_phone_number |str |forwardingPhoneNumber *Optional* |
</div>


## `CommPilotExpressRedirectionWithException`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CommPilot Express type to transfer to voice mail or forward to a number with certain
exceptions used in the context of a get.


**Attributes:**

|Name                                             |Type |Description                               |
|-------------------------------------------------|-----|------------------------------------------|
|send_calls_to_voice_mail_except_excluded_numbers |bool |sendCallsToVoiceMailExceptExcludedNumbers |
|excluded_phone_number01                          |str  |excludedPhoneNumber01 *Optional*          |
|excluded_phone_number02                          |str  |excludedPhoneNumber02 *Optional*          |
|excluded_phone_number03                          |str  |excludedPhoneNumber03 *Optional*          |
|forward_excluded_numbers_to                      |str  |forwardExcludedNumbersTo *Optional*       |
</div>


## `CommPilotExpressRedirectionWithExceptionModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CommPilot Express type to transfer to voice mail or forward to a number with certain
exceptions used in the context of a modify.


**Attributes:**

|Name                                             |Type |Description                                          |
|-------------------------------------------------|-----|-----------------------------------------------------|
|send_calls_to_voice_mail_except_excluded_numbers |bool |sendCallsToVoiceMailExceptExcludedNumbers *Optional* |
|excluded_phone_number01                          |str  |excludedPhoneNumber01 *Optional*                     |
|excluded_phone_number02                          |str  |excludedPhoneNumber02 *Optional*                     |
|excluded_phone_number03                          |str  |excludedPhoneNumber03 *Optional*                     |
|forward_excluded_numbers_to                      |str  |forwardExcludedNumbersTo *Optional*                  |
</div>


## `CommunicationBarringAuthorizationCodeConfiguration`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Communication Barring Authorization Code add entry.


**Attributes:**

|Name                     |Type|Description                      |
|-------------------------|----|---------------------------------|
|code                     |str |code                             |
|description              |str |description *Optional*           |
|network_class_of_service |str |networkClassOfService *Optional* |
</div>


## `CommunicationBarringAuthorizationCodeEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Communication Barring Authorization Code entry.


**Attributes:**

|Name        |Type|Description            |
|------------|----|-----------------------|
|code        |str |code                   |
|description |str |description *Optional* |
</div>


## `CommunicationBarringCallMeNowRule`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Communication Barring Call Me Now Rule

**Attributes:**

|Name                 |Type|Description                   |
|---------------------|----|------------------------------|
|criteria             |str |criteria                      |
|action               |str |action                        |
|call_timeout_seconds |int |callTimeoutSeconds *Optional* |
</div>


## `CommunicationBarringIncomingRule`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Communication Barring Incoming Rule

**Attributes:**

|Name                   |Type|Description                   |
|-----------------------|----|------------------------------|
|digit_pattern_criteria |str |digitPatternCriteria          |
|action                 |str |action                        |
|call_timeout_seconds   |int |callTimeoutSeconds *Optional* |
|time_schedule          |str |timeSchedule *Optional*       |
|holiday_schedule       |str |holidaySchedule *Optional*    |
|priority               |str |priority                      |
</div>


## `CommunicationBarringIncomingRule19sp1`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Communication Barring Incoming Rule

**Attributes:**

|Name                   |Type|Description                     |
|-----------------------|----|--------------------------------|
|digit_pattern_criteria |str |digitPatternCriteria *Optional* |
|incoming_criteria      |str |incomingCriteria *Optional*     |
|action                 |str |action                          |
|call_timeout_seconds   |int |callTimeoutSeconds *Optional*   |
|time_schedule          |str |timeSchedule *Optional*         |
|holiday_schedule       |str |holidaySchedule *Optional*      |
|priority               |str |priority                        |
</div>


## `CommunicationBarringOriginatingRule`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Communication Barring Originating Rule

**Attributes:**

|Name                 |Type|Description                   |
|---------------------|----|------------------------------|
|criteria             |str |criteria                      |
|action               |str |action                        |
|treatment_id         |str |treatmentId *Optional*        |
|transfer_number      |str |transferNumber *Optional*     |
|call_timeout_seconds |int |callTimeoutSeconds *Optional* |
</div>


## `CommunicationBarringOriginatingRule15sp2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Communication Barring Originating Rule

**Attributes:**

|Name            |Type|Description               |
|----------------|----|--------------------------|
|criteria        |str |criteria                  |
|action          |str |action                    |
|treatment_id    |str |treatmentId *Optional*    |
|transfer_number |str |transferNumber *Optional* |
</div>


## `CommunicationBarringProfileReplacementList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of communication barring profiles that replaces a previously configured list.

By convention, an element of this type may be set nil to clear the list.

**Attributes:**

|Name         |Type      |Description |
|-------------|----------|------------|
|profile_name |List[str] |profileName |
</div>


## `CommunicationBarringRedirectingRule`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Communication Barring Redirecting Rule

**Attributes:**

|Name                 |Type|Description                   |
|---------------------|----|------------------------------|
|criteria             |str |criteria                      |
|action               |str |action                        |
|call_timeout_seconds |int |callTimeoutSeconds *Optional* |
</div>


## `CommunicationBarringRedirectingRule15sp2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Communication Barring Redirecting Rule

**Attributes:**

|Name     |Type|Description|
|---------|----|-----------|
|criteria |str |criteria   |
|action   |str |action     |
</div>


## `ConferenceGreetingMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal greeting menu keys modify entry.


**Attributes:**

|Name                            |Type|Description                            |
|--------------------------------|----|---------------------------------------|
|activate_conf_greeting          |str |activateConfGreeting *Optional*        |
|deactivate_conf_greeting        |str |deactivateConfGreeting *Optional*      |
|record_new_conf_greeting        |str |recordNewConfGreeting *Optional*       |
|listen_to_current_conf_greeting |str |listenToCurrentConfGreeting *Optional* |
|return_to_previous_menu         |str |returnToPreviousMenu *Optional*        |
|repeat_menu                     |str |repeatMenu *Optional*                  |
</div>


## `ConferenceGreetingMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal conference greeting menu keys.


**Attributes:**

|Name                            |Type|Description                            |
|--------------------------------|----|---------------------------------------|
|activate_conf_greeting          |str |activateConfGreeting *Optional*        |
|deactivate_conf_greeting        |str |deactivateConfGreeting *Optional*      |
|record_new_conf_greeting        |str |recordNewConfGreeting *Optional*       |
|listen_to_current_conf_greeting |str |listenToCurrentConfGreeting *Optional* |
|return_to_previous_menu         |str |returnToPreviousMenu                   |
|repeat_menu                     |str |repeatMenu *Optional*                  |
</div>


## `Contact`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contact information.


**Attributes:**

|Name           |Type|Description              |
|---------------|----|-------------------------|
|contact_name   |str |contactName *Optional*   |
|contact_number |str |contactNumber *Optional* |
|contact_email  |str |contactEmail *Optional*  |
</div>


## `CriteriaActivation`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria active status indicator

**Attributes:**

|Name          |Type |Description  |
|--------------|-----|-------------|
|criteria_name |str  |criteriaName |
|is_active     |bool |isActive     |
</div>


## `CriteriaFromDn`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The from dn criteria used within an add/get request.


**Attributes:**

|Name                        |Type      |Description               |
|----------------------------|----------|--------------------------|
|from_dn_criteria_selection  |str       |fromDnCriteriaSelection   |
|include_anonymous_callers   |bool      |includeAnonymousCallers   |
|include_unavailable_callers |bool      |includeUnavailableCallers |
|phone_number                |List[str] |phoneNumber *Optional*    |
</div>


## `CriteriaReplacementDNList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of criteria DNs that replaces a previously configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name         |Type      |Description |
|-------------|----------|------------|
|phone_number |List[str] |phoneNumber |
</div>


## `CustomContactDirectoryEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Represents either an existing user's Id or an existing Virtual On-Net user's DN.

For a DN the groupId is used to make it unique within an Enterprise, however the
groupId is not used with Service Providers.

**Attributes:**

|Name                        |Type|Description                        |
|----------------------------|----|-----------------------------------|
|user_id                     |str |userId *Optional*                  |
|virtual_on_net_phone_number |str |virtualOnNetPhoneNumber *Optional* |
|group_id                    |str |groupId *Optional*                 |
</div>


## `DNISKey`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Uniquely identifies a Call Center DNIS.


**Attributes:**

|Name            |Type|Description   |
|----------------|----|--------------|
|service_user_id |str |serviceUserId |
|name            |str |name          |
</div>


## `DNRange`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Directory number range.

The minimum and maximum values are inclusive.

**Attributes:**

|Name             |Type|Description    |
|-----------------|----|---------------|
|min_phone_number |str |minPhoneNumber |
|max_phone_number |str |maxPhoneNumber |
</div>


## `DNValidationStatusMessage`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The message contains the status and error reason that prevents DN to be
assigned/validated

**Attributes:**

|Name            |Type|Description               |
|----------------|----|--------------------------|
|dn              |str |dn                        |
|status          |str |status                    |
|message_code    |int |messageCode *Optional*    |
|summary         |str |summary *Optional*        |
|summary_english |str |summaryEnglish *Optional* |
</div>


## `DefaultNetworkClassOfService`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The default Network Class of Service to set during assignation/unassignation.


**Attributes:**

|Name                          |Type |Description                          |
|------------------------------|-----|-------------------------------------|
|use_existing                  |bool |useExisting *Optional*               |
|network_class_of_service_name |str  |networkClassOfServiceName *Optional* |
</div>


## `DeleteAllMessagesMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal delete all messages menu keys modify entry modify entry.


**Attributes:**

|Name             |Type|Description                |
|-----------------|----|---------------------------|
|confirm_deletion |str |confirmDeletion *Optional* |
|cancel_deletion  |str |cancelDeletion *Optional*  |
</div>


## `DeleteAllMessagesMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal delete all messages menu keys.


**Attributes:**

|Name             |Type|Description     |
|-----------------|----|----------------|
|confirm_deletion |str |confirmDeletion |
|cancel_deletion  |str |cancelDeletion  |
</div>


## `DepartmentKey`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Uniquely identifies a department system-wide.

Departments are contained in either an enterprise or a group.  Enterprise departments
can be used by any or all groups within the enterprise.  Department names are unique
within a group and within an enterprise, but the same department name can exist in 2
different groups or in both a group and its parent enterprise.  Therefore, to uniquely
identify a department, we must know the department name and which enterprise or group
contains the department.  This type is extended by group and enterprise department
keys.

</div>


## `DeviceManagementAutoRebuildConfigEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains one automatic rebuild configuration list entry.


**Attributes:**

|Name                 |Type |Description                   |
|---------------------|-----|------------------------------|
|oci_request_prefix   |str  |ociRequestPrefix              |
|auto_rebuild_enabled |bool |autoRebuildEnabled *Optional* |
</div>


## `DeviceManagementDeviceTypeOptionsRead`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Device Management System device type options.


**Attributes:**

|Name                                   |Type |Description                         |
|---------------------------------------|-----|------------------------------------|
|device_access_protocol                 |str  |deviceAccessProtocol                |
|tag_mode                               |str  |tagMode                             |
|tag_set                                |str  |tagSet *Optional*                   |
|allow_device_profile_custom_tag_set    |bool |allowDeviceProfileCustomTagSet      |
|allow_group_custom_tag_set             |bool |allowGroupCustomTagSet              |
|send_email_upon_reset_failure          |bool |sendEmailUponResetFailure           |
|device_access_net_address              |str  |deviceAccessNetAddress *Optional*   |
|device_access_port                     |int  |deviceAccessPort *Optional*         |
|device_access_context                  |str  |deviceAccessContext *Optional*      |
|device_access_uri                      |str  |deviceAccessURI *Optional*          |
|default_device_language                |str  |defaultDeviceLanguage *Optional*    |
|default_device_encoding                |str  |defaultDeviceEncoding *Optional*    |
|access_device_credentials              |str  |accessDeviceCredentials *Optional*  |
|use_http_digest_authentication         |bool |useHttpDigestAuthentication         |
|mac_based_file_authentication          |bool |macBasedFileAuthentication          |
|user_name_password_file_authentication |bool |userNamePasswordFileAuthentication  |
|mac_in_non_request_uri                 |bool |macInNonRequestURI                  |
|mac_format_in_non_request_uri          |str  |macFormatInNonRequestURI *Optional* |
</div>


## `DeviceManagementDeviceTypeOptionsRead16`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Device Management System device type options.


**Attributes:**

|Name                                   |Type |Description                         |
|---------------------------------------|-----|------------------------------------|
|device_access_protocol                 |str  |deviceAccessProtocol                |
|tag_mode                               |str  |tagMode                             |
|tag_set                                |str  |tagSet *Optional*                   |
|allow_device_profile_custom_tag_set    |bool |allowDeviceProfileCustomTagSet      |
|allow_group_custom_tag_set             |bool |allowGroupCustomTagSet              |
|send_email_upon_reset_failure          |bool |sendEmailUponResetFailure           |
|device_access_net_address              |str  |deviceAccessNetAddress *Optional*   |
|device_access_port                     |int  |deviceAccessPort *Optional*         |
|device_access_context                  |str  |deviceAccessContext *Optional*      |
|device_access_uri                      |str  |deviceAccessURI *Optional*          |
|default_device_language                |str  |defaultDeviceLanguage *Optional*    |
|default_device_encoding                |str  |defaultDeviceEncoding *Optional*    |
|access_device_credentials              |str  |accessDeviceCredentials *Optional*  |
|use_http_digest_authentication         |bool |useHttpDigestAuthentication         |
|mac_based_file_authentication          |bool |macBasedFileAuthentication          |
|user_name_password_file_authentication |bool |userNamePasswordFileAuthentication  |
|mac_in_non_request_uri                 |bool |macInNonRequestURI                  |
|mac_format_in_non_request_uri          |str  |macFormatInNonRequestURI *Optional* |
</div>


## `DeviceManagementDeviceTypeOptionsRead21sp1`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Device Management System device type options.

Note: For the elements listed below, when device configuration is set to
deviceManagement, those elements apply to the creation of the Polycom Phone Services
directory file only.  For all other files, they are not used.  Those elements are
instead configured on a per-file basis at the Device Type File level.  When device
configuration is set to legacy, those elements apply to all configuration files.
useHttpDigestAuthentication macBasedFileAuthentication
userNamePasswordFileAuthentication macInNonRequestURI macInCert
macFormatInNonRequestURI

**Attributes:**

|Name                                   |Type |Description                         |
|---------------------------------------|-----|------------------------------------|
|device_access_protocol                 |str  |deviceAccessProtocol                |
|tag_mode                               |str  |tagMode                             |
|tag_set                                |str  |tagSet *Optional*                   |
|allow_device_profile_custom_tag_set    |bool |allowDeviceProfileCustomTagSet      |
|allow_group_custom_tag_set             |bool |allowGroupCustomTagSet              |
|send_email_upon_reset_failure          |bool |sendEmailUponResetFailure           |
|device_access_net_address              |str  |deviceAccessNetAddress *Optional*   |
|device_access_port                     |int  |deviceAccessPort *Optional*         |
|device_access_context                  |str  |deviceAccessContext *Optional*      |
|device_access_uri                      |str  |deviceAccessURI *Optional*          |
|default_device_language                |str  |defaultDeviceLanguage *Optional*    |
|default_device_encoding                |str  |defaultDeviceEncoding *Optional*    |
|access_device_credentials              |str  |accessDeviceCredentials *Optional*  |
|use_http_digest_authentication         |bool |useHttpDigestAuthentication         |
|mac_based_file_authentication          |bool |macBasedFileAuthentication          |
|user_name_password_file_authentication |bool |userNamePasswordFileAuthentication  |
|mac_in_non_request_uri                 |bool |macInNonRequestURI                  |
|mac_in_cert                            |bool |macInCert                           |
|mac_format_in_non_request_uri          |str  |macFormatInNonRequestURI *Optional* |
</div>


## `DeviceManagementDeviceTypeOptionsRead22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Device Management System device type options.

Note: For the elements listed below, when device configuration is set to
deviceManagement, those elements apply to the creation of the Polycom Phone Services
directory file only.  For all other files, they are not used.  Those elements are
instead configured on a per-file basis at the Device Type File level.  When device
configuration is set to legacy, those elements apply to all configuration files.
useHttpDigestAuthentication macBasedFileAuthentication
userNamePasswordFileAuthentication macInNonRequestURI macInCert
macFormatInNonRequestURI

**Attributes:**

|Name                                   |Type |Description                         |
|---------------------------------------|-----|------------------------------------|
|device_access_protocol                 |str  |deviceAccessProtocol                |
|tag_mode                               |str  |tagMode                             |
|tag_set                                |str  |tagSet *Optional*                   |
|allow_device_profile_custom_tag_set    |bool |allowDeviceProfileCustomTagSet      |
|allow_group_custom_tag_set             |bool |allowGroupCustomTagSet              |
|allow_sp_custom_tag_set                |bool |allowSpCustomTagSet                 |
|send_email_upon_reset_failure          |bool |sendEmailUponResetFailure           |
|device_access_net_address              |str  |deviceAccessNetAddress *Optional*   |
|device_access_port                     |int  |deviceAccessPort *Optional*         |
|device_access_context                  |str  |deviceAccessContext *Optional*      |
|device_access_uri                      |str  |deviceAccessURI *Optional*          |
|default_device_language                |str  |defaultDeviceLanguage *Optional*    |
|default_device_encoding                |str  |defaultDeviceEncoding *Optional*    |
|access_device_credentials              |str  |accessDeviceCredentials *Optional*  |
|use_http_digest_authentication         |bool |useHttpDigestAuthentication         |
|mac_based_file_authentication          |bool |macBasedFileAuthentication          |
|user_name_password_file_authentication |bool |userNamePasswordFileAuthentication  |
|mac_in_non_request_uri                 |bool |macInNonRequestURI                  |
|mac_in_cert                            |bool |macInCert                           |
|mac_format_in_non_request_uri          |str  |macFormatInNonRequestURI *Optional* |
</div>


## `DeviceManagementDeviceTypeOptionsRead22V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Device Management System device type options.

Note: For the elements listed below, when device configuration is set to
deviceManagement, those elements apply to the creation of the Polycom Phone Services
directory file only.  For all other files, they are not used.  Those elements are
instead configured on a per-file basis at the Device Type File level.  When device
configuration is set to legacy, those elements apply to all configuration files.
useHttpDigestAuthentication macBasedFileAuthentication
userNamePasswordFileAuthentication macInNonRequestURI macInCert
macFormatInNonRequestURI

**Attributes:**

|Name                                   |Type |Description                         |
|---------------------------------------|-----|------------------------------------|
|device_access_protocol                 |str  |deviceAccessProtocol                |
|tag_mode                               |str  |tagMode                             |
|tag_set                                |str  |tagSet *Optional*                   |
|allow_device_profile_custom_tag_set    |bool |allowDeviceProfileCustomTagSet      |
|allow_group_custom_tag_set             |bool |allowGroupCustomTagSet              |
|allow_sp_custom_tag_set                |bool |allowSpCustomTagSet                 |
|send_email_upon_reset_failure          |bool |sendEmailUponResetFailure           |
|device_access_net_address              |str  |deviceAccessNetAddress *Optional*   |
|device_access_port                     |int  |deviceAccessPort *Optional*         |
|device_access_context                  |str  |deviceAccessContext *Optional*      |
|device_access_uri                      |str  |deviceAccessURI *Optional*          |
|default_device_language                |str  |defaultDeviceLanguage *Optional*    |
|default_device_encoding                |str  |defaultDeviceEncoding *Optional*    |
|access_device_credentials              |str  |accessDeviceCredentials *Optional*  |
|use_http_digest_authentication         |bool |useHttpDigestAuthentication         |
|mac_based_file_authentication          |bool |macBasedFileAuthentication          |
|user_name_password_file_authentication |bool |userNamePasswordFileAuthentication  |
|mac_in_non_request_uri                 |bool |macInNonRequestURI                  |
|mac_in_cert                            |bool |macInCert                           |
|mac_format_in_non_request_uri          |str  |macFormatInNonRequestURI *Optional* |
</div>


## `DeviceManagementDeviceTypeOptionsRead22V3`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Device Management System device type options.

Note: For the elements listed below, when device configuration is set to
deviceManagement, those elements apply to the creation of the Polycom Phone Services
directory file only.  For all other files, they are not used.  Those elements are
instead configured on a per-file basis at the Device Type File level.  When device
configuration is set to legacy, those elements apply to all configuration files.
useHttpDigestAuthentication macBasedFileAuthentication
userNamePasswordFileAuthentication macInNonRequestURI macInCert
macFormatInNonRequestURI The following data elements are only used in AS data mode:
enableDeviceActivation, value false is returned The following elements are only used
in AS data mode and not returned in XS data mode deviceModel

**Attributes:**

|Name                                   |Type |Description                         |
|---------------------------------------|-----|------------------------------------|
|device_access_protocol                 |str  |deviceAccessProtocol                |
|tag_mode                               |str  |tagMode                             |
|tag_set                                |str  |tagSet *Optional*                   |
|allow_device_profile_custom_tag_set    |bool |allowDeviceProfileCustomTagSet      |
|allow_group_custom_tag_set             |bool |allowGroupCustomTagSet              |
|allow_sp_custom_tag_set                |bool |allowSpCustomTagSet                 |
|send_email_upon_reset_failure          |bool |sendEmailUponResetFailure           |
|device_access_net_address              |str  |deviceAccessNetAddress *Optional*   |
|device_access_port                     |int  |deviceAccessPort *Optional*         |
|device_access_context                  |str  |deviceAccessContext *Optional*      |
|device_access_uri                      |str  |deviceAccessURI *Optional*          |
|default_device_language                |str  |defaultDeviceLanguage *Optional*    |
|default_device_encoding                |str  |defaultDeviceEncoding *Optional*    |
|access_device_credentials              |str  |accessDeviceCredentials *Optional*  |
|use_http_digest_authentication         |bool |useHttpDigestAuthentication         |
|mac_based_file_authentication          |bool |macBasedFileAuthentication          |
|user_name_password_file_authentication |bool |userNamePasswordFileAuthentication  |
|mac_in_non_request_uri                 |bool |macInNonRequestURI                  |
|mac_in_cert                            |bool |macInCert                           |
|mac_format_in_non_request_uri          |str  |macFormatInNonRequestURI *Optional* |
|enable_device_activation               |bool |enableDeviceActivation              |
|device_model                           |str  |deviceModel *Optional*              |
</div>


## `DeviceManagementDeviceTypeOptionsRead22V4`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Device Management System device type options.

Note: For the elements listed below, when device configuration is set to
deviceManagement, those elements apply to the creation of the Polycom Phone Services
directory file only.  For all other files, they are not used.  Those elements are
instead configured on a per-file basis at the Device Type File level.  When device
configuration is set to legacy, those elements apply to all configuration files.
useHttpDigestAuthentication macBasedFileAuthentication
userNamePasswordFileAuthentication macInNonRequestURI macInCert
macFormatInNonRequestURI The following data elements are only used in AS data mode:
enableDeviceActivation, value ‘false’ is returned supportLinks, value ‘Not Supported’
is returned The following elements are only used in AS data mode and not returned in
XS data mode deviceModel

**Attributes:**

|Name                                   |Type |Description                         |
|---------------------------------------|-----|------------------------------------|
|device_access_protocol                 |str  |deviceAccessProtocol                |
|tag_mode                               |str  |tagMode                             |
|tag_set                                |str  |tagSet *Optional*                   |
|allow_device_profile_custom_tag_set    |bool |allowDeviceProfileCustomTagSet      |
|allow_group_custom_tag_set             |bool |allowGroupCustomTagSet              |
|allow_sp_custom_tag_set                |bool |allowSpCustomTagSet                 |
|send_email_upon_reset_failure          |bool |sendEmailUponResetFailure           |
|device_access_net_address              |str  |deviceAccessNetAddress *Optional*   |
|device_access_port                     |int  |deviceAccessPort *Optional*         |
|device_access_context                  |str  |deviceAccessContext *Optional*      |
|device_access_uri                      |str  |deviceAccessURI *Optional*          |
|default_device_language                |str  |defaultDeviceLanguage *Optional*    |
|default_device_encoding                |str  |defaultDeviceEncoding *Optional*    |
|access_device_credentials              |str  |accessDeviceCredentials *Optional*  |
|use_http_digest_authentication         |bool |useHttpDigestAuthentication         |
|mac_based_file_authentication          |bool |macBasedFileAuthentication          |
|user_name_password_file_authentication |bool |userNamePasswordFileAuthentication  |
|mac_in_non_request_uri                 |bool |macInNonRequestURI                  |
|mac_in_cert                            |bool |macInCert                           |
|mac_format_in_non_request_uri          |str  |macFormatInNonRequestURI *Optional* |
|enable_device_activation               |bool |enableDeviceActivation              |
|device_model                           |str  |deviceModel *Optional*              |
|support_links                          |str  |supportLinks                        |
</div>


## `DeviceManagementLanguageMapping`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Maps a BroadWorks language to a device-equivalent language.


**Attributes:**

|Name                 |Type|Description        |
|---------------------|----|-------------------|
|broad_works_language |str |broadWorksLanguage |
|device_language      |str |deviceLanguage     |
</div>


## `DeviceManagementTag`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Represents a tag name with its associated value.


**Attributes:**

|Name      |Type|Description         |
|----------|----|--------------------|
|tag_name  |str |tagName             |
|tag_value |str |tagValue *Optional* |
</div>


## `DeviceManagementTagSetRename`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Pair of DeviceManagementTagSetName

**Attributes:**

|Name                  |Type|Description        |
|----------------------|----|-------------------|
|original_tag_set_name |str |originalTagSetName |
|new_tag_set_name      |str |newTagSetName      |
</div>


## `DeviceManagementUserNamePassword`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device credentials.


**Attributes:**

|Name      |Type|Description|
|----------|----|-----------|
|user_name |str |userName   |
|password  |str |password   |
</div>


## `DeviceManagementUserNamePassword16`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device credentials.


**Attributes:**

|Name      |Type|Description|
|----------|----|-----------|
|user_name |str |userName   |
|password  |str |password   |
</div>


## `DialPlanPolicy`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Dial Plan Access Code attributes.


**Attributes:**

|Name                                            |Type |Description                                          |
|------------------------------------------------|-----|-----------------------------------------------------|
|use_setting                                     |str  |useSetting *Optional*                                |
|requires_access_code_for_public_calls           |bool |requiresAccessCodeForPublicCalls *Optional*          |
|allow_e164_public_calls                         |bool |allowE164PublicCalls *Optional*                      |
|prefer_e164_number_format_for_callback_services |bool |preferE164NumberFormatForCallbackServices *Optional* |
|public_digit_map                                |str  |publicDigitMap *Optional*                            |
|private_digit_map                               |str  |privateDigitMap *Optional*                           |
</div>


## `DialPlanPolicyAccessCode`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Dial Plan Access Code attributes.


**Attributes:**

|Name                                              |Type |Description                                            |
|--------------------------------------------------|-----|-------------------------------------------------------|
|access_code                                       |str  |accessCode                                             |
|description                                       |str  |description *Optional*                                 |
|include_code_for_network_translations_and_routing |bool |includeCodeForNetworkTranslationsAndRouting *Optional* |
|include_code_for_screening_services               |bool |includeCodeForScreeningServices *Optional*             |
|enable_secondary_dial_tone                        |bool |enableSecondaryDialTone *Optional*                     |
</div>


## `DialableCallerIDCriteriaPriorityOrder`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Dialable Caller ID routing order

**Attributes:**

|Name          |Type|Description  |
|--------------|----|-------------|
|criteria_name |str |criteriaName |
|priority      |str |priority     |
</div>


## `DirectRouteIdentifiers`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Direct Route identifiers.


**Attributes:**

|Name           |Type|Description              |
|---------------|----|-------------------------|
|dtg_identity   |str |dtgIdentity *Optional*   |
|trunk_identity |str |trunkIdentity *Optional* |
</div>


## `DirectRouteReplacementIdentityList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A replacement list of direct route parameters.


**Attributes:**

|Name           |Type|Description              |
|---------------|----|-------------------------|
|dtg_identity   |str |dtgIdentity *Optional*   |
|trunk_identity |str |trunkIdentity *Optional* |
</div>


## `DisableMessageDepositMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal disable message deposit menu keys modify entry.


**Attributes:**

|Name                          |Type|Description                            |
|------------------------------|----|---------------------------------------|
|disconnect_after_greeting     |str |disconnectAfterGreeting *Optional*     |
|forward_after_greeting        |str |forwardAfterGreeting *Optional*        |
|change_forwarding_destination |str |changeForwardingDestination *Optional* |
|return_to_previous_menu       |str |returnToPreviousMenu *Optional*        |
|repeat_menu                   |str |repeatMenu *Optional*                  |
</div>


## `DisableMessageDepositMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal disable message deposit menu keys.


**Attributes:**

|Name                          |Type|Description                            |
|------------------------------|----|---------------------------------------|
|disconnect_after_greeting     |str |disconnectAfterGreeting *Optional*     |
|forward_after_greeting        |str |forwardAfterGreeting *Optional*        |
|change_forwarding_destination |str |changeForwardingDestination *Optional* |
|return_to_previous_menu       |str |returnToPreviousMenu                   |
|repeat_menu                   |str |repeatMenu *Optional*                  |
</div>


## `EnhancedCallLogsAccountAuthorizationCodeFilter`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Filter criteria based on the account code.

When "callsWithCodes" is set to true, all call logs with account/authorization codes
are returned.  When it set to false, all call logs without account/authorization codes
are returned.

**Attributes:**

|Name                       |Type |Description                         |
|---------------------------|-----|------------------------------------|
|calls_with_codes           |bool |callsWithCodes *Optional*           |
|account_authorization_code |str  |accountAuthorizationCode *Optional* |
</div>


## `EnhancedCallLogsCallAuthorizationCodeFilter`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Filter criteria based on call authorization code.

Note that this code filter is different than
EnhancedCallLogsAccountAuthorizationCodeFilter, which applies strictly to codes
entered using the account/authorization code service.  When "callsWithCodes" is set to
true, all call logs with authorization codes are returned.  When it set to false, all
call logs without authorization codes are returned.  If "authorizationCode" is set,
all call logs matching that specific authorization code are returned.

**Attributes:**

|Name               |Type |Description                  |
|-------------------|-----|-----------------------------|
|calls_with_codes   |bool |callsWithCodes *Optional*    |
|authorization_code |str  |authorizationCode *Optional* |
</div>


## `EnhancedCallLogsEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Call Log entry describing a placed, received, or missed call.

Replaced By: CallLogsEntry

**Attributes:**

|Name         |Type|Description            |
|-------------|----|-----------------------|
|country_code |str |countryCode *Optional* |
|phone_number |str |phoneNumber            |
|name         |str |name                   |
|time         |str |time                   |
</div>


## `EnhancedCallLogsRedirectedCallSelection`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Redirected call selection.

When " redirectedCall " is set to true, all call logs with redirected call are
returned.  When it set to false, all call logs without redirected call are returned.
The redirected call can be defined by including a subset of Service Invocation
Disposition here.  If none included, any call has a ServiceInvocationDisposition value
defined in ServiceInvocationDisposition is considered as a redirected call.

**Attributes:**

|Name            |Type      |Description             |
|----------------|----------|------------------------|
|redirected_call |bool      |redirectedCall          |
|redirect_type   |List[str] |redirectType *Optional* |
</div>


## `EnhancedCallLogsRedirectedCallSelection20sp1`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Redirected call selection.

When " redirectedCall " is set to true, all call logs with redirected call are
returned.  When it set to false, all call logs without redirected call are returned.
The redirected call can be defined by including a subset of Service Invocation
Disposition here.  If none included, any call has a ServiceInvocationDisposition value
defined in ServiceInvocationDisposition21sp1 is considered as a redirected call.

**Attributes:**

|Name            |Type      |Description             |
|----------------|----------|------------------------|
|redirected_call |bool      |redirectedCall          |
|redirect_type   |List[str] |redirectType *Optional* |
</div>


## `EnhancedCallLogsRedirectedCallSelection21`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Redirected call selection.

When " redirectedCall " is set to true, all call logs with redirected call are
returned.  When it set to false, all call logs without redirected call are returned.
The redirected call can be defined by including a subset of Service Invocation
Disposition here.  If none included, any call has a ServiceInvocationDisposition value
defined in ServiceInvocationDisposition21 is considered as a redirected call.

**Attributes:**

|Name            |Type      |Description             |
|----------------|----------|------------------------|
|redirected_call |bool      |redirectedCall          |
|redirect_type   |List[str] |redirectType *Optional* |
</div>


## `EnhancedCallLogsRedirectedCallSelection21sp1`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Redirected call selection.

When " redirectedCall " is set to true, all call logs with redirected call are
returned.  When it set to false, all call logs without redirected call are returned.
The redirected call can be defined by including a subset of Service Invocation
Disposition here.  If none included, any call has a ServiceInvocationDisposition value
defined in ServiceInvocationDisposition21sp1 is considered as a redirected call.

**Attributes:**

|Name            |Type      |Description             |
|----------------|----------|------------------------|
|redirected_call |bool      |redirectedCall          |
|redirect_type   |List[str] |redirectType *Optional* |
</div>


## `EnhancedCallLogsRedirectedCallSelection23`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Redirected call selection.

When " redirectedCall " is set to true, all call logs with redirected call are
returned.  When it set to false, all call logs without redirected call are returned.
The redirected call can be defined by including a subset of Service Invocation
Disposition here.  If none included, any call has a ServiceInvocationDisposition value
defined in ServiceInvocationDisposition21sp1 is considered as a redirected call.

**Attributes:**

|Name            |Type      |Description             |
|----------------|----------|------------------------|
|redirected_call |bool      |redirectedCall          |
|redirect_type   |List[str] |redirectType *Optional* |
</div>


## `EnhancedCallLogsResponsePagingControl`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Used in enhanced call logs group and enterprise queries to restrict the set of result
rows when making a request that can result in a large dataset.

The client specifies the starting row and the number of rows requested.  The server
only provides those rows in results, if available.

**Attributes:**

|Name                 |Type|Description        |
|---------------------|----|-------------------|
|response_start_index |int |responseStartIndex |
|response_page_size   |int |responsePageSize   |
</div>


## `EnhancedCallLogsTimeRange`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Time range used to filter call logs.


**Attributes:**

|Name            |Type|Description   |
|----------------|----|--------------|
|start_date_time |str |startDateTime |
|end_date_time   |str |endDateTime   |
</div>


## `EnterpriseDepartmentKey`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Uniquely identifies a department defined within an enterprise.

To uniquely identify an enterprise department, we must know the department name and
which enterprise contains the department.

**Attributes:**

|Name                |Type|Description       |
|--------------------|----|------------------|
|service_provider_id |str |serviceProviderId |
|name                |str |name              |
</div>


## `EnterpriseSessionAdmissionControlGroupGetRequest21sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Request to get a session admission control group for the enterprise.

The response is either an EnterpriseSessionAdmissionControlGroupGetResponse21sp1V2 or
an `ErrorResponse()`.

**Attributes:**

|Name                |Type|Description       |
|--------------------|----|------------------|
|service_provider_id |str |serviceProviderId |
|name                |str |name              |
</div>


## `EnterpriseTrunkNumberRangeModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Directory number range for modification.


**Attributes:**

|Name             |Type|Description                |
|-----------------|----|---------------------------|
|dn_range_start   |str |dnRangeStart               |
|extension_length |int |extensionLength *Optional* |
</div>


## `EnterpriseTrunkReplacementNumberPrefixList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of prefixes that replaces a previously configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name          |Type      |Description  |
|--------------|----------|-------------|
|number_prefix |List[str] |numberPrefix |
</div>


## `EnterpriseTrunkTrunkGroupKey`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Identifies a trunk group within an Enterprise Trunk where the service provider id is
already known.


**Attributes:**

|Name             |Type|Description    |
|-----------------|----|---------------|
|group_id         |str |groupId        |
|trunk_group_name |str |trunkGroupName |
</div>


## `EnterpriseVoiceVPNDigitManipulation`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Enterprise Voice VPN Digit Manipulation Entry.


</div>


## `EnterpriseVoiceVPNDigitManipulationNoValue`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Enterprise Voice VPN Digit Manipulation Entry that has no value.


**Attributes:**

|Name      |Type|Description|
|----------|----|-----------|
|operation |str |operation  |
</div>


## `EnterpriseVoiceVPNDigitManipulationOptionalValue`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Enterprise Voice VPN Digit Manipulation Entry that optionally has a value.


**Attributes:**

|Name      |Type|Description      |
|----------|----|-----------------|
|operation |str |operation        |
|value     |str |value *Optional* |
</div>


## `EnterpriseVoiceVPNDigitManipulationRequiredValue`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Enterprise Voice VPN Digit Manipulation Entry that has a value.


**Attributes:**

|Name      |Type|Description|
|----------|----|-----------|
|operation |str |operation  |
|value     |str |value      |
</div>


## `EnterpriseVoiceVPNTreatmentEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Enterprise Voice VPN Treatment entry

**Attributes:**

|Name        |Type|Description            |
|------------|----|-----------------------|
|id          |str |id                     |
|description |str |description *Optional* |
</div>


## `EstimatedWaitMessageOptionsModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Estimated Wait Message Options

**Attributes:**

|Name                             |Type |Description                             |
|---------------------------------|-----|----------------------------------------|
|enabled                          |bool |enabled *Optional*                      |
|operating_mode                   |str  |operatingMode *Optional*                |
|play_position_high_volume        |bool |playPositionHighVolume *Optional*       |
|play_time_high_volume            |bool |playTimeHighVolume *Optional*           |
|maximum_positions                |int  |maximumPositions *Optional*             |
|maximum_waiting_minutes          |int  |maximumWaitingMinutes *Optional*        |
|default_call_handling_minutes    |int  |defaultCallHandlingMinutes *Optional*   |
|play_updated_ewm                 |bool |playUpdatedEWM *Optional*               |
|time_between_ewm_updates_seconds |int  |timeBetweenEWMUpdatesSeconds *Optional* |
</div>


## `EstimatedWaitMessageOptionsRead`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Estimated Wait Message Options Replaced by EstimatedWaitMessageOptionsRead17sp4

**Attributes:**

|Name                          |Type |Description                |
|------------------------------|-----|---------------------------|
|enabled                       |bool |enabled                    |
|operating_mode                |str  |operatingMode              |
|play_position_high_volume     |bool |playPositionHighVolume     |
|play_time_high_volume         |bool |playTimeHighVolume         |
|maximum_positions             |int  |maximumPositions           |
|maximum_waiting_minutes       |int  |maximumWaitingMinutes      |
|default_call_handling_minutes |int  |defaultCallHandlingMinutes |
</div>


## `EstimatedWaitMessageOptionsRead17sp4`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Estimated Wait Message Options

**Attributes:**

|Name                             |Type |Description                             |
|---------------------------------|-----|----------------------------------------|
|enabled                          |bool |enabled                                 |
|operating_mode                   |str  |operatingMode                           |
|play_position_high_volume        |bool |playPositionHighVolume                  |
|play_time_high_volume            |bool |playTimeHighVolume                      |
|maximum_positions                |int  |maximumPositions                        |
|maximum_waiting_minutes          |int  |maximumWaitingMinutes                   |
|default_call_handling_minutes    |int  |defaultCallHandlingMinutes              |
|play_updated_ewm                 |bool |playUpdatedEWM                          |
|time_between_ewm_updates_seconds |int  |timeBetweenEWMUpdatesSeconds *Optional* |
</div>


## `ExchangeUserNamePassword`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Exchange server user name and password.


**Attributes:**

|Name      |Type|Description|
|----------|----|-----------|
|user_name |str |userName   |
|password  |str |password   |
</div>


## `ExecutiveAssistantOptInStatus`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Executive assistant Opt-in status with executive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|executive_user_id |str  |executiveUserId |
|opt_in            |bool |optIn           |
</div>


## `ExecutiveCallFilteringCriteriaFromDn`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The from dn criteria used within an executive call filtering criteria add/get request.


**Attributes:**

|Name                        |Type      |Description               |
|----------------------------|----------|--------------------------|
|from_dn_criteria_selection  |str       |fromDnCriteriaSelection   |
|include_anonymous_callers   |bool      |includeAnonymousCallers   |
|include_unavailable_callers |bool      |includeUnavailableCallers |
|phone_number                |List[str] |phoneNumber *Optional*    |
</div>


## `ExtendedMixedCallLogsEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Extended Call Log entry describing a placed, received, or missed call.

"countryCode" is the user's country code The following time elements are represented
as timestamp, i.e., the number of milliseconds since January 1, 1970, 00:00:00 GMT.
"startTime" represents the time when the system sends out a call invitation message
(e.g.  for placed calls) or receives a call invitation message (e.g.  for
missed/received calls). "answerTime" represents the time when the call is answered by
the terminating party.  "detachTime" represents the time when the call is successfully
redirected by the system.  "releaseTime" represents the time when the call is
released.  This time corresponds to the moment the call is released by the system, and
not necessarily when one party hangs up, since this does not always mean the call is
released (e.g.  Emergency/911 calls). The elements "userGroupId",
"userId","userPrimaryDn" and "userPrimaryExtension" are only returned when the
enterprise or group level requests are used.  Replaced by
ExtendedMixedCallLogsEntry17sp4. Originally deprecated in release 20.

**Attributes:**

|Name                                          |Type|Description                                          |
|----------------------------------------------|----|-----------------------------------------------------|
|call_log_type                                 |str |callLogType                                          |
|country_code                                  |str |countryCode                                          |
|call_log_id                                   |str |callLogId                                            |
|call_id                                       |str |callId                                               |
|subscriber_type                               |str |subscriberType                                       |
|dialed_number                                 |str |dialedNumber *Optional*                              |
|called_number                                 |str |calledNumber *Optional*                              |
|network_translated_address                    |str |networkTranslatedAddress *Optional*                  |
|calling_asserted_number                       |str |callingAssertedNumber *Optional*                     |
|calling_presentation_number                   |str |callingPresentationNumber *Optional*                 |
|calling_presentation_number_source            |str |callingPresentationNumberSource *Optional*           |
|calling_presentation_name                     |str |callingPresentationName *Optional*                   |
|calling_presentation_indicator                |str |callingPresentationIndicator                         |
|calling_group_id                              |str |callingGroupId *Optional*                            |
|called_directory_name                         |str |calledDirectoryName *Optional*                       |
|called_group_id                               |str |calledGroupId *Optional*                             |
|connected_number                              |str |connectedNumber *Optional*                           |
|connected_number_source                       |str |connectedNumberSource *Optional*                     |
|connected_name                                |str |connectedName *Optional*                             |
|connected_presentation_indicator              |str |connectedPresentationIndicator *Optional*            |
|type_of_network                               |str |typeOfNetwork *Optional*                             |
|call_category                                 |str |callCategory *Optional*                              |
|basic_call_type                               |str |basicCallType                                        |
|configurable_call_type                        |str |configurableCallType *Optional*                      |
|alternate_call_indicator                      |str |alternateCallIndicator *Optional*                    |
|virtual_on_net_call_type                      |str |virtualOnNetCallType *Optional*                      |
|time                                          |str |time                                                 |
|start_time                                    |int |startTime                                            |
|answer_time                                   |int |answerTime *Optional*                                |
|release_time                                  |int |releaseTime *Optional*                               |
|detached_time                                 |int |detachedTime *Optional*                              |
|detached_answer_time                          |int |detachedAnswerTime *Optional*                        |
|outgoing_dnis                                 |str |outgoingDnis *Optional*                              |
|service_invocation_disposition                |str |serviceInvocationDisposition *Optional*              |
|service_invocation_dialed_number              |str |serviceInvocationDialedNumber *Optional*             |
|service_invocation_called_number              |str |serviceInvocationCalledNumber *Optional*             |
|service_invocation_network_translated_address |str |serviceInvocationNetworkTranslatedAddress *Optional* |
|service_invocation_type_of_network            |str |serviceInvocationTypeOfNetwork *Optional*            |
|service_invocation_call_category              |str |serviceInvocationCallCategory *Optional*             |
|service_invocation_basic_call_type            |str |serviceInvocationBasicCallType *Optional*            |
|service_invocation_configurable_call_type     |str |serviceInvocationConfigurableCallType *Optional*     |
|service_invocation_alternate_call_indicator   |str |serviceInvocationAlternateCallIndicator *Optional*   |
|service_invocation_virtual_on_net_call_type   |str |serviceInvocationVirtualOnNetCallType *Optional*     |
|service_invocation_called_directory_name      |str |serviceInvocationCalledDirectoryName *Optional*      |
|service_invocation_called_group_id            |str |serviceInvocationCalledGroupId *Optional*            |
|redirecting_number                            |str |redirectingNumber *Optional*                         |
|redirecting_name                              |str |redirectingName *Optional*                           |
|redirecting_presentation_indicator            |str |redirectingPresentationIndicator *Optional*          |
|redirecting_reason                            |str |RedirectingReason *Optional*                         |
|account_authorization_code                    |str |accountAuthorizationCode *Optional*                  |
|user_group_id                                 |str |userGroupId *Optional*                               |
|user_id                                       |str |userId *Optional*                                    |
|user_primary_dn                               |str |userPrimaryDn *Optional*                             |
|user_primary_extension                        |str |userPrimaryExtension *Optional*                      |
</div>


## `ExtendedMixedCallLogsEntry17sp4`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Extended Call Log entry describing a placed, received, or missed call.

"countryCode" is the user's country code The following time elements are represented
as timestamp, i.e., the number of milliseconds since January 1, 1970, 00:00:00 GMT.
"startTime" represents the time when the system sends out a call invitation message
(e.g.  for placed calls) or receives a call invitation message (e.g.  for
missed/received calls). "answerTime" represents the time when the call is answered by
the terminating party.  "detachedTime" represents the time when the call is
successfully redirected by the system.  "releaseTime" represents the time when the
call is released.  This time corresponds to the moment the call is released by the
system, and not necessarily when one party hangs up, since this does not always mean
the call is released (e.g.  Emergency/911 calls). The elements "userGroupId",
"userId","userPrimaryDn" and "userPrimaryExtension" are only returned when the
enterprise or group level requests are used.  The following elements are only used in
AS data mode and not returned in XS data mode: callAuthorizationCode

**Attributes:**

|Name                                          |Type|Description                                          |
|----------------------------------------------|----|-----------------------------------------------------|
|call_log_type                                 |str |callLogType                                          |
|country_code                                  |str |countryCode                                          |
|call_log_id                                   |str |callLogId                                            |
|call_id                                       |str |callId                                               |
|subscriber_type                               |str |subscriberType                                       |
|dialed_number                                 |str |dialedNumber *Optional*                              |
|called_number                                 |str |calledNumber *Optional*                              |
|network_translated_address                    |str |networkTranslatedAddress *Optional*                  |
|calling_asserted_number                       |str |callingAssertedNumber *Optional*                     |
|calling_presentation_number                   |str |callingPresentationNumber *Optional*                 |
|calling_presentation_number_source            |str |callingPresentationNumberSource *Optional*           |
|calling_presentation_name                     |str |callingPresentationName *Optional*                   |
|calling_presentation_indicator                |str |callingPresentationIndicator                         |
|calling_group_id                              |str |callingGroupId *Optional*                            |
|called_directory_name                         |str |calledDirectoryName *Optional*                       |
|called_group_id                               |str |calledGroupId *Optional*                             |
|connected_number                              |str |connectedNumber *Optional*                           |
|connected_number_source                       |str |connectedNumberSource *Optional*                     |
|connected_name                                |str |connectedName *Optional*                             |
|connected_presentation_indicator              |str |connectedPresentationIndicator *Optional*            |
|type_of_network                               |str |typeOfNetwork *Optional*                             |
|call_category                                 |str |callCategory *Optional*                              |
|basic_call_type                               |str |basicCallType                                        |
|configurable_call_type                        |str |configurableCallType *Optional*                      |
|alternate_call_indicator                      |str |alternateCallIndicator *Optional*                    |
|virtual_on_net_call_type                      |str |virtualOnNetCallType *Optional*                      |
|time                                          |str |time                                                 |
|start_time                                    |int |startTime                                            |
|answer_time                                   |int |answerTime *Optional*                                |
|release_time                                  |int |releaseTime *Optional*                               |
|detached_time                                 |int |detachedTime *Optional*                              |
|detached_answer_time                          |int |detachedAnswerTime *Optional*                        |
|outgoing_dnis                                 |str |outgoingDnis *Optional*                              |
|service_invocation_disposition                |str |serviceInvocationDisposition *Optional*              |
|service_invocation_dialed_number              |str |serviceInvocationDialedNumber *Optional*             |
|service_invocation_called_number              |str |serviceInvocationCalledNumber *Optional*             |
|service_invocation_network_translated_address |str |serviceInvocationNetworkTranslatedAddress *Optional* |
|service_invocation_type_of_network            |str |serviceInvocationTypeOfNetwork *Optional*            |
|service_invocation_call_category              |str |serviceInvocationCallCategory *Optional*             |
|service_invocation_basic_call_type            |str |serviceInvocationBasicCallType *Optional*            |
|service_invocation_configurable_call_type     |str |serviceInvocationConfigurableCallType *Optional*     |
|service_invocation_alternate_call_indicator   |str |serviceInvocationAlternateCallIndicator *Optional*   |
|service_invocation_virtual_on_net_call_type   |str |serviceInvocationVirtualOnNetCallType *Optional*     |
|service_invocation_called_directory_name      |str |serviceInvocationCalledDirectoryName *Optional*      |
|service_invocation_called_group_id            |str |serviceInvocationCalledGroupId *Optional*            |
|redirecting_number                            |str |redirectingNumber *Optional*                         |
|redirecting_name                              |str |redirectingName *Optional*                           |
|redirecting_presentation_indicator            |str |redirectingPresentationIndicator *Optional*          |
|redirecting_reason                            |str |RedirectingReason *Optional*                         |
|account_authorization_code                    |str |accountAuthorizationCode *Optional*                  |
|call_authorization_code                       |str |callAuthorizationCode *Optional*                     |
|user_group_id                                 |str |userGroupId *Optional*                               |
|user_id                                       |str |userId *Optional*                                    |
|user_primary_dn                               |str |userPrimaryDn *Optional*                             |
|user_primary_extension                        |str |userPrimaryExtension *Optional*                      |
</div>


## `ExtendedMixedCallLogsEntry20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Extended Call Log entry describing a placed, received, or missed call.

"countryCode" is the user's country code The following time elements are represented
as timestamp, i.e., the number of milliseconds since January 1, 1970, 00:00:00 GMT.
"startTime" represents the time when the system sends out a call invitation message
(e.g.  for placed calls) or receives a call invitation message (e.g.  for
missed/received calls). "answerTime" represents the time when the call is answered by
the terminating party.  "detachedTime" represents the time when the call is
successfully redirected by the system.  "releaseTime" represents the time when the
call is released.  This time corresponds to the moment the call is released by the
system, and not necessarily when one party hangs up, since this does not always mean
the call is released (e.g.  Emergency/911 calls). The elements "userGroupId",
"userId","userPrimaryDn" and "userPrimaryExtension" are only returned when the
enterprise or group level requests are used.  The following elements are only used in
AS data mode and not returned in XS data mode: callAuthorizationCode
callSecurityClassification

**Attributes:**

|Name                                          |Type|Description                                          |
|----------------------------------------------|----|-----------------------------------------------------|
|call_log_type                                 |str |callLogType                                          |
|country_code                                  |str |countryCode                                          |
|call_log_id                                   |str |callLogId                                            |
|call_id                                       |str |callId                                               |
|subscriber_type                               |str |subscriberType                                       |
|dialed_number                                 |str |dialedNumber *Optional*                              |
|called_number                                 |str |calledNumber *Optional*                              |
|network_translated_address                    |str |networkTranslatedAddress *Optional*                  |
|calling_asserted_number                       |str |callingAssertedNumber *Optional*                     |
|calling_presentation_number                   |str |callingPresentationNumber *Optional*                 |
|calling_presentation_number_source            |str |callingPresentationNumberSource *Optional*           |
|calling_presentation_name                     |str |callingPresentationName *Optional*                   |
|calling_presentation_indicator                |str |callingPresentationIndicator                         |
|calling_group_id                              |str |callingGroupId *Optional*                            |
|called_directory_name                         |str |calledDirectoryName *Optional*                       |
|called_group_id                               |str |calledGroupId *Optional*                             |
|connected_number                              |str |connectedNumber *Optional*                           |
|connected_number_source                       |str |connectedNumberSource *Optional*                     |
|connected_name                                |str |connectedName *Optional*                             |
|connected_presentation_indicator              |str |connectedPresentationIndicator *Optional*            |
|type_of_network                               |str |typeOfNetwork *Optional*                             |
|call_category                                 |str |callCategory *Optional*                              |
|basic_call_type                               |str |basicCallType                                        |
|configurable_call_type                        |str |configurableCallType *Optional*                      |
|alternate_call_indicator                      |str |alternateCallIndicator *Optional*                    |
|virtual_on_net_call_type                      |str |virtualOnNetCallType *Optional*                      |
|time                                          |str |time                                                 |
|start_time                                    |int |startTime                                            |
|answer_time                                   |int |answerTime *Optional*                                |
|release_time                                  |int |releaseTime *Optional*                               |
|detached_time                                 |int |detachedTime *Optional*                              |
|detached_answer_time                          |int |detachedAnswerTime *Optional*                        |
|outgoing_dnis                                 |str |outgoingDnis *Optional*                              |
|service_invocation_disposition                |str |serviceInvocationDisposition *Optional*              |
|service_invocation_dialed_number              |str |serviceInvocationDialedNumber *Optional*             |
|service_invocation_called_number              |str |serviceInvocationCalledNumber *Optional*             |
|service_invocation_network_translated_address |str |serviceInvocationNetworkTranslatedAddress *Optional* |
|service_invocation_type_of_network            |str |serviceInvocationTypeOfNetwork *Optional*            |
|service_invocation_call_category              |str |serviceInvocationCallCategory *Optional*             |
|service_invocation_basic_call_type            |str |serviceInvocationBasicCallType *Optional*            |
|service_invocation_configurable_call_type     |str |serviceInvocationConfigurableCallType *Optional*     |
|service_invocation_alternate_call_indicator   |str |serviceInvocationAlternateCallIndicator *Optional*   |
|service_invocation_virtual_on_net_call_type   |str |serviceInvocationVirtualOnNetCallType *Optional*     |
|service_invocation_called_directory_name      |str |serviceInvocationCalledDirectoryName *Optional*      |
|service_invocation_called_group_id            |str |serviceInvocationCalledGroupId *Optional*            |
|redirecting_number                            |str |redirectingNumber *Optional*                         |
|redirecting_name                              |str |redirectingName *Optional*                           |
|redirecting_presentation_indicator            |str |redirectingPresentationIndicator *Optional*          |
|redirecting_reason                            |str |RedirectingReason *Optional*                         |
|account_authorization_code                    |str |accountAuthorizationCode *Optional*                  |
|call_authorization_code                       |str |callAuthorizationCode *Optional*                     |
|user_group_id                                 |str |userGroupId *Optional*                               |
|user_id                                       |str |userId *Optional*                                    |
|user_primary_dn                               |str |userPrimaryDn *Optional*                             |
|user_primary_extension                        |str |userPrimaryExtension *Optional*                      |
|security_classification                       |str |securityClassification *Optional*                    |
</div>


## `ExtendedMixedCallLogsEntry20sp1`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Extended Call Log entry describing a placed, received, or missed call.

"countryCode" is the user's country code The following time elements are represented
as timestamp, i.e., the number of milliseconds since January 1, 1970, 00:00:00 GMT.
"startTime" represents the time when the system sends out a call invitation message
(e.g.  for placed calls) or receives a call invitation message (e.g.  for
missed/received calls). "answerTime" represents the time when the call is answered by
the terminating party.  "detachedTime" represents the time when the call is
successfully redirected by the system.  "releaseTime" represents the time when the
call is released.  This time corresponds to the moment the call is released by the
system, and not necessarily when one party hangs up, since this does not always mean
the call is released (e.g.  Emergency/911 calls). The elements "userGroupId",
"userId","userPrimaryDn" and "userPrimaryExtension" are only returned when the
enterprise or group level requests are used.  The following elements are only used in
AS data mode: callAuthorizationCode callSecurityClassification

**Attributes:**

|Name                                          |Type|Description                                          |
|----------------------------------------------|----|-----------------------------------------------------|
|call_log_type                                 |str |callLogType                                          |
|country_code                                  |str |countryCode                                          |
|call_log_id                                   |str |callLogId                                            |
|call_id                                       |str |callId                                               |
|subscriber_type                               |str |subscriberType                                       |
|dialed_number                                 |str |dialedNumber *Optional*                              |
|called_number                                 |str |calledNumber *Optional*                              |
|network_translated_address                    |str |networkTranslatedAddress *Optional*                  |
|calling_asserted_number                       |str |callingAssertedNumber *Optional*                     |
|calling_presentation_number                   |str |callingPresentationNumber *Optional*                 |
|calling_presentation_number_source            |str |callingPresentationNumberSource *Optional*           |
|calling_presentation_name                     |str |callingPresentationName *Optional*                   |
|calling_presentation_indicator                |str |callingPresentationIndicator                         |
|calling_group_id                              |str |callingGroupId *Optional*                            |
|called_directory_name                         |str |calledDirectoryName *Optional*                       |
|called_group_id                               |str |calledGroupId *Optional*                             |
|connected_number                              |str |connectedNumber *Optional*                           |
|connected_number_source                       |str |connectedNumberSource *Optional*                     |
|connected_name                                |str |connectedName *Optional*                             |
|connected_presentation_indicator              |str |connectedPresentationIndicator *Optional*            |
|type_of_network                               |str |typeOfNetwork *Optional*                             |
|call_category                                 |str |callCategory *Optional*                              |
|basic_call_type                               |str |basicCallType                                        |
|configurable_call_type                        |str |configurableCallType *Optional*                      |
|alternate_call_indicator                      |str |alternateCallIndicator *Optional*                    |
|virtual_on_net_call_type                      |str |virtualOnNetCallType *Optional*                      |
|time                                          |str |time                                                 |
|start_time                                    |int |startTime                                            |
|answer_time                                   |int |answerTime *Optional*                                |
|release_time                                  |int |releaseTime *Optional*                               |
|detached_time                                 |int |detachedTime *Optional*                              |
|detached_answer_time                          |int |detachedAnswerTime *Optional*                        |
|outgoing_dnis                                 |str |outgoingDnis *Optional*                              |
|service_invocation_disposition                |str |serviceInvocationDisposition *Optional*              |
|service_invocation_dialed_number              |str |serviceInvocationDialedNumber *Optional*             |
|service_invocation_called_number              |str |serviceInvocationCalledNumber *Optional*             |
|service_invocation_network_translated_address |str |serviceInvocationNetworkTranslatedAddress *Optional* |
|service_invocation_type_of_network            |str |serviceInvocationTypeOfNetwork *Optional*            |
|service_invocation_call_category              |str |serviceInvocationCallCategory *Optional*             |
|service_invocation_basic_call_type            |str |serviceInvocationBasicCallType *Optional*            |
|service_invocation_configurable_call_type     |str |serviceInvocationConfigurableCallType *Optional*     |
|service_invocation_alternate_call_indicator   |str |serviceInvocationAlternateCallIndicator *Optional*   |
|service_invocation_virtual_on_net_call_type   |str |serviceInvocationVirtualOnNetCallType *Optional*     |
|service_invocation_called_directory_name      |str |serviceInvocationCalledDirectoryName *Optional*      |
|service_invocation_called_group_id            |str |serviceInvocationCalledGroupId *Optional*            |
|redirecting_number                            |str |redirectingNumber *Optional*                         |
|redirecting_name                              |str |redirectingName *Optional*                           |
|redirecting_presentation_indicator            |str |redirectingPresentationIndicator *Optional*          |
|redirecting_reason                            |str |RedirectingReason *Optional*                         |
|account_authorization_code                    |str |accountAuthorizationCode *Optional*                  |
|call_authorization_code                       |str |callAuthorizationCode *Optional*                     |
|user_group_id                                 |str |userGroupId *Optional*                               |
|user_id                                       |str |userId *Optional*                                    |
|user_primary_dn                               |str |userPrimaryDn *Optional*                             |
|user_primary_extension                        |str |userPrimaryExtension *Optional*                      |
|security_classification                       |str |securityClassification *Optional*                    |
|direct_route_number                           |str |directRouteNumber *Optional*                         |
</div>


## `ExtendedMixedCallLogsEntry21`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Extended Call Log entry describing a placed, received, or missed call.

"countryCode" is the user's country code The following time elements are represented
as timestamp, i.e., the number of milliseconds since January 1, 1970, 00:00:00 GMT.
"startTime" represents the time when the system sends out a call invitation message
(e.g.  for placed calls) or receives a call invitation message (e.g.  for
missed/received calls). "answerTime" represents the time when the call is answered by
the terminating party.  "detachedTime" represents the time when the call is
successfully redirected by the system.  "releaseTime" represents the time when the
call is released.  This time corresponds to the moment the call is released by the
system, and not necessarily when one party hangs up, since this does not always mean
the call is released (e.g.  Emergency/911 calls). The elements "userGroupId",
"userId","userPrimaryDn" and "userPrimaryExtension" are only returned when the
enterprise or group level requests are used.  The following elements are only used in
AS data mode and not returned in XS data mode: callAuthorizationCode
securityClassification

**Attributes:**

|Name                                          |Type|Description                                          |
|----------------------------------------------|----|-----------------------------------------------------|
|call_log_type                                 |str |callLogType                                          |
|country_code                                  |str |countryCode                                          |
|call_log_id                                   |str |callLogId                                            |
|call_id                                       |str |callId                                               |
|subscriber_type                               |str |subscriberType                                       |
|dialed_number                                 |str |dialedNumber *Optional*                              |
|called_number                                 |str |calledNumber *Optional*                              |
|network_translated_address                    |str |networkTranslatedAddress *Optional*                  |
|calling_asserted_number                       |str |callingAssertedNumber *Optional*                     |
|calling_presentation_number                   |str |callingPresentationNumber *Optional*                 |
|calling_presentation_number_source            |str |callingPresentationNumberSource *Optional*           |
|calling_presentation_name                     |str |callingPresentationName *Optional*                   |
|calling_presentation_indicator                |str |callingPresentationIndicator                         |
|calling_group_id                              |str |callingGroupId *Optional*                            |
|called_directory_name                         |str |calledDirectoryName *Optional*                       |
|called_group_id                               |str |calledGroupId *Optional*                             |
|connected_number                              |str |connectedNumber *Optional*                           |
|connected_number_source                       |str |connectedNumberSource *Optional*                     |
|connected_name                                |str |connectedName *Optional*                             |
|connected_presentation_indicator              |str |connectedPresentationIndicator *Optional*            |
|type_of_network                               |str |typeOfNetwork *Optional*                             |
|call_category                                 |str |callCategory *Optional*                              |
|basic_call_type                               |str |basicCallType                                        |
|configurable_call_type                        |str |configurableCallType *Optional*                      |
|alternate_call_indicator                      |str |alternateCallIndicator *Optional*                    |
|virtual_on_net_call_type                      |str |virtualOnNetCallType *Optional*                      |
|time                                          |str |time                                                 |
|start_time                                    |int |startTime                                            |
|answer_time                                   |int |answerTime *Optional*                                |
|release_time                                  |int |releaseTime *Optional*                               |
|detached_time                                 |int |detachedTime *Optional*                              |
|detached_answer_time                          |int |detachedAnswerTime *Optional*                        |
|outgoing_dnis                                 |str |outgoingDnis *Optional*                              |
|service_invocation_disposition                |str |serviceInvocationDisposition *Optional*              |
|service_invocation_dialed_number              |str |serviceInvocationDialedNumber *Optional*             |
|service_invocation_called_number              |str |serviceInvocationCalledNumber *Optional*             |
|service_invocation_network_translated_address |str |serviceInvocationNetworkTranslatedAddress *Optional* |
|service_invocation_type_of_network            |str |serviceInvocationTypeOfNetwork *Optional*            |
|service_invocation_call_category              |str |serviceInvocationCallCategory *Optional*             |
|service_invocation_basic_call_type            |str |serviceInvocationBasicCallType *Optional*            |
|service_invocation_configurable_call_type     |str |serviceInvocationConfigurableCallType *Optional*     |
|service_invocation_alternate_call_indicator   |str |serviceInvocationAlternateCallIndicator *Optional*   |
|service_invocation_virtual_on_net_call_type   |str |serviceInvocationVirtualOnNetCallType *Optional*     |
|service_invocation_called_directory_name      |str |serviceInvocationCalledDirectoryName *Optional*      |
|service_invocation_called_group_id            |str |serviceInvocationCalledGroupId *Optional*            |
|redirecting_number                            |str |redirectingNumber *Optional*                         |
|redirecting_name                              |str |redirectingName *Optional*                           |
|redirecting_presentation_indicator            |str |redirectingPresentationIndicator *Optional*          |
|redirecting_reason                            |str |RedirectingReason *Optional*                         |
|account_authorization_code                    |str |accountAuthorizationCode *Optional*                  |
|call_authorization_code                       |str |callAuthorizationCode *Optional*                     |
|user_group_id                                 |str |userGroupId *Optional*                               |
|user_id                                       |str |userId *Optional*                                    |
|user_primary_dn                               |str |userPrimaryDn *Optional*                             |
|user_primary_extension                        |str |userPrimaryExtension *Optional*                      |
|security_classification                       |str |securityClassification *Optional*                    |
</div>


## `ExtendedMixedCallLogsEntry21sp1`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Extended Call Log entry describing a placed, received, or missed call.

"countryCode" is the user's country code The following time elements are represented
as timestamp, i.e., the number of milliseconds since January 1, 1970, 00:00:00 GMT.
"startTime" represents the time when the system sends out a call invitation message
(e.g.  for placed calls) or receives a call invitation message (e.g.  for
missed/received calls). "answerTime" represents the time when the call is answered by
the terminating party.  "detachedTime" represents the time when the call is
successfully redirected by the system.  "releaseTime" represents the time when the
call is released.  This time corresponds to the moment the call is released by the
system, and not necessarily when one party hangs up, since this does not always mean
the call is released (e.g.  Emergency/911 calls). The elements "userGroupId",
"userId","userPrimaryDn" and "userPrimaryExtension" are only returned when the
enterprise or group level requests are used.  The following elements are only used in
AS data mode: callAuthorizationCode securityClassification
ExtendedMixedCallLogsEntry21sp1 version: only the ServiceInvocationDisposition21sp1
name changed.

**Attributes:**

|Name                                          |Type|Description                                          |
|----------------------------------------------|----|-----------------------------------------------------|
|call_log_type                                 |str |callLogType                                          |
|country_code                                  |str |countryCode                                          |
|call_log_id                                   |str |callLogId                                            |
|call_id                                       |str |callId                                               |
|subscriber_type                               |str |subscriberType                                       |
|dialed_number                                 |str |dialedNumber *Optional*                              |
|called_number                                 |str |calledNumber *Optional*                              |
|network_translated_address                    |str |networkTranslatedAddress *Optional*                  |
|calling_asserted_number                       |str |callingAssertedNumber *Optional*                     |
|calling_presentation_number                   |str |callingPresentationNumber *Optional*                 |
|calling_presentation_number_source            |str |callingPresentationNumberSource *Optional*           |
|calling_presentation_name                     |str |callingPresentationName *Optional*                   |
|calling_presentation_indicator                |str |callingPresentationIndicator                         |
|calling_group_id                              |str |callingGroupId *Optional*                            |
|called_directory_name                         |str |calledDirectoryName *Optional*                       |
|called_group_id                               |str |calledGroupId *Optional*                             |
|connected_number                              |str |connectedNumber *Optional*                           |
|connected_number_source                       |str |connectedNumberSource *Optional*                     |
|connected_name                                |str |connectedName *Optional*                             |
|connected_presentation_indicator              |str |connectedPresentationIndicator *Optional*            |
|type_of_network                               |str |typeOfNetwork *Optional*                             |
|call_category                                 |str |callCategory *Optional*                              |
|basic_call_type                               |str |basicCallType                                        |
|configurable_call_type                        |str |configurableCallType *Optional*                      |
|alternate_call_indicator                      |str |alternateCallIndicator *Optional*                    |
|virtual_on_net_call_type                      |str |virtualOnNetCallType *Optional*                      |
|time                                          |str |time                                                 |
|start_time                                    |int |startTime                                            |
|answer_time                                   |int |answerTime *Optional*                                |
|release_time                                  |int |releaseTime *Optional*                               |
|detached_time                                 |int |detachedTime *Optional*                              |
|detached_answer_time                          |int |detachedAnswerTime *Optional*                        |
|outgoing_dnis                                 |str |outgoingDnis *Optional*                              |
|service_invocation_disposition                |str |serviceInvocationDisposition *Optional*              |
|service_invocation_dialed_number              |str |serviceInvocationDialedNumber *Optional*             |
|service_invocation_called_number              |str |serviceInvocationCalledNumber *Optional*             |
|service_invocation_network_translated_address |str |serviceInvocationNetworkTranslatedAddress *Optional* |
|service_invocation_type_of_network            |str |serviceInvocationTypeOfNetwork *Optional*            |
|service_invocation_call_category              |str |serviceInvocationCallCategory *Optional*             |
|service_invocation_basic_call_type            |str |serviceInvocationBasicCallType *Optional*            |
|service_invocation_configurable_call_type     |str |serviceInvocationConfigurableCallType *Optional*     |
|service_invocation_alternate_call_indicator   |str |serviceInvocationAlternateCallIndicator *Optional*   |
|service_invocation_virtual_on_net_call_type   |str |serviceInvocationVirtualOnNetCallType *Optional*     |
|service_invocation_called_directory_name      |str |serviceInvocationCalledDirectoryName *Optional*      |
|service_invocation_called_group_id            |str |serviceInvocationCalledGroupId *Optional*            |
|redirecting_number                            |str |redirectingNumber *Optional*                         |
|redirecting_name                              |str |redirectingName *Optional*                           |
|redirecting_presentation_indicator            |str |redirectingPresentationIndicator *Optional*          |
|redirecting_reason                            |str |RedirectingReason *Optional*                         |
|account_authorization_code                    |str |accountAuthorizationCode *Optional*                  |
|call_authorization_code                       |str |callAuthorizationCode *Optional*                     |
|user_group_id                                 |str |userGroupId *Optional*                               |
|user_id                                       |str |userId *Optional*                                    |
|user_primary_dn                               |str |userPrimaryDn *Optional*                             |
|user_primary_extension                        |str |userPrimaryExtension *Optional*                      |
|security_classification                       |str |securityClassification *Optional*                    |
</div>


## `ExtendedMixedCallLogsEntry21sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Extended Call Log entry describing a placed, received, or missed call.

"countryCode" is the user's country code The following time elements are represented
as timestamp, i.e., the number of milliseconds since January 1, 1970, 00:00:00 GMT.
"startTime" represents the time when the system sends out a call invitation message
(e.g.  for placed calls) or receives a call invitation message (e.g.  for
missed/received calls). "answerTime" represents the time when the call is answered by
the terminating party.  "detachedTime" represents the time when the call is
successfully redirected by the system.  "releaseTime" represents the time when the
call is released.  This time corresponds to the moment the call is released by the
system, and not necessarily when one party hangs up, since this does not always mean
the call is released (e.g.  Emergency/911 calls). The elements "userGroupId",
"userId","userPrimaryDn" and "userPrimaryExtension" are only returned when the
enterprise or group level requests are used.  The following elements are only used in
AS data mode: callAuthorizationCode securityClassification
ExtendedMixedCallLogsEntry21sp1 version: only the ServiceInvocationDisposition21sp1
name changed.

**Attributes:**

|Name                                          |Type|Description                                          |
|----------------------------------------------|----|-----------------------------------------------------|
|call_log_type                                 |str |callLogType                                          |
|country_code                                  |str |countryCode                                          |
|call_log_id                                   |str |callLogId                                            |
|call_id                                       |str |callId                                               |
|subscriber_type                               |str |subscriberType                                       |
|dialed_number                                 |str |dialedNumber *Optional*                              |
|called_number                                 |str |calledNumber *Optional*                              |
|network_translated_address                    |str |networkTranslatedAddress *Optional*                  |
|calling_asserted_number                       |str |callingAssertedNumber *Optional*                     |
|calling_presentation_number                   |str |callingPresentationNumber *Optional*                 |
|calling_presentation_number_source            |str |callingPresentationNumberSource *Optional*           |
|calling_presentation_name                     |str |callingPresentationName *Optional*                   |
|calling_presentation_indicator                |str |callingPresentationIndicator                         |
|calling_group_id                              |str |callingGroupId *Optional*                            |
|called_directory_name                         |str |calledDirectoryName *Optional*                       |
|called_group_id                               |str |calledGroupId *Optional*                             |
|connected_number                              |str |connectedNumber *Optional*                           |
|connected_number_source                       |str |connectedNumberSource *Optional*                     |
|connected_name                                |str |connectedName *Optional*                             |
|connected_presentation_indicator              |str |connectedPresentationIndicator *Optional*            |
|type_of_network                               |str |typeOfNetwork *Optional*                             |
|call_category                                 |str |callCategory *Optional*                              |
|basic_call_type                               |str |basicCallType                                        |
|configurable_call_type                        |str |configurableCallType *Optional*                      |
|alternate_call_indicator                      |str |alternateCallIndicator *Optional*                    |
|virtual_on_net_call_type                      |str |virtualOnNetCallType *Optional*                      |
|time                                          |str |time                                                 |
|start_time                                    |int |startTime                                            |
|answer_time                                   |int |answerTime *Optional*                                |
|release_time                                  |int |releaseTime *Optional*                               |
|detached_time                                 |int |detachedTime *Optional*                              |
|detached_answer_time                          |int |detachedAnswerTime *Optional*                        |
|outgoing_dnis                                 |str |outgoingDnis *Optional*                              |
|service_invocation_disposition                |str |serviceInvocationDisposition *Optional*              |
|service_invocation_dialed_number              |str |serviceInvocationDialedNumber *Optional*             |
|service_invocation_called_number              |str |serviceInvocationCalledNumber *Optional*             |
|service_invocation_network_translated_address |str |serviceInvocationNetworkTranslatedAddress *Optional* |
|service_invocation_type_of_network            |str |serviceInvocationTypeOfNetwork *Optional*            |
|service_invocation_call_category              |str |serviceInvocationCallCategory *Optional*             |
|service_invocation_basic_call_type            |str |serviceInvocationBasicCallType *Optional*            |
|service_invocation_configurable_call_type     |str |serviceInvocationConfigurableCallType *Optional*     |
|service_invocation_alternate_call_indicator   |str |serviceInvocationAlternateCallIndicator *Optional*   |
|service_invocation_virtual_on_net_call_type   |str |serviceInvocationVirtualOnNetCallType *Optional*     |
|service_invocation_called_directory_name      |str |serviceInvocationCalledDirectoryName *Optional*      |
|service_invocation_called_group_id            |str |serviceInvocationCalledGroupId *Optional*            |
|redirecting_number                            |str |redirectingNumber *Optional*                         |
|redirecting_name                              |str |redirectingName *Optional*                           |
|redirecting_presentation_indicator            |str |redirectingPresentationIndicator *Optional*          |
|redirecting_reason                            |str |RedirectingReason *Optional*                         |
|account_authorization_code                    |str |accountAuthorizationCode *Optional*                  |
|call_authorization_code                       |str |callAuthorizationCode *Optional*                     |
|user_group_id                                 |str |userGroupId *Optional*                               |
|user_id                                       |str |userId *Optional*                                    |
|user_primary_dn                               |str |userPrimaryDn *Optional*                             |
|user_primary_extension                        |str |userPrimaryExtension *Optional*                      |
|security_classification                       |str |securityClassification *Optional*                    |
|direct_route_number                           |str |directRouteNumber *Optional*                         |
</div>


## `ExtendedMixedCallLogsEntry22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Extended Call Log entry describing a placed, received, or missed call.

"countryCode" is the user's country code The following time elements are represented
as timestamp, i.e., the number of milliseconds since January 1, 1970, 00:00:00 GMT.
"startTime" represents the time when the system sends out a call invitation message
(e.g.  for placed calls) or receives a call invitation message (e.g.  for
missed/received calls). "answerTime" represents the time when the call is answered by
the terminating party.  "detachedTime" represents the time when the call is
successfully redirected by the system.  "releaseTime" represents the time when the
call is released.  This time corresponds to the moment the call is released by the
system, and not necessarily when one party hangs up, since this does not always mean
the call is released (e.g.  Emergency/911 calls). The elements "userGroupId",
"userId","userPrimaryDn" and "userPrimaryExtension" are only returned when the
enterprise or group level requests are used.  The following elements are only used in
AS data mode: callAuthorizationCode securityClassification
ExtendedMixedCallLogsEntry21sp1 version: only the ServiceInvocationDisposition21sp1
name changed.

**Attributes:**

|Name                                          |Type|Description                                          |
|----------------------------------------------|----|-----------------------------------------------------|
|call_log_type                                 |str |callLogType                                          |
|country_code                                  |str |countryCode                                          |
|call_log_id                                   |str |callLogId                                            |
|call_id                                       |str |callId                                               |
|subscriber_type                               |str |subscriberType                                       |
|dialed_number                                 |str |dialedNumber *Optional*                              |
|called_number                                 |str |calledNumber *Optional*                              |
|network_translated_address                    |str |networkTranslatedAddress *Optional*                  |
|calling_asserted_number                       |str |callingAssertedNumber *Optional*                     |
|calling_presentation_number                   |str |callingPresentationNumber *Optional*                 |
|calling_presentation_number_source            |str |callingPresentationNumberSource *Optional*           |
|calling_presentation_name                     |str |callingPresentationName *Optional*                   |
|calling_presentation_indicator                |str |callingPresentationIndicator                         |
|calling_group_id                              |str |callingGroupId *Optional*                            |
|called_directory_name                         |str |calledDirectoryName *Optional*                       |
|called_group_id                               |str |calledGroupId *Optional*                             |
|connected_number                              |str |connectedNumber *Optional*                           |
|connected_number_source                       |str |connectedNumberSource *Optional*                     |
|connected_name                                |str |connectedName *Optional*                             |
|connected_presentation_indicator              |str |connectedPresentationIndicator *Optional*            |
|type_of_network                               |str |typeOfNetwork *Optional*                             |
|call_category                                 |str |callCategory *Optional*                              |
|basic_call_type                               |str |basicCallType                                        |
|configurable_call_type                        |str |configurableCallType *Optional*                      |
|alternate_call_indicator                      |str |alternateCallIndicator *Optional*                    |
|virtual_on_net_call_type                      |str |virtualOnNetCallType *Optional*                      |
|time                                          |str |time                                                 |
|start_time                                    |int |startTime                                            |
|answer_time                                   |int |answerTime *Optional*                                |
|release_time                                  |int |releaseTime *Optional*                               |
|detached_time                                 |int |detachedTime *Optional*                              |
|detached_answer_time                          |int |detachedAnswerTime *Optional*                        |
|outgoing_dnis                                 |str |outgoingDnis *Optional*                              |
|service_invocation_disposition                |str |serviceInvocationDisposition *Optional*              |
|service_invocation_dialed_number              |str |serviceInvocationDialedNumber *Optional*             |
|service_invocation_called_number              |str |serviceInvocationCalledNumber *Optional*             |
|service_invocation_network_translated_address |str |serviceInvocationNetworkTranslatedAddress *Optional* |
|service_invocation_type_of_network            |str |serviceInvocationTypeOfNetwork *Optional*            |
|service_invocation_call_category              |str |serviceInvocationCallCategory *Optional*             |
|service_invocation_basic_call_type            |str |serviceInvocationBasicCallType *Optional*            |
|service_invocation_configurable_call_type     |str |serviceInvocationConfigurableCallType *Optional*     |
|service_invocation_alternate_call_indicator   |str |serviceInvocationAlternateCallIndicator *Optional*   |
|service_invocation_virtual_on_net_call_type   |str |serviceInvocationVirtualOnNetCallType *Optional*     |
|service_invocation_called_directory_name      |str |serviceInvocationCalledDirectoryName *Optional*      |
|service_invocation_called_group_id            |str |serviceInvocationCalledGroupId *Optional*            |
|redirecting_number                            |str |redirectingNumber *Optional*                         |
|redirecting_name                              |str |redirectingName *Optional*                           |
|redirecting_presentation_indicator            |str |redirectingPresentationIndicator *Optional*          |
|redirecting_reason                            |str |RedirectingReason *Optional*                         |
|account_authorization_code                    |str |accountAuthorizationCode *Optional*                  |
|call_authorization_code                       |str |callAuthorizationCode *Optional*                     |
|user_group_id                                 |str |userGroupId *Optional*                               |
|user_id                                       |str |userId *Optional*                                    |
|user_primary_dn                               |str |userPrimaryDn *Optional*                             |
|user_primary_extension                        |str |userPrimaryExtension *Optional*                      |
|security_classification                       |str |securityClassification *Optional*                    |
|direct_route_number                           |str |directRouteNumber *Optional*                         |
|route_list_dn                                 |str |routeListDN *Optional*                               |
</div>


## `ExtendedMixedCallLogsEntry23`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Extended Call Log entry describing a placed, received, or missed call.

"countryCode" is the user's country code The following time elements are represented
as timestamp, i.e., the number of milliseconds since January 1, 1970, 00:00:00 GMT.
"startTime" represents the time when the system sends out a call invitation message
(e.g.  for placed calls) or receives a call invitation message (e.g.  for
missed/received calls). "answerTime" represents the time when the call is answered by
the terminating party.  "detachedTime" represents the time when the call is
successfully redirected by the system.  "releaseTime" represents the time when the
call is released.  This time corresponds to the moment the call is released by the
system, and not necessarily when one party hangs up, since this does not always mean
the call is released (e.g.  Emergency/911 calls). The elements "userGroupId",
"userId","userPrimaryDn" and "userPrimaryExtension" are only returned when the
enterprise or group level requests are used.  The following elements are only used in
AS data mode: callAuthorizationCode securityClassification
ExtendedMixedCallLogsEntry21sp1 version: only the ServiceInvocationDisposition21sp1
name changed.

**Attributes:**

|Name                                          |Type|Description                                          |
|----------------------------------------------|----|-----------------------------------------------------|
|call_log_type                                 |str |callLogType                                          |
|country_code                                  |str |countryCode                                          |
|call_log_id                                   |str |callLogId                                            |
|call_id                                       |str |callId                                               |
|subscriber_type                               |str |subscriberType                                       |
|dialed_number                                 |str |dialedNumber *Optional*                              |
|called_number                                 |str |calledNumber *Optional*                              |
|network_translated_address                    |str |networkTranslatedAddress *Optional*                  |
|calling_asserted_number                       |str |callingAssertedNumber *Optional*                     |
|calling_presentation_number                   |str |callingPresentationNumber *Optional*                 |
|calling_presentation_number_source            |str |callingPresentationNumberSource *Optional*           |
|calling_presentation_name                     |str |callingPresentationName *Optional*                   |
|calling_presentation_indicator                |str |callingPresentationIndicator                         |
|calling_group_id                              |str |callingGroupId *Optional*                            |
|called_directory_name                         |str |calledDirectoryName *Optional*                       |
|called_group_id                               |str |calledGroupId *Optional*                             |
|connected_number                              |str |connectedNumber *Optional*                           |
|connected_number_source                       |str |connectedNumberSource *Optional*                     |
|connected_name                                |str |connectedName *Optional*                             |
|connected_presentation_indicator              |str |connectedPresentationIndicator *Optional*            |
|type_of_network                               |str |typeOfNetwork *Optional*                             |
|call_category                                 |str |callCategory *Optional*                              |
|basic_call_type                               |str |basicCallType                                        |
|configurable_call_type                        |str |configurableCallType *Optional*                      |
|alternate_call_indicator                      |str |alternateCallIndicator *Optional*                    |
|virtual_on_net_call_type                      |str |virtualOnNetCallType *Optional*                      |
|time                                          |str |time                                                 |
|start_time                                    |int |startTime                                            |
|answer_time                                   |int |answerTime *Optional*                                |
|release_time                                  |int |releaseTime *Optional*                               |
|detached_time                                 |int |detachedTime *Optional*                              |
|detached_answer_time                          |int |detachedAnswerTime *Optional*                        |
|outgoing_dnis                                 |str |outgoingDnis *Optional*                              |
|service_invocation_disposition                |str |serviceInvocationDisposition *Optional*              |
|service_invocation_dialed_number              |str |serviceInvocationDialedNumber *Optional*             |
|service_invocation_called_number              |str |serviceInvocationCalledNumber *Optional*             |
|service_invocation_network_translated_address |str |serviceInvocationNetworkTranslatedAddress *Optional* |
|service_invocation_type_of_network            |str |serviceInvocationTypeOfNetwork *Optional*            |
|service_invocation_call_category              |str |serviceInvocationCallCategory *Optional*             |
|service_invocation_basic_call_type            |str |serviceInvocationBasicCallType *Optional*            |
|service_invocation_configurable_call_type     |str |serviceInvocationConfigurableCallType *Optional*     |
|service_invocation_alternate_call_indicator   |str |serviceInvocationAlternateCallIndicator *Optional*   |
|service_invocation_virtual_on_net_call_type   |str |serviceInvocationVirtualOnNetCallType *Optional*     |
|service_invocation_called_directory_name      |str |serviceInvocationCalledDirectoryName *Optional*      |
|service_invocation_called_group_id            |str |serviceInvocationCalledGroupId *Optional*            |
|redirecting_number                            |str |redirectingNumber *Optional*                         |
|redirecting_name                              |str |redirectingName *Optional*                           |
|redirecting_presentation_indicator            |str |redirectingPresentationIndicator *Optional*          |
|redirecting_reason                            |str |RedirectingReason *Optional*                         |
|account_authorization_code                    |str |accountAuthorizationCode *Optional*                  |
|call_authorization_code                       |str |callAuthorizationCode *Optional*                     |
|user_group_id                                 |str |userGroupId *Optional*                               |
|user_id                                       |str |userId *Optional*                                    |
|user_primary_dn                               |str |userPrimaryDn *Optional*                             |
|user_primary_extension                        |str |userPrimaryExtension *Optional*                      |
|security_classification                       |str |securityClassification *Optional*                    |
|direct_route_number                           |str |directRouteNumber *Optional*                         |
|route_list_dn                                 |str |routeListDN *Optional*                               |
</div>


## `ExtensionRange`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Extension range.

The minimum and maximum values are inclusive.

**Attributes:**

|Name          |Type|Description  |
|--------------|----|-------------|
|min_extension |str |minExtension |
|max_extension |str |maxExtension |
</div>


## `ExtensionRange17`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Extension range.

The minimum and maximum values are inclusive.

**Attributes:**

|Name          |Type|Description  |
|--------------|----|-------------|
|min_extension |str |minExtension |
|max_extension |str |maxExtension |
</div>


## `FaxMessagingMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal fax messaging menu keys modify entry.


**Attributes:**

|Name                              |Type|Description                            |
|----------------------------------|----|---------------------------------------|
|save_fax_message_and_skip_to_next |str |saveFaxMessageAndSkipToNext *Optional* |
|previous_fax_message              |str |previousFaxMessage *Optional*          |
|play_envelope                     |str |playEnvelope *Optional*                |
|next_fax_message                  |str |nextFaxMessage *Optional*              |
|delete_fax_message                |str |deleteFaxMessage *Optional*            |
|print_fax_message                 |str |printFaxMessage *Optional*             |
|return_to_previous_menu           |str |returnToPreviousMenu *Optional*        |
</div>


## `FaxMessagingMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal fax messaging menu keys.


**Attributes:**

|Name                              |Type|Description                            |
|----------------------------------|----|---------------------------------------|
|save_fax_message_and_skip_to_next |str |saveFaxMessageAndSkipToNext *Optional* |
|previous_fax_message              |str |previousFaxMessage *Optional*          |
|play_envelope                     |str |playEnvelope *Optional*                |
|next_fax_message                  |str |nextFaxMessage *Optional*              |
|delete_fax_message                |str |deleteFaxMessage *Optional*            |
|print_fax_message                 |str |printFaxMessage *Optional*             |
|return_to_previous_menu           |str |returnToPreviousMenu *Optional*        |
</div>


## `FeatureAccessCodeEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Feature Access Code Entry

**Attributes:**

|Name                     |Type|Description              |
|-------------------------|----|-------------------------|
|feature_access_code_name |str |featureAccessCodeName    |
|main_code                |str |mainCode *Optional*      |
|alternate_code           |str |alternateCode *Optional* |
</div>


## `FeatureAccessCodeModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Feature Access Code Entry to be used in all the system, service provider and group
modify commands.


**Attributes:**

|Name                     |Type |Description              |
|-------------------------|-----|-------------------------|
|feature_access_code_name |str  |featureAccessCodeName    |
|main_code                |str  |mainCode *Optional*      |
|alternate_code           |str  |alternateCode *Optional* |
|enable_fac               |bool |enableFAC *Optional*     |
</div>


## `FeatureAccessCodeReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Feature Access Code Entry to be used in all GET commands.


**Attributes:**

|Name                     |Type |Description              |
|-------------------------|-----|-------------------------|
|feature_access_code_name |str  |featureAccessCodeName    |
|main_code                |str  |mainCode *Optional*      |
|alternate_code           |str  |alternateCode *Optional* |
|enable_fac               |bool |enableFAC *Optional*     |
</div>


## `FileRepositoryProtocolFTP`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Attributes of the FTP protocol when the file repository interface is using FTP.


**Attributes:**

|Name        |Type |Description|
|------------|-----|-----------|
|ftp_passive |bool |ftpPassive |
|net_address |str  |netAddress |
</div>


## `FileRepositoryProtocolFTP16`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Attributes of the FTP protocol when the file repository interface is using FTP.


**Attributes:**

|Name                    |Type |Description           |
|------------------------|-----|----------------------|
|ftp_passive             |bool |ftpPassive            |
|net_address             |str  |netAddress            |
|ftp_remote_verification |bool |ftpRemoteVerification |
</div>


## `FileRepositoryProtocolWebDAV`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Attributes of the WebDav protocol when the file repository interface is using WebDav.


**Attributes:**

|Name        |Type |Description|
|------------|-----|-----------|
|secure      |bool |secure     |
|net_address |str  |netAddress |
</div>


## `FileRepositoryProtocolWebDAV20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Attributes of the WebDav protocol when the file repository interface is using WebDav.


**Attributes:**

|Name                          |Type |Description                |
|------------------------------|-----|---------------------------|
|secure                        |bool |secure                     |
|net_address                   |str  |netAddress                 |
|extended_file_capture_support |bool |extendedFileCaptureSupport |
</div>


## `FileResource`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Represents either an existing file for the application server to use, or the contents
of a file to transfer.


**Attributes:**

|Name             |Type|Description               |
|-----------------|----|--------------------------|
|source_file_name |str |sourceFileName *Optional* |
|file_content     |str |fileContent *Optional*    |
</div>


## `FindMeFollowMeAlertingGroupReplacementOutgoingDNSIPURIorUserIdList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of phone numbers/sipuris or user ids that replaces a previously configured
list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name         |Type|Description            |
|-------------|----|-----------------------|
|phone_number |str |phoneNumber *Optional* |
|user_id      |str |userId *Optional*      |
</div>


## `ForwardOrComposeMessageMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal forward or compose message menu keys modify entry.


**Attributes:**

|Name                                      |Type|Description                                     |
|------------------------------------------|----|------------------------------------------------|
|send_to_person                            |str |sendToPerson *Optional*                         |
|send_to_all_group_members                 |str |sendToAllGroupMembers *Optional*                |
|send_to_distribution_list                 |str |sendToDistributionList *Optional*               |
|change_current_introduction_or_message    |str |changeCurrentIntroductionOrMessage *Optional*   |
|listen_to_current_introduction_or_message |str |listenToCurrentIntroductionOrMessage *Optional* |
|set_or_clear_urgent_indicator             |str |setOrClearUrgentIndicator *Optional*            |
|set_or_clear_confidential_indicator       |str |setOrClearConfidentialIndicator *Optional*      |
|return_to_previous_menu                   |str |returnToPreviousMenu *Optional*                 |
|repeat_menu                               |str |repeatMenu *Optional*                           |
</div>


## `ForwardOrComposeMessageMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal forward or compose message menu keys.


**Attributes:**

|Name                                      |Type|Description                                     |
|------------------------------------------|----|------------------------------------------------|
|send_to_person                            |str |sendToPerson *Optional*                         |
|send_to_all_group_members                 |str |sendToAllGroupMembers *Optional*                |
|send_to_distribution_list                 |str |sendToDistributionList *Optional*               |
|change_current_introduction_or_message    |str |changeCurrentIntroductionOrMessage *Optional*   |
|listen_to_current_introduction_or_message |str |listenToCurrentIntroductionOrMessage *Optional* |
|set_or_clear_urgent_indicator             |str |setOrClearUrgentIndicator *Optional*            |
|set_or_clear_confidential_indicator       |str |setOrClearConfidentialIndicator *Optional*      |
|return_to_previous_menu                   |str |returnToPreviousMenu                            |
|repeat_menu                               |str |repeatMenu *Optional*                           |
</div>


## `GETSInhibitedAvpCodeKey`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The GETS inhibited Avp code entry.


**Attributes:**

|Name      |Type|Description|
|----------|----|-----------|
|avp_code  |int |avpCode    |
|vendor_id |int |vendorId   |
</div>


## `GETSSessionPriorityMapEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The GETS session priority map entry.


**Attributes:**

|Name             |Type|Description     |
|-----------------|----|----------------|
|priority_level   |int |priorityLevel   |
|session_priority |int |sessionPriority |
</div>


## `GreetingOnlyForwardingDestinationMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal greeting only forwarding destination menu keys modify entry.


**Attributes:**

|Name                                 |Type|Description                                  |
|-------------------------------------|----|---------------------------------------------|
|greeting_only_forwarding_destination |str |greetingOnlyForwardingDestination *Optional* |
</div>


## `GreetingOnlyForwardingDestinationMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal greeting only forwarding destination menu keys.


**Attributes:**

|Name                                 |Type|Description                                  |
|-------------------------------------|----|---------------------------------------------|
|greeting_only_forwarding_destination |str |greetingOnlyForwardingDestination *Optional* |
</div>


## `GreetingsMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal greeting menu keys modify entry.


**Attributes:**

|Name                    |Type|Description                     |
|------------------------|----|--------------------------------|
|personalized_name       |str |personalizedName *Optional*     |
|conference_greeting     |str |conferenceGreeting *Optional*   |
|return_to_previous_menu |str |returnToPreviousMenu *Optional* |
|repeat_menu             |str |repeatMenu *Optional*           |
</div>


## `GreetingsMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal greeting menu keys.


**Attributes:**

|Name                    |Type|Description                   |
|------------------------|----|------------------------------|
|personalized_name       |str |personalizedName *Optional*   |
|conference_greeting     |str |conferenceGreeting *Optional* |
|return_to_previous_menu |str |returnToPreviousMenu          |
|repeat_menu             |str |repeatMenu *Optional*         |
</div>


## `GroupAdmin`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The common Group Admin elements.


**Attributes:**

|Name       |Type|Description          |
|-----------|----|---------------------|
|user_id    |str |userId               |
|first_name |str |firstName *Optional* |
|last_name  |str |lastName *Optional*  |
|password   |str |password *Optional*  |
|language   |str |language *Optional*  |
</div>


## `GroupBroadWorksMobilityGetRequest21sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Get the group's BroadWorks Mobility settings.

The response is either a GroupBroadWorksMobilityGetResponse21sp1V2 or an
`ErrorResponse()`. Replaced by `GroupBroadWorksMobilityGetRequest22V2()`.

**Attributes:**

|Name                |Type|Description       |
|--------------------|----|------------------|
|service_provider_id |str |serviceProviderId |
|group_id            |str |groupId           |
</div>


## `GroupBroadWorksMobilityGetResponse21sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The response to a GroupBroadWorksMobilityGetRequest21sp1V2.

Replaced by `GroupBroadWorksMobilityGetResponse22V2()`.

**Attributes:**

|Name                                           |Type |Description                               |
|-----------------------------------------------|-----|------------------------------------------|
|use_setting_level                              |str  |useSettingLevel                           |
|enable_location_services                       |bool |enableLocationServices                    |
|enable_msrn_lookup                             |bool |enableMSRNLookup                          |
|enable_mobile_state_checking                   |bool |enableMobileStateChecking                 |
|deny_call_originations                         |bool |denyCallOriginations                      |
|deny_call_terminations                         |bool |denyCallTerminations                      |
|enable_announcement_suppression                |bool |enableAnnouncementSuppression             |
|enable_internal_clid_delivery_access_locations |bool |enableInternalCLIDDeliveryAccessLocations |
|enable_enhanced_unreachable_state_checking     |bool |enableEnhancedUnreachableStateChecking    |
|enable_network_call_barring_status_check       |bool |enableNetworkCallBarringStatusCheck       |
</div>


## `GroupDepartmentKey`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Uniquely identifies a department defined within a group.

To uniquely identify a group department, we must know the department name and which
group contains the department.

**Attributes:**

|Name                |Type|Description       |
|--------------------|----|------------------|
|service_provider_id |str |serviceProviderId |
|group_id            |str |groupId           |
|name                |str |name              |
</div>


## `GroupEnterpriseTrunkPriorityWeightedTrunkGroup`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Trunk group details (order and weight) for each trunk group

**Attributes:**

|Name        |Type|Description|
|------------|----|-----------|
|trunk_group |str |trunkGroup |
|priority    |int |priority   |
|weight      |int |weight     |
</div>


## `GroupExtensionLengthSettings`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Group extension length settings

**Attributes:**

|Name                                    |Type |Description                                    |
|----------------------------------------|-----|-----------------------------------------------|
|min_extension_length                    |int  |minExtensionLength *Optional*                  |
|max_extension_length                    |int  |maxExtensionLength *Optional*                  |
|default_extension_length                |int  |defaultExtensionLength *Optional*              |
|use_enterprise_extension_length_setting |bool |useEnterpriseExtensionLengthSetting *Optional* |
</div>


## `GroupHuntGroupGetInstanceRequest17sp1V1`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Request to get all the information of a Hunt Group instance.

The response is either GroupHuntGroupGetInstanceResponse17sp1V1 or `ErrorResponse()`.

**Attributes:**

|Name            |Type|Description   |
|----------------|----|--------------|
|service_user_id |str |serviceUserId |
</div>


## `GroupPreferredCarrierName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Group can either use it's service provider/enterprise's preferred carrier or use it's
own.

The group carrier name is exposed if it was previously configured.

**Attributes:**

|Name                                   |Type |Description                        |
|---------------------------------------|-----|-----------------------------------|
|use_service_provider_preferred_carrier |bool |useServiceProviderPreferredCarrier |
|carrier                                |str  |carrier *Optional*                 |
</div>


## `GroupPreferredCarrierNameModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Group can either use it's service provider/enterprise's preferred carrier or use it's
own.

You can use the Service Provider preferred carrier without clearing the group carrier
name -- in this case, the group carrier name is retained.

**Attributes:**

|Name                                   |Type |Description                        |
|---------------------------------------|-----|-----------------------------------|
|use_service_provider_preferred_carrier |bool |useServiceProviderPreferredCarrier |
|carrier                                |str  |carrier *Optional*                 |
</div>


## `GroupSessionAdmissionControlGroupGetRequest21sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Request to get a session admission control group for the group.

The response is either a GroupSessionAdmissionControlGroupGetResponse21sp1V2 or an
`ErrorResponse()`.

**Attributes:**

|Name                |Type|Description       |
|--------------------|----|------------------|
|service_provider_id |str |serviceProviderId |
|group_id            |str |groupId           |
|name                |str |name              |
</div>


## `Holiday`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Holiday entry.


**Attributes:**

|Name         |Type|Description        |
|-------------|----|-------------------|
|holiday_name |str |holidayName        |
|start_date   |str |startDate          |
|end_date     |str |endDate *Optional* |
</div>


## `HolidaySchedule`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Holiday Schedule.


**Attributes:**

|Name |Type|Description|
|-----|----|-----------|
|type |str |type       |
|name |str |name       |
</div>


## `HotelingMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal hoteling menu keys modify entry.


**Attributes:**

|Name                          |Type|Description                           |
|------------------------------|----|--------------------------------------|
|check_host_status             |str |checkHostStatus *Optional*            |
|associate_with_host           |str |associateWithHost *Optional*          |
|disassociate_from_host        |str |disassociateFromHost *Optional*       |
|disassociate_from_remote_host |str |disassociateFromRemoteHost *Optional* |
|return_to_previous_menu       |str |returnToPreviousMenu *Optional*       |
|repeat_menu                   |str |repeatMenu *Optional*                 |
</div>


## `HotelingMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal hoteling menu keys.


**Attributes:**

|Name                          |Type|Description                           |
|------------------------------|----|--------------------------------------|
|check_host_status             |str |checkHostStatus *Optional*            |
|associate_with_host           |str |associateWithHost *Optional*          |
|disassociate_from_host        |str |disassociateFromHost *Optional*       |
|disassociate_from_remote_host |str |disassociateFromRemoteHost *Optional* |
|return_to_previous_menu       |str |returnToPreviousMenu                  |
|repeat_menu                   |str |repeatMenu *Optional*                 |
</div>


## `HourMinute`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Represents a specific time with hour and minute granularity

**Attributes:**

|Name   |Type|Description|
|-------|----|-----------|
|hour   |int |hour       |
|minute |int |minute     |
</div>


## `HuntAgentWeight`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The weighted call distribution weight for an agent.


**Attributes:**

|Name          |Type|Description |
|--------------|----|------------|
|agent_user_id |str |agentUserId |
|weight        |int |weight      |
</div>


## `IPAddressRange`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
IP Address Range.


**Attributes:**

|Name           |Type|Description  |
|---------------|----|-------------|
|min_ip_address |str |minIpAddress |
|max_ip_address |str |maxIpAddress |
</div>


## `IncomingCallingPlanDigitPatternPermission`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Indicates whether calls from specified digit patterns are permitted.


**Attributes:**

|Name               |Type |Description      |
|-------------------|-----|-----------------|
|digit_pattern_name |str  |digitPatternName |
|allow              |bool |allow            |
</div>


## `InterceptDNListEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Intercept User Entry containing the phone number and a Description.


**Attributes:**

|Name         |Type|Description            |
|-------------|----|-----------------------|
|phone_number |str |phoneNumber            |
|description  |str |description *Optional* |
</div>


## `InternalReleaseCauseMapEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The internal release cause map entry.


**Attributes:**

|Name                   |Type|Description            |
|-----------------------|----|-----------------------|
|internal_release_cause |str |internalReleaseCause   |
|treatment_id           |str |treatmentId *Optional* |
</div>


## `LabeledFileNameResource`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Represents an existing file for the application server to use, along with a
description and mediaType.


**Attributes:**

|Name             |Type|Description    |
|-----------------|----|---------------|
|description      |str |description    |
|media_type       |str |mediaType      |
|source_file_name |str |sourceFileName |
</div>


## `LabeledFileResource`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Represents either an existing file for the application server to use, or the contents
of a file to transfer with a description.


**Attributes:**

|Name             |Type|Description               |
|-----------------|----|--------------------------|
|description      |str |description               |
|source_file_name |str |sourceFileName *Optional* |
|content          |str |content *Optional*        |
</div>


## `LabeledMediaFileResource`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Represents either an existing file for the application server to use, or the contents
of a file to transfer with a description.


**Attributes:**

|Name             |Type|Description               |
|-----------------|----|--------------------------|
|description      |str |description               |
|media_type       |str |mediaType                 |
|source_file_name |str |sourceFileName *Optional* |
|content          |str |content *Optional*        |
</div>


## `MWIDeliveryToMobileEndpointTemplateActivation`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
MWI Delivery To Mobile Endpoint enabled status indicator

**Attributes:**

|Name       |Type |Description|
|-----------|-----|-----------|
|language   |str  |language   |
|type       |str  |type       |
|is_enabled |bool |isEnabled  |
</div>


## `MWIDeliveryToMobileEndpointTemplateLine`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
MWI Delivery To Mobile Endpoint template section associated with a specific tag.


**Attributes:**

|Name    |Type|Description        |
|--------|----|-------------------|
|prefix  |str |prefix *Optional*  |
|tag     |str |tag *Optional*     |
|postfix |str |postfix *Optional* |
</div>


## `MaliciousCallTraceTimePeriod`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Modify the user level data associated with Malicious Call Trace.

The response is either a `SuccessResponse()` or an `ErrorResponse()`.

**Attributes:**

|Name            |Type|Description   |
|----------------|----|--------------|
|start_date_time |str |startDateTime |
|stop_date_time  |str |stopDateTime  |
</div>


## `MeetMeConferencingConferenceDuration`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Conference duration.


**Attributes:**

|Name    |Type|Description|
|--------|----|-----------|
|hours   |int |hours      |
|minutes |int |minutes    |
</div>


## `MeetMeConferencingConferenceKey`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Identifier for conference.


**Attributes:**

|Name          |Type|Description  |
|--------------|----|-------------|
|bridge_id     |str |bridgeId     |
|conference_id |str |conferenceId |
</div>


## `MeetMeConferencingConferencePorts`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Number of conference ports.

Can either be unlimited or limited to a value between 0 and 999999.

**Attributes:**

|Name      |Type |Description          |
|----------|-----|---------------------|
|unlimited |bool |unlimited *Optional* |
|quantity  |int  |quantity *Optional*  |
</div>


## `MeetMeConferencingConferenceRecordingKey`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Identifier for conference recording.

startTime is the recording start timestamp.

**Attributes:**

|Name          |Type|Description  |
|--------------|----|-------------|
|bridge_id     |str |bridgeId     |
|conference_id |str |conferenceId |
|start_time    |str |startTime    |
</div>


## `MeetMeConferencingConferenceSchedule`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Conference schedule.


**Attributes:**

|Name                     |Type                    |Description                        |
|-------------------------|------------------------|-----------------------------------|
|schedule_reservationless |scheduleReservationless |scheduleReservationless *Optional* |
|schedule_one_time        |scheduleOneTime         |scheduleOneTime *Optional*         |
|schedule_recurring       |scheduleRecurring       |scheduleRecurring *Optional*       |
</div>


## `MessageDepositMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal message deposit menu keys modify entry.


**Attributes:**

|Name                             |Type|Description                             |
|---------------------------------|----|----------------------------------------|
|enable_message_deposit           |str |enableMessageDeposit *Optional*         |
|disable_message_deposit          |str |disableMessageDeposit *Optional*        |
|listen_to_message_deposit_status |str |listenToMessageDepositStatus *Optional* |
|return_to_previous_menu          |str |returnToPreviousMenu *Optional*         |
|repeat_menu                      |str |repeatMenu *Optional*                   |
</div>


## `MessageDepositMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal message deposit menu keys.


**Attributes:**

|Name                             |Type|Description                             |
|---------------------------------|----|----------------------------------------|
|enable_message_deposit           |str |enableMessageDeposit *Optional*         |
|disable_message_deposit          |str |disableMessageDeposit *Optional*        |
|listen_to_message_deposit_status |str |listenToMessageDepositStatus *Optional* |
|return_to_previous_menu          |str |returnToPreviousMenu                    |
|repeat_menu                      |str |repeatMenu *Optional*                   |
</div>


## `MixedCallLogsEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Call Log entry describing a placed, received, or missed call.


**Attributes:**

|Name          |Type|Description            |
|--------------|----|-----------------------|
|call_log_type |str |callLogType            |
|country_code  |str |countryCode *Optional* |
|call_log_id   |str |callLogId              |
|phone_number  |str |phoneNumber            |
|name          |str |name                   |
|time          |str |time                   |
</div>


## `MusicOnHoldSourceAdd`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold source configuration.


**Attributes:**

|Name                       |Type           |Description               |
|---------------------------|---------------|--------------------------|
|audio_file_preferred_codec |str            |audioFilePreferredCodec   |
|message_source_selection   |str            |messageSourceSelection    |
|custom_source              |customSource   |customSource *Optional*   |
|external_source            |externalSource |externalSource *Optional* |
</div>


## `MusicOnHoldSourceAdd16`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold source configuration.


**Attributes:**

|Name                       |Type           |Description               |
|---------------------------|---------------|--------------------------|
|audio_file_preferred_codec |str            |audioFilePreferredCodec   |
|message_source_selection   |str            |messageSourceSelection    |
|custom_source              |customSource   |customSource *Optional*   |
|external_source            |externalSource |externalSource *Optional* |
</div>


## `MusicOnHoldSourceAdd19sp1`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold source configuration.

Replaced by: MusicOnHoldSourceAdd20

**Attributes:**

|Name                       |Type           |Description               |
|---------------------------|---------------|--------------------------|
|audio_file_preferred_codec |str            |audioFilePreferredCodec   |
|message_source_selection   |str            |messageSourceSelection    |
|custom_source              |customSource   |customSource *Optional*   |
|external_source            |externalSource |externalSource *Optional* |
</div>


## `MusicOnHoldSourceAdd20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold source configuration.

Replaced by: MusicOnHoldSourceAdd21

**Attributes:**

|Name                       |Type           |Description               |
|---------------------------|---------------|--------------------------|
|audio_file_preferred_codec |str            |audioFilePreferredCodec   |
|message_source_selection   |str            |messageSourceSelection    |
|custom_source              |customSource   |customSource *Optional*   |
|external_source            |externalSource |externalSource *Optional* |
</div>


## `MusicOnHoldSourceAdd21`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold source configuration.

The following elements are only used in HSS data mode and ignored in AS data mode:
labeledMediaFiles The following elements are only used in AS data mode and ignored in
HSS data mode: announcementMediaFiles

**Attributes:**

|Name                                   |Type                               |Description                                   |
|---------------------------------------|-----------------------------------|----------------------------------------------|
|audio_file_preferred_codec             |str                                |audioFilePreferredCodec                       |
|message_source_selection               |str                                |messageSourceSelection                        |
|labeled_custom_source_media_files      |labeledCustomSourceMediaFiles      |labeledCustomSourceMediaFiles *Optional*      |
|announcement_custom_source_media_files |announcementCustomSourceMediaFiles |announcementCustomSourceMediaFiles *Optional* |
|external_source                        |externalSource                     |externalSource *Optional*                     |
</div>


## `MusicOnHoldSourceAdd22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold source configuration.

The following elements are only used in HSS data mode and ignored in AS data mode:
labeledMediaFiles The following elements are only used in AS data mode and ignored in
HSS data mode: announcementMediaFiles authenticationRequired authenticationUserName
authenticationPassword

**Attributes:**

|Name                                   |Type                               |Description                                   |
|---------------------------------------|-----------------------------------|----------------------------------------------|
|audio_file_preferred_codec             |str                                |audioFilePreferredCodec                       |
|message_source_selection               |str                                |messageSourceSelection                        |
|labeled_custom_source_media_files      |labeledCustomSourceMediaFiles      |labeledCustomSourceMediaFiles *Optional*      |
|announcement_custom_source_media_files |announcementCustomSourceMediaFiles |announcementCustomSourceMediaFiles *Optional* |
|external_source                        |externalSource                     |externalSource *Optional*                     |
</div>


## `MusicOnHoldSourceModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold source configuration.


**Attributes:**

|Name                       |Type           |Description                        |
|---------------------------|---------------|-----------------------------------|
|audio_file_preferred_codec |str            |audioFilePreferredCodec *Optional* |
|message_source_selection   |str            |messageSourceSelection *Optional*  |
|custom_source              |customSource   |customSource *Optional*            |
|external_source            |externalSource |externalSource *Optional*          |
</div>


## `MusicOnHoldSourceModify16`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold source configuration.


**Attributes:**

|Name                       |Type           |Description                        |
|---------------------------|---------------|-----------------------------------|
|audio_file_preferred_codec |str            |audioFilePreferredCodec *Optional* |
|message_source_selection   |str            |messageSourceSelection *Optional*  |
|custom_source              |customSource   |customSource *Optional*            |
|external_source            |externalSource |externalSource *Optional*          |
</div>


## `MusicOnHoldSourceModify19sp1`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold source configuration.

Replaced by: MusicOnHoldSourceModify20

**Attributes:**

|Name                       |Type           |Description                        |
|---------------------------|---------------|-----------------------------------|
|audio_file_preferred_codec |str            |audioFilePreferredCodec *Optional* |
|message_source_selection   |str            |messageSourceSelection *Optional*  |
|custom_source              |customSource   |customSource *Optional*            |
|external_source            |externalSource |externalSource *Optional*          |
</div>


## `MusicOnHoldSourceModify20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold source configuration.

Replaced by: MusicOnHoldSourceModify21

**Attributes:**

|Name                       |Type           |Description                        |
|---------------------------|---------------|-----------------------------------|
|audio_file_preferred_codec |str            |audioFilePreferredCodec *Optional* |
|message_source_selection   |str            |messageSourceSelection *Optional*  |
|custom_source              |customSource   |customSource *Optional*            |
|external_source            |externalSource |externalSource *Optional*          |
</div>


## `MusicOnHoldSourceModify21`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold source configuration.

The following elements are only used in HSS data mode and ignored in AS data mode:
labeledMediaFiles The following elements are only used in AS data mode and ignored in
HSS data mode: announcementMediaFiles

**Attributes:**

|Name                                   |Type                               |Description                                   |
|---------------------------------------|-----------------------------------|----------------------------------------------|
|audio_file_preferred_codec             |str                                |audioFilePreferredCodec *Optional*            |
|message_source_selection               |str                                |messageSourceSelection *Optional*             |
|labeled_custom_source_media_files      |labeledCustomSourceMediaFiles      |labeledCustomSourceMediaFiles *Optional*      |
|announcement_custom_source_media_files |announcementCustomSourceMediaFiles |announcementCustomSourceMediaFiles *Optional* |
|external_source                        |externalSource                     |externalSource *Optional*                     |
</div>


## `MusicOnHoldSourceModify22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold source configuration.

The following elements are only used in HSS data mode and ignored in AS data mode:
labeledMediaFiles The following elements are only used in AS data mode and ignored in
HSS data mode: announcementMediaFiles authenticationRequired authenticationUserName
authenticationPassword

**Attributes:**

|Name                                   |Type                               |Description                                   |
|---------------------------------------|-----------------------------------|----------------------------------------------|
|audio_file_preferred_codec             |str                                |audioFilePreferredCodec *Optional*            |
|message_source_selection               |str                                |messageSourceSelection *Optional*             |
|labeled_custom_source_media_files      |labeledCustomSourceMediaFiles      |labeledCustomSourceMediaFiles *Optional*      |
|announcement_custom_source_media_files |announcementCustomSourceMediaFiles |announcementCustomSourceMediaFiles *Optional* |
|external_source                        |externalSource                     |externalSource *Optional*                     |
</div>


## `MusicOnHoldSourceRead`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold source configuration.


**Attributes:**

|Name                       |Type           |Description               |
|---------------------------|---------------|--------------------------|
|audio_file_preferred_codec |str            |audioFilePreferredCodec   |
|message_source_selection   |str            |messageSourceSelection    |
|custom_source              |customSource   |customSource *Optional*   |
|external_source            |externalSource |externalSource *Optional* |
</div>


## `MusicOnHoldSourceRead16`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold source configuration.

Replaced by: MusicOnHoldSourceRead19.

**Attributes:**

|Name                       |Type           |Description               |
|---------------------------|---------------|--------------------------|
|audio_file_preferred_codec |str            |audioFilePreferredCodec   |
|message_source_selection   |str            |messageSourceSelection    |
|custom_source              |customSource   |customSource *Optional*   |
|external_source            |externalSource |externalSource *Optional* |
</div>


## `MusicOnHoldSourceRead19`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold source configuration.


**Attributes:**

|Name                       |Type           |Description               |
|---------------------------|---------------|--------------------------|
|audio_file_preferred_codec |str            |audioFilePreferredCodec   |
|message_source_selection   |str            |messageSourceSelection    |
|custom_source              |customSource   |customSource *Optional*   |
|external_source            |externalSource |externalSource *Optional* |
</div>


## `MusicOnHoldSourceRead19sp1`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold source configuration.


**Attributes:**

|Name                       |Type           |Description               |
|---------------------------|---------------|--------------------------|
|audio_file_preferred_codec |str            |audioFilePreferredCodec   |
|message_source_selection   |str            |messageSourceSelection    |
|custom_source              |customSource   |customSource *Optional*   |
|external_source            |externalSource |externalSource *Optional* |
</div>


## `MusicOnHoldSourceRead20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold source configuration.

Replaced by: MusicOnHoldSourceRead21

**Attributes:**

|Name                       |Type           |Description               |
|---------------------------|---------------|--------------------------|
|audio_file_preferred_codec |str            |audioFilePreferredCodec   |
|message_source_selection   |str            |messageSourceSelection    |
|custom_source              |customSource   |customSource *Optional*   |
|external_source            |externalSource |externalSource *Optional* |
</div>


## `MusicOnHoldSourceRead21`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold source configuration.

The following elements are only used in XS data mode and not returned in AS data mode:
labeledCustomSourceMediaFiles The following elements are only used in AS data mode and
not returned in XS data mode: announcementMediaFiles

**Attributes:**

|Name                                   |Type                               |Description                                   |
|---------------------------------------|-----------------------------------|----------------------------------------------|
|audio_file_preferred_codec             |str                                |audioFilePreferredCodec                       |
|message_source_selection               |str                                |messageSourceSelection                        |
|labeled_custom_source_media_files      |labeledCustomSourceMediaFiles      |labeledCustomSourceMediaFiles *Optional*      |
|announcement_custom_source_media_files |announcementCustomSourceMediaFiles |announcementCustomSourceMediaFiles *Optional* |
|external_source                        |externalSource                     |externalSource *Optional*                     |
</div>


## `MusicOnHoldSourceRead22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold source configuration.

The following elements are only used in XS data mode and not returned in AS data mode:
labeledCustomSourceMediaFiles The following elements are only used in AS data mode and
not returned in XS data mode: announcementMediaFiles

**Attributes:**

|Name                                   |Type                               |Description                                   |
|---------------------------------------|-----------------------------------|----------------------------------------------|
|audio_file_preferred_codec             |str                                |audioFilePreferredCodec                       |
|message_source_selection               |str                                |messageSourceSelection                        |
|labeled_custom_source_media_files      |labeledCustomSourceMediaFiles      |labeledCustomSourceMediaFiles *Optional*      |
|announcement_custom_source_media_files |announcementCustomSourceMediaFiles |announcementCustomSourceMediaFiles *Optional* |
|external_source                        |externalSource                     |externalSource *Optional*                     |
</div>


## `MusicOnHoldSourceRead22V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold source configuration.

The following elements are only used in XS data mode and not returned in AS data mode:
labeledCustomSourceMediaFiles The following elements are only used in AS data mode and
not returned in XS data mode: announcementMediaFiles

**Attributes:**

|Name                                   |Type                               |Description                                   |
|---------------------------------------|-----------------------------------|----------------------------------------------|
|audio_file_preferred_codec             |str                                |audioFilePreferredCodec                       |
|message_source_selection               |str                                |messageSourceSelection                        |
|labeled_custom_source_media_files      |labeledCustomSourceMediaFiles      |labeledCustomSourceMediaFiles *Optional*      |
|announcement_custom_source_media_files |announcementCustomSourceMediaFiles |announcementCustomSourceMediaFiles *Optional* |
|external_source                        |externalSource                     |externalSource *Optional*                     |
</div>


## `MusicOnHoldSourceRead22V3`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold source configuration.

The following elements are only used in XS data mode and not returned in AS data mode:
labeledCustomSourceMediaFiles The following elements are only used in AS data mode and
not returned in XS data mode: announcementMediaFiles authenticationUserName The
following element is only used in AS data mode: authenticationRequired, value "false"
is returned in XS data mode

**Attributes:**

|Name                                   |Type                               |Description                                   |
|---------------------------------------|-----------------------------------|----------------------------------------------|
|audio_file_preferred_codec             |str                                |audioFilePreferredCodec                       |
|message_source_selection               |str                                |messageSourceSelection                        |
|labeled_custom_source_media_files      |labeledCustomSourceMediaFiles      |labeledCustomSourceMediaFiles *Optional*      |
|announcement_custom_source_media_files |announcementCustomSourceMediaFiles |announcementCustomSourceMediaFiles *Optional* |
|external_source                        |externalSource                     |externalSource *Optional*                     |
</div>


## `MusicOnHoldUserSourceModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold user source configuration.


**Attributes:**

|Name                     |Type         |Description                       |
|-------------------------|-------------|----------------------------------|
|message_source_selection |str          |messageSourceSelection *Optional* |
|custom_source            |customSource |customSource *Optional*           |
</div>


## `MusicOnHoldUserSourceModify16`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold user source configuration.


**Attributes:**

|Name                     |Type         |Description                       |
|-------------------------|-------------|----------------------------------|
|message_source_selection |str          |messageSourceSelection *Optional* |
|custom_source            |customSource |customSource *Optional*           |
</div>


## `MusicOnHoldUserSourceModify20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold user source configuration.


**Attributes:**

|Name                     |Type         |Description                       |
|-------------------------|-------------|----------------------------------|
|message_source_selection |str          |messageSourceSelection *Optional* |
|custom_source            |customSource |customSource *Optional*           |
</div>


## `MusicOnHoldUserSourceRead`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold user source configuration.


**Attributes:**

|Name                     |Type         |Description             |
|-------------------------|-------------|------------------------|
|message_source_selection |str          |messageSourceSelection  |
|custom_source            |customSource |customSource *Optional* |
</div>


## `MusicOnHoldUserSourceRead16`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold user source configuration.


**Attributes:**

|Name                     |Type         |Description             |
|-------------------------|-------------|------------------------|
|message_source_selection |str          |messageSourceSelection  |
|custom_source            |customSource |customSource *Optional* |
</div>


## `MusicOnHoldUserSourceRead20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the music on hold user source configuration.


**Attributes:**

|Name                     |Type         |Description             |
|-------------------------|-------------|------------------------|
|message_source_selection |str          |messageSourceSelection  |
|custom_source            |customSource |customSource *Optional* |
</div>


## `NSTreatmentMapEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The NS treatment map entry.


**Attributes:**

|Name         |Type|Description            |
|-------------|----|-----------------------|
|ns_treatment |str |nsTreatment            |
|treatment_id |str |treatmentId *Optional* |
</div>


## `NameDialingName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Name dialing last and first names.


**Attributes:**

|Name                    |Type|Description          |
|------------------------|----|---------------------|
|name_dialing_last_name  |str |nameDialingLastName  |
|name_dialing_first_name |str |nameDialingFirstName |
</div>


## `NetworkClassOfServiceCommunicationBarringProfile`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Communication Barring Profile defined as part of the Network Class Of Service.

There can be only one primary profile within a Network Class Of Service.

**Attributes:**

|Name       |Type |Description|
|-----------|-----|-----------|
|name       |str  |name       |
|is_primary |bool |isPrimary  |
</div>


## `OcpCallTypeEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The outgoing call plan call type entry.


**Attributes:**

|Name         |Type|Description |
|-------------|----|------------|
|country_code |str |countryCode |
|digit_map    |str |digitMap    |
|call_type    |str |callType    |
</div>


## `OutgoingCallingPlanAuthorizationCodeEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Calling Plan Authorization Code.


**Attributes:**

|Name        |Type|Description            |
|------------|----|-----------------------|
|code        |str |code                   |
|description |str |description *Optional* |
</div>


## `OutgoingCallingPlanCallMeNowPermissions`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Calling Plan for Call Me Now call permissions.


**Attributes:**

|Name                          |Type |Description                 |
|------------------------------|-----|----------------------------|
|group                         |bool |group                       |
|local                         |bool |local                       |
|toll_free                     |bool |tollFree                    |
|toll                          |bool |toll                        |
|international                 |bool |international               |
|operator_assisted             |bool |operatorAssisted            |
|chargeable_directory_assisted |bool |chargeableDirectoryAssisted |
|special_services_i            |bool |specialServicesI            |
|special_services_ii           |bool |specialServicesII           |
|premium_services_i            |bool |premiumServicesI            |
|premium_services_ii           |bool |premiumServicesII           |
|casual                        |bool |casual                      |
|url_dialing                   |bool |urlDialing                  |
|unknown                       |bool |unknown                     |
</div>


## `OutgoingCallingPlanCallMeNowPermissionsModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Modify outgoing Calling Plan for Call Me Now call permissions.


**Attributes:**

|Name                          |Type |Description                            |
|------------------------------|-----|---------------------------------------|
|group                         |bool |group *Optional*                       |
|local                         |bool |local *Optional*                       |
|toll_free                     |bool |tollFree *Optional*                    |
|toll                          |bool |toll *Optional*                        |
|international                 |bool |international *Optional*               |
|operator_assisted             |bool |operatorAssisted *Optional*            |
|chargeable_directory_assisted |bool |chargeableDirectoryAssisted *Optional* |
|special_services_i            |bool |specialServicesI *Optional*            |
|special_services_ii           |bool |specialServicesII *Optional*           |
|premium_services_i            |bool |premiumServicesI *Optional*            |
|premium_services_ii           |bool |premiumServicesII *Optional*           |
|casual                        |bool |casual *Optional*                      |
|url_dialing                   |bool |urlDialing *Optional*                  |
|unknown                       |bool |unknown *Optional*                     |
</div>


## `OutgoingCallingPlanDigitPatternCallMeNowPermission`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Indicates whether Call Me Now calls using specified digit patterns are permitted.


**Attributes:**

|Name               |Type |Description      |
|-------------------|-----|-----------------|
|digit_pattern_name |str  |digitPatternName |
|permission         |bool |permission       |
</div>


## `OutgoingCallingPlanDigitPatternOriginatingPermission`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Indicates whether originating calls using specified digit patterns are permitted.


**Attributes:**

|Name               |Type|Description      |
|-------------------|----|-----------------|
|digit_pattern_name |str |digitPatternName |
|permission         |str |permission       |
</div>


## `OutgoingCallingPlanDigitPatternRedirectingPermission`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Indicates whether redirecting calls using specified digit patterns are permitted.


**Attributes:**

|Name               |Type |Description      |
|-------------------|-----|-----------------|
|digit_pattern_name |str  |digitPatternName |
|permission         |bool |permission       |
</div>


## `OutgoingCallingPlanOriginatingPermissions`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Calling Plan originating call permissions.


**Attributes:**

|Name                          |Type|Description                 |
|------------------------------|----|----------------------------|
|group                         |str |group                       |
|local                         |str |local                       |
|toll_free                     |str |tollFree                    |
|toll                          |str |toll                        |
|international                 |str |international               |
|operator_assisted             |str |operatorAssisted            |
|chargeable_directory_assisted |str |chargeableDirectoryAssisted |
|special_services_i            |str |specialServicesI            |
|special_services_ii           |str |specialServicesII           |
|premium_services_i            |str |premiumServicesI            |
|premium_services_ii           |str |premiumServicesII           |
|casual                        |str |casual                      |
|url_dialing                   |str |urlDialing                  |
|unknown                       |str |unknown                     |
</div>


## `OutgoingCallingPlanOriginatingPermissionsModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Calling Plan originating call permissions.


**Attributes:**

|Name                          |Type|Description                            |
|------------------------------|----|---------------------------------------|
|group                         |str |group *Optional*                       |
|local                         |str |local *Optional*                       |
|toll_free                     |str |tollFree *Optional*                    |
|toll                          |str |toll *Optional*                        |
|international                 |str |international *Optional*               |
|operator_assisted             |str |operatorAssisted *Optional*            |
|chargeable_directory_assisted |str |chargeableDirectoryAssisted *Optional* |
|special_services_i            |str |specialServicesI *Optional*            |
|special_services_ii           |str |specialServicesII *Optional*           |
|premium_services_i            |str |premiumServicesI *Optional*            |
|premium_services_ii           |str |premiumServicesII *Optional*           |
|casual                        |str |casual *Optional*                      |
|url_dialing                   |str |urlDialing *Optional*                  |
|unknown                       |str |unknown *Optional*                     |
</div>


## `OutgoingCallingPlanRedirectedPermissions`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Calling Plan being forwarded/transferred permissions.


**Attributes:**

|Name          |Type |Description  |
|--------------|-----|-------------|
|outside_group |bool |outsideGroup |
</div>


## `OutgoingCallingPlanRedirectedPermissionsModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Calling Plan being forwarded/transferred permissions.


**Attributes:**

|Name          |Type |Description             |
|--------------|-----|------------------------|
|outside_group |bool |outsideGroup *Optional* |
</div>


## `OutgoingCallingPlanRedirectingPermissions`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Calling Plan initiating call forwards/transfer permissions.


**Attributes:**

|Name                          |Type |Description                 |
|------------------------------|-----|----------------------------|
|group                         |bool |group                       |
|local                         |bool |local                       |
|toll_free                     |bool |tollFree                    |
|toll                          |bool |toll                        |
|international                 |bool |international               |
|operator_assisted             |bool |operatorAssisted            |
|chargeable_directory_assisted |bool |chargeableDirectoryAssisted |
|special_services_i            |bool |specialServicesI            |
|special_services_ii           |bool |specialServicesII           |
|premium_services_i            |bool |premiumServicesI            |
|premium_services_ii           |bool |premiumServicesII           |
|casual                        |bool |casual                      |
|url_dialing                   |bool |urlDialing                  |
|unknown                       |bool |unknown                     |
</div>


## `OutgoingCallingPlanRedirectingPermissionsModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Calling Plan initiating call forwards/transfer permissions.


**Attributes:**

|Name                          |Type |Description                            |
|------------------------------|-----|---------------------------------------|
|group                         |bool |group *Optional*                       |
|local                         |bool |local *Optional*                       |
|toll_free                     |bool |tollFree *Optional*                    |
|toll                          |bool |toll *Optional*                        |
|international                 |bool |international *Optional*               |
|operator_assisted             |bool |operatorAssisted *Optional*            |
|chargeable_directory_assisted |bool |chargeableDirectoryAssisted *Optional* |
|special_services_i            |bool |specialServicesI *Optional*            |
|special_services_ii           |bool |specialServicesII *Optional*           |
|premium_services_i            |bool |premiumServicesI *Optional*            |
|premium_services_ii           |bool |premiumServicesII *Optional*           |
|casual                        |bool |casual *Optional*                      |
|url_dialing                   |bool |urlDialing *Optional*                  |
|unknown                       |bool |unknown *Optional*                     |
</div>


## `OutgoingCallingPlanTransferNumbers`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Calling Plan transfer numbers.


**Attributes:**

|Name           |Type|Description              |
|---------------|----|-------------------------|
|phone_number01 |str |phoneNumber01 *Optional* |
|phone_number02 |str |phoneNumber02 *Optional* |
|phone_number03 |str |phoneNumber03 *Optional* |
</div>


## `OutgoingCallingPlanTransferNumbersModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Calling Plan transfer numbers.


**Attributes:**

|Name           |Type|Description              |
|---------------|----|-------------------------|
|phone_number01 |str |phoneNumber01 *Optional* |
|phone_number02 |str |phoneNumber02 *Optional* |
|phone_number03 |str |phoneNumber03 *Optional* |
</div>


## `OutgoingPinholeDigitPlanDigitPatternCallMeNowPermission`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Indicates whether Call Me Now calls using specified Pinhole digit patterns are
permitted.


**Attributes:**

|Name               |Type|Description      |
|-------------------|----|-----------------|
|digit_pattern_name |str |digitPatternName |
|permission         |str |permission       |
</div>


## `OutgoingPinholeDigitPlanDigitPatternOriginatingPermission`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Indicates whether originating calls using specified Pinhole digit patterns are
permitted.


**Attributes:**

|Name               |Type|Description      |
|-------------------|----|-----------------|
|digit_pattern_name |str |digitPatternName |
|permission         |str |permission       |
</div>


## `OutgoingPinholeDigitPlanDigitPatternRedirectingPermission`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Indicates whether redirecting calls using specified Pinhole digit patterns are
permitted.


**Attributes:**

|Name               |Type|Description      |
|-------------------|----|-----------------|
|digit_pattern_name |str |digitPatternName |
|permission         |str |permission       |
</div>


## `PasscodeMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal passcode menu keys modify entry.


**Attributes:**

|Name                                   |Type|Description                                   |
|---------------------------------------|----|----------------------------------------------|
|finish_entering_or_reentering_passcode |str |finishEnteringOrReenteringPasscode *Optional* |
|return_to_previous_menu                |str |returnToPreviousMenu *Optional*               |
</div>


## `PasscodeMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal passcode menu keys.


**Attributes:**

|Name                                   |Type|Description                        |
|---------------------------------------|----|-----------------------------------|
|finish_entering_or_reentering_passcode |str |finishEnteringOrReenteringPasscode |
|return_to_previous_menu                |str |returnToPreviousMenu               |
</div>


## `PasswordForAccessDevice`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Passwords to be generated for an access device.

The combination of serviceProviderId, groupId, and deviceName will be used to find the
device if it exists.  If the device doesn't exist yet, then the serviceProviderId and
groupId will be used to choose the password rules with which to generate the device
password.

**Attributes:**

|Name                                    |Type |Description                          |
|----------------------------------------|-----|-------------------------------------|
|service_provider_id                     |str  |serviceProviderId *Optional*         |
|group_id                                |str  |groupId *Optional*                   |
|device_name                             |str  |deviceName *Optional*                |
|generate_device_authentication_password |bool |generateDeviceAuthenticationPassword |
</div>


## `PasswordForGroupAdministrator`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Password to be generated for a group administrator.

If the administratorId is not included, or included but is not an exiting
administrator for the group, a password will be generated based on only the rules
applicable for a new user.

**Attributes:**

|Name                |Type |Description                |
|--------------------|-----|---------------------------|
|service_provider_id |str  |serviceProviderId          |
|group_id            |str  |groupId                    |
|administrator_id    |str  |administratorId *Optional* |
|generate_password   |bool |generatePassword           |
</div>


## `PasswordForServiceProviderAdministrator`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Password to be generated for a service provider administrator.

If the administratorId is not included, or included but is not an exiting
administrator for the service provider, a password will be generated based on only the
rules applicable for a new user.

**Attributes:**

|Name                |Type |Description                |
|--------------------|-----|---------------------------|
|service_provider_id |str  |serviceProviderId          |
|administrator_id    |str  |administratorId *Optional* |
|generate_password   |bool |generatePassword           |
</div>


## `PasswordForSystemAdministrator`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Password to be generated for a System or Provisioning administrator.

If the administratorId is not included, or included but is not an exiting
administrator for the service provider, a password will be generated based on only the
rules applicable for a new user.

**Attributes:**

|Name              |Type |Description                |
|------------------|-----|---------------------------|
|administrator_id  |str  |administratorId *Optional* |
|generate_password |bool |generatePassword           |
</div>


## `PasswordForTrunkGroup`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Passwords to be generated for a trunk group.

The combination of serviceProviderId, groupId, and name will be used to find the trunk
group if it exists.  If the trunk group doesn't exist yet, then the serviceProviderId
and groupId will be used to choose the password rules with which to generate the trunk
group password.

**Attributes:**

|Name                                         |Type |Description                              |
|---------------------------------------------|-----|-----------------------------------------|
|service_provider_id                          |str  |serviceProviderId                        |
|group_id                                     |str  |groupId                                  |
|name                                         |str  |name *Optional*                          |
|generate_trunk_group_authentication_password |bool |generateTrunkGroupAuthenticationPassword |
</div>


## `PasswordForUser`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Passwords, passcode and SIP authentication passwords to be generated for a user.

If the userId is not included or included but is not an existing user in the group, a
password will be generated based on only the rules applicable for a new user.

**Attributes:**

|Name                  |Type |Description                    |
|----------------------|-----|-------------------------------|
|service_provider_id   |str  |serviceProviderId              |
|group_id              |str  |groupId                        |
|user_id               |str  |userId *Optional*              |
|generate_password     |bool |generatePassword *Optional*    |
|generate_passcode     |bool |generatePasscode *Optional*    |
|generate_sip_password |bool |generateSipPassword *Optional* |
</div>


## `PersonalAssistantMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal personal assistant menu keys modify entry.


**Attributes:**

|Name                             |Type|Description                            |
|---------------------------------|----|---------------------------------------|
|set_presence_to_none             |str |setPresenceToNone *Optional*           |
|set_presence_to_business_trip    |str |setPresenceToBusinessTrip *Optional*   |
|set_presence_to_gone_for_the_day |str |setPresenceToGoneForTheDay *Optional*  |
|set_presence_to_lunch            |str |setPresenceToLunch *Optional*          |
|set_presence_to_meeting          |str |setPresenceToMeeting *Optional*        |
|set_presence_to_out_of_office    |str |setPresenceToOutOfOffice *Optional*    |
|set_presence_to_temporarily_out  |str |setPresenceToTemporarilyOut *Optional* |
|set_presence_to_training         |str |setPresenceToTraining *Optional*       |
|set_presence_to_unavailable      |str |setPresenceToUnavailable *Optional*    |
|set_presence_to_vacation         |str |setPresenceToVacation *Optional*       |
|return_to_previous_menu          |str |returnToPreviousMenu *Optional*        |
|repeat_menu                      |str |repeatMenu *Optional*                  |
</div>


## `PersonalAssistantMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal personal assistant menu keys.


**Attributes:**

|Name                             |Type|Description                            |
|---------------------------------|----|---------------------------------------|
|set_presence_to_none             |str |setPresenceToNone *Optional*           |
|set_presence_to_business_trip    |str |setPresenceToBusinessTrip *Optional*   |
|set_presence_to_gone_for_the_day |str |setPresenceToGoneForTheDay *Optional*  |
|set_presence_to_lunch            |str |setPresenceToLunch *Optional*          |
|set_presence_to_meeting          |str |setPresenceToMeeting *Optional*        |
|set_presence_to_out_of_office    |str |setPresenceToOutOfOffice *Optional*    |
|set_presence_to_temporarily_out  |str |setPresenceToTemporarilyOut *Optional* |
|set_presence_to_training         |str |setPresenceToTraining *Optional*       |
|set_presence_to_unavailable      |str |setPresenceToUnavailable *Optional*    |
|set_presence_to_vacation         |str |setPresenceToVacation *Optional*       |
|return_to_previous_menu          |str |returnToPreviousMenu                   |
|repeat_menu                      |str |repeatMenu *Optional*                  |
</div>


## `PersonalizedNameMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal personalized name menu keys modify entry.


**Attributes:**

|Name                                |Type|Description                                |
|------------------------------------|----|-------------------------------------------|
|record_new_personalized_name        |str |recordNewPersonalizedName *Optional*       |
|listen_to_current_personalized_name |str |listenToCurrentPersonalizedName *Optional* |
|delete_personalized_name            |str |deletePersonalizedName *Optional*          |
|return_to_previous_menu             |str |returnToPreviousMenu *Optional*            |
|repeat_menu                         |str |repeatMenu *Optional*                      |
</div>


## `PersonalizedNameMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal personalized name menu keys.


**Attributes:**

|Name                                |Type|Description                                |
|------------------------------------|----|-------------------------------------------|
|record_new_personalized_name        |str |recordNewPersonalizedName *Optional*       |
|listen_to_current_personalized_name |str |listenToCurrentPersonalizedName *Optional* |
|delete_personalized_name            |str |deletePersonalizedName *Optional*          |
|return_to_previous_menu             |str |returnToPreviousMenu                       |
|repeat_menu                         |str |repeatMenu *Optional*                      |
</div>


## `PhoneListEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Phone list entry.


**Attributes:**

|Name         |Type|Description |
|-------------|----|------------|
|entry_name   |str |entryName   |
|phone_number |str |phoneNumber |
</div>


## `PlayGreetingMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal play greeting menu keys modify entry.


**Attributes:**

|Name            |Type|Description              |
|----------------|----|-------------------------|
|skip_backward   |str |skipBackward *Optional*  |
|pause_or_resume |str |pauseOrResume *Optional* |
|skip_forward    |str |skipForward *Optional*   |
|jump_to_begin   |str |jumpToBegin *Optional*   |
|jump_to_end     |str |jumpToEnd *Optional*     |
</div>


## `PlayGreetingMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal play greeting menu keys.


**Attributes:**

|Name            |Type|Description              |
|----------------|----|-------------------------|
|skip_backward   |str |skipBackward *Optional*  |
|pause_or_resume |str |pauseOrResume *Optional* |
|skip_forward    |str |skipForward *Optional*   |
|jump_to_begin   |str |jumpToBegin *Optional*   |
|jump_to_end     |str |jumpToEnd *Optional*     |
</div>


## `PlayMessageMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal play message menu keys modify entry.


**Attributes:**

|Name            |Type|Description              |
|----------------|----|-------------------------|
|skip_backward   |str |skipBackward *Optional*  |
|pause_or_resume |str |pauseOrResume *Optional* |
|skip_forward    |str |skipForward *Optional*   |
|jump_to_begin   |str |jumpToBegin *Optional*   |
|jump_to_end     |str |jumpToEnd *Optional*     |
</div>


## `PlayMessageMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal play message menu keys.


**Attributes:**

|Name            |Type|Description              |
|----------------|----|-------------------------|
|skip_backward   |str |skipBackward *Optional*  |
|pause_or_resume |str |pauseOrResume *Optional* |
|skip_forward    |str |skipForward *Optional*   |
|jump_to_begin   |str |jumpToBegin *Optional*   |
|jump_to_end     |str |jumpToEnd *Optional*     |
</div>


## `PlayMessagesMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal play message menu keys modify entry.


**Attributes:**

|Name                       |Type|Description                         |
|---------------------------|----|------------------------------------|
|save_message               |str |saveMessage *Optional*              |
|delete_message             |str |deleteMessage *Optional*            |
|play_message               |str |playMessage *Optional*              |
|previous_message           |str |previousMessage *Optional*          |
|play_envelope              |str |playEnvelope *Optional*             |
|next_message               |str |nextMessage *Optional*              |
|callback_caller            |str |callbackCaller *Optional*           |
|compose_message            |str |composeMessage *Optional*           |
|reply_message              |str |replyMessage *Optional*             |
|forward_message            |str |forwardMessage *Optional*           |
|additional_message_options |str |additionalMessageOptions *Optional* |
|personalized_name          |str |personalizedName *Optional*         |
|passcode                   |str |passcode *Optional*                 |
|return_to_previous_menu    |str |returnToPreviousMenu *Optional*     |
|repeat_menu                |str |repeatMenu *Optional*               |
</div>


## `PlayMessagesMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal play message menu keys.


**Attributes:**

|Name                       |Type|Description                         |
|---------------------------|----|------------------------------------|
|save_message               |str |saveMessage *Optional*              |
|delete_message             |str |deleteMessage *Optional*            |
|play_message               |str |playMessage *Optional*              |
|previous_message           |str |previousMessage *Optional*          |
|play_envelope              |str |playEnvelope *Optional*             |
|next_message               |str |nextMessage *Optional*              |
|callback_caller            |str |callbackCaller *Optional*           |
|compose_message            |str |composeMessage *Optional*           |
|reply_message              |str |replyMessage *Optional*             |
|forward_message            |str |forwardMessage *Optional*           |
|additional_message_options |str |additionalMessageOptions *Optional* |
|personalized_name          |str |personalizedName *Optional*         |
|passcode                   |str |passcode *Optional*                 |
|return_to_previous_menu    |str |returnToPreviousMenu                |
|repeat_menu                |str |repeatMenu *Optional*               |
</div>


## `PrimaryUserInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Primary user information.


**Attributes:**

|Name                |Type|Description                  |
|--------------------|----|-----------------------------|
|user_id             |str |userId *Optional*            |
|service_provider_id |str |serviceProviderId *Optional* |
|group_id            |str |groupId *Optional*           |
|user_first_name     |str |userFirstName *Optional*     |
|user_last_name      |str |userLastName *Optional*      |
|user_phone_number   |str |userPhoneNumber *Optional*   |
|user_extension      |str |userExtension *Optional*     |
|end_point_type      |str |endPointType *Optional*      |
</div>


## `PriorityAlertCriteriaFromDn`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The from dn criteria used within an add/get request.


**Attributes:**

|Name                        |Type      |Description               |
|----------------------------|----------|--------------------------|
|from_dn_criteria_selection  |str       |fromDnCriteriaSelection   |
|include_anonymous_callers   |bool      |includeAnonymousCallers   |
|include_unavailable_callers |bool      |includeUnavailableCallers |
|phone_number                |List[str] |phoneNumber *Optional*    |
</div>


## `ProfileAndServiceAnonymousCallRejectionInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
This is the configuration parameters for anonymous Call Rejection service

**Attributes:**

|Name      |Type |Description|
|----------|-----|-----------|
|is_active |bool |isActive   |
</div>


## `ProfileAndServiceAutomaticCallbackInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
This is the configuration parameters for anonymous Call Rejection service

**Attributes:**

|Name      |Type |Description|
|----------|-----|-----------|
|is_active |bool |isActive   |
</div>


## `ProfileAndServiceBusyLampFieldInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
This is the configuration parameters for Busy Lamp Field service The
monitoredUserTable has column headings: "User Id", "Last Name", "First Name",
"Hiragana Last Name", "Hiragana First Name", "Phone Number", "Extension",
"Department", "Email Address", "IMP Id".


**Attributes:**

|Name                          |Type                     |Description                                                           |
|------------------------------|-------------------------|----------------------------------------------------------------------|
|list_uri                      |str                      |listURI *Optional*                                                    |
|enable_call_park_notification |bool                     |enableCallParkNotification                                            |
|monitored_user_table          |List(monitoredUserTable) |monitoredUserTable - *Table* array of monitoredUserTable named tuples |
</div>


## `ProfileAndServiceCallForwardAlwaysInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
This is the configuration parameters for Call Forward Always service

**Attributes:**

|Name                    |Type |Description                     |
|------------------------|-----|--------------------------------|
|is_active               |bool |isActive                        |
|forward_to_phone_number |str  |forwardToPhoneNumber *Optional* |
|is_ring_splash_active   |bool |isRingSplashActive              |
</div>


## `ProfileAndServiceCallForwardingBusyInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
This is the configuration parameters for Call Forwarding Busy service

**Attributes:**

|Name                    |Type |Description                     |
|------------------------|-----|--------------------------------|
|is_active               |bool |isActive                        |
|forward_to_phone_number |str  |forwardToPhoneNumber *Optional* |
</div>


## `ProfileAndServiceCallForwardingNoAnswerInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
This is the configuration parameters for Call Forwarding No Answer service

**Attributes:**

|Name                    |Type |Description                     |
|------------------------|-----|--------------------------------|
|is_active               |bool |isActive                        |
|forward_to_phone_number |str  |forwardToPhoneNumber *Optional* |
|number_of_rings         |int  |numberOfRings                   |
</div>


## `ProfileAndServiceCallForwardingSelectiveInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
This is the configuration parameters for Call Forwarding Selective service The
criteria table's column headings are: "Is Active", "Criteria Name", "Time Schedule",
"Calls From", "Forward To", "Blacklisted", "Holiday Schedule" The "Calls From" column
is a string containing call numbers

**Attributes:**

|Name                            |Type                |Description                                                 |
|--------------------------------|--------------------|------------------------------------------------------------|
|is_active                       |bool                |isActive                                                    |
|default_forward_to_phone_number |str                 |defaultForwardToPhoneNumber *Optional*                      |
|play_ring_reminder              |bool                |playRingReminder                                            |
|criteria_table                  |List(criteriaTable) |criteriaTable - *Table* array of criteriaTable named tuples |
</div>


## `ProfileAndServiceCallNotifyInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
This is the configuration parameters for Call Notify service The criteria table's
column headings are: "Is Active", "Criteria Name", "Time Schedule", "Calls From",
"Blacklisted" ,"Holiday Schedule" The "Calls From" column is a string containing call
numbers

**Attributes:**

|Name                      |Type                |Description                                                 |
|--------------------------|--------------------|------------------------------------------------------------|
|call_notify_email_address |str                 |callNotifyEmailAddress *Optional*                           |
|criteria_table            |List(criteriaTable) |criteriaTable - *Table* array of criteriaTable named tuples |
</div>


## `ProfileAndServiceCallTransferInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
This is the configuration parameters for Call Transfer service

**Attributes:**

|Name                                           |Type |Description                               |
|-----------------------------------------------|-----|------------------------------------------|
|is_recall_active                               |bool |isRecallActive                            |
|recall_number_of_rings                         |int  |recallNumberOfRings                       |
|use_diversion_inhibitor_for_blind_transfer     |bool |useDiversionInhibitorForBlindTransfer     |
|use_diversion_inhibitor_for_consultative_calls |bool |useDiversionInhibitorForConsultativeCalls |
|enable_busy_camp_on                            |bool |enableBusyCampOn                          |
|busy_camp_on_seconds                           |int  |busyCampOnSeconds                         |
</div>


## `ProfileAndServiceCallWaitingInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
This is the configuration parameters for Call Transfer service

**Attributes:**

|Name                             |Type |Description                  |
|---------------------------------|-----|-----------------------------|
|is_active                        |bool |isActive                     |
|disable_calling_line_id_delivery |bool |disableCallingLineIdDelivery |
</div>


## `ProfileAndServiceCallingLineIDDeliveryBlockingInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
This is the configuration parameters for Calling Line ID Delivery Blocking service

**Attributes:**

|Name      |Type |Description|
|----------|-----|-----------|
|is_active |bool |isActive   |
</div>


## `ProfileAndServiceCommunicationBarringUserControlInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
This is the configuration parameters for Communication Barring User Control service
profileTable has column headings: "Name", "Code", "Activated" and "Primary".


**Attributes:**

|Name           |Type               |Description                                               |
|---------------|-------------------|----------------------------------------------------------|
|lockout_status |bool               |lockoutStatus                                             |
|profile_table  |List(profileTable) |profileTable - *Table* array of profileTable named tuples |
</div>


## `ProfileAndServiceCustomRingbackInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
This is the configuration parameters for Custom Ringback service The criteria table's
column headings are: "Is Active", "Criteria Name", "Time Schedule", "Calls From",
"Blacklisted", "Holiday Schedule".

The "Calls From" column is a string containing call numbers

**Attributes:**

|Name           |Type                |Description                                                 |
|---------------|--------------------|------------------------------------------------------------|
|criteria_table |List(criteriaTable) |criteriaTable - *Table* array of criteriaTable named tuples |
</div>


## `ProfileAndServiceDirectedCallPickupWithBargeInInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
This is the configuration parameters for Directed Call Pickup With Barge In service

**Attributes:**

|Name                              |Type |Description                    |
|----------------------------------|-----|-------------------------------|
|enable_barge_in_warning_tone      |bool |enableBargeInWarningTone       |
|enable_automatic_target_selection |bool |enableAutomaticTargetSelection |
</div>


## `ProfileAndServiceDoNotDisturbInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
This is the configuration parameters for Do Not Disturb service

**Attributes:**

|Name        |Type |Description|
|------------|-----|-----------|
|is_active   |bool |isActive   |
|ring_splash |bool |ringSplash |
</div>


## `ProfileAndServiceExternalLineIDDeliveryInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
This is the configuration parameters for External Line ID Delivery service

**Attributes:**

|Name      |Type |Description|
|----------|-----|-----------|
|is_active |bool |isActive   |
</div>


## `ProfileAndServiceInternalCallingLineIDDeliveryInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
This is the configuration parameters for Internal Calling Line ID Delivery service

**Attributes:**

|Name      |Type |Description|
|----------|-----|-----------|
|is_active |bool |isActive   |
</div>


## `ProfileAndServicePreAlertingAnnouncementInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
This is the configuration parameters for Pre Alerting Announcement service The
criteria table's column headings are: "Is Active", "Criteria Name", "Blacklisted", and
"Calls From".

The "Calls From" column is a string containing call numbers

**Attributes:**

|Name                   |Type                |Description                                                 |
|-----------------------|--------------------|------------------------------------------------------------|
|is_active              |bool                |isActive                                                    |
|audio_selection        |str                 |audioSelection                                              |
|audio_file_description |str                 |audioFileDescription *Optional*                             |
|audio_media_type       |str                 |audioMediaType *Optional*                                   |
|audio_file_url         |str                 |audioFileUrl *Optional*                                     |
|video_selection        |str                 |videoSelection                                              |
|video_file_description |str                 |videoFileDescription *Optional*                             |
|video_media_type       |str                 |videoMediaType *Optional*                                   |
|video_file_url         |str                 |videoFileUrl *Optional*                                     |
|criteria_table         |List(criteriaTable) |criteriaTable - *Table* array of criteriaTable named tuples |
</div>


## `ProfileAndServiceSelectiveCallRejectionInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
This is the configuration parameters for Selective Call Rejection service The criteria
table's column headings are: "Is Active", "Criteria Name", "Time Schedule", "Calls
From", "Blacklisted", "Holiday Schedule" The "Calls From" column is a string
containing call numbers

**Attributes:**

|Name           |Type                |Description                                                 |
|---------------|--------------------|------------------------------------------------------------|
|criteria_table |List(criteriaTable) |criteriaTable - *Table* array of criteriaTable named tuples |
</div>


## `ProfileAndServiceSharedCallAppearanceInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
This is the configuration parameters for shared call appearance service The
endpointTable contains columns: "Device Level", "Device Name", "Device Type",
"Line/Port", "SIP Contact", "Port Number".

"Private Identity" . The "Device Level" column contains one of the AccessDeviceLevel
enumerated constants.  Port numbers are only used by devices with static line
ordering.

**Attributes:**

|Name                                          |Type                |Description                                                 |
|----------------------------------------------|--------------------|------------------------------------------------------------|
|alert_all_appearances_for_click_to_dial_calls |bool                |alertAllAppearancesForClickToDialCalls                      |
|alert_all_appearances_for_group_paging_calls  |bool                |alertAllAppearancesForGroupPagingCalls                      |
|max_appearances                               |int                 |maxAppearances                                              |
|allow_sca_call_retrieve                       |bool                |allowSCACallRetrieve                                        |
|enable_multiple_call_arrangement              |bool                |enableMultipleCallArrangement                               |
|multiple_call_arrangement_is_active           |bool                |multipleCallArrangementIsActive                             |
|endpoint_table                                |List(endpointTable) |endpointTable - *Table* array of endpointTable named tuples |
|allow_bridging_between_locations              |bool                |allowBridgingBetweenLocations                               |
|bridge_warning_tone                           |str                 |bridgeWarningTone                                           |
|enable_call_park_notification                 |bool                |enableCallParkNotification                                  |
|use_user_primary_with_alternate_calls_setting |bool                |useUserPrimaryWithAlternateCallsSetting                     |
|allow_simultaneous_primary_and_alternate      |bool                |allowSimultaneousPrimaryAndAlternate                        |
|restrict_call_retrieve_of_primary             |bool                |restrictCallRetrieveOfPrimary                               |
|restrict_call_bridging_of_primary             |bool                |restrictCallBridgingOfPrimary                               |
</div>


## `ProfileAndServiceThirdPartyVoiceMailInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
This is the configuration parameters for Third Party Voice Mail service

**Attributes:**

|Name                                       |Type |Description                         |
|-------------------------------------------|-----|------------------------------------|
|is_active                                  |bool |isActive                            |
|busy_redirect_to_voice_mail                |bool |busyRedirectToVoiceMail             |
|no_answer_redirect_to_voice_mail           |bool |noAnswerRedirectToVoiceMail         |
|server_selection                           |str  |serverSelection                     |
|user_server                                |str  |userServer *Optional*               |
|mailbox_id_type                            |str  |mailboxIdType                       |
|mailbox_url                                |str  |mailboxURL *Optional*               |
|no_answer_number_of_rings                  |int  |noAnswerNumberOfRings               |
|always_redirect_to_voice_mail              |bool |alwaysRedirectToVoiceMail           |
|out_of_primary_zone_redirect_to_voice_mail |bool |outOfPrimaryZoneRedirectToVoiceMail |
</div>


## `PublicUserIdentity`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Public User Identity

**Attributes:**

|Name    |Type|Description       |
|--------|----|------------------|
|sip_uri |str |sipURI *Optional* |
|tel_uri |str |telURI *Optional* |
</div>


## `PushNotificationEventData`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The common push notification event elements.


**Attributes:**

|Name                               |Type |Description                                |
|-----------------------------------|-----|-------------------------------------------|
|event_name                         |str  |eventName                                  |
|silent                             |bool |silent                                     |
|mutable_content                    |bool |mutableContent                             |
|push_notification_event_parameters |str  |pushNotificationEventParameters *Optional* |
</div>


## `Q850CauseMapEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The Q850 cause map entry.


**Attributes:**

|Name             |Type|Description            |
|-----------------|----|-----------------------|
|q850_cause_value |int |q850CauseValue         |
|treatment_id     |str |treatmentId *Optional* |
</div>


## `RandomPort`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Represents either a random port number, or a specific port number.


**Attributes:**

|Name   |Type|Description       |
|-------|----|------------------|
|random |str |random *Optional* |
|port   |int |port *Optional*   |
</div>


## `RecordNewGreetingOrPersonalizedNameMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal record new greeting or personalized name menu keys modify entry.


**Attributes:**

|Name          |Type|Description             |
|--------------|----|------------------------|
|end_recording |str |endRecording *Optional* |
</div>


## `RecordNewGreetingOrPersonalizedNameMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal record new greeting or personalized name menu keys.


**Attributes:**

|Name          |Type|Description  |
|--------------|----|-------------|
|end_recording |str |endRecording |
</div>


## `Recurrence`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Defines recurrence.


**Attributes:**

|Name                  |Type               |Description                   |
|----------------------|-------------------|------------------------------|
|recur_daily           |recurDaily         |recurDaily *Optional*         |
|recur_weekly          |recurWeekly        |recurWeekly *Optional*        |
|recur_monthly_by_day  |recurMonthlyByDay  |recurMonthlyByDay *Optional*  |
|recur_monthly_by_week |recurMonthlyByWeek |recurMonthlyByWeek *Optional* |
|recur_yearly_by_day   |recurYearlyByDay   |recurYearlyByDay *Optional*   |
|recur_yearly_by_week  |recurYearlyByWeek  |recurYearlyByWeek *Optional*  |
|recur_for_ever        |bool               |recurForEver *Optional*       |
|recur_end_date        |str                |recurEndDate *Optional*       |
|recur_end_occurrence  |int                |recurEndOccurrence *Optional* |
</div>


## `ReplacementCallProcessingPolicyProfileSubscriberTypeList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of CallProcessingPolicyProfileSubscriberType.

The list replaces a previously configured list.

**Attributes:**

|Name            |Type      |Description    |
|----------------|----------|---------------|
|subscriber_type |List[str] |subscriberType |
</div>


## `ReplacementCallProcessingPolicyProfileSubscriberTypeList20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of CallProcessingPolicyProfileSubscriberType20.

The list replaces a previously configured list.

**Attributes:**

|Name            |Type      |Description    |
|----------------|----------|---------------|
|subscriber_type |List[str] |subscriberType |
</div>


## `ReplacementCallProcessingPolicyProfileSubscriberTypeList21`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of CallProcessingPolicyProfileSubscriberType21.

The list replaces a previously configured list.

**Attributes:**

|Name            |Type      |Description    |
|----------------|----------|---------------|
|subscriber_type |List[str] |subscriberType |
</div>


## `ReplacementCombinedNetworkClassOfServiceList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of network class of services that replaces a previously network class of
services.


**Attributes:**

|Name                     |Type      |Description           |
|-------------------------|----------|----------------------|
|network_class_of_service |List[str] |networkClassOfService |
</div>


## `ReplacementCommunicationBarringAlternateCallIndicatorList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of Communication Barring Alternate Call Indicator that replaces a previously
configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name                     |Type      |Description            |
|-------------------------|----------|-----------------------|
|alternate_call_indicator |List[str] |alternateCallIndicator |
</div>


## `ReplacementCommunicationBarringCallTypeList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of Communication Barring Call Types that replaces a previously configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name      |Type      |Description|
|----------|----------|-----------|
|call_type |List[str] |callType   |
</div>


## `ReplacementContactList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of SIP contacts that replaces a previously configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name    |Type      |Description|
|--------|----------|-----------|
|contact |List[str] |contact    |
</div>


## `ReplacementDNList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of dns that replaces a previously configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name         |Type      |Description |
|-------------|----------|------------|
|phone_number |List[str] |phoneNumber |
</div>


## `ReplacementDeviceTypeList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of device types that replaces the previously assigned list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name        |Type      |Description|
|------------|----------|-----------|
|device_type |List[str] |deviceType |
</div>


## `ReplacementEnterpriseTrunkTrunkGroupList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of Group Trunk Krunk Group Names that replaces a previously configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name        |Type      |Description|
|------------|----------|-----------|
|trunk_group |List[str] |trunkGroup |
</div>


## `ReplacementGroupEnterpriseTrunkTrunkGroupList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of Group Trunk Krunk Group Names that replaces a previously configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name        |Type      |Description|
|------------|----------|-----------|
|trunk_group |List[str] |trunkGroup |
</div>


## `ReplacementMediaNameList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of media that replaces a previously configured list.


**Attributes:**

|Name       |Type      |Description|
|-----------|----------|-----------|
|media_name |List[str] |mediaName  |
</div>


## `ReplacementNumberPortabilityStatusList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of Number Portability Query Statuses that replaces a previously configured
list.

By convention, an element of this type may be set to nill to clear the list.

**Attributes:**

|Name   |Type      |Description|
|-------|----------|-----------|
|status |List[str] |status     |
</div>


## `ReplacementOCICallControlApplicationIdList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of applicationIds that replaces a previously configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name           |Type      |Description   |
|---------------|----------|--------------|
|application_id |List[str] |applicationId |
</div>


## `ReplacementOutgoingDNList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of outgoing dns that replaces a previously configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name         |Type      |Description |
|-------------|----------|------------|
|phone_number |List[str] |phoneNumber |
</div>


## `ReplacementOutgoingDNorSIPURIList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of phone numbers or sipuris that replaces a previously configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name         |Type      |Description |
|-------------|----------|------------|
|phone_number |List[str] |phoneNumber |
</div>


## `ReplacementSIPAliasList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of SIP aliases that replaces a previously configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name      |Type      |Description|
|----------|----------|-----------|
|sip_alias |List[str] |sipAlias   |
</div>


## `ReplacementServicePackNameList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of service packs that replaces a previously configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name              |Type      |Description     |
|------------------|----------|----------------|
|service_pack_name |List[str] |servicePackName |
</div>


## `ReplacementTagSetList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of tag sets that replaces the previously assigned list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name    |Type      |Description|
|--------|----------|-----------|
|tag_set |List[str] |tagSet     |
</div>


## `ReplacementUserIdList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of userIds that replaces a previously configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name    |Type      |Description|
|--------|----------|-----------|
|user_id |List[str] |userId     |
</div>


## `ReplacementUserServiceList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of user services that replaces a previously configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name         |Type      |Description |
|-------------|----------|------------|
|service_name |List[str] |serviceName |
</div>


## `ReplacementVirtualOnNetCallTypeNameList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of Virtual On-Net Call Types that replaces a previously configured list.

By convention, an element of this type may be set to nill to clear the list.

**Attributes:**

|Name                          |Type      |Description              |
|------------------------------|----------|-------------------------|
|virtual_on_net_call_type_name |List[str] |virtualOnNetCallTypeName |
</div>


## `ReplacementZoneList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains an ordered list of zones to use to replace the current list of zones in an
Office Zone.


**Attributes:**

|Name      |Type      |Description|
|----------|----------|-----------|
|zone_name |List[str] |zoneName   |
</div>


## `ReplyMessageMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal reply message menu keys modify entry.


**Attributes:**

|Name                                |Type|Description                                |
|------------------------------------|----|-------------------------------------------|
|send_reply_to_caller                |str |sendReplyToCaller *Optional*               |
|change_current_reply                |str |changeCurrentReply *Optional*              |
|listen_to_current_reply             |str |listenToCurrentReply *Optional*            |
|set_or_clear_urgent_indicator       |str |setOrClearUrgentIndicator *Optional*       |
|set_or_clear_confidential_indicator |str |setOrClearConfidentialIndicator *Optional* |
|return_to_previous_menu             |str |returnToPreviousMenu *Optional*            |
|repeat_menu                         |str |repeatMenu *Optional*                      |
</div>


## `ReplyMessageMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal reply message menu keys.


**Attributes:**

|Name                                |Type|Description                                |
|------------------------------------|----|-------------------------------------------|
|send_reply_to_caller                |str |sendReplyToCaller                          |
|change_current_reply                |str |changeCurrentReply *Optional*              |
|listen_to_current_reply             |str |listenToCurrentReply *Optional*            |
|set_or_clear_urgent_indicator       |str |setOrClearUrgentIndicator *Optional*       |
|set_or_clear_confidential_indicator |str |setOrClearConfidentialIndicator *Optional* |
|return_to_previous_menu             |str |returnToPreviousMenu                       |
|repeat_menu                         |str |repeatMenu *Optional*                      |
</div>


## `ResponsePagingControl`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Used in queries to restrict the set of result rows when making a request that can
result in a large dataset.

The client specifies the starting row and the number of rows requested.  The server
only provides those rows in results, if available.

**Attributes:**

|Name                 |Type|Description        |
|---------------------|----|-------------------|
|response_start_index |int |responseStartIndex |
|response_page_size   |int |responsePageSize   |
</div>


## `ReviewSelectedDistributionListMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal review selected distribution list menu keys modify entry.


**Attributes:**

|Name                                           |Type|Description                                         |
|-----------------------------------------------|----|----------------------------------------------------|
|interrupt_playback_and_return_to_previous_menu |str |interruptPlaybackAndReturnToPreviousMenu *Optional* |
</div>


## `ReviewSelectedDistributionListMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal review selected distribution list menu keys.


**Attributes:**

|Name                                           |Type|Description                              |
|-----------------------------------------------|----|-----------------------------------------|
|interrupt_playback_and_return_to_previous_menu |str |interruptPlaybackAndReturnToPreviousMenu |
</div>


## `SIPAuthenticationUserNamePassword`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
User's authentication service information.


**Attributes:**

|Name                         |Type|Description               |
|-----------------------------|----|--------------------------|
|sip_authentication_user_name |str |sipAuthenticationUserName |
|sip_authentication_password  |str |sipAuthenticationPassword |
</div>


## `SIPContactInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A SIP Contact info contains the SIP registration Contact and its associated Header
path The following element is only used in AS data mode and ignored in XS data mode:
pathHeader

**Attributes:**

|Name        |Type|Description           |
|------------|----|----------------------|
|sip_contact |str |sipContact            |
|path_header |str |pathHeader *Optional* |
</div>


## `SIPStatusMapEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The access SIP status map entry.


**Attributes:**

|Name            |Type|Description            |
|----------------|----|-----------------------|
|sip_status_code |int |sipStatusCode          |
|treatment_id    |str |treatmentId *Optional* |
</div>


## `ScheduleKey`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Uniquely identifies Holiday and Time Schedules within a level(System, Service
Provider, Group or User level).


**Attributes:**

|Name          |Type|Description  |
|--------------|----|-------------|
|schedule_name |str |scheduleName |
|schedule_type |str |scheduleType |
</div>


## `SearchCriteria`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Abstract base type for specifying search criteria.

A search criteria is an optional element used to restrict the number of rows returned
when requesting a potentially large set of data from the provisioning server.

</div>


## `SearchCriteriaAccessDeviceEndpointPrivateIdentity`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a private identity.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaAccessDeviceVersion`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for an Access Device Version.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaAdminFirstName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for an administrator's first name.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaAdminId`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for an administrator's adminId.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaAdminLastName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for an administrator's last name.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaAgentThresholdProfile`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching a Call Center Agent Threshold Profile.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaAlternateTrunkIdentity`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular fully specified alternate trunk identity.

In IMS mode, it only applies to the user part of alternate trunk identity.

**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaAlternateTrunkIdentityDomain`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for alternate trunk identity domain part.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaAlternateUserId`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a user's alternate userId.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaAnnouncementFileName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for an Announcement File Name.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaCallCenterName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a call center

**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaCallCenterReportTemplateName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular call center enhanced reporting report
template.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaCallCenterScheduledReportName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a call center enhanced reporting scheduled report name.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaCallParkName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a call park by name

**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaCallPickupName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a call pickup by name

**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaCommunicationBarringAuthorizationCode`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a Communication Barring Authorization Code.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaCommunicationBarringAuthorizationCodeDescription`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a Communication Barring Authorization Code description.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaComposedOr`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Abstract base type for specifying search criteria where the search criteria params are
OR'ed.

A search criteria is an optional element used to restrict the number of rows returned
when requesting a potentially large set of data from the provisioning server.

</div>


## `SearchCriteriaComposedOrUserName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a user's full name.

This search criterion will be compared against multiple combinations of first name and
last name: First Name + ‘ ‘ + Last Name Last Name + ‘ ‘ + First Name Hiragana Last
Name + ' ' + Hiragana First Name Note: For this search criterion, the searchMode is
always ‘Contains’ and the search criteria are always OR’ed.

**Attributes:**

|Name                |Type      |Description       |
|--------------------|----------|------------------|
|value               |List[str] |value             |
|is_case_insensitive |bool      |isCaseInsensitive |
</div>


## `SearchCriteriaDepartmentName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a user's department.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaDeviceMACAddress`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for device MAC address.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaDeviceManagementEventAdditionalInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular additional info of a DeviceManagement event.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaDeviceManagementEventLoginId`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular login id.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaDeviceName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for device name.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaDeviceNetAddress`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for device network address.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaDeviceSerialNumber`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for device serial number.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaDeviceType`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for device type.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaDigitPattern`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for digit pattern.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaDn`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a DN.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaDomainName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for Domain Names.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaEmailAddress`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a email address.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaEnterpriseCommonMultiPartPhoneListName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a multi-part name in an enterprise common phone list.

Note: For this search criterion, the searchMode is always ‘Contains’ and the multi-
part search criteria are always AND’ed.

**Attributes:**

|Name                |Type      |Description       |
|--------------------|----------|------------------|
|value               |List[str] |value             |
|is_case_insensitive |bool      |isCaseInsensitive |
</div>


## `SearchCriteriaEnterpriseCommonPhoneListName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a name in an enterprise common phone list.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaEnterpriseCommonPhoneListNumber`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a phone number in an enterprise common phone list.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaEnterpriseTrunkName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for an Enterprise Trunk name.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaExactAnnouncementFileType`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular announcement file type.


**Attributes:**

|Name |Type|Description|
|-----|----|-----------|
|type |str |type       |
</div>


## `SearchCriteriaExactAutoAttendantType`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular auto-attendant type.


**Attributes:**

|Name |Type|Description|
|-----|----|-----------|
|type |str |type       |
</div>


## `SearchCriteriaExactCallCenterScheduledReportCreatedBySupervisor`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for call center scheduled report created by a supervisor or
administrator.


**Attributes:**

|Name                  |Type |Description         |
|----------------------|-----|--------------------|
|created_by_supervisor |bool |createdBySupervisor |
</div>


## `SearchCriteriaExactCallCenterScheduledReportGroup`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular fully specified call center scheduled report's
group.


**Attributes:**

|Name                |Type|Description       |
|--------------------|----|------------------|
|service_provider_id |str |serviceProviderId |
|group_id            |str |groupId           |
</div>


## `SearchCriteriaExactCallCenterScheduledReportServiceProvider`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular call center scheduled report's service
provider.


**Attributes:**

|Name                |Type|Description       |
|--------------------|----|------------------|
|service_provider_id |str |serviceProviderId |
</div>


## `SearchCriteriaExactCallCenterType`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular fully specified call center type.


**Attributes:**

|Name             |Type|Description    |
|-----------------|----|---------------|
|call_center_type |str |callCenterType |
</div>


## `SearchCriteriaExactCustomContactDirectory`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular fully specified custom contact directory.


**Attributes:**

|Name                          |Type|Description                |
|------------------------------|----|---------------------------|
|custom_contact_directory_name |str |customContactDirectoryName |
</div>


## `SearchCriteriaExactDeviceLevel`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular device level.


**Attributes:**

|Name         |Type|Description |
|-------------|----|------------|
|device_level |str |deviceLevel |
</div>


## `SearchCriteriaExactDeviceManagementEventAction`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular fully specified DeviceManagement event action.


**Attributes:**

|Name            |Type|Description   |
|----------------|----|--------------|
|dm_event_action |str |dmEventAction |
</div>


## `SearchCriteriaExactDeviceManagementEventLevel`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular fully specified DeviceManagement event level.


**Attributes:**

|Name           |Type|Description  |
|---------------|----|-------------|
|dm_event_level |str |dmEventLevel |
</div>


## `SearchCriteriaExactDeviceManagementEventStatusCompleted`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular fully specified Device Management completed
event status.


**Attributes:**

|Name                      |Type|Description            |
|--------------------------|----|-----------------------|
|dm_event_status_completed |str |dmEventStatusCompleted |
</div>


## `SearchCriteriaExactDeviceManagementEventStatusInProgressOrPending`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular fully specified Device Management event in
progress or pending status.


**Attributes:**

|Name                                   |Type|Description                      |
|---------------------------------------|----|---------------------------------|
|dm_event_status_in_progress_or_pending |str |dmEventStatusInProgressOrPending |
</div>


## `SearchCriteriaExactDeviceManagementEventType`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular fully specified DeviceManagement event type.


**Attributes:**

|Name          |Type|Description |
|--------------|----|------------|
|dm_event_type |str |dmEventType |
</div>


## `SearchCriteriaExactDeviceServiceProvider`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular fully specified service provider associated
with a device.


**Attributes:**

|Name                |Type|Description       |
|--------------------|----|------------------|
|service_provider_id |str |serviceProviderId |
</div>


## `SearchCriteriaExactDeviceType`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular fully specified device type.


**Attributes:**

|Name        |Type|Description|
|------------|----|-----------|
|device_type |str |deviceType |
</div>


## `SearchCriteriaExactDeviceTypeConfigurationOptionType`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular fully specified
DeviceTypeConfigurationOptionType.


**Attributes:**

|Name                  |Type|Description         |
|----------------------|----|--------------------|
|device_config_options |str |deviceConfigOptions |
</div>


## `SearchCriteriaExactDnActivation`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular Dn activation state.


**Attributes:**

|Name      |Type |Description|
|----------|-----|-----------|
|activated |bool |activated  |
</div>


## `SearchCriteriaExactDnAvailability`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular dn availability.


**Attributes:**

|Name      |Type |Description|
|----------|-----|-----------|
|available |bool |available  |
</div>


## `SearchCriteriaExactDomainLevel`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular domain level.


**Attributes:**

|Name         |Type|Description |
|-------------|----|------------|
|domain_level |str |domainLevel |
</div>


## `SearchCriteriaExactEndpointType`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular endpoint type.


**Attributes:**

|Name          |Type|Description  |
|--------------|----|-------------|
|endpoint_type |str |endpointType |
</div>


## `SearchCriteriaExactEndpointType21sp1`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular endpoint type.


**Attributes:**

|Name          |Type|Description  |
|--------------|----|-------------|
|endpoint_type |str |endpointType |
</div>


## `SearchCriteriaExactGroupAdminType`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular group administrator type.


**Attributes:**

|Name |Type|Description|
|-----|----|-----------|
|type |str |type       |
</div>


## `SearchCriteriaExactHuntPolicy`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular fully specified hunt policy.


**Attributes:**

|Name        |Type|Description|
|------------|----|-----------|
|hunt_policy |str |huntPolicy |
</div>


## `SearchCriteriaExactLocationEnabled`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular Location enabled state.


**Attributes:**

|Name    |Type |Description|
|--------|-----|-----------|
|enabled |bool |enabled    |
</div>


## `SearchCriteriaExactMediaFileType`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular media file type.


**Attributes:**

|Name |Type|Description|
|-----|----|-----------|
|type |str |type       |
</div>


## `SearchCriteriaExactMobileDnAvailability`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular mobile dn availability.


**Attributes:**

|Name      |Type |Description|
|----------|-----|-----------|
|available |bool |available  |
</div>


## `SearchCriteriaExactMobileNetwork`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular BroadWorks Mobility Mobile Network.


**Attributes:**

|Name                |Type|Description       |
|--------------------|----|------------------|
|mobile_network_name |str |mobileNetworkName |
</div>


## `SearchCriteriaExactOrganizationType`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for an organization type.


**Attributes:**

|Name              |Type|Description      |
|------------------|----|-----------------|
|organization_type |str |organizationType |
</div>


## `SearchCriteriaExactPolicySelection`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular Voice VPN policy selection.


**Attributes:**

|Name             |Type|Description     |
|-----------------|----|----------------|
|policy_selection |str |policySelection |
</div>


## `SearchCriteriaExactPortNumber`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a port number.


**Attributes:**

|Name |Type|Description|
|-----|----|-----------|
|port |int |port       |
</div>


## `SearchCriteriaExactScheduleLevel`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular schedule level.


**Attributes:**

|Name  |Type|Description|
|------|----|-----------|
|level |str |level      |
</div>


## `SearchCriteriaExactScheduleType`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular schedule type.


**Attributes:**

|Name |Type|Description|
|-----|----|-----------|
|type |str |type       |
</div>


## `SearchCriteriaExactServiceProvider`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular fully specified service provider.


**Attributes:**

|Name                |Type|Description       |
|--------------------|----|------------------|
|service_provider_id |str |serviceProviderId |
</div>


## `SearchCriteriaExactServiceProviderAdminType`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular service provider administrator type.


**Attributes:**

|Name |Type|Description|
|-----|----|-----------|
|type |str |type       |
</div>


## `SearchCriteriaExactServiceType`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular fully specified service type.


**Attributes:**

|Name         |Type|Description |
|-------------|----|------------|
|service_type |str |serviceType |
</div>


## `SearchCriteriaExactSignalingAddressType`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular fully specified SignalingAddressType.


**Attributes:**

|Name    |Type|Description|
|--------|----|-----------|
|profile |str |profile    |
</div>


## `SearchCriteriaExactSkillLevel`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a skill Level.


**Attributes:**

|Name        |Type|Description|
|------------|----|-----------|
|skill_level |int |skillLevel |
</div>


## `SearchCriteriaExactUserGroup`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular fully specified user's group.


**Attributes:**

|Name                |Type|Description       |
|--------------------|----|------------------|
|service_provider_id |str |serviceProviderId |
|group_id            |str |groupId           |
</div>


## `SearchCriteriaExactUserInTrunkGroup`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for user in/not in a trunk group.


**Attributes:**

|Name                |Type |Description      |
|--------------------|-----|-----------------|
|user_in_trunk_group |bool |userInTrunkGroup |
</div>


## `SearchCriteriaExactUserNetworkClassOfService`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for users with a specified network class of service.


**Attributes:**

|Name                     |Type|Description           |
|-------------------------|----|----------------------|
|network_class_of_service |str |networkClassOfService |
</div>


## `SearchCriteriaExactUserRouteListAssigned`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for users with/without Route List feature assigned.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|route_list_assigned |bool |routeListAssigned |
</div>


## `SearchCriteriaExactUserRouteListAssignment`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for users with Route List feature assignment.


**Attributes:**

|Name     |Type |Description|
|---------|-----|-----------|
|assigned |bool |assigned   |
</div>


## `SearchCriteriaExactUserType`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular User Type.


**Attributes:**

|Name      |Type|Description|
|----------|----|-----------|
|user_type |str |userType   |
</div>


## `SearchCriteriaExactVirtualOnNetCallTypeName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular fully specified Virtual On-Net Call Type Name.


**Attributes:**

|Name                          |Type|Description              |
|------------------------------|----|-------------------------|
|virtual_on_net_call_type_name |str |virtualOnNetCallTypeName |
</div>


## `SearchCriteriaExtension`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for an extension.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaForwardedToNumber`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a forwarded to number.

This search criteria data type is only intended to be used by the commands introduced
by BW-2301. The commands are `EnterpriseUserCallForwardingSettingsGetListRequest()`
and `GroupUserCallForwardingSettingsGetListRequest()`. The following Call Forwarding
services are compatible for this search: Call Forwarding Always, Call Forwarding
Always Secondary, Call Forwarding Busy, Call Forwarding No Answer, Call Forwarding Not
Reachable, Call Forwarding Selective.

**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaGroupCommonMultiPartPhoneListName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a multi-value name in a group common phone list.

Note: For this search criterion, the searchMode is always ‘Contains’ and the multi-
part search criteria are always AND’ed.

**Attributes:**

|Name                |Type      |Description       |
|--------------------|----------|------------------|
|value               |List[str] |value             |
|is_case_insensitive |bool      |isCaseInsensitive |
</div>


## `SearchCriteriaGroupCommonPhoneListName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a name in a group common phone list.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaGroupCommonPhoneListNumber`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a phone number in a group common phone list.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaGroupExternalId`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching by a group's externalId.


**Attributes:**

|Name  |Type|Description|
|------|----|-----------|
|mode  |str |mode       |
|value |str |value      |
</div>


## `SearchCriteriaGroupId`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a group ID.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaGroupLocationCode`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a group location dialing code.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaGroupName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a group name.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaHomeMscAddress`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a system Home Network Msc Address.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaIMRN`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for an IMRN Number.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaImpId`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a user's IMP Id.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaLanguage`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a language.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaLinePortDomain`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for device line/port, or SIPURI domain part.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaLinePortUserPart`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for device line/port, or SIPURI user part.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaLocation`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a Location.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaLoginId`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a Login Id.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaMobilePhoneNumber`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a user's mobile phone number.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaMobileSubscriberDirectoryNumber`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a BroadWorks Mobility Mobile Subscriber Directory Number.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaMultiPartUserName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a user's full name.

This search criterion will be compared against multiple combinations of first name and
last name: First Name + ‘ ‘ + Last Name Last Name + ‘ ‘ + First Name Last Name + ‘, ‘
+ First Name Hiragana Last Name + Hiragana First Name Note that when specific
conditions are met, VON users will be included in the search results.  Note: For this
search criterion, the searchMode is always ‘Contains’ and the multi-part search
criteria are always AND’ed.

**Attributes:**

|Name                |Type      |Description       |
|--------------------|----------|------------------|
|value               |List[str] |value             |
|is_case_insensitive |bool      |isCaseInsensitive |
</div>


## `SearchCriteriaNetworkClassOfServiceName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a Network Class of Service name.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaNumberPortabilityQueryDigitPattern`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for digit pattern.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaNumberPortabilityStatus`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for number portability status.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaOutgoingDNorSIPURI`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a phone number or SIPURI.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaPersonalAssistantExclusionNumber`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for Personal Assistant Exclusion Number.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaPersonalAssistantExclusionNumberDescription`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching Personal Assistant Exclusion Number's Description.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaPhysicalLocation`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a Physical Location.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaProfileServiceCode`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a Service Code.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaProfileServiceCodeDescription`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a Service Code description.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaReceptionistNote`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for Receptionist Notes.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaRegistrationURI`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a RegistrationURI.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaResellerId`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a reseller ID.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaResellerName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a reseller name.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaRoamingMscAddress`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a system Roaming Network Msc Address.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaRoutePointName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a route point

**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaSIPContact`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a SIP Contact.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaScheduleName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a schedule name.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaServiceCode`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a Service Code.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaServiceCodeDescription`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a Service Code description.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaServiceInstanceName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a service instance name.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaServiceProviderId`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a service provider ID.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaServiceProviderName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a service provider name.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaServiceProviderNumberPortabilityQueryDigitPattern`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for digit pattern.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaServiceStatus`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for services that are active or not.

This search criteria data type is only intended to be used by the commands introduced
by BW-2301. The commands are `EnterpriseUserCallWaitingSettingsGetListRequest()` and
`GroupUserCallWaitingSettingsGetListRequest()`.

**Attributes:**

|Name      |Type |Description|
|----------|-----|-----------|
|is_active |bool |isActive   |
</div>


## `SearchCriteriaSystemServiceDn`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a system service DN.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaTitle`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a user's title.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaTrunkGroupName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a trunk group

**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaUserExternalId`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a user's externalId.


**Attributes:**

|Name  |Type|Description|
|------|----|-----------|
|mode  |str |mode       |
|value |str |value      |
</div>


## `SearchCriteriaUserFirstName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a user's first name.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaUserHotlineContact`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a user's hotline contact.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaUserId`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a user's userId.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaUserLastName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a user's last name.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaUserName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a user's full name.

This search criterion will be compared against multiple combinations of first name and
last name: First Name + ' ' + Last Name Last Name + ' ' + First Name Last Name + ', '
+ First Name Hiragana Last Name + ' ' + Hiragana First Name Note that when specific
conditions are met, VON users will be included in the search results.

**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaUserPersonalMultiPartPhoneListName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a name in a user personal phone list.

Note: For this search criterion, the searchMode is always ‘Contains’ and the multi-
part search criteria are always AND’ed.

**Attributes:**

|Name                |Type      |Description       |
|--------------------|----------|------------------|
|value               |List[str] |value             |
|is_case_insensitive |bool      |isCaseInsensitive |
</div>


## `SearchCriteriaUserPersonalPhoneListName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a name in a user personal phone list.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaUserPersonalPhoneListNumber`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a phone number in a user personal phone list.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaUserPlaceType`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching based on a user type – “User” or “Place”.


**Attributes:**

|Name  |Type|Description|
|------|----|-----------|
|value |str |value      |
</div>


## `SearchCriteriaYahooId`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a user's yahoo id.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SearchCriteriaZoneIPAddress`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a system zone's IP Address.


**Attributes:**

|Name                |Type |Description       |
|--------------------|-----|------------------|
|mode                |str  |mode              |
|value               |str  |value             |
|is_case_insensitive |bool |isCaseInsensitive |
</div>


## `SecurityClassificationCustomizationActivation`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The security classification customization activation.


**Attributes:**

|Name          |Type |Description  |
|--------------|-----|-------------|
|name          |str  |name         |
|is_customized |bool |isCustomized |
</div>


## `SelectDistributionListMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal select distribution list menu keys modify entry.


**Attributes:**

|Name                                                    |Type|Description                                                 |
|--------------------------------------------------------|----|------------------------------------------------------------|
|return_to_previous_menu                                 |str |returnToPreviousMenu *Optional*                             |
|repeat_menu_or_finish_entering_distribution_list_number |str |repeatMenuOrFinishEnteringDistributionListNumber *Optional* |
</div>


## `SelectDistributionListMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal select distribution list menu keys.


**Attributes:**

|Name                                                    |Type|Description                                                 |
|--------------------------------------------------------|----|------------------------------------------------------------|
|return_to_previous_menu                                 |str |returnToPreviousMenu                                        |
|repeat_menu_or_finish_entering_distribution_list_number |str |repeatMenuOrFinishEnteringDistributionListNumber *Optional* |
</div>


## `SelectiveCallRejectionCriteriaCallType`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The call type criteria used within an add/get request.


**Attributes:**

|Name                        |Type      |Description               |
|----------------------------|----------|--------------------------|
|from_dn_criteria_selection  |str       |fromDnCriteriaSelection   |
|include_anonymous_callers   |bool      |includeAnonymousCallers   |
|include_unavailable_callers |bool      |includeUnavailableCallers |
|phone_number                |List[str] |phoneNumber *Optional*    |
</div>


## `SendMessageToSelectedDistributionListMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal send message to selected distribution list menu keys modify entry.


**Attributes:**

|Name                                 |Type|Description                                 |
|-------------------------------------|----|--------------------------------------------|
|confirm_sending_to_distribution_list |str |confirmSendingToDistributionList *Optional* |
|cancel_sending_to_distribution_list  |str |cancelSendingToDistributionList *Optional*  |
</div>


## `SendMessageToSelectedDistributionListMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal send message to selected distribution list menu keys.


**Attributes:**

|Name                                 |Type|Description                                 |
|-------------------------------------|----|--------------------------------------------|
|confirm_sending_to_distribution_list |str |confirmSendingToDistributionList *Optional* |
|cancel_sending_to_distribution_list  |str |cancelSendingToDistributionList             |
</div>


## `SendToAllGroupMembersMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal send to all group memeber menu keys modify entry.


**Attributes:**

|Name                            |Type|Description                            |
|--------------------------------|----|---------------------------------------|
|confirm_sending_to_entire_group |str |confirmSendingToEntireGroup *Optional* |
|cancel_sending_to_entire_group  |str |cancelSendingToEntireGroup *Optional*  |
</div>


## `SendToAllGroupMembersMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal send to all group memeber menu keys.


**Attributes:**

|Name                            |Type|Description                 |
|--------------------------------|----|----------------------------|
|confirm_sending_to_entire_group |str |confirmSendingToEntireGroup |
|cancel_sending_to_entire_group  |str |cancelSendingToEntireGroup  |
</div>


## `SendToDistributionListMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal send to distribution list menu keys modify entry.


**Attributes:**

|Name                                       |Type|Description                                      |
|-------------------------------------------|----|-------------------------------------------------|
|send_message_to_selected_distribution_list |str |sendMessageToSelectedDistributionList *Optional* |
|select_distribution_list                   |str |selectDistributionList *Optional*                |
|review_selected_distribution_list          |str |reviewSelectedDistributionList *Optional*        |
|return_to_previous_menu                    |str |returnToPreviousMenu *Optional*                  |
|repeat_menu                                |str |repeatMenu *Optional*                            |
</div>


## `SendToDistributionListMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal send to distribution list menu keys.


**Attributes:**

|Name                                       |Type|Description                               |
|-------------------------------------------|----|------------------------------------------|
|send_message_to_selected_distribution_list |str |sendMessageToSelectedDistributionList     |
|select_distribution_list                   |str |selectDistributionList *Optional*         |
|review_selected_distribution_list          |str |reviewSelectedDistributionList *Optional* |
|return_to_previous_menu                    |str |returnToPreviousMenu                      |
|repeat_menu                                |str |repeatMenu *Optional*                     |
</div>


## `SendToPersonMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal send to person menu keys modify entry.


**Attributes:**

|Name                                            |Type|Description                                         |
|------------------------------------------------|----|----------------------------------------------------|
|confirm_sending_message                         |str |confirmSendingMessage *Optional*                    |
|cancel_sending_message                          |str |cancelSendingMessage *Optional*                     |
|finish_entering_number_where_to_send_message_to |str |finishEnteringNumberWhereToSendMessageTo *Optional* |
|finish_forwarding_or_sending_message            |str |finishForwardingOrSendingMessage *Optional*         |
</div>


## `SendToPersonMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal send to person menu keys.


**Attributes:**

|Name                                            |Type|Description                              |
|------------------------------------------------|----|-----------------------------------------|
|confirm_sending_message                         |str |confirmSendingMessage                    |
|cancel_sending_message                          |str |cancelSendingMessage                     |
|finish_entering_number_where_to_send_message_to |str |finishEnteringNumberWhereToSendMessageTo |
|finish_forwarding_or_sending_message            |str |finishForwardingOrSendingMessage         |
</div>


## `SequentialRingLocation`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Sequential Ring Location.

Replaced By: SequentialRingLocation14sp4

**Attributes:**

|Name            |Type|Description            |
|----------------|----|-----------------------|
|phone_number    |str |phoneNumber *Optional* |
|number_of_rings |int |numberOfRings          |
</div>


## `SequentialRingLocation14sp4`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Sequential Ring Location.


**Attributes:**

|Name                         |Type |Description                |
|-----------------------------|-----|---------------------------|
|phone_number                 |str  |phoneNumber *Optional*     |
|number_of_rings              |int  |numberOfRings              |
|answer_confirmation_required |bool |answerConfirmationRequired |
</div>


## `SequentialRingLocationModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Sequential Ring Location.


**Attributes:**

|Name                         |Type |Description                           |
|-----------------------------|-----|--------------------------------------|
|phone_number                 |str  |phoneNumber *Optional*                |
|number_of_rings              |int  |numberOfRings *Optional*              |
|answer_confirmation_required |bool |answerConfirmationRequired *Optional* |
</div>


## `ServiceActivation`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Service Instance active status indicator

**Attributes:**

|Name            |Type |Description   |
|----------------|-----|--------------|
|service_user_id |str  |serviceUserId |
|is_active       |bool |isActive      |
</div>


## `ServiceAttributeEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The service attributes name and value pair.


**Attributes:**

|Name  |Type|Description|
|------|----|-----------|
|name  |str |name       |
|value |str |value      |
</div>


## `ServiceAttributeEntryRead`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The service attributes name and value pair.


**Attributes:**

|Name  |Type|Description      |
|------|----|-----------------|
|name  |str |name             |
|value |str |value *Optional* |
</div>


## `ServiceCodeEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The service code entry.


**Attributes:**

|Name         |Type|Description |
|-------------|----|------------|
|service_code |str |serviceCode |
|description  |str |description |
</div>


## `ServicePolicyAttributeEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The service policy attributes name and value pair.


**Attributes:**

|Name  |Type|Description      |
|------|----|-----------------|
|name  |str |name             |
|value |str |value *Optional* |
</div>


## `ServicePolicyAttributeModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The service policy attributes name and value pair.


**Attributes:**

|Name  |Type|Description|
|------|----|-----------|
|name  |str |name       |
|value |str |value      |
</div>


## `ServicePolicyProfileKey`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The service policy profile key.


**Attributes:**

|Name     |Type|Description|
|---------|----|-----------|
|name     |str |name       |
|category |str |category   |
</div>


## `ServiceProviderAdmin`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The common Service Provider Admin elements.


**Attributes:**

|Name               |Type|Description          |
|-------------------|----|---------------------|
|user_id            |str |userId               |
|first_name         |str |firstName *Optional* |
|last_name          |str |lastName *Optional*  |
|password           |str |password *Optional*  |
|language           |str |language *Optional*  |
|administrator_type |str |administratorType    |
</div>


## `ServiceProviderBroadWorksMobilityGetRequest21sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Get the service provider BroadWorks Mobility service settings.

The response is either a ServiceProviderBroadWorksMobilityGetResponse21sp1V2 or an
`ErrorResponse()`. Replaced by `ServiceProviderBroadWorksMobilityGetRequest22V2()`.

**Attributes:**

|Name                |Type|Description       |
|--------------------|----|------------------|
|service_provider_id |str |serviceProviderId |
</div>


## `ServiceProviderBroadWorksMobilityGetResponse21sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The response to a ServiceProviderBroadWorksMobilityGetRequest21sp1V2.

Replaced by `ServiceProviderBroadWorksMobilityGetResponse22V2()`.

**Attributes:**

|Name                                           |Type |Description                               |
|-----------------------------------------------|-----|------------------------------------------|
|use_setting_level                              |str  |useSettingLevel                           |
|enable_location_services                       |bool |enableLocationServices                    |
|enable_msrn_lookup                             |bool |enableMSRNLookup                          |
|enable_mobile_state_checking                   |bool |enableMobileStateChecking                 |
|deny_call_originations                         |bool |denyCallOriginations                      |
|deny_call_terminations                         |bool |denyCallTerminations                      |
|enable_announcement_suppression                |bool |enableAnnouncementSuppression             |
|enable_internal_clid_delivery_access_locations |bool |enableInternalCLIDDeliveryAccessLocations |
|enable_enhanced_unreachable_state_checking     |bool |enableEnhancedUnreachableStateChecking    |
|enable_network_call_barring_status_check       |bool |enableNetworkCallBarringStatusCheck       |
</div>


## `ServiceProviderCommunicationBarringHierarchicalCallMeNowRule`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Service Provider Communication Barring Hierarchical Call Me Now Rule

**Attributes:**

|Name                   |Type|Description                     |
|-----------------------|----|--------------------------------|
|criteria               |str |criteria *Optional*             |
|digit_pattern_criteria |str |digitPatternCriteria *Optional* |
|action                 |str |action                          |
|call_timeout_seconds   |int |callTimeoutSeconds *Optional*   |
|time_schedule          |str |timeSchedule *Optional*         |
|holiday_schedule       |str |holidaySchedule *Optional*      |
|priority               |str |priority                        |
</div>


## `ServiceProviderCommunicationBarringHierarchicalOriginatingRule`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Service Provider Communication Barring Hierarchical Originating Rule

**Attributes:**

|Name                   |Type|Description                     |
|-----------------------|----|--------------------------------|
|criteria               |str |criteria *Optional*             |
|digit_pattern_criteria |str |digitPatternCriteria *Optional* |
|action                 |str |action                          |
|treatment_id           |str |treatmentId *Optional*          |
|transfer_number        |str |transferNumber *Optional*       |
|call_timeout_seconds   |int |callTimeoutSeconds *Optional*   |
|time_schedule          |str |timeSchedule *Optional*         |
|holiday_schedule       |str |holidaySchedule *Optional*      |
|priority               |str |priority                        |
</div>


## `ServiceProviderCommunicationBarringHierarchicalRedirectingRule`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Service Provider Communication Barring Hierarchical Redirecting Rule

**Attributes:**

|Name                   |Type|Description                     |
|-----------------------|----|--------------------------------|
|criteria               |str |criteria *Optional*             |
|digit_pattern_criteria |str |digitPatternCriteria *Optional* |
|action                 |str |action                          |
|call_timeout_seconds   |int |callTimeoutSeconds *Optional*   |
|time_schedule          |str |timeSchedule *Optional*         |
|holiday_schedule       |str |holidaySchedule *Optional*      |
|priority               |str |priority                        |
</div>


## `ServiceProviderCommunicationBarringProfileGetRequest19sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Get an existing Communication Barring Profile.

The response is either a ServiceProviderCommunicationBarringProfileGetResponse19sp1V2
or an `ErrorResponse()`.

**Attributes:**

|Name                |Type|Description       |
|--------------------|----|------------------|
|service_provider_id |str |serviceProviderId |
|name                |str |name              |
</div>


## `ServiceProviderVoiceMessagingGroupSettingsAdd`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A service provider's or enterprise's voice messaging settings used in the context of
add.


**Attributes:**

|Name                                                 |Type |Description                                   |
|-----------------------------------------------------|-----|----------------------------------------------|
|delivery_from_address                                |str  |deliveryFromAddress *Optional*                |
|notification_from_address                            |str  |notificationFromAddress *Optional*            |
|voice_portal_lockout_from_address                    |str  |voicePortalLockoutFromAddress *Optional*      |
|use_system_default_delivery_from_address             |bool |useSystemDefaultDeliveryFromAddress           |
|use_system_default_notification_from_address         |bool |useSystemDefaultNotificationFromAddress       |
|use_system_default_voice_portal_lockout_from_address |bool |useSystemDefaultVoicePortalLockoutFromAddress |
</div>


## `SimultaneousRingNumber`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Simultaneous Ring number entry.


**Attributes:**

|Name                         |Type |Description                |
|-----------------------------|-----|---------------------------|
|phone_number                 |str  |phoneNumber                |
|answer_confirmation_required |bool |answerConfirmationRequired |
</div>


## `SortByAdminFirstName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the administrator first name as the column for the sort,
whether the sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByAdminId`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the administrator id as the column for the sort, whether
the sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByAdminLastName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the administrator last name as the column for the sort,
whether the sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByAgentThresholdProfile`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the call center agent threshold profile as the column for
the sort, whether the sort is ascending or descending, and whether the sort is case
sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByAnnouncementFileName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the file name as the column for the sort, whether the sort
is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByAnnouncementFileSize`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the file size as the column for the sort, whether the sort
is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name         |Type |Description |
|-------------|-----|------------|
|is_ascending |bool |isAscending |
</div>


## `SortByCallCenterName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the call center name as the column for the sort, whether
the sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByCallCenterType`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the call center type as the column for the sort, whether
the sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByCallParkName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the call park name as the column for the sort, whether the
sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByCallPickupName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the call pickup name as the column for the sort, whether
the sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByDepartmentName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the department name as the column for the sort, whether
the sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByDeviceMACAddress`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the device MAC address as the column for the sort, whether
the sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByDeviceName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the device name as the column for the sort, whether the
sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByDeviceNetAddress`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the device net address as the column for the sort, whether
the sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByDeviceType`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the device type as the column for the sort, whether the
sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByDn`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the DN as the column for the sort, whether the sort is
ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByDnActivated`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the dn activation status as the column for the sort,
whether the sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByDnAvailable`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the dn availability as the column for the sort, whether
the sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByEmailAddress`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the email as the column for the sort, whether the sort is
ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByEnabled`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the Broadworks Enabled Flag as the column for the sort,
whether the sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByEnterpriseCommonPhoneListName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the enterprise common phone list name as the column for
the sort, whether sort is ascending or descending, and whether the sort is case
sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByEnterpriseCommonPhoneListNumber`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the enterprise common phone list number as as the column
for the sort, whether sort is ascending or descending, and whether the sort is case
sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByExtension`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the extension as the column for the sort, whether the sort
is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByForwardedToNumber`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the forwarded to phone number as the column for the sort,
whether the sort is ascending or descending, and whether the sort is case sensitive.

This sort criteria data type is only intended to be used by the commands introduced by
BW-2301. The commands are `EnterpriseUserCallForwardingSettingsGetListRequest()` and
`GroupUserCallForwardingSettingsGetListRequest()`. The following Call Forwarding
services are compatible for this search: Call Forwarding Always, Call Forwarding
Always Secondary, Call Forwarding Busy, Call Forwarding No Answer, Call Forwarding Not
Reachable, Call Forwarding Selective.

**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByGroupCommonPhoneListName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the group common phone list name as the column for the
sort, whether the sort is ascending or descending, and whether the sort is case
sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByGroupCommonPhoneListNumber`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the group common phone list number as the column for the
sort, whether sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByGroupId`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the group id as the column for the sort, whether the sort
is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByGroupLocationCode`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the group location code as the column for the sort,
whether the sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByGroupName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the group name as the column for the sort, whether the
sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByHuntPolicy`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the call center hunt policy as the column for the sort,
whether the sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByImpId`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the imp id as the column for the sort, whether the sort is
ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByLocation`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the Broadworks Location as the column for the sort,
whether the sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByMobileDirectoryNumber`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the Mobile dn availability as the column for the sort,
whether the sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByMobilePhoneNumber`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the mobile phone number as the column for the sort,
whether the sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByReceptionistNote`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the Receptionist Notes as the column for the sort, whether
the sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByScheduleName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the schedule name as the column for the sort, whether the
sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByServiceProviderId`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the service provider id as the column for the sort,
whether the sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByServiceProviderName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the service provider name as the column for the sort,
whether the sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByServiceStatus`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the service status as the column for the sort, whether the
sort is ascending or descending, and whether the sort is case sensitive.

This sort criteria data type is only intended to be used by the commands introduced by
BW-2301. The commands are `EnterpriseUserCallWaitingSettingsGetListRequest()`,
`GroupUserCallWaitingSettingsGetListRequest()`,
`EnterpriseUserHotelingGuestSettingsGetListRequest()`, and
`GroupUserHotelingGuestSettingsGetListRequest()`.

**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByTrunkGroupName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the trunk group name as the column for the sort, whether
the sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByUserDepartment`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the user department name as the column for the sort,
whether the sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByUserFirstName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the user first name as the column for the sort, whether
the sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByUserId`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the user id as the column for the sort, whether the sort
is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByUserLastName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the user last name as the column for the sort, whether the
sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByUserPersonalPhoneListName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the user personal phone list name as the column for the
sort, whether sort is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByUserPersonalPhoneListNumber`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the user personal phone list number as the column for the
sort, whether the sort is ascending or descending, and whether the sort is case
sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortByYahooId`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies the yahoo id as the column for the sort, whether the sort
is ascending or descending, and whether the sort is case sensitive.


**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortCriteria`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies whether sort is ascending or descending, and whether the
sort is case sensitive.

Sort order defaults to ascending and case sensitive.

**Attributes:**

|Name              |Type |Description     |
|------------------|-----|----------------|
|is_ascending      |bool |isAscending     |
|is_case_sensitive |bool |isCaseSensitive |
</div>


## `SortCriteriaNumeric`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The sort criteria specifies whether sort is ascending or descending.

Sort order defaults to ascending.

**Attributes:**

|Name         |Type |Description |
|-------------|-----|------------|
|is_ascending |bool |isAscending |
</div>


## `SpeedDial100Entry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Modify the speed dial 100 prefix setting for a group.

The response is either a `SuccessResponse()` or an `ErrorResponse()`.

**Attributes:**

|Name         |Type|Description            |
|-------------|----|-----------------------|
|speed_code   |int |speedCode              |
|phone_number |str |phoneNumber            |
|description  |str |description *Optional* |
</div>


## `SpeedDial100EntryModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Modify the speed dial 100 prefix setting for a group.

The response is either a `SuccessResponse()` or an `ErrorResponse()`.

**Attributes:**

|Name         |Type|Description            |
|-------------|----|-----------------------|
|speed_code   |int |speedCode              |
|phone_number |str |phoneNumber *Optional* |
|description  |str |description *Optional* |
</div>


## `SpeedDial8Entry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Modify the speed dial 8 prefix setting for a group.

The response is either a `SuccessResponse()` or an `ErrorResponse()`.

**Attributes:**

|Name         |Type|Description            |
|-------------|----|-----------------------|
|speed_code   |int |speedCode              |
|phone_number |str |phoneNumber *Optional* |
|description  |str |description *Optional* |
</div>


## `StreetAddress`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Street address information.


**Attributes:**

|Name                           |Type|Description                           |
|-------------------------------|----|--------------------------------------|
|address_line1                  |str |addressLine1 *Optional*               |
|address_line2                  |str |addressLine2 *Optional*               |
|city                           |str |city *Optional*                       |
|state_or_province              |str |stateOrProvince *Optional*            |
|state_or_province_display_name |str |stateOrProvinceDisplayName *Optional* |
|zip_or_postal_code             |str |zipOrPostalCode *Optional*            |
|country                        |str |country *Optional*                    |
</div>


## `SystemBroadWorksMobilityGetRequest21sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Get the broadworks mobility system parameters.

The response is either a SystemBroadWorksMobilityGetResponse21sp1V2 or an
`ErrorResponse()`. Replaced by `SystemBroadWorksMobilityGetRequest22V2()`.

</div>


## `SystemBroadWorksMobilityGetResponse21sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The response to a SystemBroadWorksMobilityGetRequest21sp1V2.

Replaced by `SystemBroadWorksMobilityGetResponse22V2()`.

**Attributes:**

|Name                                           |Type |Description                               |
|-----------------------------------------------|-----|------------------------------------------|
|enable_location_services                       |bool |enableLocationServices                    |
|enable_msrn_lookup                             |bool |enableMSRNLookup                          |
|enable_mobile_state_checking                   |bool |enableMobileStateChecking                 |
|deny_call_originations                         |bool |denyCallOriginations                      |
|deny_call_terminations                         |bool |denyCallTerminations                      |
|imrn_timeout_millisecnds                       |int  |imrnTimeoutMillisecnds                    |
|enable_internal_clid_delivery_access_locations |bool |enableInternalCLIDDeliveryAccessLocations |
|enable_enhanced_unreachable_state_checking     |bool |enableEnhancedUnreachableStateChecking    |
|enable_network_call_barring_status_check       |bool |enableNetworkCallBarringStatusCheck       |
</div>


## `SystemCollaborateGetRequest20sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Request the system level data associated with collaborate services.

The response is either a SystemCollaborateGetResponse20sp1V2 or an `ErrorResponse()`.

</div>


## `SystemCommunicationBarringProfileGetRequest19sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Get an existing Communication Barring Profile.

The response is either a SystemCommunicationBarringProfileGetResponse19sp1V2 or an
`ErrorResponse()`.

**Attributes:**

|Name |Type|Description|
|-----|----|-----------|
|name |str |name       |
</div>


## `SystemSIPDeviceTypeGetRequest18sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Request to get a sip device type.

See Also: `SystemDeviceTypeGetRequest()`

The response is either `SystemSIPDeviceTypeGetResponse19()` or `ErrorResponse()`.
Replaced by: `SystemSIPDeviceTypeGetRequest19()`.

**Attributes:**

|Name        |Type|Description|
|------------|----|-----------|
|device_type |str |deviceType |
</div>


## `SystemSIPDeviceTypeGetRequest21sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Request to get a sip device type.

See Also: `SystemDeviceTypeGetRequest()`

The response is either SystemSIPDeviceTypeGetResponse21sp1V2 or `ErrorResponse()`.
Replaced by: `SystemSIPDeviceTypeGetRequest22()` in AS data mode.

**Attributes:**

|Name        |Type|Description|
|------------|----|-----------|
|device_type |str |deviceType |
</div>


## `TimeInterval`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Time Interval.


**Attributes:**

|Name              |Type|Description    |
|------------------|----|---------------|
|start_day_of_week |str |startDayOfWeek |
|start_hour        |int |startHour      |
|start_minute      |int |startMinute    |
|end_day_of_week   |str |endDayOfWeek   |
|end_hour          |int |endHour        |
|end_minute        |int |endMinute      |
</div>


## `TimeSchedule`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The from dn criteria.


**Attributes:**

|Name |Type|Description|
|-----|----|-----------|
|type |str |type       |
|name |str |name       |
</div>


## `TrunkGroupDeviceEndpointAdd`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Trunk group device endpoint used in the context of modify.


**Attributes:**

|Name      |Type|Description        |
|----------|----|-------------------|
|name      |str |name               |
|line_port |str |linePort           |
|contact   |str |contact *Optional* |
</div>


## `TrunkGroupDeviceEndpointModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Trunk group device endpoint used in the context of modify.


**Attributes:**

|Name      |Type|Description        |
|----------|----|-------------------|
|name      |str |name               |
|line_port |str |linePort           |
|contact   |str |contact *Optional* |
</div>


## `TrunkGroupDeviceEndpointRead`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Trunk group device endpoint.


**Attributes:**

|Name                        |Type |Description               |
|----------------------------|-----|--------------------------|
|service_user_id             |str  |serviceUserId             |
|name                        |str  |name                      |
|line_port                   |str  |linePort                  |
|contact                     |str  |contact *Optional*        |
|static_registration_capable |bool |staticRegistrationCapable |
|use_domain                  |bool |useDomain                 |
</div>


## `TrunkGroupDeviceEndpointRead14sp4`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Trunk group device endpoint.


**Attributes:**

|Name                        |Type |Description               |
|----------------------------|-----|--------------------------|
|name                        |str  |name                      |
|line_port                   |str  |linePort                  |
|contact                     |str  |contact *Optional*        |
|static_registration_capable |bool |staticRegistrationCapable |
|use_domain                  |bool |useDomain                 |
|is_pilot_user               |bool |isPilotUser               |
</div>


## `TrunkGroupDeviceMultipleContactEndpointAdd`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Trunk group device endpoint used in the context of modify that can have multiple
contacts.


**Attributes:**

|Name      |Type      |Description        |
|----------|----------|-------------------|
|name      |str       |name               |
|line_port |str       |linePort           |
|contact   |List[str] |contact *Optional* |
</div>


## `TrunkGroupDeviceMultipleContactEndpointRead`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Trunk group device endpoint that can have multiple contacts.


**Attributes:**

|Name                        |Type      |Description               |
|----------------------------|----------|--------------------------|
|name                        |str       |name                      |
|line_port                   |str       |linePort                  |
|contact                     |List[str] |contact *Optional*        |
|static_registration_capable |bool      |staticRegistrationCapable |
|use_domain                  |bool      |useDomain                 |
|is_pilot_user               |bool      |isPilotUser               |
</div>


## `TrunkGroupKey`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Uniquely identifies a Trunk Group system-wide.

The trunkGroupName is unique within a group, but not unique system-wide.

**Attributes:**

|Name                |Type|Description       |
|--------------------|----|------------------|
|service_provider_id |str |serviceProviderId |
|group_id            |str |groupId           |
|name                |str |name              |
</div>


## `UnboundedNonNegativeInt`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Unbounded Quantity.

Can either be unlimited or a non-negative int quantity.

**Attributes:**

|Name      |Type |Description          |
|----------|-----|---------------------|
|unlimited |bool |unlimited *Optional* |
|quantity  |int  |quantity *Optional*  |
</div>


## `UnboundedPositiveInt`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Unbounded Quantity.

Can either be unlimited or a positive int quantity.

**Attributes:**

|Name      |Type |Description          |
|----------|-----|---------------------|
|unlimited |bool |unlimited *Optional* |
|quantity  |int  |quantity *Optional*  |
</div>


## `UserBroadWorksMobilityMobileIdentityGetRequest21sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Get the settings for a user's specified mobile identity.

The response is either a UserBroadWorksMobilityMobileIdentityGetResponse21sp1V2 or an
`ErrorResponse()`. Replaced by: `UserBroadWorksMobilityMobileIdentityGetRequest22()`.

**Attributes:**

|Name          |Type|Description  |
|--------------|----|-------------|
|user_id       |str |userId       |
|mobile_number |str |mobileNumber |
</div>


## `UserDNExtension`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
User's DN and extension.

Used in SearchCriteriaComposedOrDnExtension when either a DN or an extension can be
used as a search criteria.

**Attributes:**

|Name      |Type|Description          |
|----------|----|---------------------|
|dn        |str |dn *Optional*        |
|extension |str |extension *Optional* |
</div>


## `UserDisplayNames`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The parts of a user's display name that a client can display in whatever way is
appropriate for the client application.


**Attributes:**

|Name                |Type|Description                  |
|--------------------|----|-----------------------------|
|last_name           |str |lastName                     |
|first_name          |str |firstName                    |
|hiragana_last_name  |str |hiraganaLastName *Optional*  |
|hiragana_first_name |str |hiraganaFirstName *Optional* |
</div>


## `UserEndpointKey`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Key to uniquely identify a user endpoint.


**Attributes:**

|Name      |Type|Description|
|----------|----|-----------|
|user_id   |str |userId     |
|line_port |str |linePort   |
</div>


## `UserEnhancedCallLogsGetListResponse17sp4V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Response to UserEnhancedCallLogsGetListRequest17sp4V2.

Total numbers of rows is: - the total number of retrievable logs of the call log type
that was specified in the UserEnhancedCallLogsGetListRequest17sp4V2, if a call log
type was specified in the request.  - the total number of retrievable logs, if no call
log type was specified in the request.  A list of MixedCallLogsEntry will be returned
if the call logs are stored on CDS A list of ExtendedMixedCallLogsEntry17sp4 will be
returned if the call logs are stored on DBS The logs are sorted by date/time of the
call.

**Attributes:**

|Name                 |Type          |Description              |
|---------------------|--------------|-------------------------|
|total_number_of_rows |int           |totalNumberOfRows        |
|legacy_entry         |legacyEntry   |legacyEntry *Optional*   |
|extended_entry       |extendedEntry |extendedEntry *Optional* |
</div>


## `UserEnhancedCallLogsGetListResponse21sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Response to UserEnhancedCallLogsGetListRequest21sp1V2.

Total numbers of rows is: - the total number of retrievable logs of the call log type
that was specified in the UserEnhancedCallLogsGetListRequest21sp1V2, if a call log
type was specified in the request.  - the total number of retrievable logs, if no call
log type was specified in the request.  A list of MixedCallLogsEntry will be returned
if the call logs are stored on CDS A list of ExtendedMixedCallLogsEntry21sp1V2 will be
returned if the call logs are stored on DBS The logs are sorted by date/time of the
call.

**Attributes:**

|Name                 |Type          |Description              |
|---------------------|--------------|-------------------------|
|total_number_of_rows |int           |totalNumberOfRows        |
|legacy_entry         |legacyEntry   |legacyEntry *Optional*   |
|extended_entry       |extendedEntry |extendedEntry *Optional* |
</div>


## `UserFeatureAccessCodeModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Feature Access Code Entry to be used in all user modify command.


**Attributes:**

|Name                     |Type |Description           |
|-------------------------|-----|----------------------|
|feature_access_code_name |str  |featureAccessCodeName |
|enable_fac               |bool |enableFAC *Optional*  |
</div>


## `UserGetRequest21sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Request to get the user information.

The response is either UserGetResponse21sp1V2 or `ErrorResponse()`. Replaced by
`UserGetRequest22V3()` in AS data mode

**Attributes:**

|Name    |Type|Description|
|--------|----|-----------|
|user_id |str |userId     |
</div>


## `UserMoveMessage`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The message describes the impact made when moving a user from one group to another
group within the enterprise.

The message could also contain the error condition that prevents the user move.

**Attributes:**

|Name            |Type|Description    |
|----------------|----|---------------|
|message_code    |int |messageCode    |
|summary         |str |summary        |
|summary_english |str |summaryEnglish |
</div>


## `UserPreferredCarrierName`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
User can either use it's group's preferred carrier or use it's own.

The user carrier name is exposed if it was previously configured.

**Attributes:**

|Name                        |Type |Description              |
|----------------------------|-----|-------------------------|
|use_group_preferred_carrier |bool |useGroupPreferredCarrier |
|carrier                     |str  |carrier *Optional*       |
</div>


## `UserPreferredCarrierNameModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
User can either use it's group's preferred carrier or use it's own.

You can use the group's preferred carrier without clearing the user carrier name -- in
this case, the user carrier name is retained.

**Attributes:**

|Name                        |Type |Description              |
|----------------------------|-----|-------------------------|
|use_group_preferred_carrier |bool |useGroupPreferredCarrier |
|carrier                     |str  |carrier *Optional*       |
</div>


## `UserTwoStageDialingGetRequest13Mp20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Request the user level data associated with Two Stage Dialing.

The response is either a UserTwoStageDialingGetResponse13Mp20 or an `ErrorResponse()`.

**Attributes:**

|Name    |Type|Description|
|--------|----|-----------|
|user_id |str |userId     |
</div>


## `UserTwoStageDialingGetResponse13Mp20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Response to UserTwoStageDialingGetRequest13Mp20.


**Attributes:**

|Name                                 |Type |Description                      |
|-------------------------------------|-----|---------------------------------|
|is_active                            |bool |isActive                         |
|allow_activation_with_user_addresses |bool |allowActivationWithUserAddresses |
</div>


## `VerifyTranslationAndRoutingOrigination`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Verification Translation and Routing origination value.


**Attributes:**

|Name      |Type|Description         |
|----------|----|--------------------|
|line_port |str |linePort *Optional* |
|phone     |str |phone *Optional*    |
|user_id   |str |userId *Optional*   |
|url       |str |url *Optional*      |
</div>


## `VirtualOnNetUser`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Virtual On-Net User.


**Attributes:**

|Name                          |Type|Description              |
|------------------------------|----|-------------------------|
|phone_number                  |str |phoneNumber              |
|extension                     |str |extension                |
|first_name                    |str |firstName                |
|last_name                     |str |lastName                 |
|calling_line_id_first_name    |str |callingLineIdFirstName   |
|calling_line_id_last_name     |str |callingLineIdLastName    |
|virtual_on_net_call_type_name |str |virtualOnNetCallTypeName |
</div>


## `VirtualOnNetUserKey`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Virtual On-Net User identifier which is the Service Provider ID, Group ID, and phone
number (in E.

164 format).

**Attributes:**

|Name                |Type|Description       |
|--------------------|----|------------------|
|service_provider_id |str |serviceProviderId |
|group_id            |str |groupId           |
|phone_number        |str |phoneNumber       |
</div>


## `VoiceMessagingAliasListModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of dns that is added to a previously configured list.


**Attributes:**

|Name         |Type      |Description |
|-------------|----------|------------|
|phone_number |List[str] |phoneNumber |
</div>


## `VoiceMessagingAliasReplacementList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of dns that that replaces a previously configured list.

By convention, an element of this type may be set nil to clear the list.

**Attributes:**

|Name         |Type      |Description |
|-------------|----------|------------|
|phone_number |List[str] |phoneNumber |
</div>


## `VoiceMessagingAlternateNoAnswerGreetingRead`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The configuration of a alternate no answer greeting.

It is used when geting a user's voice messaging greeting.

**Attributes:**

|Name       |Type|Description          |
|-----------|----|---------------------|
|name       |str |name                 |
|audio_file |str |audioFile *Optional* |
|video_file |str |videoFile *Optional* |
</div>


## `VoiceMessagingAlternateNoAnswerGreetingRead16`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The configuration of a alternate no answer greeting.

It is used when geting a user's voice messaging greeting.

**Attributes:**

|Name             |Type|Description               |
|-----------------|----|--------------------------|
|name             |str |name                      |
|audio_file       |str |audioFile *Optional*      |
|audio_media_type |str |audioMediaType *Optional* |
|video_file       |str |videoFile *Optional*      |
|video_media_type |str |videoMediaType *Optional* |
</div>


## `VoiceMessagingMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal voice messaging menu keys modify entry.


**Attributes:**

|Name                          |Type|Description                           |
|------------------------------|----|--------------------------------------|
|play_messages                 |str |playMessages *Optional*               |
|change_busy_greeting          |str |changeBusyGreeting *Optional*         |
|change_no_answer_greeting     |str |changeNoAnswerGreeting *Optional*     |
|change_extended_away_greeting |str |changeExtendedAwayGreeting *Optional* |
|compose_message               |str |composeMessage *Optional*             |
|delete_all_messages           |str |deleteAllMessages *Optional*          |
|passcode                      |str |passcode *Optional*                   |
|personalized_name             |str |personalizedName *Optional*           |
|message_deposit               |str |messageDeposit *Optional*             |
|return_to_previous_menu       |str |returnToPreviousMenu *Optional*       |
|repeat_menu                   |str |repeatMenu *Optional*                 |
</div>


## `VoiceMessagingMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal voice messaging menu keys.


**Attributes:**

|Name                          |Type|Description                           |
|------------------------------|----|--------------------------------------|
|play_messages                 |str |playMessages *Optional*               |
|change_busy_greeting          |str |changeBusyGreeting *Optional*         |
|change_no_answer_greeting     |str |changeNoAnswerGreeting *Optional*     |
|change_extended_away_greeting |str |changeExtendedAwayGreeting *Optional* |
|compose_message               |str |composeMessage *Optional*             |
|delete_all_messages           |str |deleteAllMessages *Optional*          |
|passcode                      |str |passcode *Optional*                   |
|personalized_name             |str |personalizedName *Optional*           |
|message_deposit               |str |messageDeposit *Optional*             |
|return_to_previous_menu       |str |returnToPreviousMenu                  |
|repeat_menu                   |str |repeatMenu *Optional*                 |
</div>


## `VoicePortalCallingMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal calling menu keys modify entry.


**Attributes:**

|Name                                          |Type|Description                                      |
|----------------------------------------------|----|-------------------------------------------------|
|end_current_call_and_go_back_to_previous_menu |str |endCurrentCallAndGoBackToPreviousMenu *Optional* |
|return_to_previous_menu                       |str |returnToPreviousMenu *Optional*                  |
</div>


## `VoicePortalCallingMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal change calling menu keys.


**Attributes:**

|Name                                          |Type|Description                           |
|----------------------------------------------|----|--------------------------------------|
|end_current_call_and_go_back_to_previous_menu |str |endCurrentCallAndGoBackToPreviousMenu |
|return_to_previous_menu                       |str |returnToPreviousMenu                  |
</div>


## `VoicePortalLoginMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal voice portal login menu keys modify entry.


**Attributes:**

|Name                          |Type|Description                          |
|------------------------------|----|-------------------------------------|
|access_using_other_mailbox_id |str |accessUsingOtherMailboxId *Optional* |
</div>


## `VoicePortalLoginMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal login menu keys.


**Attributes:**

|Name                          |Type|Description                          |
|------------------------------|----|-------------------------------------|
|access_using_other_mailbox_id |str |accessUsingOtherMailboxId *Optional* |
</div>


## `VoicePortalMainMenuKeysModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal main menu keys modify entry.


**Attributes:**

|Name                       |Type|Description                        |
|---------------------------|----|-----------------------------------|
|voice_messaging            |str |voiceMessaging *Optional*          |
|comm_pilot_express_profile |str |commPilotExpressProfile *Optional* |
|greetings                  |str |greetings *Optional*               |
|call_forwarding_options    |str |callForwardingOptions *Optional*   |
|voice_portal_calling       |str |voicePortalCalling *Optional*      |
|hoteling                   |str |hoteling *Optional*                |
|passcode                   |str |passcode *Optional*                |
|exit_voice_portal          |str |exitVoicePortal *Optional*         |
|repeat_menu                |str |repeatMenu *Optional*              |
|external_routing           |str |externalRouting *Optional*         |
|announcement               |str |announcement *Optional*            |
|personal_assistant         |str |personalAssistant *Optional*       |
</div>


## `VoicePortalMainMenuKeysReadEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The voice portal main menu keys.


**Attributes:**

|Name                       |Type|Description                        |
|---------------------------|----|-----------------------------------|
|voice_messaging            |str |voiceMessaging *Optional*          |
|comm_pilot_express_profile |str |commPilotExpressProfile *Optional* |
|greetings                  |str |greetings *Optional*               |
|call_forwarding_options    |str |callForwardingOptions *Optional*   |
|voice_portal_calling       |str |voicePortalCalling *Optional*      |
|hoteling                   |str |hoteling *Optional*                |
|passcode                   |str |passcode *Optional*                |
|exit_voice_portal          |str |exitVoicePortal *Optional*         |
|repeat_menu                |str |repeatMenu *Optional*              |
|external_routing           |str |externalRouting *Optional*         |
|announcement               |str |announcement *Optional*            |
|personal_assistant         |str |personalAssistant *Optional*       |
</div>


## `XsiApplicationIdEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The system application Id entry.


**Attributes:**

|Name               |Type|Description            |
|-------------------|----|-----------------------|
|xsi_application_id |str |xsiApplicationId       |
|description        |str |description *Optional* |
</div>


## `XsiPolicyProfileAssignEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The Xsi policy profile assign entry contains multiple Xsi policy profile and one
default xsi policy profile.


**Attributes:**

|Name    |Type      |Description        |
|--------|----------|-------------------|
|name    |List[str] |name *Optional*    |
|default |str       |default *Optional* |
</div>


## `XsiPolicyProfileKey`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The system Xsi policy profile key.


**Attributes:**

|Name  |Type|Description|
|------|----|-----------|
|name  |str |name       |
|level |str |level      |
</div>


## `XsiPolicyProfileUnassignEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The Xsi policy profile unassign entry contains mutiltipe Xsi policy profile and a new
replacement default xsi policy profile.


**Attributes:**

|Name        |Type      |Description           |
|------------|----------|----------------------|
|name        |List[str] |name *Optional*       |
|new_default |str       |newDefault *Optional* |
</div>


## `AccessDeviceEndpointAdd`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point used in the context of add.

Port numbers are only used by devices with static line ordering.  The following
element is only used in AS data mode and ignored in XS data mode: pathHeader

**Attributes:**

|Name          |Type         |Description           |
|--------------|-------------|----------------------|
|access_device |accessDevice |accessDevice          |
|line_port     |str          |linePort              |
|contact       |str          |contact *Optional*    |
|path_header   |str          |pathHeader *Optional* |
|port_number   |int          |portNumber *Optional* |
</div>


## `AccessDeviceEndpointAndHotlineAdd`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point used in the context of add.

Port numbers are only used by devices with static line ordering.  The following
element is only used in AS data mode and ignored in XS data mode: pathHeader
useHotline, use value false in XS data mode hotlineContact The following element is
only used in XS data mode and ignored in AS data mode: privateIdentity

**Attributes:**

|Name             |Type         |Description                |
|-----------------|-------------|---------------------------|
|access_device    |accessDevice |accessDevice               |
|line_port        |str          |linePort                   |
|private_identity |str          |privateIdentity *Optional* |
|contact          |str          |contact *Optional*         |
|path_header      |str          |pathHeader *Optional*      |
|port_number      |int          |portNumber *Optional*      |
|use_hotline      |bool         |useHotline                 |
|hotline_contact  |str          |hotlineContact *Optional*  |
</div>


## `AccessDeviceEndpointAndHotlineModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point used in the context of modify.

Port numbers are only used by devices with static line ordering.  The following
element is only used in AS data mode and ignored in XS data mode: pathHeader
useHotline hotlineContact

**Attributes:**

|Name            |Type         |Description               |
|----------------|-------------|--------------------------|
|access_device   |accessDevice |accessDevice              |
|line_port       |str          |linePort                  |
|contact         |str          |contact *Optional*        |
|path_header     |str          |pathHeader *Optional*     |
|port_number     |int          |portNumber *Optional*     |
|use_hotline     |bool         |useHotline *Optional*     |
|hotline_contact |str          |hotlineContact *Optional* |
</div>


## `AccessDeviceEndpointKey`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point in the context of a modify or delete command.


**Attributes:**

|Name          |Type         |Description  |
|--------------|-------------|-------------|
|access_device |accessDevice |accessDevice |
|line_port     |str          |linePort     |
</div>


## `AccessDeviceEndpointModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point used in the context of modify.

Port numbers are only used by devices with static line ordering.  The following
element is only used in AS data mode and ignored in XS data mode: pathHeader

**Attributes:**

|Name          |Type         |Description           |
|--------------|-------------|----------------------|
|access_device |accessDevice |accessDevice          |
|line_port     |str          |linePort              |
|contact       |str          |contact *Optional*    |
|path_header   |str          |pathHeader *Optional* |
|port_number   |int          |portNumber *Optional* |
</div>


## `AccessDeviceEndpointRead14`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point.


**Attributes:**

|Name                        |Type         |Description               |
|----------------------------|-------------|--------------------------|
|access_device               |accessDevice |accessDevice              |
|line_port                   |str          |linePort                  |
|contact                     |str          |contact *Optional*        |
|static_registration_capable |bool         |staticRegistrationCapable |
|use_domain                  |bool         |useDomain                 |
</div>


## `AccessDeviceEndpointWithPortNumberRead`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point.

Port numbers are only used by devices with static line ordering.

**Attributes:**

|Name                        |Type         |Description               |
|----------------------------|-------------|--------------------------|
|access_device               |accessDevice |accessDevice              |
|line_port                   |str          |linePort                  |
|contact                     |str          |contact *Optional*        |
|static_registration_capable |bool         |staticRegistrationCapable |
|use_domain                  |bool         |useDomain                 |
|port_number                 |int          |portNumber *Optional*     |
</div>


## `AccessDeviceEndpointWithPortNumberRead22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point.

Port numbers are only used by devices with static line ordering.  The following
element is only used in AS data mode and ignored in XS data mode: pathHeader

**Attributes:**

|Name                        |Type         |Description               |
|----------------------------|-------------|--------------------------|
|access_device               |accessDevice |accessDevice              |
|line_port                   |str          |linePort                  |
|contact                     |str          |contact *Optional*        |
|path_header                 |str          |pathHeader *Optional*     |
|static_registration_capable |bool         |staticRegistrationCapable |
|use_domain                  |bool         |useDomain                 |
|port_number                 |int          |portNumber *Optional*     |
</div>


## `AccessDeviceEndpointWithPortNumberRead22V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point.

Port numbers are only used by devices with static line ordering.  The following
element is only used in AS data mode and ignored in XS data mode: pathHeader
hotlineContact The following elements are only used in AS data mode and a value false
is returned in the XS mode: useHotline

**Attributes:**

|Name                        |Type         |Description               |
|----------------------------|-------------|--------------------------|
|access_device               |accessDevice |accessDevice              |
|line_port                   |str          |linePort                  |
|contact                     |str          |contact *Optional*        |
|path_header                 |str          |pathHeader *Optional*     |
|static_registration_capable |bool         |staticRegistrationCapable |
|use_domain                  |bool         |useDomain                 |
|port_number                 |int          |portNumber *Optional*     |
|use_hotline                 |bool         |useHotline                |
|hotline_contact             |str          |hotlineContact *Optional* |
</div>


## `AccessDeviceMultipleContactEndpointAdd`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point used in the context of add that can have more than one contact
defined.

Only Static Registration capabable devices may have more than one contact defined.
Port numbers are only used by devices with static line ordering.

**Attributes:**

|Name          |Type         |Description           |
|--------------|-------------|----------------------|
|access_device |accessDevice |accessDevice          |
|line_port     |str          |linePort              |
|contact       |List[str]    |contact *Optional*    |
|port_number   |int          |portNumber *Optional* |
</div>


## `AccessDeviceMultipleContactEndpointAdd22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point used in the context of add that can have more than one contact
defined.

Only Static Registration capabable devices may have more than one contact defined.
Port numbers are only used by devices with static line ordering.

**Attributes:**

|Name          |Type          |Description           |
|--------------|--------------|----------------------|
|access_device |accessDevice  |accessDevice          |
|line_port     |str           |linePort              |
|contact       |List[contact] |contact *Optional*    |
|port_number   |int           |portNumber *Optional* |
</div>


## `AccessDeviceMultipleContactEndpointModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point used in the context of modify that can have more than one
contact defined.

Only Static Registration capable devices may have more than one contact defined.  Port
numbers are only used by devices with static line ordering.

**Attributes:**

|Name          |Type         |Description             |
|--------------|-------------|------------------------|
|access_device |accessDevice |accessDevice *Optional* |
|line_port     |str          |linePort *Optional*     |
|contact_list  |contactList  |contactList *Optional*  |
|port_number   |int          |portNumber *Optional*   |
</div>


## `AccessDeviceMultipleContactEndpointRead`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point that can have multiple contacts.

Replaced by AccessDeviceMultipleContactEndpointRead19.

**Attributes:**

|Name                        |Type         |Description               |
|----------------------------|-------------|--------------------------|
|access_device               |accessDevice |accessDevice              |
|line_port                   |str          |linePort                  |
|contact                     |List[str]    |contact *Optional*        |
|static_registration_capable |bool         |staticRegistrationCapable |
|use_domain                  |bool         |useDomain                 |
</div>


## `AccessDeviceMultipleContactEndpointRead19`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point that can have multiple contacts.

Port numbers are only used by devices with static line ordering.  Replaced by
AccessDeviceMultipleContactEndpointRead20.

**Attributes:**

|Name                        |Type         |Description               |
|----------------------------|-------------|--------------------------|
|access_device               |accessDevice |accessDevice              |
|line_port                   |str          |linePort                  |
|contact                     |List[str]    |contact *Optional*        |
|static_registration_capable |bool         |staticRegistrationCapable |
|use_domain                  |bool         |useDomain                 |
|port_number                 |int          |portNumber *Optional*     |
</div>


## `AccessDeviceMultipleContactEndpointRead20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point that can have multiple contacts.

Port numbers are only used by devices with static line ordering.  Replaced by
AccessDeviceMultipleContactEndpointRead22.

**Attributes:**

|Name                             |Type         |Description                   |
|---------------------------------|-------------|------------------------------|
|access_device                    |accessDevice |accessDevice                  |
|line_port                        |str          |linePort                      |
|contact                          |List[str]    |contact *Optional*            |
|static_registration_capable      |bool         |staticRegistrationCapable     |
|use_domain                       |bool         |useDomain                     |
|port_number                      |int          |portNumber *Optional*         |
|support_visual_device_management |bool         |supportVisualDeviceManagement |
</div>


## `AccessDeviceMultipleContactEndpointRead22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point that can have multiple contacts.

Port numbers are only used by devices with static line ordering.

**Attributes:**

|Name                             |Type          |Description                   |
|---------------------------------|--------------|------------------------------|
|access_device                    |accessDevice  |accessDevice                  |
|line_port                        |str           |linePort                      |
|contact                          |List[contact] |contact *Optional*            |
|static_registration_capable      |bool          |staticRegistrationCapable     |
|use_domain                       |bool          |useDomain                     |
|port_number                      |int           |portNumber *Optional*         |
|support_visual_device_management |bool          |supportVisualDeviceManagement |
</div>


## `AccessDeviceMultipleIdentityAndContactEndpointAdd`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point used in the context of add that can have more than one contact
defined.

The endpoint is identified by its linePort (public Identity) and possibly a private
Identity.  Only Static Registration capabable devices may have more than one contact
defined.  Port numbers are only used by devices with static line ordering.  The
following elements are only used in XS data mode and ignored in AS data mode:
privateIdentity

**Attributes:**

|Name             |Type         |Description                |
|-----------------|-------------|---------------------------|
|access_device    |accessDevice |accessDevice               |
|line_port        |str          |linePort                   |
|private_identity |str          |privateIdentity *Optional* |
|contact          |List[str]    |contact *Optional*         |
|port_number      |int          |portNumber *Optional*      |
</div>


## `AccessDeviceMultipleIdentityAndContactEndpointAdd22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point used in the context of add that can have more than one contact
defined.

The endpoint is identified by its linePort (public Identity) and possibly a private
Identity.  Only Static Registration capabable devices may have more than one contact
defined.  Port numbers are only used by devices with static line ordering.  The
following elements are only used in XS data mode and ignored in AS data mode:
privateIdentity

**Attributes:**

|Name             |Type          |Description                |
|-----------------|--------------|---------------------------|
|access_device    |accessDevice  |accessDevice               |
|line_port        |str           |linePort                   |
|private_identity |str           |privateIdentity *Optional* |
|contact          |List[contact] |contact *Optional*         |
|port_number      |int           |portNumber *Optional*      |
</div>


## `AccessDeviceMultipleIdentityAndContactEndpointAdd22V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point used in the context of add that can have more than one contact
defined.

The endpoint is identified by its linePort (public Identity) and possibly a private
Identity.  Only Static Registration capabable devices may have more than one contact
defined.  Port numbers are only used by devices with static line ordering.  The
following elements are only used in XS data mode and ignored in AS data mode:
privateIdentity The following elements are only used in AS data mode and ignored in XS
data mode: useHotline, use value false in XS data mode hotlineContact

**Attributes:**

|Name             |Type          |Description                |
|-----------------|--------------|---------------------------|
|access_device    |accessDevice  |accessDevice               |
|line_port        |str           |linePort                   |
|private_identity |str           |privateIdentity *Optional* |
|contact          |List[contact] |contact *Optional*         |
|port_number      |int           |portNumber *Optional*      |
|use_hotline      |bool          |useHotline                 |
|hotline_contact  |str           |hotlineContact *Optional*  |
</div>


## `AccessDeviceMultipleIdentityAndContactEndpointModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point used in the context of modify that can have more than one
contact defined.

The endpoint is identified by its linePort (public Identity) and possibly a private
Identity.  Only Static Registration capabable devices may have more than one contact
defined.  Port numbers are only used by devices with static line ordering.  The
following elements are only used in XS data mode and ignored in AS data mode:
privateIdentity

**Attributes:**

|Name             |Type         |Description                |
|-----------------|-------------|---------------------------|
|access_device    |accessDevice |accessDevice *Optional*    |
|line_port        |str          |linePort *Optional*        |
|private_identity |str          |privateIdentity *Optional* |
|contact_list     |contactList  |contactList *Optional*     |
|port_number      |int          |portNumber *Optional*      |
</div>


## `AccessDeviceMultipleIdentityAndContactEndpointRead`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point that can have multiple contacts.

The endpoint is identified by its linePort (public Identity) and possibly a private
Identity.  Port numbers are only used by devices with static line ordering.  The
following elements are only used in XS data mode and not returned in AS data mode:
privateIdentity The following elements are only used in AS data mode and a value false
is returned in the XS mode: supportVisualDeviceManagement

**Attributes:**

|Name                             |Type         |Description                   |
|---------------------------------|-------------|------------------------------|
|access_device                    |accessDevice |accessDevice                  |
|line_port                        |str          |linePort                      |
|private_identity                 |str          |privateIdentity *Optional*    |
|contact                          |List[str]    |contact *Optional*            |
|static_registration_capable      |bool         |staticRegistrationCapable     |
|use_domain                       |bool         |useDomain                     |
|port_number                      |int          |portNumber *Optional*         |
|support_visual_device_management |bool         |supportVisualDeviceManagement |
</div>


## `AccessDeviceMultipleIdentityAndContactEndpointRead22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point that can have multiple contacts.

The endpoint is identified by its linePort (public Identity) and possibly a private
Identity.  Port numbers are only used by devices with static line ordering.  The
following elements are only used in XS data mode and not returned in AS data mode:
privateIdentity The following elements are only used in AS data mode and a value false
is returned in the XS mode: supportVisualDeviceManagement

**Attributes:**

|Name                             |Type          |Description                   |
|---------------------------------|--------------|------------------------------|
|access_device                    |accessDevice  |accessDevice                  |
|line_port                        |str           |linePort                      |
|private_identity                 |str           |privateIdentity *Optional*    |
|contact                          |List[contact] |contact *Optional*            |
|static_registration_capable      |bool          |staticRegistrationCapable     |
|use_domain                       |bool          |useDomain                     |
|port_number                      |int           |portNumber *Optional*         |
|support_visual_device_management |bool          |supportVisualDeviceManagement |
</div>


## `AccessDeviceMultipleIdentityAndContactEndpointRead22V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point that can have multiple contacts.

The endpoint is identified by its linePort (public Identity) and possibly a private
Identity.  Port numbers are only used by devices with static line ordering.  The
following elements are only used in XS data mode and not returned in AS data mode:
privateIdentity The following elements are only used in AS data mode and a value false
is returned in the XS mode: supportVisualDeviceManagement useHotline The following
elements are only used in AS data mode and not returned in XS data mode:
hotlineContact

**Attributes:**

|Name                             |Type          |Description                   |
|---------------------------------|--------------|------------------------------|
|access_device                    |accessDevice  |accessDevice                  |
|line_port                        |str           |linePort                      |
|private_identity                 |str           |privateIdentity *Optional*    |
|contact                          |List[contact] |contact *Optional*            |
|static_registration_capable      |bool          |staticRegistrationCapable     |
|use_domain                       |bool          |useDomain                     |
|port_number                      |int           |portNumber *Optional*         |
|support_visual_device_management |bool          |supportVisualDeviceManagement |
|use_hotline                      |bool          |useHotline                    |
|hotline_contact                  |str           |hotlineContact *Optional*     |
</div>


## `AccessDeviceMultipleIdentityEndpointAdd`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point used in the context of add.

The endpoint is identified by its linePort (public Identity) and possibly a private
Identity.  Port numbers are only used by devices with static line ordering.  The
following elements are only used in XS data mode and ignored in AS data mode:
privateIdentity

**Attributes:**

|Name             |Type         |Description                |
|-----------------|-------------|---------------------------|
|access_device    |accessDevice |accessDevice               |
|line_port        |str          |linePort                   |
|private_identity |str          |privateIdentity *Optional* |
|contact          |str          |contact *Optional*         |
|port_number      |int          |portNumber *Optional*      |
</div>


## `AccessDeviceMultipleIdentityEndpointKey`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point in the context of a modify or delete command.

The endpoint is identified by its linePort (public Identity) and possibly a private
Identity.  The following elements are only used in XS data mode and ignored in AS data
mode: privateIdentity

**Attributes:**

|Name             |Type         |Description                |
|-----------------|-------------|---------------------------|
|access_device    |accessDevice |accessDevice               |
|line_port        |str          |linePort                   |
|private_identity |str          |privateIdentity *Optional* |
</div>


## `AccessDeviceMultipleIdentityEndpointWithType`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point that can have multiple contacts.

The endpoint is identified by its linePort (public Identity) and possibly a private
Identity.  Port numbers are only used by devices with static line ordering.

**Attributes:**

|Name             |Type         |Description                |
|-----------------|-------------|---------------------------|
|access_device    |accessDevice |accessDevice               |
|device_type      |str          |deviceType                 |
|line_port        |str          |linePort                   |
|private_identity |str          |privateIdentity *Optional* |
|contact          |str          |contact *Optional*         |
|port_number      |int          |portNumber *Optional*      |
|mac_address      |str          |macAddress *Optional*      |
</div>


## `AutoAttendantKeyConfigurationEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The configuration entry of a key for Auto Attendant.

The following elements are only used in AS data mode: audioFile videoFile

**Attributes:**

|Name         |Type      |Description            |
|-------------|----------|-----------------------|
|description  |str       |description *Optional* |
|action       |str       |action                 |
|phone_number |str       |phoneNumber *Optional* |
|audio_file   |audioFile |audioFile *Optional*   |
|video_file   |videoFile |videoFile *Optional*   |
</div>


## `AutoAttendantKeyConfigurationEntry19`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The configuration entry of a key for Auto Attendant.

The following data elements are only valid for Standard Auto Attendants: submenuId

**Attributes:**

|Name         |Type      |Description            |
|-------------|----------|-----------------------|
|description  |str       |description *Optional* |
|action       |str       |action                 |
|phone_number |str       |phoneNumber *Optional* |
|audio_file   |audioFile |audioFile *Optional*   |
|video_file   |videoFile |videoFile *Optional*   |
|submenu_id   |str       |submenuId *Optional*   |
</div>


## `AutoAttendantKeyConfigurationEntry20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The configuration entry of a key for Auto Attendant.

The following data elements are only used in AS data mode: audioFile videoFile
submenuId The following data elements are only valid for Standard Auto Attendants:
submenuId

**Attributes:**

|Name         |Type      |Description            |
|-------------|----------|-----------------------|
|description  |str       |description *Optional* |
|action       |str       |action                 |
|phone_number |str       |phoneNumber *Optional* |
|audio_file   |audioFile |audioFile *Optional*   |
|video_file   |videoFile |videoFile *Optional*   |
|submenu_id   |str       |submenuId *Optional*   |
</div>


## `AutoAttendantKeyConfigurationModifyEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The modify configuration entry of a key for Auto Attendant.

The following data elements are only valid for Standard Auto Attendants: submenuId

**Attributes:**

|Name         |Type      |Description            |
|-------------|----------|-----------------------|
|description  |str       |description *Optional* |
|action       |str       |action                 |
|phone_number |str       |phoneNumber *Optional* |
|audio_file   |audioFile |audioFile *Optional*   |
|video_file   |videoFile |videoFile *Optional*   |
|submenu_id   |str       |submenuId *Optional*   |
</div>


## `AutoAttendantKeyConfigurationModifyEntry20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The modify configuration entry of a key for Auto Attendant.

The following data elements are only used in AS data mode: audioFile videoFile
submenuId The following data elements are only valid for Standard Auto Attendants:
submenuId

**Attributes:**

|Name         |Type      |Description            |
|-------------|----------|-----------------------|
|description  |str       |description *Optional* |
|action       |str       |action                 |
|phone_number |str       |phoneNumber *Optional* |
|audio_file   |audioFile |audioFile *Optional*   |
|video_file   |videoFile |videoFile *Optional*   |
|submenu_id   |str       |submenuId *Optional*   |
</div>


## `AutoAttendantKeyConfigurationReadEntry20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The read configuration entry of a key for Auto Attendant.

The following data elements are only used in AS data mode: submenuId The following
data elements are only valid for Standard Auto Attendants: submenuId

**Attributes:**

|Name         |Type      |Description            |
|-------------|----------|-----------------------|
|description  |str       |description *Optional* |
|action       |str       |action                 |
|phone_number |str       |phoneNumber *Optional* |
|audio_file   |audioFile |audioFile *Optional*   |
|video_file   |videoFile |videoFile *Optional*   |
|submenu_id   |str       |submenuId *Optional*   |
</div>


## `AutoAttendantKeyReadConfiguration`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The read configuration of a key for Auto Attendant.


**Attributes:**

|Name  |Type  |Description|
|------|------|-----------|
|key   |str   |key        |
|entry |entry |entry      |
</div>


## `AutoAttendantKeyReadConfiguration19`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The read configuration of a key for Auto Attendant.


**Attributes:**

|Name  |Type  |Description|
|------|------|-----------|
|key   |str   |key        |
|entry |entry |entry      |
</div>


## `CPEDeviceOptionsRead`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CPE device's options.


**Attributes:**

|Name                                  |Type                              |Description                                  |
|--------------------------------------|----------------------------------|---------------------------------------------|
|enable_monitoring                     |bool                              |enableMonitoring                             |
|reset_event                           |str                               |resetEvent *Optional*                        |
|config_type                           |str                               |configType                                   |
|system_file_name                      |str                               |systemFileName *Optional*                    |
|device_file_format                    |str                               |deviceFileFormat *Optional*                  |
|device_management_device_type_options |deviceManagementDeviceTypeOptions |deviceManagementDeviceTypeOptions *Optional* |
</div>


## `CPEDeviceOptionsRead16`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CPE device's options.


**Attributes:**

|Name                                  |Type                              |Description                                  |
|--------------------------------------|----------------------------------|---------------------------------------------|
|enable_monitoring                     |bool                              |enableMonitoring                             |
|reset_event                           |str                               |resetEvent *Optional*                        |
|config_type                           |str                               |configType                                   |
|system_file_name                      |str                               |systemFileName *Optional*                    |
|device_file_format                    |str                               |deviceFileFormat *Optional*                  |
|device_management_device_type_options |deviceManagementDeviceTypeOptions |deviceManagementDeviceTypeOptions *Optional* |
</div>


## `CPEDeviceOptionsRead16sp1`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CPE device's options.


**Attributes:**

|Name                                  |Type                              |Description                                  |
|--------------------------------------|----------------------------------|---------------------------------------------|
|enable_monitoring                     |bool                              |enableMonitoring                             |
|config_type                           |str                               |configType *Optional*                        |
|system_file_name                      |str                               |systemFileName *Optional*                    |
|device_file_format                    |str                               |deviceFileFormat *Optional*                  |
|device_management_device_type_options |deviceManagementDeviceTypeOptions |deviceManagementDeviceTypeOptions *Optional* |
</div>


## `CPEDeviceOptionsRead21sp1`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CPE device's options.


**Attributes:**

|Name                                  |Type                              |Description                                  |
|--------------------------------------|----------------------------------|---------------------------------------------|
|enable_monitoring                     |bool                              |enableMonitoring                             |
|config_type                           |str                               |configType *Optional*                        |
|system_file_name                      |str                               |systemFileName *Optional*                    |
|device_file_format                    |str                               |deviceFileFormat *Optional*                  |
|device_management_device_type_options |deviceManagementDeviceTypeOptions |deviceManagementDeviceTypeOptions *Optional* |
</div>


## `CPEDeviceOptionsRead22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CPE device's options.


**Attributes:**

|Name                                  |Type                              |Description                                  |
|--------------------------------------|----------------------------------|---------------------------------------------|
|enable_monitoring                     |bool                              |enableMonitoring                             |
|config_type                           |str                               |configType *Optional*                        |
|system_file_name                      |str                               |systemFileName *Optional*                    |
|device_file_format                    |str                               |deviceFileFormat *Optional*                  |
|device_management_device_type_options |deviceManagementDeviceTypeOptions |deviceManagementDeviceTypeOptions *Optional* |
</div>


## `CPEDeviceOptionsRead22V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CPE device's options.


**Attributes:**

|Name                                  |Type                              |Description                                  |
|--------------------------------------|----------------------------------|---------------------------------------------|
|enable_monitoring                     |bool                              |enableMonitoring                             |
|config_type                           |str                               |configType *Optional*                        |
|system_file_name                      |str                               |systemFileName *Optional*                    |
|device_file_format                    |str                               |deviceFileFormat *Optional*                  |
|device_management_device_type_options |deviceManagementDeviceTypeOptions |deviceManagementDeviceTypeOptions *Optional* |
</div>


## `CPEDeviceOptionsRead22V3`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CPE device's options.


**Attributes:**

|Name                                  |Type                              |Description                                  |
|--------------------------------------|----------------------------------|---------------------------------------------|
|enable_monitoring                     |bool                              |enableMonitoring                             |
|config_type                           |str                               |configType *Optional*                        |
|system_file_name                      |str                               |systemFileName *Optional*                    |
|device_file_format                    |str                               |deviceFileFormat *Optional*                  |
|device_management_device_type_options |deviceManagementDeviceTypeOptions |deviceManagementDeviceTypeOptions *Optional* |
</div>


## `CPEDeviceOptionsRead22V4`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CPE device's options.


**Attributes:**

|Name                                  |Type                              |Description                                  |
|--------------------------------------|----------------------------------|---------------------------------------------|
|enable_monitoring                     |bool                              |enableMonitoring                             |
|config_type                           |str                               |configType *Optional*                        |
|system_file_name                      |str                               |systemFileName *Optional*                    |
|device_file_format                    |str                               |deviceFileFormat *Optional*                  |
|device_management_device_type_options |deviceManagementDeviceTypeOptions |deviceManagementDeviceTypeOptions *Optional* |
</div>


## `CallCenterAgentStatistics13mp8`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains Call Center statistics for a specified agent.


**Attributes:**

|Name                 |Type                |Description         |
|---------------------|--------------------|--------------------|
|agent_user_id        |str                 |agentUserId         |
|agent_display_names  |agentDisplayNames   |agentDisplayNames   |
|available            |bool                |available           |
|statistics_yesterday |statisticsYesterday |statisticsYesterday |
|statistics_today     |statisticsToday     |statisticsToday     |
</div>


## `CallCenterAgentStatistics14sp9`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains Call Center statistics for a specified agent.


**Attributes:**

|Name                |Type              |Description       |
|--------------------|------------------|------------------|
|agent_user_id       |str               |agentUserId       |
|agent_display_names |agentDisplayNames |agentDisplayNames |
|available           |bool              |available         |
|statistics          |statistics        |statistics        |
</div>


## `CallCenterAnnouncementFileListModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains a list of audio or video files to modify.


**Attributes:**

|Name  |Type  |Description      |
|------|------|-----------------|
|file1 |file1 |file1 *Optional* |
|file2 |file2 |file2 *Optional* |
|file3 |file3 |file3 *Optional* |
|file4 |file4 |file4 *Optional* |
</div>


## `CallCenterAnnouncementFileListModify20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains a list of announcement repository files

**Attributes:**

|Name  |Type  |Description      |
|------|------|-----------------|
|file1 |file1 |file1 *Optional* |
|file2 |file2 |file2 *Optional* |
|file3 |file3 |file3 *Optional* |
|file4 |file4 |file4 *Optional* |
</div>


## `CallCenterAnnouncementFileListRead20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains a list of announcement repository files

**Attributes:**

|Name  |Type  |Description      |
|------|------|-----------------|
|file1 |file1 |file1 *Optional* |
|file2 |file2 |file2 *Optional* |
|file3 |file3 |file3 *Optional* |
|file4 |file4 |file4 *Optional* |
</div>


## `CallCenterReplacementSkilledAgents`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of agents grouped by skill levels.


**Attributes:**

|Name        |Type   |Description|
|------------|-------|-----------|
|skill_level |int    |skillLevel |
|agents      |agents |agents     |
</div>


## `CallCenterReportIntervalDates`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The call center enhanced reporting report interval, using dates.


**Attributes:**

|Name       |Type      |Description|
|-----------|----------|-----------|
|start_date |str       |startDate  |
|start_time |startTime |startTime  |
|end_date   |str       |endDate    |
|end_time   |endTime   |endTime    |
</div>


## `CallCenterReportScheduleRecurrence`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A recurring schedule for call center enhanced reporting scheduled report.


**Attributes:**

|Name          |Type         |Description  |
|--------------|-------------|-------------|
|time_zone     |str          |timeZone     |
|start_date    |str          |startDate    |
|schedule_time |scheduleTime |scheduleTime |
|recurrence    |recurrence   |recurrence   |
</div>


## `CallCenterReportScheduleTime`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A scheduled time for call center enhanced reporting scheduled report.


**Attributes:**

|Name          |Type         |Description  |
|--------------|-------------|-------------|
|time_zone     |str          |timeZone     |
|schedule_date |str          |scheduleDate |
|schedule_time |scheduleTime |scheduleTime |
</div>


## `CallMeNowToDnCriteriaModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The To dn criteria used on the call me now external number to be modified.


**Attributes:**

|Name                     |Type            |Description                      |
|-------------------------|----------------|---------------------------------|
|to_dn_criteria_selection |str             |toDnCriteriaSelection *Optional* |
|phone_number_list        |phoneNumberList |phoneNumberList *Optional*       |
</div>


## `CombinedAccessDeviceMultipleIdentityEndpointAdd`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point used in the context of add.

The endpoint is identified by its linePort (public Identity) and possibly a private
Identity.  Only Static Registration capable devices may have more than one contact
defined.  Port numbers are only used by devices with static line ordering.  In the
case an access device referenced by accessDevice does not exist, the device will be
added.  The device attributes deviceType, protocol, netAddress, port,
outboundProxyServerNetAddress, stunServerNetAddress, macAddress, serialNumber,
description, physicalLocation, transportProtocol, useCustomUserNamePassword and
accessDeviceCredentials will be ignored if the access device already exists.

**Attributes:**

|Name                              |Type                    |Description                              |
|----------------------------------|------------------------|-----------------------------------------|
|access_device                     |accessDevice            |accessDevice                             |
|line_port                         |str                     |linePort                                 |
|private_identity                  |str                     |privateIdentity *Optional*               |
|contact                           |str                     |contact *Optional*                       |
|port_number                       |int                     |portNumber *Optional*                    |
|device_type                       |str                     |deviceType *Optional*                    |
|protocol                          |str                     |protocol *Optional*                      |
|net_address                       |str                     |netAddress *Optional*                    |
|port                              |int                     |port *Optional*                          |
|outbound_proxy_server_net_address |str                     |outboundProxyServerNetAddress *Optional* |
|stun_server_net_address           |str                     |stunServerNetAddress *Optional*          |
|mac_address                       |str                     |macAddress *Optional*                    |
|serial_number                     |str                     |serialNumber *Optional*                  |
|description                       |str                     |description *Optional*                   |
|physical_location                 |str                     |physicalLocation *Optional*              |
|transport_protocol                |str                     |transportProtocol *Optional*             |
|use_custom_user_name_password     |bool                    |useCustomUserNamePassword *Optional*     |
|access_device_credentials         |accessDeviceCredentials |accessDeviceCredentials *Optional*       |
</div>


## `CombinedAccessDeviceMultipleIdentityEndpointModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point used in the context of modify.

The endpoint is identified by its linePort (public Identity) and possibly a private
Identity.  Only Static Registration capable devices may have more than one contact
defined.  Port numbers are only used by devices with static line ordering.  In the
case an access device referenced by accessDevice does not exist, the device will be
added.  When the device needs to be added, if the linePort is not specified, the
request will fail The device attributes deviceType, protocol, netAddress, port,
outboundProxyServerNetAddress, stunServerNetAddress, macAddress, serialNumber,
description, physicalLocation, transportProtocol, useCustomUserNamePassword and
accessDeviceCredentials will be ignored if the access device already exists.

**Attributes:**

|Name                              |Type                    |Description                              |
|----------------------------------|------------------------|-----------------------------------------|
|access_device                     |accessDevice            |accessDevice *Optional*                  |
|line_port                         |str                     |linePort *Optional*                      |
|private_identity                  |str                     |privateIdentity *Optional*               |
|contact                           |str                     |contact *Optional*                       |
|port_number                       |int                     |portNumber *Optional*                    |
|device_type                       |str                     |deviceType *Optional*                    |
|protocol                          |str                     |protocol *Optional*                      |
|net_address                       |str                     |netAddress *Optional*                    |
|port                              |int                     |port *Optional*                          |
|outbound_proxy_server_net_address |str                     |outboundProxyServerNetAddress *Optional* |
|stun_server_net_address           |str                     |stunServerNetAddress *Optional*          |
|mac_address                       |str                     |macAddress *Optional*                    |
|serial_number                     |str                     |serialNumber *Optional*                  |
|description                       |str                     |description *Optional*                   |
|physical_location                 |str                     |physicalLocation *Optional*              |
|transport_protocol                |str                     |transportProtocol *Optional*             |
|use_custom_user_name_password     |bool                    |useCustomUserNamePassword *Optional*     |
|access_device_credentials         |accessDeviceCredentials |accessDeviceCredentials *Optional*       |
</div>


## `CombinedGroupServiceAuthorization`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Authorize a group service.


**Attributes:**

|Name                |Type               |Description                   |
|--------------------|-------------------|------------------------------|
|service_name        |str                |serviceName                   |
|authorized_quantity |authorizedQuantity |authorizedQuantity *Optional* |
</div>


## `CombinedServiceInstanceAddProfile`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Service Profile Information for group service.

When name, callingLineIdLastName and callingLineIdFirstName are not included, the
values in the corresponding service instance template (if this is used to add a Hunt
Group, for example, the name will come from the Hunt Group template) will be used.
Otherwise, the request will fail.  If the phoneNumber has not been assigned to the
group, it will be added to group and service provider if needed.

**Attributes:**

|Name                         |Type       |Description                         |
|-----------------------------|-----------|------------------------------------|
|name                         |str        |name *Optional*                     |
|calling_line_id_last_name    |str        |callingLineIdLastName *Optional*    |
|calling_line_id_first_name   |str        |callingLineIdFirstName *Optional*   |
|hiragana_last_name           |str        |hiraganaLastName *Optional*         |
|hiragana_first_name          |str        |hiraganaFirstName *Optional*        |
|phone_number                 |str        |phoneNumber *Optional*              |
|extension                    |str        |extension *Optional*                |
|password                     |str        |password *Optional*                 |
|department                   |department |department *Optional*               |
|language                     |str        |language *Optional*                 |
|time_zone                    |str        |timeZone *Optional*                 |
|alias                        |List[str]  |alias *Optional*                    |
|public_user_identity         |str        |publicUserIdentity *Optional*       |
|calling_line_id_phone_number |str        |callingLineIdPhoneNumber *Optional* |
</div>


## `CombinedServicePackAssignment`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Assign a service pack to user.

If the service pack has not been authorized to service provider or group, it will be
authorized.  If the service pack needs to be authorized at group/service provider
levels, the authorizedQuantity will be used.  Otherwise, it will be ignored.  If the
authorizedQuantity is not included, the quantity will come from the group template for
the service pack.  If a template does not exist, the service quantity will be set to
unlimited.

**Attributes:**

|Name                |Type               |Description                   |
|--------------------|-------------------|------------------------------|
|service_pack_name   |str                |servicePackName               |
|authorized_quantity |authorizedQuantity |authorizedQuantity *Optional* |
</div>


## `CombinedServicePackAuthorization`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Authorize a service pack.


**Attributes:**

|Name                |Type               |Description                   |
|--------------------|-------------------|------------------------------|
|service_pack_name   |str                |servicePackName               |
|authorized_quantity |authorizedQuantity |authorizedQuantity *Optional* |
</div>


## `CombinedSharedCallAppearanceAccessDeviceMultipleIdentityEndpoint`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point for Shared Call Appearance Service used in the context of add.

The endpoint is identified by its linePort (public Identity) and possibly a private
Identity.  Port numbers are only used by devices with static line ordering.  In the
case an access device referenced by accessDevice does not exist, the device will be
added.  When elements for isActive, allowOrigination, allowTermination and allowVideo
are not included in the request, the values for them will come for the Shared Call
Appearance endpoints template.  If the template does not exist, the request using this
data type will fail.  The device attributes deviceType, protocol, netAddress, port,
outboundProxyServerNetAddress, stunServerNetAddress, macAddress, serialNumber,
description, physicalLocation, transportProtocol, useCustomUserNamePassword and
accessDeviceCredentials will be ignored if the access device already exists.

**Attributes:**

|Name                              |Type                    |Description                              |
|----------------------------------|------------------------|-----------------------------------------|
|access_device                     |accessDevice            |accessDevice                             |
|line_port                         |str                     |linePort                                 |
|private_identity                  |str                     |privateIdentity *Optional*               |
|contact                           |str                     |contact *Optional*                       |
|port_number                       |int                     |portNumber *Optional*                    |
|is_active                         |bool                    |isActive *Optional*                      |
|allow_origination                 |bool                    |allowOrigination *Optional*              |
|allow_termination                 |bool                    |allowTermination *Optional*              |
|allow_video                       |bool                    |allowVideo *Optional*                    |
|device_type                       |str                     |deviceType *Optional*                    |
|protocol                          |str                     |protocol *Optional*                      |
|net_address                       |str                     |netAddress *Optional*                    |
|port                              |int                     |port *Optional*                          |
|outbound_proxy_server_net_address |str                     |outboundProxyServerNetAddress *Optional* |
|stun_server_net_address           |str                     |stunServerNetAddress *Optional*          |
|mac_address                       |str                     |macAddress *Optional*                    |
|serial_number                     |str                     |serialNumber *Optional*                  |
|description                       |str                     |description *Optional*                   |
|physical_location                 |str                     |physicalLocation *Optional*              |
|transport_protocol                |str                     |transportProtocol *Optional*             |
|use_custom_user_name_password     |bool                    |useCustomUserNamePassword *Optional*     |
|access_device_credentials         |accessDeviceCredentials |accessDeviceCredentials *Optional*       |
</div>


## `CombinedUserServiceAssignment`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Assign a service user.

If the service has not been authorized to service provider or group, it will be
authorized.  If the service needs to be authorized at group/service provider levels,
the authorizedQuantity will be used.  Otherwise, it will be ignored.  If the
authorizedQuantity is not included, the quantity will come from the group template for
the service.  If a template does not exist, the service quantity will be set to
unlimited.

**Attributes:**

|Name                |Type               |Description                   |
|--------------------|-------------------|------------------------------|
|user_service        |str                |userService                   |
|authorized_quantity |authorizedQuantity |authorizedQuantity *Optional* |
</div>


## `CombinedUserServiceAuthorization`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Authorize a user service.


**Attributes:**

|Name                |Type               |Description                   |
|--------------------|-------------------|------------------------------|
|service_name        |str                |serviceName                   |
|authorized_quantity |authorizedQuantity |authorizedQuantity *Optional* |
</div>


## `CommPilotExpressAvailableInOffice`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CommPilot Express Available In Office Settings.


**Attributes:**

|Name                            |Type            |Description                            |
|--------------------------------|----------------|---------------------------------------|
|additional_phone_number_to_ring |str             |additionalPhoneNumberToRing *Optional* |
|busy_setting                    |busySetting     |busySetting                            |
|no_answer_setting               |noAnswerSetting |noAnswerSetting                        |
</div>


## `CommPilotExpressAvailableInOfficeModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CommPilot Express Available In Office Settings.


**Attributes:**

|Name                            |Type            |Description                            |
|--------------------------------|----------------|---------------------------------------|
|additional_phone_number_to_ring |str             |additionalPhoneNumberToRing *Optional* |
|busy_setting                    |busySetting     |busySetting *Optional*                 |
|no_answer_setting               |noAnswerSetting |noAnswerSetting *Optional*             |
</div>


## `CommPilotExpressAvailableOutOfOffice`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CommPilot Express Available Out Of Office Configuration used in the context of a get.


**Attributes:**

|Name                 |Type               |Description        |
|---------------------|-------------------|-------------------|
|incoming_calls       |incomingCalls      |incomingCalls      |
|incoming_call_notify |incomingCallNotify |incomingCallNotify |
</div>


## `CommPilotExpressAvailableOutOfOfficeModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CommPilot Express Available Out Of Office Configuration used in the context of a
modify.


**Attributes:**

|Name                 |Type               |Description                   |
|---------------------|-------------------|------------------------------|
|incoming_calls       |incomingCalls      |incomingCalls *Optional*      |
|incoming_call_notify |incomingCallNotify |incomingCallNotify *Optional* |
</div>


## `CommPilotExpressBusy`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CommPilot Express Available In Office Configuration used in the context of a get.


**Attributes:**

|Name              |Type            |Description     |
|------------------|----------------|----------------|
|incoming_calls    |incomingCalls   |incomingCalls   |
|voice_mail_notify |voiceMailNotify |voiceMailNotify |
</div>


## `CommPilotExpressBusyModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CommPilot Express Available In Office Configuration used in the context of a modify.


**Attributes:**

|Name              |Type            |Description                |
|------------------|----------------|---------------------------|
|incoming_calls    |incomingCalls   |incomingCalls *Optional*   |
|voice_mail_notify |voiceMailNotify |voiceMailNotify *Optional* |
</div>


## `CommPilotExpressUnavailable`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CommPilot Express Unavailable Configuration used in the context of a get.


**Attributes:**

|Name                |Type          |Description       |
|--------------------|--------------|------------------|
|incoming_calls      |incomingCalls |incomingCalls     |
|voice_mail_greeting |str           |voiceMailGreeting |
</div>


## `CommPilotExpressUnavailableModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CommPilot Express Unavailable Configuration used in the context of a modify.


**Attributes:**

|Name                |Type          |Description                  |
|--------------------|--------------|-----------------------------|
|incoming_calls      |incomingCalls |incomingCalls *Optional*     |
|voice_mail_greeting |str           |voiceMailGreeting *Optional* |
</div>


## `ConsolidatedAccessDeviceMultipleIdentityEndpointAndContactAdd`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point used in the context of add.

The endpoint is identified by its linePort (public Identity) and possibly a private
Identity.  In XS data mode, only one contact can be defined.  Only Static Registration
capable devices may have more than one contact defined.  Port numbers are only used by
devices with static line ordering.  In the case an access device referenced by
accessDevice does not exist, the device will be added.  The device attributes
deviceType, protocol, netAddress, port, outboundProxyServerNetAddress,
stunServerNetAddress, macAddress, serialNumber, description, physicalLocation,
transportProtocol, useCustomUserNamePassword and accessDeviceCredentials will be
ignored if the access device already exists.

**Attributes:**

|Name                              |Type                    |Description                              |
|----------------------------------|------------------------|-----------------------------------------|
|access_device                     |accessDevice            |accessDevice                             |
|line_port                         |str                     |linePort                                 |
|private_identity                  |str                     |privateIdentity *Optional*               |
|contact                           |List[str]               |contact *Optional*                       |
|port_number                       |int                     |portNumber *Optional*                    |
|device_type                       |str                     |deviceType *Optional*                    |
|protocol                          |str                     |protocol *Optional*                      |
|net_address                       |str                     |netAddress *Optional*                    |
|port                              |int                     |port *Optional*                          |
|outbound_proxy_server_net_address |str                     |outboundProxyServerNetAddress *Optional* |
|stun_server_net_address           |str                     |stunServerNetAddress *Optional*          |
|mac_address                       |str                     |macAddress *Optional*                    |
|serial_number                     |str                     |serialNumber *Optional*                  |
|description                       |str                     |description *Optional*                   |
|physical_location                 |str                     |physicalLocation *Optional*              |
|transport_protocol                |str                     |transportProtocol *Optional*             |
|use_custom_user_name_password     |bool                    |useCustomUserNamePassword *Optional*     |
|access_device_credentials         |accessDeviceCredentials |accessDeviceCredentials *Optional*       |
</div>


## `ConsolidatedAccessDeviceMultipleIdentityEndpointAndContactAdd22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point used in the context of add.

The endpoint is identified by its linePort (public Identity) and possibly a private
Identity.  In XS data mode, only one contact can be defined.  Only Static Registration
capable devices may have more than one contact defined.  Port numbers are only used by
devices with static line ordering.  In the case an access device referenced by
accessDevice does not exist, the device will be added.  The device attributes
deviceType, protocol, netAddress, port, outboundProxyServerNetAddress,
stunServerNetAddress, macAddress, serialNumber, description, physicalLocation,
transportProtocol, useCustomUserNamePassword and accessDeviceCredentials will be
ignored if the access device already exists.  The following elements are only used in
AS data mode and ignored in XS data mode: useHotline, use value false in XS data mode
hotlineContact

**Attributes:**

|Name                              |Type                    |Description                              |
|----------------------------------|------------------------|-----------------------------------------|
|access_device                     |accessDevice            |accessDevice                             |
|line_port                         |str                     |linePort                                 |
|private_identity                  |str                     |privateIdentity *Optional*               |
|contact                           |List[str]               |contact *Optional*                       |
|port_number                       |int                     |portNumber *Optional*                    |
|device_type                       |str                     |deviceType *Optional*                    |
|protocol                          |str                     |protocol *Optional*                      |
|net_address                       |str                     |netAddress *Optional*                    |
|port                              |int                     |port *Optional*                          |
|outbound_proxy_server_net_address |str                     |outboundProxyServerNetAddress *Optional* |
|stun_server_net_address           |str                     |stunServerNetAddress *Optional*          |
|mac_address                       |str                     |macAddress *Optional*                    |
|serial_number                     |str                     |serialNumber *Optional*                  |
|description                       |str                     |description *Optional*                   |
|physical_location                 |str                     |physicalLocation *Optional*              |
|transport_protocol                |str                     |transportProtocol *Optional*             |
|use_custom_user_name_password     |bool                    |useCustomUserNamePassword *Optional*     |
|access_device_credentials         |accessDeviceCredentials |accessDeviceCredentials *Optional*       |
|use_hotline                       |bool                    |useHotline                               |
|hotline_contact                   |str                     |hotlineContact *Optional*                |
</div>


## `ConsolidatedAccessDeviceMultipleIdentityEndpointAndContactModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point used in the context of modify.

. The endpoint is identified by its linePort (public Identity) and possibly a private
Identity.  Only Static Registration capable devices may have more than one contact
defined.  Only the first contact in contactList is used in XS data mode.  Port numbers
are only used by devices with static line ordering.  In the case an access device
referenced by accessDevice does not exist, the device will be added.  When the device
needs to be added, if the linePort is not specified, the request will fail If the
deviceType is included in the request a new device will be created using the type
unless a device with the same name already exists.  The device attributes protocol,
netAddress, port, outboundProxyServerNetAddress, stunServerNetAddress, macAddress,
serialNumber, description, physicalLocation, transportProtocol,
useCustomUserNamePassword and accessDeviceCredentials will be ignored if the access
device already exists.  The following elements are only used in AS data mode and
ignored in XS data mode: useHotline hotlineContact

**Attributes:**

|Name                              |Type                    |Description                              |
|----------------------------------|------------------------|-----------------------------------------|
|access_device                     |accessDevice            |accessDevice *Optional*                  |
|line_port                         |str                     |linePort *Optional*                      |
|private_identity                  |str                     |privateIdentity *Optional*               |
|contact_list                      |contactList             |contactList *Optional*                   |
|port_number                       |int                     |portNumber *Optional*                    |
|device_type                       |str                     |deviceType *Optional*                    |
|protocol                          |str                     |protocol *Optional*                      |
|net_address                       |str                     |netAddress *Optional*                    |
|port                              |int                     |port *Optional*                          |
|outbound_proxy_server_net_address |str                     |outboundProxyServerNetAddress *Optional* |
|stun_server_net_address           |str                     |stunServerNetAddress *Optional*          |
|mac_address                       |str                     |macAddress *Optional*                    |
|serial_number                     |str                     |serialNumber *Optional*                  |
|description                       |str                     |description *Optional*                   |
|physical_location                 |str                     |physicalLocation *Optional*              |
|transport_protocol                |str                     |transportProtocol *Optional*             |
|use_custom_user_name_password     |bool                    |useCustomUserNamePassword *Optional*     |
|access_device_credentials         |accessDeviceCredentials |accessDeviceCredentials *Optional*       |
|use_hotline                       |bool                    |useHotline *Optional*                    |
|hotline_contact                   |str                     |hotlineContact *Optional*                |
</div>


## `ConsolidatedGroupServiceAssignment`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Authorize and assign a group service.

The authorizedQuantity will be used at the group level if provided; otherwise, the
service quantity will be set to unlimited.  The command will fail if the authorized
quantity set at the service provider level is insufficient.

**Attributes:**

|Name                |Type               |Description                   |
|--------------------|-------------------|------------------------------|
|group_service_name  |str                |groupServiceName              |
|authorized_quantity |authorizedQuantity |authorizedQuantity *Optional* |
</div>


## `ConsolidatedServicePackAssignment`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Assign a service pack to user.

If the service pack has not been authorized to the group, it will be authorized.  The
authorizedQuantity will be used at the group level if provided; otherwise, the service
quantity will be set to unlimited.  The command will fail if the authorized quantity
set at the service provider level is insufficient.

**Attributes:**

|Name                |Type               |Description                   |
|--------------------|-------------------|------------------------------|
|service_pack_name   |str                |servicePackName               |
|authorized_quantity |authorizedQuantity |authorizedQuantity *Optional* |
</div>


## `ConsolidatedSharedCallAppearanceAccessDeviceMultipleIdentityEndpoint`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point for Shared Call Appearance Service used in the context of add.

The endpoint is identified by its linePort (public Identity) and possibly a private
Identity.  Port numbers are only used by devices with static line ordering.  In the
case an access device referenced by accessDevice does not exist, the device will be
added.  The device attributes deviceType, protocol, netAddress, port,
outboundProxyServerNetAddress, stunServerNetAddress, macAddress, serialNumber,
description, physicalLocation, transportProtocol, useCustomUserNamePassword and
accessDeviceCredentials will be ignored if the access device already exists.  The
following elements are only used in XS data mode and ignored in AS data mode:
privateIdentity

**Attributes:**

|Name                              |Type                    |Description                              |
|----------------------------------|------------------------|-----------------------------------------|
|access_device                     |accessDevice            |accessDevice                             |
|line_port                         |str                     |linePort                                 |
|private_identity                  |str                     |privateIdentity *Optional*               |
|contact                           |str                     |contact *Optional*                       |
|port_number                       |int                     |portNumber *Optional*                    |
|is_active                         |bool                    |isActive                                 |
|allow_origination                 |bool                    |allowOrigination                         |
|allow_termination                 |bool                    |allowTermination                         |
|device_type                       |str                     |deviceType *Optional*                    |
|protocol                          |str                     |protocol *Optional*                      |
|net_address                       |str                     |netAddress *Optional*                    |
|port                              |int                     |port *Optional*                          |
|outbound_proxy_server_net_address |str                     |outboundProxyServerNetAddress *Optional* |
|stun_server_net_address           |str                     |stunServerNetAddress *Optional*          |
|mac_address                       |str                     |macAddress *Optional*                    |
|serial_number                     |str                     |serialNumber *Optional*                  |
|description                       |str                     |description *Optional*                   |
|physical_location                 |str                     |physicalLocation *Optional*              |
|transport_protocol                |str                     |transportProtocol *Optional*             |
|use_custom_user_name_password     |bool                    |useCustomUserNamePassword *Optional*     |
|access_device_credentials         |accessDeviceCredentials |accessDeviceCredentials *Optional*       |
|use_hotline                       |bool                    |useHotline *Optional*                    |
|hotline_contact                   |str                     |hotlineContact *Optional*                |
</div>


## `ConsolidatedSharedCallAppearanceAccessDeviceMultipleIdentityEndpointAdd22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point for Shared Call Appearance Service used in the context of add.

The endpoint is identified by its linePort (public Identity) and possibly a private
Identity.  Port numbers are only used by devices with static line ordering.  In the
case an access device referenced by accessDevice does not exist, the device will be
added.  The device attributes deviceType, protocol, netAddress, port,
outboundProxyServerNetAddress, stunServerNetAddress, macAddress, serialNumber,
description, physicalLocation, transportProtocol, useCustomUserNamePassword and
accessDeviceCredentials will be ignored if the access device already exists.  The
following elements are only used in XS data mode and ignored in AS data mode:
privateIdentity The following elements are only used in AS data mode and ignored in XS
data mode: useHotline, use value false in XS data mode hotlineContact

**Attributes:**

|Name                              |Type                    |Description                              |
|----------------------------------|------------------------|-----------------------------------------|
|access_device                     |accessDevice            |accessDevice                             |
|line_port                         |str                     |linePort                                 |
|private_identity                  |str                     |privateIdentity *Optional*               |
|contact                           |str                     |contact *Optional*                       |
|port_number                       |int                     |portNumber *Optional*                    |
|is_active                         |bool                    |isActive                                 |
|allow_origination                 |bool                    |allowOrigination                         |
|allow_termination                 |bool                    |allowTermination                         |
|device_type                       |str                     |deviceType *Optional*                    |
|protocol                          |str                     |protocol *Optional*                      |
|net_address                       |str                     |netAddress *Optional*                    |
|port                              |int                     |port *Optional*                          |
|outbound_proxy_server_net_address |str                     |outboundProxyServerNetAddress *Optional* |
|stun_server_net_address           |str                     |stunServerNetAddress *Optional*          |
|mac_address                       |str                     |macAddress *Optional*                    |
|serial_number                     |str                     |serialNumber *Optional*                  |
|description                       |str                     |description *Optional*                   |
|physical_location                 |str                     |physicalLocation *Optional*              |
|transport_protocol                |str                     |transportProtocol *Optional*             |
|use_custom_user_name_password     |bool                    |useCustomUserNamePassword *Optional*     |
|access_device_credentials         |accessDeviceCredentials |accessDeviceCredentials *Optional*       |
|use_hotline                       |bool                    |useHotline                               |
|hotline_contact                   |str                     |hotlineContact *Optional*                |
</div>


## `ConsolidatedUserServiceAssignment`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Assign a user service.

If the service has not been authorized to the group, it will be authorized.  The
authorizedQuantity will be used at the group level if provided; otherwise, the service
quantity will be set to unlimited.  The command will fail if the authorized quantity
set at the service provider level is insufficient.

**Attributes:**

|Name                |Type               |Description                   |
|--------------------|-------------------|------------------------------|
|user_service_name   |str                |userServiceName               |
|authorized_quantity |authorizedQuantity |authorizedQuantity *Optional* |
</div>


## `CriteriaFromDnModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The from dn criteria used within a modify request.


**Attributes:**

|Name                        |Type            |Description                          |
|----------------------------|----------------|-------------------------------------|
|from_dn_criteria_selection  |str             |fromDnCriteriaSelection *Optional*   |
|include_anonymous_callers   |bool            |includeAnonymousCallers *Optional*   |
|include_unavailable_callers |bool            |includeUnavailableCallers *Optional* |
|phone_number_list           |phoneNumberList |phoneNumberList *Optional*           |
</div>


## `DeviceManagementDeviceTypeModifyOptions`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Device Management System device type options during a modify request.


**Attributes:**

|Name                                   |Type                    |Description                                   |
|---------------------------------------|------------------------|----------------------------------------------|
|device_access_protocol                 |str                     |deviceAccessProtocol *Optional*               |
|tag_mode                               |str                     |tagMode *Optional*                            |
|tag_set                                |str                     |tagSet *Optional*                             |
|allow_device_profile_custom_tag_set    |bool                    |allowDeviceProfileCustomTagSet *Optional*     |
|allow_group_custom_tag_set             |bool                    |allowGroupCustomTagSet *Optional*             |
|send_email_upon_reset_failure          |bool                    |sendEmailUponResetFailure *Optional*          |
|device_access_net_address              |str                     |deviceAccessNetAddress *Optional*             |
|device_access_port                     |int                     |deviceAccessPort *Optional*                   |
|device_access_context                  |str                     |deviceAccessContext *Optional*                |
|default_device_language                |str                     |defaultDeviceLanguage *Optional*              |
|default_device_encoding                |str                     |defaultDeviceEncoding *Optional*              |
|access_device_credentials              |accessDeviceCredentials |accessDeviceCredentials *Optional*            |
|use_http_digest_authentication         |bool                    |useHttpDigestAuthentication *Optional*        |
|mac_based_file_authentication          |bool                    |macBasedFileAuthentication *Optional*         |
|user_name_password_file_authentication |bool                    |userNamePasswordFileAuthentication *Optional* |
|mac_in_non_request_uri                 |bool                    |macInNonRequestURI *Optional*                 |
|mac_format_in_non_request_uri          |str                     |macFormatInNonRequestURI *Optional*           |
</div>


## `DeviceManagementDeviceTypeModifyOptions16`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Device Management System device type options during a modify request.


**Attributes:**

|Name                                   |Type                    |Description                                   |
|---------------------------------------|------------------------|----------------------------------------------|
|device_access_protocol                 |str                     |deviceAccessProtocol *Optional*               |
|tag_mode                               |str                     |tagMode *Optional*                            |
|tag_set                                |str                     |tagSet *Optional*                             |
|allow_device_profile_custom_tag_set    |bool                    |allowDeviceProfileCustomTagSet *Optional*     |
|allow_group_custom_tag_set             |bool                    |allowGroupCustomTagSet *Optional*             |
|allow_sp_custom_tag_set                |bool                    |allowSpCustomTagSet *Optional*                |
|send_email_upon_reset_failure          |bool                    |sendEmailUponResetFailure *Optional*          |
|device_access_net_address              |str                     |deviceAccessNetAddress *Optional*             |
|device_access_port                     |int                     |deviceAccessPort *Optional*                   |
|device_access_context                  |str                     |deviceAccessContext *Optional*                |
|default_device_language                |str                     |defaultDeviceLanguage *Optional*              |
|default_device_encoding                |str                     |defaultDeviceEncoding *Optional*              |
|access_device_credentials              |accessDeviceCredentials |accessDeviceCredentials *Optional*            |
|use_http_digest_authentication         |bool                    |useHttpDigestAuthentication *Optional*        |
|mac_based_file_authentication          |bool                    |macBasedFileAuthentication *Optional*         |
|user_name_password_file_authentication |bool                    |userNamePasswordFileAuthentication *Optional* |
|mac_in_non_request_uri                 |bool                    |macInNonRequestURI *Optional*                 |
|mac_in_cert                            |bool                    |macInCert *Optional*                          |
|mac_format_in_non_request_uri          |str                     |macFormatInNonRequestURI *Optional*           |
</div>


## `DeviceManagementDeviceTypeModifyOptions22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Device Management System device type options during a modify request.

The following data elements are only used in AS data mode and ignored in XS data mode:
enableDeviceActivation deviceModel

**Attributes:**

|Name                                   |Type                    |Description                                   |
|---------------------------------------|------------------------|----------------------------------------------|
|device_access_protocol                 |str                     |deviceAccessProtocol *Optional*               |
|tag_mode                               |str                     |tagMode *Optional*                            |
|tag_set                                |str                     |tagSet *Optional*                             |
|allow_device_profile_custom_tag_set    |bool                    |allowDeviceProfileCustomTagSet *Optional*     |
|allow_group_custom_tag_set             |bool                    |allowGroupCustomTagSet *Optional*             |
|allow_sp_custom_tag_set                |bool                    |allowSpCustomTagSet *Optional*                |
|send_email_upon_reset_failure          |bool                    |sendEmailUponResetFailure *Optional*          |
|device_access_net_address              |str                     |deviceAccessNetAddress *Optional*             |
|device_access_port                     |int                     |deviceAccessPort *Optional*                   |
|device_access_context                  |str                     |deviceAccessContext *Optional*                |
|default_device_language                |str                     |defaultDeviceLanguage *Optional*              |
|default_device_encoding                |str                     |defaultDeviceEncoding *Optional*              |
|access_device_credentials              |accessDeviceCredentials |accessDeviceCredentials *Optional*            |
|use_http_digest_authentication         |bool                    |useHttpDigestAuthentication *Optional*        |
|mac_based_file_authentication          |bool                    |macBasedFileAuthentication *Optional*         |
|user_name_password_file_authentication |bool                    |userNamePasswordFileAuthentication *Optional* |
|mac_in_non_request_uri                 |bool                    |macInNonRequestURI *Optional*                 |
|mac_in_cert                            |bool                    |macInCert *Optional*                          |
|mac_format_in_non_request_uri          |str                     |macFormatInNonRequestURI *Optional*           |
|enable_device_activation               |bool                    |enableDeviceActivation *Optional*             |
|device_model                           |str                     |deviceModel *Optional*                        |
</div>


## `DeviceManagementDeviceTypeOptions`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Device Management System device type options.


**Attributes:**

|Name                                   |Type                    |Description                         |
|---------------------------------------|------------------------|------------------------------------|
|device_access_protocol                 |str                     |deviceAccessProtocol                |
|tag_mode                               |str                     |tagMode                             |
|tag_set                                |str                     |tagSet *Optional*                   |
|allow_device_profile_custom_tag_set    |bool                    |allowDeviceProfileCustomTagSet      |
|allow_group_custom_tag_set             |bool                    |allowGroupCustomTagSet              |
|send_email_upon_reset_failure          |bool                    |sendEmailUponResetFailure           |
|device_access_net_address              |str                     |deviceAccessNetAddress *Optional*   |
|device_access_port                     |int                     |deviceAccessPort *Optional*         |
|device_access_context                  |str                     |deviceAccessContext *Optional*      |
|device_access_uri                      |str                     |deviceAccessURI *Optional*          |
|default_device_language                |str                     |defaultDeviceLanguage *Optional*    |
|default_device_encoding                |str                     |defaultDeviceEncoding *Optional*    |
|access_device_credentials              |accessDeviceCredentials |accessDeviceCredentials *Optional*  |
|use_http_digest_authentication         |bool                    |useHttpDigestAuthentication         |
|mac_based_file_authentication          |bool                    |macBasedFileAuthentication          |
|user_name_password_file_authentication |bool                    |userNamePasswordFileAuthentication  |
|mac_in_non_request_uri                 |bool                    |macInNonRequestURI                  |
|mac_format_in_non_request_uri          |str                     |macFormatInNonRequestURI *Optional* |
</div>


## `DeviceManagementDeviceTypeOptions16`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Device Management System device type options.


**Attributes:**

|Name                                   |Type                    |Description                         |
|---------------------------------------|------------------------|------------------------------------|
|device_access_protocol                 |str                     |deviceAccessProtocol                |
|tag_mode                               |str                     |tagMode                             |
|tag_set                                |str                     |tagSet *Optional*                   |
|allow_device_profile_custom_tag_set    |bool                    |allowDeviceProfileCustomTagSet      |
|allow_group_custom_tag_set             |bool                    |allowGroupCustomTagSet              |
|send_email_upon_reset_failure          |bool                    |sendEmailUponResetFailure           |
|device_access_net_address              |str                     |deviceAccessNetAddress *Optional*   |
|device_access_port                     |int                     |deviceAccessPort *Optional*         |
|device_access_context                  |str                     |deviceAccessContext *Optional*      |
|device_access_uri                      |str                     |deviceAccessURI *Optional*          |
|default_device_language                |str                     |defaultDeviceLanguage *Optional*    |
|default_device_encoding                |str                     |defaultDeviceEncoding *Optional*    |
|access_device_credentials              |accessDeviceCredentials |accessDeviceCredentials *Optional*  |
|use_http_digest_authentication         |bool                    |useHttpDigestAuthentication         |
|mac_based_file_authentication          |bool                    |macBasedFileAuthentication          |
|user_name_password_file_authentication |bool                    |userNamePasswordFileAuthentication  |
|mac_in_non_request_uri                 |bool                    |macInNonRequestURI                  |
|mac_format_in_non_request_uri          |str                     |macFormatInNonRequestURI *Optional* |
</div>


## `DeviceManagementDeviceTypeOptions21sp1`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Device Management System device type options.

Note: For the elements listed below, when device configuration is set to
deviceManagement, those elements apply to the creation of the Polycom Phone Services
directory file only.  For all other files, they are not used.  Those elements are
instead configured on a per-file basis at the Device Type File level.  When device
configuration is set to legacy, those elements apply to all configuration files.
useHttpDigestAuthentication macBasedFileAuthentication
userNamePasswordFileAuthentication macInNonRequestURI macInCert
macFormatInNonRequestURI

**Attributes:**

|Name                                   |Type                    |Description                         |
|---------------------------------------|------------------------|------------------------------------|
|device_access_protocol                 |str                     |deviceAccessProtocol                |
|tag_mode                               |str                     |tagMode                             |
|tag_set                                |str                     |tagSet *Optional*                   |
|allow_device_profile_custom_tag_set    |bool                    |allowDeviceProfileCustomTagSet      |
|allow_group_custom_tag_set             |bool                    |allowGroupCustomTagSet              |
|send_email_upon_reset_failure          |bool                    |sendEmailUponResetFailure           |
|device_access_net_address              |str                     |deviceAccessNetAddress *Optional*   |
|device_access_port                     |int                     |deviceAccessPort *Optional*         |
|device_access_context                  |str                     |deviceAccessContext *Optional*      |
|device_access_uri                      |str                     |deviceAccessURI *Optional*          |
|default_device_language                |str                     |defaultDeviceLanguage *Optional*    |
|default_device_encoding                |str                     |defaultDeviceEncoding *Optional*    |
|access_device_credentials              |accessDeviceCredentials |accessDeviceCredentials *Optional*  |
|use_http_digest_authentication         |bool                    |useHttpDigestAuthentication         |
|mac_based_file_authentication          |bool                    |macBasedFileAuthentication          |
|user_name_password_file_authentication |bool                    |userNamePasswordFileAuthentication  |
|mac_in_non_request_uri                 |bool                    |macInNonRequestURI                  |
|mac_in_cert                            |bool                    |macInCert                           |
|mac_format_in_non_request_uri          |str                     |macFormatInNonRequestURI *Optional* |
</div>


## `DeviceManagementDeviceTypeOptions22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Device Management System device type options.

Note: For the elements listed below, when device configuration is set to
deviceManagement, those elements apply to the creation of the Polycom Phone Services
directory file only.  For all other files, they are not used.  Those elements are
instead configured on a per-file basis at the Device Type File level.  When device
configuration is set to legacy, those elements apply to all configuration files.
useHttpDigestAuthentication macBasedFileAuthentication
userNamePasswordFileAuthentication macInNonRequestURI macInCert
macFormatInNonRequestURI

**Attributes:**

|Name                                   |Type                    |Description                         |
|---------------------------------------|------------------------|------------------------------------|
|device_access_protocol                 |str                     |deviceAccessProtocol                |
|tag_mode                               |str                     |tagMode                             |
|tag_set                                |str                     |tagSet *Optional*                   |
|allow_device_profile_custom_tag_set    |bool                    |allowDeviceProfileCustomTagSet      |
|allow_group_custom_tag_set             |bool                    |allowGroupCustomTagSet              |
|allow_sp_custom_tag_set                |bool                    |allowSpCustomTagSet                 |
|send_email_upon_reset_failure          |bool                    |sendEmailUponResetFailure           |
|device_access_net_address              |str                     |deviceAccessNetAddress *Optional*   |
|device_access_port                     |int                     |deviceAccessPort *Optional*         |
|device_access_context                  |str                     |deviceAccessContext *Optional*      |
|device_access_uri                      |str                     |deviceAccessURI *Optional*          |
|default_device_language                |str                     |defaultDeviceLanguage *Optional*    |
|default_device_encoding                |str                     |defaultDeviceEncoding *Optional*    |
|access_device_credentials              |accessDeviceCredentials |accessDeviceCredentials *Optional*  |
|use_http_digest_authentication         |bool                    |useHttpDigestAuthentication         |
|mac_based_file_authentication          |bool                    |macBasedFileAuthentication          |
|user_name_password_file_authentication |bool                    |userNamePasswordFileAuthentication  |
|mac_in_non_request_uri                 |bool                    |macInNonRequestURI                  |
|mac_in_cert                            |bool                    |macInCert                           |
|mac_format_in_non_request_uri          |str                     |macFormatInNonRequestURI *Optional* |
</div>


## `DeviceManagementDeviceTypeOptions22V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Device Management System device type options.

Note: For the elements listed below, when device configuration is set to
deviceManagement, those elements apply to the creation of the Polycom Phone Services
directory file only.  For all other files, they are not used.  Those elements are
instead configured on a per-file basis at the Device Type File level.  When device
configuration is set to legacy, those elements apply to all configuration files.
useHttpDigestAuthentication macBasedFileAuthentication
userNamePasswordFileAuthentication macInNonRequestURI macInCert
macFormatInNonRequestURI

**Attributes:**

|Name                                   |Type                    |Description                         |
|---------------------------------------|------------------------|------------------------------------|
|device_access_protocol                 |str                     |deviceAccessProtocol                |
|tag_mode                               |str                     |tagMode                             |
|tag_set                                |str                     |tagSet *Optional*                   |
|allow_device_profile_custom_tag_set    |bool                    |allowDeviceProfileCustomTagSet      |
|allow_group_custom_tag_set             |bool                    |allowGroupCustomTagSet              |
|allow_sp_custom_tag_set                |bool                    |allowSpCustomTagSet                 |
|send_email_upon_reset_failure          |bool                    |sendEmailUponResetFailure           |
|device_access_net_address              |str                     |deviceAccessNetAddress *Optional*   |
|device_access_port                     |int                     |deviceAccessPort *Optional*         |
|device_access_context                  |str                     |deviceAccessContext *Optional*      |
|device_access_uri                      |str                     |deviceAccessURI *Optional*          |
|default_device_language                |str                     |defaultDeviceLanguage *Optional*    |
|default_device_encoding                |str                     |defaultDeviceEncoding *Optional*    |
|access_device_credentials              |accessDeviceCredentials |accessDeviceCredentials *Optional*  |
|use_http_digest_authentication         |bool                    |useHttpDigestAuthentication         |
|mac_based_file_authentication          |bool                    |macBasedFileAuthentication          |
|user_name_password_file_authentication |bool                    |userNamePasswordFileAuthentication  |
|mac_in_non_request_uri                 |bool                    |macInNonRequestURI                  |
|mac_in_cert                            |bool                    |macInCert                           |
|mac_format_in_non_request_uri          |str                     |macFormatInNonRequestURI *Optional* |
</div>


## `DeviceManagementDeviceTypeOptions22V3`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Device Management System device type options.

Note: For the elements listed below, when device configuration is set to
deviceManagement, those elements apply to the creation of the Polycom Phone Services
directory file only.  For all other files, they are not used.  Those elements are
instead configured on a per-file basis at the Device Type File level.  When device
configuration is set to legacy, those elements apply to all configuration files.
useHttpDigestAuthentication macBasedFileAuthentication
userNamePasswordFileAuthentication macInNonRequestURI macInCert
macFormatInNonRequestURI The following data elements are only used in AS data mode and
ignored in XS data mode: enableDeviceActivation deviceModel

**Attributes:**

|Name                                   |Type                    |Description                         |
|---------------------------------------|------------------------|------------------------------------|
|device_access_protocol                 |str                     |deviceAccessProtocol                |
|tag_mode                               |str                     |tagMode                             |
|tag_set                                |str                     |tagSet *Optional*                   |
|allow_device_profile_custom_tag_set    |bool                    |allowDeviceProfileCustomTagSet      |
|allow_group_custom_tag_set             |bool                    |allowGroupCustomTagSet              |
|allow_sp_custom_tag_set                |bool                    |allowSpCustomTagSet                 |
|send_email_upon_reset_failure          |bool                    |sendEmailUponResetFailure           |
|device_access_net_address              |str                     |deviceAccessNetAddress *Optional*   |
|device_access_port                     |int                     |deviceAccessPort *Optional*         |
|device_access_context                  |str                     |deviceAccessContext *Optional*      |
|device_access_uri                      |str                     |deviceAccessURI *Optional*          |
|default_device_language                |str                     |defaultDeviceLanguage *Optional*    |
|default_device_encoding                |str                     |defaultDeviceEncoding *Optional*    |
|access_device_credentials              |accessDeviceCredentials |accessDeviceCredentials *Optional*  |
|use_http_digest_authentication         |bool                    |useHttpDigestAuthentication         |
|mac_based_file_authentication          |bool                    |macBasedFileAuthentication          |
|user_name_password_file_authentication |bool                    |userNamePasswordFileAuthentication  |
|mac_in_non_request_uri                 |bool                    |macInNonRequestURI                  |
|mac_in_cert                            |bool                    |macInCert                           |
|mac_format_in_non_request_uri          |str                     |macFormatInNonRequestURI *Optional* |
|enable_device_activation               |bool                    |enableDeviceActivation              |
|device_model                           |str                     |deviceModel *Optional*              |
</div>


## `DeviceManagementDeviceTypeOptions22V4`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Device Management System device type options.

Note: For the elements listed below, when device configuration is set to
deviceManagement, those elements apply to the creation of the Polycom Phone Services
directory file only.  For all other files, they are not used.  Those elements are
instead configured on a per-file basis at the Device Type File level.  When device
configuration is set to legacy, those elements apply to all configuration files.
useHttpDigestAuthentication macBasedFileAuthentication
userNamePasswordFileAuthentication macInNonRequestURI macInCert
macFormatInNonRequestURI The following data elements are only used in AS data mode and
ignored in XS data mode: enableDeviceActivation deviceModel supportLinks

**Attributes:**

|Name                                   |Type                    |Description                         |
|---------------------------------------|------------------------|------------------------------------|
|device_access_protocol                 |str                     |deviceAccessProtocol                |
|tag_mode                               |str                     |tagMode                             |
|tag_set                                |str                     |tagSet *Optional*                   |
|allow_device_profile_custom_tag_set    |bool                    |allowDeviceProfileCustomTagSet      |
|allow_group_custom_tag_set             |bool                    |allowGroupCustomTagSet              |
|allow_sp_custom_tag_set                |bool                    |allowSpCustomTagSet                 |
|send_email_upon_reset_failure          |bool                    |sendEmailUponResetFailure           |
|device_access_net_address              |str                     |deviceAccessNetAddress *Optional*   |
|device_access_port                     |int                     |deviceAccessPort *Optional*         |
|device_access_context                  |str                     |deviceAccessContext *Optional*      |
|device_access_uri                      |str                     |deviceAccessURI *Optional*          |
|default_device_language                |str                     |defaultDeviceLanguage *Optional*    |
|default_device_encoding                |str                     |defaultDeviceEncoding *Optional*    |
|access_device_credentials              |accessDeviceCredentials |accessDeviceCredentials *Optional*  |
|use_http_digest_authentication         |bool                    |useHttpDigestAuthentication         |
|mac_based_file_authentication          |bool                    |macBasedFileAuthentication          |
|user_name_password_file_authentication |bool                    |userNamePasswordFileAuthentication  |
|mac_in_non_request_uri                 |bool                    |macInNonRequestURI                  |
|mac_in_cert                            |bool                    |macInCert                           |
|mac_format_in_non_request_uri          |str                     |macFormatInNonRequestURI *Optional* |
|enable_device_activation               |bool                    |enableDeviceActivation              |
|device_model                           |str                     |deviceModel *Optional*              |
|support_links                          |str                     |supportLinks                        |
</div>


## `EnhancedCallLogsNumberFilter`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Filter criteria based on the called number or number called.


**Attributes:**

|Name                                        |Type                                          |Description                                        |
|--------------------------------------------|----------------------------------------------|---------------------------------------------------|
|include_basic_call_type                     |List[str]                                     |includeBasicCallType *Optional*                    |
|include_call_category                       |List[str]                                     |includeCallCategory *Optional*                     |
|include_configurable_call_type              |List[str]                                     |includeConfigurableCallType *Optional*             |
|search_criteria_dialed_number               |List[searchCriteriaDialedNumber]              |searchCriteriaDialedNumber *Optional*              |
|search_criteria_called_number               |List[searchCriteriaCalledNumber]              |searchCriteriaCalledNumber *Optional*              |
|search_criteria_network_translated_number   |List[searchCriteriaNetworkTranslatedNumber]   |searchCriteriaNetworkTranslatedNumber *Optional*   |
|search_criteria_calling_presentation_number |List[searchCriteriaCallingPresentationNumber] |searchCriteriaCallingPresentationNumber *Optional* |
</div>


## `EnhancedCallLogsRedirectedNumberFilter`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Filter criteria based on the transferred/forwarded number.


**Attributes:**

|Name                                                         |Type                                                         |Description                                                       |
|-------------------------------------------------------------|-------------------------------------------------------------|------------------------------------------------------------------|
|redirected_call                                              |redirectedCall                                               |redirectedCall *Optional*                                         |
|include_service_invocation_basic_call_type                   |List[str]                                                    |includeServiceInvocationBasicCallType *Optional*                  |
|include_service_invocation_call_category                     |List[str]                                                    |includeServiceInvocationCallCategory *Optional*                   |
|include_service_invocation_configurable_call_type            |List[str]                                                    |includeServiceInvocationConfigurableCallType *Optional*           |
|search_criteria_service_invocation_dialed_number             |List[searchCriteriaServiceInvocationDialedNumber]            |searchCriteriaServiceInvocationDialedNumber *Optional*            |
|search_criteria_service_invocation_called_number             |List[searchCriteriaServiceInvocationCalledNumber]            |searchCriteriaServiceInvocationCalledNumber *Optional*            |
|search_criteria_service_invocation_network_translated_number |List[searchCriteriaServiceInvocationNetworkTranslatedNumber] |searchCriteriaServiceInvocationNetworkTranslatedNumber *Optional* |
</div>


## `EnhancedCallLogsRedirectedNumberFilter20sp1`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Filter criteria based on the transferred/forwarded number.


**Attributes:**

|Name                                                         |Type                                                         |Description                                                       |
|-------------------------------------------------------------|-------------------------------------------------------------|------------------------------------------------------------------|
|redirected_call                                              |redirectedCall                                               |redirectedCall *Optional*                                         |
|include_service_invocation_basic_call_type                   |List[str]                                                    |includeServiceInvocationBasicCallType *Optional*                  |
|include_service_invocation_call_category                     |List[str]                                                    |includeServiceInvocationCallCategory *Optional*                   |
|include_service_invocation_configurable_call_type            |List[str]                                                    |includeServiceInvocationConfigurableCallType *Optional*           |
|search_criteria_service_invocation_dialed_number             |List[searchCriteriaServiceInvocationDialedNumber]            |searchCriteriaServiceInvocationDialedNumber *Optional*            |
|search_criteria_service_invocation_called_number             |List[searchCriteriaServiceInvocationCalledNumber]            |searchCriteriaServiceInvocationCalledNumber *Optional*            |
|search_criteria_service_invocation_network_translated_number |List[searchCriteriaServiceInvocationNetworkTranslatedNumber] |searchCriteriaServiceInvocationNetworkTranslatedNumber *Optional* |
</div>


## `EnhancedCallLogsRedirectedNumberFilter21`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Filter criteria based on the transferred/forwarded number.


**Attributes:**

|Name                                                         |Type                                                         |Description                                                       |
|-------------------------------------------------------------|-------------------------------------------------------------|------------------------------------------------------------------|
|redirected_call                                              |redirectedCall                                               |redirectedCall *Optional*                                         |
|include_service_invocation_basic_call_type                   |List[str]                                                    |includeServiceInvocationBasicCallType *Optional*                  |
|include_service_invocation_call_category                     |List[str]                                                    |includeServiceInvocationCallCategory *Optional*                   |
|include_service_invocation_configurable_call_type            |List[str]                                                    |includeServiceInvocationConfigurableCallType *Optional*           |
|search_criteria_service_invocation_dialed_number             |List[searchCriteriaServiceInvocationDialedNumber]            |searchCriteriaServiceInvocationDialedNumber *Optional*            |
|search_criteria_service_invocation_called_number             |List[searchCriteriaServiceInvocationCalledNumber]            |searchCriteriaServiceInvocationCalledNumber *Optional*            |
|search_criteria_service_invocation_network_translated_number |List[searchCriteriaServiceInvocationNetworkTranslatedNumber] |searchCriteriaServiceInvocationNetworkTranslatedNumber *Optional* |
</div>


## `EnhancedCallLogsRedirectedNumberFilter21sp1`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Filter criteria based on the transferred/forwarded number.


**Attributes:**

|Name                                                         |Type                                                         |Description                                                       |
|-------------------------------------------------------------|-------------------------------------------------------------|------------------------------------------------------------------|
|redirected_call                                              |redirectedCall                                               |redirectedCall *Optional*                                         |
|include_service_invocation_basic_call_type                   |List[str]                                                    |includeServiceInvocationBasicCallType *Optional*                  |
|include_service_invocation_call_category                     |List[str]                                                    |includeServiceInvocationCallCategory *Optional*                   |
|include_service_invocation_configurable_call_type            |List[str]                                                    |includeServiceInvocationConfigurableCallType *Optional*           |
|search_criteria_service_invocation_dialed_number             |List[searchCriteriaServiceInvocationDialedNumber]            |searchCriteriaServiceInvocationDialedNumber *Optional*            |
|search_criteria_service_invocation_called_number             |List[searchCriteriaServiceInvocationCalledNumber]            |searchCriteriaServiceInvocationCalledNumber *Optional*            |
|search_criteria_service_invocation_network_translated_number |List[searchCriteriaServiceInvocationNetworkTranslatedNumber] |searchCriteriaServiceInvocationNetworkTranslatedNumber *Optional* |
</div>


## `EnhancedCallLogsRedirectedNumberFilter23`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Filter criteria based on the transferred/forwarded number.


**Attributes:**

|Name                                                         |Type                                                         |Description                                                       |
|-------------------------------------------------------------|-------------------------------------------------------------|------------------------------------------------------------------|
|redirected_call                                              |redirectedCall                                               |redirectedCall *Optional*                                         |
|include_service_invocation_basic_call_type                   |List[str]                                                    |includeServiceInvocationBasicCallType *Optional*                  |
|include_service_invocation_call_category                     |List[str]                                                    |includeServiceInvocationCallCategory *Optional*                   |
|include_service_invocation_configurable_call_type            |List[str]                                                    |includeServiceInvocationConfigurableCallType *Optional*           |
|search_criteria_service_invocation_dialed_number             |List[searchCriteriaServiceInvocationDialedNumber]            |searchCriteriaServiceInvocationDialedNumber *Optional*            |
|search_criteria_service_invocation_called_number             |List[searchCriteriaServiceInvocationCalledNumber]            |searchCriteriaServiceInvocationCalledNumber *Optional*            |
|search_criteria_service_invocation_network_translated_number |List[searchCriteriaServiceInvocationNetworkTranslatedNumber] |searchCriteriaServiceInvocationNetworkTranslatedNumber *Optional* |
</div>


## `EnterpriseAccessDevice`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Uniquely identifies an access device accessible for an enterprise.

It could be a system level device, an enterprise level device or a group level device.

**Attributes:**

|Name          |Type         |Description        |
|--------------|-------------|-------------------|
|access_device |accessDevice |accessDevice       |
|group_id      |str          |groupId *Optional* |
</div>


## `EnterpriseEnterpriseTrunkPriorityWeightedTrunkGroup`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Trunk group details (order and weight) for each trunk group

**Attributes:**

|Name        |Type       |Description|
|------------|-----------|-----------|
|trunk_group |trunkGroup |trunkGroup |
|priority    |int        |priority   |
|weight      |int        |weight     |
</div>


## `EnterpriseTrunkNumberPrefix22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Enterprise Trunk Number Prefix

**Attributes:**

|Name            |Type           |Description               |
|----------------|---------------|--------------------------|
|number_prefix   |str            |numberPrefix              |
|extension_range |extensionRange |extensionRange *Optional* |
</div>


## `EnterpriseTrunkNumberPrefixModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Enterprise Trunk Number Prefix for modify.


**Attributes:**

|Name            |Type           |Description               |
|----------------|---------------|--------------------------|
|number_prefix   |str            |numberPrefix              |
|extension_range |extensionRange |extensionRange *Optional* |
</div>


## `EnterpriseTrunkNumberRange`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Directory number range.

The minimum and maximum values are inclusive.

**Attributes:**

|Name             |Type    |Description                |
|-----------------|--------|---------------------------|
|dn_range         |dnRange |dnRange                    |
|extension_length |int     |extensionLength *Optional* |
</div>


## `EnterpriseTrunkPriorityWeightedTrunkGroup`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Trunk group details (order and weight) for each trunk group

**Attributes:**

|Name        |Type       |Description|
|------------|-----------|-----------|
|trunk_group |trunkGroup |trunkGroup |
|priority    |int        |priority   |
|weight      |int        |weight     |
</div>


## `ExecutiveCallFilteringCriteriaFromDnModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The from dn criteria used within an executive call filtering criteria modify request.


**Attributes:**

|Name                        |Type            |Description                          |
|----------------------------|----------------|-------------------------------------|
|from_dn_criteria_selection  |str             |fromDnCriteriaSelection *Optional*   |
|include_anonymous_callers   |bool            |includeAnonymousCallers *Optional*   |
|include_unavailable_callers |bool            |includeUnavailableCallers *Optional* |
|phone_number_list           |phoneNumberList |phoneNumberList *Optional*           |
</div>


## `ExtendedFileResource`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Represents either an existing file for the application server to use, or the contents
of a file to transfer and an URL.


**Attributes:**

|Name |Type |Description     |
|-----|-----|----------------|
|file |file |file *Optional* |
|url  |str  |url *Optional*  |
</div>


## `ExtendedMediaFileLevelResource20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Represents either an existing file for the application server to use, or the contents
of a file to transfer and an URL.


**Attributes:**

|Name |Type |Description     |
|-----|-----|----------------|
|file |file |file *Optional* |
|url  |str  |url *Optional*  |
</div>


## `ExtendedMediaFileResource`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Represents either an existing file for the application server to use, or the contents
of a file to transfer and an URL.


**Attributes:**

|Name |Type |Description     |
|-----|-----|----------------|
|file |file |file *Optional* |
|url  |str  |url *Optional*  |
</div>


## `ExtendedMediaFileResource20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Represents either an existing file for the application server to use, or the contents
of a file to transfer and an URL.


**Attributes:**

|Name |Type |Description     |
|-----|-----|----------------|
|file |file |file *Optional* |
|url  |str  |url *Optional*  |
</div>


## `GroupServiceAuthorization`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Authorize (with quantity) or unauthorize a group service.


**Attributes:**

|Name                |Type               |Description                   |
|--------------------|-------------------|------------------------------|
|service_name        |str                |serviceName                   |
|authorized_quantity |authorizedQuantity |authorizedQuantity *Optional* |
|unauthorized        |bool               |unauthorized *Optional*       |
</div>


## `GroupServiceAuthorizationAndAssignment`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Authorize (with quantity) a group service, and optionally assign the service.


**Attributes:**

|Name                |Type               |Description                   |
|--------------------|-------------------|------------------------------|
|service_name        |str                |serviceName                   |
|authorized_quantity |authorizedQuantity |authorizedQuantity *Optional* |
|assign              |bool               |assign *Optional*             |
</div>


## `GroupSessionAdmissionControlGroupGetResponse21sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Response to GroupSessionAdmissionControlGroupGetRequest21sp1V2.

Returns the profile information for the session admission control group.

**Attributes:**

|Name                                               |Type          |Description                                |
|---------------------------------------------------|--------------|-------------------------------------------|
|max_session                                        |int           |maxSession                                 |
|max_user_originating_sessions                      |int           |maxUserOriginatingSessions *Optional*      |
|max_user_terminating_sessions                      |int           |maxUserTerminatingSessions *Optional*      |
|reserved_session                                   |int           |reservedSession                            |
|reserved_user_originating_sessions                 |int           |reservedUserOriginatingSessions *Optional* |
|reserved_user_terminating_sessions                 |int           |reservedUserTerminatingSessions *Optional* |
|default_group                                      |bool          |defaultGroup                               |
|count_intra_sac_group_sessions                     |bool          |countIntraSACGroupSessions                 |
|devices                                            |List[devices] |devices *Optional*                         |
|block_emergency_and_repair_calls_due_to_sac_limits |bool          |blockEmergencyAndRepairCallsDueToSACLimits |
|media_group_name                                   |str           |mediaGroupName *Optional*                  |
|access_info_pattern                                |str           |accessInfoPattern *Optional*               |
</div>


## `GroupTrunkGroupGetInstanceRequest14sp9A`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Get a Trunk Group Instance's profile.

The response is either a GroupTrunkGroupGetInstanceResponse14sp9A or an
`ErrorResponse()`. The response contains a hosted user table with column headings:
"User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana First Name".

**Attributes:**

|Name            |Type          |Description   |
|----------------|--------------|--------------|
|trunk_group_key |trunkGroupKey |trunkGroupKey |
</div>


## `GroupTrunkGroupGetInstanceRequest17sp4V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Get a Trunk Group Instance's profile.

The response is either a GroupTrunkGroupGetInstanceResponse17sp4V2 or an
`ErrorResponse()`. The response contains a hosted user table with column headings:
"User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana First Name".
Replaced by: `GroupTrunkGroupGetInstanceRequest19V2()`

**Attributes:**

|Name            |Type          |Description   |
|----------------|--------------|--------------|
|trunk_group_key |trunkGroupKey |trunkGroupKey |
</div>


## `GroupTrunkGroupGetInstanceRequest19sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Get a Trunk Group Instance's profile.

The response is either a GroupTrunkGroupGetInstanceResponse19sp1V2 or an
`ErrorResponse()`. The response contains a hosted user table with column headings:
"User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana First Name",
"Phone Number", "Extension", "Department", "Email Address". Replaced by:
`GroupTrunkGroupGetInstanceRequest20sp1()`

**Attributes:**

|Name            |Type          |Description   |
|----------------|--------------|--------------|
|trunk_group_key |trunkGroupKey |trunkGroupKey |
</div>


## `GroupTrunkGroupGetInstanceResponse14sp9A`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Response to GroupTrunkGroupGetInstanceRequest14sp9A.

Returns the profile information for the Trunk Group.  Contains a hosted user table
with column headings: "User Id", "Last Name", "First Name", "Hiragana Last Name",
"Hiragana First Name".

**Attributes:**

|Name                                            |Type                                       |Description                                                                |
|------------------------------------------------|-------------------------------------------|---------------------------------------------------------------------------|
|pilot_user_id                                   |str                                        |pilotUserId *Optional*                                                     |
|department                                      |department                                 |department *Optional*                                                      |
|access_device                                   |accessDevice                               |accessDevice *Optional*                                                    |
|max_active_calls                                |int                                        |maxActiveCalls                                                             |
|max_incoming_calls                              |int                                        |maxIncomingCalls *Optional*                                                |
|max_outgoing_calls                              |int                                        |maxOutgoingCalls *Optional*                                                |
|enable_bursting                                 |bool                                       |enableBursting                                                             |
|bursting_max_active_calls                       |int                                        |burstingMaxActiveCalls *Optional*                                          |
|bursting_max_incoming_calls                     |int                                        |burstingMaxIncomingCalls *Optional*                                        |
|bursting_max_outgoing_calls                     |int                                        |burstingMaxOutgoingCalls *Optional*                                        |
|capacity_exceeded_action                        |str                                        |capacityExceededAction *Optional*                                          |
|capacity_exceeded_forward_address               |str                                        |capacityExceededForwardAddress *Optional*                                  |
|capacity_exceeded_reroute_trunk_group_key       |capacityExceededRerouteTrunkGroupKey       |capacityExceededRerouteTrunkGroupKey *Optional*                            |
|capacity_exceeded_trap_initial_calls            |int                                        |capacityExceededTrapInitialCalls                                           |
|capacity_exceeded_trap_offset_calls             |int                                        |capacityExceededTrapOffsetCalls                                            |
|unreachable_destination_action                  |str                                        |unreachableDestinationAction *Optional*                                    |
|unreachable_destination_forward_address         |str                                        |unreachableDestinationForwardAddress *Optional*                            |
|unreachable_destination_reroute_trunk_group_key |unreachableDestinationRerouteTrunkGroupKey |unreachableDestinationRerouteTrunkGroupKey *Optional*                      |
|unreachable_destination_trap_initial_calls      |int                                        |unreachableDestinationTrapInitialCalls                                     |
|unreachable_destination_trap_offset_calls       |int                                        |unreachableDestinationTrapOffsetCalls                                      |
|invitation_timeout                              |int                                        |invitationTimeout                                                          |
|require_authentication                          |bool                                       |requireAuthentication                                                      |
|sip_authentication_user_name                    |str                                        |sipAuthenticationUserName *Optional*                                       |
|hosted_user_table                               |List(hostedUserTable)                      |hostedUserTable - *Table* array of hostedUserTable named tuples *Optional* |
|trunk_group_identity                            |str                                        |trunkGroupIdentity *Optional*                                              |
|otg_dtg_identity                                |str                                        |otgDtgIdentity *Optional*                                                  |
|include_trunk_group_identity                    |bool                                       |includeTrunkGroupIdentity                                                  |
|include_dtg_identity                            |bool                                       |includeDtgIdentity                                                         |
|enable_network_address_identity                 |bool                                       |enableNetworkAddressIdentity                                               |
|allow_unscreened_calls                          |bool                                       |allowUnscreenedCalls                                                       |
|allow_unscreened_emergency_calls                |bool                                       |allowUnscreenedEmergencyCalls                                              |
|pilot_user_calling_line_identity_policy         |str                                        |pilotUserCallingLineIdentityPolicy                                         |
|pilot_user_charge_number_policy                 |str                                        |pilotUserChargeNumberPolicy                                                |
|call_forwarding_always_action                   |str                                        |callForwardingAlwaysAction *Optional*                                      |
|call_forwarding_always_forward_address          |str                                        |callForwardingAlwaysForwardAddress *Optional*                              |
|call_forwarding_always_reroute_trunk_group_key  |callForwardingAlwaysRerouteTrunkGroupKey   |callForwardingAlwaysRerouteTrunkGroupKey *Optional*                        |
</div>


## `GroupTrunkGroupGetInstanceResponse17sp4V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Response to GroupTrunkGroupGetInstanceRequest17sp4V2.

Returns the profile information for the Trunk Group.  Contains a hosted user table
with column headings: "User Id", "Last Name", "First Name", "Hiragana Last Name",
"Hiragana First Name". Replaced by: `GroupTrunkGroupGetInstanceResponse19V2()`

**Attributes:**

|Name                                             |Type                                       |Description                                                                |
|-------------------------------------------------|-------------------------------------------|---------------------------------------------------------------------------|
|pilot_user_id                                    |str                                        |pilotUserId *Optional*                                                     |
|department                                       |department                                 |department *Optional*                                                      |
|access_device                                    |accessDevice                               |accessDevice *Optional*                                                    |
|max_active_calls                                 |int                                        |maxActiveCalls                                                             |
|max_incoming_calls                               |int                                        |maxIncomingCalls *Optional*                                                |
|max_outgoing_calls                               |int                                        |maxOutgoingCalls *Optional*                                                |
|enable_bursting                                  |bool                                       |enableBursting                                                             |
|bursting_max_active_calls                        |int                                        |burstingMaxActiveCalls *Optional*                                          |
|bursting_max_incoming_calls                      |int                                        |burstingMaxIncomingCalls *Optional*                                        |
|bursting_max_outgoing_calls                      |int                                        |burstingMaxOutgoingCalls *Optional*                                        |
|capacity_exceeded_action                         |str                                        |capacityExceededAction *Optional*                                          |
|capacity_exceeded_forward_address                |str                                        |capacityExceededForwardAddress *Optional*                                  |
|capacity_exceeded_reroute_trunk_group_key        |capacityExceededRerouteTrunkGroupKey       |capacityExceededRerouteTrunkGroupKey *Optional*                            |
|capacity_exceeded_trap_initial_calls             |int                                        |capacityExceededTrapInitialCalls                                           |
|capacity_exceeded_trap_offset_calls              |int                                        |capacityExceededTrapOffsetCalls                                            |
|unreachable_destination_action                   |str                                        |unreachableDestinationAction *Optional*                                    |
|unreachable_destination_forward_address          |str                                        |unreachableDestinationForwardAddress *Optional*                            |
|unreachable_destination_reroute_trunk_group_key  |unreachableDestinationRerouteTrunkGroupKey |unreachableDestinationRerouteTrunkGroupKey *Optional*                      |
|invitation_timeout                               |int                                        |invitationTimeout                                                          |
|require_authentication                           |bool                                       |requireAuthentication                                                      |
|sip_authentication_user_name                     |str                                        |sipAuthenticationUserName *Optional*                                       |
|hosted_user_table                                |List(hostedUserTable)                      |hostedUserTable - *Table* array of hostedUserTable named tuples *Optional* |
|trunk_group_identity                             |str                                        |trunkGroupIdentity *Optional*                                              |
|otg_dtg_identity                                 |str                                        |otgDtgIdentity *Optional*                                                  |
|allow_termination_to_trunk_group_identity        |bool                                       |allowTerminationToTrunkGroupIdentity                                       |
|allow_termination_to_dtg_identity                |bool                                       |allowTerminationToDtgIdentity                                              |
|include_trunk_group_identity                     |bool                                       |includeTrunkGroupIdentity                                                  |
|include_dtg_identity                             |bool                                       |includeDtgIdentity                                                         |
|include_trunk_group_identity_for_network_calls   |bool                                       |includeTrunkGroupIdentityForNetworkCalls                                   |
|include_otg_identity_for_network_calls           |bool                                       |includeOtgIdentityForNetworkCalls                                          |
|enable_network_address_identity                  |bool                                       |enableNetworkAddressIdentity                                               |
|allow_unscreened_calls                           |bool                                       |allowUnscreenedCalls                                                       |
|allow_unscreened_emergency_calls                 |bool                                       |allowUnscreenedEmergencyCalls                                              |
|pilot_user_calling_line_identity_policy          |str                                        |pilotUserCallingLineIdentityPolicy                                         |
|pilot_user_charge_number_policy                  |str                                        |pilotUserChargeNumberPolicy                                                |
|call_forwarding_always_action                    |str                                        |callForwardingAlwaysAction *Optional*                                      |
|call_forwarding_always_forward_address           |str                                        |callForwardingAlwaysForwardAddress *Optional*                              |
|call_forwarding_always_reroute_trunk_group_key   |callForwardingAlwaysRerouteTrunkGroupKey   |callForwardingAlwaysRerouteTrunkGroupKey *Optional*                        |
|peering_domain                                   |str                                        |peeringDomain *Optional*                                                   |
|route_to_peering_domain                          |bool                                       |routeToPeeringDomain                                                       |
|prefix_enabled                                   |bool                                       |prefixEnabled                                                              |
|prefix                                           |str                                        |prefix *Optional*                                                          |
|stateful_rerouting_enabled                       |bool                                       |statefulReroutingEnabled                                                   |
|send_continuous_options_message                  |bool                                       |sendContinuousOptionsMessage                                               |
|continuous_options_sending_interval_seconds      |int                                        |continuousOptionsSendingIntervalSeconds                                    |
|failure_options_sending_interval_seconds         |int                                        |failureOptionsSendingIntervalSeconds                                       |
|failure_threshold_counter                        |int                                        |failureThresholdCounter                                                    |
|success_threshold_counter                        |int                                        |successThresholdCounter                                                    |
|invite_failure_threshold_counter                 |int                                        |inviteFailureThresholdCounter                                              |
|invite_failure_threshold_window_seconds          |int                                        |inviteFailureThresholdWindowSeconds                                        |
|trunk_group_state                                |str                                        |trunkGroupState                                                            |
|pilot_user_calling_line_asserted_identity_policy |str                                        |pilotUserCallingLineAssertedIdentityPolicy                                 |
|use_system_calling_line_asserted_identity_policy |bool                                       |useSystemCallingLineAssertedIdentityPolicy                                 |
</div>


## `GroupTrunkGroupGetInstanceResponse19sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Response to GroupTrunkGroupGetInstanceRequest19sp1V2.

Returns the profile information for the Trunk Group.  Contains a hosted user table
with column headings: "User Id", "Last Name", "First Name", "Hiragana Last Name",
"Hiragana First Name", "Phone Number", "Extension", "Department", "Email Address".
Replaced by: `GroupTrunkGroupGetInstanceResponse20sp1()`

**Attributes:**

|Name                                                        |Type                                       |Description                                                                |
|------------------------------------------------------------|-------------------------------------------|---------------------------------------------------------------------------|
|pilot_user_id                                               |str                                        |pilotUserId *Optional*                                                     |
|department                                                  |department                                 |department *Optional*                                                      |
|access_device                                               |accessDevice                               |accessDevice *Optional*                                                    |
|max_active_calls                                            |int                                        |maxActiveCalls                                                             |
|max_incoming_calls                                          |int                                        |maxIncomingCalls *Optional*                                                |
|max_outgoing_calls                                          |int                                        |maxOutgoingCalls *Optional*                                                |
|enable_bursting                                             |bool                                       |enableBursting                                                             |
|bursting_max_active_calls                                   |int                                        |burstingMaxActiveCalls *Optional*                                          |
|bursting_max_incoming_calls                                 |int                                        |burstingMaxIncomingCalls *Optional*                                        |
|bursting_max_outgoing_calls                                 |int                                        |burstingMaxOutgoingCalls *Optional*                                        |
|capacity_exceeded_action                                    |str                                        |capacityExceededAction *Optional*                                          |
|capacity_exceeded_forward_address                           |str                                        |capacityExceededForwardAddress *Optional*                                  |
|capacity_exceeded_reroute_trunk_group_key                   |capacityExceededRerouteTrunkGroupKey       |capacityExceededRerouteTrunkGroupKey *Optional*                            |
|capacity_exceeded_trap_initial_calls                        |int                                        |capacityExceededTrapInitialCalls                                           |
|capacity_exceeded_trap_offset_calls                         |int                                        |capacityExceededTrapOffsetCalls                                            |
|unreachable_destination_action                              |str                                        |unreachableDestinationAction *Optional*                                    |
|unreachable_destination_forward_address                     |str                                        |unreachableDestinationForwardAddress *Optional*                            |
|unreachable_destination_reroute_trunk_group_key             |unreachableDestinationRerouteTrunkGroupKey |unreachableDestinationRerouteTrunkGroupKey *Optional*                      |
|invitation_timeout                                          |int                                        |invitationTimeout                                                          |
|require_authentication                                      |bool                                       |requireAuthentication                                                      |
|sip_authentication_user_name                                |str                                        |sipAuthenticationUserName *Optional*                                       |
|hosted_user_table                                           |List(hostedUserTable)                      |hostedUserTable - *Table* array of hostedUserTable named tuples *Optional* |
|trunk_group_identity                                        |str                                        |trunkGroupIdentity *Optional*                                              |
|otg_dtg_identity                                            |str                                        |otgDtgIdentity *Optional*                                                  |
|allow_termination_to_trunk_group_identity                   |bool                                       |allowTerminationToTrunkGroupIdentity                                       |
|allow_termination_to_dtg_identity                           |bool                                       |allowTerminationToDtgIdentity                                              |
|include_trunk_group_identity                                |bool                                       |includeTrunkGroupIdentity                                                  |
|include_dtg_identity                                        |bool                                       |includeDtgIdentity                                                         |
|include_trunk_group_identity_for_network_calls              |bool                                       |includeTrunkGroupIdentityForNetworkCalls                                   |
|include_otg_identity_for_network_calls                      |bool                                       |includeOtgIdentityForNetworkCalls                                          |
|enable_network_address_identity                             |bool                                       |enableNetworkAddressIdentity                                               |
|allow_unscreened_calls                                      |bool                                       |allowUnscreenedCalls                                                       |
|allow_unscreened_emergency_calls                            |bool                                       |allowUnscreenedEmergencyCalls                                              |
|pilot_user_calling_line_identity_for_external_calls_policy  |str                                        |pilotUserCallingLineIdentityForExternalCallsPolicy                         |
|pilot_user_charge_number_policy                             |str                                        |pilotUserChargeNumberPolicy                                                |
|call_forwarding_always_action                               |str                                        |callForwardingAlwaysAction *Optional*                                      |
|call_forwarding_always_forward_address                      |str                                        |callForwardingAlwaysForwardAddress *Optional*                              |
|call_forwarding_always_reroute_trunk_group_key              |callForwardingAlwaysRerouteTrunkGroupKey   |callForwardingAlwaysRerouteTrunkGroupKey *Optional*                        |
|peering_domain                                              |str                                        |peeringDomain *Optional*                                                   |
|route_to_peering_domain                                     |bool                                       |routeToPeeringDomain                                                       |
|prefix_enabled                                              |bool                                       |prefixEnabled                                                              |
|prefix                                                      |str                                        |prefix *Optional*                                                          |
|stateful_rerouting_enabled                                  |bool                                       |statefulReroutingEnabled                                                   |
|send_continuous_options_message                             |bool                                       |sendContinuousOptionsMessage                                               |
|continuous_options_sending_interval_seconds                 |int                                        |continuousOptionsSendingIntervalSeconds                                    |
|failure_options_sending_interval_seconds                    |int                                        |failureOptionsSendingIntervalSeconds                                       |
|failure_threshold_counter                                   |int                                        |failureThresholdCounter                                                    |
|success_threshold_counter                                   |int                                        |successThresholdCounter                                                    |
|invite_failure_threshold_counter                            |int                                        |inviteFailureThresholdCounter                                              |
|invite_failure_threshold_window_seconds                     |int                                        |inviteFailureThresholdWindowSeconds                                        |
|trunk_group_state                                           |str                                        |trunkGroupState                                                            |
|pilot_user_calling_line_asserted_identity_policy            |str                                        |pilotUserCallingLineAssertedIdentityPolicy                                 |
|use_system_calling_line_asserted_identity_policy            |bool                                       |useSystemCallingLineAssertedIdentityPolicy                                 |
|total_active_incoming_calls                                 |int                                        |totalActiveIncomingCalls                                                   |
|total_active_outgoing_calls                                 |int                                        |totalActiveOutgoingCalls                                                   |
|pilot_user_call_optimization_policy                         |str                                        |pilotUserCallOptimizationPolicy                                            |
|clid_source_for_screened_calls_policy                       |str                                        |clidSourceForScreenedCallsPolicy                                           |
|use_system_clid_source_for_screened_calls_policy            |bool                                       |useSystemCLIDSourceForScreenedCallsPolicy                                  |
|user_lookup_policy                                          |str                                        |userLookupPolicy                                                           |
|use_system_user_lookup_policy                               |bool                                       |useSystemUserLookupPolicy                                                  |
|pilot_user_calling_line_identity_for_emergency_calls_policy |str                                        |pilotUserCallingLineIdentityForEmergencyCallsPolicy                        |
</div>


## `GroupTrunkGroupModifyInstanceRequest14sp9A`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Modify a Trunk Group Instance in a group.

The access device cannot be modified or cleared if there are any users assigned to the
Trunk Group.

The response is either a `SuccessResponse()` or an `ErrorResponse()`.

**Attributes:**

|Name                                            |Type                                       |Description                                           |
|------------------------------------------------|-------------------------------------------|------------------------------------------------------|
|trunk_group_key                                 |trunkGroupKey                              |trunkGroupKey                                         |
|new_name                                        |str                                        |newName *Optional*                                    |
|pilot_user_id                                   |str                                        |pilotUserId *Optional*                                |
|department                                      |department                                 |department *Optional*                                 |
|access_device                                   |accessDevice                               |accessDevice *Optional*                               |
|max_active_calls                                |int                                        |maxActiveCalls *Optional*                             |
|max_incoming_calls                              |int                                        |maxIncomingCalls *Optional*                           |
|max_outgoing_calls                              |int                                        |maxOutgoingCalls *Optional*                           |
|enable_bursting                                 |bool                                       |enableBursting *Optional*                             |
|bursting_max_active_calls                       |int                                        |burstingMaxActiveCalls *Optional*                     |
|bursting_max_incoming_calls                     |int                                        |burstingMaxIncomingCalls *Optional*                   |
|bursting_max_outgoing_calls                     |int                                        |burstingMaxOutgoingCalls *Optional*                   |
|capacity_exceeded_action                        |str                                        |capacityExceededAction *Optional*                     |
|capacity_exceeded_forward_address               |str                                        |capacityExceededForwardAddress *Optional*             |
|capacity_exceeded_reroute_trunk_group_key       |capacityExceededRerouteTrunkGroupKey       |capacityExceededRerouteTrunkGroupKey *Optional*       |
|capacity_exceeded_trap_initial_calls            |int                                        |capacityExceededTrapInitialCalls *Optional*           |
|capacity_exceeded_trap_offset_calls             |int                                        |capacityExceededTrapOffsetCalls *Optional*            |
|unreachable_destination_action                  |str                                        |unreachableDestinationAction *Optional*               |
|unreachable_destination_forward_address         |str                                        |unreachableDestinationForwardAddress *Optional*       |
|unreachable_destination_reroute_trunk_group_key |unreachableDestinationRerouteTrunkGroupKey |unreachableDestinationRerouteTrunkGroupKey *Optional* |
|unreachable_destination_trap_initial_calls      |int                                        |unreachableDestinationTrapInitialCalls *Optional*     |
|unreachable_destination_trap_offset_calls       |int                                        |unreachableDestinationTrapOffsetCalls *Optional*      |
|invitation_timeout                              |int                                        |invitationTimeout *Optional*                          |
|require_authentication                          |bool                                       |requireAuthentication *Optional*                      |
|sip_authentication_user_name                    |str                                        |sipAuthenticationUserName *Optional*                  |
|sip_authentication_password                     |str                                        |sipAuthenticationPassword *Optional*                  |
|hosted_user_id_list                             |hostedUserIdList                           |hostedUserIdList *Optional*                           |
|trunk_group_identity                            |str                                        |trunkGroupIdentity *Optional*                         |
|otg_dtg_identity                                |str                                        |otgDtgIdentity *Optional*                             |
|include_trunk_group_identity                    |bool                                       |includeTrunkGroupIdentity *Optional*                  |
|include_dtg_identity                            |bool                                       |includeDtgIdentity *Optional*                         |
|enable_network_address_identity                 |bool                                       |enableNetworkAddressIdentity *Optional*               |
|allow_unscreened_calls                          |bool                                       |allowUnscreenedCalls *Optional*                       |
|allow_unscreened_emergency_calls                |bool                                       |allowUnscreenedEmergencyCalls *Optional*              |
|pilot_user_calling_line_identity_policy         |str                                        |pilotUserCallingLineIdentityPolicy *Optional*         |
|pilot_user_charge_number_policy                 |str                                        |pilotUserChargeNumberPolicy *Optional*                |
|call_forwarding_always_action                   |str                                        |callForwardingAlwaysAction *Optional*                 |
|call_forwarding_always_forward_address          |str                                        |callForwardingAlwaysForwardAddress *Optional*         |
|call_forwarding_always_reroute_trunk_group_key  |callForwardingAlwaysRerouteTrunkGroupKey   |callForwardingAlwaysRerouteTrunkGroupKey *Optional*   |
</div>


## `IncomingCallingPlanDepartmentPermissions`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Allows or disallows various types of incoming calls for a specified department.


**Attributes:**

|Name                      |Type                         |Description                       |
|--------------------------|-----------------------------|----------------------------------|
|department_key            |departmentKey                |departmentKey                     |
|department_full_path_name |str                          |departmentFullPathName            |
|allow_from_within_group   |bool                         |allowFromWithinGroup              |
|allow_from_outside_group  |str                          |allowFromOutsideGroup             |
|allow_collect_calls       |bool                         |allowCollectCalls                 |
|digit_pattern_permission  |List[digitPatternPermission] |digitPatternPermission *Optional* |
</div>


## `IncomingCallingPlanDepartmentPermissionsModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Allows or disallows various types of incoming calls for a specified department.

For use when modifing settings.

**Attributes:**

|Name                     |Type                         |Description                       |
|-------------------------|-----------------------------|----------------------------------|
|department_key           |departmentKey                |departmentKey                     |
|allow_from_within_group  |bool                         |allowFromWithinGroup *Optional*   |
|allow_from_outside_group |str                          |allowFromOutsideGroup *Optional*  |
|allow_collect_calls      |bool                         |allowCollectCalls *Optional*      |
|digit_pattern_permission |List[digitPatternPermission] |digitPatternPermission *Optional* |
</div>


## `IncomingCallingPlanPermissions`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Allows or disallows various types of incoming calls for a user or group -- not any
particular department.


**Attributes:**

|Name                     |Type                         |Description                       |
|-------------------------|-----------------------------|----------------------------------|
|allow_from_within_group  |bool                         |allowFromWithinGroup              |
|allow_from_outside_group |str                          |allowFromOutsideGroup             |
|allow_collect_calls      |bool                         |allowCollectCalls                 |
|digit_pattern_permission |List[digitPatternPermission] |digitPatternPermission *Optional* |
</div>


## `IncomingCallingPlanPermissionsModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Allows or disallows various types of incoming calls for a user or group -- not any
particular department.

For use when modifing settings.

**Attributes:**

|Name                     |Type                         |Description                       |
|-------------------------|-----------------------------|----------------------------------|
|allow_from_within_group  |bool                         |allowFromWithinGroup *Optional*   |
|allow_from_outside_group |str                          |allowFromOutsideGroup *Optional*  |
|allow_collect_calls      |bool                         |allowCollectCalls *Optional*      |
|digit_pattern_permission |List[digitPatternPermission] |digitPatternPermission *Optional* |
</div>


## `MWIDeliveryToMobileEndpointTemplateBody`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
MWI Delivery To Mobile Endpoint template body.


**Attributes:**

|Name |Type       |Description|
|-----|-----------|-----------|
|line |List[line] |line       |
</div>


## `OutgoingCallingPlanCallMeNowDepartmentPermissions`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Calling Plan for Call Me Now call permissions for a department.


**Attributes:**

|Name            |Type          |Description    |
|----------------|--------------|---------------|
|department_key  |departmentKey |departmentKey  |
|department_name |str           |departmentName |
|permissions     |permissions   |permissions    |
</div>


## `OutgoingCallingPlanCallMeNowDepartmentPermissionsModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Modify outgoing Calling Plan for Call Me Now call permissions for a department.


**Attributes:**

|Name           |Type          |Description   |
|---------------|--------------|--------------|
|department_key |departmentKey |departmentKey |
|permissions    |permissions   |permissions   |
</div>


## `OutgoingCallingPlanDepartmentAuthorizationCodes`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Calling Plan Authorization Code for a department.


**Attributes:**

|Name            |Type            |Description          |
|----------------|----------------|---------------------|
|department_key  |departmentKey   |departmentKey        |
|department_name |str             |departmentName       |
|code_entry      |List[codeEntry] |codeEntry *Optional* |
</div>


## `OutgoingCallingPlanDepartmentTransferNumbers`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Calling Plan transfer numbers for a department.


**Attributes:**

|Name             |Type            |Description     |
|-----------------|----------------|----------------|
|department_key   |departmentKey   |departmentKey   |
|department_name  |str             |departmentName  |
|transfer_numbers |transferNumbers |transferNumbers |
</div>


## `OutgoingCallingPlanDepartmentTransferNumbersModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Calling Plan transfer numbers for a department.


**Attributes:**

|Name             |Type            |Description                |
|-----------------|----------------|---------------------------|
|department_key   |departmentKey   |departmentKey              |
|transfer_numbers |transferNumbers |transferNumbers *Optional* |
</div>


## `OutgoingCallingPlanDigitPatternCallMeNowPermissions`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Calling Plan Call Me Now call permissions for specified digit patterns.


**Attributes:**

|Name                      |Type                          |Description             |
|--------------------------|------------------------------|------------------------|
|digit_pattern_permissions |List[digitPatternPermissions] |digitPatternPermissions |
</div>


## `OutgoingCallingPlanDigitPatternOriginatingPermissions`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Calling Plan originating call permissions for specified digit patterns.


**Attributes:**

|Name                      |Type                          |Description             |
|--------------------------|------------------------------|------------------------|
|digit_pattern_permissions |List[digitPatternPermissions] |digitPatternPermissions |
</div>


## `OutgoingCallingPlanDigitPatternRedirectingPermissions`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Calling Plan redirecting call permissions for specified digit patterns.


**Attributes:**

|Name                      |Type                          |Description             |
|--------------------------|------------------------------|------------------------|
|digit_pattern_permissions |List[digitPatternPermissions] |digitPatternPermissions |
</div>


## `OutgoingCallingPlanGroupAuthorizationCodes`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Calling Plan Authorization Code for the group default.


**Attributes:**

|Name       |Type            |Description          |
|-----------|----------------|---------------------|
|code_entry |List[codeEntry] |codeEntry *Optional* |
</div>


## `OutgoingCallingPlanOriginatingDepartmentPermissions`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Calling Plan originating call permissions for a department.


**Attributes:**

|Name            |Type          |Description    |
|----------------|--------------|---------------|
|department_key  |departmentKey |departmentKey  |
|department_name |str           |departmentName |
|permissions     |permissions   |permissions    |
</div>


## `OutgoingCallingPlanOriginatingDepartmentPermissionsModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Calling Plan originating call permissions for a department.


**Attributes:**

|Name           |Type          |Description            |
|---------------|--------------|-----------------------|
|department_key |departmentKey |departmentKey          |
|permissions    |permissions   |permissions *Optional* |
</div>


## `OutgoingCallingPlanRedirectedDepartmentPermissions`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Calling Plan being forwarded/transferred permissions for a department.


**Attributes:**

|Name            |Type          |Description    |
|----------------|--------------|---------------|
|department_key  |departmentKey |departmentKey  |
|department_name |str           |departmentName |
|permissions     |permissions   |permissions    |
</div>


## `OutgoingCallingPlanRedirectedDepartmentPermissionsModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Calling Plan being forwarded/transferred permissions for a department.


**Attributes:**

|Name           |Type          |Description   |
|---------------|--------------|--------------|
|department_key |departmentKey |departmentKey |
|permissions    |permissions   |permissions   |
</div>


## `OutgoingCallingPlanRedirectingDepartmentPermissions`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Calling Plan initiating call forwards/transfer permissions for a department.


**Attributes:**

|Name            |Type          |Description    |
|----------------|--------------|---------------|
|department_key  |departmentKey |departmentKey  |
|department_name |str           |departmentName |
|permissions     |permissions   |permissions    |
</div>


## `OutgoingCallingPlanRedirectingDepartmentPermissionsModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Calling Plan initiating call forwards/transfer permissions for a department.


**Attributes:**

|Name           |Type          |Description   |
|---------------|--------------|--------------|
|department_key |departmentKey |departmentKey |
|permissions    |permissions   |permissions   |
</div>


## `OutgoingPinholeDigitPlanDigitPatternCallMeNowPermissions`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Pinhole Digit Plan Call Me Now call permissions for specified digit patterns.


**Attributes:**

|Name                      |Type                          |Description             |
|--------------------------|------------------------------|------------------------|
|digit_pattern_permissions |List[digitPatternPermissions] |digitPatternPermissions |
</div>


## `OutgoingPinholeDigitPlanDigitPatternOriginatingPermissions`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Pinhole Digit Plan originating call permissions for specified digit patterns.


**Attributes:**

|Name                      |Type                          |Description             |
|--------------------------|------------------------------|------------------------|
|digit_pattern_permissions |List[digitPatternPermissions] |digitPatternPermissions |
</div>


## `OutgoingPinholeDigitPlanDigitPatternRedirectingPermissions`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Pinhole Digit Plan redirecting call permissions for specified digit patterns.


**Attributes:**

|Name                      |Type                          |Description             |
|--------------------------|------------------------------|------------------------|
|digit_pattern_permissions |List[digitPatternPermissions] |digitPatternPermissions |
</div>


## `PriorityAlertCriteriaFromDnModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The from dn criteria used within a modify request.


**Attributes:**

|Name                        |Type            |Description                          |
|----------------------------|----------------|-------------------------------------|
|from_dn_criteria_selection  |str             |fromDnCriteriaSelection *Optional*   |
|include_anonymous_callers   |bool            |includeAnonymousCallers *Optional*   |
|include_unavailable_callers |bool            |includeUnavailableCallers *Optional* |
|phone_number_list           |phoneNumberList |phoneNumberList *Optional*           |
</div>


## `ProfileAndServiceDeviceEndpointInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Represents information about an endpoint device

**Attributes:**

|Name                      |Type         |Description                       |
|--------------------------|-------------|----------------------------------|
|access_device             |accessDevice |accessDevice                      |
|line_port                 |str          |linePort                          |
|private_identity          |str          |privateIdentity *Optional*        |
|access_device_mac_address |str          |accessDeviceMacAddress *Optional* |
</div>


## `ProfileAndServiceMusicOnHoldInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
This is the configuration parameters for Music On Hold service

**Attributes:**

|Name                                    |Type           |Description                        |
|----------------------------------------|---------------|-----------------------------------|
|enable_video                            |bool           |enableVideo                        |
|source                                  |source         |source                             |
|use_alternate_source_for_internal_calls |bool           |useAlternateSourceForInternalCalls |
|internal_source                         |internalSource |internalSource *Optional*          |
</div>


## `ProfileAndServiceSimultaneousRingPersonalInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
This is the configuration parameters for Simultaneous Ring Personal service Contains a
criteria table with column heading: "Is Active", "Criteria Name", "Time Schedule",
"Holiday Schedule", "Calls From" and "Blacklisted".

The "Calls From" column is a string containing call numbers

**Attributes:**

|Name                     |Type                         |Description                                                 |
|-------------------------|-----------------------------|------------------------------------------------------------|
|is_active                |bool                         |isActive                                                    |
|do_not_ring_if_on_call   |bool                         |doNotRingIfOnCall                                           |
|simultaneous_ring_number |List[simultaneousRingNumber] |simultaneousRingNumber *Optional*                           |
|criteria_table           |List(criteriaTable)          |criteriaTable - *Table* array of criteriaTable named tuples |
</div>


## `ProfileAndServiceSpeedDial100Info`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
This is the configuration parameters for Speed Dial 100 service

**Attributes:**

|Name             |Type                 |Description               |
|-----------------|---------------------|--------------------------|
|prefix           |str                  |prefix *Optional*         |
|speed_dial_entry |List[speedDialEntry] |speedDialEntry *Optional* |
</div>


## `ProfileAndServiceSpeedDial8Info`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
This is the configuration parameters for Speed Dial 8 service

**Attributes:**

|Name             |Type                 |Description               |
|-----------------|---------------------|--------------------------|
|speed_dial_entry |List[speedDialEntry] |speedDialEntry *Optional* |
</div>


## `PushNotificationTokenData`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
? The common push notification token elements.


**Attributes:**

|Name                         |Type                            |Description                          |
|-----------------------------|--------------------------------|-------------------------------------|
|push_notification_token      |str                             |pushNotificationToken                |
|push_notification_type       |str                             |pushNotificationType                 |
|push_notification_event_data |List[pushNotificationEventData] |pushNotificationEventData *Optional* |
</div>


## `ReceptionistContactUserAndNote`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The Receptionist User (or VON User) and Receptionist Notes.


**Attributes:**

|Name            |Type    |Description              |
|----------------|--------|-------------------------|
|contact_user_id |str     |contactUserId *Optional* |
|von_user        |vonUser |vonUser *Optional*       |
|note            |str     |note                     |
</div>


## `ReplacementAgentWeightList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of agent userIds and hunt agent weights that replaces the previously configured
list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name         |Type              |Description |
|-------------|------------------|------------|
|agent_weight |List[agentWeight] |agentWeight |
</div>


## `ReplacementAlternateUserIdEntryList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of alternate user ids that that replaces a previously configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name              |Type                  |Description     |
|------------------|----------------------|----------------|
|alternate_user_id |List[alternateUserId] |alternateUserId |
</div>


## `ReplacementCallToNumberList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of Call to Numbers that replaces a previously configured list.

By convention, an element of this type may be set nill to clear the list.  For the
callToNumbers, the extension element is not used and the number element is only used
when the type is BroadWorks Mobility.

**Attributes:**

|Name           |Type               |Description  |
|---------------|-------------------|-------------|
|call_to_number |List[callToNumber] |callToNumber |
</div>


## `ReplacementCommunicationBarringCallMeNowRuleList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of Communication Barring CallMeNow Rules that replaces a previously configured
list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name |Type       |Description|
|-----|-----------|-----------|
|rule |List[rule] |rule       |
</div>


## `ReplacementCommunicationBarringIncomingRuleList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of Communication Barring Incoming Rules that replaces a previously configured
list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name |Type       |Description|
|-----|-----------|-----------|
|rule |List[rule] |rule       |
</div>


## `ReplacementCommunicationBarringIncomingRuleList19sp1`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of Communication Barring Incoming Rules that replaces a previously configured
list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name |Type       |Description|
|-----|-----------|-----------|
|rule |List[rule] |rule       |
</div>


## `ReplacementCommunicationBarringOriginatingRuleList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of Communication Barring Originating Rules that replaces a previously
configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name |Type       |Description|
|-----|-----------|-----------|
|rule |List[rule] |rule       |
</div>


## `ReplacementCommunicationBarringRedirectingRuleList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of Communication Barring Redirecting Rules that replaces a previously
configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name |Type       |Description|
|-----|-----------|-----------|
|rule |List[rule] |rule       |
</div>


## `ReplacementContactList22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of SIP contacts that replaces a previously configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name    |Type          |Description|
|--------|--------------|-----------|
|contact |List[contact] |contact    |
</div>


## `ReplacementCustomContactDirectoryEntryList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of userIds and/or Virtual On-Net user DNs that replaces a previously configured
list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name  |Type        |Description|
|------|------------|-----------|
|entry |List[entry] |entry      |
</div>


## `ReplacementDeviceList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of devices that replaces a previously configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name   |Type         |Description|
|-------|-------------|-----------|
|device |List[device] |device     |
</div>


## `ReplacementEnterpriseEnterpriseTrunkTrunkGroupKeyList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of Enterprise Trunk Krunk Group Keys that replaces a previously configured
list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name        |Type             |Description|
|------------|-----------------|-----------|
|trunk_group |List[trunkGroup] |trunkGroup |
</div>


## `ReplacementEnterpriseTrunkTrunkGroupKeyList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of Enterprise Trunk Krunk Group Keys that replaces a previously configured
list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name             |Type                 |Description    |
|-----------------|---------------------|---------------|
|trunk_group_list |List[trunkGroupList] |trunkGroupList |
</div>


## `ReplacementGroupEnterpriseTrunkPriorityWeightedTrunkGroupList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of enterprise trunk priority weighted trunk groups in a group that replaces a
previously configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name        |Type             |Description|
|------------|-----------------|-----------|
|trunk_group |List[trunkGroup] |trunkGroup |
</div>


## `ScheduleEvents`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Retrives all Holiday or Time Event details for a given schedulel Level.


**Attributes:**

|Name          |Type       |Description            |
|--------------|-----------|-----------------------|
|eventname     |str        |eventname              |
|start_date    |str        |startDate              |
|all_day_event |bool       |allDayEvent *Optional* |
|start_time    |startTime  |startTime *Optional*   |
|end_time      |endTime    |endTime *Optional*     |
|end_date      |str        |endDate                |
|recurrence    |recurrence |recurrence *Optional*  |
</div>


## `ScheduleGlobalKey`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Uniquely identifies Holiday and Time Schedules throughout all System, Service
Provider, Group and User level.


**Attributes:**

|Name           |Type        |Description   |
|---------------|------------|--------------|
|schedule_key   |scheduleKey |scheduleKey   |
|schedule_level |str         |scheduleLevel |
</div>


## `SearchCriteriaComposedOrDnExtension`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a DN OR an extension.

Note: For this search criterion, the searchMode is always ‘Contains’ and the search
criteria are always OR’ed.

**Attributes:**

|Name  |Type  |Description|
|------|------|-----------|
|value |value |value      |
</div>


## `SearchCriteriaExactCallCenterReportTemplateKey`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular call center enhanced reporting report
template.


**Attributes:**

|Name            |Type           |Description    |
|----------------|---------------|---------------|
|report_template |reportTemplate |reportTemplate |
</div>


## `SearchCriteriaExactDnDepartment`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular fully specified DN's department.


**Attributes:**

|Name           |Type          |Description   |
|---------------|--------------|--------------|
|department_key |departmentKey |departmentKey |
</div>


## `SearchCriteriaExactUserDepartment`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Criteria for searching for a particular fully specified user's department.


**Attributes:**

|Name           |Type          |Description   |
|---------------|--------------|--------------|
|department_key |departmentKey |departmentKey |
</div>


## `SelectiveCallRejectionCriteriaCallTypeModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The call type criteria used within a modify request.


**Attributes:**

|Name                        |Type            |Description                          |
|----------------------------|----------------|-------------------------------------|
|from_dn_criteria_selection  |str             |fromDnCriteriaSelection *Optional*   |
|include_anonymous_callers   |bool            |includeAnonymousCallers *Optional*   |
|include_unavailable_callers |bool            |includeUnavailableCallers *Optional* |
|phone_number_list           |phoneNumberList |phoneNumberList *Optional*           |
</div>


## `ServiceInstanceAddProfile`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Service Profile Information for group service.


**Attributes:**

|Name                         |Type       |Description                         |
|-----------------------------|-----------|------------------------------------|
|name                         |str        |name                                |
|calling_line_id_last_name    |str        |callingLineIdLastName               |
|calling_line_id_first_name   |str        |callingLineIdFirstName              |
|hiragana_last_name           |str        |hiraganaLastName *Optional*         |
|hiragana_first_name          |str        |hiraganaFirstName *Optional*        |
|phone_number                 |str        |phoneNumber *Optional*              |
|extension                    |str        |extension *Optional*                |
|password                     |str        |password *Optional*                 |
|department                   |department |department *Optional*               |
|language                     |str        |language *Optional*                 |
|time_zone                    |str        |timeZone *Optional*                 |
|alias                        |List[str]  |alias *Optional*                    |
|public_user_identity         |str        |publicUserIdentity *Optional*       |
|calling_line_id_phone_number |str        |callingLineIdPhoneNumber *Optional* |
</div>


## `ServiceInstanceAddProfileCallCenter`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Service Profile Information for a call center.

Password is required.

**Attributes:**

|Name                         |Type       |Description                         |
|-----------------------------|-----------|------------------------------------|
|name                         |str        |name                                |
|calling_line_id_last_name    |str        |callingLineIdLastName               |
|calling_line_id_first_name   |str        |callingLineIdFirstName              |
|hiragana_last_name           |str        |hiraganaLastName *Optional*         |
|hiragana_first_name          |str        |hiraganaFirstName *Optional*        |
|phone_number                 |str        |phoneNumber *Optional*              |
|extension                    |str        |extension *Optional*                |
|password                     |str        |password                            |
|department                   |department |department *Optional*               |
|language                     |str        |language *Optional*                 |
|time_zone                    |str        |timeZone *Optional*                 |
|alias                        |List[str]  |alias *Optional*                    |
|public_user_identity         |str        |publicUserIdentity *Optional*       |
|calling_line_id_phone_number |str        |callingLineIdPhoneNumber *Optional* |
</div>


## `ServiceInstanceAddProfileFlexibleSeatingHost`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Service Profile Information for a flexible seating host.


**Attributes:**

|Name                         |Type       |Description                         |
|-----------------------------|-----------|------------------------------------|
|name                         |str        |name                                |
|calling_line_id_last_name    |str        |callingLineIdLastName               |
|calling_line_id_first_name   |str        |callingLineIdFirstName              |
|hiragana_last_name           |str        |hiraganaLastName *Optional*         |
|hiragana_first_name          |str        |hiraganaFirstName *Optional*        |
|phone_number                 |str        |phoneNumber *Optional*              |
|extension                    |str        |extension *Optional*                |
|password                     |str        |password *Optional*                 |
|department                   |department |department *Optional*               |
|language                     |str        |language *Optional*                 |
|time_zone                    |str        |timeZone *Optional*                 |
|calling_line_id_phone_number |str        |callingLineIdPhoneNumber *Optional* |
</div>


## `ServiceInstanceAddProfileTrunkGroup`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Service Profile Information for a trunk group.

The publicUserIdentity element is not part of ServiceInstanceAddProfileTrunkGroup.

**Attributes:**

|Name                         |Type       |Description                         |
|-----------------------------|-----------|------------------------------------|
|name                         |str        |name                                |
|calling_line_id_last_name    |str        |callingLineIdLastName               |
|calling_line_id_first_name   |str        |callingLineIdFirstName              |
|hiragana_last_name           |str        |hiraganaLastName *Optional*         |
|hiragana_first_name          |str        |hiraganaFirstName *Optional*        |
|phone_number                 |str        |phoneNumber *Optional*              |
|extension                    |str        |extension *Optional*                |
|password                     |str        |password *Optional*                 |
|department                   |department |department *Optional*               |
|language                     |str        |language *Optional*                 |
|time_zone                    |str        |timeZone *Optional*                 |
|alias                        |List[str]  |alias *Optional*                    |
|calling_line_id_phone_number |str        |callingLineIdPhoneNumber *Optional* |
</div>


## `ServiceInstanceModifyProfile`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Service Profile Information for group service used when modifying an existing service
instance.


**Attributes:**

|Name                         |Type         |Description                         |
|-----------------------------|-------------|------------------------------------|
|name                         |str          |name *Optional*                     |
|calling_line_id_last_name    |str          |callingLineIdLastName *Optional*    |
|calling_line_id_first_name   |str          |callingLineIdFirstName *Optional*   |
|hiragana_last_name           |str          |hiraganaLastName *Optional*         |
|hiragana_first_name          |str          |hiraganaFirstName *Optional*        |
|phone_number                 |str          |phoneNumber *Optional*              |
|extension                    |str          |extension *Optional*                |
|password                     |str          |password *Optional*                 |
|department                   |department   |department *Optional*               |
|language                     |str          |language *Optional*                 |
|time_zone                    |str          |timeZone *Optional*                 |
|sip_alias_list               |sipAliasList |sipAliasList *Optional*             |
|public_user_identity         |str          |publicUserIdentity *Optional*       |
|calling_line_id_phone_number |str          |callingLineIdPhoneNumber *Optional* |
</div>


## `ServiceInstanceModifyProfileFlexibleSeatingHost`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Service Profile Information for a flexible seating host

**Attributes:**

|Name                         |Type       |Description                         |
|-----------------------------|-----------|------------------------------------|
|name                         |str        |name *Optional*                     |
|calling_line_id_last_name    |str        |callingLineIdLastName *Optional*    |
|calling_line_id_first_name   |str        |callingLineIdFirstName *Optional*   |
|hiragana_last_name           |str        |hiraganaLastName *Optional*         |
|hiragana_first_name          |str        |hiraganaFirstName *Optional*        |
|phone_number                 |str        |phoneNumber *Optional*              |
|extension                    |str        |extension *Optional*                |
|password                     |str        |password *Optional*                 |
|department                   |department |department *Optional*               |
|language                     |str        |language *Optional*                 |
|time_zone                    |str        |timeZone *Optional*                 |
|calling_line_id_phone_number |str        |callingLineIdPhoneNumber *Optional* |
</div>


## `ServiceInstanceModifyProfileTrunkGroup`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Service Profile Information for a trunk group used when modifying an existing service
instance.


**Attributes:**

|Name                       |Type         |Description                       |
|---------------------------|-------------|----------------------------------|
|name                       |str          |name *Optional*                   |
|calling_line_id_last_name  |str          |callingLineIdLastName *Optional*  |
|calling_line_id_first_name |str          |callingLineIdFirstName *Optional* |
|hiragana_last_name         |str          |hiraganaLastName *Optional*       |
|hiragana_first_name        |str          |hiraganaFirstName *Optional*      |
|phone_number               |str          |phoneNumber *Optional*            |
|extension                  |str          |extension *Optional*              |
|password                   |str          |password *Optional*               |
|department                 |department   |department *Optional*             |
|language                   |str          |language *Optional*               |
|time_zone                  |str          |timeZone *Optional*               |
|sip_alias_list             |sipAliasList |sipAliasList *Optional*           |
</div>


## `ServiceInstanceReadProfile`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Service Profile Information for group service.

It is identical to the ServiceInstanceAddProfile, but without the password.  Prior to
release 14 this was called ServiceInstanceProfile.

**Attributes:**

|Name                       |Type       |Description                    |
|---------------------------|-----------|-------------------------------|
|name                       |str        |name                           |
|calling_line_id_last_name  |str        |callingLineIdLastName          |
|calling_line_id_first_name |str        |callingLineIdFirstName         |
|hiragana_last_name         |str        |hiraganaLastName *Optional*    |
|hiragana_first_name        |str        |hiraganaFirstName *Optional*   |
|phone_number               |str        |phoneNumber *Optional*         |
|extension                  |str        |extension *Optional*           |
|department                 |department |department *Optional*          |
|language                   |str        |language *Optional*            |
|time_zone                  |str        |timeZone *Optional*            |
|time_zone_display_name     |str        |timeZoneDisplayName *Optional* |
|alias                      |List[str]  |alias *Optional*               |
|public_user_identity       |str        |publicUserIdentity *Optional*  |
</div>


## `ServiceInstanceReadProfile17`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Service Profile Information for group service.

It is identical to the ServiceInstanceAddProfile, but without the password.  Replaced
by: ServiceInstanceReadProfile17sp4

**Attributes:**

|Name                       |Type       |Description                    |
|---------------------------|-----------|-------------------------------|
|name                       |str        |name                           |
|calling_line_id_last_name  |str        |callingLineIdLastName          |
|calling_line_id_first_name |str        |callingLineIdFirstName         |
|hiragana_last_name         |str        |hiraganaLastName *Optional*    |
|hiragana_first_name        |str        |hiraganaFirstName *Optional*   |
|phone_number               |str        |phoneNumber *Optional*         |
|extension                  |str        |extension *Optional*           |
|department                 |department |department *Optional*          |
|language                   |str        |language *Optional*            |
|time_zone                  |str        |timeZone *Optional*            |
|time_zone_display_name     |str        |timeZoneDisplayName *Optional* |
|alias                      |List[str]  |alias *Optional*               |
|public_user_identity       |str        |publicUserIdentity *Optional*  |
</div>


## `ServiceInstanceReadProfile17sp4`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Service Profile Information for group service.

Replaced by: ServiceInstanceReadProfile19sp1

**Attributes:**

|Name                       |Type       |Description                    |
|---------------------------|-----------|-------------------------------|
|name                       |str        |name                           |
|calling_line_id_last_name  |str        |callingLineIdLastName          |
|calling_line_id_first_name |str        |callingLineIdFirstName         |
|hiragana_last_name         |str        |hiraganaLastName *Optional*    |
|hiragana_first_name        |str        |hiraganaFirstName *Optional*   |
|phone_number               |str        |phoneNumber *Optional*         |
|extension                  |str        |extension *Optional*           |
|country_code               |str        |countryCode *Optional*         |
|national_prefix            |str        |nationalPrefix *Optional*      |
|department                 |department |department *Optional*          |
|language                   |str        |language *Optional*            |
|time_zone                  |str        |timeZone *Optional*            |
|time_zone_display_name     |str        |timeZoneDisplayName *Optional* |
|alias                      |List[str]  |alias *Optional*               |
|public_user_identity       |str        |publicUserIdentity *Optional*  |
</div>


## `ServiceInstanceReadProfile19sp1`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Service Profile Information for group service.

The callingLineIdPhoneNumber is no longer being formatted for display purpose.  The
value is returned exactly the same as being stored.

**Attributes:**

|Name                         |Type       |Description                         |
|-----------------------------|-----------|------------------------------------|
|name                         |str        |name                                |
|calling_line_id_last_name    |str        |callingLineIdLastName               |
|calling_line_id_first_name   |str        |callingLineIdFirstName              |
|hiragana_last_name           |str        |hiraganaLastName *Optional*         |
|hiragana_first_name          |str        |hiraganaFirstName *Optional*        |
|phone_number                 |str        |phoneNumber *Optional*              |
|extension                    |str        |extension *Optional*                |
|country_code                 |str        |countryCode *Optional*              |
|national_prefix              |str        |nationalPrefix *Optional*           |
|department                   |department |department *Optional*               |
|language                     |str        |language *Optional*                 |
|time_zone                    |str        |timeZone *Optional*                 |
|time_zone_display_name       |str        |timeZoneDisplayName *Optional*      |
|alias                        |List[str]  |alias *Optional*                    |
|public_user_identity         |str        |publicUserIdentity *Optional*       |
|calling_line_id_phone_number |str        |callingLineIdPhoneNumber *Optional* |
</div>


## `ServicePack`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The common Service Pack elements.


**Attributes:**

|Name                     |Type                |Description                       |
|-------------------------|--------------------|----------------------------------|
|service_pack_name        |str                 |servicePackName                   |
|service_pack_description |str                 |servicePackDescription *Optional* |
|is_available_for_use     |bool                |isAvailableForUse                 |
|service_pack_quantity    |servicePackQuantity |servicePackQuantity               |
|service_name             |List[str]           |serviceName *Optional*            |
</div>


## `ServicePackAuthorization`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Authorize (with quantity) or unauthorize a service pack.


**Attributes:**

|Name                |Type               |Description                   |
|--------------------|-------------------|------------------------------|
|service_pack_name   |str                |servicePackName               |
|authorized_quantity |authorizedQuantity |authorizedQuantity *Optional* |
|unauthorized        |bool               |unauthorized *Optional*       |
</div>


## `ServiceProviderCommunicationBarringProfileGetResponse19sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Response to the ServiceProviderCommunicationBarringProfileGetRequest19sp1V2.

The response contains the Communication Barring Profile information.  The incoming,
originating, redirecting and call me now rules are returned in ascending priority
order.  The following elements are only used in AS data mode: callMeNowDefaultAction
callMeNowDefaultCallTimeout callMeNowRule applyToAttendedCallTransfers

**Attributes:**

|Name                                |Type                  |Description                                 |
|------------------------------------|----------------------|--------------------------------------------|
|description                         |str                   |description *Optional*                      |
|originating_default_action          |str                   |originatingDefaultAction                    |
|originating_default_treatment_id    |str                   |originatingDefaultTreatmentId *Optional*    |
|originating_default_transfer_number |str                   |originatingDefaultTransferNumber *Optional* |
|originating_default_call_timeout    |int                   |originatingDefaultCallTimeout *Optional*    |
|originating_rule                    |List[originatingRule] |originatingRule *Optional*                  |
|redirecting_default_action          |str                   |redirectingDefaultAction                    |
|redirecting_default_call_timeout    |int                   |redirectingDefaultCallTimeout *Optional*    |
|redirecting_rule                    |List[redirectingRule] |redirectingRule *Optional*                  |
|call_me_now_default_action          |str                   |callMeNowDefaultAction                      |
|call_me_now_default_call_timeout    |int                   |callMeNowDefaultCallTimeout *Optional*      |
|call_me_now_rule                    |List[callMeNowRule]   |callMeNowRule *Optional*                    |
|incoming_default_action             |str                   |incomingDefaultAction                       |
|incoming_default_call_timeout       |int                   |incomingDefaultCallTimeout *Optional*       |
|incoming_rule                       |List[incomingRule]    |incomingRule *Optional*                     |
|is_default                          |bool                  |isDefault                                   |
|apply_to_attended_call_transfers    |bool                  |applyToAttendedCallTransfers                |
</div>


## `ServiceProviderReplacementCommunicationBarringHierarchicalCallMeNowRuleList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of Service Provider Communication Barring Hierarchical Call Me Now Rules that
replaces a previously configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name |Type       |Description|
|-----|-----------|-----------|
|rule |List[rule] |rule       |
</div>


## `ServiceProviderReplacementCommunicationBarringHierarchicalOriginatingRuleList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of Service Provider Communication Barring Hierarchical Originating Rules that
replaces a previously configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name |Type       |Description|
|-----|-----------|-----------|
|rule |List[rule] |rule       |
</div>


## `ServiceProviderReplacementCommunicationBarringHierarchicalRedirectingRuleList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of Service Provider Communication Barring Hierarchical Redirecting Rules that
replaces a previously configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name |Type       |Description|
|-----|-----------|-----------|
|rule |List[rule] |rule       |
</div>


## `ShInterfaceUserIdDataEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
ShInterface User Id Data Entry.


**Attributes:**

|Name                 |Type               |Description          |
|---------------------|-------------------|---------------------|
|user_type            |str                |userType             |
|public_user_identity |publicUserIdentity |publicUserIdentity   |
|endpoint_type        |str                |endpointType         |
|scscf_name           |str                |SCSCFName *Optional* |
|ims_user_state       |str                |IMSUserState         |
</div>


## `ShInterfaceUserIdDataEntry21sp1`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
ShInterface User Id Data Entry.


**Attributes:**

|Name                 |Type               |Description          |
|---------------------|-------------------|---------------------|
|user_type            |str                |userType             |
|public_user_identity |publicUserIdentity |publicUserIdentity   |
|endpoint_type        |str                |endpointType         |
|scscf_name           |str                |SCSCFName *Optional* |
|ims_user_state       |str                |IMSUserState         |
</div>


## `ShInterfaceUserListEntry`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
ShInterface User List Entry.


**Attributes:**

|Name                 |Type               |Description          |
|---------------------|-------------------|---------------------|
|user_id              |str                |userId               |
|user_type            |str                |userType             |
|public_user_identity |publicUserIdentity |publicUserIdentity   |
|endpoint_type        |str                |endpointType         |
|scscf_name           |str                |SCSCFName *Optional* |
|ims_user_state       |str                |IMSUserState         |
</div>


## `ShInterfaceUserListEntry21sp1`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
ShInterface User List Entry.


**Attributes:**

|Name                 |Type               |Description          |
|---------------------|-------------------|---------------------|
|user_id              |str                |userId               |
|user_type            |str                |userType             |
|public_user_identity |publicUserIdentity |publicUserIdentity   |
|endpoint_type        |str                |endpointType         |
|scscf_name           |str                |SCSCFName *Optional* |
|ims_user_state       |str                |IMSUserState         |
</div>


## `SimultaneousRingReplacementNumberList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of Simultaneous Ring numbers that replaces a previously configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name                     |Type                         |Description            |
|-------------------------|-----------------------------|-----------------------|
|simultaneous_ring_number |List[simultaneousRingNumber] |simultaneousRingNumber |
</div>


## `SortOrderEnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAssignmentPagedSortedList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Used to sort the
`SortOrderEnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAssignmentPagedSortedListRequest()`.


**Attributes:**

|Name                            |Type                        |Description                            |
|--------------------------------|----------------------------|---------------------------------------|
|sort_by_mobile_directory_number |sortByMobileDirectoryNumber |sortByMobileDirectoryNumber *Optional* |
|sort_by_dn                      |sortByDn                    |sortByDn *Optional*                    |
|sort_by_department_name         |sortByDepartmentName        |sortByDepartmentName *Optional*        |
|sort_by_user_id                 |sortByUserId                |sortByUserId *Optional*                |
|sort_by_user_first_name         |sortByUserFirstName         |sortByUserFirstName *Optional*         |
|sort_by_user_last_name          |sortByUserLastName          |sortByUserLastName *Optional*          |
|sort_by_extension               |sortByExtension             |sortByExtension *Optional*             |
|sort_by_dn_available            |sortByDnAvailable           |sortByDnAvailable *Optional*           |
</div>


## `SortOrderEnterpriseCallCenterAgentThresholdProfileGetAvailableAgentPagedSortedList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Used to sort the
`EnterpriseCallCenterAgentThresholdProfileGetAvailableAgentPagedSortedListRequest()`
request.


**Attributes:**

|Name                            |Type                        |Description                            |
|--------------------------------|----------------------------|---------------------------------------|
|sort_by_user_id                 |sortByUserId                |sortByUserId *Optional*                |
|sort_by_user_last_name          |sortByUserLastName          |sortByUserLastName *Optional*          |
|sort_by_user_first_name         |sortByUserFirstName         |sortByUserFirstName *Optional*         |
|sort_by_dn                      |sortByDn                    |sortByDn *Optional*                    |
|sort_by_extension               |sortByExtension             |sortByExtension *Optional*             |
|sort_by_department_name         |sortByDepartmentName        |sortByDepartmentName *Optional*        |
|sort_by_email_address           |sortByEmailAddress          |sortByEmailAddress *Optional*          |
|sort_by_agent_threshold_profile |sortByAgentThresholdProfile |sortByAgentThresholdProfile *Optional* |
</div>


## `SortOrderEnterpriseCallCenterAgentThresholdProfileGetPagedSorted`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Used to sort the `EnterpriseCallCenterAgentThresholdProfileGetPagedSortedRequest()`
request.


**Attributes:**

|Name                    |Type                 |Description                     |
|------------------------|---------------------|--------------------------------|
|sort_by_user_id         |sortByUserId         |sortByUserId *Optional*         |
|sort_by_user_last_name  |sortByUserLastName   |sortByUserLastName *Optional*   |
|sort_by_user_first_name |sortByUserFirstName  |sortByUserFirstName *Optional*  |
|sort_by_dn              |sortByDn             |sortByDn *Optional*             |
|sort_by_extension       |sortByExtension      |sortByExtension *Optional*      |
|sort_by_department_name |sortByDepartmentName |sortByDepartmentName *Optional* |
|sort_by_email_address   |sortByEmailAddress   |sortByEmailAddress *Optional*   |
</div>


## `SortOrderEnterprisePhoneDirectoryGetPagedSortedList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Used to sort the `EnterprisePhoneDirectoryGetPagedSortedListRequest()` request.


**Attributes:**

|Name                        |Type                    |Description                        |
|----------------------------|------------------------|-----------------------------------|
|sort_by_user_last_name      |sortByUserLastName      |sortByUserLastName *Optional*      |
|sort_by_user_first_name     |sortByUserFirstName     |sortByUserFirstName *Optional*     |
|sort_by_group_location_code |sortByGroupLocationCode |sortByGroupLocationCode *Optional* |
|sort_by_mobile_phone_number |sortByMobilePhoneNumber |sortByMobilePhoneNumber *Optional* |
|sort_by_email_address       |sortByEmailAddress      |sortByEmailAddress *Optional*      |
|sort_by_department_name     |sortByDepartmentName    |sortByDepartmentName *Optional*    |
|sort_by_group_name          |sortByGroupName         |sortByGroupName *Optional*         |
|sort_by_yahoo_id            |sortByYahooId           |sortByYahooId *Optional*           |
|sort_by_user_id             |sortByUserId            |sortByUserId *Optional*            |
|sort_by_imp_id              |sortByImpId             |sortByImpId *Optional*             |
</div>


## `SortOrderGroupAccessDeviceGetPagedSortedList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Used to sort the `GroupAccessDeviceGetPagedSortedListRequest()` request.


**Attributes:**

|Name                       |Type                   |Description                       |
|---------------------------|-----------------------|----------------------------------|
|sort_by_device_name        |sortByDeviceName       |sortByDeviceName *Optional*       |
|sort_by_device_type        |sortByDeviceType       |sortByDeviceType *Optional*       |
|sort_by_device_net_address |sortByDeviceNetAddress |sortByDeviceNetAddress *Optional* |
|sort_by_device_mac_address |sortByDeviceMACAddress |sortByDeviceMACAddress *Optional* |
</div>


## `SortOrderGroupAdminGetPagedSortedList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Used to sort the `GroupAdminGetPagedSortedListRequest()` request.


**Attributes:**

|Name                     |Type                 |Description                     |
|-------------------------|---------------------|--------------------------------|
|sort_by_admin_id         |sortByAdminId        |sortByAdminId *Optional*        |
|sort_by_admin_last_name  |sortByAdminLastName  |sortByAdminLastName *Optional*  |
|sort_by_admin_first_name |sortByAdminFirstName |sortByAdminFirstName *Optional* |
</div>


## `SortOrderGroupAutoAttendantGetInstancePagedSortedList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Used to sort the `GroupAutoAttendantGetInstancePagedSortedListRequest()` request.


**Attributes:**

|Name                   |Type               |Description                   |
|-----------------------|-------------------|------------------------------|
|sort_by_user_id        |sortByUserId       |sortByUserId *Optional*       |
|sort_by_user_last_name |sortByUserLastName |sortByUserLastName *Optional* |
|sort_by_dn             |sortByDn           |sortByDn *Optional*           |
|sort_by_extension      |sortByExtension    |sortByExtension *Optional*    |
</div>


## `SortOrderGroupCallCenterAgentThresholdProfileGetAvailableAgentPagedSortedList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Used to sort the
`GroupCallCenterAgentThresholdProfileGetAvailableAgentPagedSortedListRequest()`
request.


**Attributes:**

|Name                            |Type                        |Description                            |
|--------------------------------|----------------------------|---------------------------------------|
|sort_by_user_id                 |sortByUserId                |sortByUserId *Optional*                |
|sort_by_user_last_name          |sortByUserLastName          |sortByUserLastName *Optional*          |
|sort_by_user_first_name         |sortByUserFirstName         |sortByUserFirstName *Optional*         |
|sort_by_dn                      |sortByDn                    |sortByDn *Optional*                    |
|sort_by_extension               |sortByExtension             |sortByExtension *Optional*             |
|sort_by_department_name         |sortByDepartmentName        |sortByDepartmentName *Optional*        |
|sort_by_email_address           |sortByEmailAddress          |sortByEmailAddress *Optional*          |
|sort_by_agent_threshold_profile |sortByAgentThresholdProfile |sortByAgentThresholdProfile *Optional* |
</div>


## `SortOrderGroupCallCenterAgentThresholdProfileGetPagedSorted`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Used to sort the `GroupCallCenterAgentThresholdProfileGetPagedSortedRequest()`
request.


**Attributes:**

|Name                    |Type                 |Description                     |
|------------------------|---------------------|--------------------------------|
|sort_by_user_id         |sortByUserId         |sortByUserId *Optional*         |
|sort_by_user_last_name  |sortByUserLastName   |sortByUserLastName *Optional*   |
|sort_by_user_first_name |sortByUserFirstName  |sortByUserFirstName *Optional*  |
|sort_by_dn              |sortByDn             |sortByDn *Optional*             |
|sort_by_extension       |sortByExtension      |sortByExtension *Optional*      |
|sort_by_department_name |sortByDepartmentName |sortByDepartmentName *Optional* |
|sort_by_email_address   |sortByEmailAddress   |sortByEmailAddress *Optional*   |
</div>


## `SortOrderGroupCallCenterGetAvailableAgentPagedSortedList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Used to sort the `GroupCallCenterGetAvailableAgentPagedSortedListRequest()` request.


**Attributes:**

|Name                    |Type                 |Description                     |
|------------------------|---------------------|--------------------------------|
|sort_by_user_id         |sortByUserId         |sortByUserId *Optional*         |
|sort_by_user_last_name  |sortByUserLastName   |sortByUserLastName *Optional*   |
|sort_by_user_first_name |sortByUserFirstName  |sortByUserFirstName *Optional*  |
|sort_by_dn              |sortByDn             |sortByDn *Optional*             |
|sort_by_extension       |sortByExtension      |sortByExtension *Optional*      |
|sort_by_department_name |sortByDepartmentName |sortByDepartmentName *Optional* |
|sort_by_email_address   |sortByEmailAddress   |sortByEmailAddress *Optional*   |
</div>


## `SortOrderGroupCallCenterGetInstancePagedSortedList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Used to sort the `GroupCallCenterGetInstancePagedSortedListRequest()` request.


**Attributes:**

|Name                     |Type                 |Description                     |
|-------------------------|---------------------|--------------------------------|
|sort_by_user_id          |sortByUserId         |sortByUserId *Optional*         |
|sort_by_call_center_name |sortByCallCenterName |sortByCallCenterName *Optional* |
|sort_by_dn               |sortByDn             |sortByDn *Optional*             |
|sort_by_extension        |sortByExtension      |sortByExtension *Optional*      |
|sort_by_department_name  |sortByDepartmentName |sortByDepartmentName *Optional* |
|sort_by_hunt_policy      |sortByHuntPolicy     |sortByHuntPolicy *Optional*     |
|sort_by_call_center_type |sortByCallCenterType |sortByCallCenterType *Optional* |
</div>


## `SortOrderGroupCallParkGetAvailableAlternateRecallUserPagedSortedList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Used to sort the
`GroupCallParkGetAvailableAlternateRecallUserPagedSortedListRequest()` request.


**Attributes:**

|Name                    |Type                 |Description                     |
|------------------------|---------------------|--------------------------------|
|sort_by_user_id         |sortByUserId         |sortByUserId *Optional*         |
|sort_by_user_last_name  |sortByUserLastName   |sortByUserLastName *Optional*   |
|sort_by_user_first_name |sortByUserFirstName  |sortByUserFirstName *Optional*  |
|sort_by_dn              |sortByDn             |sortByDn *Optional*             |
|sort_by_extension       |sortByExtension      |sortByExtension *Optional*      |
|sort_by_department_name |sortByDepartmentName |sortByDepartmentName *Optional* |
</div>


## `SortOrderGroupCallParkGetAvailableUserPagedSortedList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Used to sort the `GroupCallParkGetAvailableUserPagedSortedListRequest()` request.


**Attributes:**

|Name                    |Type                 |Description                     |
|------------------------|---------------------|--------------------------------|
|sort_by_user_id         |sortByUserId         |sortByUserId *Optional*         |
|sort_by_user_last_name  |sortByUserLastName   |sortByUserLastName *Optional*   |
|sort_by_user_first_name |sortByUserFirstName  |sortByUserFirstName *Optional*  |
|sort_by_dn              |sortByDn             |sortByDn *Optional*             |
|sort_by_extension       |sortByExtension      |sortByExtension *Optional*      |
|sort_by_department_name |sortByDepartmentName |sortByDepartmentName *Optional* |
|sort_by_email_address   |sortByEmailAddress   |sortByEmailAddress *Optional*   |
</div>


## `SortOrderGroupCallPickupGetAvailableUserPagedSortedList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Used to sort the `GroupCallPickupGetAvailableUserPagedSortedListRequest()` request.


**Attributes:**

|Name                    |Type                 |Description                     |
|------------------------|---------------------|--------------------------------|
|sort_by_user_id         |sortByUserId         |sortByUserId *Optional*         |
|sort_by_user_last_name  |sortByUserLastName   |sortByUserLastName *Optional*   |
|sort_by_user_first_name |sortByUserFirstName  |sortByUserFirstName *Optional*  |
|sort_by_dn              |sortByDn             |sortByDn *Optional*             |
|sort_by_extension       |sortByExtension      |sortByExtension *Optional*      |
|sort_by_department_name |sortByDepartmentName |sortByDepartmentName *Optional* |
|sort_by_email_address   |sortByEmailAddress   |sortByEmailAddress *Optional*   |
</div>


## `SortOrderGroupCallPickupGetInstancePagedSorted`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Used to sort the `GroupCallPickupGetInstancePagedSortedRequest()` request.


**Attributes:**

|Name                    |Type                 |Description                     |
|------------------------|---------------------|--------------------------------|
|sort_by_user_id         |sortByUserId         |sortByUserId *Optional*         |
|sort_by_user_last_name  |sortByUserLastName   |sortByUserLastName *Optional*   |
|sort_by_user_first_name |sortByUserFirstName  |sortByUserFirstName *Optional*  |
|sort_by_dn              |sortByDn             |sortByDn *Optional*             |
|sort_by_extension       |sortByExtension      |sortByExtension *Optional*      |
|sort_by_department_name |sortByDepartmentName |sortByDepartmentName *Optional* |
|sort_by_email_address   |sortByEmailAddress   |sortByEmailAddress *Optional*   |
</div>


## `SortOrderGroupCollaborateBridgeGetAvailableUserPagedSortedList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Used to sort the `GroupCollaborateBridgeGetAvailableUserPagedSortedListRequest()`
request.


**Attributes:**

|Name                    |Type                |Description                    |
|------------------------|--------------------|-------------------------------|
|sort_by_user_id         |sortByUserId        |sortByUserId *Optional*        |
|sort_by_user_last_name  |sortByUserLastName  |sortByUserLastName *Optional*  |
|sort_by_user_first_name |sortByUserFirstName |sortByUserFirstName *Optional* |
|sort_by_dn              |sortByDn            |sortByDn *Optional*            |
|sort_by_extension       |sortByExtension     |sortByExtension *Optional*     |
</div>


## `SortOrderGroupCollaborateBridgeGetInstancePagedSortedList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Used to sort the `GroupCollaborateBridgeGetInstancePagedSortedListRequest()`.


**Attributes:**

|Name                   |Type               |Description                   |
|-----------------------|-------------------|------------------------------|
|sort_by_user_id        |sortByUserId       |sortByUserId *Optional*       |
|sort_by_user_last_name |sortByUserLastName |sortByUserLastName *Optional* |
|sort_by_dn             |sortByDn           |sortByDn *Optional*           |
|sort_by_extension      |sortByExtension    |sortByExtension *Optional*    |
</div>


## `SortOrderGroupDnGetAssignmentPagedSortedList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Used to sort the `GroupDnGetAssignmentPagedSortedListRequest()` request.


**Attributes:**

|Name                    |Type                 |Description                     |
|------------------------|---------------------|--------------------------------|
|sort_by_dn              |sortByDn             |sortByDn *Optional*             |
|sort_by_department_name |sortByDepartmentName |sortByDepartmentName *Optional* |
|sort_by_dn_activated    |sortByDnActivated    |sortByDnActivated *Optional*    |
|sort_by_dn_available    |sortByDnAvailable    |sortByDnAvailable *Optional*    |
|sort_by_user_id         |sortByUserId         |sortByUserId *Optional*         |
|sort_by_user_first_name |sortByUserFirstName  |sortByUserFirstName *Optional*  |
|sort_by_user_last_name  |sortByUserLastName   |sortByUserLastName *Optional*   |
|sort_by_extension       |sortByExtension      |sortByExtension *Optional*      |
|sort_by_email_address   |sortByEmailAddress   |sortByEmailAddress *Optional*   |
</div>


## `SortOrderGroupGetListInServiceProviderPagedSortedList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Used to sort the `GroupGetListInServiceProviderPagedSortedListRequest()` request.


**Attributes:**

|Name               |Type            |Description                |
|-------------------|----------------|---------------------------|
|sort_by_group_id   |sortByGroupId   |sortByGroupId *Optional*   |
|sort_by_group_name |sortByGroupName |sortByGroupName *Optional* |
</div>


## `SortOrderGroupHuntGroupGetAvailableUserPagedSortedList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Used to sort the `GroupHuntGroupGetAvailableUserPagedSortedListRequest()` request.


**Attributes:**

|Name                    |Type                |Description                    |
|------------------------|--------------------|-------------------------------|
|sort_by_user_id         |sortByUserId        |sortByUserId *Optional*        |
|sort_by_user_last_name  |sortByUserLastName  |sortByUserLastName *Optional*  |
|sort_by_user_first_name |sortByUserFirstName |sortByUserFirstName *Optional* |
|sort_by_dn              |sortByDn            |sortByDn *Optional*            |
|sort_by_extension       |sortByExtension     |sortByExtension *Optional*     |
</div>


## `SortOrderGroupHuntGroupGetInstancePagedSortedList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Used to sort the `GroupHuntGroupGetInstancePagedSortedListRequest()` request.


**Attributes:**

|Name                   |Type               |Description                   |
|-----------------------|-------------------|------------------------------|
|sort_by_user_id        |sortByUserId       |sortByUserId *Optional*       |
|sort_by_user_last_name |sortByUserLastName |sortByUserLastName *Optional* |
|sort_by_dn             |sortByDn           |sortByDn *Optional*           |
|sort_by_extension      |sortByExtension    |sortByExtension *Optional*    |
</div>


## `SortOrderGroupPhoneDirectoryGetPagedSortedList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Used to sort the `GroupPhoneDirectoryGetPagedSortedListRequest()` request.


**Attributes:**

|Name                        |Type                    |Description                        |
|----------------------------|------------------------|-----------------------------------|
|sort_by_user_last_name      |sortByUserLastName      |sortByUserLastName *Optional*      |
|sort_by_user_first_name     |sortByUserFirstName     |sortByUserFirstName *Optional*     |
|sort_by_mobile_phone_number |sortByMobilePhoneNumber |sortByMobilePhoneNumber *Optional* |
|sort_by_email_address       |sortByEmailAddress      |sortByEmailAddress *Optional*      |
|sort_by_department_name     |sortByDepartmentName    |sortByDepartmentName *Optional*    |
|sort_by_yahoo_id            |sortByYahooId           |sortByYahooId *Optional*           |
|sort_by_user_id             |sortByUserId            |sortByUserId *Optional*            |
|sort_by_imp_id              |sortByImpId             |sortByImpId *Optional*             |
</div>


## `SortOrderServiceProviderAdminGetPagedSortedList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Used to sort the `ServiceProviderAdminGetPagedSortedListRequest()` request.


**Attributes:**

|Name                     |Type                 |Description                     |
|-------------------------|---------------------|--------------------------------|
|sort_by_admin_id         |sortByAdminId        |sortByAdminId *Optional*        |
|sort_by_admin_last_name  |sortByAdminLastName  |sortByAdminLastName *Optional*  |
|sort_by_admin_first_name |sortByAdminFirstName |sortByAdminFirstName *Optional* |
</div>


## `SortOrderServiceProviderGetPagedSortedList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Used to sort the `ServiceProviderGetPagedSortedListRequest()` request.


**Attributes:**

|Name                          |Type                      |Description                          |
|------------------------------|--------------------------|-------------------------------------|
|sort_by_service_provider_id   |sortByServiceProviderId   |sortByServiceProviderId *Optional*   |
|sort_by_service_provider_name |sortByServiceProviderName |sortByServiceProviderName *Optional* |
</div>


## `SortOrderUserGetListInGroupPagedSortedList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Used to sort the `UserGetListInGroupPagedSortedListRequest()` request.


**Attributes:**

|Name                    |Type                 |Description                     |
|------------------------|---------------------|--------------------------------|
|sort_by_user_id         |sortByUserId         |sortByUserId *Optional*         |
|sort_by_user_last_name  |sortByUserLastName   |sortByUserLastName *Optional*   |
|sort_by_user_first_name |sortByUserFirstName  |sortByUserFirstName *Optional*  |
|sort_by_department_name |sortByDepartmentName |sortByDepartmentName *Optional* |
|sort_by_dn              |sortByDn             |sortByDn *Optional*             |
|sort_by_extension       |sortByExtension      |sortByExtension *Optional*      |
|sort_by_email_address   |sortByEmailAddress   |sortByEmailAddress *Optional*   |
</div>


## `SystemCollaborateGetResponse20sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Response to SystemCollaborateGetRequest20sp1V2.


**Attributes:**

|Name                                               |Type                   |Description                                   |
|---------------------------------------------------|-----------------------|----------------------------------------------|
|collaborate_room_id_length                         |int                    |collaborateRoomIdLength                       |
|instant_room_idle_timeout_seconds                  |int                    |instantRoomIdleTimeoutSeconds                 |
|collaborate_room_maximum_duration_minutes          |int                    |collaborateRoomMaximumDurationMinutes         |
|support_outdial                                    |bool                   |supportOutdial                                |
|max_collaborate_room_participants                  |int                    |maxCollaborateRoomParticipants                |
|collaborate_active_talker_refresh_interval_seconds |int                    |collaborateActiveTalkerRefreshIntervalSeconds |
|terminate_collaborate_after_grace_period           |bool                   |terminateCollaborateAfterGracePeriod          |
|collaborate_grace_period                           |collaborateGracePeriod |collaborateGracePeriod                        |
|enable_active_collaborate_notification             |bool                   |enableActiveCollaborateNotification           |
|collaborate_from_address                           |str                    |collaborateFromAddress *Optional*             |
</div>


## `SystemCollaborateModifyRequest20sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Modify the system level data associated with collaborate services.

The response is either a `SuccessResponse()` or an `ErrorResponse()`.

**Attributes:**

|Name                                               |Type                   |Description                                              |
|---------------------------------------------------|-----------------------|---------------------------------------------------------|
|collaborate_room_id_length                         |int                    |collaborateRoomIdLength *Optional*                       |
|instant_room_idle_timeout_seconds                  |int                    |instantRoomIdleTimeoutSeconds *Optional*                 |
|collaborate_room_maximum_duration_minutes          |int                    |collaborateRoomMaximumDurationMinutes *Optional*         |
|support_outdial                                    |bool                   |supportOutdial *Optional*                                |
|max_collaborate_room_participants                  |int                    |maxCollaborateRoomParticipants *Optional*                |
|collaborate_active_talker_refresh_interval_seconds |int                    |collaborateActiveTalkerRefreshIntervalSeconds *Optional* |
|terminate_collaborate_after_grace_period           |bool                   |terminateCollaborateAfterGracePeriod *Optional*          |
|collaborate_grace_period                           |collaborateGracePeriod |collaborateGracePeriod *Optional*                        |
|enable_active_collaborate_notification             |bool                   |enableActiveCollaborateNotification *Optional*           |
|collaborate_from_address                           |str                    |collaborateFromAddress *Optional*                        |
</div>


## `SystemCommunicationBarringProfileGetResponse19sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Response to the SystemCommunicationBarringProfileGetRequest19sp1V2.

The response contains the Communication Barring Profile information.  The incoming
rules are returned in ascending priority order.  The following elements are only used
in AS data mode: callMeNowDefaultAction callMeNowDefaultCallTimeout callMeNowRule
applyToAttendedCallTransfers

**Attributes:**

|Name                                |Type                  |Description                                 |
|------------------------------------|----------------------|--------------------------------------------|
|description                         |str                   |description *Optional*                      |
|originating_default_action          |str                   |originatingDefaultAction                    |
|originating_default_treatment_id    |str                   |originatingDefaultTreatmentId *Optional*    |
|originating_default_transfer_number |str                   |originatingDefaultTransferNumber *Optional* |
|originating_default_call_timeout    |int                   |originatingDefaultCallTimeout *Optional*    |
|originating_rule                    |List[originatingRule] |originatingRule *Optional*                  |
|redirecting_default_action          |str                   |redirectingDefaultAction                    |
|redirecting_default_call_timeout    |int                   |redirectingDefaultCallTimeout *Optional*    |
|redirecting_rule                    |List[redirectingRule] |redirectingRule *Optional*                  |
|incoming_default_action             |str                   |incomingDefaultAction                       |
|incoming_default_call_timeout       |int                   |incomingDefaultCallTimeout *Optional*       |
|incoming_rule                       |List[incomingRule]    |incomingRule *Optional*                     |
|call_me_now_default_action          |str                   |callMeNowDefaultAction                      |
|call_me_now_default_call_timeout    |int                   |callMeNowDefaultCallTimeout *Optional*      |
|call_me_now_rule                    |List[callMeNowRule]   |callMeNowRule *Optional*                    |
|apply_to_attended_call_transfers    |bool                  |applyToAttendedCallTransfers                |
</div>


## `TreeDeviceInfo`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Information related to a tree device.

A tree device is a device associated with a device type that has the option
supportLinks set to "Support Links from Devices". Many leaf devices can link to it.
When a tree device is created, it is assigned a system-wide unique linkId.

**Attributes:**

|Name            |Type          |Description   |
|----------------|--------------|--------------|
|tree_device_key |treeDeviceKey |treeDeviceKey |
|link_id         |str           |linkId        |
</div>


## `TrunkAddressingAdd`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Trunk group endpoint.


**Attributes:**

|Name                        |Type                     |Description                         |
|----------------------------|-------------------------|------------------------------------|
|trunk_group_device_endpoint |trunkGroupDeviceEndpoint |trunkGroupDeviceEndpoint *Optional* |
|enterprise_trunk_name       |str                      |enterpriseTrunkName *Optional*      |
|alternate_trunk_identity    |str                      |alternateTrunkIdentity *Optional*   |
</div>


## `TrunkAddressingModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Trunk group endpoint.


**Attributes:**

|Name                        |Type                     |Description                         |
|----------------------------|-------------------------|------------------------------------|
|trunk_group_device_endpoint |trunkGroupDeviceEndpoint |trunkGroupDeviceEndpoint *Optional* |
|enterprise_trunk_name       |str                      |enterpriseTrunkName *Optional*      |
|alternate_trunk_identity    |str                      |alternateTrunkIdentity *Optional*   |
</div>


## `TrunkAddressingMultipleContactAdd`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Trunk group endpoint that can have multiple contacts.

alternateTrunkIdentityDomain is only used in XS mode and the AS when deployed in IMS
mode.  Both alternateTrunkIdentity and AlternateTrunkIdentityDomain should be set at
the same time if one is set in XS mode.  The following elements are only used in AS
data mode and are ignored in XS data mode: physicalLocation

**Attributes:**

|Name                            |Type                     |Description                             |
|--------------------------------|-------------------------|----------------------------------------|
|trunk_group_device_endpoint     |trunkGroupDeviceEndpoint |trunkGroupDeviceEndpoint *Optional*     |
|enterprise_trunk_name           |str                      |enterpriseTrunkName *Optional*          |
|alternate_trunk_identity        |str                      |alternateTrunkIdentity *Optional*       |
|alternate_trunk_identity_domain |str                      |alternateTrunkIdentityDomain *Optional* |
|physical_location               |str                      |physicalLocation *Optional*             |
</div>


## `TrunkAddressingMultipleContactRead`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Trunk group endpoint that can have multiple contacts.

Replaced by: TrunkAddressingMultipleContactRead21

**Attributes:**

|Name                        |Type                     |Description                         |
|----------------------------|-------------------------|------------------------------------|
|trunk_group_device_endpoint |trunkGroupDeviceEndpoint |trunkGroupDeviceEndpoint *Optional* |
|enterprise_trunk_name       |str                      |enterpriseTrunkName *Optional*      |
|alternate_trunk_identity    |str                      |alternateTrunkIdentity *Optional*   |
</div>


## `TrunkAddressingMultipleContactRead21`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Trunk group endpoint that can have multiple contacts.

alternateTrunkIdentityDomain is only used in XS mode and the AS when deployed in IMS
mode.  The following elements are only used in AS data mode and ignored in XS data
mode: alternateTrunkIdentityDomain

**Attributes:**

|Name                            |Type                     |Description                             |
|--------------------------------|-------------------------|----------------------------------------|
|trunk_group_device_endpoint     |trunkGroupDeviceEndpoint |trunkGroupDeviceEndpoint *Optional*     |
|enterprise_trunk_name           |str                      |enterpriseTrunkName *Optional*          |
|alternate_trunk_identity        |str                      |alternateTrunkIdentity *Optional*       |
|alternate_trunk_identity_domain |str                      |alternateTrunkIdentityDomain *Optional* |
</div>


## `TrunkAddressingMultipleContactRead21sp1`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Trunk group endpoint that can have multiple contacts.

alternateTrunkIdentityDomain is only used in XS mode and the AS when deployed in IMS
mode.  The following elements are only used in AS data mode and are ignored in XS data
mode: physicalLocation

**Attributes:**

|Name                            |Type                     |Description                             |
|--------------------------------|-------------------------|----------------------------------------|
|trunk_group_device_endpoint     |trunkGroupDeviceEndpoint |trunkGroupDeviceEndpoint *Optional*     |
|enterprise_trunk_name           |str                      |enterpriseTrunkName *Optional*          |
|alternate_trunk_identity        |str                      |alternateTrunkIdentity *Optional*       |
|alternate_trunk_identity_domain |str                      |alternateTrunkIdentityDomain *Optional* |
|physical_location               |str                      |physicalLocation *Optional*             |
</div>


## `TrunkAddressingRead`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Trunk group endpoint.


**Attributes:**

|Name                        |Type                     |Description                         |
|----------------------------|-------------------------|------------------------------------|
|trunk_group_device_endpoint |trunkGroupDeviceEndpoint |trunkGroupDeviceEndpoint *Optional* |
|enterprise_trunk_name       |str                      |enterpriseTrunkName *Optional*      |
|alternate_trunk_identity    |str                      |alternateTrunkIdentity *Optional*   |
</div>


## `TrunkGroupDeviceMultipleContactEndpointAdd22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Trunk group device endpoint used in the context of modify that can have multiple
contacts.


**Attributes:**

|Name      |Type          |Description        |
|----------|--------------|-------------------|
|name      |str           |name               |
|line_port |str           |linePort           |
|contact   |List[contact] |contact *Optional* |
</div>


## `TrunkGroupDeviceMultipleContactEndpointModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Trunk group device endpoint used in the context of modify that can have multiple
contacts.


**Attributes:**

|Name         |Type        |Description            |
|-------------|------------|-----------------------|
|name         |str         |name *Optional*        |
|line_port    |str         |linePort *Optional*    |
|contact_list |contactList |contactList *Optional* |
</div>


## `TrunkGroupDeviceMultipleContactEndpointRead22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Trunk group device endpoint that can have multiple contacts.


**Attributes:**

|Name                        |Type          |Description               |
|----------------------------|--------------|--------------------------|
|name                        |str           |name                      |
|line_port                   |str           |linePort                  |
|contact                     |List[contact] |contact *Optional*        |
|static_registration_capable |bool          |staticRegistrationCapable |
|use_domain                  |bool          |useDomain                 |
|is_pilot_user               |bool          |isPilotUser               |
</div>


## `TrunkGroupMultipleContactPilotUser`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Trunk Group pilot user information used when adding a Trunk Group.


**Attributes:**

|Name                         |Type       |Description                         |
|-----------------------------|-----------|------------------------------------|
|user_id                      |str        |userId                              |
|last_name                    |str        |lastName                            |
|first_name                   |str        |firstName                           |
|calling_line_id_last_name    |str        |callingLineIdLastName               |
|calling_line_id_first_name   |str        |callingLineIdFirstName              |
|hiragana_last_name           |str        |hiraganaLastName *Optional*         |
|hiragana_first_name          |str        |hiraganaFirstName *Optional*        |
|password                     |str        |password *Optional*                 |
|department                   |department |department *Optional*               |
|language                     |str        |language *Optional*                 |
|time_zone                    |str        |timeZone *Optional*                 |
|line_port                    |str        |linePort                            |
|contact                      |List[str]  |contact *Optional*                  |
|calling_line_id_phone_number |str        |callingLineIdPhoneNumber *Optional* |
</div>


## `TrunkGroupMultipleContactPilotUser22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Trunk Group pilot user information used when adding a Trunk Group.


**Attributes:**

|Name                         |Type          |Description                         |
|-----------------------------|--------------|------------------------------------|
|user_id                      |str           |userId                              |
|last_name                    |str           |lastName                            |
|first_name                   |str           |firstName                           |
|calling_line_id_last_name    |str           |callingLineIdLastName               |
|calling_line_id_first_name   |str           |callingLineIdFirstName              |
|hiragana_last_name           |str           |hiraganaLastName *Optional*         |
|hiragana_first_name          |str           |hiraganaFirstName *Optional*        |
|password                     |str           |password *Optional*                 |
|department                   |department    |department *Optional*               |
|language                     |str           |language *Optional*                 |
|time_zone                    |str           |timeZone *Optional*                 |
|line_port                    |str           |linePort                            |
|contact                      |List[contact] |contact *Optional*                  |
|calling_line_id_phone_number |str           |callingLineIdPhoneNumber *Optional* |
</div>


## `TrunkGroupPilotUser`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Trunk Group pilot user information used when adding a Trunk Group.


**Attributes:**

|Name                       |Type       |Description                  |
|---------------------------|-----------|-----------------------------|
|user_id                    |str        |userId                       |
|last_name                  |str        |lastName                     |
|first_name                 |str        |firstName                    |
|calling_line_id_last_name  |str        |callingLineIdLastName        |
|calling_line_id_first_name |str        |callingLineIdFirstName       |
|hiragana_last_name         |str        |hiraganaLastName *Optional*  |
|hiragana_first_name        |str        |hiraganaFirstName *Optional* |
|password                   |str        |password *Optional*          |
|department                 |department |department *Optional*        |
|language                   |str        |language *Optional*          |
|time_zone                  |str        |timeZone *Optional*          |
|line_port                  |str        |linePort                     |
|contact                    |str        |contact *Optional*           |
</div>


## `UserServiceAuthorization`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Authorize (with quantity) or unauthorize a user service.


**Attributes:**

|Name                |Type               |Description                   |
|--------------------|-------------------|------------------------------|
|service_name        |str                |serviceName                   |
|authorized_quantity |authorizedQuantity |authorizedQuantity *Optional* |
|unauthorized        |bool               |unauthorized *Optional*       |
</div>


## `VerifyTranslationAndRoutingParameters`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Verification Translation and Routing parameters for creating a Verify Translation and
Routing request from parameters.


**Attributes:**

|Name        |Type        |Description          |
|------------|------------|---------------------|
|origination |origination |origination          |
|destination |str         |destination          |
|contact     |str         |contact *Optional*   |
|diversion   |str         |diversion *Optional* |
</div>


## `VirtualOnNetUserRange`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Virtual On-Net User Range.


**Attributes:**

|Name                          |Type           |Description              |
|------------------------------|---------------|-------------------------|
|dn_range                      |dnRange        |dnRange                  |
|extension_range               |extensionRange |extensionRange           |
|first_name                    |str            |firstName                |
|last_name                     |str            |lastName                 |
|calling_line_id_first_name    |str            |callingLineIdFirstName   |
|calling_line_id_last_name     |str            |callingLineIdLastName    |
|virtual_on_net_call_type_name |str            |virtualOnNetCallTypeName |
</div>


## `VoiceMessagingAlternateNoAnswerGreetingModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The configuration of a alternate no answer greeting.

It is used when modifying a user's voice messaging greeting.

**Attributes:**

|Name       |Type      |Description          |
|-----------|----------|---------------------|
|name       |str       |name *Optional*      |
|audio_file |audioFile |audioFile *Optional* |
|video_file |videoFile |videoFile *Optional* |
</div>


## `VoiceMessagingAlternateNoAnswerGreetingModify16`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The configuration of a alternate no answer greeting.

It is used when modifying a user's voice messaging greeting.

**Attributes:**

|Name       |Type      |Description          |
|-----------|----------|---------------------|
|name       |str       |name *Optional*      |
|audio_file |audioFile |audioFile *Optional* |
|video_file |videoFile |videoFile *Optional* |
</div>


## `VoiceMessagingAlternateNoAnswerGreetingModify20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The configuration of a alternate no answer greeting.

It is used when modifying a user's voice messaging greeting.

**Attributes:**

|Name       |Type      |Description          |
|-----------|----------|---------------------|
|name       |str       |name *Optional*      |
|audio_file |audioFile |audioFile *Optional* |
|video_file |videoFile |videoFile *Optional* |
</div>


## `VoiceMessagingAlternateNoAnswerGreetingRead20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The configuration of a alternate no answer greeting.

It is used when geting a user's voice messaging greeting.

**Attributes:**

|Name       |Type      |Description          |
|-----------|----------|---------------------|
|name       |str       |name                 |
|audio_file |audioFile |audioFile *Optional* |
|video_file |videoFile |videoFile *Optional* |
</div>


## `VoiceMessagingDistributionListModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of voice mail distribution lists It is used when setting a user's voice
messaging distribution lists

**Attributes:**

|Name              |Type            |Description                |
|------------------|----------------|---------------------------|
|list_id           |int             |listId                     |
|description       |str             |description *Optional*     |
|phone_number_list |phoneNumberList |phoneNumberList *Optional* |
</div>


## `AccessDeviceMultipleContactEndpointModify22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point used in the context of modify that can have more than one
contact defined.

Only Static Registration capable devices may have more than one contact defined.  Port
numbers are only used by devices with static line ordering.

**Attributes:**

|Name          |Type         |Description             |
|--------------|-------------|------------------------|
|access_device |accessDevice |accessDevice *Optional* |
|line_port     |str          |linePort *Optional*     |
|contact_list  |contactList  |contactList *Optional*  |
|port_number   |int          |portNumber *Optional*   |
</div>


## `AccessDeviceMultipleIdentityAndContactEndpointModify22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Access device end point used in the context of modify that can have more than one
contact defined.

The endpoint is identified by its linePort (public Identity) and possibly a private
Identity.  Only Static Registration capable devices may have more than one contact
defined.  Port numbers are only used by devices with static line ordering.  The
following elements are only used in XS data mode and ignored in AS data mode:
privateIdentity The following elements are only used in AS data mode and ignored in XS
data mode: useHotline hotlineContact

**Attributes:**

|Name             |Type         |Description                |
|-----------------|-------------|---------------------------|
|access_device    |accessDevice |accessDevice *Optional*    |
|line_port        |str          |linePort *Optional*        |
|private_identity |str          |privateIdentity *Optional* |
|contact_list     |contactList  |contactList *Optional*     |
|port_number      |int          |portNumber *Optional*      |
|use_hotline      |bool         |useHotline *Optional*      |
|hotline_contact  |str          |hotlineContact *Optional*  |
</div>


## `AutoAttendantKeyConfiguration`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The configuration of a key for Auto Attendant.


**Attributes:**

|Name  |Type  |Description|
|------|------|-----------|
|key   |str   |key        |
|entry |entry |entry      |
</div>


## `AutoAttendantKeyConfiguration19`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The configuration of a key for Auto Attendant.


**Attributes:**

|Name  |Type  |Description|
|------|------|-----------|
|key   |str   |key        |
|entry |entry |entry      |
</div>


## `AutoAttendantKeyConfiguration20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The configuration of a key for Auto Attendant.


**Attributes:**

|Name  |Type  |Description|
|------|------|-----------|
|key   |str   |key        |
|entry |entry |entry      |
</div>


## `AutoAttendantKeyModifyConfiguration`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The modify configuration of a key for Auto Attendant.


**Attributes:**

|Name  |Type  |Description|
|------|------|-----------|
|key   |str   |key        |
|entry |entry |entry      |
</div>


## `AutoAttendantKeyModifyConfiguration20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The modify configuration of a key for Auto Attendant.


**Attributes:**

|Name  |Type  |Description|
|------|------|-----------|
|key   |str   |key        |
|entry |entry |entry      |
</div>


## `AutoAttendantKeyReadConfiguration20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The read configuration of a key for Auto Attendant.


**Attributes:**

|Name  |Type  |Description|
|------|------|-----------|
|key   |str   |key        |
|entry |entry |entry      |
</div>


## `AutoAttendantReadMenu19`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The configuration of the automated receptionist greeting prompt and dialing menu to be
used during after business hours.


**Attributes:**

|Name                                      |Type                   |Description                          |
|------------------------------------------|-----------------------|-------------------------------------|
|announcement_selection                    |str                    |announcementSelection                |
|audio_file_description                    |str                    |audioFileDescription *Optional*      |
|audio_media_type                          |str                    |audioMediaType *Optional*            |
|video_file_description                    |str                    |videoFileDescription *Optional*      |
|video_media_type                          |str                    |videoMediaType *Optional*            |
|enable_first_menu_level_extension_dialing |bool                   |enableFirstMenuLevelExtensionDialing |
|key_configuration                         |List[keyConfiguration] |keyConfiguration *Optional*          |
</div>


## `CPEDeviceModifyOptions`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CPE device's options when used with a modify request.

The following options are not changeable: configType systemFileName deviceFileFormat

**Attributes:**

|Name                                  |Type                              |Description                                  |
|--------------------------------------|----------------------------------|---------------------------------------------|
|enable_monitoring                     |bool                              |enableMonitoring *Optional*                  |
|reset_event                           |str                               |resetEvent *Optional*                        |
|device_management_device_type_options |deviceManagementDeviceTypeOptions |deviceManagementDeviceTypeOptions *Optional* |
</div>


## `CPEDeviceModifyOptions16`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CPE device's options when used with a modify request.

The following options are not changeable: configType systemFileName deviceFileFormat

**Attributes:**

|Name                                  |Type                              |Description                                  |
|--------------------------------------|----------------------------------|---------------------------------------------|
|enable_monitoring                     |bool                              |enableMonitoring *Optional*                  |
|reset_event                           |str                               |resetEvent *Optional*                        |
|device_management_device_type_options |deviceManagementDeviceTypeOptions |deviceManagementDeviceTypeOptions *Optional* |
</div>


## `CPEDeviceModifyOptions16sp1`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CPE device's options when used with a modify request.

The following options are not changeable: configType systemFileName deviceFileFormat

**Attributes:**

|Name                                  |Type                              |Description                                  |
|--------------------------------------|----------------------------------|---------------------------------------------|
|enable_monitoring                     |bool                              |enableMonitoring *Optional*                  |
|device_management_device_type_options |deviceManagementDeviceTypeOptions |deviceManagementDeviceTypeOptions *Optional* |
</div>


## `CPEDeviceModifyOptions22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CPE device's options when used with a modify request.

The following options are not changeable: configType systemFileName deviceFileFormat

**Attributes:**

|Name                                  |Type                              |Description                                  |
|--------------------------------------|----------------------------------|---------------------------------------------|
|enable_monitoring                     |bool                              |enableMonitoring *Optional*                  |
|device_management_device_type_options |deviceManagementDeviceTypeOptions |deviceManagementDeviceTypeOptions *Optional* |
</div>


## `CPEDeviceOptions14sp6`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CPE device's options.


**Attributes:**

|Name                                  |Type                              |Description                                  |
|--------------------------------------|----------------------------------|---------------------------------------------|
|enable_monitoring                     |bool                              |enableMonitoring                             |
|reset_event                           |str                               |resetEvent *Optional*                        |
|config_type                           |str                               |configType                                   |
|system_file_name                      |str                               |systemFileName *Optional*                    |
|device_file_format                    |str                               |deviceFileFormat *Optional*                  |
|device_management_device_type_options |deviceManagementDeviceTypeOptions |deviceManagementDeviceTypeOptions *Optional* |
</div>


## `CPEDeviceOptions16`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CPE device's options.


**Attributes:**

|Name                                  |Type                              |Description                                  |
|--------------------------------------|----------------------------------|---------------------------------------------|
|enable_monitoring                     |bool                              |enableMonitoring                             |
|reset_event                           |str                               |resetEvent *Optional*                        |
|config_type                           |str                               |configType                                   |
|system_file_name                      |str                               |systemFileName *Optional*                    |
|device_file_format                    |str                               |deviceFileFormat *Optional*                  |
|device_management_device_type_options |deviceManagementDeviceTypeOptions |deviceManagementDeviceTypeOptions *Optional* |
</div>


## `CPEDeviceOptions16sp1`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CPE device's options.

The field configType is optional to allow the use of field enableMonitoring for all
device types being managed or not ie.  device configuration option equals to
DeviceManagement, or Legacy, or Not Supported). If the device configuration option is
set to "Not Supported", the value of configType is forced set to "None" regardless of
its current value.  It is not allowed to add a device type with device configuration
option set to Device Management or Legacy when the configType is not set.

**Attributes:**

|Name                                  |Type                              |Description                                  |
|--------------------------------------|----------------------------------|---------------------------------------------|
|enable_monitoring                     |bool                              |enableMonitoring                             |
|config_type                           |str                               |configType *Optional*                        |
|system_file_name                      |str                               |systemFileName *Optional*                    |
|device_file_format                    |str                               |deviceFileFormat *Optional*                  |
|device_management_device_type_options |deviceManagementDeviceTypeOptions |deviceManagementDeviceTypeOptions *Optional* |
</div>


## `CPEDeviceOptions21sp1`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CPE device's options.

The field configType is optional to allow the use of field enableMonitoring for all
device types being managed or not ie.  device configuration option equals to
DeviceManagement, or Legacy, or Not Supported). If the device configuration option is
set to "Not Supported", the value of configType is forced set to "None" regardless of
its current value.  It is not allowed to add a device type with device configuration
option set to Device Management or Legacy when the configType is not set.

**Attributes:**

|Name                                  |Type                              |Description                                  |
|--------------------------------------|----------------------------------|---------------------------------------------|
|enable_monitoring                     |bool                              |enableMonitoring                             |
|config_type                           |str                               |configType *Optional*                        |
|system_file_name                      |str                               |systemFileName *Optional*                    |
|device_file_format                    |str                               |deviceFileFormat *Optional*                  |
|device_management_device_type_options |deviceManagementDeviceTypeOptions |deviceManagementDeviceTypeOptions *Optional* |
</div>


## `CPEDeviceOptions22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CPE device's options.

The field configType is optional to allow the use of field enableMonitoring for all
device types being managed or not ie.  device configuration option equals to
DeviceManagement, or Legacy, or Not Supported). If the device configuration option is
set to "Not Supported", the value of configType is forced set to "None" regardless of
its current value.  It is not allowed to add a device type with device configuration
option set to Device Management or Legacy when the configType is not set.

**Attributes:**

|Name                                  |Type                              |Description                                  |
|--------------------------------------|----------------------------------|---------------------------------------------|
|enable_monitoring                     |bool                              |enableMonitoring                             |
|config_type                           |str                               |configType *Optional*                        |
|system_file_name                      |str                               |systemFileName *Optional*                    |
|device_file_format                    |str                               |deviceFileFormat *Optional*                  |
|device_management_device_type_options |deviceManagementDeviceTypeOptions |deviceManagementDeviceTypeOptions *Optional* |
</div>


## `CPEDeviceOptions22V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CPE device's options.

The field configType is optional to allow the use of field enableMonitoring for all
device types being managed or not ie.  device configuration option equals to
DeviceManagement, or Legacy, or Not Supported). If the device configuration option is
set to "Not Supported", the value of configType is forced set to "None" regardless of
its current value.  It is not allowed to add a device type with device configuration
option set to Device Management or Legacy when the configType is not set.

**Attributes:**

|Name                                  |Type                              |Description                                  |
|--------------------------------------|----------------------------------|---------------------------------------------|
|enable_monitoring                     |bool                              |enableMonitoring                             |
|config_type                           |str                               |configType *Optional*                        |
|system_file_name                      |str                               |systemFileName *Optional*                    |
|device_file_format                    |str                               |deviceFileFormat *Optional*                  |
|device_management_device_type_options |deviceManagementDeviceTypeOptions |deviceManagementDeviceTypeOptions *Optional* |
</div>


## `CPEDeviceOptions22V3`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CPE device's options.

The field configType is optional to allow the use of field enableMonitoring for all
device types being managed or not ie.  device configuration option equals to
DeviceManagement, or Legacy, or Not Supported). If the device configuration option is
set to "Not Supported", the value of configType is forced set to "None" regardless of
its current value.  It is not allowed to add a device type with device configuration
option set to Device Management or Legacy when the configType is not set.

**Attributes:**

|Name                                  |Type                              |Description                                  |
|--------------------------------------|----------------------------------|---------------------------------------------|
|enable_monitoring                     |bool                              |enableMonitoring                             |
|config_type                           |str                               |configType *Optional*                        |
|system_file_name                      |str                               |systemFileName *Optional*                    |
|device_file_format                    |str                               |deviceFileFormat *Optional*                  |
|device_management_device_type_options |deviceManagementDeviceTypeOptions |deviceManagementDeviceTypeOptions *Optional* |
</div>


## `CPEDeviceOptions22V4`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
CPE device's options.

The field configType is optional to allow the use of field enableMonitoring for all
device types being managed or not ie.  device configuration option equals to
DeviceManagement, or Legacy, or Not Supported). If the device configuration option is
set to "Not Supported", the value of configType is forced set to "None" regardless of
its current value.  It is not allowed to add a device type with device configuration
option set to Device Management or Legacy when the configType is not set.

**Attributes:**

|Name                                  |Type                              |Description                                  |
|--------------------------------------|----------------------------------|---------------------------------------------|
|enable_monitoring                     |bool                              |enableMonitoring                             |
|config_type                           |str                               |configType *Optional*                        |
|system_file_name                      |str                               |systemFileName *Optional*                    |
|device_file_format                    |str                               |deviceFileFormat *Optional*                  |
|device_management_device_type_options |deviceManagementDeviceTypeOptions |deviceManagementDeviceTypeOptions *Optional* |
</div>


## `CallCenterMediaOnHoldSourceModify16`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the call center media on hold source configuration.


**Attributes:**

|Name                           |Type                |Description                            |
|-------------------------------|--------------------|---------------------------------------|
|audio_message_source_selection |str                 |audioMessageSourceSelection *Optional* |
|audio_file                     |audioFile           |audioFile *Optional*                   |
|external_audio_source          |externalAudioSource |externalAudioSource *Optional*         |
|video_message_source_selection |str                 |videoMessageSourceSelection *Optional* |
|video_file                     |videoFile           |videoFile *Optional*                   |
|external_video_source          |externalVideoSource |externalVideoSource *Optional*         |
</div>


## `CallCenterMediaOnHoldSourceModify17`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the call center media on hold source configuration.


**Attributes:**

|Name                           |Type                |Description                            |
|-------------------------------|--------------------|---------------------------------------|
|audio_message_source_selection |str                 |audioMessageSourceSelection *Optional* |
|audio_url_list                 |audioUrlList        |audioUrlList *Optional*                |
|audio_file_list                |audioFileList       |audioFileList *Optional*               |
|external_audio_source          |externalAudioSource |externalAudioSource *Optional*         |
|video_message_source_selection |str                 |videoMessageSourceSelection *Optional* |
|video_url_list                 |videoUrlList        |videoUrlList *Optional*                |
|video_file_list                |videoFileList       |videoFileList *Optional*               |
|external_video_source          |externalVideoSource |externalVideoSource *Optional*         |
</div>


## `CallCenterMediaOnHoldSourceModify20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the call center media on hold source configuration.


**Attributes:**

|Name                           |Type                |Description                            |
|-------------------------------|--------------------|---------------------------------------|
|audio_message_source_selection |str                 |audioMessageSourceSelection *Optional* |
|audio_url_list                 |audioUrlList        |audioUrlList *Optional*                |
|audio_file_list                |audioFileList       |audioFileList *Optional*               |
|external_audio_source          |externalAudioSource |externalAudioSource *Optional*         |
|video_message_source_selection |str                 |videoMessageSourceSelection *Optional* |
|video_url_list                 |videoUrlList        |videoUrlList *Optional*                |
|video_file_list                |videoFileList       |videoFileList *Optional*               |
|external_video_source          |externalVideoSource |externalVideoSource *Optional*         |
</div>


## `CallCenterMediaOnHoldSourceRead16`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the call center media on hold source configuration.


**Attributes:**

|Name                           |Type                |Description                            |
|-------------------------------|--------------------|---------------------------------------|
|audio_message_source_selection |str                 |audioMessageSourceSelection            |
|audio_file_url                 |str                 |audioFileUrl *Optional*                |
|audio_file_description         |str                 |audioFileDescription *Optional*        |
|audio_file_media_type          |str                 |audioFileMediaType *Optional*          |
|external_audio_source          |externalAudioSource |externalAudioSource *Optional*         |
|video_message_source_selection |str                 |videoMessageSourceSelection *Optional* |
|video_file_url                 |str                 |videoFileUrl *Optional*                |
|video_file_description         |str                 |videoFileDescription *Optional*        |
|video_file_media_type          |str                 |videoFileMediaType *Optional*          |
|external_video_source          |externalVideoSource |externalVideoSource *Optional*         |
</div>


## `CallCenterMediaOnHoldSourceRead17`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the call center media on hold source configuration.

Replaced by: CallCenterMediaOnHoldSourceRead19.

**Attributes:**

|Name                           |Type                |Description                            |
|-------------------------------|--------------------|---------------------------------------|
|audio_message_source_selection |str                 |audioMessageSourceSelection            |
|audio_url_list                 |audioUrlList        |audioUrlList *Optional*                |
|audio_file_list                |audioFileList       |audioFileList *Optional*               |
|audio_media_type_list          |audioMediaTypeList  |audioMediaTypeList *Optional*          |
|external_audio_source          |externalAudioSource |externalAudioSource *Optional*         |
|video_message_source_selection |str                 |videoMessageSourceSelection *Optional* |
|video_url_list                 |videoUrlList        |videoUrlList *Optional*                |
|video_file_list                |videoFileList       |videoFileList *Optional*               |
|video_media_type_list          |videoMediaTypeList  |videoMediaTypeList *Optional*          |
|external_video_source          |externalVideoSource |externalVideoSource *Optional*         |
</div>


## `CallCenterMediaOnHoldSourceRead19`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the call center media on hold source configuration.


**Attributes:**

|Name                           |Type                |Description                            |
|-------------------------------|--------------------|---------------------------------------|
|audio_message_source_selection |str                 |audioMessageSourceSelection            |
|audio_url_list                 |audioUrlList        |audioUrlList *Optional*                |
|audio_file_list                |audioFileList       |audioFileList *Optional*               |
|audio_media_type_list          |audioMediaTypeList  |audioMediaTypeList *Optional*          |
|external_audio_source          |externalAudioSource |externalAudioSource *Optional*         |
|video_message_source_selection |str                 |videoMessageSourceSelection *Optional* |
|video_url_list                 |videoUrlList        |videoUrlList *Optional*                |
|video_file_list                |videoFileList       |videoFileList *Optional*               |
|video_media_type_list          |videoMediaTypeList  |videoMediaTypeList *Optional*          |
|external_video_source          |externalVideoSource |externalVideoSource *Optional*         |
</div>


## `CallCenterMediaOnHoldSourceRead20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the call center media on hold source configuration.


**Attributes:**

|Name                           |Type                |Description                            |
|-------------------------------|--------------------|---------------------------------------|
|audio_message_source_selection |str                 |audioMessageSourceSelection            |
|audio_url_list                 |audioUrlList        |audioUrlList *Optional*                |
|audio_file_list                |audioFileList       |audioFileList *Optional*               |
|external_audio_source          |externalAudioSource |externalAudioSource *Optional*         |
|video_message_source_selection |str                 |videoMessageSourceSelection *Optional* |
|video_url_list                 |videoUrlList        |videoUrlList *Optional*                |
|video_file_list                |videoFileList       |videoFileList *Optional*               |
|external_video_source          |externalVideoSource |externalVideoSource *Optional*         |
</div>


## `CallCenterMediaOnHoldSourceRead22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Contains the call center media on hold source configuration.


**Attributes:**

|Name                           |Type                |Description                            |
|-------------------------------|--------------------|---------------------------------------|
|audio_message_source_selection |str                 |audioMessageSourceSelection            |
|audio_url_list                 |audioUrlList        |audioUrlList *Optional*                |
|audio_file_list                |audioFileList       |audioFileList *Optional*               |
|external_audio_source          |externalAudioSource |externalAudioSource *Optional*         |
|video_message_source_selection |str                 |videoMessageSourceSelection *Optional* |
|video_url_list                 |videoUrlList        |videoUrlList *Optional*                |
|video_file_list                |videoFileList       |videoFileList *Optional*               |
|external_video_source          |externalVideoSource |externalVideoSource *Optional*         |
</div>


## `CallCenterReportInterval`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Report interval for call center enhanced reporting scheduled reports.


**Attributes:**

|Name    |Type    |Description        |
|--------|--------|-------------------|
|dates   |dates   |dates *Optional*   |
|current |current |current *Optional* |
|past    |past    |past *Optional*    |
</div>


## `CallCenterReportSchedule`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A schedule for call center enhanced reporting scheduled report.

It can either be a fixed time schedule or recurring schedule

**Attributes:**

|Name          |Type         |Description             |
|--------------|-------------|------------------------|
|schedule_time |scheduleTime |scheduleTime *Optional* |
|recurrence    |recurrence   |recurrence *Optional*   |
</div>


## `ConsolidatedGroupProperties`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">


**Attributes:**

|Name                             |Type                         |Description                             |
|---------------------------------|-----------------------------|----------------------------------------|
|default_domain                   |str                          |defaultDomain                           |
|user_limit                       |int                          |userLimit                               |
|group_name                       |str                          |groupName *Optional*                    |
|calling_line_id_name             |str                          |callingLineIdName *Optional*            |
|time_zone                        |str                          |timeZone *Optional*                     |
|location_dialing_code            |str                          |locationDialingCode *Optional*          |
|contact                          |contact                      |contact *Optional*                      |
|address                          |address                      |address *Optional*                      |
|network_class_of_service         |List[str]                    |networkClassOfService *Optional*        |
|default_network_class_of_service |defaultNetworkClassOfService |defaultNetworkClassOfService *Optional* |
|group_service                    |List[groupService]           |groupService *Optional*                 |
|service_policy                   |str                          |servicePolicy *Optional*                |
</div>


## `EnterpriseSessionAdmissionControlGroupGetResponse21sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Response to EnterpriseSessionAdmissionControlGroupGetRequest21sp1V2.

Returns the profile information for the session admission control group.

**Attributes:**

|Name                                               |Type          |Description                                |
|---------------------------------------------------|--------------|-------------------------------------------|
|max_session                                        |int           |maxSession                                 |
|max_user_originating_sessions                      |int           |maxUserOriginatingSessions *Optional*      |
|max_user_terminating_sessions                      |int           |maxUserTerminatingSessions *Optional*      |
|reserved_session                                   |int           |reservedSession                            |
|reserved_user_originating_sessions                 |int           |reservedUserOriginatingSessions *Optional* |
|reserved_user_terminating_sessions                 |int           |reservedUserTerminatingSessions *Optional* |
|default_group                                      |bool          |defaultGroup                               |
|count_intra_sac_group_sessions                     |bool          |countIntraSACGroupSessions                 |
|devices                                            |List[devices] |devices *Optional*                         |
|block_emergency_and_repair_calls_due_to_sac_limits |bool          |blockEmergencyAndRepairCallsDueToSACLimits |
|media_group_name                                   |str           |mediaGroupName *Optional*                  |
|access_info_pattern                                |str           |accessInfoPattern *Optional*               |
</div>


## `GroupHuntGroupAddInstanceRequest17sp1V1`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Add a Hunt Group instance to a group.

The domain is required in the serviceUserId.

The response is either `SuccessResponse()` or `ErrorResponse()`. The following
elements are only used in XS data mode: allowMembersToControlGroupBusy, use value
"false" in AS data mode enableGroupBusy, use value "false" in AS data mode

**Attributes:**

|Name                                |Type                   |Description                     |
|------------------------------------|-----------------------|--------------------------------|
|service_provider_id                 |str                    |serviceProviderId               |
|group_id                            |str                    |groupId                         |
|service_user_id                     |str                    |serviceUserId                   |
|service_instance_profile            |serviceInstanceProfile |serviceInstanceProfile          |
|policy                              |str                    |policy                          |
|hunt_after_no_answer                |bool                   |huntAfterNoAnswer               |
|no_answer_number_of_rings           |int                    |noAnswerNumberOfRings           |
|forward_after_timeout               |bool                   |forwardAfterTimeout             |
|forward_timeout_seconds             |int                    |forwardTimeoutSeconds           |
|forward_to_phone_number             |str                    |forwardToPhoneNumber *Optional* |
|agent_user_id                       |List[str]              |agentUserId *Optional*          |
|allow_call_waiting_for_agents       |bool                   |allowCallWaitingForAgents       |
|allow_members_to_control_group_busy |bool                   |allowMembersToControlGroupBusy  |
|enable_group_busy                   |bool                   |enableGroupBusy                 |
</div>


## `GroupHuntGroupGetInstanceResponse17sp1V1`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Response to GroupHuntGroupGetInstanceRequest17sp1V1.

Contains the service profile information and a table of assigned users.  The table has
column headings: "User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana
First Name", "Weight". The following elements are only used in XS data mode:
allowMembersToControlGroupBusy enableGroupBusy

**Attributes:**

|Name                                |Type                   |Description                                                   |
|------------------------------------|-----------------------|--------------------------------------------------------------|
|service_instance_profile            |serviceInstanceProfile |serviceInstanceProfile                                        |
|policy                              |str                    |policy                                                        |
|hunt_after_no_answer                |bool                   |huntAfterNoAnswer                                             |
|no_answer_number_of_rings           |int                    |noAnswerNumberOfRings                                         |
|forward_after_timeout               |bool                   |forwardAfterTimeout                                           |
|forward_timeout_seconds             |int                    |forwardTimeoutSeconds                                         |
|forward_to_phone_number             |str                    |forwardToPhoneNumber *Optional*                               |
|agent_user_table                    |List(agentUserTable)   |agentUserTable - *Table* array of agentUserTable named tuples |
|allow_call_waiting_for_agents       |bool                   |allowCallWaitingForAgents                                     |
|allow_members_to_control_group_busy |bool                   |allowMembersToControlGroupBusy                                |
|enable_group_busy                   |bool                   |enableGroupBusy                                               |
</div>


## `GroupTrunkGroupAddInstanceRequest14sp9A`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Add a Trunk Group instance to a group.

The response is either a `SuccessResponse()` or an `ErrorResponse()`.

**Attributes:**

|Name                                            |Type                                       |Description                                           |
|------------------------------------------------|-------------------------------------------|------------------------------------------------------|
|service_provider_id                             |str                                        |serviceProviderId                                     |
|group_id                                        |str                                        |groupId                                               |
|name                                            |str                                        |name                                                  |
|pilot_user                                      |pilotUser                                  |pilotUser *Optional*                                  |
|department                                      |department                                 |department *Optional*                                 |
|access_device                                   |accessDevice                               |accessDevice *Optional*                               |
|max_active_calls                                |int                                        |maxActiveCalls                                        |
|max_incoming_calls                              |int                                        |maxIncomingCalls *Optional*                           |
|max_outgoing_calls                              |int                                        |maxOutgoingCalls *Optional*                           |
|enable_bursting                                 |bool                                       |enableBursting                                        |
|bursting_max_active_calls                       |int                                        |burstingMaxActiveCalls *Optional*                     |
|bursting_max_incoming_calls                     |int                                        |burstingMaxIncomingCalls *Optional*                   |
|bursting_max_outgoing_calls                     |int                                        |burstingMaxOutgoingCalls *Optional*                   |
|capacity_exceeded_action                        |str                                        |capacityExceededAction *Optional*                     |
|capacity_exceeded_forward_address               |str                                        |capacityExceededForwardAddress *Optional*             |
|capacity_exceeded_reroute_trunk_group_key       |capacityExceededRerouteTrunkGroupKey       |capacityExceededRerouteTrunkGroupKey *Optional*       |
|capacity_exceeded_trap_initial_calls            |int                                        |capacityExceededTrapInitialCalls                      |
|capacity_exceeded_trap_offset_calls             |int                                        |capacityExceededTrapOffsetCalls                       |
|unreachable_destination_action                  |str                                        |unreachableDestinationAction *Optional*               |
|unreachable_destination_forward_address         |str                                        |unreachableDestinationForwardAddress *Optional*       |
|unreachable_destination_reroute_trunk_group_key |unreachableDestinationRerouteTrunkGroupKey |unreachableDestinationRerouteTrunkGroupKey *Optional* |
|unreachable_destination_trap_initial_calls      |int                                        |unreachableDestinationTrapInitialCalls                |
|unreachable_destination_trap_offset_calls       |int                                        |unreachableDestinationTrapOffsetCalls                 |
|invitation_timeout                              |int                                        |invitationTimeout                                     |
|require_authentication                          |bool                                       |requireAuthentication                                 |
|sip_authentication_user_name                    |str                                        |sipAuthenticationUserName *Optional*                  |
|sip_authentication_password                     |str                                        |sipAuthenticationPassword *Optional*                  |
|hosted_user_id                                  |List[str]                                  |hostedUserId *Optional*                               |
|trunk_group_identity                            |str                                        |trunkGroupIdentity *Optional*                         |
|otg_dtg_identity                                |str                                        |otgDtgIdentity *Optional*                             |
|include_trunk_group_identity                    |bool                                       |includeTrunkGroupIdentity                             |
|include_dtg_identity                            |bool                                       |includeDtgIdentity                                    |
|enable_network_address_identity                 |bool                                       |enableNetworkAddressIdentity                          |
|allow_unscreened_calls                          |bool                                       |allowUnscreenedCalls                                  |
|allow_unscreened_emergency_calls                |bool                                       |allowUnscreenedEmergencyCalls                         |
|pilot_user_calling_line_identity_policy         |str                                        |pilotUserCallingLineIdentityPolicy                    |
|pilot_user_charge_number_policy                 |str                                        |pilotUserChargeNumberPolicy                           |
|call_forwarding_always_action                   |str                                        |callForwardingAlwaysAction *Optional*                 |
|call_forwarding_always_forward_address          |str                                        |callForwardingAlwaysForwardAddress *Optional*         |
|call_forwarding_always_reroute_trunk_group_key  |callForwardingAlwaysRerouteTrunkGroupKey   |callForwardingAlwaysRerouteTrunkGroupKey *Optional*   |
</div>


## `OutgoingCallingPlanDigitPatternCallMeNowDepartmentPermissions`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Calling Plan Call Me Now call permissions for specified digit patterns.


**Attributes:**

|Name                      |Type                    |Description             |
|--------------------------|------------------------|------------------------|
|department_key            |departmentKey           |departmentKey           |
|department_name           |str                     |departmentName          |
|digit_pattern_permissions |digitPatternPermissions |digitPatternPermissions |
</div>


## `OutgoingCallingPlanDigitPatternCallMeNowDepartmentPermissionsModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Modify outgoing Calling Plan Call Me Now call permissions for specified digit
patterns.


**Attributes:**

|Name                      |Type                    |Description             |
|--------------------------|------------------------|------------------------|
|department_key            |departmentKey           |departmentKey           |
|digit_pattern_permissions |digitPatternPermissions |digitPatternPermissions |
</div>


## `OutgoingCallingPlanDigitPatternOriginatingDepartmentPermissions`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Calling Plan originating call permissions for specified digit patterns.


**Attributes:**

|Name                      |Type                    |Description             |
|--------------------------|------------------------|------------------------|
|department_key            |departmentKey           |departmentKey           |
|department_name           |str                     |departmentName          |
|digit_pattern_permissions |digitPatternPermissions |digitPatternPermissions |
</div>


## `OutgoingCallingPlanDigitPatternOriginatingDepartmentPermissionsModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Modify outgoing Calling Plan originating call permissions for specified digit
patterns.


**Attributes:**

|Name                      |Type                    |Description             |
|--------------------------|------------------------|------------------------|
|department_key            |departmentKey           |departmentKey           |
|digit_pattern_permissions |digitPatternPermissions |digitPatternPermissions |
</div>


## `OutgoingCallingPlanDigitPatternRedirectingDepartmentPermissions`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Calling Plan redirecting call permissions for specified digit patterns.


**Attributes:**

|Name                      |Type                    |Description             |
|--------------------------|------------------------|------------------------|
|department_key            |departmentKey           |departmentKey           |
|department_name           |str                     |departmentName          |
|digit_pattern_permissions |digitPatternPermissions |digitPatternPermissions |
</div>


## `OutgoingCallingPlanDigitPatternRedirectingDepartmentPermissionsModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Modify outgoing Calling Plan redirecting call permissions for specified digit
patterns.


**Attributes:**

|Name                      |Type                    |Description             |
|--------------------------|------------------------|------------------------|
|department_key            |departmentKey           |departmentKey           |
|digit_pattern_permissions |digitPatternPermissions |digitPatternPermissions |
</div>


## `OutgoingPinholeDigitPlanDigitPatternCallMeNowDepartmentPermissions`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Pinhole Digit Plan Call Me Now call permissions for a department.


**Attributes:**

|Name            |Type          |Description    |
|----------------|--------------|---------------|
|department_key  |departmentKey |departmentKey  |
|department_name |str           |departmentName |
|permissions     |permissions   |permissions    |
</div>


## `OutgoingPinholeDigitPlanDigitPatternCallMeNowDepartmentPermissionsModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Modify Outgoing Pinhole Digit Plan Call Me Now call permissions for specified digit
patterns.


**Attributes:**

|Name                      |Type                    |Description             |
|--------------------------|------------------------|------------------------|
|department_key            |departmentKey           |departmentKey           |
|digit_pattern_permissions |digitPatternPermissions |digitPatternPermissions |
</div>


## `OutgoingPinholeDigitPlanDigitPatternOriginatingDepartmentPermissions`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Pinhole Digit Plan department originating call permissions for specified
digit patterns.


**Attributes:**

|Name                      |Type                    |Description             |
|--------------------------|------------------------|------------------------|
|department_key            |departmentKey           |departmentKey           |
|department_name           |str                     |departmentName          |
|digit_pattern_permissions |digitPatternPermissions |digitPatternPermissions |
</div>


## `OutgoingPinholeDigitPlanDigitPatternOriginatingDepartmentPermissionsModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Modify Outgoing Pinhole Digit Plan originating call permissions for specified digit
patterns.


**Attributes:**

|Name                      |Type                    |Description             |
|--------------------------|------------------------|------------------------|
|department_key            |departmentKey           |departmentKey           |
|digit_pattern_permissions |digitPatternPermissions |digitPatternPermissions |
</div>


## `OutgoingPinholeDigitPlanDigitPatternRedirectingDepartmentPermissions`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Outgoing Pinhole Digit Plan initiating call forwards/transfer permissions for a
department.


**Attributes:**

|Name            |Type          |Description    |
|----------------|--------------|---------------|
|department_key  |departmentKey |departmentKey  |
|department_name |str           |departmentName |
|permissions     |permissions   |permissions    |
</div>


## `OutgoingPinholeDigitPlanDigitPatternRedirectingDepartmentPermissionsModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Modify Outgoing Pinhole Digit Plan redirecting call permissions for specified digit
patterns.


**Attributes:**

|Name                      |Type                    |Description             |
|--------------------------|------------------------|------------------------|
|department_key            |departmentKey           |departmentKey           |
|digit_pattern_permissions |digitPatternPermissions |digitPatternPermissions |
</div>


## `PushNotificationRegistrationData`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
? The common push notification registration elements.


**Attributes:**

|Name                             |Type                            |Description                          |
|---------------------------------|--------------------------------|-------------------------------------|
|registration_id                  |str                             |registrationId                       |
|application_id                   |str                             |applicationId                        |
|application_version              |str                             |applicationVersion                   |
|device_os_type                   |str                             |deviceOsType                         |
|device_version                   |str                             |deviceVersion                        |
|timestamp                        |str                             |timestamp                            |
|push_notification_client_version |str                             |pushNotificationClientVersion        |
|push_notification_token_data     |List[pushNotificationTokenData] |pushNotificationTokenData *Optional* |
</div>


## `ReplacementCombinedGroupServiceAuthorizationList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of group services that replaces a previously authorized group services.


**Attributes:**

|Name                        |Type                            |Description               |
|----------------------------|--------------------------------|--------------------------|
|group_service_authorization |List[groupServiceAuthorization] |groupServiceAuthorization |
</div>


## `ReplacementCombinedServicePackAssignmentList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of service packs that replaces existing service packs assgined to the user.

If a service pack is already assigned to the user, the service quantitiy will be
updated if included.

**Attributes:**

|Name         |Type              |Description |
|-------------|------------------|------------|
|service_pack |List[servicePack] |servicePack |
</div>


## `ReplacementCombinedServicePackAuthorizationList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of service packs that replaces previously authorized service packs.


**Attributes:**

|Name                       |Type                           |Description              |
|---------------------------|-------------------------------|-------------------------|
|service_pack_authorization |List[servicePackAuthorization] |servicePackAuthorization |
</div>


## `ReplacementCombinedSharedCallAppearanceAccessDeviceMultipleIdentityEndpointList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of shared call appearance endpoints that replaces existing endpoints.


**Attributes:**

|Name                                          |Type                                           |Description                              |
|----------------------------------------------|-----------------------------------------------|-----------------------------------------|
|shared_call_appearance_access_device_endpoint |List[sharedCallAppearanceAccessDeviceEndpoint] |sharedCallAppearanceAccessDeviceEndpoint |
</div>


## `ReplacementCombinedUserServiceAssignmentList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of user services that replaces existing user services assgined to the user.

If a service is already assigned to the user, the service quantitiy will be updated if
included.

**Attributes:**

|Name         |Type              |Description |
|-------------|------------------|------------|
|service_name |List[serviceName] |serviceName |
</div>


## `ReplacementCombinedUserServiceAuthorizationList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of user services that replaces a previously authorized user services.


**Attributes:**

|Name                       |Type                           |Description              |
|---------------------------|-------------------------------|-------------------------|
|user_service_authorization |List[userServiceAuthorization] |userServiceAuthorization |
</div>


## `ReplacementConsolidatedServicePackAssignmentList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of service packs that replaces existing service packs assigned to the user.

If a service pack is not authorized to the group, the service will be authorized.  The
authorizedQuantity will be used if provided; otherwise, the service quantity will be
set to unlimited.  The command will fail if the authorized Quantity set at the service
provider is insufficient If a service pack is already authorized to the group, the
service quantity will be ignored if included.

**Attributes:**

|Name         |Type              |Description |
|-------------|------------------|------------|
|service_pack |List[servicePack] |servicePack |
</div>


## `ReplacementConsolidatedSharedCallAppearanceAccessDeviceMultipleIdentityEndpointList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of shared call appearance endpoints that replaces existing endpoints.


**Attributes:**

|Name                                          |Type                                           |Description                              |
|----------------------------------------------|-----------------------------------------------|-----------------------------------------|
|shared_call_appearance_access_device_endpoint |List[sharedCallAppearanceAccessDeviceEndpoint] |sharedCallAppearanceAccessDeviceEndpoint |
</div>


## `ReplacementConsolidatedSharedCallAppearanceAccessDeviceMultipleIdentityEndpointList22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of shared call appearance endpoints that replaces existing endpoints.


**Attributes:**

|Name                                          |Type                                           |Description                              |
|----------------------------------------------|-----------------------------------------------|-----------------------------------------|
|shared_call_appearance_access_device_endpoint |List[sharedCallAppearanceAccessDeviceEndpoint] |sharedCallAppearanceAccessDeviceEndpoint |
</div>


## `ReplacementConsolidatedUserServiceAssignmentList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of user services that replaces existing user services assigned to the user.

If a service is not authorized to the group, the service will be authorized.  The
authorizedQuantity will be used if provided; otherwise, the service quantity will be
set to unlimited.  The command will fail if the authorized Quantity set at the service
provider is insufficient.  If a service is already authorized to the group, the
service quantity will be ignored if included.

**Attributes:**

|Name                      |Type                         |Description            |
|--------------------------|-----------------------------|-----------------------|
|user_service_service_name |List[userServiceServiceName] |userServiceServiceName |
</div>


## `ReplacementEnterpriseDeviceList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of enterprise accessible devices that replaces a previously configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name   |Type         |Description|
|-------|-------------|-----------|
|device |List[device] |device     |
</div>


## `ReplacementEnterpriseEnterpriseTrunkPriorityWeightedTrunkGroupList`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
A list of enterprise trunk priority weighted trunk groups that replaces a previously
configured list.

By convention, an element of this type may be set nill to clear the list.

**Attributes:**

|Name        |Type             |Description|
|------------|-----------------|-----------|
|trunk_group |List[trunkGroup] |trunkGroup |
</div>


## `SystemSIPDeviceTypeGetResponse18sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Response to SystemSIPDeviceTypeGetRequest18sp1V2.

The following elements are only used in AS data mode: holdAnnouncementMethod
supportRFC3398 The following elements are only used in XS data mode:
enable3G4GContinuity The following element values are only applicable in AS data mode:
holdNormalization=useRfc3264Hold

**Attributes:**

|Name                                     |Type             |Description                          |
|-----------------------------------------|-----------------|-------------------------------------|
|is_obsolete                              |bool             |isObsolete                           |
|number_of_ports                          |numberOfPorts    |numberOfPorts                        |
|profile                                  |str              |profile                              |
|registration_capable                     |bool             |registrationCapable                  |
|is_conference_device                     |bool             |isConferenceDevice                   |
|is_mobility_manager_device               |bool             |isMobilityManagerDevice              |
|is_music_on_hold_device                  |bool             |isMusicOnHoldDevice                  |
|hold_normalization                       |str              |holdNormalization                    |
|hold_announcement_method                 |str              |holdAnnouncementMethod               |
|is_trusted                               |bool             |isTrusted                            |
|e164_capable                             |bool             |E164Capable                          |
|route_advance                            |bool             |routeAdvance                         |
|forwarding_override                      |bool             |forwardingOverride                   |
|wireless_integration                     |bool             |wirelessIntegration                  |
|web_based_config_url                     |str              |webBasedConfigURL *Optional*         |
|is_video_capable                         |bool             |isVideoCapable                       |
|pbx_integration                          |bool             |PBXIntegration                       |
|static_registration_capable              |bool             |staticRegistrationCapable            |
|cpe_device_options                       |cpeDeviceOptions |cpeDeviceOptions *Optional*          |
|protocol_choice                          |List[str]        |protocolChoice                       |
|early_media_support                      |str              |earlyMediaSupport                    |
|authenticate_refer                       |bool             |authenticateRefer                    |
|auto_config_soft_client                  |bool             |autoConfigSoftClient                 |
|authentication_mode                      |str              |authenticationMode                   |
|requires_broad_works_digit_collection    |bool             |requiresBroadWorksDigitCollection    |
|requires_broad_works_call_waiting_tone   |bool             |requiresBroadWorksCallWaitingTone    |
|requires_mwi_subscription                |bool             |requiresMWISubscription              |
|use_history_info_header_on_access_side   |bool             |useHistoryInfoHeaderOnAccessSide     |
|advice_of_charge_capable                 |bool             |adviceOfChargeCapable                |
|reset_event                              |str              |resetEvent *Optional*                |
|support_call_center_mime_type            |bool             |supportCallCenterMIMEType            |
|trunk_mode                               |str              |trunkMode                            |
|add_p_called_party_id                    |bool             |addPCalledPartyId                    |
|support_identity_in_update_and_re_invite |bool             |supportIdentityInUpdateAndReInvite   |
|unscreened_presentation_identity_policy  |str              |unscreenedPresentationIdentityPolicy |
|enable3_g4_g_continuity                  |bool             |enable3G4GContinuity                 |
|support_emergency_disconnect_control     |bool             |supportEmergencyDisconnectControl    |
|device_type_configuration_option         |str              |deviceTypeConfigurationOption        |
|support_rfc3398                          |bool             |supportRFC3398                       |
</div>


## `SystemSIPDeviceTypeGetResponse21sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Response to SystemSIPDeviceTypeGetRequest21sp1V2.

The following elements are only used in AS data mode: holdAnnouncementMethod
supportRFC3398 supportClientSessionInfo supportCallInfoConferenceSubscriptionURI
supportRemotePartyInfo The following elements are only used in XS data mode:
enhancedForICS - value false is returned in AS data mode enable3G4GContinuity - value
false is returned in AS data mode publishesOwnPresence - value false is returned in AS
data mode locationNetwork, value Fixed is returned in AS data mode The following
element values are only applicable in AS data mode: holdNormalization=useRfc3264Hold
The following elements are only used in AS data mode: supportCauseParameter - value
false is returned in XS data mode Replaced by: `SystemSIPDeviceTypeGetResponse22()` in
AS data mode.

**Attributes:**

|Name                                          |Type             |Description                              |
|----------------------------------------------|-----------------|-----------------------------------------|
|is_obsolete                                   |bool             |isObsolete                               |
|number_of_ports                               |numberOfPorts    |numberOfPorts                            |
|profile                                       |str              |profile                                  |
|registration_capable                          |bool             |registrationCapable                      |
|is_conference_device                          |bool             |isConferenceDevice                       |
|is_mobility_manager_device                    |bool             |isMobilityManagerDevice                  |
|is_music_on_hold_device                       |bool             |isMusicOnHoldDevice                      |
|hold_normalization                            |str              |holdNormalization                        |
|hold_announcement_method                      |str              |holdAnnouncementMethod                   |
|is_trusted                                    |bool             |isTrusted                                |
|e164_capable                                  |bool             |E164Capable                              |
|route_advance                                 |bool             |routeAdvance                             |
|forwarding_override                           |bool             |forwardingOverride                       |
|wireless_integration                          |bool             |wirelessIntegration                      |
|web_based_config_url                          |str              |webBasedConfigURL *Optional*             |
|is_video_capable                              |bool             |isVideoCapable                           |
|pbx_integration                               |bool             |PBXIntegration                           |
|static_registration_capable                   |bool             |staticRegistrationCapable                |
|cpe_device_options                            |cpeDeviceOptions |cpeDeviceOptions *Optional*              |
|protocol_choice                               |List[str]        |protocolChoice                           |
|early_media_support                           |str              |earlyMediaSupport                        |
|authenticate_refer                            |bool             |authenticateRefer                        |
|auto_config_soft_client                       |bool             |autoConfigSoftClient                     |
|authentication_mode                           |str              |authenticationMode                       |
|requires_broad_works_digit_collection         |bool             |requiresBroadWorksDigitCollection        |
|requires_broad_works_call_waiting_tone        |bool             |requiresBroadWorksCallWaitingTone        |
|requires_mwi_subscription                     |bool             |requiresMWISubscription                  |
|use_history_info_header_on_access_side        |bool             |useHistoryInfoHeaderOnAccessSide         |
|advice_of_charge_capable                      |bool             |adviceOfChargeCapable                    |
|reset_event                                   |str              |resetEvent *Optional*                    |
|support_call_center_mime_type                 |bool             |supportCallCenterMIMEType                |
|trunk_mode                                    |str              |trunkMode                                |
|add_p_called_party_id                         |bool             |addPCalledPartyId                        |
|support_identity_in_update_and_re_invite      |bool             |supportIdentityInUpdateAndReInvite       |
|unscreened_presentation_identity_policy       |str              |unscreenedPresentationIdentityPolicy     |
|enhanced_for_ics                              |bool             |enhancedForICS                           |
|support_emergency_disconnect_control          |bool             |supportEmergencyDisconnectControl        |
|device_type_configuration_option              |str              |deviceTypeConfigurationOption            |
|support_rfc3398                               |bool             |supportRFC3398                           |
|static_line_ordering                          |bool             |staticLineOrdering                       |
|support_client_session_info                   |bool             |supportClientSessionInfo                 |
|support_call_info_conference_subscription_uri |bool             |supportCallInfoConferenceSubscriptionURI |
|support_remote_party_info                     |bool             |supportRemotePartyInfo                   |
|support_visual_device_management              |bool             |supportVisualDeviceManagement            |
|bypass_media_treatment                        |bool             |bypassMediaTreatment                     |
|supports3_g4_g_continuity                     |bool             |supports3G4GContinuity                   |
|publishes_own_presence                        |bool             |publishesOwnPresence                     |
|support_cause_parameter                       |bool             |supportCauseParameter                    |
|location_network                              |str              |locationNetwork                          |
</div>


## `TrunkAddressingMultipleContactAdd22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Trunk group endpoint that can have multiple contacts.

alternateTrunkIdentityDomain is only used in XS mode and the AS when deployed in IMS
mode.  Both alternateTrunkIdentity and AlternateTrunkIdentityDomain should be set at
the same time if one is set in XS mode.  The following elements are only used in AS
data mode and are ignored in XS data mode: physicalLocation

**Attributes:**

|Name                            |Type                     |Description                             |
|--------------------------------|-------------------------|----------------------------------------|
|trunk_group_device_endpoint     |trunkGroupDeviceEndpoint |trunkGroupDeviceEndpoint *Optional*     |
|enterprise_trunk_name           |str                      |enterpriseTrunkName *Optional*          |
|alternate_trunk_identity        |str                      |alternateTrunkIdentity *Optional*       |
|alternate_trunk_identity_domain |str                      |alternateTrunkIdentityDomain *Optional* |
|physical_location               |str                      |physicalLocation *Optional*             |
</div>


## `TrunkAddressingMultipleContactModify`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Trunk group endpoint that can have multiple contacts.

alternateTrunkIdentityDomain is only used in XS mode and the AS when deployed in IMS
mode.  Setting alternateTrunkIdentity or alternateTrunkIdentityDomain to nil in XS
mode, the other one paremter should be set to nil at the same time.  The following
elements are only used in AS data mode and are ignored in XS data mode:
physicalLocation

**Attributes:**

|Name                            |Type                     |Description                             |
|--------------------------------|-------------------------|----------------------------------------|
|trunk_group_device_endpoint     |trunkGroupDeviceEndpoint |trunkGroupDeviceEndpoint *Optional*     |
|enterprise_trunk_name           |str                      |enterpriseTrunkName *Optional*          |
|alternate_trunk_identity        |str                      |alternateTrunkIdentity *Optional*       |
|alternate_trunk_identity_domain |str                      |alternateTrunkIdentityDomain *Optional* |
|physical_location               |str                      |physicalLocation *Optional*             |
</div>


## `TrunkAddressingMultipleContactRead22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Trunk group endpoint that can have multiple contacts.

alternateTrunkIdentityDomain is only used in XS mode and the AS when deployed in IMS
mode.  The following elements are only used in AS data mode and are ignored in XS data
mode: physicalLocation

**Attributes:**

|Name                            |Type                     |Description                             |
|--------------------------------|-------------------------|----------------------------------------|
|trunk_group_device_endpoint     |trunkGroupDeviceEndpoint |trunkGroupDeviceEndpoint *Optional*     |
|enterprise_trunk_name           |str                      |enterpriseTrunkName *Optional*          |
|alternate_trunk_identity        |str                      |alternateTrunkIdentity *Optional*       |
|alternate_trunk_identity_domain |str                      |alternateTrunkIdentityDomain *Optional* |
|physical_location               |str                      |physicalLocation *Optional*             |
</div>


## `TrunkGroupDeviceMultipleContactEndpointModify22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Trunk group device endpoint used in the context of modify that can have multiple
contacts.


**Attributes:**

|Name         |Type        |Description            |
|-------------|------------|-----------------------|
|name         |str         |name *Optional*        |
|line_port    |str         |linePort *Optional*    |
|contact_list |contactList |contactList *Optional* |
</div>


## `UserBroadWorksMobilityMobileIdentityGetResponse21sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Response to a UserBroadWorksMobilityMobileIdentityGetRequest21sp1V2.

Columns for the mobileNumberAlertedTable are as follows: "Mobile Number", "Country
Code", "National Prefix"

**Attributes:**

|Name                                      |Type                           |Description                                                                       |
|------------------------------------------|-------------------------------|----------------------------------------------------------------------------------|
|description                               |str                            |description *Optional*                                                            |
|is_primary                                |bool                           |isPrimary                                                                         |
|enable_alerting                           |bool                           |enableAlerting                                                                    |
|alert_agent_calls                         |bool                           |alertAgentCalls                                                                   |
|alert_click_to_dial_calls                 |bool                           |alertClickToDialCalls                                                             |
|alert_group_paging_calls                  |bool                           |alertGroupPagingCalls                                                             |
|use_mobility_calling_line_id              |bool                           |useMobilityCallingLineID                                                          |
|enable_diversion_inhibitor                |bool                           |enableDiversionInhibitor                                                          |
|require_answer_confirmation               |bool                           |requireAnswerConfirmation                                                         |
|broadworks_call_control                   |bool                           |broadworksCallControl                                                             |
|use_setting_level                         |str                            |useSettingLevel                                                                   |
|deny_call_originations                    |bool                           |denyCallOriginations                                                              |
|deny_call_terminations                    |bool                           |denyCallTerminations                                                              |
|effective_enable_location_services        |bool                           |effectiveEnableLocationServices                                                   |
|effective_enable_msrn_lookup              |bool                           |effectiveEnableMSRNLookup                                                         |
|effective_enable_mobile_state_checking    |bool                           |effectiveEnableMobileStateChecking                                                |
|effective_enable_announcement_suppression |bool                           |effectiveEnableAnnouncementSuppression                                            |
|effective_deny_call_originations          |bool                           |effectiveDenyCallOriginations                                                     |
|effective_deny_call_terminations          |bool                           |effectiveDenyCallTerminations                                                     |
|devices_to_ring                           |str                            |devicesToRing                                                                     |
|include_shared_call_appearance            |bool                           |includeSharedCallAppearance                                                       |
|include_broadworks_anywhere               |bool                           |includeBroadworksAnywhere                                                         |
|include_executive_assistant               |bool                           |includeExecutiveAssistant                                                         |
|enable_call_anchoring                     |bool                           |enableCallAnchoring                                                               |
|time_schedule                             |timeSchedule                   |timeSchedule *Optional*                                                           |
|holiday_schedule                          |holidaySchedule                |holidaySchedule *Optional*                                                        |
|access_device_endpoint                    |accessDeviceEndpoint           |accessDeviceEndpoint *Optional*                                                   |
|outbound_alternate_number                 |str                            |outboundAlternateNumber *Optional*                                                |
|enable_direct_routing                     |bool                           |enableDirectRouting                                                               |
|mark_cdr_as_enterprise_group_calls        |bool                           |markCDRAsEnterpriseGroupCalls                                                     |
|mobile_number_alerted_table               |List(mobileNumberAlertedTable) |mobileNumberAlertedTable - *Table* array of mobileNumberAlertedTable named tuples |
</div>


## `UserEnhancedCallLogsGetListRequest17sp4V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Request user's call logs.

If the callLogType is not specified, all types of calls logs (placed, received,
missed) are returned.  The filters "dateTimeRange", "numberFilter",
"redirectedNumberFilter", "accountAuthorizationCodeFilter"
"callAuthorizationCodeFilter" and "subscriberType" are ignored if call logs are stored
in CDS. When "ReceivedOrMissed" is specified as "callLogType" and call logs are stored
in CDS, all call logs including placed will be returned.  It is possible to restrict
the number of rows returned using responsePagingControl.  If responsePagingControl is
not specified, the value of Enhanced Call Logs system parameter
maxNonPagedResponseSize will control the maximum number of call logs can be returned.

The response is either a UserEnhancedCallLogsGetListResponse17sp4V2 or an
`ErrorResponse()`. The following elements are only used in AS data mode and not
returned in XS data mode: callAuthorizationCodeFilter

**Attributes:**

|Name                              |Type                           |Description                               |
|----------------------------------|-------------------------------|------------------------------------------|
|user_id                           |str                            |userId                                    |
|call_log_type                     |str                            |callLogType *Optional*                    |
|date_time_range                   |dateTimeRange                  |dateTimeRange                             |
|number_filter                     |numberFilter                   |numberFilter *Optional*                   |
|redirected_number_filter          |redirectedNumberFilter         |redirectedNumberFilter *Optional*         |
|account_authorization_code_filter |accountAuthorizationCodeFilter |accountAuthorizationCodeFilter *Optional* |
|call_authorization_code_filter    |callAuthorizationCodeFilter    |callAuthorizationCodeFilter *Optional*    |
|subscriber_type                   |str                            |subscriberType *Optional*                 |
|response_paging_control           |responsePagingControl          |responsePagingControl *Optional*          |
</div>


## `UserEnhancedCallLogsGetListRequest21sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Request user's call logs.

If the callLogType is not specified, all types of calls logs (placed, received,
missed) are returned.  The filters "dateTimeRange", "numberFilter",
"redirectedNumberFilter", "accountAuthorizationCodeFilter"
"callAuthorizationCodeFilter" and "subscriberType" are ignored if call logs are stored
in CDS. When "ReceivedOrMissed" is specified as "callLogType" and call logs are stored
in CDS, all call logs including placed will be returned.  It is possible to restrict
the number of rows returned using responsePagingControl.  If responsePagingControl is
not specified, the value of Enhanced Call Logs system parameter
maxNonPagedResponseSize will control the maximum number of call logs can be returned.

The response is either a UserEnhancedCallLogsGetListResponse21sp1V2 or an
`ErrorResponse()`. The following elements are only used in AS data mode and ignored in
XS data mode: callAuthorizationCodeFilter

**Attributes:**

|Name                              |Type                           |Description                               |
|----------------------------------|-------------------------------|------------------------------------------|
|user_id                           |str                            |userId                                    |
|call_log_type                     |str                            |callLogType *Optional*                    |
|date_time_range                   |dateTimeRange                  |dateTimeRange                             |
|number_filter                     |numberFilter                   |numberFilter *Optional*                   |
|redirected_number_filter          |redirectedNumberFilter         |redirectedNumberFilter *Optional*         |
|account_authorization_code_filter |accountAuthorizationCodeFilter |accountAuthorizationCodeFilter *Optional* |
|call_authorization_code_filter    |callAuthorizationCodeFilter    |callAuthorizationCodeFilter *Optional*    |
|subscriber_type                   |str                            |subscriberType *Optional*                 |
|response_paging_control           |responsePagingControl          |responsePagingControl *Optional*          |
</div>


## `UserGetResponse21sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Response to UserGetRequest21sp1V2.

It is possible that the TrunkAddressingRead element is present with nothing populated
in it which means the user is a trunk user.  The following data elements are only used
in AS data mode and not returned in HSS data mode: contact[2]-contact[5]
alternateUserId The following data elements are only used in IMS data mode:
alternateTrunkIdentityDomain The country code (countryCode) included is the user's
phone number country code when the user has a phone number assigned, or the user's
Group associated country code when the user does not have a phone number assigned, or
the system default country code when the user's Group does not have an associated
country code.  The nationalPrefix in this response is the one associated to the
included countryCode.  The callingLineIdPhoneNumber is no longer being formatted for
display purpose.  The value is returned exactly the same as being stored.

**Attributes:**

|Name                         |Type                  |Description                         |
|-----------------------------|----------------------|------------------------------------|
|service_provider_id          |str                   |serviceProviderId                   |
|group_id                     |str                   |groupId                             |
|last_name                    |str                   |lastName                            |
|first_name                   |str                   |firstName                           |
|calling_line_id_last_name    |str                   |callingLineIdLastName               |
|calling_line_id_first_name   |str                   |callingLineIdFirstName              |
|name_dialing_name            |nameDialingName       |nameDialingName *Optional*          |
|hiragana_last_name           |str                   |hiraganaLastName *Optional*         |
|hiragana_first_name          |str                   |hiraganaFirstName *Optional*        |
|phone_number                 |str                   |phoneNumber *Optional*              |
|extension                    |str                   |extension *Optional*                |
|calling_line_id_phone_number |str                   |callingLineIdPhoneNumber *Optional* |
|department                   |department            |department *Optional*               |
|department_full_path         |str                   |departmentFullPath *Optional*       |
|language                     |str                   |language                            |
|time_zone                    |str                   |timeZone                            |
|time_zone_display_name       |str                   |timeZoneDisplayName                 |
|default_alias                |str                   |defaultAlias                        |
|alias                        |List[str]             |alias *Optional*                    |
|access_device_endpoint       |accessDeviceEndpoint  |accessDeviceEndpoint *Optional*     |
|trunk_addressing             |trunkAddressing       |trunkAddressing *Optional*          |
|title                        |str                   |title *Optional*                    |
|pager_phone_number           |str                   |pagerPhoneNumber *Optional*         |
|mobile_phone_number          |str                   |mobilePhoneNumber *Optional*        |
|email_address                |str                   |emailAddress *Optional*             |
|yahoo_id                     |str                   |yahooId *Optional*                  |
|address_location             |str                   |addressLocation *Optional*          |
|address                      |address               |address *Optional*                  |
|country_code                 |str                   |countryCode                         |
|national_prefix              |str                   |nationalPrefix *Optional*           |
|network_class_of_service     |str                   |networkClassOfService *Optional*    |
|office_zone_name             |str                   |officeZoneName *Optional*           |
|primary_zone_name            |str                   |primaryZoneName *Optional*          |
|imp_id                       |str                   |impId *Optional*                    |
|alternate_user_id            |List[alternateUserId] |alternateUserId *Optional*          |
</div>


## `AutoAttendantAddMenu`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The configuration of the automated receptionist greeting prompt and dialing menu to be
used during after business hours.


**Attributes:**

|Name                                      |Type                   |Description                          |
|------------------------------------------|-----------------------|-------------------------------------|
|announcement_selection                    |str                    |announcementSelection                |
|audio_file                                |audioFile              |audioFile *Optional*                 |
|video_file                                |videoFile              |videoFile *Optional*                 |
|enable_first_menu_level_extension_dialing |bool                   |enableFirstMenuLevelExtensionDialing |
|key_configuration                         |List[keyConfiguration] |keyConfiguration *Optional*          |
</div>


## `AutoAttendantAddMenu16`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The configuration of the automated receptionist greeting prompt and dialing menu to be
used during after business hours.


**Attributes:**

|Name                                      |Type                   |Description                          |
|------------------------------------------|-----------------------|-------------------------------------|
|announcement_selection                    |str                    |announcementSelection                |
|audio_file                                |audioFile              |audioFile *Optional*                 |
|video_file                                |videoFile              |videoFile *Optional*                 |
|enable_first_menu_level_extension_dialing |bool                   |enableFirstMenuLevelExtensionDialing |
|key_configuration                         |List[keyConfiguration] |keyConfiguration *Optional*          |
</div>


## `AutoAttendantAddMenu19`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The configuration of the automated receptionist greeting prompt and dialing menu to be
used during after business hours.


**Attributes:**

|Name                                      |Type                   |Description                          |
|------------------------------------------|-----------------------|-------------------------------------|
|announcement_selection                    |str                    |announcementSelection                |
|audio_file                                |audioFile              |audioFile *Optional*                 |
|video_file                                |videoFile              |videoFile *Optional*                 |
|enable_first_menu_level_extension_dialing |bool                   |enableFirstMenuLevelExtensionDialing |
|key_configuration                         |List[keyConfiguration] |keyConfiguration *Optional*          |
</div>


## `AutoAttendantAddMenu20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The configuration of the automated receptionist greeting prompt and dialing menu to be
used during after business hours.


**Attributes:**

|Name                                      |Type                   |Description                          |
|------------------------------------------|-----------------------|-------------------------------------|
|announcement_selection                    |str                    |announcementSelection                |
|audio_file                                |audioFile              |audioFile *Optional*                 |
|video_file                                |videoFile              |videoFile *Optional*                 |
|enable_first_menu_level_extension_dialing |bool                   |enableFirstMenuLevelExtensionDialing |
|key_configuration                         |List[keyConfiguration] |keyConfiguration *Optional*          |
</div>


## `AutoAttendantModifyMenu`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The configuration of the automated receptionist greeting prompt and dialing menu to be
used during business hours.

It is used when modifying an Auto Attendant group.

**Attributes:**

|Name                                      |Type                   |Description                                     |
|------------------------------------------|-----------------------|------------------------------------------------|
|announcement_selection                    |str                    |announcementSelection *Optional*                |
|audio_file                                |audioFile              |audioFile *Optional*                            |
|video_file                                |videoFile              |videoFile *Optional*                            |
|enable_first_menu_level_extension_dialing |bool                   |enableFirstMenuLevelExtensionDialing *Optional* |
|key_configuration                         |List[keyConfiguration] |keyConfiguration *Optional*                     |
</div>


## `AutoAttendantModifyMenu16`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The configuration of the automated receptionist greeting prompt and dialing menu to be
used during business hours.

It is used when modifying an Auto Attendant group.

**Attributes:**

|Name                                      |Type                   |Description                                     |
|------------------------------------------|-----------------------|------------------------------------------------|
|announcement_selection                    |str                    |announcementSelection *Optional*                |
|audio_file                                |audioFile              |audioFile *Optional*                            |
|video_file                                |videoFile              |videoFile *Optional*                            |
|enable_first_menu_level_extension_dialing |bool                   |enableFirstMenuLevelExtensionDialing *Optional* |
|key_configuration                         |List[keyConfiguration] |keyConfiguration *Optional*                     |
</div>


## `AutoAttendantModifyMenu20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The configuration of the automated receptionist greeting prompt and dialing menu to be
used during business hours.

It is used when modifying an Auto Attendant group.

**Attributes:**

|Name                                      |Type                   |Description                                     |
|------------------------------------------|-----------------------|------------------------------------------------|
|announcement_selection                    |str                    |announcementSelection *Optional*                |
|audio_file                                |audioFile              |audioFile *Optional*                            |
|video_file                                |videoFile              |videoFile *Optional*                            |
|enable_first_menu_level_extension_dialing |bool                   |enableFirstMenuLevelExtensionDialing *Optional* |
|key_configuration                         |List[keyConfiguration] |keyConfiguration *Optional*                     |
</div>


## `AutoAttendantReadMenu`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The configuration of the automated receptionist greeting prompt and dialing menu to be
used during after business hours.


**Attributes:**

|Name                                      |Type                   |Description                          |
|------------------------------------------|-----------------------|-------------------------------------|
|announcement_selection                    |str                    |announcementSelection                |
|audio_file_description                    |str                    |audioFileDescription *Optional*      |
|video_file_description                    |str                    |videoFileDescription *Optional*      |
|enable_first_menu_level_extension_dialing |bool                   |enableFirstMenuLevelExtensionDialing |
|key_configuration                         |List[keyConfiguration] |keyConfiguration *Optional*          |
</div>


## `AutoAttendantReadMenu16`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The configuration of the automated receptionist greeting prompt and dialing menu to be
used during after business hours.


**Attributes:**

|Name                                      |Type                   |Description                          |
|------------------------------------------|-----------------------|-------------------------------------|
|announcement_selection                    |str                    |announcementSelection                |
|audio_file_description                    |str                    |audioFileDescription *Optional*      |
|audio_media_type                          |str                    |audioMediaType *Optional*            |
|video_file_description                    |str                    |videoFileDescription *Optional*      |
|video_media_type                          |str                    |videoMediaType *Optional*            |
|enable_first_menu_level_extension_dialing |bool                   |enableFirstMenuLevelExtensionDialing |
|key_configuration                         |List[keyConfiguration] |keyConfiguration *Optional*          |
</div>


## `AutoAttendantReadMenu20`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
The configuration of the automated receptionist greeting prompt and dialing menu to be
used during after business hours.


**Attributes:**

|Name                                      |Type                   |Description                          |
|------------------------------------------|-----------------------|-------------------------------------|
|announcement_selection                    |str                    |announcementSelection                |
|audio_file                                |audioFile              |audioFile *Optional*                 |
|video_file                                |videoFile              |videoFile *Optional*                 |
|enable_first_menu_level_extension_dialing |bool                   |enableFirstMenuLevelExtensionDialing |
|key_configuration                         |List[keyConfiguration] |keyConfiguration *Optional*          |
</div>


## `SystemSIPDeviceTypeAddRequest18sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Request to add a sip device type.

The response is either `SuccessResponse()` or `ErrorResponse()`. The following
elements are only used in XS data mode: enable3G4GContinuity, use value "false" in AS
data mode The following elements are only used in AS data mode:
holdAnnouncementMethod, use value "useInactive" in XS data mode supportRFC3398, use
value "false" in XS data mode The following element values are only applicable in AS
data mode: holdNormalization=useRfc3264Hold will raise an error in XS data mode
Replaced by: `SystemSIPDeviceTypeAddRequest19()`.

**Attributes:**

|Name                                     |Type             |Description                          |
|-----------------------------------------|-----------------|-------------------------------------|
|device_type                              |str              |deviceType                           |
|number_of_ports                          |numberOfPorts    |numberOfPorts                        |
|profile                                  |str              |profile                              |
|registration_capable                     |bool             |registrationCapable                  |
|is_conference_device                     |bool             |isConferenceDevice                   |
|is_mobility_manager_device               |bool             |isMobilityManagerDevice              |
|is_music_on_hold_device                  |bool             |isMusicOnHoldDevice                  |
|hold_normalization                       |str              |holdNormalization                    |
|hold_announcement_method                 |str              |holdAnnouncementMethod               |
|is_trusted                               |bool             |isTrusted                            |
|e164_capable                             |bool             |E164Capable                          |
|route_advance                            |bool             |routeAdvance                         |
|forwarding_override                      |bool             |forwardingOverride                   |
|wireless_integration                     |bool             |wirelessIntegration                  |
|web_based_config_url                     |str              |webBasedConfigURL *Optional*         |
|is_video_capable                         |bool             |isVideoCapable                       |
|pbx_integration                          |bool             |PBXIntegration                       |
|static_registration_capable              |bool             |staticRegistrationCapable            |
|cpe_device_options                       |cpeDeviceOptions |cpeDeviceOptions *Optional*          |
|early_media_support                      |str              |earlyMediaSupport                    |
|authenticate_refer                       |bool             |authenticateRefer                    |
|auto_config_soft_client                  |bool             |autoConfigSoftClient                 |
|authentication_mode                      |str              |authenticationMode                   |
|requires_broad_works_digit_collection    |bool             |requiresBroadWorksDigitCollection    |
|requires_broad_works_call_waiting_tone   |bool             |requiresBroadWorksCallWaitingTone    |
|requires_mwi_subscription                |bool             |requiresMWISubscription              |
|use_history_info_header_on_access_side   |bool             |useHistoryInfoHeaderOnAccessSide     |
|advice_of_charge_capable                 |bool             |adviceOfChargeCapable                |
|reset_event                              |str              |resetEvent *Optional*                |
|support_call_center_mime_type            |bool             |supportCallCenterMIMEType            |
|trunk_mode                               |str              |trunkMode                            |
|add_p_called_party_id                    |bool             |addPCalledPartyId                    |
|support_identity_in_update_and_re_invite |bool             |supportIdentityInUpdateAndReInvite   |
|unscreened_presentation_identity_policy  |str              |unscreenedPresentationIdentityPolicy |
|enable3_g4_g_continuity                  |bool             |enable3G4GContinuity                 |
|support_emergency_disconnect_control     |bool             |supportEmergencyDisconnectControl    |
|device_type_configuration_option         |str              |deviceTypeConfigurationOption        |
|support_rfc3398                          |bool             |supportRFC3398                       |
</div>


## `SystemSIPDeviceTypeAddRequest21sp1V2`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Request to add a sip device type.

The response is either `SuccessResponse()` or `ErrorResponse()`. The following
elements are only used in the XS data mode and ignored in the AS data mode:
enhancedForICS supports3G4GContinuity publishesOwnPresence, use value "false" in AS
data mode locationNetwork, use value "Fixed" in AS data mode The following elements
are only used in AS data mode and ignored in the XS data mode: supportRFC3398, use
value "false" in XS data mode supportClientSessionInfo, use value "false" in XS data
mode supportCallInfoConferenceSubscriptionURI, use value "false" in XS data mode
supportRemotePartyInfo, use value "false" in XS data mode bypassMediaTreatment, use
value "false" in XS data mode supportCauseParameter, use value "false" in XS data mode
The following values for element profile are only used in AS data mode and an error is
returned in the XS data mode: Non-intelligent Device Addressing Intelligent Device
Addressing The following logic applies to these elements: macInCert macInNonRequestURI
The two elements are mutually exclusive.  When both are set to true, the command
fails.  Replaced by: `SystemSIPDeviceTypeAddRequest22()` in AS data mode.

**Attributes:**

|Name                                          |Type             |Description                              |
|----------------------------------------------|-----------------|-----------------------------------------|
|device_type                                   |str              |deviceType                               |
|number_of_ports                               |numberOfPorts    |numberOfPorts                            |
|profile                                       |str              |profile                                  |
|registration_capable                          |bool             |registrationCapable                      |
|is_conference_device                          |bool             |isConferenceDevice                       |
|is_mobility_manager_device                    |bool             |isMobilityManagerDevice                  |
|is_music_on_hold_device                       |bool             |isMusicOnHoldDevice                      |
|hold_normalization                            |str              |holdNormalization                        |
|hold_announcement_method                      |str              |holdAnnouncementMethod                   |
|is_trusted                                    |bool             |isTrusted                                |
|e164_capable                                  |bool             |E164Capable                              |
|route_advance                                 |bool             |routeAdvance                             |
|forwarding_override                           |bool             |forwardingOverride                       |
|wireless_integration                          |bool             |wirelessIntegration                      |
|web_based_config_url                          |str              |webBasedConfigURL *Optional*             |
|is_video_capable                              |bool             |isVideoCapable                           |
|pbx_integration                               |bool             |PBXIntegration                           |
|static_registration_capable                   |bool             |staticRegistrationCapable                |
|cpe_device_options                            |cpeDeviceOptions |cpeDeviceOptions *Optional*              |
|early_media_support                           |str              |earlyMediaSupport                        |
|authenticate_refer                            |bool             |authenticateRefer                        |
|auto_config_soft_client                       |bool             |autoConfigSoftClient                     |
|authentication_mode                           |str              |authenticationMode                       |
|requires_broad_works_digit_collection         |bool             |requiresBroadWorksDigitCollection        |
|requires_broad_works_call_waiting_tone        |bool             |requiresBroadWorksCallWaitingTone        |
|requires_mwi_subscription                     |bool             |requiresMWISubscription                  |
|use_history_info_header_on_access_side        |bool             |useHistoryInfoHeaderOnAccessSide         |
|advice_of_charge_capable                      |bool             |adviceOfChargeCapable                    |
|reset_event                                   |str              |resetEvent *Optional*                    |
|support_call_center_mime_type                 |bool             |supportCallCenterMIMEType                |
|trunk_mode                                    |str              |trunkMode                                |
|add_p_called_party_id                         |bool             |addPCalledPartyId                        |
|support_identity_in_update_and_re_invite      |bool             |supportIdentityInUpdateAndReInvite       |
|unscreened_presentation_identity_policy       |str              |unscreenedPresentationIdentityPolicy     |
|enhanced_for_ics                              |bool             |enhancedForICS                           |
|support_emergency_disconnect_control          |bool             |supportEmergencyDisconnectControl        |
|device_type_configuration_option              |str              |deviceTypeConfigurationOption            |
|support_rfc3398                               |bool             |supportRFC3398                           |
|static_line_ordering                          |bool             |staticLineOrdering                       |
|support_client_session_info                   |bool             |supportClientSessionInfo                 |
|support_call_info_conference_subscription_uri |bool             |supportCallInfoConferenceSubscriptionURI |
|support_remote_party_info                     |bool             |supportRemotePartyInfo                   |
|support_visual_device_management              |bool             |supportVisualDeviceManagement            |
|bypass_media_treatment                        |bool             |bypassMediaTreatment                     |
|supports3_g4_g_continuity                     |bool             |supports3G4GContinuity                   |
|publishes_own_presence                        |bool             |publishesOwnPresence                     |
|support_cause_parameter                       |bool             |supportCauseParameter                    |
|location_network                              |str              |locationNetwork                          |
</div>


## `TrunkAddressingMultipleContactModify22`([`OCIType`](/broadworks_ocip/api/base/#broadworks_ocip.base.OCIType))

<div class="doc-contents" markdown="1">
Trunk group endpoint that can have multiple contacts.

alternateTrunkIdentityDomain is only used in XS mode and the AS when deployed in IMS
mode.  . Setting alternateTrunkIdentity or alternateTrunkIdentityDomain to nil in XS
mode, the other one paremter should be set to nil at the same time.  The following
elements are only used in AS data mode and are ignored in XS data mode:
physicalLocation

**Attributes:**

|Name                            |Type                     |Description                             |
|--------------------------------|-------------------------|----------------------------------------|
|trunk_group_device_endpoint     |trunkGroupDeviceEndpoint |trunkGroupDeviceEndpoint *Optional*     |
|enterprise_trunk_name           |str                      |enterpriseTrunkName *Optional*          |
|alternate_trunk_identity        |str                      |alternateTrunkIdentity *Optional*       |
|alternate_trunk_identity_domain |str                      |alternateTrunkIdentityDomain *Optional* |
|physical_location               |str                      |physicalLocation *Optional*             |
</div>
