"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AzIdToNameMappingFunctionCodeCache = exports.AzIdToNameMapping = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class AzIdToNameMapping extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const handlerPolicy = new aws_cdk_lib_1.aws_iam.ManagedPolicy(this, 'handlerPolicy', {
            statements: [
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    sid: 'AllowSSMParameterEdit',
                    actions: [
                        'ssm:PutParameter',
                        'ssm:DeleteParameter',
                        'ssm:AddTagsToResource',
                    ],
                    resources: [
                        '*',
                    ],
                    conditions: {
                        StringEquals: {
                            'aws:ResourceTag/CdkAzMappingParameter': 'True',
                        },
                    },
                }),
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    sid: 'AllowDescribeAZs',
                    actions: [
                        'ec2:DescribeAvailabilityZones',
                    ],
                    resources: [
                        '*',
                    ],
                }),
            ],
        });
        const role = new aws_cdk_lib_1.aws_iam.Role(this, 'handlerRole', {
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('lambda.amazonaws.com'),
            managedPolicies: [
                handlerPolicy,
            ],
        });
        const onEventHandler = new aws_cdk_lib_1.aws_lambda.Function(this, 'handler', {
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_8,
            code: props.lambdaCode ?? aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, '../lambda')),
            handler: 'index.handler',
            description: 'Stores VPC mappings into parameter store',
            timeout: aws_cdk_lib_1.Duration.seconds(5),
            role,
        });
        new aws_cdk_lib_1.aws_logs.LogGroup(this, 'logGroup', {
            logGroupName: `/aws/lambda/${onEventHandler.functionName}`,
            retention: props.logRetention ?? aws_cdk_lib_1.aws_logs.RetentionDays.ONE_MONTH,
        });
        const mapping = new aws_cdk_lib_1.CustomResource(this, 'mapping', {
            serviceToken: onEventHandler.functionArn,
            properties: {
                azIds: props.azIds || ['use1-az2', 'use1-az4', 'use1-az6'],
                prefix: props.ssmParameterPrefix || '/az-mapping/',
            },
        });
        this.mapping = mapping.getAtt('azIds').toString();
    }
}
exports.AzIdToNameMapping = AzIdToNameMapping;
_a = JSII_RTTI_SYMBOL_1;
AzIdToNameMapping[_a] = { fqn: "@renovosolutions/cdk-library-multi-account-az-mapping.AzIdToNameMapping", version: "0.0.44" };
class AzIdToNameMappingFunctionCodeCache extends aws_cdk_lib_1.aws_s3.Bucket {
    constructor(scope, id, props) {
        const removalPolicy = props.removalPolicy ?? aws_cdk_lib_1.RemovalPolicy.DESTROY;
        const autoDeleteObjects = removalPolicy === aws_cdk_lib_1.RemovalPolicy.DESTROY;
        super(scope, id, {
            removalPolicy,
            autoDeleteObjects,
            ...props,
        });
        /** Force the final unzipped asset to be a zip by nesting zips */
        const bundlingCmds = [
            'mkdir -p /asset-output',
            'mkdir -p temp',
            'pip install -r /asset-input/requirements.txt -t /asset-input/temp',
            'cp index.py /asset-input/temp/index.py',
            'cd temp',
            'zip -r lambda.zip .',
            'zip -r /asset-output/temp.zip lambda.zip',
            'cd ..',
            'rm -rf ./temp',
        ];
        new aws_cdk_lib_1.aws_s3_deployment.BucketDeployment(this, 'Deployment', {
            sources: [aws_cdk_lib_1.aws_s3_deployment.Source.asset(path.join(__dirname, '../lambda'), {
                    bundling: {
                        image: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9.bundlingImage,
                        command: [
                            'bash', '-c', bundlingCmds.join(' && '),
                        ],
                    },
                })],
            destinationBucket: this,
            exclude: ['__pycache__/*', '*.pyc'],
            include: ['*.py'],
        });
        this.lambdaCode = aws_cdk_lib_1.aws_lambda.Code.fromBucket(this, 'index.py');
    }
    /**
     * Add access to the whole organization to get
     * the lambda function code from the bucket.
     *
     * @param principalOrgId The organization ID to require for any accounts accessing the bucket.
     */
    addOrgWideAccessPolicy(principalOrgId) {
        return this.addToResourcePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            principals: [new aws_cdk_lib_1.aws_iam.StarPrincipal],
            actions: [
                's3:GetObject',
            ],
            resources: [this.arnForObjects('*')],
            conditions: {
                StringEquals: {
                    'aws:PrincipalOrgID': principalOrgId,
                },
            },
        }));
    }
    ;
    /**
     * Add access to the specified accounts to get
     * the lambda function code from the bucket.
     *
     * @param principalAccountId The account ID to add access for.
     * @param principalOrgId (Optional) The organization ID to require for the account accessing the bucket.
     */
    addAccountAccessPolicy(principalAccountId, principalOrgId) {
        return this.addToResourcePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            principals: [new aws_cdk_lib_1.aws_iam.AccountPrincipal(principalAccountId)],
            actions: ['s3:GetObject'],
            resources: [this.arnForObjects('*')],
            conditions: principalOrgId === undefined ? undefined : {
                StringEquals: {
                    'aws:PrincipalOrgID': principalOrgId,
                },
            },
        }));
    }
    ;
    /**
     * Add access to the specified organizational units to get
     * the lambda function code from the bucket.
     *
     * @param principalOrgPaths The organizational unit paths to add access for.
     */
    addOrgOuAccessPolicy(principalOrgPaths) {
        return this.addToResourcePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            principals: [new aws_cdk_lib_1.aws_iam.StarPrincipal],
            actions: ['s3:GetObject'],
            resources: [this.arnForObjects('*')],
            conditions: {
                StringLike: {
                    'aws:PrincipalOrgPaths': principalOrgPaths,
                },
            },
        }));
    }
}
exports.AzIdToNameMappingFunctionCodeCache = AzIdToNameMappingFunctionCodeCache;
_b = JSII_RTTI_SYMBOL_1;
AzIdToNameMappingFunctionCodeCache[_b] = { fqn: "@renovosolutions/cdk-library-multi-account-az-mapping.AzIdToNameMappingFunctionCodeCache", version: "0.0.44" };
;
//# sourceMappingURL=data:application/json;base64,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