#!/usr/bin/env python3

import pathlib
import urllib.parse

import requests

# list of resources URL found in khan-site.css
urls = [
    "http://www.khanacademy.org/stylesheets/jqueryui-package/images/animated-overlay.gif",
    "http://www.khanacademy.org/stylesheets/jqueryui-package/images/ui-bg_flat_75_ffffff_40x100.png",
    "http://www.khanacademy.org/stylesheets/jqueryui-package/images/ui-bg_highlight-soft_75_cccccc_1x100.png",
    "http://www.khanacademy.org/stylesheets/jqueryui-package/images/ui-bg_glass_75_e6e6e6_1x400.png",
    "http://www.khanacademy.org/stylesheets/jqueryui-package/images/ui-bg_glass_75_dadada_1x400.png",
    "http://www.khanacademy.org/stylesheets/jqueryui-package/images/ui-bg_glass_65_ffffff_1x400.png",
    "http://www.khanacademy.org/stylesheets/jqueryui-package/images/ui-bg_glass_55_fbf9ee_1x400.png",
    "http://www.khanacademy.org/stylesheets/jqueryui-package/images/ui-bg_glass_95_fef1ec_1x400.png",
    "http://www.khanacademy.org/stylesheets/jqueryui-package/images/ui-icons_222222_256x240.png",
    "http://www.khanacademy.org/stylesheets/jqueryui-package/images/ui-icons_222222_256x240.png",
    "http://www.khanacademy.org/stylesheets/jqueryui-package/images/ui-icons_888888_256x240.png",
    "http://www.khanacademy.org/stylesheets/jqueryui-package/images/ui-icons_454545_256x240.png",
    "http://www.khanacademy.org/stylesheets/jqueryui-package/images/ui-icons_454545_256x240.png",
    "http://www.khanacademy.org/stylesheets/jqueryui-package/images/ui-icons_2e83ff_256x240.png",
    "http://www.khanacademy.org/stylesheets/jqueryui-package/images/ui-icons_cd0a0a_256x240.png",
    "http://www.khanacademy.org/stylesheets/jqueryui-package/images/ui-bg_flat_0_aaaaaa_40x100.png",
    "http://www.khanacademy.org/stylesheets/jqueryui-package/images/ui-bg_flat_0_aaaaaa_40x100.png",
    "http://www.khanacademy.org/stylesheets/jqueryui-package/images/ui-bg_flat_75_ffffff_40x100.png",
    "http://www.khanacademy.org/images/expand-left.png",
    "http://www.khanacademy.org/images/expand-right.png",
    "http://www.khanacademy.org/images/dashboard-icon-active.png",
    "http://www.khanacademy.org/images/play.png",
    "http://www.khanacademy.org/images/non-repeating-sprites.4.png",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-video-default.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-exercise-default.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-scratchpad-default.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-talkie-default.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-challenge-default.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-article-default.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-project-default.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-video-science.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-exercise-science.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-scratchpad-science.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-talkie-science.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-challenge-science.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-article-science.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-project-science.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-video-humanities.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-exercise-humanities.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-scratchpad-humanities.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-talkie-humanities.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-challenge-humanities.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-article-humanities.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-project-humanities.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-video-economics.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-exercise-economics.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-scratchpad-economics.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-talkie-economics.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-challenge-economics.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-article-economics.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-project-economics.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-video-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-exercise-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-scratchpad-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-talkie-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-challenge-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-article-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-project-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-video-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-exercise-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-scratchpad-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-talkie-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-challenge-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-article-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-project-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-video-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-exercise-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-scratchpad-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-talkie-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-challenge-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-article-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-project-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-video-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-exercise-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-scratchpad-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-talkie-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-challenge-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-article-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-project-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-video-partnerContent.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-exercise-partnerContent.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-scratchpad-partnerContent.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-talkie-partnerContent.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-challenge-partnerContent.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-article-partnerContent.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-project-partnerContent.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-video-math.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-exercise-math.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-scratchpad-math.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-talkie-math.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-challenge-math.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-article-math.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-project-math.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-video-testPrep.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-exercise-testPrep.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-scratchpad-testPrep.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-talkie-testPrep.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-challenge-testPrep.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-article-testPrep.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-project-testPrep.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-video-science.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-exercise-science.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-scratchpad-science.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-talkie-science.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-challenge-science.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-article-science.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-project-science.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-video-humanities.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-exercise-humanities.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-scratchpad-humanities.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-talkie-humanities.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-challenge-humanities.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-article-humanities.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-project-humanities.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-video-economics.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-exercise-economics.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-scratchpad-economics.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-talkie-economics.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-challenge-economics.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-article-economics.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-project-economics.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-video-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-exercise-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-scratchpad-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-talkie-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-challenge-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-article-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-project-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-video-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-exercise-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-scratchpad-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-talkie-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-challenge-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-article-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-project-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-video-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-exercise-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-scratchpad-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-talkie-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-challenge-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-article-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-project-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-video-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-exercise-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-scratchpad-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-talkie-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-challenge-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-article-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-project-cs.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-video-partnerContent.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-exercise-partnerContent.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-scratchpad-partnerContent.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-talkie-partnerContent.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-challenge-partnerContent.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-article-partnerContent.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-project-partnerContent.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-video-math.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-exercise-math.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-scratchpad-math.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-talkie-math.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-challenge-math.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-article-math.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-project-math.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-video-testPrep.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-exercise-testPrep.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-scratchpad-testPrep.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-talkie-testPrep.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-challenge-testPrep.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-article-testPrep.svg",
    "http://www.khanacademy.org/images/progress-icons/subway-sprites-project-testPrep.svg",
    "http://www.khanacademy.org/images/learn-storm/dart.png",
    "http://www.khanacademy.org/images/spinner.gif",
    "http://www.khanacademy.org/images/typeahead-search-bg.png",
    "http://www.khanacademy.org/images/progress-animated.gif",
    # from khan-exercise.css
    "http://www.khanacademy.org/images/previous-step.png",
    "http://www.khanacademy.org/images/next-step.png",
    # from mathquill.css and expression.less
    "https://www.khanacademy.org/images/perseus/error-buddy.png",
    "https://www.khanacademy.org/images/perseus/error-buddy.png",
]

root = pathlib.Path("./stylesheets")

for url in urls:
    uri = urllib.parse.urlparse(url)
    path = root.joinpath(uri.netloc).joinpath(uri.path[1:])
    print(f"Downloading {path}…")

    path.parent.mkdir(parents=True, exist_ok=True)
    with open(path, "wb") as fh:
        fh.write(requests.get(url).content)
