"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
/*
 * Stack verification steps:
 * * `aws cognito-idp sign-up --client-id <cfnoutput-client-id> --username user-1 --password pass1234 \
 *   --user-attributes Name="phone_number",Value="<valid-phone-number-with-intl-extension>"
 * * `aws cognito-idp sign-up --client-id <cfnoutput-client-id> --username user-2 --password pass1234 \
 *   --user-attributes Name="email",Value="<valid-email-address>"
 * * An email with the message 'integ-test: Verify by clicking on <link>' should be received.
 * * An SMS with the message 'integ-test: Account verification code is <code>' should be received.
 */
const app = new core_1.App();
const stack = new core_1.Stack(app, 'integ-user-pool-signup-link');
const userpool = new lib_1.UserPool(stack, 'myuserpool', {
    userPoolName: 'MyUserPool',
    autoVerify: {
        email: true,
        phone: true,
    },
    selfSignUpEnabled: true,
    userVerification: {
        emailStyle: lib_1.VerificationEmailStyle.LINK,
        emailSubject: 'integ-test: Verify your account',
        emailBody: 'integ-test: Verify by clicking on {##Verify Email##}',
        smsMessage: 'integ-test: Account verification code is {####}',
    },
    passwordPolicy: {
        requireUppercase: false,
        requireLowercase: false,
        requireDigits: false,
        requireSymbols: false,
    },
});
const client = new lib_1.UserPoolClient(stack, 'myuserpoolclient', {
    userPool: userpool,
    userPoolClientName: 'signup-test',
    generateSecret: false,
});
userpool.addDomain('myuserpooldomain', {
    cognitoDomain: {
        domainPrefix: 'integ-user-pool-signup-link',
    },
});
new core_1.CfnOutput(stack, 'user-pool-id', {
    value: userpool.userPoolId,
});
new core_1.CfnOutput(stack, 'client-id', {
    value: client.userPoolClientId,
});
//# sourceMappingURL=data:application/json;base64,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