/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.repository.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginsRepo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(PluginsRepo.class);
    private final String repoJSON;
    private final long expirationTime;
    private final long lastModified;

    public PluginsRepo(String repoJSON, long expirationTime, long lastModified) {
        this.repoJSON = repoJSON;
        this.expirationTime = expirationTime;
        this.lastModified = lastModified;
    }

    public boolean isActual() {
        return this.expirationTime > System.currentTimeMillis();
    }

    public boolean isActual(long lastModified) {
        return this.isActual() && lastModified <= this.lastModified;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public String getRepoJSON() {
        return this.repoJSON;
    }

    public void saveToFile(File file) {
        log.debug("Saving repo to file: " + file.getAbsolutePath());
        try (FileOutputStream fout = new FileOutputStream(file);
             ObjectOutputStream out = new ObjectOutputStream(fout);){
            FileUtils.touch((File)file);
            out.writeObject(this);
        }
        catch (IOException ex) {
            log.warn("Failed for serialize repo", (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static PluginsRepo fromFile(File file) {
        log.debug("Loading repo from file: " + file.getAbsolutePath());
        try (FileInputStream fis = new FileInputStream(file);){
            PluginsRepo pluginsRepo;
            try (ObjectInputStream in = new ObjectInputStream(fis);){
                pluginsRepo = (PluginsRepo)in.readObject();
            }
            return pluginsRepo;
        }
        catch (IOException | ClassNotFoundException ex) {
            log.warn("Failed for deserialize repo", (Throwable)ex);
            return null;
        }
    }
}

