/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import kg.apc.charting.AbstractGraphRow;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.graphs.AbstractOverTimeVisualizer;
import kg.apc.jmeter.graphs.SettingsInterface;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import org.apache.jmeter.samplers.SampleResult;

public class ResponseCodesPerSecondGui
extends AbstractOverTimeVisualizer {
    private String prefix = null;

    public ResponseCodesPerSecondGui() {
        this.setGranulation(1000);
        this.graphPanel.getGraphObject().setYAxisLabel("Number of reponses /sec");
    }

    private void addResponse(String threadGroupName, long time) {
        AbstractGraphRow row = (AbstractGraphRow)this.model.get(threadGroupName);
        if (row == null) {
            row = this.getNewRow(this.model, 4, threadGroupName, 2, false, false, false, true, true);
        }
        if (this.getGranulation() > 0) {
            row.add(time, 1000.0 / (double)this.getGranulation());
        }
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel((String)"Response Codes per Second");
    }

    public void clearData() {
        super.clearData();
        this.prefix = null;
    }

    private String getRespCodeLabel(SampleResult res) {
        String ret = this.prefix;
        if (ret == null) {
            this.prefix = "";
            ret = "";
        }
        return ret + res.getResponseCode();
    }

    private void addCodes(SampleResult res) {
        SampleResult[] subResults = res.getSubResults();
        if (!this.isFromTransactionControler(res)) {
            this.addResponse(this.getRespCodeLabel(res), this.normalizeTime(res.getEndTime()));
        }
        for (SampleResult subResult : subResults) {
            this.addCodes(subResult);
        }
    }

    public void add(SampleResult res) {
        if (!this.isSampleIncluded(res)) {
            return;
        }
        super.add(res);
        this.addCodes(res);
        this.updateGui(null);
    }

    protected JSettingsPanel createSettingsPanel() {
        return new JSettingsPanel((SettingsInterface)this, 2843);
    }

    public String getWikiPage() {
        return "ResponseCodesPerSecond";
    }
}

