from setuptools import setup, find_packages

setup(
    name = 'pywapor',
    version = '2.4.2',
    url = 'https://www.fao.org/aquastat/py-wapor/',
    author = "FAO",
    author_email = "bert.coerver@fao.org",
    license = "Apache",
    packages = find_packages(include = ['pywapor', 'pywapor.*']),
    include_package_data=True,
    python_requires='>=3.7, <3.9',
    install_requires = [
        'gdal',
        'xarray>=0.20',
        'numpy',
        'aiohttp',
        'pandas',
        'requests',
        'matplotlib',
        'netcdf4',
        'pyproj',
        'scipy',
        'fiona',
        'pycurl',
        'pyshp',
        'joblib',
        'bs4',
        'paramiko',
        'rasterio',
        'bottleneck>=1.3.1',
        'geojson',
        'vito_download',
        'nest_asyncio',
        'tqdm',
        'dask',
        'rioxarray',
        'python_log_indenter',
        'cryptography',
        'pyvis',
    ],
    classifiers=[
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
    ],
)