# coding: utf-8

"""
    Laserfiche API

    Welcome to the Laserfiche API Swagger Playground. You can try out any of our API calls against your live Laserfiche Cloud account. Visit the developer center for more details: <a href=\"https://developer.laserfiche.com\">https://developer.laserfiche.com</a><p><strong>Build# : </strong>650780</p>  # noqa: E501

    OpenAPI spec version: 1-alpha
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from laserfiche_api.api_client import ApiClient


class EntriesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def assign_entry_links(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """assign_entry_links  # noqa: E501

        - Assign links to an entry. - Provide an entry ID and a list of links to assign to that entry. - This is an overwrite action. The request must include all links to assign to the entry, including existing links that should remain assigned to the entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign_entry_links(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The request repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :param list[PutLinksRequest] body:
        :return: ODataValueOfIListOfWEntryLinkInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.assign_entry_links_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.assign_entry_links_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
            return data

    def assign_entry_links_with_http_info(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """assign_entry_links  # noqa: E501

        - Assign links to an entry. - Provide an entry ID and a list of links to assign to that entry. - This is an overwrite action. The request must include all links to assign to the entry, including existing links that should remain assigned to the entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign_entry_links_with_http_info(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The request repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :param list[PutLinksRequest] body:
        :return: ODataValueOfIListOfWEntryLinkInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repo_id', 'entry_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method assign_entry_links" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params or
                params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `assign_entry_links`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `assign_entry_links`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo_id' in params:
            path_params['repoId'] = params['repo_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v1-alpha/Repositories/{repoId}/Entries/{entryId}/links', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ODataValueOfIListOfWEntryLinkInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def assign_field_values(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """assign_field_values  # noqa: E501

        - Update field values assigned to an entry. - Provide the new field values to assign to the entry, and remove/reset all previously assigned field values.  - This is an overwrite action. The request body must include all desired field values, including any existing field values that should remain assigned to the entry. Field values that are not included in the request will be deleted from the entry. If the field value that is not included is part of a template, it will still be assigned (as required by the template), but its value will be reset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign_field_values(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository ID. (required)
        :param int entry_id: The entry ID of the entry that will have its fields updated. (required)
        :param dict(str, FieldToUpdate) body:
        :return: ODataValueOfIListOfFieldValue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.assign_field_values_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.assign_field_values_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
            return data

    def assign_field_values_with_http_info(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """assign_field_values  # noqa: E501

        - Update field values assigned to an entry. - Provide the new field values to assign to the entry, and remove/reset all previously assigned field values.  - This is an overwrite action. The request body must include all desired field values, including any existing field values that should remain assigned to the entry. Field values that are not included in the request will be deleted from the entry. If the field value that is not included is part of a template, it will still be assigned (as required by the template), but its value will be reset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign_field_values_with_http_info(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository ID. (required)
        :param int entry_id: The entry ID of the entry that will have its fields updated. (required)
        :param dict(str, FieldToUpdate) body:
        :return: ODataValueOfIListOfFieldValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repo_id', 'entry_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method assign_field_values" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params or
                params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `assign_field_values`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `assign_field_values`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo_id' in params:
            path_params['repoId'] = params['repo_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v1-alpha/Repositories/{repoId}/Entries/{entryId}/fields', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ODataValueOfIListOfFieldValue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def assign_tags(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """assign_tags  # noqa: E501

        - Assign tags to an entry. - Provide an entry ID and a list of tags to assign to that entry. - This is an overwrite action. The request must include all tags to assign to the entry, including existing tags that should remain assigned to the entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign_tags(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :param PutTagRequest body: The tags to add.
        :return: ODataValueOfIListOfWTagInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.assign_tags_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.assign_tags_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
            return data

    def assign_tags_with_http_info(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """assign_tags  # noqa: E501

        - Assign tags to an entry. - Provide an entry ID and a list of tags to assign to that entry. - This is an overwrite action. The request must include all tags to assign to the entry, including existing tags that should remain assigned to the entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign_tags_with_http_info(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :param PutTagRequest body: The tags to add.
        :return: ODataValueOfIListOfWTagInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repo_id', 'entry_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method assign_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params or
                params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `assign_tags`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `assign_tags`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo_id' in params:
            path_params['repoId'] = params['repo_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v1-alpha/Repositories/{repoId}/Entries/{entryId}/tags', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ODataValueOfIListOfWTagInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def copy_entry_async(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """copy_entry_async  # noqa: E501

        - Copy a new child entry in the designated folder async, and potentially return an operationToken. - Provide the parent folder id, and copy an entry as a child of the designated folder. - Optional parameter: autoRename (default false). If an entry already exists with the given name, the entry will be automatically renamed.  - The status of the operation can be checked via the Tasks/{operationToken} route.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.copy_entry_async(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository id. (required)
        :param int entry_id: The folder id that the entry will be created in. (required)
        :param CopyAsyncRequest body: Copy entry request.
        :param bool auto_rename: An optional query parameter used to indicate if the new entry should be automatically             renamed if an entry already exists with the given name in the folder. The default value is false.
        :return: AcceptedOperation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.copy_entry_async_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.copy_entry_async_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
            return data

    def copy_entry_async_with_http_info(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """copy_entry_async  # noqa: E501

        - Copy a new child entry in the designated folder async, and potentially return an operationToken. - Provide the parent folder id, and copy an entry as a child of the designated folder. - Optional parameter: autoRename (default false). If an entry already exists with the given name, the entry will be automatically renamed.  - The status of the operation can be checked via the Tasks/{operationToken} route.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.copy_entry_async_with_http_info(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository id. (required)
        :param int entry_id: The folder id that the entry will be created in. (required)
        :param CopyAsyncRequest body: Copy entry request.
        :param bool auto_rename: An optional query parameter used to indicate if the new entry should be automatically             renamed if an entry already exists with the given name in the folder. The default value is false.
        :return: AcceptedOperation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repo_id', 'entry_id', 'body', 'auto_rename']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method copy_entry_async" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params or
                params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `copy_entry_async`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `copy_entry_async`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo_id' in params:
            path_params['repoId'] = params['repo_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []
        if 'auto_rename' in params:
            query_params.append(('autoRename', params['auto_rename']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v1-alpha/Repositories/{repoId}/Entries/{entryId}/Laserfiche.Repository.Folder/CopyAsync', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AcceptedOperation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_or_copy_entry(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """create_or_copy_entry  # noqa: E501

        - Create/copy a new child entry in the designated folder. - Provide the parent folder id, and based on the request body, copy or create a folder/shortcut as a child entry of the designated folder. - Optional parameter: autoRename (default false). If an entry already exists with the given name, the entry will be automatically renamed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_or_copy_entry(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository id. (required)
        :param int entry_id: The folder id that the entry will be created in. (required)
        :param PostEntryChildrenRequest body: The entry to create.
        :param bool auto_rename: An optional query parameter used to indicate if the new entry should be automatically             renamed if an entry already exists with the given name in the folder. The default value is false.
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_or_copy_entry_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_or_copy_entry_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
            return data

    def create_or_copy_entry_with_http_info(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """create_or_copy_entry  # noqa: E501

        - Create/copy a new child entry in the designated folder. - Provide the parent folder id, and based on the request body, copy or create a folder/shortcut as a child entry of the designated folder. - Optional parameter: autoRename (default false). If an entry already exists with the given name, the entry will be automatically renamed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_or_copy_entry_with_http_info(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository id. (required)
        :param int entry_id: The folder id that the entry will be created in. (required)
        :param PostEntryChildrenRequest body: The entry to create.
        :param bool auto_rename: An optional query parameter used to indicate if the new entry should be automatically             renamed if an entry already exists with the given name in the folder. The default value is false.
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repo_id', 'entry_id', 'body', 'auto_rename']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_or_copy_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params or
                params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `create_or_copy_entry`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `create_or_copy_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo_id' in params:
            path_params['repoId'] = params['repo_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []
        if 'auto_rename' in params:
            query_params.append(('autoRename', params['auto_rename']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v1-alpha/Repositories/{repoId}/Entries/{entryId}/Laserfiche.Repository.Folder/children', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Entry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_assigned_template(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """delete_assigned_template  # noqa: E501

        - Remove the currently assigned template from the specified entry. - Provide an entry id to clear template value on. - If the entry does not have a template assigned, no change will be made.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_assigned_template(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository id. (required)
        :param int entry_id: The id of the entry that will have its template removed. (required)
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_assigned_template_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_assigned_template_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
            return data

    def delete_assigned_template_with_http_info(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """delete_assigned_template  # noqa: E501

        - Remove the currently assigned template from the specified entry. - Provide an entry id to clear template value on. - If the entry does not have a template assigned, no change will be made.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_assigned_template_with_http_info(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository id. (required)
        :param int entry_id: The id of the entry that will have its template removed. (required)
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repo_id', 'entry_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_assigned_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params or
                params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `delete_assigned_template`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `delete_assigned_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo_id' in params:
            path_params['repoId'] = params['repo_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v1-alpha/Repositories/{repoId}/Entries/{entryId}/template', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Entry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_entry_info(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """delete_entry_info  # noqa: E501

        - Begins a task to delete an entry, and returns an operationToken. - Provide an entry ID, and queue a delete task to remove it from the repository (includes nested objects if the entry is a Folder type). The entry will not be deleted immediately. - Optionally include an audit reason ID and comment in the JSON body. This route returns an operationToken, and will run as an asynchronous operation. Check the progress via the Tasks/{operationToken} route.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_entry_info(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :param DeleteEntryWithAuditReason body:
        :return: AcceptedOperation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_entry_info_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_entry_info_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
            return data

    def delete_entry_info_with_http_info(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """delete_entry_info  # noqa: E501

        - Begins a task to delete an entry, and returns an operationToken. - Provide an entry ID, and queue a delete task to remove it from the repository (includes nested objects if the entry is a Folder type). The entry will not be deleted immediately. - Optionally include an audit reason ID and comment in the JSON body. This route returns an operationToken, and will run as an asynchronous operation. Check the progress via the Tasks/{operationToken} route.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_entry_info_with_http_info(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :param DeleteEntryWithAuditReason body:
        :return: AcceptedOperation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repo_id', 'entry_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_entry_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params or
                params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `delete_entry_info`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `delete_entry_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo_id' in params:
            path_params['repoId'] = params['repo_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v1-alpha/Repositories/{repoId}/Entries/{entryId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AcceptedOperation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_document(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """export_document  # noqa: E501

        - Get an entry's edoc resource in a stream format. - Provide an entry id, and get the edoc resource as part of the response content. - Optional header: Range. Use the Range header (single range with byte unit) to retrieve partial content of the edoc, rather than the entire edoc.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_document(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository id. (required)
        :param int entry_id: The requested document id. (required)
        :param str range: An optional header used to retrieve partial content of the edoc. Only supports single             range with byte unit.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.export_document_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.export_document_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
            return data

    def export_document_with_http_info(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """export_document  # noqa: E501

        - Get an entry's edoc resource in a stream format. - Provide an entry id, and get the edoc resource as part of the response content. - Optional header: Range. Use the Range header (single range with byte unit) to retrieve partial content of the edoc, rather than the entire edoc.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_document_with_http_info(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository id. (required)
        :param int entry_id: The requested document id. (required)
        :param str range: An optional header used to retrieve partial content of the edoc. Only supports single             range with byte unit.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repo_id', 'entry_id', 'range']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_document" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params or
                params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `export_document`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `export_document`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo_id' in params:
            path_params['repoId'] = params['repo_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'range' in params:
            header_params['Range'] = params['range']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v1-alpha/Repositories/{repoId}/Entries/{entryId}/Laserfiche.Repository.Document/edoc', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_document_with_audit_reason(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """export_document_with_audit_reason  # noqa: E501

        - Get an entry's edoc resource in a stream format while including an audit reason. - Provide an entry id and audit reason/comment in the request body, and get the edoc resource as part of the response content. - Optional header: Range. Use the Range header (single range with byte unit) to retrieve partial content of the edoc, rather than the entire edoc. This route is identical to the GET edoc route, but allows clients to include an audit reason when downloading the edoc.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_document_with_audit_reason(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository id. (required)
        :param int entry_id: The requested document id. (required)
        :param GetEdocWithAuditReasonRequest body:
        :param str range: An optional header used to retrieve partial content of the edoc. Only supports single             range with byte unit.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.export_document_with_audit_reason_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.export_document_with_audit_reason_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
            return data

    def export_document_with_audit_reason_with_http_info(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """export_document_with_audit_reason  # noqa: E501

        - Get an entry's edoc resource in a stream format while including an audit reason. - Provide an entry id and audit reason/comment in the request body, and get the edoc resource as part of the response content. - Optional header: Range. Use the Range header (single range with byte unit) to retrieve partial content of the edoc, rather than the entire edoc. This route is identical to the GET edoc route, but allows clients to include an audit reason when downloading the edoc.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_document_with_audit_reason_with_http_info(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository id. (required)
        :param int entry_id: The requested document id. (required)
        :param GetEdocWithAuditReasonRequest body:
        :param str range: An optional header used to retrieve partial content of the edoc. Only supports single             range with byte unit.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repo_id', 'entry_id', 'body', 'range']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_document_with_audit_reason" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params or
                params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `export_document_with_audit_reason`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `export_document_with_audit_reason`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo_id' in params:
            path_params['repoId'] = params['repo_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'range' in params:
            header_params['Range'] = params['range']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream', 'application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v1-alpha/Repositories/{repoId}/Entries/{entryId}/Laserfiche.Repository.Document/GetEdocWithAuditReason', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_document_content_type(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """get_document_content_type  # noqa: E501

        - Get information about the edoc content of an entry, without downloading the edoc in its entirety. - Provide an entry id, and get back the Content-Type and Content-Length in the response headers. - This route does not provide a way to download the actual edoc. Instead, it just gives metadata information about the edoc associated with the entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_document_content_type(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository id. (required)
        :param int entry_id: The requested document id. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_document_content_type_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_document_content_type_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
            return data

    def get_document_content_type_with_http_info(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """get_document_content_type  # noqa: E501

        - Get information about the edoc content of an entry, without downloading the edoc in its entirety. - Provide an entry id, and get back the Content-Type and Content-Length in the response headers. - This route does not provide a way to download the actual edoc. Instead, it just gives metadata information about the edoc associated with the entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_document_content_type_with_http_info(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository id. (required)
        :param int entry_id: The requested document id. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repo_id', 'entry_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_content_type" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params or
                params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `get_document_content_type`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `get_document_content_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo_id' in params:
            path_params['repoId'] = params['repo_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v1-alpha/Repositories/{repoId}/Entries/{entryId}/Laserfiche.Repository.Document/edoc', 'HEAD',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dynamic_field_values(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """get_dynamic_field_values  # noqa: E501

        - Get dynamic field logic values with the current values of the fields in the template. - Provide an entry id and field values in the JSON body to get dynamic field logic values.  Independent and non-dynamic fields in the request body will be ignored, and only related dynamic field logic values for the assigned template will be returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dynamic_field_values(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository id. (required)
        :param int entry_id: The requested entry id. (required)
        :param GetDynamicFieldLogicValueRequest body:
        :return: dict(str, list[str])
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dynamic_field_values_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dynamic_field_values_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
            return data

    def get_dynamic_field_values_with_http_info(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """get_dynamic_field_values  # noqa: E501

        - Get dynamic field logic values with the current values of the fields in the template. - Provide an entry id and field values in the JSON body to get dynamic field logic values.  Independent and non-dynamic fields in the request body will be ignored, and only related dynamic field logic values for the assigned template will be returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dynamic_field_values_with_http_info(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository id. (required)
        :param int entry_id: The requested entry id. (required)
        :param GetDynamicFieldLogicValueRequest body:
        :return: dict(str, list[str])
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repo_id', 'entry_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dynamic_field_values" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params or
                params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `get_dynamic_field_values`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `get_dynamic_field_values`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo_id' in params:
            path_params['repoId'] = params['repo_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v1-alpha/Repositories/{repoId}/Entries/{entryId}/fields/GetDynamicFieldLogicValue', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, list[str])',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_entry(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """get_entry  # noqa: E501

        - Returns a single entry object. - Provide an entry ID, and get the entry associated with that ID. Useful when detailed information about the entry is required, such as metadata, path information, etc. - Allowed OData query options: Select. If the entry is a subtype (Folder, Document, or Shortcut), the entry will automatically be converted to include those model-specific properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_entry(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :param str select: Limits the properties returned in the result.
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_entry_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_entry_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
            return data

    def get_entry_with_http_info(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """get_entry  # noqa: E501

        - Returns a single entry object. - Provide an entry ID, and get the entry associated with that ID. Useful when detailed information about the entry is required, such as metadata, path information, etc. - Allowed OData query options: Select. If the entry is a subtype (Folder, Document, or Shortcut), the entry will automatically be converted to include those model-specific properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_entry_with_http_info(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :param str select: Limits the properties returned in the result.
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repo_id', 'entry_id', 'select']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params or
                params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `get_entry`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `get_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo_id' in params:
            path_params['repoId'] = params['repo_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []
        if 'select' in params:
            query_params.append(('$select', params['select']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v1-alpha/Repositories/{repoId}/Entries/{entryId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Entry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_entry_listing(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """get_entry_listing  # noqa: E501

        - Returns the children entries of a folder in the repository. - Provide an entry ID (must be a folder), and get a paged listing of entries in that folder. Used as a way of navigating through the repository. - Default page size: 100. Allowed OData query options: Select | Count | OrderBy | Skip | Top | SkipToken | Prefer. OData $OrderBy syntax should follow: \"PropertyName direction,PropertyName2 direction\". Sort order can be either value \"asc\" or \"desc\". Optional query parameters: groupByOrderType (bool). This query parameter decides if results are returned in groups based on their entry type. Entries returned in the listing are not automatically converted to their subtype (Folder, Shortcut, Document), so clients who want model-specific information should request it via the GET entry by ID route.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_entry_listing(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository ID. (required)
        :param int entry_id: The folder ID. (required)
        :param bool group_by_entry_type: An optional query parameter used to indicate if the result should be grouped by entry type or not.
        :param str prefer: An optional OData header. Can be used to set the maximum page size using odata.maxpagesize.
        :param str select: Limits the properties returned in the result.
        :param str orderby: Specifies the order in which items are returned. The maximum number of expressions is 5.
        :param int top: Limits the number of items returned from a collection.
        :param int skip: Excludes the specified number of items of the queried collection from the result.
        :param bool count: Indicates whether the total count of items within a collection are returned in the result.
        :return: ODataValueOfIListOfEntry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_entry_listing_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_entry_listing_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
            return data

    def get_entry_listing_with_http_info(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """get_entry_listing  # noqa: E501

        - Returns the children entries of a folder in the repository. - Provide an entry ID (must be a folder), and get a paged listing of entries in that folder. Used as a way of navigating through the repository. - Default page size: 100. Allowed OData query options: Select | Count | OrderBy | Skip | Top | SkipToken | Prefer. OData $OrderBy syntax should follow: \"PropertyName direction,PropertyName2 direction\". Sort order can be either value \"asc\" or \"desc\". Optional query parameters: groupByOrderType (bool). This query parameter decides if results are returned in groups based on their entry type. Entries returned in the listing are not automatically converted to their subtype (Folder, Shortcut, Document), so clients who want model-specific information should request it via the GET entry by ID route.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_entry_listing_with_http_info(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository ID. (required)
        :param int entry_id: The folder ID. (required)
        :param bool group_by_entry_type: An optional query parameter used to indicate if the result should be grouped by entry type or not.
        :param str prefer: An optional OData header. Can be used to set the maximum page size using odata.maxpagesize.
        :param str select: Limits the properties returned in the result.
        :param str orderby: Specifies the order in which items are returned. The maximum number of expressions is 5.
        :param int top: Limits the number of items returned from a collection.
        :param int skip: Excludes the specified number of items of the queried collection from the result.
        :param bool count: Indicates whether the total count of items within a collection are returned in the result.
        :return: ODataValueOfIListOfEntry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repo_id', 'entry_id', 'group_by_entry_type', 'prefer', 'select', 'orderby', 'top', 'skip', 'count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_entry_listing" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params or
                params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `get_entry_listing`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `get_entry_listing`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo_id' in params:
            path_params['repoId'] = params['repo_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []
        if 'group_by_entry_type' in params:
            query_params.append(('groupByEntryType', params['group_by_entry_type']))  # noqa: E501
        if 'select' in params:
            query_params.append(('$select', params['select']))  # noqa: E501
        if 'orderby' in params:
            query_params.append(('$orderby', params['orderby']))  # noqa: E501
        if 'top' in params:
            query_params.append(('$top', params['top']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('$skip', params['skip']))  # noqa: E501
        if 'count' in params:
            query_params.append(('$count', params['count']))  # noqa: E501

        header_params = {}
        if 'prefer' in params:
            header_params['Prefer'] = params['prefer']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v1-alpha/Repositories/{repoId}/Entries/{entryId}/Laserfiche.Repository.Folder/children', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ODataValueOfIListOfEntry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_field_values(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """get_field_values  # noqa: E501

        - Returns the fields assigned to an entry. - Provide an entry ID, and get a paged listing of all fields assigned to that entry. - Default page size: 100. Allowed OData query options: Select | Count | OrderBy | Skip | Top | SkipToken | Prefer.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_field_values(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :param str prefer: An optional OData header. Can be used to set the maximum page size using odata.maxpagesize.
        :param bool format_value: An optional query parameter used to indicate if the field values should be formatted.             The default value is false.
        :param str culture: An optional query parameter used to indicate the locale that should be used for formatting.             The value should be a standard language tag. The formatValue query parameter must be set to true, otherwise             culture will not be used for formatting.
        :param str select: Limits the properties returned in the result.
        :param str orderby: Specifies the order in which items are returned. The maximum number of expressions is 5.
        :param int top: Limits the number of items returned from a collection.
        :param int skip: Excludes the specified number of items of the queried collection from the result.
        :param bool count: Indicates whether the total count of items within a collection are returned in the result.
        :return: ODataValueOfIListOfFieldValue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_field_values_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_field_values_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
            return data

    def get_field_values_with_http_info(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """get_field_values  # noqa: E501

        - Returns the fields assigned to an entry. - Provide an entry ID, and get a paged listing of all fields assigned to that entry. - Default page size: 100. Allowed OData query options: Select | Count | OrderBy | Skip | Top | SkipToken | Prefer.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_field_values_with_http_info(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :param str prefer: An optional OData header. Can be used to set the maximum page size using odata.maxpagesize.
        :param bool format_value: An optional query parameter used to indicate if the field values should be formatted.             The default value is false.
        :param str culture: An optional query parameter used to indicate the locale that should be used for formatting.             The value should be a standard language tag. The formatValue query parameter must be set to true, otherwise             culture will not be used for formatting.
        :param str select: Limits the properties returned in the result.
        :param str orderby: Specifies the order in which items are returned. The maximum number of expressions is 5.
        :param int top: Limits the number of items returned from a collection.
        :param int skip: Excludes the specified number of items of the queried collection from the result.
        :param bool count: Indicates whether the total count of items within a collection are returned in the result.
        :return: ODataValueOfIListOfFieldValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repo_id', 'entry_id', 'prefer', 'format_value', 'culture', 'select', 'orderby', 'top', 'skip', 'count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_field_values" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params or
                params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `get_field_values`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `get_field_values`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo_id' in params:
            path_params['repoId'] = params['repo_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []
        if 'format_value' in params:
            query_params.append(('formatValue', params['format_value']))  # noqa: E501
        if 'culture' in params:
            query_params.append(('culture', params['culture']))  # noqa: E501
        if 'select' in params:
            query_params.append(('$select', params['select']))  # noqa: E501
        if 'orderby' in params:
            query_params.append(('$orderby', params['orderby']))  # noqa: E501
        if 'top' in params:
            query_params.append(('$top', params['top']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('$skip', params['skip']))  # noqa: E501
        if 'count' in params:
            query_params.append(('$count', params['count']))  # noqa: E501

        header_params = {}
        if 'prefer' in params:
            header_params['Prefer'] = params['prefer']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v1-alpha/Repositories/{repoId}/Entries/{entryId}/fields', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ODataValueOfIListOfFieldValue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_link_values_from_entry(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """get_link_values_from_entry  # noqa: E501

        - Get the links assigned to an entry. - Provide an entry id, and get a paged listing of links assigned to that entry. - Default page size: 100. Allowed OData query options: Select | Count | OrderBy | Skip | Top | SkipToken | Prefer.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_link_values_from_entry(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository id. (required)
        :param int entry_id: The requested entry id. (required)
        :param str prefer: An optional odata header. Can be used to set the maximum page size using odata.maxpagesize.
        :param str select: Limits the properties returned in the result.
        :param str orderby: Specifies the order in which items are returned. The maximum number of expressions is 5.
        :param int top: Limits the number of items returned from a collection.
        :param int skip: Excludes the specified number of items of the queried collection from the result.
        :param bool count: Indicates whether the total count of items within a collection are returned in the result.
        :return: ODataValueOfIListOfWEntryLinkInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_link_values_from_entry_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_link_values_from_entry_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
            return data

    def get_link_values_from_entry_with_http_info(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """get_link_values_from_entry  # noqa: E501

        - Get the links assigned to an entry. - Provide an entry id, and get a paged listing of links assigned to that entry. - Default page size: 100. Allowed OData query options: Select | Count | OrderBy | Skip | Top | SkipToken | Prefer.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_link_values_from_entry_with_http_info(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository id. (required)
        :param int entry_id: The requested entry id. (required)
        :param str prefer: An optional odata header. Can be used to set the maximum page size using odata.maxpagesize.
        :param str select: Limits the properties returned in the result.
        :param str orderby: Specifies the order in which items are returned. The maximum number of expressions is 5.
        :param int top: Limits the number of items returned from a collection.
        :param int skip: Excludes the specified number of items of the queried collection from the result.
        :param bool count: Indicates whether the total count of items within a collection are returned in the result.
        :return: ODataValueOfIListOfWEntryLinkInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repo_id', 'entry_id', 'prefer', 'select', 'orderby', 'top', 'skip', 'count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_link_values_from_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params or
                params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `get_link_values_from_entry`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `get_link_values_from_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo_id' in params:
            path_params['repoId'] = params['repo_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []
        if 'select' in params:
            query_params.append(('$select', params['select']))  # noqa: E501
        if 'orderby' in params:
            query_params.append(('$orderby', params['orderby']))  # noqa: E501
        if 'top' in params:
            query_params.append(('$top', params['top']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('$skip', params['skip']))  # noqa: E501
        if 'count' in params:
            query_params.append(('$count', params['count']))  # noqa: E501

        header_params = {}
        if 'prefer' in params:
            header_params['Prefer'] = params['prefer']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v1-alpha/Repositories/{repoId}/Entries/{entryId}/links', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ODataValueOfIListOfWEntryLinkInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tags_assigned_to_entry(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """get_tags_assigned_to_entry  # noqa: E501

        - Get the tags assigned to an entry. - Provide an entry ID, and get a paged listing of tags assigned to that entry. - Default page size: 100. Allowed OData query options: Select | Count | OrderBy | Skip | Top | SkipToken | Prefer.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tags_assigned_to_entry(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :param str prefer: An optional OData header. Can be used to set the maximum page size using odata.maxpagesize.
        :param str select: Limits the properties returned in the result.
        :param str orderby: Specifies the order in which items are returned. The maximum number of expressions is 5.
        :param int top: Limits the number of items returned from a collection.
        :param int skip: Excludes the specified number of items of the queried collection from the result.
        :param bool count: Indicates whether the total count of items within a collection are returned in the result.
        :return: ODataValueOfIListOfWTagInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tags_assigned_to_entry_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tags_assigned_to_entry_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
            return data

    def get_tags_assigned_to_entry_with_http_info(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """get_tags_assigned_to_entry  # noqa: E501

        - Get the tags assigned to an entry. - Provide an entry ID, and get a paged listing of tags assigned to that entry. - Default page size: 100. Allowed OData query options: Select | Count | OrderBy | Skip | Top | SkipToken | Prefer.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tags_assigned_to_entry_with_http_info(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :param str prefer: An optional OData header. Can be used to set the maximum page size using odata.maxpagesize.
        :param str select: Limits the properties returned in the result.
        :param str orderby: Specifies the order in which items are returned. The maximum number of expressions is 5.
        :param int top: Limits the number of items returned from a collection.
        :param int skip: Excludes the specified number of items of the queried collection from the result.
        :param bool count: Indicates whether the total count of items within a collection are returned in the result.
        :return: ODataValueOfIListOfWTagInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repo_id', 'entry_id', 'prefer', 'select', 'orderby', 'top', 'skip', 'count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tags_assigned_to_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params or
                params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `get_tags_assigned_to_entry`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `get_tags_assigned_to_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo_id' in params:
            path_params['repoId'] = params['repo_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []
        if 'select' in params:
            query_params.append(('$select', params['select']))  # noqa: E501
        if 'orderby' in params:
            query_params.append(('$orderby', params['orderby']))  # noqa: E501
        if 'top' in params:
            query_params.append(('$top', params['top']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('$skip', params['skip']))  # noqa: E501
        if 'count' in params:
            query_params.append(('$count', params['count']))  # noqa: E501

        header_params = {}
        if 'prefer' in params:
            header_params['Prefer'] = params['prefer']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v1-alpha/Repositories/{repoId}/Entries/{entryId}/tags', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ODataValueOfIListOfWTagInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_document(self, repo_id, parent_entry_id, file_name, **kwargs):  # noqa: E501
        """import_document  # noqa: E501

        - Creates a new document in the specified folder. - Optionally sets metadata and electronic document component. - Optional parameter: autoRename (default false). If an entry already exists with the given name, the entry will be automatically renamed. With this route, partial success is possible. The response returns multiple operation (entryCreate operation, setEdoc operation, setLinks operation, etc..) objects, which contain information about any errors that may have occurred during the creation. As long as the entryCreate operation succeeds, the entry will be created, even if all other operations fail.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_document(repo_id, parent_entry_id, file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository ID. (required)
        :param int parent_entry_id: The entry ID of the folder that the document will be created in. (required)
        :param str file_name: The created document's file name. (required)
        :param str electronic_document:
        :param PostEntryWithEdocMetadataRequest request:
        :param bool auto_rename: An optional query parameter used to indicate if the new document should be automatically             renamed if an entry already exists with the given name in the folder. The default value is false.
        :return: CreateEntryResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.import_document_with_http_info(repo_id, parent_entry_id, file_name, **kwargs)  # noqa: E501
        else:
            (data) = self.import_document_with_http_info(repo_id, parent_entry_id, file_name, **kwargs)  # noqa: E501
            return data

    def import_document_with_http_info(self, repo_id, parent_entry_id, file_name, **kwargs):  # noqa: E501
        """import_document  # noqa: E501

        - Creates a new document in the specified folder. - Optionally sets metadata and electronic document component. - Optional parameter: autoRename (default false). If an entry already exists with the given name, the entry will be automatically renamed. With this route, partial success is possible. The response returns multiple operation (entryCreate operation, setEdoc operation, setLinks operation, etc..) objects, which contain information about any errors that may have occurred during the creation. As long as the entryCreate operation succeeds, the entry will be created, even if all other operations fail.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_document_with_http_info(repo_id, parent_entry_id, file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository ID. (required)
        :param int parent_entry_id: The entry ID of the folder that the document will be created in. (required)
        :param str file_name: The created document's file name. (required)
        :param str electronic_document:
        :param PostEntryWithEdocMetadataRequest request:
        :param bool auto_rename: An optional query parameter used to indicate if the new document should be automatically             renamed if an entry already exists with the given name in the folder. The default value is false.
        :return: CreateEntryResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repo_id', 'parent_entry_id', 'file_name', 'electronic_document', 'request', 'auto_rename']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_document" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params or
                params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `import_document`")  # noqa: E501
        # verify the required parameter 'parent_entry_id' is set
        if ('parent_entry_id' not in params or
                params['parent_entry_id'] is None):
            raise ValueError("Missing the required parameter `parent_entry_id` when calling `import_document`")  # noqa: E501
        # verify the required parameter 'file_name' is set
        if ('file_name' not in params or
                params['file_name'] is None):
            raise ValueError("Missing the required parameter `file_name` when calling `import_document`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo_id' in params:
            path_params['repoId'] = params['repo_id']  # noqa: E501
        if 'parent_entry_id' in params:
            path_params['parentEntryId'] = params['parent_entry_id']  # noqa: E501
        if 'file_name' in params:
            path_params['fileName'] = params['file_name']  # noqa: E501

        query_params = []
        if 'auto_rename' in params:
            query_params.append(('autoRename', params['auto_rename']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'electronic_document' in params:
            local_var_files['electronicDocument'] = params['electronic_document']  # noqa: E501
        if 'request' in params:
            form_params.append(('request', params['request']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v1-alpha/Repositories/{repoId}/Entries/{parentEntryId}/{fileName}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateEntryResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def move_or_rename_document(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """move_or_rename_document  # noqa: E501

        - Moves and/or renames an entry. - Move and/or rename an entry by passing in the new parent folder ID or name in the JSON body. - Optional parameter: autoRename (default false). If an entry already exists with the given name, the entry will be automatically renamed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.move_or_rename_document(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :param PatchEntryRequest body: The request containing the folder ID that the entry will be moved to and the new name
            the entry will be renamed to.
        :param bool auto_rename: An optional query parameter used to indicate if the entry should be automatically             renamed if another entry already exists with the same name in the folder. The default value is false.
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.move_or_rename_document_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.move_or_rename_document_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
            return data

    def move_or_rename_document_with_http_info(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """move_or_rename_document  # noqa: E501

        - Moves and/or renames an entry. - Move and/or rename an entry by passing in the new parent folder ID or name in the JSON body. - Optional parameter: autoRename (default false). If an entry already exists with the given name, the entry will be automatically renamed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.move_or_rename_document_with_http_info(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository ID. (required)
        :param int entry_id: The requested entry ID. (required)
        :param PatchEntryRequest body: The request containing the folder ID that the entry will be moved to and the new name
            the entry will be renamed to.
        :param bool auto_rename: An optional query parameter used to indicate if the entry should be automatically             renamed if another entry already exists with the same name in the folder. The default value is false.
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repo_id', 'entry_id', 'body', 'auto_rename']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method move_or_rename_document" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params or
                params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `move_or_rename_document`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `move_or_rename_document`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo_id' in params:
            path_params['repoId'] = params['repo_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []
        if 'auto_rename' in params:
            query_params.append(('autoRename', params['auto_rename']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v1-alpha/Repositories/{repoId}/Entries/{entryId}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Entry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def write_template_value_to_entry(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """write_template_value_to_entry  # noqa: E501

        - Assign a template to an entry. - Provide an entry id, template name, and a list of template fields to assign to that entry. - Only template values will be modified. Any existing independent fields on the entry will not be modified, nor will they be added if included in the request. The only modification to fields will only occur on templated fields. If the previously assigned template includes common template fields as the newly assigned template, the common field values will not be modified.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.write_template_value_to_entry(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository id. (required)
        :param int entry_id: The id of entry that will have its template updated. (required)
        :param PutTemplateRequest body: The template and template fields that will be assigned to the entry.
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.write_template_value_to_entry_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.write_template_value_to_entry_with_http_info(repo_id, entry_id, **kwargs)  # noqa: E501
            return data

    def write_template_value_to_entry_with_http_info(self, repo_id, entry_id, **kwargs):  # noqa: E501
        """write_template_value_to_entry  # noqa: E501

        - Assign a template to an entry. - Provide an entry id, template name, and a list of template fields to assign to that entry. - Only template values will be modified. Any existing independent fields on the entry will not be modified, nor will they be added if included in the request. The only modification to fields will only occur on templated fields. If the previously assigned template includes common template fields as the newly assigned template, the common field values will not be modified.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.write_template_value_to_entry_with_http_info(repo_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: The requested repository id. (required)
        :param int entry_id: The id of entry that will have its template updated. (required)
        :param PutTemplateRequest body: The template and template fields that will be assigned to the entry.
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repo_id', 'entry_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method write_template_value_to_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params or
                params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `write_template_value_to_entry`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if ('entry_id' not in params or
                params['entry_id'] is None):
            raise ValueError("Missing the required parameter `entry_id` when calling `write_template_value_to_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo_id' in params:
            path_params['repoId'] = params['repo_id']  # noqa: E501
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v1-alpha/Repositories/{repoId}/Entries/{entryId}/template', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Entry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
