# coding: utf-8

"""
    Match Predicting Application Public API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, conlist
from match_predicting_pub_api.models.training_network_dto import TrainingNetworkDTO

class TrainingRequestDTO(BaseModel):
    """
    TrainingRequestDTO
    """
    competition_ids: Optional[conlist(StrictInt)] = Field(default=None, alias="competitionIds")
    seasons: Optional[conlist(StrictInt)] = None
    number_of_epochs: Optional[StrictInt] = Field(default=None, alias="numberOfEpochs")
    learning_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="learningRate")
    training_network: Optional[TrainingNetworkDTO] = Field(default=None, alias="trainingNetwork")
    __properties = ["competitionIds", "seasons", "numberOfEpochs", "learningRate", "trainingNetwork"]

    class Config:
        """Pydantic configuration"""
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TrainingRequestDTO:
        """Create an instance of TrainingRequestDTO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of training_network
        if self.training_network:
            _dict['trainingNetwork'] = self.training_network.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TrainingRequestDTO:
        """Create an instance of TrainingRequestDTO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TrainingRequestDTO.parse_obj(obj)

        _obj = TrainingRequestDTO.parse_obj({
            "competition_ids": obj.get("competitionIds"),
            "seasons": obj.get("seasons"),
            "number_of_epochs": obj.get("numberOfEpochs"),
            "learning_rate": obj.get("learningRate"),
            "training_network": TrainingNetworkDTO.from_dict(obj.get("trainingNetwork")) if obj.get("trainingNetwork") is not None else None
        })
        return _obj


