Freenom-dns Script v2.x
=======================
An unofficial python implementation for managing freenom.com dns records.

## Freenom
Freenom is the world's first and only free domain provider.
## Install
```
pip install freenom-dns
```
## How to use
### Instantiate an object
```python
from freenom_dns import Freenom

your_username = 'your username'
your_password = 'your password'
your_domain = 'your domain'
freenom = Freenom(your_username, your_password)
```
### Show All Domains
```python
freenom.show_domains()
```
### Show All Records
```python
freenom.show_records(your_domain)
```
### Add One Record
```python
# add '' record name with public ip
freenom.add_record(your_domain)
# add 'www' record name with public ip
freenom.add_record(your_domain, 'www')
freenom.add_record(your_domain, 'www', '192.168.1.1')
freenom.add_record(your_domain, '_dnsauth', type='txt', ttl='3000', target='33333333')
```
### Modify One Record (if the record exists then modify)
```python
# modify '' record name with public ip
freenom.modify_record(your_domain)
# modify 'www' record name with public ip
freenom.modify_record(your_domain, 'www')
freenom.modify_record(your_domain, 'www', '192.168.2.2')
freenom.modify_record(your_domain, '_dnsauth', ttl='2800', target='88888888')
```
### Set One Record (Add or Modify)
```python
freenom.set_record(your_domain, 'my')
freenom.set_record(your_domain, 'my', '0.0.0.0')
```
### Set Record List (Beta)
```python
"""
record_list:
{name}: *required!!!
{type}: default: A
{ttl}: default: 3600
{target}: default: your Public IP
"""
record_list = [
    {'name': ''},
    {'name': 'www', 'target': '100.100.100.100'},
    {'name': '_dnsauth', 'type': 'txt', 'ttl': '2800', 'target': '22222222'}]
freenom.set_record_list(your_domain, record_list)
```
### Delete One Record
```python
freenom.del_record(your_domain, 'www')
```
### Clear All Record (Beta)
```python
freenom.clear_record(your_domain)
```

## License
[MIT](https://github.com/PunkLee2py/freenom-dns/blob/master/LICENSE)