# Generated by Django 3.2.9 on 2021-11-15 17:06

import _socket
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_revision.revision_field
import edc_sites.models
import edc_utils.date
import simple_history.models
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ("sites", "0002_alter_domain_unique"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("edc_qol", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="Sf12",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50, unique=True)),
                (
                    "general_health",
                    models.CharField(
                        choices=[
                            ("excellent", "Excellent"),
                            ("very_good", "Very good"),
                            ("good", "Good"),
                            ("fair", "Fair"),
                            ("poor", "Poor"),
                        ],
                        max_length=15,
                        verbose_name="In general, would you say your health is:",
                    ),
                ),
                (
                    "moderate_activities_now_limited",
                    models.CharField(
                        choices=[
                            ("limited_a_lot", "YES, limited a lot"),
                            ("limited_a_little", "YES, limited a little"),
                            ("not_limited_at_all", "NO, not at all limited"),
                        ],
                        max_length=20,
                        verbose_name="<u>Moderate activities</u> such as moving a table, pushing a vacuum cleaner, bowling, or playing golf:",
                    ),
                ),
                (
                    "climbing_stairs_now_limited",
                    models.CharField(
                        choices=[
                            ("limited_a_lot", "YES, limited a lot"),
                            ("limited_a_little", "YES, limited a little"),
                            ("not_limited_at_all", "NO, not at all limited"),
                        ],
                        max_length=20,
                        verbose_name="Climbing <u>several</u> flights of stairs:",
                    ),
                ),
                (
                    "accomplished_less_physical_health",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="<u>Accomplished less</u> than you would like:",
                    ),
                ),
                (
                    "work_limited_physical_health",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Were limited in the <u>kind</u> of work or other activities:",
                    ),
                ),
                (
                    "accomplished_less_emotional",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="<u>Accomplished less</u> than you would like:",
                    ),
                ),
                (
                    "work_less_carefully_emotional",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did work or activities <u>less carefully than usual</u>:",
                    ),
                ),
                (
                    "pain_interfere_work",
                    models.CharField(
                        choices=[
                            ("not_at_all", "Not at all"),
                            ("a_little_bit", "A little bit"),
                            ("moderately", "Moderately"),
                            ("quite_a-bit", "Quite a bit"),
                            ("extremely", "Extremely"),
                        ],
                        max_length=15,
                        verbose_name="During the <u>past 4 weeks</u>, how much <u>did pain interfere</u> with your normal work (including work outside the home and housework)?",
                    ),
                ),
                (
                    "felt_calm_peaceful",
                    models.CharField(
                        choices=[
                            ("all_of_the_time", "All of the time"),
                            ("most_of_the_time", "Most of the time"),
                            ("good_bit_of_the_time", " A good bit of the time"),
                            ("some_of_the_time", "Some of the time"),
                            ("little_of_the_time", "A little of the time"),
                            ("none_of_the_time", "None of the time"),
                        ],
                        max_length=25,
                        verbose_name="Have you felt calm & peaceful?",
                    ),
                ),
                (
                    "felt_lot_energy",
                    models.CharField(
                        choices=[
                            ("all_of_the_time", "All of the time"),
                            ("most_of_the_time", "Most of the time"),
                            ("good_bit_of_the_time", " A good bit of the time"),
                            ("some_of_the_time", "Some of the time"),
                            ("little_of_the_time", "A little of the time"),
                            ("none_of_the_time", "None of the time"),
                        ],
                        max_length=25,
                        verbose_name="Did you have a lot of energy?",
                    ),
                ),
                (
                    "felt_down",
                    models.CharField(
                        choices=[
                            ("all_of_the_time", "All of the time"),
                            ("most_of_the_time", "Most of the time"),
                            ("good_bit_of_the_time", " A good bit of the time"),
                            ("some_of_the_time", "Some of the time"),
                            ("little_of_the_time", "A little of the time"),
                            ("none_of_the_time", "None of the time"),
                        ],
                        max_length=25,
                        verbose_name="Have you felt down-hearted and blue?",
                    ),
                ),
                (
                    "social_activities_interfered",
                    models.CharField(
                        choices=[
                            ("all_of_the_time", "All of the time"),
                            ("most_of_the_time", "Most of the time"),
                            ("some_of_the_time", "Some of the time"),
                            ("little_of_the_time", "A little of the time"),
                            ("none_of_the_time", "None of the time"),
                        ],
                        max_length=25,
                        verbose_name="During the <u>past 4 weeks</u>, how much of the time has your physical health or emotional problems interfered with your social activities (like visiting friends, relatives, etc.)?",
                    ),
                ),
                ("report_datetime", models.DateTimeField(default=edc_utils.date.get_utcnow)),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "SF-12 Health Survey",
                "verbose_name_plural": "SF-12 Health Survey",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", edc_sites.models.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name="HistoricalSf12",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("subject_identifier", models.CharField(db_index=True, max_length=50)),
                (
                    "general_health",
                    models.CharField(
                        choices=[
                            ("excellent", "Excellent"),
                            ("very_good", "Very good"),
                            ("good", "Good"),
                            ("fair", "Fair"),
                            ("poor", "Poor"),
                        ],
                        max_length=15,
                        verbose_name="In general, would you say your health is:",
                    ),
                ),
                (
                    "moderate_activities_now_limited",
                    models.CharField(
                        choices=[
                            ("limited_a_lot", "YES, limited a lot"),
                            ("limited_a_little", "YES, limited a little"),
                            ("not_limited_at_all", "NO, not at all limited"),
                        ],
                        max_length=20,
                        verbose_name="<u>Moderate activities</u> such as moving a table, pushing a vacuum cleaner, bowling, or playing golf:",
                    ),
                ),
                (
                    "climbing_stairs_now_limited",
                    models.CharField(
                        choices=[
                            ("limited_a_lot", "YES, limited a lot"),
                            ("limited_a_little", "YES, limited a little"),
                            ("not_limited_at_all", "NO, not at all limited"),
                        ],
                        max_length=20,
                        verbose_name="Climbing <u>several</u> flights of stairs:",
                    ),
                ),
                (
                    "accomplished_less_physical_health",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="<u>Accomplished less</u> than you would like:",
                    ),
                ),
                (
                    "work_limited_physical_health",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Were limited in the <u>kind</u> of work or other activities:",
                    ),
                ),
                (
                    "accomplished_less_emotional",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="<u>Accomplished less</u> than you would like:",
                    ),
                ),
                (
                    "work_less_carefully_emotional",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did work or activities <u>less carefully than usual</u>:",
                    ),
                ),
                (
                    "pain_interfere_work",
                    models.CharField(
                        choices=[
                            ("not_at_all", "Not at all"),
                            ("a_little_bit", "A little bit"),
                            ("moderately", "Moderately"),
                            ("quite_a-bit", "Quite a bit"),
                            ("extremely", "Extremely"),
                        ],
                        max_length=15,
                        verbose_name="During the <u>past 4 weeks</u>, how much <u>did pain interfere</u> with your normal work (including work outside the home and housework)?",
                    ),
                ),
                (
                    "felt_calm_peaceful",
                    models.CharField(
                        choices=[
                            ("all_of_the_time", "All of the time"),
                            ("most_of_the_time", "Most of the time"),
                            ("good_bit_of_the_time", " A good bit of the time"),
                            ("some_of_the_time", "Some of the time"),
                            ("little_of_the_time", "A little of the time"),
                            ("none_of_the_time", "None of the time"),
                        ],
                        max_length=25,
                        verbose_name="Have you felt calm & peaceful?",
                    ),
                ),
                (
                    "felt_lot_energy",
                    models.CharField(
                        choices=[
                            ("all_of_the_time", "All of the time"),
                            ("most_of_the_time", "Most of the time"),
                            ("good_bit_of_the_time", " A good bit of the time"),
                            ("some_of_the_time", "Some of the time"),
                            ("little_of_the_time", "A little of the time"),
                            ("none_of_the_time", "None of the time"),
                        ],
                        max_length=25,
                        verbose_name="Did you have a lot of energy?",
                    ),
                ),
                (
                    "felt_down",
                    models.CharField(
                        choices=[
                            ("all_of_the_time", "All of the time"),
                            ("most_of_the_time", "Most of the time"),
                            ("good_bit_of_the_time", " A good bit of the time"),
                            ("some_of_the_time", "Some of the time"),
                            ("little_of_the_time", "A little of the time"),
                            ("none_of_the_time", "None of the time"),
                        ],
                        max_length=25,
                        verbose_name="Have you felt down-hearted and blue?",
                    ),
                ),
                (
                    "social_activities_interfered",
                    models.CharField(
                        choices=[
                            ("all_of_the_time", "All of the time"),
                            ("most_of_the_time", "Most of the time"),
                            ("some_of_the_time", "Some of the time"),
                            ("little_of_the_time", "A little of the time"),
                            ("none_of_the_time", "None of the time"),
                        ],
                        max_length=25,
                        verbose_name="During the <u>past 4 weeks</u>, how much of the time has your physical health or emotional problems interfered with your social activities (like visiting friends, relatives, etc.)?",
                    ),
                ),
                ("report_datetime", models.DateTimeField(default=edc_utils.date.get_utcnow)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical SF-12 Health Survey",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
    ]
