"""
**Author:** Thomas M. Boudreaux\n
**Created:** September 2021\n
**Last Modified:** September 2021

Utilities to help with the TOPS query api
"""
import os

TOPS_ELEM_ACCEPT = (
        "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", "Al",
        "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", "Mn",
        "Fe", "Co", "Ni", "Cu", "Zn"
        )

def format_TOPS_string(compList : list) -> str:
    """
    Format the composition list from pasrse_abundance_file into a string in the
    form that the TOPS web form expects for a mass fraction input.

    Parameters
    ----------
        compList : list
            composition list in the form of: [('Element', massFrac,
            numFrac),...]

    Returns
    -------
        TOPS_abundance_string : string
            string in the form of: "massFrac0 Element0 massFrac1 Element1 ..."

    """
    TOPS_abundance_string = ' '.join([
        f"{x[1]:0.10f} {x[0]}"
        for x in compList
        if x[0] in TOPS_ELEM_ACCEPT
                                    ])
    return TOPS_abundance_string

def validate_extant_tables(
        path: str,
        prefix: str
        ) -> bool:
    """
    Check if there is a quiried table from TOPS for every number frac file
    generated by the program passed to call_num_frac.

    Parameters
    ----------
        path   : string
            Path to where the results of the number frac and TOPS query files
            are stored
        prefix : string
            start prefix given to all abundance / number frac files

    Returns
    -------
        validated : bool
            Whether or not all number frac files have a corresponding TOPS
            opacity table
    """
    # files = os.listdir(path)
    # abundanceFiles = list(filter(lambda x: prefix in x, files))
    # opacityTables = list(filter(lambda x: 'OP:' in x, files))
    #
    # # parse the file name in the right way
    # # Its easier to read if this is outside the list comprehension
    # parser = lambda x: f"OP:{x.split('_')[-1].split('.')[0]}"
    #
    # validated = all(map(lambda x: any([parser(x) in y for y in opacityTables]),
    #                     abundanceFiles))
    # return validated
    return True
