import pathlib
from setuptools import setup

# The directory containing this file
HERE = pathlib.Path(__file__).parent

# The text of the README file
README = (HERE / "README.md").read_text()

# This call to setup() does all the work
setup(
    name="keycloak-basic",
    version="1.0.0",
    description="Keycloak Authenticator",
    long_description=README,
    long_description_content_type="text/markdown",
    url="https://github.com/iTecAI/Keycloak-Basic",
    author="Dax Harris",
    license="MIT",
    classifiers=[
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.10",
    ],
    packages=["keycloak"],
    include_package_data=True,
    install_requires=["requests"],
)
