/*
 * Decompiled with CFR 0.152.
 */
package AnaDroidAnalyzer.Results;

import AnaDroidAnalyzer.Results.Metrics.IGreenSourceFormat;
import AnaDroidAnalyzer.Results.Metrics.Metric;
import AnaDroidAnalyzer.Results.Metrics.NominalImmutableMetric;
import AnaDroidAnalyzer.Results.Metrics.NominalMutableMetric;
import AnaDroidAnalyzer.Results.Metrics.NumericImmutableMetric;
import AnaDroidAnalyzer.Results.Metrics.NumericMutableMetric;
import AnaDroidAnalyzer.Results.Metrics.TrepnCSVMetric;
import AnaDroidAnalyzer.Utils.Pair;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.json.simple.JSONObject;

public class TrepnResults {
    public int time = 0;
    public double totalEnergyConsumption = 0.0;
    public int startTime = -1;
    public int stopTime = -1;

    public boolean hasStartTime() {
        return this.startTime != -1;
    }

    public boolean hasEndTime() {
        return this.stopTime != -1;
    }

    public static Double getClosestPower(Map<Integer, Number> timeConsumption, int time) {
        int closestStart = 1000000;
        int closestStop = 1000000;
        int difStart = 1000000;
        int diffEnd = 1000000;
        boolean alternativeEnd = false;
        int alternativeStart = 0;
        for (Number number : timeConsumption.keySet()) {
            Integer i2 = number.intValue();
            if (Math.abs(time - i2) >= difStart) continue;
            difStart = Math.abs(time - i2);
            alternativeStart = closestStart;
            closestStart = i2;
        }
        return timeConsumption.get(closestStart).doubleValue();
    }

    private double getClosestTimeAfter(double time, TreeMap<Integer, Number> samples) {
        return samples.keySet().stream().filter(x -> (double)x.intValue() >= time).sorted().findFirst().get().intValue();
    }

    private double getClosestTimeBefore(double time, TreeMap<Integer, Number> samples) {
        return samples.keySet().stream().filter(x -> (double)x.intValue() <= time).sorted(Comparator.reverseOrder()).findFirst().get().intValue();
    }

    private static double interpolate(double y0, double y1, double x, double x0, double x1) {
        return y0 + (x - x0) / (x1 - x0) * (y1 - y0);
    }

    public double getTotalConsumptionInterpolated(TreeMap<Integer, Number> powerSamples, TreeMap<Integer, Number> stateSamples) {
        double sum_energy_consumed = 0.0;
        double last_non_zero_power_registered = 0.0;
        long zeroPowerCount = powerSamples.values().stream().filter(x -> x.intValue() == 0).count();
        System.out.println("Total of 0's in power samples -> " + zeroPowerCount + ". Percentage: " + (double)zeroPowerCount / (double)powerSamples.size() * 100.0 + " %");
        SortedMap<Integer, Number> desiredStateSamples = stateSamples.subMap(this.startTime, this.stopTime);
        double lastInterpolatedValue = 0.0;
        double interpolatedPowerValue = 0.0;
        Optional lastTime = desiredStateSamples.keySet().stream().findFirst();
        int lastTimeValue = lastTime.isPresent() ? (Integer)lastTime.get() : 0;
        for (Integer key : desiredStateSamples.keySet()) {
            Double x0 = this.getClosestTimeBefore(key.intValue(), powerSamples);
            Double x1 = this.getClosestTimeAfter(key.intValue(), powerSamples);
            if (Double.compare(x0, x1) == 0) {
                interpolatedPowerValue = powerSamples.get(x0.intValue()).doubleValue() / 1000000.0;
            } else {
                double y0 = powerSamples.get(x0.intValue()).doubleValue();
                double y1 = powerSamples.get(x1.intValue()).doubleValue();
                if (y0 <= 0.0) {
                    y0 = last_non_zero_power_registered;
                } else if (y0 > last_non_zero_power_registered) {
                    last_non_zero_power_registered = y0;
                }
                if (y1 <= 0.0) {
                    y1 = last_non_zero_power_registered;
                } else if (y1 > last_non_zero_power_registered) {
                    last_non_zero_power_registered = y1;
                }
                interpolatedPowerValue = TrepnResults.interpolate(y0, y1, key.intValue(), x0, x1) / 1000000.0;
            }
            double avgInterp = (lastInterpolatedValue + interpolatedPowerValue) / 2.0;
            double elapsed_time_seconds = (double)(key - lastTimeValue) / 1000.0;
            sum_energy_consumed += avgInterp * elapsed_time_seconds;
            lastInterpolatedValue = interpolatedPowerValue;
            lastTimeValue = key;
        }
        this.time = this.stopTime - this.startTime;
        this.totalEnergyConsumption = sum_energy_consumed;
        return sum_energy_consumed;
    }

    public boolean bluetoothUsed(Map<Integer, Number> bluetoothStateSamples) {
        for (Number i2 : bluetoothStateSamples.values()) {
            if (i2.intValue() <= 0) continue;
            return true;
        }
        return false;
    }

    public double getAvgRSSILevel(Map<Integer, Number> rSSILevelSamples) {
        int total = 0;
        for (Number mem : rSSILevelSamples.values()) {
            total += mem.intValue();
        }
        return (double)total / (double)rSSILevelSamples.size();
    }

    public double getAvgGPULoad(Map<Integer, Number> gpuLoadSamples) {
        int total = 0;
        for (Number mem : gpuLoadSamples.values()) {
            total += mem.intValue();
        }
        return (double)total / (double)gpuLoadSamples.size();
    }

    public Pair<Double, Double> getAvgAndTopPower(Map<Integer, Number> powerSamples) {
        double total = 0.0;
        double top = 0.0;
        for (Number pow : powerSamples.values()) {
            total += pow.doubleValue();
            top = top > pow.doubleValue() ? top : pow.doubleValue();
        }
        return new Pair<Double, Double>(total / (double)powerSamples.size(), top);
    }

    public Pair<Integer, Integer> getBottomAndTopScreenBrigthness(Map<Integer, Number> screenBrigthtnessSamples) {
        int bottom = 0;
        int top = 0;
        for (Number me : screenBrigthtnessSamples.values()) {
            Integer mem = me.intValue();
            bottom = mem < bottom ? mem : bottom;
            top = top > mem ? top : mem;
        }
        return new Pair<Integer, Integer>(bottom, top);
    }

    public Pair<Double, Double> getAvgAndTopCPULoad(Map<Integer, Number> cpuLoadSamples) {
        double total = 0.0;
        double top = 0.0;
        int samples = cpuLoadSamples.size();
        for (Number m : cpuLoadSamples.values()) {
            total += m.doubleValue();
            top = top > m.doubleValue() ? top : m.doubleValue();
        }
        return new Pair<Double, Double>(total / (double)samples, top);
    }

    public Pair<Double, Double> getAvgAndTopCPUFreq(Map<Integer, Number> cpuFrequencySamples) {
        double total = 0.0;
        double top = 0.0;
        int samples = cpuFrequencySamples.size();
        for (Number m : cpuFrequencySamples.values()) {
            total += m.doubleValue();
            top = top > m.doubleValue() ? top : m.doubleValue();
        }
        return new Pair<Double, Double>(total / (double)samples, top);
    }

    public Pair<Double, Double> getAvgAndTopGPUFreq(Map<Integer, Number> gpuFrequencySamples) {
        double total = 0.0;
        double top = 0.0;
        for (Number valu : gpuFrequencySamples.values()) {
            Double value = valu.doubleValue();
            total += value.doubleValue();
            top = top > value ? top : value;
        }
        return new Pair<Double, Double>(total / (double)gpuFrequencySamples.size(), top);
    }

    public boolean wifiUsed(Map<Integer, Number> wifiStateSamples) {
        for (Number i2 : wifiStateSamples.values()) {
            if (i2.intValue() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean mobileDataUsed(Map<Integer, Number> mobileDataStateSamples) {
        for (Number i2 : mobileDataStateSamples.values()) {
            if (i2.intValue() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean batteryCharging(Map<Integer, Number> batteryStatusSamples) {
        for (Number i2 : batteryStatusSamples.values()) {
            if (i2.intValue() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean gpsUsed(Map<Integer, Number> gpsSamples) {
        for (Number i2 : gpsSamples.values()) {
            if (i2.intValue() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean screenUsed(Map<Integer, Number> screenStateSamples) {
        for (Number i2 : screenStateSamples.values()) {
            if (i2.intValue() <= 0) continue;
            return true;
        }
        return false;
    }

    private String trimMetricID(String metricID) {
        if (metricID.toLowerCase().contains("normalized")) {
            return metricID.replaceAll("\\s", "").replaceAll("\\[.*\\]", "").replace("(", "").replace(")", "");
        }
        if (metricID.toLowerCase().contains("delta")) {
            return metricID.replaceAll("\\s", "").replaceAll("\\[.*\\]", "").replace("(", "").replace(")", "").replace("*", "");
        }
        return metricID.replaceAll("\\s", "").replaceAll("\\(.*\\)", "").replaceAll("\\[.*\\]", "").replace("*", "").replace("-", "");
    }

    public Set<IGreenSourceFormat> getAllGSMetrics(double totalcoverage, Set<TrepnCSVMetric> metricSet, JSONObject begin_state, JSONObject end_state) {
        HashSet<IGreenSourceFormat> set = new HashSet<IGreenSourceFormat>();
        for (TrepnCSVMetric tcm : metricSet) {
            Metric.TestMetricCategory testMetricCategory = Metric.TestMetricCategory.inferMetricCategoryCode(tcm.metricId);
            if (Metric.TestMetricCategory.getMetricType(testMetricCategory) instanceof NumericMutableMetric) {
                set.add(new NumericMutableMetric(this.trimMetricID(tcm.metricId), tcm.metricUnit, tcm.getSamplesMap().subMap(this.startTime, this.stopTime)));
                continue;
            }
            if (!(Metric.TestMetricCategory.getMetricType(testMetricCategory) instanceof NominalMutableMetric)) continue;
            set.add(new NominalMutableMetric(this.trimMetricID(tcm.metricId), tcm.metricUnit));
        }
        set.add(new NumericImmutableMetric("coverage", "%", totalcoverage));
        set.add(new NumericImmutableMetric("elapsedtime", "ms", this.time));
        set.add(new NumericImmutableMetric("energyconsumed", "J", this.totalEnergyConsumption));
        set.addAll(this.getMetricsFromDeviceResourcesState(begin_state, false));
        set.addAll(this.getMetricsFromDeviceResourcesState(end_state, true));
        return set;
    }

    private Collection<? extends IGreenSourceFormat> getMetricsFromDeviceResourcesState(JSONObject state, boolean isEnd) {
        HashSet<NominalImmutableMetric> set = new HashSet<NominalImmutableMetric>();
        if (isEnd) {
            set.add(new NominalImmutableMetric("end_used_cpu", "%", state.get("used_cpu").toString()));
            set.add(new NominalImmutableMetric("end_used_mem_pss", "KB", state.get("used_mem_pss").toString()));
            set.add(new NominalImmutableMetric("end_used_mem_kernel", "KB", state.get("used_mem_kernel").toString()));
            set.add(new NominalImmutableMetric("end_nr_procceses", "", state.get("nr_processes").toString()));
            set.add(new NominalImmutableMetric("end_ischarging", "b", state.get("ischarging").toString()));
            set.add(new NominalImmutableMetric("end_battery_level", "%", state.get("battery_level").toString()));
            set.add(new NominalImmutableMetric("end_battery_temperature", "dC", state.get("battery_temperature").toString()));
            set.add(new NominalImmutableMetric("end_battery_voltage", "kV", state.get("battery_voltage").toString()));
            set.add(new NominalImmutableMetric("end_keyboard", "b", state.get("keyboard").toString()));
            if (state.containsKey("nr_files_keyboard_folder")) {
                set.add(new NominalImmutableMetric("end_nr_files_keyboard_folder", "int", state.get("nr_files_keyboard_folder").toString()));
            }
            if (state.containsKey("main_cpu_freq")) {
                set.add(new NominalImmutableMetric("end_main_cpu_freq", "mHz", state.get("main_cpu_freq").toString()));
            }
        } else {
            set.add(new NominalImmutableMetric("begin_used_cpu", "%", state.get("used_cpu").toString()));
            set.add(new NominalImmutableMetric("begin_used_mem_pss", "kB", state.get("used_mem_pss").toString()));
            set.add(new NominalImmutableMetric("begin_used_mem_kernel", "kB", state.get("used_mem_kernel").toString()));
            set.add(new NominalImmutableMetric("begin_nr_procceses", "", state.get("nr_processes").toString()));
            set.add(new NominalImmutableMetric("begin_ischarging", "b", state.get("ischarging").toString()));
            set.add(new NominalImmutableMetric("begin_battery_level", "%", state.get("battery_level").toString()));
            set.add(new NominalImmutableMetric("begin_battery_temperature", "dC", state.get("battery_temperature").toString()));
            set.add(new NominalImmutableMetric("begin_battery_voltage", "KV", state.get("battery_voltage").toString()));
            set.add(new NominalImmutableMetric("begin_keyboard", "", state.get("keyboard").toString()));
            if (state.containsKey("nr_files_keyboard_folder")) {
                set.add(new NominalImmutableMetric("begin_nr_files_keyboard_folder", "int", state.get("nr_files_keyboard_folder").toString()));
            }
            if (state.containsKey("main_cpu_freq")) {
                set.add(new NominalImmutableMetric("begin_main_cpu_freq", "mHz", state.get("main_cpu_freq").toString()));
            }
        }
        return set;
    }
}

