/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.diagnostics;

import java.util.Collection;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.AtomicNotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentMultiMap;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

public class DiagnosticsElementsCache {
    private final Diagnostics diagnostics;
    private final Function1<Diagnostic, Boolean> filter;
    private final AtomicNotNullLazyValue<MultiMap<PsiElement, Diagnostic>> elementToDiagnostic = new AtomicNotNullLazyValue<MultiMap<PsiElement, Diagnostic>>(){

        @Override
        @NotNull
        protected MultiMap<PsiElement, Diagnostic> compute() {
            return DiagnosticsElementsCache.buildElementToDiagnosticCache(DiagnosticsElementsCache.this.diagnostics, DiagnosticsElementsCache.this.filter);
        }
    };

    public DiagnosticsElementsCache(Diagnostics diagnostics2, Function1<Diagnostic, Boolean> filter2) {
        this.diagnostics = diagnostics2;
        this.filter = filter2;
    }

    @NotNull
    public Collection<Diagnostic> getDiagnostics(@NotNull PsiElement psiElement) {
        return this.elementToDiagnostic.getValue().get(psiElement);
    }

    private static MultiMap<PsiElement, Diagnostic> buildElementToDiagnosticCache(Diagnostics diagnostics2, Function1<Diagnostic, Boolean> filter2) {
        ConcurrentMultiMap<PsiElement, Diagnostic> elementToDiagnostic = new ConcurrentMultiMap<PsiElement, Diagnostic>();
        for (Diagnostic diagnostic : diagnostics2) {
            if (diagnostic == null) {
                throw new IllegalStateException("There shouldn't be null diagnostics in the collection: " + CollectionsKt.toList(diagnostics2));
            }
            if (!filter2.invoke(diagnostic).booleanValue()) continue;
            ((MultiMap)elementToDiagnostic).putValue(diagnostic.getPsiElement(), diagnostic);
        }
        return elementToDiagnostic;
    }
}

