/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.inline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.inline.DescriptorSubstitutorForExternalScope;
import org.jetbrains.kotlin.ir.backend.js.lower.inline.Inliner;
import org.jetbrains.kotlin.ir.backend.js.lower.inline.IrElementTransformerWithContext;
import org.jetbrains.kotlin.ir.backend.js.lower.inline.LegacyDescriptorUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.lower.inline.Ref;
import org.jetbrains.kotlin.ir.backend.js.lower.inline.SubstitutedDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0011\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016R\u0015\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/inline/FunctionInlining;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/inline/IrElementTransformerWithContext;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/inline/Ref;", "", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/inline/Context;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "globalSubstituteMap", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/inline/SubstitutedDescriptor;", "inlineFunctions", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getFunctionDeclaration", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "irCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "inline", "Lorg/jetbrains/kotlin/ir/IrElement;", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "data", "visitFunctionNew", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "backend.js"})
public final class FunctionInlining
extends IrElementTransformerWithContext<Ref<Boolean>> {
    private final Map<DeclarationDescriptor, SubstitutedDescriptor> globalSubstituteMap;
    private final Map<FunctionDescriptor, Boolean> inlineFunctions;
    @NotNull
    private final JsIrBackendContext context;

    @NotNull
    public final IrElement inline(@NotNull IrModuleFragment irModule) {
        Intrinsics.checkParameterIsNotNull(irModule, "irModule");
        IrElement transformedModule = (IrElement)irModule.accept(this, new Ref<Boolean>(false));
        new DescriptorSubstitutorForExternalScope(this.globalSubstituteMap, this.context).run(transformedModule);
        return transformedModule;
    }

    @Override
    @NotNull
    public IrStatement visitFunctionNew(@NotNull IrFunction declaration, @NotNull Ref<Boolean> data2) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(data2, "data");
        FunctionDescriptor descriptor2 = declaration.getDescriptor();
        Boolean bl = this.inlineFunctions.get(descriptor2);
        Ref<Boolean> localData = new Ref<Boolean>(bl != null ? bl : false);
        IrStatement result2 = super.visitFunctionNew(declaration, localData);
        data2.setValue(data2.getValue() | localData.getValue());
        if (LegacyDescriptorUtilsKt.getNeedsInlining(descriptor2)) {
            Map<FunctionDescriptor, Boolean> map2 = this.inlineFunctions;
            Boolean bl2 = localData.getValue();
            map2.put(descriptor2, bl2);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2, @NotNull Ref<Boolean> data2) {
        Collection<IrElement> collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data2, "data");
        Ref<Boolean> argsAreBad = new Ref<Boolean>(false);
        Object object = super.visitCall(expression2, argsAreBad);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
        }
        IrCall callSite = (IrCall)object;
        data2.setValue(data2.getValue() | argsAreBad.getValue());
        FunctionDescriptor functionDescriptor = callSite.getDescriptor();
        if (!LegacyDescriptorUtilsKt.getNeedsInlining(functionDescriptor)) {
            return callSite;
        }
        Pair<IrFunction, Boolean> callee = this.getFunctionDeclaration(callSite);
        if (callee == null) {
            String message = "Inliner failed to obtain function declaration: " + DescriptorUtilsKt.getFqNameSafe(functionDescriptor).toString();
            UtilsKt.reportWarning(this.context, message, this.getCurrentFile(), callSite);
            return callSite;
        }
        data2.setValue(data2.getValue() | callee.getSecond());
        Boolean bl = this.inlineFunctions.get(functionDescriptor);
        Ref<Boolean> childIsBad = new Ref<Boolean>(bl != null ? bl : false);
        callee.getFirst().transformChildren(this, childIsBad);
        Map<FunctionDescriptor, Boolean> map2 = this.inlineFunctions;
        Boolean bl2 = childIsBad.getValue();
        map2.put(functionDescriptor, bl2);
        data2.setValue(data2.getValue() | childIsBad.getValue());
        boolean currentCalleeIsBad = argsAreBad.getValue() | childIsBad.getValue() | callee.getSecond();
        boolean bl3 = !currentCalleeIsBad;
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        if (scopeWithIr == null) {
            Intrinsics.throwNpe();
        }
        Iterable iterable = this.getAllScopes();
        ScopeWithIr scopeWithIr2 = scopeWithIr;
        boolean bl4 = bl3;
        IrFunction irFunction = callee.getFirst();
        IrCall irCall = callSite;
        Map<DeclarationDescriptor, SubstitutedDescriptor> map3 = this.globalSubstituteMap;
        void var11_18 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ScopeWithIr scopeWithIr3 = (ScopeWithIr)item$iv$iv;
            collection = destination$iv$iv;
            IrElement irElement = it.getIrElement();
            collection.add(irElement);
        }
        collection = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)collection;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof IrDeclarationParent)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        collection = (List)destination$iv$iv;
        FunctionInlining functionInlining = this;
        JsIrBackendContext jsIrBackendContext = this.context;
        IrDeclarationParent irDeclarationParent = (IrDeclarationParent)CollectionsKt.lastOrNull(collection);
        ScopeWithIr scopeWithIr4 = scopeWithIr2;
        boolean bl5 = bl4;
        IrFunction irFunction2 = irFunction;
        IrCall irCall2 = irCall;
        Map<DeclarationDescriptor, SubstitutedDescriptor> map4 = map3;
        Inliner inliner = new Inliner(map4, irCall2, irFunction2, bl5, scopeWithIr4, irDeclarationParent, jsIrBackendContext, functionInlining);
        return inliner.inline();
    }

    private final Pair<IrFunction, Boolean> getFunctionDeclaration(IrCall irCall) {
        Pair<IrFunction, Boolean> pair;
        IrFunction functionDeclaration;
        FunctionDescriptor functionDescriptor = irCall.getDescriptor();
        FunctionDescriptor functionDescriptor2 = ((FunctionDescriptor)LegacyDescriptorUtilsKt.resolveFakeOverride((CallableMemberDescriptor)functionDescriptor)).getOriginal();
        Intrinsics.checkExpressionValueIsNotNull(functionDescriptor2, "functionDescriptor.resolveFakeOverride().original");
        FunctionDescriptor originalDescriptor = functionDescriptor2;
        IrFunction irFunction = this.context.getOriginalModuleIndex().getFunctions().get(originalDescriptor);
        if (irFunction == null) {
            irFunction = this.context.getSymbolTable().referenceDeclaredFunction(originalDescriptor).getOwner();
        }
        IrFunction irFunction2 = functionDeclaration = irFunction;
        if (irFunction2 != null) {
            IrFunction irFunction3;
            IrFunction it = irFunction3 = irFunction2;
            pair = TuplesKt.to(it, false);
        } else {
            pair = null;
        }
        return pair;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public FunctionInlining(@NotNull JsIrBackendContext context) {
        Map map2;
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
        FunctionInlining functionInlining = this;
        functionInlining.globalSubstituteMap = map2 = (Map)new LinkedHashMap();
        functionInlining = this;
        functionInlining.inlineFunctions = map2 = (Map)new LinkedHashMap();
    }
}

