/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderEx;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValue;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.ParameterizedCachedValue;
import org.jetbrains.kotlin.com.intellij.psi.util.ParameterizedCachedValueProvider;
import org.jetbrains.kotlin.com.intellij.util.CachedValueBase;
import org.jetbrains.kotlin.com.intellij.util.CachedValueLeakChecker;
import org.jetbrains.kotlin.com.intellij.util.CachedValuesFactory;
import org.jetbrains.kotlin.com.intellij.util.DefaultCachedValuesFactory;

public class CachedValuesManagerImpl
extends CachedValuesManager {
    private final Project myProject;
    private final CachedValuesFactory myFactory;

    public CachedValuesManagerImpl(Project project, CachedValuesFactory factory2) {
        this.myProject = project;
        this.myFactory = factory2 == null ? new DefaultCachedValuesFactory(project) : factory2;
    }

    @Override
    @NotNull
    public <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> provider, boolean trackValue) {
        if (provider == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(0);
        }
        CachedValue<T> cachedValue2 = this.myFactory.createCachedValue(provider, trackValue);
        if (cachedValue2 == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(1);
        }
        return cachedValue2;
    }

    @Override
    @NotNull
    public <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull ParameterizedCachedValueProvider<T, P> provider, boolean trackValue) {
        if (provider == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(2);
        }
        ParameterizedCachedValue<T, P> parameterizedCachedValue = this.myFactory.createParameterizedCachedValue(provider, trackValue);
        if (parameterizedCachedValue == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(3);
        }
        return parameterizedCachedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T, D extends UserDataHolder> T getCachedValue(@NotNull D dataHolder, @NotNull Key<CachedValue<T>> key, @NotNull CachedValueProvider<T> provider, boolean trackValue) {
        CachedValue<T> value;
        if (dataHolder == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(4);
        }
        if (key == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(5);
        }
        if (provider == null) {
            CachedValuesManagerImpl.$$$reportNull$$$0(6);
        }
        if (dataHolder instanceof UserDataHolderEx) {
            UserDataHolderEx dh = (UserDataHolderEx)dataHolder;
            value = dh.getUserData(key);
            while (this.isOutdated(value)) {
                if (dh.replace(key, value, null)) {
                    value = null;
                    break;
                }
                value = dh.getUserData(key);
            }
            if (value == null) {
                CachedValueLeakChecker.checkProvider(provider, key, dataHolder);
                value = this.createCachedValue(provider, trackValue);
                assert (((CachedValueBase)((Object)value)).isFromMyProject(this.myProject));
                value = dh.putUserDataIfAbsent(key, value);
            }
        } else {
            D d = dataHolder;
            synchronized (d) {
                value = dataHolder.getUserData(key);
                if (this.isOutdated(value)) {
                    value = null;
                }
                if (value == null) {
                    CachedValueLeakChecker.checkProvider(provider, key, dataHolder);
                    value = this.createCachedValue(provider, trackValue);
                    dataHolder.putUserData(key, value);
                }
            }
        }
        return value.getValue();
    }

    private boolean isOutdated(CachedValue<?> value) {
        return value instanceof CachedValueBase && (!((CachedValueBase)((Object)value)).isFromMyProject(this.myProject) || CachedValuesManagerImpl.hasOutdatedValue((CachedValueBase)((Object)value)));
    }

    private static boolean hasOutdatedValue(CachedValueBase base) {
        return !base.hasUpToDateValue() && base.getRawData() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/CachedValuesManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/CachedValuesManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCachedValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterizedCachedValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCachedValue";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createParameterizedCachedValue";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCachedValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

